#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
/*
 * ClientMetric.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbclient/GlobalConfig.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/RunTransaction.actor.h"
#include "fdbclient/Tuple.h"
#include "flow/actorcompiler.h" // has to be last include

static const StringRef sampleTrInfoKey =
    "\xff\x02/fdbClientInfo/client_latency/SSSSSSSSSS/RRRRRRRRRRRRRRRR/NNNNTTTT/XXXX/"_sr;
static const auto versionStampIndex = sampleTrInfoKey.toString().find('S');
static const int versionStampLength = 10;

static const Key CLIENT_LATENCY_INFO_PREFIX = "client_latency/"_sr;
static const Key CLIENT_LATENCY_INFO_CTR_PREFIX = "client_latency_counter/"_sr;

struct ClientMetricWorkload : TestWorkload {
	static constexpr auto NAME = "ClientMetric";
	double samplingProbability;
	double testDuration;
	bool toSet;
	int64_t trInfoSizeLimit;
	std::vector<Future<Void>> clients;

	ClientMetricWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		samplingProbability = getOption(options,
		                                "samplingProbability"_sr,
		                                deterministicRandom()->random01()); // rand range 0 - 1
		toSet = getOption(options, "toSet"_sr, false);
		trInfoSizeLimit = getOption(options,
		                            "trInfoSizeLimit"_sr,
		                            deterministicRandom()->randomInt(100 * 1024, 10 * 1024 * 1024)); // 100 KB - 10 MB
		testDuration = getOption(options, "testDuration"_sr, 1000.0);
	}

	static uint64_t getVersionStamp(KeyRef key) {
		return bigEndian64(
		    BinaryReader::fromStringRef<int64_t>(key.substr(versionStampIndex, versionStampLength), Unversioned()));
	}

	Future<Void> setup(Database const& cx) override {
		if (toSet && this->clientId == 0) {
			return changeProfilingParameters(cx, trInfoSizeLimit, samplingProbability);
		}
		return Void();
	}

	Future<Void> start(Database const& cx) override {
		if (this->clientId != 0) {
			return Void();
		}
		return _start(this, cx);
	}

																#line 77 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 75 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
template <class _startActor>
															#line 75 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
class _startActorState {
															#line 83 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
public:
															#line 75 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	_startActorState(ClientMetricWorkload* const& self,Database const& cx) 
															#line 75 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
															#line 75 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		 : self(self),
															#line 75 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   cx(cx)
															#line 92 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 77 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
				self->clients.push_back(timeout(self->runner(cx, self), self->testDuration, Void()));
															#line 78 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(self->clients);
															#line 78 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 112 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 78 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 82 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 80 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			TraceEvent("ClientMetricError::_start").error(e);
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 75 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	ClientMetricWorkload* self;
															#line 75 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	Database cx;
															#line 274 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 75 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 279 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12268011061571689728UL, 2964755513232704512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 75 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	_startActor(ClientMetricWorkload* const& self,Database const& cx) 
															#line 296 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 75 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
[[nodiscard]] Future<Void> _start( ClientMetricWorkload* const& self, Database const& cx ) {
															#line 75 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 328 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
}

#line 84 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"

																#line 333 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
// This generated class is to be used only via changeProfilingParameters()
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
template <class ChangeProfilingParametersActor>
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
class ChangeProfilingParametersActorState {
															#line 339 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
public:
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	ChangeProfilingParametersActorState(Database const& cx,int64_t const& sizeLimit,double const& sampleProbability) 
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		 : cx(cx),
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   sizeLimit(sizeLimit),
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   sampleProbability(sampleProbability)
															#line 350 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
	{
		fdb_probe_actor_create("changeProfilingParameters", reinterpret_cast<unsigned long>(this));

	}
	~ChangeProfilingParametersActorState() 
	{
		fdb_probe_actor_destroy("changeProfilingParameters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 86 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			StrictFuture<Void> __when_expr_0 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { Tuple rate = Tuple::makeTuple(sampleProbability); Tuple size = Tuple::makeTuple(sizeLimit); tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES); tr->set(GlobalConfig::prefixedKey(fdbClientInfoTxnSampleRate), rate.pack()); tr->set(GlobalConfig::prefixedKey(fdbClientInfoTxnSizeLimit), size.pack()); std::cout << "Change globalconfig: sampleRate=" << sampleProbability << " sizeLimit=" << sizeLimit << std::endl; return Void(); });
															#line 86 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			if (static_cast<ChangeProfilingParametersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 367 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeProfilingParametersActor*>(this)->actor_wait_state = 1;
															#line 86 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeProfilingParametersActor, 0, Void >*>(static_cast<ChangeProfilingParametersActor*>(this)));
															#line 372 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeProfilingParametersActorState();
		static_cast<ChangeProfilingParametersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 97 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (!static_cast<ChangeProfilingParametersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeProfilingParametersActorState(); static_cast<ChangeProfilingParametersActor*>(this)->destroy(); return 0; }
															#line 395 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		new (&static_cast<ChangeProfilingParametersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeProfilingParametersActorState();
		static_cast<ChangeProfilingParametersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 97 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (!static_cast<ChangeProfilingParametersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeProfilingParametersActorState(); static_cast<ChangeProfilingParametersActor*>(this)->destroy(); return 0; }
															#line 407 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		new (&static_cast<ChangeProfilingParametersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeProfilingParametersActorState();
		static_cast<ChangeProfilingParametersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeProfilingParametersActor*>(this)->actor_wait_state > 0) static_cast<ChangeProfilingParametersActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeProfilingParametersActor*>(this)->ActorCallback< ChangeProfilingParametersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeProfilingParametersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeProfilingParameters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeProfilingParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeProfilingParameters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeProfilingParametersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeProfilingParameters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeProfilingParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeProfilingParameters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeProfilingParametersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeProfilingParameters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeProfilingParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeProfilingParameters", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	Database cx;
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	int64_t sizeLimit;
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	double sampleProbability;
															#line 496 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
};
// This generated class is to be used only via changeProfilingParameters()
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
class ChangeProfilingParametersActor final : public Actor<Void>, public ActorCallback< ChangeProfilingParametersActor, 0, Void >, public FastAllocated<ChangeProfilingParametersActor>, public ChangeProfilingParametersActorState<ChangeProfilingParametersActor> {
															#line 501 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
public:
	using FastAllocated<ChangeProfilingParametersActor>::operator new;
	using FastAllocated<ChangeProfilingParametersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2221818970871123712UL, 2148367581129172736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeProfilingParametersActor, 0, Void >;
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	ChangeProfilingParametersActor(Database const& cx,int64_t const& sizeLimit,double const& sampleProbability) 
															#line 518 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeProfilingParametersActorState<ChangeProfilingParametersActor>(cx, sizeLimit, sampleProbability),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeProfilingParameters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9786684525058980096UL, 13704156376182779136UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeProfilingParametersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeProfilingParameters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeProfilingParameters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeProfilingParametersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
[[nodiscard]] Future<Void> changeProfilingParameters( Database const& cx, int64_t const& sizeLimit, double const& sampleProbability ) {
															#line 85 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	return Future<Void>(new ChangeProfilingParametersActor(cx, sizeLimit, sampleProbability));
															#line 550 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
}

#line 99 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"

																#line 555 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
// This generated class is to be used only via latencyRangeQuery()
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
template <class LatencyRangeQueryActor>
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
class LatencyRangeQueryActorState {
															#line 561 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
public:
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	LatencyRangeQueryActorState(Database const& cx,int const& keysLimit,bool const& reverse) 
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		 : cx(cx),
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   keysLimit(keysLimit),
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   reverse(reverse),
															#line 101 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   begin(firstGreaterOrEqual(CLIENT_LATENCY_INFO_PREFIX.withPrefix(fdbClientInfoPrefixRange.begin))),
															#line 103 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   end(firstGreaterOrEqual(strinc(begin.getKey()))),
															#line 104 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(cx)),
															#line 105 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   txInfoEntries()
															#line 580 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
	{
		fdb_probe_actor_create("latencyRangeQuery", reinterpret_cast<unsigned long>(this));

	}
	~LatencyRangeQueryActorState() 
	{
		fdb_probe_actor_destroy("latencyRangeQuery", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 107 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(CLIENT_KNOBS->CSI_STATUS_DELAY);
															#line 107 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			if (static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 597 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state = 1;
															#line 107 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LatencyRangeQueryActor, 0, Void >*>(static_cast<LatencyRangeQueryActor*>(this)));
															#line 602 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LatencyRangeQueryActorState();
		static_cast<LatencyRangeQueryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 108 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		;
															#line 625 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 108 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		;
															#line 634 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state > 0) static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state = 0;
		static_cast<LatencyRangeQueryActor*>(this)->ActorCallback< LatencyRangeQueryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LatencyRangeQueryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyRangeQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LatencyRangeQueryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyRangeQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LatencyRangeQueryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyRangeQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 140 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		for( auto& kv : txInfoEntries ) {
															#line 141 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			uint64_t vs = getVersionStamp(kv.key);
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			std::cout << "VersionStamp is " << vs << std::endl;
															#line 722 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		}
															#line 144 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (!static_cast<LatencyRangeQueryActor*>(this)->SAV<RangeResult>::futures) { (void)(txInfoEntries); this->~LatencyRangeQueryActorState(); static_cast<LatencyRangeQueryActor*>(this)->destroy(); return 0; }
															#line 726 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		new (&static_cast<LatencyRangeQueryActor*>(this)->SAV< RangeResult >::value()) RangeResult(std::move(txInfoEntries)); // state_var_RVO
		this->~LatencyRangeQueryActorState();
		static_cast<LatencyRangeQueryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 110 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			tr->reset();
															#line 111 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 112 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 113 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			std::string sampleRateStr = "default";
															#line 114 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			std::string sizeLimitStr = "default";
															#line 115 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			const double sampleRateDbl = cx->globalConfig->get<double>(fdbClientInfoTxnSampleRate, std::numeric_limits<double>::infinity());
															#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			if (!std::isinf(sampleRateDbl))
															#line 758 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			{
															#line 118 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
				sampleRateStr = std::to_string(sampleRateDbl);
															#line 762 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			}
															#line 120 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			const int64_t sizeLimit = cx->globalConfig->get<int64_t>(fdbClientInfoTxnSizeLimit, -1);
															#line 121 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			if (sizeLimit != -1)
															#line 768 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			{
															#line 122 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
				sizeLimitStr = std::to_string(sizeLimit);
															#line 772 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			}
															#line 124 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			std::cout << "Read from globalconfig: rate=" << sampleRateStr << " size=" << sizeLimitStr << std::endl;
															#line 125 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = tr->getRange(begin, end, keysLimit, Snapshot::False, reverse ? Reverse::True : Reverse::False);
															#line 125 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			if (static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 780 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state = 2;
															#line 125 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LatencyRangeQueryActor, 1, RangeResult >*>(static_cast<LatencyRangeQueryActor*>(this)));
															#line 785 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 137 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 137 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			if (static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 822 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state = 4;
															#line 137 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LatencyRangeQueryActor, 3, Void >*>(static_cast<LatencyRangeQueryActor*>(this)));
															#line 827 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 127 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (kvRange.empty())
															#line 842 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		{
															#line 128 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(1.0);
															#line 128 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			if (static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 848 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state = 3;
															#line 128 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LatencyRangeQueryActor, 2, Void >*>(static_cast<LatencyRangeQueryActor*>(this)));
															#line 853 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult const& __kvRange,int loopDepth) 
	{
															#line 125 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		kvRange = __kvRange;
															#line 867 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult && __kvRange,int loopDepth) 
	{
		kvRange = std::move(__kvRange);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state > 0) static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state = 0;
		static_cast<LatencyRangeQueryActor*>(this)->ActorCallback< LatencyRangeQueryActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< LatencyRangeQueryActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyRangeQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LatencyRangeQueryActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyRangeQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LatencyRangeQueryActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyRangeQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont5(int loopDepth) 
	{
															#line 133 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		txInfoEntries.arena().dependsOn(kvRange.arena());
															#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		txInfoEntries.append(txInfoEntries.arena(), kvRange.begin(), kvRange.size());
															#line 948 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		std::cout << "WaitingForLatencyMetricToBePresent" << std::endl;
															#line 130 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		TraceEvent("WaitingForLatencyMetricToBePresent").log();
															#line 959 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		return a_body1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		std::cout << "WaitingForLatencyMetricToBePresent" << std::endl;
															#line 130 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		TraceEvent("WaitingForLatencyMetricToBePresent").log();
															#line 970 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		return a_body1cont1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state > 0) static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state = 0;
		static_cast<LatencyRangeQueryActor*>(this)->ActorCallback< LatencyRangeQueryActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LatencyRangeQueryActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyRangeQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LatencyRangeQueryActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyRangeQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LatencyRangeQueryActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyRangeQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state > 0) static_cast<LatencyRangeQueryActor*>(this)->actor_wait_state = 0;
		static_cast<LatencyRangeQueryActor*>(this)->ActorCallback< LatencyRangeQueryActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LatencyRangeQueryActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyRangeQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LatencyRangeQueryActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyRangeQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LatencyRangeQueryActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyRangeQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyRangeQuery", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	Database cx;
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	int keysLimit;
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	bool reverse;
															#line 101 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	KeySelector begin;
															#line 103 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	KeySelector end;
															#line 104 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 105 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	RangeResult txInfoEntries;
															#line 125 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	RangeResult kvRange;
															#line 1153 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
};
// This generated class is to be used only via latencyRangeQuery()
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
class LatencyRangeQueryActor final : public Actor<RangeResult>, public ActorCallback< LatencyRangeQueryActor, 0, Void >, public ActorCallback< LatencyRangeQueryActor, 1, RangeResult >, public ActorCallback< LatencyRangeQueryActor, 2, Void >, public ActorCallback< LatencyRangeQueryActor, 3, Void >, public FastAllocated<LatencyRangeQueryActor>, public LatencyRangeQueryActorState<LatencyRangeQueryActor> {
															#line 1158 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
public:
	using FastAllocated<LatencyRangeQueryActor>::operator new;
	using FastAllocated<LatencyRangeQueryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5189948797211859712UL, 9528098053384282368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<RangeResult>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LatencyRangeQueryActor, 0, Void >;
friend struct ActorCallback< LatencyRangeQueryActor, 1, RangeResult >;
friend struct ActorCallback< LatencyRangeQueryActor, 2, Void >;
friend struct ActorCallback< LatencyRangeQueryActor, 3, Void >;
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	LatencyRangeQueryActor(Database const& cx,int const& keysLimit,bool const& reverse) 
															#line 1178 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		 : Actor<RangeResult>(),
		   LatencyRangeQueryActorState<LatencyRangeQueryActor>(cx, keysLimit, reverse),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("latencyRangeQuery", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3731804498305057792UL, 1954923718081093120UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyRangeQueryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("latencyRangeQuery");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("latencyRangeQuery", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LatencyRangeQueryActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LatencyRangeQueryActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LatencyRangeQueryActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LatencyRangeQueryActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
[[nodiscard]] Future<RangeResult> latencyRangeQuery( Database const& cx, int const& keysLimit, bool const& reverse ) {
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	return Future<RangeResult>(new LatencyRangeQueryActor(cx, keysLimit, reverse));
															#line 1213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
}

#line 146 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"

																#line 1218 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
// This generated class is to be used only via writeRandomKeys()
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
template <class WriteRandomKeysActor>
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
class WriteRandomKeysActorState {
															#line 1224 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
public:
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	WriteRandomKeysActorState(Database const& cx,int const& total) 
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		 : cx(cx),
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   total(total),
															#line 148 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   cnt(0),
															#line 149 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   tr(cx)
															#line 1237 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
	{
		fdb_probe_actor_create("writeRandomKeys", reinterpret_cast<unsigned long>(this));

	}
	~WriteRandomKeysActorState() 
	{
		fdb_probe_actor_destroy("writeRandomKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 151 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
				;
															#line 1253 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteRandomKeysActorState();
		static_cast<WriteRandomKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 170 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		std::cout << "writeRandomKeys finish, written=" << cnt << std::endl;
															#line 171 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (!static_cast<WriteRandomKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteRandomKeysActorState(); static_cast<WriteRandomKeysActor*>(this)->destroy(); return 0; }
															#line 1284 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		new (&static_cast<WriteRandomKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteRandomKeysActorState();
		static_cast<WriteRandomKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			TraceEvent(SevError, "ClientMetricErrorWhenWriteKeys").error(e);
															#line 168 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1299 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 153 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0.001);
															#line 153 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			if (static_cast<WriteRandomKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1329 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteRandomKeysActor*>(this)->actor_wait_state = 1;
															#line 153 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteRandomKeysActor, 0, Void >*>(static_cast<WriteRandomKeysActor*>(this)));
															#line 1334 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 163 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 163 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			if (static_cast<WriteRandomKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1371 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WriteRandomKeysActor*>(this)->actor_wait_state = 3;
															#line 163 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteRandomKeysActor, 2, Void >*>(static_cast<WriteRandomKeysActor*>(this)));
															#line 1376 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		tr.reset();
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		tr.set(Key(deterministicRandom()->randomAlphaNumeric(10)), Value(Key(deterministicRandom()->randomAlphaNumeric(10))));
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (static_cast<WriteRandomKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1397 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteRandomKeysActor*>(this)->actor_wait_state = 2;
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteRandomKeysActor, 1, Void >*>(static_cast<WriteRandomKeysActor*>(this)));
															#line 1402 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		tr.reset();
															#line 155 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		tr.set(Key(deterministicRandom()->randomAlphaNumeric(10)), Value(Key(deterministicRandom()->randomAlphaNumeric(10))));
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (static_cast<WriteRandomKeysActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1417 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteRandomKeysActor*>(this)->actor_wait_state = 2;
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteRandomKeysActor, 1, Void >*>(static_cast<WriteRandomKeysActor*>(this)));
															#line 1422 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteRandomKeysActor*>(this)->actor_wait_state > 0) static_cast<WriteRandomKeysActor*>(this)->actor_wait_state = 0;
		static_cast<WriteRandomKeysActor*>(this)->ActorCallback< WriteRandomKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteRandomKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeRandomKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteRandomKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeRandomKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteRandomKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeRandomKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteRandomKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeRandomKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteRandomKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeRandomKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteRandomKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeRandomKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (cnt >= total)
															#line 1506 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 161 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		++cnt;
															#line 1512 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 158 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (cnt >= total)
															#line 1521 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 161 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		++cnt;
															#line 1527 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteRandomKeysActor*>(this)->actor_wait_state > 0) static_cast<WriteRandomKeysActor*>(this)->actor_wait_state = 0;
		static_cast<WriteRandomKeysActor*>(this)->ActorCallback< WriteRandomKeysActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteRandomKeysActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeRandomKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteRandomKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeRandomKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteRandomKeysActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeRandomKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteRandomKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeRandomKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteRandomKeysActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeRandomKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteRandomKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeRandomKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteRandomKeysActor*>(this)->actor_wait_state > 0) static_cast<WriteRandomKeysActor*>(this)->actor_wait_state = 0;
		static_cast<WriteRandomKeysActor*>(this)->ActorCallback< WriteRandomKeysActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteRandomKeysActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeRandomKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteRandomKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeRandomKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteRandomKeysActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeRandomKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteRandomKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeRandomKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteRandomKeysActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeRandomKeys", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteRandomKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeRandomKeys", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	Database cx;
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	int total;
															#line 148 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	int cnt;
															#line 149 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	Transaction tr;
															#line 1728 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
};
// This generated class is to be used only via writeRandomKeys()
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
class WriteRandomKeysActor final : public Actor<Void>, public ActorCallback< WriteRandomKeysActor, 0, Void >, public ActorCallback< WriteRandomKeysActor, 1, Void >, public ActorCallback< WriteRandomKeysActor, 2, Void >, public FastAllocated<WriteRandomKeysActor>, public WriteRandomKeysActorState<WriteRandomKeysActor> {
															#line 1733 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
public:
	using FastAllocated<WriteRandomKeysActor>::operator new;
	using FastAllocated<WriteRandomKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11988636691308735488UL, 10630434074611361024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteRandomKeysActor, 0, Void >;
friend struct ActorCallback< WriteRandomKeysActor, 1, Void >;
friend struct ActorCallback< WriteRandomKeysActor, 2, Void >;
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	WriteRandomKeysActor(Database const& cx,int const& total) 
															#line 1752 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		 : Actor<Void>(),
		   WriteRandomKeysActorState<WriteRandomKeysActor>(cx, total),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeRandomKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2716966138349694464UL, 545149060022967040UL);
		ActorExecutionContextHelper __helper(static_cast<WriteRandomKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeRandomKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeRandomKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteRandomKeysActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteRandomKeysActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteRandomKeysActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
[[nodiscard]] Future<Void> writeRandomKeys( Database const& cx, int const& total ) {
															#line 147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	return Future<Void>(new WriteRandomKeysActor(cx, total));
															#line 1786 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
}

#line 173 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"

																#line 1791 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
// This generated class is to be used only via writeKeysAndGetLatencyVersion()
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
template <class WriteKeysAndGetLatencyVersionActor>
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
class WriteKeysAndGetLatencyVersionActorState {
															#line 1797 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
public:
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	WriteKeysAndGetLatencyVersionActorState(Database const& cx,ClientMetricWorkload* const& self,int const& numKeys,uint64_t const& previousVS) 
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		 : cx(cx),
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   self(self),
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   numKeys(numKeys),
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   previousVS(previousVS),
															#line 178 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   retry(0),
															#line 179 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   max_retry(10),
															#line 180 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   keysLimit(1)
															#line 1816 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
	{
		fdb_probe_actor_create("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this));

	}
	~WriteKeysAndGetLatencyVersionActorState() 
	{
		fdb_probe_actor_destroy("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 181 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			;
															#line 1831 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteKeysAndGetLatencyVersionActorState();
		static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 182 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (retry > max_retry)
															#line 1861 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		{
															#line 184 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			ASSERT(false);
															#line 1865 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		}
															#line 187 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->writeRandomKeys(cx, numKeys);
															#line 187 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1871 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->actor_wait_state = 1;
															#line 187 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteKeysAndGetLatencyVersionActor, 0, Void >*>(static_cast<WriteKeysAndGetLatencyVersionActor*>(this)));
															#line 1876 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 189 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = self->latencyRangeQuery(cx, keysLimit, true);
															#line 189 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1887 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->actor_wait_state = 2;
															#line 189 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKeysAndGetLatencyVersionActor, 1, RangeResult >*>(static_cast<WriteKeysAndGetLatencyVersionActor*>(this)));
															#line 1892 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 189 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = self->latencyRangeQuery(cx, keysLimit, true);
															#line 189 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1903 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->actor_wait_state = 2;
															#line 189 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteKeysAndGetLatencyVersionActor, 1, RangeResult >*>(static_cast<WriteKeysAndGetLatencyVersionActor*>(this)));
															#line 1908 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->actor_wait_state > 0) static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->ActorCallback< WriteKeysAndGetLatencyVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKeysAndGetLatencyVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteKeysAndGetLatencyVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteKeysAndGetLatencyVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& r,int loopDepth) 
	{
															#line 190 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (r.size() == 0)
															#line 1992 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		{
															#line 192 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			++retry;
															#line 1996 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 195 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		ASSERT(r.size() > 0);
															#line 197 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		KeyRef latest = r[0].key;
															#line 198 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		uint64_t vs = getVersionStamp(latest);
															#line 199 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		ASSERT(vs >= previousVS);
															#line 200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (vs == previousVS)
															#line 2009 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		{
															#line 202 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			++retry;
															#line 2013 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 205 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (!static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->SAV<uint64_t>::futures) { (void)(vs); this->~WriteKeysAndGetLatencyVersionActorState(); static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->destroy(); return 0; }
															#line 2018 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		new (&static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->SAV< uint64_t >::value()) uint64_t(vs);
		this->~WriteKeysAndGetLatencyVersionActorState();
		static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && r,int loopDepth) 
	{
															#line 190 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (r.size() == 0)
															#line 2030 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		{
															#line 192 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			++retry;
															#line 2034 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 195 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		ASSERT(r.size() > 0);
															#line 197 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		KeyRef latest = r[0].key;
															#line 198 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		uint64_t vs = getVersionStamp(latest);
															#line 199 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		ASSERT(vs >= previousVS);
															#line 200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (vs == previousVS)
															#line 2047 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		{
															#line 202 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			++retry;
															#line 2051 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 205 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (!static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->SAV<uint64_t>::futures) { (void)(vs); this->~WriteKeysAndGetLatencyVersionActorState(); static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->destroy(); return 0; }
															#line 2056 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		new (&static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->SAV< uint64_t >::value()) uint64_t(vs);
		this->~WriteKeysAndGetLatencyVersionActorState();
		static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(RangeResult const& r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(r, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(RangeResult && r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->actor_wait_state > 0) static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->actor_wait_state = 0;
		static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->ActorCallback< WriteKeysAndGetLatencyVersionActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< WriteKeysAndGetLatencyVersionActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteKeysAndGetLatencyVersionActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteKeysAndGetLatencyVersionActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	Database cx;
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	ClientMetricWorkload* self;
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	int numKeys;
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	uint64_t previousVS;
															#line 178 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	int retry;
															#line 179 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	int max_retry;
															#line 180 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	int keysLimit;
															#line 2153 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
};
// This generated class is to be used only via writeKeysAndGetLatencyVersion()
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
class WriteKeysAndGetLatencyVersionActor final : public Actor<uint64_t>, public ActorCallback< WriteKeysAndGetLatencyVersionActor, 0, Void >, public ActorCallback< WriteKeysAndGetLatencyVersionActor, 1, RangeResult >, public FastAllocated<WriteKeysAndGetLatencyVersionActor>, public WriteKeysAndGetLatencyVersionActorState<WriteKeysAndGetLatencyVersionActor> {
															#line 2158 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
public:
	using FastAllocated<WriteKeysAndGetLatencyVersionActor>::operator new;
	using FastAllocated<WriteKeysAndGetLatencyVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8087423610062654208UL, 12456704497076000256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<uint64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteKeysAndGetLatencyVersionActor, 0, Void >;
friend struct ActorCallback< WriteKeysAndGetLatencyVersionActor, 1, RangeResult >;
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	WriteKeysAndGetLatencyVersionActor(Database const& cx,ClientMetricWorkload* const& self,int const& numKeys,uint64_t const& previousVS) 
															#line 2176 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		 : Actor<uint64_t>(),
		   WriteKeysAndGetLatencyVersionActorState<WriteKeysAndGetLatencyVersionActor>(cx, self, numKeys, previousVS),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8142829335151791872UL, 6454775058622704128UL);
		ActorExecutionContextHelper __helper(static_cast<WriteKeysAndGetLatencyVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeKeysAndGetLatencyVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeKeysAndGetLatencyVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteKeysAndGetLatencyVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteKeysAndGetLatencyVersionActor, 1, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
[[nodiscard]] Future<uint64_t> writeKeysAndGetLatencyVersion( Database const& cx, ClientMetricWorkload* const& self, int const& numKeys, uint64_t const& previousVS ) {
															#line 174 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	return Future<uint64_t>(new WriteKeysAndGetLatencyVersionActor(cx, self, numKeys, previousVS));
															#line 2209 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
}

#line 208 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"

	// goal:
	//      write some random keys, check the latency metric and the latest version stamp vs1
	//      write some other random keys, check the latency metric and latest version stamp again vs2
	//      vs2 should be strictly larger than vs1, to verify new latency metrics are added
																#line 2218 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
// This generated class is to be used only via runner()
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
template <class RunnerActor>
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
class RunnerActorState {
															#line 2224 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
public:
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	RunnerActorState(Database const& cx,ClientMetricWorkload* const& self) 
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		 : cx(cx),
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		   self(self)
															#line 2233 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
	{
		fdb_probe_actor_create("runner", reinterpret_cast<unsigned long>(this));

	}
	~RunnerActorState() 
	{
		fdb_probe_actor_destroy("runner", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 215 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
				initialWrites = deterministicRandom()->randomInt(100, 200);
															#line 216 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
				secondWrites = deterministicRandom()->randomInt(100, 200);
															#line 218 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
				zeroVS = 0;
															#line 219 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
				StrictFuture<uint64_t> __when_expr_0 = self->writeKeysAndGetLatencyVersion(cx, self, initialWrites, zeroVS);
															#line 219 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
				if (static_cast<RunnerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2257 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunnerActor*>(this)->actor_wait_state = 1;
															#line 219 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunnerActor, 0, uint64_t >*>(static_cast<RunnerActor*>(this)));
															#line 2262 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunnerActorState();
		static_cast<RunnerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 230 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (!static_cast<RunnerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunnerActorState(); static_cast<RunnerActor*>(this)->destroy(); return 0; }
															#line 2291 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		new (&static_cast<RunnerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunnerActorState();
		static_cast<RunnerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 228 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
			TraceEvent("ClientMetricError").error(e);
															#line 2304 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 220 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		std::cout << "vs1=" << vs1 << std::endl;
															#line 221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		ASSERT(vs1 > zeroVS);
															#line 223 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		StrictFuture<uint64_t> __when_expr_1 = self->writeKeysAndGetLatencyVersion(cx, self, secondWrites, vs1);
															#line 223 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		if (static_cast<RunnerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2325 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<RunnerActor*>(this)->actor_wait_state = 2;
															#line 223 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunnerActor, 1, uint64_t >*>(static_cast<RunnerActor*>(this)));
															#line 2330 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(uint64_t const& __vs1,int loopDepth) 
	{
															#line 219 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		vs1 = __vs1;
															#line 2339 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(uint64_t && __vs1,int loopDepth) 
	{
		vs1 = std::move(__vs1);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunnerActor*>(this)->actor_wait_state > 0) static_cast<RunnerActor*>(this)->actor_wait_state = 0;
		static_cast<RunnerActor*>(this)->ActorCallback< RunnerActor, 0, uint64_t >::remove();

	}
	void a_callback_fire(ActorCallback< RunnerActor, 0, uint64_t >*,uint64_t const& value) 
	{
		fdb_probe_actor_enter("runner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runner", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunnerActor, 0, uint64_t >*,uint64_t && value) 
	{
		fdb_probe_actor_enter("runner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runner", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunnerActor, 0, uint64_t >*,Error err) 
	{
		fdb_probe_actor_enter("runner", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runner", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 224 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		std::cout << "vs2=" << vs2 << std::endl;
															#line 225 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		ASSERT(vs2 > vs1);
															#line 2420 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(uint64_t const& __vs2,int loopDepth) 
	{
															#line 223 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
		vs2 = __vs2;
															#line 2429 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(uint64_t && __vs2,int loopDepth) 
	{
		vs2 = std::move(__vs2);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunnerActor*>(this)->actor_wait_state > 0) static_cast<RunnerActor*>(this)->actor_wait_state = 0;
		static_cast<RunnerActor*>(this)->ActorCallback< RunnerActor, 1, uint64_t >::remove();

	}
	void a_callback_fire(ActorCallback< RunnerActor, 1, uint64_t >*,uint64_t const& value) 
	{
		fdb_probe_actor_enter("runner", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runner", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunnerActor, 1, uint64_t >*,uint64_t && value) 
	{
		fdb_probe_actor_enter("runner", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runner", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunnerActor, 1, uint64_t >*,Error err) 
	{
		fdb_probe_actor_enter("runner", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runner", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	Database cx;
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	ClientMetricWorkload* self;
															#line 215 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	int initialWrites;
															#line 216 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	int secondWrites;
															#line 218 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	uint64_t zeroVS;
															#line 219 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	uint64_t vs1;
															#line 223 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	uint64_t vs2;
															#line 2531 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
};
// This generated class is to be used only via runner()
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
class RunnerActor final : public Actor<Void>, public ActorCallback< RunnerActor, 0, uint64_t >, public ActorCallback< RunnerActor, 1, uint64_t >, public FastAllocated<RunnerActor>, public RunnerActorState<RunnerActor> {
															#line 2536 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
public:
	using FastAllocated<RunnerActor>::operator new;
	using FastAllocated<RunnerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14227871930089316096UL, 11972609325153368576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunnerActor, 0, uint64_t >;
friend struct ActorCallback< RunnerActor, 1, uint64_t >;
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	RunnerActor(Database const& cx,ClientMetricWorkload* const& self) 
															#line 2554 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
		 : Actor<Void>(),
		   RunnerActorState<RunnerActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runner", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11759470971493413376UL, 9671572266735255808UL);
		ActorExecutionContextHelper __helper(static_cast<RunnerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runner");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runner", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunnerActor, 0, uint64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunnerActor, 1, uint64_t >*)0, actor_cancelled()); break;
		}

	}
};
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
[[nodiscard]] Future<Void> runner( Database const& cx, ClientMetricWorkload* const& self ) {
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"
	return Future<Void>(new RunnerActor(cx, self));
															#line 2587 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClientMetric.actor.g.cpp"
}

#line 232 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/ClientMetric.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<ClientMetricWorkload> ClientMetricWorkloadFactory;
