#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
/*
 * BackupToBlob.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/BlobStoreWorkload.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct BackupToBlobWorkload : TestWorkload {
	double backupAfter;
	Key backupTag;
	Standalone<StringRef> backupURL;
	int initSnapshotInterval = 0;
	int snapshotInterval = 100000;

	static constexpr auto NAME = "BackupToBlob";

	BackupToBlobWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		backupAfter = getOption(options, "backupAfter"_sr, 10.0);
		backupTag = getOption(options, "backupTag"_sr, BackupAgentBase::getDefaultTag());
		auto backupURLString = getOption(options, "backupURL"_sr, "http://0.0.0.0:10000"_sr).toString();
		auto accessKeyEnvVar = getOption(options, "accessKeyVar"_sr, "BLOB_ACCESS_KEY"_sr).toString();
		auto secretKeyEnvVar = getOption(options, "secretKeyVar"_sr, "BLOB_SECRET_KEY"_sr).toString();
		bool provideKeys = getOption(options, "provideKeys"_sr, false);
		if (provideKeys) {
			updateBackupURL(backupURLString, accessKeyEnvVar, "<access_key>", secretKeyEnvVar, "<secret_key>");
		}
		backupURL = backupURLString;
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

																#line 56 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
template <class _startActor>
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
class _startActorState {
															#line 62 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
public:
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
	_startActorState(Database const& cx,BackupToBlobWorkload* const& self) 
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		 : cx(cx),
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		   self(self),
															#line 55 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		   backupAgent(),
															#line 56 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		   backupRanges()
															#line 75 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 58 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
			addDefaultBackupRanges(backupRanges);
															#line 60 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->backupAfter);
															#line 60 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 94 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 60 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 99 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		StrictFuture<Void> __when_expr_1 = backupAgent.submitBackup(cx, self->backupURL, {}, self->initSnapshotInterval, self->snapshotInterval, self->backupTag.toString(), backupRanges, true);
															#line 61 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 124 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 61 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 129 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 61 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		StrictFuture<Void> __when_expr_1 = backupAgent.submitBackup(cx, self->backupURL, {}, self->initSnapshotInterval, self->snapshotInterval, self->backupTag.toString(), backupRanges, true);
															#line 61 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 140 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 61 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 145 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 69 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		StrictFuture<EBackupState> __when_expr_2 = backupAgent.waitBackup(cx, self->backupTag.toString(), StopWhenDone::True);
															#line 69 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 231 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 69 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, EBackupState >*>(static_cast<_startActor*>(this)));
															#line 236 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 69 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		StrictFuture<EBackupState> __when_expr_2 = backupAgent.waitBackup(cx, self->backupTag.toString(), StopWhenDone::True);
															#line 69 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 247 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 69 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, EBackupState >*>(static_cast<_startActor*>(this)));
															#line 252 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(EBackupState const& backupStatus,int loopDepth) 
	{
															#line 70 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		TraceEvent("BackupToBlob_BackupStatus").detail("Status", BackupAgentBase::getStateText(backupStatus));
															#line 71 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 338 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(EBackupState && backupStatus,int loopDepth) 
	{
															#line 70 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		TraceEvent("BackupToBlob_BackupStatus").detail("Status", BackupAgentBase::getStateText(backupStatus));
															#line 71 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 352 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(EBackupState const& backupStatus,int loopDepth) 
	{
		loopDepth = a_body1cont3(backupStatus, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(EBackupState && backupStatus,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(backupStatus), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
	Database cx;
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
	BackupToBlobWorkload* self;
															#line 55 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
	FileBackupAgent backupAgent;
															#line 56 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 443 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, EBackupState >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 448 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8008355759062539008UL, 4645515724852762368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, EBackupState >;
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
	_startActor(Database const& cx,BackupToBlobWorkload* const& self) 
															#line 467 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, EBackupState >*)0, actor_cancelled()); break;
		}

	}
};
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, BackupToBlobWorkload* const& self ) {
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 501 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToBlob.actor.g.cpp"
}

#line 73 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToBlob.actor.cpp"

	Future<Void> start(Database const& cx) override { return clientId ? Void() : _start(cx, this); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<BackupToBlobWorkload> BackupToBlobWorkloadFactory;
