#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
/*
 * CoordinatedState.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbserver/ConfigBroadcaster.h"
#include "fdbserver/CoordinatedState.h"
#include "fdbserver/CoordinationInterface.h"
#include "fdbserver/Knobs.h"
#include "flow/ActorCollection.h"
#include "fdbserver/LeaderElection.h"
#include "flow/actorcompiler.h" // has to be last include

															#line 32 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
namespace {
// This generated class is to be used only via waitAndSendRead()
															#line 30 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
template <class WaitAndSendReadActor>
															#line 30 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class WaitAndSendReadActorState {
															#line 39 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
															#line 30 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	WaitAndSendReadActorState(GenerationRegInterface const& stateServer,GenerationRegReadRequest const& req) 
															#line 30 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
															#line 30 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		 : stateServer(stateServer),
															#line 30 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   req(req)
															#line 48 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
	{
		fdb_probe_actor_create("waitAndSendRead", reinterpret_cast<unsigned long>(this));

	}
	~WaitAndSendReadActorState() 
	{
		fdb_probe_actor_destroy("waitAndSendRead", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 31 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (SERVER_KNOBS->BUGGIFY_ALL_COORDINATION || BUGGIFY)
															#line 63 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			{
															#line 32 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->BUGGIFIED_EVENTUAL_CONSISTENCY * deterministicRandom()->random01());
															#line 32 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				if (static_cast<WaitAndSendReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 69 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitAndSendReadActor*>(this)->actor_wait_state = 1;
															#line 32 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitAndSendReadActor, 0, Void >*>(static_cast<WaitAndSendReadActor*>(this)));
															#line 74 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitAndSendReadActorState();
		static_cast<WaitAndSendReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 33 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		reply = GenerationRegReadReply();
															#line 34 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (stateServer.hostname.present())
															#line 104 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 35 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(reply, retryGetReplyFromHostname(req, stateServer.hostname.get(), WLTOKEN_GENERATIONREG_READ));
															#line 35 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<WaitAndSendReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 110 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitAndSendReadActor*>(this)->actor_wait_state = 2;
															#line 35 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitAndSendReadActor, 1, Void >*>(static_cast<WaitAndSendReadActor*>(this)));
															#line 115 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 37 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(reply, retryBrokenPromise(stateServer.read, req));
															#line 37 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<WaitAndSendReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 124 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<WaitAndSendReadActor*>(this)->actor_wait_state = 3;
															#line 37 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitAndSendReadActor, 2, Void >*>(static_cast<WaitAndSendReadActor*>(this)));
															#line 129 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitAndSendReadActor*>(this)->actor_wait_state > 0) static_cast<WaitAndSendReadActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAndSendReadActor*>(this)->ActorCallback< WaitAndSendReadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAndSendReadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAndSendRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitAndSendReadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAndSendRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitAndSendReadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAndSendRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendRead", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 39 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (SERVER_KNOBS->BUGGIFY_ALL_COORDINATION || BUGGIFY)
															#line 226 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 40 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->BUGGIFIED_EVENTUAL_CONSISTENCY * deterministicRandom()->random01());
															#line 40 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<WaitAndSendReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 232 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<WaitAndSendReadActor*>(this)->actor_wait_state = 4;
															#line 40 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitAndSendReadActor, 3, Void >*>(static_cast<WaitAndSendReadActor*>(this)));
															#line 237 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitAndSendReadActor*>(this)->actor_wait_state > 0) static_cast<WaitAndSendReadActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAndSendReadActor*>(this)->ActorCallback< WaitAndSendReadActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAndSendReadActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAndSendRead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendRead", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitAndSendReadActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAndSendRead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendRead", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitAndSendReadActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAndSendRead", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendRead", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitAndSendReadActor*>(this)->actor_wait_state > 0) static_cast<WaitAndSendReadActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAndSendReadActor*>(this)->ActorCallback< WaitAndSendReadActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAndSendReadActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAndSendRead", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendRead", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitAndSendReadActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAndSendRead", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendRead", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitAndSendReadActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAndSendRead", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendRead", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 41 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (!static_cast<WaitAndSendReadActor*>(this)->SAV<GenerationRegReadReply>::futures) { (void)(reply); this->~WaitAndSendReadActorState(); static_cast<WaitAndSendReadActor*>(this)->destroy(); return 0; }
															#line 425 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		new (&static_cast<WaitAndSendReadActor*>(this)->SAV< GenerationRegReadReply >::value()) GenerationRegReadReply(std::move(reply)); // state_var_RVO
		this->~WaitAndSendReadActorState();
		static_cast<WaitAndSendReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitAndSendReadActor*>(this)->actor_wait_state > 0) static_cast<WaitAndSendReadActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAndSendReadActor*>(this)->ActorCallback< WaitAndSendReadActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAndSendReadActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAndSendRead", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendRead", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitAndSendReadActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAndSendRead", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendRead", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitAndSendReadActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAndSendRead", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendRead", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 30 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	GenerationRegInterface stateServer;
															#line 30 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	GenerationRegReadRequest req;
															#line 33 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	GenerationRegReadReply reply;
															#line 526 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
};
// This generated class is to be used only via waitAndSendRead()
															#line 30 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class WaitAndSendReadActor final : public Actor<GenerationRegReadReply>, public ActorCallback< WaitAndSendReadActor, 0, Void >, public ActorCallback< WaitAndSendReadActor, 1, Void >, public ActorCallback< WaitAndSendReadActor, 2, Void >, public ActorCallback< WaitAndSendReadActor, 3, Void >, public FastAllocated<WaitAndSendReadActor>, public WaitAndSendReadActorState<WaitAndSendReadActor> {
															#line 531 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
	using FastAllocated<WaitAndSendReadActor>::operator new;
	using FastAllocated<WaitAndSendReadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11800142951915596032UL, 13277882060814506240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<GenerationRegReadReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitAndSendReadActor, 0, Void >;
friend struct ActorCallback< WaitAndSendReadActor, 1, Void >;
friend struct ActorCallback< WaitAndSendReadActor, 2, Void >;
friend struct ActorCallback< WaitAndSendReadActor, 3, Void >;
															#line 30 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	WaitAndSendReadActor(GenerationRegInterface const& stateServer,GenerationRegReadRequest const& req) 
															#line 551 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		 : Actor<GenerationRegReadReply>(),
		   WaitAndSendReadActorState<WaitAndSendReadActor>(stateServer, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitAndSendRead", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7733972956495371008UL, 3351568193074062336UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitAndSendRead");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitAndSendRead", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitAndSendReadActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitAndSendReadActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitAndSendReadActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitAndSendReadActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 30 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
[[nodiscard]] Future<GenerationRegReadReply> waitAndSendRead( GenerationRegInterface const& stateServer, GenerationRegReadRequest const& req ) {
															#line 30 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	return Future<GenerationRegReadReply>(new WaitAndSendReadActor(stateServer, req));
															#line 587 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
}

#line 43 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"

															#line 592 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
namespace {
// This generated class is to be used only via waitAndSendWrite()
															#line 44 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
template <class WaitAndSendWriteActor>
															#line 44 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class WaitAndSendWriteActorState {
															#line 599 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
															#line 44 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	WaitAndSendWriteActorState(GenerationRegInterface const& stateServer,GenerationRegWriteRequest const& req) 
															#line 44 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
															#line 44 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		 : stateServer(stateServer),
															#line 44 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   req(req)
															#line 608 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
	{
		fdb_probe_actor_create("waitAndSendWrite", reinterpret_cast<unsigned long>(this));

	}
	~WaitAndSendWriteActorState() 
	{
		fdb_probe_actor_destroy("waitAndSendWrite", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 45 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (SERVER_KNOBS->BUGGIFY_ALL_COORDINATION || BUGGIFY)
															#line 623 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			{
															#line 46 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->BUGGIFIED_EVENTUAL_CONSISTENCY * deterministicRandom()->random01());
															#line 46 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				if (static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 629 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitAndSendWriteActor, 0, Void >*>(static_cast<WaitAndSendWriteActor*>(this)));
															#line 634 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitAndSendWriteActorState();
		static_cast<WaitAndSendWriteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 47 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		reply = UniqueGeneration();
															#line 48 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (stateServer.hostname.present())
															#line 664 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 49 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_1 = store(reply, retryGetReplyFromHostname(req, stateServer.hostname.get(), WLTOKEN_GENERATIONREG_WRITE));
															#line 49 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 670 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state = 2;
															#line 49 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitAndSendWriteActor, 1, Void >*>(static_cast<WaitAndSendWriteActor*>(this)));
															#line 675 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 51 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(reply, retryBrokenPromise(stateServer.write, req));
															#line 51 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 684 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
			static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state = 3;
															#line 51 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitAndSendWriteActor, 2, Void >*>(static_cast<WaitAndSendWriteActor*>(this)));
															#line 689 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state > 0) static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAndSendWriteActor*>(this)->ActorCallback< WaitAndSendWriteActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAndSendWriteActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitAndSendWriteActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitAndSendWriteActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 53 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (SERVER_KNOBS->BUGGIFY_ALL_COORDINATION || BUGGIFY)
															#line 786 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(SERVER_KNOBS->BUGGIFIED_EVENTUAL_CONSISTENCY * deterministicRandom()->random01());
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 792 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state = 4;
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitAndSendWriteActor, 3, Void >*>(static_cast<WaitAndSendWriteActor*>(this)));
															#line 797 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state > 0) static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAndSendWriteActor*>(this)->ActorCallback< WaitAndSendWriteActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAndSendWriteActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitAndSendWriteActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitAndSendWriteActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state > 0) static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAndSendWriteActor*>(this)->ActorCallback< WaitAndSendWriteActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAndSendWriteActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitAndSendWriteActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitAndSendWriteActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 55 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (!static_cast<WaitAndSendWriteActor*>(this)->SAV<UniqueGeneration>::futures) { (void)(reply); this->~WaitAndSendWriteActorState(); static_cast<WaitAndSendWriteActor*>(this)->destroy(); return 0; }
															#line 985 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		new (&static_cast<WaitAndSendWriteActor*>(this)->SAV< UniqueGeneration >::value()) UniqueGeneration(std::move(reply)); // state_var_RVO
		this->~WaitAndSendWriteActorState();
		static_cast<WaitAndSendWriteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state > 0) static_cast<WaitAndSendWriteActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAndSendWriteActor*>(this)->ActorCallback< WaitAndSendWriteActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAndSendWriteActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitAndSendWriteActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitAndSendWriteActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSendWrite", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 44 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	GenerationRegInterface stateServer;
															#line 44 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	GenerationRegWriteRequest req;
															#line 47 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	UniqueGeneration reply;
															#line 1086 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
};
// This generated class is to be used only via waitAndSendWrite()
															#line 44 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class WaitAndSendWriteActor final : public Actor<UniqueGeneration>, public ActorCallback< WaitAndSendWriteActor, 0, Void >, public ActorCallback< WaitAndSendWriteActor, 1, Void >, public ActorCallback< WaitAndSendWriteActor, 2, Void >, public ActorCallback< WaitAndSendWriteActor, 3, Void >, public FastAllocated<WaitAndSendWriteActor>, public WaitAndSendWriteActorState<WaitAndSendWriteActor> {
															#line 1091 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
	using FastAllocated<WaitAndSendWriteActor>::operator new;
	using FastAllocated<WaitAndSendWriteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2190264058587157504UL, 1995649385459962624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<UniqueGeneration>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitAndSendWriteActor, 0, Void >;
friend struct ActorCallback< WaitAndSendWriteActor, 1, Void >;
friend struct ActorCallback< WaitAndSendWriteActor, 2, Void >;
friend struct ActorCallback< WaitAndSendWriteActor, 3, Void >;
															#line 44 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	WaitAndSendWriteActor(GenerationRegInterface const& stateServer,GenerationRegWriteRequest const& req) 
															#line 1111 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		 : Actor<UniqueGeneration>(),
		   WaitAndSendWriteActorState<WaitAndSendWriteActor>(stateServer, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitAndSendWrite", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9593568379740578816UL, 3648420840714693888UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSendWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitAndSendWrite");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitAndSendWrite", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitAndSendWriteActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitAndSendWriteActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitAndSendWriteActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitAndSendWriteActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 44 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
[[nodiscard]] Future<UniqueGeneration> waitAndSendWrite( GenerationRegInterface const& stateServer, GenerationRegWriteRequest const& req ) {
															#line 44 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	return Future<UniqueGeneration>(new WaitAndSendWriteActor(stateServer, req));
															#line 1147 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
}

#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"

															#line 1152 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
namespace {
// This generated class is to be used only via emptyToNever()
															#line 58 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
template <class EmptyToNeverActor>
															#line 58 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class EmptyToNeverActorState {
															#line 1159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
															#line 58 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	EmptyToNeverActorState(Future<GenerationRegReadReply> const& f) 
															#line 58 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
															#line 58 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		 : f(f)
															#line 1166 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
	{
		fdb_probe_actor_create("emptyToNever", reinterpret_cast<unsigned long>(this));

	}
	~EmptyToNeverActorState() 
	{
		fdb_probe_actor_destroy("emptyToNever", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 59 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<GenerationRegReadReply> __when_expr_0 = f;
															#line 59 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<EmptyToNeverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1183 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<EmptyToNeverActor*>(this)->actor_wait_state = 1;
															#line 59 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EmptyToNeverActor, 0, GenerationRegReadReply >*>(static_cast<EmptyToNeverActor*>(this)));
															#line 1188 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EmptyToNeverActorState();
		static_cast<EmptyToNeverActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 60 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (r.gen.generation == 0)
															#line 1211 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 61 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_1 = Future<Void>(Never());
															#line 61 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<EmptyToNeverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1217 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<EmptyToNeverActor*>(this)->actor_wait_state = 2;
															#line 61 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EmptyToNeverActor, 1, Void >*>(static_cast<EmptyToNeverActor*>(this)));
															#line 1222 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(GenerationRegReadReply const& __r,int loopDepth) 
	{
															#line 59 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		r = __r;
															#line 1236 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(GenerationRegReadReply && __r,int loopDepth) 
	{
		r = std::move(__r);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EmptyToNeverActor*>(this)->actor_wait_state > 0) static_cast<EmptyToNeverActor*>(this)->actor_wait_state = 0;
		static_cast<EmptyToNeverActor*>(this)->ActorCallback< EmptyToNeverActor, 0, GenerationRegReadReply >::remove();

	}
	void a_callback_fire(ActorCallback< EmptyToNeverActor, 0, GenerationRegReadReply >*,GenerationRegReadReply const& value) 
	{
		fdb_probe_actor_enter("emptyToNever", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyToNever", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EmptyToNeverActor, 0, GenerationRegReadReply >*,GenerationRegReadReply && value) 
	{
		fdb_probe_actor_enter("emptyToNever", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyToNever", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EmptyToNeverActor, 0, GenerationRegReadReply >*,Error err) 
	{
		fdb_probe_actor_enter("emptyToNever", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyToNever", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 62 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (!static_cast<EmptyToNeverActor*>(this)->SAV<GenerationRegReadReply>::futures) { (void)(r); this->~EmptyToNeverActorState(); static_cast<EmptyToNeverActor*>(this)->destroy(); return 0; }
															#line 1315 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		new (&static_cast<EmptyToNeverActor*>(this)->SAV< GenerationRegReadReply >::value()) GenerationRegReadReply(std::move(r)); // state_var_RVO
		this->~EmptyToNeverActorState();
		static_cast<EmptyToNeverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<EmptyToNeverActor*>(this)->actor_wait_state > 0) static_cast<EmptyToNeverActor*>(this)->actor_wait_state = 0;
		static_cast<EmptyToNeverActor*>(this)->ActorCallback< EmptyToNeverActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< EmptyToNeverActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("emptyToNever", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyToNever", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EmptyToNeverActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("emptyToNever", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyToNever", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< EmptyToNeverActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("emptyToNever", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("emptyToNever", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 58 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	Future<GenerationRegReadReply> f;
															#line 59 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	GenerationRegReadReply r;
															#line 1414 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
};
// This generated class is to be used only via emptyToNever()
															#line 58 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class EmptyToNeverActor final : public Actor<GenerationRegReadReply>, public ActorCallback< EmptyToNeverActor, 0, GenerationRegReadReply >, public ActorCallback< EmptyToNeverActor, 1, Void >, public FastAllocated<EmptyToNeverActor>, public EmptyToNeverActorState<EmptyToNeverActor> {
															#line 1419 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
	using FastAllocated<EmptyToNeverActor>::operator new;
	using FastAllocated<EmptyToNeverActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11880256408247382016UL, 13188441621809622272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<GenerationRegReadReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EmptyToNeverActor, 0, GenerationRegReadReply >;
friend struct ActorCallback< EmptyToNeverActor, 1, Void >;
															#line 58 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	EmptyToNeverActor(Future<GenerationRegReadReply> const& f) 
															#line 1437 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		 : Actor<GenerationRegReadReply>(),
		   EmptyToNeverActorState<EmptyToNeverActor>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("emptyToNever", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1776544315372359936UL, 3445767680576194560UL);
		ActorExecutionContextHelper __helper(static_cast<EmptyToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("emptyToNever");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("emptyToNever", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EmptyToNeverActor, 0, GenerationRegReadReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< EmptyToNeverActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 58 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
[[nodiscard]] Future<GenerationRegReadReply> emptyToNever( Future<GenerationRegReadReply> const& f ) {
															#line 58 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	return Future<GenerationRegReadReply>(new EmptyToNeverActor(f));
															#line 1471 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
}

#line 64 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"

															#line 1476 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
namespace {
// This generated class is to be used only via nonemptyToNever()
															#line 65 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
template <class NonemptyToNeverActor>
															#line 65 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class NonemptyToNeverActorState {
															#line 1483 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
															#line 65 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	NonemptyToNeverActorState(Future<GenerationRegReadReply> const& f) 
															#line 65 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
															#line 65 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		 : f(f)
															#line 1490 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
	{
		fdb_probe_actor_create("nonemptyToNever", reinterpret_cast<unsigned long>(this));

	}
	~NonemptyToNeverActorState() 
	{
		fdb_probe_actor_destroy("nonemptyToNever", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<GenerationRegReadReply> __when_expr_0 = f;
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<NonemptyToNeverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1507 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<NonemptyToNeverActor*>(this)->actor_wait_state = 1;
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NonemptyToNeverActor, 0, GenerationRegReadReply >*>(static_cast<NonemptyToNeverActor*>(this)));
															#line 1512 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NonemptyToNeverActorState();
		static_cast<NonemptyToNeverActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 67 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (r.gen.generation != 0)
															#line 1535 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 68 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_1 = Future<Void>(Never());
															#line 68 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<NonemptyToNeverActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1541 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<NonemptyToNeverActor*>(this)->actor_wait_state = 2;
															#line 68 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NonemptyToNeverActor, 1, Void >*>(static_cast<NonemptyToNeverActor*>(this)));
															#line 1546 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(GenerationRegReadReply const& __r,int loopDepth) 
	{
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		r = __r;
															#line 1560 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(GenerationRegReadReply && __r,int loopDepth) 
	{
		r = std::move(__r);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NonemptyToNeverActor*>(this)->actor_wait_state > 0) static_cast<NonemptyToNeverActor*>(this)->actor_wait_state = 0;
		static_cast<NonemptyToNeverActor*>(this)->ActorCallback< NonemptyToNeverActor, 0, GenerationRegReadReply >::remove();

	}
	void a_callback_fire(ActorCallback< NonemptyToNeverActor, 0, GenerationRegReadReply >*,GenerationRegReadReply const& value) 
	{
		fdb_probe_actor_enter("nonemptyToNever", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NonemptyToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("nonemptyToNever", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NonemptyToNeverActor, 0, GenerationRegReadReply >*,GenerationRegReadReply && value) 
	{
		fdb_probe_actor_enter("nonemptyToNever", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NonemptyToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("nonemptyToNever", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NonemptyToNeverActor, 0, GenerationRegReadReply >*,Error err) 
	{
		fdb_probe_actor_enter("nonemptyToNever", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NonemptyToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("nonemptyToNever", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 69 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (!static_cast<NonemptyToNeverActor*>(this)->SAV<GenerationRegReadReply>::futures) { (void)(r); this->~NonemptyToNeverActorState(); static_cast<NonemptyToNeverActor*>(this)->destroy(); return 0; }
															#line 1639 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		new (&static_cast<NonemptyToNeverActor*>(this)->SAV< GenerationRegReadReply >::value()) GenerationRegReadReply(std::move(r)); // state_var_RVO
		this->~NonemptyToNeverActorState();
		static_cast<NonemptyToNeverActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NonemptyToNeverActor*>(this)->actor_wait_state > 0) static_cast<NonemptyToNeverActor*>(this)->actor_wait_state = 0;
		static_cast<NonemptyToNeverActor*>(this)->ActorCallback< NonemptyToNeverActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NonemptyToNeverActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("nonemptyToNever", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NonemptyToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("nonemptyToNever", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NonemptyToNeverActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("nonemptyToNever", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NonemptyToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("nonemptyToNever", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NonemptyToNeverActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("nonemptyToNever", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NonemptyToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("nonemptyToNever", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 65 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	Future<GenerationRegReadReply> f;
															#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	GenerationRegReadReply r;
															#line 1738 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
};
// This generated class is to be used only via nonemptyToNever()
															#line 65 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class NonemptyToNeverActor final : public Actor<GenerationRegReadReply>, public ActorCallback< NonemptyToNeverActor, 0, GenerationRegReadReply >, public ActorCallback< NonemptyToNeverActor, 1, Void >, public FastAllocated<NonemptyToNeverActor>, public NonemptyToNeverActorState<NonemptyToNeverActor> {
															#line 1743 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
	using FastAllocated<NonemptyToNeverActor>::operator new;
	using FastAllocated<NonemptyToNeverActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10919748056308697344UL, 15201599940844642304UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<GenerationRegReadReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NonemptyToNeverActor, 0, GenerationRegReadReply >;
friend struct ActorCallback< NonemptyToNeverActor, 1, Void >;
															#line 65 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	NonemptyToNeverActor(Future<GenerationRegReadReply> const& f) 
															#line 1761 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		 : Actor<GenerationRegReadReply>(),
		   NonemptyToNeverActorState<NonemptyToNeverActor>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("nonemptyToNever", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10831198834256230656UL, 10219014396045676800UL);
		ActorExecutionContextHelper __helper(static_cast<NonemptyToNeverActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("nonemptyToNever");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("nonemptyToNever", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NonemptyToNeverActor, 0, GenerationRegReadReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NonemptyToNeverActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 65 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
[[nodiscard]] Future<GenerationRegReadReply> nonemptyToNever( Future<GenerationRegReadReply> const& f ) {
															#line 65 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	return Future<GenerationRegReadReply>(new NonemptyToNeverActor(f));
															#line 1795 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
}

#line 71 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"

struct CoordinatedStateImpl {
	ServerCoordinators coordinators;
	int stage;
	UniqueGeneration gen;
	uint64_t conflictGen;
	bool doomed;
	ActorCollection ac; // Errors are not reported
	bool initial;

	CoordinatedStateImpl(ServerCoordinators const& c)
	  : coordinators(c), stage(0), conflictGen(0), doomed(false), ac(false), initial(false) {}
	uint64_t getConflict() const { return conflictGen; }

	bool isDoomed(GenerationRegReadReply const& rep) const {
		return rep.gen > gen;
		// setExclusive is doomed, because there was a write at least started at a higher
		// generation, which means a read completed at that higher generation
		// || rep.rgen > gen // setExclusive isn't absolutely doomed, but it may/probably will fail
	}

																#line 1820 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
// This generated class is to be used only via read()
															#line 92 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
template <class ReadActor>
															#line 92 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class ReadActorState {
															#line 1826 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
															#line 92 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	ReadActorState(CoordinatedStateImpl* const& self) 
															#line 92 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
															#line 92 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		 : self(self)
															#line 1833 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
	{
		fdb_probe_actor_create("read", reinterpret_cast<unsigned long>(this));

	}
	~ReadActorState() 
	{
		fdb_probe_actor_destroy("read", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 93 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			ASSERT(self->stage == 0);
															#line 1848 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			{
															#line 96 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				self->stage = 1;
															#line 97 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				StrictFuture<GenerationRegReadReply> __when_expr_0 = self->replicatedRead( self, GenerationRegReadRequest(self->coordinators.clusterKey, UniqueGeneration()));
															#line 97 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				if (static_cast<ReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1856 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadActor*>(this)->actor_wait_state = 1;
															#line 97 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadActor, 0, GenerationRegReadReply >*>(static_cast<ReadActor*>(this)));
															#line 1861 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadActorState();
		static_cast<ReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		{
															#line 104 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			self->stage = 2;
															#line 105 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<GenerationRegReadReply> __when_expr_1 = self->replicatedRead(self, GenerationRegReadRequest(self->coordinators.clusterKey, self->gen));
															#line 105 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<ReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1890 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadActor*>(this)->actor_wait_state = 2;
															#line 105 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadActor, 1, GenerationRegReadReply >*>(static_cast<ReadActor*>(this)));
															#line 1895 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2(GenerationRegReadReply const& rep,int loopDepth) 
	{
															#line 99 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->conflictGen = std::max(self->conflictGen, std::max(rep.gen.generation, rep.rgen.generation)) + 1;
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->gen = UniqueGeneration(self->conflictGen, deterministicRandom()->randomUniqueID());
															#line 1907 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(GenerationRegReadReply && rep,int loopDepth) 
	{
															#line 99 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->conflictGen = std::max(self->conflictGen, std::max(rep.gen.generation, rep.rgen.generation)) + 1;
															#line 100 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->gen = UniqueGeneration(self->conflictGen, deterministicRandom()->randomUniqueID());
															#line 1918 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(GenerationRegReadReply const& rep,int loopDepth) 
	{
		loopDepth = a_body1cont2(rep, loopDepth);

		return loopDepth;
	}
	int a_body1when1(GenerationRegReadReply && rep,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadActor*>(this)->actor_wait_state > 0) static_cast<ReadActor*>(this)->actor_wait_state = 0;
		static_cast<ReadActor*>(this)->ActorCallback< ReadActor, 0, GenerationRegReadReply >::remove();

	}
	void a_callback_fire(ActorCallback< ReadActor, 0, GenerationRegReadReply >*,GenerationRegReadReply const& value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadActor, 0, GenerationRegReadReply >*,GenerationRegReadReply && value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadActor, 0, GenerationRegReadReply >*,Error err) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(GenerationRegReadReply const& rep,int loopDepth) 
	{
															#line 107 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->stage = 3;
															#line 108 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->conflictGen = std::max(self->conflictGen, std::max(rep.gen.generation, rep.rgen.generation));
															#line 109 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (self->isDoomed(rep))
															#line 2006 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 110 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			self->doomed = true;
															#line 2010 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		}
															#line 111 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->initial = rep.gen.generation == 0;
															#line 113 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->stage = 4;
															#line 114 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (!static_cast<ReadActor*>(this)->SAV<Value>::futures) { (void)(rep.value.present() ? rep.value.get() : Value()); this->~ReadActorState(); static_cast<ReadActor*>(this)->destroy(); return 0; }
															#line 2018 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		new (&static_cast<ReadActor*>(this)->SAV< Value >::value()) Value(rep.value.present() ? rep.value.get() : Value());
		this->~ReadActorState();
		static_cast<ReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(GenerationRegReadReply && rep,int loopDepth) 
	{
															#line 107 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->stage = 3;
															#line 108 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->conflictGen = std::max(self->conflictGen, std::max(rep.gen.generation, rep.rgen.generation));
															#line 109 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (self->isDoomed(rep))
															#line 2034 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 110 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			self->doomed = true;
															#line 2038 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		}
															#line 111 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->initial = rep.gen.generation == 0;
															#line 113 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->stage = 4;
															#line 114 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (!static_cast<ReadActor*>(this)->SAV<Value>::futures) { (void)(rep.value.present() ? rep.value.get() : Value()); this->~ReadActorState(); static_cast<ReadActor*>(this)->destroy(); return 0; }
															#line 2046 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		new (&static_cast<ReadActor*>(this)->SAV< Value >::value()) Value(rep.value.present() ? rep.value.get() : Value());
		this->~ReadActorState();
		static_cast<ReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(GenerationRegReadReply const& rep,int loopDepth) 
	{
		loopDepth = a_body1cont5(rep, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(GenerationRegReadReply && rep,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadActor*>(this)->actor_wait_state > 0) static_cast<ReadActor*>(this)->actor_wait_state = 0;
		static_cast<ReadActor*>(this)->ActorCallback< ReadActor, 1, GenerationRegReadReply >::remove();

	}
	void a_callback_fire(ActorCallback< ReadActor, 1, GenerationRegReadReply >*,GenerationRegReadReply const& value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadActor, 1, GenerationRegReadReply >*,GenerationRegReadReply && value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadActor, 1, GenerationRegReadReply >*,Error err) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 92 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	CoordinatedStateImpl* self;
															#line 2131 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
};
// This generated class is to be used only via read()
															#line 92 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class ReadActor final : public Actor<Value>, public ActorCallback< ReadActor, 0, GenerationRegReadReply >, public ActorCallback< ReadActor, 1, GenerationRegReadReply >, public FastAllocated<ReadActor>, public ReadActorState<ReadActor> {
															#line 2136 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
	using FastAllocated<ReadActor>::operator new;
	using FastAllocated<ReadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15422497785423398912UL, 3210475657304951552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Value>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadActor, 0, GenerationRegReadReply >;
friend struct ActorCallback< ReadActor, 1, GenerationRegReadReply >;
															#line 92 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	ReadActor(CoordinatedStateImpl* const& self) 
															#line 2154 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		 : Actor<Value>(),
		   ReadActorState<ReadActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3377648328873480704UL, 6210503387287458048UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("read");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadActor, 0, GenerationRegReadReply >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadActor, 1, GenerationRegReadReply >*)0, actor_cancelled()); break;
		}

	}
};
															#line 92 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
[[nodiscard]] static Future<Value> read( CoordinatedStateImpl* const& self ) {
															#line 92 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	return Future<Value>(new ReadActor(self));
															#line 2187 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
}

#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
																#line 2191 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
// This generated class is to be used only via onConflict()
															#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
template <class OnConflictActor>
															#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class OnConflictActorState {
															#line 2197 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
															#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	OnConflictActorState(CoordinatedStateImpl* const& self) 
															#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
															#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		 : self(self)
															#line 2204 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
	{
		fdb_probe_actor_create("onConflict", reinterpret_cast<unsigned long>(this));

	}
	~OnConflictActorState() 
	{
		fdb_probe_actor_destroy("onConflict", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 118 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			ASSERT(self->stage == 4);
															#line 119 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (self->doomed)
															#line 2221 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			{
															#line 120 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				if (!static_cast<OnConflictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnConflictActorState(); static_cast<OnConflictActor*>(this)->destroy(); return 0; }
															#line 2225 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
				new (&static_cast<OnConflictActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~OnConflictActorState();
				static_cast<OnConflictActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 121 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			;
															#line 2233 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OnConflictActorState();
		static_cast<OnConflictActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 131 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		StrictFuture<Void> __when_expr_2 = Future<Void>(Never());
															#line 131 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (static_cast<OnConflictActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2258 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<OnConflictActor*>(this)->actor_wait_state = 3;
															#line 131 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< OnConflictActor, 2, Void >*>(static_cast<OnConflictActor*>(this)));
															#line 2263 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 122 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->COORDINATED_STATE_ONCONFLICT_POLL_INTERVAL);
															#line 122 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (static_cast<OnConflictActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2281 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<OnConflictActor*>(this)->actor_wait_state = 1;
															#line 122 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OnConflictActor, 0, Void >*>(static_cast<OnConflictActor*>(this)));
															#line 2286 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		StrictFuture<GenerationRegReadReply> __when_expr_1 = self->replicatedRead( self, GenerationRegReadRequest(self->coordinators.clusterKey, UniqueGeneration()));
															#line 123 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (static_cast<OnConflictActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2310 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OnConflictActor*>(this)->actor_wait_state = 2;
															#line 123 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OnConflictActor, 1, GenerationRegReadReply >*>(static_cast<OnConflictActor*>(this)));
															#line 2315 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		StrictFuture<GenerationRegReadReply> __when_expr_1 = self->replicatedRead( self, GenerationRegReadRequest(self->coordinators.clusterKey, UniqueGeneration()));
															#line 123 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (static_cast<OnConflictActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2326 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OnConflictActor*>(this)->actor_wait_state = 2;
															#line 123 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OnConflictActor, 1, GenerationRegReadReply >*>(static_cast<OnConflictActor*>(this)));
															#line 2331 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OnConflictActor*>(this)->actor_wait_state > 0) static_cast<OnConflictActor*>(this)->actor_wait_state = 0;
		static_cast<OnConflictActor*>(this)->ActorCallback< OnConflictActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OnConflictActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onConflict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onConflict", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OnConflictActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onConflict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onConflict", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OnConflictActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onConflict", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onConflict", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(GenerationRegReadReply const& rep,int loopDepth) 
	{
															#line 125 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (self->stage > 4)
															#line 2415 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 127 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->conflictGen = std::max(self->conflictGen, std::max(rep.gen.generation, rep.rgen.generation));
															#line 128 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (self->isDoomed(rep))
															#line 2423 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 129 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (!static_cast<OnConflictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnConflictActorState(); static_cast<OnConflictActor*>(this)->destroy(); return 0; }
															#line 2427 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			new (&static_cast<OnConflictActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~OnConflictActorState();
			static_cast<OnConflictActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(GenerationRegReadReply && rep,int loopDepth) 
	{
															#line 125 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (self->stage > 4)
															#line 2441 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 127 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->conflictGen = std::max(self->conflictGen, std::max(rep.gen.generation, rep.rgen.generation));
															#line 128 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (self->isDoomed(rep))
															#line 2449 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 129 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (!static_cast<OnConflictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnConflictActorState(); static_cast<OnConflictActor*>(this)->destroy(); return 0; }
															#line 2453 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			new (&static_cast<OnConflictActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~OnConflictActorState();
			static_cast<OnConflictActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(GenerationRegReadReply const& rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(rep, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(GenerationRegReadReply && rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OnConflictActor*>(this)->actor_wait_state > 0) static_cast<OnConflictActor*>(this)->actor_wait_state = 0;
		static_cast<OnConflictActor*>(this)->ActorCallback< OnConflictActor, 1, GenerationRegReadReply >::remove();

	}
	void a_callback_fire(ActorCallback< OnConflictActor, 1, GenerationRegReadReply >*,GenerationRegReadReply const& value) 
	{
		fdb_probe_actor_enter("onConflict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onConflict", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OnConflictActor, 1, GenerationRegReadReply >*,GenerationRegReadReply && value) 
	{
		fdb_probe_actor_enter("onConflict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onConflict", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OnConflictActor, 1, GenerationRegReadReply >*,Error err) 
	{
		fdb_probe_actor_enter("onConflict", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onConflict", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 132 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (!static_cast<OnConflictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnConflictActorState(); static_cast<OnConflictActor*>(this)->destroy(); return 0; }
															#line 2542 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		new (&static_cast<OnConflictActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OnConflictActorState();
		static_cast<OnConflictActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 132 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (!static_cast<OnConflictActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnConflictActorState(); static_cast<OnConflictActor*>(this)->destroy(); return 0; }
															#line 2554 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		new (&static_cast<OnConflictActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OnConflictActorState();
		static_cast<OnConflictActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<OnConflictActor*>(this)->actor_wait_state > 0) static_cast<OnConflictActor*>(this)->actor_wait_state = 0;
		static_cast<OnConflictActor*>(this)->ActorCallback< OnConflictActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OnConflictActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onConflict", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onConflict", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< OnConflictActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onConflict", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onConflict", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< OnConflictActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onConflict", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onConflict", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	CoordinatedStateImpl* self;
															#line 2639 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
};
// This generated class is to be used only via onConflict()
															#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class OnConflictActor final : public Actor<Void>, public ActorCallback< OnConflictActor, 0, Void >, public ActorCallback< OnConflictActor, 1, GenerationRegReadReply >, public ActorCallback< OnConflictActor, 2, Void >, public FastAllocated<OnConflictActor>, public OnConflictActorState<OnConflictActor> {
															#line 2644 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
	using FastAllocated<OnConflictActor>::operator new;
	using FastAllocated<OnConflictActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10878672305447270912UL, 5224763198146559488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OnConflictActor, 0, Void >;
friend struct ActorCallback< OnConflictActor, 1, GenerationRegReadReply >;
friend struct ActorCallback< OnConflictActor, 2, Void >;
															#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	OnConflictActor(CoordinatedStateImpl* const& self) 
															#line 2663 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		 : Actor<Void>(),
		   OnConflictActorState<OnConflictActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("onConflict", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14530620195693158400UL, 9294409471953321728UL);
		ActorExecutionContextHelper __helper(static_cast<OnConflictActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("onConflict");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("onConflict", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OnConflictActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OnConflictActor, 1, GenerationRegReadReply >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< OnConflictActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
[[nodiscard]] static Future<Void> onConflict( CoordinatedStateImpl* const& self ) {
															#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	return Future<Void>(new OnConflictActor(self));
															#line 2697 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
}

#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
																#line 2701 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
// This generated class is to be used only via setExclusive()
															#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
template <class SetExclusiveActor>
															#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class SetExclusiveActorState {
															#line 2707 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
															#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	SetExclusiveActorState(CoordinatedStateImpl* const& self,Value const& v) 
															#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
															#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		 : self(self),
															#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   v(v)
															#line 2716 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
	{
		fdb_probe_actor_create("setExclusive", reinterpret_cast<unsigned long>(this));

	}
	~SetExclusiveActorState() 
	{
		fdb_probe_actor_destroy("setExclusive", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 135 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			ASSERT(self->stage == 4);
															#line 136 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			self->stage = 5;
															#line 138 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<UniqueGeneration> __when_expr_0 = self->replicatedWrite( self, GenerationRegWriteRequest(KeyValueRef(self->coordinators.clusterKey, v), self->gen));
															#line 138 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<SetExclusiveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2737 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetExclusiveActor*>(this)->actor_wait_state = 1;
															#line 138 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetExclusiveActor, 0, UniqueGeneration >*>(static_cast<SetExclusiveActor*>(this)));
															#line 2742 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetExclusiveActorState();
		static_cast<SetExclusiveActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(UniqueGeneration const& wgen,int loopDepth) 
	{
															#line 140 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->stage = 6;
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		TraceEvent("CoordinatedStateSet") .detail("Gen", self->gen.generation) .detail("Wgen", wgen.generation) .detail("Genu", self->gen.uid) .detail("Wgenu", wgen.uid) .detail("Cgen", self->conflictGen);
															#line 149 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (wgen == self->gen)
															#line 2769 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 150 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (!static_cast<SetExclusiveActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetExclusiveActorState(); static_cast<SetExclusiveActor*>(this)->destroy(); return 0; }
															#line 2773 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			new (&static_cast<SetExclusiveActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~SetExclusiveActorState();
			static_cast<SetExclusiveActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 152 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			self->conflictGen = std::max(self->conflictGen, wgen.generation);
															#line 153 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			return a_body1Catch1(coordinated_state_conflict(), loopDepth);
															#line 2785 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		}

		return loopDepth;
	}
	int a_body1cont1(UniqueGeneration && wgen,int loopDepth) 
	{
															#line 140 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		self->stage = 6;
															#line 142 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		TraceEvent("CoordinatedStateSet") .detail("Gen", self->gen.generation) .detail("Wgen", wgen.generation) .detail("Genu", self->gen.uid) .detail("Wgenu", wgen.uid) .detail("Cgen", self->conflictGen);
															#line 149 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (wgen == self->gen)
															#line 2798 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 150 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (!static_cast<SetExclusiveActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetExclusiveActorState(); static_cast<SetExclusiveActor*>(this)->destroy(); return 0; }
															#line 2802 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			new (&static_cast<SetExclusiveActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~SetExclusiveActorState();
			static_cast<SetExclusiveActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 152 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			self->conflictGen = std::max(self->conflictGen, wgen.generation);
															#line 153 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			return a_body1Catch1(coordinated_state_conflict(), loopDepth);
															#line 2814 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		}

		return loopDepth;
	}
	int a_body1when1(UniqueGeneration const& wgen,int loopDepth) 
	{
		loopDepth = a_body1cont1(wgen, loopDepth);

		return loopDepth;
	}
	int a_body1when1(UniqueGeneration && wgen,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(wgen), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetExclusiveActor*>(this)->actor_wait_state > 0) static_cast<SetExclusiveActor*>(this)->actor_wait_state = 0;
		static_cast<SetExclusiveActor*>(this)->ActorCallback< SetExclusiveActor, 0, UniqueGeneration >::remove();

	}
	void a_callback_fire(ActorCallback< SetExclusiveActor, 0, UniqueGeneration >*,UniqueGeneration const& value) 
	{
		fdb_probe_actor_enter("setExclusive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetExclusiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setExclusive", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetExclusiveActor, 0, UniqueGeneration >*,UniqueGeneration && value) 
	{
		fdb_probe_actor_enter("setExclusive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetExclusiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setExclusive", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetExclusiveActor, 0, UniqueGeneration >*,Error err) 
	{
		fdb_probe_actor_enter("setExclusive", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetExclusiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setExclusive", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	CoordinatedStateImpl* self;
															#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	Value v;
															#line 2898 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
};
// This generated class is to be used only via setExclusive()
															#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class SetExclusiveActor final : public Actor<Void>, public ActorCallback< SetExclusiveActor, 0, UniqueGeneration >, public FastAllocated<SetExclusiveActor>, public SetExclusiveActorState<SetExclusiveActor> {
															#line 2903 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
	using FastAllocated<SetExclusiveActor>::operator new;
	using FastAllocated<SetExclusiveActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12263359946490332928UL, 2234667480089229312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetExclusiveActor, 0, UniqueGeneration >;
															#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	SetExclusiveActor(CoordinatedStateImpl* const& self,Value const& v) 
															#line 2920 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		 : Actor<Void>(),
		   SetExclusiveActorState<SetExclusiveActor>(self, v),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setExclusive", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(568494211712728320UL, 4222287345987786496UL);
		ActorExecutionContextHelper __helper(static_cast<SetExclusiveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setExclusive");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setExclusive", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetExclusiveActor, 0, UniqueGeneration >*)0, actor_cancelled()); break;
		}

	}
};
															#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
[[nodiscard]] static Future<Void> setExclusive( CoordinatedStateImpl* const& self, Value const& v ) {
															#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	return Future<Void>(new SetExclusiveActor(self, v));
															#line 2952 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
}

#line 156 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"

																#line 2957 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
// This generated class is to be used only via replicatedRead()
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
template <class ReplicatedReadActor>
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class ReplicatedReadActorState {
															#line 2963 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	ReplicatedReadActorState(CoordinatedStateImpl* const& self,GenerationRegReadRequest const& req) 
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		 : self(self),
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   req(req),
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   replicas(self->coordinators.stateServers),
															#line 160 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   rep_empty_reply(),
															#line 161 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   rep_reply()
															#line 2978 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
	{
		fdb_probe_actor_create("replicatedRead", reinterpret_cast<unsigned long>(this));

	}
	~ReplicatedReadActorState() 
	{
		fdb_probe_actor_destroy("replicatedRead", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 162 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			for(int i = 0;i < replicas.size();i++) {
															#line 163 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				Future<GenerationRegReadReply> reply = waitAndSendRead(replicas[i], GenerationRegReadRequest(req.key, req.gen));
															#line 165 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				rep_empty_reply.push_back(nonemptyToNever(reply));
															#line 166 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				rep_reply.push_back(emptyToNever(reply));
															#line 167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				self->ac.add(success(reply));
															#line 3001 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			}
															#line 170 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			majorityEmpty = quorum(rep_empty_reply, (replicas.size() + 1) / 2);
															#line 173 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_0 = quorum(rep_reply, replicas.size() / 2 + 1) || majorityEmpty;
															#line 173 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<ReplicatedReadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3009 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReplicatedReadActor*>(this)->actor_wait_state = 1;
															#line 173 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReplicatedReadActor, 0, Void >*>(static_cast<ReplicatedReadActor*>(this)));
															#line 3014 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReplicatedReadActorState();
		static_cast<ReplicatedReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 175 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (majorityEmpty.isReady())
															#line 3037 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 176 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			int best = -1;
															#line 177 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			for(int i = 0;i < rep_empty_reply.size();i++) {
															#line 178 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				if (rep_empty_reply[i].isReady() && !rep_empty_reply[i].isError())
															#line 3045 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
				{
															#line 179 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
					if (best < 0 || rep_empty_reply[i].get().rgen > rep_empty_reply[best].get().rgen)
															#line 3049 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
					{
															#line 180 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
						best = i;
															#line 3053 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
					}
				}
			}
															#line 182 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			ASSERT(best >= 0);
															#line 183 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			auto result = rep_empty_reply[best].get();
															#line 184 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (!static_cast<ReplicatedReadActor*>(this)->SAV<GenerationRegReadReply>::futures) { (void)(result); this->~ReplicatedReadActorState(); static_cast<ReplicatedReadActor*>(this)->destroy(); return 0; }
															#line 3063 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			new (&static_cast<ReplicatedReadActor*>(this)->SAV< GenerationRegReadReply >::value()) GenerationRegReadReply(result);
			this->~ReplicatedReadActorState();
			static_cast<ReplicatedReadActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 186 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			int best = -1;
															#line 187 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			for(int i = 0;i < rep_reply.size();i++) {
															#line 188 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				if (rep_reply[i].isReady() && !rep_reply[i].isError())
															#line 3077 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
				{
															#line 189 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
					if (best < 0 || rep_reply[i].get().gen > rep_reply[best].get().gen || (rep_reply[i].get().gen == rep_reply[best].get().gen && rep_reply[i].get().rgen > rep_reply[best].get().rgen))
															#line 3081 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
					{
															#line 192 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
						best = i;
															#line 3085 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
					}
				}
			}
															#line 194 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			ASSERT(best >= 0);
															#line 195 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			auto result = rep_reply[best].get();
															#line 196 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (!static_cast<ReplicatedReadActor*>(this)->SAV<GenerationRegReadReply>::futures) { (void)(result); this->~ReplicatedReadActorState(); static_cast<ReplicatedReadActor*>(this)->destroy(); return 0; }
															#line 3095 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			new (&static_cast<ReplicatedReadActor*>(this)->SAV< GenerationRegReadReply >::value()) GenerationRegReadReply(result);
			this->~ReplicatedReadActorState();
			static_cast<ReplicatedReadActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 175 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (majorityEmpty.isReady())
															#line 3108 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 176 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			int best = -1;
															#line 177 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			for(int i = 0;i < rep_empty_reply.size();i++) {
															#line 178 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				if (rep_empty_reply[i].isReady() && !rep_empty_reply[i].isError())
															#line 3116 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
				{
															#line 179 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
					if (best < 0 || rep_empty_reply[i].get().rgen > rep_empty_reply[best].get().rgen)
															#line 3120 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
					{
															#line 180 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
						best = i;
															#line 3124 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
					}
				}
			}
															#line 182 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			ASSERT(best >= 0);
															#line 183 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			auto result = rep_empty_reply[best].get();
															#line 184 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (!static_cast<ReplicatedReadActor*>(this)->SAV<GenerationRegReadReply>::futures) { (void)(result); this->~ReplicatedReadActorState(); static_cast<ReplicatedReadActor*>(this)->destroy(); return 0; }
															#line 3134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			new (&static_cast<ReplicatedReadActor*>(this)->SAV< GenerationRegReadReply >::value()) GenerationRegReadReply(result);
			this->~ReplicatedReadActorState();
			static_cast<ReplicatedReadActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 186 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			int best = -1;
															#line 187 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			for(int i = 0;i < rep_reply.size();i++) {
															#line 188 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				if (rep_reply[i].isReady() && !rep_reply[i].isError())
															#line 3148 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
				{
															#line 189 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
					if (best < 0 || rep_reply[i].get().gen > rep_reply[best].get().gen || (rep_reply[i].get().gen == rep_reply[best].get().gen && rep_reply[i].get().rgen > rep_reply[best].get().rgen))
															#line 3152 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
					{
															#line 192 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
						best = i;
															#line 3156 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
					}
				}
			}
															#line 194 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			ASSERT(best >= 0);
															#line 195 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			auto result = rep_reply[best].get();
															#line 196 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (!static_cast<ReplicatedReadActor*>(this)->SAV<GenerationRegReadReply>::futures) { (void)(result); this->~ReplicatedReadActorState(); static_cast<ReplicatedReadActor*>(this)->destroy(); return 0; }
															#line 3166 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			new (&static_cast<ReplicatedReadActor*>(this)->SAV< GenerationRegReadReply >::value()) GenerationRegReadReply(result);
			this->~ReplicatedReadActorState();
			static_cast<ReplicatedReadActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReplicatedReadActor*>(this)->actor_wait_state > 0) static_cast<ReplicatedReadActor*>(this)->actor_wait_state = 0;
		static_cast<ReplicatedReadActor*>(this)->ActorCallback< ReplicatedReadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplicatedReadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("replicatedRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicatedReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicatedRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReplicatedReadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("replicatedRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicatedReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicatedRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReplicatedReadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("replicatedRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicatedReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicatedRead", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	CoordinatedStateImpl* self;
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	GenerationRegReadRequest req;
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	std::vector<GenerationRegInterface>& replicas;
															#line 160 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	std::vector<Future<GenerationRegReadReply>> rep_empty_reply;
															#line 161 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	std::vector<Future<GenerationRegReadReply>> rep_reply;
															#line 170 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	Future<Void> majorityEmpty;
															#line 3262 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
};
// This generated class is to be used only via replicatedRead()
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class ReplicatedReadActor final : public Actor<GenerationRegReadReply>, public ActorCallback< ReplicatedReadActor, 0, Void >, public FastAllocated<ReplicatedReadActor>, public ReplicatedReadActorState<ReplicatedReadActor> {
															#line 3267 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
	using FastAllocated<ReplicatedReadActor>::operator new;
	using FastAllocated<ReplicatedReadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14927810956299378944UL, 3620264518520994560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<GenerationRegReadReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReplicatedReadActor, 0, Void >;
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	ReplicatedReadActor(CoordinatedStateImpl* const& self,GenerationRegReadRequest const& req) 
															#line 3284 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		 : Actor<GenerationRegReadReply>(),
		   ReplicatedReadActorState<ReplicatedReadActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("replicatedRead", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5729479581140262912UL, 9503690441270471680UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicatedReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("replicatedRead");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("replicatedRead", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReplicatedReadActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
[[nodiscard]] static Future<GenerationRegReadReply> replicatedRead( CoordinatedStateImpl* const& self, GenerationRegReadRequest const& req ) {
															#line 157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	return Future<GenerationRegReadReply>(new ReplicatedReadActor(self, req));
															#line 3316 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
}

#line 199 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"

																#line 3321 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
// This generated class is to be used only via replicatedWrite()
															#line 200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
template <class ReplicatedWriteActor>
															#line 200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class ReplicatedWriteActorState {
															#line 3327 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
															#line 200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	ReplicatedWriteActorState(CoordinatedStateImpl* const& self,GenerationRegWriteRequest const& req) 
															#line 200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
															#line 200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		 : self(self),
															#line 200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   req(req),
															#line 201 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   replicas(self->coordinators.stateServers),
															#line 202 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   wrep_reply()
															#line 3340 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
	{
		fdb_probe_actor_create("replicatedWrite", reinterpret_cast<unsigned long>(this));

	}
	~ReplicatedWriteActorState() 
	{
		fdb_probe_actor_destroy("replicatedWrite", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 203 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			for(int i = 0;i < replicas.size();i++) {
															#line 204 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				Future<UniqueGeneration> reply = waitAndSendWrite(replicas[i], GenerationRegWriteRequest(req.kv, req.gen));
															#line 205 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				wrep_reply.push_back(reply);
															#line 206 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				self->ac.add(success(reply));
															#line 3361 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			}
															#line 209 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_0 = quorum(wrep_reply, self->initial ? replicas.size() : replicas.size() / 2 + 1);
															#line 209 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<ReplicatedWriteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3367 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReplicatedWriteActor*>(this)->actor_wait_state = 1;
															#line 209 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReplicatedWriteActor, 0, Void >*>(static_cast<ReplicatedWriteActor*>(this)));
															#line 3372 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReplicatedWriteActorState();
		static_cast<ReplicatedWriteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		UniqueGeneration maxGen;
															#line 212 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		for(int i = 0;i < wrep_reply.size();i++) {
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (wrep_reply[i].isReady())
															#line 3399 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			{
															#line 214 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				maxGen = std::max(maxGen, wrep_reply[i].get());
															#line 3403 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			}
		}
															#line 215 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (!static_cast<ReplicatedWriteActor*>(this)->SAV<UniqueGeneration>::futures) { (void)(maxGen); this->~ReplicatedWriteActorState(); static_cast<ReplicatedWriteActor*>(this)->destroy(); return 0; }
															#line 3408 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		new (&static_cast<ReplicatedWriteActor*>(this)->SAV< UniqueGeneration >::value()) UniqueGeneration(maxGen);
		this->~ReplicatedWriteActorState();
		static_cast<ReplicatedWriteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		UniqueGeneration maxGen;
															#line 212 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		for(int i = 0;i < wrep_reply.size();i++) {
															#line 213 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (wrep_reply[i].isReady())
															#line 3424 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			{
															#line 214 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				maxGen = std::max(maxGen, wrep_reply[i].get());
															#line 3428 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			}
		}
															#line 215 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (!static_cast<ReplicatedWriteActor*>(this)->SAV<UniqueGeneration>::futures) { (void)(maxGen); this->~ReplicatedWriteActorState(); static_cast<ReplicatedWriteActor*>(this)->destroy(); return 0; }
															#line 3433 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		new (&static_cast<ReplicatedWriteActor*>(this)->SAV< UniqueGeneration >::value()) UniqueGeneration(maxGen);
		this->~ReplicatedWriteActorState();
		static_cast<ReplicatedWriteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReplicatedWriteActor*>(this)->actor_wait_state > 0) static_cast<ReplicatedWriteActor*>(this)->actor_wait_state = 0;
		static_cast<ReplicatedWriteActor*>(this)->ActorCallback< ReplicatedWriteActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplicatedWriteActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("replicatedWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicatedWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicatedWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReplicatedWriteActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("replicatedWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicatedWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicatedWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReplicatedWriteActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("replicatedWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicatedWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replicatedWrite", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	CoordinatedStateImpl* self;
															#line 200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	GenerationRegWriteRequest req;
															#line 201 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	std::vector<GenerationRegInterface>& replicas;
															#line 202 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	std::vector<Future<UniqueGeneration>> wrep_reply;
															#line 3524 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
};
// This generated class is to be used only via replicatedWrite()
															#line 200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class ReplicatedWriteActor final : public Actor<UniqueGeneration>, public ActorCallback< ReplicatedWriteActor, 0, Void >, public FastAllocated<ReplicatedWriteActor>, public ReplicatedWriteActorState<ReplicatedWriteActor> {
															#line 3529 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
	using FastAllocated<ReplicatedWriteActor>::operator new;
	using FastAllocated<ReplicatedWriteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1713066609688300288UL, 10588762747389108736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<UniqueGeneration>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReplicatedWriteActor, 0, Void >;
															#line 200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	ReplicatedWriteActor(CoordinatedStateImpl* const& self,GenerationRegWriteRequest const& req) 
															#line 3546 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		 : Actor<UniqueGeneration>(),
		   ReplicatedWriteActorState<ReplicatedWriteActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("replicatedWrite", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9276545954642284544UL, 3318672836167186688UL);
		ActorExecutionContextHelper __helper(static_cast<ReplicatedWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("replicatedWrite");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("replicatedWrite", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReplicatedWriteActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
[[nodiscard]] static Future<UniqueGeneration> replicatedWrite( CoordinatedStateImpl* const& self, GenerationRegWriteRequest const& req ) {
															#line 200 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	return Future<UniqueGeneration>(new ReplicatedWriteActor(self, req));
															#line 3578 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
}

#line 217 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
};

CoordinatedState::CoordinatedState(ServerCoordinators const& coord)
  : impl(PImpl<CoordinatedStateImpl>::create(coord)) {}
CoordinatedState::~CoordinatedState() = default;
Future<Value> CoordinatedState::read() {
	return CoordinatedStateImpl::read(impl.get());
}
Future<Void> CoordinatedState::onConflict() {
	return CoordinatedStateImpl::onConflict(impl.get());
}
Future<Void> CoordinatedState::setExclusive(Value v) {
	return CoordinatedStateImpl::setExclusive(impl.get(), v);
}
uint64_t CoordinatedState::getConflict() const {
	return impl->getConflict();
}

struct MovableValue {
	enum MoveState { MaybeTo = 1, Active = 2, MovingFrom = 3 };

	Value value;
	int32_t mode;
	Optional<Value> other; // a cluster connection string

	MovableValue() : mode(Active) {}
	MovableValue(Value const& v, int mode, Optional<Value> other = Optional<Value>())
	  : value(v), mode(mode), other(other) {}

	// To change this serialization, ProtocolVersion::MovableCoordinatedStateV2 must be updated, and downgrades need to
	// be considered
	template <class Ar>
	void serialize(Ar& ar) {
		ASSERT(ar.protocolVersion().hasMovableCoordinatedState());
		serializer(ar, value, mode, other);
	}
};

struct MovableCoordinatedStateImpl {
	ServerCoordinators coordinators;
	CoordinatedState cs;
	Optional<Value> lastValue, // The value passed to setExclusive()
	    lastCSValue; // The value passed to cs.setExclusive()

	MovableCoordinatedStateImpl(ServerCoordinators const& c) : coordinators(c), cs(c) {}

																#line 3628 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
// This generated class is to be used only via read()
															#line 263 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
template <class ReadActor1>
															#line 263 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class ReadActor1State {
															#line 3634 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
															#line 263 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	ReadActor1State(MovableCoordinatedStateImpl* const& self) 
															#line 263 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
															#line 263 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		 : self(self),
															#line 264 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   moveState()
															#line 3643 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
	{
		fdb_probe_actor_create("read", reinterpret_cast<unsigned long>(this));

	}
	~ReadActor1State() 
	{
		fdb_probe_actor_destroy("read", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 265 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Value> __when_expr_0 = self->cs.read();
															#line 265 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<ReadActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3660 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadActor1*>(this)->actor_wait_state = 1;
															#line 265 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadActor1, 0, Value >*>(static_cast<ReadActor1*>(this)));
															#line 3665 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadActor1State();
		static_cast<ReadActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Value const& rawValue,int loopDepth) 
	{
															#line 266 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (rawValue.size())
															#line 3688 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 267 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			BinaryReader r(rawValue, IncludeVersion());
															#line 268 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (!r.protocolVersion().hasMovableCoordinatedState())
															#line 3694 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			{
															#line 270 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				moveState.value = rawValue;
															#line 3698 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			}
			else
			{
															#line 272 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				r >> moveState;
															#line 3704 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			}
		}
															#line 276 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (moveState.mode == MovableValue::MaybeTo)
															#line 3709 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			CODE_PROBE(true, "Maybe moveto state");
															#line 278 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			ASSERT(moveState.other.present());
															#line 279 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->moveTo( self, &self->cs, ClusterConnectionString(moveState.other.get().toString()), moveState.value);
															#line 279 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<ReadActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3719 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadActor1*>(this)->actor_wait_state = 2;
															#line 279 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadActor1, 1, Void >*>(static_cast<ReadActor1*>(this)));
															#line 3724 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Value && rawValue,int loopDepth) 
	{
															#line 266 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (rawValue.size())
															#line 3738 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 267 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			BinaryReader r(rawValue, IncludeVersion());
															#line 268 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (!r.protocolVersion().hasMovableCoordinatedState())
															#line 3744 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			{
															#line 270 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				moveState.value = rawValue;
															#line 3748 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			}
			else
			{
															#line 272 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
				r >> moveState;
															#line 3754 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			}
		}
															#line 276 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (moveState.mode == MovableValue::MaybeTo)
															#line 3759 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 277 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			CODE_PROBE(true, "Maybe moveto state");
															#line 278 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			ASSERT(moveState.other.present());
															#line 279 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->moveTo( self, &self->cs, ClusterConnectionString(moveState.other.get().toString()), moveState.value);
															#line 279 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<ReadActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3769 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadActor1*>(this)->actor_wait_state = 2;
															#line 279 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadActor1, 1, Void >*>(static_cast<ReadActor1*>(this)));
															#line 3774 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Value const& rawValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(rawValue, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Value && rawValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(rawValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadActor1*>(this)->actor_wait_state > 0) static_cast<ReadActor1*>(this)->actor_wait_state = 0;
		static_cast<ReadActor1*>(this)->ActorCallback< ReadActor1, 0, Value >::remove();

	}
	void a_callback_fire(ActorCallback< ReadActor1, 0, Value >*,Value const& value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadActor1, 0, Value >*,Value && value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadActor1, 0, Value >*,Error err) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 282 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (!static_cast<ReadActor1*>(this)->SAV<Value>::futures) { (void)(moveState.value); this->~ReadActor1State(); static_cast<ReadActor1*>(this)->destroy(); return 0; }
															#line 3863 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		new (&static_cast<ReadActor1*>(this)->SAV< Value >::value()) Value(moveState.value);
		this->~ReadActor1State();
		static_cast<ReadActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadActor1*>(this)->actor_wait_state > 0) static_cast<ReadActor1*>(this)->actor_wait_state = 0;
		static_cast<ReadActor1*>(this)->ActorCallback< ReadActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 263 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	MovableCoordinatedStateImpl* self;
															#line 264 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	MovableValue moveState;
															#line 3962 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
};
// This generated class is to be used only via read()
															#line 263 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class ReadActor1 final : public Actor<Value>, public ActorCallback< ReadActor1, 0, Value >, public ActorCallback< ReadActor1, 1, Void >, public FastAllocated<ReadActor1>, public ReadActor1State<ReadActor1> {
															#line 3967 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
	using FastAllocated<ReadActor1>::operator new;
	using FastAllocated<ReadActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15422497785423398912UL, 3210475657304951552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Value>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadActor1, 0, Value >;
friend struct ActorCallback< ReadActor1, 1, Void >;
															#line 263 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	ReadActor1(MovableCoordinatedStateImpl* const& self) 
															#line 3985 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		 : Actor<Value>(),
		   ReadActor1State<ReadActor1>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13045688915661361920UL, 7552795543224692992UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("read");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadActor1, 0, Value >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 263 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
[[nodiscard]] static Future<Value> read( MovableCoordinatedStateImpl* const& self ) {
															#line 263 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	return Future<Value>(new ReadActor1(self));
															#line 4018 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
}

#line 284 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"

	Future<Void> onConflict() { return cs.onConflict(); }

	Future<Void> setExclusive(Value v) {
		lastValue = v;
		lastCSValue = BinaryWriter::toValue(MovableValue(v, MovableValue::Active),
		                                    IncludeVersion(ProtocolVersion::withMovableCoordinatedStateV2()));
		return cs.setExclusive(lastCSValue.get());
	}

																#line 4032 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
// This generated class is to be used only via move()
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
template <class MoveActor>
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class MoveActorState {
															#line 4038 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	MoveActorState(MovableCoordinatedStateImpl* const& self,ClusterConnectionString const& nc) 
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		 : self(self),
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   nc(nc),
															#line 299 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   cs(self->coordinators),
															#line 300 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   nccs(ServerCoordinators(makeReference<ClusterConnectionMemoryRecord>(nc))),
															#line 301 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   creationTimeout(delay(30))
															#line 4053 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
	{
		fdb_probe_actor_create("move", reinterpret_cast<unsigned long>(this));

	}
	~MoveActorState() 
	{
		fdb_probe_actor_destroy("move", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 302 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			ASSERT(self->lastValue.present() && self->lastCSValue.present());
															#line 303 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			TraceEvent("StartMove").detail("ConnectionString", nc.toString());
															#line 305 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_0 = creationTimeout;
															#line 304 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<MoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4074 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 308 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Value> __when_expr_1 = nccs.read();
															#line 4078 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<MoveActor*>(this)->actor_wait_state = 1;
															#line 305 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MoveActor, 0, Void >*>(static_cast<MoveActor*>(this)));
															#line 308 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MoveActor, 1, Value >*>(static_cast<MoveActor*>(this)));
															#line 4085 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MoveActorState();
		static_cast<MoveActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 312 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		TraceEvent("FinishedRead").detail("ConnectionString", nc.toString());
															#line 315 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		StrictFuture<Void> __when_expr_2 = creationTimeout;
															#line 314 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (static_cast<MoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4112 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
															#line 318 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		StrictFuture<Void> __when_expr_3 = nccs.setExclusive( BinaryWriter::toValue(MovableValue(self->lastValue.get(), MovableValue::MovingFrom, self->coordinators.ccr->getConnectionString().toString()), IncludeVersion(ProtocolVersion::withMovableCoordinatedStateV2())));
															#line 4116 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1when2(__when_expr_3.get(), loopDepth); };
		static_cast<MoveActor*>(this)->actor_wait_state = 2;
															#line 315 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MoveActor, 2, Void >*>(static_cast<MoveActor*>(this)));
															#line 318 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MoveActor, 3, Void >*>(static_cast<MoveActor*>(this)));
															#line 4123 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
															#line 306 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		return a_body1Catch1(new_coordinators_timed_out(), loopDepth);
															#line 4132 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
															#line 306 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		return a_body1Catch1(new_coordinators_timed_out(), loopDepth);
															#line 4140 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"

		return loopDepth;
	}
	int a_body1when2(Value const& ncInitialValue,int loopDepth) 
	{
															#line 309 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		ASSERT(!ncInitialValue.size());
															#line 4148 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Value && ncInitialValue,int loopDepth) 
	{
															#line 309 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		ASSERT(!ncInitialValue.size());
															#line 4157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MoveActor*>(this)->actor_wait_state > 0) static_cast<MoveActor*>(this)->actor_wait_state = 0;
		static_cast<MoveActor*>(this)->ActorCallback< MoveActor, 0, Void >::remove();
		static_cast<MoveActor*>(this)->ActorCallback< MoveActor, 1, Value >::remove();

	}
	void a_callback_fire(ActorCallback< MoveActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MoveActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MoveActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MoveActor, 1, Value >*,Value const& value) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MoveActor, 1, Value >*,Value && value) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MoveActor, 1, Value >*,Error err) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 325 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (BUGGIFY)
															#line 4287 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 326 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_4 = delay(5);
															#line 326 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<MoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4293 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when1(__when_expr_4.get(), loopDepth); };
			static_cast<MoveActor*>(this)->actor_wait_state = 3;
															#line 326 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MoveActor, 4, Void >*>(static_cast<MoveActor*>(this)));
															#line 4298 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
															#line 316 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		return a_body1Catch1(new_coordinators_timed_out(), loopDepth);
															#line 4312 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
															#line 316 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		return a_body1Catch1(new_coordinators_timed_out(), loopDepth);
															#line 4320 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MoveActor*>(this)->actor_wait_state > 0) static_cast<MoveActor*>(this)->actor_wait_state = 0;
		static_cast<MoveActor*>(this)->ActorCallback< MoveActor, 2, Void >::remove();
		static_cast<MoveActor*>(this)->ActorCallback< MoveActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MoveActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MoveActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MoveActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MoveActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MoveActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 328 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		StrictFuture<Value> __when_expr_5 = cs.read();
															#line 328 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (static_cast<MoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4463 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<MoveActor*>(this)->actor_wait_state = 4;
															#line 328 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< MoveActor, 5, Value >*>(static_cast<MoveActor*>(this)));
															#line 4468 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MoveActor*>(this)->actor_wait_state > 0) static_cast<MoveActor*>(this)->actor_wait_state = 0;
		static_cast<MoveActor*>(this)->ActorCallback< MoveActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MoveActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MoveActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont5(Value const& oldQuorumState,int loopDepth) 
	{
															#line 329 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (oldQuorumState != self->lastCSValue.get())
															#line 4564 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 330 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			CODE_PROBE( true, "Quorum change aborted by concurrent write to old coordination state", probe::decoration::rare);
															#line 332 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			TraceEvent("QuorumChangeAbortedByConcurrency").log();
															#line 333 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			return a_body1Catch1(coordinated_state_conflict(), loopDepth);
															#line 4572 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		}
															#line 336 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->moveTo(self, &cs, nc, self->lastValue.get());
															#line 336 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (static_cast<MoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4578 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont5when1(__when_expr_6.get(), loopDepth); };
		static_cast<MoveActor*>(this)->actor_wait_state = 5;
															#line 336 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MoveActor, 6, Void >*>(static_cast<MoveActor*>(this)));
															#line 4583 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Value && oldQuorumState,int loopDepth) 
	{
															#line 329 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (oldQuorumState != self->lastCSValue.get())
															#line 4592 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 330 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			CODE_PROBE( true, "Quorum change aborted by concurrent write to old coordination state", probe::decoration::rare);
															#line 332 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			TraceEvent("QuorumChangeAbortedByConcurrency").log();
															#line 333 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			return a_body1Catch1(coordinated_state_conflict(), loopDepth);
															#line 4600 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		}
															#line 336 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		StrictFuture<Void> __when_expr_6 = self->moveTo(self, &cs, nc, self->lastValue.get());
															#line 336 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (static_cast<MoveActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4606 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont5when1(__when_expr_6.get(), loopDepth); };
		static_cast<MoveActor*>(this)->actor_wait_state = 5;
															#line 336 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< MoveActor, 6, Void >*>(static_cast<MoveActor*>(this)));
															#line 4611 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Value const& oldQuorumState,int loopDepth) 
	{
		loopDepth = a_body1cont5(oldQuorumState, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Value && oldQuorumState,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(oldQuorumState), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MoveActor*>(this)->actor_wait_state > 0) static_cast<MoveActor*>(this)->actor_wait_state = 0;
		static_cast<MoveActor*>(this)->ActorCallback< MoveActor, 5, Value >::remove();

	}
	void a_callback_fire(ActorCallback< MoveActor, 5, Value >*,Value const& value) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< MoveActor, 5, Value >*,Value && value) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< MoveActor, 5, Value >*,Error err) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 338 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		return a_body1Catch1(coordinators_changed(), loopDepth);
															#line 4695 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 338 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		return a_body1Catch1(coordinators_changed(), loopDepth);
															#line 4703 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MoveActor*>(this)->actor_wait_state > 0) static_cast<MoveActor*>(this)->actor_wait_state = 0;
		static_cast<MoveActor*>(this)->ActorCallback< MoveActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< MoveActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< MoveActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	MovableCoordinatedStateImpl* self;
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	ClusterConnectionString nc;
															#line 299 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	CoordinatedState cs;
															#line 300 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	CoordinatedState nccs;
															#line 301 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	Future<Void> creationTimeout;
															#line 4792 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
};
// This generated class is to be used only via move()
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class MoveActor final : public Actor<Void>, public ActorCallback< MoveActor, 0, Void >, public ActorCallback< MoveActor, 1, Value >, public ActorCallback< MoveActor, 2, Void >, public ActorCallback< MoveActor, 3, Void >, public ActorCallback< MoveActor, 4, Void >, public ActorCallback< MoveActor, 5, Value >, public ActorCallback< MoveActor, 6, Void >, public FastAllocated<MoveActor>, public MoveActorState<MoveActor> {
															#line 4797 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
	using FastAllocated<MoveActor>::operator new;
	using FastAllocated<MoveActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2613100914261081088UL, 12529078697900037632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MoveActor, 0, Void >;
friend struct ActorCallback< MoveActor, 1, Value >;
friend struct ActorCallback< MoveActor, 2, Void >;
friend struct ActorCallback< MoveActor, 3, Void >;
friend struct ActorCallback< MoveActor, 4, Void >;
friend struct ActorCallback< MoveActor, 5, Value >;
friend struct ActorCallback< MoveActor, 6, Void >;
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	MoveActor(MovableCoordinatedStateImpl* const& self,ClusterConnectionString const& nc) 
															#line 4820 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		 : Actor<Void>(),
		   MoveActorState<MoveActor>(self, nc),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("move", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1464667086547104768UL, 10065780536284941312UL);
		ActorExecutionContextHelper __helper(static_cast<MoveActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("move");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("move", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MoveActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MoveActor, 2, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MoveActor, 4, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MoveActor, 5, Value >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MoveActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
[[nodiscard]] static Future<Void> move( MovableCoordinatedStateImpl* const& self, ClusterConnectionString const& nc ) {
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	return Future<Void>(new MoveActor(self, nc));
															#line 4856 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
}

#line 340 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"

																#line 4861 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
// This generated class is to be used only via moveTo()
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
template <class MoveToActor>
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class MoveToActorState {
															#line 4867 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	MoveToActorState(MovableCoordinatedStateImpl* const& self,CoordinatedState* const& coordinatedState,ClusterConnectionString const& nc,Value const& value) 
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		 : self(self),
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   coordinatedState(coordinatedState),
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   nc(nc),
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		   value(value)
															#line 4880 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
	{
		fdb_probe_actor_create("moveTo", reinterpret_cast<unsigned long>(this));

	}
	~MoveToActorState() 
	{
		fdb_probe_actor_destroy("moveTo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 345 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_0 = coordinatedState->setExclusive( BinaryWriter::toValue(MovableValue(value, MovableValue::MaybeTo, nc.toString()), IncludeVersion(ProtocolVersion::withMovableCoordinatedStateV2())));
															#line 345 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<MoveToActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4897 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MoveToActor*>(this)->actor_wait_state = 1;
															#line 345 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MoveToActor, 0, Void >*>(static_cast<MoveToActor*>(this)));
															#line 4902 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MoveToActorState();
		static_cast<MoveToActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 349 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (BUGGIFY)
															#line 4925 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 350 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(5);
															#line 350 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<MoveToActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4931 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MoveToActor*>(this)->actor_wait_state = 2;
															#line 350 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MoveToActor, 1, Void >*>(static_cast<MoveToActor*>(this)));
															#line 4936 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 349 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (BUGGIFY)
															#line 4950 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		{
															#line 350 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(5);
															#line 350 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			if (static_cast<MoveToActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4956 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MoveToActor*>(this)->actor_wait_state = 2;
															#line 350 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MoveToActor, 1, Void >*>(static_cast<MoveToActor*>(this)));
															#line 4961 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MoveToActor*>(this)->actor_wait_state > 0) static_cast<MoveToActor*>(this)->actor_wait_state = 0;
		static_cast<MoveToActor*>(this)->ActorCallback< MoveToActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveToActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("moveTo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveToActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveTo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MoveToActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("moveTo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveToActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveTo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MoveToActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("moveTo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveToActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveTo", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 354 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		TraceEvent("ChangingQuorum").detail("ConnectionString", nc.toString());
															#line 355 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		StrictFuture<Void> __when_expr_2 = ConfigBroadcaster::lockConfigNodes(self->coordinators) && changeLeaderCoordinators(self->coordinators, StringRef(nc.toString()));
															#line 355 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		if (static_cast<MoveToActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5054 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<MoveToActor*>(this)->actor_wait_state = 3;
															#line 355 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MoveToActor, 2, Void >*>(static_cast<MoveToActor*>(this)));
															#line 5059 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MoveToActor*>(this)->actor_wait_state > 0) static_cast<MoveToActor*>(this)->actor_wait_state = 0;
		static_cast<MoveToActor*>(this)->ActorCallback< MoveToActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveToActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("moveTo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveToActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveTo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MoveToActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("moveTo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveToActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveTo", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MoveToActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("moveTo", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveToActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveTo", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 357 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		TraceEvent("ChangedQuorum").detail("ConnectionString", nc.toString());
															#line 358 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		return a_body1Catch1(coordinators_changed(), loopDepth);
															#line 5157 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 357 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		TraceEvent("ChangedQuorum").detail("ConnectionString", nc.toString());
															#line 358 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
		return a_body1Catch1(coordinators_changed(), loopDepth);
															#line 5167 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MoveToActor*>(this)->actor_wait_state > 0) static_cast<MoveToActor*>(this)->actor_wait_state = 0;
		static_cast<MoveToActor*>(this)->ActorCallback< MoveToActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MoveToActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("moveTo", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveToActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveTo", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MoveToActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("moveTo", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MoveToActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveTo", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MoveToActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("moveTo", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MoveToActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("moveTo", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	MovableCoordinatedStateImpl* self;
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	CoordinatedState* coordinatedState;
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	ClusterConnectionString nc;
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	Value value;
															#line 5254 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
};
// This generated class is to be used only via moveTo()
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
class MoveToActor final : public Actor<Void>, public ActorCallback< MoveToActor, 0, Void >, public ActorCallback< MoveToActor, 1, Void >, public ActorCallback< MoveToActor, 2, Void >, public FastAllocated<MoveToActor>, public MoveToActorState<MoveToActor> {
															#line 5259 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
public:
	using FastAllocated<MoveToActor>::operator new;
	using FastAllocated<MoveToActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13348983689625555200UL, 9622940304943673344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MoveToActor, 0, Void >;
friend struct ActorCallback< MoveToActor, 1, Void >;
friend struct ActorCallback< MoveToActor, 2, Void >;
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	MoveToActor(MovableCoordinatedStateImpl* const& self,CoordinatedState* const& coordinatedState,ClusterConnectionString const& nc,Value const& value) 
															#line 5278 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
		 : Actor<Void>(),
		   MoveToActorState<MoveToActor>(self, coordinatedState, nc, value),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("moveTo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8646792263645983232UL, 9019550262175926784UL);
		ActorExecutionContextHelper __helper(static_cast<MoveToActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("moveTo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("moveTo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MoveToActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MoveToActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MoveToActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
[[nodiscard]] static Future<Void> moveTo( MovableCoordinatedStateImpl* const& self, CoordinatedState* const& coordinatedState, ClusterConnectionString const& nc, Value const& value ) {
															#line 341 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
	return Future<Void>(new MoveToActor(self, coordinatedState, nc, value));
															#line 5312 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbserver/CoordinatedState.actor.g.cpp"
}

#line 360 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbserver/CoordinatedState.actor.cpp"
};

MovableCoordinatedState& MovableCoordinatedState::operator=(MovableCoordinatedState&&) = default;
MovableCoordinatedState::MovableCoordinatedState(class ServerCoordinators const& coord)
  : impl(PImpl<MovableCoordinatedStateImpl>::create(coord)) {}
MovableCoordinatedState::~MovableCoordinatedState() = default;
Future<Value> MovableCoordinatedState::read() {
	return MovableCoordinatedStateImpl::read(impl.get());
}
Future<Void> MovableCoordinatedState::onConflict() {
	return impl->onConflict();
}
Future<Void> MovableCoordinatedState::setExclusive(Value v) {
	return impl->setExclusive(v);
}
Future<Void> MovableCoordinatedState::move(ClusterConnectionString const& nc) {
	return MovableCoordinatedStateImpl::move(impl.get(), nc);
}

Optional<Value> updateCCSInMovableValue(ValueRef movableVal, KeyRef oldClusterKey, KeyRef newClusterKey) {
	Optional<Value> result;
	MovableValue moveVal = BinaryReader::fromStringRef<MovableValue>(
	    movableVal, IncludeVersion(ProtocolVersion::withMovableCoordinatedStateV2()));
	if (moveVal.other.present() && moveVal.other.get().startsWith(oldClusterKey)) {
		TraceEvent(SevDebug, "UpdateCCSInMovableValue").detail("OldConnectionString", moveVal.other.get());
		moveVal.other = moveVal.other.get().removePrefix(oldClusterKey).withPrefix(newClusterKey);
		result = BinaryWriter::toValue(moveVal, IncludeVersion(ProtocolVersion::withMovableCoordinatedStateV2()));
	}
	return result;
}
