#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
/*
 * fdbrpc_bench.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <iostream>
#include <boost/program_options.hpp>

#include "flow/flow.h"
#include "flow/Platform.h"
#include "flow/TLSConfig.actor.h"
#include "fdbrpc/fdbrpc.h"
#include "fdbrpc/FlowTransport.h"
#include "flow/actorcompiler.h" // has to be last include

namespace fdbrpc_bench {
NetworkAddress serverAddress;

enum FdbRpcBenchWellKnownEndpoints {
	WLTOKEN_ECHO_SERVER = WLTOKEN_FIRST_AVAILABLE,
	WLTOKEN_COUNT_ENDPOINTS,
};

struct EchoServerInterface {
	constexpr static FileIdentifier file_identifier = 3152015;
	RequestStream<struct GetInterfaceRequest> getInterface;
	RequestStream<struct EchoRequest> echo;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, echo);
	}
};

struct GetInterfaceRequest {
	constexpr static FileIdentifier file_identifier = 12004156;
	ReplyPromise<EchoServerInterface> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, reply);
	}
};

struct EchoRequest {
	constexpr static FileIdentifier file_identifier = 10624019;
	std::string message;
	ReplyPromise<std::string> reply;

	template <class Ar>
	void serialize(Ar& ar) {
		serializer(ar, message, reply);
	}
};

// A sliding window counter over last `size` seconds. Internally uses a vector
// where each entry counts the number of hits each second.
class StatCounter {
public:
	StatCounter(int size = 10) : vals(size) {}

	// Returns the average number of hits per seconds over last `size` seconds.
	int avg() {
		int now_ts = this->now() / 1000; // Convert ms to second.
		int sum = 0;
		for (auto [ts, v] : vals) {
			if (ts < now_ts - vals.size()) // timestamp older than last `size` seconds.
				continue;
			sum += v;
		}
		return sum / vals.size();
	}

	// Increaments the counter by one for current time.
	void inc() {
		int ts = this->now() / 1000;
		int pos = ts % vals.size();

		auto [old_ts, v] = vals[pos];
		if (old_ts < ts) {
			// Timestamp older than last `size` second, so we reset it back.
			vals[pos] = { ts, 1 };
		} else {
			vals[pos] = { old_ts, v + 1 };
		}
	}

private:
	int64_t now() {
		auto n = std::chrono::system_clock::now();
		auto duration = std::chrono::duration_cast<std::chrono::milliseconds>(n.time_since_epoch());
		return duration.count();
	}

	std::vector<std::pair<int64_t, int>> vals;
};

															#line 115 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
// This generated class is to be used only via echoServer()
															#line 113 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
template <class EchoServerActor>
															#line 113 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
class EchoServerActorState {
															#line 121 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
public:
															#line 113 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	EchoServerActorState() 
															#line 113 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
															#line 114 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		 : echoServer(),
															#line 115 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		   c()
															#line 130 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
	{
		fdb_probe_actor_create("echoServer", reinterpret_cast<unsigned long>(this));

	}
	~EchoServerActorState() 
	{
		fdb_probe_actor_destroy("echoServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 116 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			echoServer.getInterface.makeWellKnownEndpoint(WLTOKEN_ECHO_SERVER, TaskPriority::DefaultEndpoint);
															#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			next = delay(10);
															#line 118 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			;
															#line 149 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EchoServerActorState();
		static_cast<EchoServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 121 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			auto __when_expr_0 = echoServer.getInterface.getFuture();
															#line 180 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetInterfaceRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetInterfaceRequest>>::value, "invalid type");
															#line 120 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			if (static_cast<EchoServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 184 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 124 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			auto __when_expr_1 = echoServer.echo.getFuture();
															#line 188 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_1), FutureStream<EchoRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<EchoRequest>>::value, "invalid type");
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
															#line 128 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			StrictFuture<Void> __when_expr_2 = next;
															#line 193 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
			static_cast<EchoServerActor*>(this)->actor_wait_state = 1;
															#line 121 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*>(static_cast<EchoServerActor*>(this)));
															#line 124 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< EchoServerActor, 1, EchoRequest >*>(static_cast<EchoServerActor*>(this)));
															#line 128 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< EchoServerActor, 2, Void >*>(static_cast<EchoServerActor*>(this)));
															#line 202 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 134 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			if (e.code() != error_code_operation_obsolete)
															#line 224 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
			{
															#line 135 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
				fprintf(stderr, "Error: %s\n", e.what());
															#line 136 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 230 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetInterfaceRequest const& req,int loopDepth) 
	{
															#line 122 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		req.reply.send(echoServer);
															#line 252 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetInterfaceRequest && req,int loopDepth) 
	{
															#line 122 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		req.reply.send(echoServer);
															#line 261 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(EchoRequest const& req,int loopDepth) 
	{
															#line 125 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		req.reply.send(req.message);
															#line 126 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		c.inc();
															#line 272 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(EchoRequest && req,int loopDepth) 
	{
															#line 125 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		req.reply.send(req.message);
															#line 126 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		c.inc();
															#line 283 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		next = delay(10);
															#line 130 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		std::cout << "Throughput: " << c.avg() << " req/sec" << std::endl;
															#line 294 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 129 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		next = delay(10);
															#line 130 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		std::cout << "Throughput: " << c.avg() << " req/sec" << std::endl;
															#line 305 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EchoServerActor*>(this)->actor_wait_state > 0) static_cast<EchoServerActor*>(this)->actor_wait_state = 0;
		static_cast<EchoServerActor*>(this)->ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >::remove();
		static_cast<EchoServerActor*>(this)->ActorSingleCallback< EchoServerActor, 1, EchoRequest >::remove();
		static_cast<EchoServerActor*>(this)->ActorCallback< EchoServerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*,GetInterfaceRequest const& value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*,GetInterfaceRequest && value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*,Error err) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 1, EchoRequest >*,EchoRequest const& value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< EchoServerActor, 1, EchoRequest >*,EchoRequest && value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< EchoServerActor, 1, EchoRequest >*,Error err) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EchoServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< EchoServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< EchoServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 114 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	EchoServerInterface echoServer;
															#line 115 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	StatCounter c;
															#line 117 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	Future<Void> next;
															#line 508 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
};
// This generated class is to be used only via echoServer()
															#line 113 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
class EchoServerActor final : public Actor<Void>, public ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >, public ActorSingleCallback< EchoServerActor, 1, EchoRequest >, public ActorCallback< EchoServerActor, 2, Void >, public FastAllocated<EchoServerActor>, public EchoServerActorState<EchoServerActor> {
															#line 513 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
public:
	using FastAllocated<EchoServerActor>::operator new;
	using FastAllocated<EchoServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17114331540361963520UL, 15083685916961087488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >;
friend struct ActorSingleCallback< EchoServerActor, 1, EchoRequest >;
friend struct ActorCallback< EchoServerActor, 2, Void >;
															#line 113 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	EchoServerActor() 
															#line 532 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		 : Actor<Void>(),
		   EchoServerActorState<EchoServerActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("echoServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7060032109465747968UL, 10021521862504165120UL);
		ActorExecutionContextHelper __helper(static_cast<EchoServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("echoServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("echoServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< EchoServerActor, 0, GetInterfaceRequest >*)0, actor_cancelled()); break;
		}

	}
};
															#line 113 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
[[nodiscard]] Future<Void> echoServer(  ) {
															#line 113 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	return Future<Void>(new EchoServerActor());
															#line 564 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
}

#line 141 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"

int payload_size_bytes = 1024 * 10;

std::string randString(int size) {
	const std::string charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
	const int charsetLength = charset.length();
	std::string result;

	// Seed the random number generator
	std::srand(static_cast<unsigned int>(std::time(nullptr)));

	for (int i = 0; i < size; ++i) {
		result += charset[std::rand() % charsetLength];
	}

	return result;
}

															#line 586 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
// This generated class is to be used only via echoClient()
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
template <class EchoClientActor>
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
class EchoClientActorState {
															#line 592 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
public:
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	EchoClientActorState() 
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	{
															#line 598 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		fdb_probe_actor_create("echoClient", reinterpret_cast<unsigned long>(this));

	}
	~EchoClientActorState() 
	{
		fdb_probe_actor_destroy("echoClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 160 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			std::cout << "Starting client. Payload size: " << payload_size_bytes << " bytes" << std::endl;
															#line 161 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			server = EchoServerInterface();
															#line 162 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			server.getInterface = RequestStream<GetInterfaceRequest>(Endpoint::wellKnown({ serverAddress }, WLTOKEN_ECHO_SERVER));
															#line 164 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			StrictFuture<EchoServerInterface> __when_expr_0 = server.getInterface.getReply(GetInterfaceRequest());
															#line 164 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			if (static_cast<EchoClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 620 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<EchoClientActor*>(this)->actor_wait_state = 1;
															#line 164 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< EchoClientActor, 0, EchoServerInterface >*>(static_cast<EchoClientActor*>(this)));
															#line 625 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~EchoClientActorState();
		static_cast<EchoClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(EchoServerInterface const& s,int loopDepth) 
	{
															#line 165 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		server = s;
															#line 166 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		payload = randString(payload_size_bytes);
															#line 168 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		;
															#line 652 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(EchoServerInterface && s,int loopDepth) 
	{
															#line 165 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		server = s;
															#line 166 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		payload = randString(payload_size_bytes);
															#line 168 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		;
															#line 665 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(EchoServerInterface const& s,int loopDepth) 
	{
		loopDepth = a_body1cont1(s, loopDepth);

		return loopDepth;
	}
	int a_body1when1(EchoServerInterface && s,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<EchoClientActor*>(this)->actor_wait_state > 0) static_cast<EchoClientActor*>(this)->actor_wait_state = 0;
		static_cast<EchoClientActor*>(this)->ActorCallback< EchoClientActor, 0, EchoServerInterface >::remove();

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 0, EchoServerInterface >*,EchoServerInterface const& value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 0, EchoServerInterface >*,EchoServerInterface && value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< EchoClientActor, 0, EchoServerInterface >*,Error err) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 169 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		duration_seconds = 10;
															#line 170 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		request_count = 0;
															#line 172 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		start_time = std::chrono::steady_clock::now();
															#line 173 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		end_time = start_time + std::chrono::seconds(duration_seconds);
															#line 176 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		;
															#line 764 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 182 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		std::cout << "Sent " << request_count << " requests in " << request_count / duration_seconds << " /second" << std::endl;
															#line 773 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 176 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		if (!(std::chrono::steady_clock::now() < end_time))
															#line 789 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		{
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 177 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		EchoRequest echoRequest;
															#line 178 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		echoRequest.message = payload;
															#line 179 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = server.echo.getReply(echoRequest);
															#line 179 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		if (static_cast<EchoClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 801 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<EchoClientActor*>(this)->actor_wait_state = 2;
															#line 179 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< EchoClientActor, 1, std::string >*>(static_cast<EchoClientActor*>(this)));
															#line 806 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(std::string const& echoMessage,int loopDepth) 
	{
															#line 180 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		++request_count;
															#line 828 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(std::string && echoMessage,int loopDepth) 
	{
															#line 180 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
		++request_count;
															#line 837 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(std::string const& echoMessage,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(echoMessage, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(std::string && echoMessage,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(std::move(echoMessage), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<EchoClientActor*>(this)->actor_wait_state > 0) static_cast<EchoClientActor*>(this)->actor_wait_state = 0;
		static_cast<EchoClientActor*>(this)->ActorCallback< EchoClientActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< EchoClientActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< EchoClientActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 161 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	EchoServerInterface server;
															#line 166 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	std::string payload;
															#line 169 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	int duration_seconds;
															#line 170 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	int request_count;
															#line 172 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	std::chrono::time_point<std::chrono::steady_clock> start_time;
															#line 173 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	std::chrono::time_point<std::chrono::steady_clock> end_time;
															#line 929 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
};
// This generated class is to be used only via echoClient()
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
class EchoClientActor final : public Actor<Void>, public ActorCallback< EchoClientActor, 0, EchoServerInterface >, public ActorCallback< EchoClientActor, 1, std::string >, public FastAllocated<EchoClientActor>, public EchoClientActorState<EchoClientActor> {
															#line 934 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
public:
	using FastAllocated<EchoClientActor>::operator new;
	using FastAllocated<EchoClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11172343008129739264UL, 407520461466842368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< EchoClientActor, 0, EchoServerInterface >;
friend struct ActorCallback< EchoClientActor, 1, std::string >;
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	EchoClientActor() 
															#line 952 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
		 : Actor<Void>(),
		   EchoClientActorState<EchoClientActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("echoClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9930685301966915072UL, 10766244735779810048UL);
		ActorExecutionContextHelper __helper(static_cast<EchoClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("echoClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("echoClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< EchoClientActor, 0, EchoServerInterface >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< EchoClientActor, 1, std::string >*)0, actor_cancelled()); break;
		}

	}
};
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
[[nodiscard]] Future<Void> echoClient(  ) {
															#line 159 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"
	return Future<Void>(new EchoClientActor());
															#line 985 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbrpc/tests/fdbrpc_bench.actor.g.cpp"
}

#line 186 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbrpc/tests/fdbrpc_bench.actor.cpp"

std::unordered_map<std::string, std::function<Future<Void>()>> actors = {
	{ "server", &echoServer },
	{ "client", &echoClient },
};
} // namespace fdbrpc_bench

int main(int argc, char* argv[]) {
	using namespace fdbrpc_bench;
	namespace po = boost::program_options;

	po::options_description desc("fdbrpc_bench usage");
	// clang-format off
	desc.add_options()
		("help,h","show help message")
		("mode,m", po::value<std::string>(), "process mode [server/client]")
		("payload_size,s", po::value<int>(), "size of payload sent by client (bytes)");
	// clang-format on

	po::variables_map vm;
	po::store(po::parse_command_line(argc, argv, desc), vm);
	po::notify(vm);

	// Check for help option
	if (vm.count("help")) {
		std::cout << desc << std::endl;
		return 0;
	}

	auto errMsg = "invalid arguments provided.\n";
	if (vm.count("mode") == 0) {
		std::cerr << errMsg << desc << std::endl;
		return -1;
	}

	auto mode = vm["mode"].as<std::string>();
	if ((mode != "client" && mode != "server") || (mode == "server" && vm.count("payload_size") > 0)) {
		std::cerr << errMsg << desc << std::endl;
		return -1;
	}

	if (vm.count("payload_size") > 0) {
		payload_size_bytes = vm["payload_size"].as<int>();
	}

	bool isServer = (mode == "server");
	std::string port;
	std::vector<std::function<Future<Void>()>> toRun;
	auto actor = actors.find(mode);
	toRun.push_back(actor->second);

	platformInit();
	g_network = newNet2(TLSConfig(), false, true);
	FlowTransport::createInstance(!isServer, 0, WLTOKEN_COUNT_ENDPOINTS);

	serverAddress = NetworkAddress::parse("127.0.0.1:9001");
	NetworkAddress publicAddress = NetworkAddress::parse("127.0.0.1:9001");

	try {
		if (isServer) {
			auto listenError = FlowTransport::transport().bind(publicAddress, publicAddress);
			if (listenError.isError()) {
				listenError.get();
			}
		}
	} catch (Error& e) {
		std::cout << format("Error while binding to address (%d): %s\n", e.code(), e.what());
	}

	std::vector<Future<Void>> all;
	all.reserve(toRun.size());
	for (auto& f : toRun) {
		all.emplace_back(f());
	}

	auto f = stopAfter(waitForAll(all));
	g_network->run();

	return 0;
}
