#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
/*
 * AdvanceVersionCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "boost/lexical_cast.hpp"
#include "fmt/format.h"
#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/IClientApi.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

const KeyRef advanceVersionSpecialKey = "\xff\xff/management/min_required_commit_version"_sr;

															#line 38 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
// This generated class is to be used only via advanceVersionCommandActor()
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
template <class AdvanceVersionCommandActorActor>
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
class AdvanceVersionCommandActorActorState {
															#line 44 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
public:
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
	AdvanceVersionCommandActorActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
		 : db(db),
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
		   tokens(tokens)
															#line 53 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~AdvanceVersionCommandActorActorState() 
	{
		fdb_probe_actor_destroy("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 37 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			if (tokens.size() != 2)
															#line 68 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
			{
															#line 38 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 39 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
				if (!static_cast<AdvanceVersionCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~AdvanceVersionCommandActorActorState(); static_cast<AdvanceVersionCommandActorActor*>(this)->destroy(); return 0; }
															#line 74 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
				new (&static_cast<AdvanceVersionCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~AdvanceVersionCommandActorActorState();
				static_cast<AdvanceVersionCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 41 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
				v = Version();
															#line 42 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
				int n = 0;
															#line 43 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
				if (sscanf(tokens[1].toString().c_str(), "%" PRId64 "%n", &v, &n) != 1 || n != tokens[1].size())
															#line 88 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
				{
															#line 44 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 45 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
					if (!static_cast<AdvanceVersionCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~AdvanceVersionCommandActorActorState(); static_cast<AdvanceVersionCommandActorActor*>(this)->destroy(); return 0; }
															#line 94 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
					new (&static_cast<AdvanceVersionCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
					this->~AdvanceVersionCommandActorActorState();
					static_cast<AdvanceVersionCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 47 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
					tr = db->createTransaction();
															#line 48 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
					;
															#line 106 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
					loopDepth = a_body1loopHead1(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AdvanceVersionCommandActorActorState();
		static_cast<AdvanceVersionCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 49 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 138 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
		try {
															#line 51 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			StrictFuture<Version> __when_expr_0 = safeThreadFutureToFuture(tr->getReadVersion());
															#line 51 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			if (static_cast<AdvanceVersionCommandActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 144 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<AdvanceVersionCommandActorActor*>(this)->actor_wait_state = 1;
															#line 51 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionCommandActorActor, 0, Version >*>(static_cast<AdvanceVersionCommandActorActor*>(this)));
															#line 149 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 60 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 60 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			if (static_cast<AdvanceVersionCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 173 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<AdvanceVersionCommandActorActor*>(this)->actor_wait_state = 3;
															#line 60 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionCommandActorActor, 2, Void >*>(static_cast<AdvanceVersionCommandActorActor*>(this)));
															#line 178 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version const& rv,int loopDepth) 
	{
															#line 52 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
		if (rv <= v)
															#line 193 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
		{
															#line 53 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			tr->set(advanceVersionSpecialKey, boost::lexical_cast<std::string>(v));
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			if (static_cast<AdvanceVersionCommandActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 201 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<AdvanceVersionCommandActorActor*>(this)->actor_wait_state = 2;
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionCommandActorActor, 1, Void >*>(static_cast<AdvanceVersionCommandActorActor*>(this)));
															#line 206 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 56 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			fmt::print("Current read version is {}\n", rv);
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			if (!static_cast<AdvanceVersionCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~AdvanceVersionCommandActorActorState(); static_cast<AdvanceVersionCommandActorActor*>(this)->destroy(); return 0; }
															#line 215 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
			new (&static_cast<AdvanceVersionCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
			this->~AdvanceVersionCommandActorActorState();
			static_cast<AdvanceVersionCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Version && rv,int loopDepth) 
	{
															#line 52 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
		if (rv <= v)
															#line 228 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
		{
															#line 53 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			tr->set(advanceVersionSpecialKey, boost::lexical_cast<std::string>(v));
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->commit());
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			if (static_cast<AdvanceVersionCommandActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 236 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<AdvanceVersionCommandActorActor*>(this)->actor_wait_state = 2;
															#line 54 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AdvanceVersionCommandActorActor, 1, Void >*>(static_cast<AdvanceVersionCommandActorActor*>(this)));
															#line 241 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 56 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			fmt::print("Current read version is {}\n", rv);
															#line 57 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
			if (!static_cast<AdvanceVersionCommandActorActor*>(this)->SAV<bool>::futures) { (void)(true); this->~AdvanceVersionCommandActorActorState(); static_cast<AdvanceVersionCommandActorActor*>(this)->destroy(); return 0; }
															#line 250 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
			new (&static_cast<AdvanceVersionCommandActorActor*>(this)->SAV< bool >::value()) bool(true);
			this->~AdvanceVersionCommandActorActorState();
			static_cast<AdvanceVersionCommandActorActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& rv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(rv, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && rv,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(rv), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AdvanceVersionCommandActorActor*>(this)->actor_wait_state > 0) static_cast<AdvanceVersionCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<AdvanceVersionCommandActorActor*>(this)->ActorCallback< AdvanceVersionCommandActorActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< AdvanceVersionCommandActorActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AdvanceVersionCommandActorActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AdvanceVersionCommandActorActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AdvanceVersionCommandActorActor*>(this)->actor_wait_state > 0) static_cast<AdvanceVersionCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<AdvanceVersionCommandActorActor*>(this)->ActorCallback< AdvanceVersionCommandActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdvanceVersionCommandActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AdvanceVersionCommandActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AdvanceVersionCommandActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<AdvanceVersionCommandActorActor*>(this)->actor_wait_state > 0) static_cast<AdvanceVersionCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<AdvanceVersionCommandActorActor*>(this)->ActorCallback< AdvanceVersionCommandActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< AdvanceVersionCommandActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< AdvanceVersionCommandActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< AdvanceVersionCommandActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 41 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
	Version v;
															#line 47 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 535 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
};
// This generated class is to be used only via advanceVersionCommandActor()
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
class AdvanceVersionCommandActorActor final : public Actor<bool>, public ActorCallback< AdvanceVersionCommandActorActor, 0, Version >, public ActorCallback< AdvanceVersionCommandActorActor, 1, Void >, public ActorCallback< AdvanceVersionCommandActorActor, 2, Void >, public FastAllocated<AdvanceVersionCommandActorActor>, public AdvanceVersionCommandActorActorState<AdvanceVersionCommandActorActor> {
															#line 540 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
public:
	using FastAllocated<AdvanceVersionCommandActorActor>::operator new;
	using FastAllocated<AdvanceVersionCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12429504370807988736UL, 5889114291783815424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AdvanceVersionCommandActorActor, 0, Version >;
friend struct ActorCallback< AdvanceVersionCommandActorActor, 1, Void >;
friend struct ActorCallback< AdvanceVersionCommandActorActor, 2, Void >;
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
	AdvanceVersionCommandActorActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 559 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
		 : Actor<bool>(),
		   AdvanceVersionCommandActorActorState<AdvanceVersionCommandActorActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16112156182182856704UL, 10134831721763923968UL);
		ActorExecutionContextHelper __helper(static_cast<AdvanceVersionCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("advanceVersionCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("advanceVersionCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AdvanceVersionCommandActorActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AdvanceVersionCommandActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< AdvanceVersionCommandActorActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
[[nodiscard]] Future<bool> advanceVersionCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 36 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"
	return Future<bool>(new AdvanceVersionCommandActorActor(db, tokens));
															#line 593 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/build_output/fdbcli/AdvanceVersionCommand.actor.g.cpp"
}

#line 66 "/codebuild/output/src387719887/src/github.com/apple/foundationdb/fdbcli/AdvanceVersionCommand.actor.cpp"

CommandFactory advanceVersionFactory(
    "advanceversion",
    CommandHelp(
        "advanceversion <VERSION>",
        "Force the cluster to recover at the specified version",
        "Forces the cluster to recover at the specified version. If the specified version is larger than the current "
        "version of the cluster, the cluster version is advanced "
        "to the specified version via a forced recovery."));
} // namespace fdb_cli
