#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
/*
 * WriteDuringRead.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "flow/ActorCollection.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbclient/Atomic.h"
#include "flow/ApiVersion.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct WriteDuringReadWorkload : TestWorkload {
	static constexpr auto NAME = "WriteDuringRead";

	double testDuration, slowModeStart;
	int numOps;
	bool rarelyCommit, adjacentKeys;
	PerfIntCounter transactions, retries;
	std::map<Key, Value> memoryDatabase;
	std::map<Key, Value> lastCommittedDatabase;
	KeyRangeMap<int> changeCount;
	int minNode, nodes;
	double initialKeyDensity;
	AsyncTrigger finished;
	KeyRange conflictRange;
	std::pair<int, int> valueSizeRange;
	int maxClearSize;
	CoalescedKeyRangeMap<bool> addedConflicts;
	bool useSystemKeys;
	std::string keyPrefix;
	int64_t maximumTotalData;
	int64_t maximumDataWritten;

	int64_t dataWritten = 0;

	bool success;
	Database extraDB;
	bool useExtraDB;
	double zeroPaddingRatio;

	WriteDuringReadWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), transactions("Transactions"), retries("Retries"), success(true) {
		testDuration = getOption(options, "testDuration"_sr, 60.0);
		slowModeStart = getOption(options, "slowModeStart"_sr, 1000.0);
		numOps = getOption(options, "numOps"_sr, 21);
		rarelyCommit = getOption(options, "rarelyCommit"_sr, false);
		maximumTotalData = getOption(options, "maximumTotalData"_sr, 3e6);
		maximumDataWritten = getOption(options, "maximumDataWritten"_sr, std::numeric_limits<int64_t>::max());
		minNode = getOption(options, "minNode"_sr, 0);
		useSystemKeys = getOption(options, "useSystemKeys"_sr, deterministicRandom()->random01() < 0.5);
		zeroPaddingRatio = getOption(options, "zeroPaddingRatio"_sr, 0.15);
		adjacentKeys = deterministicRandom()->random01() < 0.5;
		initialKeyDensity = deterministicRandom()->random01(); // This fraction of keys are present before the first
		                                                       // transaction (and after an unknown result)
		valueSizeRange = std::make_pair(
		    0,
		    std::min<int>(deterministicRandom()->randomInt(0, 4 << deterministicRandom()->randomInt(0, 16)),
		                  CLIENT_KNOBS->VALUE_SIZE_LIMIT * 1.2));
		if (adjacentKeys) {
			nodes = std::min<int64_t>(deterministicRandom()->randomInt(1, 4 << deterministicRandom()->randomInt(0, 14)),
			                          CLIENT_KNOBS->KEY_SIZE_LIMIT * 1.2);
		} else {
			nodes = deterministicRandom()->randomInt(1, 4 << deterministicRandom()->randomInt(0, 20));
		}

		dataWritten = 0;
		int newNodes = std::min<int>(nodes, maximumTotalData / (getKeyForIndex(nodes).size() + valueSizeRange.second));
		minNode = std::max(minNode, nodes - newNodes);
		nodes = newNodes;

		CODE_PROBE(adjacentKeys && (nodes + minNode) > CLIENT_KNOBS->KEY_SIZE_LIMIT,
		           "WriteDuringReadWorkload testing large keys");

		useExtraDB = g_network->isSimulated() && !g_simulator->extraDatabases.empty();
		if (useExtraDB) {
			ASSERT(g_simulator->extraDatabases.size() == 1);
			extraDB = Database::createSimulatedExtraDatabase(g_simulator->extraDatabases[0]);
			useSystemKeys = false;
		}

		if (useSystemKeys && deterministicRandom()->random01() < 0.5) {
			keyPrefix = "\xff\x01";
		} else {
			keyPrefix = "\x02";
		}

		maxClearSize = 1 << deterministicRandom()->randomInt(0, 20);
		conflictRange = KeyRangeRef("\xfe"_sr, "\xfe\x00"_sr);
		if (clientId == 0)
			TraceEvent("RYWConfiguration")
			    .detail("Nodes", nodes)
			    .detail("InitialKeyDensity", initialKeyDensity)
			    .detail("AdjacentKeys", adjacentKeys)
			    .detail("ValueSizeMin", valueSizeRange.first)
			    .detail("ValueSizeMax", valueSizeRange.second)
			    .detail("MaxClearSize", maxClearSize);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId == 0)
			return loadAndRun(cx, this);
		return Void();
	}

	Future<bool> check(Database const& cx) override { return success; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(transactions.getMetric());
		m.push_back(retries.getMetric());
	}

	Key memoryGetKey(std::map<Key, Value>* db, KeySelector key) const {
		std::map<Key, Value>::iterator iter;
		if (key.orEqual)
			iter = db->upper_bound(key.getKey());
		else
			iter = db->lower_bound(key.getKey());

		int offset = key.offset - 1;
		while (offset > 0) {
			if (iter == db->end())
				return useSystemKeys ? allKeys.end : normalKeys.end;
			++iter;
			--offset;
		}
		while (offset < 0) {
			if (iter == db->begin())
				return allKeys.begin;
			--iter;
			++offset;
		}
		if (iter == db->end())
			return useSystemKeys ? allKeys.end : normalKeys.end;
		return iter->first;
	}

																#line 161 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
// This generated class is to be used only via getKeyAndCompare()
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class GetKeyAndCompareActor>
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class GetKeyAndCompareActorState {
															#line 167 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	GetKeyAndCompareActorState(ReadYourWritesTransaction* const& tr,KeySelector const& key,Snapshot const& snapshot,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : tr(tr),
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   key(key),
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshot(snapshot),
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readYourWritesDisabled(readYourWritesDisabled),
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshotRYWDisabled(snapshotRYWDisabled),
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   self(self),
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   doingCommit(doingCommit),
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   memLimit(memLimit),
															#line 167 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID())
															#line 190 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getKeyAndCompare", reinterpret_cast<unsigned long>(this));

	}
	~GetKeyAndCompareActorState() 
	{
		fdb_probe_actor_destroy("getKeyAndCompare", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 170 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				memRes = self->memoryGetKey(readYourWritesDisabled || (snapshot && snapshotRYWDisabled) ? &self->lastCommittedDatabase : &self->memoryDatabase, key);
															#line 174 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				*memLimit -= memRes.expectedSize();
															#line 175 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				StrictFuture<Key> __when_expr_0 = tr->getKey(key, snapshot);
															#line 175 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (static_cast<GetKeyAndCompareActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 212 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetKeyAndCompareActor*>(this)->actor_wait_state = 1;
															#line 175 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetKeyAndCompareActor, 0, Key >*>(static_cast<GetKeyAndCompareActor*>(this)));
															#line 217 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetKeyAndCompareActorState();
		static_cast<GetKeyAndCompareActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 193 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_used_during_commit)
															#line 247 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 194 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				ASSERT(*doingCommit);
															#line 195 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<GetKeyAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetKeyAndCompareActorState(); static_cast<GetKeyAndCompareActor*>(this)->destroy(); return 0; }
															#line 253 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				new (&static_cast<GetKeyAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetKeyAndCompareActorState();
				static_cast<GetKeyAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 196 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (e.code() == error_code_transaction_cancelled)
															#line 263 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 197 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<GetKeyAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetKeyAndCompareActorState(); static_cast<GetKeyAndCompareActor*>(this)->destroy(); return 0; }
															#line 267 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					new (&static_cast<GetKeyAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetKeyAndCompareActorState();
					static_cast<GetKeyAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 198 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 276 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Key const& _res,int loopDepth) 
	{
															#line 176 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		Key res = _res;
															#line 177 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*memLimit += memRes.expectedSize();
															#line 178 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (self->useSystemKeys && res > self->getKeyForIndex(self->nodes))
															#line 294 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 179 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			res = allKeys.end;
															#line 298 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 180 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (res != memRes)
															#line 302 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 181 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRGetKeyWrongResult", randomID) .detail("Key", key.getKey()) .detail("Offset", key.offset) .detail("OrEqual", key.orEqual) .detail("Snapshot", snapshot) .detail("MemoryResult", memRes) .detail("DbResult", res);
															#line 188 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			self->success = false;
															#line 308 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 190 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<GetKeyAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetKeyAndCompareActorState(); static_cast<GetKeyAndCompareActor*>(this)->destroy(); return 0; }
															#line 312 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		new (&static_cast<GetKeyAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetKeyAndCompareActorState();
		static_cast<GetKeyAndCompareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Key && _res,int loopDepth) 
	{
															#line 176 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		Key res = _res;
															#line 177 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*memLimit += memRes.expectedSize();
															#line 178 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (self->useSystemKeys && res > self->getKeyForIndex(self->nodes))
															#line 328 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 179 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			res = allKeys.end;
															#line 332 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 180 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (res != memRes)
															#line 336 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 181 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRGetKeyWrongResult", randomID) .detail("Key", key.getKey()) .detail("Offset", key.offset) .detail("OrEqual", key.orEqual) .detail("Snapshot", snapshot) .detail("MemoryResult", memRes) .detail("DbResult", res);
															#line 188 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			self->success = false;
															#line 342 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 190 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<GetKeyAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetKeyAndCompareActorState(); static_cast<GetKeyAndCompareActor*>(this)->destroy(); return 0; }
															#line 346 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		new (&static_cast<GetKeyAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetKeyAndCompareActorState();
		static_cast<GetKeyAndCompareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Key const& _res,int loopDepth) 
	{
		loopDepth = a_body1cont2(_res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Key && _res,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetKeyAndCompareActor*>(this)->actor_wait_state > 0) static_cast<GetKeyAndCompareActor*>(this)->actor_wait_state = 0;
		static_cast<GetKeyAndCompareActor*>(this)->ActorCallback< GetKeyAndCompareActor, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< GetKeyAndCompareActor, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("getKeyAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetKeyAndCompareActor, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("getKeyAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetKeyAndCompareActor, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("getKeyAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getKeyAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	ReadYourWritesTransaction* tr;
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	KeySelector key;
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Snapshot snapshot;
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readYourWritesDisabled;
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool snapshotRYWDisabled;
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool* doingCommit;
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t* memLimit;
															#line 167 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	UID randomID;
															#line 170 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Key memRes;
															#line 449 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getKeyAndCompare()
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class GetKeyAndCompareActor final : public Actor<Void>, public ActorCallback< GetKeyAndCompareActor, 0, Key >, public FastAllocated<GetKeyAndCompareActor>, public GetKeyAndCompareActorState<GetKeyAndCompareActor> {
															#line 454 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetKeyAndCompareActor>::operator new;
	using FastAllocated<GetKeyAndCompareActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12641716183420190976UL, 11886766005067674112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetKeyAndCompareActor, 0, Key >;
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	GetKeyAndCompareActor(ReadYourWritesTransaction* const& tr,KeySelector const& key,Snapshot const& snapshot,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 471 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetKeyAndCompareActorState<GetKeyAndCompareActor>(tr, key, snapshot, readYourWritesDisabled, snapshotRYWDisabled, self, doingCommit, memLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getKeyAndCompare", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8149137736939811840UL, 1143147249212726528UL);
		ActorExecutionContextHelper __helper(static_cast<GetKeyAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getKeyAndCompare");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getKeyAndCompare", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetKeyAndCompareActor, 0, Key >*)0, actor_cancelled()); break;
		}

	}
};
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> getKeyAndCompare( ReadYourWritesTransaction* const& tr, KeySelector const& key, Snapshot const& snapshot, bool const& readYourWritesDisabled, bool const& snapshotRYWDisabled, WriteDuringReadWorkload* const& self, bool* const& doingCommit, int64_t* const& memLimit ) {
															#line 159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new GetKeyAndCompareActor(tr, key, snapshot, readYourWritesDisabled, snapshotRYWDisabled, self, doingCommit, memLimit));
															#line 503 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
}

#line 201 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

	Standalone<VectorRef<KeyValueRef>> memoryGetRange(std::map<Key, Value>* db,
	                                                  KeySelector begin,
	                                                  KeySelector end,
	                                                  GetRangeLimits limit,
	                                                  Reverse reverse) {
		Key beginKey = memoryGetKey(db, begin);
		Key endKey = memoryGetKey(db, end);
		//TraceEvent("WDRGetRange").detail("Begin", beginKey).detail("End", endKey);
		if (beginKey >= endKey)
			return Standalone<VectorRef<KeyValueRef>>();

		auto beginIter = db->lower_bound(beginKey);
		auto endIter = db->lower_bound(endKey);

		Standalone<VectorRef<KeyValueRef>> results;
		if (reverse) {
			loop {
				if (beginIter == endIter || limit.reachedBy(results))
					break;

				--endIter;
				results.push_back_deep(results.arena(), KeyValueRef(endIter->first, endIter->second));
			}
		} else {
			for (; beginIter != endIter && !limit.reachedBy(results); ++beginIter)
				results.push_back_deep(results.arena(), KeyValueRef(beginIter->first, beginIter->second));
		}
		return results;
	}

																#line 538 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
// This generated class is to be used only via getRangeAndCompare()
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class GetRangeAndCompareActor>
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class GetRangeAndCompareActorState {
															#line 544 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	GetRangeAndCompareActorState(ReadYourWritesTransaction* const& tr,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limit,Snapshot const& snapshot,Reverse const& reverse,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : tr(tr),
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   begin(begin),
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   end(end),
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   limit(limit),
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshot(snapshot),
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   reverse(reverse),
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readYourWritesDisabled(readYourWritesDisabled),
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshotRYWDisabled(snapshotRYWDisabled),
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   self(self),
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   doingCommit(doingCommit),
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   memLimit(memLimit),
															#line 243 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID())
															#line 573 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getRangeAndCompare", reinterpret_cast<unsigned long>(this));

	}
	~GetRangeAndCompareActorState() 
	{
		fdb_probe_actor_destroy("getRangeAndCompare", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 250 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				memRes = self->memoryGetRange( readYourWritesDisabled || (snapshot && snapshotRYWDisabled) ? &self->lastCommittedDatabase : &self->memoryDatabase, begin, end, limit, reverse);
															#line 257 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				*memLimit -= memRes.expectedSize();
															#line 258 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				StrictFuture<RangeResult> __when_expr_0 = tr->getRange(begin, end, limit, snapshot, reverse);
															#line 258 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (static_cast<GetRangeAndCompareActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 595 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetRangeAndCompareActor*>(this)->actor_wait_state = 1;
															#line 258 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRangeAndCompareActor, 0, RangeResult >*>(static_cast<GetRangeAndCompareActor*>(this)));
															#line 600 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRangeAndCompareActorState();
		static_cast<GetRangeAndCompareActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 384 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_used_during_commit)
															#line 630 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 385 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				ASSERT(*doingCommit);
															#line 386 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 636 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetRangeAndCompareActorState();
				static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 387 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (e.code() == error_code_transaction_cancelled)
															#line 646 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 388 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 650 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetRangeAndCompareActorState();
					static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 389 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 659 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(RangeResult const& _res,int loopDepth) 
	{
															#line 259 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		RangeResult res = _res;
															#line 260 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*memLimit += memRes.expectedSize();
															#line 262 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		int systemKeyCount = 0;
															#line 263 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		bool resized = false;
															#line 264 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (self->useSystemKeys)
															#line 681 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 265 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (!reverse)
															#line 685 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 266 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				int newSize = std::lower_bound( res.begin(), res.end(), self->getKeyForIndex(self->nodes), KeyValueRef::OrderByKey()) - res.begin();
															#line 270 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (newSize != res.size())
															#line 691 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 271 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					res.resize(res.arena(), newSize);
															#line 272 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					resized = true;
															#line 697 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 275 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				for(;systemKeyCount < res.size();systemKeyCount++) {
															#line 276 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (res[systemKeyCount].key < self->getKeyForIndex(self->nodes))
															#line 706 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					{
						break;
					}
				}
															#line 278 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (systemKeyCount > 0)
															#line 713 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 279 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					res = RangeResultRef(VectorRef<KeyValueRef>(&res[systemKeyCount], res.size() - systemKeyCount), true);
															#line 281 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					resized = true;
															#line 719 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				}
			}
		}
															#line 286 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!limit.hasByteLimit() && systemKeyCount == 0)
															#line 725 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 287 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (res.size() != memRes.size())
															#line 729 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 288 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("MemorySize", memRes.size()) .detail("DbSize", res.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled);
															#line 303 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				self->success = false;
															#line 304 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 737 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetRangeAndCompareActorState();
				static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 307 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 308 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (res[i] != memRes[i])
															#line 747 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 309 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("Size", memRes.size()) .detail("WrongLocation", i) .detail("MemoryResultKey", memRes[i].key) .detail("DbResultKey", res[i].key) .detail("MemoryResultValueSize", memRes[i].value.size()) .detail("DbResultValueSize", res[i].value.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled);
															#line 327 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					self->success = false;
															#line 328 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 755 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetRangeAndCompareActorState();
					static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
		else
		{
															#line 332 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (res.size() > memRes.size() || (res.size() < memRes.size() && !res.more) || (res.size() == 0 && res.more && !resized))
															#line 767 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 334 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("MemorySize", memRes.size()) .detail("DbSize", res.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled) .detail("More", res.more) .detail("SystemKeyCount", systemKeyCount);
															#line 351 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				self->success = false;
															#line 352 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 775 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetRangeAndCompareActorState();
				static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 355 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 356 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (res[i] != memRes[i])
															#line 785 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 357 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("Size", memRes.size()) .detail("WrongLocation", i) .detail("MemoryResultKey", memRes[i].key) .detail("DbResultKey", res[i].key) .detail("MemoryResultValueSize", memRes[i].value.size()) .detail("DbResultValueSize", res[i].value.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled) .detail("More", res.more);
															#line 376 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					self->success = false;
															#line 377 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 793 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetRangeAndCompareActorState();
					static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 381 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 803 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeAndCompareActorState();
		static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(RangeResult && _res,int loopDepth) 
	{
															#line 259 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		RangeResult res = _res;
															#line 260 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*memLimit += memRes.expectedSize();
															#line 262 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		int systemKeyCount = 0;
															#line 263 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		bool resized = false;
															#line 264 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (self->useSystemKeys)
															#line 823 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 265 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (!reverse)
															#line 827 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 266 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				int newSize = std::lower_bound( res.begin(), res.end(), self->getKeyForIndex(self->nodes), KeyValueRef::OrderByKey()) - res.begin();
															#line 270 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (newSize != res.size())
															#line 833 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 271 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					res.resize(res.arena(), newSize);
															#line 272 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					resized = true;
															#line 839 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				}
			}
			else
			{
															#line 275 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				for(;systemKeyCount < res.size();systemKeyCount++) {
															#line 276 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (res[systemKeyCount].key < self->getKeyForIndex(self->nodes))
															#line 848 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					{
						break;
					}
				}
															#line 278 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (systemKeyCount > 0)
															#line 855 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 279 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					res = RangeResultRef(VectorRef<KeyValueRef>(&res[systemKeyCount], res.size() - systemKeyCount), true);
															#line 281 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					resized = true;
															#line 861 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				}
			}
		}
															#line 286 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!limit.hasByteLimit() && systemKeyCount == 0)
															#line 867 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 287 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (res.size() != memRes.size())
															#line 871 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 288 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("MemorySize", memRes.size()) .detail("DbSize", res.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled);
															#line 303 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				self->success = false;
															#line 304 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 879 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetRangeAndCompareActorState();
				static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 307 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 308 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (res[i] != memRes[i])
															#line 889 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 309 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("Size", memRes.size()) .detail("WrongLocation", i) .detail("MemoryResultKey", memRes[i].key) .detail("DbResultKey", res[i].key) .detail("MemoryResultValueSize", memRes[i].value.size()) .detail("DbResultValueSize", res[i].value.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled);
															#line 327 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					self->success = false;
															#line 328 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 897 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetRangeAndCompareActorState();
					static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
		else
		{
															#line 332 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (res.size() > memRes.size() || (res.size() < memRes.size() && !res.more) || (res.size() == 0 && res.more && !resized))
															#line 909 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 334 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("MemorySize", memRes.size()) .detail("DbSize", res.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled) .detail("More", res.more) .detail("SystemKeyCount", systemKeyCount);
															#line 351 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				self->success = false;
															#line 352 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 917 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetRangeAndCompareActorState();
				static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 355 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			for(int i = 0;i < res.size();i++) {
															#line 356 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (res[i] != memRes[i])
															#line 927 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 357 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					TraceEvent(SevError, "WDRGetRangeWrongResult", randomID) .detail("BeginKey", begin.getKey()) .detail("BeginOffset", begin.offset) .detail("BeginOrEqual", begin.orEqual) .detail("EndKey", end.getKey()) .detail("EndOffset", end.offset) .detail("EndOrEqual", end.orEqual) .detail("LimitRows", limit.rows) .detail("LimitBytes", limit.bytes) .detail("Snapshot", snapshot) .detail("Reverse", reverse) .detail("Size", memRes.size()) .detail("WrongLocation", i) .detail("MemoryResultKey", memRes[i].key) .detail("DbResultKey", res[i].key) .detail("MemoryResultValueSize", memRes[i].value.size()) .detail("DbResultValueSize", res[i].value.size()) .detail("ReadYourWritesDisabled", readYourWritesDisabled) .detail("More", res.more);
															#line 376 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					self->success = false;
															#line 377 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 935 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetRangeAndCompareActorState();
					static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
		}
															#line 381 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<GetRangeAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetRangeAndCompareActorState(); static_cast<GetRangeAndCompareActor*>(this)->destroy(); return 0; }
															#line 945 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		new (&static_cast<GetRangeAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetRangeAndCompareActorState();
		static_cast<GetRangeAndCompareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& _res,int loopDepth) 
	{
		loopDepth = a_body1cont2(_res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && _res,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRangeAndCompareActor*>(this)->actor_wait_state > 0) static_cast<GetRangeAndCompareActor*>(this)->actor_wait_state = 0;
		static_cast<GetRangeAndCompareActor*>(this)->ActorCallback< GetRangeAndCompareActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetRangeAndCompareActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getRangeAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRangeAndCompareActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getRangeAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRangeAndCompareActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getRangeAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRangeAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	ReadYourWritesTransaction* tr;
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	KeySelector begin;
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	KeySelector end;
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	GetRangeLimits limit;
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Snapshot snapshot;
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Reverse reverse;
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readYourWritesDisabled;
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool snapshotRYWDisabled;
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool* doingCommit;
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t* memLimit;
															#line 243 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	UID randomID;
															#line 250 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Standalone<VectorRef<KeyValueRef>> memRes;
															#line 1054 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getRangeAndCompare()
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class GetRangeAndCompareActor final : public Actor<Void>, public ActorCallback< GetRangeAndCompareActor, 0, RangeResult >, public FastAllocated<GetRangeAndCompareActor>, public GetRangeAndCompareActorState<GetRangeAndCompareActor> {
															#line 1059 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetRangeAndCompareActor>::operator new;
	using FastAllocated<GetRangeAndCompareActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12926080847414696960UL, 4054218161638457344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRangeAndCompareActor, 0, RangeResult >;
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	GetRangeAndCompareActor(ReadYourWritesTransaction* const& tr,KeySelector const& begin,KeySelector const& end,GetRangeLimits const& limit,Snapshot const& snapshot,Reverse const& reverse,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 1076 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetRangeAndCompareActorState<GetRangeAndCompareActor>(tr, begin, end, limit, snapshot, reverse, readYourWritesDisabled, snapshotRYWDisabled, self, doingCommit, memLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRangeAndCompare", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17567354558359962368UL, 17800240668702594560UL);
		ActorExecutionContextHelper __helper(static_cast<GetRangeAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRangeAndCompare");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRangeAndCompare", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRangeAndCompareActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> getRangeAndCompare( ReadYourWritesTransaction* const& tr, KeySelector const& begin, KeySelector const& end, GetRangeLimits const& limit, Snapshot const& snapshot, Reverse const& reverse, bool const& readYourWritesDisabled, bool const& snapshotRYWDisabled, WriteDuringReadWorkload* const& self, bool* const& doingCommit, int64_t* const& memLimit ) {
															#line 232 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new GetRangeAndCompareActor(tr, begin, end, limit, snapshot, reverse, readYourWritesDisabled, snapshotRYWDisabled, self, doingCommit, memLimit));
															#line 1108 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
}

#line 392 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

	Optional<Value> memoryGet(std::map<Key, Value>* db, Key key) {
		auto iter = db->find(key);
		if (iter == db->end())
			return Optional<Value>();
		else
			return iter->second;
	}

																#line 1121 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
// This generated class is to be used only via getAndCompare()
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class GetAndCompareActor>
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class GetAndCompareActorState {
															#line 1127 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	GetAndCompareActorState(ReadYourWritesTransaction* const& tr,Key const& key,Snapshot const& snapshot,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : tr(tr),
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   key(key),
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshot(snapshot),
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readYourWritesDisabled(readYourWritesDisabled),
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshotRYWDisabled(snapshotRYWDisabled),
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   self(self),
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   doingCommit(doingCommit),
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   memLimit(memLimit),
															#line 409 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID())
															#line 1150 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAndCompare", reinterpret_cast<unsigned long>(this));

	}
	~GetAndCompareActorState() 
	{
		fdb_probe_actor_destroy("getAndCompare", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 412 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				memRes = self->memoryGet(readYourWritesDisabled || (snapshot && snapshotRYWDisabled) ? &self->lastCommittedDatabase : &self->memoryDatabase, key);
															#line 416 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				*memLimit -= memRes.expectedSize();
															#line 417 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				StrictFuture<Optional<Value>> __when_expr_0 = tr->get(key, snapshot);
															#line 417 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (static_cast<GetAndCompareActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1172 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetAndCompareActor*>(this)->actor_wait_state = 1;
															#line 417 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAndCompareActor, 0, Optional<Value> >*>(static_cast<GetAndCompareActor*>(this)));
															#line 1177 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAndCompareActorState();
		static_cast<GetAndCompareActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 431 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_used_during_commit)
															#line 1207 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 432 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				ASSERT(*doingCommit);
															#line 433 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<GetAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAndCompareActorState(); static_cast<GetAndCompareActor*>(this)->destroy(); return 0; }
															#line 1213 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				new (&static_cast<GetAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~GetAndCompareActorState();
				static_cast<GetAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 434 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (e.code() == error_code_transaction_cancelled)
															#line 1223 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 435 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<GetAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAndCompareActorState(); static_cast<GetAndCompareActor*>(this)->destroy(); return 0; }
															#line 1227 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					new (&static_cast<GetAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~GetAndCompareActorState();
					static_cast<GetAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 436 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1236 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> const& res,int loopDepth) 
	{
															#line 418 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*memLimit += memRes.expectedSize();
															#line 419 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (res != memRes)
															#line 1252 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 420 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRGetWrongResult", randomID) .detail("Key", key) .detail("Snapshot", snapshot) .detail("MemoryResult", memRes.present() ? memRes.get().size() : -1) .detail("DbResult", res.present() ? res.get().size() : -1) .detail("RywDisable", readYourWritesDisabled);
															#line 426 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			self->success = false;
															#line 1258 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 428 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<GetAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAndCompareActorState(); static_cast<GetAndCompareActor*>(this)->destroy(); return 0; }
															#line 1262 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		new (&static_cast<GetAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetAndCompareActorState();
		static_cast<GetAndCompareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Optional<Value> && res,int loopDepth) 
	{
															#line 418 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*memLimit += memRes.expectedSize();
															#line 419 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (res != memRes)
															#line 1276 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 420 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRGetWrongResult", randomID) .detail("Key", key) .detail("Snapshot", snapshot) .detail("MemoryResult", memRes.present() ? memRes.get().size() : -1) .detail("DbResult", res.present() ? res.get().size() : -1) .detail("RywDisable", readYourWritesDisabled);
															#line 426 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			self->success = false;
															#line 1282 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 428 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<GetAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetAndCompareActorState(); static_cast<GetAndCompareActor*>(this)->destroy(); return 0; }
															#line 1286 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		new (&static_cast<GetAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetAndCompareActorState();
		static_cast<GetAndCompareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& res,int loopDepth) 
	{
		loopDepth = a_body1cont2(res, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && res,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAndCompareActor*>(this)->actor_wait_state > 0) static_cast<GetAndCompareActor*>(this)->actor_wait_state = 0;
		static_cast<GetAndCompareActor*>(this)->ActorCallback< GetAndCompareActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAndCompareActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAndCompareActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAndCompareActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	ReadYourWritesTransaction* tr;
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Key key;
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Snapshot snapshot;
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readYourWritesDisabled;
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool snapshotRYWDisabled;
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool* doingCommit;
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t* memLimit;
															#line 409 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	UID randomID;
															#line 412 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Optional<Value> memRes;
															#line 1389 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAndCompare()
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class GetAndCompareActor final : public Actor<Void>, public ActorCallback< GetAndCompareActor, 0, Optional<Value> >, public FastAllocated<GetAndCompareActor>, public GetAndCompareActorState<GetAndCompareActor> {
															#line 1394 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAndCompareActor>::operator new;
	using FastAllocated<GetAndCompareActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(368057684178463232UL, 350387989530519296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAndCompareActor, 0, Optional<Value> >;
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	GetAndCompareActor(ReadYourWritesTransaction* const& tr,Key const& key,Snapshot const& snapshot,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 1411 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   GetAndCompareActorState<GetAndCompareActor>(tr, key, snapshot, readYourWritesDisabled, snapshotRYWDisabled, self, doingCommit, memLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAndCompare", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6664611363522752512UL, 17833135999407791360UL);
		ActorExecutionContextHelper __helper(static_cast<GetAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAndCompare");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAndCompare", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAndCompareActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> getAndCompare( ReadYourWritesTransaction* const& tr, Key const& key, Snapshot const& snapshot, bool const& readYourWritesDisabled, bool const& snapshotRYWDisabled, WriteDuringReadWorkload* const& self, bool* const& doingCommit, int64_t* const& memLimit ) {
															#line 401 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new GetAndCompareActor(tr, key, snapshot, readYourWritesDisabled, snapshotRYWDisabled, self, doingCommit, memLimit));
															#line 1443 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
}

#line 439 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

																#line 1448 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
// This generated class is to be used only via watchAndCompare()
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class WatchAndCompareActor>
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class WatchAndCompareActorState {
															#line 1454 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WatchAndCompareActorState(ReadYourWritesTransaction* const& tr,Key const& key,bool const& readYourWritesDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : tr(tr),
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   key(key),
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readYourWritesDisabled(readYourWritesDisabled),
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   self(self),
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   doingCommit(doingCommit),
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   memLimit(memLimit),
															#line 446 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID())
															#line 1473 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("watchAndCompare", reinterpret_cast<unsigned long>(this));

	}
	~WatchAndCompareActorState() 
	{
		fdb_probe_actor_destroy("watchAndCompare", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 448 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (readYourWritesDisabled)
															#line 1488 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 449 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<WatchAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchAndCompareActorState(); static_cast<WatchAndCompareActor*>(this)->destroy(); return 0; }
															#line 1492 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				new (&static_cast<WatchAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WatchAndCompareActorState();
				static_cast<WatchAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 453 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				changeNum = self->changeCount[key];
															#line 454 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				memRes = self->memoryGet(&self->memoryDatabase, key);
															#line 455 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				*memLimit -= memRes.expectedSize();
															#line 458 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (1)
															#line 1507 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 460 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					StrictFuture<Void> __when_expr_0 = tr->watch(key);
															#line 459 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (static_cast<WatchAndCompareActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1513 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 469 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					StrictFuture<Void> __when_expr_1 = self->finished.onTrigger();
															#line 1517 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<WatchAndCompareActor*>(this)->actor_wait_state = 1;
															#line 460 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WatchAndCompareActor, 0, Void >*>(static_cast<WatchAndCompareActor*>(this)));
															#line 469 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WatchAndCompareActor, 1, Void >*>(static_cast<WatchAndCompareActor*>(this)));
															#line 1524 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont3(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WatchAndCompareActorState();
		static_cast<WatchAndCompareActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 487 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_used_during_commit)
															#line 1559 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 488 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				ASSERT(*doingCommit);
															#line 489 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<WatchAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchAndCompareActorState(); static_cast<WatchAndCompareActor*>(this)->destroy(); return 0; }
															#line 1565 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				new (&static_cast<WatchAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WatchAndCompareActorState();
				static_cast<WatchAndCompareActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 490 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (e.code() == error_code_transaction_cancelled)
															#line 1575 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 491 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (!static_cast<WatchAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchAndCompareActorState(); static_cast<WatchAndCompareActor*>(this)->destroy(); return 0; }
															#line 1579 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					new (&static_cast<WatchAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
					this->~WatchAndCompareActorState();
					static_cast<WatchAndCompareActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
			}
															#line 492 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1588 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 481 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*memLimit += memRes.expectedSize();
															#line 483 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<WatchAndCompareActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WatchAndCompareActorState(); static_cast<WatchAndCompareActor*>(this)->destroy(); return 0; }
															#line 1604 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		new (&static_cast<WatchAndCompareActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WatchAndCompareActorState();
		static_cast<WatchAndCompareActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
															#line 461 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (changeNum == self->changeCount[key])
															#line 1622 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 462 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRWatchWrongResult", randomID) .detail("Reason", "Triggered without changing") .detail("Key", key) .detail("Value", changeNum) .detail("DuringCommit", *doingCommit);
															#line 1626 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
															#line 461 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (changeNum == self->changeCount[key])
															#line 1636 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 462 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRWatchWrongResult", randomID) .detail("Reason", "Triggered without changing") .detail("Key", key) .detail("Value", changeNum) .detail("DuringCommit", *doingCommit);
															#line 1640 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 470 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		Optional<Value> memRes2 = self->memoryGet(&self->memoryDatabase, key);
															#line 471 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (memRes != memRes2)
															#line 1652 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 472 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRWatchWrongResult", randomID) .detail("Reason", "Changed without triggering") .detail("Key", key) .detail("Value1", memRes) .detail("Value2", memRes2);
															#line 1656 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 470 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		Optional<Value> memRes2 = self->memoryGet(&self->memoryDatabase, key);
															#line 471 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (memRes != memRes2)
															#line 1668 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 472 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			TraceEvent(SevError, "WDRWatchWrongResult", randomID) .detail("Reason", "Changed without triggering") .detail("Key", key) .detail("Value1", memRes) .detail("Value2", memRes2);
															#line 1672 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WatchAndCompareActor*>(this)->actor_wait_state > 0) static_cast<WatchAndCompareActor*>(this)->actor_wait_state = 0;
		static_cast<WatchAndCompareActor*>(this)->ActorCallback< WatchAndCompareActor, 0, Void >::remove();
		static_cast<WatchAndCompareActor*>(this)->ActorCallback< WatchAndCompareActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WatchAndCompareActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchAndCompareActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WatchAndCompareActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchAndCompare", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndCompare", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WatchAndCompareActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("watchAndCompare", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndCompare", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WatchAndCompareActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("watchAndCompare", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndCompare", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WatchAndCompareActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("watchAndCompare", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("watchAndCompare", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	ReadYourWritesTransaction* tr;
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Key key;
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readYourWritesDisabled;
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool* doingCommit;
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t* memLimit;
															#line 446 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	UID randomID;
															#line 453 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int changeNum;
															#line 454 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Optional<Value> memRes;
															#line 1817 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
};
// This generated class is to be used only via watchAndCompare()
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class WatchAndCompareActor final : public Actor<Void>, public ActorCallback< WatchAndCompareActor, 0, Void >, public ActorCallback< WatchAndCompareActor, 1, Void >, public FastAllocated<WatchAndCompareActor>, public WatchAndCompareActorState<WatchAndCompareActor> {
															#line 1822 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
	using FastAllocated<WatchAndCompareActor>::operator new;
	using FastAllocated<WatchAndCompareActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(857522268645531392UL, 14468451507384015104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WatchAndCompareActor, 0, Void >;
friend struct ActorCallback< WatchAndCompareActor, 1, Void >;
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WatchAndCompareActor(ReadYourWritesTransaction* const& tr,Key const& key,bool const& readYourWritesDisabled,WriteDuringReadWorkload* const& self,bool* const& doingCommit,int64_t* const& memLimit) 
															#line 1840 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WatchAndCompareActorState<WatchAndCompareActor>(tr, key, readYourWritesDisabled, self, doingCommit, memLimit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("watchAndCompare", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14783106384540347648UL, 12163028697870592000UL);
		ActorExecutionContextHelper __helper(static_cast<WatchAndCompareActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("watchAndCompare");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("watchAndCompare", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WatchAndCompareActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> watchAndCompare( ReadYourWritesTransaction* const& tr, Key const& key, bool const& readYourWritesDisabled, WriteDuringReadWorkload* const& self, bool* const& doingCommit, int64_t* const& memLimit ) {
															#line 440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new WatchAndCompareActor(tr, key, readYourWritesDisabled, self, doingCommit, memLimit));
															#line 1872 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
}

#line 495 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

																#line 1877 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
// This generated class is to be used only via commitAndUpdateMemory()
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class CommitAndUpdateMemoryActor>
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class CommitAndUpdateMemoryActorState {
															#line 1883 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	CommitAndUpdateMemoryActorState(ReadYourWritesTransaction* const& tr,WriteDuringReadWorkload* const& self,bool* const& cancelled,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,bool const& readAheadDisabled,bool const& useBatchPriority,bool* const& doingCommit,double* const& startTime,Key const& timebombStr) 
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : tr(tr),
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   self(self),
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   cancelled(cancelled),
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readYourWritesDisabled(readYourWritesDisabled),
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshotRYWDisabled(snapshotRYWDisabled),
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readAheadDisabled(readAheadDisabled),
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   useBatchPriority(useBatchPriority),
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   doingCommit(doingCommit),
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   startTime(startTime),
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   timebombStr(timebombStr)
															#line 1908 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this));

	}
	~CommitAndUpdateMemoryActorState() 
	{
		fdb_probe_actor_destroy("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 509 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!readYourWritesDisabled && !*cancelled)
															#line 1924 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 510 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					KeyRangeMap<bool> transactionConflicts;
															#line 511 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					tr->getWriteConflicts(&transactionConflicts);
															#line 513 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					auto transactionRanges = transactionConflicts.ranges();
															#line 514 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					auto addedRanges = self->addedConflicts.ranges();
															#line 515 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					auto transactionIter = transactionRanges.begin();
															#line 516 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					auto addedIter = addedRanges.begin();
															#line 518 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					bool failed = false;
															#line 519 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					for(;transactionIter != transactionRanges.end() && addedIter != addedRanges.end();) {
															#line 520 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						if (transactionIter->begin() != addedIter->begin() || transactionIter->value() != addedIter->value())
															#line 1944 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
						{
															#line 522 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
							TraceEvent(SevError, "WriteConflictError") .detail("TransactionKey", transactionIter->begin()) .detail("AddedKey", addedIter->begin()) .detail("TransactionVal", transactionIter->value()) .detail("AddedVal", addedIter->value());
															#line 527 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
							failed = true;
															#line 1950 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
						}
															#line 529 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						++transactionIter;
															#line 530 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						++addedIter;
															#line 1956 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					}
															#line 533 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (transactionIter != transactionRanges.end() || addedIter != addedRanges.end())
															#line 1960 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					{
															#line 534 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						failed = true;
															#line 1964 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					}
															#line 537 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (failed)
															#line 1968 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					{
															#line 538 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						TraceEvent(SevError, "WriteConflictRangeError").log();
															#line 539 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						for(transactionIter = transactionRanges.begin();transactionIter != transactionRanges.end();++transactionIter) {
															#line 541 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
							TraceEvent("WCRTransaction") .detail("Range", transactionIter.range()) .detail("Value", transactionIter.value());
															#line 1976 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
						}
															#line 545 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						for(addedIter = addedRanges.begin();addedIter != addedRanges.end();++addedIter) {
															#line 546 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
							TraceEvent("WCRAdded").detail("Range", addedIter.range()).detail("Value", addedIter.value());
															#line 1982 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
						}
					}
				}
															#line 551 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				txnSize = tr->getApproximateSize();
															#line 552 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				committedDB = self->memoryDatabase;
															#line 553 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				*doingCommit = true;
															#line 554 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 554 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (static_cast<CommitAndUpdateMemoryActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1996 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<CommitAndUpdateMemoryActor*>(this)->actor_wait_state = 1;
															#line 554 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CommitAndUpdateMemoryActor, 0, Void >*>(static_cast<CommitAndUpdateMemoryActor*>(this)));
															#line 2001 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CommitAndUpdateMemoryActorState();
		static_cast<CommitAndUpdateMemoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 585 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_actor_cancelled || e.code() == error_code_transaction_cancelled || e.code() == error_code_used_during_commit)
															#line 2031 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 587 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				*cancelled = true;
															#line 2035 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			}
															#line 588 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_actor_cancelled || e.code() == error_code_transaction_cancelled)
															#line 2039 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 589 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				return a_body1Catch1(commit_unknown_result(), loopDepth);
															#line 2043 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			}
															#line 590 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_transaction_too_old)
															#line 2047 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 591 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				return a_body1Catch1(not_committed(), loopDepth);
															#line 2051 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			}
															#line 592 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2055 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 555 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*doingCommit = false;
															#line 556 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->finished.trigger();
															#line 557 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->dataWritten += txnSize;
															#line 565 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (snapshotRYWDisabled)
															#line 2075 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 566 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::SNAPSHOT_RYW_DISABLE);
															#line 2079 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 567 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (readAheadDisabled)
															#line 2083 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 568 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_AHEAD_DISABLE);
															#line 2087 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 569 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (useBatchPriority)
															#line 2091 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 570 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_BATCH);
															#line 2095 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 571 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (self->useSystemKeys)
															#line 2099 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 572 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2103 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 573 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		tr->addWriteConflictRange(self->conflictRange);
															#line 574 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(allKeys, false);
															#line 575 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(self->conflictRange, true);
															#line 576 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*startTime = now();
															#line 577 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		tr->setOption(FDBTransactionOptions::TIMEOUT, timebombStr);
															#line 580 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->lastCommittedDatabase = committedDB;
															#line 582 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<CommitAndUpdateMemoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitAndUpdateMemoryActorState(); static_cast<CommitAndUpdateMemoryActor*>(this)->destroy(); return 0; }
															#line 2119 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		new (&static_cast<CommitAndUpdateMemoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitAndUpdateMemoryActorState();
		static_cast<CommitAndUpdateMemoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 555 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*doingCommit = false;
															#line 556 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->finished.trigger();
															#line 557 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->dataWritten += txnSize;
															#line 565 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (snapshotRYWDisabled)
															#line 2137 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 566 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::SNAPSHOT_RYW_DISABLE);
															#line 2141 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 567 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (readAheadDisabled)
															#line 2145 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 568 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_AHEAD_DISABLE);
															#line 2149 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 569 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (useBatchPriority)
															#line 2153 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 570 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_BATCH);
															#line 2157 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 571 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (self->useSystemKeys)
															#line 2161 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 572 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2165 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 573 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		tr->addWriteConflictRange(self->conflictRange);
															#line 574 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(allKeys, false);
															#line 575 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(self->conflictRange, true);
															#line 576 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		*startTime = now();
															#line 577 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		tr->setOption(FDBTransactionOptions::TIMEOUT, timebombStr);
															#line 580 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->lastCommittedDatabase = committedDB;
															#line 582 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<CommitAndUpdateMemoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CommitAndUpdateMemoryActorState(); static_cast<CommitAndUpdateMemoryActor*>(this)->destroy(); return 0; }
															#line 2181 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		new (&static_cast<CommitAndUpdateMemoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CommitAndUpdateMemoryActorState();
		static_cast<CommitAndUpdateMemoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CommitAndUpdateMemoryActor*>(this)->actor_wait_state > 0) static_cast<CommitAndUpdateMemoryActor*>(this)->actor_wait_state = 0;
		static_cast<CommitAndUpdateMemoryActor*>(this)->ActorCallback< CommitAndUpdateMemoryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CommitAndUpdateMemoryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitAndUpdateMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CommitAndUpdateMemoryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CommitAndUpdateMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CommitAndUpdateMemoryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CommitAndUpdateMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	ReadYourWritesTransaction* tr;
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool* cancelled;
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readYourWritesDisabled;
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool snapshotRYWDisabled;
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readAheadDisabled;
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool useBatchPriority;
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool* doingCommit;
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	double* startTime;
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Key timebombStr;
															#line 551 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t txnSize;
															#line 552 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	std::map<Key, Value> committedDB;
															#line 2288 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
};
// This generated class is to be used only via commitAndUpdateMemory()
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class CommitAndUpdateMemoryActor final : public Actor<Void>, public ActorCallback< CommitAndUpdateMemoryActor, 0, Void >, public FastAllocated<CommitAndUpdateMemoryActor>, public CommitAndUpdateMemoryActorState<CommitAndUpdateMemoryActor> {
															#line 2293 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
	using FastAllocated<CommitAndUpdateMemoryActor>::operator new;
	using FastAllocated<CommitAndUpdateMemoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6172973422139963648UL, 9899029155901347328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CommitAndUpdateMemoryActor, 0, Void >;
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	CommitAndUpdateMemoryActor(ReadYourWritesTransaction* const& tr,WriteDuringReadWorkload* const& self,bool* const& cancelled,bool const& readYourWritesDisabled,bool const& snapshotRYWDisabled,bool const& readAheadDisabled,bool const& useBatchPriority,bool* const& doingCommit,double* const& startTime,Key const& timebombStr) 
															#line 2310 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CommitAndUpdateMemoryActorState<CommitAndUpdateMemoryActor>(tr, self, cancelled, readYourWritesDisabled, snapshotRYWDisabled, readAheadDisabled, useBatchPriority, doingCommit, startTime, timebombStr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4231613749852679424UL, 5657626562256922112UL);
		ActorExecutionContextHelper __helper(static_cast<CommitAndUpdateMemoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("commitAndUpdateMemory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("commitAndUpdateMemory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CommitAndUpdateMemoryActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> commitAndUpdateMemory( ReadYourWritesTransaction* const& tr, WriteDuringReadWorkload* const& self, bool* const& cancelled, bool const& readYourWritesDisabled, bool const& snapshotRYWDisabled, bool const& readAheadDisabled, bool const& useBatchPriority, bool* const& doingCommit, double* const& startTime, Key const& timebombStr ) {
															#line 496 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new CommitAndUpdateMemoryActor(tr, self, cancelled, readYourWritesDisabled, snapshotRYWDisabled, readAheadDisabled, useBatchPriority, doingCommit, startTime, timebombStr));
															#line 2342 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
}

#line 595 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

	Value getRandomValue() {
		int length = deterministicRandom()->randomInt(valueSizeRange.first, valueSizeRange.second + 1);
		int zeroPadding = static_cast<int>(zeroPaddingRatio * length);
		if (zeroPadding > length) {
			zeroPadding = length;
		}
		std::string valueString = deterministicRandom()->randomAlphaNumeric(length);
		for (int i = 0; i < zeroPadding; ++i) {
			valueString[i] = '\0';
		}
		return StringRef((uint8_t*)valueString.c_str(), length);
	}

	// Prevent a write only transaction whose commit was previously cancelled from being reordered after this
	// transaction
																#line 2362 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
// This generated class is to be used only via writeBarrier()
															#line 611 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class WriteBarrierActor>
															#line 611 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class WriteBarrierActorState {
															#line 2368 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
															#line 611 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteBarrierActorState(Database const& cx) 
															#line 611 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 611 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : cx(cx),
															#line 612 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   tr(cx)
															#line 2377 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("writeBarrier", reinterpret_cast<unsigned long>(this));

	}
	~WriteBarrierActorState() 
	{
		fdb_probe_actor_destroy("writeBarrier", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 613 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			;
															#line 2392 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteBarrierActorState();
		static_cast<WriteBarrierActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 615 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 618 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.addWriteConflictRange(allKeys);
															#line 619 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 619 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (static_cast<WriteBarrierActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2429 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteBarrierActor*>(this)->actor_wait_state = 1;
															#line 619 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteBarrierActor, 0, Void >*>(static_cast<WriteBarrierActor*>(this)));
															#line 2434 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 622 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 622 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (static_cast<WriteBarrierActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2458 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WriteBarrierActor*>(this)->actor_wait_state = 2;
															#line 622 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteBarrierActor, 1, Void >*>(static_cast<WriteBarrierActor*>(this)));
															#line 2463 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 620 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<WriteBarrierActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteBarrierActorState(); static_cast<WriteBarrierActor*>(this)->destroy(); return 0; }
															#line 2478 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		new (&static_cast<WriteBarrierActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteBarrierActorState();
		static_cast<WriteBarrierActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 620 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<WriteBarrierActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteBarrierActorState(); static_cast<WriteBarrierActor*>(this)->destroy(); return 0; }
															#line 2490 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		new (&static_cast<WriteBarrierActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteBarrierActorState();
		static_cast<WriteBarrierActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteBarrierActor*>(this)->actor_wait_state > 0) static_cast<WriteBarrierActor*>(this)->actor_wait_state = 0;
		static_cast<WriteBarrierActor*>(this)->ActorCallback< WriteBarrierActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteBarrierActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeBarrier", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBarrierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBarrier", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteBarrierActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeBarrier", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBarrierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBarrier", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteBarrierActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeBarrier", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBarrierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBarrier", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteBarrierActor*>(this)->actor_wait_state > 0) static_cast<WriteBarrierActor*>(this)->actor_wait_state = 0;
		static_cast<WriteBarrierActor*>(this)->ActorCallback< WriteBarrierActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteBarrierActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeBarrier", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBarrierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBarrier", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteBarrierActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeBarrier", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBarrierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBarrier", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteBarrierActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeBarrier", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBarrierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeBarrier", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 611 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Database cx;
															#line 612 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Transaction tr;
															#line 2664 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
};
// This generated class is to be used only via writeBarrier()
															#line 611 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class WriteBarrierActor final : public Actor<Void>, public ActorCallback< WriteBarrierActor, 0, Void >, public ActorCallback< WriteBarrierActor, 1, Void >, public FastAllocated<WriteBarrierActor>, public WriteBarrierActorState<WriteBarrierActor> {
															#line 2669 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
	using FastAllocated<WriteBarrierActor>::operator new;
	using FastAllocated<WriteBarrierActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17571072291634775296UL, 16514621179991923968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteBarrierActor, 0, Void >;
friend struct ActorCallback< WriteBarrierActor, 1, Void >;
															#line 611 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteBarrierActor(Database const& cx) 
															#line 2687 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   WriteBarrierActorState<WriteBarrierActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeBarrier", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12408030041787207680UL, 1824477430591930112UL);
		ActorExecutionContextHelper __helper(static_cast<WriteBarrierActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeBarrier");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeBarrier", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteBarrierActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteBarrierActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 611 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> writeBarrier( Database const& cx ) {
															#line 611 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new WriteBarrierActor(cx));
															#line 2720 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
}

#line 626 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

																#line 2725 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
// This generated class is to be used only via loadAndRun()
															#line 627 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class LoadAndRunActor>
															#line 627 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class LoadAndRunActorState {
															#line 2731 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
															#line 627 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	LoadAndRunActorState(Database const& cx,WriteDuringReadWorkload* const& self) 
															#line 627 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 627 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : cx(cx),
															#line 627 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   self(self),
															#line 628 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   startTime(now())
															#line 2742 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("loadAndRun", reinterpret_cast<unsigned long>(this));

	}
	~LoadAndRunActorState() 
	{
		fdb_probe_actor_destroy("loadAndRun", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 629 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			;
															#line 2757 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadAndRunActorState();
		static_cast<LoadAndRunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 630 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->writeBarrier(cx);
															#line 630 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<LoadAndRunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2789 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<LoadAndRunActor*>(this)->actor_wait_state = 1;
															#line 630 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadAndRunActor, 0, Void >*>(static_cast<LoadAndRunActor*>(this)));
															#line 2794 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 632 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		i = 0;
															#line 633 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		keysPerBatch = std::min<int64_t>(1000, 1 + CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT / 6 / (self->getKeyForIndex(self->nodes).size() + self->valueSizeRange.second));
															#line 637 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->memoryDatabase = std::map<Key, Value>();
															#line 638 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		;
															#line 2809 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 632 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		i = 0;
															#line 633 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		keysPerBatch = std::min<int64_t>(1000, 1 + CLIENT_KNOBS->TRANSACTION_SIZE_LIMIT / 6 / (self->getKeyForIndex(self->nodes).size() + self->valueSizeRange.second));
															#line 637 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->memoryDatabase = std::map<Key, Value>();
															#line 638 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		;
															#line 2824 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadAndRunActor*>(this)->actor_wait_state > 0) static_cast<LoadAndRunActor*>(this)->actor_wait_state = 0;
		static_cast<LoadAndRunActor*>(this)->ActorCallback< LoadAndRunActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadAndRunActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 680 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->lastCommittedDatabase = self->memoryDatabase;
															#line 681 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(allKeys, false);
															#line 684 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		;
															#line 2912 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 638 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!(i < self->nodes))
															#line 2928 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 639 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		tr = Transaction(cx);
															#line 640 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		;
															#line 2936 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 638 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		i += keysPerBatch;
															#line 2958 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 642 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (now() - startTime > self->testDuration || self->dataWritten >= self->maximumDataWritten)
															#line 2975 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 643 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<LoadAndRunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadAndRunActorState(); static_cast<LoadAndRunActor*>(this)->destroy(); return 0; }
															#line 2979 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				new (&static_cast<LoadAndRunActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~LoadAndRunActorState();
				static_cast<LoadAndRunActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 644 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (self->useSystemKeys)
															#line 2987 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 645 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2991 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			}
															#line 647 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			txnSize = 0;
															#line 648 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (i == 0)
															#line 2997 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 649 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				tr.clear(normalKeys);
															#line 3001 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			}
															#line 652 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			int end = std::min(self->nodes, i + keysPerBatch);
															#line 653 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.clear(KeyRangeRef(self->getKeyForIndex(i), self->getKeyForIndex(end)));
															#line 654 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			self->memoryDatabase.erase(self->memoryDatabase.lower_bound(self->getKeyForIndex(i)), self->memoryDatabase.lower_bound(self->getKeyForIndex(end)));
															#line 657 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			for(int j = i;j < end;j++) {
															#line 658 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (deterministicRandom()->random01() < self->initialKeyDensity)
															#line 3013 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 659 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					Key key = self->getKeyForIndex(j);
															#line 660 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (key.size() <= getMaxWriteKeySize(key, false))
															#line 3019 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					{
															#line 661 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						Value value = self->getRandomValue();
															#line 662 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						value = value.substr(0, std::min<int>(value.size(), CLIENT_KNOBS->VALUE_SIZE_LIMIT));
															#line 664 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						self->memoryDatabase[key] = value;
															#line 665 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						tr.set(key, value);
															#line 666 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						int64_t rowSize = key.expectedSize() + value.expectedSize();
															#line 667 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						txnSize += rowSize;
															#line 3033 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					}
				}
			}
															#line 671 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 671 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (static_cast<LoadAndRunActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3041 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<LoadAndRunActor*>(this)->actor_wait_state = 2;
															#line 671 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadAndRunActor, 1, Void >*>(static_cast<LoadAndRunActor*>(this)));
															#line 3046 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 676 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 676 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (static_cast<LoadAndRunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 3));
															#line 3083 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 3)); else return a_body1loopBody1cont1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<LoadAndRunActor*>(this)->actor_wait_state = 3;
															#line 676 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadAndRunActor, 2, Void >*>(static_cast<LoadAndRunActor*>(this)));
															#line 3088 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 672 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->dataWritten += txnSize;
															#line 3103 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		return a_body1loopBody1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 672 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->dataWritten += txnSize;
															#line 3112 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		return a_body1loopBody1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadAndRunActor*>(this)->actor_wait_state > 0) static_cast<LoadAndRunActor*>(this)->actor_wait_state = 0;
		static_cast<LoadAndRunActor*>(this)->ActorCallback< LoadAndRunActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadAndRunActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadAndRunActor*>(this)->actor_wait_state > 0) static_cast<LoadAndRunActor*>(this)->actor_wait_state = 0;
		static_cast<LoadAndRunActor*>(this)->ActorCallback< LoadAndRunActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadAndRunActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 685 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(now() - startTime > self->slowModeStart || (g_network->isSimulated() && g_simulator->speedUpSimulation) ? 1.0 : 0.1);
															#line 685 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<LoadAndRunActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3298 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<LoadAndRunActor*>(this)->actor_wait_state = 4;
															#line 685 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LoadAndRunActor, 3, Void >*>(static_cast<LoadAndRunActor*>(this)));
															#line 3303 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void const& _,int loopDepth) 
	{
		try {
															#line 690 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->randomTransaction( (self->useExtraDB && deterministicRandom()->random01() < 0.5) ? self->extraDB : cx, self, startTime);
															#line 690 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (static_cast<LoadAndRunActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3328 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont2loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<LoadAndRunActor*>(this)->actor_wait_state = 5;
															#line 690 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LoadAndRunActor, 4, Void >*>(static_cast<LoadAndRunActor*>(this)));
															#line 3333 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(Void && _,int loopDepth) 
	{
		try {
															#line 690 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			StrictFuture<Void> __when_expr_4 = self->randomTransaction( (self->useExtraDB && deterministicRandom()->random01() < 0.5) ? self->extraDB : cx, self, startTime);
															#line 690 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (static_cast<LoadAndRunActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 3351 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont2loopBody1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
			static_cast<LoadAndRunActor*>(this)->actor_wait_state = 5;
															#line 690 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LoadAndRunActor, 4, Void >*>(static_cast<LoadAndRunActor*>(this)));
															#line 3356 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LoadAndRunActor*>(this)->actor_wait_state > 0) static_cast<LoadAndRunActor*>(this)->actor_wait_state = 0;
		static_cast<LoadAndRunActor*>(this)->ActorCallback< LoadAndRunActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LoadAndRunActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont2loopBody1cont2(int loopDepth) 
	{
															#line 699 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (now() - startTime > self->testDuration || self->dataWritten >= self->maximumDataWritten)
															#line 3446 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 700 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (!static_cast<LoadAndRunActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadAndRunActorState(); static_cast<LoadAndRunActor*>(this)->destroy(); return 0; }
															#line 3450 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			new (&static_cast<LoadAndRunActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~LoadAndRunActorState();
			static_cast<LoadAndRunActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 695 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() != error_code_not_committed)
															#line 3465 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 696 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 3469 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			}
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<LoadAndRunActor*>(this)->actor_wait_state > 0) static_cast<LoadAndRunActor*>(this)->actor_wait_state = 0;
		static_cast<LoadAndRunActor*>(this)->ActorCallback< LoadAndRunActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LoadAndRunActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LoadAndRunActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont2loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
															#line 627 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Database cx;
															#line 627 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 628 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	double startTime;
															#line 632 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int i;
															#line 633 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int keysPerBatch;
															#line 639 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Transaction tr;
															#line 647 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t txnSize;
															#line 3595 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
};
// This generated class is to be used only via loadAndRun()
															#line 627 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class LoadAndRunActor final : public Actor<Void>, public ActorCallback< LoadAndRunActor, 0, Void >, public ActorCallback< LoadAndRunActor, 1, Void >, public ActorCallback< LoadAndRunActor, 2, Void >, public ActorCallback< LoadAndRunActor, 3, Void >, public ActorCallback< LoadAndRunActor, 4, Void >, public FastAllocated<LoadAndRunActor>, public LoadAndRunActorState<LoadAndRunActor> {
															#line 3600 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
	using FastAllocated<LoadAndRunActor>::operator new;
	using FastAllocated<LoadAndRunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17277611336367171584UL, 11792508808487911680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadAndRunActor, 0, Void >;
friend struct ActorCallback< LoadAndRunActor, 1, Void >;
friend struct ActorCallback< LoadAndRunActor, 2, Void >;
friend struct ActorCallback< LoadAndRunActor, 3, Void >;
friend struct ActorCallback< LoadAndRunActor, 4, Void >;
															#line 627 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	LoadAndRunActor(Database const& cx,WriteDuringReadWorkload* const& self) 
															#line 3621 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   LoadAndRunActorState<LoadAndRunActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadAndRun", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1948779402819391744UL, 14849708037289523712UL);
		ActorExecutionContextHelper __helper(static_cast<LoadAndRunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadAndRun");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadAndRun", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadAndRunActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadAndRunActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadAndRunActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LoadAndRunActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< LoadAndRunActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 627 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> loadAndRun( Database const& cx, WriteDuringReadWorkload* const& self ) {
															#line 627 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new LoadAndRunActor(cx, self));
															#line 3657 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
}

#line 704 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"

	Key getRandomKey() { return getKeyForIndex(deterministicRandom()->randomInt(0, nodes)); }

	Key getKeyForIndex(int idx) {
		idx += minNode;
		if (adjacentKeys) {
			return Key(keyPrefix + (idx ? std::string(idx, '\x00') : ""));
		} else {
			return Key(keyPrefix + format("%010d", idx));
		}
	}

	Key versionStampKeyForIndex(int idx) {
		Key result = KeyRef(getKeyForIndex(idx).toString() + std::string(14, '\x00'));
		int32_t pos = deterministicRandom()->randomInt(0, result.size() - 13);
		pos = littleEndian32(pos);
		uint8_t* data = mutateString(result);
		memcpy(data + result.size() - sizeof(int32_t), &pos, sizeof(int32_t));
		return result;
	}

	Key getRandomVersionStampKey() { return versionStampKeyForIndex(deterministicRandom()->randomInt(0, nodes)); }

	KeySelector getRandomKeySelector() {
		int scale = 1 << deterministicRandom()->randomInt(0, 14);
		return KeySelectorRef(
		    getRandomKey(), deterministicRandom()->random01() < 0.5, deterministicRandom()->randomInt(-scale, scale));
	}

	GetRangeLimits getRandomLimits() {
		int kind = deterministicRandom()->randomInt(0, 3);
		return GetRangeLimits(
		    (kind & 1) ? GetRangeLimits::ROW_LIMIT_UNLIMITED
		               : deterministicRandom()->randomInt(0, 1 << deterministicRandom()->randomInt(1, 10)),
		    (kind & 2) ? GetRangeLimits::BYTE_LIMIT_UNLIMITED
		               : deterministicRandom()->randomInt(0, 1 << deterministicRandom()->randomInt(1, 15)));
	}

	KeyRange getRandomRange(int sizeLimit) {
		int startLocation = deterministicRandom()->randomInt(0, nodes);
		int scale = deterministicRandom()->randomInt(
		    0, deterministicRandom()->randomInt(2, 5) * deterministicRandom()->randomInt(2, 5));
		int endLocation = startLocation + deterministicRandom()->randomInt(
		                                      0, 1 + std::min(sizeLimit, std::min(nodes - startLocation, 1 << scale)));

		return KeyRangeRef(getKeyForIndex(startLocation), getKeyForIndex(endLocation));
	}

	Value applyAtomicOp(Optional<StringRef> existingValue, Value value, MutationRef::Type type) {
		Arena arena;
		if (type == MutationRef::SetValue)
			return value;
		else if (type == MutationRef::AddValue)
			return doLittleEndianAdd(existingValue, value, arena);
		else if (type == MutationRef::AppendIfFits)
			return doAppendIfFits(existingValue, value, arena);
		else if (type == MutationRef::And)
			return doAndV2(existingValue, value, arena);
		else if (type == MutationRef::Or)
			return doOr(existingValue, value, arena);
		else if (type == MutationRef::Xor)
			return doXor(existingValue, value, arena);
		else if (type == MutationRef::Max)
			return doMax(existingValue, value, arena);
		else if (type == MutationRef::Min)
			return doMinV2(existingValue, value, arena);
		else if (type == MutationRef::ByteMin)
			return doByteMin(existingValue, value, arena);
		else if (type == MutationRef::ByteMax)
			return doByteMax(existingValue, value, arena);
		ASSERT(false);
		return Value();
	}

																#line 3735 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
// This generated class is to be used only via randomTransaction()
															#line 778 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
template <class RandomTransactionActor>
															#line 778 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class RandomTransactionActorState {
															#line 3741 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
															#line 778 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	RandomTransactionActorState(Database const& cx,WriteDuringReadWorkload* const& self,double const& testStartTime) 
															#line 778 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															#line 778 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		 : cx(cx),
															#line 778 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   self(self),
															#line 778 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   testStartTime(testStartTime),
															#line 779 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   tr(cx),
															#line 780 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readYourWritesDisabled(deterministicRandom()->random01() < 0.5),
															#line 781 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   readAheadDisabled(deterministicRandom()->random01() < 0.5),
															#line 782 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   snapshotRYWDisabled(deterministicRandom()->random01() < 0.5),
															#line 783 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   useBatchPriority(deterministicRandom()->random01() < 0.5),
															#line 784 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   timebomb((FLOW_KNOBS->MAX_BUGGIFIED_DELAY == 0.0 && deterministicRandom()->random01() < 0.01) ? deterministicRandom()->randomInt64(1, 6000) : 0),
															#line 788 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   operations(),
															#line 789 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   commits(false),
															#line 790 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   watches(),
															#line 791 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   changeNum(1),
															#line 792 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   doingCommit(false),
															#line 793 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   waitLocation(0),
															#line 794 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   startTime(now()),
															#line 796 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableGetKey(BUGGIFY),
															#line 797 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableGetRange(BUGGIFY),
															#line 798 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableGet(BUGGIFY),
															#line 799 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableCommit(BUGGIFY),
															#line 800 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableClearRange(BUGGIFY),
															#line 801 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableClear(BUGGIFY),
															#line 802 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableWatch(BUGGIFY),
															#line 803 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableWriteConflictRange(BUGGIFY),
															#line 804 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableDelay(BUGGIFY),
															#line 805 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableReset(BUGGIFY),
															#line 806 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableReadConflictRange(BUGGIFY),
															#line 807 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableSet(BUGGIFY),
															#line 808 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   disableAtomicOp(BUGGIFY),
															#line 810 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		   timebombStr(makeString(8))
															#line 3806 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("randomTransaction", reinterpret_cast<unsigned long>(this));

	}
	~RandomTransactionActorState() 
	{
		fdb_probe_actor_destroy("randomTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 811 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			uint8_t* data = mutateString(timebombStr);
															#line 812 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			memcpy(data, &timebomb, 8);
															#line 814 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			;
															#line 3825 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RandomTransactionActorState();
		static_cast<RandomTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1101 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->memoryDatabase = self->lastCommittedDatabase;
															#line 1102 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(allKeys, false);
															#line 1103 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!static_cast<RandomTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RandomTransactionActorState(); static_cast<RandomTransactionActor*>(this)->destroy(); return 0; }
															#line 3852 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		new (&static_cast<RandomTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RandomTransactionActorState();
		static_cast<RandomTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 815 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (now() - testStartTime > self->testDuration)
															#line 3871 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 816 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (!static_cast<RandomTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RandomTransactionActorState(); static_cast<RandomTransactionActor*>(this)->destroy(); return 0; }
															#line 3875 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			new (&static_cast<RandomTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RandomTransactionActorState();
			static_cast<RandomTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 819 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		memLimit = 1e8;
															#line 820 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		cancelled = false;
															#line 821 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (readYourWritesDisabled)
															#line 3887 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 822 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 3891 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 823 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (snapshotRYWDisabled)
															#line 3895 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 824 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.setOption(FDBTransactionOptions::SNAPSHOT_RYW_DISABLE);
															#line 3899 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 825 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (readAheadDisabled)
															#line 3903 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 826 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_AHEAD_DISABLE);
															#line 3907 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 827 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (useBatchPriority)
															#line 3911 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 828 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_BATCH);
															#line 3915 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 829 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (self->useSystemKeys)
															#line 3919 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 830 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 3923 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
															#line 831 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		tr.setOption(FDBTransactionOptions::TIMEOUT, timebombStr);
															#line 832 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		tr.addWriteConflictRange(self->conflictRange);
															#line 833 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(self->conflictRange, true);
															#line 3931 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		try {
															#line 835 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			numWaits = deterministicRandom()->randomInt(1, 5);
															#line 836 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			i = 0;
															#line 837 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			;
															#line 3939 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1072 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			operations.clear();
															#line 1073 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			commits.clear(false);
															#line 1074 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			waitLocation = 0;
															#line 1075 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			watches.clear();
															#line 1076 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			self->changeCount.insert(allKeys, 0);
															#line 1077 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			doingCommit = false;
															#line 1079 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_database_locked)
															#line 3986 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 1080 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				self->memoryDatabase = self->lastCommittedDatabase;
															#line 1081 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				self->addedConflicts.insert(allKeys, false);
															#line 1082 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (!static_cast<RandomTransactionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RandomTransactionActorState(); static_cast<RandomTransactionActor*>(this)->destroy(); return 0; }
															#line 3994 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				new (&static_cast<RandomTransactionActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RandomTransactionActorState();
				static_cast<RandomTransactionActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1084 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_not_committed || e.code() == error_code_commit_unknown_result || e.code() == error_code_transaction_too_large || e.code() == error_code_key_too_large || e.code() == error_code_value_too_large || e.code() == error_code_too_many_watches || cancelled)
															#line 4002 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 1087 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				return a_body1Catch1(not_committed(), std::max(0, loopDepth - 1));
															#line 4006 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			}
			try {
															#line 1089 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				StrictFuture<Void> __when_expr_6 = tr.onError(e);
															#line 1089 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 4013 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
				static_cast<RandomTransactionActor*>(this)->actor_wait_state = 7;
															#line 1089 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 6, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 4018 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
															#line 1063 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(operations);
															#line 1063 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4041 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_2.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 3;
															#line 1063 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 2, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 4046 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 837 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!(i < numWaits && memLimit > 0))
															#line 4062 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 839 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		numOps = deterministicRandom()->randomInt(1, self->numOps);
															#line 840 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		j = 0;
															#line 841 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		;
															#line 4072 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 1055 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (waitLocation < operations.size())
															#line 4094 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 1056 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			int waitOp = deterministicRandom()->randomInt(waitLocation, operations.size());
															#line 1058 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			StrictFuture<Void> __when_expr_0 = operations[waitOp];
															#line 1058 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4102 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1cont1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RandomTransactionActor*>(this)->actor_wait_state = 1;
															#line 1058 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 0, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 4107 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1(int loopDepth) 
	{
															#line 841 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (!(j < numOps && memLimit > 0))
															#line 4128 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 842 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (commits.getResult().isError())
															#line 4134 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		{
															#line 843 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			return a_body1loopBody1Catch1(commits.getResult().getError(), std::max(0, loopDepth - 2));
															#line 4138 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
		try {
															#line 845 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			operationType = deterministicRandom()->randomInt(0, 21);
															#line 846 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (operationType == 0 && !disableGetKey)
															#line 4145 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 847 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				operations.push_back( self->getKeyAndCompare(&tr, self->getRandomKeySelector(), Snapshot{ deterministicRandom()->coinflip() }, readYourWritesDisabled, snapshotRYWDisabled, self, &doingCommit, &memLimit));
															#line 4149 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			}
			else
			{
															#line 856 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (operationType == 1 && !disableGetRange)
															#line 4155 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 857 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					operations.push_back( self->getRangeAndCompare(&tr, self->getRandomKeySelector(), self->getRandomKeySelector(), self->getRandomLimits(), Snapshot{ deterministicRandom()->coinflip() }, Reverse{ deterministicRandom()->coinflip() }, readYourWritesDisabled, snapshotRYWDisabled, self, &doingCommit, &memLimit));
															#line 4159 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				}
				else
				{
															#line 869 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					if (operationType == 2 && !disableGet)
															#line 4165 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					{
															#line 870 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						operations.push_back(self->getAndCompare(&tr, self->getRandomKey(), Snapshot{ deterministicRandom()->coinflip() }, readYourWritesDisabled, snapshotRYWDisabled, self, &doingCommit, &memLimit));
															#line 4169 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
					}
					else
					{
															#line 878 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
						if (operationType == 3 && !disableCommit)
															#line 4175 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
						{
															#line 879 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
							if (!self->rarelyCommit || deterministicRandom()->random01() < 1.0 / self->numOps)
															#line 4179 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
							{
															#line 880 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								Future<Void> commit = self->commitAndUpdateMemory(&tr, self, &cancelled, readYourWritesDisabled, snapshotRYWDisabled, readAheadDisabled, useBatchPriority, &doingCommit, &startTime, timebombStr);
															#line 890 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								operations.push_back(commit);
															#line 891 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								commits.add(commit);
															#line 4187 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
							}
						}
						else
						{
															#line 893 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
							if (operationType == 4 && !disableClearRange)
															#line 4194 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
							{
															#line 894 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								KeyRange range = self->getRandomRange(self->maxClearSize);
															#line 895 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								self->changeCount.insert(range, changeNum++);
															#line 896 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								bool noConflict = deterministicRandom()->random01() < 0.5;
															#line 898 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								if (noConflict)
															#line 4204 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
								{
															#line 899 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									tr.setOption(FDBTransactionOptions::NEXT_WRITE_NO_WRITE_CONFLICT_RANGE);
															#line 4208 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
								}
															#line 900 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								tr.clear(range);
															#line 901 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								if (!noConflict)
															#line 4214 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
								{
															#line 902 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									KeyRangeRef conflict( range.begin.substr( 0, std::min<int>(range.begin.size(), getMaxClearKeySize(range.begin) + 1)), range.end.substr( 0, std::min<int>(range.end.size(), getMaxClearKeySize(range.end) + 1)));
															#line 907 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									self->addedConflicts.insert(conflict, true);
															#line 4220 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
								}
															#line 909 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								self->memoryDatabase.erase(self->memoryDatabase.lower_bound(range.begin), self->memoryDatabase.lower_bound(range.end));
															#line 4224 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
							}
							else
							{
															#line 911 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
								if (operationType == 5 && !disableClear)
															#line 4230 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
								{
															#line 912 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									Key key = self->getRandomKey();
															#line 913 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									self->changeCount.insert(key, changeNum++);
															#line 914 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									bool noConflict = deterministicRandom()->random01() < 0.5;
															#line 916 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									if (noConflict)
															#line 4240 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
									{
															#line 917 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
										tr.setOption(FDBTransactionOptions::NEXT_WRITE_NO_WRITE_CONFLICT_RANGE);
															#line 4244 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
									}
															#line 918 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									tr.clear(key);
															#line 919 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									if (!noConflict && key.size() <= getMaxClearKeySize(key))
															#line 4250 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
									{
															#line 920 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
										self->addedConflicts.insert(key, true);
															#line 4254 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
									}
															#line 922 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									self->memoryDatabase.erase(key);
															#line 4258 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
								}
								else
								{
															#line 923 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
									if (operationType == 6 && !disableWatch)
															#line 4264 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
									{
															#line 924 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
										watches.push_back(self->watchAndCompare( &tr, self->getRandomKey(), readYourWritesDisabled, self, &doingCommit, &memLimit));
															#line 4268 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
									}
									else
									{
															#line 926 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
										if (operationType == 7 && !disableWriteConflictRange)
															#line 4274 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
										{
															#line 927 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
											KeyRange range = self->getRandomRange(self->nodes);
															#line 929 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
											tr.addWriteConflictRange(range);
															#line 930 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
											KeyRangeRef conflict( range.begin.substr( 0, std::min<int>(range.begin.size(), getMaxKeySize(range.begin) + 1)), range.end.substr(0, std::min<int>(range.end.size(), getMaxKeySize(range.end) + 1)));
															#line 934 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
											self->addedConflicts.insert(conflict, true);
															#line 4284 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
										}
										else
										{
															#line 935 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
											if (operationType == 8 && !disableDelay)
															#line 4290 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
											{
															#line 936 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
												double maxTime = 6.0;
															#line 937 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
												if (timebomb > 0)
															#line 4296 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
												{
															#line 938 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
													maxTime = startTime + timebomb / 1000.0 - now();
															#line 4300 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
												}
															#line 939 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
												operations.push_back( delay(deterministicRandom()->random01() * deterministicRandom()->random01() * deterministicRandom()->random01() * maxTime));
															#line 4304 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
											}
											else
											{
															#line 942 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
												if (operationType == 9 && !disableReset)
															#line 4310 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
												{
															#line 943 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
													if (deterministicRandom()->random01() < 0.001)
															#line 4314 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
													{
															#line 945 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														tr.reset();
															#line 946 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														self->memoryDatabase = self->lastCommittedDatabase;
															#line 947 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														self->addedConflicts.insert(allKeys, false);
															#line 948 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														if (readYourWritesDisabled)
															#line 4324 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
														{
															#line 949 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															tr.setOption(FDBTransactionOptions::READ_YOUR_WRITES_DISABLE);
															#line 4328 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
														}
															#line 950 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														if (snapshotRYWDisabled)
															#line 4332 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
														{
															#line 951 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															tr.setOption(FDBTransactionOptions::SNAPSHOT_RYW_DISABLE);
															#line 4336 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
														}
															#line 952 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														if (readAheadDisabled)
															#line 4340 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
														{
															#line 953 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															tr.setOption(FDBTransactionOptions::READ_AHEAD_DISABLE);
															#line 4344 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
														}
															#line 954 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														if (self->useSystemKeys)
															#line 4348 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
														{
															#line 955 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 4352 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
														}
															#line 956 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														tr.addWriteConflictRange(self->conflictRange);
															#line 957 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														self->addedConflicts.insert(self->conflictRange, true);
															#line 958 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														startTime = now();
															#line 959 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														tr.setOption(FDBTransactionOptions::TIMEOUT, timebombStr);
															#line 4362 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
													}
												}
												else
												{
															#line 961 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
													if (operationType == 10 && !disableReadConflictRange)
															#line 4369 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
													{
															#line 962 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														KeyRange range = self->getRandomRange(self->maxClearSize);
															#line 963 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														tr.addReadConflictRange(range);
															#line 4375 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
													}
													else
													{
															#line 964 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
														if (operationType == 11 && !disableAtomicOp)
															#line 4381 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
														{
															#line 965 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															if (!self->useSystemKeys && deterministicRandom()->random01() < 0.01)
															#line 4385 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
															{
															#line 966 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																Key versionStampKey = self->getRandomVersionStampKey();
															#line 967 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																Value value = self->getRandomValue();
															#line 968 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																KeyRangeRef range = getVersionstampKeyRange(versionStampKey.arena(), versionStampKey, tr.getCachedReadVersion(), normalKeys.end);
															#line 972 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																self->changeCount.insert(range, changeNum++);
															#line 974 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																tr.atomicOp(versionStampKey, value, MutationRef::SetVersionstampedKey);
															#line 975 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																tr.clear(range);
															#line 976 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																KeyRangeRef conflict( range.begin.substr( 0, std::min<int>(range.begin.size(), getMaxClearKeySize(range.begin) + 1)), range.end.substr( 0, std::min<int>(range.end.size(), getMaxClearKeySize(range.end) + 1)));
															#line 981 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																self->addedConflicts.insert(conflict, true);
															#line 982 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																self->memoryDatabase.erase(self->memoryDatabase.lower_bound(range.begin), self->memoryDatabase.lower_bound(range.end));
															#line 4405 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
															}
															else
															{
															#line 985 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																Key key = self->getRandomKey();
															#line 986 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																Value value = self->getRandomValue();
															#line 987 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																MutationRef::Type opType;
															#line 988 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																switch (deterministicRandom()->randomInt(0, 8)) { case 0: opType = MutationRef::AddValue; break; case 1: opType = MutationRef::And; break; case 2: opType = MutationRef::Or; break; case 3: opType = MutationRef::Xor; break; case 4: opType = MutationRef::Max; break; case 5: opType = MutationRef::Min; break; case 6: opType = MutationRef::ByteMin; break; case 7: opType = MutationRef::ByteMax; break; };
															#line 1014 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																self->changeCount.insert(key, changeNum++);
															#line 1015 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																bool noConflict = deterministicRandom()->random01() < 0.5;
															#line 1017 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																if (noConflict)
															#line 4423 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
																{
															#line 1018 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																	tr.setOption(FDBTransactionOptions::NEXT_WRITE_NO_WRITE_CONFLICT_RANGE);
															#line 4427 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
																}
															#line 1019 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																tr.atomicOp(key, value, opType);
															#line 1021 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																if (!noConflict && key.size() <= getMaxWriteKeySize(key, self->useSystemKeys))
															#line 4433 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
																{
															#line 1022 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																	self->addedConflicts.insert(key, true);
															#line 4437 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
																}
															#line 1024 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																Optional<Value> existing = self->memoryGet(&self->memoryDatabase, key);
															#line 1025 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																self->memoryDatabase[key] = self->applyAtomicOp(existing.present() ? Optional<StringRef>(existing.get()) : Optional<StringRef>(), value, opType);
															#line 4443 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
															}
														}
														else
														{
															#line 1031 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
															if (operationType > 11 && !disableSet)
															#line 4450 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
															{
															#line 1032 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																Key key = self->getRandomKey();
															#line 1033 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																Value value = self->getRandomValue();
															#line 1034 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																self->changeCount.insert(key, changeNum++);
															#line 1035 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																bool noConflict = deterministicRandom()->random01() < 0.5;
															#line 1037 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																if (noConflict)
															#line 4462 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
																{
															#line 1038 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																	tr.setOption(FDBTransactionOptions::NEXT_WRITE_NO_WRITE_CONFLICT_RANGE);
															#line 4466 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
																}
															#line 1039 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																tr.set(key, value);
															#line 1040 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																if (!noConflict && key.size() <= getMaxWriteKeySize(key, self->useSystemKeys))
															#line 4472 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
																{
															#line 1041 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																	self->addedConflicts.insert(key, true);
															#line 4476 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
																}
															#line 1044 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
																self->memoryDatabase[key] = value;
															#line 4480 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			loopDepth = a_body1loopBody1loopBody1loopBody1cont47(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 841 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		j++;
															#line 4521 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1047 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_used_during_commit)
															#line 4531 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 1048 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				ASSERT(doingCommit);
															#line 4535 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1049 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				if (e.code() != error_code_transaction_cancelled)
															#line 4541 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				{
															#line 1050 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
					return a_body1loopBody1Catch1(e, std::max(0, loopDepth - 2));
															#line 4545 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
				}
			}
			loopDepth = a_body1loopBody1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont47(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(int loopDepth) 
	{
															#line 837 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		i++;
															#line 4575 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 1059 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.000001);
															#line 1059 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4586 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1cont4when1(__when_expr_1.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 2;
															#line 1059 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 1, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 4591 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 1059 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(0.000001);
															#line 1059 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4602 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1cont4when1(__when_expr_1.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 2;
															#line 1059 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 1, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 4607 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTransactionActor*>(this)->ActorCallback< RandomTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RandomTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 1060 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		waitLocation = operations.size();
															#line 4691 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 1060 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		waitLocation = operations.size();
															#line 4700 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTransactionActor*>(this)->ActorCallback< RandomTransactionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RandomTransactionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 1064 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		ASSERT(timebomb == 0 || 1000 * (now() - startTime) <= timebomb + 1);
															#line 1065 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr.debug_onIdle();
															#line 1065 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4788 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 4;
															#line 1065 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 3, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 4793 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 1064 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		ASSERT(timebomb == 0 || 1000 * (now() - startTime) <= timebomb + 1);
															#line 1065 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr.debug_onIdle();
															#line 1065 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4806 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_3.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 4;
															#line 1065 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 3, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 4811 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTransactionActor*>(this)->ActorCallback< RandomTransactionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RandomTransactionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 1066 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(0.000001);
															#line 1066 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4897 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont10when1(__when_expr_4.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 5;
															#line 1066 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 4, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 4902 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 1066 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(0.000001);
															#line 1066 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4913 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont10when1(__when_expr_4.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 5;
															#line 1066 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 4, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 4918 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTransactionActor*>(this)->ActorCallback< RandomTransactionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RandomTransactionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 1067 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->finished.trigger();
															#line 1068 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_5 = waitForAll(watches);
															#line 1068 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5006 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont10cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 6;
															#line 1068 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 5, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 5011 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10cont1(Void && _,int loopDepth) 
	{
															#line 1067 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->finished.trigger();
															#line 1068 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		StrictFuture<Void> __when_expr_5 = waitForAll(watches);
															#line 1068 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5024 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont10cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<RandomTransactionActor*>(this)->actor_wait_state = 6;
															#line 1068 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< RandomTransactionActor, 5, Void >*>(static_cast<RandomTransactionActor*>(this)));
															#line 5029 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTransactionActor*>(this)->ActorCallback< RandomTransactionActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< RandomTransactionActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont10cont2(Void const& _,int loopDepth) 
	{
															#line 1069 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->changeCount.insert(allKeys, 0);
															#line 5113 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont10cont2(Void && _,int loopDepth) 
	{
															#line 1069 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->changeCount.insert(allKeys, 0);
															#line 5122 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTransactionActor*>(this)->ActorCallback< RandomTransactionActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< RandomTransactionActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
															#line 1097 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->memoryDatabase = self->lastCommittedDatabase;
															#line 1098 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
		self->addedConflicts.insert(allKeys, false);
															#line 5208 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1091 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			if (e.code() == error_code_transaction_timed_out)
															#line 5218 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			{
															#line 1092 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				ASSERT(timebomb != 0 && 1000 * (now() - startTime) >= timebomb - 1);
															#line 1093 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
				return a_body1Catch1(not_committed(), std::max(0, loopDepth - 1));
															#line 5224 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
			}
															#line 1095 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5228 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<RandomTransactionActor*>(this)->actor_wait_state > 0) static_cast<RandomTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<RandomTransactionActor*>(this)->ActorCallback< RandomTransactionActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< RandomTransactionActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< RandomTransactionActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 778 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Database cx;
															#line 778 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	WriteDuringReadWorkload* self;
															#line 778 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	double testStartTime;
															#line 779 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 780 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readYourWritesDisabled;
															#line 781 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool readAheadDisabled;
															#line 782 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool snapshotRYWDisabled;
															#line 783 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool useBatchPriority;
															#line 784 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t timebomb;
															#line 788 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	std::vector<Future<Void>> operations;
															#line 789 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	ActorCollection commits;
															#line 790 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	std::vector<Future<Void>> watches;
															#line 791 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int changeNum;
															#line 792 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool doingCommit;
															#line 793 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int waitLocation;
															#line 794 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	double startTime;
															#line 796 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableGetKey;
															#line 797 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableGetRange;
															#line 798 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableGet;
															#line 799 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableCommit;
															#line 800 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableClearRange;
															#line 801 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableClear;
															#line 802 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableWatch;
															#line 803 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableWriteConflictRange;
															#line 804 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableDelay;
															#line 805 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableReset;
															#line 806 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableReadConflictRange;
															#line 807 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableSet;
															#line 808 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool disableAtomicOp;
															#line 810 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	Key timebombStr;
															#line 819 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int64_t memLimit;
															#line 820 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	bool cancelled;
															#line 835 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int numWaits;
															#line 836 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int i;
															#line 839 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int numOps;
															#line 840 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int j;
															#line 845 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	int operationType;
															#line 5412 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
};
// This generated class is to be used only via randomTransaction()
															#line 778 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
class RandomTransactionActor final : public Actor<Void>, public ActorCallback< RandomTransactionActor, 0, Void >, public ActorCallback< RandomTransactionActor, 1, Void >, public ActorCallback< RandomTransactionActor, 2, Void >, public ActorCallback< RandomTransactionActor, 3, Void >, public ActorCallback< RandomTransactionActor, 4, Void >, public ActorCallback< RandomTransactionActor, 5, Void >, public ActorCallback< RandomTransactionActor, 6, Void >, public FastAllocated<RandomTransactionActor>, public RandomTransactionActorState<RandomTransactionActor> {
															#line 5417 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
public:
	using FastAllocated<RandomTransactionActor>::operator new;
	using FastAllocated<RandomTransactionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5908571733078549760UL, 14219442823615613952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RandomTransactionActor, 0, Void >;
friend struct ActorCallback< RandomTransactionActor, 1, Void >;
friend struct ActorCallback< RandomTransactionActor, 2, Void >;
friend struct ActorCallback< RandomTransactionActor, 3, Void >;
friend struct ActorCallback< RandomTransactionActor, 4, Void >;
friend struct ActorCallback< RandomTransactionActor, 5, Void >;
friend struct ActorCallback< RandomTransactionActor, 6, Void >;
															#line 778 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	RandomTransactionActor(Database const& cx,WriteDuringReadWorkload* const& self,double const& testStartTime) 
															#line 5440 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RandomTransactionActorState<RandomTransactionActor>(cx, self, testStartTime),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("randomTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15887765483757040128UL, 8877054762753181952UL);
		ActorExecutionContextHelper __helper(static_cast<RandomTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("randomTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("randomTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RandomTransactionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RandomTransactionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RandomTransactionActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RandomTransactionActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< RandomTransactionActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< RandomTransactionActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< RandomTransactionActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 778 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
[[nodiscard]] Future<Void> randomTransaction( Database const& cx, WriteDuringReadWorkload* const& self, double const& testStartTime ) {
															#line 778 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
	return Future<Void>(new RandomTransactionActor(cx, self, testStartTime));
															#line 5478 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteDuringRead.actor.g.cpp.py_gen"
}

#line 1105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/WriteDuringRead.actor.cpp"
};

WorkloadFactory<WriteDuringReadWorkload> WriteDuringReadWorkloadFactory;
