#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
/*
 * SuspendProcesses.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <boost/algorithm/string/predicate.hpp>

#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbclient/Status.h"
#include "fdbclient/StatusClient.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "flow/actorcompiler.h" // has to be last include

struct SuspendProcessesWorkload : TestWorkload {
	static constexpr auto NAME = "SuspendProcesses";
	std::vector<std::string> prefixSuspendProcesses;
	double suspendTimeDuration;
	double waitTimeDuration;

	SuspendProcessesWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		prefixSuspendProcesses = getOption(options, "prefixesSuspendProcesses"_sr, std::vector<std::string>());
		waitTimeDuration = getOption(options, "waitTimeDuration"_sr, 0);
		suspendTimeDuration = getOption(options, "suspendTimeDuration"_sr, 0);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

																#line 47 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 45 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
template <class _startActor>
															#line 45 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
class _startActorState {
															#line 53 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
public:
															#line 45 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
	_startActorState(Database const& cx,SuspendProcessesWorkload* const& self) 
															#line 45 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
															#line 45 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		 : cx(cx),
															#line 45 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		   self(self)
															#line 62 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 46 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->waitTimeDuration);
															#line 46 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 79 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 46 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 84 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 48 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		;
															#line 109 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 47 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 48 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		;
															#line 120 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 50 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 51 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 52 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = tr.getRange(KeyRangeRef("\xff\xff/worker_interfaces/"_sr, "\xff\xff/worker_interfaces0"_sr), CLIENT_KNOBS->TOO_MANY);
															#line 52 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 218 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 52 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, RangeResult >*>(static_cast<_startActor*>(this)));
															#line 223 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 73 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 247 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 73 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 252 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(RangeResult const& kvs,int loopDepth) 
	{
															#line 55 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		ASSERT(!kvs.more);
															#line 56 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		std::vector<Standalone<StringRef>> suspendProcessInterfaces;
															#line 57 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		for( auto it : kvs ) {
															#line 58 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			auto ip_port = (it.key.endsWith(":tls"_sr) ? it.key.removeSuffix(":tls"_sr) : it.key) .removePrefix("\xff\xff/worker_interfaces/"_sr);
															#line 60 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			for( auto& killProcess : self->prefixSuspendProcesses ) {
															#line 61 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
				if (boost::starts_with(ip_port.toString().c_str(), killProcess.c_str()))
															#line 277 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
				{
															#line 62 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
					suspendProcessInterfaces.push_back(it.value);
															#line 63 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
					TraceEvent("SuspendProcessSelectedProcess").detail("IpPort", printable(ip_port));
															#line 283 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
				}
			}
		}
															#line 67 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		for( auto& interf : suspendProcessInterfaces ) {
															#line 68 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			BinaryReader::fromStringRef<ClientWorkerInterface>(interf, IncludeVersion()) .reboot.send(RebootRequest(false, false, self->suspendTimeDuration));
															#line 291 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
		}
															#line 71 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 295 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(RangeResult && kvs,int loopDepth) 
	{
															#line 55 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		ASSERT(!kvs.more);
															#line 56 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		std::vector<Standalone<StringRef>> suspendProcessInterfaces;
															#line 57 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		for( auto it : kvs ) {
															#line 58 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			auto ip_port = (it.key.endsWith(":tls"_sr) ? it.key.removeSuffix(":tls"_sr) : it.key) .removePrefix("\xff\xff/worker_interfaces/"_sr);
															#line 60 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			for( auto& killProcess : self->prefixSuspendProcesses ) {
															#line 61 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
				if (boost::starts_with(ip_port.toString().c_str(), killProcess.c_str()))
															#line 317 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
				{
															#line 62 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
					suspendProcessInterfaces.push_back(it.value);
															#line 63 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
					TraceEvent("SuspendProcessSelectedProcess").detail("IpPort", printable(ip_port));
															#line 323 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
				}
			}
		}
															#line 67 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		for( auto& interf : suspendProcessInterfaces ) {
															#line 68 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
			BinaryReader::fromStringRef<ClientWorkerInterface>(interf, IncludeVersion()) .reboot.send(RebootRequest(false, false, self->suspendTimeDuration));
															#line 331 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
		}
															#line 71 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 335 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult const& kvs,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(kvs, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(RangeResult && kvs,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(kvs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 45 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
	Database cx;
															#line 45 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
	SuspendProcessesWorkload* self;
															#line 47 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 511 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 45 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, RangeResult >, public ActorCallback< _startActor, 2, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 516 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9317043477401263616UL, 4129500801666269952UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, RangeResult >;
friend struct ActorCallback< _startActor, 2, Void >;
															#line 45 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
	_startActor(Database const& cx,SuspendProcessesWorkload* const& self) 
															#line 535 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 45 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, SuspendProcessesWorkload* const& self ) {
															#line 45 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 569 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SuspendProcesses.actor.g.cpp.py_gen"
}

#line 77 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/SuspendProcesses.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<SuspendProcessesWorkload> SuspendProcessesWorkloadFactory;
