#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
/*
 * ReadAfterWrite.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <vector>

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/genericactors.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// If the log->storage propagation delay is longer than 1 second, then it's likely that our read
// will see a `future_version` error from the storage server.  We need to retry the read until
// a value is returned, or a different error is thrown.
															#line 33 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via latencyOfRead()
															#line 31 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
template <class LatencyOfReadActor>
															#line 31 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
class LatencyOfReadActorState {
															#line 40 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
public:
															#line 31 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	LatencyOfReadActorState(Transaction* const& tr,Key const& k) 
															#line 31 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
															#line 31 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		 : tr(tr),
															#line 31 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		   k(k),
															#line 32 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		   start(timer())
															#line 51 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("latencyOfRead", reinterpret_cast<unsigned long>(this));

	}
	~LatencyOfReadActorState() 
	{
		fdb_probe_actor_destroy("latencyOfRead", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 33 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			;
															#line 66 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LatencyOfReadActorState();
		static_cast<LatencyOfReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 44 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		if (!static_cast<LatencyOfReadActor*>(this)->SAV<double>::futures) { (void)(timer() - start); this->~LatencyOfReadActorState(); static_cast<LatencyOfReadActor*>(this)->destroy(); return 0; }
															#line 89 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		new (&static_cast<LatencyOfReadActor*>(this)->SAV< double >::value()) double(timer() - start);
		this->~LatencyOfReadActorState();
		static_cast<LatencyOfReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 35 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(tr->get(k));
															#line 35 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			if (static_cast<LatencyOfReadActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 111 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LatencyOfReadActor*>(this)->actor_wait_state = 1;
															#line 35 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LatencyOfReadActor, 0, Void >*>(static_cast<LatencyOfReadActor*>(this)));
															#line 116 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 38 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			if (e.code() == error_code_future_version)
															#line 145 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
			{
				return a_body1loopHead1(loopDepth); // continue
			}
															#line 41 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 151 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LatencyOfReadActor*>(this)->actor_wait_state > 0) static_cast<LatencyOfReadActor*>(this)->actor_wait_state = 0;
		static_cast<LatencyOfReadActor*>(this)->ActorCallback< LatencyOfReadActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LatencyOfReadActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("latencyOfRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyOfReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyOfRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LatencyOfReadActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("latencyOfRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyOfReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyOfRead", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LatencyOfReadActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("latencyOfRead", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyOfReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("latencyOfRead", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 31 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	Transaction* tr;
															#line 31 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	Key k;
															#line 32 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	double start;
															#line 254 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via latencyOfRead()
															#line 31 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
class LatencyOfReadActor final : public Actor<double>, public ActorCallback< LatencyOfReadActor, 0, Void >, public FastAllocated<LatencyOfReadActor>, public LatencyOfReadActorState<LatencyOfReadActor> {
															#line 259 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<LatencyOfReadActor>::operator new;
	using FastAllocated<LatencyOfReadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3277519146578931968UL, 9445060216849877504UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<double>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LatencyOfReadActor, 0, Void >;
															#line 31 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	LatencyOfReadActor(Transaction* const& tr,Key const& k) 
															#line 276 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		 : Actor<double>(),
		   LatencyOfReadActorState<LatencyOfReadActor>(tr, k),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("latencyOfRead", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6598983437488590080UL, 2899978730344229120UL);
		ActorExecutionContextHelper __helper(static_cast<LatencyOfReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("latencyOfRead");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("latencyOfRead", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LatencyOfReadActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 31 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
[[nodiscard]] Future<double> latencyOfRead( Transaction* const& tr, Key const& k ) {
															#line 31 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	return Future<double>(new LatencyOfReadActor(tr, k));
															#line 309 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
}

#line 46 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"

// Measure the latency of a storage server making a committed value available for reading.
struct ReadAfterWriteWorkload : KVWorkload {
	static constexpr auto NAME = "ReadAfterWrite";

	double testDuration;
	DDSketch<double> propagationLatency;

	ReadAfterWriteWorkload(WorkloadContext const& wcx) : KVWorkload(wcx), propagationLatency() {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

																#line 327 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
// This generated class is to be used only via benchmark()
															#line 60 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
template <class BenchmarkActor>
															#line 60 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
class BenchmarkActorState {
															#line 333 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
public:
															#line 60 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	BenchmarkActorState(Database const& cx,ReadAfterWriteWorkload* const& self) 
															#line 60 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
															#line 60 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		 : cx(cx),
															#line 60 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		   self(self)
															#line 342 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("benchmark", reinterpret_cast<unsigned long>(this));

	}
	~BenchmarkActorState() 
	{
		fdb_probe_actor_destroy("benchmark", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 61 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			;
															#line 357 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BenchmarkActorState();
		static_cast<BenchmarkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 62 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		key = self->getRandomKey();
															#line 63 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		writeTr = Transaction(cx);
															#line 64 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		baselineReadTr = Transaction(cx);
															#line 65 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		afterWriteTr = Transaction(cx);
															#line 393 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		try {
															#line 68 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			StrictFuture<Version> __when_expr_0 = writeTr.getReadVersion();
															#line 68 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			if (static_cast<BenchmarkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 399 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BenchmarkActor*>(this)->actor_wait_state = 1;
															#line 68 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BenchmarkActor, 0, Version >*>(static_cast<BenchmarkActor*>(this)));
															#line 404 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 99 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			StrictFuture<Void> __when_expr_4 = writeTr.onError(e);
															#line 99 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			if (static_cast<BenchmarkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 428 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<BenchmarkActor*>(this)->actor_wait_state = 5;
															#line 99 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BenchmarkActor, 4, Void >*>(static_cast<BenchmarkActor*>(this)));
															#line 433 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 74 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = writeTr.get(key);
															#line 74 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		if (static_cast<BenchmarkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 450 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<BenchmarkActor*>(this)->actor_wait_state = 2;
															#line 74 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BenchmarkActor, 1, Optional<Value> >*>(static_cast<BenchmarkActor*>(this)));
															#line 455 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& __readVersion,int loopDepth) 
	{
															#line 68 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		readVersion = __readVersion;
															#line 464 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && __readVersion,int loopDepth) 
	{
		readVersion = std::move(__readVersion);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BenchmarkActor*>(this)->actor_wait_state > 0) static_cast<BenchmarkActor*>(this)->actor_wait_state = 0;
		static_cast<BenchmarkActor*>(this)->ActorCallback< BenchmarkActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< BenchmarkActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BenchmarkActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BenchmarkActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Value> const& value,int loopDepth) 
	{
															#line 75 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		if (value.present())
															#line 543 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		{
															#line 76 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			writeTr.set(key, value.get());
															#line 547 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		}
		else
		{
															#line 78 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			writeTr.clear(key);
															#line 553 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		}
															#line 81 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		StrictFuture<Void> __when_expr_2 = writeTr.commit();
															#line 81 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		if (static_cast<BenchmarkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 559 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<BenchmarkActor*>(this)->actor_wait_state = 3;
															#line 81 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BenchmarkActor, 2, Void >*>(static_cast<BenchmarkActor*>(this)));
															#line 564 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && value,int loopDepth) 
	{
															#line 75 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		if (value.present())
															#line 573 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		{
															#line 76 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			writeTr.set(key, value.get());
															#line 577 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		}
		else
		{
															#line 78 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			writeTr.clear(key);
															#line 583 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		}
															#line 81 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		StrictFuture<Void> __when_expr_2 = writeTr.commit();
															#line 81 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		if (static_cast<BenchmarkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 589 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<BenchmarkActor*>(this)->actor_wait_state = 3;
															#line 81 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BenchmarkActor, 2, Void >*>(static_cast<BenchmarkActor*>(this)));
															#line 594 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BenchmarkActor*>(this)->actor_wait_state > 0) static_cast<BenchmarkActor*>(this)->actor_wait_state = 0;
		static_cast<BenchmarkActor*>(this)->ActorCallback< BenchmarkActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< BenchmarkActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BenchmarkActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BenchmarkActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		Version commitVersion = writeTr.getCommittedVersion();
															#line 85 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		baselineReadTr.setVersion(readVersion);
															#line 86 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		afterWriteTr.setVersion(commitVersion);
															#line 88 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		baselineLatency = 0;
															#line 89 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		afterWriteLatency = 0;
															#line 91 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(baselineLatency, latencyOfRead(&baselineReadTr, key)) && store(afterWriteLatency, latencyOfRead(&afterWriteTr, key));
															#line 91 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		if (static_cast<BenchmarkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 690 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<BenchmarkActor*>(this)->actor_wait_state = 4;
															#line 91 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BenchmarkActor, 3, Void >*>(static_cast<BenchmarkActor*>(this)));
															#line 695 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		Version commitVersion = writeTr.getCommittedVersion();
															#line 85 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		baselineReadTr.setVersion(readVersion);
															#line 86 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		afterWriteTr.setVersion(commitVersion);
															#line 88 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		baselineLatency = 0;
															#line 89 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		afterWriteLatency = 0;
															#line 91 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(baselineLatency, latencyOfRead(&baselineReadTr, key)) && store(afterWriteLatency, latencyOfRead(&afterWriteTr, key));
															#line 91 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		if (static_cast<BenchmarkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 716 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<BenchmarkActor*>(this)->actor_wait_state = 4;
															#line 91 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BenchmarkActor, 3, Void >*>(static_cast<BenchmarkActor*>(this)));
															#line 721 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BenchmarkActor*>(this)->actor_wait_state > 0) static_cast<BenchmarkActor*>(this)->actor_wait_state = 0;
		static_cast<BenchmarkActor*>(this)->ActorCallback< BenchmarkActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BenchmarkActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BenchmarkActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BenchmarkActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 97 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		self->propagationLatency.addSample(std::max<double>(afterWriteLatency - baselineLatency, 0));
															#line 805 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 97 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		self->propagationLatency.addSample(std::max<double>(afterWriteLatency - baselineLatency, 0));
															#line 814 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BenchmarkActor*>(this)->actor_wait_state > 0) static_cast<BenchmarkActor*>(this)->actor_wait_state = 0;
		static_cast<BenchmarkActor*>(this)->ActorCallback< BenchmarkActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BenchmarkActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BenchmarkActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BenchmarkActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<BenchmarkActor*>(this)->actor_wait_state > 0) static_cast<BenchmarkActor*>(this)->actor_wait_state = 0;
		static_cast<BenchmarkActor*>(this)->ActorCallback< BenchmarkActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BenchmarkActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BenchmarkActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BenchmarkActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 60 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	Database cx;
															#line 60 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	ReadAfterWriteWorkload* self;
															#line 62 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	Key key;
															#line 63 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	Transaction writeTr;
															#line 64 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	Transaction baselineReadTr;
															#line 65 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	Transaction afterWriteTr;
															#line 68 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	Version readVersion;
															#line 88 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	double baselineLatency;
															#line 89 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	double afterWriteLatency;
															#line 1012 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via benchmark()
															#line 60 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
class BenchmarkActor final : public Actor<Void>, public ActorCallback< BenchmarkActor, 0, Version >, public ActorCallback< BenchmarkActor, 1, Optional<Value> >, public ActorCallback< BenchmarkActor, 2, Void >, public ActorCallback< BenchmarkActor, 3, Void >, public ActorCallback< BenchmarkActor, 4, Void >, public FastAllocated<BenchmarkActor>, public BenchmarkActorState<BenchmarkActor> {
															#line 1017 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<BenchmarkActor>::operator new;
	using FastAllocated<BenchmarkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5829074925727408384UL, 1478661178418204416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BenchmarkActor, 0, Version >;
friend struct ActorCallback< BenchmarkActor, 1, Optional<Value> >;
friend struct ActorCallback< BenchmarkActor, 2, Void >;
friend struct ActorCallback< BenchmarkActor, 3, Void >;
friend struct ActorCallback< BenchmarkActor, 4, Void >;
															#line 60 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	BenchmarkActor(Database const& cx,ReadAfterWriteWorkload* const& self) 
															#line 1038 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   BenchmarkActorState<BenchmarkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("benchmark", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7627055875764863232UL, 10192556654578484480UL);
		ActorExecutionContextHelper __helper(static_cast<BenchmarkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("benchmark");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("benchmark", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BenchmarkActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BenchmarkActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BenchmarkActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BenchmarkActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< BenchmarkActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 60 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
[[nodiscard]] static Future<Void> benchmark( Database const& cx, ReadAfterWriteWorkload* const& self ) {
															#line 60 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	return Future<Void>(new BenchmarkActor(cx, self));
															#line 1074 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
}

#line 103 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"

	Future<Void> start(Database const& cx) override { return _start(cx, this); }
																#line 1080 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
template <class _startActor>
															#line 105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
class _startActorState {
															#line 1086 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
public:
															#line 105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	_startActorState(Database const& cx,ReadAfterWriteWorkload* const& self) 
															#line 105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
															#line 105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		 : cx(cx),
															#line 105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		   self(self),
															#line 106 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		   lifetime(benchmark(cx, self))
															#line 1097 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 107 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->testDuration);
															#line 107 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1114 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 107 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1119 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 108 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1142 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 108 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1154 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	Database cx;
															#line 105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	ReadAfterWriteWorkload* self;
															#line 106 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	Future<Void> lifetime;
															#line 1243 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1248 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(319907088162130944UL, 10352968970116367872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	_startActor(Database const& cx,ReadAfterWriteWorkload* const& self) 
															#line 1265 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, ReadAfterWriteWorkload* const& self ) {
															#line 105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1297 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ReadAfterWrite.actor.g.cpp.py_gen"
}

#line 110 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/workloads/ReadAfterWrite.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.emplace_back("Mean Latency (ms)", 1000 * propagationLatency.mean(), Averaged::True);
		m.emplace_back("Median Latency (ms, averaged)", 1000 * propagationLatency.median(), Averaged::True);
		m.emplace_back("90% Latency (ms, averaged)", 1000 * propagationLatency.percentile(0.90), Averaged::True);
		m.emplace_back("99% Latency (ms, averaged)", 1000 * propagationLatency.percentile(0.99), Averaged::True);
		m.emplace_back("Max Latency (ms, averaged)", 1000 * propagationLatency.max(), Averaged::True);
	}
};

WorkloadFactory<ReadAfterWriteWorkload> ReadAfterWriteWorkloadFactory;
