#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
/*
 * OnDemandStore.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/OnDemandStore.h"
#include "flow/actorcompiler.h" // must be last include

															#line 26 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via onErr()
															#line 24 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
template <class OnErrActor>
															#line 24 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
class OnErrActorState {
															#line 33 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
public:
															#line 24 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
	OnErrActorState(Future<Future<Void>> const& e) 
															#line 24 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
															#line 24 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
		 : e(e)
															#line 40 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("onErr", reinterpret_cast<unsigned long>(this));

	}
	~OnErrActorState() 
	{
		fdb_probe_actor_destroy("onErr", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 25 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
			StrictFuture<Future<Void>> __when_expr_0 = e;
															#line 25 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
			if (static_cast<OnErrActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 57 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OnErrActor*>(this)->actor_wait_state = 1;
															#line 25 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OnErrActor, 0, Future<Void> >*>(static_cast<OnErrActor*>(this)));
															#line 62 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OnErrActorState();
		static_cast<OnErrActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Future<Void> const& f,int loopDepth) 
	{
															#line 26 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f;
															#line 26 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
		if (static_cast<OnErrActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 87 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OnErrActor*>(this)->actor_wait_state = 2;
															#line 26 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OnErrActor, 1, Void >*>(static_cast<OnErrActor*>(this)));
															#line 92 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Future<Void> && f,int loopDepth) 
	{
															#line 26 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f;
															#line 26 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
		if (static_cast<OnErrActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 103 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<OnErrActor*>(this)->actor_wait_state = 2;
															#line 26 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OnErrActor, 1, Void >*>(static_cast<OnErrActor*>(this)));
															#line 108 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Future<Void> const& f,int loopDepth) 
	{
		loopDepth = a_body1cont1(f, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Future<Void> && f,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OnErrActor*>(this)->actor_wait_state > 0) static_cast<OnErrActor*>(this)->actor_wait_state = 0;
		static_cast<OnErrActor*>(this)->ActorCallback< OnErrActor, 0, Future<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< OnErrActor, 0, Future<Void> >*,Future<Void> const& value) 
	{
		fdb_probe_actor_enter("onErr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnErrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onErr", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OnErrActor, 0, Future<Void> >*,Future<Void> && value) 
	{
		fdb_probe_actor_enter("onErr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnErrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onErr", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OnErrActor, 0, Future<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("onErr", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnErrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onErr", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 27 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
		if (!static_cast<OnErrActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnErrActorState(); static_cast<OnErrActor*>(this)->destroy(); return 0; }
															#line 192 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
		new (&static_cast<OnErrActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OnErrActorState();
		static_cast<OnErrActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 27 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
		if (!static_cast<OnErrActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OnErrActorState(); static_cast<OnErrActor*>(this)->destroy(); return 0; }
															#line 204 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
		new (&static_cast<OnErrActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OnErrActorState();
		static_cast<OnErrActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OnErrActor*>(this)->actor_wait_state > 0) static_cast<OnErrActor*>(this)->actor_wait_state = 0;
		static_cast<OnErrActor*>(this)->ActorCallback< OnErrActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OnErrActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("onErr", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnErrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onErr", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OnErrActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("onErr", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OnErrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onErr", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OnErrActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("onErr", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OnErrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("onErr", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 24 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
	Future<Future<Void>> e;
															#line 289 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
};
// This generated class is to be used only via onErr()
															#line 24 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
class OnErrActor final : public Actor<Void>, public ActorCallback< OnErrActor, 0, Future<Void> >, public ActorCallback< OnErrActor, 1, Void >, public FastAllocated<OnErrActor>, public OnErrActorState<OnErrActor> {
															#line 294 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
public:
	using FastAllocated<OnErrActor>::operator new;
	using FastAllocated<OnErrActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10241209157444493056UL, 11904424434364160512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OnErrActor, 0, Future<Void> >;
friend struct ActorCallback< OnErrActor, 1, Void >;
															#line 24 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
	OnErrActor(Future<Future<Void>> const& e) 
															#line 312 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   OnErrActorState<OnErrActor>(e),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("onErr", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2305532523157443584UL, 11896290790492638464UL);
		ActorExecutionContextHelper __helper(static_cast<OnErrActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("onErr");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("onErr", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OnErrActor, 0, Future<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OnErrActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 24 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
[[nodiscard]] static Future<Void> onErr( Future<Future<Void>> const& e ) {
															#line 24 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"
	return Future<Void>(new OnErrActor(e));
															#line 346 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbserver/OnDemandStore.actor.g.cpp.py_gen"
}

#line 29 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbserver/OnDemandStore.actor.cpp"

void OnDemandStore::open() {
	platform::createDirectory(folder);
	store = keyValueStoreMemory(joinPath(folder, prefix), myID, 500e6);
	err.send(store->getError());
}

OnDemandStore::OnDemandStore(std::string const& folder, UID myID, std::string const& prefix)
  : folder(folder), myID(myID), store(nullptr), prefix(prefix) {}

OnDemandStore::~OnDemandStore() {
	close();
}

IKeyValueStore* OnDemandStore::get() {
	if (!store) {
		open();
	}
	return store;
}

bool OnDemandStore::exists() const {
	return store || fileExists(joinPath(folder, prefix + "0.fdq")) || fileExists(joinPath(folder, prefix + "1.fdq")) ||
	       fileExists(joinPath(folder, prefix + ".fdb"));
}

IKeyValueStore* OnDemandStore::operator->() {
	return get();
}

Future<Void> OnDemandStore::getError() const {
	return onErr(err.getFuture());
}

Future<Void> OnDemandStore::onClosed() const {
	return store->onClosed();
}

void OnDemandStore::dispose() {
	if (store) {
		store->dispose();
		store = nullptr;
	}
}
void OnDemandStore::close() {
	if (store) {
		store->close();
		store = nullptr;
	}
}
