#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
/*
 * AuditStorageCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * ============================================================================
 * AUDIT STORAGE COMMANDS
 * ============================================================================
 *
 * This file implements CLI commands for various storage audit operations:
 *   - audit_storage ha                 : Validate high availability
 *   - audit_storage replica            : Validate replica consistency
 *   - audit_storage locationmetadata   : Validate location metadata
 *   - audit_storage ssshard            : Validate storage server shards
 *   - audit_storage validate_restore   : Validate restored backup data
 *
 * ============================================================================
 * RESTORE VALIDATION (validate_restore) - Quick Reference
 * ============================================================================
 *
 * USAGE: audit_storage validate_restore <begin_key> <end_key>
 *
 * Validates that restored backup data matches original source data.
 *
 * EXAMPLE WORKFLOW:
 *   1. Backup:     fdbbackup start -d file:///backup -z
 *   2. Stop:       fdbbackup discontinue -C <cluster_file>
 *   3. Lock:       fdb> lock                               (save the returned UID)
 *   4. Restore:    fdbrestore start -r file:///backup --add-prefix "\xff\x02/rlog/"
 *   5. Validate:   fdb> audit_storage validate_restore "" "\xff"
 *   6. Check:      fdb> get_audit_status validate_restore id <AuditID>
 *   7. Unlock:     fdb> unlock <UID>
 *   8. Cleanup:    fdb> clearrange "\xff\x02/rlog/" "\xff\x02/rlog0"
 *
 * NOTE: Steps 2-3 (stop backup and lock) prevent writes during validation, avoiding
 * false positive audit errors. The --add-prefix parameter in step 4 allows the restore
 * to run on a non-empty database, enabling validation by comparing restored data
 * against the source. Both restore and audit use LOCK_AWARE transactions, so they
 * work on a locked database.
 *
 * See fdbserver/storageserver.actor.cpp for detailed implementation docs.
 * ============================================================================
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/IClientApi.h"

#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/Audit.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

															#line 77 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
// This generated class is to be used only via auditStorageCommandActor()
															#line 75 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
template <class AuditStorageCommandActorActor>
															#line 75 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
class AuditStorageCommandActorActorState {
															#line 83 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
public:
															#line 75 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
	AuditStorageCommandActorActorState(Reference<IClusterConnectionRecord> const& clusterFile,std::vector<StringRef> const& tokens) 
															#line 75 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
															#line 75 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
		 : clusterFile(clusterFile),
															#line 75 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
		   tokens(tokens)
															#line 92 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("auditStorageCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~AuditStorageCommandActorActorState() 
	{
		fdb_probe_actor_destroy("auditStorageCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 77 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
			if (tokens.size() < 2)
															#line 107 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
			{
															#line 78 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 79 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 113 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
				this->~AuditStorageCommandActorActorState();
				static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 82 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
			resAuditId = UID();
															#line 83 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
			if (tokencmp(tokens[1], "cancel"))
															#line 123 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
			{
															#line 84 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (tokens.size() != 4)
															#line 127 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				{
															#line 85 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 86 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 133 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
					new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
					this->~AuditStorageCommandActorActorState();
					static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 88 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				AuditType type = AuditType::Invalid;
															#line 89 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (tokencmp(tokens[2], "ha"))
															#line 143 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				{
															#line 90 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					type = AuditType::ValidateHA;
															#line 147 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 91 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					if (tokencmp(tokens[2], "replica"))
															#line 153 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
					{
															#line 92 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						type = AuditType::ValidateReplica;
															#line 157 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
					}
					else
					{
															#line 93 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						if (tokencmp(tokens[2], "locationmetadata"))
															#line 163 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
						{
															#line 94 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
							type = AuditType::ValidateLocationMetadata;
															#line 167 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
						}
						else
						{
															#line 95 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
							if (tokencmp(tokens[2], "ssshard"))
															#line 173 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
							{
															#line 96 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
								type = AuditType::ValidateStorageServerShard;
															#line 177 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
							}
							else
							{
															#line 97 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
								if (tokencmp(tokens[2], "validate_restore"))
															#line 183 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
								{
															#line 98 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
									type = AuditType::ValidateRestore;
															#line 187 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
								}
								else
								{
															#line 100 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
									printUsage(tokens[0]);
															#line 101 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
									if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 195 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
									new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
									this->~AuditStorageCommandActorActorState();
									static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
									return 0;
								}
							}
						}
					}
				}
															#line 103 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				const UID auditId = UID::fromString(tokens[3].toString());
															#line 104 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				StrictFuture<UID> __when_expr_0 = cancelAuditStorage(clusterFile, type, auditId, 60);
															#line 104 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 211 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state = 1;
															#line 104 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCommandActorActor, 0, UID >*>(static_cast<AuditStorageCommandActorActor*>(this)));
															#line 216 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 108 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				AuditType type = AuditType::Invalid;
															#line 109 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (tokencmp(tokens[1], "ha"))
															#line 225 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				{
															#line 110 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					type = AuditType::ValidateHA;
															#line 229 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 111 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					if (tokencmp(tokens[1], "replica"))
															#line 235 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
					{
															#line 112 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						type = AuditType::ValidateReplica;
															#line 239 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
					}
					else
					{
															#line 113 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						if (tokencmp(tokens[1], "locationmetadata"))
															#line 245 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
						{
															#line 114 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
							type = AuditType::ValidateLocationMetadata;
															#line 249 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
						}
						else
						{
															#line 115 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
							if (tokencmp(tokens[1], "ssshard"))
															#line 255 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
							{
															#line 116 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
								type = AuditType::ValidateStorageServerShard;
															#line 259 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
							}
							else
							{
															#line 117 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
								if (tokencmp(tokens[1], "validate_restore"))
															#line 265 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
								{
															#line 118 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
									type = AuditType::ValidateRestore;
															#line 269 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
								}
								else
								{
															#line 120 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
									printUsage(tokens[0]);
															#line 121 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
									if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 277 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
									new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
									this->~AuditStorageCommandActorActorState();
									static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
									return 0;
								}
							}
						}
					}
				}
															#line 124 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				Key begin = allKeys.begin, end = allKeys.end;
															#line 125 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (tokens.size() == 3)
															#line 291 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				{
															#line 126 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					begin = tokens[2];
															#line 295 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				}
				else
				{
															#line 127 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					if (tokens.size() == 4 || tokens.size() == 5)
															#line 301 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
					{
															#line 128 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						begin = tokens[2];
															#line 129 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						end = tokens[3];
															#line 307 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
					}
					else
					{
															#line 131 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						printUsage(tokens[0]);
															#line 132 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 315 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
						new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
						this->~AuditStorageCommandActorActorState();
						static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 134 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (end > allKeys.end)
															#line 324 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				{
															#line 135 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 136 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 330 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
					new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
					this->~AuditStorageCommandActorActorState();
					static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 138 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (begin >= end)
															#line 338 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				{
															#line 139 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					printUsage(tokens[0]);
															#line 140 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 344 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
					new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
					this->~AuditStorageCommandActorActorState();
					static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 143 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				KeyValueStoreType engineType = KeyValueStoreType::END;
															#line 144 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (tokens.size() == 5 && (type == AuditType::ValidateHA || type == AuditType::ValidateReplica))
															#line 354 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				{
															#line 145 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					engineType = KeyValueStoreType::fromString(tokens[4].toString());
															#line 146 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
					if (engineType != KeyValueStoreType::SSD_BTREE_V2 && engineType != KeyValueStoreType::SSD_ROCKSDB_V1 && engineType != KeyValueStoreType::SSD_SHARDED_ROCKSDB)
															#line 360 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
					{
															#line 148 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						printUsage(tokens[0]);
															#line 149 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
						if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(UID()); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 366 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
						new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(UID());
						this->~AuditStorageCommandActorActorState();
						static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
															#line 154 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				StrictFuture<UID> __when_expr_1 = auditStorage(clusterFile, KeyRangeRef(begin, end), type, engineType, 60);
															#line 154 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				if (static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 377 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state = 2;
															#line 154 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< AuditStorageCommandActorActor, 1, UID >*>(static_cast<AuditStorageCommandActorActor*>(this)));
															#line 382 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~AuditStorageCommandActorActorState();
		static_cast<AuditStorageCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 158 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
		if (!static_cast<AuditStorageCommandActorActor*>(this)->SAV<UID>::futures) { (void)(resAuditId); this->~AuditStorageCommandActorActorState(); static_cast<AuditStorageCommandActorActor*>(this)->destroy(); return 0; }
															#line 406 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
		new (&static_cast<AuditStorageCommandActorActor*>(this)->SAV< UID >::value()) UID(std::move(resAuditId)); // state_var_RVO
		this->~AuditStorageCommandActorActorState();
		static_cast<AuditStorageCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(UID const& cancelledAuditId,int loopDepth) 
	{
															#line 105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
		resAuditId = cancelledAuditId;
															#line 418 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(UID && cancelledAuditId,int loopDepth) 
	{
															#line 105 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
		resAuditId = cancelledAuditId;
															#line 427 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(UID const& cancelledAuditId,int loopDepth) 
	{
		loopDepth = a_body1cont3(cancelledAuditId, loopDepth);

		return loopDepth;
	}
	int a_body1when1(UID && cancelledAuditId,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(cancelledAuditId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCommandActorActor*>(this)->ActorCallback< AuditStorageCommandActorActor, 0, UID >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCommandActorActor, 0, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< AuditStorageCommandActorActor, 0, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< AuditStorageCommandActorActor, 0, UID >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont16(UID const& startedAuditId,int loopDepth) 
	{
															#line 156 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
		resAuditId = startedAuditId;
															#line 511 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont16(UID && startedAuditId,int loopDepth) 
	{
															#line 156 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
		resAuditId = startedAuditId;
															#line 520 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(UID const& startedAuditId,int loopDepth) 
	{
		loopDepth = a_body1cont16(startedAuditId, loopDepth);

		return loopDepth;
	}
	int a_body1when2(UID && startedAuditId,int loopDepth) 
	{
		loopDepth = a_body1cont16(std::move(startedAuditId), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state > 0) static_cast<AuditStorageCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<AuditStorageCommandActorActor*>(this)->ActorCallback< AuditStorageCommandActorActor, 1, UID >::remove();

	}
	void a_callback_fire(ActorCallback< AuditStorageCommandActorActor, 1, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< AuditStorageCommandActorActor, 1, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< AuditStorageCommandActorActor, 1, UID >*,Error err) 
	{
		fdb_probe_actor_enter("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 75 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
	Reference<IClusterConnectionRecord> clusterFile;
															#line 75 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 82 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
	UID resAuditId;
															#line 606 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
};
// This generated class is to be used only via auditStorageCommandActor()
															#line 75 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
class AuditStorageCommandActorActor final : public Actor<UID>, public ActorCallback< AuditStorageCommandActorActor, 0, UID >, public ActorCallback< AuditStorageCommandActorActor, 1, UID >, public FastAllocated<AuditStorageCommandActorActor>, public AuditStorageCommandActorActorState<AuditStorageCommandActorActor> {
															#line 611 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
public:
	using FastAllocated<AuditStorageCommandActorActor>::operator new;
	using FastAllocated<AuditStorageCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2888975414744863232UL, 296433451847932416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<UID>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< AuditStorageCommandActorActor, 0, UID >;
friend struct ActorCallback< AuditStorageCommandActorActor, 1, UID >;
															#line 75 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
	AuditStorageCommandActorActor(Reference<IClusterConnectionRecord> const& clusterFile,std::vector<StringRef> const& tokens) 
															#line 629 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
		 : Actor<UID>(),
		   AuditStorageCommandActorActorState<AuditStorageCommandActorActor>(clusterFile, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4733057652697692416UL, 1885724123785879040UL);
		ActorExecutionContextHelper __helper(static_cast<AuditStorageCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("auditStorageCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("auditStorageCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< AuditStorageCommandActorActor, 0, UID >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< AuditStorageCommandActorActor, 1, UID >*)0, actor_cancelled()); break;
		}

	}
};
															#line 75 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
[[nodiscard]] Future<UID> auditStorageCommandActor( Reference<IClusterConnectionRecord> const& clusterFile, std::vector<StringRef> const& tokens ) {
															#line 75 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"
	return Future<UID>(new AuditStorageCommandActorActor(clusterFile, tokens));
															#line 662 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/fdbcli/AuditStorageCommand.actor.g.cpp.py_gen"
}

#line 160 "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/fdbcli/AuditStorageCommand.actor.cpp"

CommandFactory auditStorageFactory(
    "audit_storage",
    CommandHelp("audit_storage <Type> [BeginKey EndKey] <EngineType>",
                "Start an audit storage",
                "Specify audit `Type' (only `ha' and `replica' and `locationmetadata' and "
                "`ssshard' and `validate_restore' `Type' are supported currently), and\n"
                "optionally a sub-range with `BeginKey' and `EndKey'.\n"
                "Specify audit `EngineType' when auditType is `ha' or `replica'\n"
                "(only `ssd-rocksdb-v1' and `ssd-sharded-rocksdb' and `ssd-2' are supported).\n"
                "If no EngineType is specified, every storage engine will be audited.\n"
                "For example, to audit the full key range: `audit_storage ha'\n"
                "To audit a sub-range only: `audit_storage ha \\xa \\xb'\n"
                "Returns an audit `ID'. See also `get_audit_status' command.\n"
                "Note that BeginKey should not equal to EndKey and EndKey is at most \\xff.\n"
                "To cancel an audit: audit_storage cancel <Type> [ID]"));
} // namespace fdb_cli
