# Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
# file Copyright.txt or https://cmake.org/licensing for details.

cmake_minimum_required(VERSION ${CMAKE_VERSION}) # this file comes with cmake

if(EXISTS "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/doctest/src/doctest_proj-stamp/doctest_proj-gitclone-lastrun.txt" AND EXISTS "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/doctest/src/doctest_proj-stamp/doctest_proj-gitinfo.txt" AND
  "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/doctest/src/doctest_proj-stamp/doctest_proj-gitclone-lastrun.txt" IS_NEWER_THAN "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/doctest/src/doctest_proj-stamp/doctest_proj-gitinfo.txt")
  message(VERBOSE
    "Avoiding repeated git clone, stamp file is up to date: "
    "'/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/doctest/src/doctest_proj-stamp/doctest_proj-gitclone-lastrun.txt'"
  )
  return()
endif()

# Even at VERBOSE level, we don't want to see the commands executed, but
# enabling them to be shown for DEBUG may be useful to help diagnose problems.
cmake_language(GET_MESSAGE_LOG_LEVEL active_log_level)
if(active_log_level MATCHES "DEBUG|TRACE")
  set(maybe_show_command COMMAND_ECHO STDOUT)
else()
  set(maybe_show_command "")
endif()

execute_process(
  COMMAND ${CMAKE_COMMAND} -E rm -rf "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/doctest/src/doctest_proj"
  RESULT_VARIABLE error_code
  ${maybe_show_command}
)
if(error_code)
  message(FATAL_ERROR "Failed to remove directory: '/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/doctest/src/doctest_proj'")
endif()

# try the clone 3 times in case there is an odd git clone issue
set(error_code 1)
set(number_of_tries 0)
while(error_code AND number_of_tries LESS 3)
  execute_process(
    COMMAND "/usr/local/bin/git"
            clone --no-checkout --config "advice.detachedHead=false" "https://github.com/onqtam/doctest.git" "doctest_proj"
    WORKING_DIRECTORY "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/doctest/src"
    RESULT_VARIABLE error_code
    ${maybe_show_command}
  )
  math(EXPR number_of_tries "${number_of_tries} + 1")
endwhile()
if(number_of_tries GREATER 1)
  message(NOTICE "Had to git clone more than once: ${number_of_tries} times.")
endif()
if(error_code)
  message(FATAL_ERROR "Failed to clone repository: 'https://github.com/onqtam/doctest.git'")
endif()

execute_process(
  COMMAND "/usr/local/bin/git"
          checkout "7b9885133108ae301ddd16e2651320f54cafeba7" --
  WORKING_DIRECTORY "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/doctest/src/doctest_proj"
  RESULT_VARIABLE error_code
  ${maybe_show_command}
)
if(error_code)
  message(FATAL_ERROR "Failed to checkout tag: '7b9885133108ae301ddd16e2651320f54cafeba7'")
endif()

set(init_submodules TRUE)
if(init_submodules)
  execute_process(
    COMMAND "/usr/local/bin/git" 
            submodule update --recursive --init 
    WORKING_DIRECTORY "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/doctest/src/doctest_proj"
    RESULT_VARIABLE error_code
    ${maybe_show_command}
  )
endif()
if(error_code)
  message(FATAL_ERROR "Failed to update submodules in: '/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/doctest/src/doctest_proj'")
endif()

# Complete success, update the script-last-run stamp file:
#
execute_process(
  COMMAND ${CMAKE_COMMAND} -E copy "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/doctest/src/doctest_proj-stamp/doctest_proj-gitinfo.txt" "/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/doctest/src/doctest_proj-stamp/doctest_proj-gitclone-lastrun.txt"
  RESULT_VARIABLE error_code
  ${maybe_show_command}
)
if(error_code)
  message(FATAL_ERROR "Failed to copy script-last-run stamp file: '/codebuild/output/src2038086582/src/github.com/apple/foundationdb/build_output/doctest/src/doctest_proj-stamp/doctest_proj-gitclone-lastrun.txt'")
endif()
