#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
/*
 * BackupToDBAbort.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/ApiVersion.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct BackupToDBAbort : TestWorkload {
	static constexpr auto NAME = "BackupToDBAbort";
	double abortDelay;
	Database extraDB;
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
	UID lockid;

	explicit BackupToDBAbort(const WorkloadContext& wcx) : TestWorkload(wcx) {
		abortDelay = getOption(options, "abortDelay"_sr, 50.0);

		addDefaultBackupRanges(backupRanges);

		ASSERT(g_simulator->extraDatabases.size() == 1);
		extraDB = Database::createSimulatedExtraDatabase(g_simulator->extraDatabases[0], wcx.defaultTenant);

		lockid = UID(0xbeeffeed, 0xdecaf00d);
	}

	Future<Void> setup(const Database& cx) override {
		if (clientId != 0)
			return Void();
		return _setup(this, cx);
	}

																#line 55 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 53 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
template <class _setupActor>
															#line 53 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
class _setupActorState {
															#line 61 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
public:
															#line 53 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	_setupActorState(BackupToDBAbort* const& self,Database const& cx) 
															#line 53 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
															#line 53 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		 : self(self),
															#line 53 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		   cx(cx),
															#line 54 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		   backupAgent(cx)
															#line 72 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 56 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
				TraceEvent("BDBA_Submit1").log();
															#line 57 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
				StrictFuture<Void> __when_expr_0 = backupAgent.submitBackup(self->extraDB, BackupAgentBase::getDefaultTag(), self->backupRanges, StopWhenDone::False, StringRef(), StringRef(), LockDB::True);
															#line 57 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 92 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 57 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 97 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 69 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 126 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 66 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
			if (e.code() != error_code_backup_duplicate)
															#line 139 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
			{
															#line 67 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 143 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 64 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		TraceEvent("BDBA_Submit2").log();
															#line 159 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 64 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		TraceEvent("BDBA_Submit2").log();
															#line 168 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 53 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	BackupToDBAbort* self;
															#line 53 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	Database cx;
															#line 54 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 267 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 53 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 272 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5968384544519493120UL, 6258565004938816768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 53 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	_setupActor(BackupToDBAbort* const& self,Database const& cx) 
															#line 289 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 53 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
[[nodiscard]] static Future<Void> _setup( BackupToDBAbort* const& self, Database const& cx ) {
															#line 53 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	return Future<Void>(new _setupActor(self, cx));
															#line 321 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
}

#line 71 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();
		return _start(this, cx);
	}

																#line 332 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 78 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
template <class _startActor>
															#line 78 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
class _startActorState {
															#line 338 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
public:
															#line 78 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	_startActorState(BackupToDBAbort* const& self,Database const& cx) 
															#line 78 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
															#line 78 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		 : self(self),
															#line 78 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		   cx(cx),
															#line 79 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		   backupAgent(cx)
															#line 349 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 81 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
			TraceEvent("BDBA_Start").detail("Delay", self->abortDelay);
															#line 82 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->abortDelay);
															#line 82 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 368 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 82 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 373 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		TraceEvent("BDBA_Wait").log();
															#line 84 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(backupAgent.waitBackup(self->extraDB, BackupAgentBase::getDefaultTag(), StopWhenDone::False));
															#line 84 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 400 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 84 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 405 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		TraceEvent("BDBA_Wait").log();
															#line 84 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		StrictFuture<Void> __when_expr_1 = success(backupAgent.waitBackup(self->extraDB, BackupAgentBase::getDefaultTag(), StopWhenDone::False));
															#line 84 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 418 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 84 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 423 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		TraceEvent("BDBA_Lock").log();
															#line 86 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		StrictFuture<Void> __when_expr_2 = lockDatabase(cx, self->lockid);
															#line 86 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 511 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 86 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 516 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		TraceEvent("BDBA_Lock").log();
															#line 86 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		StrictFuture<Void> __when_expr_2 = lockDatabase(cx, self->lockid);
															#line 86 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 529 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 86 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 534 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 87 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		TraceEvent("BDBA_Abort").log();
															#line 88 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		StrictFuture<Void> __when_expr_3 = backupAgent.abortBackup(self->extraDB, BackupAgentBase::getDefaultTag());
															#line 88 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 88 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 627 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 87 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		TraceEvent("BDBA_Abort").log();
															#line 88 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		StrictFuture<Void> __when_expr_3 = backupAgent.abortBackup(self->extraDB, BackupAgentBase::getDefaultTag());
															#line 88 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 640 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 88 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 645 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 89 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		TraceEvent("BDBA_Unlock").log();
															#line 90 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		StrictFuture<Void> __when_expr_4 = backupAgent.unlockBackup(self->extraDB, BackupAgentBase::getDefaultTag());
															#line 90 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 733 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 90 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 738 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 89 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		TraceEvent("BDBA_Unlock").log();
															#line 90 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		StrictFuture<Void> __when_expr_4 = backupAgent.unlockBackup(self->extraDB, BackupAgentBase::getDefaultTag());
															#line 90 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 751 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 90 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 756 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 91 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		TraceEvent("BDBA_End").log();
															#line 94 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (g_simulator->drAgents == ISimulator::BackupAgentType::BackupToDB)
															#line 842 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		{
															#line 95 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
			g_simulator->drAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 846 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		}
															#line 98 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 850 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 91 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		TraceEvent("BDBA_End").log();
															#line 94 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (g_simulator->drAgents == ISimulator::BackupAgentType::BackupToDB)
															#line 864 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		{
															#line 95 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
			g_simulator->drAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 868 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		}
															#line 98 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 872 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 78 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	BackupToDBAbort* self;
															#line 78 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	Database cx;
															#line 79 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 961 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 78 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 966 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10150645083187516928UL, 3730471546092898560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
															#line 78 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	_startActor(BackupToDBAbort* const& self,Database const& cx) 
															#line 987 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 78 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
[[nodiscard]] static Future<Void> _start( BackupToDBAbort* const& self, Database const& cx ) {
															#line 78 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 1023 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
}

#line 100 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"

																#line 1028 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
template <class _checkActor>
															#line 101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
class _checkActorState {
															#line 1034 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
public:
															#line 101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	_checkActorState(BackupToDBAbort* const& self,Database const& cx) 
															#line 101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
															#line 101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		 : self(self),
															#line 101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		   cx(cx)
															#line 1043 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 102 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
			TraceEvent("BDBA_UnlockPrimary").log();
															#line 105 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
			StrictFuture<Void> __when_expr_0 = unlockDatabase(cx, self->lockid);
															#line 105 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1062 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 105 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 1067 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 106 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1090 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 106 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1102 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	BackupToDBAbort* self;
															#line 101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	Database cx;
															#line 1189 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 1194 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(614219014232883712UL, 12066287639294726912UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
															#line 101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	_checkActor(BackupToDBAbort* const& self,Database const& cx) 
															#line 1211 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
[[nodiscard]] static Future<bool> _check( BackupToDBAbort* const& self, Database const& cx ) {
															#line 101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"
	return Future<bool>(new _checkActor(self, cx));
															#line 1243 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBAbort.actor.g.cpp"
}

#line 108 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBAbort.actor.cpp"

	Future<bool> check(const Database& cx) override { return _check(this, cx); }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

REGISTER_WORKLOAD(BackupToDBAbort);
