#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
/*
 * networktest.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fmt/format.h"
#include "fdbserver/NetworkTest.h"
#include "flow/Knobs.h"
#include "flow/ActorCollection.h"
#include "flow/UnitTest.h"
#include <inttypes.h>

#include "flow/IConnection.h"
#include "flow/actorcompiler.h" // This must be the last #include.

constexpr int WLTOKEN_NETWORKTEST = WLTOKEN_FIRST_AVAILABLE;

struct LatencyStats {
	using sample = double;
	double x = 0;
	double x2 = 0;
	double n = 0;

	sample tick() {
		// now() returns the timestamp when we were scheduled; count
		// all that time against this sample.
		return now();
	}

	void tock(sample tick) {
		// time_monotonic returns the timestamp when it was called;
		// count the time it took us to be dispatched and invoke
		// timer_monotonic
		double delta = timer_monotonic() - tick;
		x += delta;
		x2 += (delta * delta);
		n++;
	}

	void reset() { *this = LatencyStats(); }
	double mean() { return x / n; }
	double stddev() { return sqrt(x2 / n - (x / n) * (x / n)); }
};

NetworkTestInterface::NetworkTestInterface(NetworkAddress remote)
  : test(Endpoint::wellKnown({ remote }, WLTOKEN_NETWORKTEST)) {}

NetworkTestInterface::NetworkTestInterface(INetwork* local) {
	test.makeWellKnownEndpoint(WLTOKEN_NETWORKTEST, TaskPriority::DefaultEndpoint);
}

															#line 69 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
namespace {
// This generated class is to be used only via networkTestServer()
															#line 67 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
template <class NetworkTestServerActor>
															#line 67 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class NetworkTestServerActorState {
															#line 76 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
															#line 67 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	NetworkTestServerActorState() 
															#line 67 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
															#line 68 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		 : interf(g_network),
															#line 69 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   logging(delay(1.0)),
															#line 70 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   lastTime(now()),
															#line 71 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   sent(0),
															#line 72 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   latency()
															#line 91 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
	{
		fdb_probe_actor_create("networkTestServer", reinterpret_cast<unsigned long>(this));

	}
	~NetworkTestServerActorState() 
	{
		fdb_probe_actor_destroy("networkTestServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 74 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			;
															#line 106 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NetworkTestServerActorState();
		static_cast<NetworkTestServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 76 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		auto __when_expr_0 = interf.test.getFuture();
															#line 136 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<NetworkTestRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<NetworkTestRequest>>::value, "invalid type");
															#line 75 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<NetworkTestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 140 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 82 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = logging;
															#line 144 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<NetworkTestServerActor*>(this)->actor_wait_state = 1;
															#line 76 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< NetworkTestServerActor, 0, NetworkTestRequest >*>(static_cast<NetworkTestServerActor*>(this)));
															#line 82 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NetworkTestServerActor, 1, Void >*>(static_cast<NetworkTestServerActor*>(this)));
															#line 151 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(NetworkTestRequest const& req,int loopDepth) 
	{
															#line 77 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		LatencyStats::sample sample = latency.tick();
															#line 78 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		req.reply.send(NetworkTestReply(Value(std::string(req.replySize, '.'))));
															#line 79 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		latency.tock(sample);
															#line 80 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		sent++;
															#line 172 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(NetworkTestRequest && req,int loopDepth) 
	{
															#line 77 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		LatencyStats::sample sample = latency.tick();
															#line 78 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		req.reply.send(NetworkTestReply(Value(std::string(req.replySize, '.'))));
															#line 79 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		latency.tock(sample);
															#line 80 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		sent++;
															#line 187 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		auto spd = sent / (now() - lastTime);
															#line 84 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (FLOW_KNOBS->NETWORK_TEST_SCRIPT_MODE)
															#line 198 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
															#line 85 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			fprintf(stderr, "%f\t%.3f\t%.3f\n", spd, latency.mean() * 1e6, latency.stddev() * 1e6);
															#line 202 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
		else
		{
															#line 87 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			fprintf(stderr, "responses per second: %f (%f us)\n", spd, latency.mean() * 1e6);
															#line 208 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
															#line 89 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		latency.reset();
															#line 90 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		lastTime = now();
															#line 91 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		sent = 0;
															#line 92 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		logging = delay(1.0);
															#line 218 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 83 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		auto spd = sent / (now() - lastTime);
															#line 84 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (FLOW_KNOBS->NETWORK_TEST_SCRIPT_MODE)
															#line 229 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
															#line 85 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			fprintf(stderr, "%f\t%.3f\t%.3f\n", spd, latency.mean() * 1e6, latency.stddev() * 1e6);
															#line 233 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
		else
		{
															#line 87 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			fprintf(stderr, "responses per second: %f (%f us)\n", spd, latency.mean() * 1e6);
															#line 239 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
															#line 89 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		latency.reset();
															#line 90 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		lastTime = now();
															#line 91 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		sent = 0;
															#line 92 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		logging = delay(1.0);
															#line 249 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NetworkTestServerActor*>(this)->actor_wait_state > 0) static_cast<NetworkTestServerActor*>(this)->actor_wait_state = 0;
		static_cast<NetworkTestServerActor*>(this)->ActorSingleCallback< NetworkTestServerActor, 0, NetworkTestRequest >::remove();
		static_cast<NetworkTestServerActor*>(this)->ActorCallback< NetworkTestServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< NetworkTestServerActor, 0, NetworkTestRequest >*,NetworkTestRequest const& value) 
	{
		fdb_probe_actor_enter("networkTestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< NetworkTestServerActor, 0, NetworkTestRequest >*,NetworkTestRequest && value) 
	{
		fdb_probe_actor_enter("networkTestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< NetworkTestServerActor, 0, NetworkTestRequest >*,Error err) 
	{
		fdb_probe_actor_enter("networkTestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NetworkTestServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("networkTestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NetworkTestServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("networkTestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NetworkTestServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("networkTestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestServer", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 68 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	NetworkTestInterface interf;
															#line 69 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	Future<Void> logging;
															#line 70 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	double lastTime;
															#line 71 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int sent;
															#line 72 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	LatencyStats latency;
															#line 385 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
};
// This generated class is to be used only via networkTestServer()
															#line 67 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class NetworkTestServerActor final : public Actor<Void>, public ActorSingleCallback< NetworkTestServerActor, 0, NetworkTestRequest >, public ActorCallback< NetworkTestServerActor, 1, Void >, public FastAllocated<NetworkTestServerActor>, public NetworkTestServerActorState<NetworkTestServerActor> {
															#line 390 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
	using FastAllocated<NetworkTestServerActor>::operator new;
	using FastAllocated<NetworkTestServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17611345470585751040UL, 8853867016252570112UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< NetworkTestServerActor, 0, NetworkTestRequest >;
friend struct ActorCallback< NetworkTestServerActor, 1, Void >;
															#line 67 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	NetworkTestServerActor() 
															#line 408 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		 : Actor<Void>(),
		   NetworkTestServerActorState<NetworkTestServerActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("networkTestServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13777956478460868096UL, 7532812109222428928UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("networkTestServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("networkTestServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< NetworkTestServerActor, 0, NetworkTestRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 67 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
[[nodiscard]] Future<Void> networkTestServer(  ) {
															#line 67 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	return Future<Void>(new NetworkTestServerActor());
															#line 441 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
}

#line 97 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"

															#line 446 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
namespace {
// This generated class is to be used only via networkTestStreamingServer()
															#line 98 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
template <class NetworkTestStreamingServerActor>
															#line 98 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class NetworkTestStreamingServerActorState {
															#line 453 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
															#line 98 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	NetworkTestStreamingServerActorState() 
															#line 98 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
															#line 99 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		 : interf(g_network),
															#line 100 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   logging(delay(1.0)),
															#line 101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   lastTime(now()),
															#line 102 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   sent(0),
															#line 103 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   latency()
															#line 468 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
	{
		fdb_probe_actor_create("networkTestStreamingServer", reinterpret_cast<unsigned long>(this));

	}
	~NetworkTestStreamingServerActorState() 
	{
		fdb_probe_actor_destroy("networkTestStreamingServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 105 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			;
															#line 483 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NetworkTestStreamingServerActorState();
		static_cast<NetworkTestStreamingServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 108 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			auto __when_expr_0 = interf.testStream.getFuture();
															#line 514 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<NetworkTestStreamingRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<NetworkTestStreamingRequest>>::value, "invalid type");
															#line 107 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (static_cast<NetworkTestStreamingServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 518 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 119 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			StrictFuture<Void> __when_expr_1 = logging;
															#line 522 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
			static_cast<NetworkTestStreamingServerActor*>(this)->actor_wait_state = 1;
															#line 108 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< NetworkTestStreamingServerActor, 0, NetworkTestStreamingRequest >*>(static_cast<NetworkTestStreamingServerActor*>(this)));
															#line 119 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NetworkTestStreamingServerActor, 1, Void >*>(static_cast<NetworkTestStreamingServerActor*>(this)));
															#line 529 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 133 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (e.code() != error_code_operation_obsolete)
															#line 551 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			{
															#line 134 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 555 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(NetworkTestStreamingRequest const& __req,int loopDepth) 
	{
															#line 108 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		req = __req;
															#line 109 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		sample = latency.tick();
															#line 110 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		i = 0;
															#line 111 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		;
															#line 583 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1loopBody1when1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(NetworkTestStreamingRequest && __req,int loopDepth) 
	{
		req = std::move(__req);
															#line 109 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		sample = latency.tick();
															#line 110 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		i = 0;
															#line 111 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		;
															#line 597 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1loopBody1when1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 120 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		auto spd = sent / (now() - lastTime);
															#line 121 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (FLOW_KNOBS->NETWORK_TEST_SCRIPT_MODE)
															#line 608 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
															#line 122 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			fprintf(stderr, "%f\t%.3f\t%.3f\n", spd, latency.mean() * 1e6, latency.stddev() * 1e6);
															#line 612 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
		else
		{
															#line 124 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			fprintf(stderr, "responses per second: %f (%f us)\n", spd, latency.mean() * 1e6);
															#line 618 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
															#line 126 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		latency.reset();
															#line 127 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		lastTime = now();
															#line 128 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		sent = 0;
															#line 129 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		logging = delay(1.0);
															#line 628 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 120 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		auto spd = sent / (now() - lastTime);
															#line 121 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (FLOW_KNOBS->NETWORK_TEST_SCRIPT_MODE)
															#line 639 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
															#line 122 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			fprintf(stderr, "%f\t%.3f\t%.3f\n", spd, latency.mean() * 1e6, latency.stddev() * 1e6);
															#line 643 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
		else
		{
															#line 124 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			fprintf(stderr, "responses per second: %f (%f us)\n", spd, latency.mean() * 1e6);
															#line 649 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
															#line 126 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		latency.reset();
															#line 127 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		lastTime = now();
															#line 128 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		sent = 0;
															#line 129 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		logging = delay(1.0);
															#line 659 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NetworkTestStreamingServerActor*>(this)->actor_wait_state > 0) static_cast<NetworkTestStreamingServerActor*>(this)->actor_wait_state = 0;
		static_cast<NetworkTestStreamingServerActor*>(this)->ActorSingleCallback< NetworkTestStreamingServerActor, 0, NetworkTestStreamingRequest >::remove();
		static_cast<NetworkTestStreamingServerActor*>(this)->ActorCallback< NetworkTestStreamingServerActor, 1, Void >::remove();

	}
	int a_body1loopBody1when1cont1(int loopDepth) 
	{
															#line 115 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		req.reply.sendError(end_of_stream());
															#line 116 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		latency.tock(sample);
															#line 117 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		sent++;
															#line 679 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1when1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1loopBody1(int loopDepth) 
	{
															#line 111 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!(i < 100))
															#line 695 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
			return a_body1loopBody1when1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 112 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = req.reply.onReady();
															#line 112 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<NetworkTestStreamingServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 703 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<NetworkTestStreamingServerActor*>(this)->actor_wait_state = 2;
															#line 112 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< NetworkTestStreamingServerActor, 2, Void >*>(static_cast<NetworkTestStreamingServerActor*>(this)));
															#line 708 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1when1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 113 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		req.reply.send(NetworkTestStreamingReply{ i });
															#line 111 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		++i;
															#line 732 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1when1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 113 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		req.reply.send(NetworkTestStreamingReply{ i });
															#line 111 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		++i;
															#line 743 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1when1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NetworkTestStreamingServerActor*>(this)->actor_wait_state > 0) static_cast<NetworkTestStreamingServerActor*>(this)->actor_wait_state = 0;
		static_cast<NetworkTestStreamingServerActor*>(this)->ActorCallback< NetworkTestStreamingServerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NetworkTestStreamingServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestStreamingServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< NetworkTestStreamingServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestStreamingServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< NetworkTestStreamingServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestStreamingServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< NetworkTestStreamingServerActor, 0, NetworkTestStreamingRequest >*,NetworkTestStreamingRequest const& value) 
	{
		fdb_probe_actor_enter("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestStreamingServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< NetworkTestStreamingServerActor, 0, NetworkTestStreamingRequest >*,NetworkTestStreamingRequest && value) 
	{
		fdb_probe_actor_enter("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestStreamingServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< NetworkTestStreamingServerActor, 0, NetworkTestStreamingRequest >*,Error err) 
	{
		fdb_probe_actor_enter("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestStreamingServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NetworkTestStreamingServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestStreamingServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NetworkTestStreamingServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestStreamingServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NetworkTestStreamingServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestStreamingServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 99 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	NetworkTestInterface interf;
															#line 100 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	Future<Void> logging;
															#line 101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	double lastTime;
															#line 102 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int sent;
															#line 103 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	LatencyStats latency;
															#line 108 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	NetworkTestStreamingRequest req;
															#line 109 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	LatencyStats::sample sample;
															#line 110 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int i;
															#line 966 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
};
// This generated class is to be used only via networkTestStreamingServer()
															#line 98 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class NetworkTestStreamingServerActor final : public Actor<Void>, public ActorSingleCallback< NetworkTestStreamingServerActor, 0, NetworkTestStreamingRequest >, public ActorCallback< NetworkTestStreamingServerActor, 2, Void >, public ActorCallback< NetworkTestStreamingServerActor, 1, Void >, public FastAllocated<NetworkTestStreamingServerActor>, public NetworkTestStreamingServerActorState<NetworkTestStreamingServerActor> {
															#line 971 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
	using FastAllocated<NetworkTestStreamingServerActor>::operator new;
	using FastAllocated<NetworkTestStreamingServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18061496535208548864UL, 10139417565275964160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< NetworkTestStreamingServerActor, 0, NetworkTestStreamingRequest >;
friend struct ActorCallback< NetworkTestStreamingServerActor, 2, Void >;
friend struct ActorCallback< NetworkTestStreamingServerActor, 1, Void >;
															#line 98 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	NetworkTestStreamingServerActor() 
															#line 990 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		 : Actor<Void>(),
		   NetworkTestStreamingServerActorState<NetworkTestStreamingServerActor>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2079391287609594368UL, 8359721550299852800UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestStreamingServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("networkTestStreamingServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("networkTestStreamingServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< NetworkTestStreamingServerActor, 0, NetworkTestStreamingRequest >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NetworkTestStreamingServerActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 98 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
[[nodiscard]] Future<Void> networkTestStreamingServer(  ) {
															#line 98 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	return Future<Void>(new NetworkTestStreamingServerActor());
															#line 1024 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
}

#line 139 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"

static bool moreRequestsPending(int count) {
	if (count == -1) {
		return false;
	} else {
		int request_count = FLOW_KNOBS->NETWORK_TEST_REQUEST_COUNT;
		return (!request_count) || count < request_count;
	}
}

static bool moreLoggingNeeded(int count, int iteration) {
	if (FLOW_KNOBS->NETWORK_TEST_SCRIPT_MODE) {
		return iteration <= 2;
	} else {
		return moreRequestsPending(count);
	}
}

															#line 1046 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
namespace {
// This generated class is to be used only via testClient()
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
template <class TestClientActor>
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class TestClientActorState {
															#line 1053 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	TestClientActorState(std::vector<NetworkTestInterface> const& interfs,int* const& sent,int* const& completed,LatencyStats* const& latency) 
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		 : interfs(interfs),
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   sent(sent),
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   completed(completed),
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   latency(latency),
															#line 161 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   request_payload(FLOW_KNOBS->NETWORK_TEST_REQUEST_SIZE, '.'),
															#line 162 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   sample()
															#line 1070 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
	{
		fdb_probe_actor_create("testClient", reinterpret_cast<unsigned long>(this));

	}
	~TestClientActorState() 
	{
		fdb_probe_actor_destroy("testClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 164 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			;
															#line 1085 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestClientActorState();
		static_cast<TestClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 173 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!static_cast<TestClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestClientActorState(); static_cast<TestClientActor*>(this)->destroy(); return 0; }
															#line 1108 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		new (&static_cast<TestClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestClientActorState();
		static_cast<TestClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 164 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!(moreRequestsPending(*sent)))
															#line 1127 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		(*sent)++;
															#line 166 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		sample = latency->tick();
															#line 167 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<NetworkTestReply> __when_expr_0 = retryBrokenPromise(interfs[deterministicRandom()->randomInt(0, interfs.size())].test, NetworkTestRequest(StringRef(request_payload), FLOW_KNOBS->NETWORK_TEST_REPLY_SIZE));
															#line 167 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<TestClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1139 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TestClientActor*>(this)->actor_wait_state = 1;
															#line 167 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TestClientActor, 0, NetworkTestReply >*>(static_cast<TestClientActor*>(this)));
															#line 1144 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(NetworkTestReply const& rep,int loopDepth) 
	{
															#line 170 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		latency->tock(sample);
															#line 171 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		(*completed)++;
															#line 1168 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(NetworkTestReply && rep,int loopDepth) 
	{
															#line 170 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		latency->tock(sample);
															#line 171 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		(*completed)++;
															#line 1179 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(NetworkTestReply const& rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(rep, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(NetworkTestReply && rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestClientActor*>(this)->actor_wait_state > 0) static_cast<TestClientActor*>(this)->actor_wait_state = 0;
		static_cast<TestClientActor*>(this)->ActorCallback< TestClientActor, 0, NetworkTestReply >::remove();

	}
	void a_callback_fire(ActorCallback< TestClientActor, 0, NetworkTestReply >*,NetworkTestReply const& value) 
	{
		fdb_probe_actor_enter("testClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TestClientActor, 0, NetworkTestReply >*,NetworkTestReply && value) 
	{
		fdb_probe_actor_enter("testClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TestClientActor, 0, NetworkTestReply >*,Error err) 
	{
		fdb_probe_actor_enter("testClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClient", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	std::vector<NetworkTestInterface> interfs;
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int* sent;
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int* completed;
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	LatencyStats* latency;
															#line 161 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	std::string request_payload;
															#line 162 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	LatencyStats::sample sample;
															#line 1271 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
};
// This generated class is to be used only via testClient()
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class TestClientActor final : public Actor<Void>, public ActorCallback< TestClientActor, 0, NetworkTestReply >, public FastAllocated<TestClientActor>, public TestClientActorState<TestClientActor> {
															#line 1276 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
	using FastAllocated<TestClientActor>::operator new;
	using FastAllocated<TestClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(862866141443403264UL, 11102076376031334656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TestClientActor, 0, NetworkTestReply >;
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	TestClientActor(std::vector<NetworkTestInterface> const& interfs,int* const& sent,int* const& completed,LatencyStats* const& latency) 
															#line 1293 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		 : Actor<Void>(),
		   TestClientActorState<TestClientActor>(interfs, sent, completed, latency),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2507000208969744896UL, 3302717861848338688UL);
		ActorExecutionContextHelper __helper(static_cast<TestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TestClientActor, 0, NetworkTestReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
[[nodiscard]] Future<Void> testClient( std::vector<NetworkTestInterface> const& interfs, int* const& sent, int* const& completed, LatencyStats* const& latency ) {
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	return Future<Void>(new TestClientActor(interfs, sent, completed, latency));
															#line 1326 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
}

#line 175 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"

															#line 1331 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
namespace {
// This generated class is to be used only via testClientStream()
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
template <class TestClientStreamActor>
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class TestClientStreamActorState {
															#line 1338 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	TestClientStreamActorState(std::vector<NetworkTestInterface> const& interfs,int* const& sent,int* const& completed,LatencyStats* const& latency) 
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		 : interfs(interfs),
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   sent(sent),
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   completed(completed),
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   latency(latency),
															#line 180 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   request_payload(FLOW_KNOBS->NETWORK_TEST_REQUEST_SIZE, '.'),
															#line 181 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   sample()
															#line 1355 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
	{
		fdb_probe_actor_create("testClientStream", reinterpret_cast<unsigned long>(this));

	}
	~TestClientStreamActorState() 
	{
		fdb_probe_actor_destroy("testClientStream", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 183 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			;
															#line 1370 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TestClientStreamActorState();
		static_cast<TestClientStreamActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 202 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!static_cast<TestClientStreamActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TestClientStreamActorState(); static_cast<TestClientStreamActor*>(this)->destroy(); return 0; }
															#line 1393 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		new (&static_cast<TestClientStreamActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TestClientStreamActorState();
		static_cast<TestClientStreamActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 183 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!(moreRequestsPending(*sent)))
															#line 1412 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 184 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		(*sent)++;
															#line 185 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		sample = latency->tick();
															#line 186 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		stream = interfs[deterministicRandom()->randomInt(0, interfs.size())].testStream.getReplyStream( NetworkTestStreamingRequest{});
															#line 189 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		j = 0;
															#line 1424 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		try {
															#line 191 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			;
															#line 1428 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 199 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		latency->tock(sample);
															#line 200 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		(*completed)++;
															#line 1458 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 196 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			ASSERT(e.code() == error_code_end_of_stream || e.code() == error_code_connection_failed || e.code() == error_code_request_maybe_delivered);
															#line 1468 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		auto __when_expr_0 = stream.getFuture();
															#line 1490 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<NetworkTestStreamingReply>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<NetworkTestStreamingReply>>::value, "invalid type");
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<TestClientStreamActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1494 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<TestClientStreamActor*>(this)->actor_wait_state = 1;
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< TestClientStreamActor, 0, NetworkTestStreamingReply >*>(static_cast<TestClientStreamActor*>(this)));
															#line 1499 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(NetworkTestStreamingReply const& rep,int loopDepth) 
	{
															#line 193 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		ASSERT(rep.index == j++);
															#line 1508 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(NetworkTestStreamingReply && rep,int loopDepth) 
	{
															#line 193 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		ASSERT(rep.index == j++);
															#line 1517 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(NetworkTestStreamingReply const& rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(rep, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(NetworkTestStreamingReply && rep,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(rep), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TestClientStreamActor*>(this)->actor_wait_state > 0) static_cast<TestClientStreamActor*>(this)->actor_wait_state = 0;
		static_cast<TestClientStreamActor*>(this)->ActorSingleCallback< TestClientStreamActor, 0, NetworkTestStreamingReply >::remove();

	}
	void a_callback_fire(ActorSingleCallback< TestClientStreamActor, 0, NetworkTestStreamingReply >*,NetworkTestStreamingReply const& value) 
	{
		fdb_probe_actor_enter("testClientStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClientStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< TestClientStreamActor, 0, NetworkTestStreamingReply >*,NetworkTestStreamingReply && value) 
	{
		fdb_probe_actor_enter("testClientStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TestClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClientStream", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< TestClientStreamActor, 0, NetworkTestStreamingReply >*,Error err) 
	{
		fdb_probe_actor_enter("testClientStream", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TestClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("testClientStream", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	std::vector<NetworkTestInterface> interfs;
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int* sent;
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int* completed;
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	LatencyStats* latency;
															#line 180 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	std::string request_payload;
															#line 181 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	LatencyStats::sample sample;
															#line 186 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	ReplyPromiseStream<NetworkTestStreamingReply> stream;
															#line 189 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int j;
															#line 1613 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
};
// This generated class is to be used only via testClientStream()
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class TestClientStreamActor final : public Actor<Void>, public ActorSingleCallback< TestClientStreamActor, 0, NetworkTestStreamingReply >, public FastAllocated<TestClientStreamActor>, public TestClientStreamActorState<TestClientStreamActor> {
															#line 1618 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
	using FastAllocated<TestClientStreamActor>::operator new;
	using FastAllocated<TestClientStreamActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10099632371164369664UL, 14923606144876982272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< TestClientStreamActor, 0, NetworkTestStreamingReply >;
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	TestClientStreamActor(std::vector<NetworkTestInterface> const& interfs,int* const& sent,int* const& completed,LatencyStats* const& latency) 
															#line 1635 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		 : Actor<Void>(),
		   TestClientStreamActorState<TestClientStreamActor>(interfs, sent, completed, latency),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("testClientStream", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16025981438584099584UL, 17674244585900507904UL);
		ActorExecutionContextHelper __helper(static_cast<TestClientStreamActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("testClientStream");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("testClientStream", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< TestClientStreamActor, 0, NetworkTestStreamingReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
[[nodiscard]] Future<Void> testClientStream( std::vector<NetworkTestInterface> const& interfs, int* const& sent, int* const& completed, LatencyStats* const& latency ) {
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	return Future<Void>(new TestClientStreamActor(interfs, sent, completed, latency));
															#line 1668 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
}

#line 204 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"

															#line 1673 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
namespace {
// This generated class is to be used only via logger()
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
template <class LoggerActor>
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class LoggerActorState {
															#line 1680 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	LoggerActorState(int* const& sent,int* const& completed,LatencyStats* const& latency) 
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		 : sent(sent),
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   completed(completed),
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   latency(latency),
															#line 206 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   lastTime(now()),
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   logged(0),
															#line 208 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   iteration(0)
															#line 1697 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
	{
		fdb_probe_actor_create("logger", reinterpret_cast<unsigned long>(this));

	}
	~LoggerActorState() 
	{
		fdb_probe_actor_destroy("logger", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 209 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			;
															#line 1712 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoggerActorState();
		static_cast<LoggerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 225 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		*sent = -1;
															#line 226 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!static_cast<LoggerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoggerActorState(); static_cast<LoggerActor*>(this)->destroy(); return 0; }
															#line 1737 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		new (&static_cast<LoggerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoggerActorState();
		static_cast<LoggerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 209 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!(moreLoggingNeeded(logged, ++iteration)))
															#line 1756 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 210 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 210 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<LoggerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1764 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<LoggerActor*>(this)->actor_wait_state = 1;
															#line 210 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoggerActor, 0, Void >*>(static_cast<LoggerActor*>(this)));
															#line 1769 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		auto spd = (*completed - logged) / (now() - lastTime);
															#line 212 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (FLOW_KNOBS->NETWORK_TEST_SCRIPT_MODE)
															#line 1793 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
															#line 213 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (iteration == 2)
															#line 1797 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			{
															#line 215 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				printf("%f\t%.3f\t%.3f\n", spd, latency->mean() * 1e6, latency->stddev() * 1e6);
															#line 1801 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			}
		}
		else
		{
															#line 218 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			fprintf(stderr, "messages per second: %f (%6.3f us)\n", spd, latency->mean() * 1e6);
															#line 1808 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
															#line 220 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		latency->reset();
															#line 221 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		lastTime = now();
															#line 222 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		logged = *completed;
															#line 1816 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 211 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		auto spd = (*completed - logged) / (now() - lastTime);
															#line 212 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (FLOW_KNOBS->NETWORK_TEST_SCRIPT_MODE)
															#line 1827 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
															#line 213 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (iteration == 2)
															#line 1831 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			{
															#line 215 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				printf("%f\t%.3f\t%.3f\n", spd, latency->mean() * 1e6, latency->stddev() * 1e6);
															#line 1835 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			}
		}
		else
		{
															#line 218 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			fprintf(stderr, "messages per second: %f (%6.3f us)\n", spd, latency->mean() * 1e6);
															#line 1842 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
															#line 220 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		latency->reset();
															#line 221 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		lastTime = now();
															#line 222 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		logged = *completed;
															#line 1850 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoggerActor*>(this)->actor_wait_state > 0) static_cast<LoggerActor*>(this)->actor_wait_state = 0;
		static_cast<LoggerActor*>(this)->ActorCallback< LoggerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoggerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("logger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoggerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("logger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logger", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoggerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("logger", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("logger", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int* sent;
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int* completed;
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	LatencyStats* latency;
															#line 206 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	double lastTime;
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int logged;
															#line 208 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int iteration;
															#line 1942 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
};
// This generated class is to be used only via logger()
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class LoggerActor final : public Actor<Void>, public ActorCallback< LoggerActor, 0, Void >, public FastAllocated<LoggerActor>, public LoggerActorState<LoggerActor> {
															#line 1947 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
	using FastAllocated<LoggerActor>::operator new;
	using FastAllocated<LoggerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10151237791850326528UL, 5211025552046977536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoggerActor, 0, Void >;
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	LoggerActor(int* const& sent,int* const& completed,LatencyStats* const& latency) 
															#line 1964 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		 : Actor<Void>(),
		   LoggerActorState<LoggerActor>(sent, completed, latency),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("logger", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(121836529648399872UL, 5205237752744888576UL);
		ActorExecutionContextHelper __helper(static_cast<LoggerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("logger");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("logger", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoggerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
[[nodiscard]] Future<Void> logger( int* const& sent, int* const& completed, LatencyStats* const& latency ) {
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	return Future<Void>(new LoggerActor(sent, completed, latency));
															#line 1997 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
}

#line 228 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"

static void networkTestnanosleep() {
	printf("nanosleep speed test\n");

#ifdef __linux__
	printf("\nnanosleep(10) latencies:");
	for (int i = 0; i < 10; i++) {

		double before = timer_monotonic();
		timespec tv;
		tv.tv_sec = 0;
		tv.tv_nsec = 10;
		nanosleep(&tv, nullptr);
		double after = timer_monotonic();

		printf(" %0.3lf", (after - before) * 1e6);
	}

	printf("\nnanosleep(10) latency after 5ms spin:");
	for (int i = 0; i < 10; i++) {
		double a = timer_monotonic() + 5e-3;
		while (timer_monotonic() < a) {
		}

		double before = timer_monotonic();
		timespec tv;
		tv.tv_sec = 0;
		tv.tv_nsec = 10;
		nanosleep(&tv, nullptr);
		double after = timer_monotonic();
		printf(" %0.3lf", (after - before) * 1e6);
	}

	printf("\nnanosleep(20000) latency:");
	for (int i = 0; i < 10; i++) {
		double before = timer_monotonic();
		timespec tv;
		tv.tv_sec = 0;
		tv.tv_nsec = 20000;
		nanosleep(&tv, nullptr);
		double after = timer_monotonic();

		printf(" %0.3lf", (after - before) * 1e6);
	}
	printf("\n");

	printf("nanosleep(20000) loop\n");
	while (true) {
		timespec tv;
		tv.tv_sec = 0;
		tv.tv_nsec = 20000;
		nanosleep(&tv, nullptr);
	}
#endif

	return;
}

															#line 2059 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
namespace {
// This generated class is to be used only via networkTestClient()
															#line 286 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
template <class NetworkTestClientActor>
															#line 286 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class NetworkTestClientActorState {
															#line 2066 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
															#line 286 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	NetworkTestClientActorState(std::string const& testServers) 
															#line 286 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
															#line 286 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		 : testServers(testServers)
															#line 2073 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
	{
		fdb_probe_actor_create("networkTestClient", reinterpret_cast<unsigned long>(this));

	}
	~NetworkTestClientActorState() 
	{
		fdb_probe_actor_destroy("networkTestClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 287 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (testServers == "nanosleep")
															#line 2088 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			{
															#line 288 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				networkTestnanosleep();
															#line 2092 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			}
															#line 292 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			interfs = std::vector<NetworkTestInterface>();
															#line 293 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			servers = NetworkAddress::parseList(testServers);
															#line 294 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			sent = 0;
															#line 295 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			completed = 0;
															#line 296 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			latency = LatencyStats();
															#line 298 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			interfs.reserve(servers.size());
															#line 299 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			for(int i = 0;i < servers.size();i++) {
															#line 300 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				interfs.push_back(NetworkTestInterface(servers[i]));
															#line 2110 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			}
															#line 303 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			clients = std::vector<Future<Void>>();
															#line 304 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			clients.reserve(FLOW_KNOBS->NETWORK_TEST_CLIENT_COUNT);
															#line 305 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			for(int i = 0;i < FLOW_KNOBS->NETWORK_TEST_CLIENT_COUNT;i++) {
															#line 306 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				clients.push_back(testClient(interfs, &sent, &completed, &latency));
															#line 2120 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			}
															#line 308 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			clients.push_back(logger(&sent, &completed, &latency));
															#line 310 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(clients);
															#line 310 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (static_cast<NetworkTestClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2128 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<NetworkTestClientActor*>(this)->actor_wait_state = 1;
															#line 310 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NetworkTestClientActor, 0, Void >*>(static_cast<NetworkTestClientActor*>(this)));
															#line 2133 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NetworkTestClientActorState();
		static_cast<NetworkTestClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 311 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!static_cast<NetworkTestClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NetworkTestClientActorState(); static_cast<NetworkTestClientActor*>(this)->destroy(); return 0; }
															#line 2156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		new (&static_cast<NetworkTestClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NetworkTestClientActorState();
		static_cast<NetworkTestClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 311 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!static_cast<NetworkTestClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NetworkTestClientActorState(); static_cast<NetworkTestClientActor*>(this)->destroy(); return 0; }
															#line 2168 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		new (&static_cast<NetworkTestClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NetworkTestClientActorState();
		static_cast<NetworkTestClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NetworkTestClientActor*>(this)->actor_wait_state > 0) static_cast<NetworkTestClientActor*>(this)->actor_wait_state = 0;
		static_cast<NetworkTestClientActor*>(this)->ActorCallback< NetworkTestClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NetworkTestClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("networkTestClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NetworkTestClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("networkTestClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NetworkTestClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("networkTestClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("networkTestClient", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 286 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	std::string testServers;
															#line 292 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	std::vector<NetworkTestInterface> interfs;
															#line 293 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	std::vector<NetworkAddress> servers;
															#line 294 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int sent;
															#line 295 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int completed;
															#line 296 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	LatencyStats latency;
															#line 303 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	std::vector<Future<Void>> clients;
															#line 2265 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
};
// This generated class is to be used only via networkTestClient()
															#line 286 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class NetworkTestClientActor final : public Actor<Void>, public ActorCallback< NetworkTestClientActor, 0, Void >, public FastAllocated<NetworkTestClientActor>, public NetworkTestClientActorState<NetworkTestClientActor> {
															#line 2270 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
	using FastAllocated<NetworkTestClientActor>::operator new;
	using FastAllocated<NetworkTestClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13616548161096416000UL, 11221964350104686080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NetworkTestClientActor, 0, Void >;
															#line 286 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	NetworkTestClientActor(std::string const& testServers) 
															#line 2287 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		 : Actor<Void>(),
		   NetworkTestClientActorState<NetworkTestClientActor>(testServers),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("networkTestClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6593423090462528256UL, 13694205517824845056UL);
		ActorExecutionContextHelper __helper(static_cast<NetworkTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("networkTestClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("networkTestClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NetworkTestClientActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 286 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
[[nodiscard]] Future<Void> networkTestClient( std::string const& testServers ) {
															#line 286 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	return Future<Void>(new NetworkTestClientActor(testServers));
															#line 2320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
}

#line 313 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"

struct RandomIntRange {
	int min;
	int max;

	RandomIntRange(int low = 0, int high = 0) : min(low), max(high) {}

	// Accepts strings of the form "min:max" or "N"
	// where N will be used for both min and max
	RandomIntRange(std::string str) {
		StringRef high = str;
		StringRef low = high.eat(":");
		if (high.size() == 0) {
			high = low;
		}
		min = low.size() == 0 ? 0 : atol(low.toString().c_str());
		max = high.size() == 0 ? 0 : atol(high.toString().c_str());
		if (min > max) {
			std::swap(min, max);
		}
	}

	int get() const { return (max == 0) ? 0 : nondeterministicRandom()->randomInt(min, max + 1); }

	std::string toString() const { return format("%d:%d", min, max); }
};

struct P2PNetworkTest {
	// Addresses to listen on
	std::vector<Reference<IListener>> listeners;
	// Addresses to randomly connect to
	std::vector<NetworkAddress> remotes;
	// Number of outgoing connections to maintain
	int connectionsOut;
	// Message size range to send on outgoing established connections
	RandomIntRange requestBytes;
	// Message size to reply with on incoming established connections
	RandomIntRange replyBytes;
	// Number of requests/replies per session
	RandomIntRange requests;
	// Delay after message send and receive are complete before closing connection
	RandomIntRange idleMilliseconds;
	// Random delay before socket reads
	RandomIntRange waitReadMilliseconds;
	// Random delay before socket writes
	RandomIntRange waitWriteMilliseconds;
	double targetDuration;
	double startTime;
	double globalStartTime;
	int64_t bytesSent;
	int64_t bytesReceived;
	int sessionsIn;
	int sessionsOut;
	int connectErrors;
	int acceptErrors;
	int sessionErrors;

	Standalone<StringRef> msgBuffer;

	std::string statsString() {
		double elapsed = now() - startTime;
		std::string s = format(
		    "%.2f MB/s bytes in  %.2f MB/s bytes out  %.2f/s completed sessions in  %.2f/s completed sessions out  ",
		    bytesReceived / elapsed / 1e6,
		    bytesSent / elapsed / 1e6,
		    sessionsIn / elapsed,
		    sessionsOut / elapsed);
		s += format("Total Errors %d  connect error=%d  accept error=%d  session error=%d  ",
		            connectErrors + acceptErrors + sessionErrors,
		            connectErrors,
		            acceptErrors,
		            sessionErrors);
		s += format("Remaining time %.0f seconds",
		            targetDuration > 0 ? std::max(0.0, targetDuration - (now() - globalStartTime)) : 0.0);
		bytesSent = 0;
		bytesReceived = 0;
		sessionsIn = 0;
		sessionsOut = 0;
		startTime = now();
		return s;
	}

	P2PNetworkTest() {}

	P2PNetworkTest(std::string listenerAddresses,
	               std::string remoteAddresses,
	               int connectionsOut,
	               RandomIntRange sendMsgBytes,
	               RandomIntRange recvMsgBytes,
	               RandomIntRange requests,
	               RandomIntRange idleMilliseconds,
	               RandomIntRange waitReadMilliseconds,
	               RandomIntRange waitWriteMilliseconds,
	               double targetDuration)
	  : connectionsOut(connectionsOut), requestBytes(sendMsgBytes), replyBytes(recvMsgBytes), requests(requests),
	    idleMilliseconds(idleMilliseconds), waitReadMilliseconds(waitReadMilliseconds),
	    waitWriteMilliseconds(waitWriteMilliseconds), targetDuration(targetDuration) {
		bytesSent = 0;
		bytesReceived = 0;
		sessionsIn = 0;
		sessionsOut = 0;
		connectErrors = 0;
		acceptErrors = 0;
		sessionErrors = 0;
		msgBuffer = makeString(std::max(sendMsgBytes.max, recvMsgBytes.max));

		if (!remoteAddresses.empty()) {
			remotes = NetworkAddress::parseList(remoteAddresses);
		}

		if (!listenerAddresses.empty()) {
			for (auto a : NetworkAddress::parseList(listenerAddresses)) {
				listeners.push_back(INetworkConnections::net()->listen(a));
			}
		}
	}

	NetworkAddress randomRemote() { return remotes[nondeterministicRandom()->randomInt(0, remotes.size())]; }

																#line 2443 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
// This generated class is to be used only via readMsg()
															#line 432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
template <class ReadMsgActor>
															#line 432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class ReadMsgActorState {
															#line 2449 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
															#line 432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	ReadMsgActorState(P2PNetworkTest* const& self,Reference<IConnection> const& conn) 
															#line 432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
															#line 432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		 : self(self),
															#line 432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   conn(conn),
															#line 433 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   buffer(makeString(sizeof(int))),
															#line 434 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   writeOffset(0),
															#line 435 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   gotHeader(false)
															#line 2464 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
	{
		fdb_probe_actor_create("readMsg", reinterpret_cast<unsigned long>(this));

	}
	~ReadMsgActorState() 
	{
		fdb_probe_actor_destroy("readMsg", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 439 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			;
															#line 2479 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadMsgActorState();
		static_cast<ReadMsgActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 440 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		int stutter = self->waitReadMilliseconds.get();
															#line 441 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (stutter > 0)
															#line 2511 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
															#line 442 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(stutter / 1e3);
															#line 442 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (static_cast<ReadMsgActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2517 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadMsgActor*>(this)->actor_wait_state = 1;
															#line 442 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadMsgActor, 0, Void >*>(static_cast<ReadMsgActor*>(this)));
															#line 2522 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 445 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		int len = conn->read((uint8_t*)buffer.begin() + writeOffset, (uint8_t*)buffer.end());
															#line 446 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		writeOffset += len;
															#line 447 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		self->bytesReceived += len;
															#line 450 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (writeOffset == buffer.size())
															#line 2542 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
															#line 451 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (gotHeader)
															#line 2546 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			{
															#line 452 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				if (!static_cast<ReadMsgActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(buffer); this->~ReadMsgActorState(); static_cast<ReadMsgActor*>(this)->destroy(); return 0; }
															#line 2550 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
				new (&static_cast<ReadMsgActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(std::move(buffer)); // state_var_RVO
				this->~ReadMsgActorState();
				static_cast<ReadMsgActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 454 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				gotHeader = true;
															#line 455 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				int msgSize = *(int*)buffer.begin();
															#line 456 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				if (msgSize == 0)
															#line 2564 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
				{
															#line 457 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
					if (!static_cast<ReadMsgActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(Standalone<StringRef>()); this->~ReadMsgActorState(); static_cast<ReadMsgActor*>(this)->destroy(); return 0; }
															#line 2568 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
					new (&static_cast<ReadMsgActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(Standalone<StringRef>());
					this->~ReadMsgActorState();
					static_cast<ReadMsgActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
															#line 459 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				buffer = makeString(msgSize);
															#line 460 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				writeOffset = 0;
															#line 2578 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			}
		}
															#line 464 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (len == 0)
															#line 2583 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
															#line 465 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			StrictFuture<Void> __when_expr_1 = conn->onReadable();
															#line 465 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (static_cast<ReadMsgActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadMsgActor*>(this)->actor_wait_state = 2;
															#line 465 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadMsgActor, 1, Void >*>(static_cast<ReadMsgActor*>(this)));
															#line 2594 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadMsgActor*>(this)->actor_wait_state > 0) static_cast<ReadMsgActor*>(this)->actor_wait_state = 0;
		static_cast<ReadMsgActor*>(this)->ActorCallback< ReadMsgActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadMsgActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readMsg", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMsg", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadMsgActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readMsg", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMsg", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadMsgActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readMsg", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMsg", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 466 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0, TaskPriority::ReadSocket);
															#line 466 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<ReadMsgActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2703 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont8when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReadMsgActor*>(this)->actor_wait_state = 3;
															#line 466 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadMsgActor, 2, Void >*>(static_cast<ReadMsgActor*>(this)));
															#line 2708 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 466 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(0, TaskPriority::ReadSocket);
															#line 466 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<ReadMsgActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont8when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReadMsgActor*>(this)->actor_wait_state = 3;
															#line 466 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadMsgActor, 2, Void >*>(static_cast<ReadMsgActor*>(this)));
															#line 2724 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadMsgActor*>(this)->actor_wait_state > 0) static_cast<ReadMsgActor*>(this)->actor_wait_state = 0;
		static_cast<ReadMsgActor*>(this)->ActorCallback< ReadMsgActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadMsgActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readMsg", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMsg", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadMsgActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readMsg", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMsg", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadMsgActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readMsg", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMsg", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadMsgActor*>(this)->actor_wait_state > 0) static_cast<ReadMsgActor*>(this)->actor_wait_state = 0;
		static_cast<ReadMsgActor*>(this)->ActorCallback< ReadMsgActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadMsgActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readMsg", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMsg", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadMsgActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readMsg", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMsg", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadMsgActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readMsg", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readMsg", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	P2PNetworkTest* self;
															#line 432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	Reference<IConnection> conn;
															#line 433 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	Standalone<StringRef> buffer;
															#line 434 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int writeOffset;
															#line 435 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	bool gotHeader;
															#line 2901 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
};
// This generated class is to be used only via readMsg()
															#line 432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class ReadMsgActor final : public Actor<Standalone<StringRef>>, public ActorCallback< ReadMsgActor, 0, Void >, public ActorCallback< ReadMsgActor, 1, Void >, public ActorCallback< ReadMsgActor, 2, Void >, public FastAllocated<ReadMsgActor>, public ReadMsgActorState<ReadMsgActor> {
															#line 2906 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
	using FastAllocated<ReadMsgActor>::operator new;
	using FastAllocated<ReadMsgActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2732075825188075776UL, 12655377363541062656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadMsgActor, 0, Void >;
friend struct ActorCallback< ReadMsgActor, 1, Void >;
friend struct ActorCallback< ReadMsgActor, 2, Void >;
															#line 432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	ReadMsgActor(P2PNetworkTest* const& self,Reference<IConnection> const& conn) 
															#line 2925 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   ReadMsgActorState<ReadMsgActor>(self, conn),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readMsg", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1752135171599562496UL, 9881581936879679488UL);
		ActorExecutionContextHelper __helper(static_cast<ReadMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readMsg");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readMsg", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadMsgActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadMsgActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadMsgActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
[[nodiscard]] static Future<Standalone<StringRef>> readMsg( P2PNetworkTest* const& self, Reference<IConnection> const& conn ) {
															#line 432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	return Future<Standalone<StringRef>>(new ReadMsgActor(self, conn));
															#line 2959 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
}

#line 470 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"

																#line 2964 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
// This generated class is to be used only via writeMsg()
															#line 471 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
template <class WriteMsgActor>
															#line 471 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class WriteMsgActorState {
															#line 2970 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
															#line 471 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	WriteMsgActorState(P2PNetworkTest* const& self,Reference<IConnection> const& conn,StringRef const& msg) 
															#line 471 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
															#line 471 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		 : self(self),
															#line 471 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   conn(conn),
															#line 471 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   msg(msg),
															#line 472 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   packets()
															#line 2983 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
	{
		fdb_probe_actor_create("writeMsg", reinterpret_cast<unsigned long>(this));

	}
	~WriteMsgActorState() 
	{
		fdb_probe_actor_destroy("writeMsg", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 473 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			PacketWriter writer(packets.getWriteBuffer(msg.size()), nullptr, Unversioned());
															#line 474 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			writer.serializeBinaryItem((int)msg.size());
															#line 475 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			writer.serializeBytes(msg);
															#line 477 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			;
															#line 3004 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteMsgActorState();
		static_cast<WriteMsgActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!static_cast<WriteMsgActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteMsgActorState(); static_cast<WriteMsgActor*>(this)->destroy(); return 0; }
															#line 3027 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		new (&static_cast<WriteMsgActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteMsgActorState();
		static_cast<WriteMsgActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 478 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		int stutter = self->waitWriteMilliseconds.get();
															#line 479 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (stutter > 0)
															#line 3048 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
															#line 480 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(stutter / 1e3);
															#line 480 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (static_cast<WriteMsgActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3054 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteMsgActor*>(this)->actor_wait_state = 1;
															#line 480 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteMsgActor, 0, Void >*>(static_cast<WriteMsgActor*>(this)));
															#line 3059 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 482 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		int sent = conn->write(packets.getUnsent(), FLOW_KNOBS->MAX_PACKET_SEND_BYTES);
															#line 484 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (sent != 0)
															#line 3088 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
															#line 485 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			self->bytesSent += sent;
															#line 486 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			packets.sent(sent);
															#line 3094 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
															#line 489 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (packets.empty())
															#line 3098 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 493 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = conn->onWritable();
															#line 493 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<WriteMsgActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3106 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteMsgActor*>(this)->actor_wait_state = 2;
															#line 493 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteMsgActor, 1, Void >*>(static_cast<WriteMsgActor*>(this)));
															#line 3111 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteMsgActor*>(this)->actor_wait_state > 0) static_cast<WriteMsgActor*>(this)->actor_wait_state = 0;
		static_cast<WriteMsgActor*>(this)->ActorCallback< WriteMsgActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteMsgActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeMsg", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMsg", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteMsgActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeMsg", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMsg", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteMsgActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeMsg", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMsg", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 494 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = yield(TaskPriority::WriteSocket);
															#line 494 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<WriteMsgActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3209 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteMsgActor*>(this)->actor_wait_state = 3;
															#line 494 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteMsgActor, 2, Void >*>(static_cast<WriteMsgActor*>(this)));
															#line 3214 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 494 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = yield(TaskPriority::WriteSocket);
															#line 494 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<WriteMsgActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3225 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteMsgActor*>(this)->actor_wait_state = 3;
															#line 494 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteMsgActor, 2, Void >*>(static_cast<WriteMsgActor*>(this)));
															#line 3230 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteMsgActor*>(this)->actor_wait_state > 0) static_cast<WriteMsgActor*>(this)->actor_wait_state = 0;
		static_cast<WriteMsgActor*>(this)->ActorCallback< WriteMsgActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteMsgActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeMsg", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMsg", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteMsgActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeMsg", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMsg", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteMsgActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeMsg", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMsg", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteMsgActor*>(this)->actor_wait_state > 0) static_cast<WriteMsgActor*>(this)->actor_wait_state = 0;
		static_cast<WriteMsgActor*>(this)->ActorCallback< WriteMsgActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteMsgActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeMsg", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMsg", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteMsgActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeMsg", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMsg", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteMsgActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeMsg", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeMsg", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 471 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	P2PNetworkTest* self;
															#line 471 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	Reference<IConnection> conn;
															#line 471 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	StringRef msg;
															#line 472 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	UnsentPacketQueue packets;
															#line 3405 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
};
// This generated class is to be used only via writeMsg()
															#line 471 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class WriteMsgActor final : public Actor<Void>, public ActorCallback< WriteMsgActor, 0, Void >, public ActorCallback< WriteMsgActor, 1, Void >, public ActorCallback< WriteMsgActor, 2, Void >, public FastAllocated<WriteMsgActor>, public WriteMsgActorState<WriteMsgActor> {
															#line 3410 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
	using FastAllocated<WriteMsgActor>::operator new;
	using FastAllocated<WriteMsgActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11930928293351681792UL, 14902087328040407552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteMsgActor, 0, Void >;
friend struct ActorCallback< WriteMsgActor, 1, Void >;
friend struct ActorCallback< WriteMsgActor, 2, Void >;
															#line 471 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	WriteMsgActor(P2PNetworkTest* const& self,Reference<IConnection> const& conn,StringRef const& msg) 
															#line 3429 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		 : Actor<Void>(),
		   WriteMsgActorState<WriteMsgActor>(self, conn, msg),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeMsg", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14921208423531159552UL, 378455205424646400UL);
		ActorExecutionContextHelper __helper(static_cast<WriteMsgActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeMsg");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeMsg", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteMsgActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteMsgActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteMsgActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 471 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
[[nodiscard]] static Future<Void> writeMsg( P2PNetworkTest* const& self, Reference<IConnection> const& conn, StringRef const& msg ) {
															#line 471 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	return Future<Void>(new WriteMsgActor(self, conn, msg));
															#line 3463 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
}

#line 499 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"

																#line 3468 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
// This generated class is to be used only via doSession()
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
template <class DoSessionActor>
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class DoSessionActorState {
															#line 3474 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	DoSessionActorState(P2PNetworkTest* const& self,Reference<IConnection> const& conn,bool const& incoming) 
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		 : self(self),
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   conn(conn),
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   incoming(incoming),
															#line 501 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   numRequests()
															#line 3487 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
	{
		fdb_probe_actor_create("doSession", reinterpret_cast<unsigned long>(this));

	}
	~DoSessionActorState() 
	{
		fdb_probe_actor_destroy("doSession", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 504 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				if (incoming)
															#line 3503 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
				{
															#line 505 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
					StrictFuture<Void> __when_expr_0 = conn->acceptHandshake();
															#line 505 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
					if (static_cast<DoSessionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3509 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<DoSessionActor*>(this)->actor_wait_state = 1;
															#line 505 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoSessionActor, 0, Void >*>(static_cast<DoSessionActor*>(this)));
															#line 3514 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 512 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
					StrictFuture<Void> __when_expr_2 = conn->connectHandshake();
															#line 512 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
					if (static_cast<DoSessionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3523 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1when2(__when_expr_2.get(), loopDepth); };
					static_cast<DoSessionActor*>(this)->actor_wait_state = 3;
															#line 512 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoSessionActor, 2, Void >*>(static_cast<DoSessionActor*>(this)));
															#line 3528 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
					loopDepth = 0;
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoSessionActorState();
		static_cast<DoSessionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 552 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!static_cast<DoSessionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoSessionActorState(); static_cast<DoSessionActor*>(this)->destroy(); return 0; }
															#line 3558 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		new (&static_cast<DoSessionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoSessionActorState();
		static_cast<DoSessionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 546 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			++self->sessionErrors;
															#line 547 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			TraceEvent(SevError, incoming ? "P2PIncomingSessionError" : "P2POutgoingSessionError") .error(e) .detail("Remote", conn->getPeerAddress());
															#line 3573 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 519 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		;
															#line 3588 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 508 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = readMsg(self, conn);
															#line 508 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<DoSessionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3599 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoSessionActor*>(this)->actor_wait_state = 2;
															#line 508 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoSessionActor, 1, Standalone<StringRef> >*>(static_cast<DoSessionActor*>(this)));
															#line 3604 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 508 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = readMsg(self, conn);
															#line 508 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<DoSessionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3615 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<DoSessionActor*>(this)->actor_wait_state = 2;
															#line 508 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoSessionActor, 1, Standalone<StringRef> >*>(static_cast<DoSessionActor*>(this)));
															#line 3620 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoSessionActor*>(this)->actor_wait_state > 0) static_cast<DoSessionActor*>(this)->actor_wait_state = 0;
		static_cast<DoSessionActor*>(this)->ActorCallback< DoSessionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoSessionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Standalone<StringRef> const& buf,int loopDepth) 
	{
															#line 509 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		ASSERT(buf.size() == sizeof(int));
															#line 510 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		numRequests = *(int*)buf.begin();
															#line 3706 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Standalone<StringRef> && buf,int loopDepth) 
	{
															#line 509 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		ASSERT(buf.size() == sizeof(int));
															#line 510 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		numRequests = *(int*)buf.begin();
															#line 3717 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<StringRef> const& buf,int loopDepth) 
	{
		loopDepth = a_body1cont4(buf, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Standalone<StringRef> && buf,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(buf), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoSessionActor*>(this)->actor_wait_state > 0) static_cast<DoSessionActor*>(this)->actor_wait_state = 0;
		static_cast<DoSessionActor*>(this)->ActorCallback< DoSessionActor, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoSessionActor, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 515 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		numRequests = self->requests.get();
															#line 516 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_3 = writeMsg(self, conn, StringRef((const uint8_t*)&numRequests, sizeof(int)));
															#line 516 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<DoSessionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3805 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<DoSessionActor*>(this)->actor_wait_state = 4;
															#line 516 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoSessionActor, 3, Void >*>(static_cast<DoSessionActor*>(this)));
															#line 3810 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 515 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		numRequests = self->requests.get();
															#line 516 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_3 = writeMsg(self, conn, StringRef((const uint8_t*)&numRequests, sizeof(int)));
															#line 516 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<DoSessionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3823 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<DoSessionActor*>(this)->actor_wait_state = 4;
															#line 516 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoSessionActor, 3, Void >*>(static_cast<DoSessionActor*>(this)));
															#line 3828 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoSessionActor*>(this)->actor_wait_state > 0) static_cast<DoSessionActor*>(this)->actor_wait_state = 0;
		static_cast<DoSessionActor*>(this)->ActorCallback< DoSessionActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoSessionActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoSessionActor*>(this)->actor_wait_state > 0) static_cast<DoSessionActor*>(this)->actor_wait_state = 0;
		static_cast<DoSessionActor*>(this)->ActorCallback< DoSessionActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoSessionActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 537 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_8 = delay(self->idleMilliseconds.get() / 1e3);
															#line 537 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<DoSessionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 4001 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch2(__when_expr_8.getError(), loopDepth); else return a_body1cont8when1(__when_expr_8.get(), loopDepth); };
		static_cast<DoSessionActor*>(this)->actor_wait_state = 9;
															#line 537 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DoSessionActor, 8, Void >*>(static_cast<DoSessionActor*>(this)));
															#line 4006 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 519 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!(numRequests > 0))
															#line 4022 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 520 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (incoming)
															#line 4028 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
															#line 522 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			StrictFuture<Void> __when_expr_4 = success(readMsg(self, conn));
															#line 522 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (static_cast<DoSessionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4034 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<DoSessionActor*>(this)->actor_wait_state = 5;
															#line 522 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoSessionActor, 4, Void >*>(static_cast<DoSessionActor*>(this)));
															#line 4039 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 527 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			StrictFuture<Void> __when_expr_6 = writeMsg(self, conn, self->msgBuffer.substr(0, self->requestBytes.get()));
															#line 527 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (static_cast<DoSessionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4048 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2(__when_expr_6.get(), loopDepth); };
			static_cast<DoSessionActor*>(this)->actor_wait_state = 7;
															#line 527 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoSessionActor, 6, Void >*>(static_cast<DoSessionActor*>(this)));
															#line 4053 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 532 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (--numRequests == 0)
															#line 4076 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 524 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_5 = writeMsg(self, conn, self->msgBuffer.substr(0, self->replyBytes.get()));
															#line 524 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<DoSessionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4090 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<DoSessionActor*>(this)->actor_wait_state = 6;
															#line 524 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoSessionActor, 5, Void >*>(static_cast<DoSessionActor*>(this)));
															#line 4095 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 524 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_5 = writeMsg(self, conn, self->msgBuffer.substr(0, self->replyBytes.get()));
															#line 524 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<DoSessionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4106 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<DoSessionActor*>(this)->actor_wait_state = 6;
															#line 524 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoSessionActor, 5, Void >*>(static_cast<DoSessionActor*>(this)));
															#line 4111 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DoSessionActor*>(this)->actor_wait_state > 0) static_cast<DoSessionActor*>(this)->actor_wait_state = 0;
		static_cast<DoSessionActor*>(this)->ActorCallback< DoSessionActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DoSessionActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont2loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DoSessionActor*>(this)->actor_wait_state > 0) static_cast<DoSessionActor*>(this)->actor_wait_state = 0;
		static_cast<DoSessionActor*>(this)->ActorCallback< DoSessionActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DoSessionActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont2loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 529 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_7 = success(readMsg(self, conn));
															#line 529 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<DoSessionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4284 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont5when1(__when_expr_7.get(), loopDepth); };
		static_cast<DoSessionActor*>(this)->actor_wait_state = 8;
															#line 529 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DoSessionActor, 7, Void >*>(static_cast<DoSessionActor*>(this)));
															#line 4289 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 529 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_7 = success(readMsg(self, conn));
															#line 529 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<DoSessionActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4300 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont5when1(__when_expr_7.get(), loopDepth); };
		static_cast<DoSessionActor*>(this)->actor_wait_state = 8;
															#line 529 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DoSessionActor, 7, Void >*>(static_cast<DoSessionActor*>(this)));
															#line 4305 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DoSessionActor*>(this)->actor_wait_state > 0) static_cast<DoSessionActor*>(this)->actor_wait_state = 0;
		static_cast<DoSessionActor*>(this)->ActorCallback< DoSessionActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DoSessionActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont2loopBody1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<DoSessionActor*>(this)->actor_wait_state > 0) static_cast<DoSessionActor*>(this)->actor_wait_state = 0;
		static_cast<DoSessionActor*>(this)->ActorCallback< DoSessionActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont2loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< DoSessionActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 538 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		conn->close();
															#line 540 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (incoming)
															#line 4478 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
															#line 541 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			++self->sessionsIn;
															#line 4482 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
		else
		{
															#line 543 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			++self->sessionsOut;
															#line 4488 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 538 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		conn->close();
															#line 540 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (incoming)
															#line 4500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
															#line 541 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			++self->sessionsIn;
															#line 4504 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
		else
		{
															#line 543 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			++self->sessionsOut;
															#line 4510 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		}
		loopDepth = a_body1cont13(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<DoSessionActor*>(this)->actor_wait_state > 0) static_cast<DoSessionActor*>(this)->actor_wait_state = 0;
		static_cast<DoSessionActor*>(this)->ActorCallback< DoSessionActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< DoSessionActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< DoSessionActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont13(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	P2PNetworkTest* self;
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	Reference<IConnection> conn;
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	bool incoming;
															#line 501 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	int numRequests;
															#line 4612 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
};
// This generated class is to be used only via doSession()
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class DoSessionActor final : public Actor<Void>, public ActorCallback< DoSessionActor, 0, Void >, public ActorCallback< DoSessionActor, 1, Standalone<StringRef> >, public ActorCallback< DoSessionActor, 2, Void >, public ActorCallback< DoSessionActor, 3, Void >, public ActorCallback< DoSessionActor, 4, Void >, public ActorCallback< DoSessionActor, 5, Void >, public ActorCallback< DoSessionActor, 6, Void >, public ActorCallback< DoSessionActor, 7, Void >, public ActorCallback< DoSessionActor, 8, Void >, public FastAllocated<DoSessionActor>, public DoSessionActorState<DoSessionActor> {
															#line 4617 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
	using FastAllocated<DoSessionActor>::operator new;
	using FastAllocated<DoSessionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10388739566011687680UL, 6384244608549185792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoSessionActor, 0, Void >;
friend struct ActorCallback< DoSessionActor, 1, Standalone<StringRef> >;
friend struct ActorCallback< DoSessionActor, 2, Void >;
friend struct ActorCallback< DoSessionActor, 3, Void >;
friend struct ActorCallback< DoSessionActor, 4, Void >;
friend struct ActorCallback< DoSessionActor, 5, Void >;
friend struct ActorCallback< DoSessionActor, 6, Void >;
friend struct ActorCallback< DoSessionActor, 7, Void >;
friend struct ActorCallback< DoSessionActor, 8, Void >;
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	DoSessionActor(P2PNetworkTest* const& self,Reference<IConnection> const& conn,bool const& incoming) 
															#line 4642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		 : Actor<Void>(),
		   DoSessionActorState<DoSessionActor>(self, conn, incoming),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doSession", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(499054008761010944UL, 14557343032080956160UL);
		ActorExecutionContextHelper __helper(static_cast<DoSessionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doSession");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doSession", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoSessionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoSessionActor, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoSessionActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoSessionActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DoSessionActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DoSessionActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DoSessionActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< DoSessionActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< DoSessionActor, 8, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
[[nodiscard]] static Future<Void> doSession( P2PNetworkTest* const& self, Reference<IConnection> const& conn, bool const& incoming ) {
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	return Future<Void>(new DoSessionActor(self, conn, incoming));
															#line 4682 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
}

#line 554 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"

																#line 4687 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
// This generated class is to be used only via outgoing()
															#line 555 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
template <class OutgoingActor>
															#line 555 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class OutgoingActorState {
															#line 4693 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
															#line 555 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	OutgoingActorState(P2PNetworkTest* const& self) 
															#line 555 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
															#line 555 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		 : self(self)
															#line 4700 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
	{
		fdb_probe_actor_create("outgoing", reinterpret_cast<unsigned long>(this));

	}
	~OutgoingActorState() 
	{
		fdb_probe_actor_destroy("outgoing", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 556 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			;
															#line 4715 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OutgoingActorState();
		static_cast<OutgoingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 557 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::WriteSocket);
															#line 557 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<OutgoingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4747 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<OutgoingActor*>(this)->actor_wait_state = 1;
															#line 557 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OutgoingActor, 0, Void >*>(static_cast<OutgoingActor*>(this)));
															#line 4752 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 558 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		remote = self->randomRemote();
															#line 4761 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		try {
															#line 561 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			StrictFuture<Reference<IConnection>> __when_expr_1 = INetworkConnections::net()->connect(remote);
															#line 561 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (static_cast<OutgoingActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4767 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<OutgoingActor*>(this)->actor_wait_state = 2;
															#line 561 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OutgoingActor, 1, Reference<IConnection> >*>(static_cast<OutgoingActor*>(this)));
															#line 4772 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 558 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		remote = self->randomRemote();
															#line 4787 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		try {
															#line 561 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			StrictFuture<Reference<IConnection>> __when_expr_1 = INetworkConnections::net()->connect(remote);
															#line 561 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (static_cast<OutgoingActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4793 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<OutgoingActor*>(this)->actor_wait_state = 2;
															#line 561 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OutgoingActor, 1, Reference<IConnection> >*>(static_cast<OutgoingActor*>(this)));
															#line 4798 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OutgoingActor*>(this)->actor_wait_state > 0) static_cast<OutgoingActor*>(this)->actor_wait_state = 0;
		static_cast<OutgoingActor*>(this)->ActorCallback< OutgoingActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OutgoingActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("outgoing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OutgoingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("outgoing", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OutgoingActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("outgoing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OutgoingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("outgoing", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OutgoingActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("outgoing", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OutgoingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("outgoing", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 565 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			++self->connectErrors;
															#line 566 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			TraceEvent(SevError, "P2POutgoingError").error(e).detail("Remote", remote);
															#line 567 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(1);
															#line 567 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (static_cast<OutgoingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4901 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<OutgoingActor*>(this)->actor_wait_state = 4;
															#line 567 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< OutgoingActor, 3, Void >*>(static_cast<OutgoingActor*>(this)));
															#line 4906 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 563 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = doSession(self, conn, false);
															#line 563 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<OutgoingActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 4923 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<OutgoingActor*>(this)->actor_wait_state = 3;
															#line 563 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< OutgoingActor, 2, Void >*>(static_cast<OutgoingActor*>(this)));
															#line 4928 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Reference<IConnection> const& __conn,int loopDepth) 
	{
															#line 561 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		conn = __conn;
															#line 4937 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Reference<IConnection> && __conn,int loopDepth) 
	{
		conn = std::move(__conn);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OutgoingActor*>(this)->actor_wait_state > 0) static_cast<OutgoingActor*>(this)->actor_wait_state = 0;
		static_cast<OutgoingActor*>(this)->ActorCallback< OutgoingActor, 1, Reference<IConnection> >::remove();

	}
	void a_callback_fire(ActorCallback< OutgoingActor, 1, Reference<IConnection> >*,Reference<IConnection> const& value) 
	{
		fdb_probe_actor_enter("outgoing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OutgoingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("outgoing", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OutgoingActor, 1, Reference<IConnection> >*,Reference<IConnection> && value) 
	{
		fdb_probe_actor_enter("outgoing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OutgoingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("outgoing", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OutgoingActor, 1, Reference<IConnection> >*,Error err) 
	{
		fdb_probe_actor_enter("outgoing", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OutgoingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("outgoing", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<OutgoingActor*>(this)->actor_wait_state > 0) static_cast<OutgoingActor*>(this)->actor_wait_state = 0;
		static_cast<OutgoingActor*>(this)->ActorCallback< OutgoingActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OutgoingActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("outgoing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OutgoingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("outgoing", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< OutgoingActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("outgoing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OutgoingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("outgoing", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< OutgoingActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("outgoing", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OutgoingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("outgoing", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<OutgoingActor*>(this)->actor_wait_state > 0) static_cast<OutgoingActor*>(this)->actor_wait_state = 0;
		static_cast<OutgoingActor*>(this)->ActorCallback< OutgoingActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OutgoingActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("outgoing", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OutgoingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("outgoing", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< OutgoingActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("outgoing", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OutgoingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("outgoing", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< OutgoingActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("outgoing", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OutgoingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("outgoing", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 555 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	P2PNetworkTest* self;
															#line 558 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	NetworkAddress remote;
															#line 561 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	Reference<IConnection> conn;
															#line 5205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
};
// This generated class is to be used only via outgoing()
															#line 555 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class OutgoingActor final : public Actor<Void>, public ActorCallback< OutgoingActor, 0, Void >, public ActorCallback< OutgoingActor, 1, Reference<IConnection> >, public ActorCallback< OutgoingActor, 2, Void >, public ActorCallback< OutgoingActor, 3, Void >, public FastAllocated<OutgoingActor>, public OutgoingActorState<OutgoingActor> {
															#line 5210 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
	using FastAllocated<OutgoingActor>::operator new;
	using FastAllocated<OutgoingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10293997641279436032UL, 17569503506557605888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OutgoingActor, 0, Void >;
friend struct ActorCallback< OutgoingActor, 1, Reference<IConnection> >;
friend struct ActorCallback< OutgoingActor, 2, Void >;
friend struct ActorCallback< OutgoingActor, 3, Void >;
															#line 555 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	OutgoingActor(P2PNetworkTest* const& self) 
															#line 5230 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		 : Actor<Void>(),
		   OutgoingActorState<OutgoingActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("outgoing", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7678516466495174656UL, 617111602333335040UL);
		ActorExecutionContextHelper __helper(static_cast<OutgoingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("outgoing");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("outgoing", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OutgoingActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OutgoingActor, 1, Reference<IConnection> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< OutgoingActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< OutgoingActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 555 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
[[nodiscard]] static Future<Void> outgoing( P2PNetworkTest* const& self ) {
															#line 555 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	return Future<Void>(new OutgoingActor(self));
															#line 5265 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
}

#line 571 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"

																#line 5270 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
// This generated class is to be used only via incoming()
															#line 572 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
template <class IncomingActor>
															#line 572 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class IncomingActorState {
															#line 5276 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
															#line 572 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	IncomingActorState(P2PNetworkTest* const& self,Reference<IListener> const& listener) 
															#line 572 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
															#line 572 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		 : self(self),
															#line 572 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   listener(listener),
															#line 573 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   sessions(false)
															#line 5287 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
	{
		fdb_probe_actor_create("incoming", reinterpret_cast<unsigned long>(this));

	}
	~IncomingActorState() 
	{
		fdb_probe_actor_destroy("incoming", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 575 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			;
															#line 5302 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncomingActorState();
		static_cast<IncomingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 576 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::AcceptSocket);
															#line 576 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<IncomingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5334 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<IncomingActor*>(this)->actor_wait_state = 1;
															#line 576 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncomingActor, 0, Void >*>(static_cast<IncomingActor*>(this)));
															#line 5339 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		try {
															#line 579 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			StrictFuture<Reference<IConnection>> __when_expr_1 = listener->accept();
															#line 579 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (static_cast<IncomingActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5351 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<IncomingActor*>(this)->actor_wait_state = 2;
															#line 579 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncomingActor, 1, Reference<IConnection> >*>(static_cast<IncomingActor*>(this)));
															#line 5356 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		try {
															#line 579 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			StrictFuture<Reference<IConnection>> __when_expr_1 = listener->accept();
															#line 579 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (static_cast<IncomingActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5374 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<IncomingActor*>(this)->actor_wait_state = 2;
															#line 579 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncomingActor, 1, Reference<IConnection> >*>(static_cast<IncomingActor*>(this)));
															#line 5379 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncomingActor*>(this)->actor_wait_state > 0) static_cast<IncomingActor*>(this)->actor_wait_state = 0;
		static_cast<IncomingActor*>(this)->ActorCallback< IncomingActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncomingActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incoming", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncomingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incoming", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncomingActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incoming", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncomingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incoming", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncomingActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incoming", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncomingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incoming", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 583 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			++self->acceptErrors;
															#line 584 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			TraceEvent(SevError, "P2PIncomingError").error(e).detail("Listener", listener->getListenAddress());
															#line 5478 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 581 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		sessions.add(doSession(self, conn, true));
															#line 5493 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Reference<IConnection> const& __conn,int loopDepth) 
	{
															#line 579 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		conn = __conn;
															#line 5502 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Reference<IConnection> && __conn,int loopDepth) 
	{
		conn = std::move(__conn);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IncomingActor*>(this)->actor_wait_state > 0) static_cast<IncomingActor*>(this)->actor_wait_state = 0;
		static_cast<IncomingActor*>(this)->ActorCallback< IncomingActor, 1, Reference<IConnection> >::remove();

	}
	void a_callback_fire(ActorCallback< IncomingActor, 1, Reference<IConnection> >*,Reference<IConnection> const& value) 
	{
		fdb_probe_actor_enter("incoming", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncomingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incoming", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IncomingActor, 1, Reference<IConnection> >*,Reference<IConnection> && value) 
	{
		fdb_probe_actor_enter("incoming", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncomingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incoming", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IncomingActor, 1, Reference<IConnection> >*,Error err) 
	{
		fdb_probe_actor_enter("incoming", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncomingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incoming", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 572 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	P2PNetworkTest* self;
															#line 572 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	Reference<IListener> listener;
															#line 573 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	ActorCollection sessions;
															#line 579 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	Reference<IConnection> conn;
															#line 5598 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
};
// This generated class is to be used only via incoming()
															#line 572 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class IncomingActor final : public Actor<Void>, public ActorCallback< IncomingActor, 0, Void >, public ActorCallback< IncomingActor, 1, Reference<IConnection> >, public FastAllocated<IncomingActor>, public IncomingActorState<IncomingActor> {
															#line 5603 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
	using FastAllocated<IncomingActor>::operator new;
	using FastAllocated<IncomingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17006902828776456960UL, 6849287112033532160UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncomingActor, 0, Void >;
friend struct ActorCallback< IncomingActor, 1, Reference<IConnection> >;
															#line 572 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	IncomingActor(P2PNetworkTest* const& self,Reference<IListener> const& listener) 
															#line 5621 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		 : Actor<Void>(),
		   IncomingActorState<IncomingActor>(self, listener),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("incoming", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16411418270032844800UL, 1312176920934643456UL);
		ActorExecutionContextHelper __helper(static_cast<IncomingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("incoming");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("incoming", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncomingActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IncomingActor, 1, Reference<IConnection> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 572 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
[[nodiscard]] static Future<Void> incoming( P2PNetworkTest* const& self, Reference<IListener> const& listener ) {
															#line 572 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	return Future<Void>(new IncomingActor(self, listener));
															#line 5654 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
}

#line 588 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"

																#line 5659 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
// This generated class is to be used only via run_impl()
															#line 589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
template <class Run_implActor>
															#line 589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class Run_implActorState {
															#line 5665 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
															#line 589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	Run_implActorState(P2PNetworkTest* const& self) 
															#line 589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
															#line 589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		 : self(self),
															#line 590 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   actors(false)
															#line 5674 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
	{
		fdb_probe_actor_create("run_impl", reinterpret_cast<unsigned long>(this));

	}
	~Run_implActorState() 
	{
		fdb_probe_actor_destroy("run_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 592 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			self->startTime = now();
															#line 593 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			self->globalStartTime = self->startTime;
															#line 595 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			fmt::print("{0} listeners, {1} remotes, {2} outgoing connections\n", self->listeners.size(), self->remotes.size(), self->connectionsOut);
															#line 600 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			for( auto n : self->remotes ) {
															#line 601 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				printf("Remote: %s\n", n.toString().c_str());
															#line 5697 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			}
															#line 604 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			for( auto el : self->listeners ) {
															#line 605 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				printf("Listener: %s\n", el->getListenAddress().toString().c_str());
															#line 606 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				actors.add(incoming(self, el));
															#line 5705 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			}
															#line 609 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			printf("Request size: %s\n", self->requestBytes.toString().c_str());
															#line 610 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			printf("Response size: %s\n", self->replyBytes.toString().c_str());
															#line 611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			printf("Requests per outgoing session: %s\n", self->requests.toString().c_str());
															#line 612 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			printf("Delay before socket read: %s\n", self->waitReadMilliseconds.toString().c_str());
															#line 613 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			printf("Delay before socket write: %s\n", self->waitWriteMilliseconds.toString().c_str());
															#line 614 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			printf("Delay before session close: %s\n", self->idleMilliseconds.toString().c_str());
															#line 615 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			printf("Send/Recv size %d bytes\n", FLOW_KNOBS->MAX_PACKET_SEND_BYTES);
															#line 617 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if ((self->remotes.empty() || self->connectionsOut == 0) && self->listeners.empty())
															#line 5723 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			{
															#line 618 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				printf("No listeners and no remotes or connectionsOut, so there is nothing to do!\n");
															#line 619 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				ASSERT((!self->remotes.empty() && (self->connectionsOut > 0)) || !self->listeners.empty());
															#line 5729 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			}
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (!self->remotes.empty())
															#line 5733 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			{
															#line 623 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
				for(int i = 0;i < self->connectionsOut;++i) {
															#line 624 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
					actors.add(outgoing(self));
															#line 5739 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
				}
			}
															#line 628 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			;
															#line 5744 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~Run_implActorState();
		static_cast<Run_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 635 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!static_cast<Run_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~Run_implActorState(); static_cast<Run_implActor*>(this)->destroy(); return 0; }
															#line 5767 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		new (&static_cast<Run_implActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~Run_implActorState();
		static_cast<Run_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 629 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1.0, TaskPriority::Max);
															#line 629 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (static_cast<Run_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5788 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<Run_implActor*>(this)->actor_wait_state = 1;
															#line 629 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< Run_implActor, 0, Void >*>(static_cast<Run_implActor*>(this)));
															#line 5793 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 630 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		printf("%s\n", self->statsString().c_str());
															#line 631 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (self->targetDuration > 0 && now() - self->globalStartTime > self->targetDuration)
															#line 5817 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 630 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		printf("%s\n", self->statsString().c_str());
															#line 631 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (self->targetDuration > 0 && now() - self->globalStartTime > self->targetDuration)
															#line 5831 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<Run_implActor*>(this)->actor_wait_state > 0) static_cast<Run_implActor*>(this)->actor_wait_state = 0;
		static_cast<Run_implActor*>(this)->ActorCallback< Run_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< Run_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Run_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< Run_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<Run_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< Run_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<Run_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	P2PNetworkTest* self;
															#line 590 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	ActorCollection actors;
															#line 5918 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
};
// This generated class is to be used only via run_impl()
															#line 589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class Run_implActor final : public Actor<Void>, public ActorCallback< Run_implActor, 0, Void >, public FastAllocated<Run_implActor>, public Run_implActorState<Run_implActor> {
															#line 5923 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
	using FastAllocated<Run_implActor>::operator new;
	using FastAllocated<Run_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(584397086250562048UL, 17771003142904658944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< Run_implActor, 0, Void >;
															#line 589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	Run_implActor(P2PNetworkTest* const& self) 
															#line 5940 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		 : Actor<Void>(),
		   Run_implActorState<Run_implActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("run_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7902255364233588480UL, 15026758637304104960UL);
		ActorExecutionContextHelper __helper(static_cast<Run_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("run_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("run_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< Run_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
[[nodiscard]] static Future<Void> run_impl( P2PNetworkTest* const& self ) {
															#line 589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	return Future<Void>(new Run_implActor(self));
															#line 5972 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
}

#line 637 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"

	Future<Void> run() { return run_impl(this); }
};

// Peer-to-Peer network test.
// One or more instances can be run and set to talk to each other.
// Each instance
//   - listens on 0 or more listenerAddresses
//   - maintains 0 or more connectionsOut at a time, each to a random choice from remoteAddresses
// Address lists are a string of comma-separated IP:port[:tls] strings.
//
// The other arguments can be specified as "fixedValue" or "minValue:maxValue".
// Each outgoing connection will live for a random requests count.
// Each request will
//   - send a random requestBytes sized message
//   - wait for a random replyBytes sized response.
// The client will close the connection after a random idleMilliseconds.
// Reads and writes can optionally preceded by random delays, waitReadMilliseconds and waitWriteMilliseconds.
															#line 5994 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase655()
															#line 655 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
template <class FlowTestCase655Actor>
															#line 655 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class FlowTestCase655ActorState {
															#line 6001 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
															#line 655 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	FlowTestCase655ActorState(UnitTestParameters const& params) 
															#line 655 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
															#line 655 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		 : params(params),
															#line 656 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		   p2p(params.get("listenerAddresses").orDefault(""), params.get("remoteAddresses").orDefault(""), params.getInt("connectionsOut").orDefault(1), params.get("requestBytes").orDefault("50:100"), params.get("replyBytes").orDefault("500:1000"), params.get("requests").orDefault("10:10000"), params.get("idleMilliseconds").orDefault("0"), params.get("waitReadMilliseconds").orDefault("0"), params.get("waitWriteMilliseconds").orDefault("0"), params.getDouble("targetDuration").orDefault(0.0))
															#line 6010 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase655", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase655ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase655", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 667 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = p2p.run();
															#line 667 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			if (static_cast<FlowTestCase655Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6027 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase655Actor*>(this)->actor_wait_state = 1;
															#line 667 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase655Actor, 0, Void >*>(static_cast<FlowTestCase655Actor*>(this)));
															#line 6032 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase655ActorState();
		static_cast<FlowTestCase655Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 668 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!static_cast<FlowTestCase655Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase655ActorState(); static_cast<FlowTestCase655Actor*>(this)->destroy(); return 0; }
															#line 6055 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		new (&static_cast<FlowTestCase655Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase655ActorState();
		static_cast<FlowTestCase655Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 668 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
		if (!static_cast<FlowTestCase655Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase655ActorState(); static_cast<FlowTestCase655Actor*>(this)->destroy(); return 0; }
															#line 6067 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		new (&static_cast<FlowTestCase655Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase655ActorState();
		static_cast<FlowTestCase655Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase655Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase655Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase655Actor*>(this)->ActorCallback< FlowTestCase655Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase655Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase655", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase655Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase655", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase655Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase655", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase655Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase655", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase655Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase655", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase655Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase655", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 655 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	UnitTestParameters params;
															#line 656 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	P2PNetworkTest p2p;
															#line 6154 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase655()
															#line 655 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
class FlowTestCase655Actor final : public Actor<Void>, public ActorCallback< FlowTestCase655Actor, 0, Void >, public FastAllocated<FlowTestCase655Actor>, public FlowTestCase655ActorState<FlowTestCase655Actor> {
															#line 6159 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase655Actor>::operator new;
	using FastAllocated<FlowTestCase655Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13366150984226168064UL, 6362251917959509248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase655Actor, 0, Void >;
															#line 655 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	FlowTestCase655Actor(UnitTestParameters const& params) 
															#line 6176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase655ActorState<FlowTestCase655Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase655", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18338916045365979648UL, 1381693904826875904UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase655Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase655");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase655", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase655Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 655 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
static Future<Void> flowTestCase655( UnitTestParameters const& params ) {
															#line 655 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
	return Future<Void>(new FlowTestCase655Actor(params));
															#line 6209 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/networktest.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase655, ":/network/p2ptest")

#line 670 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/networktest.actor.cpp"
