#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
/*
 * MetricLogger.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cmath>
#include <cstddef>
#include <memory>
#include "msgpack.hpp"
#include <msgpack/v3/unpack_decl.hpp>
#include <string>
#include "fdbrpc/Stats.h"
#include "flow/Msgpack.h"
#include "flow/ApiVersion.h"
#include "flow/IRandom.h"
#include "flow/Knobs.h"
#include "flow/OTELMetrics.h"
#include "flow/SystemMonitor.h"
#include "flow/UnitTest.h"
#include "flow/TDMetric.actor.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbserver/MetricLogger.actor.h"
#include "fdbserver/MetricClient.h"
#include "flow/flow.h"
#include "flow/network.h"
#include "flow/IUDPSocket.h"
#include "flow/IConnection.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct MetricsRule {
	MetricsRule(bool enabled = false, int minLevel = 0, StringRef const& name = StringRef())
	  : namePattern(name), enabled(enabled), minLevel(minLevel) {}

	Standalone<StringRef> typePattern;
	Standalone<StringRef> namePattern;
	Standalone<StringRef> addressPattern;
	Standalone<StringRef> idPattern;

	bool enabled;
	int minLevel;

	Tuple pack() const {
		return Tuple::makeTuple(namePattern, typePattern, addressPattern, idPattern, enabled ? 1 : 0, minLevel);
	}

	static inline MetricsRule unpack(Tuple const& t) {
		MetricsRule r;
		int i = 0;
		if (i < t.size())
			r.namePattern = t.getString(i++);
		if (i < t.size())
			r.typePattern = t.getString(i++);
		if (i < t.size())
			r.addressPattern = t.getString(i++);
		if (i < t.size())
			r.idPattern = t.getString(i++);
		if (i < t.size())
			r.enabled = t.getInt(i++) != 0;
		if (i < t.size())
			r.minLevel = (int)t.getInt(i++);
		return r;
	}

	// For now this just returns true if pat is in subject.  Returns true if pat is empty.
	// TODO:  Support more complex patterns?
	static inline bool patternMatch(StringRef const& pat, StringRef const& subject) {
		if (pat.size() == 0)
			return true;
		for (int i = 0, iend = subject.size() - pat.size() + 1; i < iend; ++i)
			if (subject.substr(i, pat.size()) == pat)
				return true;
		return false;
	}

	bool applyTo(BaseMetric* m, StringRef const& address) const {
		if (!patternMatch(addressPattern, address))
			return false;
		if (!patternMatch(namePattern, m->metricName.name))
			return false;
		if (!patternMatch(typePattern, m->metricName.type))
			return false;
		if (!patternMatch(idPattern, m->metricName.id))
			return false;

		m->setConfig(enabled, minLevel);
		return true;
	}
};

struct MetricsConfig {
	MetricsConfig(Key prefix = KeyRef())
	  : space(prefix), ruleMap(space.get("Rules"_sr).key()), addressMap(space.get("Enum"_sr).get("Address"_sr).key()),
	    nameAndTypeMap(space.get("Enum"_sr).get("NameType"_sr).key()),
	    ruleChangeKey(space.get("RulesChanged"_sr).key()), enumsChangeKey(space.get("EnumsChanged"_sr).key()),
	    fieldChangeKey(space.get("FieldsChanged"_sr).key()) {}

	Subspace space;

	typedef KeyBackedMap<int64_t, MetricsRule> RuleMapT;
	RuleMapT ruleMap;
	RuleMapT::RangeResultType rules;

	KeyBackedMap<Key, int64_t> addressMap;
	KeyBackedMap<std::pair<Key, Key>, int64_t> nameAndTypeMap;

	Key ruleChangeKey;
	Key enumsChangeKey;
	Key fieldChangeKey;
};

/*
  Rule Updater:

  For now:
    Read and store all rules locally.
    For each metric
      Disable the metric
      For each rule in reverse order, apply the rule to the metric and stop if it returns true
    Wait for rule change, repeat.

  If this gets too slow, yields can be added but at the cost of potentially missing a few data points
  because a metric was disabled and not yet re-enabled before it was logged.

  Or, rules and metrics can be stored for more efficient matching and rule updates can be applied
  differentially.
    Read all rules, store latest version
    Clear all configs for each registered metric
    For each rule in order,
       Efficiently select matching metrics and set config
    Loop
      Wait for rule change
      If rule version skipped, go back to start of rule updater
      Read only new rules.
      For each new rule, in order
        Remove any old rules that new rule completely covers
        Efficiently select matching metrics and set config
      Go back to wait for rule change
*/
															#line 158 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
namespace {
// This generated class is to be used only via metricRuleUpdater()
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
template <class MetricRuleUpdaterActor>
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class MetricRuleUpdaterActorState {
															#line 165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	MetricRuleUpdaterActorState(Database const& cx,MetricsConfig* const& config,TDMetricCollection* const& collection) 
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		 : cx(cx),
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		   config(config),
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		   collection(collection),
															#line 158 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		   tr(new ReadYourWritesTransaction(cx))
															#line 178 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
	{
		fdb_probe_actor_create("metricRuleUpdater", reinterpret_cast<unsigned long>(this));

	}
	~MetricRuleUpdaterActorState() 
	{
		fdb_probe_actor_destroy("metricRuleUpdater", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 160 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			;
															#line 193 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MetricRuleUpdaterActorState();
		static_cast<MetricRuleUpdaterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 161 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		newMetric = collection->metricAdded.onTrigger();
															#line 223 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		try {
															#line 163 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 164 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			StrictFuture<MetricsConfig::RuleMapT::RangeResultType> __when_expr_0 = config->ruleMap.getRange(tr, 0, {}, 1e6);
															#line 164 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 231 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state = 1;
															#line 164 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MetricRuleUpdaterActor, 0, MetricsConfig::RuleMapT::RangeResultType >*>(static_cast<MetricRuleUpdaterActor*>(this)));
															#line 236 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 180 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr->onError(e);
															#line 180 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 260 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state = 4;
															#line 180 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MetricRuleUpdaterActor, 3, Void >*>(static_cast<MetricRuleUpdaterActor*>(this)));
															#line 265 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(MetricsConfig::RuleMapT::RangeResultType const& rules,int loopDepth) 
	{
															#line 166 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		for( auto& it : collection->metricMap ) {
															#line 167 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			it.value->setConfig(false);
															#line 168 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			for(auto i = rules.results.rbegin();!(i == rules.results.rend());++i) {
															#line 169 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				if (i->second.applyTo(it.value.getPtr(), collection->address))
															#line 286 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
				{
					break;
				}
			}
		}
															#line 172 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		config->rules = std::move(rules);
															#line 174 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		rulesChanged = tr->watch(config->ruleChangeKey);
															#line 175 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 175 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 300 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state = 2;
															#line 175 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MetricRuleUpdaterActor, 1, Void >*>(static_cast<MetricRuleUpdaterActor*>(this)));
															#line 305 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(MetricsConfig::RuleMapT::RangeResultType && rules,int loopDepth) 
	{
															#line 166 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		for( auto& it : collection->metricMap ) {
															#line 167 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			it.value->setConfig(false);
															#line 168 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			for(auto i = rules.results.rbegin();!(i == rules.results.rend());++i) {
															#line 169 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				if (i->second.applyTo(it.value.getPtr(), collection->address))
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
				{
					break;
				}
			}
		}
															#line 172 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		config->rules = std::move(rules);
															#line 174 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		rulesChanged = tr->watch(config->ruleChangeKey);
															#line 175 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr->commit();
															#line 175 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 334 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state = 2;
															#line 175 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MetricRuleUpdaterActor, 1, Void >*>(static_cast<MetricRuleUpdaterActor*>(this)));
															#line 339 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(MetricsConfig::RuleMapT::RangeResultType const& rules,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(rules, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(MetricsConfig::RuleMapT::RangeResultType && rules,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(rules), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state > 0) static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<MetricRuleUpdaterActor*>(this)->ActorCallback< MetricRuleUpdaterActor, 0, MetricsConfig::RuleMapT::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< MetricRuleUpdaterActor, 0, MetricsConfig::RuleMapT::RangeResultType >*,MetricsConfig::RuleMapT::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetricRuleUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MetricRuleUpdaterActor, 0, MetricsConfig::RuleMapT::RangeResultType >*,MetricsConfig::RuleMapT::RangeResultType && value) 
	{
		fdb_probe_actor_enter("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetricRuleUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MetricRuleUpdaterActor, 0, MetricsConfig::RuleMapT::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetricRuleUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		StrictFuture<Void> __when_expr_2 = rulesChanged || newMetric;
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 425 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state = 3;
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MetricRuleUpdaterActor, 2, Void >*>(static_cast<MetricRuleUpdaterActor*>(this)));
															#line 430 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		StrictFuture<Void> __when_expr_2 = rulesChanged || newMetric;
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 441 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state = 3;
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MetricRuleUpdaterActor, 2, Void >*>(static_cast<MetricRuleUpdaterActor*>(this)));
															#line 446 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state > 0) static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<MetricRuleUpdaterActor*>(this)->ActorCallback< MetricRuleUpdaterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MetricRuleUpdaterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetricRuleUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MetricRuleUpdaterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetricRuleUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MetricRuleUpdaterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetricRuleUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 177 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		tr->reset();
															#line 530 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 177 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		tr->reset();
															#line 539 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = a_body1loopBody1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state > 0) static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<MetricRuleUpdaterActor*>(this)->ActorCallback< MetricRuleUpdaterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MetricRuleUpdaterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetricRuleUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MetricRuleUpdaterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetricRuleUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MetricRuleUpdaterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetricRuleUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state > 0) static_cast<MetricRuleUpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<MetricRuleUpdaterActor*>(this)->ActorCallback< MetricRuleUpdaterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MetricRuleUpdaterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetricRuleUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MetricRuleUpdaterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MetricRuleUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MetricRuleUpdaterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MetricRuleUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("metricRuleUpdater", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Database cx;
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	MetricsConfig* config;
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	TDMetricCollection* collection;
															#line 158 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 161 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Future<Void> newMetric;
															#line 174 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Future<Void> rulesChanged;
															#line 731 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
};
// This generated class is to be used only via metricRuleUpdater()
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class MetricRuleUpdaterActor final : public Actor<Void>, public ActorCallback< MetricRuleUpdaterActor, 0, MetricsConfig::RuleMapT::RangeResultType >, public ActorCallback< MetricRuleUpdaterActor, 1, Void >, public ActorCallback< MetricRuleUpdaterActor, 2, Void >, public ActorCallback< MetricRuleUpdaterActor, 3, Void >, public FastAllocated<MetricRuleUpdaterActor>, public MetricRuleUpdaterActorState<MetricRuleUpdaterActor> {
															#line 736 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
	using FastAllocated<MetricRuleUpdaterActor>::operator new;
	using FastAllocated<MetricRuleUpdaterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2245015399068147456UL, 5402197710574063104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MetricRuleUpdaterActor, 0, MetricsConfig::RuleMapT::RangeResultType >;
friend struct ActorCallback< MetricRuleUpdaterActor, 1, Void >;
friend struct ActorCallback< MetricRuleUpdaterActor, 2, Void >;
friend struct ActorCallback< MetricRuleUpdaterActor, 3, Void >;
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	MetricRuleUpdaterActor(Database const& cx,MetricsConfig* const& config,TDMetricCollection* const& collection) 
															#line 756 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		 : Actor<Void>(),
		   MetricRuleUpdaterActorState<MetricRuleUpdaterActor>(cx, config, collection),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("metricRuleUpdater", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7094767803385151744UL, 5274282263642214144UL);
		ActorExecutionContextHelper __helper(static_cast<MetricRuleUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("metricRuleUpdater");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("metricRuleUpdater", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MetricRuleUpdaterActor, 0, MetricsConfig::RuleMapT::RangeResultType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MetricRuleUpdaterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MetricRuleUpdaterActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MetricRuleUpdaterActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
[[nodiscard]] Future<Void> metricRuleUpdater( Database const& cx, MetricsConfig* const& config, TDMetricCollection* const& collection ) {
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	return Future<Void>(new MetricRuleUpdaterActor(cx, config, collection));
															#line 792 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
}

#line 184 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"

// Implementation of IMetricDB
class MetricDB : public IMetricDB {
public:
	MetricDB(ReadYourWritesTransaction* tr = nullptr) : tr(tr) {}
	~MetricDB() override {}

	// levelKey is the prefix for the entire level, no timestamp at the end
																#line 804 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
// This generated class is to be used only via getLastBlock_impl()
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
template <class GetLastBlock_implActor>
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class GetLastBlock_implActorState {
															#line 810 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	GetLastBlock_implActorState(ReadYourWritesTransaction* const& tr,Standalone<StringRef> const& levelKey) 
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		 : tr(tr),
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		   levelKey(levelKey)
															#line 819 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
	{
		fdb_probe_actor_create("getLastBlock_impl", reinterpret_cast<unsigned long>(this));

	}
	~GetLastBlock_implActorState() 
	{
		fdb_probe_actor_destroy("getLastBlock_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 194 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(normalKeys.withPrefix(levelKey), 1, Snapshot::True, Reverse::True);
															#line 194 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (static_cast<GetLastBlock_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 836 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLastBlock_implActor*>(this)->actor_wait_state = 1;
															#line 194 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLastBlock_implActor, 0, RangeResult >*>(static_cast<GetLastBlock_implActor*>(this)));
															#line 841 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLastBlock_implActorState();
		static_cast<GetLastBlock_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult const& results,int loopDepth) 
	{
															#line 195 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (results.size() == 1)
															#line 864 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
															#line 196 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (!static_cast<GetLastBlock_implActor*>(this)->SAV<Optional<Standalone<StringRef>>>::futures) { (void)(results[0].value); this->~GetLastBlock_implActorState(); static_cast<GetLastBlock_implActor*>(this)->destroy(); return 0; }
															#line 868 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			new (&static_cast<GetLastBlock_implActor*>(this)->SAV< Optional<Standalone<StringRef>> >::value()) Optional<Standalone<StringRef>>(results[0].value);
			this->~GetLastBlock_implActorState();
			static_cast<GetLastBlock_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 197 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (!static_cast<GetLastBlock_implActor*>(this)->SAV<Optional<Standalone<StringRef>>>::futures) { (void)(Optional<Standalone<StringRef>>()); this->~GetLastBlock_implActorState(); static_cast<GetLastBlock_implActor*>(this)->destroy(); return 0; }
															#line 876 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		new (&static_cast<GetLastBlock_implActor*>(this)->SAV< Optional<Standalone<StringRef>> >::value()) Optional<Standalone<StringRef>>(Optional<Standalone<StringRef>>());
		this->~GetLastBlock_implActorState();
		static_cast<GetLastBlock_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(RangeResult && results,int loopDepth) 
	{
															#line 195 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (results.size() == 1)
															#line 888 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
															#line 196 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (!static_cast<GetLastBlock_implActor*>(this)->SAV<Optional<Standalone<StringRef>>>::futures) { (void)(results[0].value); this->~GetLastBlock_implActorState(); static_cast<GetLastBlock_implActor*>(this)->destroy(); return 0; }
															#line 892 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			new (&static_cast<GetLastBlock_implActor*>(this)->SAV< Optional<Standalone<StringRef>> >::value()) Optional<Standalone<StringRef>>(results[0].value);
			this->~GetLastBlock_implActorState();
			static_cast<GetLastBlock_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 197 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (!static_cast<GetLastBlock_implActor*>(this)->SAV<Optional<Standalone<StringRef>>>::futures) { (void)(Optional<Standalone<StringRef>>()); this->~GetLastBlock_implActorState(); static_cast<GetLastBlock_implActor*>(this)->destroy(); return 0; }
															#line 900 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		new (&static_cast<GetLastBlock_implActor*>(this)->SAV< Optional<Standalone<StringRef>> >::value()) Optional<Standalone<StringRef>>(Optional<Standalone<StringRef>>());
		this->~GetLastBlock_implActorState();
		static_cast<GetLastBlock_implActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(RangeResult const& results,int loopDepth) 
	{
		loopDepth = a_body1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && results,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLastBlock_implActor*>(this)->actor_wait_state > 0) static_cast<GetLastBlock_implActor*>(this)->actor_wait_state = 0;
		static_cast<GetLastBlock_implActor*>(this)->ActorCallback< GetLastBlock_implActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetLastBlock_implActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getLastBlock_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastBlock_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastBlock_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLastBlock_implActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getLastBlock_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastBlock_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastBlock_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLastBlock_implActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getLastBlock_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastBlock_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLastBlock_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	ReadYourWritesTransaction* tr;
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Standalone<StringRef> levelKey;
															#line 987 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
};
// This generated class is to be used only via getLastBlock_impl()
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class GetLastBlock_implActor final : public Actor<Optional<Standalone<StringRef>>>, public ActorCallback< GetLastBlock_implActor, 0, RangeResult >, public FastAllocated<GetLastBlock_implActor>, public GetLastBlock_implActorState<GetLastBlock_implActor> {
															#line 992 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
	using FastAllocated<GetLastBlock_implActor>::operator new;
	using FastAllocated<GetLastBlock_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6331218812157076736UL, 9067806111335808000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<Standalone<StringRef>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLastBlock_implActor, 0, RangeResult >;
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	GetLastBlock_implActor(ReadYourWritesTransaction* const& tr,Standalone<StringRef> const& levelKey) 
															#line 1009 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		 : Actor<Optional<Standalone<StringRef>>>(),
		   GetLastBlock_implActorState<GetLastBlock_implActor>(tr, levelKey),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLastBlock_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2307886854969989376UL, 4437904606957425408UL);
		ActorExecutionContextHelper __helper(static_cast<GetLastBlock_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLastBlock_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLastBlock_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLastBlock_implActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
[[nodiscard]] static Future<Optional<Standalone<StringRef>>> getLastBlock_impl( ReadYourWritesTransaction* const& tr, Standalone<StringRef> const& levelKey ) {
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	return Future<Optional<Standalone<StringRef>>>(new GetLastBlock_implActor(tr, levelKey));
															#line 1041 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
}

#line 199 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"

	Future<Optional<Standalone<StringRef>>> getLastBlock(Standalone<StringRef> key) override {
		return getLastBlock_impl(tr, key);
	}

	ReadYourWritesTransaction* tr;
};

															#line 1053 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
namespace {
// This generated class is to be used only via dumpMetrics()
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
template <class DumpMetricsActor>
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class DumpMetricsActorState {
															#line 1060 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	DumpMetricsActorState(Database const& cx,MetricsConfig* const& config,TDMetricCollection* const& collection) 
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		 : cx(cx),
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		   config(config),
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		   collection(collection),
															#line 208 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		   batch(),
															#line 209 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		   mk()
															#line 1075 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
	{
		fdb_probe_actor_create("dumpMetrics", reinterpret_cast<unsigned long>(this));

	}
	~DumpMetricsActorState() 
	{
		fdb_probe_actor_destroy("dumpMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 210 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			ASSERT(collection != nullptr);
															#line 211 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			mk.prefix = StringRef(mk.arena(), config->space.key());
															#line 212 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			mk.address = StringRef(mk.arena(), collection->address);
															#line 214 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			;
															#line 1096 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpMetricsActorState();
		static_cast<DumpMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 215 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		batch.clear();
															#line 216 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		uint64_t rollTime = std::numeric_limits<uint64_t>::max();
															#line 217 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (collection->rollTimes.size())
															#line 1130 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
															#line 218 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			rollTime = collection->rollTimes.front();
															#line 219 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			collection->rollTimes.pop_front();
															#line 1136 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		}
															#line 223 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		enabled = false;
															#line 226 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		for( auto& it : collection->metricMap ) {
															#line 228 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (it.value->pCollection != nullptr)
															#line 1144 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			{
															#line 229 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				mk.name = it.value->metricName;
															#line 230 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				it.value->flushData(mk, rollTime, batch);
															#line 1150 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
															#line 232 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			enabled = enabled || it.value->enabled;
															#line 1154 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		}
															#line 235 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (rollTime == std::numeric_limits<uint64_t>::max())
															#line 1158 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
															#line 236 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			collection->currentTimeBytes = 0;
															#line 1162 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		}
															#line 239 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		cbtr = ReadYourWritesTransaction(cx);
															#line 240 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		mdb = MetricDB(&cbtr);
															#line 242 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		results = std::map<int, Future<Void>>();
															#line 244 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		for(int i = 0, iend = batch.scope.callbacks.size();i < iend;++i) {
															#line 245 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			results[i] = batch.scope.callbacks[i](&mdb, &batch.scope);
															#line 1174 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		}
															#line 247 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		;
															#line 1178 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 273 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		nextDump = Future<Void>();
															#line 274 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (collection->rollTimes.size() > 0)
															#line 1189 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
															#line 275 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			nextDump = Void();
															#line 1193 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		}
		else
		{
															#line 277 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			nextDump = collection->metricEnabled.onTrigger();
															#line 278 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (enabled)
															#line 1201 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			{
															#line 279 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				nextDump = nextDump || delay(1.0);
															#line 1205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
		}
															#line 282 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		tr = Transaction(cx);
															#line 283 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		;
															#line 1212 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 248 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		cb = results.begin();
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		lastError = Error();
															#line 251 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		;
															#line 1232 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 262 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (results.empty())
															#line 1254 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 266 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cbtr.onError(lastError);
															#line 266 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (static_cast<DumpMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1262 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DumpMetricsActor*>(this)->actor_wait_state = 2;
															#line 266 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DumpMetricsActor, 1, Void >*>(static_cast<DumpMetricsActor*>(this)));
															#line 1267 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1(int loopDepth) 
	{
															#line 251 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (!(cb != results.end()))
															#line 1283 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
			return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 253 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			StrictFuture<Void> __when_expr_0 = cb->second;
															#line 253 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (static_cast<DumpMetricsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1292 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DumpMetricsActor*>(this)->actor_wait_state = 1;
															#line 253 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DumpMetricsActor, 0, Void >*>(static_cast<DumpMetricsActor*>(this)));
															#line 1297 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 256 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			++cb;
															#line 257 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			lastError = e;
															#line 1334 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = a_body1loopBody1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 254 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		cb = results.erase(cb);
															#line 1349 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 254 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		cb = results.erase(cb);
															#line 1358 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpMetricsActor*>(this)->actor_wait_state > 0) static_cast<DumpMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<DumpMetricsActor*>(this)->ActorCallback< DumpMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DumpMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DumpMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1loopBody1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 3));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 3));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 267 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		for( auto& cb : results ) {
															#line 268 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			cb.second = batch.scope.callbacks[cb.first](&mdb, &batch.scope);
															#line 1457 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 267 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		for( auto& cb : results ) {
															#line 268 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			cb.second = batch.scope.callbacks[cb.first](&mdb, &batch.scope);
															#line 1469 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DumpMetricsActor*>(this)->actor_wait_state > 0) static_cast<DumpMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<DumpMetricsActor*>(this)->ActorCallback< DumpMetricsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpMetricsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DumpMetricsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DumpMetricsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
															#line 310 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		StrictFuture<Void> __when_expr_4 = nextDump;
															#line 310 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (static_cast<DumpMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1556 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<DumpMetricsActor*>(this)->actor_wait_state = 5;
															#line 310 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DumpMetricsActor, 4, Void >*>(static_cast<DumpMetricsActor*>(this)));
															#line 1561 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 284 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1577 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		try {
															#line 286 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			for( auto& i : batch.scope.inserts ) {
															#line 289 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				tr.set(i.key, i.value());
															#line 1583 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
															#line 292 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			for( auto& a : batch.scope.appends ) {
															#line 295 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				tr.atomicOp(a.key, a.value(), MutationRef::AppendIfFits);
															#line 1589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
															#line 298 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			for( auto& u : batch.scope.updates ) {
															#line 301 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				tr.set(u.first, u.second);
															#line 1595 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
															#line 304 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 304 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (static_cast<DumpMetricsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1601 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DumpMetricsActor*>(this)->actor_wait_state = 3;
															#line 304 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DumpMetricsActor, 2, Void >*>(static_cast<DumpMetricsActor*>(this)));
															#line 1606 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 307 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 307 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (static_cast<DumpMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1643 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<DumpMetricsActor*>(this)->actor_wait_state = 4;
															#line 307 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DumpMetricsActor, 3, Void >*>(static_cast<DumpMetricsActor*>(this)));
															#line 1648 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DumpMetricsActor*>(this)->actor_wait_state > 0) static_cast<DumpMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<DumpMetricsActor*>(this)->ActorCallback< DumpMetricsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpMetricsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DumpMetricsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DumpMetricsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DumpMetricsActor*>(this)->actor_wait_state > 0) static_cast<DumpMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<DumpMetricsActor*>(this)->ActorCallback< DumpMetricsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpMetricsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DumpMetricsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DumpMetricsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DumpMetricsActor*>(this)->actor_wait_state > 0) static_cast<DumpMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<DumpMetricsActor*>(this)->ActorCallback< DumpMetricsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpMetricsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DumpMetricsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DumpMetricsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Database cx;
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	MetricsConfig* config;
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	TDMetricCollection* collection;
															#line 208 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	MetricBatch batch;
															#line 209 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Standalone<MetricKeyRef> mk;
															#line 223 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	bool enabled;
															#line 239 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	ReadYourWritesTransaction cbtr;
															#line 240 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	MetricDB mdb;
															#line 242 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	std::map<int, Future<Void>> results;
															#line 248 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	std::map<int, Future<Void>>::iterator cb;
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Error lastError;
															#line 273 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Future<Void> nextDump;
															#line 282 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Transaction tr;
															#line 1946 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
};
// This generated class is to be used only via dumpMetrics()
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class DumpMetricsActor final : public Actor<Void>, public ActorCallback< DumpMetricsActor, 0, Void >, public ActorCallback< DumpMetricsActor, 1, Void >, public ActorCallback< DumpMetricsActor, 2, Void >, public ActorCallback< DumpMetricsActor, 3, Void >, public ActorCallback< DumpMetricsActor, 4, Void >, public FastAllocated<DumpMetricsActor>, public DumpMetricsActorState<DumpMetricsActor> {
															#line 1951 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
	using FastAllocated<DumpMetricsActor>::operator new;
	using FastAllocated<DumpMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(846907912185357312UL, 2375076847009780224UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DumpMetricsActor, 0, Void >;
friend struct ActorCallback< DumpMetricsActor, 1, Void >;
friend struct ActorCallback< DumpMetricsActor, 2, Void >;
friend struct ActorCallback< DumpMetricsActor, 3, Void >;
friend struct ActorCallback< DumpMetricsActor, 4, Void >;
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	DumpMetricsActor(Database const& cx,MetricsConfig* const& config,TDMetricCollection* const& collection) 
															#line 1972 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		 : Actor<Void>(),
		   DumpMetricsActorState<DumpMetricsActor>(cx, config, collection),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17689923518287362560UL, 4817746073828371456UL);
		ActorExecutionContextHelper __helper(static_cast<DumpMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DumpMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DumpMetricsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DumpMetricsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DumpMetricsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DumpMetricsActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
[[nodiscard]] Future<Void> dumpMetrics( Database const& cx, MetricsConfig* const& config, TDMetricCollection* const& collection ) {
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	return Future<Void>(new DumpMetricsActor(cx, config, collection));
															#line 2009 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
}

#line 313 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"

// Push metric field registrations to database.
															#line 2015 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
namespace {
// This generated class is to be used only via updateMetricRegistration()
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
template <class UpdateMetricRegistrationActor>
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class UpdateMetricRegistrationActorState {
															#line 2022 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	UpdateMetricRegistrationActorState(Database const& cx,MetricsConfig* const& config,TDMetricCollection* const& collection) 
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		 : cx(cx),
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		   config(config),
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		   collection(collection),
															#line 316 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		   mk()
															#line 2035 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
	{
		fdb_probe_actor_create("updateMetricRegistration", reinterpret_cast<unsigned long>(this));

	}
	~UpdateMetricRegistrationActorState() 
	{
		fdb_probe_actor_destroy("updateMetricRegistration", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 317 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			mk.prefix = StringRef(mk.arena(), config->space.key());
															#line 318 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			mk.address = StringRef(mk.arena(), collection->address);
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			addressRegistered = false;
															#line 322 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			;
															#line 2056 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateMetricRegistrationActorState();
		static_cast<UpdateMetricRegistrationActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 323 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		registrationChange = collection->metricRegistrationChanged.onTrigger();
															#line 324 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		newMetric = collection->metricAdded.onTrigger();
															#line 325 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		keys = std::vector<Standalone<StringRef>>();
															#line 326 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		fieldsChanged = false;
															#line 327 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		enumsChanged = false;
															#line 330 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		for( auto& it : collection->metricMap ) {
															#line 331 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (!it.value->registered)
															#line 2098 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			{
															#line 333 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				mk.name = it.value->metricName;
															#line 334 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				it.value->registerFields(mk, keys);
															#line 337 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				keys.push_back( config->nameAndTypeMap.getProperty({ it.value->metricName.name, it.value->metricName.type }).key);
															#line 340 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				it.value->registered = true;
															#line 341 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				fieldsChanged = true;
															#line 342 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				enumsChanged = true;
															#line 2112 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
		}
															#line 347 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (!addressRegistered)
															#line 2117 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
															#line 348 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			keys.push_back(config->addressMap.getProperty(collection->address).key);
															#line 349 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			addressRegistered = true;
															#line 350 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			enumsChanged = true;
															#line 2125 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		}
															#line 353 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (enumsChanged)
															#line 2129 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
															#line 354 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			keys.push_back(config->enumsChangeKey);
															#line 2133 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		}
															#line 355 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (fieldsChanged)
															#line 2137 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
															#line 356 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			keys.push_back(config->fieldChangeKey);
															#line 2141 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		}
															#line 359 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		tr = Transaction(cx);
															#line 360 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		;
															#line 2147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 379 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		StrictFuture<Void> __when_expr_2 = registrationChange || newMetric;
															#line 379 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (static_cast<UpdateMetricRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2158 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<UpdateMetricRegistrationActor*>(this)->actor_wait_state = 3;
															#line 379 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UpdateMetricRegistrationActor, 2, Void >*>(static_cast<UpdateMetricRegistrationActor*>(this)));
															#line 2163 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 361 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 2179 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		try {
															#line 363 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			Value timestamp = BinaryWriter::toValue(CompressedInt<int64_t>(now()), AssumeVersion(g_network->protocolVersion()));
															#line 365 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			for( auto& key : keys ) {
															#line 368 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				tr.set(key, timestamp);
															#line 2187 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
															#line 371 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 371 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (static_cast<UpdateMetricRegistrationActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2193 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateMetricRegistrationActor*>(this)->actor_wait_state = 1;
															#line 371 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateMetricRegistrationActor, 0, Void >*>(static_cast<UpdateMetricRegistrationActor*>(this)));
															#line 2198 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 374 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 374 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (static_cast<UpdateMetricRegistrationActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 2235 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<UpdateMetricRegistrationActor*>(this)->actor_wait_state = 2;
															#line 374 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateMetricRegistrationActor, 1, Void >*>(static_cast<UpdateMetricRegistrationActor*>(this)));
															#line 2240 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateMetricRegistrationActor*>(this)->actor_wait_state > 0) static_cast<UpdateMetricRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateMetricRegistrationActor*>(this)->ActorCallback< UpdateMetricRegistrationActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateMetricRegistrationActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMetricRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateMetricRegistrationActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMetricRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateMetricRegistrationActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMetricRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateMetricRegistrationActor*>(this)->actor_wait_state > 0) static_cast<UpdateMetricRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateMetricRegistrationActor*>(this)->ActorCallback< UpdateMetricRegistrationActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateMetricRegistrationActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMetricRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateMetricRegistrationActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMetricRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateMetricRegistrationActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMetricRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UpdateMetricRegistrationActor*>(this)->actor_wait_state > 0) static_cast<UpdateMetricRegistrationActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateMetricRegistrationActor*>(this)->ActorCallback< UpdateMetricRegistrationActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateMetricRegistrationActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMetricRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UpdateMetricRegistrationActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMetricRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UpdateMetricRegistrationActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMetricRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMetricRegistration", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Database cx;
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	MetricsConfig* config;
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	TDMetricCollection* collection;
															#line 316 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Standalone<MetricKeyRef> mk;
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	bool addressRegistered;
															#line 323 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Future<Void> registrationChange;
															#line 324 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Future<Void> newMetric;
															#line 325 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	std::vector<Standalone<StringRef>> keys;
															#line 326 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	bool fieldsChanged;
															#line 327 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	bool enumsChanged;
															#line 359 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Transaction tr;
															#line 2534 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
};
// This generated class is to be used only via updateMetricRegistration()
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class UpdateMetricRegistrationActor final : public Actor<Void>, public ActorCallback< UpdateMetricRegistrationActor, 0, Void >, public ActorCallback< UpdateMetricRegistrationActor, 1, Void >, public ActorCallback< UpdateMetricRegistrationActor, 2, Void >, public FastAllocated<UpdateMetricRegistrationActor>, public UpdateMetricRegistrationActorState<UpdateMetricRegistrationActor> {
															#line 2539 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
	using FastAllocated<UpdateMetricRegistrationActor>::operator new;
	using FastAllocated<UpdateMetricRegistrationActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8442283400961072640UL, 8839758185140063744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateMetricRegistrationActor, 0, Void >;
friend struct ActorCallback< UpdateMetricRegistrationActor, 1, Void >;
friend struct ActorCallback< UpdateMetricRegistrationActor, 2, Void >;
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	UpdateMetricRegistrationActor(Database const& cx,MetricsConfig* const& config,TDMetricCollection* const& collection) 
															#line 2558 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateMetricRegistrationActorState<UpdateMetricRegistrationActor>(cx, config, collection),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateMetricRegistration", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1195313076773392640UL, 16336970770180875264UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMetricRegistrationActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateMetricRegistration");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateMetricRegistration", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateMetricRegistrationActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateMetricRegistrationActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UpdateMetricRegistrationActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
[[nodiscard]] Future<Void> updateMetricRegistration( Database const& cx, MetricsConfig* const& config, TDMetricCollection* const& collection ) {
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	return Future<Void>(new UpdateMetricRegistrationActor(cx, config, collection));
															#line 2593 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
}

#line 382 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"

															#line 2598 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
namespace {
// This generated class is to be used only via runMetrics()
															#line 383 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
template <class RunMetricsActor>
															#line 383 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class RunMetricsActorState {
															#line 2605 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
															#line 383 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	RunMetricsActorState(Future<Database> const& fcx,Key const& prefix) 
															#line 383 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
															#line 383 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		 : fcx(fcx),
															#line 383 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		   prefix(prefix)
															#line 2614 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
	{
		fdb_probe_actor_create("runMetrics", reinterpret_cast<unsigned long>(this));

	}
	~RunMetricsActorState() 
	{
		fdb_probe_actor_destroy("runMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 385 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (prefix.size() == 0)
															#line 2629 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			{
															#line 386 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				TraceEvent(SevWarnAlways, "TDMetricsRefusingEmptyPrefix").log();
															#line 387 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				if (!static_cast<RunMetricsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunMetricsActorState(); static_cast<RunMetricsActor*>(this)->destroy(); return 0; }
															#line 2635 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
				new (&static_cast<RunMetricsActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RunMetricsActorState();
				static_cast<RunMetricsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 391 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			metrics = nullptr;
															#line 392 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			;
															#line 2645 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunMetricsActorState();
		static_cast<RunMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 400 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		config = MetricsConfig(prefix);
															#line 2668 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		try {
															#line 403 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			StrictFuture<Database> __when_expr_1 = fcx;
															#line 403 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (static_cast<RunMetricsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2674 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RunMetricsActor*>(this)->actor_wait_state = 2;
															#line 403 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RunMetricsActor, 1, Database >*>(static_cast<RunMetricsActor*>(this)));
															#line 2679 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 393 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		metrics = TDMetricCollection::getTDMetrics();
															#line 394 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (metrics != nullptr)
															#line 2703 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
															#line 395 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (metrics->init())
															#line 2707 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			{
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
		}
															#line 397 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 397 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (static_cast<RunMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2716 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RunMetricsActor*>(this)->actor_wait_state = 1;
															#line 397 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunMetricsActor, 0, Void >*>(static_cast<RunMetricsActor*>(this)));
															#line 2721 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunMetricsActor*>(this)->actor_wait_state > 0) static_cast<RunMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<RunMetricsActor*>(this)->ActorCallback< RunMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 419 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (!static_cast<RunMetricsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunMetricsActorState(); static_cast<RunMetricsActor*>(this)->destroy(); return 0; }
															#line 2830 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		new (&static_cast<RunMetricsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunMetricsActorState();
		static_cast<RunMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 410 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 2843 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			{
															#line 412 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				for( auto& it : metrics->metricMap ) {
															#line 413 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
					it.value->setConfig(false);
															#line 2849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
				}
			}
															#line 416 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			TraceEvent(SevWarnAlways, "TDMetricsStopped").error(e);
															#line 417 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2856 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Database const& cx,int loopDepth) 
	{
															#line 404 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		Future<Void> conf = metricRuleUpdater(cx, &config, metrics);
															#line 405 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		Future<Void> dump = dumpMetrics(cx, &config, metrics);
															#line 406 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		Future<Void> reg = updateMetricRegistration(cx, &config, metrics);
															#line 408 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		StrictFuture<Void> __when_expr_2 = conf || dump || reg;
															#line 408 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (static_cast<RunMetricsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2878 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunMetricsActor*>(this)->actor_wait_state = 3;
															#line 408 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunMetricsActor, 2, Void >*>(static_cast<RunMetricsActor*>(this)));
															#line 2883 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Database && cx,int loopDepth) 
	{
															#line 404 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		Future<Void> conf = metricRuleUpdater(cx, &config, metrics);
															#line 405 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		Future<Void> dump = dumpMetrics(cx, &config, metrics);
															#line 406 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		Future<Void> reg = updateMetricRegistration(cx, &config, metrics);
															#line 408 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		StrictFuture<Void> __when_expr_2 = conf || dump || reg;
															#line 408 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (static_cast<RunMetricsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 2900 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<RunMetricsActor*>(this)->actor_wait_state = 3;
															#line 408 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunMetricsActor, 2, Void >*>(static_cast<RunMetricsActor*>(this)));
															#line 2905 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Database const& cx,int loopDepth) 
	{
		loopDepth = a_body1cont4(cx, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Database && cx,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(cx), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunMetricsActor*>(this)->actor_wait_state > 0) static_cast<RunMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<RunMetricsActor*>(this)->ActorCallback< RunMetricsActor, 1, Database >::remove();

	}
	void a_callback_fire(ActorCallback< RunMetricsActor, 1, Database >*,Database const& value) 
	{
		fdb_probe_actor_enter("runMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunMetricsActor, 1, Database >*,Database && value) 
	{
		fdb_probe_actor_enter("runMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RunMetricsActor, 1, Database >*,Error err) 
	{
		fdb_probe_actor_enter("runMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RunMetricsActor*>(this)->actor_wait_state > 0) static_cast<RunMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<RunMetricsActor*>(this)->ActorCallback< RunMetricsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunMetricsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunMetricsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunMetricsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runMetrics", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runMetrics", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 383 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Future<Database> fcx;
															#line 383 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Key prefix;
															#line 391 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	TDMetricCollection* metrics;
															#line 400 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	MetricsConfig config;
															#line 3093 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
};
// This generated class is to be used only via runMetrics()
															#line 383 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class RunMetricsActor final : public Actor<Void>, public ActorCallback< RunMetricsActor, 0, Void >, public ActorCallback< RunMetricsActor, 1, Database >, public ActorCallback< RunMetricsActor, 2, Void >, public FastAllocated<RunMetricsActor>, public RunMetricsActorState<RunMetricsActor> {
															#line 3098 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
	using FastAllocated<RunMetricsActor>::operator new;
	using FastAllocated<RunMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14602308735322072832UL, 12026424326283002368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunMetricsActor, 0, Void >;
friend struct ActorCallback< RunMetricsActor, 1, Database >;
friend struct ActorCallback< RunMetricsActor, 2, Void >;
															#line 383 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	RunMetricsActor(Future<Database> const& fcx,Key const& prefix) 
															#line 3117 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		 : Actor<Void>(),
		   RunMetricsActorState<RunMetricsActor>(fcx, prefix),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13329783537572423424UL, 12803361985707191552UL);
		ActorExecutionContextHelper __helper(static_cast<RunMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RunMetricsActor, 1, Database >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RunMetricsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 383 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
[[nodiscard]] Future<Void> runMetrics( Future<Database> const& fcx, Key const& prefix ) {
															#line 383 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	return Future<Void>(new RunMetricsActor(fcx, prefix));
															#line 3152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
}

#line 421 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"

															#line 3157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
namespace {
// This generated class is to be used only via startMetricsSimulationServer()
															#line 422 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
template <class StartMetricsSimulationServerActor>
															#line 422 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class StartMetricsSimulationServerActorState {
															#line 3164 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
															#line 422 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	StartMetricsSimulationServerActorState(MetricsDataModel const& model) 
															#line 422 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
															#line 422 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		 : model(model)
															#line 3171 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
	{
		fdb_probe_actor_create("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this));

	}
	~StartMetricsSimulationServerActorState() 
	{
		fdb_probe_actor_destroy("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 423 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (model == MetricsDataModel::NONE)
															#line 3186 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			{
															#line 424 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				if (!static_cast<StartMetricsSimulationServerActor*>(this)->SAV<Void>::futures) { (void)(Void{}); this->~StartMetricsSimulationServerActorState(); static_cast<StartMetricsSimulationServerActor*>(this)->destroy(); return 0; }
															#line 3190 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
				new (&static_cast<StartMetricsSimulationServerActor*>(this)->SAV< Void >::value()) Void(Void{});
				this->~StartMetricsSimulationServerActorState();
				static_cast<StartMetricsSimulationServerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 426 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			port = 0;
															#line 427 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			switch (model) { case MetricsDataModel::STATSD: port = FLOW_KNOBS->STATSD_UDP_EMISSION_PORT; case MetricsDataModel::OTLP: port = FLOW_KNOBS->OTEL_UDP_EMISSION_PORT; case MetricsDataModel::NONE: port = 0; };
															#line 435 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			TraceEvent(SevInfo, "MetricsUDPServerStarted").detail("Address", "127.0.0.1").detail("Port", port);
															#line 436 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			localAddress = NetworkAddress::parse("127.0.0.1:" + std::to_string(port));
															#line 437 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			StrictFuture<Reference<IUDPSocket>> __when_expr_0 = INetworkConnections::net()->createUDPSocket(localAddress);
															#line 437 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (static_cast<StartMetricsSimulationServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3208 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartMetricsSimulationServerActor*>(this)->actor_wait_state = 1;
															#line 437 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartMetricsSimulationServerActor, 0, Reference<IUDPSocket> >*>(static_cast<StartMetricsSimulationServerActor*>(this)));
															#line 3213 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartMetricsSimulationServerActorState();
		static_cast<StartMetricsSimulationServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 438 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		serverSocket->bind(localAddress);
															#line 439 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		packetString = makeString(IUDPSocket::MAX_PACKET_SIZE);
															#line 440 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		packet = mutateString(packetString);
															#line 442 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		;
															#line 3242 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IUDPSocket> const& __serverSocket,int loopDepth) 
	{
															#line 437 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		serverSocket = __serverSocket;
															#line 3251 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IUDPSocket> && __serverSocket,int loopDepth) 
	{
		serverSocket = std::move(__serverSocket);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartMetricsSimulationServerActor*>(this)->actor_wait_state > 0) static_cast<StartMetricsSimulationServerActor*>(this)->actor_wait_state = 0;
		static_cast<StartMetricsSimulationServerActor*>(this)->ActorCallback< StartMetricsSimulationServerActor, 0, Reference<IUDPSocket> >::remove();

	}
	void a_callback_fire(ActorCallback< StartMetricsSimulationServerActor, 0, Reference<IUDPSocket> >*,Reference<IUDPSocket> const& value) 
	{
		fdb_probe_actor_enter("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMetricsSimulationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartMetricsSimulationServerActor, 0, Reference<IUDPSocket> >*,Reference<IUDPSocket> && value) 
	{
		fdb_probe_actor_enter("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMetricsSimulationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartMetricsSimulationServerActor, 0, Reference<IUDPSocket> >*,Error err) 
	{
		fdb_probe_actor_enter("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMetricsSimulationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 443 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		StrictFuture<int> __when_expr_1 = serverSocket->receive(packet, packet + IUDPSocket::MAX_PACKET_SIZE);
															#line 443 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (static_cast<StartMetricsSimulationServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3339 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartMetricsSimulationServerActor*>(this)->actor_wait_state = 2;
															#line 443 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartMetricsSimulationServerActor, 1, int >*>(static_cast<StartMetricsSimulationServerActor*>(this)));
															#line 3344 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int const& size,int loopDepth) 
	{
															#line 444 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		auto message = packetString.substr(0, size);
															#line 448 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (model == MetricsDataModel::STATSD)
															#line 3355 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
															#line 449 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			std::string statsd_message = message.toString();
															#line 450 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			auto metrics = splitString(statsd_message, "\n");
															#line 451 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			for( const auto& metric : metrics ) {
															#line 452 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				ASSERT(verifyStatsdMessage(metric));
															#line 3365 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
		}
		else
		{
															#line 454 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (model == MetricsDataModel::OTLP)
															#line 3372 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			{
															#line 455 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				msgpack::object_handle result;
															#line 456 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				msgpack::unpack(result, reinterpret_cast<const char*>(packet), size);
															#line 3378 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int && size,int loopDepth) 
	{
															#line 444 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		auto message = packetString.substr(0, size);
															#line 448 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (model == MetricsDataModel::STATSD)
															#line 3391 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
															#line 449 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			std::string statsd_message = message.toString();
															#line 450 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			auto metrics = splitString(statsd_message, "\n");
															#line 451 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			for( const auto& metric : metrics ) {
															#line 452 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				ASSERT(verifyStatsdMessage(metric));
															#line 3401 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
		}
		else
		{
															#line 454 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (model == MetricsDataModel::OTLP)
															#line 3408 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			{
															#line 455 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				msgpack::object_handle result;
															#line 456 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				msgpack::unpack(result, reinterpret_cast<const char*>(packet), size);
															#line 3414 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(int const& size,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(size, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(int && size,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(size), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartMetricsSimulationServerActor*>(this)->actor_wait_state > 0) static_cast<StartMetricsSimulationServerActor*>(this)->actor_wait_state = 0;
		static_cast<StartMetricsSimulationServerActor*>(this)->ActorCallback< StartMetricsSimulationServerActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< StartMetricsSimulationServerActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMetricsSimulationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartMetricsSimulationServerActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartMetricsSimulationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartMetricsSimulationServerActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartMetricsSimulationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 422 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	MetricsDataModel model;
															#line 426 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	uint32_t port;
															#line 436 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	NetworkAddress localAddress;
															#line 437 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Reference<IUDPSocket> serverSocket;
															#line 439 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Standalone<StringRef> packetString;
															#line 440 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	uint8_t* packet;
															#line 3508 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
};
// This generated class is to be used only via startMetricsSimulationServer()
															#line 422 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class StartMetricsSimulationServerActor final : public Actor<Void>, public ActorCallback< StartMetricsSimulationServerActor, 0, Reference<IUDPSocket> >, public ActorCallback< StartMetricsSimulationServerActor, 1, int >, public FastAllocated<StartMetricsSimulationServerActor>, public StartMetricsSimulationServerActorState<StartMetricsSimulationServerActor> {
															#line 3513 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
	using FastAllocated<StartMetricsSimulationServerActor>::operator new;
	using FastAllocated<StartMetricsSimulationServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17586318266738740992UL, 3443163526421726464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartMetricsSimulationServerActor, 0, Reference<IUDPSocket> >;
friend struct ActorCallback< StartMetricsSimulationServerActor, 1, int >;
															#line 422 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	StartMetricsSimulationServerActor(MetricsDataModel const& model) 
															#line 3531 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		 : Actor<Void>(),
		   StartMetricsSimulationServerActorState<StartMetricsSimulationServerActor>(model),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12269822179358974720UL, 952844753776750080UL);
		ActorExecutionContextHelper __helper(static_cast<StartMetricsSimulationServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startMetricsSimulationServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startMetricsSimulationServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartMetricsSimulationServerActor, 0, Reference<IUDPSocket> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartMetricsSimulationServerActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 422 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
[[nodiscard]] Future<Void> startMetricsSimulationServer( MetricsDataModel const& model ) {
															#line 422 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	return Future<Void>(new StartMetricsSimulationServerActor(model));
															#line 3565 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
}

#line 460 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"

															#line 3570 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
namespace {
// This generated class is to be used only via runMetrics()
															#line 461 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
template <class RunMetricsActor1>
															#line 461 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class RunMetricsActor1State {
															#line 3577 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
															#line 461 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	RunMetricsActor1State() 
															#line 461 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
															#line 462 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		 : metrics(nullptr)
															#line 3584 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
	{
		fdb_probe_actor_create("runMetrics", reinterpret_cast<unsigned long>(this));

	}
	~RunMetricsActor1State() 
	{
		fdb_probe_actor_destroy("runMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 463 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			MetricsDataModel model = knobToMetricModel(FLOW_KNOBS->METRICS_DATA_MODEL);
															#line 464 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (model == MetricsDataModel::NONE)
															#line 3601 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			{
															#line 465 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				if (!static_cast<RunMetricsActor1*>(this)->SAV<Void>::futures) { (void)(Void{}); this->~RunMetricsActor1State(); static_cast<RunMetricsActor1*>(this)->destroy(); return 0; }
															#line 3605 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
				new (&static_cast<RunMetricsActor1*>(this)->SAV< Void >::value()) Void(Void{});
				this->~RunMetricsActor1State();
				static_cast<RunMetricsActor1*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 467 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			metricClient = UDPMetricClient();
															#line 468 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			metricsActor = Future<Void>();
															#line 469 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (g_network->isSimulated())
															#line 3617 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			{
															#line 470 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				metricsActor = startMetricsSimulationServer(model);
															#line 3621 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
															#line 472 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			;
															#line 3625 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunMetricsActor1State();
		static_cast<RunMetricsActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 473 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		metrics = MetricCollection::getMetricCollection();
															#line 474 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (metrics != nullptr)
															#line 3657 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
															#line 476 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			metricClient.send(metrics);
															#line 3661 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		}
															#line 478 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(FLOW_KNOBS->METRICS_EMISSION_INTERVAL);
															#line 478 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (static_cast<RunMetricsActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3667 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RunMetricsActor1*>(this)->actor_wait_state = 1;
															#line 478 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunMetricsActor1, 0, Void >*>(static_cast<RunMetricsActor1*>(this)));
															#line 3672 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunMetricsActor1*>(this)->actor_wait_state > 0) static_cast<RunMetricsActor1*>(this)->actor_wait_state = 0;
		static_cast<RunMetricsActor1*>(this)->ActorCallback< RunMetricsActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunMetricsActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunMetricsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunMetricsActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunMetricsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunMetricsActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunMetricsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 462 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	MetricCollection* metrics;
															#line 467 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	UDPMetricClient metricClient;
															#line 468 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Future<Void> metricsActor;
															#line 3770 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
};
// This generated class is to be used only via runMetrics()
															#line 461 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class RunMetricsActor1 final : public Actor<Void>, public ActorCallback< RunMetricsActor1, 0, Void >, public FastAllocated<RunMetricsActor1>, public RunMetricsActor1State<RunMetricsActor1> {
															#line 3775 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
	using FastAllocated<RunMetricsActor1>::operator new;
	using FastAllocated<RunMetricsActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14602308735322072832UL, 12026424326283002368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunMetricsActor1, 0, Void >;
															#line 461 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	RunMetricsActor1() 
															#line 3792 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		 : Actor<Void>(),
		   RunMetricsActor1State<RunMetricsActor1>(),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4136153500143715072UL, 2504022601771982592UL);
		ActorExecutionContextHelper __helper(static_cast<RunMetricsActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunMetricsActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 461 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
[[nodiscard]] Future<Void> runMetrics(  ) {
															#line 461 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	return Future<Void>(new RunMetricsActor1());
															#line 3825 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
}

#line 481 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"

															#line 3830 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase482()
															#line 482 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
template <class FlowTestCase482Actor>
															#line 482 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class FlowTestCase482ActorState {
															#line 3837 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
															#line 482 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	FlowTestCase482ActorState(UnitTestParameters const& params) 
															#line 482 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
															#line 482 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		 : params(params)
															#line 3844 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase482", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase482ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase482", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 483 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			auto getenv2 = [](const char* s) -> const char* { s = getenv(s); return s ? s : ""; };
															#line 487 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			std::string metricsConnFile = getenv2("METRICS_CONNFILE");
															#line 488 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			std::string metricsPrefix = getenv2("METRICS_PREFIX");
															#line 489 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (metricsConnFile == "")
															#line 3865 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			{
															#line 490 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				fprintf(stdout, "Metrics cluster file must be specified in environment variable METRICS_CONNFILE\n");
															#line 491 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				if (!static_cast<FlowTestCase482Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase482ActorState(); static_cast<FlowTestCase482Actor*>(this)->destroy(); return 0; }
															#line 3871 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
				new (&static_cast<FlowTestCase482Actor*>(this)->SAV< Void >::value()) Void(Void());
				this->~FlowTestCase482ActorState();
				static_cast<FlowTestCase482Actor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 493 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			fprintf(stdout, "Using environment variables METRICS_CONNFILE and METRICS_PREFIX.\n");
															#line 495 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			metricsDb = Database::createDatabase(metricsConnFile, ApiVersion::LATEST_VERSION);
															#line 496 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			TDMetricCollection::getTDMetrics()->address = "0.0.0.0:0"_sr;
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			metrics = runMetrics(metricsDb, KeyRef(metricsPrefix));
															#line 498 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			x = 0;
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			w = 0.5;
															#line 501 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			chunk = 4000;
															#line 502 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			total = 200000;
															#line 504 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			fprintf(stdout, "Writing trace event named Dummy with fields a, b, c, d, j, k, s, x, y, z.\n");
															#line 505 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			fprintf(stdout, "  There is a %f second pause every %d events\n", w, chunk);
															#line 506 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			fprintf(stdout, "  %d events will be logged.\n", total);
															#line 507 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			fprintf(stdout, "  a is always present.  It starts with = 0 and increments by 1 with each event.\n");
															#line 508 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			fprintf(stdout, "  b, if present, is always a*2.\n");
															#line 509 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			fprintf(stdout, "  c, if present, is always a*3.\n");
															#line 510 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			fprintf(stdout, "  b and c are never present in the same event.\n");
															#line 511 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			fprintf(stdout, "  x, y, and z, if present, are doubles and equal to 1.5 * a, b, and c, respectively\n");
															#line 512 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			fprintf(stdout, "  d is always present, is a string, and rotates through the values 'one', 'two', and ''.\n");
															#line 513 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			fprintf(stdout, "  Plotting j on the x axis and k on the y axis should look like x=sin(2t), y=sin(3t)\n");
															#line 515 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			intMetric = Int64MetricHandle("DummyInt"_sr);
															#line 516 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			boolMetric = BoolMetricHandle("DummyBool"_sr);
															#line 517 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			stringMetric = StringMetricHandle("DummyString"_sr);
															#line 519 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			static const char* dStrings[] = { "one", "two", "" };
															#line 520 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			d = dStrings;
															#line 521 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			arena = Arena();
															#line 523 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			;
															#line 3927 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase482ActorState();
		static_cast<FlowTestCase482Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		{
															#line 525 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			double sstart = x;
															#line 526 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			for(int i = 0;i < chunk;++i, ++x) {
															#line 527 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				intMetric = x;
															#line 528 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				boolMetric = (x % 2) > 0;
															#line 529 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				const char* s = d[x % 3];
															#line 531 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				stringMetric = Standalone<StringRef>(StringRef((uint8_t*)s, strlen(s)), arena);
															#line 533 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				TraceEvent("Dummy") .detail("A", x) .detail("X", 1.5 * x) .detail("D", s) .detail("J", sin(2.0 * x)) .detail("K", sin(3.0 * x)) .detail("S", sstart + (double)chunk * sin(10.0 * i / chunk));
															#line 3970 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
															#line 541 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(w);
															#line 541 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (static_cast<FlowTestCase482Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3976 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase482Actor*>(this)->actor_wait_state = 1;
															#line 541 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase482Actor, 0, Void >*>(static_cast<FlowTestCase482Actor*>(this)));
															#line 3981 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		{
															#line 545 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			double sstart = x;
															#line 546 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			for(int i = 0;i < chunk;++i, ++x) {
															#line 547 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				intMetric = x;
															#line 548 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				boolMetric = x % 2 > 0;
															#line 549 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				TraceEvent("Dummy") .detail("A", x) .detail("X", 1.5 * x) .detail("B", x * 2) .detail("Y", 3.0 * x) .detail("D", d[x % 3]) .detail("J", sin(2.0 * x)) .detail("K", sin(3.0 * x)) .detail("S", sstart + (double)chunk * sin(40.0 * i / chunk));
															#line 4000 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
															#line 559 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(w);
															#line 559 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (static_cast<FlowTestCase482Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4006 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<FlowTestCase482Actor*>(this)->actor_wait_state = 2;
															#line 559 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase482Actor, 1, Void >*>(static_cast<FlowTestCase482Actor*>(this)));
															#line 4011 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase482Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase482Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase482Actor*>(this)->ActorCallback< FlowTestCase482Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase482Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase482", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase482Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase482", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase482Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase482", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase482Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase482", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase482Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase482", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase482Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase482", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		{
															#line 563 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			double sstart = x;
															#line 564 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			for(int i = 0;i < chunk;++i, ++x) {
															#line 565 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				intMetric = x;
															#line 566 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				boolMetric = x % 2 > 0;
															#line 567 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
				TraceEvent("Dummy") .detail("A", x) .detail("X", 1.5 * x) .detail("C", x * 3) .detail("Z", 4.5 * x) .detail("D", d[x % 3]) .detail("J", sin(2.0 * x)) .detail("K", sin(3.0 * x)) .detail("S", sstart + (double)chunk * sin(160.0 * i / chunk));
															#line 4117 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			}
															#line 577 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(w);
															#line 577 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (static_cast<FlowTestCase482Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4123 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<FlowTestCase482Actor*>(this)->actor_wait_state = 3;
															#line 577 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase482Actor, 2, Void >*>(static_cast<FlowTestCase482Actor*>(this)));
															#line 4128 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase482Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase482Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase482Actor*>(this)->ActorCallback< FlowTestCase482Actor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase482Actor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase482", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase482Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase482", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase482Actor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase482", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase482Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase482", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase482Actor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase482", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase482Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase482", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 579 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (x >= total)
															#line 4231 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
															#line 580 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (!static_cast<FlowTestCase482Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase482ActorState(); static_cast<FlowTestCase482Actor*>(this)->destroy(); return 0; }
															#line 4235 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			new (&static_cast<FlowTestCase482Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase482ActorState();
			static_cast<FlowTestCase482Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 579 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
		if (x >= total)
															#line 4249 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		{
															#line 580 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
			if (!static_cast<FlowTestCase482Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase482ActorState(); static_cast<FlowTestCase482Actor*>(this)->destroy(); return 0; }
															#line 4253 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
			new (&static_cast<FlowTestCase482Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase482ActorState();
			static_cast<FlowTestCase482Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase482Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase482Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase482Actor*>(this)->ActorCallback< FlowTestCase482Actor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase482Actor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase482", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase482Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase482", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase482Actor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase482", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase482Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase482", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase482Actor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase482", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase482Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase482", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 482 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	UnitTestParameters params;
															#line 495 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Database metricsDb;
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Future<Void> metrics;
															#line 498 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	int64_t x;
															#line 500 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	double w;
															#line 501 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	int chunk;
															#line 502 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	int total;
															#line 515 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Int64MetricHandle intMetric;
															#line 516 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	BoolMetricHandle boolMetric;
															#line 517 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	StringMetricHandle stringMetric;
															#line 520 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	const char** d;
															#line 521 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	Arena arena;
															#line 4362 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase482()
															#line 482 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
class FlowTestCase482Actor final : public Actor<Void>, public ActorCallback< FlowTestCase482Actor, 0, Void >, public ActorCallback< FlowTestCase482Actor, 1, Void >, public ActorCallback< FlowTestCase482Actor, 2, Void >, public FastAllocated<FlowTestCase482Actor>, public FlowTestCase482ActorState<FlowTestCase482Actor> {
															#line 4367 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase482Actor>::operator new;
	using FastAllocated<FlowTestCase482Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14671378454593911040UL, 14649258333817966848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase482Actor, 0, Void >;
friend struct ActorCallback< FlowTestCase482Actor, 1, Void >;
friend struct ActorCallback< FlowTestCase482Actor, 2, Void >;
															#line 482 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	FlowTestCase482Actor(UnitTestParameters const& params) 
															#line 4386 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase482ActorState<FlowTestCase482Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase482", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12778150663482071552UL, 9640007613459756800UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase482Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase482");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase482", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase482Actor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase482Actor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase482Actor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 482 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
static Future<Void> flowTestCase482( UnitTestParameters const& params ) {
															#line 482 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
	return Future<Void>(new FlowTestCase482Actor(params));
															#line 4421 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/MetricLogger.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase482, "/fdbserver/metrics/TraceEvents")

#line 584 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/MetricLogger.actor.cpp"
