#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
/*
 * GrvProxyServer.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ClientKnobs.h"
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/Knobs.h"
#include "fdbclient/Notified.h"
#include "fdbclient/TransactionLineage.h"
#include "fdbclient/Tuple.h"
#include "fdbclient/CommitProxyInterface.h"
#include "fdbclient/GrvProxyInterface.h"
#include "fdbclient/VersionVector.h"
#include "fdbserver/GrvProxyTagThrottler.h"
#include "fdbserver/GrvTransactionRateInfo.h"
#include "fdbserver/LogSystem.h"
#include "fdbserver/LogSystemDiskQueueAdapter.h"
#include "fdbserver/WaitFailure.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbrpc/sim_validation.h"
#include "flow/IRandom.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "flow/actorcompiler.h" // This must be the last #include.
#include "flow/genericactors.actor.h"

struct GrvProxyStats {
	CounterCollection cc;
	Counter txnRequestIn, txnRequestOut, txnRequestErrors;
	Counter txnStartIn, txnStartOut, txnStartBatch;
	Counter txnSystemPriorityStartIn, txnSystemPriorityStartOut;
	Counter txnBatchPriorityStartIn, txnBatchPriorityStartOut;
	Counter txnDefaultPriorityStartIn, txnDefaultPriorityStartOut;
	Counter txnTagThrottlerIn, txnTagThrottlerOut;
	Counter txnThrottled;
	Counter updatesFromRatekeeper, leaseTimeouts;
	int systemGRVQueueSize, defaultGRVQueueSize, batchGRVQueueSize;
	int tagThrottlerGRVQueueSize;
	double transactionRateAllowed, batchTransactionRateAllowed;
	double transactionLimit, batchTransactionLimit;
	// how much of the GRV requests queue was processed in one attempt to hand out read version.
	double percentageOfDefaultGRVQueueProcessed;
	double percentageOfBatchGRVQueueProcessed;

	bool lastBatchQueueThrottled;
	bool lastDefaultQueueThrottled;
	double batchThrottleStartTime;
	double defaultThrottleStartTime;

	LatencySample defaultTxnGRVTimeInQueue;
	LatencySample batchTxnGRVTimeInQueue;

	// These latency bands and samples ignore latency injected by the GrvProxyTagThrottler
	LatencyBands grvLatencyBands;
	LatencySample grvLatencySample; // GRV latency metric sample of default priority
	LatencySample grvBatchLatencySample; // GRV latency metric sample of batched priority

	Future<Void> logger;

	int recentRequests;
	Deque<int> requestBuckets;
	double lastBucketBegin;
	double bucketInterval;
	Reference<Histogram> grvConfirmEpochLiveDist;
	Reference<Histogram> grvGetCommittedVersionRpcDist;

	void updateRequestBuckets() {
		while (now() - lastBucketBegin > bucketInterval) {
			lastBucketBegin += bucketInterval;
			recentRequests -= requestBuckets.front();
			requestBuckets.pop_front();
			requestBuckets.push_back(0);
		}
	}

	void addRequest(int transactionCount) {
		updateRequestBuckets();
		recentRequests += transactionCount;
		requestBuckets.back() += transactionCount;
	}

	int getRecentRequests() {
		updateRequestBuckets();
		return recentRequests /
		       (FLOW_KNOBS->BASIC_LOAD_BALANCE_UPDATE_RATE - (lastBucketBegin + bucketInterval - now()));
	}

	void update(GrvProxyTagThrottler::ReleaseTransactionsResult const& releaseStats) {
		auto const totalReleasedRequests =
		    releaseStats.batchPriorityRequestsReleased + releaseStats.defaultPriorityRequestsReleased;
		auto const totalReleasedTransactions =
		    releaseStats.batchPriorityTransactionsReleased + releaseStats.defaultPriorityTransactionsReleased;

		txnRequestIn += totalReleasedRequests;
		txnStartIn += totalReleasedTransactions;
		txnBatchPriorityStartIn += releaseStats.batchPriorityTransactionsReleased;
		txnDefaultPriorityStartIn += releaseStats.defaultPriorityTransactionsReleased;
		batchGRVQueueSize += releaseStats.batchPriorityRequestsReleased;
		defaultGRVQueueSize += releaseStats.defaultPriorityRequestsReleased;
		txnRequestErrors += releaseStats.rejectedRequests;
		txnTagThrottlerOut += totalReleasedTransactions;
		tagThrottlerGRVQueueSize -= totalReleasedRequests;
	}

	// Current stats maintained for a given grv proxy server
	explicit GrvProxyStats(UID id)
	  : cc("GrvProxyStats", id.toString()),

	    txnRequestIn("TxnRequestIn", cc), txnRequestOut("TxnRequestOut", cc), txnRequestErrors("TxnRequestErrors", cc),
	    txnStartIn("TxnStartIn", cc), txnStartOut("TxnStartOut", cc), txnStartBatch("TxnStartBatch", cc),
	    txnSystemPriorityStartIn("TxnSystemPriorityStartIn", cc),
	    txnSystemPriorityStartOut("TxnSystemPriorityStartOut", cc),
	    txnBatchPriorityStartIn("TxnBatchPriorityStartIn", cc),
	    txnBatchPriorityStartOut("TxnBatchPriorityStartOut", cc),
	    txnDefaultPriorityStartIn("TxnDefaultPriorityStartIn", cc),
	    txnDefaultPriorityStartOut("TxnDefaultPriorityStartOut", cc), txnTagThrottlerIn("TxnTagThrottlerIn", cc),
	    txnTagThrottlerOut("TxnTagThrottlerOut", cc), txnThrottled("TxnThrottled", cc),
	    updatesFromRatekeeper("UpdatesFromRatekeeper", cc), leaseTimeouts("LeaseTimeouts", cc), systemGRVQueueSize(0),
	    defaultGRVQueueSize(0), batchGRVQueueSize(0), tagThrottlerGRVQueueSize(0), transactionRateAllowed(0),
	    batchTransactionRateAllowed(0), transactionLimit(0), batchTransactionLimit(0),
	    percentageOfDefaultGRVQueueProcessed(0), percentageOfBatchGRVQueueProcessed(0), lastBatchQueueThrottled(false),
	    lastDefaultQueueThrottled(false), batchThrottleStartTime(0.0), defaultThrottleStartTime(0.0),
	    defaultTxnGRVTimeInQueue("DefaultTxnGRVTimeInQueue",
	                             id,
	                             SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
	                             SERVER_KNOBS->LATENCY_SKETCH_ACCURACY),
	    batchTxnGRVTimeInQueue("BatchTxnGRVTimeInQueue",
	                           id,
	                           SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
	                           SERVER_KNOBS->LATENCY_SKETCH_ACCURACY),
	    grvLatencyBands("GRVLatencyBands", id, SERVER_KNOBS->STORAGE_LOGGING_DELAY),
	    grvLatencySample("GRVLatencyMetrics",
	                     id,
	                     SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
	                     SERVER_KNOBS->LATENCY_SKETCH_ACCURACY),
	    grvBatchLatencySample("GRVBatchLatencyMetrics",
	                          id,
	                          SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
	                          SERVER_KNOBS->LATENCY_SKETCH_ACCURACY),
	    recentRequests(0), lastBucketBegin(now()),
	    bucketInterval(FLOW_KNOBS->BASIC_LOAD_BALANCE_UPDATE_RATE / FLOW_KNOBS->BASIC_LOAD_BALANCE_BUCKETS),
	    grvConfirmEpochLiveDist(
	        Histogram::getHistogram("GrvProxy"_sr, "GrvConfirmEpochLive"_sr, Histogram::Unit::milliseconds)),
	    grvGetCommittedVersionRpcDist(
	        Histogram::getHistogram("GrvProxy"_sr, "GrvGetCommittedVersionRpc"_sr, Histogram::Unit::milliseconds)) {
		// The rate at which the limit(budget) is allowed to grow.
		specialCounter(cc, "SystemGRVQueueSize", [this]() { return this->systemGRVQueueSize; });
		specialCounter(cc, "DefaultGRVQueueSize", [this]() { return this->defaultGRVQueueSize; });
		specialCounter(cc, "BatchGRVQueueSize", [this]() { return this->batchGRVQueueSize; });
		specialCounter(cc, "TagThrottlerGRVQueueSize", [this]() { return this->tagThrottlerGRVQueueSize; });
		specialCounter(
		    cc, "SystemAndDefaultTxnRateAllowed", [this]() { return int64_t(this->transactionRateAllowed); });
		specialCounter(
		    cc, "BatchTransactionRateAllowed", [this]() { return int64_t(this->batchTransactionRateAllowed); });
		specialCounter(cc, "SystemAndDefaultTxnLimit", [this]() { return int64_t(this->transactionLimit); });
		specialCounter(cc, "BatchTransactionLimit", [this]() { return int64_t(this->batchTransactionLimit); });
		specialCounter(cc, "PercentageOfDefaultGRVQueueProcessed", [this]() {
			return int64_t(100 * this->percentageOfDefaultGRVQueueProcessed);
		});
		specialCounter(cc, "PercentageOfBatchGRVQueueProcessed", [this]() {
			return int64_t(100 * this->percentageOfBatchGRVQueueProcessed);
		});

		logger = cc.traceCounters("GrvProxyMetrics", id, SERVER_KNOBS->WORKER_LOGGING_INTERVAL, "GrvProxyMetrics");
		for (int i = 0; i < FLOW_KNOBS->BASIC_LOAD_BALANCE_BUCKETS; i++) {
			requestBuckets.push_back(0);
		}
	}
};

struct GrvProxyData {
	GrvProxyInterface proxy;
	UID dbgid;

	GrvProxyStats stats;
	MasterInterface master;
	PublicRequestStream<GetReadVersionRequest> getConsistentReadVersion;
	Reference<ILogSystem> logSystem;

	Database cx;
	Reference<AsyncVar<ServerDBInfo> const> db;

	Optional<LatencyBandConfig> latencyBandConfig;
	double lastStartCommit;
	double lastCommitLatency;
	std::unique_ptr<LatencySample> versionVectorSizeOnGRVReply;
	int updateCommitRequests;
	NotifiedDouble lastCommitTime;

	Version version;
	Version minKnownCommittedVersion; // we should ask master for this version.

	GrvProxyTagThrottler tagThrottler;

	// Cache of the latest commit versions of storage servers.
	VersionVector ssVersionVectorCache;

	void updateLatencyBandConfig(Optional<LatencyBandConfig> newLatencyBandConfig) {
		if (newLatencyBandConfig.present() != latencyBandConfig.present() ||
		    (newLatencyBandConfig.present() &&
		     newLatencyBandConfig.get().grvConfig != latencyBandConfig.get().grvConfig)) {
			TraceEvent("LatencyBandGrvUpdatingConfig").detail("Present", newLatencyBandConfig.present());
			stats.grvLatencyBands.clearBands();
			if (newLatencyBandConfig.present()) {
				for (auto band : newLatencyBandConfig.get().grvConfig.bands) {
					stats.grvLatencyBands.addThreshold(band);
					tagThrottler.addLatencyBandThreshold(band);
				}
			}
		}

		latencyBandConfig = newLatencyBandConfig;
	}

	GrvProxyData(UID dbgid,
	             MasterInterface master,
	             PublicRequestStream<GetReadVersionRequest> getConsistentReadVersion,
	             Reference<AsyncVar<ServerDBInfo> const> db)
	  : dbgid(dbgid), stats(dbgid), master(master), getConsistentReadVersion(getConsistentReadVersion),
	    cx(openDBOnServer(db, TaskPriority::DefaultEndpoint, LockAware::True)), db(db), lastStartCommit(0),
	    lastCommitLatency(SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION), updateCommitRequests(0), lastCommitTime(0),
	    version(0), minKnownCommittedVersion(invalidVersion),
	    tagThrottler(CLIENT_KNOBS->PROXY_MAX_TAG_THROTTLE_DURATION) {
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR) {
			versionVectorSizeOnGRVReply =
			    std::make_unique<LatencySample>("VersionVectorSizeOnGRVReply",
			                                    dbgid,
			                                    SERVER_KNOBS->LATENCY_METRICS_LOGGING_INTERVAL,
			                                    SERVER_KNOBS->LATENCY_SKETCH_ACCURACY);
		}
	}
};

															#line 252 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via healthMetricsRequestServer()
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class HealthMetricsRequestServerActor>
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class HealthMetricsRequestServerActorState {
															#line 259 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	HealthMetricsRequestServerActorState(GrvProxyInterface const& grvProxy,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply) 
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : grvProxy(grvProxy),
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   healthMetricsReply(healthMetricsReply),
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   detailedHealthMetricsReply(detailedHealthMetricsReply)
															#line 270 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this));

	}
	~HealthMetricsRequestServerActorState() 
	{
		fdb_probe_actor_destroy("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 253 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 285 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HealthMetricsRequestServerActorState();
		static_cast<HealthMetricsRequestServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 255 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		auto __when_expr_0 = grvProxy.getHealthMetrics.getFuture();
															#line 315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetHealthMetricsRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetHealthMetricsRequest>>::value, "invalid type");
															#line 254 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<HealthMetricsRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 319 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<HealthMetricsRequestServerActor*>(this)->actor_wait_state = 1;
															#line 255 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*>(static_cast<HealthMetricsRequestServerActor*>(this)));
															#line 324 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetHealthMetricsRequest const& req,int loopDepth) 
	{
															#line 256 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (req.detailed)
															#line 339 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 257 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			req.reply.send(*detailedHealthMetricsReply);
															#line 343 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 259 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			req.reply.send(*healthMetricsReply);
															#line 349 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetHealthMetricsRequest && req,int loopDepth) 
	{
															#line 256 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (req.detailed)
															#line 359 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 257 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			req.reply.send(*detailedHealthMetricsReply);
															#line 363 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 259 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			req.reply.send(*healthMetricsReply);
															#line 369 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HealthMetricsRequestServerActor*>(this)->actor_wait_state > 0) static_cast<HealthMetricsRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMetricsRequestServerActor*>(this)->ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*,GetHealthMetricsRequest const& value) 
	{
		fdb_probe_actor_enter("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*,GetHealthMetricsRequest && value) 
	{
		fdb_probe_actor_enter("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface grvProxy;
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* healthMetricsReply;
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* detailedHealthMetricsReply;
															#line 444 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via healthMetricsRequestServer()
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class HealthMetricsRequestServerActor final : public Actor<Void>, public ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >, public FastAllocated<HealthMetricsRequestServerActor>, public HealthMetricsRequestServerActorState<HealthMetricsRequestServerActor> {
															#line 449 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<HealthMetricsRequestServerActor>::operator new;
	using FastAllocated<HealthMetricsRequestServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11564992429248752640UL, 12794349363241313280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >;
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	HealthMetricsRequestServerActor(GrvProxyInterface const& grvProxy,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply) 
															#line 466 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   HealthMetricsRequestServerActorState<HealthMetricsRequestServerActor>(grvProxy, healthMetricsReply, detailedHealthMetricsReply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15006378439154462208UL, 8394861280111908096UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("healthMetricsRequestServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("healthMetricsRequestServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< HealthMetricsRequestServerActor, 0, GetHealthMetricsRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> healthMetricsRequestServer( GrvProxyInterface const& grvProxy, GetHealthMetricsReply* const& healthMetricsReply, GetHealthMetricsReply* const& detailedHealthMetricsReply ) {
															#line 250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new HealthMetricsRequestServerActor(grvProxy, healthMetricsReply, detailedHealthMetricsReply));
															#line 499 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 264 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Older FDB versions used different keys for client profiling data. This
// function performs a one-time migration of data in these keys to the new
// global configuration key space.
															#line 507 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via globalConfigMigrate()
															#line 268 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GlobalConfigMigrateActor>
															#line 268 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigMigrateActorState {
															#line 514 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 268 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigMigrateActorState(GrvProxyData* const& grvProxyData) 
															#line 268 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 268 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : grvProxyData(grvProxyData),
															#line 269 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   migratedKey("\xff\x02/fdbClientInfo/migrated/"_sr),
															#line 270 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(grvProxyData->cx))
															#line 525 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("globalConfigMigrate", reinterpret_cast<unsigned long>(this));

	}
	~GlobalConfigMigrateActorState() 
	{
		fdb_probe_actor_destroy("globalConfigMigrate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 272 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				;
															#line 541 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GlobalConfigMigrateActorState();
		static_cast<GlobalConfigMigrateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 316 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GlobalConfigMigrateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GlobalConfigMigrateActorState(); static_cast<GlobalConfigMigrateActor*>(this)->destroy(); return 0; }
															#line 570 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GlobalConfigMigrateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GlobalConfigMigrateActorState();
		static_cast<GlobalConfigMigrateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 314 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent(SevWarnAlways, "GlobalConfigMigrationError").error(e);
															#line 583 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 273 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		try {
															#line 276 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(migratedKey);
															#line 276 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 617 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 1;
															#line 276 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 308 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent(SevInfo, "GlobalConfigRetryableMigrationError").errorUnsuppressed(e).suppressFor(1.0);
															#line 309 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 309 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 661 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 5;
															#line 309 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 4, Void >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 666 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 277 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (migrated.present())
															#line 681 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 282 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr->get(Key("\xff\x02/fdbClientInfo/client_txn_sample_rate/"_sr));
															#line 282 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 689 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 2;
															#line 282 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 694 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __migrated,int loopDepth) 
	{
															#line 276 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		migrated = __migrated;
															#line 703 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __migrated,int loopDepth) 
	{
		migrated = std::move(__migrated);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 284 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_2 = tr->get(Key("\xff\x02/fdbClientInfo/client_txn_size_limit/"_sr));
															#line 284 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 784 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 3;
															#line 284 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 789 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& __sampleRate,int loopDepth) 
	{
															#line 282 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		sampleRate = __sampleRate;
															#line 798 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && __sampleRate,int loopDepth) 
	{
		sampleRate = std::move(__sampleRate);
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 287 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 289 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		tr->set(migratedKey.contents(), "1"_sr);
															#line 290 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (sampleRate.present())
															#line 881 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 291 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			const double sampleRateDbl = BinaryReader::fromStringRef<double>(sampleRate.get().contents(), Unversioned());
															#line 293 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Tuple rate = Tuple::makeTuple(sampleRateDbl);
															#line 294 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			tr->set(GlobalConfig::prefixedKey(fdbClientInfoTxnSampleRate), rate.pack());
															#line 889 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 296 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (sizeLimit.present())
															#line 893 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 297 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			const int64_t sizeLimitInt = BinaryReader::fromStringRef<int64_t>(sizeLimit.get().contents(), Unversioned());
															#line 299 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Tuple size = Tuple::makeTuple(sizeLimitInt);
															#line 300 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			tr->set(GlobalConfig::prefixedKey(fdbClientInfoTxnSizeLimit), size.pack());
															#line 901 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 303 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 303 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 907 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 4;
															#line 303 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigMigrateActor, 3, Void >*>(static_cast<GlobalConfigMigrateActor*>(this)));
															#line 912 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Optional<Value> const& __sizeLimit,int loopDepth) 
	{
															#line 284 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		sizeLimit = __sizeLimit;
															#line 921 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Optional<Value> && __sizeLimit,int loopDepth) 
	{
		sizeLimit = std::move(__sizeLimit);
		loopDepth = a_body1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigMigrateActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigMigrateActor*>(this)->ActorCallback< GlobalConfigMigrateActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< GlobalConfigMigrateActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< GlobalConfigMigrateActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 268 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 269 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Key migratedKey;
															#line 270 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 276 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<Value> migrated;
															#line 282 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<Value> sampleRate;
															#line 284 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<Value> sizeLimit;
															#line 1195 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via globalConfigMigrate()
															#line 268 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigMigrateActor final : public Actor<Void>, public ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >, public ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >, public ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >, public ActorCallback< GlobalConfigMigrateActor, 3, Void >, public ActorCallback< GlobalConfigMigrateActor, 4, Void >, public FastAllocated<GlobalConfigMigrateActor>, public GlobalConfigMigrateActorState<GlobalConfigMigrateActor> {
															#line 1200 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GlobalConfigMigrateActor>::operator new;
	using FastAllocated<GlobalConfigMigrateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7143414757233508864UL, 7178702369990029824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >;
friend struct ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >;
friend struct ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >;
friend struct ActorCallback< GlobalConfigMigrateActor, 3, Void >;
friend struct ActorCallback< GlobalConfigMigrateActor, 4, Void >;
															#line 268 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigMigrateActor(GrvProxyData* const& grvProxyData) 
															#line 1221 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GlobalConfigMigrateActorState<GlobalConfigMigrateActor>(grvProxyData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("globalConfigMigrate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(154511452753742592UL, 13598310903932054784UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigMigrateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("globalConfigMigrate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("globalConfigMigrate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 2, Optional<Value> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< GlobalConfigMigrateActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 268 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> globalConfigMigrate( GrvProxyData* const& grvProxyData ) {
															#line 268 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GlobalConfigMigrateActor(grvProxyData));
															#line 1258 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 318 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Periodically refresh local copy of global configuration.
															#line 1264 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via globalConfigRefresh()
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GlobalConfigRefreshActor>
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigRefreshActorState {
															#line 1271 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigRefreshActorState(GrvProxyData* const& grvProxyData,Version* const& cachedVersion,RangeResult* const& cachedData) 
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : grvProxyData(grvProxyData),
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   cachedVersion(cachedVersion),
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   cachedData(cachedData),
															#line 321 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(grvProxyData->cx))
															#line 1284 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("globalConfigRefresh", reinterpret_cast<unsigned long>(this));

	}
	~GlobalConfigRefreshActorState() 
	{
		fdb_probe_actor_destroy("globalConfigRefresh", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 322 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 1299 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GlobalConfigRefreshActorState();
		static_cast<GlobalConfigRefreshActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 324 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 325 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			globalConfigVersionFuture = tr->get(globalConfigVersionKey);
															#line 326 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			tmpCachedDataFuture = tr->getRange(globalConfigDataKeys, CLIENT_KNOBS->TOO_MANY);
															#line 327 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = globalConfigVersionFuture;
															#line 327 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1338 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 1;
															#line 327 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*>(static_cast<GlobalConfigRefreshActor*>(this)));
															#line 1343 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 337 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 337 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1367 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 3;
															#line 337 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRefreshActor, 2, Void >*>(static_cast<GlobalConfigRefreshActor*>(this)));
															#line 1372 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 328 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tmpCachedDataFuture;
															#line 328 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 2;
															#line 328 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*>(static_cast<GlobalConfigRefreshActor*>(this)));
															#line 1394 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& __globalConfigVersion,int loopDepth) 
	{
															#line 327 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		globalConfigVersion = __globalConfigVersion;
															#line 1403 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && __globalConfigVersion,int loopDepth) 
	{
		globalConfigVersion = std::move(__globalConfigVersion);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRefreshActor*>(this)->ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& tmpCachedData,int loopDepth) 
	{
															#line 329 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*cachedData = tmpCachedData;
															#line 330 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (globalConfigVersion.present())
															#line 1484 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 331 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Version parsedVersion;
															#line 332 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			memcpy(&parsedVersion, globalConfigVersion.get().begin(), sizeof(Version));
															#line 333 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			*cachedVersion = bigEndian64(parsedVersion);
															#line 1492 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 335 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GlobalConfigRefreshActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GlobalConfigRefreshActorState(); static_cast<GlobalConfigRefreshActor*>(this)->destroy(); return 0; }
															#line 1496 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GlobalConfigRefreshActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GlobalConfigRefreshActorState();
		static_cast<GlobalConfigRefreshActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && tmpCachedData,int loopDepth) 
	{
															#line 329 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*cachedData = tmpCachedData;
															#line 330 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (globalConfigVersion.present())
															#line 1510 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 331 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Version parsedVersion;
															#line 332 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			memcpy(&parsedVersion, globalConfigVersion.get().begin(), sizeof(Version));
															#line 333 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			*cachedVersion = bigEndian64(parsedVersion);
															#line 1518 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 335 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GlobalConfigRefreshActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GlobalConfigRefreshActorState(); static_cast<GlobalConfigRefreshActor*>(this)->destroy(); return 0; }
															#line 1522 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GlobalConfigRefreshActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GlobalConfigRefreshActorState();
		static_cast<GlobalConfigRefreshActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& tmpCachedData,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(tmpCachedData, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && tmpCachedData,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(tmpCachedData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRefreshActor*>(this)->ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRefreshActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRefreshActor*>(this)->ActorCallback< GlobalConfigRefreshActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRefreshActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GlobalConfigRefreshActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Version* cachedVersion;
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	RangeResult* cachedData;
															#line 321 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 325 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Optional<Value>> globalConfigVersionFuture;
															#line 326 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<RangeResult> tmpCachedDataFuture;
															#line 327 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<Value> globalConfigVersion;
															#line 1706 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via globalConfigRefresh()
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigRefreshActor final : public Actor<Void>, public ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >, public ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >, public ActorCallback< GlobalConfigRefreshActor, 2, Void >, public FastAllocated<GlobalConfigRefreshActor>, public GlobalConfigRefreshActorState<GlobalConfigRefreshActor> {
															#line 1711 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GlobalConfigRefreshActor>::operator new;
	using FastAllocated<GlobalConfigRefreshActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3953727147627235840UL, 5161908097053042944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >;
friend struct ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >;
friend struct ActorCallback< GlobalConfigRefreshActor, 2, Void >;
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigRefreshActor(GrvProxyData* const& grvProxyData,Version* const& cachedVersion,RangeResult* const& cachedData) 
															#line 1730 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GlobalConfigRefreshActorState<GlobalConfigRefreshActor>(grvProxyData, cachedVersion, cachedData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("globalConfigRefresh", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10827479308140659200UL, 8791014497271066624UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRefreshActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("globalConfigRefresh");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("globalConfigRefresh", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GlobalConfigRefreshActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GlobalConfigRefreshActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GlobalConfigRefreshActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> globalConfigRefresh( GrvProxyData* const& grvProxyData, Version* const& cachedVersion, RangeResult* const& cachedData ) {
															#line 320 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GlobalConfigRefreshActor(grvProxyData, cachedVersion, cachedData));
															#line 1765 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 341 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Handle common GlobalConfig transactions on the server side, because not all
// clients are allowed to read system keys. Eventually, this could become its
// own role.
															#line 1773 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via globalConfigRequestServer()
															#line 345 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GlobalConfigRequestServerActor>
															#line 345 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigRequestServerActorState {
															#line 1780 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 345 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigRequestServerActorState(GrvProxyData* const& grvProxyData,GrvProxyInterface const& grvProxy) 
															#line 345 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 345 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : grvProxyData(grvProxyData),
															#line 345 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxy(grvProxy),
															#line 346 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   actors(false),
															#line 347 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   refreshFuture(),
															#line 348 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   cachedVersion(0),
															#line 349 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   cachedData()
															#line 1797 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("globalConfigRequestServer", reinterpret_cast<unsigned long>(this));

	}
	~GlobalConfigRequestServerActorState() 
	{
		fdb_probe_actor_destroy("globalConfigRequestServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 354 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refreshFuture = timeout(globalConfigRefresh(grvProxyData, &cachedVersion, &cachedData), SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_TIMEOUT, Void()) && delay(SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_INTERVAL);
															#line 360 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(timeout(globalConfigMigrate(grvProxyData), SERVER_KNOBS->GLOBAL_CONFIG_MIGRATE_TIMEOUT));
															#line 360 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1816 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state = 1;
															#line 360 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRequestServerActor, 0, Void >*>(static_cast<GlobalConfigRequestServerActor*>(this)));
															#line 1821 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GlobalConfigRequestServerActorState();
		static_cast<GlobalConfigRequestServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 362 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		;
															#line 1844 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 362 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		;
															#line 1853 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRequestServerActor*>(this)->ActorCallback< GlobalConfigRequestServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GlobalConfigRequestServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 364 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		auto __when_expr_1 = grvProxy.refreshGlobalConfig.getFuture();
															#line 1944 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<GlobalConfigRefreshRequest>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<GlobalConfigRefreshRequest>>::value, "invalid type");
															#line 363 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1948 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
															#line 375 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = refreshFuture;
															#line 1952 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 381 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = actors.getResult();
															#line 1956 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when3(__when_expr_3.get(), loopDepth); };
		static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state = 2;
															#line 364 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*>(static_cast<GlobalConfigRequestServerActor*>(this)));
															#line 375 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRequestServerActor, 2, Void >*>(static_cast<GlobalConfigRequestServerActor*>(this)));
															#line 381 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GlobalConfigRequestServerActor, 3, Void >*>(static_cast<GlobalConfigRequestServerActor*>(this)));
															#line 1965 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GlobalConfigRefreshRequest const& refresh,int loopDepth) 
	{
															#line 369 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (refresh.lastKnown <= cachedVersion)
															#line 1980 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 370 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refresh.reply.send(GlobalConfigRefreshReply{ cachedData.arena(), cachedVersion, cachedData });
															#line 1984 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 372 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refresh.reply.sendError(future_version());
															#line 1990 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(GlobalConfigRefreshRequest && refresh,int loopDepth) 
	{
															#line 369 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (refresh.lastKnown <= cachedVersion)
															#line 2000 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 370 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refresh.reply.send(GlobalConfigRefreshReply{ cachedData.arena(), cachedVersion, cachedData });
															#line 2004 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 372 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			refresh.reply.sendError(future_version());
															#line 2010 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 376 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		refreshFuture = timeout(globalConfigRefresh(grvProxyData, &cachedVersion, &cachedData), SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_TIMEOUT, Void()) && delay(SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_INTERVAL);
															#line 2020 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 376 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		refreshFuture = timeout(globalConfigRefresh(grvProxyData, &cachedVersion, &cachedData), SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_TIMEOUT, Void()) && delay(SERVER_KNOBS->GLOBAL_CONFIG_REFRESH_INTERVAL);
															#line 2029 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void const& _,int loopDepth) 
	{
															#line 382 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(false);
															#line 2038 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when3(Void && _,int loopDepth) 
	{
															#line 382 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(false);
															#line 2047 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state > 0) static_cast<GlobalConfigRequestServerActor*>(this)->actor_wait_state = 0;
		static_cast<GlobalConfigRequestServerActor*>(this)->ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >::remove();
		static_cast<GlobalConfigRequestServerActor*>(this)->ActorCallback< GlobalConfigRequestServerActor, 2, Void >::remove();
		static_cast<GlobalConfigRequestServerActor*>(this)->ActorCallback< GlobalConfigRequestServerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*,GlobalConfigRefreshRequest const& value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*,GlobalConfigRefreshRequest && value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GlobalConfigRequestServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GlobalConfigRequestServerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GlobalConfigRequestServerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 345 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 345 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface grvProxy;
															#line 346 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	ActorCollection actors;
															#line 347 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> refreshFuture;
															#line 348 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Version cachedVersion;
															#line 349 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	RangeResult cachedData;
															#line 2243 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via globalConfigRequestServer()
															#line 345 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GlobalConfigRequestServerActor final : public Actor<Void>, public ActorCallback< GlobalConfigRequestServerActor, 0, Void >, public ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >, public ActorCallback< GlobalConfigRequestServerActor, 2, Void >, public ActorCallback< GlobalConfigRequestServerActor, 3, Void >, public FastAllocated<GlobalConfigRequestServerActor>, public GlobalConfigRequestServerActorState<GlobalConfigRequestServerActor> {
															#line 2248 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GlobalConfigRequestServerActor>::operator new;
	using FastAllocated<GlobalConfigRequestServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9605009241404609024UL, 9637423126651249664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GlobalConfigRequestServerActor, 0, Void >;
friend struct ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >;
friend struct ActorCallback< GlobalConfigRequestServerActor, 2, Void >;
friend struct ActorCallback< GlobalConfigRequestServerActor, 3, Void >;
															#line 345 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GlobalConfigRequestServerActor(GrvProxyData* const& grvProxyData,GrvProxyInterface const& grvProxy) 
															#line 2268 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GlobalConfigRequestServerActorState<GlobalConfigRequestServerActor>(grvProxyData, grvProxy),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15730633037479306240UL, 7934117556835500544UL);
		ActorExecutionContextHelper __helper(static_cast<GlobalConfigRequestServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("globalConfigRequestServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("globalConfigRequestServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GlobalConfigRequestServerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< GlobalConfigRequestServerActor, 1, GlobalConfigRefreshRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 345 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> globalConfigRequestServer( GrvProxyData* const& grvProxyData, GrvProxyInterface const& grvProxy ) {
															#line 345 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GlobalConfigRequestServerActor(grvProxyData, grvProxy));
															#line 2302 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 387 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Get transaction rate info from RateKeeper.
															#line 2308 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via getRate()
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GetRateActor>
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GetRateActorState {
															#line 2315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetRateActorState(UID const& myID,Reference<AsyncVar<ServerDBInfo> const> const& db,int64_t* const& inTransactionCount,int64_t* const& inBatchTransactionCount,GrvTransactionRateInfo* const& transactionRateInfo,GrvTransactionRateInfo* const& batchTransactionRateInfo,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply,TransactionTagMap<uint64_t>* const& transactionTagCounter,PrioritizedTransactionTagMap<ClientTagThrottleLimits>* const& clientThrottledTags,GrvProxyStats* const& stats,GrvProxyData* const& proxyData) 
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : myID(myID),
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db),
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   inTransactionCount(inTransactionCount),
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   inBatchTransactionCount(inBatchTransactionCount),
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionRateInfo(transactionRateInfo),
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchTransactionRateInfo(batchTransactionRateInfo),
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   healthMetricsReply(healthMetricsReply),
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   detailedHealthMetricsReply(detailedHealthMetricsReply),
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionTagCounter(transactionTagCounter),
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   clientThrottledTags(clientThrottledTags),
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   stats(stats),
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   proxyData(proxyData),
															#line 401 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   nextRequestTimer(Never()),
															#line 402 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   leaseTimeout(Never()),
															#line 403 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   reply(Never()),
															#line 404 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   lastDetailedReply(0.0),
															#line 405 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   expectingDetailedReply(false)
															#line 2354 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("getRate", reinterpret_cast<unsigned long>(this));

	}
	~GetRateActorState() 
	{
		fdb_probe_actor_destroy("getRate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 408 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (db->get().ratekeeper.present())
															#line 2369 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 409 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				nextRequestTimer = Void();
															#line 2373 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 410 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 2377 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetRateActorState();
		static_cast<GetRateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 411 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 410 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GetRateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2409 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 421 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = nextRequestTimer;
															#line 2413 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 435 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<GetRateInfoReply> __when_expr_2 = reply;
															#line 2417 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
															#line 462 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_3 = leaseTimeout;
															#line 2421 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
		static_cast<GetRateActor*>(this)->actor_wait_state = 1;
															#line 411 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetRateActor, 0, Void >*>(static_cast<GetRateActor*>(this)));
															#line 421 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetRateActor, 1, Void >*>(static_cast<GetRateActor*>(this)));
															#line 435 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetRateActor, 2, GetRateInfoReply >*>(static_cast<GetRateActor*>(this)));
															#line 462 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< GetRateActor, 3, Void >*>(static_cast<GetRateActor*>(this)));
															#line 2432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 412 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 2447 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 413 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperChanged", myID).detail("RKID", db->get().ratekeeper.get().id());
															#line 414 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 2453 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 416 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperDied", myID).log();
															#line 417 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 418 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply = Never();
															#line 2463 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 412 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().ratekeeper.present())
															#line 2473 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 413 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperChanged", myID).detail("RKID", db->get().ratekeeper.get().id());
															#line 414 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 2479 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 416 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("ProxyRatekeeperDied", myID).log();
															#line 417 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 418 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply = Never();
															#line 2489 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 422 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 423 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		bool detailed = now() - lastDetailedReply > SERVER_KNOBS->DETAILED_METRIC_UPDATE_RATE;
															#line 425 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		reply = brokenPromiseToNever( db->get().ratekeeper.get().getRateInfo.getReply(GetRateInfoRequest(myID, *inTransactionCount, *inBatchTransactionCount, proxyData->version, *transactionTagCounter, detailed)));
															#line 432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionTagCounter->clear();
															#line 433 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		expectingDetailedReply = detailed;
															#line 2507 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 422 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 423 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		bool detailed = now() - lastDetailedReply > SERVER_KNOBS->DETAILED_METRIC_UPDATE_RATE;
															#line 425 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		reply = brokenPromiseToNever( db->get().ratekeeper.get().getRateInfo.getReply(GetRateInfoRequest(myID, *inTransactionCount, *inBatchTransactionCount, proxyData->version, *transactionTagCounter, detailed)));
															#line 432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionTagCounter->clear();
															#line 433 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		expectingDetailedReply = detailed;
															#line 2524 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetRateInfoReply const& rep,int loopDepth) 
	{
															#line 436 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		reply = Never();
															#line 438 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionRateInfo->setRate(rep.transactionRate);
															#line 439 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionRateInfo->setRate(rep.batchTransactionRate);
															#line 440 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		stats->transactionRateAllowed = rep.transactionRate;
															#line 441 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		stats->batchTransactionRateAllowed = rep.batchTransactionRate;
															#line 442 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		++stats->updatesFromRatekeeper;
															#line 445 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		leaseTimeout = delay(rep.leaseDuration);
															#line 446 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = delayJittered(rep.leaseDuration / 2);
															#line 447 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		healthMetricsReply->update(rep.healthMetrics, expectingDetailedReply, true);
															#line 448 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (expectingDetailedReply)
															#line 2551 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 449 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			detailedHealthMetricsReply->update(rep.healthMetrics, true, true);
															#line 450 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			lastDetailedReply = now();
															#line 2557 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 455 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (rep.clientThrottledTags.present())
															#line 2561 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 456 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			*clientThrottledTags = std::move(rep.clientThrottledTags.get());
															#line 2565 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 458 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (rep.proxyThrottledTags.present())
															#line 2569 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 459 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			proxyData->tagThrottler.updateRates(rep.proxyThrottledTags.get());
															#line 2573 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetRateInfoReply && rep,int loopDepth) 
	{
															#line 436 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		reply = Never();
															#line 438 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionRateInfo->setRate(rep.transactionRate);
															#line 439 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionRateInfo->setRate(rep.batchTransactionRate);
															#line 440 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		stats->transactionRateAllowed = rep.transactionRate;
															#line 441 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		stats->batchTransactionRateAllowed = rep.batchTransactionRate;
															#line 442 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		++stats->updatesFromRatekeeper;
															#line 445 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		leaseTimeout = delay(rep.leaseDuration);
															#line 446 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = delayJittered(rep.leaseDuration / 2);
															#line 447 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		healthMetricsReply->update(rep.healthMetrics, expectingDetailedReply, true);
															#line 448 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (expectingDetailedReply)
															#line 2601 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 449 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			detailedHealthMetricsReply->update(rep.healthMetrics, true, true);
															#line 450 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			lastDetailedReply = now();
															#line 2607 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 455 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (rep.clientThrottledTags.present())
															#line 2611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 456 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			*clientThrottledTags = std::move(rep.clientThrottledTags.get());
															#line 2615 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 458 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (rep.proxyThrottledTags.present())
															#line 2619 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 459 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			proxyData->tagThrottler.updateRates(rep.proxyThrottledTags.get());
															#line 2623 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void const& _,int loopDepth) 
	{
															#line 463 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionRateInfo->disable();
															#line 464 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionRateInfo->disable();
															#line 465 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		++stats->leaseTimeouts;
															#line 466 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		TraceEvent(SevWarn, "GrvProxyRateLeaseExpired", myID).suppressFor(5.0);
															#line 468 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		leaseTimeout = Never();
															#line 2641 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void && _,int loopDepth) 
	{
															#line 463 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionRateInfo->disable();
															#line 464 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionRateInfo->disable();
															#line 465 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		++stats->leaseTimeouts;
															#line 466 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		TraceEvent(SevWarn, "GrvProxyRateLeaseExpired", myID).suppressFor(5.0);
															#line 468 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		leaseTimeout = Never();
															#line 2658 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetRateActor*>(this)->actor_wait_state > 0) static_cast<GetRateActor*>(this)->actor_wait_state = 0;
		static_cast<GetRateActor*>(this)->ActorCallback< GetRateActor, 0, Void >::remove();
		static_cast<GetRateActor*>(this)->ActorCallback< GetRateActor, 1, Void >::remove();
		static_cast<GetRateActor*>(this)->ActorCallback< GetRateActor, 2, GetRateInfoReply >::remove();
		static_cast<GetRateActor*>(this)->ActorCallback< GetRateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetRateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetRateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetRateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 2, GetRateInfoReply >*,GetRateInfoReply const& value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 2, GetRateInfoReply >*,GetRateInfoReply && value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetRateActor, 2, GetRateInfoReply >*,Error err) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< GetRateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< GetRateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	UID myID;
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t* inTransactionCount;
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t* inBatchTransactionCount;
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo* transactionRateInfo;
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo* batchTransactionRateInfo;
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* healthMetricsReply;
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* detailedHealthMetricsReply;
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	TransactionTagMap<uint64_t>* transactionTagCounter;
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PrioritizedTransactionTagMap<ClientTagThrottleLimits>* clientThrottledTags;
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyStats* stats;
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* proxyData;
															#line 401 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> nextRequestTimer;
															#line 402 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> leaseTimeout;
															#line 403 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<GetRateInfoReply> reply;
															#line 404 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double lastDetailedReply;
															#line 405 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	bool expectingDetailedReply;
															#line 2934 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via getRate()
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GetRateActor final : public Actor<Void>, public ActorCallback< GetRateActor, 0, Void >, public ActorCallback< GetRateActor, 1, Void >, public ActorCallback< GetRateActor, 2, GetRateInfoReply >, public ActorCallback< GetRateActor, 3, Void >, public FastAllocated<GetRateActor>, public GetRateActorState<GetRateActor> {
															#line 2939 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GetRateActor>::operator new;
	using FastAllocated<GetRateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14425935600368176640UL, 16277065140355546368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetRateActor, 0, Void >;
friend struct ActorCallback< GetRateActor, 1, Void >;
friend struct ActorCallback< GetRateActor, 2, GetRateInfoReply >;
friend struct ActorCallback< GetRateActor, 3, Void >;
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetRateActor(UID const& myID,Reference<AsyncVar<ServerDBInfo> const> const& db,int64_t* const& inTransactionCount,int64_t* const& inBatchTransactionCount,GrvTransactionRateInfo* const& transactionRateInfo,GrvTransactionRateInfo* const& batchTransactionRateInfo,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply,TransactionTagMap<uint64_t>* const& transactionTagCounter,PrioritizedTransactionTagMap<ClientTagThrottleLimits>* const& clientThrottledTags,GrvProxyStats* const& stats,GrvProxyData* const& proxyData) 
															#line 2959 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GetRateActorState<GetRateActor>(myID, db, inTransactionCount, inBatchTransactionCount, transactionRateInfo, batchTransactionRateInfo, healthMetricsReply, detailedHealthMetricsReply, transactionTagCounter, clientThrottledTags, stats, proxyData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getRate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3946064217190820608UL, 8787252396757706496UL);
		ActorExecutionContextHelper __helper(static_cast<GetRateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getRate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getRate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetRateActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> getRate( UID const& myID, Reference<AsyncVar<ServerDBInfo> const> const& db, int64_t* const& inTransactionCount, int64_t* const& inBatchTransactionCount, GrvTransactionRateInfo* const& transactionRateInfo, GrvTransactionRateInfo* const& batchTransactionRateInfo, GetHealthMetricsReply* const& healthMetricsReply, GetHealthMetricsReply* const& detailedHealthMetricsReply, TransactionTagMap<uint64_t>* const& transactionTagCounter, PrioritizedTransactionTagMap<ClientTagThrottleLimits>* const& clientThrottledTags, GrvProxyStats* const& stats, GrvProxyData* const& proxyData ) {
															#line 389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GetRateActor(myID, db, inTransactionCount, inBatchTransactionCount, transactionRateInfo, batchTransactionRateInfo, healthMetricsReply, detailedHealthMetricsReply, transactionTagCounter, clientThrottledTags, stats, proxyData));
															#line 2992 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 472 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Respond with an error to the GetReadVersion request when the GRV limit is hit.
void proxyGRVThresholdExceeded(const GetReadVersionRequest* req, GrvProxyStats* stats) {
	++stats->txnRequestErrors;
	req->reply.sendError(grv_proxy_memory_limit_exceeded());
	if (req->priority == TransactionPriority::IMMEDIATE) {
		TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyGRVThresholdExceededSystem")
		    .suppressFor(60);
	} else if (req->priority == TransactionPriority::DEFAULT) {
		TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyGRVThresholdExceededDefault")
		    .suppressFor(60);
	} else {
		TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "ProxyGRVThresholdExceededBatch")
		    .suppressFor(60);
	}
}

// Drop a GetReadVersion request from a queue, by responding an error to the request.
void dropRequestFromQueue(Deque<GetReadVersionRequest>* queue, GrvProxyStats* stats) {
	proxyGRVThresholdExceeded(&queue->front(), stats);
	++stats->txnRequestOut;
	queue->pop_front();
}

// Put a GetReadVersion request into the queue corresponding to its priority.
															#line 3021 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via queueGetReadVersionRequests()
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class QueueGetReadVersionRequestsActor>
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class QueueGetReadVersionRequestsActorState {
															#line 3028 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	QueueGetReadVersionRequestsActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,Deque<GetReadVersionRequest>* const& systemQueue,Deque<GetReadVersionRequest>* const& defaultQueue,Deque<GetReadVersionRequest>* const& batchQueue,FutureStream<GetReadVersionRequest> const& readVersionRequests,PromiseStream<Void> const& GRVTimer,double* const& lastGRVTime,double* const& GRVBatchTime,FutureStream<double> const& normalGRVLatency,GrvProxyStats* const& stats,GrvTransactionRateInfo* const& batchRateInfo,GrvProxyTagThrottler* const& tagThrottler) 
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : db(db),
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   systemQueue(systemQueue),
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   defaultQueue(defaultQueue),
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchQueue(batchQueue),
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   readVersionRequests(readVersionRequests),
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   GRVTimer(GRVTimer),
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   lastGRVTime(lastGRVTime),
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   GRVBatchTime(GRVBatchTime),
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   normalGRVLatency(normalGRVLatency),
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   stats(stats),
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchRateInfo(batchRateInfo),
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   tagThrottler(tagThrottler)
															#line 3057 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this));

	}
	~QueueGetReadVersionRequestsActorState() 
	{
		fdb_probe_actor_destroy("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 509 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::operation) = TransactionLineage::Operation::GetConsistentReadVersion;
															#line 511 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 3074 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~QueueGetReadVersionRequestsActorState();
		static_cast<QueueGetReadVersionRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 512 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		auto __when_expr_0 = readVersionRequests;
															#line 3104 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<GetReadVersionRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<GetReadVersionRequest>>::value, "invalid type");
															#line 511 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<QueueGetReadVersionRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3108 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
															#line 600 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		auto __when_expr_1 = normalGRVLatency;
															#line 3112 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<double>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<double>>::value, "invalid type");
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.pop(), loopDepth); };
		static_cast<QueueGetReadVersionRequestsActor*>(this)->actor_wait_state = 1;
															#line 512 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*>(static_cast<QueueGetReadVersionRequestsActor*>(this)));
															#line 600 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >*>(static_cast<QueueGetReadVersionRequestsActor*>(this)));
															#line 3120 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetReadVersionRequest const& req,int loopDepth) 
	{
															#line 516 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		bool canBeQueued = true;
															#line 517 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (stats->txnRequestIn.getValue() - stats->txnRequestOut.getValue() > SERVER_KNOBS->START_TRANSACTION_MAX_QUEUE_SIZE || (g_network->isSimulated() && !g_simulator->speedUpSimulation && deterministicRandom()->random01() < 0.01))
															#line 3137 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 522 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority == TransactionPriority::BATCH)
															#line 3141 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 523 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				canBeQueued = false;
															#line 3145 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 524 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority == TransactionPriority::DEFAULT)
															#line 3151 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 525 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue->empty())
															#line 3155 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 526 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						dropRequestFromQueue(batchQueue, stats);
															#line 527 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						--stats->batchGRVQueueSize;
															#line 3161 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 529 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						canBeQueued = false;
															#line 3167 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					}
				}
				else
				{
															#line 532 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue->empty())
															#line 3174 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 533 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						dropRequestFromQueue(batchQueue, stats);
															#line 534 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						--stats->batchGRVQueueSize;
															#line 3180 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 535 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (!defaultQueue->empty())
															#line 3186 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 536 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							dropRequestFromQueue(defaultQueue, stats);
															#line 537 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							--stats->defaultGRVQueueSize;
															#line 3192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						}
						else
						{
															#line 539 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							canBeQueued = false;
															#line 3198 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
		}
															#line 543 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!canBeQueued)
															#line 3206 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 544 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			proxyGRVThresholdExceeded(&req, stats);
															#line 3210 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 546 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			stats->addRequest(req.transactionCount);
															#line 548 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.debugID.present())
															#line 3218 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 549 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", req.debugID.get().first(), "GrvProxyServer.queueTransactionStartRequests.Before");
															#line 3222 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 553 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (systemQueue->empty() && defaultQueue->empty() && batchQueue->empty())
															#line 3226 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 554 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				forwardPromise(GRVTimer, delayJittered(std::max(0.0, *GRVBatchTime - (now() - *lastGRVTime)), TaskPriority::ProxyGRVTimer));
															#line 3230 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 559 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority >= TransactionPriority::IMMEDIATE)
															#line 3234 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 560 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				++stats->txnRequestIn;
															#line 561 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->txnStartIn += req.transactionCount;
															#line 562 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->txnSystemPriorityStartIn += req.transactionCount;
															#line 563 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				++stats->systemGRVQueueSize;
															#line 564 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				systemQueue->push_back(req);
															#line 3246 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 565 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority >= TransactionPriority::DEFAULT)
															#line 3252 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 566 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (SERVER_KNOBS->ENFORCE_TAG_THROTTLING_ON_PROXIES && req.isTagged())
															#line 3256 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 567 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->tagThrottlerGRVQueueSize;
															#line 568 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnTagThrottlerIn += req.transactionCount;
															#line 569 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						tagThrottler->addRequest(req);
															#line 3264 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 571 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->txnRequestIn;
															#line 572 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnStartIn += req.transactionCount;
															#line 573 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnDefaultPriorityStartIn += req.transactionCount;
															#line 574 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->defaultGRVQueueSize;
															#line 575 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						defaultQueue->push_back(req);
															#line 3278 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					}
				}
				else
				{
															#line 579 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					int64_t proxiesCount = std::max((int)db->get().client.grvProxies.size(), 1);
															#line 580 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (batchRateInfo->getRate() <= (1.0 / proxiesCount))
															#line 3287 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 581 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						req.reply.sendError(batch_transaction_throttled());
															#line 582 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnThrottled += req.transactionCount;
															#line 3293 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 584 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (SERVER_KNOBS->ENFORCE_TAG_THROTTLING_ON_PROXIES && req.isTagged())
															#line 3299 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 585 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->tagThrottlerGRVQueueSize;
															#line 586 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnTagThrottlerIn += req.transactionCount;
															#line 587 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							tagThrottler->addRequest(req);
															#line 3307 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						}
						else
						{
															#line 589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->txnRequestIn;
															#line 590 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnStartIn += req.transactionCount;
															#line 591 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnBatchPriorityStartIn += req.transactionCount;
															#line 592 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->batchGRVQueueSize;
															#line 593 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							batchQueue->push_back(req);
															#line 3321 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(GetReadVersionRequest && req,int loopDepth) 
	{
															#line 516 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		bool canBeQueued = true;
															#line 517 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (stats->txnRequestIn.getValue() - stats->txnRequestOut.getValue() > SERVER_KNOBS->START_TRANSACTION_MAX_QUEUE_SIZE || (g_network->isSimulated() && !g_simulator->speedUpSimulation && deterministicRandom()->random01() < 0.01))
															#line 3337 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 522 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority == TransactionPriority::BATCH)
															#line 3341 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 523 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				canBeQueued = false;
															#line 3345 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 524 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority == TransactionPriority::DEFAULT)
															#line 3351 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 525 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue->empty())
															#line 3355 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 526 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						dropRequestFromQueue(batchQueue, stats);
															#line 527 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						--stats->batchGRVQueueSize;
															#line 3361 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 529 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						canBeQueued = false;
															#line 3367 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					}
				}
				else
				{
															#line 532 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue->empty())
															#line 3374 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 533 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						dropRequestFromQueue(batchQueue, stats);
															#line 534 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						--stats->batchGRVQueueSize;
															#line 3380 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 535 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (!defaultQueue->empty())
															#line 3386 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 536 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							dropRequestFromQueue(defaultQueue, stats);
															#line 537 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							--stats->defaultGRVQueueSize;
															#line 3392 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						}
						else
						{
															#line 539 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							canBeQueued = false;
															#line 3398 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
		}
															#line 543 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!canBeQueued)
															#line 3406 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 544 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			proxyGRVThresholdExceeded(&req, stats);
															#line 3410 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 546 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			stats->addRequest(req.transactionCount);
															#line 548 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.debugID.present())
															#line 3418 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 549 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				g_traceBatch.addEvent("TransactionDebug", req.debugID.get().first(), "GrvProxyServer.queueTransactionStartRequests.Before");
															#line 3422 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 553 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (systemQueue->empty() && defaultQueue->empty() && batchQueue->empty())
															#line 3426 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 554 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				forwardPromise(GRVTimer, delayJittered(std::max(0.0, *GRVBatchTime - (now() - *lastGRVTime)), TaskPriority::ProxyGRVTimer));
															#line 3430 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 559 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority >= TransactionPriority::IMMEDIATE)
															#line 3434 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 560 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				++stats->txnRequestIn;
															#line 561 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->txnStartIn += req.transactionCount;
															#line 562 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->txnSystemPriorityStartIn += req.transactionCount;
															#line 563 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				++stats->systemGRVQueueSize;
															#line 564 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				systemQueue->push_back(req);
															#line 3446 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 565 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority >= TransactionPriority::DEFAULT)
															#line 3452 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 566 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (SERVER_KNOBS->ENFORCE_TAG_THROTTLING_ON_PROXIES && req.isTagged())
															#line 3456 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 567 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->tagThrottlerGRVQueueSize;
															#line 568 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnTagThrottlerIn += req.transactionCount;
															#line 569 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						tagThrottler->addRequest(req);
															#line 3464 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 571 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->txnRequestIn;
															#line 572 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnStartIn += req.transactionCount;
															#line 573 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnDefaultPriorityStartIn += req.transactionCount;
															#line 574 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						++stats->defaultGRVQueueSize;
															#line 575 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						defaultQueue->push_back(req);
															#line 3478 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					}
				}
				else
				{
															#line 579 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					int64_t proxiesCount = std::max((int)db->get().client.grvProxies.size(), 1);
															#line 580 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (batchRateInfo->getRate() <= (1.0 / proxiesCount))
															#line 3487 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 581 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						req.reply.sendError(batch_transaction_throttled());
															#line 582 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						stats->txnThrottled += req.transactionCount;
															#line 3493 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
															#line 584 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (SERVER_KNOBS->ENFORCE_TAG_THROTTLING_ON_PROXIES && req.isTagged())
															#line 3499 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 585 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->tagThrottlerGRVQueueSize;
															#line 586 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnTagThrottlerIn += req.transactionCount;
															#line 587 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							tagThrottler->addRequest(req);
															#line 3507 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						}
						else
						{
															#line 589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->txnRequestIn;
															#line 590 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnStartIn += req.transactionCount;
															#line 591 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							stats->txnBatchPriorityStartIn += req.transactionCount;
															#line 592 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							++stats->batchGRVQueueSize;
															#line 593 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							batchQueue->push_back(req);
															#line 3521 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(double const& reply_latency,int loopDepth) 
	{
															#line 601 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double target_latency = reply_latency * SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_LATENCY_FRACTION;
															#line 602 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*GRVBatchTime = std::max( SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MIN, std::min(SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MAX, target_latency * SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA + *GRVBatchTime * (1 - SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA)));
															#line 3537 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(double && reply_latency,int loopDepth) 
	{
															#line 601 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double target_latency = reply_latency * SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_LATENCY_FRACTION;
															#line 602 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*GRVBatchTime = std::max( SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MIN, std::min(SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MAX, target_latency * SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA + *GRVBatchTime * (1 - SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_SMOOTHER_ALPHA)));
															#line 3548 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<QueueGetReadVersionRequestsActor*>(this)->actor_wait_state > 0) static_cast<QueueGetReadVersionRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<QueueGetReadVersionRequestsActor*>(this)->ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >::remove();
		static_cast<QueueGetReadVersionRequestsActor*>(this)->ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >::remove();

	}
	void a_callback_fire(ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*,GetReadVersionRequest const& value) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*,GetReadVersionRequest && value) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*,Error err) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >*,double const& value) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >*,double && value) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >*,Error err) 
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest>* systemQueue;
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest>* defaultQueue;
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest>* batchQueue;
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	FutureStream<GetReadVersionRequest> readVersionRequests;
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Void> GRVTimer;
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double* lastGRVTime;
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double* GRVBatchTime;
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	FutureStream<double> normalGRVLatency;
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyStats* stats;
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo* batchRateInfo;
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyTagThrottler* tagThrottler;
															#line 3698 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via queueGetReadVersionRequests()
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class QueueGetReadVersionRequestsActor final : public Actor<Void>, public ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >, public ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >, public FastAllocated<QueueGetReadVersionRequestsActor>, public QueueGetReadVersionRequestsActorState<QueueGetReadVersionRequestsActor> {
															#line 3703 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<QueueGetReadVersionRequestsActor>::operator new;
	using FastAllocated<QueueGetReadVersionRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6225131914823848704UL, 15857635572841669376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >;
friend struct ActorSingleCallback< QueueGetReadVersionRequestsActor, 1, double >;
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	QueueGetReadVersionRequestsActor(Reference<AsyncVar<ServerDBInfo> const> const& db,Deque<GetReadVersionRequest>* const& systemQueue,Deque<GetReadVersionRequest>* const& defaultQueue,Deque<GetReadVersionRequest>* const& batchQueue,FutureStream<GetReadVersionRequest> const& readVersionRequests,PromiseStream<Void> const& GRVTimer,double* const& lastGRVTime,double* const& GRVBatchTime,FutureStream<double> const& normalGRVLatency,GrvProxyStats* const& stats,GrvTransactionRateInfo* const& batchRateInfo,GrvProxyTagThrottler* const& tagThrottler) 
															#line 3721 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   QueueGetReadVersionRequestsActorState<QueueGetReadVersionRequestsActor>(db, systemQueue, defaultQueue, batchQueue, readVersionRequests, GRVTimer, lastGRVTime, GRVBatchTime, normalGRVLatency, stats, batchRateInfo, tagThrottler),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16228072202774818048UL, 4568169853275226880UL);
		ActorExecutionContextHelper __helper(static_cast<QueueGetReadVersionRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("queueGetReadVersionRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("queueGetReadVersionRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< QueueGetReadVersionRequestsActor, 0, GetReadVersionRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> queueGetReadVersionRequests( Reference<AsyncVar<ServerDBInfo> const> const& db, Deque<GetReadVersionRequest>* const& systemQueue, Deque<GetReadVersionRequest>* const& defaultQueue, Deque<GetReadVersionRequest>* const& batchQueue, FutureStream<GetReadVersionRequest> const& readVersionRequests, PromiseStream<Void> const& GRVTimer, double* const& lastGRVTime, double* const& GRVBatchTime, FutureStream<double> const& normalGRVLatency, GrvProxyStats* const& stats, GrvTransactionRateInfo* const& batchRateInfo, GrvProxyTagThrottler* const& tagThrottler ) {
															#line 497 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new QueueGetReadVersionRequestsActor(db, systemQueue, defaultQueue, batchQueue, readVersionRequests, GRVTimer, lastGRVTime, GRVBatchTime, normalGRVLatency, stats, batchRateInfo, tagThrottler));
															#line 3754 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 610 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 3759 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via updateLastCommit()
															#line 611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class UpdateLastCommitActor>
															#line 611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class UpdateLastCommitActorState {
															#line 3766 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	UpdateLastCommitActorState(GrvProxyData* const& self,Optional<UID> const& debugID = Optional<UID>()) 
															#line 611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : self(self),
															#line 611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   debugID(debugID),
															#line 612 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   confirmStart(now())
															#line 3777 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("updateLastCommit", reinterpret_cast<unsigned long>(this));

	}
	~UpdateLastCommitActorState() 
	{
		fdb_probe_actor_destroy("updateLastCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 613 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			self->lastStartCommit = confirmStart;
															#line 614 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			self->updateCommitRequests++;
															#line 615 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->logSystem->confirmEpochLive(debugID);
															#line 615 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<UpdateLastCommitActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3798 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UpdateLastCommitActor*>(this)->actor_wait_state = 1;
															#line 615 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateLastCommitActor, 0, Void >*>(static_cast<UpdateLastCommitActor*>(this)));
															#line 3803 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateLastCommitActorState();
		static_cast<UpdateLastCommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 616 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->updateCommitRequests--;
															#line 617 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->lastCommitLatency = now() - confirmStart;
															#line 618 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->lastCommitTime = std::max(self->lastCommitTime.get(), confirmStart);
															#line 619 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<UpdateLastCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLastCommitActorState(); static_cast<UpdateLastCommitActor*>(this)->destroy(); return 0; }
															#line 3832 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<UpdateLastCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLastCommitActorState();
		static_cast<UpdateLastCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 616 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->updateCommitRequests--;
															#line 617 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->lastCommitLatency = now() - confirmStart;
															#line 618 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		self->lastCommitTime = std::max(self->lastCommitTime.get(), confirmStart);
															#line 619 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<UpdateLastCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateLastCommitActorState(); static_cast<UpdateLastCommitActor*>(this)->destroy(); return 0; }
															#line 3850 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<UpdateLastCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateLastCommitActorState();
		static_cast<UpdateLastCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateLastCommitActor*>(this)->actor_wait_state > 0) static_cast<UpdateLastCommitActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateLastCommitActor*>(this)->ActorCallback< UpdateLastCommitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateLastCommitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateLastCommitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateLastCommitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateLastCommit", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* self;
															#line 611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<UID> debugID;
															#line 612 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double confirmStart;
															#line 3939 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via updateLastCommit()
															#line 611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class UpdateLastCommitActor final : public Actor<Void>, public ActorCallback< UpdateLastCommitActor, 0, Void >, public FastAllocated<UpdateLastCommitActor>, public UpdateLastCommitActorState<UpdateLastCommitActor> {
															#line 3944 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<UpdateLastCommitActor>::operator new;
	using FastAllocated<UpdateLastCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10918197081729688320UL, 4097694382758733056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateLastCommitActor, 0, Void >;
															#line 611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	UpdateLastCommitActor(GrvProxyData* const& self,Optional<UID> const& debugID = Optional<UID>()) 
															#line 3961 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateLastCommitActorState<UpdateLastCommitActor>(self, debugID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateLastCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6267630262008360960UL, 2835741678179808768UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateLastCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateLastCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateLastCommit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateLastCommitActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> updateLastCommit( GrvProxyData* const& self, Optional<UID> const& debugID = Optional<UID>() ) {
															#line 611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new UpdateLastCommitActor(self, debugID));
															#line 3994 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 621 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 3999 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via lastCommitUpdater()
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class LastCommitUpdaterActor>
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class LastCommitUpdaterActorState {
															#line 4006 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	LastCommitUpdaterActorState(GrvProxyData* const& self,PromiseStream<Future<Void>> const& addActor) 
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : self(self),
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   addActor(addActor)
															#line 4015 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("lastCommitUpdater", reinterpret_cast<unsigned long>(this));

	}
	~LastCommitUpdaterActorState() 
	{
		fdb_probe_actor_destroy("lastCommitUpdater", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 623 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 4030 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LastCommitUpdaterActorState();
		static_cast<LastCommitUpdaterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 624 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double interval = std::max(SERVER_KNOBS->MIN_CONFIRM_INTERVAL, (SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION - self->lastCommitLatency) / 2.0);
															#line 626 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double elapsed = now() - self->lastStartCommit;
															#line 627 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (elapsed < interval)
															#line 4064 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 628 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(interval + 0.0001 - elapsed);
															#line 628 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<LastCommitUpdaterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4070 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LastCommitUpdaterActor*>(this)->actor_wait_state = 1;
															#line 628 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LastCommitUpdaterActor, 0, Void >*>(static_cast<LastCommitUpdaterActor*>(this)));
															#line 4075 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 631 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (self->updateCommitRequests < SERVER_KNOBS->MAX_COMMIT_UPDATES)
															#line 4082 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 632 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				addActor.send(updateLastCommit(self));
															#line 4086 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 634 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				TraceEvent(g_network->isSimulated() ? SevInfo : SevWarnAlways, "TooManyLastCommitUpdates") .suppressFor(1.0);
															#line 636 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				self->lastStartCommit = now();
															#line 4094 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LastCommitUpdaterActor*>(this)->actor_wait_state > 0) static_cast<LastCommitUpdaterActor*>(this)->actor_wait_state = 0;
		static_cast<LastCommitUpdaterActor*>(this)->ActorCallback< LastCommitUpdaterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LastCommitUpdaterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LastCommitUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LastCommitUpdaterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LastCommitUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LastCommitUpdaterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LastCommitUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastCommitUpdater", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* self;
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 4198 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via lastCommitUpdater()
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class LastCommitUpdaterActor final : public Actor<Void>, public ActorCallback< LastCommitUpdaterActor, 0, Void >, public FastAllocated<LastCommitUpdaterActor>, public LastCommitUpdaterActorState<LastCommitUpdaterActor> {
															#line 4203 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<LastCommitUpdaterActor>::operator new;
	using FastAllocated<LastCommitUpdaterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4756608674189728000UL, 5706930098325498624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LastCommitUpdaterActor, 0, Void >;
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	LastCommitUpdaterActor(GrvProxyData* const& self,PromiseStream<Future<Void>> const& addActor) 
															#line 4220 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   LastCommitUpdaterActorState<LastCommitUpdaterActor>(self, addActor),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lastCommitUpdater", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5278625381336097792UL, 45007184844760832UL);
		ActorExecutionContextHelper __helper(static_cast<LastCommitUpdaterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lastCommitUpdater");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lastCommitUpdater", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LastCommitUpdaterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> lastCommitUpdater( GrvProxyData* const& self, PromiseStream<Future<Void>> const& addActor ) {
															#line 622 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new LastCommitUpdaterActor(self, addActor));
															#line 4253 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 641 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 4258 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via getLiveCommittedVersion()
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GetLiveCommittedVersionActor>
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GetLiveCommittedVersionActorState {
															#line 4265 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetLiveCommittedVersionActorState(std::vector<SpanContext> const& spanContexts,GrvProxyData* const& grvProxyData,uint32_t const& flags,Optional<UID> const& debugID,int const& transactionCount,int const& systemTransactionCount,int const& defaultPriTransactionCount,int const& batchPriTransactionCount) 
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : spanContexts(spanContexts),
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxyData(grvProxyData),
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   flags(flags),
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   debugID(debugID),
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionCount(transactionCount),
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   systemTransactionCount(systemTransactionCount),
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   defaultPriTransactionCount(defaultPriTransactionCount),
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchPriTransactionCount(batchPriTransactionCount),
															#line 655 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   span("GP:getLiveCommittedVersion"_loc)
															#line 4288 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetLiveCommittedVersionActorState() 
	{
		fdb_probe_actor_destroy("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 656 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			for( const SpanContext& spanContext : spanContexts ) {
															#line 657 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				span.addLink(spanContext);
															#line 4305 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 659 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			++grvProxyData->stats.txnStartBatch;
															#line 661 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvStart = now();
															#line 662 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			replyFromMasterFuture = Future<GetRawCommittedVersionReply>();
															#line 663 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			replyFromMasterFuture = grvProxyData->master.getLiveCommittedVersion.getReply( GetRawCommittedVersionRequest(span.context, debugID, grvProxyData->ssVersionVectorCache.getMaxVersion()), TaskPriority::GetLiveCommittedVersionReply);
															#line 667 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!SERVER_KNOBS->ALWAYS_CAUSAL_READ_RISKY && !(flags & GetReadVersionRequest::FLAG_CAUSAL_READ_RISKY))
															#line 4317 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 668 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = transformError(updateLastCommit(grvProxyData, debugID), broken_promise(), tlog_failed());
															#line 668 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4323 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 1;
															#line 668 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLiveCommittedVersionActor, 0, Void >*>(static_cast<GetLiveCommittedVersionActor*>(this)));
															#line 4328 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 669 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION > 0 && now() - SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION > grvProxyData->lastCommitTime.get())
															#line 4335 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 671 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					StrictFuture<Void> __when_expr_1 = grvProxyData->lastCommitTime.whenAtLeast(now() - SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION);
															#line 671 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4341 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
					static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 2;
															#line 671 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetLiveCommittedVersionActor, 1, Void >*>(static_cast<GetLiveCommittedVersionActor*>(this)));
															#line 4346 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont4(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLiveCommittedVersionActorState();
		static_cast<GetLiveCommittedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 674 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvConfirmEpochLive = now();
															#line 675 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.grvConfirmEpochLiveDist->sampleSeconds(grvConfirmEpochLive - grvStart);
															#line 676 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 4379 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 677 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "GrvProxyServer.getLiveCommittedVersion.confirmEpochLive");
															#line 4383 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 681 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<GetRawCommittedVersionReply> __when_expr_2 = transformError(replyFromMasterFuture, broken_promise(), master_failed());
															#line 681 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4389 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 3;
															#line 681 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*>(static_cast<GetLiveCommittedVersionActor*>(this)));
															#line 4394 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLiveCommittedVersionActor*>(this)->ActorCallback< GetLiveCommittedVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLiveCommittedVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLiveCommittedVersionActor*>(this)->ActorCallback< GetLiveCommittedVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetLiveCommittedVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(GetRawCommittedVersionReply const& repFromMaster,int loopDepth) 
	{
															#line 683 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->version = std::max(grvProxyData->version, repFromMaster.version);
															#line 684 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->minKnownCommittedVersion = std::max(grvProxyData->minKnownCommittedVersion, repFromMaster.minKnownCommittedVersion);
															#line 686 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 4587 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 688 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->ssVersionVectorCache.applyDelta(repFromMaster.ssVersionVectorDelta);
															#line 4591 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 690 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.grvGetCommittedVersionRpcDist->sampleSeconds(now() - grvConfirmEpochLive);
															#line 691 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		GetReadVersionReply rep;
															#line 692 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.version = repFromMaster.version;
															#line 693 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.locked = repFromMaster.locked;
															#line 694 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.metadataVersion = repFromMaster.metadataVersion;
															#line 695 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.processBusyTime = FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION * std::min((std::numeric_limits<int>::max() / FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION) - 1, grvProxyData->stats.getRecentRequests());
															#line 699 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.processBusyTime += FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION * (g_network->isSimulated() ? deterministicRandom()->random01() : g_network->networkInfo.metrics.lastRunLoopBusyness);
															#line 703 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 4609 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 704 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "GrvProxyServer.getLiveCommittedVersion.After");
															#line 4613 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 708 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnStartOut += transactionCount;
															#line 709 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnSystemPriorityStartOut += systemTransactionCount;
															#line 710 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnDefaultPriorityStartOut += defaultPriTransactionCount;
															#line 711 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnBatchPriorityStartOut += batchPriTransactionCount;
															#line 713 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GetLiveCommittedVersionActor*>(this)->SAV<GetReadVersionReply>::futures) { (void)(rep); this->~GetLiveCommittedVersionActorState(); static_cast<GetLiveCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 4625 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GetLiveCommittedVersionActor*>(this)->SAV< GetReadVersionReply >::value()) GetReadVersionReply(rep);
		this->~GetLiveCommittedVersionActorState();
		static_cast<GetLiveCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(GetRawCommittedVersionReply && repFromMaster,int loopDepth) 
	{
															#line 683 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->version = std::max(grvProxyData->version, repFromMaster.version);
															#line 684 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->minKnownCommittedVersion = std::max(grvProxyData->minKnownCommittedVersion, repFromMaster.minKnownCommittedVersion);
															#line 686 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 4641 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 688 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->ssVersionVectorCache.applyDelta(repFromMaster.ssVersionVectorDelta);
															#line 4645 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 690 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.grvGetCommittedVersionRpcDist->sampleSeconds(now() - grvConfirmEpochLive);
															#line 691 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		GetReadVersionReply rep;
															#line 692 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.version = repFromMaster.version;
															#line 693 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.locked = repFromMaster.locked;
															#line 694 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.metadataVersion = repFromMaster.metadataVersion;
															#line 695 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.processBusyTime = FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION * std::min((std::numeric_limits<int>::max() / FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION) - 1, grvProxyData->stats.getRecentRequests());
															#line 699 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		rep.processBusyTime += FLOW_KNOBS->BASIC_LOAD_BALANCE_COMPUTE_PRECISION * (g_network->isSimulated() ? deterministicRandom()->random01() : g_network->networkInfo.metrics.lastRunLoopBusyness);
															#line 703 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 4663 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 704 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent( "TransactionDebug", debugID.get().first(), "GrvProxyServer.getLiveCommittedVersion.After");
															#line 4667 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 708 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnStartOut += transactionCount;
															#line 709 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnSystemPriorityStartOut += systemTransactionCount;
															#line 710 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnDefaultPriorityStartOut += defaultPriTransactionCount;
															#line 711 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.txnBatchPriorityStartOut += batchPriTransactionCount;
															#line 713 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GetLiveCommittedVersionActor*>(this)->SAV<GetReadVersionReply>::futures) { (void)(rep); this->~GetLiveCommittedVersionActorState(); static_cast<GetLiveCommittedVersionActor*>(this)->destroy(); return 0; }
															#line 4679 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GetLiveCommittedVersionActor*>(this)->SAV< GetReadVersionReply >::value()) GetReadVersionReply(rep);
		this->~GetLiveCommittedVersionActorState();
		static_cast<GetLiveCommittedVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(GetRawCommittedVersionReply const& repFromMaster,int loopDepth) 
	{
		loopDepth = a_body1cont6(repFromMaster, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(GetRawCommittedVersionReply && repFromMaster,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(repFromMaster), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state > 0) static_cast<GetLiveCommittedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetLiveCommittedVersionActor*>(this)->ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*,GetRawCommittedVersionReply const& value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*,GetRawCommittedVersionReply && value) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	std::vector<SpanContext> spanContexts;
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	uint32_t flags;
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Optional<UID> debugID;
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int transactionCount;
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int systemTransactionCount;
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int defaultPriTransactionCount;
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int batchPriTransactionCount;
															#line 655 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Span span;
															#line 661 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double grvStart;
															#line 662 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<GetRawCommittedVersionReply> replyFromMasterFuture;
															#line 674 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double grvConfirmEpochLive;
															#line 4786 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via getLiveCommittedVersion()
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GetLiveCommittedVersionActor final : public Actor<GetReadVersionReply>, public ActorCallback< GetLiveCommittedVersionActor, 0, Void >, public ActorCallback< GetLiveCommittedVersionActor, 1, Void >, public ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >, public FastAllocated<GetLiveCommittedVersionActor>, public GetLiveCommittedVersionActorState<GetLiveCommittedVersionActor> {
															#line 4791 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GetLiveCommittedVersionActor>::operator new;
	using FastAllocated<GetLiveCommittedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14156105633309669376UL, 7035641441222481664UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<GetReadVersionReply>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLiveCommittedVersionActor, 0, Void >;
friend struct ActorCallback< GetLiveCommittedVersionActor, 1, Void >;
friend struct ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >;
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetLiveCommittedVersionActor(std::vector<SpanContext> const& spanContexts,GrvProxyData* const& grvProxyData,uint32_t const& flags,Optional<UID> const& debugID,int const& transactionCount,int const& systemTransactionCount,int const& defaultPriTransactionCount,int const& batchPriTransactionCount) 
															#line 4810 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<GetReadVersionReply>(),
		   GetLiveCommittedVersionActorState<GetLiveCommittedVersionActor>(spanContexts, grvProxyData, flags, debugID, transactionCount, systemTransactionCount, defaultPriTransactionCount, batchPriTransactionCount),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2565788491578482432UL, 13699237086852491520UL);
		ActorExecutionContextHelper __helper(static_cast<GetLiveCommittedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLiveCommittedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLiveCommittedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLiveCommittedVersionActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetLiveCommittedVersionActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetLiveCommittedVersionActor, 2, GetRawCommittedVersionReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<GetReadVersionReply> getLiveCommittedVersion( std::vector<SpanContext> const& spanContexts, GrvProxyData* const& grvProxyData, uint32_t const& flags, Optional<UID> const& debugID, int const& transactionCount, int const& systemTransactionCount, int const& defaultPriTransactionCount, int const& batchPriTransactionCount ) {
															#line 642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<GetReadVersionReply>(new GetLiveCommittedVersionActor(spanContexts, grvProxyData, flags, debugID, transactionCount, systemTransactionCount, defaultPriTransactionCount, batchPriTransactionCount));
															#line 4845 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 715 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

// Returns the current read version (or minimum known committed version if requested),
// to each request in the provided list. Also check if the request should be throttled.
// Update GRV statistics according to the request's priority.
															#line 4853 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via sendGrvReplies()
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class SendGrvRepliesActor>
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class SendGrvRepliesActorState {
															#line 4860 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	SendGrvRepliesActorState(Future<GetReadVersionReply> const& replyFuture,std::vector<GetReadVersionRequest> const& requests,GrvProxyData* const& grvProxyData,GrvProxyStats* const& stats,Version const& minKnownCommittedVersion,PrioritizedTransactionTagMap<ClientTagThrottleLimits> const& clientThrottledTags,int64_t const& midShardSize = 0) 
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : replyFuture(replyFuture),
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   requests(requests),
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxyData(grvProxyData),
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   stats(stats),
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   minKnownCommittedVersion(minKnownCommittedVersion),
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   clientThrottledTags(clientThrottledTags),
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   midShardSize(midShardSize)
															#line 4879 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("sendGrvReplies", reinterpret_cast<unsigned long>(this));

	}
	~SendGrvRepliesActorState() 
	{
		fdb_probe_actor_destroy("sendGrvReplies", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 726 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<GetReadVersionReply> __when_expr_0 = replyFuture;
															#line 726 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<SendGrvRepliesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4896 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SendGrvRepliesActor*>(this)->actor_wait_state = 1;
															#line 726 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*>(static_cast<SendGrvRepliesActor*>(this)));
															#line 4901 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SendGrvRepliesActorState();
		static_cast<SendGrvRepliesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(GetReadVersionReply const& _reply,int loopDepth) 
	{
															#line 727 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		GetReadVersionReply reply = _reply;
															#line 728 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		Version replyVersion = reply.version;
															#line 730 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double end = g_network->timer();
															#line 731 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for( GetReadVersionRequest const& request : requests ) {
															#line 732 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			double duration = end - request.requestTime() - request.proxyTagThrottledDuration;
															#line 733 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority == TransactionPriority::BATCH)
															#line 4934 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 734 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvBatchLatencySample.addMeasurement(duration);
															#line 4938 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 737 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority == TransactionPriority::DEFAULT)
															#line 4942 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 738 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvLatencySample.addMeasurement(duration);
															#line 4946 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 741 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority >= TransactionPriority::DEFAULT)
															#line 4950 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 742 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvLatencyBands.addMeasurement(duration);
															#line 4954 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 745 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.flags & GetReadVersionRequest::FLAG_USE_MIN_KNOWN_COMMITTED_VERSION)
															#line 4958 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 747 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				reply.version = minKnownCommittedVersion;
															#line 4962 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 749 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				reply.version = replyVersion;
															#line 4968 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 751 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.midShardSize = midShardSize;
															#line 752 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.tagThrottleInfo.clear();
															#line 753 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 4976 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 754 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->ssVersionVectorCache.getDelta(request.maxVersion, reply.ssVersionVectorDelta);
															#line 755 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->versionVectorSizeOnGRVReply->addMeasurement(reply.ssVersionVectorDelta.size());
															#line 4982 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 757 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.proxyId = grvProxyData->dbgid;
															#line 758 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.proxyTagThrottledDuration = request.proxyTagThrottledDuration;
															#line 760 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.isTagged())
															#line 4990 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 761 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				auto& priorityThrottledTags = clientThrottledTags[request.priority];
															#line 762 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				for( auto tag : request.tags ) {
															#line 763 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					auto tagItr = priorityThrottledTags.find(tag.first);
															#line 764 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (tagItr != priorityThrottledTags.end())
															#line 5000 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 765 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (tagItr->second.expiration > now())
															#line 5004 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 766 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							if (tagItr->second.tpsRate == std::numeric_limits<double>::max())
															#line 5008 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
							{
															#line 767 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								CODE_PROBE(true, "Auto TPS rate is unlimited");
															#line 5012 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
							}
							else
							{
															#line 769 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								CODE_PROBE(true, "GRV proxy returning tag throttle");
															#line 770 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								reply.tagThrottleInfo[tag.first] = tagItr->second;
															#line 5020 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
							}
						}
						else
						{
															#line 774 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							CODE_PROBE(true, "GRV proxy expiring tag throttle");
															#line 775 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							priorityThrottledTags.erase(tagItr);
															#line 5029 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
															#line 781 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (stats->lastBatchQueueThrottled)
															#line 5036 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 783 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (now() - stats->batchThrottleStartTime > CLIENT_KNOBS->GRV_SUSTAINED_THROTTLING_THRESHOLD)
															#line 5040 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 784 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkBatchThrottled = true;
															#line 5044 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 787 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (stats->lastDefaultQueueThrottled)
															#line 5049 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 789 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (now() - stats->defaultThrottleStartTime > CLIENT_KNOBS->GRV_SUSTAINED_THROTTLING_THRESHOLD)
															#line 5053 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 793 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkBatchThrottled = true;
															#line 794 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkDefaultThrottled = true;
															#line 5059 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 797 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			request.reply.send(reply);
															#line 798 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			++stats->txnRequestOut;
															#line 5066 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 801 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<SendGrvRepliesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendGrvRepliesActorState(); static_cast<SendGrvRepliesActor*>(this)->destroy(); return 0; }
															#line 5070 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<SendGrvRepliesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendGrvRepliesActorState();
		static_cast<SendGrvRepliesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(GetReadVersionReply && _reply,int loopDepth) 
	{
															#line 727 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		GetReadVersionReply reply = _reply;
															#line 728 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		Version replyVersion = reply.version;
															#line 730 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double end = g_network->timer();
															#line 731 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for( GetReadVersionRequest const& request : requests ) {
															#line 732 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			double duration = end - request.requestTime() - request.proxyTagThrottledDuration;
															#line 733 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority == TransactionPriority::BATCH)
															#line 5092 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 734 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvBatchLatencySample.addMeasurement(duration);
															#line 5096 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 737 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority == TransactionPriority::DEFAULT)
															#line 5100 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 738 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvLatencySample.addMeasurement(duration);
															#line 5104 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 741 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.priority >= TransactionPriority::DEFAULT)
															#line 5108 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 742 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				stats->grvLatencyBands.addMeasurement(duration);
															#line 5112 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 745 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.flags & GetReadVersionRequest::FLAG_USE_MIN_KNOWN_COMMITTED_VERSION)
															#line 5116 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 747 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				reply.version = minKnownCommittedVersion;
															#line 5120 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 749 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				reply.version = replyVersion;
															#line 5126 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 751 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.midShardSize = midShardSize;
															#line 752 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.tagThrottleInfo.clear();
															#line 753 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (SERVER_KNOBS->ENABLE_VERSION_VECTOR)
															#line 5134 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 754 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->ssVersionVectorCache.getDelta(request.maxVersion, reply.ssVersionVectorDelta);
															#line 755 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->versionVectorSizeOnGRVReply->addMeasurement(reply.ssVersionVectorDelta.size());
															#line 5140 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 757 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.proxyId = grvProxyData->dbgid;
															#line 758 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			reply.proxyTagThrottledDuration = request.proxyTagThrottledDuration;
															#line 760 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (request.isTagged())
															#line 5148 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 761 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				auto& priorityThrottledTags = clientThrottledTags[request.priority];
															#line 762 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				for( auto tag : request.tags ) {
															#line 763 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					auto tagItr = priorityThrottledTags.find(tag.first);
															#line 764 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (tagItr != priorityThrottledTags.end())
															#line 5158 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 765 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						if (tagItr->second.expiration > now())
															#line 5162 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						{
															#line 766 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							if (tagItr->second.tpsRate == std::numeric_limits<double>::max())
															#line 5166 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
							{
															#line 767 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								CODE_PROBE(true, "Auto TPS rate is unlimited");
															#line 5170 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
							}
							else
							{
															#line 769 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								CODE_PROBE(true, "GRV proxy returning tag throttle");
															#line 770 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
								reply.tagThrottleInfo[tag.first] = tagItr->second;
															#line 5178 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
							}
						}
						else
						{
															#line 774 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							CODE_PROBE(true, "GRV proxy expiring tag throttle");
															#line 775 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
							priorityThrottledTags.erase(tagItr);
															#line 5187 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
						}
					}
				}
			}
															#line 781 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (stats->lastBatchQueueThrottled)
															#line 5194 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 783 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (now() - stats->batchThrottleStartTime > CLIENT_KNOBS->GRV_SUSTAINED_THROTTLING_THRESHOLD)
															#line 5198 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 784 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkBatchThrottled = true;
															#line 5202 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 787 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (stats->lastDefaultQueueThrottled)
															#line 5207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 789 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (now() - stats->defaultThrottleStartTime > CLIENT_KNOBS->GRV_SUSTAINED_THROTTLING_THRESHOLD)
															#line 5211 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 793 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkBatchThrottled = true;
															#line 794 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					reply.rkDefaultThrottled = true;
															#line 5217 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 797 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			request.reply.send(reply);
															#line 798 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			++stats->txnRequestOut;
															#line 5224 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 801 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<SendGrvRepliesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendGrvRepliesActorState(); static_cast<SendGrvRepliesActor*>(this)->destroy(); return 0; }
															#line 5228 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<SendGrvRepliesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendGrvRepliesActorState();
		static_cast<SendGrvRepliesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(GetReadVersionReply const& _reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(_reply, loopDepth);

		return loopDepth;
	}
	int a_body1when1(GetReadVersionReply && _reply,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_reply), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SendGrvRepliesActor*>(this)->actor_wait_state > 0) static_cast<SendGrvRepliesActor*>(this)->actor_wait_state = 0;
		static_cast<SendGrvRepliesActor*>(this)->ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >::remove();

	}
	void a_callback_fire(ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*,GetReadVersionReply const& value) 
	{
		fdb_probe_actor_enter("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendGrvRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*,GetReadVersionReply && value) 
	{
		fdb_probe_actor_enter("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendGrvRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*,Error err) 
	{
		fdb_probe_actor_enter("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendGrvRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendGrvReplies", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<GetReadVersionReply> replyFuture;
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	std::vector<GetReadVersionRequest> requests;
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyStats* stats;
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Version minKnownCommittedVersion;
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PrioritizedTransactionTagMap<ClientTagThrottleLimits> clientThrottledTags;
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t midShardSize;
															#line 5325 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via sendGrvReplies()
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class SendGrvRepliesActor final : public Actor<Void>, public ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >, public FastAllocated<SendGrvRepliesActor>, public SendGrvRepliesActorState<SendGrvRepliesActor> {
															#line 5330 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<SendGrvRepliesActor>::operator new;
	using FastAllocated<SendGrvRepliesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5064034602316425984UL, 5647140561104812288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >;
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	SendGrvRepliesActor(Future<GetReadVersionReply> const& replyFuture,std::vector<GetReadVersionRequest> const& requests,GrvProxyData* const& grvProxyData,GrvProxyStats* const& stats,Version const& minKnownCommittedVersion,PrioritizedTransactionTagMap<ClientTagThrottleLimits> const& clientThrottledTags,int64_t const& midShardSize = 0) 
															#line 5347 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   SendGrvRepliesActorState<SendGrvRepliesActor>(replyFuture, requests, grvProxyData, stats, minKnownCommittedVersion, clientThrottledTags, midShardSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sendGrvReplies", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6621363967670553088UL, 9891954819986612480UL);
		ActorExecutionContextHelper __helper(static_cast<SendGrvRepliesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sendGrvReplies");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sendGrvReplies", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SendGrvRepliesActor, 0, GetReadVersionReply >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> sendGrvReplies( Future<GetReadVersionReply> const& replyFuture, std::vector<GetReadVersionRequest> const& requests, GrvProxyData* const& grvProxyData, GrvProxyStats* const& stats, Version const& minKnownCommittedVersion, PrioritizedTransactionTagMap<ClientTagThrottleLimits> const& clientThrottledTags, int64_t const& midShardSize = 0 ) {
															#line 719 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new SendGrvRepliesActor(replyFuture, requests, grvProxyData, stats, minKnownCommittedVersion, clientThrottledTags, midShardSize));
															#line 5380 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 803 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 5385 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via monitorDDMetricsChanges()
															#line 804 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class MonitorDDMetricsChangesActor>
															#line 804 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class MonitorDDMetricsChangesActorState {
															#line 5392 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 804 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	MonitorDDMetricsChangesActorState(int64_t* const& midShardSize,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 804 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 804 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : midShardSize(midShardSize),
															#line 804 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db),
															#line 805 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   nextRequestTimer(Never()),
															#line 806 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   nextReply(Never())
															#line 5405 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this));

	}
	~MonitorDDMetricsChangesActorState() 
	{
		fdb_probe_actor_destroy("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 808 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (db->get().distributor.present())
															#line 5420 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 809 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				nextRequestTimer = Void();
															#line 5424 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 810 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 5428 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorDDMetricsChangesActorState();
		static_cast<MonitorDDMetricsChangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 813 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 812 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (static_cast<MonitorDDMetricsChangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5461 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 824 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<Void> __when_expr_1 = nextRequestTimer;
															#line 5465 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
															#line 832 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			StrictFuture<GetDataDistributorMetricsReply> __when_expr_2 = nextReply;
															#line 5469 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
			static_cast<MonitorDDMetricsChangesActor*>(this)->actor_wait_state = 1;
															#line 813 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*>(static_cast<MonitorDDMetricsChangesActor*>(this)));
															#line 824 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MonitorDDMetricsChangesActor, 1, Void >*>(static_cast<MonitorDDMetricsChangesActor*>(this)));
															#line 832 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >*>(static_cast<MonitorDDMetricsChangesActor*>(this)));
															#line 5478 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 840 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DDMidShardSizeUpdateFail").error(e);
															#line 841 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (e.code() != error_code_timed_out && e.code() != error_code_dd_not_found)
															#line 5502 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 842 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5506 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 843 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = delay(CLIENT_KNOBS->MID_SHARD_SIZE_MAX_STALENESS);
															#line 844 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = Never();
															#line 5512 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 814 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().distributor.present())
															#line 5533 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 815 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DataDistributorChanged", db->get().id) .detail("DDID", db->get().distributor.get().id());
															#line 817 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 5539 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 819 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DataDistributorDied", db->get().id);
															#line 820 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 5547 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 822 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextReply = Never();
															#line 5551 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 814 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().distributor.present())
															#line 5560 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 815 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DataDistributorChanged", db->get().id) .detail("DDID", db->get().distributor.get().id());
															#line 817 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Void();
															#line 5566 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 819 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("DataDistributorDied", db->get().id);
															#line 820 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextRequestTimer = Never();
															#line 5574 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 822 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextReply = Never();
															#line 5578 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 825 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 826 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().distributor.present())
															#line 5589 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 827 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = brokenPromiseToNever(db->get().distributor.get().dataDistributorMetrics.getReply( GetDataDistributorMetricsRequest(normalKeys, CLIENT_KNOBS->TOO_MANY, true)));
															#line 5593 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 830 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = Never();
															#line 5599 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 825 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = Never();
															#line 826 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().distributor.present())
															#line 5611 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 827 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = brokenPromiseToNever(db->get().distributor.get().dataDistributorMetrics.getReply( GetDataDistributorMetricsRequest(normalKeys, CLIENT_KNOBS->TOO_MANY, true)));
															#line 5615 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		else
		{
															#line 830 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			nextReply = Never();
															#line 5621 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetDataDistributorMetricsReply const& reply,int loopDepth) 
	{
															#line 833 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextReply = Never();
															#line 834 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(reply.midShardSize.present());
															#line 835 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*midShardSize = reply.midShardSize.get();
															#line 836 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = delay(CLIENT_KNOBS->MID_SHARD_SIZE_MAX_STALENESS);
															#line 5637 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(GetDataDistributorMetricsReply && reply,int loopDepth) 
	{
															#line 833 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextReply = Never();
															#line 834 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(reply.midShardSize.present());
															#line 835 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		*midShardSize = reply.midShardSize.get();
															#line 836 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		nextRequestTimer = delay(CLIENT_KNOBS->MID_SHARD_SIZE_MAX_STALENESS);
															#line 5652 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorDDMetricsChangesActor*>(this)->actor_wait_state > 0) static_cast<MonitorDDMetricsChangesActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorDDMetricsChangesActor*>(this)->ActorCallback< MonitorDDMetricsChangesActor, 0, Void >::remove();
		static_cast<MonitorDDMetricsChangesActor*>(this)->ActorCallback< MonitorDDMetricsChangesActor, 1, Void >::remove();
		static_cast<MonitorDDMetricsChangesActor*>(this)->ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MonitorDDMetricsChangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >*,GetDataDistributorMetricsReply const& value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >*,GetDataDistributorMetricsReply && value) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >*,Error err) 
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 804 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t* midShardSize;
															#line 804 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 805 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> nextRequestTimer;
															#line 806 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<GetDataDistributorMetricsReply> nextReply;
															#line 5857 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via monitorDDMetricsChanges()
															#line 804 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class MonitorDDMetricsChangesActor final : public Actor<Void>, public ActorCallback< MonitorDDMetricsChangesActor, 0, Void >, public ActorCallback< MonitorDDMetricsChangesActor, 1, Void >, public ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >, public FastAllocated<MonitorDDMetricsChangesActor>, public MonitorDDMetricsChangesActorState<MonitorDDMetricsChangesActor> {
															#line 5862 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<MonitorDDMetricsChangesActor>::operator new;
	using FastAllocated<MonitorDDMetricsChangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5890875380510646784UL, 833067089996526336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorDDMetricsChangesActor, 0, Void >;
friend struct ActorCallback< MonitorDDMetricsChangesActor, 1, Void >;
friend struct ActorCallback< MonitorDDMetricsChangesActor, 2, GetDataDistributorMetricsReply >;
															#line 804 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	MonitorDDMetricsChangesActor(int64_t* const& midShardSize,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 5881 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   MonitorDDMetricsChangesActorState<MonitorDDMetricsChangesActor>(midShardSize, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16350006110712773376UL, 12950337145856341760UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorDDMetricsChangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorDDMetricsChanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorDDMetricsChanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorDDMetricsChangesActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 804 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> monitorDDMetricsChanges( int64_t* const& midShardSize, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 804 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new MonitorDDMetricsChangesActor(midShardSize, db));
															#line 5914 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 848 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 5919 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via transactionStarter()
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class TransactionStarterActor>
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class TransactionStarterActorState {
															#line 5926 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	TransactionStarterActorState(GrvProxyInterface const& proxy,Reference<AsyncVar<ServerDBInfo> const> const& db,PromiseStream<Future<Void>> const& addActor,GrvProxyData* const& grvProxyData,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply) 
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db),
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   addActor(addActor),
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxyData(grvProxyData),
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   healthMetricsReply(healthMetricsReply),
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   detailedHealthMetricsReply(detailedHealthMetricsReply),
															#line 855 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   lastGRVTime(0),
															#line 856 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   GRVTimer(),
															#line 857 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   GRVBatchTime(SERVER_KNOBS->START_TRANSACTION_BATCH_INTERVAL_MIN),
															#line 859 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionCount(0),
															#line 860 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchTransactionCount(0),
															#line 861 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   normalRateInfo(SERVER_KNOBS->START_TRANSACTION_RATE_WINDOW, SERVER_KNOBS->START_TRANSACTION_MAX_EMPTY_QUEUE_BUDGET, 10),
															#line 864 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchRateInfo(SERVER_KNOBS->START_TRANSACTION_RATE_WINDOW, SERVER_KNOBS->START_TRANSACTION_MAX_EMPTY_QUEUE_BUDGET, 0),
															#line 868 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   systemQueue(),
															#line 869 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   defaultQueue(),
															#line 870 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   batchQueue(),
															#line 872 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   transactionTagCounter(),
															#line 873 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   clientThrottledTags(),
															#line 875 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   normalGRVLatency(),
															#line 877 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   midShardSize(SERVER_KNOBS->MIN_SHARD_BYTES)
															#line 5971 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("transactionStarter", reinterpret_cast<unsigned long>(this));

	}
	~TransactionStarterActorState() 
	{
		fdb_probe_actor_destroy("transactionStarter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 878 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			getCurrentLineage()->modify(&TransactionLineage::operation) = TransactionLineage::Operation::GetConsistentReadVersion;
															#line 880 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(monitorDDMetricsChanges(&midShardSize, db));
															#line 882 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(getRate(proxy.id(), db, &transactionCount, &batchTransactionCount, &normalRateInfo, &batchRateInfo, healthMetricsReply, detailedHealthMetricsReply, &transactionTagCounter, &clientThrottledTags, &grvProxyData->stats, grvProxyData));
															#line 894 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(queueGetReadVersionRequests(db, &systemQueue, &defaultQueue, &batchQueue, proxy.getConsistentReadVersion.getFuture(), GRVTimer, &lastGRVTime, &GRVBatchTime, normalGRVLatency.getFuture(), &grvProxyData->stats, &batchRateInfo, &grvProxyData->tagThrottler));
															#line 907 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 5994 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TransactionStarterActorState();
		static_cast<TransactionStarterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 912 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		ASSERT(db->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS);
															#line 914 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		TraceEvent("GrvProxyReadyForTxnStarts", proxy.id());
															#line 916 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		;
															#line 6021 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 907 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!(std::find(db->get().client.grvProxies.begin(), db->get().client.grvProxies.end(), proxy) == db->get().client.grvProxies.end()))
															#line 6037 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 909 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 909 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<TransactionStarterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6045 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<TransactionStarterActor*>(this)->actor_wait_state = 1;
															#line 909 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TransactionStarterActor, 0, Void >*>(static_cast<TransactionStarterActor*>(this)));
															#line 6050 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TransactionStarterActor*>(this)->actor_wait_state > 0) static_cast<TransactionStarterActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionStarterActor*>(this)->ActorCallback< TransactionStarterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TransactionStarterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TransactionStarterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TransactionStarterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 917 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		auto __when_expr_1 = GRVTimer.getFuture();
															#line 6166 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<Void>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<Void>>::value, "invalid type");
															#line 917 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<TransactionStarterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6170 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.pop(), loopDepth); };
		static_cast<TransactionStarterActor*>(this)->actor_wait_state = 2;
															#line 917 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< TransactionStarterActor, 1, Void >*>(static_cast<TransactionStarterActor*>(this)));
															#line 6175 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 919 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double t = now();
															#line 920 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double elapsed = now() - lastGRVTime;
															#line 921 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		lastGRVTime = t;
															#line 924 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (elapsed == 0)
															#line 6190 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 925 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			elapsed = 1e-15;
															#line 6194 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 928 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.update(grvProxyData->tagThrottler.releaseTransactions(elapsed, batchQueue, defaultQueue));
															#line 930 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		normalRateInfo.startReleaseWindow();
															#line 931 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchRateInfo.startReleaseWindow();
															#line 933 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.transactionLimit = normalRateInfo.getLimit();
															#line 934 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.batchTransactionLimit = batchRateInfo.getLimit();
															#line 936 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int transactionsStarted[2] = { 0, 0 };
															#line 937 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int systemTransactionsStarted[2] = { 0, 0 };
															#line 938 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int defaultPriTransactionsStarted[2] = { 0, 0 };
															#line 939 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchPriTransactionsStarted[2] = { 0, 0 };
															#line 941 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		std::vector<std::vector<GetReadVersionRequest>> start( 2);
															#line 944 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		Optional<UID> debugID;
															#line 946 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int requestsToStart = 0;
															#line 948 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		uint32_t defaultQueueSize = defaultQueue.size();
															#line 949 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		uint32_t batchQueueSize = batchQueue.size();
															#line 950 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for(;requestsToStart < SERVER_KNOBS->START_TRANSACTION_MAX_REQUESTS_TO_START;) {
															#line 951 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Deque<GetReadVersionRequest>* transactionQueue;
															#line 952 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!systemQueue.empty())
															#line 6230 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 953 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				transactionQueue = &systemQueue;
															#line 6234 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 954 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (!defaultQueue.empty())
															#line 6240 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 955 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					transactionQueue = &defaultQueue;
															#line 6244 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
				else
				{
															#line 956 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue.empty())
															#line 6250 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 957 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						transactionQueue = &batchQueue;
															#line 6254 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
						break;
					}
				}
			}
															#line 962 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			auto& req = transactionQueue->front();
															#line 963 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			int tc = req.transactionCount;
															#line 965 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority < TransactionPriority::DEFAULT && !batchRateInfo.canStart(transactionsStarted[0] + transactionsStarted[1], tc))
															#line 6268 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
				break;
			}
			else
			{
															#line 968 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority < TransactionPriority::IMMEDIATE && !normalRateInfo.canStart(transactionsStarted[0] + transactionsStarted[1], tc))
															#line 6276 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
					break;
				}
			}
															#line 973 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.debugID.present())
															#line 6283 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 974 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (!debugID.present())
															#line 6287 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 975 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					debugID = nondeterministicRandom()->randomUniqueID();
															#line 6291 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 976 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				g_traceBatch.addAttach("TransactionAttachID", req.debugID.get().first(), debugID.get().first());
															#line 6295 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 979 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			transactionsStarted[req.flags & 1] += tc;
															#line 980 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			double currentTime = g_network->timer();
															#line 981 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority >= TransactionPriority::IMMEDIATE)
															#line 6303 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 982 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				systemTransactionsStarted[req.flags & 1] += tc;
															#line 983 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				--grvProxyData->stats.systemGRVQueueSize;
															#line 6309 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 984 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority >= TransactionPriority::DEFAULT)
															#line 6315 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 985 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					defaultPriTransactionsStarted[req.flags & 1] += tc;
															#line 986 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					grvProxyData->stats.defaultTxnGRVTimeInQueue.addMeasurement(currentTime - req.requestTime());
															#line 987 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					--grvProxyData->stats.defaultGRVQueueSize;
															#line 6323 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
				else
				{
															#line 989 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					batchPriTransactionsStarted[req.flags & 1] += tc;
															#line 990 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					grvProxyData->stats.batchTxnGRVTimeInQueue.addMeasurement(currentTime - req.requestTime());
															#line 991 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					--grvProxyData->stats.batchGRVQueueSize;
															#line 6333 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 993 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			for( auto tag : req.tags ) {
															#line 994 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				transactionTagCounter[tag.first] += tag.second;
															#line 6340 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 996 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			start[req.flags & 1].push_back(std::move(req));
															#line 997 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			static_assert(GetReadVersionRequest::FLAG_CAUSAL_READ_RISKY == 1, "Implementation dependent on flag value");
															#line 998 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			transactionQueue->pop_front();
															#line 999 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			requestsToStart++;
															#line 6350 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1001 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!batchQueue.empty())
															#line 6354 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1002 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!grvProxyData->stats.lastBatchQueueThrottled)
															#line 6358 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1003 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.lastBatchQueueThrottled = true;
															#line 1004 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.batchThrottleStartTime = now();
															#line 6364 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
		else
		{
															#line 1007 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->stats.lastBatchQueueThrottled = false;
															#line 6371 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1009 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!defaultQueue.empty())
															#line 6375 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1010 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!grvProxyData->stats.lastDefaultQueueThrottled)
															#line 6379 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1011 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.lastDefaultQueueThrottled = true;
															#line 1012 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.defaultThrottleStartTime = now();
															#line 6385 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
		else
		{
															#line 1015 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->stats.lastDefaultQueueThrottled = false;
															#line 6392 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1018 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!systemQueue.empty() || !defaultQueue.empty() || !batchQueue.empty())
															#line 6396 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1019 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			forwardPromise( GRVTimer, delayJittered(SERVER_KNOBS->START_TRANSACTION_BATCH_QUEUE_CHECK_INTERVAL, TaskPriority::ProxyGRVTimer));
															#line 6400 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1036 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int systemTotalStarted = systemTransactionsStarted[0] + systemTransactionsStarted[1];
															#line 1037 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int normalTotalStarted = defaultPriTransactionsStarted[0] + defaultPriTransactionsStarted[1];
															#line 1038 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchTotalStarted = batchPriTransactionsStarted[0] + batchPriTransactionsStarted[1];
															#line 1040 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionCount += transactionsStarted[0] + transactionsStarted[1];
															#line 1041 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionCount += batchTotalStarted;
															#line 1043 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		normalRateInfo.endReleaseWindow( systemTotalStarted + normalTotalStarted, systemQueue.empty() && defaultQueue.empty(), elapsed);
															#line 1045 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchRateInfo.endReleaseWindow(systemTotalStarted + normalTotalStarted + batchTotalStarted, systemQueue.empty() && defaultQueue.empty() && batchQueue.empty(), elapsed);
															#line 1049 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 6418 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1050 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", debugID.get().first(), "GrvProxyServer.transactionStarter.AskLiveCommittedVersionFromMaster");
															#line 6422 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1055 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int defaultGRVProcessed = 0;
															#line 1056 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchGRVProcessed = 0;
															#line 1057 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for(int i = 0;i < start.size();i++) {
															#line 1058 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (start[i].size())
															#line 6432 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1059 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				std::vector<SpanContext> spanContexts;
															#line 1060 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				spanContexts.reserve(start[i].size());
															#line 1061 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				for( const GetReadVersionRequest& request : start[i] ) {
															#line 1062 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					spanContexts.push_back(request.spanContext);
															#line 6442 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 1065 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				Future<GetReadVersionReply> readVersionReply = getLiveCommittedVersion(spanContexts, grvProxyData, i, debugID, transactionsStarted[i], systemTransactionsStarted[i], defaultPriTransactionsStarted[i], batchPriTransactionsStarted[i]);
															#line 1073 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				addActor.send(sendGrvReplies(readVersionReply, start[i], grvProxyData, &grvProxyData->stats, grvProxyData->minKnownCommittedVersion, clientThrottledTags, midShardSize));
															#line 1082 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (i == 0)
															#line 6450 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 1083 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					addActor.send(timeReply(readVersionReply, normalGRVLatency));
															#line 6454 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 1085 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				defaultGRVProcessed += defaultPriTransactionsStarted[i];
															#line 1086 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				batchGRVProcessed += batchPriTransactionsStarted[i];
															#line 6460 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
															#line 1090 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.percentageOfDefaultGRVQueueProcessed = defaultQueueSize ? (double)defaultGRVProcessed / defaultQueueSize : 1;
															#line 1092 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.percentageOfBatchGRVQueueProcessed = batchQueueSize ? (double)batchGRVProcessed / batchQueueSize : 1;
															#line 6467 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 919 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double t = now();
															#line 920 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		double elapsed = now() - lastGRVTime;
															#line 921 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		lastGRVTime = t;
															#line 924 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (elapsed == 0)
															#line 6482 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 925 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			elapsed = 1e-15;
															#line 6486 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 928 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.update(grvProxyData->tagThrottler.releaseTransactions(elapsed, batchQueue, defaultQueue));
															#line 930 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		normalRateInfo.startReleaseWindow();
															#line 931 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchRateInfo.startReleaseWindow();
															#line 933 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.transactionLimit = normalRateInfo.getLimit();
															#line 934 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.batchTransactionLimit = batchRateInfo.getLimit();
															#line 936 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int transactionsStarted[2] = { 0, 0 };
															#line 937 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int systemTransactionsStarted[2] = { 0, 0 };
															#line 938 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int defaultPriTransactionsStarted[2] = { 0, 0 };
															#line 939 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchPriTransactionsStarted[2] = { 0, 0 };
															#line 941 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		std::vector<std::vector<GetReadVersionRequest>> start( 2);
															#line 944 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		Optional<UID> debugID;
															#line 946 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int requestsToStart = 0;
															#line 948 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		uint32_t defaultQueueSize = defaultQueue.size();
															#line 949 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		uint32_t batchQueueSize = batchQueue.size();
															#line 950 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for(;requestsToStart < SERVER_KNOBS->START_TRANSACTION_MAX_REQUESTS_TO_START;) {
															#line 951 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			Deque<GetReadVersionRequest>* transactionQueue;
															#line 952 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!systemQueue.empty())
															#line 6522 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 953 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				transactionQueue = &systemQueue;
															#line 6526 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 954 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (!defaultQueue.empty())
															#line 6532 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 955 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					transactionQueue = &defaultQueue;
															#line 6536 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
				else
				{
															#line 956 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					if (!batchQueue.empty())
															#line 6542 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					{
															#line 957 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
						transactionQueue = &batchQueue;
															#line 6546 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
					}
					else
					{
						break;
					}
				}
			}
															#line 962 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			auto& req = transactionQueue->front();
															#line 963 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			int tc = req.transactionCount;
															#line 965 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority < TransactionPriority::DEFAULT && !batchRateInfo.canStart(transactionsStarted[0] + transactionsStarted[1], tc))
															#line 6560 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
				break;
			}
			else
			{
															#line 968 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority < TransactionPriority::IMMEDIATE && !normalRateInfo.canStart(transactionsStarted[0] + transactionsStarted[1], tc))
															#line 6568 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
					break;
				}
			}
															#line 973 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.debugID.present())
															#line 6575 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 974 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (!debugID.present())
															#line 6579 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 975 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					debugID = nondeterministicRandom()->randomUniqueID();
															#line 6583 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 976 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				g_traceBatch.addAttach("TransactionAttachID", req.debugID.get().first(), debugID.get().first());
															#line 6587 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 979 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			transactionsStarted[req.flags & 1] += tc;
															#line 980 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			double currentTime = g_network->timer();
															#line 981 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (req.priority >= TransactionPriority::IMMEDIATE)
															#line 6595 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 982 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				systemTransactionsStarted[req.flags & 1] += tc;
															#line 983 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				--grvProxyData->stats.systemGRVQueueSize;
															#line 6601 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			else
			{
															#line 984 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (req.priority >= TransactionPriority::DEFAULT)
															#line 6607 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 985 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					defaultPriTransactionsStarted[req.flags & 1] += tc;
															#line 986 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					grvProxyData->stats.defaultTxnGRVTimeInQueue.addMeasurement(currentTime - req.requestTime());
															#line 987 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					--grvProxyData->stats.defaultGRVQueueSize;
															#line 6615 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
				else
				{
															#line 989 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					batchPriTransactionsStarted[req.flags & 1] += tc;
															#line 990 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					grvProxyData->stats.batchTxnGRVTimeInQueue.addMeasurement(currentTime - req.requestTime());
															#line 991 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					--grvProxyData->stats.batchGRVQueueSize;
															#line 6625 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
			}
															#line 993 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			for( auto tag : req.tags ) {
															#line 994 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				transactionTagCounter[tag.first] += tag.second;
															#line 6632 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
															#line 996 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			start[req.flags & 1].push_back(std::move(req));
															#line 997 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			static_assert(GetReadVersionRequest::FLAG_CAUSAL_READ_RISKY == 1, "Implementation dependent on flag value");
															#line 998 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			transactionQueue->pop_front();
															#line 999 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			requestsToStart++;
															#line 6642 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1001 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!batchQueue.empty())
															#line 6646 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1002 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!grvProxyData->stats.lastBatchQueueThrottled)
															#line 6650 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1003 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.lastBatchQueueThrottled = true;
															#line 1004 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.batchThrottleStartTime = now();
															#line 6656 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
		else
		{
															#line 1007 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->stats.lastBatchQueueThrottled = false;
															#line 6663 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1009 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!defaultQueue.empty())
															#line 6667 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1010 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (!grvProxyData->stats.lastDefaultQueueThrottled)
															#line 6671 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1011 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.lastDefaultQueueThrottled = true;
															#line 1012 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				grvProxyData->stats.defaultThrottleStartTime = now();
															#line 6677 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
		else
		{
															#line 1015 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData->stats.lastDefaultQueueThrottled = false;
															#line 6684 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1018 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!systemQueue.empty() || !defaultQueue.empty() || !batchQueue.empty())
															#line 6688 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1019 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			forwardPromise( GRVTimer, delayJittered(SERVER_KNOBS->START_TRANSACTION_BATCH_QUEUE_CHECK_INTERVAL, TaskPriority::ProxyGRVTimer));
															#line 6692 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1036 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int systemTotalStarted = systemTransactionsStarted[0] + systemTransactionsStarted[1];
															#line 1037 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int normalTotalStarted = defaultPriTransactionsStarted[0] + defaultPriTransactionsStarted[1];
															#line 1038 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchTotalStarted = batchPriTransactionsStarted[0] + batchPriTransactionsStarted[1];
															#line 1040 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		transactionCount += transactionsStarted[0] + transactionsStarted[1];
															#line 1041 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchTransactionCount += batchTotalStarted;
															#line 1043 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		normalRateInfo.endReleaseWindow( systemTotalStarted + normalTotalStarted, systemQueue.empty() && defaultQueue.empty(), elapsed);
															#line 1045 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		batchRateInfo.endReleaseWindow(systemTotalStarted + normalTotalStarted + batchTotalStarted, systemQueue.empty() && defaultQueue.empty() && batchQueue.empty(), elapsed);
															#line 1049 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (debugID.present())
															#line 6710 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1050 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			g_traceBatch.addEvent("TransactionDebug", debugID.get().first(), "GrvProxyServer.transactionStarter.AskLiveCommittedVersionFromMaster");
															#line 6714 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1055 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int defaultGRVProcessed = 0;
															#line 1056 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		int batchGRVProcessed = 0;
															#line 1057 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		for(int i = 0;i < start.size();i++) {
															#line 1058 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (start[i].size())
															#line 6724 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1059 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				std::vector<SpanContext> spanContexts;
															#line 1060 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				spanContexts.reserve(start[i].size());
															#line 1061 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				for( const GetReadVersionRequest& request : start[i] ) {
															#line 1062 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					spanContexts.push_back(request.spanContext);
															#line 6734 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 1065 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				Future<GetReadVersionReply> readVersionReply = getLiveCommittedVersion(spanContexts, grvProxyData, i, debugID, transactionsStarted[i], systemTransactionsStarted[i], defaultPriTransactionsStarted[i], batchPriTransactionsStarted[i]);
															#line 1073 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				addActor.send(sendGrvReplies(readVersionReply, start[i], grvProxyData, &grvProxyData->stats, grvProxyData->minKnownCommittedVersion, clientThrottledTags, midShardSize));
															#line 1082 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (i == 0)
															#line 6742 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				{
															#line 1083 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
					addActor.send(timeReply(readVersionReply, normalGRVLatency));
															#line 6746 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				}
															#line 1085 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				defaultGRVProcessed += defaultPriTransactionsStarted[i];
															#line 1086 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				batchGRVProcessed += batchPriTransactionsStarted[i];
															#line 6752 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
		}
															#line 1090 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.percentageOfDefaultGRVQueueProcessed = defaultQueueSize ? (double)defaultGRVProcessed / defaultQueueSize : 1;
															#line 1092 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData->stats.percentageOfBatchGRVQueueProcessed = batchQueueSize ? (double)batchGRVProcessed / batchQueueSize : 1;
															#line 6759 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TransactionStarterActor*>(this)->actor_wait_state > 0) static_cast<TransactionStarterActor*>(this)->actor_wait_state = 0;
		static_cast<TransactionStarterActor*>(this)->ActorSingleCallback< TransactionStarterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorSingleCallback< TransactionStarterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< TransactionStarterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< TransactionStarterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface proxy;
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData* grvProxyData;
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* healthMetricsReply;
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply* detailedHealthMetricsReply;
															#line 855 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double lastGRVTime;
															#line 856 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Void> GRVTimer;
															#line 857 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	double GRVBatchTime;
															#line 859 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t transactionCount;
															#line 860 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t batchTransactionCount;
															#line 861 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo normalRateInfo;
															#line 864 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvTransactionRateInfo batchRateInfo;
															#line 868 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest> systemQueue;
															#line 869 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest> defaultQueue;
															#line 870 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Deque<GetReadVersionRequest> batchQueue;
															#line 872 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	TransactionTagMap<uint64_t> transactionTagCounter;
															#line 873 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PrioritizedTransactionTagMap<ClientTagThrottleLimits> clientThrottledTags;
															#line 875 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<double> normalGRVLatency;
															#line 877 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	int64_t midShardSize;
															#line 6879 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via transactionStarter()
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class TransactionStarterActor final : public Actor<Void>, public ActorCallback< TransactionStarterActor, 0, Void >, public ActorSingleCallback< TransactionStarterActor, 1, Void >, public FastAllocated<TransactionStarterActor>, public TransactionStarterActorState<TransactionStarterActor> {
															#line 6884 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<TransactionStarterActor>::operator new;
	using FastAllocated<TransactionStarterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17756761995130572288UL, 8890117223216781824UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TransactionStarterActor, 0, Void >;
friend struct ActorSingleCallback< TransactionStarterActor, 1, Void >;
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	TransactionStarterActor(GrvProxyInterface const& proxy,Reference<AsyncVar<ServerDBInfo> const> const& db,PromiseStream<Future<Void>> const& addActor,GrvProxyData* const& grvProxyData,GetHealthMetricsReply* const& healthMetricsReply,GetHealthMetricsReply* const& detailedHealthMetricsReply) 
															#line 6902 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   TransactionStarterActorState<TransactionStarterActor>(proxy, db, addActor, grvProxyData, healthMetricsReply, detailedHealthMetricsReply),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("transactionStarter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10700198538979324160UL, 3557432467917975808UL);
		ActorExecutionContextHelper __helper(static_cast<TransactionStarterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("transactionStarter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("transactionStarter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TransactionStarterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< TransactionStarterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] static Future<Void> transactionStarter( GrvProxyInterface const& proxy, Reference<AsyncVar<ServerDBInfo> const> const& db, PromiseStream<Future<Void>> const& addActor, GrvProxyData* const& grvProxyData, GetHealthMetricsReply* const& healthMetricsReply, GetHealthMetricsReply* const& detailedHealthMetricsReply ) {
															#line 849 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new TransactionStarterActor(proxy, db, addActor, grvProxyData, healthMetricsReply, detailedHealthMetricsReply));
															#line 6936 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 1096 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 6941 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via grvProxyServerCore()
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GrvProxyServerCoreActor>
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GrvProxyServerCoreActorState {
															#line 6948 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyServerCoreActorState(GrvProxyInterface const& proxy,MasterInterface const& master,LifetimeToken const& masterLifetime,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   master(master),
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   masterLifetime(masterLifetime),
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db),
															#line 1101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   grvProxyData(proxy.id(), master, proxy.getConsistentReadVersion, db),
															#line 1103 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   addActor(),
															#line 1104 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   onError(actorCollection(addActor.getFuture())),
															#line 1106 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   healthMetricsReply(),
															#line 1107 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   detailedHealthMetricsReply()
															#line 6971 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("grvProxyServerCore", reinterpret_cast<unsigned long>(this));

	}
	~GrvProxyServerCoreActorState() 
	{
		fdb_probe_actor_destroy("grvProxyServerCore", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1109 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(waitFailureServer(proxy.waitFailure.getFuture()));
															#line 1110 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(traceRole(Role::GRV_PROXY, proxy.id()));
															#line 1112 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("GrvProxyServerCore", proxy.id()) .detail("MasterId", master.id()) .detail("MasterLifetime", masterLifetime.toString()) .detail("RecoveryCount", db->get().recoveryCount);
															#line 1118 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 6992 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GrvProxyServerCoreActorState();
		static_cast<GrvProxyServerCoreActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1123 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		dbInfoChange = grvProxyData.db->onChange();
															#line 1124 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), grvProxyData.db->get(), false, addActor);
															#line 1126 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData.updateLatencyBandConfig(grvProxyData.db->get().latencyBandConfig);
															#line 1128 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		addActor.send(transactionStarter( proxy, grvProxyData.db, addActor, &grvProxyData, &healthMetricsReply, &detailedHealthMetricsReply));
															#line 1130 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		addActor.send(healthMetricsRequestServer(proxy, &healthMetricsReply, &detailedHealthMetricsReply));
															#line 1131 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		addActor.send(globalConfigRequestServer(&grvProxyData, proxy));
															#line 1133 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (SERVER_KNOBS->REQUIRED_MIN_RECOVERY_DURATION > 0)
															#line 7027 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1134 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			addActor.send(lastCommitUpdater(&grvProxyData, addActor));
															#line 7031 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1137 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		;
															#line 7035 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1118 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!(!(masterLifetime.isEqual(grvProxyData.db->get().masterLifetime) && grvProxyData.db->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS)))
															#line 7051 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1120 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = grvProxyData.db->onChange();
															#line 1120 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7059 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state = 1;
															#line 1120 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GrvProxyServerCoreActor, 0, Void >*>(static_cast<GrvProxyServerCoreActor*>(this)));
															#line 7064 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state > 0) static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state = 0;
		static_cast<GrvProxyServerCoreActor*>(this)->ActorCallback< GrvProxyServerCoreActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GrvProxyServerCoreActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1138 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_1 = dbInfoChange;
															#line 1137 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7182 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 1148 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_2 = onError;
															#line 7186 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
		static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state = 2;
															#line 1138 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GrvProxyServerCoreActor, 1, Void >*>(static_cast<GrvProxyServerCoreActor*>(this)));
															#line 1148 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GrvProxyServerCoreActor, 2, Void >*>(static_cast<GrvProxyServerCoreActor*>(this)));
															#line 7193 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 1139 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		dbInfoChange = grvProxyData.db->onChange();
															#line 1141 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (masterLifetime.isEqual(grvProxyData.db->get().masterLifetime) && grvProxyData.db->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION)
															#line 7210 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1143 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), grvProxyData.db->get(), false, addActor);
															#line 7214 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1146 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData.updateLatencyBandConfig(grvProxyData.db->get().latencyBandConfig);
															#line 7218 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 1139 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		dbInfoChange = grvProxyData.db->onChange();
															#line 1141 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (masterLifetime.isEqual(grvProxyData.db->get().masterLifetime) && grvProxyData.db->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION)
															#line 7229 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1143 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			grvProxyData.logSystem = ILogSystem::fromServerDBInfo(proxy.id(), grvProxyData.db->get(), false, addActor);
															#line 7233 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1146 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		grvProxyData.updateLatencyBandConfig(grvProxyData.db->get().latencyBandConfig);
															#line 7237 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state > 0) static_cast<GrvProxyServerCoreActor*>(this)->actor_wait_state = 0;
		static_cast<GrvProxyServerCoreActor*>(this)->ActorCallback< GrvProxyServerCoreActor, 1, Void >::remove();
		static_cast<GrvProxyServerCoreActor*>(this)->ActorCallback< GrvProxyServerCoreActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GrvProxyServerCoreActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerCoreActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GrvProxyServerCoreActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface proxy;
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	MasterInterface master;
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	LifetimeToken masterLifetime;
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1101 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyData grvProxyData;
															#line 1103 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	PromiseStream<Future<Void>> addActor;
															#line 1104 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> onError;
															#line 1106 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply healthMetricsReply;
															#line 1107 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GetHealthMetricsReply detailedHealthMetricsReply;
															#line 1123 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> dbInfoChange;
															#line 7395 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via grvProxyServerCore()
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GrvProxyServerCoreActor final : public Actor<Void>, public ActorCallback< GrvProxyServerCoreActor, 0, Void >, public ActorCallback< GrvProxyServerCoreActor, 1, Void >, public ActorCallback< GrvProxyServerCoreActor, 2, Void >, public FastAllocated<GrvProxyServerCoreActor>, public GrvProxyServerCoreActorState<GrvProxyServerCoreActor> {
															#line 7400 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GrvProxyServerCoreActor>::operator new;
	using FastAllocated<GrvProxyServerCoreActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4211288562289784320UL, 16524978445040898560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GrvProxyServerCoreActor, 0, Void >;
friend struct ActorCallback< GrvProxyServerCoreActor, 1, Void >;
friend struct ActorCallback< GrvProxyServerCoreActor, 2, Void >;
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyServerCoreActor(GrvProxyInterface const& proxy,MasterInterface const& master,LifetimeToken const& masterLifetime,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 7419 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GrvProxyServerCoreActorState<GrvProxyServerCoreActor>(proxy, master, masterLifetime, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("grvProxyServerCore", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6046041477836266752UL, 214675386595290880UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerCoreActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("grvProxyServerCore");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("grvProxyServerCore", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GrvProxyServerCoreActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GrvProxyServerCoreActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> grvProxyServerCore( GrvProxyInterface const& proxy, MasterInterface const& master, LifetimeToken const& masterLifetime, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 1097 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GrvProxyServerCoreActor(proxy, master, masterLifetime, db));
															#line 7453 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 1151 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 7458 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via checkRemoved()
															#line 1152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class CheckRemovedActor>
															#line 1152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class CheckRemovedActorState {
															#line 7465 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 1152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	CheckRemovedActorState(Reference<AsyncVar<ServerDBInfo> const> const& db,uint64_t const& recoveryCount,GrvProxyInterface const& myInterface) 
															#line 1152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 1152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : db(db),
															#line 1152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   recoveryCount(recoveryCount),
															#line 1152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   myInterface(myInterface)
															#line 7476 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("checkRemoved", reinterpret_cast<unsigned long>(this));

	}
	~CheckRemovedActorState() 
	{
		fdb_probe_actor_destroy("checkRemoved", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1155 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			;
															#line 7491 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckRemovedActorState();
		static_cast<CheckRemovedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (db->get().recoveryCount >= recoveryCount && std::find(db->get().client.grvProxies.begin(), db->get().client.grvProxies.end(), myInterface) == db->get().client.grvProxies.end())
															#line 7521 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		{
															#line 1159 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			return a_body1Catch1(worker_removed(), std::max(0, loopDepth - 1));
															#line 7525 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		}
															#line 1161 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		StrictFuture<Void> __when_expr_0 = db->onChange();
															#line 1161 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (static_cast<CheckRemovedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7531 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckRemovedActor*>(this)->actor_wait_state = 1;
															#line 1161 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckRemovedActor, 0, Void >*>(static_cast<CheckRemovedActor*>(this)));
															#line 7536 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckRemovedActor*>(this)->actor_wait_state > 0) static_cast<CheckRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRemovedActor*>(this)->ActorCallback< CheckRemovedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRemovedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckRemovedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckRemovedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	uint64_t recoveryCount;
															#line 1152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface myInterface;
															#line 7634 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via checkRemoved()
															#line 1152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class CheckRemovedActor final : public Actor<Void>, public ActorCallback< CheckRemovedActor, 0, Void >, public FastAllocated<CheckRemovedActor>, public CheckRemovedActorState<CheckRemovedActor> {
															#line 7639 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<CheckRemovedActor>::operator new;
	using FastAllocated<CheckRemovedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7413422232571201792UL, 4337475673204673792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckRemovedActor, 0, Void >;
															#line 1152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	CheckRemovedActor(Reference<AsyncVar<ServerDBInfo> const> const& db,uint64_t const& recoveryCount,GrvProxyInterface const& myInterface) 
															#line 7656 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   CheckRemovedActorState<CheckRemovedActor>(db, recoveryCount, myInterface),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkRemoved", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15518436168711072512UL, 6662910151609573120UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkRemoved");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkRemoved", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckRemovedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> checkRemoved( Reference<AsyncVar<ServerDBInfo> const> const& db, uint64_t const& recoveryCount, GrvProxyInterface const& myInterface ) {
															#line 1152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new CheckRemovedActor(db, recoveryCount, myInterface));
															#line 7689 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 1164 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"

															#line 7694 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
namespace {
// This generated class is to be used only via grvProxyServer()
															#line 1165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
template <class GrvProxyServerActor>
															#line 1165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GrvProxyServerActorState {
															#line 7701 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
															#line 1165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyServerActorState(GrvProxyInterface const& proxy,InitializeGrvProxyRequest const& req,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 1165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
															#line 1165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		 : proxy(proxy),
															#line 1165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   req(req),
															#line 1165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		   db(db)
															#line 7712 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
	{
		fdb_probe_actor_create("grvProxyServer", reinterpret_cast<unsigned long>(this));

	}
	~GrvProxyServerActorState() 
	{
		fdb_probe_actor_destroy("grvProxyServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1169 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				core = grvProxyServerCore(proxy, req.master, req.masterLifetime, db);
															#line 1170 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				StrictFuture<Void> __when_expr_0 = core || checkRemoved(db, req.recoveryCount, proxy);
															#line 1170 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				if (static_cast<GrvProxyServerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 7732 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GrvProxyServerActor*>(this)->actor_wait_state = 1;
															#line 1170 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GrvProxyServerActor, 0, Void >*>(static_cast<GrvProxyServerActor*>(this)));
															#line 7737 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GrvProxyServerActorState();
		static_cast<GrvProxyServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1184 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
		if (!static_cast<GrvProxyServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GrvProxyServerActorState(); static_cast<GrvProxyServerActor*>(this)->destroy(); return 0; }
															#line 7766 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		new (&static_cast<GrvProxyServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GrvProxyServerActorState();
		static_cast<GrvProxyServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1172 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			TraceEvent("GrvProxyTerminated", proxy.id()).errorUnsuppressed(e);
															#line 1173 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			ASSERT(e.code() != error_code_broken_promise);
															#line 1175 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			CODE_PROBE(e.code() == error_code_master_failed, "GrvProxyServer master failed");
															#line 1176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			CODE_PROBE(e.code() == error_code_tlog_failed, "GrvProxyServer tlog failed");
															#line 1177 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
			if (e.code() != error_code_worker_removed && e.code() != error_code_tlog_stopped && e.code() != error_code_tlog_failed && e.code() != error_code_coordinators_changed && e.code() != error_code_coordinated_state_conflict && e.code() != error_code_new_coordinators_timed_out && e.code() != error_code_master_failed)
															#line 7787 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			{
															#line 1181 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 7791 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GrvProxyServerActor*>(this)->actor_wait_state > 0) static_cast<GrvProxyServerActor*>(this)->actor_wait_state = 0;
		static_cast<GrvProxyServerActor*>(this)->ActorCallback< GrvProxyServerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GrvProxyServerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GrvProxyServerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GrvProxyServerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("grvProxyServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyInterface proxy;
															#line 1165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	InitializeGrvProxyRequest req;
															#line 1165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> db;
															#line 1169 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	Future<Void> core;
															#line 7911 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
};
// This generated class is to be used only via grvProxyServer()
															#line 1165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
class GrvProxyServerActor final : public Actor<Void>, public ActorCallback< GrvProxyServerActor, 0, Void >, public FastAllocated<GrvProxyServerActor>, public GrvProxyServerActorState<GrvProxyServerActor> {
															#line 7916 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
public:
	using FastAllocated<GrvProxyServerActor>::operator new;
	using FastAllocated<GrvProxyServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8538375819154562560UL, 214243901550812416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GrvProxyServerActor, 0, Void >;
															#line 1165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	GrvProxyServerActor(GrvProxyInterface const& proxy,InitializeGrvProxyRequest const& req,Reference<AsyncVar<ServerDBInfo> const> const& db) 
															#line 7933 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
		 : Actor<Void>(),
		   GrvProxyServerActorState<GrvProxyServerActor>(proxy, req, db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("grvProxyServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13905335545483414272UL, 8240318245689050112UL);
		ActorExecutionContextHelper __helper(static_cast<GrvProxyServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("grvProxyServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("grvProxyServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GrvProxyServerActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
[[nodiscard]] Future<Void> grvProxyServer( GrvProxyInterface const& proxy, InitializeGrvProxyRequest const& req, Reference<AsyncVar<ServerDBInfo> const> const& db ) {
															#line 1165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
	return Future<Void>(new GrvProxyServerActor(proxy, req, db));
															#line 7966 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/GrvProxyServer.actor.g.cpp"
}

#line 1186 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/GrvProxyServer.actor.cpp"
