#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
/*
 * BackupProgress.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/BackupProgress.actor.h"

#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "flow/UnitTest.h"
#include "flow/actorcompiler.h" // This must be the last #include.

void BackupProgress::addBackupStatus(const WorkerBackupStatus& status) {
	auto& it = progress[status.epoch];
	auto lb = it.lower_bound(status.tag);
	if (lb != it.end() && status.tag == lb->first) {
		if (lb->second < status.version) {
			lb->second = status.version;
		}
	} else {
		it.insert(lb, { status.tag, status.version });
	}

	auto tagIt = epochTags.find(status.epoch);
	if (tagIt == epochTags.end()) {
		epochTags.insert({ status.epoch, status.totalTags });
	} else {
		ASSERT(status.totalTags == tagIt->second);
	}
}

void BackupProgress::updateTagVersions(std::map<Tag, Version>* tagVersions,
                                       std::set<Tag>* tags,
                                       const std::map<Tag, Version>& progress,
                                       Version endVersion,
                                       Version adjustedBeginVersion,
                                       LogEpoch epoch) {
	for (const auto& [tag, savedVersion] : progress) {
		// If tag is not in "tags", it means the old epoch has more tags than
		// new epoch's tags. Just ignore the tag here.
		auto n = tags->erase(tag);
		if (n > 0 && savedVersion < endVersion - 1) {
			const Version beginVersion =
			    (savedVersion + 1 > adjustedBeginVersion) ? (savedVersion + 1) : adjustedBeginVersion;
			tagVersions->insert({ tag, beginVersion });
			TraceEvent("BackupVersionRange", dbgid)
			    .detail("OldEpoch", epoch)
			    .detail("Tag", tag.toString())
			    .detail("BeginVersion", savedVersion + 1)
			    .detail("AdjustedBeginVersion", beginVersion)
			    .detail("EndVersion", endVersion);
		}
	}
}

std::map<std::tuple<LogEpoch, Version, int>, std::map<Tag, Version>> BackupProgress::getUnfinishedBackup() {
	std::map<std::tuple<LogEpoch, Version, int>, std::map<Tag, Version>> toRecruit;

	if (!backupStartedValue.present())
		return toRecruit; // No active backups

	Version lastEnd = invalidVersion;
	for (const auto& [epoch, info] : epochInfos) {
		std::set<Tag> tags = enumerateLogRouterTags(info.logRouterTags);
		std::map<Tag, Version> tagVersions;

		// Sometimes, an epoch's begin version is lower than the previous epoch's
		// end version. In this case, adjust the epoch's begin version to be the
		// same as previous end version.
		Version adjustedBeginVersion = lastEnd > info.epochBegin ? lastEnd : info.epochBegin;
		lastEnd = info.epochEnd;

		auto progressIt = progress.lower_bound(epoch);
		if (progressIt != progress.end() && progressIt->first == epoch) {
			std::set<Tag> toCheck = tags;
			for (auto current = progressIt; current != progress.begin() && !toCheck.empty();) {
				auto prev = std::prev(current);
				// Previous epoch is gone, consolidate the progress.
				for (auto [tag, version] : prev->second) {
					if (toCheck.contains(tag)) {
						progressIt->second[tag] = std::max(version, progressIt->second[tag]);
						toCheck.erase(tag);
					}
				}
				current = prev;
			}
			updateTagVersions(&tagVersions, &tags, progressIt->second, info.epochEnd, adjustedBeginVersion, epoch);
		} else {
			auto rit = std::find_if(
			    progress.rbegin(),
			    progress.rend(),
			    [epoch = epoch](const std::pair<LogEpoch, std::map<Tag, Version>>& p) { return p.first < epoch; });
			while (!(rit == progress.rend())) {
				// A partial recovery can result in empty epoch that copies previous
				// epoch's version range. In this case, we should check previous
				// epoch's savedVersion.
				int savedMore = 0;
				for (auto [tag, version] : rit->second) {
					if (version >= info.epochBegin) {
						savedMore++;
					}
				}
				if (savedMore > 0) {
					// The logRouterTags are the same
					// ASSERT(info.logRouterTags == epochTags[rit->first]);

					updateTagVersions(&tagVersions, &tags, rit->second, info.epochEnd, adjustedBeginVersion, epoch);
					if (tags.empty())
						break;
				}
				rit++;
			}
		}

		for (const Tag& tag : tags) { // tags without progress data
			tagVersions.insert({ tag, adjustedBeginVersion });
			TraceEvent("BackupVersionRange", dbgid)
			    .detail("OldEpoch", epoch)
			    .detail("Tag", tag.toString())
			    .detail("BeginVersion", info.epochBegin)
			    .detail("AdjustedBeginVersion", adjustedBeginVersion)
			    .detail("EndVersion", info.epochEnd);
		}
		if (!tagVersions.empty()) {
			toRecruit[{ epoch, info.epochEnd, info.logRouterTags }] = tagVersions;
		}
	}
	return toRecruit;
}

// Save each tag's savedVersion for all epochs into "bStatus".
															#line 149 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
namespace {
// This generated class is to be used only via getBackupProgress()
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
template <class GetBackupProgressActor>
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
class GetBackupProgressActorState {
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
public:
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	GetBackupProgressActorState(Database const& cx,UID const& dbgid,Reference<BackupProgress> const& bStatus,bool const& logging) 
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		 : cx(cx),
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		   dbgid(dbgid),
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		   bStatus(bStatus),
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		   logging(logging),
															#line 148 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		   tr(cx)
															#line 171 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
	{
		fdb_probe_actor_create("getBackupProgress", reinterpret_cast<unsigned long>(this));

	}
	~GetBackupProgressActorState() 
	{
		fdb_probe_actor_destroy("getBackupProgress", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 150 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			;
															#line 186 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetBackupProgressActorState();
		static_cast<GetBackupProgressActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 152 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 153 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 154 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 155 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			fValue = tr.get(backupStartedKey);
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(backupProgressKeys, CLIENT_KNOBS->TOO_MANY);
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			if (static_cast<GetBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 227 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetBackupProgressActor*>(this)->actor_wait_state = 1;
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetBackupProgressActor, 0, RangeResult >*>(static_cast<GetBackupProgressActor*>(this)));
															#line 232 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			if (static_cast<GetBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 256 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetBackupProgressActor*>(this)->actor_wait_state = 3;
															#line 176 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetBackupProgressActor, 2, Void >*>(static_cast<GetBackupProgressActor*>(this)));
															#line 261 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 157 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		ASSERT(!results.more && results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 159 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = fValue;
															#line 159 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		if (static_cast<GetBackupProgressActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 280 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetBackupProgressActor*>(this)->actor_wait_state = 2;
															#line 159 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetBackupProgressActor, 1, Optional<Value> >*>(static_cast<GetBackupProgressActor*>(this)));
															#line 285 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __results,int loopDepth) 
	{
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		results = __results;
															#line 294 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __results,int loopDepth) 
	{
		results = std::move(__results);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetBackupProgressActor*>(this)->actor_wait_state > 0) static_cast<GetBackupProgressActor*>(this)->actor_wait_state = 0;
		static_cast<GetBackupProgressActor*>(this)->ActorCallback< GetBackupProgressActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetBackupProgressActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetBackupProgressActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetBackupProgressActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Value> const& value,int loopDepth) 
	{
															#line 160 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		bStatus->setBackupStartedValue(value);
															#line 161 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		for( auto& it : results ) {
															#line 162 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			const UID workerID = decodeBackupProgressKey(it.key);
															#line 163 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			const WorkerBackupStatus status = decodeBackupProgressValue(it.value);
															#line 164 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			bStatus->addBackupStatus(status);
															#line 165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			if (logging)
															#line 383 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
			{
															#line 166 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				TraceEvent("GotBackupProgress", dbgid) .detail("BackupWorker", workerID) .detail("Epoch", status.epoch) .detail("Version", status.version) .detail("Tag", status.tag.toString()) .detail("TotalTags", status.totalTags);
															#line 387 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
			}
		}
															#line 174 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		if (!static_cast<GetBackupProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetBackupProgressActorState(); static_cast<GetBackupProgressActor*>(this)->destroy(); return 0; }
															#line 392 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
		new (&static_cast<GetBackupProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetBackupProgressActorState();
		static_cast<GetBackupProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && value,int loopDepth) 
	{
															#line 160 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		bStatus->setBackupStartedValue(value);
															#line 161 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		for( auto& it : results ) {
															#line 162 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			const UID workerID = decodeBackupProgressKey(it.key);
															#line 163 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			const WorkerBackupStatus status = decodeBackupProgressValue(it.value);
															#line 164 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			bStatus->addBackupStatus(status);
															#line 165 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			if (logging)
															#line 414 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
			{
															#line 166 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				TraceEvent("GotBackupProgress", dbgid) .detail("BackupWorker", workerID) .detail("Epoch", status.epoch) .detail("Version", status.version) .detail("Tag", status.tag.toString()) .detail("TotalTags", status.totalTags);
															#line 418 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
			}
		}
															#line 174 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		if (!static_cast<GetBackupProgressActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetBackupProgressActorState(); static_cast<GetBackupProgressActor*>(this)->destroy(); return 0; }
															#line 423 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
		new (&static_cast<GetBackupProgressActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetBackupProgressActorState();
		static_cast<GetBackupProgressActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetBackupProgressActor*>(this)->actor_wait_state > 0) static_cast<GetBackupProgressActor*>(this)->actor_wait_state = 0;
		static_cast<GetBackupProgressActor*>(this)->ActorCallback< GetBackupProgressActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetBackupProgressActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetBackupProgressActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetBackupProgressActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetBackupProgressActor*>(this)->actor_wait_state > 0) static_cast<GetBackupProgressActor*>(this)->actor_wait_state = 0;
		static_cast<GetBackupProgressActor*>(this)->ActorCallback< GetBackupProgressActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetBackupProgressActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetBackupProgressActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetBackupProgressActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	Database cx;
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	UID dbgid;
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	Reference<BackupProgress> bStatus;
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	bool logging;
															#line 148 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	Transaction tr;
															#line 155 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	Future<Optional<Value>> fValue;
															#line 156 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	RangeResult results;
															#line 607 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
};
// This generated class is to be used only via getBackupProgress()
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
class GetBackupProgressActor final : public Actor<Void>, public ActorCallback< GetBackupProgressActor, 0, RangeResult >, public ActorCallback< GetBackupProgressActor, 1, Optional<Value> >, public ActorCallback< GetBackupProgressActor, 2, Void >, public FastAllocated<GetBackupProgressActor>, public GetBackupProgressActorState<GetBackupProgressActor> {
															#line 612 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
public:
	using FastAllocated<GetBackupProgressActor>::operator new;
	using FastAllocated<GetBackupProgressActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14984574423132943104UL, 15899507777698930432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetBackupProgressActor, 0, RangeResult >;
friend struct ActorCallback< GetBackupProgressActor, 1, Optional<Value> >;
friend struct ActorCallback< GetBackupProgressActor, 2, Void >;
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	GetBackupProgressActor(Database const& cx,UID const& dbgid,Reference<BackupProgress> const& bStatus,bool const& logging) 
															#line 631 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
		 : Actor<Void>(),
		   GetBackupProgressActorState<GetBackupProgressActor>(cx, dbgid, bStatus, logging),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getBackupProgress", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9203706318277777920UL, 8609133948190877696UL);
		ActorExecutionContextHelper __helper(static_cast<GetBackupProgressActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getBackupProgress");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getBackupProgress", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetBackupProgressActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetBackupProgressActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetBackupProgressActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
[[nodiscard]] Future<Void> getBackupProgress( Database const& cx, UID const& dbgid, Reference<BackupProgress> const& bStatus, bool const& logging ) {
															#line 147 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	return Future<Void>(new GetBackupProgressActor(cx, dbgid, bStatus, logging));
															#line 666 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
}

#line 180 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"

															#line 671 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase181()
															#line 181 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
template <class FlowTestCase181Actor>
															#line 181 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
class FlowTestCase181ActorState {
															#line 678 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
public:
															#line 181 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	FlowTestCase181ActorState(UnitTestParameters const& params) 
															#line 181 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
															#line 181 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
		 : params(params)
															#line 685 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase181", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase181ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase181", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 182 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			std::map<LogEpoch, ILogSystem::EpochTagsVersionsInfo> epochInfos;
															#line 184 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			const int epoch1 = 2, begin1 = 1, end1 = 100;
															#line 185 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			const Tag tag1(tagLocalityLogRouter, 0);
															#line 186 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			epochInfos.insert({ epoch1, ILogSystem::EpochTagsVersionsInfo(1, begin1, end1) });
															#line 187 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			BackupProgress progress(UID(0, 0), epochInfos);
															#line 188 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			progress.setBackupStartedValue(Optional<Value>("1"_sr));
															#line 190 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			std::map<std::tuple<LogEpoch, Version, int>, std::map<Tag, Version>> unfinished = progress.getUnfinishedBackup();
															#line 192 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			ASSERT(unfinished.size() == 1);
															#line 193 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			for( const auto& [epochVersionCount, tagVersion] : unfinished ) {
															#line 194 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				ASSERT(std::get<0>(epochVersionCount) == epoch1 && std::get<1>(epochVersionCount) == end1 && std::get<2>(epochVersionCount) == 1);
															#line 196 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				ASSERT(tagVersion.size() == 1 && tagVersion.begin()->first == tag1 && tagVersion.begin()->second == begin1);
															#line 720 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
			}
															#line 199 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			const int saved1 = 50, totalTags = 1;
															#line 200 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			WorkerBackupStatus status1(epoch1, saved1, tag1, totalTags);
															#line 201 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			progress.addBackupStatus(status1);
															#line 202 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			unfinished = progress.getUnfinishedBackup();
															#line 203 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			ASSERT(unfinished.size() == 1);
															#line 204 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			for( const auto& [epochVersionCount, tagVersion] : unfinished ) {
															#line 205 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				ASSERT(std::get<0>(epochVersionCount) == epoch1 && std::get<1>(epochVersionCount) == end1 && std::get<2>(epochVersionCount) == 1);
															#line 207 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
				ASSERT(tagVersion.size() == 1 && tagVersion.begin()->first == tag1 && tagVersion.begin()->second == saved1 + 1);
															#line 738 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
			}
															#line 210 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
			if (!static_cast<FlowTestCase181Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase181ActorState(); static_cast<FlowTestCase181Actor*>(this)->destroy(); return 0; }
															#line 742 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
			new (&static_cast<FlowTestCase181Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase181ActorState();
			static_cast<FlowTestCase181Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase181ActorState();
		static_cast<FlowTestCase181Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 181 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	UnitTestParameters params;
															#line 766 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase181()
															#line 181 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
class FlowTestCase181Actor final : public Actor<Void>, public FastAllocated<FlowTestCase181Actor>, public FlowTestCase181ActorState<FlowTestCase181Actor> {
															#line 771 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase181Actor>::operator new;
	using FastAllocated<FlowTestCase181Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8281530218568106496UL, 17919824755754948608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 181 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	FlowTestCase181Actor(UnitTestParameters const& params) 
															#line 787 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase181ActorState<FlowTestCase181Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase181", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(989090039673791232UL, 13530194818726815232UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase181Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase181");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase181", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 181 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
static Future<Void> flowTestCase181( UnitTestParameters const& params ) {
															#line 181 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
	return Future<Void>(new FlowTestCase181Actor(params));
															#line 819 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/build_output/fdbserver/BackupProgress.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase181, "/BackupProgress/Unfinished")

#line 212 "/codebuild/output/src4281317892/src/github.com/apple/foundationdb/fdbserver/BackupProgress.actor.cpp"
