#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
/*
 * ClogTlog.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/GenericManagementAPI.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbrpc/Locality.h"
#include "fdbrpc/SimulatorProcessInfo.h"
#include "fdbserver/RecoveryState.h"
#include "fdbserver/ServerDBInfo.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbrpc/simulator.h"
#include "flow/CodeProbe.h"
#include "flow/NetworkAddress.h"
#include "flow/Error.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "flow/network.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// This workload tests a gray failure scenario: a single TLog is network-partitioned from
// the rest of the cluster, except the cluster controller. This will cause proxies to
// fail to progress, and trigger a recovery. During the recovery, if this TLog is again
// recruited, the recovery can become stuck in the initializing_transaction_servers state.
// If that happens, the workload will start a "configure force exclude=IP:PORT" for the
// TLog, which would unblock the recovery to reach fully_recovered state.
struct ClogTlogWorkload : TestWorkload {
	static constexpr auto NAME = "ClogTlog";
	bool enabled;
	double testDuration;
	bool clogged = false;
	bool useDisconnection = false;
	Optional<NetworkAddress> tlog; // the tlog to be clogged with all other processes except the CC
	std::vector<std::pair<IPAddress, IPAddress>> cloggedPairs;

	ClogTlogWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		enabled = !clientId; // only do this on the "first" client
		testDuration = getOption(options, "testDuration"_sr, 1000.0);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override {
		if (g_network->isSimulated() && enabled)
			return timeout(reportErrors(clogClient(this, cx), "ClogTlogError"), testDuration, Void());
		else
			return Void();
	}
	Future<bool> check(Database const& cx) override { return true; }
	void getMetrics(std::vector<PerfMetric>& m) override {}

	// Clog a random tlog with all other processes so that this triggers a recovery
	// and the recovery may become stuck if the clogged tlog is recruited again.
	void clogTlog(double seconds) {
		ASSERT(dbInfo->get().recoveryState >= RecoveryState::RECOVERY_TRANSACTION);

		IPAddress cc = dbInfo->get().clusterInterface.address().ip;
		std::vector<IPAddress> ips; // all FDB process IPs
		for (const auto& process : g_simulator->getAllProcesses()) {
			const auto& ip = process->address.ip;
			if (process->startingClass != ProcessClass::TesterClass) {
				ips.push_back(ip);
			}
		}
		ASSERT(ips.size() > 0);

		// Find all primary tlogs
		std::vector<NetworkAddress> logs; // all primary logs except CC
		for (int i = 0; i < dbInfo->get().logSystemConfig.tLogs.size(); i++) {
			const auto& tlogset = dbInfo->get().logSystemConfig.tLogs[i];
			if (!tlogset.isLocal)
				continue;
			for (const auto& log : tlogset.tLogs) {
				const NetworkAddress& addr = log.interf().address();
				if (cc != addr.ip) {
					if (!tlog.present()) {
						tlog = addr;
					}
					logs.push_back(addr);
				}
			}
		}
		ASSERT(logs.size() > 0 && tlog.present());

		// clog pairs
		for (const auto& ip : ips) {
			if (ip != tlog.get().ip && ip != cc) {
				if (useDisconnection) {
					g_simulator->disconnectPair(ip, tlog.get().ip, seconds);
					g_simulator->disconnectPair(tlog.get().ip, ip, seconds);
				} else {
					g_simulator->clogPair(ip, tlog.get().ip, seconds);
					g_simulator->clogPair(tlog.get().ip, ip, seconds);
				}
				cloggedPairs.emplace_back(ip, tlog.get().ip);
				cloggedPairs.emplace_back(tlog.get().ip, ip);
			}
		}
		clogged = true;
	}

	void unclogAll() {
		// unclog previously clogged connections
		for (const auto& pair : cloggedPairs) {
			if (useDisconnection) {
				g_simulator->reconnectPair(pair.first, pair.second);
			} else {
				g_simulator->unclogPair(pair.first, pair.second);
			}
		}
		cloggedPairs.clear();
	}

																#line 133 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
// This generated class is to be used only via excludeFailedLog()
															#line 131 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
template <class ExcludeFailedLogActor>
															#line 131 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
class ExcludeFailedLogActorState {
															#line 139 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
public:
															#line 131 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
	ExcludeFailedLogActorState(ClogTlogWorkload* const& self,Database const& cx) 
															#line 131 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
															#line 131 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		 : self(self),
															#line 131 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		   cx(cx)
															#line 148 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
	{
		fdb_probe_actor_create("excludeFailedLog", reinterpret_cast<unsigned long>(this));

	}
	~ExcludeFailedLogActorState() 
	{
		fdb_probe_actor_destroy("excludeFailedLog", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 132 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			;
															#line 163 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExcludeFailedLogActorState();
		static_cast<ExcludeFailedLogActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 133 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		StrictFuture<Void> __when_expr_0 = self->dbInfo->onChange();
															#line 132 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (static_cast<ExcludeFailedLogActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 195 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
															#line 138 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(30);
															#line 199 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
		static_cast<ExcludeFailedLogActor*>(this)->actor_wait_state = 1;
															#line 133 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExcludeFailedLogActor, 0, Void >*>(static_cast<ExcludeFailedLogActor*>(this)));
															#line 138 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExcludeFailedLogActor, 1, Void >*>(static_cast<ExcludeFailedLogActor*>(this)));
															#line 206 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 134 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (self->dbInfo->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS)
															#line 221 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		{
															#line 135 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			if (!static_cast<ExcludeFailedLogActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ExcludeFailedLogActorState(); static_cast<ExcludeFailedLogActor*>(this)->destroy(); return 0; }
															#line 225 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
			new (&static_cast<ExcludeFailedLogActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ExcludeFailedLogActorState();
			static_cast<ExcludeFailedLogActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
															#line 134 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (self->dbInfo->get().recoveryState >= RecoveryState::ACCEPTING_COMMITS)
															#line 239 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		{
															#line 135 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			if (!static_cast<ExcludeFailedLogActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ExcludeFailedLogActorState(); static_cast<ExcludeFailedLogActor*>(this)->destroy(); return 0; }
															#line 243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
			new (&static_cast<ExcludeFailedLogActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ExcludeFailedLogActorState();
			static_cast<ExcludeFailedLogActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 140 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		CODE_PROBE(true, "Exclude failed tlog");
															#line 141 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		TraceEvent("ExcludeFailedLog") .detail("TLog", self->tlog.get()) .detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 144 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		std::string modes = "exclude=" + formatIpPort(self->tlog.get().ip, self->tlog.get().port);
															#line 145 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		StrictFuture<ConfigurationResult> __when_expr_2 = ManagementAPI::changeConfig(cx.getReference(), modes, true);
															#line 145 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (static_cast<ExcludeFailedLogActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 265 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ExcludeFailedLogActor*>(this)->actor_wait_state = 2;
															#line 145 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExcludeFailedLogActor, 2, ConfigurationResult >*>(static_cast<ExcludeFailedLogActor*>(this)));
															#line 270 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
															#line 140 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		CODE_PROBE(true, "Exclude failed tlog");
															#line 141 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		TraceEvent("ExcludeFailedLog") .detail("TLog", self->tlog.get()) .detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 144 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		std::string modes = "exclude=" + formatIpPort(self->tlog.get().ip, self->tlog.get().port);
															#line 145 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		StrictFuture<ConfigurationResult> __when_expr_2 = ManagementAPI::changeConfig(cx.getReference(), modes, true);
															#line 145 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (static_cast<ExcludeFailedLogActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 287 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ExcludeFailedLogActor*>(this)->actor_wait_state = 2;
															#line 145 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ExcludeFailedLogActor, 2, ConfigurationResult >*>(static_cast<ExcludeFailedLogActor*>(this)));
															#line 292 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExcludeFailedLogActor*>(this)->actor_wait_state > 0) static_cast<ExcludeFailedLogActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeFailedLogActor*>(this)->ActorCallback< ExcludeFailedLogActor, 0, Void >::remove();
		static_cast<ExcludeFailedLogActor*>(this)->ActorCallback< ExcludeFailedLogActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeFailedLogActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("excludeFailedLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeFailedLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeFailedLog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExcludeFailedLogActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("excludeFailedLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeFailedLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeFailedLog", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExcludeFailedLogActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("excludeFailedLog", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeFailedLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeFailedLog", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1when2cont1(ConfigurationResult const& r,int loopDepth) 
	{
															#line 146 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		TraceEvent("ExcludeFailedLog").detail("Result", r);
															#line 147 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (!static_cast<ExcludeFailedLogActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ExcludeFailedLogActorState(); static_cast<ExcludeFailedLogActor*>(this)->destroy(); return 0; }
															#line 367 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		new (&static_cast<ExcludeFailedLogActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ExcludeFailedLogActorState();
		static_cast<ExcludeFailedLogActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2cont1(ConfigurationResult && r,int loopDepth) 
	{
															#line 146 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		TraceEvent("ExcludeFailedLog").detail("Result", r);
															#line 147 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (!static_cast<ExcludeFailedLogActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ExcludeFailedLogActorState(); static_cast<ExcludeFailedLogActor*>(this)->destroy(); return 0; }
															#line 381 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		new (&static_cast<ExcludeFailedLogActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ExcludeFailedLogActorState();
		static_cast<ExcludeFailedLogActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when2when1(ConfigurationResult const& r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(r, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2when1(ConfigurationResult && r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1when2cont1(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExcludeFailedLogActor*>(this)->actor_wait_state > 0) static_cast<ExcludeFailedLogActor*>(this)->actor_wait_state = 0;
		static_cast<ExcludeFailedLogActor*>(this)->ActorCallback< ExcludeFailedLogActor, 2, ConfigurationResult >::remove();

	}
	void a_callback_fire(ActorCallback< ExcludeFailedLogActor, 2, ConfigurationResult >*,ConfigurationResult const& value) 
	{
		fdb_probe_actor_enter("excludeFailedLog", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeFailedLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeFailedLog", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExcludeFailedLogActor, 2, ConfigurationResult >*,ConfigurationResult && value) 
	{
		fdb_probe_actor_enter("excludeFailedLog", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeFailedLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeFailedLog", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ExcludeFailedLogActor, 2, ConfigurationResult >*,Error err) 
	{
		fdb_probe_actor_enter("excludeFailedLog", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeFailedLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeFailedLog", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ExcludeFailedLogActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("excludeFailedLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeFailedLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeFailedLog", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExcludeFailedLogActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("excludeFailedLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeFailedLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeFailedLog", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExcludeFailedLogActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("excludeFailedLog", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeFailedLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("excludeFailedLog", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 131 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
	ClogTlogWorkload* self;
															#line 131 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
	Database cx;
															#line 525 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
};
// This generated class is to be used only via excludeFailedLog()
															#line 131 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
class ExcludeFailedLogActor final : public Actor<Void>, public ActorCallback< ExcludeFailedLogActor, 0, Void >, public ActorCallback< ExcludeFailedLogActor, 1, Void >, public ActorCallback< ExcludeFailedLogActor, 2, ConfigurationResult >, public FastAllocated<ExcludeFailedLogActor>, public ExcludeFailedLogActorState<ExcludeFailedLogActor> {
															#line 530 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
public:
	using FastAllocated<ExcludeFailedLogActor>::operator new;
	using FastAllocated<ExcludeFailedLogActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10662441050318582272UL, 17559876318790184960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExcludeFailedLogActor, 0, Void >;
friend struct ActorCallback< ExcludeFailedLogActor, 1, Void >;
friend struct ActorCallback< ExcludeFailedLogActor, 2, ConfigurationResult >;
															#line 131 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
	ExcludeFailedLogActor(ClogTlogWorkload* const& self,Database const& cx) 
															#line 549 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		 : Actor<Void>(),
		   ExcludeFailedLogActorState<ExcludeFailedLogActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("excludeFailedLog", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17691880574403815680UL, 13316127376611693056UL);
		ActorExecutionContextHelper __helper(static_cast<ExcludeFailedLogActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("excludeFailedLog");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("excludeFailedLog", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExcludeFailedLogActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExcludeFailedLogActor, 2, ConfigurationResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 131 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
[[nodiscard]] static Future<Void> excludeFailedLog( ClogTlogWorkload* const& self, Database const& cx ) {
															#line 131 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
	return Future<Void>(new ExcludeFailedLogActor(self, cx));
															#line 582 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
}

#line 151 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"

																#line 587 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
// This generated class is to be used only via clogClient()
															#line 152 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
template <class ClogClientActor>
															#line 152 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
class ClogClientActorState {
															#line 593 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
public:
															#line 152 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
	ClogClientActorState(ClogTlogWorkload* const& self,Database const& cx) 
															#line 152 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
															#line 152 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		 : self(self),
															#line 152 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		   cx(cx)
															#line 602 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
	{
		fdb_probe_actor_create("clogClient", reinterpret_cast<unsigned long>(this));

	}
	~ClogClientActorState() 
	{
		fdb_probe_actor_destroy("clogClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 153 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 617 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
			{
															#line 154 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
				self->useDisconnection = true;
															#line 621 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
			}
															#line 158 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(20.0);
															#line 158 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			if (static_cast<ClogClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 627 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClogClientActor*>(this)->actor_wait_state = 1;
															#line 158 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClogClientActor, 0, Void >*>(static_cast<ClogClientActor*>(this)));
															#line 632 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClogClientActorState();
		static_cast<ClogClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 160 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		;
															#line 655 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 160 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		;
															#line 664 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClogClientActor*>(this)->actor_wait_state > 0) static_cast<ClogClientActor*>(this)->actor_wait_state = 0;
		static_cast<ClogClientActor*>(this)->ActorCallback< ClogClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClogClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 164 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		double startTime = now();
															#line 165 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		workloadEnd = now() + self->testDuration - 10;
															#line 166 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		TraceEvent("ClogTlog").detail("StartTime", startTime).detail("EndTime", workloadEnd);
															#line 169 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		self->clogTlog(workloadEnd - now());
															#line 170 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		;
															#line 756 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 160 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (!(self->dbInfo->get().recoveryState < RecoveryState::FULLY_RECOVERED))
															#line 772 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 161 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->dbInfo->onChange();
															#line 161 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (static_cast<ClogClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 780 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClogClientActor*>(this)->actor_wait_state = 2;
															#line 161 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClogClientActor, 1, Void >*>(static_cast<ClogClientActor*>(this)));
															#line 785 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClogClientActor*>(this)->actor_wait_state > 0) static_cast<ClogClientActor*>(this)->actor_wait_state = 0;
		static_cast<ClogClientActor*>(this)->ActorCallback< ClogClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClogClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 174 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		useGrayFailureToRecover = false;
															#line 175 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (deterministicRandom()->coinflip() && self->useDisconnection)
															#line 896 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		{
															#line 177 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			TraceEvent("ClogTLogUseGrayFailreToRecover").log();
															#line 178 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			useGrayFailureToRecover = true;
															#line 902 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		}
															#line 183 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		excludeLog = useGrayFailureToRecover ? Never() : excludeFailedLog(self, cx);
															#line 184 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		onChange = self->dbInfo->onChange();
															#line 185 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		;
															#line 910 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 170 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (!(self->dbInfo->get().recoveryState == RecoveryState::FULLY_RECOVERED))
															#line 926 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 171 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		StrictFuture<Void> __when_expr_2 = self->dbInfo->onChange();
															#line 171 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (static_cast<ClogClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 934 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ClogClientActor*>(this)->actor_wait_state = 3;
															#line 171 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClogClientActor, 2, Void >*>(static_cast<ClogClientActor*>(this)));
															#line 939 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClogClientActor*>(this)->actor_wait_state > 0) static_cast<ClogClientActor*>(this)->actor_wait_state = 0;
		static_cast<ClogClientActor*>(this)->ActorCallback< ClogClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClogClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 186 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		StrictFuture<Void> __when_expr_3 = onChange;
															#line 185 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (static_cast<ClogClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1057 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when1(__when_expr_3.get(), loopDepth); };
															#line 194 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delayUntil(workloadEnd);
															#line 1061 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1when2(__when_expr_4.get(), loopDepth); };
		static_cast<ClogClientActor*>(this)->actor_wait_state = 4;
															#line 186 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ClogClientActor, 3, Void >*>(static_cast<ClogClientActor*>(this)));
															#line 194 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ClogClientActor, 4, Void >*>(static_cast<ClogClientActor*>(this)));
															#line 1068 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void const& _,int loopDepth) 
	{
															#line 187 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (self->dbInfo->get().recoveryState == RecoveryState::FULLY_RECOVERED)
															#line 1083 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		{
															#line 188 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			TraceEvent("ClogDoneFullyRecovered").log();
															#line 189 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			self->unclogAll();
															#line 190 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			if (!static_cast<ClogClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClogClientActorState(); static_cast<ClogClientActor*>(this)->destroy(); return 0; }
															#line 1091 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
			new (&static_cast<ClogClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ClogClientActorState();
			static_cast<ClogClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 192 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		onChange = self->dbInfo->onChange();
															#line 1099 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when1(Void && _,int loopDepth) 
	{
															#line 187 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (self->dbInfo->get().recoveryState == RecoveryState::FULLY_RECOVERED)
															#line 1108 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		{
															#line 188 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			TraceEvent("ClogDoneFullyRecovered").log();
															#line 189 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			self->unclogAll();
															#line 190 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
			if (!static_cast<ClogClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClogClientActorState(); static_cast<ClogClientActor*>(this)->destroy(); return 0; }
															#line 1116 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
			new (&static_cast<ClogClientActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ClogClientActorState();
			static_cast<ClogClientActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 192 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		onChange = self->dbInfo->onChange();
															#line 1124 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		loopDepth = a_body1cont4loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 196 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		TraceEvent(SevError, "ClogTLogFailure").detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 197 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (!static_cast<ClogClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClogClientActorState(); static_cast<ClogClientActor*>(this)->destroy(); return 0; }
															#line 1135 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		new (&static_cast<ClogClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClogClientActorState();
		static_cast<ClogClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1when2(Void && _,int loopDepth) 
	{
															#line 196 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		TraceEvent(SevError, "ClogTLogFailure").detail("RecoveryState", self->dbInfo->get().recoveryState);
															#line 197 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
		if (!static_cast<ClogClientActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClogClientActorState(); static_cast<ClogClientActor*>(this)->destroy(); return 0; }
															#line 1149 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		new (&static_cast<ClogClientActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClogClientActorState();
		static_cast<ClogClientActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ClogClientActor*>(this)->actor_wait_state > 0) static_cast<ClogClientActor*>(this)->actor_wait_state = 0;
		static_cast<ClogClientActor*>(this)->ActorCallback< ClogClientActor, 3, Void >::remove();
		static_cast<ClogClientActor*>(this)->ActorCallback< ClogClientActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ClogClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ClogClientActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ClogClientActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 152 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
	ClogTlogWorkload* self;
															#line 152 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
	Database cx;
															#line 165 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
	double workloadEnd;
															#line 174 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
	bool useGrayFailureToRecover;
															#line 183 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
	Future<Void> excludeLog;
															#line 184 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
	Future<Void> onChange;
															#line 1290 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
};
// This generated class is to be used only via clogClient()
															#line 152 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
class ClogClientActor final : public Actor<Void>, public ActorCallback< ClogClientActor, 0, Void >, public ActorCallback< ClogClientActor, 1, Void >, public ActorCallback< ClogClientActor, 2, Void >, public ActorCallback< ClogClientActor, 3, Void >, public ActorCallback< ClogClientActor, 4, Void >, public FastAllocated<ClogClientActor>, public ClogClientActorState<ClogClientActor> {
															#line 1295 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
public:
	using FastAllocated<ClogClientActor>::operator new;
	using FastAllocated<ClogClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18400305532064075520UL, 10399799598661376512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClogClientActor, 0, Void >;
friend struct ActorCallback< ClogClientActor, 1, Void >;
friend struct ActorCallback< ClogClientActor, 2, Void >;
friend struct ActorCallback< ClogClientActor, 3, Void >;
friend struct ActorCallback< ClogClientActor, 4, Void >;
															#line 152 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
	ClogClientActor(ClogTlogWorkload* const& self,Database const& cx) 
															#line 1316 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
		 : Actor<Void>(),
		   ClogClientActorState<ClogClientActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clogClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6639068557903887104UL, 1016936592221440256UL);
		ActorExecutionContextHelper __helper(static_cast<ClogClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clogClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clogClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClogClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClogClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClogClientActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ClogClientActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 152 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
[[nodiscard]] Future<Void> clogClient( ClogTlogWorkload* const& self, Database const& cx ) {
															#line 152 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
	return Future<Void>(new ClogClientActor(self, cx));
															#line 1351 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ClogTlog.actor.g.cpp"
}

#line 201 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/workloads/ClogTlog.actor.cpp"
};

WorkloadFactory<ClogTlogWorkload> ClogTlogWorkloadFactory;
