#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
/*
 * DataDistributionTracker.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/FDBTypes.h"
#include "fdbclient/StorageServerInterface.h"
#include "fdbrpc/FailureMonitor.h"
#include "fdbclient/SystemData.h"
#include "fdbserver/DataDistribution.actor.h"
#include "fdbserver/DDSharedContext.h"
#include "fdbserver/TenantCache.h"
#include "fdbserver/Knobs.h"
#include "flow/ActorCollection.h"
#include "flow/Arena.h"
#include "flow/CodeProbe.h"
#include "flow/FastRef.h"
#include "flow/Trace.h"
#include "fdbserver/DDShardTracker.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// The used bandwidth of a shard. The higher the value is, the busier the shard is.
enum BandwidthStatus { BandwidthStatusLow, BandwidthStatusNormal, BandwidthStatusHigh };

enum ReadBandwidthStatus { ReadBandwidthStatusNormal, ReadBandwidthStatusHigh };

BandwidthStatus getBandwidthStatus(StorageMetrics const& metrics) {
	if (metrics.bytesWrittenPerKSecond > SERVER_KNOBS->SHARD_MAX_BYTES_PER_KSEC)
		return BandwidthStatusHigh;
	else if (metrics.bytesWrittenPerKSecond < SERVER_KNOBS->SHARD_MIN_BYTES_PER_KSEC)
		return BandwidthStatusLow;

	return BandwidthStatusNormal;
}

ReadBandwidthStatus getReadBandwidthStatus(StorageMetrics const& metrics) {
	if (metrics.bytesReadPerKSecond <= SERVER_KNOBS->SHARD_READ_HOT_BANDWIDTH_MIN_PER_KSECONDS ||
	    metrics.bytesReadPerKSecond <= SERVER_KNOBS->SHARD_MAX_READ_DENSITY_RATIO * metrics.bytes *
	                                       SERVER_KNOBS->STORAGE_METRICS_AVERAGE_INTERVAL_PER_KSECONDS) {
		return ReadBandwidthStatusNormal;
	} else {
		return ReadBandwidthStatusHigh;
	}
}

															#line 63 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via updateMaxShardSize()
															#line 61 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class UpdateMaxShardSizeActor>
															#line 61 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class UpdateMaxShardSizeActorState {
															#line 70 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 61 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	UpdateMaxShardSizeActorState(Reference<AsyncVar<int64_t>> const& dbSizeEstimate,Reference<AsyncVar<Optional<int64_t>>> const& maxShardSize) 
															#line 61 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 61 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : dbSizeEstimate(dbSizeEstimate),
															#line 61 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   maxShardSize(maxShardSize),
															#line 63 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   lastDbSize(0),
															#line 64 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   granularity(g_network->isSimulated() ? SERVER_KNOBS->DD_SHARD_SIZE_GRANULARITY_SIM : SERVER_KNOBS->DD_SHARD_SIZE_GRANULARITY)
															#line 83 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("updateMaxShardSize", reinterpret_cast<unsigned long>(this));

	}
	~UpdateMaxShardSizeActorState() 
	{
		fdb_probe_actor_destroy("updateMaxShardSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 66 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			;
															#line 98 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateMaxShardSizeActorState();
		static_cast<UpdateMaxShardSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 67 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto sizeDelta = std::abs(dbSizeEstimate->get() - lastDbSize);
															#line 68 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (sizeDelta > granularity || !maxShardSize->get().present())
															#line 130 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 69 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			auto v = getMaxShardSize(dbSizeEstimate->get());
															#line 70 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			maxShardSize->set(v);
															#line 71 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			lastDbSize = dbSizeEstimate->get();
															#line 138 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 73 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = dbSizeEstimate->onChange();
															#line 73 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<UpdateMaxShardSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 144 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<UpdateMaxShardSizeActor*>(this)->actor_wait_state = 1;
															#line 73 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateMaxShardSizeActor, 0, Void >*>(static_cast<UpdateMaxShardSizeActor*>(this)));
															#line 149 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateMaxShardSizeActor*>(this)->actor_wait_state > 0) static_cast<UpdateMaxShardSizeActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateMaxShardSizeActor*>(this)->ActorCallback< UpdateMaxShardSizeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateMaxShardSizeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateMaxShardSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMaxShardSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMaxShardSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateMaxShardSizeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateMaxShardSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMaxShardSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMaxShardSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateMaxShardSizeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateMaxShardSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMaxShardSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateMaxShardSize", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 61 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<int64_t>> dbSizeEstimate;
															#line 61 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<int64_t>>> maxShardSize;
															#line 63 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int64_t lastDbSize;
															#line 64 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int64_t granularity;
															#line 249 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via updateMaxShardSize()
															#line 61 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class UpdateMaxShardSizeActor final : public Actor<Void>, public ActorCallback< UpdateMaxShardSizeActor, 0, Void >, public FastAllocated<UpdateMaxShardSizeActor>, public UpdateMaxShardSizeActorState<UpdateMaxShardSizeActor> {
															#line 254 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<UpdateMaxShardSizeActor>::operator new;
	using FastAllocated<UpdateMaxShardSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11020666683029111040UL, 5493300666061687808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateMaxShardSizeActor, 0, Void >;
															#line 61 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	UpdateMaxShardSizeActor(Reference<AsyncVar<int64_t>> const& dbSizeEstimate,Reference<AsyncVar<Optional<int64_t>>> const& maxShardSize) 
															#line 271 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   UpdateMaxShardSizeActorState<UpdateMaxShardSizeActor>(dbSizeEstimate, maxShardSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateMaxShardSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17771926794046547712UL, 18273101803754460160UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateMaxShardSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateMaxShardSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateMaxShardSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateMaxShardSizeActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 61 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> updateMaxShardSize( Reference<AsyncVar<int64_t>> const& dbSizeEstimate, Reference<AsyncVar<Optional<int64_t>>> const& maxShardSize ) {
															#line 61 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new UpdateMaxShardSizeActor(dbSizeEstimate, maxShardSize));
															#line 304 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 76 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

void restartShardTrackers(DataDistributionTracker* self,
                          KeyRangeRef keys,
                          Optional<ShardMetrics> startingMetrics = Optional<ShardMetrics>(),
                          bool whenDDInit = false);

// Gets the permitted size and IO bounds for a shard. A shard that starts at allKeys.begin
//  (i.e. '') will have a permitted size of 0, since the database can contain no data.
ShardSizeBounds getShardSizeBounds(KeyRangeRef shard, int64_t maxShardSize) {
	ShardSizeBounds bounds;

	if (shard.begin >= keyServersKeys.begin) {
		bounds.max.bytes = SERVER_KNOBS->KEY_SERVER_SHARD_BYTES;
	} else {
		bounds.max.bytes = maxShardSize;
	}

	bounds.max.bytesWrittenPerKSecond = bounds.max.infinity;
	bounds.max.iosPerKSecond = bounds.max.infinity;
	bounds.max.bytesReadPerKSecond = bounds.max.infinity;
	bounds.max.opsReadPerKSecond = bounds.max.infinity;

	// The first shard can have arbitrarily small size
	if (shard.begin == allKeys.begin) {
		bounds.min.bytes = 0;
	} else {
		bounds.min.bytes = maxShardSize / SERVER_KNOBS->SHARD_BYTES_RATIO;
	}

	bounds.min.bytesWrittenPerKSecond = 0;
	bounds.min.iosPerKSecond = 0;
	bounds.min.bytesReadPerKSecond = 0;
	bounds.min.opsReadPerKSecond = 0;

	// The permitted error is 1/3 of the general-case minimum bytes (even in the special case where this is the last
	// shard)
	bounds.permittedError.bytes = bounds.max.bytes / SERVER_KNOBS->SHARD_BYTES_RATIO / 3;
	bounds.permittedError.bytesWrittenPerKSecond = bounds.permittedError.infinity;
	bounds.permittedError.iosPerKSecond = bounds.permittedError.infinity;
	bounds.permittedError.bytesReadPerKSecond = bounds.permittedError.infinity;
	bounds.permittedError.opsReadPerKSecond = bounds.permittedError.infinity;

	return bounds;
}

int64_t getMaxShardSize(double dbSizeEstimate) {
	int64_t size = std::min((SERVER_KNOBS->MIN_SHARD_BYTES + (int64_t)std::sqrt(std::max<double>(dbSizeEstimate, 0)) *
	                                                             SERVER_KNOBS->SHARD_BYTES_PER_SQRT_BYTES) *
	                            SERVER_KNOBS->SHARD_BYTES_RATIO,
	                        (int64_t)SERVER_KNOBS->MAX_SHARD_BYTES);
	if (SERVER_KNOBS->ALLOW_LARGE_SHARD) {
		size = std::max(size, static_cast<int64_t>(SERVER_KNOBS->MAX_LARGE_SHARD_BYTES));
	}

	TraceEvent("MaxShardSize")
	    .suppressFor(60.0)
	    .detail("Bytes", size)
	    .detail("EstimatedDbSize", dbSizeEstimate)
	    .detail("SqrtBytes", SERVER_KNOBS->SHARD_BYTES_PER_SQRT_BYTES)
	    .detail("AllowLargeShard", SERVER_KNOBS->ALLOW_LARGE_SHARD);
	return size;
}

bool ddLargeTeamEnabled() {
	return SERVER_KNOBS->DD_MAX_SHARDS_ON_LARGE_TEAMS > 0 && !SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA;
}

// Returns the shard size bounds as well as whether `keys` a read hot shard.
std::pair<ShardSizeBounds, bool> calculateShardSizeBounds(
    const KeyRange& keys,
    const Reference<AsyncVar<Optional<ShardMetrics>>>& shardMetrics,
    const BandwidthStatus& bandwidthStatus) {
	ShardSizeBounds bounds = ShardSizeBounds::shardSizeBoundsBeforeTrack();
	bool readHotShard = false;
	if (shardMetrics->get().present()) {
		auto bytes = shardMetrics->get().get().metrics.bytes;
		auto readBandwidthStatus = getReadBandwidthStatus(shardMetrics->get().get().metrics);

		// 1. bytes bound
		bounds.max.bytes = std::max(int64_t(bytes * 1.1), (int64_t)SERVER_KNOBS->MIN_SHARD_BYTES);
		bounds.min.bytes = std::min(int64_t(bytes * 0.9),
		                            std::max(int64_t(bytes - (SERVER_KNOBS->MIN_SHARD_BYTES * 0.1)), (int64_t)0));
		bounds.permittedError.bytes = bytes * 0.1;

		// 2. bytes written bound
		if (bandwidthStatus == BandwidthStatusNormal) { // Not high or low
			bounds.max.bytesWrittenPerKSecond = SERVER_KNOBS->SHARD_MAX_BYTES_PER_KSEC;
			bounds.min.bytesWrittenPerKSecond = SERVER_KNOBS->SHARD_MIN_BYTES_PER_KSEC;
			bounds.permittedError.bytesWrittenPerKSecond = bounds.min.bytesWrittenPerKSecond / 4;
		} else if (bandwidthStatus == BandwidthStatusHigh) { // > 10MB/sec for 100MB shard, proportionally lower
			                                                 // for smaller shard, > 200KB/sec no matter what
			bounds.max.bytesWrittenPerKSecond = bounds.max.infinity;
			bounds.min.bytesWrittenPerKSecond = SERVER_KNOBS->SHARD_MAX_BYTES_PER_KSEC;
			bounds.permittedError.bytesWrittenPerKSecond = bounds.min.bytesWrittenPerKSecond / 4;
		} else if (bandwidthStatus == BandwidthStatusLow) { // < 10KB/sec
			bounds.max.bytesWrittenPerKSecond = SERVER_KNOBS->SHARD_MIN_BYTES_PER_KSEC;
			bounds.min.bytesWrittenPerKSecond = 0;
			bounds.permittedError.bytesWrittenPerKSecond = bounds.max.bytesWrittenPerKSecond / 4;
		} else {
			ASSERT(false);
		}

		// 3. read bandwidth bound
		if (readBandwidthStatus == ReadBandwidthStatusNormal) {
			bounds.max.bytesReadPerKSecond =
			    std::max((int64_t)(SERVER_KNOBS->SHARD_MAX_READ_DENSITY_RATIO * bytes *
			                       SERVER_KNOBS->STORAGE_METRICS_AVERAGE_INTERVAL_PER_KSECONDS *
			                       (1.0 + SERVER_KNOBS->SHARD_MAX_BYTES_READ_PER_KSEC_JITTER)),
			             SERVER_KNOBS->SHARD_READ_HOT_BANDWIDTH_MIN_PER_KSECONDS);
			bounds.min.bytesReadPerKSecond = 0;
			bounds.permittedError.bytesReadPerKSecond = bounds.min.bytesReadPerKSecond / 4;
		} else if (readBandwidthStatus == ReadBandwidthStatusHigh) {
			bounds.max.bytesReadPerKSecond = bounds.max.infinity;
			bounds.min.bytesReadPerKSecond = SERVER_KNOBS->SHARD_MAX_READ_DENSITY_RATIO * bytes *
			                                 SERVER_KNOBS->STORAGE_METRICS_AVERAGE_INTERVAL_PER_KSECONDS *
			                                 (1.0 - SERVER_KNOBS->SHARD_MAX_BYTES_READ_PER_KSEC_JITTER);
			bounds.permittedError.bytesReadPerKSecond = bounds.min.bytesReadPerKSecond / 4;

			readHotShard = true;
		} else {
			ASSERT(false);
		}

		// 4. read ops bound
		if (shardMetrics->get()->metrics.opsReadPerKSecond > SERVER_KNOBS->SHARD_MAX_READ_OPS_PER_KSEC) {
			readHotShard = true;
		}
		// update when the read ops changed drastically
		int64_t currentReadOps = shardMetrics->get()->metrics.opsReadPerKSecond;
		bounds.max.opsReadPerKSecond = currentReadOps + SERVER_KNOBS->SHARD_READ_OPS_CHANGE_THRESHOLD;
		bounds.min.opsReadPerKSecond =
		    std::max((int64_t)0, currentReadOps - SERVER_KNOBS->SHARD_READ_OPS_CHANGE_THRESHOLD);
		bounds.permittedError.opsReadPerKSecond = currentReadOps * 0.25;
	}
	return { bounds, readHotShard };
}

															#line 445 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via shardUsableRegions()
															#line 213 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class ShardUsableRegionsActor>
															#line 213 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardUsableRegionsActorState {
															#line 452 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 213 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardUsableRegionsActorState(DataDistributionTracker::SafeAccessor const& self,KeyRange const& keys) 
															#line 213 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 213 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 213 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   keys(keys)
															#line 461 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("shardUsableRegions", reinterpret_cast<unsigned long>(this));

	}
	~ShardUsableRegionsActorState() 
	{
		fdb_probe_actor_destroy("shardUsableRegions", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 214 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
															#line 215 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			ASSERT(SERVER_KNOBS->DD_SHARD_USABLE_REGION_CHECK_RATE > 0);
															#line 216 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = yieldedFuture(self()->readyToStart.getFuture());
															#line 216 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 482 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state = 1;
															#line 216 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ShardUsableRegionsActor, 0, Void >*>(static_cast<ShardUsableRegionsActor*>(this)));
															#line 487 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ShardUsableRegionsActorState();
		static_cast<ShardUsableRegionsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 217 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		double expectedCompletionSeconds = self()->shards->size() * 1.0 / SERVER_KNOBS->DD_SHARD_USABLE_REGION_CHECK_RATE;
															#line 218 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		double delayTime = deterministicRandom()->random01() * expectedCompletionSeconds;
															#line 219 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(delayTime);
															#line 219 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 516 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state = 2;
															#line 219 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShardUsableRegionsActor, 1, Void >*>(static_cast<ShardUsableRegionsActor*>(this)));
															#line 521 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 217 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		double expectedCompletionSeconds = self()->shards->size() * 1.0 / SERVER_KNOBS->DD_SHARD_USABLE_REGION_CHECK_RATE;
															#line 218 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		double delayTime = deterministicRandom()->random01() * expectedCompletionSeconds;
															#line 219 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delayJittered(delayTime);
															#line 219 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 536 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state = 2;
															#line 219 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShardUsableRegionsActor, 1, Void >*>(static_cast<ShardUsableRegionsActor*>(this)));
															#line 541 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state > 0) static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state = 0;
		static_cast<ShardUsableRegionsActor*>(this)->ActorCallback< ShardUsableRegionsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardUsableRegionsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardUsableRegions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardUsableRegionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardUsableRegions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ShardUsableRegionsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardUsableRegions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardUsableRegionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardUsableRegions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ShardUsableRegionsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardUsableRegions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardUsableRegionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardUsableRegions", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 220 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto [newTeam, previousTeam] = self()->shardsAffectedByTeamFailure->getTeamsForFirstShard(keys);
															#line 221 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (newTeam.size() < self()->usableRegions)
															#line 627 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 222 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			TraceEvent(SevWarn, "ShardUsableRegionMismatch", self()->distributorId) .suppressFor(5.0) .detail("NewTeamSize", newTeam.size()) .detail("PreviousTeamSize", previousTeam.size()) .detail("NewServers", describe(newTeam)) .detail("PreviousServers", describe(previousTeam)) .detail("UsableRegion", self()->usableRegions) .detail("Shard", keys);
															#line 230 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			RelocateShard rs(keys, DataMovementReason::POPULATE_REGION, RelocateReason::OTHER);
															#line 231 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			self()->output.send(rs);
															#line 635 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 233 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<ShardUsableRegionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ShardUsableRegionsActorState(); static_cast<ShardUsableRegionsActor*>(this)->destroy(); return 0; }
															#line 639 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<ShardUsableRegionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ShardUsableRegionsActorState();
		static_cast<ShardUsableRegionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 220 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto [newTeam, previousTeam] = self()->shardsAffectedByTeamFailure->getTeamsForFirstShard(keys);
															#line 221 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (newTeam.size() < self()->usableRegions)
															#line 653 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 222 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			TraceEvent(SevWarn, "ShardUsableRegionMismatch", self()->distributorId) .suppressFor(5.0) .detail("NewTeamSize", newTeam.size()) .detail("PreviousTeamSize", previousTeam.size()) .detail("NewServers", describe(newTeam)) .detail("PreviousServers", describe(previousTeam)) .detail("UsableRegion", self()->usableRegions) .detail("Shard", keys);
															#line 230 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			RelocateShard rs(keys, DataMovementReason::POPULATE_REGION, RelocateReason::OTHER);
															#line 231 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			self()->output.send(rs);
															#line 661 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 233 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<ShardUsableRegionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ShardUsableRegionsActorState(); static_cast<ShardUsableRegionsActor*>(this)->destroy(); return 0; }
															#line 665 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<ShardUsableRegionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ShardUsableRegionsActorState();
		static_cast<ShardUsableRegionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state > 0) static_cast<ShardUsableRegionsActor*>(this)->actor_wait_state = 0;
		static_cast<ShardUsableRegionsActor*>(this)->ActorCallback< ShardUsableRegionsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardUsableRegionsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardUsableRegions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardUsableRegionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardUsableRegions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ShardUsableRegionsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardUsableRegions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardUsableRegionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardUsableRegions", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ShardUsableRegionsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardUsableRegions", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardUsableRegionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardUsableRegions", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 213 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker::SafeAccessor self;
															#line 213 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 752 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via shardUsableRegions()
															#line 213 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardUsableRegionsActor final : public Actor<Void>, public ActorCallback< ShardUsableRegionsActor, 0, Void >, public ActorCallback< ShardUsableRegionsActor, 1, Void >, public FastAllocated<ShardUsableRegionsActor>, public ShardUsableRegionsActorState<ShardUsableRegionsActor> {
															#line 757 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<ShardUsableRegionsActor>::operator new;
	using FastAllocated<ShardUsableRegionsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12415041644237590528UL, 13410848757975920896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ShardUsableRegionsActor, 0, Void >;
friend struct ActorCallback< ShardUsableRegionsActor, 1, Void >;
															#line 213 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardUsableRegionsActor(DataDistributionTracker::SafeAccessor const& self,KeyRange const& keys) 
															#line 775 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   ShardUsableRegionsActorState<ShardUsableRegionsActor>(self, keys),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("shardUsableRegions", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7379208784678766848UL, 649665179754772480UL);
		ActorExecutionContextHelper __helper(static_cast<ShardUsableRegionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("shardUsableRegions");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("shardUsableRegions", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ShardUsableRegionsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ShardUsableRegionsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 213 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> shardUsableRegions( DataDistributionTracker::SafeAccessor const& self, KeyRange const& keys ) {
															#line 213 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new ShardUsableRegionsActor(self, keys));
															#line 809 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 235 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 814 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via trackShardMetrics()
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class TrackShardMetricsActor>
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TrackShardMetricsActorState {
															#line 821 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TrackShardMetricsActorState(DataDistributionTracker::SafeAccessor const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardMetrics,bool const& whenDDInit) 
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   keys(keys),
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardMetrics(shardMetrics),
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   whenDDInit(whenDDInit),
															#line 240 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   bandwidthStatus(shardMetrics->get().present() ? getBandwidthStatus(shardMetrics->get().get().metrics) : BandwidthStatusNormal),
															#line 242 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   lastLowBandwidthStartTime(shardMetrics->get().present() ? shardMetrics->get().get().lastLowBandwidthStartTime : now()),
															#line 244 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardCount(shardMetrics->get().present() ? shardMetrics->get().get().shardCount : 1),
															#line 245 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   initWithNewMetrics(whenDDInit)
															#line 842 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("trackShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	~TrackShardMetricsActorState() 
	{
		fdb_probe_actor_destroy("trackShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 246 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::DataDistribution);
															#line 246 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<TrackShardMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 859 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TrackShardMetricsActor*>(this)->actor_wait_state = 1;
															#line 246 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackShardMetricsActor, 0, Void >*>(static_cast<TrackShardMetricsActor*>(this)));
															#line 864 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackShardMetricsActorState();
		static_cast<TrackShardMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 248 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		DisabledTraceEvent(SevDebug, "TrackShardMetricsStarting", self()->distributorId) .detail("Keys", keys) .detail("TrackedBytesInitiallyPresent", shardMetrics->get().present()) .detail("StartingMetrics", shardMetrics->get().present() ? shardMetrics->get().get().metrics.bytes : 0);
															#line 887 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		try {
															#line 254 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			;
															#line 891 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 248 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		DisabledTraceEvent(SevDebug, "TrackShardMetricsStarting", self()->distributorId) .detail("Keys", keys) .detail("TrackedBytesInitiallyPresent", shardMetrics->get().present()) .detail("StartingMetrics", shardMetrics->get().present() ? shardMetrics->get().get().metrics.bytes : 0);
															#line 906 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		try {
															#line 254 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			;
															#line 910 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackShardMetricsActor*>(this)->actor_wait_state > 0) static_cast<TrackShardMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackShardMetricsActor*>(this)->ActorCallback< TrackShardMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackShardMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackShardMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackShardMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 343 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_actor_cancelled && e.code() != error_code_dd_tracker_cancelled)
															#line 1001 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 344 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				DisabledTraceEvent(SevDebug, "TrackShardError", self()->distributorId).detail("Keys", keys);
															#line 346 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				ASSERT(!transactionRetryableErrors.contains(e.code()));
															#line 347 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				self()->output.sendError(e);
															#line 1009 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 349 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1013 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 255 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		bounds = ShardSizeBounds();
															#line 256 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		bool readHotShard;
															#line 257 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::tie(bounds, readHotShard) = calculateShardSizeBounds(keys, shardMetrics, bandwidthStatus);
															#line 259 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (readHotShard)
															#line 1040 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 263 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			self()->readHotShard.send(keys);
															#line 1044 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 266 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		;
															#line 1048 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 268 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<std::pair<Optional<StorageMetrics>, int>> __when_expr_1 = self()->db->waitStorageMetrics(keys, bounds.min, bounds.max, bounds.permittedError, CLIENT_KNOBS->STORAGE_METRICS_SHARD_LIMIT, shardCount);
															#line 268 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<TrackShardMetricsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1072 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackShardMetricsActor*>(this)->actor_wait_state = 2;
															#line 268 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*>(static_cast<TrackShardMetricsActor*>(this)));
															#line 1077 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(std::pair<Optional<StorageMetrics>, int> const& metrics,int loopDepth) 
	{
															#line 275 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (metrics.first.present())
															#line 1099 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 276 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			BandwidthStatus newBandwidthStatus = getBandwidthStatus(metrics.first.get());
															#line 277 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (newBandwidthStatus == BandwidthStatusLow && bandwidthStatus != BandwidthStatusLow)
															#line 1105 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 278 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				lastLowBandwidthStartTime = now();
															#line 1109 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 280 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			bandwidthStatus = newBandwidthStatus;
															#line 282 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			DisabledTraceEvent("ShardSizeUpdate", self()->distributorId) .detail("Keys", keys) .detail("UpdatedSize", metrics.first.get().bytes) .detail("WriteBandwidth", metrics.first.get().bytesWrittenPerKSecond) .detail("BandwidthStatus", bandwidthStatus) .detail("ReadBandWidth", metrics.first.get().bytesReadPerKSecond) .detail("ReadOps", metrics.first.get().opsReadPerKSecond) .detail("BytesLower", bounds.min.bytes) .detail("BytesUpper", bounds.max.bytes) .detail("WriteBandwidthLower", bounds.min.bytesWrittenPerKSecond) .detail("WriteBandwidthUpper", bounds.max.bytesWrittenPerKSecond) .detail("ShardSizePresent", shardMetrics->get().present()) .detail("OldShardSize", shardMetrics->get().present() ? shardMetrics->get().get().metrics.bytes : 0);
															#line 297 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shardMetrics->get().present())
															#line 1117 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 298 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				DisabledTraceEvent("TrackerChangeSizes") .detail("Context", "trackShardMetrics") .detail("Keys", keys) .detail("TotalSizeEstimate", self()->dbSizeEstimate->get()) .detail("EndSizeOfOldShards", shardMetrics->get().get().metrics.bytes) .detail("StartingSizeOfNewShards", metrics.first.get().bytes);
															#line 304 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				self()->dbSizeEstimate->set(self()->dbSizeEstimate->get() + metrics.first.get().bytes - shardMetrics->get().get().metrics.bytes);
															#line 306 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA && SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD)
															#line 1125 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				{
															#line 309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					const MoveKeyRangeOutPhysicalShard needToMove = self()->physicalShardCollection->trackPhysicalShard( keys, metrics.first.get(), shardMetrics->get().get().metrics, initWithNewMetrics);
															#line 312 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					if (needToMove)
															#line 1131 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
					{
															#line 315 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
						self()->output.send( RelocateShard(keys, DataMovementReason::ENFORCE_MOVE_OUT_OF_PHYSICAL_SHARD, RelocateReason::OTHER));
															#line 1135 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
					}
															#line 320 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					if (initWithNewMetrics)
															#line 1139 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
					{
															#line 321 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
						initWithNewMetrics = false;
															#line 1143 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
					}
				}
															#line 324 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (keys.begin >= systemKeys.begin)
															#line 1148 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				{
															#line 325 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					self()->systemSizeEstimate += metrics.first.get().bytes - shardMetrics->get().get().metrics.bytes;
															#line 1152 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				}
			}
															#line 330 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardMetrics->set(ShardMetrics(metrics.first.get(), lastLowBandwidthStartTime, shardCount));
															#line 1157 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 333 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardCount = metrics.second;
															#line 334 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shardMetrics->get().present())
															#line 1166 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 335 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				auto newShardMetrics = shardMetrics->get().get();
															#line 336 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				newShardMetrics.shardCount = shardCount;
															#line 337 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				shardMetrics->set(newShardMetrics);
															#line 1174 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
		}
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(std::pair<Optional<StorageMetrics>, int> && metrics,int loopDepth) 
	{
															#line 275 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (metrics.first.present())
															#line 1185 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 276 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			BandwidthStatus newBandwidthStatus = getBandwidthStatus(metrics.first.get());
															#line 277 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (newBandwidthStatus == BandwidthStatusLow && bandwidthStatus != BandwidthStatusLow)
															#line 1191 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 278 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				lastLowBandwidthStartTime = now();
															#line 1195 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 280 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			bandwidthStatus = newBandwidthStatus;
															#line 282 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			DisabledTraceEvent("ShardSizeUpdate", self()->distributorId) .detail("Keys", keys) .detail("UpdatedSize", metrics.first.get().bytes) .detail("WriteBandwidth", metrics.first.get().bytesWrittenPerKSecond) .detail("BandwidthStatus", bandwidthStatus) .detail("ReadBandWidth", metrics.first.get().bytesReadPerKSecond) .detail("ReadOps", metrics.first.get().opsReadPerKSecond) .detail("BytesLower", bounds.min.bytes) .detail("BytesUpper", bounds.max.bytes) .detail("WriteBandwidthLower", bounds.min.bytesWrittenPerKSecond) .detail("WriteBandwidthUpper", bounds.max.bytesWrittenPerKSecond) .detail("ShardSizePresent", shardMetrics->get().present()) .detail("OldShardSize", shardMetrics->get().present() ? shardMetrics->get().get().metrics.bytes : 0);
															#line 297 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shardMetrics->get().present())
															#line 1203 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 298 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				DisabledTraceEvent("TrackerChangeSizes") .detail("Context", "trackShardMetrics") .detail("Keys", keys) .detail("TotalSizeEstimate", self()->dbSizeEstimate->get()) .detail("EndSizeOfOldShards", shardMetrics->get().get().metrics.bytes) .detail("StartingSizeOfNewShards", metrics.first.get().bytes);
															#line 304 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				self()->dbSizeEstimate->set(self()->dbSizeEstimate->get() + metrics.first.get().bytes - shardMetrics->get().get().metrics.bytes);
															#line 306 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA && SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD)
															#line 1211 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				{
															#line 309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					const MoveKeyRangeOutPhysicalShard needToMove = self()->physicalShardCollection->trackPhysicalShard( keys, metrics.first.get(), shardMetrics->get().get().metrics, initWithNewMetrics);
															#line 312 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					if (needToMove)
															#line 1217 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
					{
															#line 315 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
						self()->output.send( RelocateShard(keys, DataMovementReason::ENFORCE_MOVE_OUT_OF_PHYSICAL_SHARD, RelocateReason::OTHER));
															#line 1221 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
					}
															#line 320 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					if (initWithNewMetrics)
															#line 1225 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
					{
															#line 321 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
						initWithNewMetrics = false;
															#line 1229 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
					}
				}
															#line 324 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (keys.begin >= systemKeys.begin)
															#line 1234 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				{
															#line 325 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					self()->systemSizeEstimate += metrics.first.get().bytes - shardMetrics->get().get().metrics.bytes;
															#line 1238 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				}
			}
															#line 330 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardMetrics->set(ShardMetrics(metrics.first.get(), lastLowBandwidthStartTime, shardCount));
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 333 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardCount = metrics.second;
															#line 334 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shardMetrics->get().present())
															#line 1252 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 335 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				auto newShardMetrics = shardMetrics->get().get();
															#line 336 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				newShardMetrics.shardCount = shardCount;
															#line 337 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				shardMetrics->set(newShardMetrics);
															#line 1260 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
		}
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(std::pair<Optional<StorageMetrics>, int> const& metrics,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(metrics, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(std::pair<Optional<StorageMetrics>, int> && metrics,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(std::move(metrics), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TrackShardMetricsActor*>(this)->actor_wait_state > 0) static_cast<TrackShardMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackShardMetricsActor*>(this)->ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >::remove();

	}
	void a_callback_fire(ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*,std::pair<Optional<StorageMetrics>, int> const& value) 
	{
		fdb_probe_actor_enter("trackShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*,std::pair<Optional<StorageMetrics>, int> && value) 
	{
		fdb_probe_actor_enter("trackShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*,Error err) 
	{
		fdb_probe_actor_enter("trackShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker::SafeAccessor self;
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<ShardMetrics>>> shardMetrics;
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	bool whenDDInit;
															#line 240 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	BandwidthStatus bandwidthStatus;
															#line 242 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	double lastLowBandwidthStartTime;
															#line 244 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int shardCount;
															#line 245 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	bool initWithNewMetrics;
															#line 255 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardSizeBounds bounds;
															#line 1360 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via trackShardMetrics()
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TrackShardMetricsActor final : public Actor<Void>, public ActorCallback< TrackShardMetricsActor, 0, Void >, public ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >, public FastAllocated<TrackShardMetricsActor>, public TrackShardMetricsActorState<TrackShardMetricsActor> {
															#line 1365 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<TrackShardMetricsActor>::operator new;
	using FastAllocated<TrackShardMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14670054559941011712UL, 4234638845058015232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackShardMetricsActor, 0, Void >;
friend struct ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >;
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TrackShardMetricsActor(DataDistributionTracker::SafeAccessor const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardMetrics,bool const& whenDDInit) 
															#line 1383 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   TrackShardMetricsActorState<TrackShardMetricsActor>(self, keys, shardMetrics, whenDDInit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackShardMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8095935716908204288UL, 1249160800655855360UL);
		ActorExecutionContextHelper __helper(static_cast<TrackShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackShardMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackShardMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackShardMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TrackShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> trackShardMetrics( DataDistributionTracker::SafeAccessor const& self, KeyRange const& keys, Reference<AsyncVar<Optional<ShardMetrics>>> const& shardMetrics, bool const& whenDDInit ) {
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new TrackShardMetricsActor(self, keys, shardMetrics, whenDDInit));
															#line 1417 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 352 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 1422 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via readHotDetector()
															#line 353 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class ReadHotDetectorActor>
															#line 353 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ReadHotDetectorActorState {
															#line 1429 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 353 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ReadHotDetectorActorState(DataDistributionTracker* const& self) 
															#line 353 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 353 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self)
															#line 1436 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("readHotDetector", reinterpret_cast<unsigned long>(this));

	}
	~ReadHotDetectorActorState() 
	{
		fdb_probe_actor_destroy("readHotDetector", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 355 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				;
															#line 1452 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadHotDetectorActorState();
		static_cast<ReadHotDetectorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 369 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_actor_cancelled)
															#line 1482 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 371 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				ASSERT(!transactionRetryableErrors.contains(e.code()));
															#line 372 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				self->output.sendError(e);
															#line 1488 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 374 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 1492 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 356 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_0 = self->readHotShard.getFuture();
															#line 1513 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<KeyRange>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<KeyRange>>::value, "invalid type");
															#line 356 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ReadHotDetectorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1517 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<ReadHotDetectorActor*>(this)->actor_wait_state = 1;
															#line 356 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >*>(static_cast<ReadHotDetectorActor*>(this)));
															#line 1522 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 357 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Standalone<VectorRef<ReadHotRangeWithMetrics>>> __when_expr_1 = self->db->getReadHotRanges(keys);
															#line 357 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ReadHotDetectorActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1533 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadHotDetectorActor*>(this)->actor_wait_state = 2;
															#line 357 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*>(static_cast<ReadHotDetectorActor*>(this)));
															#line 1538 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyRange const& __keys,int loopDepth) 
	{
															#line 356 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		keys = __keys;
															#line 1547 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyRange && __keys,int loopDepth) 
	{
		keys = std::move(__keys);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadHotDetectorActor*>(this)->actor_wait_state > 0) static_cast<ReadHotDetectorActor*>(this)->actor_wait_state = 0;
		static_cast<ReadHotDetectorActor*>(this)->ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >::remove();

	}
	void a_callback_fire(ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >*,KeyRange const& value) 
	{
		fdb_probe_actor_enter("readHotDetector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadHotDetectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readHotDetector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >*,KeyRange && value) 
	{
		fdb_probe_actor_enter("readHotDetector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadHotDetectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readHotDetector", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >*,Error err) 
	{
		fdb_probe_actor_enter("readHotDetector", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadHotDetectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readHotDetector", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Standalone<VectorRef<ReadHotRangeWithMetrics>> const& readHotRanges,int loopDepth) 
	{
															#line 359 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( const auto& keyRange : readHotRanges ) {
															#line 360 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			TraceEvent("ReadHotRangeLog") .detail("ReadDensity", keyRange.density) .detail("ReadBandwidth", keyRange.readBandwidthSec) .detail("ReadDensityThreshold", SERVER_KNOBS->SHARD_MAX_READ_DENSITY_RATIO) .detail("KeyRangeBegin", keyRange.keys.begin) .detail("KeyRangeEnd", keyRange.keys.end);
															#line 1628 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Standalone<VectorRef<ReadHotRangeWithMetrics>> && readHotRanges,int loopDepth) 
	{
															#line 359 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( const auto& keyRange : readHotRanges ) {
															#line 360 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			TraceEvent("ReadHotRangeLog") .detail("ReadDensity", keyRange.density) .detail("ReadBandwidth", keyRange.readBandwidthSec) .detail("ReadDensityThreshold", SERVER_KNOBS->SHARD_MAX_READ_DENSITY_RATIO) .detail("KeyRangeBegin", keyRange.keys.begin) .detail("KeyRangeEnd", keyRange.keys.end);
															#line 1640 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Standalone<VectorRef<ReadHotRangeWithMetrics>> const& readHotRanges,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(readHotRanges, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Standalone<VectorRef<ReadHotRangeWithMetrics>> && readHotRanges,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(readHotRanges), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadHotDetectorActor*>(this)->actor_wait_state > 0) static_cast<ReadHotDetectorActor*>(this)->actor_wait_state = 0;
		static_cast<ReadHotDetectorActor*>(this)->ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*,Standalone<VectorRef<ReadHotRangeWithMetrics>> const& value) 
	{
		fdb_probe_actor_enter("readHotDetector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadHotDetectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readHotDetector", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*,Standalone<VectorRef<ReadHotRangeWithMetrics>> && value) 
	{
		fdb_probe_actor_enter("readHotDetector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadHotDetectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readHotDetector", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*,Error err) 
	{
		fdb_probe_actor_enter("readHotDetector", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadHotDetectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readHotDetector", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 353 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 356 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 1725 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via readHotDetector()
															#line 353 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ReadHotDetectorActor final : public Actor<Void>, public ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >, public ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >, public FastAllocated<ReadHotDetectorActor>, public ReadHotDetectorActorState<ReadHotDetectorActor> {
															#line 1730 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<ReadHotDetectorActor>::operator new;
	using FastAllocated<ReadHotDetectorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6133816133813498368UL, 3207709423948150784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >;
friend struct ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >;
															#line 353 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ReadHotDetectorActor(DataDistributionTracker* const& self) 
															#line 1748 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   ReadHotDetectorActorState<ReadHotDetectorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readHotDetector", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7522552365585453056UL, 2930011701178436608UL);
		ActorExecutionContextHelper __helper(static_cast<ReadHotDetectorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readHotDetector");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readHotDetector", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< ReadHotDetectorActor, 0, KeyRange >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadHotDetectorActor, 1, Standalone<VectorRef<ReadHotRangeWithMetrics>> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 353 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> readHotDetector( DataDistributionTracker* const& self ) {
															#line 353 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new ReadHotDetectorActor(self));
															#line 1782 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 377 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

/*
ACTOR Future<Void> extrapolateShardBytes( Reference<AsyncVar<Optional<int64_t>>> inBytes,
Reference<AsyncVar<Optional<int64_t>>> outBytes ) { state std::deque< std::pair<double,int64_t> > past; loop { wait(
inBytes->onChange() ); if( inBytes->get().present() ) { past.emplace_back(now(),inBytes->get().get()); if
(past.size() < 2) outBytes->set( inBytes->get() ); else { while (past.size() > 1 && past.end()[-1].first -
past.begin()[1].first > 1.0) past.pop_front(); double rate = std::max(0.0,
double(past.end()[-1].second-past.begin()[0].second)/(past.end()[-1].first - past.begin()[0].first)); outBytes->set(
inBytes->get().get() + rate * 10.0 );
            }
        }
    }
}*/

															#line 1800 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via getFirstSize()
															#line 391 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class GetFirstSizeActor>
															#line 391 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class GetFirstSizeActorState {
															#line 1807 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 391 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetFirstSizeActorState(Reference<AsyncVar<Optional<ShardMetrics>>> const& stats) 
															#line 391 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 391 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : stats(stats)
															#line 1814 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("getFirstSize", reinterpret_cast<unsigned long>(this));

	}
	~GetFirstSizeActorState() 
	{
		fdb_probe_actor_destroy("getFirstSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 392 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			;
															#line 1829 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetFirstSizeActorState();
		static_cast<GetFirstSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 393 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (stats->get().present())
															#line 1859 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 394 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!static_cast<GetFirstSizeActor*>(this)->SAV<int64_t>::futures) { (void)(stats->get().get().metrics.bytes); this->~GetFirstSizeActorState(); static_cast<GetFirstSizeActor*>(this)->destroy(); return 0; }
															#line 1863 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			new (&static_cast<GetFirstSizeActor*>(this)->SAV< int64_t >::value()) int64_t(stats->get().get().metrics.bytes);
			this->~GetFirstSizeActorState();
			static_cast<GetFirstSizeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 395 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = stats->onChange();
															#line 395 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<GetFirstSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1873 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetFirstSizeActor*>(this)->actor_wait_state = 1;
															#line 395 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetFirstSizeActor, 0, Void >*>(static_cast<GetFirstSizeActor*>(this)));
															#line 1878 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetFirstSizeActor*>(this)->actor_wait_state > 0) static_cast<GetFirstSizeActor*>(this)->actor_wait_state = 0;
		static_cast<GetFirstSizeActor*>(this)->ActorCallback< GetFirstSizeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetFirstSizeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getFirstSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetFirstSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFirstSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetFirstSizeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getFirstSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetFirstSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFirstSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetFirstSizeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getFirstSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetFirstSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getFirstSize", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 391 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<ShardMetrics>>> stats;
															#line 1972 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via getFirstSize()
															#line 391 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class GetFirstSizeActor final : public Actor<int64_t>, public ActorCallback< GetFirstSizeActor, 0, Void >, public FastAllocated<GetFirstSizeActor>, public GetFirstSizeActorState<GetFirstSizeActor> {
															#line 1977 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<GetFirstSizeActor>::operator new;
	using FastAllocated<GetFirstSizeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14927479046939065344UL, 5984055563722543104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetFirstSizeActor, 0, Void >;
															#line 391 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetFirstSizeActor(Reference<AsyncVar<Optional<ShardMetrics>>> const& stats) 
															#line 1994 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<int64_t>(),
		   GetFirstSizeActorState<GetFirstSizeActor>(stats),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getFirstSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5224663036299137024UL, 12919559761751353856UL);
		ActorExecutionContextHelper __helper(static_cast<GetFirstSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getFirstSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getFirstSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetFirstSizeActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 391 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<int64_t> getFirstSize( Reference<AsyncVar<Optional<ShardMetrics>>> const& stats ) {
															#line 391 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<int64_t>(new GetFirstSizeActor(stats));
															#line 2027 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 398 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 2032 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via changeSizes()
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class ChangeSizesActor>
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ChangeSizesActorState {
															#line 2039 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ChangeSizesActorState(DataDistributionTracker* const& self,KeyRange const& keys,int64_t const& oldShardsEndingSize,std::string const& context) 
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   keys(keys),
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   oldShardsEndingSize(oldShardsEndingSize),
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   context(context),
															#line 403 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   sizes(),
															#line 404 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   systemSizes()
															#line 2056 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("changeSizes", reinterpret_cast<unsigned long>(this));

	}
	~ChangeSizesActorState() 
	{
		fdb_probe_actor_destroy("changeSizes", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 405 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			for( auto it : self->shards->intersectingRanges(keys) ) {
															#line 406 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				Future<int64_t> thisSize = getFirstSize(it->value().stats);
															#line 407 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				sizes.push_back(thisSize);
															#line 408 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (it->range().begin >= systemKeys.begin)
															#line 2077 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				{
															#line 409 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					systemSizes.push_back(thisSize);
															#line 2081 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				}
			}
															#line 413 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(sizes);
															#line 413 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ChangeSizesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2088 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ChangeSizesActor*>(this)->actor_wait_state = 1;
															#line 413 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeSizesActor, 0, Void >*>(static_cast<ChangeSizesActor*>(this)));
															#line 2093 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeSizesActorState();
		static_cast<ChangeSizesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 414 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield(TaskPriority::DataDistribution);
															#line 414 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ChangeSizesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2118 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeSizesActor*>(this)->actor_wait_state = 2;
															#line 414 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeSizesActor, 1, Void >*>(static_cast<ChangeSizesActor*>(this)));
															#line 2123 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 414 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield(TaskPriority::DataDistribution);
															#line 414 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ChangeSizesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2134 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeSizesActor*>(this)->actor_wait_state = 2;
															#line 414 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeSizesActor, 1, Void >*>(static_cast<ChangeSizesActor*>(this)));
															#line 2139 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeSizesActor*>(this)->actor_wait_state > 0) static_cast<ChangeSizesActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeSizesActor*>(this)->ActorCallback< ChangeSizesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeSizesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeSizes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeSizesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeSizes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeSizesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeSizes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeSizesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeSizes", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeSizesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeSizes", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeSizesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeSizes", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 416 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int64_t newShardsStartingSize = 0;
															#line 417 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( const auto& size : sizes ) {
															#line 418 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			newShardsStartingSize += size.get();
															#line 2227 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 421 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int64_t newSystemShardsStartingSize = 0;
															#line 422 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( const auto& systemSize : systemSizes ) {
															#line 423 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			newSystemShardsStartingSize += systemSize.get();
															#line 2235 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 426 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int64_t totalSizeEstimate = self->dbSizeEstimate->get();
															#line 427 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		DisabledTraceEvent("TrackerChangeSizes") .detail("Context", "changeSizes when " + context) .detail("Keys", keys) .detail("TotalSizeEstimate", totalSizeEstimate) .detail("EndSizeOfOldShards", oldShardsEndingSize) .detail("StartingSizeOfNewShards", newShardsStartingSize);
															#line 433 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->dbSizeEstimate->set(totalSizeEstimate + newShardsStartingSize - oldShardsEndingSize);
															#line 434 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->systemSizeEstimate += newSystemShardsStartingSize;
															#line 435 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (keys.begin >= systemKeys.begin)
															#line 2247 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 436 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			self->systemSizeEstimate -= oldShardsEndingSize;
															#line 2251 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 438 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<ChangeSizesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeSizesActorState(); static_cast<ChangeSizesActor*>(this)->destroy(); return 0; }
															#line 2255 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<ChangeSizesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeSizesActorState();
		static_cast<ChangeSizesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 416 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int64_t newShardsStartingSize = 0;
															#line 417 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( const auto& size : sizes ) {
															#line 418 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			newShardsStartingSize += size.get();
															#line 2271 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 421 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int64_t newSystemShardsStartingSize = 0;
															#line 422 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( const auto& systemSize : systemSizes ) {
															#line 423 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			newSystemShardsStartingSize += systemSize.get();
															#line 2279 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 426 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int64_t totalSizeEstimate = self->dbSizeEstimate->get();
															#line 427 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		DisabledTraceEvent("TrackerChangeSizes") .detail("Context", "changeSizes when " + context) .detail("Keys", keys) .detail("TotalSizeEstimate", totalSizeEstimate) .detail("EndSizeOfOldShards", oldShardsEndingSize) .detail("StartingSizeOfNewShards", newShardsStartingSize);
															#line 433 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->dbSizeEstimate->set(totalSizeEstimate + newShardsStartingSize - oldShardsEndingSize);
															#line 434 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->systemSizeEstimate += newSystemShardsStartingSize;
															#line 435 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (keys.begin >= systemKeys.begin)
															#line 2291 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 436 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			self->systemSizeEstimate -= oldShardsEndingSize;
															#line 2295 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 438 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<ChangeSizesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeSizesActorState(); static_cast<ChangeSizesActor*>(this)->destroy(); return 0; }
															#line 2299 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<ChangeSizesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeSizesActorState();
		static_cast<ChangeSizesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeSizesActor*>(this)->actor_wait_state > 0) static_cast<ChangeSizesActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeSizesActor*>(this)->ActorCallback< ChangeSizesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeSizesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeSizes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeSizesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeSizes", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeSizesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeSizes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeSizesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeSizes", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeSizesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeSizes", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeSizesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeSizes", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int64_t oldShardsEndingSize;
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	std::string context;
															#line 403 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	std::vector<Future<int64_t>> sizes;
															#line 404 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	std::vector<Future<int64_t>> systemSizes;
															#line 2394 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via changeSizes()
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ChangeSizesActor final : public Actor<Void>, public ActorCallback< ChangeSizesActor, 0, Void >, public ActorCallback< ChangeSizesActor, 1, Void >, public FastAllocated<ChangeSizesActor>, public ChangeSizesActorState<ChangeSizesActor> {
															#line 2399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<ChangeSizesActor>::operator new;
	using FastAllocated<ChangeSizesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5183810174892157696UL, 17216861789375583744UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeSizesActor, 0, Void >;
friend struct ActorCallback< ChangeSizesActor, 1, Void >;
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ChangeSizesActor(DataDistributionTracker* const& self,KeyRange const& keys,int64_t const& oldShardsEndingSize,std::string const& context) 
															#line 2417 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeSizesActorState<ChangeSizesActor>(self, keys, oldShardsEndingSize, context),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeSizes", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2410211478348430848UL, 17775302493419396352UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeSizesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeSizes");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeSizes", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeSizesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeSizesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> changeSizes( DataDistributionTracker* const& self, KeyRange const& keys, int64_t const& oldShardsEndingSize, std::string const& context ) {
															#line 399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new ChangeSizesActor(self, keys, oldShardsEndingSize, context));
															#line 2451 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 440 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

struct HasBeenTrueFor : ReferenceCounted<HasBeenTrueFor> {
	explicit HasBeenTrueFor(const Optional<ShardMetrics>& value) {
		if (value.present()) {
			lowBandwidthStartTime = value.get().lastLowBandwidthStartTime;
			trigger =
			    delayJittered(std::max(0.0, SERVER_KNOBS->DD_MERGE_COALESCE_DELAY + lowBandwidthStartTime - now()),
			                  TaskPriority::DataDistributionLow) ||
			    cleared.getFuture();
		}
	}

	Future<Void> set(double lastLowBandwidthStartTime) {
		if (!trigger.isValid() || lowBandwidthStartTime != lastLowBandwidthStartTime) {
			cleared = Promise<Void>();
			trigger =
			    delayJittered(SERVER_KNOBS->DD_MERGE_COALESCE_DELAY + std::max(lastLowBandwidthStartTime - now(), 0.0),
			                  TaskPriority::DataDistributionLow) ||
			    cleared.getFuture();

			lowBandwidthStartTime = lastLowBandwidthStartTime;
		}
		return trigger;
	}
	void clear() {
		if (!trigger.isValid()) {
			return;
		}
		trigger = Future<Void>();
		cleared.send(Void());
		lowBandwidthStartTime = 0;
	}

	// True if this->value is true and has been true for this->seconds
	bool hasBeenTrueForLongEnough() const { return trigger.isValid() && trigger.isReady(); }

private:
	double lowBandwidthStartTime = 0;
	Future<Void> trigger;
	Promise<Void> cleared;
};

std::string describeSplit(KeyRange keys, Standalone<VectorRef<KeyRef>>& splitKeys) {
	std::string s;
	s += "[" + keys.begin.toString() + ", " + keys.end.toString() + ") -> ";

	for (auto& sk : splitKeys) {
		s += sk.printable() + " ";
	}

	return s;
}
void traceSplit(KeyRange keys, Standalone<VectorRef<KeyRef>>& splitKeys) {
	auto s = describeSplit(keys, splitKeys);
	TraceEvent(SevInfo, "ExecutingShardSplit").detail("AtKeys", s);
}

void executeShardSplit(DataDistributionTracker* self,
                       KeyRange keys,
                       Standalone<VectorRef<KeyRef>> splitKeys,
                       Reference<AsyncVar<Optional<ShardMetrics>>> shardSize,
                       bool relocate,
                       RelocateReason reason) {

	int numShards = splitKeys.size() - 1;
	ASSERT(numShards > 1);

	int skipRange = deterministicRandom()->randomInt(0, numShards);

	auto s = describeSplit(keys, splitKeys);
	TraceEvent(SevInfo, "ExecutingShardSplit").suppressFor(0.5).detail("Splitting", s).detail("NumShards", numShards);

	// The queue can't deal with RelocateShard requests which split an existing shard into three pieces, so
	// we have to send the unskipped ranges in this order (nibbling in from the edges of the old range)
	for (int i = 0; i < skipRange; i++)
		restartShardTrackers(self, KeyRangeRef(splitKeys[i], splitKeys[i + 1]));
	restartShardTrackers(self, KeyRangeRef(splitKeys[skipRange], splitKeys[skipRange + 1]));
	for (int i = numShards - 1; i > skipRange; i--)
		restartShardTrackers(self, KeyRangeRef(splitKeys[i], splitKeys[i + 1]));

	for (int i = 0; i < skipRange; i++) {
		KeyRangeRef r(splitKeys[i], splitKeys[i + 1]);
		self->shardsAffectedByTeamFailure->defineShard(r);
		if (relocate) {
			RelocateShard rs(r, DataMovementReason::SPLIT_SHARD, reason);
			rs.setParentRange(keys);
			self->output.send(rs);
		}
	}
	for (int i = numShards - 1; i > skipRange; i--) {
		KeyRangeRef r(splitKeys[i], splitKeys[i + 1]);
		self->shardsAffectedByTeamFailure->defineShard(r);
		if (relocate) {
			RelocateShard rs(r, DataMovementReason::SPLIT_SHARD, reason);
			rs.setParentRange(keys);
			self->output.send(rs);
		}
	}

	self->actors.add(changeSizes(self, keys, shardSize->get().get().metrics.bytes, "ShardSplit"));
}

struct RangeToSplit {
	RangeMap<Standalone<StringRef>, ShardTrackedData, KeyRangeRef>::iterator shard;
	Standalone<VectorRef<KeyRef>> faultLines;

	RangeToSplit(RangeMap<Standalone<StringRef>, ShardTrackedData, KeyRangeRef>::iterator shard,
	             Standalone<VectorRef<KeyRef>> faultLines)
	  : shard(shard), faultLines(faultLines) {}
};

Standalone<VectorRef<KeyRef>> findShardFaultLines(KeyRef shardBegin,
                                                  KeyRef shardEnd,
                                                  KeyRef tenantBegin,
                                                  KeyRef tenantEnd) {
	Standalone<VectorRef<KeyRef>> faultLines;

	ASSERT((shardBegin < tenantBegin && shardEnd > tenantBegin) || (shardBegin < tenantEnd && shardEnd > tenantEnd));

	faultLines.push_back_deep(faultLines.arena(), shardBegin);
	if (shardBegin < tenantBegin && shardEnd > tenantBegin) {
		faultLines.push_back_deep(faultLines.arena(), tenantBegin);
	}
	if (shardBegin < tenantEnd && shardEnd > tenantEnd) {
		faultLines.push_back_deep(faultLines.arena(), tenantEnd);
	}
	faultLines.push_back_deep(faultLines.arena(), shardEnd);

	return faultLines;
}

std::vector<RangeToSplit> findTenantShardBoundaries(KeyRangeMap<ShardTrackedData>* shards, KeyRange tenantKeys) {

	std::vector<RangeToSplit> result;
	auto shardContainingTenantStart = shards->rangeContaining(tenantKeys.begin);
	auto shardContainingTenantEnd = shards->rangeContainingKeyBefore(tenantKeys.end);

	// same shard
	if (shardContainingTenantStart == shardContainingTenantEnd) {
		// If shard boundaries are not aligned with tenantKeys
		if (shardContainingTenantStart.begin() != tenantKeys.begin ||
		    shardContainingTenantStart.end() != tenantKeys.end) {

			CODE_PROBE(true, "Splitting a shard that contains complete tenant key range");

			auto startShardSize = shardContainingTenantStart->value().stats;

			if (startShardSize->get().present()) {
				auto faultLines = findShardFaultLines(shardContainingTenantStart->begin(),
				                                      shardContainingTenantStart->end(),
				                                      tenantKeys.begin,
				                                      tenantKeys.end);
				result.emplace_back(shardContainingTenantStart, faultLines);
			} else {
				CODE_PROBE(true,
				           "Shard that contains complete tenant key range not split since shard stats are unavailable");
			}
		}
	} else {
		auto startShardSize = shardContainingTenantStart->value().stats;
		auto endShardSize = shardContainingTenantEnd->value().stats;

		CODE_PROBE(true, "Splitting multiple shards that a tenant key range straddles");

		if (startShardSize->get().present() && endShardSize->get().present()) {
			if (shardContainingTenantStart->begin() != tenantKeys.begin) {
				auto faultLines = findShardFaultLines(shardContainingTenantStart->begin(),
				                                      shardContainingTenantStart->end(),
				                                      tenantKeys.begin,
				                                      tenantKeys.end);
				result.emplace_back(shardContainingTenantStart, faultLines);
			}

			if (shardContainingTenantEnd->end() != tenantKeys.end) {
				auto faultLines = findShardFaultLines(shardContainingTenantEnd->begin(),
				                                      shardContainingTenantEnd->end(),
				                                      tenantKeys.begin,
				                                      tenantKeys.end);
				result.emplace_back(shardContainingTenantEnd, faultLines);
			}
		} else {
			CODE_PROBE(true,
			           "Shards that contain tenant key range not split since shard stats are unavailable",
			           probe::decoration::rare);
		}
	}

	return result;
}

bool faultLinesMatch(std::vector<RangeToSplit>& ranges, std::vector<std::vector<KeyRef>>& expectedFaultLines) {
	if (ranges.size() != expectedFaultLines.size()) {
		return false;
	}

	for (auto& range : ranges) {
		KeyRangeRef keys = KeyRangeRef(range.shard->begin(), range.shard->end());
		traceSplit(keys, range.faultLines);
	}

	for (int r = 0; r < ranges.size(); r++) {
		if (ranges[r].faultLines.size() != expectedFaultLines[r].size()) {
			return false;
		}
		for (int fl = 0; fl < ranges[r].faultLines.size(); fl++) {
			if (ranges[r].faultLines[fl] != expectedFaultLines[r][fl]) {
				return false;
			}
		}
	}

	return true;
}

															#line 2669 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase654()
															#line 654 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FlowTestCase654Actor>
															#line 654 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase654ActorState {
															#line 2676 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 654 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase654ActorState(UnitTestParameters const& params) 
															#line 654 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 654 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : params(params)
															#line 2683 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase654", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase654ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase654", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 655 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Void());
															#line 655 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FlowTestCase654Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2700 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase654Actor*>(this)->actor_wait_state = 1;
															#line 655 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase654Actor, 0, Void >*>(static_cast<FlowTestCase654Actor*>(this)));
															#line 2705 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase654ActorState();
		static_cast<FlowTestCase654Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 656 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardTrackedData data;
															#line 657 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardMetrics sm(StorageMetrics(), now(), 1);
															#line 658 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 660 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeMap<ShardTrackedData> shards;
															#line 662 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin = "a"_sr, end = "f"_sr;
															#line 663 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k(begin, end);
															#line 664 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k, data);
															#line 666 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef tenantKeys("b"_sr, "c"_sr);
															#line 668 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats->set(sm);
															#line 670 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> result = findTenantShardBoundaries(&shards, tenantKeys);
															#line 672 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<std::vector<KeyRef>> expectedFaultLines = { { "a"_sr, "b"_sr, "c"_sr, "f"_sr } };
															#line 673 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(faultLinesMatch(result, expectedFaultLines));
															#line 675 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase654Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase654ActorState(); static_cast<FlowTestCase654Actor*>(this)->destroy(); return 0; }
															#line 2752 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase654Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase654ActorState();
		static_cast<FlowTestCase654Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 656 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardTrackedData data;
															#line 657 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardMetrics sm(StorageMetrics(), now(), 1);
															#line 658 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 660 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeMap<ShardTrackedData> shards;
															#line 662 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin = "a"_sr, end = "f"_sr;
															#line 663 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k(begin, end);
															#line 664 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k, data);
															#line 666 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef tenantKeys("b"_sr, "c"_sr);
															#line 668 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats->set(sm);
															#line 670 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> result = findTenantShardBoundaries(&shards, tenantKeys);
															#line 672 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<std::vector<KeyRef>> expectedFaultLines = { { "a"_sr, "b"_sr, "c"_sr, "f"_sr } };
															#line 673 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(faultLinesMatch(result, expectedFaultLines));
															#line 675 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase654Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase654ActorState(); static_cast<FlowTestCase654Actor*>(this)->destroy(); return 0; }
															#line 2788 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase654Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase654ActorState();
		static_cast<FlowTestCase654Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase654Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase654Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase654Actor*>(this)->ActorCallback< FlowTestCase654Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase654Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase654", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase654", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase654Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase654", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase654", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase654Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase654", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase654", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 654 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	UnitTestParameters params;
															#line 2873 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase654()
															#line 654 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase654Actor final : public Actor<Void>, public ActorCallback< FlowTestCase654Actor, 0, Void >, public FastAllocated<FlowTestCase654Actor>, public FlowTestCase654ActorState<FlowTestCase654Actor> {
															#line 2878 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase654Actor>::operator new;
	using FastAllocated<FlowTestCase654Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6561999577297713408UL, 3849382178685416960UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase654Actor, 0, Void >;
															#line 654 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase654Actor(UnitTestParameters const& params) 
															#line 2895 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase654ActorState<FlowTestCase654Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase654", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15749366891994674688UL, 4486536413348900096UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase654Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase654");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase654", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase654Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 654 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
static Future<Void> flowTestCase654( UnitTestParameters const& params ) {
															#line 654 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FlowTestCase654Actor(params));
															#line 2928 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase654, "/DataDistribution/Tenant/SingleShardSplit")

#line 677 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 2934 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase678()
															#line 678 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FlowTestCase678Actor>
															#line 678 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase678ActorState {
															#line 2941 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 678 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase678ActorState(UnitTestParameters const& params) 
															#line 678 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 678 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : params(params)
															#line 2948 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase678", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase678ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase678", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 679 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Void());
															#line 679 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FlowTestCase678Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2965 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase678Actor*>(this)->actor_wait_state = 1;
															#line 679 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase678Actor, 0, Void >*>(static_cast<FlowTestCase678Actor*>(this)));
															#line 2970 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase678ActorState();
		static_cast<FlowTestCase678Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 680 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardTrackedData data;
															#line 681 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardMetrics sm(StorageMetrics(), now(), 1);
															#line 682 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 684 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeMap<ShardTrackedData> shards;
															#line 686 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin = "a"_sr, end = "f"_sr;
															#line 687 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k(begin, end);
															#line 688 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k, data);
															#line 690 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef tenantKeys("a"_sr, "f"_sr);
															#line 692 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats->set(sm);
															#line 694 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> result = findTenantShardBoundaries(&shards, tenantKeys);
															#line 696 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<std::vector<KeyRef>> expectedFaultLines = {};
															#line 697 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(faultLinesMatch(result, expectedFaultLines));
															#line 699 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase678Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase678ActorState(); static_cast<FlowTestCase678Actor*>(this)->destroy(); return 0; }
															#line 3017 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase678Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase678ActorState();
		static_cast<FlowTestCase678Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 680 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardTrackedData data;
															#line 681 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardMetrics sm(StorageMetrics(), now(), 1);
															#line 682 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 684 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeMap<ShardTrackedData> shards;
															#line 686 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin = "a"_sr, end = "f"_sr;
															#line 687 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k(begin, end);
															#line 688 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k, data);
															#line 690 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef tenantKeys("a"_sr, "f"_sr);
															#line 692 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats->set(sm);
															#line 694 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> result = findTenantShardBoundaries(&shards, tenantKeys);
															#line 696 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<std::vector<KeyRef>> expectedFaultLines = {};
															#line 697 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(faultLinesMatch(result, expectedFaultLines));
															#line 699 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase678Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase678ActorState(); static_cast<FlowTestCase678Actor*>(this)->destroy(); return 0; }
															#line 3053 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase678Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase678ActorState();
		static_cast<FlowTestCase678Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase678Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase678Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase678Actor*>(this)->ActorCallback< FlowTestCase678Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase678Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase678", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase678Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase678", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase678Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase678", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase678Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase678", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase678Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase678", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase678Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase678", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 678 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	UnitTestParameters params;
															#line 3138 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase678()
															#line 678 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase678Actor final : public Actor<Void>, public ActorCallback< FlowTestCase678Actor, 0, Void >, public FastAllocated<FlowTestCase678Actor>, public FlowTestCase678ActorState<FlowTestCase678Actor> {
															#line 3143 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase678Actor>::operator new;
	using FastAllocated<FlowTestCase678Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4128150552568901120UL, 5537018095671422720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase678Actor, 0, Void >;
															#line 678 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase678Actor(UnitTestParameters const& params) 
															#line 3160 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase678ActorState<FlowTestCase678Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase678", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13033606024022344448UL, 15252850492105295872UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase678Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase678");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase678", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase678Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 678 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
static Future<Void> flowTestCase678( UnitTestParameters const& params ) {
															#line 678 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FlowTestCase678Actor(params));
															#line 3193 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase678, "/DataDistribution/Tenant/SingleShardTenantAligned")

#line 701 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 3199 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase702()
															#line 702 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FlowTestCase702Actor>
															#line 702 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase702ActorState {
															#line 3206 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 702 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase702ActorState(UnitTestParameters const& params) 
															#line 702 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 702 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : params(params)
															#line 3213 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase702", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase702ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase702", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 703 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Void());
															#line 703 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FlowTestCase702Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3230 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase702Actor*>(this)->actor_wait_state = 1;
															#line 703 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase702Actor, 0, Void >*>(static_cast<FlowTestCase702Actor*>(this)));
															#line 3235 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase702ActorState();
		static_cast<FlowTestCase702Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 704 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardTrackedData data;
															#line 705 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardMetrics sm(StorageMetrics(), now(), 1);
															#line 706 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 708 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeMap<ShardTrackedData> shards;
															#line 710 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin = "a"_sr, end = "f"_sr;
															#line 711 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k(begin, end);
															#line 712 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k, data);
															#line 714 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef tenantKeys("a"_sr, "d"_sr);
															#line 716 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats->set(sm);
															#line 718 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> result = findTenantShardBoundaries(&shards, tenantKeys);
															#line 720 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<std::vector<KeyRef>> expectedFaultLines = { { "a"_sr, "d"_sr, "f"_sr } };
															#line 721 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(faultLinesMatch(result, expectedFaultLines));
															#line 723 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase702Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase702ActorState(); static_cast<FlowTestCase702Actor*>(this)->destroy(); return 0; }
															#line 3282 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase702Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase702ActorState();
		static_cast<FlowTestCase702Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 704 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardTrackedData data;
															#line 705 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardMetrics sm(StorageMetrics(), now(), 1);
															#line 706 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 708 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeMap<ShardTrackedData> shards;
															#line 710 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin = "a"_sr, end = "f"_sr;
															#line 711 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k(begin, end);
															#line 712 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k, data);
															#line 714 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef tenantKeys("a"_sr, "d"_sr);
															#line 716 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats->set(sm);
															#line 718 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> result = findTenantShardBoundaries(&shards, tenantKeys);
															#line 720 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<std::vector<KeyRef>> expectedFaultLines = { { "a"_sr, "d"_sr, "f"_sr } };
															#line 721 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(faultLinesMatch(result, expectedFaultLines));
															#line 723 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase702Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase702ActorState(); static_cast<FlowTestCase702Actor*>(this)->destroy(); return 0; }
															#line 3318 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase702Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase702ActorState();
		static_cast<FlowTestCase702Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase702Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase702Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase702Actor*>(this)->ActorCallback< FlowTestCase702Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase702Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase702", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase702Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase702", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase702Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase702", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase702Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase702", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase702Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase702", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase702Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase702", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 702 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	UnitTestParameters params;
															#line 3403 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase702()
															#line 702 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase702Actor final : public Actor<Void>, public ActorCallback< FlowTestCase702Actor, 0, Void >, public FastAllocated<FlowTestCase702Actor>, public FlowTestCase702ActorState<FlowTestCase702Actor> {
															#line 3408 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase702Actor>::operator new;
	using FastAllocated<FlowTestCase702Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4023130482258238976UL, 13451854158447291648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase702Actor, 0, Void >;
															#line 702 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase702Actor(UnitTestParameters const& params) 
															#line 3425 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase702ActorState<FlowTestCase702Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase702", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14299021289775095040UL, 12614485869169099520UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase702Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase702");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase702", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase702Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 702 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
static Future<Void> flowTestCase702( UnitTestParameters const& params ) {
															#line 702 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FlowTestCase702Actor(params));
															#line 3458 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase702, "/DataDistribution/Tenant/SingleShardTenantAlignedAtStart")

#line 725 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 3464 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase726()
															#line 726 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FlowTestCase726Actor>
															#line 726 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase726ActorState {
															#line 3471 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 726 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase726ActorState(UnitTestParameters const& params) 
															#line 726 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 726 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : params(params)
															#line 3478 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase726", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase726ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase726", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 727 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Void());
															#line 727 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FlowTestCase726Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3495 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase726Actor*>(this)->actor_wait_state = 1;
															#line 727 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase726Actor, 0, Void >*>(static_cast<FlowTestCase726Actor*>(this)));
															#line 3500 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase726ActorState();
		static_cast<FlowTestCase726Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 728 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardTrackedData data;
															#line 729 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardMetrics sm(StorageMetrics(), now(), 1);
															#line 730 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 732 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeMap<ShardTrackedData> shards;
															#line 734 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin = "a"_sr, end = "f"_sr;
															#line 735 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k(begin, end);
															#line 736 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k, data);
															#line 738 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef tenantKeys("b"_sr, "f"_sr);
															#line 740 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats->set(sm);
															#line 742 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> result = findTenantShardBoundaries(&shards, tenantKeys);
															#line 744 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<std::vector<KeyRef>> expectedFaultLines = { { "a"_sr, "b"_sr, "f"_sr } };
															#line 745 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(faultLinesMatch(result, expectedFaultLines));
															#line 747 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase726Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase726ActorState(); static_cast<FlowTestCase726Actor*>(this)->destroy(); return 0; }
															#line 3547 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase726Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase726ActorState();
		static_cast<FlowTestCase726Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 728 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardTrackedData data;
															#line 729 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardMetrics sm(StorageMetrics(), now(), 1);
															#line 730 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 732 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeMap<ShardTrackedData> shards;
															#line 734 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin = "a"_sr, end = "f"_sr;
															#line 735 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k(begin, end);
															#line 736 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k, data);
															#line 738 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef tenantKeys("b"_sr, "f"_sr);
															#line 740 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data.stats->set(sm);
															#line 742 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> result = findTenantShardBoundaries(&shards, tenantKeys);
															#line 744 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<std::vector<KeyRef>> expectedFaultLines = { { "a"_sr, "b"_sr, "f"_sr } };
															#line 745 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(faultLinesMatch(result, expectedFaultLines));
															#line 747 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase726Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase726ActorState(); static_cast<FlowTestCase726Actor*>(this)->destroy(); return 0; }
															#line 3583 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase726Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase726ActorState();
		static_cast<FlowTestCase726Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase726Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase726Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase726Actor*>(this)->ActorCallback< FlowTestCase726Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase726Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase726", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase726Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase726", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase726Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase726", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase726Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase726", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase726Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase726", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase726Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase726", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 726 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	UnitTestParameters params;
															#line 3668 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase726()
															#line 726 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase726Actor final : public Actor<Void>, public ActorCallback< FlowTestCase726Actor, 0, Void >, public FastAllocated<FlowTestCase726Actor>, public FlowTestCase726ActorState<FlowTestCase726Actor> {
															#line 3673 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase726Actor>::operator new;
	using FastAllocated<FlowTestCase726Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7803829229005991168UL, 1195044059571393792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase726Actor, 0, Void >;
															#line 726 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase726Actor(UnitTestParameters const& params) 
															#line 3690 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase726ActorState<FlowTestCase726Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase726", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(182326355348364544UL, 12557845224503988992UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase726Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase726");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase726", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase726Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 726 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
static Future<Void> flowTestCase726( UnitTestParameters const& params ) {
															#line 726 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FlowTestCase726Actor(params));
															#line 3723 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase726, "/DataDistribution/Tenant/SingleShardTenantAlignedAtEnd")

#line 749 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 3729 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase750()
															#line 750 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FlowTestCase750Actor>
															#line 750 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase750ActorState {
															#line 3736 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 750 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase750ActorState(UnitTestParameters const& params) 
															#line 750 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 750 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : params(params)
															#line 3743 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase750", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase750ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase750", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Void());
															#line 751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FlowTestCase750Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3760 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase750Actor*>(this)->actor_wait_state = 1;
															#line 751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase750Actor, 0, Void >*>(static_cast<FlowTestCase750Actor*>(this)));
															#line 3765 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase750ActorState();
		static_cast<FlowTestCase750Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 752 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardTrackedData data1, data2;
															#line 753 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardMetrics sm(StorageMetrics(), now(), 1);
															#line 754 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data1.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 755 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data2.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 757 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeMap<ShardTrackedData> shards;
															#line 759 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin1 = "a"_sr, end1 = "c"_sr;
															#line 760 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin2 = "d"_sr, end2 = "f"_sr;
															#line 761 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k1(begin1, end1);
															#line 762 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k2(begin2, end2);
															#line 764 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k1, data1);
															#line 765 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k2, data2);
															#line 767 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef tenantKeys("b"_sr, "e"_sr);
															#line 769 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data1.stats->set(sm);
															#line 770 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data2.stats->set(sm);
															#line 772 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> result = findTenantShardBoundaries(&shards, tenantKeys);
															#line 774 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( auto& range : result ) {
															#line 775 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			KeyRangeRef keys = KeyRangeRef(range.shard->begin(), range.shard->end());
															#line 776 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			traceSplit(keys, range.faultLines);
															#line 3822 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 779 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<std::vector<KeyRef>> expectedFaultLines = { { "a"_sr, "b"_sr, "c"_sr }, { "d"_sr, "e"_sr, "f"_sr } };
															#line 780 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(faultLinesMatch(result, expectedFaultLines));
															#line 782 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase750Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase750ActorState(); static_cast<FlowTestCase750Actor*>(this)->destroy(); return 0; }
															#line 3830 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase750Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase750ActorState();
		static_cast<FlowTestCase750Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 752 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardTrackedData data1, data2;
															#line 753 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardMetrics sm(StorageMetrics(), now(), 1);
															#line 754 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data1.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 755 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data2.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 757 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeMap<ShardTrackedData> shards;
															#line 759 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin1 = "a"_sr, end1 = "c"_sr;
															#line 760 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin2 = "d"_sr, end2 = "f"_sr;
															#line 761 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k1(begin1, end1);
															#line 762 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k2(begin2, end2);
															#line 764 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k1, data1);
															#line 765 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k2, data2);
															#line 767 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef tenantKeys("b"_sr, "e"_sr);
															#line 769 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data1.stats->set(sm);
															#line 770 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data2.stats->set(sm);
															#line 772 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> result = findTenantShardBoundaries(&shards, tenantKeys);
															#line 774 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( auto& range : result ) {
															#line 775 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			KeyRangeRef keys = KeyRangeRef(range.shard->begin(), range.shard->end());
															#line 776 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			traceSplit(keys, range.faultLines);
															#line 3876 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 779 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<std::vector<KeyRef>> expectedFaultLines = { { "a"_sr, "b"_sr, "c"_sr }, { "d"_sr, "e"_sr, "f"_sr } };
															#line 780 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(faultLinesMatch(result, expectedFaultLines));
															#line 782 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase750Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase750ActorState(); static_cast<FlowTestCase750Actor*>(this)->destroy(); return 0; }
															#line 3884 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase750Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase750ActorState();
		static_cast<FlowTestCase750Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase750Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase750Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase750Actor*>(this)->ActorCallback< FlowTestCase750Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase750Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase750", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase750Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase750", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase750Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase750", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase750Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase750", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase750Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase750", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase750Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase750", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 750 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	UnitTestParameters params;
															#line 3969 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase750()
															#line 750 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase750Actor final : public Actor<Void>, public ActorCallback< FlowTestCase750Actor, 0, Void >, public FastAllocated<FlowTestCase750Actor>, public FlowTestCase750ActorState<FlowTestCase750Actor> {
															#line 3974 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase750Actor>::operator new;
	using FastAllocated<FlowTestCase750Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12448359962346249216UL, 10242844050318400000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase750Actor, 0, Void >;
															#line 750 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase750Actor(UnitTestParameters const& params) 
															#line 3991 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase750ActorState<FlowTestCase750Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase750", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11308439092086508032UL, 13399189322470465536UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase750Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase750");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase750", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase750Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 750 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
static Future<Void> flowTestCase750( UnitTestParameters const& params ) {
															#line 750 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FlowTestCase750Actor(params));
															#line 4024 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase750, "/DataDistribution/Tenant/DoubleShardSplit")

#line 784 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 4030 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase785()
															#line 785 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FlowTestCase785Actor>
															#line 785 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase785ActorState {
															#line 4037 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 785 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase785ActorState(UnitTestParameters const& params) 
															#line 785 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 785 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : params(params)
															#line 4044 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase785", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase785ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase785", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 786 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Void());
															#line 786 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FlowTestCase785Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4061 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase785Actor*>(this)->actor_wait_state = 1;
															#line 786 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase785Actor, 0, Void >*>(static_cast<FlowTestCase785Actor*>(this)));
															#line 4066 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase785ActorState();
		static_cast<FlowTestCase785Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 787 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardTrackedData data1, data2;
															#line 788 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardMetrics sm(StorageMetrics(), now(), 1);
															#line 789 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data1.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 790 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data2.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 792 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeMap<ShardTrackedData> shards;
															#line 794 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin1 = "a"_sr, end1 = "c"_sr;
															#line 795 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin2 = "d"_sr, end2 = "f"_sr;
															#line 796 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k1(begin1, end1);
															#line 797 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k2(begin2, end2);
															#line 799 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k1, data1);
															#line 800 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k2, data2);
															#line 802 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef tenantKeys("a"_sr, "e"_sr);
															#line 804 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data1.stats->set(sm);
															#line 805 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data2.stats->set(sm);
															#line 807 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> result = findTenantShardBoundaries(&shards, tenantKeys);
															#line 809 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<std::vector<KeyRef>> expectedFaultLines = { { "d"_sr, "e"_sr, "f"_sr } };
															#line 810 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(faultLinesMatch(result, expectedFaultLines));
															#line 812 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase785Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase785ActorState(); static_cast<FlowTestCase785Actor*>(this)->destroy(); return 0; }
															#line 4123 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase785Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase785ActorState();
		static_cast<FlowTestCase785Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 787 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardTrackedData data1, data2;
															#line 788 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardMetrics sm(StorageMetrics(), now(), 1);
															#line 789 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data1.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 790 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data2.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 792 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeMap<ShardTrackedData> shards;
															#line 794 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin1 = "a"_sr, end1 = "c"_sr;
															#line 795 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin2 = "d"_sr, end2 = "f"_sr;
															#line 796 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k1(begin1, end1);
															#line 797 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k2(begin2, end2);
															#line 799 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k1, data1);
															#line 800 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k2, data2);
															#line 802 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef tenantKeys("a"_sr, "e"_sr);
															#line 804 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data1.stats->set(sm);
															#line 805 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data2.stats->set(sm);
															#line 807 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> result = findTenantShardBoundaries(&shards, tenantKeys);
															#line 809 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<std::vector<KeyRef>> expectedFaultLines = { { "d"_sr, "e"_sr, "f"_sr } };
															#line 810 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(faultLinesMatch(result, expectedFaultLines));
															#line 812 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase785Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase785ActorState(); static_cast<FlowTestCase785Actor*>(this)->destroy(); return 0; }
															#line 4169 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase785Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase785ActorState();
		static_cast<FlowTestCase785Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase785Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase785Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase785Actor*>(this)->ActorCallback< FlowTestCase785Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase785Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase785", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase785Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase785", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase785Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase785", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase785Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase785", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase785Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase785", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase785Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase785", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 785 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	UnitTestParameters params;
															#line 4254 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase785()
															#line 785 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase785Actor final : public Actor<Void>, public ActorCallback< FlowTestCase785Actor, 0, Void >, public FastAllocated<FlowTestCase785Actor>, public FlowTestCase785ActorState<FlowTestCase785Actor> {
															#line 4259 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase785Actor>::operator new;
	using FastAllocated<FlowTestCase785Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12037890260874859264UL, 10071124420799781376UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase785Actor, 0, Void >;
															#line 785 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase785Actor(UnitTestParameters const& params) 
															#line 4276 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase785ActorState<FlowTestCase785Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase785", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1997556968121289216UL, 3675660456581784832UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase785Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase785");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase785", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase785Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 785 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
static Future<Void> flowTestCase785( UnitTestParameters const& params ) {
															#line 785 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FlowTestCase785Actor(params));
															#line 4309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase785, "/DataDistribution/Tenant/DoubleShardTenantAlignedAtStart")

#line 814 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 4315 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase815()
															#line 815 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FlowTestCase815Actor>
															#line 815 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase815ActorState {
															#line 4322 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 815 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase815ActorState(UnitTestParameters const& params) 
															#line 815 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 815 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : params(params)
															#line 4329 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase815", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase815ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase815", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 816 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Void());
															#line 816 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FlowTestCase815Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4346 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase815Actor*>(this)->actor_wait_state = 1;
															#line 816 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase815Actor, 0, Void >*>(static_cast<FlowTestCase815Actor*>(this)));
															#line 4351 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase815ActorState();
		static_cast<FlowTestCase815Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 817 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardTrackedData data1, data2;
															#line 818 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardMetrics sm(StorageMetrics(), now(), 1);
															#line 819 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data1.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 820 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data2.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 822 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeMap<ShardTrackedData> shards;
															#line 824 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin1 = "a"_sr, end1 = "c"_sr;
															#line 825 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin2 = "d"_sr, end2 = "f"_sr;
															#line 826 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k1(begin1, end1);
															#line 827 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k2(begin2, end2);
															#line 829 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k1, data1);
															#line 830 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k2, data2);
															#line 832 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef tenantKeys("b"_sr, "f"_sr);
															#line 834 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data1.stats->set(sm);
															#line 835 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data2.stats->set(sm);
															#line 837 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> result = findTenantShardBoundaries(&shards, tenantKeys);
															#line 839 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<std::vector<KeyRef>> expectedFaultLines = { { "a"_sr, "b"_sr, "c"_sr } };
															#line 840 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(faultLinesMatch(result, expectedFaultLines));
															#line 842 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase815Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase815ActorState(); static_cast<FlowTestCase815Actor*>(this)->destroy(); return 0; }
															#line 4408 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase815Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase815ActorState();
		static_cast<FlowTestCase815Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 817 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardTrackedData data1, data2;
															#line 818 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ShardMetrics sm(StorageMetrics(), now(), 1);
															#line 819 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data1.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 820 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data2.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
															#line 822 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeMap<ShardTrackedData> shards;
															#line 824 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin1 = "a"_sr, end1 = "c"_sr;
															#line 825 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRef begin2 = "d"_sr, end2 = "f"_sr;
															#line 826 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k1(begin1, end1);
															#line 827 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef k2(begin2, end2);
															#line 829 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k1, data1);
															#line 830 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		shards.insert(k2, data2);
															#line 832 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		KeyRangeRef tenantKeys("b"_sr, "f"_sr);
															#line 834 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data1.stats->set(sm);
															#line 835 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		data2.stats->set(sm);
															#line 837 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> result = findTenantShardBoundaries(&shards, tenantKeys);
															#line 839 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<std::vector<KeyRef>> expectedFaultLines = { { "a"_sr, "b"_sr, "c"_sr } };
															#line 840 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(faultLinesMatch(result, expectedFaultLines));
															#line 842 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase815Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase815ActorState(); static_cast<FlowTestCase815Actor*>(this)->destroy(); return 0; }
															#line 4454 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase815Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase815ActorState();
		static_cast<FlowTestCase815Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase815Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase815Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase815Actor*>(this)->ActorCallback< FlowTestCase815Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase815Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase815", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase815Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase815", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase815Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase815", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase815Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase815", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase815Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase815", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase815Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase815", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 815 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	UnitTestParameters params;
															#line 4539 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase815()
															#line 815 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase815Actor final : public Actor<Void>, public ActorCallback< FlowTestCase815Actor, 0, Void >, public FastAllocated<FlowTestCase815Actor>, public FlowTestCase815ActorState<FlowTestCase815Actor> {
															#line 4544 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase815Actor>::operator new;
	using FastAllocated<FlowTestCase815Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8224086854301561600UL, 13088344545097479168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase815Actor, 0, Void >;
															#line 815 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase815Actor(UnitTestParameters const& params) 
															#line 4561 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase815ActorState<FlowTestCase815Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase815", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6611298764997514752UL, 635811557548360192UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase815Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase815");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase815", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase815Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 815 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
static Future<Void> flowTestCase815( UnitTestParameters const& params ) {
															#line 815 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FlowTestCase815Actor(params));
															#line 4594 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase815, "/DataDistribution/Tenant/DoubleShardTenantAlignedAtEnd")

#line 844 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 4600 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via tenantShardSplitter()
															#line 845 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class TenantShardSplitterActor>
															#line 845 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TenantShardSplitterActorState {
															#line 4607 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 845 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TenantShardSplitterActorState(DataDistributionTracker* const& self,KeyRange const& tenantKeys) 
															#line 845 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 845 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 845 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   tenantKeys(tenantKeys)
															#line 4616 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantShardSplitter", reinterpret_cast<unsigned long>(this));

	}
	~TenantShardSplitterActorState() 
	{
		fdb_probe_actor_destroy("tenantShardSplitter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 846 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = Future<Void>(Void());
															#line 846 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<TenantShardSplitterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4633 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TenantShardSplitterActor*>(this)->actor_wait_state = 1;
															#line 846 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TenantShardSplitterActor, 0, Void >*>(static_cast<TenantShardSplitterActor*>(this)));
															#line 4638 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantShardSplitterActorState();
		static_cast<TenantShardSplitterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 847 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> rangesToSplit = findTenantShardBoundaries(self->shards, tenantKeys);
															#line 849 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( auto& range : rangesToSplit ) {
															#line 850 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			KeyRangeRef keys = KeyRangeRef(range.shard->begin(), range.shard->end());
															#line 851 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			traceSplit(keys, range.faultLines);
															#line 852 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			executeShardSplit(self, keys, range.faultLines, range.shard->value().stats, true, RelocateReason::TENANT_SPLIT);
															#line 4669 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 855 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<TenantShardSplitterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TenantShardSplitterActorState(); static_cast<TenantShardSplitterActor*>(this)->destroy(); return 0; }
															#line 4673 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<TenantShardSplitterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TenantShardSplitterActorState();
		static_cast<TenantShardSplitterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 847 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::vector<RangeToSplit> rangesToSplit = findTenantShardBoundaries(self->shards, tenantKeys);
															#line 849 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( auto& range : rangesToSplit ) {
															#line 850 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			KeyRangeRef keys = KeyRangeRef(range.shard->begin(), range.shard->end());
															#line 851 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			traceSplit(keys, range.faultLines);
															#line 852 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			executeShardSplit(self, keys, range.faultLines, range.shard->value().stats, true, RelocateReason::TENANT_SPLIT);
															#line 4693 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 855 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<TenantShardSplitterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TenantShardSplitterActorState(); static_cast<TenantShardSplitterActor*>(this)->destroy(); return 0; }
															#line 4697 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<TenantShardSplitterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TenantShardSplitterActorState();
		static_cast<TenantShardSplitterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantShardSplitterActor*>(this)->actor_wait_state > 0) static_cast<TenantShardSplitterActor*>(this)->actor_wait_state = 0;
		static_cast<TenantShardSplitterActor*>(this)->ActorCallback< TenantShardSplitterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantShardSplitterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantShardSplitter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantShardSplitter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TenantShardSplitterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantShardSplitter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantShardSplitter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TenantShardSplitterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantShardSplitter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantShardSplitter", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 845 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 845 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange tenantKeys;
															#line 4784 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via tenantShardSplitter()
															#line 845 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TenantShardSplitterActor final : public Actor<Void>, public ActorCallback< TenantShardSplitterActor, 0, Void >, public FastAllocated<TenantShardSplitterActor>, public TenantShardSplitterActorState<TenantShardSplitterActor> {
															#line 4789 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<TenantShardSplitterActor>::operator new;
	using FastAllocated<TenantShardSplitterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13309962149381914112UL, 7046218845933325312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TenantShardSplitterActor, 0, Void >;
															#line 845 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TenantShardSplitterActor(DataDistributionTracker* const& self,KeyRange const& tenantKeys) 
															#line 4806 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   TenantShardSplitterActorState<TenantShardSplitterActor>(self, tenantKeys),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantShardSplitter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2028216487851187712UL, 8103513350710152960UL);
		ActorExecutionContextHelper __helper(static_cast<TenantShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantShardSplitter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantShardSplitter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TenantShardSplitterActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 845 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> tenantShardSplitter( DataDistributionTracker* const& self, KeyRange const& tenantKeys ) {
															#line 845 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new TenantShardSplitterActor(self, tenantKeys));
															#line 4839 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 857 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 4844 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via tenantCreationHandling()
															#line 858 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class TenantCreationHandlingActor>
															#line 858 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TenantCreationHandlingActorState {
															#line 4851 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 858 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TenantCreationHandlingActorState(DataDistributionTracker* const& self,TenantCacheTenantCreated const& req) 
															#line 858 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 858 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 858 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(req)
															#line 4860 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("tenantCreationHandling", reinterpret_cast<unsigned long>(this));

	}
	~TenantCreationHandlingActorState() 
	{
		fdb_probe_actor_destroy("tenantCreationHandling", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 859 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			TraceEvent(SevInfo, "TenantCacheTenantCreated").detail("Begin", req.keys.begin).detail("End", req.keys.end);
															#line 861 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tenantShardSplitter(self, req.keys);
															#line 861 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<TenantCreationHandlingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4879 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TenantCreationHandlingActor*>(this)->actor_wait_state = 1;
															#line 861 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TenantCreationHandlingActor, 0, Void >*>(static_cast<TenantCreationHandlingActor*>(this)));
															#line 4884 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TenantCreationHandlingActorState();
		static_cast<TenantCreationHandlingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 862 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.reply.send(true);
															#line 863 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<TenantCreationHandlingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TenantCreationHandlingActorState(); static_cast<TenantCreationHandlingActor*>(this)->destroy(); return 0; }
															#line 4909 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<TenantCreationHandlingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TenantCreationHandlingActorState();
		static_cast<TenantCreationHandlingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 862 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.reply.send(true);
															#line 863 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<TenantCreationHandlingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TenantCreationHandlingActorState(); static_cast<TenantCreationHandlingActor*>(this)->destroy(); return 0; }
															#line 4923 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<TenantCreationHandlingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TenantCreationHandlingActorState();
		static_cast<TenantCreationHandlingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TenantCreationHandlingActor*>(this)->actor_wait_state > 0) static_cast<TenantCreationHandlingActor*>(this)->actor_wait_state = 0;
		static_cast<TenantCreationHandlingActor*>(this)->ActorCallback< TenantCreationHandlingActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TenantCreationHandlingActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("tenantCreationHandling", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreationHandlingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreationHandling", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TenantCreationHandlingActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("tenantCreationHandling", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreationHandlingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreationHandling", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TenantCreationHandlingActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("tenantCreationHandling", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreationHandlingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("tenantCreationHandling", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 858 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 858 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TenantCacheTenantCreated req;
															#line 5010 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via tenantCreationHandling()
															#line 858 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TenantCreationHandlingActor final : public Actor<Void>, public ActorCallback< TenantCreationHandlingActor, 0, Void >, public FastAllocated<TenantCreationHandlingActor>, public TenantCreationHandlingActorState<TenantCreationHandlingActor> {
															#line 5015 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<TenantCreationHandlingActor>::operator new;
	using FastAllocated<TenantCreationHandlingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7723532809216267776UL, 229822161696556288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TenantCreationHandlingActor, 0, Void >;
															#line 858 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TenantCreationHandlingActor(DataDistributionTracker* const& self,TenantCacheTenantCreated const& req) 
															#line 5032 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   TenantCreationHandlingActorState<TenantCreationHandlingActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("tenantCreationHandling", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15587854374318735872UL, 5099636547166237696UL);
		ActorExecutionContextHelper __helper(static_cast<TenantCreationHandlingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("tenantCreationHandling");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("tenantCreationHandling", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TenantCreationHandlingActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 858 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> tenantCreationHandling( DataDistributionTracker* const& self, TenantCacheTenantCreated const& req ) {
															#line 858 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new TenantCreationHandlingActor(self, req));
															#line 5065 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 865 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 5070 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via shardSplitter()
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class ShardSplitterActor>
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardSplitterActorState {
															#line 5077 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardSplitterActorState(DataDistributionTracker* const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize,ShardSizeBounds const& shardBounds,RelocateReason const& reason) 
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   keys(keys),
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardSize(shardSize),
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardBounds(shardBounds),
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   reason(reason),
															#line 871 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   metrics(shardSize->get().get().metrics),
															#line 872 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   bandwidthStatus(getBandwidthStatus(metrics))
															#line 5096 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("shardSplitter", reinterpret_cast<unsigned long>(this));

	}
	~ShardSplitterActorState() 
	{
		fdb_probe_actor_destroy("shardSplitter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 875 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			CODE_PROBE(true, "shard to be split");
															#line 877 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StorageMetrics splitMetrics;
															#line 878 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			splitMetrics.bytes = shardBounds.max.bytes / 2;
															#line 879 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			splitMetrics.bytesWrittenPerKSecond = keys.begin >= keyServersKeys.begin ? splitMetrics.infinity : SERVER_KNOBS->SHARD_SPLIT_BYTES_PER_KSEC;
															#line 881 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			splitMetrics.iosPerKSecond = splitMetrics.infinity;
															#line 882 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			splitMetrics.bytesReadPerKSecond = splitMetrics.infinity;
															#line 884 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Standalone<VectorRef<KeyRef>>> __when_expr_0 = self->db->splitStorageMetrics(keys, splitMetrics, metrics, SERVER_KNOBS->MIN_SHARD_BYTES);
															#line 884 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardSplitterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5125 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ShardSplitterActor*>(this)->actor_wait_state = 1;
															#line 884 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >*>(static_cast<ShardSplitterActor*>(this)));
															#line 5130 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ShardSplitterActorState();
		static_cast<ShardSplitterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 890 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int numShards = splitKeys.size() - 1;
															#line 892 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		TraceEvent("RelocateShardStartSplit", self->distributorId) .suppressFor(1.0) .detail("Begin", keys.begin) .detail("End", keys.end) .detail("MaxBytes", shardBounds.max.bytes) .detail("MetricsBytes", metrics.bytes) .detail("Bandwidth", bandwidthStatus == BandwidthStatusHigh ? "High" : bandwidthStatus == BandwidthStatusNormal ? "Normal" : "Low") .detail("BytesWrittenPerKSec", metrics.bytesWrittenPerKSecond) .detail("NumShards", numShards);
															#line 905 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (numShards > 1)
															#line 5157 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 906 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			executeShardSplit(self, keys, splitKeys, shardSize, true, reason);
															#line 5161 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = a_body1cont2(loopDepth);
		}
		else
		{
															#line 908 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(1.0, TaskPriority::DataDistribution);
															#line 908 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardSplitterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5170 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ShardSplitterActor*>(this)->actor_wait_state = 2;
															#line 908 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShardSplitterActor, 1, Void >*>(static_cast<ShardSplitterActor*>(this)));
															#line 5175 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRef>> const& __splitKeys,int loopDepth) 
	{
															#line 884 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		splitKeys = __splitKeys;
															#line 5185 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<VectorRef<KeyRef>> && __splitKeys,int loopDepth) 
	{
		splitKeys = std::move(__splitKeys);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ShardSplitterActor*>(this)->actor_wait_state > 0) static_cast<ShardSplitterActor*>(this)->actor_wait_state = 0;
		static_cast<ShardSplitterActor*>(this)->ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> const& value) 
	{
		fdb_probe_actor_enter("shardSplitter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardSplitter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >*,Standalone<VectorRef<KeyRef>> && value) 
	{
		fdb_probe_actor_enter("shardSplitter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardSplitter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("shardSplitter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardSplitter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 911 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<ShardSplitterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ShardSplitterActorState(); static_cast<ShardSplitterActor*>(this)->destroy(); return 0; }
															#line 5264 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<ShardSplitterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ShardSplitterActorState();
		static_cast<ShardSplitterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ShardSplitterActor*>(this)->actor_wait_state > 0) static_cast<ShardSplitterActor*>(this)->actor_wait_state = 0;
		static_cast<ShardSplitterActor*>(this)->ActorCallback< ShardSplitterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardSplitterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardSplitter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardSplitter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ShardSplitterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardSplitter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardSplitter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ShardSplitterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardSplitter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardSplitter", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<ShardMetrics>>> shardSize;
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardSizeBounds shardBounds;
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	RelocateReason reason;
															#line 871 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	StorageMetrics metrics;
															#line 872 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	BandwidthStatus bandwidthStatus;
															#line 884 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Standalone<VectorRef<KeyRef>> splitKeys;
															#line 5375 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via shardSplitter()
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardSplitterActor final : public Actor<Void>, public ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >, public ActorCallback< ShardSplitterActor, 1, Void >, public FastAllocated<ShardSplitterActor>, public ShardSplitterActorState<ShardSplitterActor> {
															#line 5380 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<ShardSplitterActor>::operator new;
	using FastAllocated<ShardSplitterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4436647407528692480UL, 1854903597923692800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >;
friend struct ActorCallback< ShardSplitterActor, 1, Void >;
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardSplitterActor(DataDistributionTracker* const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize,ShardSizeBounds const& shardBounds,RelocateReason const& reason) 
															#line 5398 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   ShardSplitterActorState<ShardSplitterActor>(self, keys, shardSize, shardBounds, reason),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("shardSplitter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8500483300706847744UL, 11633084953466301952UL);
		ActorExecutionContextHelper __helper(static_cast<ShardSplitterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("shardSplitter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("shardSplitter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ShardSplitterActor, 0, Standalone<VectorRef<KeyRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ShardSplitterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> shardSplitter( DataDistributionTracker* const& self, KeyRange const& keys, Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize, ShardSizeBounds const& shardBounds, RelocateReason const& reason ) {
															#line 866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new ShardSplitterActor(self, keys, shardSize, shardBounds, reason));
															#line 5432 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 913 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 5437 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via brokenPromiseToReady()
															#line 914 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class BrokenPromiseToReadyActor>
															#line 914 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class BrokenPromiseToReadyActorState {
															#line 5444 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 914 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	BrokenPromiseToReadyActorState(Future<Void> const& f) 
															#line 914 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 914 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : f(f)
															#line 5451 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("brokenPromiseToReady", reinterpret_cast<unsigned long>(this));

	}
	~BrokenPromiseToReadyActorState() 
	{
		fdb_probe_actor_destroy("brokenPromiseToReady", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 916 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = f;
															#line 916 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (static_cast<BrokenPromiseToReadyActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5469 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BrokenPromiseToReadyActor*>(this)->actor_wait_state = 1;
															#line 916 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BrokenPromiseToReadyActor, 0, Void >*>(static_cast<BrokenPromiseToReadyActor*>(this)));
															#line 5474 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BrokenPromiseToReadyActorState();
		static_cast<BrokenPromiseToReadyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 922 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<BrokenPromiseToReadyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BrokenPromiseToReadyActorState(); static_cast<BrokenPromiseToReadyActor*>(this)->destroy(); return 0; }
															#line 5503 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<BrokenPromiseToReadyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BrokenPromiseToReadyActorState();
		static_cast<BrokenPromiseToReadyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 918 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_broken_promise)
															#line 5516 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 919 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 5520 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BrokenPromiseToReadyActor*>(this)->actor_wait_state > 0) static_cast<BrokenPromiseToReadyActor*>(this)->actor_wait_state = 0;
		static_cast<BrokenPromiseToReadyActor*>(this)->ActorCallback< BrokenPromiseToReadyActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToReadyActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BrokenPromiseToReadyActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BrokenPromiseToReadyActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 914 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Future<Void> f;
															#line 5634 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via brokenPromiseToReady()
															#line 914 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class BrokenPromiseToReadyActor final : public Actor<Void>, public ActorCallback< BrokenPromiseToReadyActor, 0, Void >, public FastAllocated<BrokenPromiseToReadyActor>, public BrokenPromiseToReadyActorState<BrokenPromiseToReadyActor> {
															#line 5639 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<BrokenPromiseToReadyActor>::operator new;
	using FastAllocated<BrokenPromiseToReadyActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2529223956702183424UL, 15640181264267993856UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BrokenPromiseToReadyActor, 0, Void >;
															#line 914 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	BrokenPromiseToReadyActor(Future<Void> const& f) 
															#line 5656 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   BrokenPromiseToReadyActorState<BrokenPromiseToReadyActor>(f),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10854979289586105344UL, 2195692730666635776UL);
		ActorExecutionContextHelper __helper(static_cast<BrokenPromiseToReadyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("brokenPromiseToReady");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("brokenPromiseToReady", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BrokenPromiseToReadyActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 914 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> brokenPromiseToReady( Future<Void> const& f ) {
															#line 914 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new BrokenPromiseToReadyActor(f));
															#line 5689 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 924 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

static bool shardMergeFeasible(DataDistributionTracker* self, KeyRange const& keys, KeyRangeRef adjRange) {
	if (!SERVER_KNOBS->DD_TENANT_AWARENESS_ENABLED) {
		return true;
	}

	ASSERT(self->ddTenantCache.present());

	Optional<Reference<TCTenantInfo>> tenantOwningRange = {};
	Optional<Reference<TCTenantInfo>> tenantOwningAdjRange = {};

	tenantOwningRange = self->ddTenantCache.get()->tenantOwning(keys.begin);
	tenantOwningAdjRange = self->ddTenantCache.get()->tenantOwning(adjRange.begin);

	if ((tenantOwningRange.present() != tenantOwningAdjRange.present()) ||
	    (tenantOwningRange.present() && (tenantOwningRange != tenantOwningAdjRange))) {
		return false;
	}

	return true;
}

static bool shardForwardMergeFeasible(DataDistributionTracker* self, KeyRange const& keys, KeyRangeRef nextRange) {
	if (keys.end == allKeys.end) {
		return false;
	}

	if (self->userRangeConfig->rangeContaining(keys.begin)->range().end < nextRange.end) {
		return false;
	}

	if (self->bulkLoadEnabled && self->bulkLoadTaskCollection->bulkLoading(nextRange)) {
		TraceEvent(SevWarn, "ShardCanForwardMergeButUnderBulkLoading", self->distributorId)
		    .suppressFor(5.0)
		    .detail("ShardMerging", keys)
		    .detail("NextShard", nextRange);
		return false;
	}

	return shardMergeFeasible(self, keys, nextRange);
}

static bool shardBackwardMergeFeasible(DataDistributionTracker* self, KeyRange const& keys, KeyRangeRef prevRange) {
	if (keys.begin == allKeys.begin) {
		return false;
	}

	if (self->userRangeConfig->rangeContaining(keys.begin)->range().begin > prevRange.begin) {
		return false;
	}

	if (self->bulkLoadEnabled && self->bulkLoadTaskCollection->bulkLoading(prevRange)) {
		TraceEvent(SevWarn, "ShardCanBackwardMergeButUnderBulkLoading", self->distributorId)
		    .suppressFor(5.0)
		    .detail("ShardMerging", keys)
		    .detail("PrevShard", prevRange);
		return false;
	}

	return shardMergeFeasible(self, keys, prevRange);
}

// Must be atomic
// If cancelledDataMovePriority is set, we may need to issue a data move for the task range because previous data move
// has been stuck and forced to exit. If that data move is an team unhealthy data move, we need to issue a new data
// move.
void createShardToBulkLoad(DataDistributionTracker* self,
                           const BulkLoadTaskState& bulkLoadTaskState,
                           Optional<int> cancelledDataMovePriority) {
	KeyRange keys = bulkLoadTaskState.getRange();
	ASSERT(!keys.empty());
	bool issueDataMoveForCancel = cancelledDataMovePriority.present();
	TraceEvent e(issueDataMoveForCancel ? SevWarnAlways : bulkLoadVerboseEventSev(),
	             "DDBulkLoadEngineCreateShardToBulkLoad",
	             self->distributorId);
	e.detail("TaskID", bulkLoadTaskState.getTaskId());
	e.detail("BulkLoadRange", keys);
	// Create shards at the two ends and do not data move for those shards
	// Create a new shard and trigger data move for bulk loading on the new shard
	// Step 1: split left without data move nor updating dbEstimate size (will be rebuilt after DD restarts)
	for (auto it : self->shards->intersectingRanges(keys)) {
		if (it->range().begin < keys.begin) {
			KeyRange leftRange = Standalone(KeyRangeRef(it->range().begin, keys.begin));
			e.detail("FirstSplitShard", it->range());
			restartShardTrackers(self, leftRange);
			issueDataMoveForCancel = false;
			// Shard boundary has changed. So, there has a shard split or merge data move as a normal data move.
			// Or a new bulkload task has been issued on the range. So, we need not issue data move at this time.
		}
		break;
	}

	// Step 2: split right without data move nor updating dbEstimate size (will be rebuilt after DD restarts)
	for (auto it : self->shards->intersectingRanges(keys)) {
		if (it->range().end > keys.end) {
			KeyRange rightRange = Standalone(KeyRangeRef(keys.end, it->range().end));
			e.detail("LastSplitShard", it->range());
			restartShardTrackers(self, rightRange);
			issueDataMoveForCancel = false;
			// See comments at Step 1
			break;
		}
	}

	// Step 3: merge with new data move
	StorageMetrics oldStats;
	int shardCount = 0;
	for (auto it : self->shards->intersectingRanges(keys)) {
		Reference<AsyncVar<Optional<ShardMetrics>>> stats;
		if (it->value().stats->get().present()) {
			oldStats = oldStats + it->value().stats->get().get().metrics;
			shardCount = shardCount + it->value().stats->get().get().shardCount;
		}
	}
	if (!cancelledDataMovePriority.present()) {
		// If this is for a new bulkload task
		restartShardTrackers(self, keys, ShardMetrics(oldStats, now(), shardCount));
		self->shardsAffectedByTeamFailure->defineShard(keys);
		self->output.send(RelocateShard(
		    keys, DataMovementReason::TEAM_HEALTHY, RelocateReason::OTHER, bulkLoadTaskState.getTaskId()));
	} else if (issueDataMoveForCancel) {
		// If this is for a cancelled task
		restartShardTrackers(self, keys, ShardMetrics(oldStats, now(), shardCount));
		self->shardsAffectedByTeamFailure->defineShard(keys);
		ASSERT(cancelledDataMovePriority.present() &&
		       cancelledDataMovePriority.get() != SERVER_KNOBS->PRIORITY_TEAM_HEALTHY);
		self->output.send(RelocateShard(keys,
		                                priorityToDataMovementReason(cancelledDataMovePriority.get()),
		                                RelocateReason::OTHER,
		                                bulkLoadTaskState.getTaskId()));
	}
	e.detail("NewShardToLoad", keys);
	e.detail("CancelledDataMove", cancelledDataMovePriority.present() ? cancelledDataMovePriority.get() : -1);
	e.detail("IssueDataMoveForCancel", issueDataMoveForCancel);
	return;
}

Future<Void> shardMerger(DataDistributionTracker* self,
                         KeyRange const& keys,
                         Reference<AsyncVar<Optional<ShardMetrics>>> shardSize) {
	const UID actionId = deterministicRandom()->randomUniqueID();
	const Severity stSev = static_cast<Severity>(SERVER_KNOBS->DD_SHARD_TRACKING_LOG_SEVERITY);
	int64_t maxShardSize = self->maxShardSize->get().get();

	auto prevIter = self->shards->rangeContaining(keys.begin);
	auto nextIter = self->shards->rangeContaining(keys.begin);

	CODE_PROBE(true, "shard to be merged");
	ASSERT(keys.begin > allKeys.begin);

	// This will merge shards both before and after "this" shard in keyspace.
	int shardsMerged = 1;
	bool forwardComplete = false;
	KeyRangeRef merged;

	StorageMetrics endingStats = shardSize->get().get().metrics;
	int shardCount = shardSize->get().get().shardCount;
	double lastLowBandwidthStartTime = shardSize->get().get().lastLowBandwidthStartTime;
	if (FLOW_KNOBS->DELAY_JITTER_OFFSET * SERVER_KNOBS->DD_MERGE_COALESCE_DELAY >
	        SERVER_KNOBS->DD_LOW_BANDWIDTH_DELAY &&
	    now() - lastLowBandwidthStartTime < SERVER_KNOBS->DD_LOW_BANDWIDTH_DELAY) {
		TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "ShardMergeTooSoon", self->distributorId)
		    .detail("Keys", keys)
		    .detail("LastLowBandwidthStartTime", lastLowBandwidthStartTime);
	}

	int64_t systemBytes = keys.begin >= systemKeys.begin ? shardSize->get().get().metrics.bytes : 0;

	loop {
		Optional<ShardMetrics> newMetrics;
		if (!forwardComplete) {
			if (nextIter->range().end == allKeys.end) {
				forwardComplete = true;
				continue;
			}

			++nextIter;
			if (!shardForwardMergeFeasible(self, keys, nextIter->range())) {
				--nextIter;
				forwardComplete = true;
				continue;
			}

			newMetrics = nextIter->value().stats->get();

			// If going forward, give up when the next shard's stats are not yet present, or if the
			// the shard is already over the merge bounds.
			const int newCount = newMetrics.present() ? (shardCount + newMetrics.get().shardCount) : shardCount;
			const int64_t newSize =
			    newMetrics.present() ? (endingStats.bytes + newMetrics.get().metrics.bytes) : endingStats.bytes;
			if (!newMetrics.present() || newCount >= CLIENT_KNOBS->SHARD_COUNT_LIMIT || newSize > maxShardSize) {
				if (shardsMerged == 1) {
					TraceEvent(stSev, "ShardMergeStopForward", self->distributorId)
					    .detail("ActionID", actionId)
					    .detail("Keys", keys)
					    .detail("MetricsPresent", newMetrics.present())
					    .detail("ShardCount", newCount)
					    .detail("ShardSize", newSize)
					    .detail("MaxShardSize", maxShardSize);
				}
				--nextIter;
				forwardComplete = true;
				continue;
			}
		} else {
			--prevIter;
			newMetrics = prevIter->value().stats->get();

			if (!shardBackwardMergeFeasible(self, keys, prevIter->range())) {
				++prevIter;
				break;
			}

			// If going backward, stop when the stats are not present or if the shard is already over the merge
			//  bounds. If this check triggers right away (if we have not merged anything) then return a trigger
			//  on the previous shard changing "size".
			const int newCount = newMetrics.present() ? (shardCount + newMetrics.get().shardCount) : shardCount;
			const int64_t newSize =
			    newMetrics.present() ? (endingStats.bytes + newMetrics.get().metrics.bytes) : endingStats.bytes;
			if (!newMetrics.present() || newCount >= CLIENT_KNOBS->SHARD_COUNT_LIMIT || newSize > maxShardSize) {
				if (shardsMerged == 1) {
					TraceEvent(stSev, "ShardMergeStopBackward", self->distributorId)
					    .detail("ActionID", actionId)
					    .detail("Keys", keys)
					    .detail("MetricsPresent", newMetrics.present())
					    .detail("ShardCount", newCount)
					    .detail("ShardSize", newSize)
					    .detail("MaxShardSize", maxShardSize);
					CODE_PROBE(true, "shardMerger cannot merge anything");
					return brokenPromiseToReady(prevIter->value().stats->onChange());
				}

				++prevIter;
				break;
			}
		}

		merged = KeyRangeRef(prevIter->range().begin, nextIter->range().end);
		endingStats += newMetrics.get().metrics;
		shardCount += newMetrics.get().shardCount;
		lastLowBandwidthStartTime = newMetrics.get().lastLowBandwidthStartTime;
		if ((forwardComplete ? prevIter->range().begin : nextIter->range().begin) >= systemKeys.begin) {
			systemBytes += newMetrics.get().metrics.bytes;
		}
		shardsMerged++;

		auto shardBounds = getShardSizeBounds(merged, maxShardSize);
		// If we just recently get the current shard's metrics (i.e., less than DD_LOW_BANDWIDTH_DELAY ago), it
		// means the shard's metric may not be stable yet. So we cannot continue merging in this direction.
		if (endingStats.bytes >= shardBounds.min.bytes || getBandwidthStatus(endingStats) != BandwidthStatusLow ||
		    now() - lastLowBandwidthStartTime < SERVER_KNOBS->DD_LOW_BANDWIDTH_DELAY ||
		    shardsMerged >= SERVER_KNOBS->DD_MERGE_LIMIT) {
			// The merged range is larger than the min bounds so we cannot continue merging in this direction.
			//  This means that:
			//  1. If we were going forwards (the starting direction), we roll back the last speculative merge.
			//      In this direction we do not want to go above this boundary since we will merge at least one in
			//      the other direction, even when that goes over the bounds.
			//  2. If we were going backwards we always want to merge one more shard on (to make sure we go over
			//      the shard min bounds) so we "break" without resetting the merged range.
			if (forwardComplete)
				break;

			shardsMerged--;
			if (shardsMerged == 1) {
				TraceEvent(stSev, "ShardMergeUndoForward", self->distributorId)
				    .detail("ActionID", actionId)
				    .detail("Keys", keys)
				    .detail("ShardCount", shardCount)
				    .detail("EndingMetrics", endingStats.toString())
				    .detail("MaxShardSize", maxShardSize);
			}
			// If going forward, remove most recently added range
			endingStats -= newMetrics.get().metrics;
			shardCount -= newMetrics.get().shardCount;
			if (nextIter->range().begin >= systemKeys.begin) {
				systemBytes -= newMetrics.get().metrics.bytes;
			}
			--nextIter;
			merged = KeyRangeRef(prevIter->range().begin, nextIter->range().end);
			forwardComplete = true;
		}
	}

	if (shardsMerged == 1) {
		return brokenPromiseToReady(nextIter->value().stats->onChange());
	}

	// restarting shard tracker will dereference values in the shard map, so make a copy
	KeyRange mergeRange = merged;

	// OldKeys: Shards in the key range are merged as one shard defined by NewKeys;
	// NewKeys: New key range after shards are merged;
	// EndingSize: The new merged shard size in bytes;
	// BatchedMerges: The number of shards merged. Each shard is defined in self->shards;
	// LastLowBandwidthStartTime: When does a shard's bandwidth status becomes BandwidthStatusLow. If a shard's
	// status
	//   becomes BandwidthStatusLow less than DD_LOW_BANDWIDTH_DELAY ago, the merging logic will stop at the shard;
	// ShardCount: The number of non-splittable shards that are merged. Each shard is defined in self->shards may
	// have
	//   more than 1 shards.
	TraceEvent("RelocateShardMergeMetrics", self->distributorId)
	    .detail("OldKeys", keys)
	    .detail("NewKeys", mergeRange)
	    .detail("EndingSize", endingStats.bytes)
	    .detail("BatchedMerges", shardsMerged)
	    .detail("LastLowBandwidthStartTime", lastLowBandwidthStartTime)
	    .detail("ShardCount", shardCount);

	if (mergeRange.begin < systemKeys.begin) {
		self->systemSizeEstimate -= systemBytes;
	}
	restartShardTrackers(self, mergeRange, ShardMetrics(endingStats, lastLowBandwidthStartTime, shardCount));
	self->shardsAffectedByTeamFailure->defineShard(mergeRange);
	self->output.send(RelocateShard(mergeRange, DataMovementReason::MERGE_SHARD, RelocateReason::MERGE_SHARD));

	// We are about to be cancelled by the call to restartShardTrackers
	return Void();
}

															#line 6012 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via shardEvaluator()
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class ShardEvaluatorActor>
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardEvaluatorActorState {
															#line 6019 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardEvaluatorActorState(DataDistributionTracker* const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize,Reference<HasBeenTrueFor> const& wantsToMerge) 
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   keys(keys),
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardSize(shardSize),
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   wantsToMerge(wantsToMerge)
															#line 6032 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("shardEvaluator", reinterpret_cast<unsigned long>(this));

	}
	~ShardEvaluatorActorState() 
	{
		fdb_probe_actor_destroy("shardEvaluator", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1247 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			Future<Void> onChange = shardSize->onChange() || yieldedFuture(self->maxShardSize->onChange());
															#line 1252 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			ShardSizeBounds shardBounds = getShardSizeBounds(keys, self->maxShardSize->get().get());
															#line 1253 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StorageMetrics const& stats = shardSize->get().get().metrics;
															#line 1254 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			auto bandwidthStatus = getBandwidthStatus(stats);
															#line 1256 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			bool sizeSplit = stats.bytes > shardBounds.max.bytes, writeSplit = bandwidthStatus == BandwidthStatusHigh && keys.begin < keyServersKeys.begin;
															#line 1258 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			bool shouldSplit = sizeSplit || writeSplit;
															#line 1260 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			auto prevIter = self->shards->rangeContaining(keys.begin);
															#line 1261 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (keys.begin > allKeys.begin)
															#line 6061 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1262 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				--prevIter;
															#line 6065 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 1264 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			auto nextIter = self->shards->rangeContaining(keys.begin);
															#line 1265 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (keys.end < allKeys.end)
															#line 6071 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1266 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				++nextIter;
															#line 6075 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 1268 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			bool shouldMerge = stats.bytes < shardBounds.min.bytes && bandwidthStatus == BandwidthStatusLow && (shardForwardMergeFeasible(self, keys, nextIter.range()) || shardBackwardMergeFeasible(self, keys, prevIter.range()));
															#line 1273 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shouldMerge && !self->anyZeroHealthyTeams->get())
															#line 6081 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1274 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				auto whenLongEnough = wantsToMerge->set(shardSize->get().get().lastLowBandwidthStartTime);
															#line 1275 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (!wantsToMerge->hasBeenTrueForLongEnough())
															#line 6087 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				{
															#line 1276 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					onChange = onChange || whenLongEnough;
															#line 6091 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				}
			}
			else
			{
															#line 1279 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				wantsToMerge->clear();
															#line 1280 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (shouldMerge)
															#line 6100 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				{
															#line 1281 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					onChange = onChange || self->anyZeroHealthyTeams->onChange();
															#line 6104 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				}
			}
															#line 1297 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!self->anyZeroHealthyTeams->get() && wantsToMerge->hasBeenTrueForLongEnough())
															#line 6109 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1298 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				onChange = onChange || shardMerger(self, keys, shardSize);
															#line 6113 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 1300 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shouldSplit)
															#line 6117 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1301 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				RelocateReason reason = sizeSplit ? RelocateReason::SIZE_SPLIT : RelocateReason::WRITE_SPLIT;
															#line 1302 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				onChange = onChange || shardSplitter(self, keys, shardSize, shardBounds, reason);
															#line 6123 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 1305 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = onChange;
															#line 1305 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardEvaluatorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6129 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ShardEvaluatorActor*>(this)->actor_wait_state = 1;
															#line 1305 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ShardEvaluatorActor, 0, Void >*>(static_cast<ShardEvaluatorActor*>(this)));
															#line 6134 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ShardEvaluatorActorState();
		static_cast<ShardEvaluatorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1306 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<ShardEvaluatorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ShardEvaluatorActorState(); static_cast<ShardEvaluatorActor*>(this)->destroy(); return 0; }
															#line 6157 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<ShardEvaluatorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ShardEvaluatorActorState();
		static_cast<ShardEvaluatorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1306 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<ShardEvaluatorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ShardEvaluatorActorState(); static_cast<ShardEvaluatorActor*>(this)->destroy(); return 0; }
															#line 6169 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<ShardEvaluatorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ShardEvaluatorActorState();
		static_cast<ShardEvaluatorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ShardEvaluatorActor*>(this)->actor_wait_state > 0) static_cast<ShardEvaluatorActor*>(this)->actor_wait_state = 0;
		static_cast<ShardEvaluatorActor*>(this)->ActorCallback< ShardEvaluatorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardEvaluatorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardEvaluator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardEvaluatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardEvaluator", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ShardEvaluatorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardEvaluator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardEvaluatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardEvaluator", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ShardEvaluatorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardEvaluator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardEvaluatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardEvaluator", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<ShardMetrics>>> shardSize;
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<HasBeenTrueFor> wantsToMerge;
															#line 6260 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via shardEvaluator()
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardEvaluatorActor final : public Actor<Void>, public ActorCallback< ShardEvaluatorActor, 0, Void >, public FastAllocated<ShardEvaluatorActor>, public ShardEvaluatorActorState<ShardEvaluatorActor> {
															#line 6265 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<ShardEvaluatorActor>::operator new;
	using FastAllocated<ShardEvaluatorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18247746175346012160UL, 14598864851988626432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ShardEvaluatorActor, 0, Void >;
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardEvaluatorActor(DataDistributionTracker* const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize,Reference<HasBeenTrueFor> const& wantsToMerge) 
															#line 6282 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   ShardEvaluatorActorState<ShardEvaluatorActor>(self, keys, shardSize, wantsToMerge),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("shardEvaluator", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8816555440906647552UL, 5907959878536576768UL);
		ActorExecutionContextHelper __helper(static_cast<ShardEvaluatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("shardEvaluator");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("shardEvaluator", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ShardEvaluatorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> shardEvaluator( DataDistributionTracker* const& self, KeyRange const& keys, Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize, Reference<HasBeenTrueFor> const& wantsToMerge ) {
															#line 1243 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new ShardEvaluatorActor(self, keys, shardSize, wantsToMerge));
															#line 6315 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 1308 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 6320 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via shardTracker()
															#line 1309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class ShardTrackerActor>
															#line 1309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardTrackerActorState {
															#line 6327 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 1309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardTrackerActorState(DataDistributionTracker::SafeAccessor const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize) 
															#line 1309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   keys(keys),
															#line 1309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardSize(shardSize)
															#line 6338 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("shardTracker", reinterpret_cast<unsigned long>(this));

	}
	~ShardTrackerActorState() 
	{
		fdb_probe_actor_destroy("shardTracker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1312 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = yieldedFuture(self()->readyToStart.getFuture());
															#line 1312 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6355 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ShardTrackerActor*>(this)->actor_wait_state = 1;
															#line 1312 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 0, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 6360 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ShardTrackerActorState();
		static_cast<ShardTrackerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1314 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!shardSize->get().present())
															#line 6383 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 1315 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = shardSize->onChange();
															#line 1315 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6389 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ShardTrackerActor*>(this)->actor_wait_state = 2;
															#line 1315 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 1, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 6394 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1314 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!shardSize->get().present())
															#line 6408 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 1315 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = shardSize->onChange();
															#line 1315 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6414 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ShardTrackerActor*>(this)->actor_wait_state = 2;
															#line 1315 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 1, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 6419 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state > 0) static_cast<ShardTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardTrackerActor*>(this)->ActorCallback< ShardTrackerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ShardTrackerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1317 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!self()->maxShardSize->get().present())
															#line 6508 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 1318 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_2 = yieldedFuture(self()->maxShardSize->onChange());
															#line 1318 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6514 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<ShardTrackerActor*>(this)->actor_wait_state = 3;
															#line 1318 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 2, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 6519 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state > 0) static_cast<ShardTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardTrackerActor*>(this)->ActorCallback< ShardTrackerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ShardTrackerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1321 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(0, TaskPriority::DataDistribution);
															#line 1321 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6622 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<ShardTrackerActor*>(this)->actor_wait_state = 4;
															#line 1321 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 3, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 6627 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state > 0) static_cast<ShardTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardTrackerActor*>(this)->ActorCallback< ShardTrackerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ShardTrackerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1324 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		wantsToMerge = Reference<HasBeenTrueFor>(new HasBeenTrueFor(shardSize->get()));
															#line 6723 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		try {
															#line 1335 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			;
															#line 6727 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = a_body1cont6loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1324 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		wantsToMerge = Reference<HasBeenTrueFor>(new HasBeenTrueFor(shardSize->get()));
															#line 6742 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		try {
															#line 1335 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			;
															#line 6746 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = a_body1cont6loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state > 0) static_cast<ShardTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardTrackerActor*>(this)->ActorCallback< ShardTrackerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ShardTrackerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1352 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_actor_cancelled && e.code() != error_code_dd_tracker_cancelled)
															#line 6837 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1353 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				self()->output.sendError(e);
															#line 6841 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 1355 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 6845 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 1336 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		;
															#line 6866 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont6loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(int loopDepth) 
	{
															#line 1345 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_5 = shardEvaluator(self(), keys, shardSize, wantsToMerge);
															#line 1345 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6877 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont6Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont1when1(__when_expr_5.get(), loopDepth); };
		static_cast<ShardTrackerActor*>(this)->actor_wait_state = 6;
															#line 1345 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 5, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 6882 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1(int loopDepth) 
	{
															#line 1336 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!(self()->bulkLoadEnabled && self()->bulkLoadTaskCollection->bulkLoading(keys)))
															#line 6898 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
			return a_body1cont6loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1337 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		TraceEvent(SevWarn, "ShardBoundaryChangeDisabledForBulkLoad", self()->distributorId) .suppressFor(60.0) .detail("KeyRange", keys);
															#line 1340 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(SERVER_KNOBS->DD_BULKLOAD_SHARD_BOUNDARY_CHANGE_DELAY_SEC * deterministicRandom()->random01() + 60);
															#line 1340 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6908 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont6Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1cont6loopBody1loopBody1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ShardTrackerActor*>(this)->actor_wait_state = 5;
															#line 1340 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 4, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 6913 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont6loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont6Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1cont6Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state > 0) static_cast<ShardTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardTrackerActor*>(this)->ActorCallback< ShardTrackerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ShardTrackerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 1349 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(0, TaskPriority::DataDistribution);
															#line 1349 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7024 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont6Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<ShardTrackerActor*>(this)->actor_wait_state = 7;
															#line 1349 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 6, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 7029 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 1349 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(0, TaskPriority::DataDistribution);
															#line 1349 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state < 0) return a_body1cont6Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7040 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont6Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont2when1(__when_expr_6.get(), loopDepth); };
		static_cast<ShardTrackerActor*>(this)->actor_wait_state = 7;
															#line 1349 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ShardTrackerActor, 6, Void >*>(static_cast<ShardTrackerActor*>(this)));
															#line 7045 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state > 0) static_cast<ShardTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardTrackerActor*>(this)->ActorCallback< ShardTrackerActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ShardTrackerActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont6loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ShardTrackerActor*>(this)->actor_wait_state > 0) static_cast<ShardTrackerActor*>(this)->actor_wait_state = 0;
		static_cast<ShardTrackerActor*>(this)->ActorCallback< ShardTrackerActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ShardTrackerActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ShardTrackerActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont6Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont6Catch1(error, 0);
		} catch (...) {
			a_body1cont6Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 1309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker::SafeAccessor self;
															#line 1309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 1309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<ShardMetrics>>> shardSize;
															#line 1324 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<HasBeenTrueFor> wantsToMerge;
															#line 7220 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via shardTracker()
															#line 1309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class ShardTrackerActor final : public Actor<Void>, public ActorCallback< ShardTrackerActor, 0, Void >, public ActorCallback< ShardTrackerActor, 1, Void >, public ActorCallback< ShardTrackerActor, 2, Void >, public ActorCallback< ShardTrackerActor, 3, Void >, public ActorCallback< ShardTrackerActor, 4, Void >, public ActorCallback< ShardTrackerActor, 5, Void >, public ActorCallback< ShardTrackerActor, 6, Void >, public FastAllocated<ShardTrackerActor>, public ShardTrackerActorState<ShardTrackerActor> {
															#line 7225 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<ShardTrackerActor>::operator new;
	using FastAllocated<ShardTrackerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13444693061471823104UL, 6143579231050648064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ShardTrackerActor, 0, Void >;
friend struct ActorCallback< ShardTrackerActor, 1, Void >;
friend struct ActorCallback< ShardTrackerActor, 2, Void >;
friend struct ActorCallback< ShardTrackerActor, 3, Void >;
friend struct ActorCallback< ShardTrackerActor, 4, Void >;
friend struct ActorCallback< ShardTrackerActor, 5, Void >;
friend struct ActorCallback< ShardTrackerActor, 6, Void >;
															#line 1309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardTrackerActor(DataDistributionTracker::SafeAccessor const& self,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize) 
															#line 7248 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   ShardTrackerActorState<ShardTrackerActor>(self, keys, shardSize),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("shardTracker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7249602009175214080UL, 15683107163027600384UL);
		ActorExecutionContextHelper __helper(static_cast<ShardTrackerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("shardTracker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("shardTracker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ShardTrackerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ShardTrackerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ShardTrackerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ShardTrackerActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ShardTrackerActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ShardTrackerActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< ShardTrackerActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> shardTracker( DataDistributionTracker::SafeAccessor const& self, KeyRange const& keys, Reference<AsyncVar<Optional<ShardMetrics>>> const& shardSize ) {
															#line 1309 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new ShardTrackerActor(self, keys, shardSize));
															#line 7287 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 1358 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

void restartShardTrackers(DataDistributionTracker* self,
                          KeyRangeRef keys,
                          Optional<ShardMetrics> startingMetrics,
                          bool whenDDInit) {
	auto ranges = self->shards->getAffectedRangesAfterInsertion(keys, ShardTrackedData());
	for (int i = 0; i < ranges.size(); i++) {
		if (!ranges[i].value.trackShard.isValid() && ranges[i].begin != keys.begin) {
			// When starting, key space will be full of "dummy" default constructed entries.
			// This should happen when called from trackInitialShards()
			ASSERT(!self->readyToStart.isSet());
			continue;
		}

		auto shardMetrics = makeReference<AsyncVar<Optional<ShardMetrics>>>();

		// For the case where the new tracker will take over at the boundaries of current shard(s)
		//  we can use the old size if it is available. This will be the case when merging shards.
		if (startingMetrics.present()) {
			ASSERT(ranges.size() == 1);
			/*TraceEvent("ShardTrackerSizePreset", self->distributorId)
			    .detail("Keys", keys)
			    .detail("Size", startingMetrics.get().metrics.bytes)
			    .detail("Merges", startingMetrics.get().merges);*/
			CODE_PROBE(true, "shardTracker started with trackedBytes already set");
			shardMetrics->set(startingMetrics);
		}

		ShardTrackedData data;
		data.stats = shardMetrics;
		data.trackShard = shardTracker(DataDistributionTracker::SafeAccessor(self), ranges[i], shardMetrics);
		data.trackBytes =
		    trackShardMetrics(DataDistributionTracker::SafeAccessor(self), ranges[i], shardMetrics, whenDDInit);
		if (SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA && SERVER_KNOBS->DD_SHARD_USABLE_REGION_CHECK_RATE > 0 &&
		    self->usableRegions != -1) {
			data.trackUsableRegion = shardUsableRegions(DataDistributionTracker::SafeAccessor(self), ranges[i]);
		}
		self->shards->insert(ranges[i], data);
	}
}

															#line 7332 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via trackInitialShards()
															#line 1399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class TrackInitialShardsActor>
															#line 1399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TrackInitialShardsActorState {
															#line 7339 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 1399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TrackInitialShardsActorState(DataDistributionTracker* const& self,Reference<InitialDataDistribution> const& initData) 
															#line 1399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   initData(initData)
															#line 7348 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("trackInitialShards", reinterpret_cast<unsigned long>(this));

	}
	~TrackInitialShardsActorState() 
	{
		fdb_probe_actor_destroy("trackInitialShards", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1400 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			TraceEvent("TrackInitialShards", self->distributorId).detail("InitialShardCount", initData->shards.size());
															#line 1404 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0.0, TaskPriority::DataDistribution);
															#line 1404 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<TrackInitialShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7367 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TrackInitialShardsActor*>(this)->actor_wait_state = 1;
															#line 1404 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackInitialShardsActor, 0, Void >*>(static_cast<TrackInitialShardsActor*>(this)));
															#line 7372 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackInitialShardsActorState();
		static_cast<TrackInitialShardsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1406 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		customBoundaries = std::vector<Key>();
															#line 1407 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( auto it : self->userRangeConfig->ranges() ) {
															#line 1408 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			customBoundaries.push_back(it->range().begin);
															#line 7399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 1411 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		s = int();
															#line 1412 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		customBoundary = 0;
															#line 1413 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		s = 0;
															#line 7407 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1406 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		customBoundaries = std::vector<Key>();
															#line 1407 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( auto it : self->userRangeConfig->ranges() ) {
															#line 1408 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			customBoundaries.push_back(it->range().begin);
															#line 7420 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 1411 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		s = int();
															#line 1412 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		customBoundary = 0;
															#line 1413 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		s = 0;
															#line 7428 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackInitialShardsActor*>(this)->actor_wait_state > 0) static_cast<TrackInitialShardsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackInitialShardsActor*>(this)->ActorCallback< TrackInitialShardsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackInitialShardsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackInitialShardsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackInitialShardsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1429 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		Future<Void> initialSize = changeSizes(self, KeyRangeRef(allKeys.begin, allKeys.end), 0, "ShardInit");
															#line 1430 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->readyToStart.send(Void());
															#line 1431 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = initialSize;
															#line 1431 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<TrackInitialShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7518 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<TrackInitialShardsActor*>(this)->actor_wait_state = 3;
															#line 1431 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< TrackInitialShardsActor, 2, Void >*>(static_cast<TrackInitialShardsActor*>(this)));
															#line 7523 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1413 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!(s < initData->shards.size() - 1))
															#line 7539 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1414 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		Key beginKey = initData->shards[s].key;
															#line 1415 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		Key endKey = initData->shards[s + 1].key;
															#line 1416 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for(;customBoundary < customBoundaries.size() && customBoundaries[customBoundary] <= beginKey;) {
															#line 1417 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			customBoundary++;
															#line 7551 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 1419 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for(;customBoundary < customBoundaries.size() && customBoundaries[customBoundary] < endKey;) {
															#line 1420 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			restartShardTrackers( self, KeyRangeRef(beginKey, customBoundaries[customBoundary]), Optional<ShardMetrics>(), true);
															#line 1422 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			beginKey = customBoundaries[customBoundary];
															#line 1423 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			customBoundary++;
															#line 7561 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 1425 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		restartShardTrackers(self, KeyRangeRef(beginKey, endKey), Optional<ShardMetrics>(), true);
															#line 1426 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = yield(TaskPriority::DataDistribution);
															#line 1426 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<TrackInitialShardsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7569 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackInitialShardsActor*>(this)->actor_wait_state = 2;
															#line 1426 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackInitialShardsActor, 1, Void >*>(static_cast<TrackInitialShardsActor*>(this)));
															#line 7574 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1413 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		s++;
															#line 7596 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1413 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		s++;
															#line 7605 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TrackInitialShardsActor*>(this)->actor_wait_state > 0) static_cast<TrackInitialShardsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackInitialShardsActor*>(this)->ActorCallback< TrackInitialShardsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackInitialShardsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TrackInitialShardsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TrackInitialShardsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 1432 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->maxShardSizeUpdater = updateMaxShardSize(self->dbSizeEstimate, self->maxShardSize);
															#line 1434 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<TrackInitialShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TrackInitialShardsActorState(); static_cast<TrackInitialShardsActor*>(this)->destroy(); return 0; }
															#line 7691 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<TrackInitialShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TrackInitialShardsActorState();
		static_cast<TrackInitialShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 1432 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->maxShardSizeUpdater = updateMaxShardSize(self->dbSizeEstimate, self->maxShardSize);
															#line 1434 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<TrackInitialShardsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TrackInitialShardsActorState(); static_cast<TrackInitialShardsActor*>(this)->destroy(); return 0; }
															#line 7705 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<TrackInitialShardsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TrackInitialShardsActorState();
		static_cast<TrackInitialShardsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<TrackInitialShardsActor*>(this)->actor_wait_state > 0) static_cast<TrackInitialShardsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackInitialShardsActor*>(this)->ActorCallback< TrackInitialShardsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackInitialShardsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< TrackInitialShardsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< TrackInitialShardsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 1399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<InitialDataDistribution> initData;
															#line 1406 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	std::vector<Key> customBoundaries;
															#line 1411 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int s;
															#line 1412 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int customBoundary;
															#line 7798 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via trackInitialShards()
															#line 1399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TrackInitialShardsActor final : public Actor<Void>, public ActorCallback< TrackInitialShardsActor, 0, Void >, public ActorCallback< TrackInitialShardsActor, 1, Void >, public ActorCallback< TrackInitialShardsActor, 2, Void >, public FastAllocated<TrackInitialShardsActor>, public TrackInitialShardsActorState<TrackInitialShardsActor> {
															#line 7803 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<TrackInitialShardsActor>::operator new;
	using FastAllocated<TrackInitialShardsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13376328164168068608UL, 27994591538033920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackInitialShardsActor, 0, Void >;
friend struct ActorCallback< TrackInitialShardsActor, 1, Void >;
friend struct ActorCallback< TrackInitialShardsActor, 2, Void >;
															#line 1399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TrackInitialShardsActor(DataDistributionTracker* const& self,Reference<InitialDataDistribution> const& initData) 
															#line 7822 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   TrackInitialShardsActorState<TrackInitialShardsActor>(self, initData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackInitialShards", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9397468799121883904UL, 15036047991511515904UL);
		ActorExecutionContextHelper __helper(static_cast<TrackInitialShardsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackInitialShards");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackInitialShards", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackInitialShardsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TrackInitialShardsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< TrackInitialShardsActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> trackInitialShards( DataDistributionTracker* const& self, Reference<InitialDataDistribution> const& initData ) {
															#line 1399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new TrackInitialShardsActor(self, initData));
															#line 7857 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 1436 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 7862 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via fetchTopKShardMetrics_impl()
															#line 1437 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FetchTopKShardMetrics_implActor>
															#line 1437 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchTopKShardMetrics_implActorState {
															#line 7869 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 1437 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchTopKShardMetrics_implActorState(DataDistributionTracker* const& self,GetTopKMetricsRequest const& req) 
															#line 1437 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1437 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1437 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(req),
															#line 1438 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   onChange(),
															#line 1439 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   returnMetrics()
															#line 7882 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this));

	}
	~FetchTopKShardMetrics_implActorState() 
	{
		fdb_probe_actor_destroy("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1441 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (req.keys.size() > SERVER_KNOBS->DD_SHARD_COMPARE_LIMIT)
															#line 7897 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1442 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				deterministicRandom()->randomShuffle(req.keys, 0, SERVER_KNOBS->DD_SHARD_COMPARE_LIMIT);
															#line 7901 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
			try {
															#line 1445 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				;
															#line 7906 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchTopKShardMetrics_implActorState();
		static_cast<FetchTopKShardMetrics_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1499 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_actor_cancelled && !req.reply.isSet())
															#line 7936 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1500 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				req.reply.sendError(e);
															#line 7940 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 1501 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 7944 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1446 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		onChange = Future<Void>();
															#line 1447 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		returnMetrics.clear();
															#line 1448 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		minReadLoad = -1;
															#line 1449 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		maxReadLoad = -1;
															#line 1450 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		i = int();
															#line 1451 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		i = 0;
															#line 7975 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 1480 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!onChange.isValid())
															#line 7984 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 1481 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (req.getTopK() >= returnMetrics.size())
															#line 7988 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1482 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				req.reply.send(GetTopKMetricsReply(returnMetrics, minReadLoad, maxReadLoad));
															#line 7992 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
			else
			{
															#line 1484 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				std::nth_element(returnMetrics.begin(), returnMetrics.begin() + req.getTopK() - 1, returnMetrics.end(), GetTopKMetricsRequest::compare);
															#line 1488 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				req.reply.send( GetTopKMetricsReply(std::vector<GetTopKMetricsReply::KeyRangeStorageMetrics>( returnMetrics.begin(), returnMetrics.begin() + req.getTopK()), minReadLoad, maxReadLoad));
															#line 8000 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 1494 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!static_cast<FetchTopKShardMetrics_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchTopKShardMetrics_implActorState(); static_cast<FetchTopKShardMetrics_implActor*>(this)->destroy(); return 0; }
															#line 8004 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			new (&static_cast<FetchTopKShardMetrics_implActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FetchTopKShardMetrics_implActorState();
			static_cast<FetchTopKShardMetrics_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1496 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_1 = onChange;
															#line 1496 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8014 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state = 2;
															#line 1496 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >*>(static_cast<FetchTopKShardMetrics_implActor*>(this)));
															#line 8019 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 1451 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!(i < SERVER_KNOBS->DD_SHARD_COMPARE_LIMIT && i < req.keys.size()))
															#line 8035 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1452 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto range = req.keys[i];
															#line 1453 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StorageMetrics metrics;
															#line 1454 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( auto t : self->shards->intersectingRanges(range) ) {
															#line 1455 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			auto& stats = t.value().stats;
															#line 1456 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!stats->get().present())
															#line 8049 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1457 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				onChange = stats->onChange();
															#line 8053 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				break;
			}
															#line 1460 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			metrics += t.value().stats->get().get().metrics;
															#line 8058 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 1464 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (onChange.isValid())
															#line 8062 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1468 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto readLoad = metrics.readLoadKSecond();
															#line 1469 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (readLoad > 0)
															#line 8070 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 1470 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			minReadLoad = std::min(readLoad, minReadLoad);
															#line 1471 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			maxReadLoad = std::max(readLoad, maxReadLoad);
															#line 1472 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (req.minReadLoadPerKSecond <= readLoad && readLoad <= req.maxReadLoadPerKSecond)
															#line 8078 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1473 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				returnMetrics.emplace_back(range, metrics);
															#line 8082 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
		}
															#line 1477 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = yield();
															#line 1477 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 8089 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state = 1;
															#line 1477 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >*>(static_cast<FetchTopKShardMetrics_implActor*>(this)));
															#line 8094 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1451 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		++i;
															#line 8116 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1451 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		++i;
															#line 8125 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state > 0) static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state = 0;
		static_cast<FetchTopKShardMetrics_implActor*>(this)->ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state > 0) static_cast<FetchTopKShardMetrics_implActor*>(this)->actor_wait_state = 0;
		static_cast<FetchTopKShardMetrics_implActor*>(this)->ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1437 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1437 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetTopKMetricsRequest req;
															#line 1438 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Future<Void> onChange;
															#line 1439 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	std::vector<GetTopKMetricsReply::KeyRangeStorageMetrics> returnMetrics;
															#line 1448 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int64_t minReadLoad;
															#line 1449 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int64_t maxReadLoad;
															#line 1450 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int i;
															#line 8306 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via fetchTopKShardMetrics_impl()
															#line 1437 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchTopKShardMetrics_implActor final : public Actor<Void>, public ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >, public ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >, public FastAllocated<FetchTopKShardMetrics_implActor>, public FetchTopKShardMetrics_implActorState<FetchTopKShardMetrics_implActor> {
															#line 8311 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<FetchTopKShardMetrics_implActor>::operator new;
	using FastAllocated<FetchTopKShardMetrics_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(37199523164965376UL, 9209099873003418368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >;
friend struct ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >;
															#line 1437 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchTopKShardMetrics_implActor(DataDistributionTracker* const& self,GetTopKMetricsRequest const& req) 
															#line 8329 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   FetchTopKShardMetrics_implActorState<FetchTopKShardMetrics_implActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16335621257324376576UL, 17612975492946055168UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchTopKShardMetrics_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchTopKShardMetrics_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchTopKShardMetrics_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FetchTopKShardMetrics_implActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1437 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> fetchTopKShardMetrics_impl( DataDistributionTracker* const& self, GetTopKMetricsRequest const& req ) {
															#line 1437 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FetchTopKShardMetrics_implActor(self, req));
															#line 8363 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 1504 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 8368 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via fetchTopKShardMetrics()
															#line 1505 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FetchTopKShardMetricsActor>
															#line 1505 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchTopKShardMetricsActorState {
															#line 8375 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 1505 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchTopKShardMetricsActorState(DataDistributionTracker* const& self,GetTopKMetricsRequest const& req) 
															#line 1505 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1505 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1505 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(req)
															#line 8384 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	~FetchTopKShardMetricsActorState() 
	{
		fdb_probe_actor_destroy("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1508 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = g_network->isSimulated() && BUGGIFY_WITH_PROB(0.01) ? Never() : fetchTopKShardMetrics_impl(self, req);
															#line 1506 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FetchTopKShardMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8401 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1510 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->DD_SHARD_METRICS_TIMEOUT);
															#line 8405 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<FetchTopKShardMetricsActor*>(this)->actor_wait_state = 1;
															#line 1508 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchTopKShardMetricsActor, 0, Void >*>(static_cast<FetchTopKShardMetricsActor*>(this)));
															#line 1510 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchTopKShardMetricsActor, 1, Void >*>(static_cast<FetchTopKShardMetricsActor*>(this)));
															#line 8412 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchTopKShardMetricsActorState();
		static_cast<FetchTopKShardMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1515 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FetchTopKShardMetricsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchTopKShardMetricsActorState(); static_cast<FetchTopKShardMetricsActor*>(this)->destroy(); return 0; }
															#line 8435 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FetchTopKShardMetricsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FetchTopKShardMetricsActorState();
		static_cast<FetchTopKShardMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 1511 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		CODE_PROBE(true, "TopK DD_SHARD_METRICS_TIMEOUT");
															#line 1512 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.reply.send(GetTopKMetricsReply());
															#line 8461 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 1511 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		CODE_PROBE(true, "TopK DD_SHARD_METRICS_TIMEOUT");
															#line 1512 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.reply.send(GetTopKMetricsReply());
															#line 8472 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchTopKShardMetricsActor*>(this)->actor_wait_state > 0) static_cast<FetchTopKShardMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<FetchTopKShardMetricsActor*>(this)->ActorCallback< FetchTopKShardMetricsActor, 0, Void >::remove();
		static_cast<FetchTopKShardMetricsActor*>(this)->ActorCallback< FetchTopKShardMetricsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchTopKShardMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetricsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchTopKShardMetricsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchTopKShardMetricsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1505 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1505 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetTopKMetricsRequest req;
															#line 8602 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via fetchTopKShardMetrics()
															#line 1505 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchTopKShardMetricsActor final : public Actor<Void>, public ActorCallback< FetchTopKShardMetricsActor, 0, Void >, public ActorCallback< FetchTopKShardMetricsActor, 1, Void >, public FastAllocated<FetchTopKShardMetricsActor>, public FetchTopKShardMetricsActorState<FetchTopKShardMetricsActor> {
															#line 8607 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<FetchTopKShardMetricsActor>::operator new;
	using FastAllocated<FetchTopKShardMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16411994469909990144UL, 14534012085562846720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchTopKShardMetricsActor, 0, Void >;
friend struct ActorCallback< FetchTopKShardMetricsActor, 1, Void >;
															#line 1505 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchTopKShardMetricsActor(DataDistributionTracker* const& self,GetTopKMetricsRequest const& req) 
															#line 8625 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   FetchTopKShardMetricsActorState<FetchTopKShardMetricsActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(562825965935643136UL, 6235542981586304000UL);
		ActorExecutionContextHelper __helper(static_cast<FetchTopKShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchTopKShardMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchTopKShardMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchTopKShardMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1505 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> fetchTopKShardMetrics( DataDistributionTracker* const& self, GetTopKMetricsRequest const& req ) {
															#line 1505 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FetchTopKShardMetricsActor(self, req));
															#line 8658 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 1517 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 8663 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via fetchShardMetrics_impl()
															#line 1518 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FetchShardMetrics_implActor>
															#line 1518 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetrics_implActorState {
															#line 8670 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 1518 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetrics_implActorState(DataDistributionTracker* const& self,GetMetricsRequest const& req) 
															#line 1518 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1518 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1518 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(req)
															#line 8679 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this));

	}
	~FetchShardMetrics_implActorState() 
	{
		fdb_probe_actor_destroy("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1520 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				;
															#line 8695 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchShardMetrics_implActorState();
		static_cast<FetchShardMetrics_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1540 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_actor_cancelled && !req.reply.isSet())
															#line 8725 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1541 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				req.reply.sendError(e);
															#line 8729 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 1542 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 8733 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1521 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		Future<Void> onChange;
															#line 1522 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StorageMetrics returnMetrics;
															#line 1523 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for( auto t : self->shards->intersectingRanges(req.keys) ) {
															#line 1524 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			auto& stats = t.value().stats;
															#line 1525 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!stats->get().present())
															#line 8762 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1526 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				onChange = stats->onChange();
															#line 8766 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				break;
			}
															#line 1529 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			returnMetrics += t.value().stats->get().get().metrics;
															#line 8771 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 1532 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!onChange.isValid())
															#line 8775 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 1533 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			req.reply.send(returnMetrics);
															#line 1534 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!static_cast<FetchShardMetrics_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchShardMetrics_implActorState(); static_cast<FetchShardMetrics_implActor*>(this)->destroy(); return 0; }
															#line 8781 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			new (&static_cast<FetchShardMetrics_implActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FetchShardMetrics_implActorState();
			static_cast<FetchShardMetrics_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1537 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = onChange;
															#line 1537 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<FetchShardMetrics_implActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8791 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FetchShardMetrics_implActor*>(this)->actor_wait_state = 1;
															#line 1537 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchShardMetrics_implActor, 0, Void >*>(static_cast<FetchShardMetrics_implActor*>(this)));
															#line 8796 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchShardMetrics_implActor*>(this)->actor_wait_state > 0) static_cast<FetchShardMetrics_implActor*>(this)->actor_wait_state = 0;
		static_cast<FetchShardMetrics_implActor*>(this)->ActorCallback< FetchShardMetrics_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchShardMetrics_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchShardMetrics_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchShardMetrics_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1518 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1518 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetMetricsRequest req;
															#line 8892 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via fetchShardMetrics_impl()
															#line 1518 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetrics_implActor final : public Actor<Void>, public ActorCallback< FetchShardMetrics_implActor, 0, Void >, public FastAllocated<FetchShardMetrics_implActor>, public FetchShardMetrics_implActorState<FetchShardMetrics_implActor> {
															#line 8897 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<FetchShardMetrics_implActor>::operator new;
	using FastAllocated<FetchShardMetrics_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12412652384081739776UL, 15827608886537576448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchShardMetrics_implActor, 0, Void >;
															#line 1518 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetrics_implActor(DataDistributionTracker* const& self,GetMetricsRequest const& req) 
															#line 8914 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   FetchShardMetrics_implActorState<FetchShardMetrics_implActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8157094183056292352UL, 15731389018228572672UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetrics_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchShardMetrics_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchShardMetrics_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchShardMetrics_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1518 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> fetchShardMetrics_impl( DataDistributionTracker* const& self, GetMetricsRequest const& req ) {
															#line 1518 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FetchShardMetrics_implActor(self, req));
															#line 8947 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 1545 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 8952 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via fetchShardMetrics()
															#line 1546 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FetchShardMetricsActor>
															#line 1546 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetricsActorState {
															#line 8959 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 1546 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetricsActorState(DataDistributionTracker* const& self,GetMetricsRequest const& req) 
															#line 1546 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1546 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1546 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(req)
															#line 8968 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	~FetchShardMetricsActorState() 
	{
		fdb_probe_actor_destroy("fetchShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1548 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = fetchShardMetrics_impl(self, req);
															#line 1547 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FetchShardMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8985 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1549 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->DD_SHARD_METRICS_TIMEOUT, TaskPriority::DataDistribution);
															#line 8989 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<FetchShardMetricsActor*>(this)->actor_wait_state = 1;
															#line 1548 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchShardMetricsActor, 0, Void >*>(static_cast<FetchShardMetricsActor*>(this)));
															#line 1549 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchShardMetricsActor, 1, Void >*>(static_cast<FetchShardMetricsActor*>(this)));
															#line 8996 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchShardMetricsActorState();
		static_cast<FetchShardMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1556 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FetchShardMetricsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchShardMetricsActorState(); static_cast<FetchShardMetricsActor*>(this)->destroy(); return 0; }
															#line 9019 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FetchShardMetricsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FetchShardMetricsActorState();
		static_cast<FetchShardMetricsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 1550 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		CODE_PROBE(true, "DD_SHARD_METRICS_TIMEOUT");
															#line 1551 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StorageMetrics largeMetrics;
															#line 1552 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		largeMetrics.bytes = getMaxShardSize(self->dbSizeEstimate->get());
															#line 1553 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.reply.send(largeMetrics);
															#line 9049 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 1550 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		CODE_PROBE(true, "DD_SHARD_METRICS_TIMEOUT");
															#line 1551 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StorageMetrics largeMetrics;
															#line 1552 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		largeMetrics.bytes = getMaxShardSize(self->dbSizeEstimate->get());
															#line 1553 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.reply.send(largeMetrics);
															#line 9064 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchShardMetricsActor*>(this)->actor_wait_state > 0) static_cast<FetchShardMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<FetchShardMetricsActor*>(this)->ActorCallback< FetchShardMetricsActor, 0, Void >::remove();
		static_cast<FetchShardMetricsActor*>(this)->ActorCallback< FetchShardMetricsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchShardMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchShardMetricsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1546 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1546 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetMetricsRequest req;
															#line 9194 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via fetchShardMetrics()
															#line 1546 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetricsActor final : public Actor<Void>, public ActorCallback< FetchShardMetricsActor, 0, Void >, public ActorCallback< FetchShardMetricsActor, 1, Void >, public FastAllocated<FetchShardMetricsActor>, public FetchShardMetricsActorState<FetchShardMetricsActor> {
															#line 9199 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<FetchShardMetricsActor>::operator new;
	using FastAllocated<FetchShardMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7839698675888045056UL, 1606765310037611008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchShardMetricsActor, 0, Void >;
friend struct ActorCallback< FetchShardMetricsActor, 1, Void >;
															#line 1546 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetricsActor(DataDistributionTracker* const& self,GetMetricsRequest const& req) 
															#line 9217 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   FetchShardMetricsActorState<FetchShardMetricsActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchShardMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4595584884492349440UL, 13042209588914682880UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchShardMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchShardMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchShardMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1546 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> fetchShardMetrics( DataDistributionTracker* const& self, GetMetricsRequest const& req ) {
															#line 1546 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FetchShardMetricsActor(self, req));
															#line 9250 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 1558 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 9255 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via fetchShardMetricsList_impl()
															#line 1559 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FetchShardMetricsList_implActor>
															#line 1559 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetricsList_implActorState {
															#line 9262 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 1559 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetricsList_implActorState(DataDistributionTracker* const& self,GetMetricsListRequest const& req) 
															#line 1559 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1559 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1559 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(req)
															#line 9271 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this));

	}
	~FetchShardMetricsList_implActorState() 
	{
		fdb_probe_actor_destroy("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1561 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				;
															#line 9287 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchShardMetricsList_implActorState();
		static_cast<FetchShardMetricsList_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1593 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_actor_cancelled && !req.reply.isSet())
															#line 9317 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1594 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				req.reply.sendError(e);
															#line 9321 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 1595 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 9325 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1563 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		int shardNum = 0;
															#line 1565 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		Standalone<VectorRef<DDMetricsRef>> result;
															#line 1566 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		Future<Void> onChange;
															#line 1567 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto beginIter = self->shards->containedRanges(req.keys).begin();
															#line 1568 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto endIter = self->shards->intersectingRanges(req.keys).end();
															#line 1569 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		for(auto t = beginIter;t != endIter;++t) {
															#line 1570 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			auto& stats = t.value().stats;
															#line 1571 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!stats->get().present())
															#line 9360 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1572 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				onChange = stats->onChange();
															#line 9364 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				break;
			}
															#line 1575 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			result.push_back_deep(result.arena(), DDMetricsRef(stats->get().get().metrics.bytes, stats->get().get().metrics.bytesWrittenPerKSecond, KeyRef(t.begin().toString())));
															#line 1579 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			++shardNum;
															#line 1580 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shardNum >= req.shardLimit)
															#line 9373 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
				break;
			}
		}
															#line 1585 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!onChange.isValid())
															#line 9380 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 1586 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			req.reply.send(result);
															#line 1587 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!static_cast<FetchShardMetricsList_implActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchShardMetricsList_implActorState(); static_cast<FetchShardMetricsList_implActor*>(this)->destroy(); return 0; }
															#line 9386 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			new (&static_cast<FetchShardMetricsList_implActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FetchShardMetricsList_implActorState();
			static_cast<FetchShardMetricsList_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1590 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_0 = onChange;
															#line 1590 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<FetchShardMetricsList_implActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9396 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FetchShardMetricsList_implActor*>(this)->actor_wait_state = 1;
															#line 1590 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchShardMetricsList_implActor, 0, Void >*>(static_cast<FetchShardMetricsList_implActor*>(this)));
															#line 9401 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchShardMetricsList_implActor*>(this)->actor_wait_state > 0) static_cast<FetchShardMetricsList_implActor*>(this)->actor_wait_state = 0;
		static_cast<FetchShardMetricsList_implActor*>(this)->ActorCallback< FetchShardMetricsList_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsList_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsList_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsList_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsList_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchShardMetricsList_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsList_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1559 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1559 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetMetricsListRequest req;
															#line 9497 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via fetchShardMetricsList_impl()
															#line 1559 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetricsList_implActor final : public Actor<Void>, public ActorCallback< FetchShardMetricsList_implActor, 0, Void >, public FastAllocated<FetchShardMetricsList_implActor>, public FetchShardMetricsList_implActorState<FetchShardMetricsList_implActor> {
															#line 9502 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<FetchShardMetricsList_implActor>::operator new;
	using FastAllocated<FetchShardMetricsList_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3564635853511734016UL, 12043630458354322688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchShardMetricsList_implActor, 0, Void >;
															#line 1559 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetricsList_implActor(DataDistributionTracker* const& self,GetMetricsListRequest const& req) 
															#line 9519 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   FetchShardMetricsList_implActorState<FetchShardMetricsList_implActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14407635174814048256UL, 1377555907217671936UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsList_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchShardMetricsList_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchShardMetricsList_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchShardMetricsList_implActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1559 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> fetchShardMetricsList_impl( DataDistributionTracker* const& self, GetMetricsListRequest const& req ) {
															#line 1559 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FetchShardMetricsList_implActor(self, req));
															#line 9552 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 1598 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

															#line 9557 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via fetchShardMetricsList()
															#line 1599 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FetchShardMetricsListActor>
															#line 1599 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetricsListActorState {
															#line 9564 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 1599 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetricsListActorState(DataDistributionTracker* const& self,GetMetricsListRequest const& req) 
															#line 1599 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1599 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1599 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(req)
															#line 9573 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("fetchShardMetricsList", reinterpret_cast<unsigned long>(this));

	}
	~FetchShardMetricsListActorState() 
	{
		fdb_probe_actor_destroy("fetchShardMetricsList", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1601 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = fetchShardMetricsList_impl(self, req);
															#line 1600 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FetchShardMetricsListActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9590 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1602 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(SERVER_KNOBS->DD_SHARD_METRICS_TIMEOUT);
															#line 9594 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
			static_cast<FetchShardMetricsListActor*>(this)->actor_wait_state = 1;
															#line 1601 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FetchShardMetricsListActor, 0, Void >*>(static_cast<FetchShardMetricsListActor*>(this)));
															#line 1602 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FetchShardMetricsListActor, 1, Void >*>(static_cast<FetchShardMetricsListActor*>(this)));
															#line 9601 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FetchShardMetricsListActorState();
		static_cast<FetchShardMetricsListActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1606 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FetchShardMetricsListActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FetchShardMetricsListActorState(); static_cast<FetchShardMetricsListActor*>(this)->destroy(); return 0; }
															#line 9624 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FetchShardMetricsListActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FetchShardMetricsListActorState();
		static_cast<FetchShardMetricsListActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
															#line 1603 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.reply.sendError(timed_out());
															#line 9648 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
															#line 1603 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.reply.sendError(timed_out());
															#line 9657 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FetchShardMetricsListActor*>(this)->actor_wait_state > 0) static_cast<FetchShardMetricsListActor*>(this)->actor_wait_state = 0;
		static_cast<FetchShardMetricsListActor*>(this)->ActorCallback< FetchShardMetricsListActor, 0, Void >::remove();
		static_cast<FetchShardMetricsListActor*>(this)->ActorCallback< FetchShardMetricsListActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsListActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsListActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FetchShardMetricsListActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsListActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FetchShardMetricsListActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FetchShardMetricsListActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1599 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1599 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetMetricsListRequest req;
															#line 9787 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via fetchShardMetricsList()
															#line 1599 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FetchShardMetricsListActor final : public Actor<Void>, public ActorCallback< FetchShardMetricsListActor, 0, Void >, public ActorCallback< FetchShardMetricsListActor, 1, Void >, public FastAllocated<FetchShardMetricsListActor>, public FetchShardMetricsListActorState<FetchShardMetricsListActor> {
															#line 9792 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<FetchShardMetricsListActor>::operator new;
	using FastAllocated<FetchShardMetricsListActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11935933154231102976UL, 4390940552570194944UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FetchShardMetricsListActor, 0, Void >;
friend struct ActorCallback< FetchShardMetricsListActor, 1, Void >;
															#line 1599 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FetchShardMetricsListActor(DataDistributionTracker* const& self,GetMetricsListRequest const& req) 
															#line 9810 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   FetchShardMetricsListActorState<FetchShardMetricsListActor>(self, req),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1877805589017634560UL, 1177625241290689280UL);
		ActorExecutionContextHelper __helper(static_cast<FetchShardMetricsListActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("fetchShardMetricsList");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("fetchShardMetricsList", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FetchShardMetricsListActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1599 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> fetchShardMetricsList( DataDistributionTracker* const& self, GetMetricsListRequest const& req ) {
															#line 1599 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FetchShardMetricsListActor(self, req));
															#line 9843 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 1608 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

void triggerStorageQueueRebalance(DataDistributionTracker* self, RebalanceStorageQueueRequest req) {
	TraceEvent e("TriggerDataMoveStorageQueueRebalance", self->distributorId);
	e.detail("Server", req.serverId);
	e.detail("Teams", req.teams.size());
	int64_t maxShardWriteTraffic = 0;
	KeyRange shardToMove;
	ShardsAffectedByTeamFailure::Team selectedTeam;
	for (const auto& team : req.teams) {
		for (auto const& shard : self->shardsAffectedByTeamFailure->getShardsFor(team)) {
			for (auto it : self->shards->intersectingRanges(shard)) {
				if (it->value().stats->get().present()) {
					int64_t shardWriteTraffic = it->value().stats->get().get().metrics.bytesWrittenPerKSecond;
					if (shardWriteTraffic > maxShardWriteTraffic &&
					    (SERVER_KNOBS->DD_ENABLE_REBALANCE_STORAGE_QUEUE_WITH_LIGHT_WRITE_SHARD ||
					     shardWriteTraffic > SERVER_KNOBS->REBALANCE_STORAGE_QUEUE_SHARD_PER_KSEC_MIN)) {
						shardToMove = it->range();
						maxShardWriteTraffic = shardWriteTraffic;
					}
				}
			}
		}
	}
	if (!shardToMove.empty()) {
		e.detail("TeamSelected", selectedTeam.servers);
		e.detail("ShardSelected", shardToMove);
		e.detail("ShardWriteBytesPerKSec", maxShardWriteTraffic);
		RelocateShard rs(shardToMove, DataMovementReason::REBALANCE_STORAGE_QUEUE, RelocateReason::REBALANCE_WRITE);
		self->output.send(rs);
		TraceEvent("SendRelocateToDDQueue", self->distributorId)
		    .detail("ServerPrimary", req.primary)
		    .detail("ServerTeam", selectedTeam.servers)
		    .detail("KeyBegin", rs.keys.begin)
		    .detail("KeyEnd", rs.keys.end)
		    .detail("Priority", rs.priority);
	}
	return;
}

DataDistributionTracker::DataDistributionTracker(DataDistributionTrackerInitParams const& params)
  : IDDShardTracker(), db(params.db), distributorId(params.distributorId), shards(params.shards), actors(false),
    systemSizeEstimate(0), dbSizeEstimate(new AsyncVar<int64_t>()), maxShardSize(new AsyncVar<Optional<int64_t>>()),
    output(params.output), shardsAffectedByTeamFailure(params.shardsAffectedByTeamFailure),
    physicalShardCollection(params.physicalShardCollection), bulkLoadTaskCollection(params.bulkLoadTaskCollection),
    readyToStart(params.readyToStart), anyZeroHealthyTeams(params.anyZeroHealthyTeams),
    trackerCancelled(params.trackerCancelled), ddTenantCache(params.ddTenantCache),
    usableRegions(params.usableRegions) {}

DataDistributionTracker::~DataDistributionTracker() {
	if (trackerCancelled) {
		*trackerCancelled = true;
	}
	// Cancel all actors so they aren't waiting on sizeChanged broken promise
	actors.clear(false);
}

struct DataDistributionTrackerImpl {
																#line 9904 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
// This generated class is to be used only via run()
															#line 1665 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class RunActor>
															#line 1665 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class RunActorState {
															#line 9910 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 1665 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	RunActorState(DataDistributionTracker* const& self,Reference<InitialDataDistribution> const& initData) 
															#line 1665 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1665 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : self(self),
															#line 1665 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   initData(initData),
															#line 1666 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   loggingTrigger(Void()),
															#line 1667 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   readHotDetect(readHotDetector(self)),
															#line 1668 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   ddTrackerStatsEventHolder(makeReference<EventCacheHolder>("DDTrackerStats"))
															#line 9925 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("run", reinterpret_cast<unsigned long>(this));

	}
	~RunActorState() 
	{
		fdb_probe_actor_destroy("run", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1671 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				StrictFuture<Void> __when_expr_0 = trackInitialShards(self, initData);
															#line 1671 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9943 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<RunActor*>(this)->actor_wait_state = 1;
															#line 1671 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunActor, 0, Void >*>(static_cast<RunActor*>(this)));
															#line 9948 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunActorState();
		static_cast<RunActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1717 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (e.code() != error_code_broken_promise)
															#line 9978 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1718 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				TraceEvent(SevError, "DataDistributionTrackerError", self->distributorId) .error(e);
															#line 9982 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
			else
			{
															#line 1721 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				TraceEvent(SevWarn, "DataDistributionTrackerError", self->distributorId).error(e);
															#line 9988 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 1723 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 9992 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1672 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		initData.clear();
															#line 1674 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		tenantCreationSignal = PromiseStream<TenantCacheTenantCreated>();
															#line 1675 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (SERVER_KNOBS->DD_TENANT_AWARENESS_ENABLED)
															#line 10010 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 1676 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			ASSERT(self->ddTenantCache.present());
															#line 1677 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			tenantCreationSignal = self->ddTenantCache.get()->tenantCreationSignal;
															#line 10016 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 1680 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		;
															#line 10020 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1672 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		initData.clear();
															#line 1674 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		tenantCreationSignal = PromiseStream<TenantCacheTenantCreated>();
															#line 1675 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (SERVER_KNOBS->DD_TENANT_AWARENESS_ENABLED)
															#line 10033 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 1676 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			ASSERT(self->ddTenantCache.present());
															#line 1677 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			tenantCreationSignal = self->ddTenantCache.get()->tenantCreationSignal;
															#line 10039 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		}
															#line 1680 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		;
															#line 10043 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 1681 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_1 = self->averageShardBytes;
															#line 10134 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_1), FutureStream<Promise<int64_t>>>::value || std::is_same<decltype(__when_expr_1), ThreadFutureStream<Promise<int64_t>>>::value, "invalid type");
															#line 1680 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<RunActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10138 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.pop(), loopDepth); };
															#line 1684 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_2 = loggingTrigger;
															#line 10142 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when2(__when_expr_2.get(), loopDepth); };
															#line 1693 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_3 = self->getShardMetrics;
															#line 10146 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<GetMetricsRequest>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<GetMetricsRequest>>::value, "invalid type");
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when3(__when_expr_3.pop(), loopDepth); };
															#line 1696 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_4 = self->getTopKMetrics;
															#line 10151 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_4), FutureStream<GetTopKMetricsRequest>>::value || std::is_same<decltype(__when_expr_4), ThreadFutureStream<GetTopKMetricsRequest>>::value, "invalid type");
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when4(__when_expr_4.pop(), loopDepth); };
															#line 1699 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_5 = self->getShardMetricsList;
															#line 10156 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_5), FutureStream<GetMetricsListRequest>>::value || std::is_same<decltype(__when_expr_5), ThreadFutureStream<GetMetricsListRequest>>::value, "invalid type");
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when5(__when_expr_5.pop(), loopDepth); };
															#line 1702 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_6 = self->triggerStorageQueueRebalance;
															#line 10161 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_6), FutureStream<RebalanceStorageQueueRequest>>::value || std::is_same<decltype(__when_expr_6), ThreadFutureStream<RebalanceStorageQueueRequest>>::value, "invalid type");
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when6(__when_expr_6.pop(), loopDepth); };
															#line 1705 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_7 = self->triggerShardBulkLoading;
															#line 10166 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_7), FutureStream<BulkLoadShardRequest>>::value || std::is_same<decltype(__when_expr_7), ThreadFutureStream<BulkLoadShardRequest>>::value, "invalid type");
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch2(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when7(__when_expr_7.pop(), loopDepth); };
															#line 1708 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<Void> __when_expr_8 = self->actors.getResult();
															#line 10171 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch2(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when8(__when_expr_8.get(), loopDepth); };
															#line 1709 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_9 = tenantCreationSignal.getFuture();
															#line 10175 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_9), FutureStream<TenantCacheTenantCreated>>::value || std::is_same<decltype(__when_expr_9), ThreadFutureStream<TenantCacheTenantCreated>>::value, "invalid type");
		if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch2(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when9(__when_expr_9.pop(), loopDepth); };
															#line 1712 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto __when_expr_10 = self->shardsAffectedByTeamFailure->restartShardTracker.getFuture();
															#line 10180 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_10), FutureStream<KeyRange>>::value || std::is_same<decltype(__when_expr_10), ThreadFutureStream<KeyRange>>::value, "invalid type");
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch2(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when10(__when_expr_10.pop(), loopDepth); };
		static_cast<RunActor*>(this)->actor_wait_state = 2;
															#line 1681 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 1, Promise<int64_t> >*>(static_cast<RunActor*>(this)));
															#line 1684 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RunActor, 2, Void >*>(static_cast<RunActor*>(this)));
															#line 1693 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 3, GetMetricsRequest >*>(static_cast<RunActor*>(this)));
															#line 1696 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 4, GetTopKMetricsRequest >*>(static_cast<RunActor*>(this)));
															#line 1699 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 5, GetMetricsListRequest >*>(static_cast<RunActor*>(this)));
															#line 1702 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 6, RebalanceStorageQueueRequest >*>(static_cast<RunActor*>(this)));
															#line 1705 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 7, BulkLoadShardRequest >*>(static_cast<RunActor*>(this)));
															#line 1708 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< RunActor, 8, Void >*>(static_cast<RunActor*>(this)));
															#line 1709 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_9.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 9, TenantCacheTenantCreated >*>(static_cast<RunActor*>(this)));
															#line 1712 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorSingleCallback< RunActor, 10, KeyRange >*>(static_cast<RunActor*>(this)));
															#line 10204 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Promise<int64_t> const& req,int loopDepth) 
	{
															#line 1682 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.send(self->getAverageShardBytes());
															#line 10219 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Promise<int64_t> && req,int loopDepth) 
	{
															#line 1682 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		req.send(self->getAverageShardBytes());
															#line 10228 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void const& _,int loopDepth) 
	{
															#line 1685 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		TraceEvent("DDTrackerStats", self->distributorId) .detail("Shards", self->shards->size()) .detail("TotalSizeBytes", self->dbSizeEstimate->get()) .detail("SystemSizeBytes", self->systemSizeEstimate) .trackLatest(ddTrackerStatsEventHolder->trackingKey);
															#line 1691 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		loggingTrigger = delay(SERVER_KNOBS->DATA_DISTRIBUTION_LOGGING_INTERVAL, TaskPriority::FlushTrace);
															#line 10239 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when2(Void && _,int loopDepth) 
	{
															#line 1685 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		TraceEvent("DDTrackerStats", self->distributorId) .detail("Shards", self->shards->size()) .detail("TotalSizeBytes", self->dbSizeEstimate->get()) .detail("SystemSizeBytes", self->systemSizeEstimate) .trackLatest(ddTrackerStatsEventHolder->trackingKey);
															#line 1691 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		loggingTrigger = delay(SERVER_KNOBS->DATA_DISTRIBUTION_LOGGING_INTERVAL, TaskPriority::FlushTrace);
															#line 10250 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when3(GetMetricsRequest const& req,int loopDepth) 
	{
															#line 1694 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->actors.add(fetchShardMetrics(self, req));
															#line 10259 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when3(GetMetricsRequest && req,int loopDepth) 
	{
															#line 1694 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->actors.add(fetchShardMetrics(self, req));
															#line 10268 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when4(GetTopKMetricsRequest const& req,int loopDepth) 
	{
															#line 1697 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->actors.add(fetchTopKShardMetrics(self, req));
															#line 10277 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when4(GetTopKMetricsRequest && req,int loopDepth) 
	{
															#line 1697 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->actors.add(fetchTopKShardMetrics(self, req));
															#line 10286 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when5(GetMetricsListRequest const& req,int loopDepth) 
	{
															#line 1700 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->actors.add(fetchShardMetricsList(self, req));
															#line 10295 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when5(GetMetricsListRequest && req,int loopDepth) 
	{
															#line 1700 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->actors.add(fetchShardMetricsList(self, req));
															#line 10304 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when6(RebalanceStorageQueueRequest const& req,int loopDepth) 
	{
															#line 1703 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		triggerStorageQueueRebalance(self, req);
															#line 10313 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when6(RebalanceStorageQueueRequest && req,int loopDepth) 
	{
															#line 1703 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		triggerStorageQueueRebalance(self, req);
															#line 10322 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when7(BulkLoadShardRequest const& req,int loopDepth) 
	{
															#line 1706 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		createShardToBulkLoad(self, req.bulkLoadTaskState, req.cancelledDataMovePriority);
															#line 10331 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when7(BulkLoadShardRequest && req,int loopDepth) 
	{
															#line 1706 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		createShardToBulkLoad(self, req.bulkLoadTaskState, req.cancelledDataMovePriority);
															#line 10340 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when9(TenantCacheTenantCreated const& newTenant,int loopDepth) 
	{
															#line 1710 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->actors.add(tenantCreationHandling(self, newTenant));
															#line 10361 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when9(TenantCacheTenantCreated && newTenant,int loopDepth) 
	{
															#line 1710 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		self->actors.add(tenantCreationHandling(self, newTenant));
															#line 10370 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when10(KeyRange const& req,int loopDepth) 
	{
															#line 1713 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		restartShardTrackers(self, req);
															#line 10379 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when10(KeyRange && req,int loopDepth) 
	{
															#line 1713 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		restartShardTrackers(self, req);
															#line 10388 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RunActor*>(this)->actor_wait_state > 0) static_cast<RunActor*>(this)->actor_wait_state = 0;
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 1, Promise<int64_t> >::remove();
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 2, Void >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 3, GetMetricsRequest >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 4, GetTopKMetricsRequest >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 5, GetMetricsListRequest >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 6, RebalanceStorageQueueRequest >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 7, BulkLoadShardRequest >::remove();
		static_cast<RunActor*>(this)->ActorCallback< RunActor, 8, Void >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 9, TenantCacheTenantCreated >::remove();
		static_cast<RunActor*>(this)->ActorSingleCallback< RunActor, 10, KeyRange >::remove();

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 1, Promise<int64_t> >*,Promise<int64_t> const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 1, Promise<int64_t> >*,Promise<int64_t> && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 1, Promise<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RunActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RunActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 3, GetMetricsRequest >*,GetMetricsRequest const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 3, GetMetricsRequest >*,GetMetricsRequest && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 3, GetMetricsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 4, GetTopKMetricsRequest >*,GetTopKMetricsRequest const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 4, GetTopKMetricsRequest >*,GetTopKMetricsRequest && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 4, GetTopKMetricsRequest >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 5, GetMetricsListRequest >*,GetMetricsListRequest const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 5, GetMetricsListRequest >*,GetMetricsListRequest && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 5, GetMetricsListRequest >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 6, RebalanceStorageQueueRequest >*,RebalanceStorageQueueRequest const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 6, RebalanceStorageQueueRequest >*,RebalanceStorageQueueRequest && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 6, RebalanceStorageQueueRequest >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 7, BulkLoadShardRequest >*,BulkLoadShardRequest const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when7(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 7, BulkLoadShardRequest >*,BulkLoadShardRequest && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when7(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 7, BulkLoadShardRequest >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< RunActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when8(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< RunActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when8(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< RunActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 9, TenantCacheTenantCreated >*,TenantCacheTenantCreated const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when9(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 9, TenantCacheTenantCreated >*,TenantCacheTenantCreated && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when9(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 9, TenantCacheTenantCreated >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 10, KeyRange >*,KeyRange const& value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when10(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorSingleCallback< RunActor, 10, KeyRange >*,KeyRange && value) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when10(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorSingleCallback< RunActor, 10, KeyRange >*,Error err) 
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), 10);

	}
															#line 1665 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker* self;
															#line 1665 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<InitialDataDistribution> initData;
															#line 1666 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Future<Void> loggingTrigger;
															#line 1667 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Future<Void> readHotDetect;
															#line 1668 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<EventCacheHolder> ddTrackerStatsEventHolder;
															#line 1674 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	PromiseStream<TenantCacheTenantCreated> tenantCreationSignal;
															#line 10990 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via run()
															#line 1665 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class RunActor final : public Actor<Void>, public ActorCallback< RunActor, 0, Void >, public ActorSingleCallback< RunActor, 1, Promise<int64_t> >, public ActorCallback< RunActor, 2, Void >, public ActorSingleCallback< RunActor, 3, GetMetricsRequest >, public ActorSingleCallback< RunActor, 4, GetTopKMetricsRequest >, public ActorSingleCallback< RunActor, 5, GetMetricsListRequest >, public ActorSingleCallback< RunActor, 6, RebalanceStorageQueueRequest >, public ActorSingleCallback< RunActor, 7, BulkLoadShardRequest >, public ActorCallback< RunActor, 8, Void >, public ActorSingleCallback< RunActor, 9, TenantCacheTenantCreated >, public ActorSingleCallback< RunActor, 10, KeyRange >, public FastAllocated<RunActor>, public RunActorState<RunActor> {
															#line 10995 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<RunActor>::operator new;
	using FastAllocated<RunActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9617734979083158272UL, 2927491077837217792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunActor, 0, Void >;
friend struct ActorSingleCallback< RunActor, 1, Promise<int64_t> >;
friend struct ActorCallback< RunActor, 2, Void >;
friend struct ActorSingleCallback< RunActor, 3, GetMetricsRequest >;
friend struct ActorSingleCallback< RunActor, 4, GetTopKMetricsRequest >;
friend struct ActorSingleCallback< RunActor, 5, GetMetricsListRequest >;
friend struct ActorSingleCallback< RunActor, 6, RebalanceStorageQueueRequest >;
friend struct ActorSingleCallback< RunActor, 7, BulkLoadShardRequest >;
friend struct ActorCallback< RunActor, 8, Void >;
friend struct ActorSingleCallback< RunActor, 9, TenantCacheTenantCreated >;
friend struct ActorSingleCallback< RunActor, 10, KeyRange >;
															#line 1665 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	RunActor(DataDistributionTracker* const& self,Reference<InitialDataDistribution> const& initData) 
															#line 11022 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   RunActorState<RunActor>(self, initData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("run", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(633236942609902848UL, 16810589115111353856UL);
		ActorExecutionContextHelper __helper(static_cast<RunActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("run");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("run", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorSingleCallback< RunActor, 1, Promise<int64_t> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1665 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] static Future<Void> run( DataDistributionTracker* const& self, Reference<InitialDataDistribution> const& initData ) {
															#line 1665 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new RunActor(self, initData));
															#line 11055 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 1726 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
};

Future<Void> DataDistributionTracker::run(
    Reference<DataDistributionTracker> self,
    const Reference<InitialDataDistribution>& initData,
    const FutureStream<GetMetricsRequest>& getShardMetrics,
    const FutureStream<GetTopKMetricsRequest>& getTopKMetrics,
    const FutureStream<GetMetricsListRequest>& getShardMetricsList,
    const FutureStream<Promise<int64_t>>& getAverageShardBytes,
    const FutureStream<RebalanceStorageQueueRequest>& triggerStorageQueueRebalance,
    const FutureStream<BulkLoadShardRequest>& triggerShardBulkLoading) {
	self->getShardMetrics = getShardMetrics;
	self->getTopKMetrics = getTopKMetrics;
	self->getShardMetricsList = getShardMetricsList;
	self->averageShardBytes = getAverageShardBytes;
	self->triggerStorageQueueRebalance = triggerStorageQueueRebalance;
	self->triggerShardBulkLoading = triggerShardBulkLoading;
	self->userRangeConfig = initData->userRangeConfig;
	self->bulkLoadEnabled = bulkLoadIsEnabled(initData->bulkLoadMode);
	return holdWhile(self, DataDistributionTrackerImpl::run(self.getPtr(), initData));
}

// Tracks storage metrics for `keys` and updates `physicalShardStats` which is the stats for the physical shard owning
// this key range. This function is similar to `trackShardMetrics()` and altered for physical shard. This meant to be
// temporary. Eventually, we want a new interface to track physical shard metrics more efficiently.
															#line 11084 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via trackKeyRangeInPhysicalShardMetrics()
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class TrackKeyRangeInPhysicalShardMetricsActor>
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TrackKeyRangeInPhysicalShardMetricsActorState {
															#line 11091 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TrackKeyRangeInPhysicalShardMetricsActorState(Reference<IDDTxnProcessor> const& db,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardMetrics,Reference<AsyncVar<Optional<StorageMetrics>>> const& physicalShardStats) 
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : db(db),
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   keys(keys),
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardMetrics(shardMetrics),
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   physicalShardStats(physicalShardStats),
															#line 1756 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   bandwidthStatus(shardMetrics->get().present() ? getBandwidthStatus(shardMetrics->get().get().metrics) : BandwidthStatusNormal),
															#line 1758 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   lastLowBandwidthStartTime(shardMetrics->get().present() ? shardMetrics->get().get().lastLowBandwidthStartTime : now()),
															#line 1760 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   shardCount(shardMetrics->get().present() ? shardMetrics->get().get().shardCount : 1)
															#line 11110 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	~TrackKeyRangeInPhysicalShardMetricsActorState() 
	{
		fdb_probe_actor_destroy("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1761 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(0, TaskPriority::DataDistribution);
															#line 1761 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11127 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state = 1;
															#line 1761 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >*>(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)));
															#line 11132 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TrackKeyRangeInPhysicalShardMetricsActorState();
		static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1769 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		;
															#line 11155 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1769 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		;
															#line 11164 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state > 0) static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1770 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		bounds = ShardSizeBounds();
															#line 1771 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		bool readHotShard;
															#line 1772 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		std::tie(bounds, readHotShard) = calculateShardSizeBounds(keys, shardMetrics, bandwidthStatus);
															#line 1774 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		;
															#line 11261 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1(int loopDepth) 
	{
															#line 1776 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		StrictFuture<std::pair<Optional<StorageMetrics>, int>> __when_expr_1 = db->waitStorageMetrics(keys, bounds.min, bounds.max, bounds.permittedError, CLIENT_KNOBS->STORAGE_METRICS_SHARD_LIMIT, shardCount);
															#line 1776 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 11285 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1cont1loopBody1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state = 2;
															#line 1776 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*>(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)));
															#line 11290 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(std::pair<Optional<StorageMetrics>, int> const& metrics,int loopDepth) 
	{
															#line 1783 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (metrics.first.present())
															#line 11312 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 1784 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			BandwidthStatus newBandwidthStatus = getBandwidthStatus(metrics.first.get());
															#line 1785 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (newBandwidthStatus == BandwidthStatusLow && bandwidthStatus != BandwidthStatusLow)
															#line 11318 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1786 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				lastLowBandwidthStartTime = now();
															#line 11322 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 1788 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			bandwidthStatus = newBandwidthStatus;
															#line 1791 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!physicalShardStats->get().present())
															#line 11328 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1792 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				physicalShardStats->set(metrics.first.get());
															#line 11332 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
			else
			{
															#line 1794 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (!shardMetrics->get().present())
															#line 11338 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				{
															#line 1796 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					physicalShardStats->set(physicalShardStats->get().get() + metrics.first.get());
															#line 11342 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				}
				else
				{
															#line 1798 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					physicalShardStats->set(physicalShardStats->get().get() - shardMetrics->get().get().metrics + metrics.first.get());
															#line 11348 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				}
			}
															#line 1803 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardMetrics->set(ShardMetrics(metrics.first.get(), lastLowBandwidthStartTime, shardCount));
															#line 11353 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 1806 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardCount = metrics.second;
															#line 1807 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shardMetrics->get().present())
															#line 11362 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1808 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				auto newShardMetrics = shardMetrics->get().get();
															#line 1809 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				newShardMetrics.shardCount = shardCount;
															#line 1810 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				shardMetrics->set(newShardMetrics);
															#line 11370 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
		}
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1cont1(std::pair<Optional<StorageMetrics>, int> && metrics,int loopDepth) 
	{
															#line 1783 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (metrics.first.present())
															#line 11381 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		{
															#line 1784 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			BandwidthStatus newBandwidthStatus = getBandwidthStatus(metrics.first.get());
															#line 1785 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (newBandwidthStatus == BandwidthStatusLow && bandwidthStatus != BandwidthStatusLow)
															#line 11387 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1786 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				lastLowBandwidthStartTime = now();
															#line 11391 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
															#line 1788 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			bandwidthStatus = newBandwidthStatus;
															#line 1791 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (!physicalShardStats->get().present())
															#line 11397 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1792 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				physicalShardStats->set(metrics.first.get());
															#line 11401 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
			else
			{
															#line 1794 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				if (!shardMetrics->get().present())
															#line 11407 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				{
															#line 1796 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					physicalShardStats->set(physicalShardStats->get().get() + metrics.first.get());
															#line 11411 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				}
				else
				{
															#line 1798 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
					physicalShardStats->set(physicalShardStats->get().get() - shardMetrics->get().get().metrics + metrics.first.get());
															#line 11417 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
				}
			}
															#line 1803 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardMetrics->set(ShardMetrics(metrics.first.get(), lastLowBandwidthStartTime, shardCount));
															#line 11422 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			return a_body1cont1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 1806 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			shardCount = metrics.second;
															#line 1807 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (shardMetrics->get().present())
															#line 11431 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			{
															#line 1808 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				auto newShardMetrics = shardMetrics->get().get();
															#line 1809 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				newShardMetrics.shardCount = shardCount;
															#line 1810 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
				shardMetrics->set(newShardMetrics);
															#line 11439 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			}
		}
		if (loopDepth == 0) return a_body1cont1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(std::pair<Optional<StorageMetrics>, int> const& metrics,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(metrics, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1loopBody1when1(std::pair<Optional<StorageMetrics>, int> && metrics,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1loopBody1cont1(std::move(metrics), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state > 0) static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->actor_wait_state = 0;
		static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >::remove();

	}
	void a_callback_fire(ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*,std::pair<Optional<StorageMetrics>, int> const& value) 
	{
		fdb_probe_actor_enter("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*,std::pair<Optional<StorageMetrics>, int> && value) 
	{
		fdb_probe_actor_enter("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*,Error err) 
	{
		fdb_probe_actor_enter("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<IDDTxnProcessor> db;
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	KeyRange keys;
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<ShardMetrics>>> shardMetrics;
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	Reference<AsyncVar<Optional<StorageMetrics>>> physicalShardStats;
															#line 1756 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	BandwidthStatus bandwidthStatus;
															#line 1758 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	double lastLowBandwidthStartTime;
															#line 1760 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	int shardCount;
															#line 1770 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	ShardSizeBounds bounds;
															#line 11537 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via trackKeyRangeInPhysicalShardMetrics()
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class TrackKeyRangeInPhysicalShardMetricsActor final : public Actor<Void>, public ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >, public ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >, public FastAllocated<TrackKeyRangeInPhysicalShardMetricsActor>, public TrackKeyRangeInPhysicalShardMetricsActorState<TrackKeyRangeInPhysicalShardMetricsActor> {
															#line 11542 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<TrackKeyRangeInPhysicalShardMetricsActor>::operator new;
	using FastAllocated<TrackKeyRangeInPhysicalShardMetricsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18311327668629383680UL, 17582864082513760256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >;
friend struct ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >;
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	TrackKeyRangeInPhysicalShardMetricsActor(Reference<IDDTxnProcessor> const& db,KeyRange const& keys,Reference<AsyncVar<Optional<ShardMetrics>>> const& shardMetrics,Reference<AsyncVar<Optional<StorageMetrics>>> const& physicalShardStats) 
															#line 11560 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   TrackKeyRangeInPhysicalShardMetricsActorState<TrackKeyRangeInPhysicalShardMetricsActor>(db, keys, shardMetrics, physicalShardStats),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10053982890854043392UL, 5522241827895872000UL);
		ActorExecutionContextHelper __helper(static_cast<TrackKeyRangeInPhysicalShardMetricsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("trackKeyRangeInPhysicalShardMetrics");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("trackKeyRangeInPhysicalShardMetrics", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< TrackKeyRangeInPhysicalShardMetricsActor, 1, std::pair<Optional<StorageMetrics>, int> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
[[nodiscard]] Future<Void> trackKeyRangeInPhysicalShardMetrics( Reference<IDDTxnProcessor> const& db, KeyRange const& keys, Reference<AsyncVar<Optional<ShardMetrics>>> const& shardMetrics, Reference<AsyncVar<Optional<StorageMetrics>>> const& physicalShardStats ) {
															#line 1751 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new TrackKeyRangeInPhysicalShardMetricsActor(db, keys, shardMetrics, physicalShardStats));
															#line 11594 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}

#line 1816 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"

void PhysicalShardCollection::PhysicalShard::insertNewRangeData(const KeyRange& newRange) {
	RangeData data;
	data.stats = makeReference<AsyncVar<Optional<ShardMetrics>>>();
	data.trackMetrics = trackKeyRangeInPhysicalShardMetrics(txnProcessor, newRange, data.stats, stats);
	auto it = rangeData.emplace(newRange, data);
	ASSERT(it.second);
}

void PhysicalShardCollection::PhysicalShard::addRange(const KeyRange& newRange) {
	if (g_network->isSimulated()) {
		// Test that new range must not overlap with any existing range in this shard.
		for (const auto& [range, data] : rangeData) {
			ASSERT(!range.intersects(newRange));
		}
	}

	insertNewRangeData(newRange);
}

void PhysicalShardCollection::PhysicalShard::removeRange(const KeyRange& outRange) {
	std::vector<KeyRangeRef> updateRanges;
	for (auto& [range, data] : rangeData) {
		if (range.intersects(outRange)) {
			updateRanges.push_back(range);
		}
	}

	for (auto& range : updateRanges) {
		std::vector<KeyRangeRef> remainingRanges = range - outRange;
		for (auto& r : remainingRanges) {
			ASSERT(r != range);
			insertNewRangeData(r);
		}
		// Must erase last since `remainingRanges` uses data in `range`.
		rangeData.erase(range);
	}
}

// Decide whether a physical shard is available at the moment when the func is calling
PhysicalShardAvailable PhysicalShardCollection::checkPhysicalShardAvailable(uint64_t physicalShardID,
                                                                            StorageMetrics const& moveInMetrics) {
	ASSERT(physicalShardID != UID().first() && physicalShardID != anonymousShardId.first());
	ASSERT(physicalShardInstances.contains(physicalShardID));
	if (physicalShardInstances[physicalShardID].metrics.bytes + moveInMetrics.bytes >
	    SERVER_KNOBS->MAX_PHYSICAL_SHARD_BYTES) {
		return PhysicalShardAvailable::False;
	}
	return PhysicalShardAvailable::True;
}

std::string PhysicalShardCollection::convertIDsToString(std::set<uint64_t> ids) {
	std::string r = "";
	for (auto id : ids) {
		r = r + std::to_string(id) + " ";
	}
	return r;
}

void PhysicalShardCollection::updateTeamPhysicalShardIDsMap(uint64_t inputPhysicalShardID,
                                                            std::vector<ShardsAffectedByTeamFailure::Team> inputTeams,
                                                            uint64_t debugID) {
	ASSERT(inputTeams.size() <= 2);
	ASSERT(inputPhysicalShardID != anonymousShardId.first() && inputPhysicalShardID != UID().first());
	for (auto inputTeam : inputTeams) {
		if (!teamPhysicalShardIDs.contains(inputTeam)) {
			std::set<uint64_t> physicalShardIDSet;
			physicalShardIDSet.insert(inputPhysicalShardID);
			teamPhysicalShardIDs.insert(std::make_pair(inputTeam, physicalShardIDSet));
		} else {
			teamPhysicalShardIDs[inputTeam].insert(inputPhysicalShardID);
		}
	}
	return;
}

void PhysicalShardCollection::insertPhysicalShardToCollection(uint64_t physicalShardID,
                                                              StorageMetrics const& metrics,
                                                              std::vector<ShardsAffectedByTeamFailure::Team> teams,
                                                              uint64_t debugID,
                                                              PhysicalShardCreationTime whenCreated) {
	ASSERT(physicalShardID != anonymousShardId.first() && physicalShardID != UID().first());
	ASSERT(!physicalShardInstances.contains(physicalShardID));
	physicalShardInstances.insert(
	    std::make_pair(physicalShardID, PhysicalShard(txnProcessor, physicalShardID, metrics, teams, whenCreated)));
	return;
}

// This method maintains the consistency between keyRangePhysicalShardIDMap and the RangeData in physicalShardInstances.
// They are all updated in this method.
void PhysicalShardCollection::updatekeyRangePhysicalShardIDMap(KeyRange keyRange,
                                                               uint64_t physicalShardID,
                                                               uint64_t debugID) {
	ASSERT(physicalShardID != UID().first());
	auto ranges = keyRangePhysicalShardIDMap.intersectingRanges(keyRange);
	std::set<uint64_t> physicalShardIDSet;

	// If there are any existing physical shards own `keyRange`, remove the overlapping ranges from existing physical
	// shards.
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		uint64_t shardID = it->value();
		if (shardID == UID().first()) {
			continue;
		}
		ASSERT(physicalShardInstances.find(shardID) != physicalShardInstances.end());
		physicalShardInstances[shardID].removeRange(keyRange);
	}

	// Insert `keyRange` to the new physical shard.
	keyRangePhysicalShardIDMap.insert(keyRange, physicalShardID);
	ASSERT(physicalShardInstances.find(physicalShardID) != physicalShardInstances.end());
	physicalShardInstances[physicalShardID].addRange(keyRange);

	// KeyRange to physical shard mapping consistency sanity check.
	checkKeyRangePhysicalShardMapping();
}

void PhysicalShardCollection::checkKeyRangePhysicalShardMapping() {
	if (!g_network->isSimulated()) {
		return;
	}

	// Check the invariant that keyRangePhysicalShardIDMap and physicalShardInstances should be consistent.
	KeyRangeMap<uint64_t>::Ranges keyRangePhysicalShardIDRanges = keyRangePhysicalShardIDMap.ranges();
	KeyRangeMap<uint64_t>::iterator it = keyRangePhysicalShardIDRanges.begin();
	for (; it != keyRangePhysicalShardIDRanges.end(); ++it) {
		uint64_t shardID = it->value();
		if (shardID == UID().first()) {
			continue;
		}
		auto keyRangePiece = KeyRangeRef(it->range().begin, it->range().end);
		ASSERT(physicalShardInstances.find(shardID) != physicalShardInstances.end());
		bool exist = false;
		for (const auto& [range, data] : physicalShardInstances[shardID].rangeData) {
			if (range == keyRangePiece) {
				exist = true;
				break;
			}
		}
		ASSERT(exist);
	}

	for (auto& [shardID, physicalShard] : physicalShardInstances) {
		for (auto& [range, data] : physicalShard.rangeData) {
			ASSERT(keyRangePhysicalShardIDMap[range.begin] == shardID);
		}
	}
}

// At beginning of the transition from the initial state without physical shard notion
// to the physical shard aware state, the physicalShard set only contains one element which is anonymousShardId[0]
// After a period in the transition, the physicalShard set of the team contains some meaningful physicalShardIDs
Optional<uint64_t> PhysicalShardCollection::trySelectAvailablePhysicalShardFor(
    ShardsAffectedByTeamFailure::Team team,
    StorageMetrics const& moveInMetrics,
    const std::unordered_set<uint64_t>& excludedPhysicalShards,
    uint64_t debugID) {
	ASSERT(team.servers.size() > 0);
	// Case: The team is not tracked in the mapping (teamPhysicalShardIDs)
	if (!teamPhysicalShardIDs.contains(team)) {
		return Optional<uint64_t>();
	}
	ASSERT(teamPhysicalShardIDs[team].size() >= 1);
	// Case: The team is tracked in the mapping and the system already has physical shard notion
	// 		and the number of physicalShard is large
	std::vector<uint64_t> availablePhysicalShardIDs;
	for (auto physicalShardID : teamPhysicalShardIDs[team]) {
		if (physicalShardID == anonymousShardId.first() || physicalShardID == UID().first()) {
			ASSERT(false);
		}
		ASSERT(physicalShardInstances.contains(physicalShardID));
		/*TraceEvent("TryGetPhysicalShardIDCandidates")
		    .detail("PhysicalShardID", physicalShardID)
		    .detail("Bytes", physicalShardInstances[physicalShardID].metrics.bytes)
		    .detail("BelongTeam", team.toString())
		    .detail("DebugID", debugID);*/
		if (excludedPhysicalShards.find(physicalShardID) != excludedPhysicalShards.end()) {
			continue;
		}
		if (!checkPhysicalShardAvailable(physicalShardID, moveInMetrics)) {
			continue;
		}
		availablePhysicalShardIDs.push_back(physicalShardID);
	}
	if (availablePhysicalShardIDs.size() == 0) {
		/*TraceEvent("TryGetPhysicalShardIDResultFailed")
		    .detail("Reason", "no valid physicalShard")
		    .detail("MoveInBytes", moveInMetrics.bytes)
		    .detail("MaxPhysicalShardBytes", SERVER_KNOBS->MAX_PHYSICAL_SHARD_BYTES)
		    .detail("DebugID", debugID);*/
		return Optional<uint64_t>();
	}
	return deterministicRandom()->randomChoice(availablePhysicalShardIDs);
}

uint64_t PhysicalShardCollection::generateNewPhysicalShardID(uint64_t debugID) {
	uint64_t physicalShardID = UID().first();
	int stuckCount = 0;
	while (physicalShardID == UID().first() || physicalShardID == anonymousShardId.first()) {
		physicalShardID = deterministicRandom()->randomUInt64();
		stuckCount = stuckCount + 1;
		if (stuckCount > 50) {
			ASSERT(false);
		}
	}
	ASSERT(physicalShardID != UID().first() && physicalShardID != anonymousShardId.first());
	//TraceEvent("GenerateNewPhysicalShardID").detail("PhysicalShardID", physicalShardID).detail("DebugID", debugID);
	return physicalShardID;
}

void PhysicalShardCollection::reduceMetricsForMoveOut(uint64_t physicalShardID, StorageMetrics const& moveOutMetrics) {
	ASSERT(physicalShardInstances.contains(physicalShardID));
	ASSERT(physicalShardID != UID().first() && physicalShardID != anonymousShardId.first());
	physicalShardInstances[physicalShardID].metrics = physicalShardInstances[physicalShardID].metrics - moveOutMetrics;
	return;
}

void PhysicalShardCollection::increaseMetricsForMoveIn(uint64_t physicalShardID, StorageMetrics const& moveInMetrics) {
	ASSERT(physicalShardInstances.contains(physicalShardID));
	ASSERT(physicalShardID != UID().first() && physicalShardID != anonymousShardId.first());
	physicalShardInstances[physicalShardID].metrics = physicalShardInstances[physicalShardID].metrics + moveInMetrics;
	return;
}

void PhysicalShardCollection::updatePhysicalShardMetricsByKeyRange(KeyRange keyRange,
                                                                   StorageMetrics const& newMetrics,
                                                                   StorageMetrics const& oldMetrics,
                                                                   bool initWithNewMetrics) {
	auto ranges = keyRangePhysicalShardIDMap.intersectingRanges(keyRange);
	std::set<uint64_t> physicalShardIDSet;
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		physicalShardIDSet.insert(it->value());
	}
	StorageMetrics delta;
	if (initWithNewMetrics) {
		delta = newMetrics;
	} else {
		delta = newMetrics - oldMetrics;
	}
	for (auto physicalShardID : physicalShardIDSet) {
		ASSERT(physicalShardID != UID().first());
		if (physicalShardID == anonymousShardId.first()) {
			continue; // we ignore anonymousShard when updating physicalShard metrics
		}
		increaseMetricsForMoveIn(physicalShardID, (delta * (1.0 / physicalShardIDSet.size())));
	}
	return;
}

InAnonymousPhysicalShard PhysicalShardCollection::isInAnonymousPhysicalShard(KeyRange keyRange) {
	InAnonymousPhysicalShard res = InAnonymousPhysicalShard::True;
	auto ranges = keyRangePhysicalShardIDMap.intersectingRanges(keyRange);
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		uint64_t physicalShardID = it->value();
		if (physicalShardID != anonymousShardId.first()) {
			// res = false if exists a part of keyRange belongs to a non-anonymous physicalShard
			// exist a case where some keyRange of anonymousShard is decided to move
			// to a non-anonymous physicalShard but not completes
			res = InAnonymousPhysicalShard::False;
		}
	}
	return res;
}

// TODO: require optimize
// It is slow to go through the keyRangePhysicalShardIDRanges for each time
// Do we need a D/S to store the keyRange for each physicalShard?
PhysicalShardHasMoreThanKeyRange PhysicalShardCollection::whetherPhysicalShardHasMoreThanKeyRange(
    uint64_t physicalShardID,
    KeyRange keyRange) {
	KeyRangeMap<uint64_t>::Ranges keyRangePhysicalShardIDRanges = keyRangePhysicalShardIDMap.ranges();
	KeyRangeMap<uint64_t>::iterator it = keyRangePhysicalShardIDRanges.begin();
	for (; it != keyRangePhysicalShardIDRanges.end(); ++it) {
		if (it->value() != physicalShardID) {
			continue;
		}
		auto keyRangePiece = KeyRangeRef(it->range().begin, it->range().end);
		if (!keyRange.intersects(keyRangePiece)) {
			return PhysicalShardHasMoreThanKeyRange::True;
		}
		// if keyRange and keyRangePiece have intersection
		if (!keyRange.contains(keyRangePiece)) {
			return PhysicalShardHasMoreThanKeyRange::True;
		}
	}
	return PhysicalShardHasMoreThanKeyRange::False;
}

InOverSizePhysicalShard PhysicalShardCollection::isInOverSizePhysicalShard(KeyRange keyRange) {
	auto ranges = keyRangePhysicalShardIDMap.intersectingRanges(keyRange);
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		uint64_t physicalShardID = it->value();
		ASSERT(physicalShardID != UID().first());
		if (physicalShardID == anonymousShardId.first()) {
			continue;
		}
		if (checkPhysicalShardAvailable(physicalShardID, StorageMetrics())) {
			continue;
		}
		if (!whetherPhysicalShardHasMoreThanKeyRange(physicalShardID, keyRange)) {
			continue;
		}
		return InOverSizePhysicalShard::True;
	}
	return InOverSizePhysicalShard::False;
}

// May return a problematic remote team
std::pair<Optional<ShardsAffectedByTeamFailure::Team>, bool> PhysicalShardCollection::tryGetAvailableRemoteTeamWith(
    uint64_t inputPhysicalShardID,
    StorageMetrics const& moveInMetrics,
    uint64_t debugID) {
	ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
	ASSERT(SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD);
	ASSERT(inputPhysicalShardID != anonymousShardId.first() && inputPhysicalShardID != UID().first());
	if (!physicalShardInstances.contains(inputPhysicalShardID)) {
		return { Optional<ShardsAffectedByTeamFailure::Team>(), true };
	}
	if (!checkPhysicalShardAvailable(inputPhysicalShardID, moveInMetrics)) {
		return { Optional<ShardsAffectedByTeamFailure::Team>(), false };
	}
	for (auto team : physicalShardInstances[inputPhysicalShardID].teams) {
		if (team.primary == false) {
			/*TraceEvent("TryGetRemoteTeamWith")
			    .detail("PhysicalShardID", inputPhysicalShardID)
			    .detail("Team", team.toString())
			    .detail("TeamSize", team.servers.size())
			    .detail("PhysicalShardsOfTeam", convertIDsToString(teamPhysicalShardIDs[team]))
			    .detail("DebugID", debugID);*/
			return { team, true };
		}
	}
	// In this case, the physical shard may not be populated in the remote region yet, e.g., we are making a
	// configuration change to turn a single region cluster into HA mode.
	return { Optional<ShardsAffectedByTeamFailure::Team>(), true };
}

// The update of PhysicalShardToTeams, Collection, keyRangePhysicalShardIDMap should be atomic
void PhysicalShardCollection::initPhysicalShardCollection(KeyRange keys,
                                                          std::vector<ShardsAffectedByTeamFailure::Team> selectedTeams,
                                                          uint64_t physicalShardID,
                                                          uint64_t debugID) {
	ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
	ASSERT(SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD);
	ASSERT(physicalShardID != UID().first());
	if (physicalShardID != anonymousShardId.first()) {
		updateTeamPhysicalShardIDsMap(physicalShardID, selectedTeams, debugID);
		if (!physicalShardInstances.contains(physicalShardID)) {
			insertPhysicalShardToCollection(
			    physicalShardID, StorageMetrics(), selectedTeams, debugID, PhysicalShardCreationTime::DDInit);
		} else {
			// This assertion will be broken if we enable the optimization of data move traffic between DCs
			ASSERT(physicalShardInstances[physicalShardID].teams == selectedTeams);
		}
	} else {
		// If any physicalShard restored when DD init is the anonymousShard,
		// Then DD enters Transition state where DD graduatelly moves Shard (or KeyRange)
		// out of the anonymousShard
		setTransitionCheck();
	}
	updatekeyRangePhysicalShardIDMap(keys, physicalShardID, debugID);
	return;
}

// The update of PhysicalShardToTeams, Collection, keyRangePhysicalShardIDMap should be atomic
void PhysicalShardCollection::updatePhysicalShardCollection(
    KeyRange keys,
    bool isRestore,
    std::vector<ShardsAffectedByTeamFailure::Team> selectedTeams,
    uint64_t physicalShardID,
    const StorageMetrics& metrics,
    uint64_t debugID) {
	ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
	ASSERT(SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD);
	ASSERT(physicalShardID != UID().first());
	/*TraceEvent e("UpdatePhysicalShard");
	e.detail("DebugID", debugID);
	e.detail("KeyRange", keys);
	e.detail("IsRestore", isRestore);*/
	// When updates metrics in physicalShard collection, we assume:
	// It is impossible to move a keyRange from anonymousShard to a valid physicalShard
	// Thus, we ignore anonymousShard when updating metrics
	if (physicalShardID != anonymousShardId.first()) {
		updateTeamPhysicalShardIDsMap(physicalShardID, selectedTeams, debugID);
		// Update physicalShardInstances
		// Add the metrics to in-physicalShard
		// e.detail("PhysicalShardIDIn", physicalShardID);
		if (!physicalShardInstances.contains(physicalShardID)) {
			// e.detail("Op", "Insert");
			insertPhysicalShardToCollection(
			    physicalShardID, metrics, selectedTeams, debugID, PhysicalShardCreationTime::DDRelocator);
		} else {
			// e.detail("Op", "Update");
			//  This assertion is true since we disable the optimization of data move traffic between DCs
			ASSERT(physicalShardInstances[physicalShardID].teams == selectedTeams);
			increaseMetricsForMoveIn(physicalShardID, metrics);
		}
	}
	// Minus the metrics from the existing (multiple) out-physicalShard(s)
	auto ranges = keyRangePhysicalShardIDMap.intersectingRanges(keys);
	std::set<uint64_t> physicalShardIDSet;
	for (auto it = ranges.begin(); it != ranges.end(); ++it) {
		physicalShardIDSet.insert(it->value());
	}
	/*std::string physicalShardIDOut = "";
	for (auto id : physicalShardIDSet) {
	    physicalShardIDOut = physicalShardIDOut + std::to_string(id) + " ";
	}*/
	// e.detail("PhysicalShardIDOut", physicalShardIDOut);
	for (auto physicalShardID : physicalShardIDSet) { // imprecise: evenly move out bytes
		if (physicalShardID == anonymousShardId.first()) {
			continue; // we ignore anonymousShard when updating physicalShard metrics
		}
		StorageMetrics toReduceMetrics = metrics * (1.0 / physicalShardIDSet.size());
		reduceMetricsForMoveOut(physicalShardID, toReduceMetrics);
	}
	// keyRangePhysicalShardIDMap must be update after updating the metrics of physicalShardInstances
	updatekeyRangePhysicalShardIDMap(keys, physicalShardID, debugID);
	return;
}

// return false if no need to move keyRange out of current physical shard
MoveKeyRangeOutPhysicalShard PhysicalShardCollection::trackPhysicalShard(KeyRange keyRange,
                                                                         StorageMetrics const& newMetrics,
                                                                         StorageMetrics const& oldMetrics,
                                                                         bool initWithNewMetrics) {
	ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
	ASSERT(SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD);
	updatePhysicalShardMetricsByKeyRange(keyRange, newMetrics, oldMetrics, initWithNewMetrics);
	if (requireTransitionCheck() &&
	    now() - lastTransitionStartTime > SERVER_KNOBS->ANONYMOUS_PHYSICAL_SHARD_TRANSITION_TIME) {
		if (isInAnonymousPhysicalShard(keyRange)) {
			// Currently, whenever a shard updates metrics, it checks whether is in AnonymousPhysicalShard
			// If yes, and if the shard has been created for long time, then triggers a data move on the shard.
			resetLastTransitionStartTime();
			TraceEvent("PhysicalShardTiggerTransitionMove")
			    .detail("KeyRange", keyRange)
			    .detail("TransitionCoolDownTime", SERVER_KNOBS->ANONYMOUS_PHYSICAL_SHARD_TRANSITION_TIME);
			return MoveKeyRangeOutPhysicalShard::True;
		}
	}
	if (isInOverSizePhysicalShard(keyRange)) {
		return MoveKeyRangeOutPhysicalShard::True;
	}
	return MoveKeyRangeOutPhysicalShard::False;
}

// The update of PhysicalShardToTeams, PhysicalShardInstances, KeyRangePhysicalShardIDMap should be atomic
void PhysicalShardCollection::cleanUpPhysicalShardCollection() {
	ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
	ASSERT(SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD);
	std::set<uint64_t> physicalShardsInUse;
	std::map<uint64_t, StorageMetrics> metricsReplies;
	KeyRangeMap<uint64_t>::Ranges keyRangePhysicalShardIDRanges = keyRangePhysicalShardIDMap.ranges();
	KeyRangeMap<uint64_t>::iterator it = keyRangePhysicalShardIDRanges.begin();
	// Assume that once a physical shard is disappear in keyRangePhysicalShardIDMap,
	// the physical shard (with the deleted id) should be deprecated.
	// This function aims at clean up those deprecated physical shards in PhysicalShardCollection
	// This function collects the physicalShard usage info from KeyRangePhysicalShardIDMap,
	// then based on the info to update PhysicalShardToTeams and PhysicalShardInstances

	// keyRangePhysicalShardIDMap indicates which physicalShard actually has data
	// Step 1: Clear unused physicalShard in physicalShardInstances based on keyRangePhysicalShardIDMap
	for (; it != keyRangePhysicalShardIDRanges.end(); ++it) {
		uint64_t physicalShardID = it->value();
		if (physicalShardID == anonymousShardId.first()) {
			continue;
		}
		physicalShardsInUse.insert(physicalShardID);
	}
	for (auto it = physicalShardInstances.begin(); it != physicalShardInstances.end();) {
		uint64_t physicalShardID = it->first;
		ASSERT(physicalShardInstances.contains(physicalShardID));
		if (!physicalShardsInUse.contains(physicalShardID)) {
			/*TraceEvent("PhysicalShardisEmpty")
			    .detail("PhysicalShard", physicalShardID)
			    .detail("RemainBytes", physicalShardInstances[physicalShardID].metrics.bytes);*/
			// "RemainBytes" indicates the deviation of current physical shard metric update
			it = physicalShardInstances.erase(it);
		} else {
			it++;
		}
	}
	// Step 2: Clean up teamPhysicalShardIDs
	std::set<ShardsAffectedByTeamFailure::Team> toRemoveTeams;
	for (auto [team, _] : teamPhysicalShardIDs) {
		for (auto it = teamPhysicalShardIDs[team].begin(); it != teamPhysicalShardIDs[team].end();) {
			uint64_t physicalShardID = *it;
			if (!physicalShardInstances.contains(physicalShardID)) {
				// physicalShardID has been removed from physicalShardInstances (see step 1)
				// So, remove the physicalShard from teamPhysicalShardID[team]
				it = teamPhysicalShardIDs[team].erase(it);
			} else {
				it++;
			}
		}
		if (teamPhysicalShardIDs[team].size() == 0) {
			// If a team has no physicalShard, remove the team from teamPhysicalShardID
			toRemoveTeams.insert(team);
		}
	}
	for (auto team : toRemoveTeams) {
		teamPhysicalShardIDs.erase(team);
	}
}

void PhysicalShardCollection::logPhysicalShardCollection() {
	ASSERT(SERVER_KNOBS->SHARD_ENCODE_LOCATION_METADATA);
	ASSERT(SERVER_KNOBS->ENABLE_DD_PHYSICAL_SHARD);
	// Step 1: Logging non-empty physicalShard
	for (auto [physicalShardID, physicalShard] : physicalShardInstances) {
		ASSERT(physicalShardID == physicalShard.id);
		TraceEvent e("PhysicalShardStatus");
		e.detail("PhysicalShardID", physicalShardID);
		e.detail("TotalBytes", physicalShard.metrics.bytes);
	}
	// Step 2: Logging TeamPhysicalShardStatus
	for (auto [team, physicalShardIDs] : teamPhysicalShardIDs) {
		TraceEvent e("TeamPhysicalShardStatus");
		e.detail("Team", team.toString());
		// std::string metricsStr = "";
		int64_t counter = 0;
		int64_t totalBytes = 0;
		int64_t maxPhysicalShardBytes = -1;
		int64_t minPhysicalShardBytes = StorageMetrics::infinity;
		uint64_t maxPhysicalShardID = 0;
		uint64_t minPhysicalShardID = 0;
		for (auto physicalShardID : physicalShardIDs) {
			ASSERT(physicalShardInstances.contains(physicalShardID));
			uint64_t id = physicalShardInstances[physicalShardID].id;
			int64_t bytes = physicalShardInstances[physicalShardID].metrics.bytes;
			if (bytes > maxPhysicalShardBytes) {
				maxPhysicalShardBytes = bytes;
				maxPhysicalShardID = id;
			}
			if (bytes < minPhysicalShardBytes) {
				minPhysicalShardBytes = bytes;
				minPhysicalShardID = id;
			}
			totalBytes = totalBytes + bytes;
			/* metricsStr = metricsStr + std::to_string(id) + ":" + std::to_string(bytes);
			if (counter < physicalShardIDs.size() - 1) {
			    metricsStr = metricsStr + ",";
			} */
			counter = counter + 1;
		}
		// e.detail("Metrics", metricsStr);
		e.detail("TotalBytes", totalBytes);
		e.detail("NumPhysicalShards", counter);
		e.detail("MaxPhysicalShard", std::to_string(maxPhysicalShardID) + ":" + std::to_string(maxPhysicalShardBytes));
		e.detail("MinPhysicalShard", std::to_string(minPhysicalShardID) + ":" + std::to_string(minPhysicalShardBytes));
	}
	// Step 3: Logging StorageServerPhysicalShardStatus
	std::map<UID, std::map<uint64_t, int64_t>> storageServerPhysicalShardStatus;
	for (auto [team, _] : teamPhysicalShardIDs) {
		for (auto ssid : team.servers) {
			for (auto it = teamPhysicalShardIDs[team].begin(); it != teamPhysicalShardIDs[team].end();) {
				uint64_t physicalShardID = *it;
				if (storageServerPhysicalShardStatus.contains(ssid)) {
					if (!storageServerPhysicalShardStatus[ssid].contains(physicalShardID)) {
						ASSERT(physicalShardInstances.contains(physicalShardID));
						storageServerPhysicalShardStatus[ssid].insert(
						    std::make_pair(physicalShardID, physicalShardInstances[physicalShardID].metrics.bytes));
					}
				} else {
					ASSERT(physicalShardInstances.contains(physicalShardID));
					std::map<uint64_t, int64_t> tmp;
					tmp.insert(std::make_pair(physicalShardID, physicalShardInstances[physicalShardID].metrics.bytes));
					storageServerPhysicalShardStatus.insert(std::make_pair(ssid, tmp));
				}
				it++;
			}
		}
	}
	for (auto [serverID, physicalShardMetrics] : storageServerPhysicalShardStatus) {
		TraceEvent e("ServerPhysicalShardStatus");
		e.detail("Server", serverID);
		e.detail("NumPhysicalShards", physicalShardMetrics.size());
		int64_t totalBytes = 0;
		int64_t maxPhysicalShardBytes = -1;
		int64_t minPhysicalShardBytes = StorageMetrics::infinity;
		uint64_t maxPhysicalShardID = 0;
		uint64_t minPhysicalShardID = 0;
		// std::string metricsStr = "";
		// int64_t counter = 0;
		for (auto [physicalShardID, bytes] : physicalShardMetrics) {
			totalBytes = totalBytes + bytes;
			if (bytes > maxPhysicalShardBytes) {
				maxPhysicalShardBytes = bytes;
				maxPhysicalShardID = physicalShardID;
			}
			if (bytes < minPhysicalShardBytes) {
				minPhysicalShardBytes = bytes;
				minPhysicalShardID = physicalShardID;
			}
			/* metricsStr = metricsStr + std::to_string(physicalShardID) + ":" + std::to_string(bytes);
			if (counter < physicalShardMetrics.size() - 1) {
			        metricsStr = metricsStr + ",";
			}
			counter = counter + 1; */
		}
		e.detail("TotalBytes", totalBytes);
		e.detail("MaxPhysicalShard", std::to_string(maxPhysicalShardID) + ":" + std::to_string(maxPhysicalShardBytes));
		e.detail("MinPhysicalShard", std::to_string(minPhysicalShardID) + ":" + std::to_string(minPhysicalShardBytes));
	}
}

bool PhysicalShardCollection::physicalShardExists(uint64_t physicalShardID) {
	return physicalShardInstances.find(physicalShardID) != physicalShardInstances.end();
}

// FIXME: complete this test with non-empty range
															#line 12210 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase2428()
															#line 2428 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
template <class FlowTestCase2428Actor>
															#line 2428 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase2428ActorState {
															#line 12217 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
															#line 2428 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase2428ActorState(UnitTestParameters const& params) 
															#line 2428 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
															#line 2428 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		 : params(params),
															#line 2429 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   self(),
															#line 2430 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   ranges(),
															#line 2435 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		   req(ranges, 3, 1000, 100000)
															#line 12230 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase2428", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase2428ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase2428", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 2439 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			StrictFuture<Void> __when_expr_0 = fetchTopKShardMetrics(&self, req);
															#line 2439 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			if (static_cast<FlowTestCase2428Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12247 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase2428Actor*>(this)->actor_wait_state = 1;
															#line 2439 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase2428Actor, 0, Void >*>(static_cast<FlowTestCase2428Actor*>(this)));
															#line 12252 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase2428ActorState();
		static_cast<FlowTestCase2428Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 2440 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto& reply = req.reply.getFuture().get();
															#line 2441 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(reply.shardMetrics.empty());
															#line 2442 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(reply.maxReadLoad == -1);
															#line 2443 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(reply.minReadLoad == -1);
															#line 2445 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase2428Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2428ActorState(); static_cast<FlowTestCase2428Actor*>(this)->destroy(); return 0; }
															#line 12283 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase2428Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2428ActorState();
		static_cast<FlowTestCase2428Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 2440 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		auto& reply = req.reply.getFuture().get();
															#line 2441 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(reply.shardMetrics.empty());
															#line 2442 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(reply.maxReadLoad == -1);
															#line 2443 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		ASSERT(reply.minReadLoad == -1);
															#line 2445 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
		if (!static_cast<FlowTestCase2428Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase2428ActorState(); static_cast<FlowTestCase2428Actor*>(this)->destroy(); return 0; }
															#line 12303 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		new (&static_cast<FlowTestCase2428Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase2428ActorState();
		static_cast<FlowTestCase2428Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase2428Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase2428Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase2428Actor*>(this)->ActorCallback< FlowTestCase2428Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase2428Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase2428", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2428Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2428", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase2428Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase2428", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2428Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2428", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase2428Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase2428", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2428Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase2428", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 2428 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	UnitTestParameters params;
															#line 2429 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	DataDistributionTracker self;
															#line 2430 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	std::vector<KeyRange> ranges;
															#line 2435 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	GetTopKMetricsRequest req;
															#line 12394 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase2428()
															#line 2428 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
class FlowTestCase2428Actor final : public Actor<Void>, public ActorCallback< FlowTestCase2428Actor, 0, Void >, public FastAllocated<FlowTestCase2428Actor>, public FlowTestCase2428ActorState<FlowTestCase2428Actor> {
															#line 12399 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase2428Actor>::operator new;
	using FastAllocated<FlowTestCase2428Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13367254507263314688UL, 4730817690209993728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase2428Actor, 0, Void >;
															#line 2428 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	FlowTestCase2428Actor(UnitTestParameters const& params) 
															#line 12416 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase2428ActorState<FlowTestCase2428Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase2428", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12263266818408997632UL, 3838686239656412672UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase2428Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase2428");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase2428", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase2428Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 2428 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
static Future<Void> flowTestCase2428( UnitTestParameters const& params ) {
															#line 2428 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
	return Future<Void>(new FlowTestCase2428Actor(params));
															#line 12449 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbserver/DDShardTracker.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase2428, "/DataDistributor/Tracker/FetchTopK")

#line 2447 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbserver/DDShardTracker.actor.cpp"
