#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
/*
 * KillCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "boost/algorithm/string.hpp"

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/Knobs.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/CodeProbe.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace fdb_cli {

															#line 39 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
// This generated class is to be used only via killCommandActor()
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
template <class KillCommandActorActor>
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
class KillCommandActorActorState {
															#line 45 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
public:
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
	KillCommandActorActorState(Reference<IDatabase> const& db,Reference<ITransaction> const& tr,std::vector<StringRef> const& tokens,std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface) 
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
		 : db(db),
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
		   tr(tr),
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
		   tokens(tokens),
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
		   address_interface(address_interface)
															#line 58 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("killCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~KillCommandActorActorState() 
	{
		fdb_probe_actor_destroy("killCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 41 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			ASSERT(tokens.size() >= 1);
															#line 42 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			result = true;
															#line 43 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			addressesStr = std::string();
															#line 44 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			if (tokens.size() == 1)
															#line 79 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
			{
															#line 46 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
				address_interface->clear();
															#line 47 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
				StrictFuture<Void> __when_expr_0 = getWorkerInterfaces(tr, address_interface, true);
															#line 47 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
				if (static_cast<KillCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 87 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<KillCommandActorActor*>(this)->actor_wait_state = 1;
															#line 47 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KillCommandActorActor, 0, Void >*>(static_cast<KillCommandActorActor*>(this)));
															#line 92 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KillCommandActorActorState();
		static_cast<KillCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 49 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
		if (tokens.size() == 1 || tokencmp(tokens[1], "list"))
															#line 120 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
		{
															#line 50 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			if (address_interface->size() == 0)
															#line 124 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
			{
															#line 51 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
				printf("\nNo addresses can be killed.\n");
															#line 128 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
			}
			else
			{
															#line 52 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
				if (address_interface->size() == 1)
															#line 134 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
				{
															#line 53 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					printf("\nThe following address can be killed:\n");
															#line 138 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
				}
				else
				{
															#line 55 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					printf("\nThe following %zu addresses can be killed:\n", address_interface->size());
															#line 144 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
				}
			}
															#line 57 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			for( auto it : *address_interface ) {
															#line 58 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
				printf("%s\n", printable(it.first).c_str());
															#line 151 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
			}
															#line 60 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			printf("\n");
															#line 155 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
			loopDepth = a_body1cont3(loopDepth);
		}
		else
		{
															#line 61 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			if (tokencmp(tokens[1], "all"))
															#line 162 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
			{
															#line 62 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
				if (address_interface->size() == 0)
															#line 166 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
				{
															#line 63 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					result = false;
															#line 64 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					fprintf(stderr, "ERROR: no processes to kill. You must run the `kill’ command before " "running `kill all’.\n");
															#line 172 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
					loopDepth = a_body1cont11(loopDepth);
				}
				else
				{
															#line 68 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					std::vector<std::string> addressesVec;
															#line 69 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					for( const auto& [address, _] : *address_interface ) {
															#line 70 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
						addressesVec.push_back(address.toString());
															#line 183 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
					}
															#line 72 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					addressesStr = boost::algorithm::join(addressesVec, ",");
															#line 74 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					StrictFuture<int64_t> __when_expr_1 = safeThreadFutureToFuture(db->rebootWorker(addressesStr, false, 0));
															#line 74 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					if (static_cast<KillCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 191 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
					static_cast<KillCommandActorActor*>(this)->actor_wait_state = 2;
															#line 74 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< KillCommandActorActor, 1, int64_t >*>(static_cast<KillCommandActorActor*>(this)));
															#line 196 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
					loopDepth = 0;
				}
			}
			else
			{
															#line 85 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
				i = int();
															#line 86 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
				for(i = 1;i < tokens.size();i++) {
															#line 87 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					if (!address_interface->count(tokens[i]))
															#line 208 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
					{
															#line 88 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
						fprintf(stderr, "ERROR: process `%s' not recognized.\n", printable(tokens[i]).c_str());
															#line 89 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
						result = false;
															#line 214 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
						break;
					}
				}
															#line 94 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
				if (result)
															#line 220 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
				{
															#line 95 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					std::vector<std::string> addressesVec;
															#line 96 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					for(i = 1;i < tokens.size();i++) {
															#line 97 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
						addressesVec.push_back(tokens[i].toString());
															#line 228 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
					}
															#line 99 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					addressesStr = boost::algorithm::join(addressesVec, ",");
															#line 100 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					StrictFuture<int64_t> __when_expr_2 = safeThreadFutureToFuture(db->rebootWorker(addressesStr, false, 0));
															#line 100 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					if (static_cast<KillCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 236 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when2(__when_expr_2.get(), loopDepth); };
					static_cast<KillCommandActorActor*>(this)->actor_wait_state = 3;
															#line 100 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< KillCommandActorActor, 2, int64_t >*>(static_cast<KillCommandActorActor*>(this)));
															#line 241 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont15(loopDepth);
				}
			}
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KillCommandActorActor*>(this)->actor_wait_state > 0) static_cast<KillCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<KillCommandActorActor*>(this)->ActorCallback< KillCommandActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KillCommandActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KillCommandActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KillCommandActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 114 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
		if (!static_cast<KillCommandActorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~KillCommandActorActorState(); static_cast<KillCommandActorActor*>(this)->destroy(); return 0; }
															#line 344 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
		new (&static_cast<KillCommandActorActor*>(this)->SAV< bool >::value()) bool(std::move(result)); // state_var_RVO
		this->~KillCommandActorActorState();
		static_cast<KillCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(int64_t const& killRequestsSent,int loopDepth) 
	{
															#line 75 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
		if (!killRequestsSent)
															#line 368 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
		{
															#line 76 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			result = false;
															#line 77 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			fprintf(stderr, "ERROR: failed to send requests to all processes, please run the `kill’ command again to fetch " "latest addresses.\n");
															#line 374 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
		}
		else
		{
															#line 81 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			printf("Attempted to kill %zu processes\n", address_interface->size());
															#line 380 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
		}
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(int64_t && killRequestsSent,int loopDepth) 
	{
															#line 75 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
		if (!killRequestsSent)
															#line 390 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
		{
															#line 76 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			result = false;
															#line 77 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			fprintf(stderr, "ERROR: failed to send requests to all processes, please run the `kill’ command again to fetch " "latest addresses.\n");
															#line 396 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
		}
		else
		{
															#line 81 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			printf("Attempted to kill %zu processes\n", address_interface->size());
															#line 402 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
		}
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& killRequestsSent,int loopDepth) 
	{
		loopDepth = a_body1cont13(killRequestsSent, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && killRequestsSent,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(killRequestsSent), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<KillCommandActorActor*>(this)->actor_wait_state > 0) static_cast<KillCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<KillCommandActorActor*>(this)->ActorCallback< KillCommandActorActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< KillCommandActorActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("killCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< KillCommandActorActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("killCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< KillCommandActorActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("killCommandActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killCommandActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont15(int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont18(int64_t const& killRequestsSent,int loopDepth) 
	{
															#line 101 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
		if (!killRequestsSent)
															#line 493 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
		{
															#line 102 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			result = false;
															#line 103 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			fprintf(stderr, "ERROR: failed to send requests to kill processes `%s', please run the `kill’ command again to " "fetch latest addresses.\n", addressesStr.c_str());
															#line 499 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
			loopDepth = a_body1cont18cont1(loopDepth);
		}
		else
		{
															#line 109 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(3.0);
															#line 109 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			if (static_cast<KillCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 508 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont18when1(__when_expr_3.get(), loopDepth); };
			static_cast<KillCommandActorActor*>(this)->actor_wait_state = 4;
															#line 109 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< KillCommandActorActor, 3, Void >*>(static_cast<KillCommandActorActor*>(this)));
															#line 513 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont18(int64_t && killRequestsSent,int loopDepth) 
	{
															#line 101 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
		if (!killRequestsSent)
															#line 523 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
		{
															#line 102 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			result = false;
															#line 103 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			fprintf(stderr, "ERROR: failed to send requests to kill processes `%s', please run the `kill’ command again to " "fetch latest addresses.\n", addressesStr.c_str());
															#line 529 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
			loopDepth = a_body1cont18cont1(loopDepth);
		}
		else
		{
															#line 109 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			StrictFuture<Void> __when_expr_3 = delay(3.0);
															#line 109 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			if (static_cast<KillCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 538 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont18when1(__when_expr_3.get(), loopDepth); };
			static_cast<KillCommandActorActor*>(this)->actor_wait_state = 4;
															#line 109 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< KillCommandActorActor, 3, Void >*>(static_cast<KillCommandActorActor*>(this)));
															#line 543 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1when2(int64_t const& killRequestsSent,int loopDepth) 
	{
		loopDepth = a_body1cont18(killRequestsSent, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when2(int64_t && killRequestsSent,int loopDepth) 
	{
		loopDepth = a_body1cont18(std::move(killRequestsSent), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<KillCommandActorActor*>(this)->actor_wait_state > 0) static_cast<KillCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<KillCommandActorActor*>(this)->ActorCallback< KillCommandActorActor, 2, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< KillCommandActorActor, 2, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("killCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< KillCommandActorActor, 2, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("killCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< KillCommandActorActor, 2, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("killCommandActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killCommandActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont18cont1(int loopDepth) 
	{
		loopDepth = a_body1cont15(loopDepth);

		return loopDepth;
	}
	int a_body1cont18cont3(Void const& _,int loopDepth) 
	{
															#line 110 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
		printf("Attempted to kill %zu processes\n", tokens.size() - 1);
															#line 634 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
		loopDepth = a_body1cont18cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont18cont3(Void && _,int loopDepth) 
	{
															#line 110 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
		printf("Attempted to kill %zu processes\n", tokens.size() - 1);
															#line 643 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
		loopDepth = a_body1cont18cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont18when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont18cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont18when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont18cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<KillCommandActorActor*>(this)->actor_wait_state > 0) static_cast<KillCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<KillCommandActorActor*>(this)->ActorCallback< KillCommandActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KillCommandActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont18when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< KillCommandActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont18when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< KillCommandActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killCommandActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killCommandActor", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
	std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* address_interface;
															#line 42 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
	bool result;
															#line 43 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
	std::string addressesStr;
															#line 85 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
	int i;
															#line 737 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
};
// This generated class is to be used only via killCommandActor()
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
class KillCommandActorActor final : public Actor<bool>, public ActorCallback< KillCommandActorActor, 0, Void >, public ActorCallback< KillCommandActorActor, 1, int64_t >, public ActorCallback< KillCommandActorActor, 2, int64_t >, public ActorCallback< KillCommandActorActor, 3, Void >, public FastAllocated<KillCommandActorActor>, public KillCommandActorActorState<KillCommandActorActor> {
															#line 742 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
public:
	using FastAllocated<KillCommandActorActor>::operator new;
	using FastAllocated<KillCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5032731595271236864UL, 5140951966883478784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KillCommandActorActor, 0, Void >;
friend struct ActorCallback< KillCommandActorActor, 1, int64_t >;
friend struct ActorCallback< KillCommandActorActor, 2, int64_t >;
friend struct ActorCallback< KillCommandActorActor, 3, Void >;
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
	KillCommandActorActor(Reference<IDatabase> const& db,Reference<ITransaction> const& tr,std::vector<StringRef> const& tokens,std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface) 
															#line 762 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
		 : Actor<bool>(),
		   KillCommandActorActorState<KillCommandActorActor>(db, tr, tokens, address_interface),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("killCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6231360232827298048UL, 18325841213695098624UL);
		ActorExecutionContextHelper __helper(static_cast<KillCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("killCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("killCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KillCommandActorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< KillCommandActorActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< KillCommandActorActor, 2, int64_t >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< KillCommandActorActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
[[nodiscard]] Future<bool> killCommandActor( Reference<IDatabase> const& db, Reference<ITransaction> const& tr, std::vector<StringRef> const& tokens, std::map<Key, std::pair<Value, ClientLeaderRegInterface>>* const& address_interface ) {
															#line 37 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"
	return Future<bool>(new KillCommandActorActor(db, tr, tokens, address_interface));
															#line 797 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/build_output/fdbcli/KillCommand.actor.g.cpp"
}

#line 116 "/codebuild/output/src1603528237/src/github.com/apple/foundationdb/fdbcli/KillCommand.actor.cpp"

void killGenerator(const char* text,
                   const char* line,
                   std::vector<std::string>& lc,
                   std::vector<StringRef> const& tokens) {
	const char* opts[] = { "all", "list", nullptr };
	arrayGenerator(text, line, opts, lc);
}

CommandFactory killFactory(
    "kill",
    CommandHelp(
        "kill all|list|<ADDRESS...>",
        "attempts to kill one or more processes in the cluster",
        "If no addresses are specified, populates the list of processes which can be killed. Processes cannot be "
        "killed before this list has been populated.\n\nIf `all' is specified, attempts to kill all known "
        "processes.\n\nIf `list' is specified, displays all known processes. This is only useful when the database is "
        "unresponsive.\n\nFor each IP:port pair in <ADDRESS ...>, attempt to kill the specified process."),
    &killGenerator);
} // namespace fdb_cli
