#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
/*
 * Unreadable.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct UnreadableWorkload : TestWorkload {
	static constexpr auto NAME = "Unreadable";
	uint64_t nodeCount;
	double testDuration;
	std::vector<Future<Void>> clients;

	UnreadableWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 600.0);
		nodeCount = getOption(options, "nodeCount"_sr, (uint64_t)100000);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		if (clientId == 0)
			return _start(cx, this);
		return Void();
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	static Optional<KeyRef> containsUnreadable(KeyRangeMap<bool>& unreadableMap,
	                                           KeyRangeRef const& range,
	                                           bool forward) {
		auto unreadableRanges = unreadableMap.intersectingRanges(range);

		if (forward) {
			for (auto it : unreadableRanges) {
				if (it.value()) {
					//TraceEvent("RYWT_CheckingRange1").detail("Range", printable(range)).detail("UnreadableRange", printable(it.range()));
					return it.range().begin;
				}
			}
		} else {
			auto it = unreadableRanges.end();
			auto itEnd = unreadableRanges.begin();
			--it;
			--itEnd;

			for (; it != itEnd; --it) {
				if (it.value()) {
					//TraceEvent("RYWT_CheckingRange2").detail("Range", printable(range)).detail("UnreadableRange", printable(it.range()));
					return it.range().end;
				}
			}
		}
		return Optional<KeyRef>();
	}

	static void resolveKeySelector(std::map<KeyRef, ValueRef> const& setMap,
	                               KeyRangeMap<bool>& unreadableMap,
	                               KeySelector& key) {
		ASSERT(!key.orEqual);
		if (key.offset == 1)
			return;

		auto it = setMap.lower_bound(key.getKey());

		if (key.offset >= 1) {
			auto unreadable = containsUnreadable(unreadableMap, KeyRangeRef(key.getKey(), it->first), true);
			if (unreadable.present()) {
				key.setKey(unreadable.get());
				return;
			}
			key.setKey(it->first);
		}

		while (key.offset < 1 && it->first != normalKeys.begin) {
			--it;

			auto unreadable = containsUnreadable(unreadableMap, KeyRangeRef(it->first, key.getKey()), false);
			if (unreadable.present()) {
				key.setKey(unreadable.get());
				return;
			}

			key.setKey(it->first);
			++key.offset;
		}
		while (key.offset > 1 && it->first != normalKeys.end) {
			++it;

			auto unreadable = containsUnreadable(unreadableMap, KeyRangeRef(key.getKey(), it->first), true);
			if (unreadable.present()) {
				if (unreadable.get() > key.getKey())
					--key.offset;
				key.setKey(unreadable.get());
				return;
			}

			key.setKey(it->first);
			--key.offset;
		}

		key.setKey(it->first);
	}

	static void checkUnreadability(std::map<KeyRef, ValueRef> const& setMap,
	                               KeyRangeMap<bool>& unreadableMap,
	                               KeySelectorRef const& _begin,
	                               KeySelectorRef const& _end,
	                               bool isUnreadable,
	                               int limit,
	                               Reverse reverse) {

		/*
		for (auto it : setMap) {
		    TraceEvent("RYWT_SetMapContents").detail("Key", printable(it.first));
		}

		for (auto it : unreadableMap.ranges()) {
		    TraceEvent("RYWT_UnreadableMapContents").detail("Key", printable(it.range())).detail("Value", it.value());
		}
		*/

		KeySelector begin = _begin;
		KeySelector end = _end;

		begin.removeOrEqual(begin.arena());
		end.removeOrEqual(end.arena());

		if (begin.offset >= end.offset && begin.getKey() >= end.getKey()) {
			ASSERT(isUnreadable == false);
			return;
		}

		//TraceEvent("RYWT_CheckUnreadability").detail("Begin", begin.toString()).detail("End", end.toString());

		KeySelector resolvedBegin = begin;
		KeySelector resolvedEnd = end;

		resolveKeySelector(setMap, unreadableMap, resolvedBegin);
		resolveKeySelector(setMap, unreadableMap, resolvedEnd);

		//TraceEvent("RYWT_CheckUnreadability2").detail("ResolvedBegin", resolvedBegin.toString()).detail("ResolvedEnd", resolvedEnd.toString());

		if ((resolvedBegin.offset >= resolvedEnd.offset && resolvedBegin.getKey() >= resolvedEnd.getKey()) ||
		    (resolvedBegin.offset >= end.offset && resolvedBegin.getKey() >= end.getKey()) ||
		    (begin.offset >= resolvedEnd.offset && begin.getKey() >= resolvedEnd.getKey())) {
			// RYW does not perfectly optimize this scenario, it should be readable but might unnecessarily return as
			// unreadable
			return;
		}

		if (resolvedEnd.getKey() == normalKeys.begin || resolvedBegin.getKey() == normalKeys.end) {
			// RYW does not perfectly optimize this scenario, it should be readable but might unnecessarily return as
			// unreadable
			return;
		}

		bool beginUnreadable = resolvedBegin.offset != 1 && resolvedBegin.getKey() != normalKeys.begin;
		bool endUnreadable = resolvedEnd.offset != 1 && resolvedEnd.getKey() != normalKeys.end;

		if (!reverse && !beginUnreadable) {
			int itemCount = resolvedBegin.getKey() == normalKeys.begin ? 0 : 1;
			itemCount += std::min(0, resolvedEnd.offset - 1);
			auto setItem = setMap.lower_bound(resolvedBegin.getKey());

			while (itemCount < limit && setItem->first != normalKeys.end) {
				++setItem;
				++itemCount;
			}

			//TraceEvent("RYWT_ModifiedEnd").detail("SetItem", printable(setItem->first)).detail("ResolvedEnd", printable(resolvedEnd.getKey())).detail("Limit", limit).detail("ItemCount", resolvedBegin.getKey() == normalKeys.begin ? 0 : 1 + std::min(0, resolvedEnd.offset - 1));

			KeyRef keyAfterSet = keyAfter(setItem->first, resolvedEnd.arena());
			if (keyAfterSet <= resolvedEnd.getKey()) {
				if (std::max(begin.getKey(), resolvedBegin.getKey()) > std::min(end.getKey(), resolvedEnd.getKey())) {
					// RYW might have to resolve the key selector anyways in this scenario, even though the limit should
					// make this unnecessary.
					return;
				}

				if (end.offset < resolvedEnd.offset && end.offset < 1) {
					int itemCount2 = resolvedBegin.getKey() == normalKeys.begin ? 0 : 1;
					itemCount2 += std::min(0, end.offset - 1);
					auto setItem2 = setMap.lower_bound(resolvedBegin.getKey());

					while (itemCount2 < limit && setItem2->first != normalKeys.end) {
						++setItem2;
						++itemCount2;
					}

					Key keyAfterSet2 = keyAfter(setItem2->first);
					if (containsUnreadable(unreadableMap, KeyRangeRef(keyAfterSet, keyAfterSet2), true).present()) {
						// RYW might not have resolved the end selector
						return;
					}
				}

				resolvedEnd.setKey(keyAfterSet);
				resolvedEnd.offset = 1;
				endUnreadable = false;
			}
		} else if (reverse && !endUnreadable) {
			int itemCount = 0;
			itemCount -= std::max(0, resolvedBegin.offset - 1);
			auto setItem = setMap.lower_bound(resolvedEnd.getKey());
			while (itemCount < limit && setItem->first != normalKeys.begin) {
				--setItem;
				++itemCount;
			}

			//TraceEvent("RYWT_ModifiedBegin").detail("SetItem", printable(setItem->first)).detail("ResolvedBegin", printable(resolvedBegin.getKey())).detail("Limit", limit).detail("ItemCount", -1*std::max(0, resolvedBegin.offset - 1));

			if (setItem->first >= resolvedBegin.getKey()) {
				if (std::max(begin.getKey(), resolvedBegin.getKey()) > std::min(end.getKey(), resolvedEnd.getKey())) {
					// RYW might have to resolve the key selector anyways in this scenario, even though the limit should
					// make this unnecessary.
					return;
				}

				if (begin.offset > resolvedBegin.offset && begin.offset > 1) {
					int itemCount2 = 0;
					itemCount2 -= std::max(0, begin.offset - 1);
					auto setItem2 = setMap.lower_bound(resolvedEnd.getKey());

					while (itemCount2 < limit && setItem2->first != normalKeys.begin) {
						--setItem2;
						++itemCount2;
					}

					if (containsUnreadable(unreadableMap, KeyRangeRef(setItem2->first, setItem->first), true)
					        .present()) {
						// RYW might not have resolved the begin selector
						return;
					}
				}

				resolvedBegin.setKey(setItem->first);
				resolvedBegin.offset = 1;
				beginUnreadable = false;
			}
		}

		if (beginUnreadable || endUnreadable) {
			ASSERT(isUnreadable == true);
			return;
		}

		if (!reverse && resolvedEnd.getKey() != normalKeys.end &&
		    std::max(begin.getKey(), resolvedBegin.getKey()) > std::min(end.getKey(), resolvedEnd.getKey()) &&
		    !end.isFirstGreaterOrEqual()) {
			auto setNext = setMap.lower_bound(resolvedEnd.getKey());
			auto unreadableRanges = unreadableMap.intersectingRanges(KeyRangeRef(resolvedEnd.getKey(), normalKeys.end));
			KeyRef unreadableNext = normalKeys.end;
			for (auto it : unreadableRanges) {
				if (it.value()) {
					unreadableNext = it.begin();
					break;
				}
			}

			//TraceEvent("RYWT_CheckUnreadability3").detail("SetNext", printable(setNext->first)).detail("UnreadableNext", printable(unreadableNext));
			if (setNext->first >= unreadableNext) {
				// RYW resolves the end key selector, even though it does not need the exact key to answer the query.
				return;
			}
		}

		ASSERT(isUnreadable ==
		       containsUnreadable(unreadableMap, KeyRangeRef(resolvedBegin.getKey(), resolvedEnd.getKey()), true)
		           .present());
	}

																#line 297 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 295 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
template <class _startActor>
															#line 295 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
class _startActorState {
															#line 303 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
public:
															#line 295 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	_startActorState(Database const& cx,UnreadableWorkload* const& self) 
															#line 295 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
															#line 295 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		 : cx(cx),
															#line 295 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		   self(self),
															#line 296 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		   testCount(0),
															#line 297 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		   reverse(Reverse::False),
															#line 298 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		   snapshot(Snapshot::False)
															#line 318 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 299 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			;
															#line 333 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 473 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 356 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 299 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (!(testCount < 100))
															#line 375 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 301 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 302 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		arena = Arena();
															#line 304 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		setMap = std::map<KeyRef, ValueRef>();
															#line 305 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		unreadableMap = KeyRangeMap<bool>();
															#line 307 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		opCount = 0;
															#line 308 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		range = KeyRangeRef();
															#line 309 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		key = KeyRef();
															#line 310 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		value = ValueRef();
															#line 311 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		limit = int();
															#line 312 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		begin = KeySelectorRef();
															#line 313 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		end = KeySelectorRef();
															#line 314 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		bypassUnreadable = deterministicRandom()->coinflip();
															#line 315 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (bypassUnreadable)
															#line 405 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
															#line 316 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			tr.setOption(FDBTransactionOptions::BYPASS_UNREADABLE);
															#line 409 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		}
															#line 319 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		setMap[normalKeys.begin] = ValueRef();
															#line 320 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		setMap[normalKeys.end] = ValueRef();
															#line 322 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		;
															#line 417 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 299 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		testCount++;
															#line 439 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 322 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (!(opCount < 500))
															#line 455 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 323 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		int r = deterministicRandom()->randomInt(0, 19);
															#line 324 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (r <= 10)
															#line 463 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
															#line 325 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			key = RandomTestImpl::getRandomKey(arena);
															#line 326 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			value = RandomTestImpl::getRandomValue(arena);
															#line 327 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			tr.set(key, value);
															#line 328 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap[key] = value;
															#line 473 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);
		}
		else
		{
															#line 330 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			if (r == 11)
															#line 480 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			{
															#line 331 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				range = RandomTestImpl::getRandomRange(arena);
															#line 332 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				tr.addReadConflictRange(range);
															#line 486 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);
			}
			else
			{
															#line 334 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				if (r == 12)
															#line 493 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
				{
															#line 335 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
					range = RandomTestImpl::getRandomRange(arena);
															#line 336 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
					tr.addWriteConflictRange(range);
															#line 499 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
					loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);
				}
				else
				{
															#line 338 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
					if (r == 13)
															#line 506 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
					{
															#line 339 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
						range = RandomTestImpl::getRandomRange(arena);
															#line 340 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
						tr.clear(range);
															#line 341 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
						unreadableMap.insert(range, false);
															#line 342 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
						setMap.erase(setMap.lower_bound(range.begin), setMap.lower_bound(range.end));
															#line 516 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
						loopDepth = a_body1loopBody1loopBody1cont8(loopDepth);
					}
					else
					{
															#line 344 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
						if (r == 14)
															#line 523 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
						{
															#line 345 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
							key = RandomTestImpl::getRandomKey(arena);
															#line 346 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
							value = RandomTestImpl::getRandomVersionstampValue(arena);
															#line 347 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
							tr.atomicOp(key, value, MutationRef::SetVersionstampedValue);
															#line 348 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
							unreadableMap.insert(key, true);
															#line 533 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
							loopDepth = a_body1loopBody1loopBody1cont10(loopDepth);
						}
						else
						{
															#line 350 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
							if (r == 15)
															#line 540 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
							{
															#line 351 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
								key = RandomTestImpl::getRandomVersionstampKey(arena);
															#line 352 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
								value = RandomTestImpl::getRandomValue(arena);
															#line 353 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
								tr.atomicOp(key, value, MutationRef::SetVersionstampedKey);
															#line 354 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
								range = getVersionstampKeyRange(arena, key, tr.getCachedReadVersion(), allKeys.end);
															#line 355 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
								unreadableMap.insert(range, true);
															#line 552 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
								loopDepth = a_body1loopBody1loopBody1cont12(loopDepth);
							}
							else
							{
															#line 357 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
								if (r == 16)
															#line 559 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
								{
															#line 358 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
									range = RandomTestImpl::getRandomRange(arena);
															#line 359 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
									snapshot.set(deterministicRandom()->random01() < 0.05);
															#line 360 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
									reverse.set(deterministicRandom()->coinflip());
															#line 362 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
									if (snapshot)
															#line 569 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
									{
															#line 363 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
										tr.setOption(FDBTransactionOptions::SNAPSHOT_RYW_DISABLE);
															#line 573 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
									}
															#line 365 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
									StrictFuture<ErrorOr<RangeResult>> __when_expr_0 = errorOr(tr.getRange(range, CLIENT_KNOBS->TOO_MANY, snapshot, reverse));
															#line 365 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
									if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 579 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
									if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
									static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 365 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
									__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, ErrorOr<RangeResult> >*>(static_cast<_startActor*>(this)));
															#line 584 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
									loopDepth = 0;
								}
								else
								{
															#line 390 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
									if (r == 17)
															#line 591 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
									{
															#line 391 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
										begin = RandomTestImpl::getRandomKeySelector(arena);
															#line 392 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
										end = RandomTestImpl::getRandomKeySelector(arena);
															#line 393 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
										limit = deterministicRandom()->randomInt(1, 100);
															#line 394 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
										snapshot.set(deterministicRandom()->random01() < 0.05);
															#line 395 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
										reverse.set(deterministicRandom()->coinflip());
															#line 397 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
										if (snapshot)
															#line 605 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
										{
															#line 398 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
											tr.setOption(FDBTransactionOptions::SNAPSHOT_RYW_DISABLE);
															#line 609 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
										}
															#line 401 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
										StrictFuture<ErrorOr<RangeResult>> __when_expr_1 = errorOr(tr.getRange(begin, end, limit, snapshot, reverse));
															#line 401 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
										if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 615 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
										if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when2(__when_expr_1.get(), loopDepth); };
										static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 401 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
										__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, ErrorOr<RangeResult> >*>(static_cast<_startActor*>(this)));
															#line 620 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
										loopDepth = 0;
									}
									else
									{
															#line 437 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
										if (r == 18)
															#line 627 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
										{
															#line 438 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
											key = RandomTestImpl::getRandomKey(arena);
															#line 439 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
											snapshot.set(deterministicRandom()->random01() < 0.05);
															#line 441 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
											if (snapshot)
															#line 635 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
											{
															#line 442 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
												tr.setOption(FDBTransactionOptions::SNAPSHOT_RYW_DISABLE);
															#line 639 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
											}
															#line 444 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
											StrictFuture<ErrorOr<Optional<Value>>> __when_expr_2 = errorOr(tr.get(key, snapshot));
															#line 444 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
											if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 645 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
											if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1when3(__when_expr_2.get(), loopDepth); };
											static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 444 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
											__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, ErrorOr<Optional<Value>> >*>(static_cast<_startActor*>(this)));
															#line 650 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
											loopDepth = 0;
										}
										else
										{
											loopDepth = a_body1loopBody1loopBody1cont20(loopDepth);
										}
									}
								}
							}
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 322 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		opCount++;
															#line 685 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont10(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont14(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont15(ErrorOr<RangeResult> const& value,int loopDepth) 
	{
															#line 368 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (snapshot)
															#line 730 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
															#line 369 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			tr.setOption(FDBTransactionOptions::SNAPSHOT_RYW_ENABLE);
															#line 734 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		}
															#line 370 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (!value.isError() || value.getError().code() == error_code_accessed_unreadable)
															#line 738 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
															#line 372 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			if (snapshot)
															#line 742 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			{
															#line 373 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				ASSERT(!value.isError());
															#line 746 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
			else
			{
															#line 375 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				ASSERT(containsUnreadable(unreadableMap, range, true).present() == value.isError());
															#line 752 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 379 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap = std::map<KeyRef, ValueRef>();
															#line 380 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			unreadableMap = KeyRangeMap<bool>();
															#line 381 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			tr = ReadYourWritesTransaction(cx);
															#line 382 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			if (bypassUnreadable)
															#line 765 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			{
															#line 383 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				tr.setOption(FDBTransactionOptions::BYPASS_UNREADABLE);
															#line 769 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
															#line 385 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			arena = Arena();
															#line 387 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap[normalKeys.begin] = ValueRef();
															#line 388 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap[normalKeys.end] = ValueRef();
															#line 777 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont15(ErrorOr<RangeResult> && value,int loopDepth) 
	{
															#line 368 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (snapshot)
															#line 787 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
															#line 369 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			tr.setOption(FDBTransactionOptions::SNAPSHOT_RYW_ENABLE);
															#line 791 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		}
															#line 370 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (!value.isError() || value.getError().code() == error_code_accessed_unreadable)
															#line 795 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
															#line 372 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			if (snapshot)
															#line 799 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			{
															#line 373 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				ASSERT(!value.isError());
															#line 803 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
			else
			{
															#line 375 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				ASSERT(containsUnreadable(unreadableMap, range, true).present() == value.isError());
															#line 809 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 379 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap = std::map<KeyRef, ValueRef>();
															#line 380 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			unreadableMap = KeyRangeMap<bool>();
															#line 381 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			tr = ReadYourWritesTransaction(cx);
															#line 382 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			if (bypassUnreadable)
															#line 822 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			{
															#line 383 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				tr.setOption(FDBTransactionOptions::BYPASS_UNREADABLE);
															#line 826 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
															#line 385 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			arena = Arena();
															#line 387 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap[normalKeys.begin] = ValueRef();
															#line 388 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap[normalKeys.end] = ValueRef();
															#line 834 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(ErrorOr<RangeResult> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont15(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(ErrorOr<RangeResult> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont15(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, ErrorOr<RangeResult> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, ErrorOr<RangeResult> >*,ErrorOr<RangeResult> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, ErrorOr<RangeResult> >*,ErrorOr<RangeResult> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, ErrorOr<RangeResult> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont17(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont18(ErrorOr<RangeResult> const& value,int loopDepth) 
	{
															#line 403 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (snapshot)
															#line 925 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
															#line 404 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			tr.setOption(FDBTransactionOptions::SNAPSHOT_RYW_ENABLE);
															#line 929 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		}
															#line 405 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		bool isUnreadable = value.isError() && value.getError().code() == error_code_accessed_unreadable;
															#line 406 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (!value.isError() || value.getError().code() == error_code_accessed_unreadable)
															#line 935 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
															#line 419 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			if (snapshot)
															#line 939 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			{
															#line 420 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				ASSERT(!isUnreadable);
															#line 943 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
			else
			{
															#line 422 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				checkUnreadability(setMap, unreadableMap, begin, end, isUnreadable, limit, reverse);
															#line 949 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 426 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap = std::map<KeyRef, ValueRef>();
															#line 427 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			unreadableMap = KeyRangeMap<bool>();
															#line 428 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			tr = ReadYourWritesTransaction(cx);
															#line 429 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			if (bypassUnreadable)
															#line 962 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			{
															#line 430 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				tr.setOption(FDBTransactionOptions::BYPASS_UNREADABLE);
															#line 966 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
															#line 432 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			arena = Arena();
															#line 434 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap[normalKeys.begin] = ValueRef();
															#line 435 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap[normalKeys.end] = ValueRef();
															#line 974 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont18(ErrorOr<RangeResult> && value,int loopDepth) 
	{
															#line 403 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (snapshot)
															#line 984 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
															#line 404 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			tr.setOption(FDBTransactionOptions::SNAPSHOT_RYW_ENABLE);
															#line 988 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		}
															#line 405 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		bool isUnreadable = value.isError() && value.getError().code() == error_code_accessed_unreadable;
															#line 406 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (!value.isError() || value.getError().code() == error_code_accessed_unreadable)
															#line 994 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
															#line 419 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			if (snapshot)
															#line 998 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			{
															#line 420 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				ASSERT(!isUnreadable);
															#line 1002 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
			else
			{
															#line 422 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				checkUnreadability(setMap, unreadableMap, begin, end, isUnreadable, limit, reverse);
															#line 1008 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 426 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap = std::map<KeyRef, ValueRef>();
															#line 427 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			unreadableMap = KeyRangeMap<bool>();
															#line 428 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			tr = ReadYourWritesTransaction(cx);
															#line 429 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			if (bypassUnreadable)
															#line 1021 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			{
															#line 430 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				tr.setOption(FDBTransactionOptions::BYPASS_UNREADABLE);
															#line 1025 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
															#line 432 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			arena = Arena();
															#line 434 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap[normalKeys.begin] = ValueRef();
															#line 435 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap[normalKeys.end] = ValueRef();
															#line 1033 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(ErrorOr<RangeResult> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont18(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when2(ErrorOr<RangeResult> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont18(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, ErrorOr<RangeResult> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, ErrorOr<RangeResult> >*,ErrorOr<RangeResult> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, ErrorOr<RangeResult> >*,ErrorOr<RangeResult> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, ErrorOr<RangeResult> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont20(int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont17(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont21(ErrorOr<Optional<Value>> const& value,int loopDepth) 
	{
															#line 446 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (snapshot)
															#line 1124 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
															#line 447 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			tr.setOption(FDBTransactionOptions::SNAPSHOT_RYW_ENABLE);
															#line 1128 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		}
															#line 449 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (!value.isError() || value.getError().code() == error_code_accessed_unreadable)
															#line 1132 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
															#line 451 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			if (snapshot || bypassUnreadable)
															#line 1136 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			{
															#line 452 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				ASSERT(!value.isError());
															#line 1140 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
			else
			{
															#line 454 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				ASSERT(unreadableMap[key] == value.isError());
															#line 1146 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 458 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap = std::map<KeyRef, ValueRef>();
															#line 459 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			unreadableMap = KeyRangeMap<bool>();
															#line 460 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			tr = ReadYourWritesTransaction(cx);
															#line 461 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			if (bypassUnreadable)
															#line 1159 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			{
															#line 462 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				tr.setOption(FDBTransactionOptions::BYPASS_UNREADABLE);
															#line 1163 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
															#line 464 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			arena = Arena();
															#line 466 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap[normalKeys.begin] = ValueRef();
															#line 467 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap[normalKeys.end] = ValueRef();
															#line 1171 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont21(ErrorOr<Optional<Value>> && value,int loopDepth) 
	{
															#line 446 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (snapshot)
															#line 1181 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
															#line 447 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			tr.setOption(FDBTransactionOptions::SNAPSHOT_RYW_ENABLE);
															#line 1185 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		}
															#line 449 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
		if (!value.isError() || value.getError().code() == error_code_accessed_unreadable)
															#line 1189 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		{
															#line 451 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			if (snapshot || bypassUnreadable)
															#line 1193 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			{
															#line 452 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				ASSERT(!value.isError());
															#line 1197 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
			else
			{
															#line 454 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				ASSERT(unreadableMap[key] == value.isError());
															#line 1203 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
		}
		else
		{
															#line 458 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap = std::map<KeyRef, ValueRef>();
															#line 459 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			unreadableMap = KeyRangeMap<bool>();
															#line 460 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			tr = ReadYourWritesTransaction(cx);
															#line 461 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			if (bypassUnreadable)
															#line 1216 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			{
															#line 462 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
				tr.setOption(FDBTransactionOptions::BYPASS_UNREADABLE);
															#line 1220 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
			}
															#line 464 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			arena = Arena();
															#line 466 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap[normalKeys.begin] = ValueRef();
															#line 467 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
			setMap[normalKeys.end] = ValueRef();
															#line 1228 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1loopBody1cont20(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(ErrorOr<Optional<Value>> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont21(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when3(ErrorOr<Optional<Value>> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont21(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, ErrorOr<Optional<Value>> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, ErrorOr<Optional<Value>> >*,ErrorOr<Optional<Value>> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, ErrorOr<Optional<Value>> >*,ErrorOr<Optional<Value>> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, ErrorOr<Optional<Value>> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 295 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	Database cx;
															#line 295 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	UnreadableWorkload* self;
															#line 296 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	int testCount;
															#line 297 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	Reverse reverse;
															#line 298 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	Snapshot snapshot;
															#line 301 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 302 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	Arena arena;
															#line 304 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	std::map<KeyRef, ValueRef> setMap;
															#line 305 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	KeyRangeMap<bool> unreadableMap;
															#line 307 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	int opCount;
															#line 308 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	KeyRangeRef range;
															#line 309 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	KeyRef key;
															#line 310 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	ValueRef value;
															#line 311 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	int limit;
															#line 312 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	KeySelectorRef begin;
															#line 313 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	KeySelectorRef end;
															#line 314 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	bool bypassUnreadable;
															#line 1343 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 295 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, ErrorOr<RangeResult> >, public ActorCallback< _startActor, 1, ErrorOr<RangeResult> >, public ActorCallback< _startActor, 2, ErrorOr<Optional<Value>> >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1348 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2630944760405069312UL, 13107452538538808064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, ErrorOr<RangeResult> >;
friend struct ActorCallback< _startActor, 1, ErrorOr<RangeResult> >;
friend struct ActorCallback< _startActor, 2, ErrorOr<Optional<Value>> >;
															#line 295 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	_startActor(Database const& cx,UnreadableWorkload* const& self) 
															#line 1367 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, ErrorOr<RangeResult> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, ErrorOr<RangeResult> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, ErrorOr<Optional<Value>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 295 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, UnreadableWorkload* const& self ) {
															#line 295 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1401 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Unreadable.actor.g.cpp.py_gen"
}

#line 475 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/Unreadable.actor.cpp"
};

WorkloadFactory<UnreadableWorkload> UnreadableWorkloadFactory;
