#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
/*
 * SidebandSingle.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/Knobs.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

/*
 * This workload is modelled off the Sideband workload, except it uses a single
 * mutator and checker rather than several. In addition to ordinary consistency checks,
 * it also checks the consistency of the cached read versions when using the
 * USE_GRV_CACHE transaction option, specifically when commit_unknown_result
 * produces a maybe/maybe-not written scenario. It makes sure that a cached read of an
 * unknown result matches the regular read of that same key and is not too stale.
 */

struct SidebandSingleWorkload : TestWorkload {
	static constexpr auto NAME = "SidebandSingle";

	double testDuration, operationsPerSecond;
	// Pair represents <Key, commitVersion>
	PromiseStream<std::pair<uint64_t, Version>> interf;

	std::vector<Future<Void>> clients;
	PerfIntCounter messages, consistencyErrors, keysUnexpectedlyPresent;

	SidebandSingleWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), messages("Messages"), consistencyErrors("Causal Consistency Errors"),
	    keysUnexpectedlyPresent("KeysUnexpectedlyPresent") {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		operationsPerSecond = getOption(options, "operationsPerSecond"_sr, 50.0);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }
	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();

		clients.push_back(mutator(this, cx));
		clients.push_back(checker(this, cx));
		return delay(testDuration);
	}
	Future<bool> check(Database const& cx) override {
		if (clientId != 0)
			return true;
		int errors = 0;
		for (int c = 0; c < clients.size(); c++) {
			errors += clients[c].isError();
		}
		if (errors)
			TraceEvent(SevError, "TestFailure").detail("Reason", "There were client errors.");
		clients.clear();
		if (consistencyErrors.getValue())
			TraceEvent(SevError, "TestFailure").detail("Reason", "There were causal consistency errors.");
		return !errors && !consistencyErrors.getValue();
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(messages.getMetric());
		m.push_back(consistencyErrors.getMetric());
		m.push_back(keysUnexpectedlyPresent.getMetric());
	}

																#line 85 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
// This generated class is to be used only via mutator()
															#line 83 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
template <class MutatorActor>
															#line 83 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
class MutatorActorState {
															#line 91 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
public:
															#line 83 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	MutatorActorState(SidebandSingleWorkload* const& self,Database const& cx) 
															#line 83 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
															#line 83 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		 : self(self),
															#line 83 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		   cx(cx),
															#line 84 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		   lastTime(now()),
															#line 85 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		   commitVersion(),
															#line 86 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		   unknown(false)
															#line 106 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("mutator", reinterpret_cast<unsigned long>(this));

	}
	~MutatorActorState() 
	{
		fdb_probe_actor_destroy("mutator", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 88 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			;
															#line 121 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MutatorActorState();
		static_cast<MutatorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 89 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, 1.0 / self->operationsPerSecond);
															#line 89 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		if (static_cast<MutatorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 153 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MutatorActor*>(this)->actor_wait_state = 1;
															#line 89 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MutatorActor, 0, Void >*>(static_cast<MutatorActor*>(this)));
															#line 158 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 90 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		tr0 = Transaction(cx);
															#line 91 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		tr = Transaction(cx);
															#line 92 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		key = deterministicRandom()->randomUniqueID().hash();
															#line 94 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		messageKey = Standalone<StringRef>(format("Sideband/Message/%llx", key));
															#line 96 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		;
															#line 175 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 90 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		tr0 = Transaction(cx);
															#line 91 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		tr = Transaction(cx);
															#line 92 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		key = deterministicRandom()->randomUniqueID().hash();
															#line 94 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		messageKey = Standalone<StringRef>(format("Sideband/Message/%llx", key));
															#line 96 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		;
															#line 192 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MutatorActor*>(this)->actor_wait_state > 0) static_cast<MutatorActor*>(this)->actor_wait_state = 0;
		static_cast<MutatorActor*>(this)->ActorCallback< MutatorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutatorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MutatorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MutatorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 106 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		;
															#line 276 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 98 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			tr0.set(messageKey, "oldbeef"_sr);
															#line 99 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr0.commit();
															#line 99 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			if (static_cast<MutatorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 297 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<MutatorActor*>(this)->actor_wait_state = 2;
															#line 99 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< MutatorActor, 1, Void >*>(static_cast<MutatorActor*>(this)));
															#line 302 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 102 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr0.onError(e);
															#line 102 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			if (static_cast<MutatorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 339 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<MutatorActor*>(this)->actor_wait_state = 3;
															#line 102 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< MutatorActor, 2, Void >*>(static_cast<MutatorActor*>(this)));
															#line 344 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<MutatorActor*>(this)->actor_wait_state > 0) static_cast<MutatorActor*>(this)->actor_wait_state = 0;
		static_cast<MutatorActor*>(this)->ActorCallback< MutatorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutatorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< MutatorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< MutatorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<MutatorActor*>(this)->actor_wait_state > 0) static_cast<MutatorActor*>(this)->actor_wait_state = 0;
		static_cast<MutatorActor*>(this)->ActorCallback< MutatorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutatorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< MutatorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< MutatorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 122 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		if (unknown)
															#line 533 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		{
															#line 123 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			unknown = false;
															#line 537 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 126 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		++self->messages;
															#line 127 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		self->interf.send(std::pair(key, commitVersion));
															#line 544 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 108 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			tr.set(messageKey, "deadbeef"_sr);
															#line 109 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.commit();
															#line 109 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			if (static_cast<MutatorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 565 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<MutatorActor*>(this)->actor_wait_state = 4;
															#line 109 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< MutatorActor, 3, Void >*>(static_cast<MutatorActor*>(this)));
															#line 570 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			if (e.code() == error_code_commit_unknown_result)
															#line 605 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			{
															#line 114 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
				unknown = true;
															#line 115 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
				++self->messages;
															#line 116 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
				self->interf.send(std::pair(key, invalidVersion));
															#line 613 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
				return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
			}
															#line 119 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 119 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			if (static_cast<MutatorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 620 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont2loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<MutatorActor*>(this)->actor_wait_state = 5;
															#line 119 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< MutatorActor, 4, Void >*>(static_cast<MutatorActor*>(this)));
															#line 625 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 110 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		commitVersion = tr.getCommittedVersion();
															#line 640 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 110 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		commitVersion = tr.getCommittedVersion();
															#line 649 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<MutatorActor*>(this)->actor_wait_state > 0) static_cast<MutatorActor*>(this)->actor_wait_state = 0;
		static_cast<MutatorActor*>(this)->ActorCallback< MutatorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutatorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< MutatorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< MutatorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<MutatorActor*>(this)->actor_wait_state > 0) static_cast<MutatorActor*>(this)->actor_wait_state = 0;
		static_cast<MutatorActor*>(this)->ActorCallback< MutatorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MutatorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< MutatorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< MutatorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 83 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	SidebandSingleWorkload* self;
															#line 83 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	Database cx;
															#line 84 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	double lastTime;
															#line 85 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	Version commitVersion;
															#line 86 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	bool unknown;
															#line 90 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	Transaction tr0;
															#line 91 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	Transaction tr;
															#line 92 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	uint64_t key;
															#line 94 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	Standalone<StringRef> messageKey;
															#line 834 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
};
// This generated class is to be used only via mutator()
															#line 83 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
class MutatorActor final : public Actor<Void>, public ActorCallback< MutatorActor, 0, Void >, public ActorCallback< MutatorActor, 1, Void >, public ActorCallback< MutatorActor, 2, Void >, public ActorCallback< MutatorActor, 3, Void >, public ActorCallback< MutatorActor, 4, Void >, public FastAllocated<MutatorActor>, public MutatorActorState<MutatorActor> {
															#line 839 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
public:
	using FastAllocated<MutatorActor>::operator new;
	using FastAllocated<MutatorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6764289891796379136UL, 10409049686224290560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MutatorActor, 0, Void >;
friend struct ActorCallback< MutatorActor, 1, Void >;
friend struct ActorCallback< MutatorActor, 2, Void >;
friend struct ActorCallback< MutatorActor, 3, Void >;
friend struct ActorCallback< MutatorActor, 4, Void >;
															#line 83 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	MutatorActor(SidebandSingleWorkload* const& self,Database const& cx) 
															#line 860 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MutatorActorState<MutatorActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("mutator", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5815853074451583744UL, 2307273088879991296UL);
		ActorExecutionContextHelper __helper(static_cast<MutatorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("mutator");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("mutator", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MutatorActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< MutatorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< MutatorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< MutatorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< MutatorActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 83 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
[[nodiscard]] Future<Void> mutator( SidebandSingleWorkload* const& self, Database const& cx ) {
															#line 83 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	return Future<Void>(new MutatorActor(self, cx));
															#line 896 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
}

#line 130 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"

																#line 901 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
// This generated class is to be used only via checker()
															#line 131 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
template <class CheckerActor>
															#line 131 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
class CheckerActorState {
															#line 907 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
public:
															#line 131 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	CheckerActorState(SidebandSingleWorkload* const& self,Database const& cx) 
															#line 131 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
															#line 131 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		 : self(self),
															#line 131 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		   cx(cx)
															#line 916 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checker", reinterpret_cast<unsigned long>(this));

	}
	~CheckerActorState() 
	{
		fdb_probe_actor_destroy("checker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 136 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			cx->initSharedState();
															#line 137 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			;
															#line 933 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckerActorState();
		static_cast<CheckerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 139 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		auto __when_expr_0 = self->interf.getFuture();
															#line 963 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		static_assert(std::is_same<decltype(__when_expr_0), FutureStream<std::pair<uint64_t, Version>>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<std::pair<uint64_t, Version>>>::value, "invalid type");
															#line 139 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		if (static_cast<CheckerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 967 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
		static_cast<CheckerActor*>(this)->actor_wait_state = 1;
															#line 139 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< CheckerActor, 0, std::pair<uint64_t, Version> >*>(static_cast<CheckerActor*>(this)));
															#line 972 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 140 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		messageKey = Standalone<StringRef>(format("Sideband/Message/%llx", message.first));
															#line 141 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		tr = Transaction(cx);
															#line 142 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		;
															#line 985 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::pair<uint64_t, Version> const& __message,int loopDepth) 
	{
															#line 139 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		message = __message;
															#line 994 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::pair<uint64_t, Version> && __message,int loopDepth) 
	{
		message = std::move(__message);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckerActor*>(this)->actor_wait_state > 0) static_cast<CheckerActor*>(this)->actor_wait_state = 0;
		static_cast<CheckerActor*>(this)->ActorSingleCallback< CheckerActor, 0, std::pair<uint64_t, Version> >::remove();

	}
	void a_callback_fire(ActorSingleCallback< CheckerActor, 0, std::pair<uint64_t, Version> >*,std::pair<uint64_t, Version> const& value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< CheckerActor, 0, std::pair<uint64_t, Version> >*,std::pair<uint64_t, Version> && value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< CheckerActor, 0, std::pair<uint64_t, Version> >*,Error err) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 144 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			tr.setOption(FDBTransactionOptions::USE_GRV_CACHE);
															#line 145 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(messageKey);
															#line 145 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			if (static_cast<CheckerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1091 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckerActor*>(this)->actor_wait_state = 2;
															#line 145 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckerActor, 1, Optional<Value> >*>(static_cast<CheckerActor*>(this)));
															#line 1096 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 187 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			TraceEvent("DebugSidebandCheckError").errorUnsuppressed(e);
															#line 188 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 188 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			if (static_cast<CheckerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1135 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CheckerActor*>(this)->actor_wait_state = 5;
															#line 188 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckerActor, 4, Void >*>(static_cast<CheckerActor*>(this)));
															#line 1140 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(int loopDepth) 
	{
															#line 146 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		if (!val.present())
															#line 1155 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		{
															#line 147 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			TraceEvent(SevError, "CausalConsistencyError1") .detail("MessageKey", messageKey.toString().c_str()) .detail("RemoteCommitVersion", message.second) .detail("LocalReadVersion", tr.getReadVersion().get());
															#line 152 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			++self->consistencyErrors;
															#line 1161 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1cont1loopBody1cont3(loopDepth);
		}
		else
		{
															#line 153 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			if (val.get() != "deadbeef"_sr)
															#line 1168 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			{
															#line 156 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
				if (message.second != invalidVersion)
															#line 1172 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
				{
															#line 157 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
					TraceEvent(SevError, "CausalConsistencyError2") .detail("MessageKey", messageKey.toString().c_str());
															#line 159 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
					++self->consistencyErrors;
															#line 1178 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
					return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
				}
															#line 163 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
				tr2 = Transaction(cx);
															#line 164 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
				val2 = Optional<Value>();
															#line 165 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
				;
															#line 1187 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
				loopDepth = a_body1loopBody1cont1loopBody1cont2loopHead1(loopDepth);
			}
			else
			{
				loopDepth = a_body1loopBody1cont1loopBody1cont5(loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> const& __val,int loopDepth) 
	{
															#line 145 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		val = __val;
															#line 1202 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> && __val,int loopDepth) 
	{
		val = std::move(__val);
		loopDepth = a_body1loopBody1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckerActor*>(this)->actor_wait_state > 0) static_cast<CheckerActor*>(this)->actor_wait_state = 0;
		static_cast<CheckerActor*>(this)->ActorCallback< CheckerActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckerActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckerActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckerActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont3(int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont5(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6(int loopDepth) 
	{
															#line 174 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
		if (val != val2)
															#line 1293 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		{
															#line 175 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			TraceEvent(SevError, "CausalConsistencyError3") .detail("MessageKey", messageKey.toString().c_str()) .detail("Val1", val) .detail("Val2", val2) .detail("RemoteCommitVersion", message.second) .detail("LocalReadVersion", tr.getReadVersion().get());
															#line 182 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			++self->consistencyErrors;
															#line 1299 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		}
		loopDepth = a_body1loopBody1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 167 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			StrictFuture<Void> __when_expr_2 = store(val2, tr2.get(messageKey));
															#line 167 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			if (static_cast<CheckerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1319 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckerActor*>(this)->actor_wait_state = 3;
															#line 167 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckerActor, 2, Void >*>(static_cast<CheckerActor*>(this)));
															#line 1324 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 170 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			TraceEvent("DebugSidebandNoCacheError").errorUnsuppressed(e);
															#line 171 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr2.onError(e);
															#line 171 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			if (static_cast<CheckerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1363 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1loopBody1cont2loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CheckerActor*>(this)->actor_wait_state = 4;
															#line 171 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckerActor, 3, Void >*>(static_cast<CheckerActor*>(this)));
															#line 1368 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckerActor*>(this)->actor_wait_state > 0) static_cast<CheckerActor*>(this)->actor_wait_state = 0;
		static_cast<CheckerActor*>(this)->ActorCallback< CheckerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckerActor*>(this)->actor_wait_state > 0) static_cast<CheckerActor*>(this)->actor_wait_state = 0;
		static_cast<CheckerActor*>(this)->ActorCallback< CheckerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckerActor*>(this)->actor_wait_state > 0) static_cast<CheckerActor*>(this)->actor_wait_state = 0;
		static_cast<CheckerActor*>(this)->ActorCallback< CheckerActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckerActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckerActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckerActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 131 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	SidebandSingleWorkload* self;
															#line 131 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	Database cx;
															#line 139 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	std::pair<uint64_t, Version> message;
															#line 140 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	Standalone<StringRef> messageKey;
															#line 141 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	Transaction tr;
															#line 145 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	Optional<Value> val;
															#line 163 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	Transaction tr2;
															#line 164 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	Optional<Value> val2;
															#line 1656 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checker()
															#line 131 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
class CheckerActor final : public Actor<Void>, public ActorSingleCallback< CheckerActor, 0, std::pair<uint64_t, Version> >, public ActorCallback< CheckerActor, 1, Optional<Value> >, public ActorCallback< CheckerActor, 2, Void >, public ActorCallback< CheckerActor, 3, Void >, public ActorCallback< CheckerActor, 4, Void >, public FastAllocated<CheckerActor>, public CheckerActorState<CheckerActor> {
															#line 1661 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckerActor>::operator new;
	using FastAllocated<CheckerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6084661983805079296UL, 14295754913284734720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< CheckerActor, 0, std::pair<uint64_t, Version> >;
friend struct ActorCallback< CheckerActor, 1, Optional<Value> >;
friend struct ActorCallback< CheckerActor, 2, Void >;
friend struct ActorCallback< CheckerActor, 3, Void >;
friend struct ActorCallback< CheckerActor, 4, Void >;
															#line 131 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	CheckerActor(SidebandSingleWorkload* const& self,Database const& cx) 
															#line 1682 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckerActorState<CheckerActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8562182272201437184UL, 15617388284688477440UL);
		ActorExecutionContextHelper __helper(static_cast<CheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< CheckerActor, 0, std::pair<uint64_t, Version> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckerActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckerActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckerActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 131 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
[[nodiscard]] Future<Void> checker( SidebandSingleWorkload* const& self, Database const& cx ) {
															#line 131 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
	return Future<Void>(new CheckerActor(self, cx));
															#line 1718 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/SidebandSingle.actor.g.cpp.py_gen"
}

#line 193 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/SidebandSingle.actor.cpp"
};

WorkloadFactory<SidebandSingleWorkload> SidebandSingleWorkloadFactory;
