#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
/*
 * ConfigIncrement.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/ISingleThreadTransaction.h"
#include "fdbclient/Tuple.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

class ConfigIncrementWorkload : public TestWorkload {
	int incrementActors{ 0 };
	int incrementsPerActor{ 0 };
	Version lastKnownCommittedVersion{ ::invalidVersion };
	int lastKnownValue{ -1 };
	double meanSleepWithinTransactions{ 0.01 };
	double meanSleepBetweenTransactions{ 0.1 };

	static KeyRef const testKnobName;
	static Key configKey;

	PerfIntCounter transactions, retries, commitUnknownResult;

	static Key getConfigKey() { return Tuple::makeTuple(/* config class */ nullptr, testKnobName).pack(); }

																#line 43 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
// This generated class is to be used only via get()
															#line 41 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
template <class GetActor>
															#line 41 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
class GetActorState {
															#line 49 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
public:
															#line 41 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	GetActorState(Reference<ISingleThreadTransaction> const& tr) 
															#line 41 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
															#line 41 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		 : tr(tr),
															#line 42 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		   te(SevDebug, "ConfigIncrementGet")
															#line 58 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("get", reinterpret_cast<unsigned long>(this));

	}
	~GetActorState() 
	{
		fdb_probe_actor_destroy("get", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 43 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(getConfigKey());
															#line 43 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			if (static_cast<GetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 75 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetActor*>(this)->actor_wait_state = 1;
															#line 43 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetActor, 0, Optional<Value> >*>(static_cast<GetActor*>(this)));
															#line 80 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetActorState();
		static_cast<GetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& serializedValue,int loopDepth) 
	{
															#line 44 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		if (!serializedValue.present())
															#line 103 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		{
															#line 45 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			if (!static_cast<GetActor*>(this)->SAV<int>::futures) { (void)(0); this->~GetActorState(); static_cast<GetActor*>(this)->destroy(); return 0; }
															#line 107 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			new (&static_cast<GetActor*>(this)->SAV< int >::value()) int(0);
			this->~GetActorState();
			static_cast<GetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 47 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			Tuple t = Tuple::unpack(serializedValue.get());
															#line 48 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			int value = t.getInt(0);
															#line 49 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			te.detail("Value", value);
															#line 50 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			if (!static_cast<GetActor*>(this)->SAV<int>::futures) { (void)(value); this->~GetActorState(); static_cast<GetActor*>(this)->destroy(); return 0; }
															#line 123 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			new (&static_cast<GetActor*>(this)->SAV< int >::value()) int(value);
			this->~GetActorState();
			static_cast<GetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && serializedValue,int loopDepth) 
	{
															#line 44 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		if (!serializedValue.present())
															#line 136 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		{
															#line 45 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			if (!static_cast<GetActor*>(this)->SAV<int>::futures) { (void)(0); this->~GetActorState(); static_cast<GetActor*>(this)->destroy(); return 0; }
															#line 140 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			new (&static_cast<GetActor*>(this)->SAV< int >::value()) int(0);
			this->~GetActorState();
			static_cast<GetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 47 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			Tuple t = Tuple::unpack(serializedValue.get());
															#line 48 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			int value = t.getInt(0);
															#line 49 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			te.detail("Value", value);
															#line 50 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			if (!static_cast<GetActor*>(this)->SAV<int>::futures) { (void)(value); this->~GetActorState(); static_cast<GetActor*>(this)->destroy(); return 0; }
															#line 156 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			new (&static_cast<GetActor*>(this)->SAV< int >::value()) int(value);
			this->~GetActorState();
			static_cast<GetActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& serializedValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(serializedValue, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && serializedValue,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(serializedValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetActor*>(this)->actor_wait_state > 0) static_cast<GetActor*>(this)->actor_wait_state = 0;
		static_cast<GetActor*>(this)->ActorCallback< GetActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 41 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	Reference<ISingleThreadTransaction> tr;
															#line 42 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	TraceEvent te;
															#line 244 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
};
// This generated class is to be used only via get()
															#line 41 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
class GetActor final : public Actor<int>, public ActorCallback< GetActor, 0, Optional<Value> >, public FastAllocated<GetActor>, public GetActorState<GetActor> {
															#line 249 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetActor>::operator new;
	using FastAllocated<GetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1627632557634809600UL, 8713471019004381184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetActor, 0, Optional<Value> >;
															#line 41 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	GetActor(Reference<ISingleThreadTransaction> const& tr) 
															#line 266 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		 : Actor<int>(),
		   GetActorState<GetActor>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("get", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13305627610698362112UL, 12413557174276224768UL);
		ActorExecutionContextHelper __helper(static_cast<GetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("get");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("get", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 41 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
[[nodiscard]] static Future<int> get( Reference<ISingleThreadTransaction> const& tr ) {
															#line 41 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	return Future<int>(new GetActor(tr));
															#line 298 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
}

#line 53 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"

	static void set(Reference<ISingleThreadTransaction> tr, int value) {
		TraceEvent(SevDebug, "ConfigIncrementSet").detail("Value", value);
		tr->set(getConfigKey(), format("%d", value));
	}

																#line 308 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
// This generated class is to be used only via incrementActor()
															#line 59 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
template <class IncrementActorActor>
															#line 59 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
class IncrementActorActorState {
															#line 314 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
public:
															#line 59 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	IncrementActorActorState(ConfigIncrementWorkload* const& self,Database const& cx) 
															#line 59 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
															#line 59 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		 : self(self),
															#line 59 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		   cx(cx),
															#line 60 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		   trsComplete(0),
															#line 61 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		   tr()
															#line 327 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("incrementActor", reinterpret_cast<unsigned long>(this));

	}
	~IncrementActorActorState() 
	{
		fdb_probe_actor_destroy("incrementActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 62 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			TraceEvent(SevDebug, "ConfigIncrementStartIncrementActor");
															#line 63 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			;
															#line 344 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncrementActorActorState();
		static_cast<IncrementActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 101 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		if (!static_cast<IncrementActorActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncrementActorActorState(); static_cast<IncrementActorActor*>(this)->destroy(); return 0; }
															#line 367 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		new (&static_cast<IncrementActorActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncrementActorActorState();
		static_cast<IncrementActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 63 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		if (!(trsComplete < self->incrementsPerActor))
															#line 386 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		try {
															#line 65 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			;
															#line 393 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 92 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			if (e.code() == error_code_commit_unknown_result)
															#line 428 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			{
															#line 93 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
				++self->commitUnknownResult;
															#line 94 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
				StrictFuture<Void> __when_expr_5 = delayJittered(0.1);
															#line 94 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
				if (static_cast<IncrementActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 436 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
				static_cast<IncrementActorActor*>(this)->actor_wait_state = 6;
															#line 94 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< IncrementActorActor, 5, Void >*>(static_cast<IncrementActorActor*>(this)));
															#line 441 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
															#line 97 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 448 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 67 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			tr = self->getTransaction(cx);
															#line 68 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			StrictFuture<int> __when_expr_0 = get(tr);
															#line 68 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			if (static_cast<IncrementActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 481 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IncrementActorActor*>(this)->actor_wait_state = 1;
															#line 68 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncrementActorActor, 0, int >*>(static_cast<IncrementActorActor*>(this)));
															#line 486 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 84 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			TraceEvent(SevDebug, "ConfigIncrementError") .errorUnsuppressed(e) .detail("LastKnownValue", self->lastKnownValue);
															#line 87 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 87 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			if (static_cast<IncrementActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 525 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<IncrementActorActor*>(this)->actor_wait_state = 5;
															#line 87 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< IncrementActorActor, 4, Void >*>(static_cast<IncrementActorActor*>(this)));
															#line 530 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 69 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		ASSERT_GE(currentValue, self->lastKnownValue);
															#line 70 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		set(tr, currentValue + 1);
															#line 71 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(deterministicRandom()->random01() * 2 * self->meanSleepWithinTransactions);
															#line 71 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		if (static_cast<IncrementActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 551 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<IncrementActorActor*>(this)->actor_wait_state = 2;
															#line 71 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncrementActorActor, 1, Void >*>(static_cast<IncrementActorActor*>(this)));
															#line 556 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(int const& __currentValue,int loopDepth) 
	{
															#line 68 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		currentValue = __currentValue;
															#line 565 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(int && __currentValue,int loopDepth) 
	{
		currentValue = std::move(__currentValue);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncrementActorActor*>(this)->actor_wait_state > 0) static_cast<IncrementActorActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementActorActor*>(this)->ActorCallback< IncrementActorActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementActorActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncrementActorActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncrementActorActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 72 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 72 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		if (static_cast<IncrementActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 646 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<IncrementActorActor*>(this)->actor_wait_state = 3;
															#line 72 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IncrementActorActor, 2, Void >*>(static_cast<IncrementActorActor*>(this)));
															#line 651 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 72 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr->commit();
															#line 72 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		if (static_cast<IncrementActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 662 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<IncrementActorActor*>(this)->actor_wait_state = 3;
															#line 72 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IncrementActorActor, 2, Void >*>(static_cast<IncrementActorActor*>(this)));
															#line 667 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IncrementActorActor*>(this)->actor_wait_state > 0) static_cast<IncrementActorActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementActorActor*>(this)->ActorCallback< IncrementActorActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementActorActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IncrementActorActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IncrementActorActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 73 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		ASSERT_GT(tr->getCommittedVersion(), self->lastKnownCommittedVersion);
															#line 74 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		self->lastKnownCommittedVersion = tr->getCommittedVersion();
															#line 75 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		self->lastKnownValue = currentValue + 1;
															#line 76 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		TraceEvent("ConfigIncrementSucceeded") .detail("CommittedVersion", self->lastKnownCommittedVersion) .detail("CommittedValue", self->lastKnownValue);
															#line 79 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		++self->transactions;
															#line 80 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		++trsComplete;
															#line 81 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(deterministicRandom()->random01() * 2 * self->meanSleepBetweenTransactions);
															#line 81 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		if (static_cast<IncrementActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 765 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<IncrementActorActor*>(this)->actor_wait_state = 4;
															#line 81 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< IncrementActorActor, 3, Void >*>(static_cast<IncrementActorActor*>(this)));
															#line 770 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 73 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		ASSERT_GT(tr->getCommittedVersion(), self->lastKnownCommittedVersion);
															#line 74 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		self->lastKnownCommittedVersion = tr->getCommittedVersion();
															#line 75 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		self->lastKnownValue = currentValue + 1;
															#line 76 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		TraceEvent("ConfigIncrementSucceeded") .detail("CommittedVersion", self->lastKnownCommittedVersion) .detail("CommittedValue", self->lastKnownValue);
															#line 79 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		++self->transactions;
															#line 80 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		++trsComplete;
															#line 81 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(deterministicRandom()->random01() * 2 * self->meanSleepBetweenTransactions);
															#line 81 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		if (static_cast<IncrementActorActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 793 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<IncrementActorActor*>(this)->actor_wait_state = 4;
															#line 81 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< IncrementActorActor, 3, Void >*>(static_cast<IncrementActorActor*>(this)));
															#line 798 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<IncrementActorActor*>(this)->actor_wait_state > 0) static_cast<IncrementActorActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementActorActor*>(this)->ActorCallback< IncrementActorActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementActorActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< IncrementActorActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< IncrementActorActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1loopBody1cont5(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont5(Void && _,int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<IncrementActorActor*>(this)->actor_wait_state > 0) static_cast<IncrementActorActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementActorActor*>(this)->ActorCallback< IncrementActorActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementActorActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< IncrementActorActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< IncrementActorActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		++self->retries;
															#line 969 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		++self->retries;
															#line 978 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<IncrementActorActor*>(this)->actor_wait_state > 0) static_cast<IncrementActorActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementActorActor*>(this)->ActorCallback< IncrementActorActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementActorActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< IncrementActorActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< IncrementActorActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
															#line 95 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		tr->reset();
															#line 1081 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
															#line 95 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		tr->reset();
															#line 1090 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<IncrementActorActor*>(this)->actor_wait_state > 0) static_cast<IncrementActorActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementActorActor*>(this)->ActorCallback< IncrementActorActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementActorActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< IncrementActorActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< IncrementActorActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 59 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	ConfigIncrementWorkload* self;
															#line 59 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	Database cx;
															#line 60 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	int trsComplete;
															#line 61 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	Reference<ISingleThreadTransaction> tr;
															#line 68 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	int currentValue;
															#line 1180 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
};
// This generated class is to be used only via incrementActor()
															#line 59 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
class IncrementActorActor final : public Actor<Void>, public ActorCallback< IncrementActorActor, 0, int >, public ActorCallback< IncrementActorActor, 1, Void >, public ActorCallback< IncrementActorActor, 2, Void >, public ActorCallback< IncrementActorActor, 3, Void >, public ActorCallback< IncrementActorActor, 4, Void >, public ActorCallback< IncrementActorActor, 5, Void >, public FastAllocated<IncrementActorActor>, public IncrementActorActorState<IncrementActorActor> {
															#line 1185 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
public:
	using FastAllocated<IncrementActorActor>::operator new;
	using FastAllocated<IncrementActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3085055676886749696UL, 7349931094872010752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncrementActorActor, 0, int >;
friend struct ActorCallback< IncrementActorActor, 1, Void >;
friend struct ActorCallback< IncrementActorActor, 2, Void >;
friend struct ActorCallback< IncrementActorActor, 3, Void >;
friend struct ActorCallback< IncrementActorActor, 4, Void >;
friend struct ActorCallback< IncrementActorActor, 5, Void >;
															#line 59 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	IncrementActorActor(ConfigIncrementWorkload* const& self,Database const& cx) 
															#line 1207 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   IncrementActorActorState<IncrementActorActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("incrementActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5945950786295346688UL, 13686646068419484416UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("incrementActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("incrementActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncrementActorActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IncrementActorActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< IncrementActorActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< IncrementActorActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< IncrementActorActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< IncrementActorActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 59 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
[[nodiscard]] static Future<Void> incrementActor( ConfigIncrementWorkload* const& self, Database const& cx ) {
															#line 59 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	return Future<Void>(new IncrementActorActor(self, cx));
															#line 1244 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
}

#line 103 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"

																#line 1249 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
// This generated class is to be used only via check()
															#line 104 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
template <class CheckActor>
															#line 104 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
class CheckActorState {
															#line 1255 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
public:
															#line 104 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	CheckActorState(ConfigIncrementWorkload* const& self,Database const& cx) 
															#line 104 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
															#line 104 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		 : self(self),
															#line 104 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		   cx(cx),
															#line 105 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		   tr()
															#line 1266 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("check", reinterpret_cast<unsigned long>(this));

	}
	~CheckActorState() 
	{
		fdb_probe_actor_destroy("check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 106 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			;
															#line 1281 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckActorState();
		static_cast<CheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 107 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		tr.clear();
															#line 1311 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		try {
															#line 109 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			tr = self->getTransaction(cx);
															#line 110 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			StrictFuture<int> __when_expr_0 = get(tr);
															#line 110 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			if (static_cast<CheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1319 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckActor*>(this)->actor_wait_state = 1;
															#line 110 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckActor, 0, int >*>(static_cast<CheckActor*>(this)));
															#line 1324 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 117 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 117 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			if (static_cast<CheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1348 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckActor*>(this)->actor_wait_state = 2;
															#line 117 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckActor, 1, Void >*>(static_cast<CheckActor*>(this)));
															#line 1353 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 111 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		auto expectedValue = self->incrementActors * self->incrementsPerActor;
															#line 112 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		TraceEvent("ConfigIncrementCheck") .detail("CurrentValue", currentValue) .detail("ExpectedValue", expectedValue);
															#line 115 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		if (!static_cast<CheckActor*>(this)->SAV<bool>::futures) { (void)(currentValue >= expectedValue); this->~CheckActorState(); static_cast<CheckActor*>(this)->destroy(); return 0; }
															#line 1372 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		new (&static_cast<CheckActor*>(this)->SAV< bool >::value()) bool(currentValue >= expectedValue);
		this->~CheckActorState();
		static_cast<CheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(int const& __currentValue,int loopDepth) 
	{
															#line 110 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
		currentValue = __currentValue;
															#line 1384 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int && __currentValue,int loopDepth) 
	{
		currentValue = std::move(__currentValue);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckActor*>(this)->actor_wait_state > 0) static_cast<CheckActor*>(this)->actor_wait_state = 0;
		static_cast<CheckActor*>(this)->ActorCallback< CheckActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< CheckActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckActor*>(this)->actor_wait_state > 0) static_cast<CheckActor*>(this)->actor_wait_state = 0;
		static_cast<CheckActor*>(this)->ActorCallback< CheckActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 104 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	ConfigIncrementWorkload* self;
															#line 104 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	Database cx;
															#line 105 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	Reference<ISingleThreadTransaction> tr;
															#line 110 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	int currentValue;
															#line 1554 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
};
// This generated class is to be used only via check()
															#line 104 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
class CheckActor final : public Actor<bool>, public ActorCallback< CheckActor, 0, int >, public ActorCallback< CheckActor, 1, Void >, public FastAllocated<CheckActor>, public CheckActorState<CheckActor> {
															#line 1559 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckActor>::operator new;
	using FastAllocated<CheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16132588128499768064UL, 4950658451149185792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckActor, 0, int >;
friend struct ActorCallback< CheckActor, 1, Void >;
															#line 104 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	CheckActor(ConfigIncrementWorkload* const& self,Database const& cx) 
															#line 1577 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   CheckActorState<CheckActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9223858490859549696UL, 13188886265273636608UL);
		ActorExecutionContextHelper __helper(static_cast<CheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 104 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
[[nodiscard]] static Future<bool> check( ConfigIncrementWorkload* const& self, Database const& cx ) {
															#line 104 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"
	return Future<bool>(new CheckActor(self, cx));
															#line 1610 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/ConfigIncrement.actor.g.cpp.py_gen"
}

#line 121 "/codebuild/output/src1701444386/src/github.com/apple/foundationdb/fdbserver/workloads/ConfigIncrement.actor.cpp"

	Reference<ISingleThreadTransaction> getTransaction(Database cx) const {
		ASSERT(g_network->isSimulated()); // TODO: Enforce elsewhere
		ASSERT(g_simulator->configDBType != ConfigDBType::DISABLED);
		auto type = (g_simulator->configDBType == ConfigDBType::SIMPLE) ? ISingleThreadTransaction::Type::SIMPLE_CONFIG
		                                                                : ISingleThreadTransaction::Type::PAXOS_CONFIG;
		return ISingleThreadTransaction::create(type, cx);
	}

public:
	static constexpr auto NAME = "ConfigIncrement";
	ConfigIncrementWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), transactions("Transactions"), retries("Retries"),
	    commitUnknownResult("CommitUnknownResult") {
		incrementActors = getOption(options, "incrementActors"_sr, 10);
		incrementsPerActor = getOption(options, "incrementsPerActor"_sr, 10);
		meanSleepWithinTransactions = getOption(options, "meanSleepWithinTransactions"_sr, 0.01);
		meanSleepBetweenTransactions = getOption(options, "meanSleepBetweenTransactions"_sr, 0.1);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	Future<Void> start(Database const& cx) override {
		std::vector<Future<Void>> actors;
		auto localIncrementActors =
		    (clientId < incrementActors) ? ((incrementActors - clientId - 1) / clientCount + 1) : 0;
		for (int i = 0; i < localIncrementActors; ++i) {
			actors.push_back(incrementActor(this, cx));
		}
		return waitForAll(actors);
	}

	Future<bool> check(Database const& cx) override { return clientId ? Future<bool>{ true } : check(this, cx); }

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(transactions.getMetric());
		m.push_back(retries.getMetric());
		m.push_back(commitUnknownResult.getMetric());
		m.emplace_back("Last Known Value", lastKnownValue, Averaged::False);
	}
};

WorkloadFactory<ConfigIncrementWorkload> ConfigIncrementWorkloadFactory;

KeyRef const ConfigIncrementWorkload::testKnobName = "test_int"_sr;
