/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.DatabaseOptions;
import com.apple.foundationdb.EventKeeper;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.FDBTransaction;
import com.apple.foundationdb.FutureKey;
import com.apple.foundationdb.NativeObjectWrapper;
import com.apple.foundationdb.OptionConsumer;
import com.apple.foundationdb.ReadTransaction;
import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.async.AsyncUtil;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

class FDBDatabase
extends NativeObjectWrapper
implements Database,
OptionConsumer {
    private DatabaseOptions options;
    private final Executor executor;
    private final EventKeeper eventKeeper;

    protected FDBDatabase(long l, Executor executor) {
        this(l, executor, null);
    }

    protected FDBDatabase(long l, Executor executor, EventKeeper eventKeeper) {
        super(l);
        this.executor = executor;
        this.options = new DatabaseOptions(this);
        if (FDB.instance().getAPIVersion() >= 730) {
            this.options.setTransactionUsedDuringCommitProtectionDisable();
        }
        this.eventKeeper = eventKeeper;
    }

    @Override
    public DatabaseOptions options() {
        return this.options;
    }

    @Override
    public <T> T run(Function<? super Transaction, T> function, Executor executor) {
        Transaction transaction = this.createTransaction(executor);
        while (true) {
            try {
                T t = function.apply(transaction);
                transaction.commit().join();
                T t2 = t;
                return t2;
            }
            catch (RuntimeException runtimeException) {
                transaction = transaction.onError(runtimeException).join();
                continue;
            }
            break;
        }
        finally {
            transaction.close();
        }
    }

    @Override
    public <T> T read(Function<? super ReadTransaction, T> function, Executor executor) {
        return this.run(function, executor);
    }

    @Override
    public <T> CompletableFuture<T> runAsync(Function<? super Transaction, ? extends CompletableFuture<T>> function, Executor executor) {
        AtomicReference<Transaction> atomicReference = new AtomicReference<Transaction>(this.createTransaction(executor));
        AtomicReference atomicReference2 = new AtomicReference();
        return ((CompletableFuture)AsyncUtil.whileTrue(() -> {
            CompletableFuture completableFuture = AsyncUtil.applySafely(function, atomicReference.get());
            return AsyncUtil.composeHandleAsync(completableFuture.thenComposeAsync(object -> ((Transaction)atomicReference.get()).commit().thenApply(void_ -> {
                atomicReference2.set(object);
                return false;
            }), executor), (bl, throwable) -> {
                if (throwable == null) {
                    return CompletableFuture.completedFuture(bl);
                }
                if (!(throwable instanceof RuntimeException)) {
                    throw new CompletionException((Throwable)throwable);
                }
                return ((Transaction)atomicReference.get()).onError((Throwable)throwable).thenApply(transaction -> {
                    atomicReference.set((Transaction)transaction);
                    return true;
                });
            }, executor);
        }, executor).thenApply(void_ -> atomicReference2.get())).whenComplete((object, throwable) -> ((Transaction)atomicReference.get()).close());
    }

    @Override
    public <T> CompletableFuture<T> readAsync(Function<? super ReadTransaction, ? extends CompletableFuture<T>> function, Executor executor) {
        return this.runAsync(function, executor);
    }

    protected void finalize() throws Throwable {
        try {
            this.checkUnclosed("Database");
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public Transaction createTransaction(Executor executor) {
        return this.createTransaction(executor, this.eventKeeper);
    }

    @Override
    public Transaction createTransaction(Executor executor, EventKeeper eventKeeper) {
        this.pointerReadLock.lock();
        Transaction transaction = null;
        try {
            transaction = new FDBTransaction(this.Database_createTransaction(this.getPtr()), this, executor, eventKeeper);
            if (FDB.instance().getAPIVersion() < 730) {
                transaction.options().setUsedDuringCommitProtectionDisable();
            }
            Transaction transaction2 = transaction;
            return transaction2;
        }
        catch (RuntimeException runtimeException) {
            if (transaction != null) {
                transaction.close();
            }
            throw runtimeException;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    public void setOption(int n, byte[] byArray) {
        this.pointerReadLock.lock();
        try {
            this.Database_setOption(this.getPtr(), n, byArray);
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    public double getMainThreadBusyness() {
        this.pointerReadLock.lock();
        try {
            double d = this.Database_getMainThreadBusyness(this.getPtr());
            return d;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    protected void closeInternal(long l) {
        this.Database_dispose(l);
    }

    @Override
    public CompletableFuture<byte[]> getClientStatus(Executor executor) {
        this.pointerReadLock.lock();
        try {
            FutureKey futureKey = new FutureKey(this.Database_getClientStatus(this.getPtr()), executor, this.eventKeeper);
            return futureKey;
        }
        finally {
            this.pointerReadLock.unlock();
        }
    }

    private native long Database_createTransaction(long var1);

    private native void Database_dispose(long var1);

    private native void Database_setOption(long var1, int var3, byte[] var4) throws FDBException;

    private native double Database_getMainThreadBusyness(long var1);

    private native long Database_getClientStatus(long var1);
}

