#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
/*
 * MetaclusterInternal.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_METACLUSTERINTERNAL_ACTOR_G_H)
#define METACLUSTER_METACLUSTERINTERNAL_ACTOR_G_H
#include "metacluster/MetaclusterInternal.actor.g.h"
#elif !defined(METACLUSTER_METACLUSTERINTERNAL_ACTOR_H)
#define METACLUSTER_METACLUSTERINTERNAL_ACTOR_H

#include "fdbclient/CoordinationInterface.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbclient/Tenant.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbrpc/TenantName.h"
#include "flow/FastRef.h"
#include "flow/IRandom.h"
#include "flow/Platform.h"

#include "metacluster/MetaclusterMetadata.h"
#include "metacluster/MetaclusterTypes.h"

#include "flow/actorcompiler.h" // has to be last include

// This provides internal Metacluster APIs that are not meant to be consumed outside the metacluster project
namespace metacluster::internal {

															#line 48 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
// This generated class is to be used only via managementClusterCheckEmpty()
															#line 46 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
template <class Transaction, class ManagementClusterCheckEmptyActor>
															#line 46 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
class ManagementClusterCheckEmptyActorState {
															#line 54 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
public:
															#line 46 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
	ManagementClusterCheckEmptyActorState(Transaction const& tr) 
															#line 46 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
															#line 46 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		 : tr(tr),
															#line 48 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		   tenantsFuture(TenantMetadata::tenantMap().getRange(tr, {}, {}, 1)),
															#line 50 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		   dbContentsFuture(tr->getRange(normalKeys, 1))
															#line 65 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
	{
		fdb_probe_actor_create("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this));

	}
	~ManagementClusterCheckEmptyActorState() 
	{
		fdb_probe_actor_destroy("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 53 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
			StrictFuture<KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>>> __when_expr_0 = tenantsFuture;
															#line 53 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
			if (static_cast<ManagementClusterCheckEmptyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 82 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ManagementClusterCheckEmptyActor*>(this)->actor_wait_state = 1;
															#line 53 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ManagementClusterCheckEmptyActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*>(static_cast<ManagementClusterCheckEmptyActor*>(this)));
															#line 87 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ManagementClusterCheckEmptyActorState();
		static_cast<ManagementClusterCheckEmptyActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> const& tenants,int loopDepth) 
	{
															#line 54 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		if (!tenants.results.empty())
															#line 110 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		{
															#line 55 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
			CODE_PROBE(true, "Metacluster emptiness check has tenants", probe::decoration::rare);
															#line 56 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
			return a_body1Catch1(cluster_not_empty(), loopDepth);
															#line 116 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		}
															#line 59 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		StrictFuture<RangeResult> __when_expr_1 = safeThreadFutureToFuture(dbContentsFuture);
															#line 59 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		if (static_cast<ManagementClusterCheckEmptyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 122 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ManagementClusterCheckEmptyActor*>(this)->actor_wait_state = 2;
															#line 59 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ManagementClusterCheckEmptyActor, 1, RangeResult >*>(static_cast<ManagementClusterCheckEmptyActor*>(this)));
															#line 127 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> && tenants,int loopDepth) 
	{
															#line 54 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		if (!tenants.results.empty())
															#line 136 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		{
															#line 55 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
			CODE_PROBE(true, "Metacluster emptiness check has tenants", probe::decoration::rare);
															#line 56 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
			return a_body1Catch1(cluster_not_empty(), loopDepth);
															#line 142 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		}
															#line 59 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		StrictFuture<RangeResult> __when_expr_1 = safeThreadFutureToFuture(dbContentsFuture);
															#line 59 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		if (static_cast<ManagementClusterCheckEmptyActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 148 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ManagementClusterCheckEmptyActor*>(this)->actor_wait_state = 2;
															#line 59 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ManagementClusterCheckEmptyActor, 1, RangeResult >*>(static_cast<ManagementClusterCheckEmptyActor*>(this)));
															#line 153 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> const& tenants,int loopDepth) 
	{
		loopDepth = a_body1cont1(tenants, loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> && tenants,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(tenants), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ManagementClusterCheckEmptyActor*>(this)->actor_wait_state > 0) static_cast<ManagementClusterCheckEmptyActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementClusterCheckEmptyActor*>(this)->ActorCallback< ManagementClusterCheckEmptyActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementClusterCheckEmptyActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterCheckEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ManagementClusterCheckEmptyActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterCheckEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ManagementClusterCheckEmptyActor, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterCheckEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(RangeResult const& dbContents,int loopDepth) 
	{
															#line 60 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		if (!dbContents.empty())
															#line 237 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		{
															#line 61 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
			CODE_PROBE(true, "Metacluster emptiness check has data");
															#line 62 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
			return a_body1Catch1(cluster_not_empty(), loopDepth);
															#line 243 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		}
															#line 65 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		if (!static_cast<ManagementClusterCheckEmptyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ManagementClusterCheckEmptyActorState(); static_cast<ManagementClusterCheckEmptyActor*>(this)->destroy(); return 0; }
															#line 247 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		new (&static_cast<ManagementClusterCheckEmptyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ManagementClusterCheckEmptyActorState();
		static_cast<ManagementClusterCheckEmptyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(RangeResult && dbContents,int loopDepth) 
	{
															#line 60 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		if (!dbContents.empty())
															#line 259 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		{
															#line 61 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
			CODE_PROBE(true, "Metacluster emptiness check has data");
															#line 62 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
			return a_body1Catch1(cluster_not_empty(), loopDepth);
															#line 265 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		}
															#line 65 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
		if (!static_cast<ManagementClusterCheckEmptyActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ManagementClusterCheckEmptyActorState(); static_cast<ManagementClusterCheckEmptyActor*>(this)->destroy(); return 0; }
															#line 269 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		new (&static_cast<ManagementClusterCheckEmptyActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ManagementClusterCheckEmptyActorState();
		static_cast<ManagementClusterCheckEmptyActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult const& dbContents,int loopDepth) 
	{
		loopDepth = a_body1cont2(dbContents, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(RangeResult && dbContents,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(dbContents), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ManagementClusterCheckEmptyActor*>(this)->actor_wait_state > 0) static_cast<ManagementClusterCheckEmptyActor*>(this)->actor_wait_state = 0;
		static_cast<ManagementClusterCheckEmptyActor*>(this)->ActorCallback< ManagementClusterCheckEmptyActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ManagementClusterCheckEmptyActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterCheckEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ManagementClusterCheckEmptyActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterCheckEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ManagementClusterCheckEmptyActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterCheckEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 46 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
	Transaction tr;
															#line 48 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
	Future<KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>>> tenantsFuture;
															#line 50 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
	typename transaction_future_type<Transaction, RangeResult>::type dbContentsFuture;
															#line 358 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
};
// This generated class is to be used only via managementClusterCheckEmpty()
															#line 46 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
template <class Transaction>
															#line 46 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
class ManagementClusterCheckEmptyActor final : public Actor<Void>, public ActorCallback< ManagementClusterCheckEmptyActor<Transaction>, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >, public ActorCallback< ManagementClusterCheckEmptyActor<Transaction>, 1, RangeResult >, public FastAllocated<ManagementClusterCheckEmptyActor<Transaction>>, public ManagementClusterCheckEmptyActorState<Transaction, ManagementClusterCheckEmptyActor<Transaction>> {
															#line 365 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
public:
	using FastAllocated<ManagementClusterCheckEmptyActor<Transaction>>::operator new;
	using FastAllocated<ManagementClusterCheckEmptyActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13199609128073582592UL, 384951727014905344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ManagementClusterCheckEmptyActor<Transaction>, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >;
friend struct ActorCallback< ManagementClusterCheckEmptyActor<Transaction>, 1, RangeResult >;
															#line 46 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
	ManagementClusterCheckEmptyActor(Transaction const& tr) 
															#line 383 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
		 : Actor<Void>(),
		   ManagementClusterCheckEmptyActorState<Transaction, ManagementClusterCheckEmptyActor<Transaction>>(tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4649153860554891520UL, 15740510087803751168UL);
		ActorExecutionContextHelper __helper(static_cast<ManagementClusterCheckEmptyActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("managementClusterCheckEmpty");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("managementClusterCheckEmpty", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ManagementClusterCheckEmptyActor<Transaction>, 0, KeyBackedRangeResult<std::pair<int64_t, TenantMapEntry>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ManagementClusterCheckEmptyActor<Transaction>, 1, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 46 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
template <class Transaction>
															#line 46 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
[[nodiscard]] Future<Void> managementClusterCheckEmpty( Transaction const& tr ) {
															#line 46 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"
	return Future<Void>(new ManagementClusterCheckEmptyActor<Transaction>(tr));
															#line 418 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/MetaclusterInternal.actor.g.h"
}

#line 67 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/metacluster/include/metacluster/MetaclusterInternal.actor.h"

template <class Transaction>
void updateClusterCapacityIndex(Transaction tr,
                                ClusterName name,
                                DataClusterEntry const& previousEntry,
                                DataClusterEntry const& updatedEntry) {
	CODE_PROBE(updatedEntry.autoTenantAssignment == AutoTenantAssignment::DISABLED,
	           "Update tenant capacity with auto-assignment disabled");
	CODE_PROBE(updatedEntry.autoTenantAssignment == AutoTenantAssignment::ENABLED,
	           "Update tenant capacity with auto-assignment enabled");

	// Entries are put in the cluster capacity index ordered by how many items are already allocated to them
	if (previousEntry.hasCapacity() || updatedEntry.autoTenantAssignment == AutoTenantAssignment::DISABLED) {
		metadata::management::clusterCapacityIndex().erase(
		    tr, Tuple::makeTuple(previousEntry.allocated.numTenantGroups, name));
	}
	if (updatedEntry.hasCapacity() && updatedEntry.autoTenantAssignment == AutoTenantAssignment::ENABLED) {
		metadata::management::clusterCapacityIndex().insert(
		    tr, Tuple::makeTuple(updatedEntry.allocated.numTenantGroups, name));
	}
}

} // namespace metacluster::internal

#include "flow/unactorcompiler.h"
#endif