#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
/*
 * UnitTests.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/workloads/workloads.actor.h"
#include "flow/UnitTest.h"
#include "flow/actorcompiler.h" // has to be last include

void forceLinkIndexedSetTests();
void forceLinkDequeTests();
void forceLinkFlowTests();
void forceLinkCoroTests();
void forceLinkVersionedMapTests();
void forceLinkMemcpyTests();
void forceLinkMemcpyPerfTests();
void forceLinkStreamCipherTests();
void forceLinkBlobCipherTests();
void forceLinkParallelStreamTests();
void forceLinkSimExternalConnectionTests();
void forceLinkMutationLogReaderTests();
void forceLinkSimKmsConnectorTests();
void forceLinkIThreadPoolTests();
void forceLinkTokenSignTests();
void forceLinkJsonWebKeySetTests();
void forceLinkVersionVectorTests();
void forceLinkRESTClientTests();
void forceLinkRESTUtilsTests();
void forceLinkRESTKmsConnectorTest();
void forceLinkCompressionUtilsTest();
void forceLinkAtomicTests();
void forceLinkIdempotencyIdTests();
void forceLinkBlobConnectionProviderTests();
void forceLinkActorCollectionTests();
void forceLinkDDSketchTests();
void forceLinkCommitProxyTests();
void forceLinkWipedStringTests();
void forceLinkRandomKeyValueUtilsTests();
void forceLinkSimKmsVaultTests();
void forceLinkRESTSimKmsVaultTest();
void forceLinkActorFuzzUnitTests();
void forceLinkGrpcTests();
void forceLinkGrpcTests2();
void forceLinkSimpleCounterTests();

struct UnitTestWorkload : TestWorkload {
	static constexpr auto NAME = "UnitTests";

	bool enabled;
	std::string testPattern;
	std::vector<std::string> testsIgnored;
	int testRunLimit;
	UnitTestParameters testParams;
	bool cleanupAfterTests;

	PerfIntCounter testsAvailable, testsExecuted, testsFailed;
	PerfDoubleCounter totalWallTime, totalSimTime;

	UnitTestWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), testsAvailable("Test Cases Available"), testsExecuted("Test Cases Executed"),
	    testsFailed("Test Cases Failed"), totalWallTime("Total wall clock time (s)"),
	    totalSimTime("Total flow time (s)") {
		enabled = !clientId; // only do this on the "first" client
		testPattern = getOption(options, "testsMatching"_sr, Value()).toString();
		if (hasOption(options, "testsIgnored"_sr)) {
			auto ignored = getOption(options, "testsIgnored"_sr, Value());
			for (auto s : ignored.splitAny(";"_sr)) {
				auto str = s.toString();
				str.erase(remove_if(str.begin(), str.end(), isspace), str.end());
				testsIgnored.push_back(str);
			}
		}
		testRunLimit = getOption(options, "maxTestCases"_sr, -1);
		if (g_network->isSimulated()) {
			testParams.setDataDir(getOption(options, "dataDir"_sr, "simfdb/unittests/"_sr).toString());
		} else {
			testParams.setDataDir(getOption(options, "dataDir"_sr, "unittests/"_sr).toString());
		}
		cleanupAfterTests = getOption(options, "cleanupAfterTests"_sr, true);

		// Consume all remaining options as testParams which the unit test can access
		for (auto& kv : options) {
			if (kv.value.size() != 0) {
				testParams.set(kv.key.toString(), getOption(options, kv.key, StringRef()).toString());
			}
		}

		forceLinkIndexedSetTests();
		forceLinkDequeTests();
		forceLinkFlowTests();
		forceLinkCoroTests();
		forceLinkVersionedMapTests();
		forceLinkMemcpyTests();
		forceLinkMemcpyPerfTests();
		forceLinkStreamCipherTests();
		forceLinkBlobCipherTests();
		forceLinkParallelStreamTests();
		forceLinkSimExternalConnectionTests();
		forceLinkMutationLogReaderTests();
		forceLinkSimKmsConnectorTests();
		forceLinkIThreadPoolTests();
		forceLinkTokenSignTests();
		forceLinkJsonWebKeySetTests();
		forceLinkVersionVectorTests();
		forceLinkRESTClientTests();
		forceLinkRESTUtilsTests();
		forceLinkRESTKmsConnectorTest();
		forceLinkCompressionUtilsTest();
		forceLinkAtomicTests();
		forceLinkIdempotencyIdTests();
		forceLinkBlobConnectionProviderTests();
		forceLinkActorCollectionTests();
		forceLinkDDSketchTests();
		forceLinkWipedStringTests();
		forceLinkRandomKeyValueUtilsTests();
		forceLinkSimKmsVaultTests();
		forceLinkRESTSimKmsVaultTest();
		forceLinkActorFuzzUnitTests();
		forceLinkSimpleCounterTests();

#ifdef FLOW_GRPC_ENABLED
		forceLinkGrpcTests();
		forceLinkGrpcTests2();
#endif
	}

	Future<Void> setup(Database const& cx) override {
		platform::eraseDirectoryRecursive(testParams.getDataDir());
		return Void();
	}
	Future<Void> start(Database const& cx) override {
		if (enabled)
			return runUnitTests(this);
		return Void();
	}
	Future<bool> check(Database const& cx) override { return testsFailed.getValue() == 0; }
	void getMetrics(std::vector<PerfMetric>& m) override {
		m.push_back(testsAvailable.getMetric());
		m.push_back(testsExecuted.getMetric());
		m.push_back(testsFailed.getMetric());
		m.push_back(totalWallTime.getMetric());
		m.push_back(totalSimTime.getMetric());
	}

	bool testMatched(std::string const& testName) const {
		if (!StringRef(testName).startsWith(testPattern)) {
			return false;
		}

		for (auto ignorePatt : testsIgnored) {
			if (StringRef(testName).startsWith(ignorePatt)) {
				return false;
			}
		}

		return true;
	}

																#line 176 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
// This generated class is to be used only via runUnitTests()
															#line 174 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
template <class RunUnitTestsActor>
															#line 174 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
class RunUnitTestsActorState {
															#line 182 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
public:
															#line 174 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
	RunUnitTestsActorState(UnitTestWorkload* const& self) 
															#line 174 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
															#line 174 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		 : self(self),
															#line 175 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		   tests()
															#line 191 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("runUnitTests", reinterpret_cast<unsigned long>(this));

	}
	~RunUnitTestsActorState() 
	{
		fdb_probe_actor_destroy("runUnitTests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 177 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			for(auto test = g_unittests.tests;test != nullptr;test = test->next) {
															#line 178 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
				if (self->testMatched(test->name))
															#line 208 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
				{
															#line 179 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
					++self->testsAvailable;
															#line 180 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
					tests.push_back(test);
															#line 214 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
				}
			}
															#line 184 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			std::sort(tests.begin(), tests.end(), [](auto lhs, auto rhs) { return std::string_view(lhs->name) < std::string_view(rhs->name); });
															#line 188 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			fprintf(stdout, "Found %zu tests\n", tests.size());
															#line 190 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			if (tests.size() == 0)
															#line 223 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
			{
															#line 191 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
				TraceEvent(SevError, "NoMatchingUnitTests") .detail("TestPattern", self->testPattern) .detail("TestsIgnored", self->testsIgnored);
															#line 194 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
				++self->testsFailed;
															#line 195 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
				if (!static_cast<RunUnitTestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunUnitTestsActorState(); static_cast<RunUnitTestsActor*>(this)->destroy(); return 0; }
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
				new (&static_cast<RunUnitTestsActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~RunUnitTestsActorState();
				static_cast<RunUnitTestsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 198 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			deterministicRandom()->randomShuffle(tests);
															#line 199 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			if (self->testRunLimit > 0 && tests.size() > self->testRunLimit)
															#line 241 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
			{
															#line 200 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
				tests.resize(self->testRunLimit);
															#line 245 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
			}
															#line 202 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			t = std::vector<UnitTest*>::iterator();
															#line 203 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			t = tests.begin();
															#line 251 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RunUnitTestsActorState();
		static_cast<RunUnitTestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 241 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		if (!static_cast<RunUnitTestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RunUnitTestsActorState(); static_cast<RunUnitTestsActor*>(this)->destroy(); return 0; }
															#line 274 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
		new (&static_cast<RunUnitTestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RunUnitTestsActorState();
		static_cast<RunUnitTestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 203 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		if (!(t != tests.end()))
															#line 293 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 204 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		test = *t;
															#line 205 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		printf("Testing %s\n", test->name);
															#line 207 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		TraceEvent(SevInfo, "RunningUnitTest") .detail("Name", test->name) .detail("File", test->file) .detail("Line", test->line);
															#line 212 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		result = success();
															#line 213 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		start_now = now();
															#line 214 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		start_timer = timer();
															#line 216 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		platform::createDirectory(self->testParams.getDataDir());
															#line 311 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
		try {
															#line 218 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = test->func(self->testParams);
															#line 218 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			if (static_cast<RunUnitTestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 317 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RunUnitTestsActor*>(this)->actor_wait_state = 1;
															#line 218 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RunUnitTestsActor, 0, Void >*>(static_cast<RunUnitTestsActor*>(this)));
															#line 322 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 223 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		if (self->cleanupAfterTests)
															#line 350 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
		{
															#line 224 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			platform::eraseDirectoryRecursive(self->testParams.getDataDir());
															#line 354 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
		}
															#line 226 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		++self->testsExecuted;
															#line 227 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		double wallTime = timer() - start_timer;
															#line 228 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		double simTime = now() - start_now;
															#line 230 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		self->totalWallTime += wallTime;
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		self->totalSimTime += simTime;
															#line 232 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		TraceEvent(result.code() != error_code_success ? SevError : SevInfo, "UnitTest") .errorUnsuppressed(result) .detail("Name", test->name) .detail("File", test->file) .detail("Line", test->line) .detail("WallTime", wallTime) .detail("FlowTime", simTime);
															#line 203 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		++t;
															#line 370 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 220 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			++self->testsFailed;
															#line 221 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			result = e;
															#line 382 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RunUnitTestsActor*>(this)->actor_wait_state > 0) static_cast<RunUnitTestsActor*>(this)->actor_wait_state = 0;
		static_cast<RunUnitTestsActor*>(this)->ActorCallback< RunUnitTestsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RunUnitTestsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("runUnitTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUnitTests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RunUnitTestsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("runUnitTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RunUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUnitTests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RunUnitTestsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("runUnitTests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RunUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("runUnitTests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 174 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
	UnitTestWorkload* self;
															#line 175 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
	std::vector<UnitTest*> tests;
															#line 202 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
	std::vector<UnitTest*>::iterator t;
															#line 204 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
	UnitTest* test;
															#line 212 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
	Error result;
															#line 213 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
	double start_now;
															#line 214 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
	double start_timer;
															#line 507 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
};
// This generated class is to be used only via runUnitTests()
															#line 174 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
class RunUnitTestsActor final : public Actor<Void>, public ActorCallback< RunUnitTestsActor, 0, Void >, public FastAllocated<RunUnitTestsActor>, public RunUnitTestsActorState<RunUnitTestsActor> {
															#line 512 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
public:
	using FastAllocated<RunUnitTestsActor>::operator new;
	using FastAllocated<RunUnitTestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2100389025930141184UL, 16549170960773258496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RunUnitTestsActor, 0, Void >;
															#line 174 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
	RunUnitTestsActor(UnitTestWorkload* const& self) 
															#line 529 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   RunUnitTestsActorState<RunUnitTestsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("runUnitTests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15611276127407735808UL, 489341551778919680UL);
		ActorExecutionContextHelper __helper(static_cast<RunUnitTestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("runUnitTests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("runUnitTests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RunUnitTestsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 174 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
[[nodiscard]] static Future<Void> runUnitTests( UnitTestWorkload* const& self ) {
															#line 174 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
	return Future<Void>(new RunUnitTestsActor(self));
															#line 561 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
}

#line 243 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
};

WorkloadFactory<UnitTestWorkload> UnitTestWorkloadFactory;

															#line 569 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase247()
															#line 247 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
template <class FlowTestCase247Actor>
															#line 247 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
class FlowTestCase247ActorState {
															#line 576 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
public:
															#line 247 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
	FlowTestCase247ActorState(UnitTestParameters const& params) 
															#line 247 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
															#line 247 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		 : params(params)
															#line 583 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase247", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase247ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase247", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 248 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(60);
															#line 248 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			if (static_cast<FlowTestCase247Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 600 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase247Actor*>(this)->actor_wait_state = 1;
															#line 248 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase247Actor, 0, Void >*>(static_cast<FlowTestCase247Actor*>(this)));
															#line 605 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase247ActorState();
		static_cast<FlowTestCase247Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 249 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		if (!static_cast<FlowTestCase247Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase247ActorState(); static_cast<FlowTestCase247Actor*>(this)->destroy(); return 0; }
															#line 628 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase247Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase247ActorState();
		static_cast<FlowTestCase247Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 249 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
		if (!static_cast<FlowTestCase247Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase247ActorState(); static_cast<FlowTestCase247Actor*>(this)->destroy(); return 0; }
															#line 640 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
		new (&static_cast<FlowTestCase247Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase247ActorState();
		static_cast<FlowTestCase247Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase247Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase247Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase247Actor*>(this)->ActorCallback< FlowTestCase247Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase247Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase247", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase247Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase247", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase247Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase247", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase247Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase247", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase247Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase247", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase247Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase247", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 247 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
	UnitTestParameters params;
															#line 725 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase247()
															#line 247 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
class FlowTestCase247Actor final : public Actor<Void>, public ActorCallback< FlowTestCase247Actor, 0, Void >, public FastAllocated<FlowTestCase247Actor>, public FlowTestCase247ActorState<FlowTestCase247Actor> {
															#line 730 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase247Actor>::operator new;
	using FastAllocated<FlowTestCase247Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6679497559465997824UL, 5193942290853408768UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase247Actor, 0, Void >;
															#line 247 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
	FlowTestCase247Actor(UnitTestParameters const& params) 
															#line 747 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase247ActorState<FlowTestCase247Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase247", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5374695881978211328UL, 8763892027782956288UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase247Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase247");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase247", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase247Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 247 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
static Future<Void> flowTestCase247( UnitTestParameters const& params ) {
															#line 247 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
	return Future<Void>(new FlowTestCase247Actor(params));
															#line 780 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/UnitTests.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase247, "/fdbserver/UnitTestWorkload/long delay")

#line 251 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/workloads/UnitTests.actor.cpp"
