#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
/*
 * BlobManifest.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <algorithm>
#include <string>
#include <vector>

#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/BackupContainer.h"
#include "fdbclient/BlobGranuleCommon.h"
#include "fdbclient/BlobGranuleFiles.h"
#include "flow/Arena.h"
#include "flow/CodeProbe.h"
#include "flow/FastRef.h"
#include "flow/Trace.h"
#include "flow/flow.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/BlobConnectionProvider.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/KeyRangeMap.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/BackupContainerFileSystem.h"
#include "fdbclient/BlobGranuleReader.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/BlobGranuleServerCommon.actor.h"

#include "flow/actorcompiler.h" // has to be last include

//
// This module offers routines to dump or load blob manifest, which is used for full restore from granules.
//
// - Manifest includes a complete set of system keys which are essential to bootstrap blob manager and workers for
//   readBlobGranule API.
// - Epoch - manifest is generated by a blob manager. It's associated with epoch of the blob manager.
// - SeqNo - Blob manager dumps manifests periodically. Each manifest has a sequence number for each dumping
// - SegmentNo - Manifest may be too big to be processed as single file. So it's split as segments
//   when writing to external blob storage as manifest files.

// Default manifest folder on external blob storage
#define MANIFEST "manifest"

#define ENABLE_DEBUG_PRINT false
template <typename... T>
inline void dprint(fmt::format_string<T...> fmt, T&&... args) {
	if (ENABLE_DEBUG_PRINT)
		fmt::print(fmt, std::forward<T>(args)...);
}

// A blob manifest file contains partial content of a manifest.
// The file name includes the epoch of blob manager, a dump sequence number and segment number.
// For example: 1.2.3.manifest - the 3rd segment of the 2nd manifest file generated by blob manager with epoch 1.
struct BlobManifestFile {
	std::string fileName;
	int64_t epoch{ 0 };
	int64_t seqNo{ 0 };
	int64_t segmentNo{ 0 };

	BlobManifestFile(const std::string& path) {
		if (sscanf(path.c_str(), "%" SCNd64 ".%" SCNd64 ".%" SCNd64 "." MANIFEST, &epoch, &seqNo, &segmentNo) == 3) {
			fileName = path;
		}
	}

	bool belongToSameManifest(const BlobManifestFile& rhs) const { return epoch == rhs.epoch && seqNo == rhs.seqNo; }

	// Sort in descending order of {epoch, seqNo} and ascending order of segmentNo
	bool operator<(const BlobManifestFile& rhs) const {
		if (epoch == rhs.epoch) {
			if (seqNo == rhs.seqNo) { // compare seqNo if epoch is same
				return segmentNo < rhs.segmentNo; // compare segmentNo if seqNo is same
			} else {
				return seqNo > rhs.seqNo;
			}
		} else {
			return epoch > rhs.epoch;
		}
	}

	// List all blob manifest files, sorted in descending order of {epoch, seqNo} and ascending order of segmentNo
																#line 100 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via listAll()
															#line 98 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class ListAllActor>
															#line 98 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ListAllActorState {
															#line 106 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 98 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ListAllActorState(Reference<BackupContainerFileSystem> const& reader) 
															#line 98 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 98 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : reader(reader)
															#line 113 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("listAll", reinterpret_cast<unsigned long>(this));

	}
	~ListAllActorState() 
	{
		fdb_probe_actor_destroy("listAll", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 99 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			std::function<bool(std::string const&)> filter = [=](std::string const& path) { BlobManifestFile file(path); return file.epoch > 0 && file.seqNo > 0 && file.segmentNo > 0; };
															#line 103 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<BackupContainerFileSystem::FilesAndSizesT> __when_expr_0 = reader->listFiles("", filter);
															#line 103 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<ListAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 132 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListAllActor*>(this)->actor_wait_state = 1;
															#line 103 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListAllActor, 0, BackupContainerFileSystem::FilesAndSizesT >*>(static_cast<ListAllActor*>(this)));
															#line 137 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListAllActorState();
		static_cast<ListAllActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(BackupContainerFileSystem::FilesAndSizesT const& filesAndSizes,int loopDepth) 
	{
															#line 105 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		std::vector<BlobManifestFile> result;
															#line 106 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		for( auto& f : filesAndSizes ) {
															#line 107 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			BlobManifestFile file(f.first);
															#line 108 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			result.push_back(file);
															#line 166 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
															#line 110 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		std::sort(result.begin(), result.end());
															#line 111 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ListAllActor*>(this)->SAV<std::vector<BlobManifestFile>>::futures) { (void)(result); this->~ListAllActorState(); static_cast<ListAllActor*>(this)->destroy(); return 0; }
															#line 172 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ListAllActor*>(this)->SAV< std::vector<BlobManifestFile> >::value()) std::vector<BlobManifestFile>(result);
		this->~ListAllActorState();
		static_cast<ListAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(BackupContainerFileSystem::FilesAndSizesT && filesAndSizes,int loopDepth) 
	{
															#line 105 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		std::vector<BlobManifestFile> result;
															#line 106 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		for( auto& f : filesAndSizes ) {
															#line 107 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			BlobManifestFile file(f.first);
															#line 108 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			result.push_back(file);
															#line 190 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
															#line 110 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		std::sort(result.begin(), result.end());
															#line 111 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ListAllActor*>(this)->SAV<std::vector<BlobManifestFile>>::futures) { (void)(result); this->~ListAllActorState(); static_cast<ListAllActor*>(this)->destroy(); return 0; }
															#line 196 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ListAllActor*>(this)->SAV< std::vector<BlobManifestFile> >::value()) std::vector<BlobManifestFile>(result);
		this->~ListAllActorState();
		static_cast<ListAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(BackupContainerFileSystem::FilesAndSizesT const& filesAndSizes,int loopDepth) 
	{
		loopDepth = a_body1cont1(filesAndSizes, loopDepth);

		return loopDepth;
	}
	int a_body1when1(BackupContainerFileSystem::FilesAndSizesT && filesAndSizes,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(filesAndSizes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListAllActor*>(this)->actor_wait_state > 0) static_cast<ListAllActor*>(this)->actor_wait_state = 0;
		static_cast<ListAllActor*>(this)->ActorCallback< ListAllActor, 0, BackupContainerFileSystem::FilesAndSizesT >::remove();

	}
	void a_callback_fire(ActorCallback< ListAllActor, 0, BackupContainerFileSystem::FilesAndSizesT >*,BackupContainerFileSystem::FilesAndSizesT const& value) 
	{
		fdb_probe_actor_enter("listAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListAllActor, 0, BackupContainerFileSystem::FilesAndSizesT >*,BackupContainerFileSystem::FilesAndSizesT && value) 
	{
		fdb_probe_actor_enter("listAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListAllActor, 0, BackupContainerFileSystem::FilesAndSizesT >*,Error err) 
	{
		fdb_probe_actor_enter("listAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listAll", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 98 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BackupContainerFileSystem> reader;
															#line 281 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via listAll()
															#line 98 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ListAllActor final : public Actor<std::vector<BlobManifestFile>>, public ActorCallback< ListAllActor, 0, BackupContainerFileSystem::FilesAndSizesT >, public FastAllocated<ListAllActor>, public ListAllActorState<ListAllActor> {
															#line 286 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<ListAllActor>::operator new;
	using FastAllocated<ListAllActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10177096461851086080UL, 1151716119318681344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<BlobManifestFile>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListAllActor, 0, BackupContainerFileSystem::FilesAndSizesT >;
															#line 98 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ListAllActor(Reference<BackupContainerFileSystem> const& reader) 
															#line 303 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<std::vector<BlobManifestFile>>(),
		   ListAllActorState<ListAllActor>(reader),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listAll", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7335603402646281216UL, 6409437776465158400UL);
		ActorExecutionContextHelper __helper(static_cast<ListAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listAll");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listAll", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListAllActor, 0, BackupContainerFileSystem::FilesAndSizesT >*)0, actor_cancelled()); break;
		}

	}
};
															#line 98 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<std::vector<BlobManifestFile>> listAll( Reference<BackupContainerFileSystem> const& reader ) {
															#line 98 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<std::vector<BlobManifestFile>>(new ListAllActor(reader));
															#line 335 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 113 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
};

// BlobManifest is composed of segment files and a tailer file.
class BlobManifest {
public:
	BlobManifest() {}
	BlobManifest(std::vector<BlobManifestFile> files) : files_(files) {}

	// Return the tailer file
	BlobManifestFile tailer() {
		ASSERT(!files_.empty());
		return files_.front();
	}

	// Iterator for segment files
	std::vector<BlobManifestFile>::iterator segmentsBegin() { return files_.begin() + 1; }
	std::vector<BlobManifestFile>::iterator segmentsEnd() { return files_.end(); }

	// Return total number of segment files
	int totalSegments() {
		ASSERT(!files_.empty());
		return files_.size() - 1;
	}

	// Validate if manifest file segment numbers are continuous
	bool isValid() {
		ASSERT(!files_.empty());
		int64_t nextSegmentNo = 0;
		int64_t epoch = files_.front().epoch;
		int64_t seqNo = files_.front().seqNo;
		for (auto iter = files_.begin(); iter != files_.end(); ++iter) {
			ASSERT(iter->epoch == epoch);
			ASSERT(iter->seqNo == seqNo);
			if (iter->segmentNo != nextSegmentNo) {
				TraceEvent("BlobRestoreMissingSegment")
				    .detail("Epoch", epoch)
				    .detail("SeqNo", epoch)
				    .detail("Expected", nextSegmentNo)
				    .detail("Current", iter->segmentNo);
				return false;
			}
			nextSegmentNo++; // manifest segment number should be continuous
		}
		return true;
	}

	// Find latest manifest. The input manifest files are sorted by {epoch, seqNo} desc and segmentNo asc
	static BlobManifest latest(const std::vector<BlobManifestFile>& allFiles) {
		auto iter = allFiles.begin();
		std::vector<BlobManifestFile> result;
		while (iter != allFiles.end()) {
			const BlobManifestFile& firstFile = *iter;
			result.push_back(firstFile);
			// search all following files belonging to same manifest
			for (++iter; iter != allFiles.end(); ++iter) {
				if (iter->belongToSameManifest(firstFile)) {
					result.push_back(*iter);
				} else {
					break;
				}
			}

			// return the manifest if it's valid
			BlobManifest manifest(result);
			if (manifest.isValid()) {
				TraceEvent("BlobRestoreManifest")
				    .detail("FileName", firstFile.fileName)
				    .detail("Count", manifest.totalSegments());
				return manifest;
			} else {
				dprint("Skip corrupted manifest {} {}\n", firstFile.epoch, firstFile.seqNo);
				result.clear(); // prepare for next search
			}
		}

		dprint("No valid blob manifest files\n");
		TraceEvent("BlobRestoreMissingManifest").log();
		throw blob_restore_missing_manifest();
	}

	// Delete all files of oldest manifest
																#line 420 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via deleteOldest()
															#line 194 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class DeleteOldestActor>
															#line 194 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class DeleteOldestActorState {
															#line 426 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 194 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	DeleteOldestActorState(std::vector<BlobManifestFile> const& allFiles,Reference<BackupContainerFileSystem> const& container) 
															#line 194 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 194 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : allFiles(allFiles),
															#line 194 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   container(container)
															#line 435 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteOldest", reinterpret_cast<unsigned long>(this));

	}
	~DeleteOldestActorState() 
	{
		fdb_probe_actor_destroy("deleteOldest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 196 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			ASSERT(!allFiles.empty());
															#line 197 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			epoch = allFiles.back().epoch;
															#line 198 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			seqNo = allFiles.back().seqNo;
															#line 199 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			std::vector<Future<Void>> futures;
															#line 200 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			for( auto& f : allFiles ) {
															#line 201 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				if (f.epoch == epoch && f.seqNo == seqNo)
															#line 460 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				{
															#line 202 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
					futures.push_back(container->deleteFile(f.fileName));
															#line 464 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				}
			}
															#line 205 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(futures);
															#line 205 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<DeleteOldestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 471 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteOldestActor*>(this)->actor_wait_state = 1;
															#line 205 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteOldestActor, 0, Void >*>(static_cast<DeleteOldestActor*>(this)));
															#line 476 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteOldestActorState();
		static_cast<DeleteOldestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 206 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<DeleteOldestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteOldestActorState(); static_cast<DeleteOldestActor*>(this)->destroy(); return 0; }
															#line 499 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<DeleteOldestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteOldestActorState();
		static_cast<DeleteOldestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 206 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<DeleteOldestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteOldestActorState(); static_cast<DeleteOldestActor*>(this)->destroy(); return 0; }
															#line 511 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<DeleteOldestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteOldestActorState();
		static_cast<DeleteOldestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteOldestActor*>(this)->actor_wait_state > 0) static_cast<DeleteOldestActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteOldestActor*>(this)->ActorCallback< DeleteOldestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteOldestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteOldest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteOldestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteOldest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteOldestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteOldest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteOldestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteOldest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteOldestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteOldest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteOldestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteOldest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 194 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	std::vector<BlobManifestFile> allFiles;
															#line 194 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BackupContainerFileSystem> container;
															#line 197 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int64_t epoch;
															#line 198 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int64_t seqNo;
															#line 602 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via deleteOldest()
															#line 194 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class DeleteOldestActor final : public Actor<Void>, public ActorCallback< DeleteOldestActor, 0, Void >, public FastAllocated<DeleteOldestActor>, public DeleteOldestActorState<DeleteOldestActor> {
															#line 607 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<DeleteOldestActor>::operator new;
	using FastAllocated<DeleteOldestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5014008004496177664UL, 13371019879024841984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteOldestActor, 0, Void >;
															#line 194 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	DeleteOldestActor(std::vector<BlobManifestFile> const& allFiles,Reference<BackupContainerFileSystem> const& container) 
															#line 624 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteOldestActorState<DeleteOldestActor>(allFiles, container),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteOldest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4875600630383017216UL, 6835696739533155840UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteOldestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteOldest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteOldest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteOldestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 194 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> deleteOldest( std::vector<BlobManifestFile> const& allFiles, Reference<BackupContainerFileSystem> const& container ) {
															#line 194 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new DeleteOldestActor(allFiles, container));
															#line 656 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 208 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Count how many manifests
	static int count(const std::vector<BlobManifestFile>& allFiles) {
		if (allFiles.empty())
			return 0;

		int64_t epoch = allFiles.front().epoch;
		int64_t seqNo = allFiles.front().seqNo;
		int count = 1;
		for (auto& f : allFiles) {
			if (f.epoch != epoch || f.seqNo != seqNo) {
				count++;
				epoch = f.epoch;
				seqNo = f.seqNo;
			}
		}
		return count;
	}

private:
	std::vector<BlobManifestFile> files_;
};

// Splitter could write manifest content into a collection of files with bounded # rows
class BlobManifestFileSplitter : public ReferenceCounted<BlobManifestFileSplitter> {
public:
	BlobManifestFileSplitter(Reference<BlobConnectionProvider> blobConn,
	                         int64_t epoch,
	                         int64_t seqNo,
	                         Optional<BlobGranuleCipherKeysCtx> cipherKeysCtx)
	  : segmentNo_(1), blobConn_(blobConn), epoch_(epoch), seqNo_(seqNo), closed_(false), totalRows_(0),
	    logicalSize_(0), totalBytes_(0), cipherKeysCtx_(cipherKeysCtx) {}

	// Append a new row to the splitter
	void append(KeyValueRef row) {
		ASSERT(!closed_);
		rows_.push_back_deep(rows_.arena(), row);
		++totalRows_;
		logicalSize_ += row.expectedSize();
		if (logicalSize_ > SERVER_KNOBS->BLOB_RESTORE_MANIFEST_FILE_MAX_SIZE) {
			flushNext();
		}
	}

	// Append rows to the splitter
	void append(RangeResult rows) {
		ASSERT(!closed_);
		rows_.arena().dependsOn(rows.arena());
		rows_.append(rows_.arena(), rows.begin(), rows.size());
		totalRows_ += rows.size();
		logicalSize_ += rows.expectedSize();
		if (logicalSize_ > SERVER_KNOBS->BLOB_RESTORE_MANIFEST_FILE_MAX_SIZE) {
			flushNext();
		}
	}

	int64_t totalBytes() { return totalBytes_; }

	// Close the splitter. No more data should be added after
																#line 719 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via close()
															#line 267 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class CloseActor>
															#line 267 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class CloseActorState {
															#line 725 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 267 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	CloseActorState(Reference<BlobManifestFileSplitter> const& self) 
															#line 267 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 267 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self)
															#line 732 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("close", reinterpret_cast<unsigned long>(this));

	}
	~CloseActorState() 
	{
		fdb_probe_actor_destroy("close", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 268 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			self->flushNext();
															#line 269 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(self->pendingFutures_);
															#line 269 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<CloseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 751 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CloseActor*>(this)->actor_wait_state = 1;
															#line 269 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CloseActor, 0, Void >*>(static_cast<CloseActor*>(this)));
															#line 756 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CloseActorState();
		static_cast<CloseActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 270 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		self->pendingFutures_.clear();
															#line 271 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		self->flushTailer();
															#line 272 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(self->pendingFutures_);
															#line 272 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<CloseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 785 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CloseActor*>(this)->actor_wait_state = 2;
															#line 272 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CloseActor, 1, Void >*>(static_cast<CloseActor*>(this)));
															#line 790 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 270 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		self->pendingFutures_.clear();
															#line 271 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		self->flushTailer();
															#line 272 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(self->pendingFutures_);
															#line 272 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<CloseActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 805 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CloseActor*>(this)->actor_wait_state = 2;
															#line 272 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CloseActor, 1, Void >*>(static_cast<CloseActor*>(this)));
															#line 810 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CloseActor*>(this)->actor_wait_state > 0) static_cast<CloseActor*>(this)->actor_wait_state = 0;
		static_cast<CloseActor*>(this)->ActorCallback< CloseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CloseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("close", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("close", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CloseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("close", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("close", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CloseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("close", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("close", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 273 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		self->closed_ = true;
															#line 274 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<CloseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CloseActorState(); static_cast<CloseActor*>(this)->destroy(); return 0; }
															#line 896 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<CloseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CloseActorState();
		static_cast<CloseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 273 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		self->closed_ = true;
															#line 274 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<CloseActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CloseActorState(); static_cast<CloseActor*>(this)->destroy(); return 0; }
															#line 910 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<CloseActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CloseActorState();
		static_cast<CloseActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CloseActor*>(this)->actor_wait_state > 0) static_cast<CloseActor*>(this)->actor_wait_state = 0;
		static_cast<CloseActor*>(this)->ActorCallback< CloseActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CloseActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("close", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("close", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CloseActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("close", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("close", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CloseActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("close", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("close", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 267 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestFileSplitter> self;
															#line 995 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via close()
															#line 267 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class CloseActor final : public Actor<Void>, public ActorCallback< CloseActor, 0, Void >, public ActorCallback< CloseActor, 1, Void >, public FastAllocated<CloseActor>, public CloseActorState<CloseActor> {
															#line 1000 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<CloseActor>::operator new;
	using FastAllocated<CloseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16526504992317612288UL, 9711880410916862720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CloseActor, 0, Void >;
friend struct ActorCallback< CloseActor, 1, Void >;
															#line 267 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	CloseActor(Reference<BlobManifestFileSplitter> const& self) 
															#line 1018 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   CloseActorState<CloseActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("close", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9419912505739474944UL, 5603856312376563968UL);
		ActorExecutionContextHelper __helper(static_cast<CloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("close");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("close", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CloseActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CloseActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 267 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> close( Reference<BlobManifestFileSplitter> const& self ) {
															#line 267 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new CloseActor(self));
															#line 1051 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 276 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Reset writer and start to write from the beginning
																#line 1057 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via reset()
															#line 278 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class ResetActor>
															#line 278 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ResetActorState {
															#line 1063 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 278 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ResetActorState(Reference<BlobManifestFileSplitter> const& self) 
															#line 278 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 278 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self)
															#line 1070 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("reset", reinterpret_cast<unsigned long>(this));

	}
	~ResetActorState() 
	{
		fdb_probe_actor_destroy("reset", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 279 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			dprint("Reset manifest file {} {}\n", self->epoch_, self->seqNo_);
															#line 280 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			TraceEvent("ResetBlobManifestFile").detail("SegNo", self->segmentNo_);
															#line 281 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			self->rows_.clear();
															#line 282 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			self->segmentNo_ = 1;
															#line 283 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			self->totalRows_ = 0;
															#line 284 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			self->logicalSize_ = 0;
															#line 285 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			self->totalBytes_ = 0;
															#line 286 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(self->pendingFutures_);
															#line 286 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<ResetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1101 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ResetActor*>(this)->actor_wait_state = 1;
															#line 286 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ResetActor, 0, Void >*>(static_cast<ResetActor*>(this)));
															#line 1106 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ResetActorState();
		static_cast<ResetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		self->pendingFutures_.clear();
															#line 288 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		self->deleteSegmentFiles();
															#line 289 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(self->pendingFutures_);
															#line 289 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<ResetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1135 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ResetActor*>(this)->actor_wait_state = 2;
															#line 289 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ResetActor, 1, Void >*>(static_cast<ResetActor*>(this)));
															#line 1140 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		self->pendingFutures_.clear();
															#line 288 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		self->deleteSegmentFiles();
															#line 289 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(self->pendingFutures_);
															#line 289 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<ResetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1155 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ResetActor*>(this)->actor_wait_state = 2;
															#line 289 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ResetActor, 1, Void >*>(static_cast<ResetActor*>(this)));
															#line 1160 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ResetActor*>(this)->actor_wait_state > 0) static_cast<ResetActor*>(this)->actor_wait_state = 0;
		static_cast<ResetActor*>(this)->ActorCallback< ResetActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResetActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reset", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reset", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ResetActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reset", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reset", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ResetActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reset", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reset", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 290 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ResetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResetActorState(); static_cast<ResetActor*>(this)->destroy(); return 0; }
															#line 1244 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ResetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResetActorState();
		static_cast<ResetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 290 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ResetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ResetActorState(); static_cast<ResetActor*>(this)->destroy(); return 0; }
															#line 1256 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ResetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ResetActorState();
		static_cast<ResetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ResetActor*>(this)->actor_wait_state > 0) static_cast<ResetActor*>(this)->actor_wait_state = 0;
		static_cast<ResetActor*>(this)->ActorCallback< ResetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ResetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("reset", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reset", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ResetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("reset", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ResetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reset", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ResetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("reset", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ResetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("reset", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 278 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestFileSplitter> self;
															#line 1341 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via reset()
															#line 278 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ResetActor final : public Actor<Void>, public ActorCallback< ResetActor, 0, Void >, public ActorCallback< ResetActor, 1, Void >, public FastAllocated<ResetActor>, public ResetActorState<ResetActor> {
															#line 1346 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<ResetActor>::operator new;
	using FastAllocated<ResetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13520935123045722880UL, 746913611063436288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ResetActor, 0, Void >;
friend struct ActorCallback< ResetActor, 1, Void >;
															#line 278 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ResetActor(Reference<BlobManifestFileSplitter> const& self) 
															#line 1364 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   ResetActorState<ResetActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("reset", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16247258192305665536UL, 536915242178975744UL);
		ActorExecutionContextHelper __helper(static_cast<ResetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("reset");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("reset", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ResetActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ResetActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 278 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> reset( Reference<BlobManifestFileSplitter> const& self ) {
															#line 278 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new ResetActor(self));
															#line 1397 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 292 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

private:
	// Write next segment
	void flushNext() {
		std::string fname = fileName(segmentNo_);
		Optional<CompressionFilter> compressionFilter;
		Value bytes = serializeChunkedSnapshot(StringRef(fname),
		                                       rows_,
		                                       SERVER_KNOBS->BG_SNAPSHOT_FILE_TARGET_CHUNK_BYTES,
		                                       compressionFilter,
		                                       cipherKeysCtx_,
		                                       false);
		pendingFutures_.push_back(writeToFile(this, bytes, fname));
		TraceEvent("BlobManifestFile").detail("Rows", rows_.size()).detail("SegNo", segmentNo_);

		rows_.clear();
		segmentNo_++;
		totalBytes_ += bytes.size();
		logicalSize_ = 0;
	}

	// Write tailer(segment 0). A manifest is completed only after the tailer is written
	void flushTailer() {
		Standalone<BlobManifestTailer> tailer;
		tailer.totalRows = totalRows_;
		tailer.totalSegments = segmentNo_ - 1;
		tailer.totalBytes = totalBytes_;
		if (cipherKeysCtx_.present()) {
			tailer.cipherKeysMeta = BlobGranuleCipherKeysCtx::toCipherKeysMeta(cipherKeysCtx_.get());
		}

		Value bytes = BinaryWriter::toValue(tailer, IncludeVersion(ProtocolVersion::withBlobGranuleFile()));
		std::string fname = fileName(0);
		pendingFutures_.push_back(writeToFile(this, bytes, fname));
	}

	// Manifest file name for given segment
	std::string fileName(int64_t segmentNo) { return format("%lld.%lld.%lld." MANIFEST, epoch_, seqNo_, segmentNo); }

	// Write data to a manifest file
																#line 1441 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via writeToFile()
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class WriteToFileActor>
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class WriteToFileActorState {
															#line 1447 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	WriteToFileActorState(BlobManifestFileSplitter* const& self,Value const& data,std::string const& fileName) 
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   data(data),
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   fileName(fileName),
															#line 333 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   writer(),
															#line 334 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   fullPath()
															#line 1462 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("writeToFile", reinterpret_cast<unsigned long>(this));

	}
	~WriteToFileActorState() 
	{
		fdb_probe_actor_destroy("writeToFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 335 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			std::tie(writer, fullPath) = self->blobConn_->createForWrite(MANIFEST);
															#line 337 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Reference<IBackupFile>> __when_expr_0 = writer->writeFile(fileName);
															#line 337 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<WriteToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1481 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteToFileActor*>(this)->actor_wait_state = 1;
															#line 337 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteToFileActor, 0, Reference<IBackupFile> >*>(static_cast<WriteToFileActor*>(this)));
															#line 1486 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteToFileActorState();
		static_cast<WriteToFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 338 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = file->append(data.begin(), data.size());
															#line 338 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<WriteToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1511 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteToFileActor*>(this)->actor_wait_state = 2;
															#line 338 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteToFileActor, 1, Void >*>(static_cast<WriteToFileActor*>(this)));
															#line 1516 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IBackupFile> const& __file,int loopDepth) 
	{
															#line 337 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		file = __file;
															#line 1525 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IBackupFile> && __file,int loopDepth) 
	{
		file = std::move(__file);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteToFileActor*>(this)->actor_wait_state > 0) static_cast<WriteToFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteToFileActor*>(this)->ActorCallback< WriteToFileActor, 0, Reference<IBackupFile> >::remove();

	}
	void a_callback_fire(ActorCallback< WriteToFileActor, 0, Reference<IBackupFile> >*,Reference<IBackupFile> const& value) 
	{
		fdb_probe_actor_enter("writeToFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeToFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteToFileActor, 0, Reference<IBackupFile> >*,Reference<IBackupFile> && value) 
	{
		fdb_probe_actor_enter("writeToFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeToFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteToFileActor, 0, Reference<IBackupFile> >*,Error err) 
	{
		fdb_probe_actor_enter("writeToFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeToFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 339 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->finish();
															#line 339 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<WriteToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1606 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteToFileActor*>(this)->actor_wait_state = 3;
															#line 339 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteToFileActor, 2, Void >*>(static_cast<WriteToFileActor*>(this)));
															#line 1611 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 339 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->finish();
															#line 339 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<WriteToFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1622 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<WriteToFileActor*>(this)->actor_wait_state = 3;
															#line 339 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteToFileActor, 2, Void >*>(static_cast<WriteToFileActor*>(this)));
															#line 1627 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteToFileActor*>(this)->actor_wait_state > 0) static_cast<WriteToFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteToFileActor*>(this)->ActorCallback< WriteToFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteToFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeToFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeToFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteToFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeToFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeToFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteToFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeToFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeToFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 340 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("Write blob manifest file {} with {} bytes\n", fileName, data.size());
															#line 341 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<WriteToFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteToFileActorState(); static_cast<WriteToFileActor*>(this)->destroy(); return 0; }
															#line 1713 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<WriteToFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteToFileActorState();
		static_cast<WriteToFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 340 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("Write blob manifest file {} with {} bytes\n", fileName, data.size());
															#line 341 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<WriteToFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteToFileActorState(); static_cast<WriteToFileActor*>(this)->destroy(); return 0; }
															#line 1727 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<WriteToFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteToFileActorState();
		static_cast<WriteToFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteToFileActor*>(this)->actor_wait_state > 0) static_cast<WriteToFileActor*>(this)->actor_wait_state = 0;
		static_cast<WriteToFileActor*>(this)->ActorCallback< WriteToFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteToFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeToFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeToFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteToFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeToFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeToFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteToFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeToFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeToFile", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	BlobManifestFileSplitter* self;
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Value data;
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	std::string fileName;
															#line 333 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BackupContainerFileSystem> writer;
															#line 334 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	std::string fullPath;
															#line 337 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<IBackupFile> file;
															#line 1822 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via writeToFile()
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class WriteToFileActor final : public Actor<Void>, public ActorCallback< WriteToFileActor, 0, Reference<IBackupFile> >, public ActorCallback< WriteToFileActor, 1, Void >, public ActorCallback< WriteToFileActor, 2, Void >, public FastAllocated<WriteToFileActor>, public WriteToFileActorState<WriteToFileActor> {
															#line 1827 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<WriteToFileActor>::operator new;
	using FastAllocated<WriteToFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15783317547700644864UL, 7691653412741401600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteToFileActor, 0, Reference<IBackupFile> >;
friend struct ActorCallback< WriteToFileActor, 1, Void >;
friend struct ActorCallback< WriteToFileActor, 2, Void >;
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	WriteToFileActor(BlobManifestFileSplitter* const& self,Value const& data,std::string const& fileName) 
															#line 1846 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   WriteToFileActorState<WriteToFileActor>(self, data, fileName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeToFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3165418012280509696UL, 3414447353737447936UL);
		ActorExecutionContextHelper __helper(static_cast<WriteToFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeToFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeToFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteToFileActor, 0, Reference<IBackupFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteToFileActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteToFileActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> writeToFile( BlobManifestFileSplitter* const& self, Value const& data, std::string const& fileName ) {
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new WriteToFileActor(self, data, fileName));
															#line 1880 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 343 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Delete all written segment files
	void deleteSegmentFiles() {
		Reference<BackupContainerFileSystem> container;
		std::string fullPath;
		std::tie(container, fullPath) = blobConn_->createForWrite(MANIFEST);

		int i = 1;
		while (i < segmentNo_) {
			pendingFutures_.push_back(container->deleteFile(fileName(i)));
			++i;
		}
	}

	Standalone<GranuleSnapshot> rows_;
	Reference<BlobConnectionProvider> blobConn_;
	int64_t epoch_;
	int64_t seqNo_;
	int64_t segmentNo_;
	int64_t totalRows_;
	int64_t logicalSize_;
	int64_t totalBytes_;
	std::vector<Future<Void>> pendingFutures_;
	bool closed_;
	Optional<BlobGranuleCipherKeysCtx> cipherKeysCtx_;
};

															#line 1911 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
namespace {
// This generated class is to be used only via getLatestManifestCipherKeys()
															#line 370 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class GetLatestManifestCipherKeysActor>
															#line 370 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class GetLatestManifestCipherKeysActorState {
															#line 1918 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 370 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	GetLatestManifestCipherKeysActorState(Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Arena* const& arena) 
															#line 370 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 370 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : dbInfo(dbInfo),
															#line 370 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   arena(arena),
															#line 372 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   cipherKeysCtx()
															#line 1929 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this));

	}
	~GetLatestManifestCipherKeysActorState() 
	{
		fdb_probe_actor_destroy("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 373 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>>> __when_expr_0 = GetEncryptCipherKeys<ServerDBInfo>::getLatestEncryptCipherKeys( dbInfo, { FDB_DEFAULT_ENCRYPT_DOMAIN_ID }, BlobCipherMetrics::BLOB_GRANULE);
															#line 373 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<GetLatestManifestCipherKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1946 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetLatestManifestCipherKeysActor*>(this)->actor_wait_state = 1;
															#line 373 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetLatestManifestCipherKeysActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*>(static_cast<GetLatestManifestCipherKeysActor*>(this)));
															#line 1951 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetLatestManifestCipherKeysActorState();
		static_cast<GetLatestManifestCipherKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& domainKeyMap,int loopDepth) 
	{
															#line 377 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		auto domainKeyItr = domainKeyMap.find(FDB_DEFAULT_ENCRYPT_DOMAIN_ID);
															#line 378 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		ASSERT(domainKeyItr != domainKeyMap.end());
															#line 379 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		cipherKeysCtx.textCipherKey = BlobGranuleCipherKey::fromBlobCipherKey(domainKeyItr->second, *arena);
															#line 381 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<TextAndHeaderCipherKeys> __when_expr_1 = GetEncryptCipherKeys<ServerDBInfo>::getLatestSystemEncryptCipherKeys(dbInfo, BlobCipherMetrics::BLOB_GRANULE);
															#line 381 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<GetLatestManifestCipherKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1982 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetLatestManifestCipherKeysActor*>(this)->actor_wait_state = 2;
															#line 381 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetLatestManifestCipherKeysActor, 1, TextAndHeaderCipherKeys >*>(static_cast<GetLatestManifestCipherKeysActor*>(this)));
															#line 1987 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && domainKeyMap,int loopDepth) 
	{
															#line 377 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		auto domainKeyItr = domainKeyMap.find(FDB_DEFAULT_ENCRYPT_DOMAIN_ID);
															#line 378 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		ASSERT(domainKeyItr != domainKeyMap.end());
															#line 379 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		cipherKeysCtx.textCipherKey = BlobGranuleCipherKey::fromBlobCipherKey(domainKeyItr->second, *arena);
															#line 381 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<TextAndHeaderCipherKeys> __when_expr_1 = GetEncryptCipherKeys<ServerDBInfo>::getLatestSystemEncryptCipherKeys(dbInfo, BlobCipherMetrics::BLOB_GRANULE);
															#line 381 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<GetLatestManifestCipherKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2004 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<GetLatestManifestCipherKeysActor*>(this)->actor_wait_state = 2;
															#line 381 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetLatestManifestCipherKeysActor, 1, TextAndHeaderCipherKeys >*>(static_cast<GetLatestManifestCipherKeysActor*>(this)));
															#line 2009 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& domainKeyMap,int loopDepth) 
	{
		loopDepth = a_body1cont1(domainKeyMap, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && domainKeyMap,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(domainKeyMap), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetLatestManifestCipherKeysActor*>(this)->actor_wait_state > 0) static_cast<GetLatestManifestCipherKeysActor*>(this)->actor_wait_state = 0;
		static_cast<GetLatestManifestCipherKeysActor*>(this)->ActorCallback< GetLatestManifestCipherKeysActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >::remove();

	}
	void a_callback_fire(ActorCallback< GetLatestManifestCipherKeysActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> const& value) 
	{
		fdb_probe_actor_enter("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestManifestCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetLatestManifestCipherKeysActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> && value) 
	{
		fdb_probe_actor_enter("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestManifestCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetLatestManifestCipherKeysActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*,Error err) 
	{
		fdb_probe_actor_enter("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestManifestCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
															#line 383 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		ASSERT(cipherKeys.cipherHeaderKey.isValid());
															#line 384 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		cipherKeysCtx.headerCipherKey = BlobGranuleCipherKey::fromBlobCipherKey(cipherKeys.cipherHeaderKey, *arena);
															#line 386 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		cipherKeysCtx.ivRef = makeString(AES_256_IV_LENGTH, *arena);
															#line 387 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		deterministicRandom()->randomBytes(mutateString(cipherKeysCtx.ivRef), AES_256_IV_LENGTH);
															#line 389 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<GetLatestManifestCipherKeysActor*>(this)->SAV<BlobGranuleCipherKeysCtx>::futures) { (void)(cipherKeysCtx); this->~GetLatestManifestCipherKeysActorState(); static_cast<GetLatestManifestCipherKeysActor*>(this)->destroy(); return 0; }
															#line 2101 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<GetLatestManifestCipherKeysActor*>(this)->SAV< BlobGranuleCipherKeysCtx >::value()) BlobGranuleCipherKeysCtx(std::move(cipherKeysCtx)); // state_var_RVO
		this->~GetLatestManifestCipherKeysActorState();
		static_cast<GetLatestManifestCipherKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
															#line 383 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		ASSERT(cipherKeys.cipherHeaderKey.isValid());
															#line 384 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		cipherKeysCtx.headerCipherKey = BlobGranuleCipherKey::fromBlobCipherKey(cipherKeys.cipherHeaderKey, *arena);
															#line 386 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		cipherKeysCtx.ivRef = makeString(AES_256_IV_LENGTH, *arena);
															#line 387 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		deterministicRandom()->randomBytes(mutateString(cipherKeysCtx.ivRef), AES_256_IV_LENGTH);
															#line 389 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<GetLatestManifestCipherKeysActor*>(this)->SAV<BlobGranuleCipherKeysCtx>::futures) { (void)(cipherKeysCtx); this->~GetLatestManifestCipherKeysActorState(); static_cast<GetLatestManifestCipherKeysActor*>(this)->destroy(); return 0; }
															#line 2121 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<GetLatestManifestCipherKeysActor*>(this)->SAV< BlobGranuleCipherKeysCtx >::value()) BlobGranuleCipherKeysCtx(std::move(cipherKeysCtx)); // state_var_RVO
		this->~GetLatestManifestCipherKeysActorState();
		static_cast<GetLatestManifestCipherKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(TextAndHeaderCipherKeys const& cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont2(cipherKeys, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(TextAndHeaderCipherKeys && cipherKeys,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(cipherKeys), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetLatestManifestCipherKeysActor*>(this)->actor_wait_state > 0) static_cast<GetLatestManifestCipherKeysActor*>(this)->actor_wait_state = 0;
		static_cast<GetLatestManifestCipherKeysActor*>(this)->ActorCallback< GetLatestManifestCipherKeysActor, 1, TextAndHeaderCipherKeys >::remove();

	}
	void a_callback_fire(ActorCallback< GetLatestManifestCipherKeysActor, 1, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys const& value) 
	{
		fdb_probe_actor_enter("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestManifestCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetLatestManifestCipherKeysActor, 1, TextAndHeaderCipherKeys >*,TextAndHeaderCipherKeys && value) 
	{
		fdb_probe_actor_enter("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestManifestCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetLatestManifestCipherKeysActor, 1, TextAndHeaderCipherKeys >*,Error err) 
	{
		fdb_probe_actor_enter("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestManifestCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 370 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 370 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Arena* arena;
															#line 372 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	BlobGranuleCipherKeysCtx cipherKeysCtx;
															#line 2210 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via getLatestManifestCipherKeys()
															#line 370 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class GetLatestManifestCipherKeysActor final : public Actor<BlobGranuleCipherKeysCtx>, public ActorCallback< GetLatestManifestCipherKeysActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >, public ActorCallback< GetLatestManifestCipherKeysActor, 1, TextAndHeaderCipherKeys >, public FastAllocated<GetLatestManifestCipherKeysActor>, public GetLatestManifestCipherKeysActorState<GetLatestManifestCipherKeysActor> {
															#line 2215 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<GetLatestManifestCipherKeysActor>::operator new;
	using FastAllocated<GetLatestManifestCipherKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11032413403452193024UL, 696776842105844736UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BlobGranuleCipherKeysCtx>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetLatestManifestCipherKeysActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >;
friend struct ActorCallback< GetLatestManifestCipherKeysActor, 1, TextAndHeaderCipherKeys >;
															#line 370 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	GetLatestManifestCipherKeysActor(Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Arena* const& arena) 
															#line 2233 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<BlobGranuleCipherKeysCtx>(),
		   GetLatestManifestCipherKeysActorState<GetLatestManifestCipherKeysActor>(dbInfo, arena),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5894442095971939072UL, 15852311495275377408UL);
		ActorExecutionContextHelper __helper(static_cast<GetLatestManifestCipherKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getLatestManifestCipherKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getLatestManifestCipherKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetLatestManifestCipherKeysActor, 0, std::unordered_map<EncryptCipherDomainId, Reference<BlobCipherKey>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetLatestManifestCipherKeysActor, 1, TextAndHeaderCipherKeys >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 370 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] Future<BlobGranuleCipherKeysCtx> getLatestManifestCipherKeys( Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Arena* const& arena ) {
															#line 370 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<BlobGranuleCipherKeysCtx>(new GetLatestManifestCipherKeysActor(dbInfo, arena));
															#line 2267 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 391 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

// This class dumps blob manifest to external blob storage.
class BlobManifestDumper : public ReferenceCounted<BlobManifestDumper> {
public:
	BlobManifestDumper(Database& db,
	                   Reference<AsyncVar<ServerDBInfo> const> dbInfo,
	                   Reference<BlobConnectionProvider> blobConn,
	                   int64_t epoch,
	                   int64_t seqNo,
	                   bool encryptionEnabled)
	  : db_(db), blobConn_(blobConn), epoch_(epoch), seqNo_(seqNo), dbInfo_(dbInfo),
	    encryptionEnabled_(encryptionEnabled) {}
	virtual ~BlobManifestDumper() {}

	// Execute the dumper
																#line 2286 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via execute()
															#line 406 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class ExecuteActor>
															#line 406 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ExecuteActorState {
															#line 2292 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 406 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ExecuteActorState(Reference<BlobManifestDumper> const& self) 
															#line 406 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 406 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self)
															#line 2299 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("execute", reinterpret_cast<unsigned long>(this));

	}
	~ExecuteActorState() 
	{
		fdb_probe_actor_destroy("execute", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 408 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				StrictFuture<int64_t> __when_expr_0 = dump(self);
															#line 408 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				if (static_cast<ExecuteActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2317 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ExecuteActor*>(this)->actor_wait_state = 1;
															#line 408 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExecuteActor, 0, int64_t >*>(static_cast<ExecuteActor*>(this)));
															#line 2322 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExecuteActorState();
		static_cast<ExecuteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 412 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			dprint("WARNING: unexpected blob manifest dumper error {}\n", e.what());
															#line 413 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (!static_cast<ExecuteActor*>(this)->SAV<int64_t>::futures) { (void)(0); this->~ExecuteActorState(); static_cast<ExecuteActor*>(this)->destroy(); return 0; }
															#line 2354 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			new (&static_cast<ExecuteActor*>(this)->SAV< int64_t >::value()) int64_t(0);
			this->~ExecuteActorState();
			static_cast<ExecuteActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 409 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = cleanup(self);
															#line 409 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<ExecuteActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 2374 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExecuteActor*>(this)->actor_wait_state = 2;
															#line 409 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExecuteActor, 1, Void >*>(static_cast<ExecuteActor*>(this)));
															#line 2379 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int64_t const& __bytes,int loopDepth) 
	{
															#line 408 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		bytes = __bytes;
															#line 2388 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && __bytes,int loopDepth) 
	{
		bytes = std::move(__bytes);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExecuteActor*>(this)->actor_wait_state > 0) static_cast<ExecuteActor*>(this)->actor_wait_state = 0;
		static_cast<ExecuteActor*>(this)->ActorCallback< ExecuteActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< ExecuteActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExecuteActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExecuteActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execute", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 410 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ExecuteActor*>(this)->SAV<int64_t>::futures) { (void)(bytes); this->~ExecuteActorState(); static_cast<ExecuteActor*>(this)->destroy(); return 0; }
															#line 2467 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ExecuteActor*>(this)->SAV< int64_t >::value()) int64_t(std::move(bytes)); // state_var_RVO
		this->~ExecuteActorState();
		static_cast<ExecuteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 410 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ExecuteActor*>(this)->SAV<int64_t>::futures) { (void)(bytes); this->~ExecuteActorState(); static_cast<ExecuteActor*>(this)->destroy(); return 0; }
															#line 2479 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ExecuteActor*>(this)->SAV< int64_t >::value()) int64_t(std::move(bytes)); // state_var_RVO
		this->~ExecuteActorState();
		static_cast<ExecuteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExecuteActor*>(this)->actor_wait_state > 0) static_cast<ExecuteActor*>(this)->actor_wait_state = 0;
		static_cast<ExecuteActor*>(this)->ActorCallback< ExecuteActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExecuteActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExecuteActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExecuteActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execute", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 406 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestDumper> self;
															#line 408 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int64_t bytes;
															#line 2566 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via execute()
															#line 406 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ExecuteActor final : public Actor<int64_t>, public ActorCallback< ExecuteActor, 0, int64_t >, public ActorCallback< ExecuteActor, 1, Void >, public FastAllocated<ExecuteActor>, public ExecuteActorState<ExecuteActor> {
															#line 2571 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<ExecuteActor>::operator new;
	using FastAllocated<ExecuteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7833566249667374336UL, 13040891862336798976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExecuteActor, 0, int64_t >;
friend struct ActorCallback< ExecuteActor, 1, Void >;
															#line 406 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ExecuteActor(Reference<BlobManifestDumper> const& self) 
															#line 2589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<int64_t>(),
		   ExecuteActorState<ExecuteActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("execute", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8703361184122104832UL, 10021404704877615360UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("execute");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("execute", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExecuteActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExecuteActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 406 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<int64_t> execute( Reference<BlobManifestDumper> const& self ) {
															#line 406 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<int64_t>(new ExecuteActor(self));
															#line 2622 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 416 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

private:
	// Read system keys and write to manifest files
																#line 2629 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via dump()
															#line 419 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class DumpActor>
															#line 419 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class DumpActorState {
															#line 2635 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 419 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	DumpActorState(Reference<BlobManifestDumper> const& self) 
															#line 419 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 419 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 420 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   arena(),
															#line 421 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   cipherKeysCtx()
															#line 2646 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("dump", reinterpret_cast<unsigned long>(this));

	}
	~DumpActorState() 
	{
		fdb_probe_actor_destroy("dump", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 422 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (self->encryptionEnabled_)
															#line 2661 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			{
															#line 423 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				StrictFuture<BlobGranuleCipherKeysCtx> __when_expr_0 = getLatestManifestCipherKeys(self->dbInfo_, &arena);
															#line 423 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				if (static_cast<DumpActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2667 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DumpActor*>(this)->actor_wait_state = 1;
															#line 423 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DumpActor, 0, BlobGranuleCipherKeysCtx >*>(static_cast<DumpActor*>(this)));
															#line 2672 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpActorState();
		static_cast<DumpActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 427 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		splitter = makeReference<BlobManifestFileSplitter>(self->blobConn_, self->epoch_, self->seqNo_, cipherKeysCtx);
															#line 429 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr = Transaction(self->db_);
															#line 431 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		;
															#line 2704 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(BlobGranuleCipherKeysCtx const& ctx,int loopDepth) 
	{
															#line 424 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		cipherKeysCtx = ctx;
															#line 2713 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(BlobGranuleCipherKeysCtx && ctx,int loopDepth) 
	{
															#line 424 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		cipherKeysCtx = ctx;
															#line 2722 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(BlobGranuleCipherKeysCtx const& ctx,int loopDepth) 
	{
		loopDepth = a_body1cont2(ctx, loopDepth);

		return loopDepth;
	}
	int a_body1when1(BlobGranuleCipherKeysCtx && ctx,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(ctx), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpActor*>(this)->actor_wait_state > 0) static_cast<DumpActor*>(this)->actor_wait_state = 0;
		static_cast<DumpActor*>(this)->ActorCallback< DumpActor, 0, BlobGranuleCipherKeysCtx >::remove();

	}
	void a_callback_fire(ActorCallback< DumpActor, 0, BlobGranuleCipherKeysCtx >*,BlobGranuleCipherKeysCtx const& value) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DumpActor, 0, BlobGranuleCipherKeysCtx >*,BlobGranuleCipherKeysCtx && value) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DumpActor, 0, BlobGranuleCipherKeysCtx >*,Error err) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 433 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			std::vector<KeyRangeRef> ranges = { blobGranuleMappingKeys, blobRangeKeys };
															#line 438 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			for( auto& r : getSystemBackupRanges() ) {
															#line 439 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				ranges.push_back(r);
															#line 2818 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			}
															#line 442 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			ranges.push_back(KeyRangeRef(metadataVersionKey, metadataVersionKeyEnd));
															#line 443 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Version> __when_expr_1 = dumpRanges(self, splitter, ranges);
															#line 443 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<DumpActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2826 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DumpActor*>(this)->actor_wait_state = 2;
															#line 443 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DumpActor, 1, Version >*>(static_cast<DumpActor*>(this)));
															#line 2831 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 462 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			TraceEvent("BlobManifestDumpError").error(e).log();
															#line 463 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			dprint("Manifest dumping error {}\n", e.what());
															#line 464 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_5 = BlobManifestFileSplitter::reset(splitter);
															#line 464 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<DumpActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2859 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<DumpActor*>(this)->actor_wait_state = 6;
															#line 464 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DumpActor, 5, Void >*>(static_cast<DumpActor*>(this)));
															#line 2864 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(int loopDepth) 
	{
															#line 446 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_2 = dumpRange(self, splitter, blobGranuleHistoryKeys, [=](KeyValueRef row) { return shouldDumpBlobGranuleHistoryKey(row, readVersion); });
															#line 446 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<DumpActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2881 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DumpActor*>(this)->actor_wait_state = 3;
															#line 446 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DumpActor, 2, Void >*>(static_cast<DumpActor*>(this)));
															#line 2886 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version const& __readVersion,int loopDepth) 
	{
															#line 443 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		readVersion = __readVersion;
															#line 2895 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Version && __readVersion,int loopDepth) 
	{
		readVersion = std::move(__readVersion);
		loopDepth = a_body1cont1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DumpActor*>(this)->actor_wait_state > 0) static_cast<DumpActor*>(this)->actor_wait_state = 0;
		static_cast<DumpActor*>(this)->ActorCallback< DumpActor, 1, Version >::remove();

	}
	void a_callback_fire(ActorCallback< DumpActor, 1, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DumpActor, 1, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DumpActor, 1, Version >*,Error err) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 450 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_3 = dumpRange(self, splitter, blobGranuleFileKeys, [=](KeyValueRef row) { return shouldDumpBlobGranuleFileKey(row, readVersion); });
															#line 450 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<DumpActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2976 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<DumpActor*>(this)->actor_wait_state = 4;
															#line 450 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DumpActor, 3, Void >*>(static_cast<DumpActor*>(this)));
															#line 2981 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 450 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_3 = dumpRange(self, splitter, blobGranuleFileKeys, [=](KeyValueRef row) { return shouldDumpBlobGranuleFileKey(row, readVersion); });
															#line 450 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<DumpActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2992 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont1loopBody1cont4when1(__when_expr_3.get(), loopDepth); };
		static_cast<DumpActor*>(this)->actor_wait_state = 4;
															#line 450 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DumpActor, 3, Void >*>(static_cast<DumpActor*>(this)));
															#line 2997 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DumpActor*>(this)->actor_wait_state > 0) static_cast<DumpActor*>(this)->actor_wait_state = 0;
		static_cast<DumpActor*>(this)->ActorCallback< DumpActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DumpActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DumpActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 455 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_4 = BlobManifestFileSplitter::close(splitter);
															#line 455 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<DumpActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3083 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<DumpActor*>(this)->actor_wait_state = 5;
															#line 455 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DumpActor, 4, Void >*>(static_cast<DumpActor*>(this)));
															#line 3088 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 455 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_4 = BlobManifestFileSplitter::close(splitter);
															#line 455 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<DumpActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3099 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<DumpActor*>(this)->actor_wait_state = 5;
															#line 455 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DumpActor, 4, Void >*>(static_cast<DumpActor*>(this)));
															#line 3104 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DumpActor*>(this)->actor_wait_state > 0) static_cast<DumpActor*>(this)->actor_wait_state = 0;
		static_cast<DumpActor*>(this)->ActorCallback< DumpActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DumpActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DumpActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 456 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		TraceEvent("BlobManifestDump") .detail("Size", splitter->totalBytes()) .detail("Encrypted", self->encryptionEnabled_) .detail("Version", readVersion);
															#line 460 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<DumpActor*>(this)->SAV<int64_t>::futures) { (void)(splitter->totalBytes()); this->~DumpActorState(); static_cast<DumpActor*>(this)->destroy(); return 0; }
															#line 3190 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<DumpActor*>(this)->SAV< int64_t >::value()) int64_t(splitter->totalBytes());
		this->~DumpActorState();
		static_cast<DumpActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 456 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		TraceEvent("BlobManifestDump") .detail("Size", splitter->totalBytes()) .detail("Encrypted", self->encryptionEnabled_) .detail("Version", readVersion);
															#line 460 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<DumpActor*>(this)->SAV<int64_t>::futures) { (void)(splitter->totalBytes()); this->~DumpActorState(); static_cast<DumpActor*>(this)->destroy(); return 0; }
															#line 3204 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<DumpActor*>(this)->SAV< int64_t >::value()) int64_t(splitter->totalBytes());
		this->~DumpActorState();
		static_cast<DumpActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DumpActor*>(this)->actor_wait_state > 0) static_cast<DumpActor*>(this)->actor_wait_state = 0;
		static_cast<DumpActor*>(this)->ActorCallback< DumpActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DumpActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DumpActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 466 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(SERVER_KNOBS->BLOB_MANIFEST_RETRY_INTERVAL);
															#line 466 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<DumpActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3293 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<DumpActor*>(this)->actor_wait_state = 7;
															#line 466 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DumpActor, 6, Void >*>(static_cast<DumpActor*>(this)));
															#line 3298 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 466 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_6 = delay(SERVER_KNOBS->BLOB_MANIFEST_RETRY_INTERVAL);
															#line 466 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<DumpActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3309 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch1(__when_expr_6.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1cont1when1(__when_expr_6.get(), loopDepth); };
		static_cast<DumpActor*>(this)->actor_wait_state = 7;
															#line 466 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DumpActor, 6, Void >*>(static_cast<DumpActor*>(this)));
															#line 3314 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DumpActor*>(this)->actor_wait_state > 0) static_cast<DumpActor*>(this)->actor_wait_state = 0;
		static_cast<DumpActor*>(this)->ActorCallback< DumpActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DumpActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DumpActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DumpActor*>(this)->actor_wait_state > 0) static_cast<DumpActor*>(this)->actor_wait_state = 0;
		static_cast<DumpActor*>(this)->ActorCallback< DumpActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DumpActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont1loopBody1Catch1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DumpActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 419 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestDumper> self;
															#line 420 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Arena arena;
															#line 421 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Optional<BlobGranuleCipherKeysCtx> cipherKeysCtx;
															#line 427 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestFileSplitter> splitter;
															#line 429 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Transaction tr;
															#line 443 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Version readVersion;
															#line 3493 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via dump()
															#line 419 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class DumpActor final : public Actor<int64_t>, public ActorCallback< DumpActor, 0, BlobGranuleCipherKeysCtx >, public ActorCallback< DumpActor, 1, Version >, public ActorCallback< DumpActor, 2, Void >, public ActorCallback< DumpActor, 3, Void >, public ActorCallback< DumpActor, 4, Void >, public ActorCallback< DumpActor, 5, Void >, public ActorCallback< DumpActor, 6, Void >, public FastAllocated<DumpActor>, public DumpActorState<DumpActor> {
															#line 3498 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<DumpActor>::operator new;
	using FastAllocated<DumpActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13809609574337142272UL, 4910813813904545280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DumpActor, 0, BlobGranuleCipherKeysCtx >;
friend struct ActorCallback< DumpActor, 1, Version >;
friend struct ActorCallback< DumpActor, 2, Void >;
friend struct ActorCallback< DumpActor, 3, Void >;
friend struct ActorCallback< DumpActor, 4, Void >;
friend struct ActorCallback< DumpActor, 5, Void >;
friend struct ActorCallback< DumpActor, 6, Void >;
															#line 419 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	DumpActor(Reference<BlobManifestDumper> const& self) 
															#line 3521 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<int64_t>(),
		   DumpActorState<DumpActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dump", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1978394910149856768UL, 6717059495682635520UL);
		ActorExecutionContextHelper __helper(static_cast<DumpActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dump");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dump", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DumpActor, 0, BlobGranuleCipherKeysCtx >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DumpActor, 1, Version >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DumpActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DumpActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DumpActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DumpActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DumpActor, 6, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 419 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<int64_t> dump( Reference<BlobManifestDumper> const& self ) {
															#line 419 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<int64_t>(new DumpActor(self));
															#line 3559 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 470 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Read ranges and append to splitter. Assume the ranges can be processed within single transaction
																#line 3565 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via dumpRanges()
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class DumpRangesActor>
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class DumpRangesActorState {
															#line 3571 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	DumpRangesActorState(Reference<BlobManifestDumper> const& self,Reference<BlobManifestFileSplitter> const& splitter,std::vector<KeyRangeRef> const& ranges) 
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   splitter(splitter),
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   ranges(ranges),
															#line 475 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   tr(self->db_)
															#line 3584 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("dumpRanges", reinterpret_cast<unsigned long>(this));

	}
	~DumpRangesActorState() 
	{
		fdb_probe_actor_destroy("dumpRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 477 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 478 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 479 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 481 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 481 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				if (static_cast<DumpRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3608 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<DumpRangesActor*>(this)->actor_wait_state = 1;
															#line 481 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DumpRangesActor, 0, Version >*>(static_cast<DumpRangesActor*>(this)));
															#line 3613 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpRangesActorState();
		static_cast<DumpRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 508 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			err = e;
															#line 511 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 511 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<DumpRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3647 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_4.get(), loopDepth); };
			static_cast<DumpRangesActor*>(this)->actor_wait_state = 5;
															#line 511 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DumpRangesActor, 4, Void >*>(static_cast<DumpRangesActor*>(this)));
															#line 3652 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 482 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = BlobGranuleBackupConfig().lastFlushVersion().getD(&tr);
															#line 482 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<DumpRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3669 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DumpRangesActor*>(this)->actor_wait_state = 2;
															#line 482 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DumpRangesActor, 1, int64_t >*>(static_cast<DumpRangesActor*>(this)));
															#line 3674 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& __readVersion,int loopDepth) 
	{
															#line 481 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		readVersion = __readVersion;
															#line 3683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __readVersion,int loopDepth) 
	{
		readVersion = std::move(__readVersion);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpRangesActor*>(this)->actor_wait_state > 0) static_cast<DumpRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DumpRangesActor*>(this)->ActorCallback< DumpRangesActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< DumpRangesActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DumpRangesActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DumpRangesActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int64_t const& lastFlushVersion,int loopDepth) 
	{
															#line 483 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (readVersion < lastFlushVersion)
															#line 3762 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 484 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 484 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<DumpRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3768 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<DumpRangesActor*>(this)->actor_wait_state = 3;
															#line 484 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DumpRangesActor, 2, Void >*>(static_cast<DumpRangesActor*>(this)));
															#line 3773 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int64_t && lastFlushVersion,int loopDepth) 
	{
															#line 483 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (readVersion < lastFlushVersion)
															#line 3787 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 484 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(FLOW_KNOBS->PREVENT_FAST_SPIN_DELAY);
															#line 484 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<DumpRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 3793 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<DumpRangesActor*>(this)->actor_wait_state = 3;
															#line 484 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DumpRangesActor, 2, Void >*>(static_cast<DumpRangesActor*>(this)));
															#line 3798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(int64_t const& lastFlushVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3(lastFlushVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int64_t && lastFlushVersion,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(lastFlushVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DumpRangesActor*>(this)->actor_wait_state > 0) static_cast<DumpRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DumpRangesActor*>(this)->ActorCallback< DumpRangesActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< DumpRangesActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DumpRangesActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DumpRangesActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 488 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		RangeForbody1cont4Iterator0 = std::begin(ranges);
															#line 3887 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont4loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 485 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		return a_body1Catch2(blob_granule_transaction_too_old(), loopDepth);
															#line 3896 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 485 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		return a_body1Catch2(blob_granule_transaction_too_old(), loopDepth);
															#line 3904 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DumpRangesActor*>(this)->actor_wait_state > 0) static_cast<DumpRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DumpRangesActor*>(this)->ActorCallback< DumpRangesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpRangesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DumpRangesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DumpRangesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 504 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		Value versionEncoded = BinaryWriter::toValue(readVersion, Unversioned());
															#line 505 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		splitter->append(KeyValueRef(blobManifestVersionKey, versionEncoded));
															#line 506 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<DumpRangesActor*>(this)->SAV<Version>::futures) { (void)(readVersion); this->~DumpRangesActorState(); static_cast<DumpRangesActor*>(this)->destroy(); return 0; }
															#line 3991 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<DumpRangesActor*>(this)->SAV< Version >::value()) Version(std::move(readVersion)); // state_var_RVO
		this->~DumpRangesActorState();
		static_cast<DumpRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1(int loopDepth) 
	{
															#line 488 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!(RangeForbody1cont4Iterator0 != std::end(ranges)))
															#line 4010 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
			return a_body1cont4break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 488 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		auto range = *RangeForbody1cont4Iterator0;
															#line 4016 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
			try {
															#line 490 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				rows = PromiseStream<RangeResult>();
															#line 491 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				stream = tr.getRangeStream(rows, range, GetRangeLimits(), Snapshot::True);
															#line 492 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				;
															#line 4025 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				loopDepth = a_body1cont4loopBody1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont4loopBody1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont4loopBody1Catch1(unknown_error(), loopDepth);
			}
		}

		return loopDepth;
	}
	int a_body1cont4break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4continue1(int loopDepth) 
	{
															#line 488 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		++RangeForbody1cont4Iterator0;
															#line 4054 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 497 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (e.code() == error_code_end_of_stream)
															#line 4064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			{
				return a_body1cont4continue1(loopDepth); // continue
			}
															#line 500 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			return a_body1Catch2(e, std::max(0, loopDepth - 1));
															#line 4070 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont4loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont4loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1(int loopDepth) 
	{
															#line 493 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		auto __when_expr_3 = rows.getFuture();
															#line 4091 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		static_assert(std::is_same<decltype(__when_expr_3), FutureStream<RangeResult>>::value || std::is_same<decltype(__when_expr_3), ThreadFutureStream<RangeResult>>::value, "invalid type");
															#line 493 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<DumpRangesActor*>(this)->actor_wait_state < 0) return a_body1cont4loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4095 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont4loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont4loopBody1loopBody1when1(__when_expr_3.pop(), loopDepth); };
		static_cast<DumpRangesActor*>(this)->actor_wait_state = 4;
															#line 493 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorSingleCallback< DumpRangesActor, 3, RangeResult >*>(static_cast<DumpRangesActor*>(this)));
															#line 4100 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont1(RangeResult const& result,int loopDepth) 
	{
															#line 494 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		splitter->append(result);
															#line 4109 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1cont1(RangeResult && result,int loopDepth) 
	{
															#line 494 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		splitter->append(result);
															#line 4118 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont4loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1cont4loopBody1loopBody1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1cont4loopBody1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DumpRangesActor*>(this)->actor_wait_state > 0) static_cast<DumpRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DumpRangesActor*>(this)->ActorSingleCallback< DumpRangesActor, 3, RangeResult >::remove();

	}
	void a_callback_fire(ActorSingleCallback< DumpRangesActor, 3, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorSingleCallback< DumpRangesActor, 3, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorSingleCallback< DumpRangesActor, 3, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont4loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont4loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
															#line 512 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 4202 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
															#line 512 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		return a_body1Catch1(err, loopDepth);
															#line 4210 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DumpRangesActor*>(this)->actor_wait_state > 0) static_cast<DumpRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DumpRangesActor*>(this)->ActorCallback< DumpRangesActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpRangesActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DumpRangesActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DumpRangesActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestDumper> self;
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestFileSplitter> splitter;
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	std::vector<KeyRangeRef> ranges;
															#line 475 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Transaction tr;
															#line 481 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Version readVersion;
															#line 488 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	decltype(std::begin(std::declval<std::vector<KeyRangeRef>>())) RangeForbody1cont4Iterator0;
															#line 490 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	PromiseStream<RangeResult> rows;
															#line 491 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Future<Void> stream;
															#line 508 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Error err;
															#line 4307 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via dumpRanges()
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class DumpRangesActor final : public Actor<Version>, public ActorCallback< DumpRangesActor, 0, Version >, public ActorCallback< DumpRangesActor, 1, int64_t >, public ActorCallback< DumpRangesActor, 2, Void >, public ActorSingleCallback< DumpRangesActor, 3, RangeResult >, public ActorCallback< DumpRangesActor, 4, Void >, public FastAllocated<DumpRangesActor>, public DumpRangesActorState<DumpRangesActor> {
															#line 4312 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<DumpRangesActor>::operator new;
	using FastAllocated<DumpRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13747167246032325632UL, 17598542524547185152UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DumpRangesActor, 0, Version >;
friend struct ActorCallback< DumpRangesActor, 1, int64_t >;
friend struct ActorCallback< DumpRangesActor, 2, Void >;
friend struct ActorSingleCallback< DumpRangesActor, 3, RangeResult >;
friend struct ActorCallback< DumpRangesActor, 4, Void >;
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	DumpRangesActor(Reference<BlobManifestDumper> const& self,Reference<BlobManifestFileSplitter> const& splitter,std::vector<KeyRangeRef> const& ranges) 
															#line 4333 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Version>(),
		   DumpRangesActorState<DumpRangesActor>(self, splitter, ranges),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(589491892084825344UL, 16753177881720338432UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DumpRangesActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DumpRangesActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DumpRangesActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorSingleCallback< DumpRangesActor, 3, RangeResult >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DumpRangesActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Version> dumpRanges( Reference<BlobManifestDumper> const& self, Reference<BlobManifestFileSplitter> const& splitter, std::vector<KeyRangeRef> const& ranges ) {
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Version>(new DumpRangesActor(self, splitter, ranges));
															#line 4369 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 515 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	static bool shouldDumpBlobGranuleFileKey(KeyValueRef row, Version maxVersion) {
		ASSERT(row.key.startsWith(blobGranuleFileKeys.begin));

		UID gid;
		uint8_t fileType;
		Version version;
		std::tie(gid, version, fileType) = decodeBlobGranuleFileKey(row.key);
		if (version > maxVersion) {
			CODE_PROBE(true, "Skip newer blob granule files for blob manifest");
			dprint("Skip granule file {} {}\n", gid.toString(), version);
			return false;
		}
		return true;
	}

	static bool shouldDumpBlobGranuleHistoryKey(KeyValueRef row, Version maxVersion) {
		ASSERT(row.key.startsWith(blobGranuleHistoryKeys.begin));

		std::pair<KeyRange, Version> decodedKey = decodeBlobGranuleHistoryKey(row.key);
		if (decodedKey.second > maxVersion) {
			CODE_PROBE(true, "Skip newer blob granule history for blob manifest");
			dprint("Skip granule history {} {}\n", decodedKey.first.toString(), decodedKey.second);
			return false;
		}
		return true;
	}

	// Start a transcation to read range and append to splitter. Number of rows are limited by maxRowsPerTransaction.
	// It returns the last key that has been read.
																#line 4403 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via dumpRange()
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class DumpRangeActor>
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class DumpRangeActorState {
															#line 4409 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	DumpRangeActorState(Reference<BlobManifestDumper> const& self,Reference<BlobManifestFileSplitter> const& splitter,KeySelector const& begin,KeySelector const& end,std::function<bool(KeyValueRef)> const& shouldDumpFunc,int const& maxRowsPerTransaction) 
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   splitter(splitter),
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   begin(begin),
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   end(end),
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   shouldDumpFunc(shouldDumpFunc),
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   maxRowsPerTransaction(maxRowsPerTransaction),
															#line 551 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   tr(self->db_),
															#line 552 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   count(0)
															#line 4430 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("dumpRange", reinterpret_cast<unsigned long>(this));

	}
	~DumpRangeActorState() 
	{
		fdb_probe_actor_destroy("dumpRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 553 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			;
															#line 4445 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpRangeActorState();
		static_cast<DumpRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 554 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 555 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 556 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 4479 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		try {
															#line 558 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			limits = GetRangeLimits(SERVER_KNOBS->BLOB_MANIFEST_RW_ROWS);
															#line 559 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			limits.minRows = 0;
															#line 560 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			;
															#line 4487 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 580 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			err = e;
															#line 581 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 581 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<DumpRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4507 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DumpRangeActor*>(this)->actor_wait_state = 2;
															#line 581 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DumpRangeActor, 1, Void >*>(static_cast<DumpRangeActor*>(this)));
															#line 4512 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 561 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = tr.getRange(begin, end, limits, Snapshot::True);
															#line 561 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<DumpRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4536 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DumpRangeActor*>(this)->actor_wait_state = 1;
															#line 561 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DumpRangeActor, 0, RangeResult >*>(static_cast<DumpRangeActor*>(this)));
															#line 4541 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(RangeResult const& result,int loopDepth) 
	{
															#line 562 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		for( auto& row : result ) {
															#line 563 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (shouldDumpFunc(row))
															#line 4552 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			{
															#line 564 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				splitter->append(row);
															#line 4556 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			}
		}
															#line 568 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		count += result.size();
															#line 569 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!result.more)
															#line 4563 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 570 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (!static_cast<DumpRangeActor*>(this)->SAV<Key>::futures) { (void)(end.getKey()); this->~DumpRangeActorState(); static_cast<DumpRangeActor*>(this)->destroy(); return 0; }
															#line 4567 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			new (&static_cast<DumpRangeActor*>(this)->SAV< Key >::value()) Key(end.getKey());
			this->~DumpRangeActorState();
			static_cast<DumpRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 572 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		begin = result.nextBeginKeySelector();
															#line 573 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (count > maxRowsPerTransaction)
															#line 4577 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 574 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (!static_cast<DumpRangeActor*>(this)->SAV<Key>::futures) { (void)(begin.getKey()); this->~DumpRangeActorState(); static_cast<DumpRangeActor*>(this)->destroy(); return 0; }
															#line 4581 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			new (&static_cast<DumpRangeActor*>(this)->SAV< Key >::value()) Key(begin.getKey());
			this->~DumpRangeActorState();
			static_cast<DumpRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(RangeResult && result,int loopDepth) 
	{
															#line 562 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		for( auto& row : result ) {
															#line 563 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (shouldDumpFunc(row))
															#line 4597 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			{
															#line 564 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				splitter->append(row);
															#line 4601 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			}
		}
															#line 568 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		count += result.size();
															#line 569 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!result.more)
															#line 4608 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 570 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (!static_cast<DumpRangeActor*>(this)->SAV<Key>::futures) { (void)(end.getKey()); this->~DumpRangeActorState(); static_cast<DumpRangeActor*>(this)->destroy(); return 0; }
															#line 4612 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			new (&static_cast<DumpRangeActor*>(this)->SAV< Key >::value()) Key(end.getKey());
			this->~DumpRangeActorState();
			static_cast<DumpRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 572 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		begin = result.nextBeginKeySelector();
															#line 573 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (count > maxRowsPerTransaction)
															#line 4622 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 574 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (!static_cast<DumpRangeActor*>(this)->SAV<Key>::futures) { (void)(begin.getKey()); this->~DumpRangeActorState(); static_cast<DumpRangeActor*>(this)->destroy(); return 0; }
															#line 4626 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			new (&static_cast<DumpRangeActor*>(this)->SAV< Key >::value()) Key(begin.getKey());
			this->~DumpRangeActorState();
			static_cast<DumpRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpRangeActor*>(this)->actor_wait_state > 0) static_cast<DumpRangeActor*>(this)->actor_wait_state = 0;
		static_cast<DumpRangeActor*>(this)->ActorCallback< DumpRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< DumpRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("dumpRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DumpRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("dumpRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DumpRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("dumpRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 582 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 4715 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 582 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 4723 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DumpRangeActor*>(this)->actor_wait_state > 0) static_cast<DumpRangeActor*>(this)->actor_wait_state = 0;
		static_cast<DumpRangeActor*>(this)->ActorCallback< DumpRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DumpRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dumpRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DumpRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dumpRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DumpRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dumpRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestDumper> self;
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestFileSplitter> splitter;
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeySelector begin;
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeySelector end;
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	std::function<bool(KeyValueRef)> shouldDumpFunc;
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int maxRowsPerTransaction;
															#line 551 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Transaction tr;
															#line 552 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int count;
															#line 558 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	GetRangeLimits limits;
															#line 580 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Error err;
															#line 4822 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via dumpRange()
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class DumpRangeActor final : public Actor<Key>, public ActorCallback< DumpRangeActor, 0, RangeResult >, public ActorCallback< DumpRangeActor, 1, Void >, public FastAllocated<DumpRangeActor>, public DumpRangeActorState<DumpRangeActor> {
															#line 4827 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<DumpRangeActor>::operator new;
	using FastAllocated<DumpRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10349680716342494976UL, 10012792031489633024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Key>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DumpRangeActor, 0, RangeResult >;
friend struct ActorCallback< DumpRangeActor, 1, Void >;
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	DumpRangeActor(Reference<BlobManifestDumper> const& self,Reference<BlobManifestFileSplitter> const& splitter,KeySelector const& begin,KeySelector const& end,std::function<bool(KeyValueRef)> const& shouldDumpFunc,int const& maxRowsPerTransaction) 
															#line 4845 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Key>(),
		   DumpRangeActorState<DumpRangeActor>(self, splitter, begin, end, shouldDumpFunc, maxRowsPerTransaction),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3782143043169124608UL, 3379351179355159808UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DumpRangeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DumpRangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Key> dumpRange( Reference<BlobManifestDumper> const& self, Reference<BlobManifestFileSplitter> const& splitter, KeySelector const& begin, KeySelector const& end, std::function<bool(KeyValueRef)> const& shouldDumpFunc, int const& maxRowsPerTransaction ) {
															#line 545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Key>(new DumpRangeActor(self, splitter, begin, end, shouldDumpFunc, maxRowsPerTransaction));
															#line 4878 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 586 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Use multiple transactions to read the range and append to splitter. It's used for blobGranuleFileKeys
	// and blobGranuleHistoryKeys. All rows with version greater than maxVersion will be skipped.
																#line 4885 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via dumpRange()
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class DumpRangeActor1>
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class DumpRangeActor1State {
															#line 4891 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	DumpRangeActor1State(Reference<BlobManifestDumper> const& self,Reference<BlobManifestFileSplitter> const& splitter,KeyRange const& range,std::function<bool(KeyValueRef)> const& shouldDumpFunc) 
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   splitter(splitter),
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   range(range),
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   shouldDumpFunc(shouldDumpFunc),
															#line 593 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   begin(firstGreaterOrEqual(range.begin)),
															#line 594 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   end(firstGreaterOrEqual(range.end))
															#line 4908 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("dumpRange", reinterpret_cast<unsigned long>(this));

	}
	~DumpRangeActor1State() 
	{
		fdb_probe_actor_destroy("dumpRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 595 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			;
															#line 4923 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpRangeActor1State();
		static_cast<DumpRangeActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 596 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		int limit = SERVER_KNOBS->BLOB_MANIFEST_MAX_ROWS_PER_TRANSACTION;
															#line 597 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Key> __when_expr_0 = dumpRange(self, splitter, begin, end, shouldDumpFunc, limit);
															#line 597 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<DumpRangeActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4957 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DumpRangeActor1*>(this)->actor_wait_state = 1;
															#line 597 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DumpRangeActor1, 0, Key >*>(static_cast<DumpRangeActor1*>(this)));
															#line 4962 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Key const& next,int loopDepth) 
	{
															#line 598 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (next >= range.end)
															#line 4971 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 599 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (!static_cast<DumpRangeActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DumpRangeActor1State(); static_cast<DumpRangeActor1*>(this)->destroy(); return 0; }
															#line 4975 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			new (&static_cast<DumpRangeActor1*>(this)->SAV< Void >::value()) Void(Void());
			this->~DumpRangeActor1State();
			static_cast<DumpRangeActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 601 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		begin = firstGreaterThan(next);
															#line 4983 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Key && next,int loopDepth) 
	{
															#line 598 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (next >= range.end)
															#line 4992 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 599 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (!static_cast<DumpRangeActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DumpRangeActor1State(); static_cast<DumpRangeActor1*>(this)->destroy(); return 0; }
															#line 4996 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			new (&static_cast<DumpRangeActor1*>(this)->SAV< Void >::value()) Void(Void());
			this->~DumpRangeActor1State();
			static_cast<DumpRangeActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 601 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		begin = firstGreaterThan(next);
															#line 5004 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Key const& next,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(next, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Key && next,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(next), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpRangeActor1*>(this)->actor_wait_state > 0) static_cast<DumpRangeActor1*>(this)->actor_wait_state = 0;
		static_cast<DumpRangeActor1*>(this)->ActorCallback< DumpRangeActor1, 0, Key >::remove();

	}
	void a_callback_fire(ActorCallback< DumpRangeActor1, 0, Key >*,Key const& value) 
	{
		fdb_probe_actor_enter("dumpRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DumpRangeActor1, 0, Key >*,Key && value) 
	{
		fdb_probe_actor_enter("dumpRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DumpRangeActor1, 0, Key >*,Error err) 
	{
		fdb_probe_actor_enter("dumpRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpRange", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestDumper> self;
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestFileSplitter> splitter;
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeyRange range;
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	std::function<bool(KeyValueRef)> shouldDumpFunc;
															#line 593 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeySelectorRef begin;
															#line 594 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeySelectorRef end;
															#line 5096 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via dumpRange()
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class DumpRangeActor1 final : public Actor<Void>, public ActorCallback< DumpRangeActor1, 0, Key >, public FastAllocated<DumpRangeActor1>, public DumpRangeActor1State<DumpRangeActor1> {
															#line 5101 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<DumpRangeActor1>::operator new;
	using FastAllocated<DumpRangeActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10349680716342494976UL, 10012792031489633024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DumpRangeActor1, 0, Key >;
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	DumpRangeActor1(Reference<BlobManifestDumper> const& self,Reference<BlobManifestFileSplitter> const& splitter,KeyRange const& range,std::function<bool(KeyValueRef)> const& shouldDumpFunc) 
															#line 5118 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   DumpRangeActor1State<DumpRangeActor1>(self, splitter, range, shouldDumpFunc),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17221996803673977856UL, 6629684651992338688UL);
		ActorExecutionContextHelper __helper(static_cast<DumpRangeActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DumpRangeActor1, 0, Key >*)0, actor_cancelled()); break;
		}

	}
};
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> dumpRange( Reference<BlobManifestDumper> const& self, Reference<BlobManifestFileSplitter> const& splitter, KeyRange const& range, std::function<bool(KeyValueRef)> const& shouldDumpFunc ) {
															#line 589 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new DumpRangeActor1(self, splitter, range, shouldDumpFunc));
															#line 5150 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 604 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Cleanup oldest manifest file
																#line 5156 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via cleanup()
															#line 606 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class CleanupActor>
															#line 606 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class CleanupActorState {
															#line 5162 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 606 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	CleanupActorState(Reference<BlobManifestDumper> const& self) 
															#line 606 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 606 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 607 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   writer(),
															#line 608 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   fullPath()
															#line 5173 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("cleanup", reinterpret_cast<unsigned long>(this));

	}
	~CleanupActorState() 
	{
		fdb_probe_actor_destroy("cleanup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 609 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			std::tie(writer, fullPath) = self->blobConn_->createForWrite("");
															#line 611 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			;
															#line 5190 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CleanupActorState();
		static_cast<CleanupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 612 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<std::vector<BlobManifestFile>> __when_expr_0 = BlobManifestFile::listAll(writer);
															#line 612 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<CleanupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5222 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CleanupActor*>(this)->actor_wait_state = 1;
															#line 612 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CleanupActor, 0, std::vector<BlobManifestFile> >*>(static_cast<CleanupActor*>(this)));
															#line 5227 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 613 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		TraceEvent("BlobManfiestCleanup").detail("FileCount", allFiles.size());
															#line 614 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		int count = BlobManifest::count(allFiles);
															#line 615 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (count <= SERVER_KNOBS->BLOB_RESTORE_MANIFEST_RETENTION_MAX)
															#line 5240 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 616 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (!static_cast<CleanupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CleanupActorState(); static_cast<CleanupActor*>(this)->destroy(); return 0; }
															#line 5244 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			new (&static_cast<CleanupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~CleanupActorState();
			static_cast<CleanupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 618 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = BlobManifest::deleteOldest(allFiles, writer);
															#line 618 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<CleanupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5254 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CleanupActor*>(this)->actor_wait_state = 2;
															#line 618 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CleanupActor, 1, Void >*>(static_cast<CleanupActor*>(this)));
															#line 5259 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<BlobManifestFile> const& __allFiles,int loopDepth) 
	{
															#line 612 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		allFiles = __allFiles;
															#line 5268 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<BlobManifestFile> && __allFiles,int loopDepth) 
	{
		allFiles = std::move(__allFiles);
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CleanupActor*>(this)->actor_wait_state > 0) static_cast<CleanupActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupActor*>(this)->ActorCallback< CleanupActor, 0, std::vector<BlobManifestFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupActor, 0, std::vector<BlobManifestFile> >*,std::vector<BlobManifestFile> const& value) 
	{
		fdb_probe_actor_enter("cleanup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CleanupActor, 0, std::vector<BlobManifestFile> >*,std::vector<BlobManifestFile> && value) 
	{
		fdb_probe_actor_enter("cleanup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CleanupActor, 0, std::vector<BlobManifestFile> >*,Error err) 
	{
		fdb_probe_actor_enter("cleanup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CleanupActor*>(this)->actor_wait_state > 0) static_cast<CleanupActor*>(this)->actor_wait_state = 0;
		static_cast<CleanupActor*>(this)->ActorCallback< CleanupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CleanupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cleanup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CleanupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cleanup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CleanupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cleanup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cleanup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 606 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestDumper> self;
															#line 607 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BackupContainerFileSystem> writer;
															#line 608 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	std::string fullPath;
															#line 612 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	std::vector<BlobManifestFile> allFiles;
															#line 5438 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via cleanup()
															#line 606 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class CleanupActor final : public Actor<Void>, public ActorCallback< CleanupActor, 0, std::vector<BlobManifestFile> >, public ActorCallback< CleanupActor, 1, Void >, public FastAllocated<CleanupActor>, public CleanupActorState<CleanupActor> {
															#line 5443 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<CleanupActor>::operator new;
	using FastAllocated<CleanupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13223254243513163520UL, 1600816087825410560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CleanupActor, 0, std::vector<BlobManifestFile> >;
friend struct ActorCallback< CleanupActor, 1, Void >;
															#line 606 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	CleanupActor(Reference<BlobManifestDumper> const& self) 
															#line 5461 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   CleanupActorState<CleanupActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cleanup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17613239497936119296UL, 12602339259201360896UL);
		ActorExecutionContextHelper __helper(static_cast<CleanupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cleanup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cleanup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CleanupActor, 0, std::vector<BlobManifestFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CleanupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 606 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> cleanup( Reference<BlobManifestDumper> const& self ) {
															#line 606 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new CleanupActor(self));
															#line 5494 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 621 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	Database db_;
	Reference<BlobConnectionProvider> blobConn_;
	int64_t epoch_;
	int64_t seqNo_;
	Reference<AsyncVar<ServerDBInfo> const> dbInfo_;
	bool encryptionEnabled_;
};

// Defines filename, version, size for each granule file that interests full restore
struct GranuleFileVersion {
	Version version;
	uint8_t fileType;
	std::string filename;
	int64_t sizeInBytes;
};

// This class is to load blob manifest into system key space, which is part of for bare metal restore
class BlobManifestLoader : public ReferenceCounted<BlobManifestLoader> {
public:
	BlobManifestLoader(Database& db,
	                   Reference<AsyncVar<ServerDBInfo> const> dbInfo,
	                   Reference<BlobConnectionProvider> blobConn)
	  : db_(db), blobConn_(blobConn), dbInfo_(dbInfo) {}
	virtual ~BlobManifestLoader() {}

	// Execute the loader
																#line 5525 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via execute()
															#line 648 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class ExecuteActor1>
															#line 648 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ExecuteActor1State {
															#line 5531 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 648 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ExecuteActor1State(Reference<BlobManifestLoader> const& self) 
															#line 648 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 648 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self)
															#line 5538 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("execute", reinterpret_cast<unsigned long>(this));

	}
	~ExecuteActor1State() 
	{
		fdb_probe_actor_destroy("execute", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 650 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				StrictFuture<Void> __when_expr_0 = load(self);
															#line 650 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				if (static_cast<ExecuteActor1*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5556 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ExecuteActor1*>(this)->actor_wait_state = 1;
															#line 650 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExecuteActor1, 0, Void >*>(static_cast<ExecuteActor1*>(this)));
															#line 5561 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExecuteActor1State();
		static_cast<ExecuteActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 657 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ExecuteActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ExecuteActor1State(); static_cast<ExecuteActor1*>(this)->destroy(); return 0; }
															#line 5590 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ExecuteActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~ExecuteActor1State();
		static_cast<ExecuteActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 653 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			dprint("WARNING: unexpected manifest loader error {}\n", e.what());
															#line 654 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			TraceEvent("BlobManfiestError").error(e).log();
															#line 655 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 5607 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 651 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = validate(self);
															#line 651 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<ExecuteActor1*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5623 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExecuteActor1*>(this)->actor_wait_state = 2;
															#line 651 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExecuteActor1, 1, Void >*>(static_cast<ExecuteActor1*>(this)));
															#line 5628 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 651 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = validate(self);
															#line 651 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<ExecuteActor1*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 5639 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ExecuteActor1*>(this)->actor_wait_state = 2;
															#line 651 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ExecuteActor1, 1, Void >*>(static_cast<ExecuteActor1*>(this)));
															#line 5644 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExecuteActor1*>(this)->actor_wait_state > 0) static_cast<ExecuteActor1*>(this)->actor_wait_state = 0;
		static_cast<ExecuteActor1*>(this)->ActorCallback< ExecuteActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExecuteActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExecuteActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execute", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExecuteActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("execute", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execute", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ExecuteActor1*>(this)->actor_wait_state > 0) static_cast<ExecuteActor1*>(this)->actor_wait_state = 0;
		static_cast<ExecuteActor1*>(this)->ActorCallback< ExecuteActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExecuteActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ExecuteActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execute", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ExecuteActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("execute", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("execute", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 648 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestLoader> self;
															#line 5826 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via execute()
															#line 648 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ExecuteActor1 final : public Actor<Void>, public ActorCallback< ExecuteActor1, 0, Void >, public ActorCallback< ExecuteActor1, 1, Void >, public FastAllocated<ExecuteActor1>, public ExecuteActor1State<ExecuteActor1> {
															#line 5831 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<ExecuteActor1>::operator new;
	using FastAllocated<ExecuteActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7833566249667374336UL, 13040891862336798976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExecuteActor1, 0, Void >;
friend struct ActorCallback< ExecuteActor1, 1, Void >;
															#line 648 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ExecuteActor1(Reference<BlobManifestLoader> const& self) 
															#line 5849 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   ExecuteActor1State<ExecuteActor1>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("execute", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11652476918815766272UL, 4267730629950766592UL);
		ActorExecutionContextHelper __helper(static_cast<ExecuteActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("execute");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("execute", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExecuteActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ExecuteActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 648 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> execute( Reference<BlobManifestLoader> const& self ) {
															#line 648 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new ExecuteActor1(self));
															#line 5882 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 659 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Iterate active granules and return their version/sizes
																#line 5888 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via listGranules()
															#line 661 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class ListGranulesActor>
															#line 661 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ListGranulesActorState {
															#line 5894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 661 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ListGranulesActorState(Reference<BlobManifestLoader> const& self) 
															#line 661 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 661 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 662 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   tr(self->db_)
															#line 5903 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("listGranules", reinterpret_cast<unsigned long>(this));

	}
	~ListGranulesActorState() 
	{
		fdb_probe_actor_destroy("listGranules", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 663 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			;
															#line 5918 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListGranulesActorState();
		static_cast<ListGranulesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 664 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		results = BlobGranuleRestoreVersionVector();
															#line 665 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 666 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 667 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 5954 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		try {
															#line 670 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			blobRanges = Standalone<VectorRef<KeyRef>>();
															#line 671 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			blobRangesAssigned = Standalone<VectorRef<bool>>();
															#line 673 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			limits = GetRangeLimits(SERVER_KNOBS->BLOB_MANIFEST_RW_ROWS);
															#line 674 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			limits.minRows = 0;
															#line 675 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			begin = firstGreaterOrEqual(blobGranuleMappingKeys.begin);
															#line 676 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			end = firstGreaterOrEqual(blobGranuleMappingKeys.end);
															#line 677 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			;
															#line 5970 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 713 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 713 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<ListGranulesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5994 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ListGranulesActor*>(this)->actor_wait_state = 3;
															#line 713 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ListGranulesActor, 2, Void >*>(static_cast<ListGranulesActor*>(this)));
															#line 5999 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 690 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		i = 0;
															#line 691 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		i = 0;
															#line 6016 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 678 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = tr.getRange(begin, end, limits, Snapshot::True);
															#line 678 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<ListGranulesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6034 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ListGranulesActor*>(this)->actor_wait_state = 1;
															#line 678 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListGranulesActor, 0, RangeResult >*>(static_cast<ListGranulesActor*>(this)));
															#line 6039 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(RangeResult const& rows,int loopDepth) 
	{
															#line 679 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		for( auto& row : rows ) {
															#line 680 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			blobRanges.push_back_deep(blobRanges.arena(), row.key);
															#line 681 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			blobRangesAssigned.push_back(blobRangesAssigned.arena(), !row.value.empty());
															#line 6065 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!rows.more)
															#line 6069 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 686 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		begin = rows.nextBeginKeySelector();
															#line 6075 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(RangeResult && rows,int loopDepth) 
	{
															#line 679 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		for( auto& row : rows ) {
															#line 680 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			blobRanges.push_back_deep(blobRanges.arena(), row.key);
															#line 681 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			blobRangesAssigned.push_back(blobRangesAssigned.arena(), !row.value.empty());
															#line 6088 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!rows.more)
															#line 6092 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 686 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		begin = rows.nextBeginKeySelector();
															#line 6098 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& rows,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(rows, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && rows,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(rows), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListGranulesActor*>(this)->actor_wait_state > 0) static_cast<ListGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<ListGranulesActor*>(this)->ActorCallback< ListGranulesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ListGranulesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("listGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListGranulesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("listGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListGranulesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("listGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 711 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ListGranulesActor*>(this)->SAV<BlobGranuleRestoreVersionVector>::futures) { (void)(results); this->~ListGranulesActorState(); static_cast<ListGranulesActor*>(this)->destroy(); return 0; }
															#line 6182 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ListGranulesActor*>(this)->SAV< BlobGranuleRestoreVersionVector >::value()) BlobGranuleRestoreVersionVector(std::move(results)); // state_var_RVO
		this->~ListGranulesActorState();
		static_cast<ListGranulesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 691 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!(i < blobRanges.size() - 1))
															#line 6201 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 692 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		Key startKey = blobRanges[i].removePrefix(blobGranuleMappingKeys.begin);
															#line 693 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!blobRangesAssigned[i])
															#line 6209 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
			return a_body1loopBody1cont2continue1(loopDepth); // continue
		}
															#line 695 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		Key endKey = blobRanges[i + 1].removePrefix(blobGranuleMappingKeys.begin);
															#line 697 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		granuleRange = KeyRangeRef(startKey, endKey);
															#line 6217 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		try {
															#line 699 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Standalone<BlobGranuleRestoreVersion>> __when_expr_1 = getGranule(&tr, granuleRange);
															#line 699 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<ListGranulesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6223 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont2loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ListGranulesActor*>(this)->actor_wait_state = 2;
															#line 699 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListGranulesActor, 1, Standalone<BlobGranuleRestoreVersion> >*>(static_cast<ListGranulesActor*>(this)));
															#line 6228 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2continue1(int loopDepth) 
	{
															#line 691 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		i++;
															#line 6256 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
															#line 691 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		i++;
															#line 6265 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 702 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (e.code() == error_code_restore_missing_data)
															#line 6275 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			{
															#line 703 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				dprint("missing data for key range {} \n", granuleRange.toString());
															#line 704 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				TraceEvent("BlobRestoreMissingData").detail("KeyRange", granuleRange.toString());
															#line 6281 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			}
			else
			{
															#line 706 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				TraceEvent("BlobManifestError").error(e).detail("KeyRange", granuleRange.toString());
															#line 707 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				return a_body1loopBody1Catch1(e, std::max(0, loopDepth - 1));
															#line 6289 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			}
			loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont4(Standalone<BlobGranuleRestoreVersion> const& granule,int loopDepth) 
	{
															#line 700 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		results.push_back_deep(results.arena(), granule);
															#line 6305 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont4(Standalone<BlobGranuleRestoreVersion> && granule,int loopDepth) 
	{
															#line 700 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		results.push_back_deep(results.arena(), granule);
															#line 6314 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Standalone<BlobGranuleRestoreVersion> const& granule,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont4(granule, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(Standalone<BlobGranuleRestoreVersion> && granule,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont4(std::move(granule), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListGranulesActor*>(this)->actor_wait_state > 0) static_cast<ListGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<ListGranulesActor*>(this)->ActorCallback< ListGranulesActor, 1, Standalone<BlobGranuleRestoreVersion> >::remove();

	}
	void a_callback_fire(ActorCallback< ListGranulesActor, 1, Standalone<BlobGranuleRestoreVersion> >*,Standalone<BlobGranuleRestoreVersion> const& value) 
	{
		fdb_probe_actor_enter("listGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListGranulesActor, 1, Standalone<BlobGranuleRestoreVersion> >*,Standalone<BlobGranuleRestoreVersion> && value) 
	{
		fdb_probe_actor_enter("listGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListGranulesActor, 1, Standalone<BlobGranuleRestoreVersion> >*,Error err) 
	{
		fdb_probe_actor_enter("listGranules", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listGranules", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont2loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ListGranulesActor*>(this)->actor_wait_state > 0) static_cast<ListGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<ListGranulesActor*>(this)->ActorCallback< ListGranulesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListGranulesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listGranules", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ListGranulesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listGranules", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ListGranulesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listGranules", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listGranules", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 661 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestLoader> self;
															#line 662 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Transaction tr;
															#line 664 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	BlobGranuleRestoreVersionVector results;
															#line 670 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Standalone<VectorRef<KeyRef>> blobRanges;
															#line 671 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Standalone<VectorRef<bool>> blobRangesAssigned;
															#line 673 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	GetRangeLimits limits;
															#line 675 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeySelectorRef begin;
															#line 676 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeySelectorRef end;
															#line 690 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int i;
															#line 697 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeyRange granuleRange;
															#line 6514 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via listGranules()
															#line 661 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ListGranulesActor final : public Actor<BlobGranuleRestoreVersionVector>, public ActorCallback< ListGranulesActor, 0, RangeResult >, public ActorCallback< ListGranulesActor, 1, Standalone<BlobGranuleRestoreVersion> >, public ActorCallback< ListGranulesActor, 2, Void >, public FastAllocated<ListGranulesActor>, public ListGranulesActorState<ListGranulesActor> {
															#line 6519 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<ListGranulesActor>::operator new;
	using FastAllocated<ListGranulesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9361417583987192064UL, 16440115243557423616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BlobGranuleRestoreVersionVector>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListGranulesActor, 0, RangeResult >;
friend struct ActorCallback< ListGranulesActor, 1, Standalone<BlobGranuleRestoreVersion> >;
friend struct ActorCallback< ListGranulesActor, 2, Void >;
															#line 661 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ListGranulesActor(Reference<BlobManifestLoader> const& self) 
															#line 6538 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<BlobGranuleRestoreVersionVector>(),
		   ListGranulesActorState<ListGranulesActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listGranules", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16998789021718469376UL, 15160308083199330816UL);
		ActorExecutionContextHelper __helper(static_cast<ListGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listGranules");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listGranules", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListGranulesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListGranulesActor, 1, Standalone<BlobGranuleRestoreVersion> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ListGranulesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 661 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<BlobGranuleRestoreVersionVector> listGranules( Reference<BlobManifestLoader> const& self ) {
															#line 661 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<BlobGranuleRestoreVersionVector>(new ListGranulesActor(self));
															#line 6572 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 717 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Print out a summary for blob granules
																#line 6578 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via print()
															#line 719 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class PrintActor>
															#line 719 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class PrintActorState {
															#line 6584 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 719 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	PrintActorState(Reference<BlobManifestLoader> const& self) 
															#line 719 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 719 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self)
															#line 6591 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("print", reinterpret_cast<unsigned long>(this));

	}
	~PrintActorState() 
	{
		fdb_probe_actor_destroy("print", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 720 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<BlobGranuleRestoreVersionVector> __when_expr_0 = listGranules(self);
															#line 720 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<PrintActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6608 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintActor*>(this)->actor_wait_state = 1;
															#line 720 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintActor, 0, BlobGranuleRestoreVersionVector >*>(static_cast<PrintActor*>(this)));
															#line 6613 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintActorState();
		static_cast<PrintActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 721 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(granules);
															#line 6636 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(BlobGranuleRestoreVersionVector const& __granules,int loopDepth) 
	{
															#line 720 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		granules = __granules;
															#line 6645 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(BlobGranuleRestoreVersionVector && __granules,int loopDepth) 
	{
		granules = std::move(__granules);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintActor*>(this)->actor_wait_state > 0) static_cast<PrintActor*>(this)->actor_wait_state = 0;
		static_cast<PrintActor*>(this)->ActorCallback< PrintActor, 0, BlobGranuleRestoreVersionVector >::remove();

	}
	void a_callback_fire(ActorCallback< PrintActor, 0, BlobGranuleRestoreVersionVector >*,BlobGranuleRestoreVersionVector const& value) 
	{
		fdb_probe_actor_enter("print", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintActor, 0, BlobGranuleRestoreVersionVector >*,BlobGranuleRestoreVersionVector && value) 
	{
		fdb_probe_actor_enter("print", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintActor, 0, BlobGranuleRestoreVersionVector >*,Error err) 
	{
		fdb_probe_actor_enter("print", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 724 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<PrintActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintActorState(); static_cast<PrintActor*>(this)->destroy(); return 0; }
															#line 6724 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<PrintActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintActorState();
		static_cast<PrintActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 721 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!(RangeForbody1cont1Iterator0 != std::end(granules)))
															#line 6743 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 721 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		auto granule = *RangeForbody1cont1Iterator0;
															#line 6749 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 722 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_1 = checkGranuleFiles(self, granule);
															#line 722 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<PrintActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6755 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<PrintActor*>(this)->actor_wait_state = 2;
															#line 722 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PrintActor, 1, Void >*>(static_cast<PrintActor*>(this)));
															#line 6760 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 721 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		++RangeForbody1cont1Iterator0;
															#line 6783 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PrintActor*>(this)->actor_wait_state > 0) static_cast<PrintActor*>(this)->actor_wait_state = 0;
		static_cast<PrintActor*>(this)->ActorCallback< PrintActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("print", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PrintActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("print", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PrintActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("print", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("print", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 719 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestLoader> self;
															#line 720 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	BlobGranuleRestoreVersionVector granules;
															#line 721 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	decltype(std::begin(std::declval<BlobGranuleRestoreVersionVector>())) RangeForbody1cont1Iterator0;
															#line 6881 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via print()
															#line 719 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class PrintActor final : public Actor<Void>, public ActorCallback< PrintActor, 0, BlobGranuleRestoreVersionVector >, public ActorCallback< PrintActor, 1, Void >, public FastAllocated<PrintActor>, public PrintActorState<PrintActor> {
															#line 6886 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<PrintActor>::operator new;
	using FastAllocated<PrintActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10173491658359560448UL, 361187780663460608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintActor, 0, BlobGranuleRestoreVersionVector >;
friend struct ActorCallback< PrintActor, 1, Void >;
															#line 719 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	PrintActor(Reference<BlobManifestLoader> const& self) 
															#line 6904 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   PrintActorState<PrintActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("print", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3644253348028475648UL, 11974031660397878272UL);
		ActorExecutionContextHelper __helper(static_cast<PrintActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("print");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("print", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintActor, 0, BlobGranuleRestoreVersionVector >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PrintActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 719 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> print( Reference<BlobManifestLoader> const& self ) {
															#line 719 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new PrintActor(self));
															#line 6937 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 726 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Return max epoch from all manifest files
																#line 6943 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via lastBlobEpoc()
															#line 728 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class LastBlobEpocActor>
															#line 728 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class LastBlobEpocActorState {
															#line 6949 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 728 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	LastBlobEpocActorState(Reference<BlobManifestLoader> const& self) 
															#line 728 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 728 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 729 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   container(self->blobConn_->getForRead(""))
															#line 6958 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("lastBlobEpoc", reinterpret_cast<unsigned long>(this));

	}
	~LastBlobEpocActorState() 
	{
		fdb_probe_actor_destroy("lastBlobEpoc", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 730 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<std::vector<BlobManifestFile>> __when_expr_0 = BlobManifestFile::listAll(container);
															#line 730 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<LastBlobEpocActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6975 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LastBlobEpocActor*>(this)->actor_wait_state = 1;
															#line 730 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LastBlobEpocActor, 0, std::vector<BlobManifestFile> >*>(static_cast<LastBlobEpocActor*>(this)));
															#line 6980 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LastBlobEpocActorState();
		static_cast<LastBlobEpocActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<BlobManifestFile> const& files,int loopDepth) 
	{
															#line 731 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		ASSERT(!files.empty());
															#line 732 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<LastBlobEpocActor*>(this)->SAV<int64_t>::futures) { (void)(files.front().epoch); this->~LastBlobEpocActorState(); static_cast<LastBlobEpocActor*>(this)->destroy(); return 0; }
															#line 7005 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<LastBlobEpocActor*>(this)->SAV< int64_t >::value()) int64_t(files.front().epoch);
		this->~LastBlobEpocActorState();
		static_cast<LastBlobEpocActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<BlobManifestFile> && files,int loopDepth) 
	{
															#line 731 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		ASSERT(!files.empty());
															#line 732 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<LastBlobEpocActor*>(this)->SAV<int64_t>::futures) { (void)(files.front().epoch); this->~LastBlobEpocActorState(); static_cast<LastBlobEpocActor*>(this)->destroy(); return 0; }
															#line 7019 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<LastBlobEpocActor*>(this)->SAV< int64_t >::value()) int64_t(files.front().epoch);
		this->~LastBlobEpocActorState();
		static_cast<LastBlobEpocActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<BlobManifestFile> const& files,int loopDepth) 
	{
		loopDepth = a_body1cont1(files, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<BlobManifestFile> && files,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(files), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LastBlobEpocActor*>(this)->actor_wait_state > 0) static_cast<LastBlobEpocActor*>(this)->actor_wait_state = 0;
		static_cast<LastBlobEpocActor*>(this)->ActorCallback< LastBlobEpocActor, 0, std::vector<BlobManifestFile> >::remove();

	}
	void a_callback_fire(ActorCallback< LastBlobEpocActor, 0, std::vector<BlobManifestFile> >*,std::vector<BlobManifestFile> const& value) 
	{
		fdb_probe_actor_enter("lastBlobEpoc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LastBlobEpocActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastBlobEpoc", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LastBlobEpocActor, 0, std::vector<BlobManifestFile> >*,std::vector<BlobManifestFile> && value) 
	{
		fdb_probe_actor_enter("lastBlobEpoc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LastBlobEpocActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastBlobEpoc", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LastBlobEpocActor, 0, std::vector<BlobManifestFile> >*,Error err) 
	{
		fdb_probe_actor_enter("lastBlobEpoc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LastBlobEpocActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastBlobEpoc", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 728 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestLoader> self;
															#line 729 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BackupContainerFileSystem> container;
															#line 7106 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via lastBlobEpoc()
															#line 728 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class LastBlobEpocActor final : public Actor<int64_t>, public ActorCallback< LastBlobEpocActor, 0, std::vector<BlobManifestFile> >, public FastAllocated<LastBlobEpocActor>, public LastBlobEpocActorState<LastBlobEpocActor> {
															#line 7111 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<LastBlobEpocActor>::operator new;
	using FastAllocated<LastBlobEpocActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10787755995999559424UL, 5194339525538723840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LastBlobEpocActor, 0, std::vector<BlobManifestFile> >;
															#line 728 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	LastBlobEpocActor(Reference<BlobManifestLoader> const& self) 
															#line 7128 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<int64_t>(),
		   LastBlobEpocActorState<LastBlobEpocActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lastBlobEpoc", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5403539371745721600UL, 138917043476225024UL);
		ActorExecutionContextHelper __helper(static_cast<LastBlobEpocActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lastBlobEpoc");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lastBlobEpoc", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LastBlobEpocActor, 0, std::vector<BlobManifestFile> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 728 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<int64_t> lastBlobEpoc( Reference<BlobManifestLoader> const& self ) {
															#line 728 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<int64_t>(new LastBlobEpocActor(self));
															#line 7160 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 734 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

private:
	// Load latest manifest to system space
																#line 7167 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via load()
															#line 737 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class LoadActor>
															#line 737 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class LoadActorState {
															#line 7173 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 737 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	LoadActorState(Reference<BlobManifestLoader> const& self) 
															#line 737 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 737 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 738 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   container(self->blobConn_->getForRead(""))
															#line 7182 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("load", reinterpret_cast<unsigned long>(this));

	}
	~LoadActorState() 
	{
		fdb_probe_actor_destroy("load", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 739 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<std::vector<BlobManifestFile>> __when_expr_0 = BlobManifestFile::listAll(container);
															#line 739 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<LoadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7199 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadActor*>(this)->actor_wait_state = 1;
															#line 739 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadActor, 0, std::vector<BlobManifestFile> >*>(static_cast<LoadActor*>(this)));
															#line 7204 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadActorState();
		static_cast<LoadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<BlobManifestFile> const& files,int loopDepth) 
	{
															#line 742 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		manifest = BlobManifest::latest(files);
															#line 743 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Standalone<BlobManifestTailer>> __when_expr_1 = loadTailer(self, container, manifest.tailer());
															#line 743 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<LoadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LoadActor*>(this)->actor_wait_state = 2;
															#line 743 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadActor, 1, Standalone<BlobManifestTailer> >*>(static_cast<LoadActor*>(this)));
															#line 7236 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(std::vector<BlobManifestFile> && files,int loopDepth) 
	{
															#line 742 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		manifest = BlobManifest::latest(files);
															#line 743 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Standalone<BlobManifestTailer>> __when_expr_1 = loadTailer(self, container, manifest.tailer());
															#line 743 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<LoadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7249 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LoadActor*>(this)->actor_wait_state = 2;
															#line 743 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadActor, 1, Standalone<BlobManifestTailer> >*>(static_cast<LoadActor*>(this)));
															#line 7254 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(std::vector<BlobManifestFile> const& files,int loopDepth) 
	{
		loopDepth = a_body1cont1(files, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<BlobManifestFile> && files,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(files), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadActor*>(this)->actor_wait_state > 0) static_cast<LoadActor*>(this)->actor_wait_state = 0;
		static_cast<LoadActor*>(this)->ActorCallback< LoadActor, 0, std::vector<BlobManifestFile> >::remove();

	}
	void a_callback_fire(ActorCallback< LoadActor, 0, std::vector<BlobManifestFile> >*,std::vector<BlobManifestFile> const& value) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadActor, 0, std::vector<BlobManifestFile> >*,std::vector<BlobManifestFile> && value) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadActor, 0, std::vector<BlobManifestFile> >*,Error err) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 744 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		arena = Arena();
															#line 745 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		cipherKeysCtx = Optional<BlobGranuleCipherKeysCtx>();
															#line 746 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (tailer.cipherKeysMeta.present())
															#line 7342 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 747 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<BlobGranuleCipherKeysCtx> __when_expr_2 = getGranuleCipherKeysFromKeysMeta(self->dbInfo_, tailer.cipherKeysMeta.get(), &arena);
															#line 747 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<LoadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7348 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<LoadActor*>(this)->actor_wait_state = 3;
															#line 747 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< LoadActor, 2, BlobGranuleCipherKeysCtx >*>(static_cast<LoadActor*>(this)));
															#line 7353 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<BlobManifestTailer> const& __tailer,int loopDepth) 
	{
															#line 743 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tailer = __tailer;
															#line 7367 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Standalone<BlobManifestTailer> && __tailer,int loopDepth) 
	{
		tailer = std::move(__tailer);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadActor*>(this)->actor_wait_state > 0) static_cast<LoadActor*>(this)->actor_wait_state = 0;
		static_cast<LoadActor*>(this)->ActorCallback< LoadActor, 1, Standalone<BlobManifestTailer> >::remove();

	}
	void a_callback_fire(ActorCallback< LoadActor, 1, Standalone<BlobManifestTailer> >*,Standalone<BlobManifestTailer> const& value) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadActor, 1, Standalone<BlobManifestTailer> >*,Standalone<BlobManifestTailer> && value) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadActor, 1, Standalone<BlobManifestTailer> >*,Error err) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 753 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		totalRows = 0;
															#line 754 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		totalBytes = 0;
															#line 755 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		iter = std::vector<BlobManifestFile>::iterator();
															#line 756 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		iter = manifest.segmentsBegin();
															#line 7452 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(BlobGranuleCipherKeysCtx const& ctx,int loopDepth) 
	{
															#line 749 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		cipherKeysCtx = ctx;
															#line 7461 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(BlobGranuleCipherKeysCtx && ctx,int loopDepth) 
	{
															#line 749 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		cipherKeysCtx = ctx;
															#line 7470 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(BlobGranuleCipherKeysCtx const& ctx,int loopDepth) 
	{
		loopDepth = a_body1cont4(ctx, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(BlobGranuleCipherKeysCtx && ctx,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(ctx), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<LoadActor*>(this)->actor_wait_state > 0) static_cast<LoadActor*>(this)->actor_wait_state = 0;
		static_cast<LoadActor*>(this)->ActorCallback< LoadActor, 2, BlobGranuleCipherKeysCtx >::remove();

	}
	void a_callback_fire(ActorCallback< LoadActor, 2, BlobGranuleCipherKeysCtx >*,BlobGranuleCipherKeysCtx const& value) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< LoadActor, 2, BlobGranuleCipherKeysCtx >*,BlobGranuleCipherKeysCtx && value) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< LoadActor, 2, BlobGranuleCipherKeysCtx >*,Error err) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(int loopDepth) 
	{
															#line 759 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_4 = writeDelayedRows(self);
															#line 759 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<LoadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7556 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<LoadActor*>(this)->actor_wait_state = 5;
															#line 759 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< LoadActor, 4, Void >*>(static_cast<LoadActor*>(this)));
															#line 7561 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1(int loopDepth) 
	{
															#line 756 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!(iter != manifest.segmentsEnd()))
															#line 7577 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
			return a_body1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 757 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_3 = loadSegment(self, container, *iter, cipherKeysCtx, &totalRows, &totalBytes);
															#line 757 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<LoadActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7585 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont3loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<LoadActor*>(this)->actor_wait_state = 4;
															#line 757 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< LoadActor, 3, Void >*>(static_cast<LoadActor*>(this)));
															#line 7590 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3break1(int loopDepth) 
	{
		try {
			return a_body1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 756 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		++iter;
															#line 7612 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 756 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		++iter;
															#line 7621 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<LoadActor*>(this)->actor_wait_state > 0) static_cast<LoadActor*>(this)->actor_wait_state = 0;
		static_cast<LoadActor*>(this)->ActorCallback< LoadActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< LoadActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< LoadActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 762 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (tailer.totalRows != totalRows || tailer.totalSegments != manifest.totalSegments() || tailer.totalBytes != totalBytes)
															#line 7705 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 764 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			TraceEvent("BlobRestoreManifestCorruption") .detail("ExpectedRows", tailer.totalRows) .detail("CurrentRows", totalRows) .detail("ExpectedSegments", tailer.totalSegments) .detail("CurrentSegments", manifest.totalSegments()) .detail("ExpectedBytes", tailer.totalBytes) .detail("CurrentBytes", totalBytes);
															#line 771 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			return a_body1Catch1(blob_restore_corrupted_manifest(), loopDepth);
															#line 7711 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
															#line 774 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<LoadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadActorState(); static_cast<LoadActor*>(this)->destroy(); return 0; }
															#line 7715 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<LoadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadActorState();
		static_cast<LoadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 762 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (tailer.totalRows != totalRows || tailer.totalSegments != manifest.totalSegments() || tailer.totalBytes != totalBytes)
															#line 7727 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 764 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			TraceEvent("BlobRestoreManifestCorruption") .detail("ExpectedRows", tailer.totalRows) .detail("CurrentRows", totalRows) .detail("ExpectedSegments", tailer.totalSegments) .detail("CurrentSegments", manifest.totalSegments()) .detail("ExpectedBytes", tailer.totalBytes) .detail("CurrentBytes", totalBytes);
															#line 771 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			return a_body1Catch1(blob_restore_corrupted_manifest(), loopDepth);
															#line 7733 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
															#line 774 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<LoadActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadActorState(); static_cast<LoadActor*>(this)->destroy(); return 0; }
															#line 7737 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<LoadActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadActorState();
		static_cast<LoadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<LoadActor*>(this)->actor_wait_state > 0) static_cast<LoadActor*>(this)->actor_wait_state = 0;
		static_cast<LoadActor*>(this)->ActorCallback< LoadActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< LoadActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< LoadActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 737 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestLoader> self;
															#line 738 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BackupContainerFileSystem> container;
															#line 742 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	BlobManifest manifest;
															#line 743 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Standalone<BlobManifestTailer> tailer;
															#line 744 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Arena arena;
															#line 745 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Optional<BlobGranuleCipherKeysCtx> cipherKeysCtx;
															#line 753 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int64_t totalRows;
															#line 754 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int64_t totalBytes;
															#line 755 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	std::vector<BlobManifestFile>::iterator iter;
															#line 7838 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via load()
															#line 737 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class LoadActor final : public Actor<Void>, public ActorCallback< LoadActor, 0, std::vector<BlobManifestFile> >, public ActorCallback< LoadActor, 1, Standalone<BlobManifestTailer> >, public ActorCallback< LoadActor, 2, BlobGranuleCipherKeysCtx >, public ActorCallback< LoadActor, 3, Void >, public ActorCallback< LoadActor, 4, Void >, public FastAllocated<LoadActor>, public LoadActorState<LoadActor> {
															#line 7843 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<LoadActor>::operator new;
	using FastAllocated<LoadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4588178777742346496UL, 4262736142637156352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadActor, 0, std::vector<BlobManifestFile> >;
friend struct ActorCallback< LoadActor, 1, Standalone<BlobManifestTailer> >;
friend struct ActorCallback< LoadActor, 2, BlobGranuleCipherKeysCtx >;
friend struct ActorCallback< LoadActor, 3, Void >;
friend struct ActorCallback< LoadActor, 4, Void >;
															#line 737 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	LoadActor(Reference<BlobManifestLoader> const& self) 
															#line 7864 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   LoadActorState<LoadActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("load", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9452025005965542912UL, 13383681653903659008UL);
		ActorExecutionContextHelper __helper(static_cast<LoadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("load");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("load", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadActor, 0, std::vector<BlobManifestFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadActor, 1, Standalone<BlobManifestTailer> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< LoadActor, 2, BlobGranuleCipherKeysCtx >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< LoadActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< LoadActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 737 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> load( Reference<BlobManifestLoader> const& self ) {
															#line 737 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new LoadActor(self));
															#line 7900 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 776 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

																#line 7905 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via loadTailer()
															#line 777 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class LoadTailerActor>
															#line 777 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class LoadTailerActorState {
															#line 7911 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 777 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	LoadTailerActorState(Reference<BlobManifestLoader> const& self,Reference<BackupContainerFileSystem> const& container,BlobManifestFile const& tailerFile) 
															#line 777 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 777 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 777 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   container(container),
															#line 777 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   tailerFile(tailerFile)
															#line 7922 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("loadTailer", reinterpret_cast<unsigned long>(this));

	}
	~LoadTailerActorState() 
	{
		fdb_probe_actor_destroy("loadTailer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 780 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (tailerFile.segmentNo != 0)
															#line 7937 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			{
															#line 781 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				TraceEvent("BlobRestoreMissingTailer").log();
															#line 782 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				return a_body1Catch1(blob_restore_corrupted_manifest(), loopDepth);
															#line 7943 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			}
															#line 785 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Value> __when_expr_0 = readFromFile(self, container, tailerFile.fileName);
															#line 785 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<LoadTailerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7949 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadTailerActor*>(this)->actor_wait_state = 1;
															#line 785 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadTailerActor, 0, Value >*>(static_cast<LoadTailerActor*>(this)));
															#line 7954 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadTailerActorState();
		static_cast<LoadTailerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Value const& data,int loopDepth) 
	{
															#line 786 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		Standalone<BlobManifestTailer> tailer;
															#line 787 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		BinaryReader binaryReader(data, IncludeVersion());
															#line 788 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		binaryReader >> tailer;
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<LoadTailerActor*>(this)->SAV<Standalone<BlobManifestTailer>>::futures) { (void)(tailer); this->~LoadTailerActorState(); static_cast<LoadTailerActor*>(this)->destroy(); return 0; }
															#line 7983 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<LoadTailerActor*>(this)->SAV< Standalone<BlobManifestTailer> >::value()) Standalone<BlobManifestTailer>(tailer);
		this->~LoadTailerActorState();
		static_cast<LoadTailerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Value && data,int loopDepth) 
	{
															#line 786 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		Standalone<BlobManifestTailer> tailer;
															#line 787 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		BinaryReader binaryReader(data, IncludeVersion());
															#line 788 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		binaryReader >> tailer;
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<LoadTailerActor*>(this)->SAV<Standalone<BlobManifestTailer>>::futures) { (void)(tailer); this->~LoadTailerActorState(); static_cast<LoadTailerActor*>(this)->destroy(); return 0; }
															#line 8001 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<LoadTailerActor*>(this)->SAV< Standalone<BlobManifestTailer> >::value()) Standalone<BlobManifestTailer>(tailer);
		this->~LoadTailerActorState();
		static_cast<LoadTailerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Value const& data,int loopDepth) 
	{
		loopDepth = a_body1cont1(data, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Value && data,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(data), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadTailerActor*>(this)->actor_wait_state > 0) static_cast<LoadTailerActor*>(this)->actor_wait_state = 0;
		static_cast<LoadTailerActor*>(this)->ActorCallback< LoadTailerActor, 0, Value >::remove();

	}
	void a_callback_fire(ActorCallback< LoadTailerActor, 0, Value >*,Value const& value) 
	{
		fdb_probe_actor_enter("loadTailer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTailerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTailer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadTailerActor, 0, Value >*,Value && value) 
	{
		fdb_probe_actor_enter("loadTailer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTailerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTailer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadTailerActor, 0, Value >*,Error err) 
	{
		fdb_probe_actor_enter("loadTailer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTailerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadTailer", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 777 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestLoader> self;
															#line 777 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BackupContainerFileSystem> container;
															#line 777 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	BlobManifestFile tailerFile;
															#line 8090 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via loadTailer()
															#line 777 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class LoadTailerActor final : public Actor<Standalone<BlobManifestTailer>>, public ActorCallback< LoadTailerActor, 0, Value >, public FastAllocated<LoadTailerActor>, public LoadTailerActorState<LoadTailerActor> {
															#line 8095 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<LoadTailerActor>::operator new;
	using FastAllocated<LoadTailerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8970139431932034560UL, 16121883090965452800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<BlobManifestTailer>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadTailerActor, 0, Value >;
															#line 777 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	LoadTailerActor(Reference<BlobManifestLoader> const& self,Reference<BackupContainerFileSystem> const& container,BlobManifestFile const& tailerFile) 
															#line 8112 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Standalone<BlobManifestTailer>>(),
		   LoadTailerActorState<LoadTailerActor>(self, container, tailerFile),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadTailer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9359606451158942720UL, 1837710222029163264UL);
		ActorExecutionContextHelper __helper(static_cast<LoadTailerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadTailer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadTailer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadTailerActor, 0, Value >*)0, actor_cancelled()); break;
		}

	}
};
															#line 777 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Standalone<BlobManifestTailer>> loadTailer( Reference<BlobManifestLoader> const& self, Reference<BackupContainerFileSystem> const& container, BlobManifestFile const& tailerFile ) {
															#line 777 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Standalone<BlobManifestTailer>>(new LoadTailerActor(self, container, tailerFile));
															#line 8144 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 791 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

																#line 8149 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via loadSegment()
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class LoadSegmentActor>
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class LoadSegmentActorState {
															#line 8155 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	LoadSegmentActorState(Reference<BlobManifestLoader> const& self,Reference<BackupContainerFileSystem> const& container,BlobManifestFile const& segmentFile,Optional<BlobGranuleCipherKeysCtx> const& cipherKeysCtx,int64_t* const& totalRows,int64_t* const& totalBytes) 
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   container(container),
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   segmentFile(segmentFile),
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   cipherKeysCtx(cipherKeysCtx),
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   totalRows(totalRows),
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   totalBytes(totalBytes)
															#line 8172 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("loadSegment", reinterpret_cast<unsigned long>(this));

	}
	~LoadSegmentActorState() 
	{
		fdb_probe_actor_destroy("loadSegment", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Value> __when_expr_0 = readFromFile(self, container, segmentFile.fileName);
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<LoadSegmentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8189 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadSegmentActor*>(this)->actor_wait_state = 1;
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadSegmentActor, 0, Value >*>(static_cast<LoadSegmentActor*>(this)));
															#line 8194 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadSegmentActorState();
		static_cast<LoadSegmentActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 799 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		*totalBytes += data.size();
															#line 801 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		rows = bgReadSnapshotFile(data, {}, cipherKeysCtx, allKeys);
															#line 802 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_1 = writeSystemKeys(self, rows);
															#line 802 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<LoadSegmentActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8223 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<LoadSegmentActor*>(this)->actor_wait_state = 2;
															#line 802 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< LoadSegmentActor, 1, Void >*>(static_cast<LoadSegmentActor*>(this)));
															#line 8228 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Value const& __data,int loopDepth) 
	{
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		data = __data;
															#line 8237 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Value && __data,int loopDepth) 
	{
		data = std::move(__data);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadSegmentActor*>(this)->actor_wait_state > 0) static_cast<LoadSegmentActor*>(this)->actor_wait_state = 0;
		static_cast<LoadSegmentActor*>(this)->ActorCallback< LoadSegmentActor, 0, Value >::remove();

	}
	void a_callback_fire(ActorCallback< LoadSegmentActor, 0, Value >*,Value const& value) 
	{
		fdb_probe_actor_enter("loadSegment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadSegmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadSegment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadSegmentActor, 0, Value >*,Value && value) 
	{
		fdb_probe_actor_enter("loadSegment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadSegmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadSegment", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadSegmentActor, 0, Value >*,Error err) 
	{
		fdb_probe_actor_enter("loadSegment", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadSegmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadSegment", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 803 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		*totalRows += rows.size();
															#line 804 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<LoadSegmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadSegmentActorState(); static_cast<LoadSegmentActor*>(this)->destroy(); return 0; }
															#line 8318 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<LoadSegmentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadSegmentActorState();
		static_cast<LoadSegmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 803 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		*totalRows += rows.size();
															#line 804 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<LoadSegmentActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadSegmentActorState(); static_cast<LoadSegmentActor*>(this)->destroy(); return 0; }
															#line 8332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<LoadSegmentActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadSegmentActorState();
		static_cast<LoadSegmentActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<LoadSegmentActor*>(this)->actor_wait_state > 0) static_cast<LoadSegmentActor*>(this)->actor_wait_state = 0;
		static_cast<LoadSegmentActor*>(this)->ActorCallback< LoadSegmentActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadSegmentActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadSegment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadSegmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadSegment", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< LoadSegmentActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadSegment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadSegmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadSegment", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< LoadSegmentActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadSegment", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadSegmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadSegment", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestLoader> self;
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BackupContainerFileSystem> container;
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	BlobManifestFile segmentFile;
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Optional<BlobGranuleCipherKeysCtx> cipherKeysCtx;
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int64_t* totalRows;
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int64_t* totalBytes;
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Value data;
															#line 801 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	RangeResult rows;
															#line 8431 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via loadSegment()
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class LoadSegmentActor final : public Actor<Void>, public ActorCallback< LoadSegmentActor, 0, Value >, public ActorCallback< LoadSegmentActor, 1, Void >, public FastAllocated<LoadSegmentActor>, public LoadSegmentActorState<LoadSegmentActor> {
															#line 8436 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<LoadSegmentActor>::operator new;
	using FastAllocated<LoadSegmentActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8641993902476640512UL, 11965197270667362816UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadSegmentActor, 0, Value >;
friend struct ActorCallback< LoadSegmentActor, 1, Void >;
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	LoadSegmentActor(Reference<BlobManifestLoader> const& self,Reference<BackupContainerFileSystem> const& container,BlobManifestFile const& segmentFile,Optional<BlobGranuleCipherKeysCtx> const& cipherKeysCtx,int64_t* const& totalRows,int64_t* const& totalBytes) 
															#line 8454 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   LoadSegmentActorState<LoadSegmentActor>(self, container, segmentFile, cipherKeysCtx, totalRows, totalBytes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadSegment", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1432078483057536000UL, 7900149144312481280UL);
		ActorExecutionContextHelper __helper(static_cast<LoadSegmentActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadSegment");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadSegment", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadSegmentActor, 0, Value >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< LoadSegmentActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> loadSegment( Reference<BlobManifestLoader> const& self, Reference<BackupContainerFileSystem> const& container, BlobManifestFile const& segmentFile, Optional<BlobGranuleCipherKeysCtx> const& cipherKeysCtx, int64_t* const& totalRows, int64_t* const& totalBytes ) {
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new LoadSegmentActor(self, container, segmentFile, cipherKeysCtx, totalRows, totalBytes));
															#line 8487 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 806 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Read data from a manifest file
																#line 8493 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via readFromFile()
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class ReadFromFileActor>
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ReadFromFileActorState {
															#line 8499 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ReadFromFileActorState(Reference<BlobManifestLoader> const& self,Reference<BackupContainerFileSystem> const& container,std::string const& fileName) 
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   container(container),
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   fileName(fileName)
															#line 8510 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("readFromFile", reinterpret_cast<unsigned long>(this));

	}
	~ReadFromFileActorState() 
	{
		fdb_probe_actor_destroy("readFromFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 811 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			dprint("Read manifest file {}\n", fileName);
															#line 812 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = container->readFile(fileName);
															#line 812 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<ReadFromFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8529 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadFromFileActor*>(this)->actor_wait_state = 1;
															#line 812 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadFromFileActor, 0, Reference<IAsyncFile> >*>(static_cast<ReadFromFileActor*>(this)));
															#line 8534 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadFromFileActorState();
		static_cast<ReadFromFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 813 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = reader->size();
															#line 813 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<ReadFromFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8559 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadFromFileActor*>(this)->actor_wait_state = 2;
															#line 813 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadFromFileActor, 1, int64_t >*>(static_cast<ReadFromFileActor*>(this)));
															#line 8564 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& __reader,int loopDepth) 
	{
															#line 812 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		reader = __reader;
															#line 8573 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && __reader,int loopDepth) 
	{
		reader = std::move(__reader);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadFromFileActor*>(this)->actor_wait_state > 0) static_cast<ReadFromFileActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromFileActor*>(this)->ActorCallback< ReadFromFileActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("readFromFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadFromFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("readFromFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadFromFileActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("readFromFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 814 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		arena = Arena();
															#line 815 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		data = new (arena) uint8_t[fileSize];
															#line 816 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<int> __when_expr_2 = reader->read(data, fileSize, 0);
															#line 816 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<ReadFromFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8658 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ReadFromFileActor*>(this)->actor_wait_state = 3;
															#line 816 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadFromFileActor, 2, int >*>(static_cast<ReadFromFileActor*>(this)));
															#line 8663 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(int64_t const& __fileSize,int loopDepth) 
	{
															#line 813 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		fileSize = __fileSize;
															#line 8672 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(int64_t && __fileSize,int loopDepth) 
	{
		fileSize = std::move(__fileSize);
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadFromFileActor*>(this)->actor_wait_state > 0) static_cast<ReadFromFileActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromFileActor*>(this)->ActorCallback< ReadFromFileActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromFileActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("readFromFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadFromFileActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("readFromFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadFromFileActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("readFromFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int const& readSize,int loopDepth) 
	{
															#line 817 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("Blob manifest restoring {} bytes\n", readSize);
															#line 818 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StringRef ref = StringRef(data, readSize);
															#line 819 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ReadFromFileActor*>(this)->SAV<Value>::futures) { (void)(Value(ref, arena)); this->~ReadFromFileActorState(); static_cast<ReadFromFileActor*>(this)->destroy(); return 0; }
															#line 8755 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ReadFromFileActor*>(this)->SAV< Value >::value()) Value(Value(ref, arena));
		this->~ReadFromFileActorState();
		static_cast<ReadFromFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int && readSize,int loopDepth) 
	{
															#line 817 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("Blob manifest restoring {} bytes\n", readSize);
															#line 818 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StringRef ref = StringRef(data, readSize);
															#line 819 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ReadFromFileActor*>(this)->SAV<Value>::futures) { (void)(Value(ref, arena)); this->~ReadFromFileActorState(); static_cast<ReadFromFileActor*>(this)->destroy(); return 0; }
															#line 8771 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ReadFromFileActor*>(this)->SAV< Value >::value()) Value(Value(ref, arena));
		this->~ReadFromFileActorState();
		static_cast<ReadFromFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(int const& readSize,int loopDepth) 
	{
		loopDepth = a_body1cont3(readSize, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(int && readSize,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(readSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadFromFileActor*>(this)->actor_wait_state > 0) static_cast<ReadFromFileActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFromFileActor*>(this)->ActorCallback< ReadFromFileActor, 2, int >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFromFileActor, 2, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readFromFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadFromFileActor, 2, int >*,int && value) 
	{
		fdb_probe_actor_enter("readFromFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadFromFileActor, 2, int >*,Error err) 
	{
		fdb_probe_actor_enter("readFromFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFromFile", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestLoader> self;
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BackupContainerFileSystem> container;
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	std::string fileName;
															#line 812 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<IAsyncFile> reader;
															#line 813 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int64_t fileSize;
															#line 814 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Arena arena;
															#line 815 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	uint8_t* data;
															#line 8868 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via readFromFile()
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ReadFromFileActor final : public Actor<Value>, public ActorCallback< ReadFromFileActor, 0, Reference<IAsyncFile> >, public ActorCallback< ReadFromFileActor, 1, int64_t >, public ActorCallback< ReadFromFileActor, 2, int >, public FastAllocated<ReadFromFileActor>, public ReadFromFileActorState<ReadFromFileActor> {
															#line 8873 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<ReadFromFileActor>::operator new;
	using FastAllocated<ReadFromFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5451436962601449984UL, 14452661351627379456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Value>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadFromFileActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< ReadFromFileActor, 1, int64_t >;
friend struct ActorCallback< ReadFromFileActor, 2, int >;
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ReadFromFileActor(Reference<BlobManifestLoader> const& self,Reference<BackupContainerFileSystem> const& container,std::string const& fileName) 
															#line 8892 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Value>(),
		   ReadFromFileActorState<ReadFromFileActor>(self, container, fileName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readFromFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12549550556786349056UL, 10980564325864710656UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFromFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readFromFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readFromFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadFromFileActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadFromFileActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadFromFileActor, 2, int >*)0, actor_cancelled()); break;
		}

	}
};
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Value> readFromFile( Reference<BlobManifestLoader> const& self, Reference<BackupContainerFileSystem> const& container, std::string const& fileName ) {
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Value>(new ReadFromFileActor(self, container, fileName));
															#line 8926 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 821 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Write system keys to database
																#line 8932 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via writeSystemKeys()
															#line 823 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class WriteSystemKeysActor>
															#line 823 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class WriteSystemKeysActorState {
															#line 8938 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 823 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	WriteSystemKeysActorState(Reference<BlobManifestLoader> const& self,RangeResult const& rows) 
															#line 823 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 823 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 823 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   rows(rows),
															#line 824 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   start(0),
															#line 825 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   end(0)
															#line 8951 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("writeSystemKeys", reinterpret_cast<unsigned long>(this));

	}
	~WriteSystemKeysActorState() 
	{
		fdb_probe_actor_destroy("writeSystemKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 826 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			start = 0;
															#line 8966 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteSystemKeysActorState();
		static_cast<WriteSystemKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 830 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<WriteSystemKeysActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteSystemKeysActorState(); static_cast<WriteSystemKeysActor*>(this)->destroy(); return 0; }
															#line 8989 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<WriteSystemKeysActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteSystemKeysActorState();
		static_cast<WriteSystemKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 826 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!(start < rows.size()))
															#line 9008 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 827 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		end = std::min(start + SERVER_KNOBS->BLOB_MANIFEST_RW_ROWS, rows.size());
															#line 828 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<Void> __when_expr_0 = writeSystemKeys(self, rows, start, end);
															#line 828 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<WriteSystemKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9018 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<WriteSystemKeysActor*>(this)->actor_wait_state = 1;
															#line 828 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteSystemKeysActor, 0, Void >*>(static_cast<WriteSystemKeysActor*>(this)));
															#line 9023 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 826 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		start = end;
															#line 9045 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 826 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		start = end;
															#line 9054 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteSystemKeysActor*>(this)->actor_wait_state > 0) static_cast<WriteSystemKeysActor*>(this)->actor_wait_state = 0;
		static_cast<WriteSystemKeysActor*>(this)->ActorCallback< WriteSystemKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteSystemKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteSystemKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteSystemKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 823 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestLoader> self;
															#line 823 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	RangeResult rows;
															#line 824 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int start;
															#line 825 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int end;
															#line 9142 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via writeSystemKeys()
															#line 823 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class WriteSystemKeysActor final : public Actor<Void>, public ActorCallback< WriteSystemKeysActor, 0, Void >, public FastAllocated<WriteSystemKeysActor>, public WriteSystemKeysActorState<WriteSystemKeysActor> {
															#line 9147 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<WriteSystemKeysActor>::operator new;
	using FastAllocated<WriteSystemKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16475476677108329216UL, 4364805975988944896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteSystemKeysActor, 0, Void >;
															#line 823 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	WriteSystemKeysActor(Reference<BlobManifestLoader> const& self,RangeResult const& rows) 
															#line 9164 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   WriteSystemKeysActorState<WriteSystemKeysActor>(self, rows),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeSystemKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14922351279475292416UL, 5530827796740565504UL);
		ActorExecutionContextHelper __helper(static_cast<WriteSystemKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeSystemKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeSystemKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteSystemKeysActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 823 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> writeSystemKeys( Reference<BlobManifestLoader> const& self, RangeResult const& rows ) {
															#line 823 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new WriteSystemKeysActor(self, rows));
															#line 9196 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 832 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Write system keys from start index to end(exclusive), so that we don't exceed the limit of transaction limit
																#line 9202 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via writeSystemKeys()
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class WriteSystemKeysActor1>
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class WriteSystemKeysActor1State {
															#line 9208 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	WriteSystemKeysActor1State(Reference<BlobManifestLoader> const& self,RangeResult const& rows,int const& start,int const& end) 
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   rows(rows),
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   start(start),
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   end(end),
															#line 838 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   tr(self->db_)
															#line 9223 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("writeSystemKeys", reinterpret_cast<unsigned long>(this));

	}
	~WriteSystemKeysActor1State() 
	{
		fdb_probe_actor_destroy("writeSystemKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 839 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			;
															#line 9238 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteSystemKeysActor1State();
		static_cast<WriteSystemKeysActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 840 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 841 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 842 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 9272 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		try {
															#line 844 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			for(int i = start;i < end;++i) {
															#line 848 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				if (rows[i].key == TenantMetadata::lastTenantId().key || rows[i].key == TenantMetadata::lastTenantModification().key)
															#line 9278 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				{
															#line 850 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
					self->delayedRows_.push_back_deep(self->delayedRows_.arena(), rows[i]);
															#line 9282 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				}
				else
				{
															#line 852 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
					tr.set(rows[i].key, rows[i].value);
															#line 9288 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				}
			}
															#line 855 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 855 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<WriteSystemKeysActor1*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9295 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteSystemKeysActor1*>(this)->actor_wait_state = 1;
															#line 855 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteSystemKeysActor1, 0, Void >*>(static_cast<WriteSystemKeysActor1*>(this)));
															#line 9300 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 860 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 860 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<WriteSystemKeysActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9324 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WriteSystemKeysActor1*>(this)->actor_wait_state = 2;
															#line 860 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteSystemKeysActor1, 1, Void >*>(static_cast<WriteSystemKeysActor1*>(this)));
															#line 9329 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 856 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("Blob manifest loaded rows from {} to {}\n", start, end);
															#line 857 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		TraceEvent("BlobManifestLoader").detail("RowStart", start).detail("RowEnd", end);
															#line 858 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<WriteSystemKeysActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteSystemKeysActor1State(); static_cast<WriteSystemKeysActor1*>(this)->destroy(); return 0; }
															#line 9348 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<WriteSystemKeysActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteSystemKeysActor1State();
		static_cast<WriteSystemKeysActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 856 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("Blob manifest loaded rows from {} to {}\n", start, end);
															#line 857 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		TraceEvent("BlobManifestLoader").detail("RowStart", start).detail("RowEnd", end);
															#line 858 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<WriteSystemKeysActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteSystemKeysActor1State(); static_cast<WriteSystemKeysActor1*>(this)->destroy(); return 0; }
															#line 9364 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<WriteSystemKeysActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteSystemKeysActor1State();
		static_cast<WriteSystemKeysActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteSystemKeysActor1*>(this)->actor_wait_state > 0) static_cast<WriteSystemKeysActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteSystemKeysActor1*>(this)->ActorCallback< WriteSystemKeysActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteSystemKeysActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteSystemKeysActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteSystemKeysActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteSystemKeysActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteSystemKeysActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeSystemKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteSystemKeysActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeSystemKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteSystemKeysActor1*>(this)->actor_wait_state > 0) static_cast<WriteSystemKeysActor1*>(this)->actor_wait_state = 0;
		static_cast<WriteSystemKeysActor1*>(this)->ActorCallback< WriteSystemKeysActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteSystemKeysActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeSystemKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteSystemKeysActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeSystemKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteSystemKeysActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeSystemKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteSystemKeysActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeSystemKeys", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteSystemKeysActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeSystemKeys", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteSystemKeysActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeSystemKeys", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestLoader> self;
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	RangeResult rows;
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int start;
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int end;
															#line 838 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Transaction tr;
															#line 9544 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via writeSystemKeys()
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class WriteSystemKeysActor1 final : public Actor<Void>, public ActorCallback< WriteSystemKeysActor1, 0, Void >, public ActorCallback< WriteSystemKeysActor1, 1, Void >, public FastAllocated<WriteSystemKeysActor1>, public WriteSystemKeysActor1State<WriteSystemKeysActor1> {
															#line 9549 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<WriteSystemKeysActor1>::operator new;
	using FastAllocated<WriteSystemKeysActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16475476677108329216UL, 4364805975988944896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteSystemKeysActor1, 0, Void >;
friend struct ActorCallback< WriteSystemKeysActor1, 1, Void >;
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	WriteSystemKeysActor1(Reference<BlobManifestLoader> const& self,RangeResult const& rows,int const& start,int const& end) 
															#line 9567 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   WriteSystemKeysActor1State<WriteSystemKeysActor1>(self, rows, start, end),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeSystemKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10931073766380528640UL, 2127371183535107840UL);
		ActorExecutionContextHelper __helper(static_cast<WriteSystemKeysActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeSystemKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeSystemKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteSystemKeysActor1, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteSystemKeysActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> writeSystemKeys( Reference<BlobManifestLoader> const& self, RangeResult const& rows, int const& start, int const& end ) {
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new WriteSystemKeysActor1(self, rows, start, end));
															#line 9600 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 864 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

																#line 9605 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via writeDelayedRows()
															#line 865 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class WriteDelayedRowsActor>
															#line 865 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class WriteDelayedRowsActorState {
															#line 9611 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 865 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	WriteDelayedRowsActorState(Reference<BlobManifestLoader> const& self) 
															#line 865 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 865 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self)
															#line 9618 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("writeDelayedRows", reinterpret_cast<unsigned long>(this));

	}
	~WriteDelayedRowsActorState() 
	{
		fdb_probe_actor_destroy("writeDelayedRows", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 866 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (self->delayedRows_.empty())
															#line 9633 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			{
															#line 867 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				if (!static_cast<WriteDelayedRowsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteDelayedRowsActorState(); static_cast<WriteDelayedRowsActor*>(this)->destroy(); return 0; }
															#line 9637 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
				new (&static_cast<WriteDelayedRowsActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WriteDelayedRowsActorState();
				static_cast<WriteDelayedRowsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 870 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			tr = Transaction(self->db_);
															#line 871 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			;
															#line 9647 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteDelayedRowsActorState();
		static_cast<WriteDelayedRowsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 872 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 873 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 874 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 9681 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		try {
															#line 876 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			for( auto& row : self->delayedRows_ ) {
															#line 877 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
				tr.set(row.key, row.value);
															#line 9687 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			}
															#line 879 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 879 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<WriteDelayedRowsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9693 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteDelayedRowsActor*>(this)->actor_wait_state = 1;
															#line 879 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteDelayedRowsActor, 0, Void >*>(static_cast<WriteDelayedRowsActor*>(this)));
															#line 9698 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 882 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 882 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<WriteDelayedRowsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9722 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<WriteDelayedRowsActor*>(this)->actor_wait_state = 2;
															#line 882 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteDelayedRowsActor, 1, Void >*>(static_cast<WriteDelayedRowsActor*>(this)));
															#line 9727 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 880 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<WriteDelayedRowsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteDelayedRowsActorState(); static_cast<WriteDelayedRowsActor*>(this)->destroy(); return 0; }
															#line 9742 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<WriteDelayedRowsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteDelayedRowsActorState();
		static_cast<WriteDelayedRowsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 880 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<WriteDelayedRowsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteDelayedRowsActorState(); static_cast<WriteDelayedRowsActor*>(this)->destroy(); return 0; }
															#line 9754 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<WriteDelayedRowsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteDelayedRowsActorState();
		static_cast<WriteDelayedRowsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteDelayedRowsActor*>(this)->actor_wait_state > 0) static_cast<WriteDelayedRowsActor*>(this)->actor_wait_state = 0;
		static_cast<WriteDelayedRowsActor*>(this)->ActorCallback< WriteDelayedRowsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteDelayedRowsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeDelayedRows", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDelayedRowsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDelayedRows", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteDelayedRowsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeDelayedRows", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDelayedRowsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDelayedRows", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteDelayedRowsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeDelayedRows", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDelayedRowsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDelayedRows", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteDelayedRowsActor*>(this)->actor_wait_state > 0) static_cast<WriteDelayedRowsActor*>(this)->actor_wait_state = 0;
		static_cast<WriteDelayedRowsActor*>(this)->ActorCallback< WriteDelayedRowsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteDelayedRowsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeDelayedRows", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDelayedRowsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDelayedRows", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteDelayedRowsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeDelayedRows", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDelayedRowsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDelayedRows", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteDelayedRowsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeDelayedRows", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDelayedRowsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeDelayedRows", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 865 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestLoader> self;
															#line 870 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Transaction tr;
															#line 9928 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via writeDelayedRows()
															#line 865 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class WriteDelayedRowsActor final : public Actor<Void>, public ActorCallback< WriteDelayedRowsActor, 0, Void >, public ActorCallback< WriteDelayedRowsActor, 1, Void >, public FastAllocated<WriteDelayedRowsActor>, public WriteDelayedRowsActorState<WriteDelayedRowsActor> {
															#line 9933 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<WriteDelayedRowsActor>::operator new;
	using FastAllocated<WriteDelayedRowsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13713561826929582336UL, 6409688186280373248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteDelayedRowsActor, 0, Void >;
friend struct ActorCallback< WriteDelayedRowsActor, 1, Void >;
															#line 865 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	WriteDelayedRowsActor(Reference<BlobManifestLoader> const& self) 
															#line 9951 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   WriteDelayedRowsActorState<WriteDelayedRowsActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeDelayedRows", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11629874868501434624UL, 3719149081196389888UL);
		ActorExecutionContextHelper __helper(static_cast<WriteDelayedRowsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeDelayedRows");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeDelayedRows", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteDelayedRowsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteDelayedRowsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 865 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> writeDelayedRows( Reference<BlobManifestLoader> const& self ) {
															#line 865 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new WriteDelayedRowsActor(self));
															#line 9984 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 886 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Validate correctness of the loaded manifest
																#line 9990 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via validate()
															#line 888 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class ValidateActor>
															#line 888 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ValidateActorState {
															#line 9996 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 888 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ValidateActorState(Reference<BlobManifestLoader> const& self) 
															#line 888 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 888 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self)
															#line 10003 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("validate", reinterpret_cast<unsigned long>(this));

	}
	~ValidateActorState() 
	{
		fdb_probe_actor_destroy("validate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 891 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Version> __when_expr_0 = getManifestVersion(self->db_);
															#line 891 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<ValidateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10020 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ValidateActor*>(this)->actor_wait_state = 1;
															#line 891 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ValidateActor, 0, Version >*>(static_cast<ValidateActor*>(this)));
															#line 10025 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ValidateActorState();
		static_cast<ValidateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Version const& manifestVersion,int loopDepth) 
	{
															#line 892 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("Blob manifest version {}\n", manifestVersion);
															#line 894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<BlobGranuleRestoreVersionVector> __when_expr_1 = listGranules(self);
															#line 894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<ValidateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10052 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ValidateActor*>(this)->actor_wait_state = 2;
															#line 894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateActor, 1, BlobGranuleRestoreVersionVector >*>(static_cast<ValidateActor*>(this)));
															#line 10057 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Version && manifestVersion,int loopDepth) 
	{
															#line 892 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("Blob manifest version {}\n", manifestVersion);
															#line 894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<BlobGranuleRestoreVersionVector> __when_expr_1 = listGranules(self);
															#line 894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<ValidateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10070 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ValidateActor*>(this)->actor_wait_state = 2;
															#line 894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ValidateActor, 1, BlobGranuleRestoreVersionVector >*>(static_cast<ValidateActor*>(this)));
															#line 10075 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Version const& manifestVersion,int loopDepth) 
	{
		loopDepth = a_body1cont1(manifestVersion, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && manifestVersion,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(manifestVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ValidateActor*>(this)->actor_wait_state > 0) static_cast<ValidateActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateActor*>(this)->ActorCallback< ValidateActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("validate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ValidateActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("validate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ValidateActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("validate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(BlobGranuleRestoreVersionVector const& _,int loopDepth) 
	{
															#line 895 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ValidateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateActorState(); static_cast<ValidateActor*>(this)->destroy(); return 0; }
															#line 10159 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ValidateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateActorState();
		static_cast<ValidateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(BlobGranuleRestoreVersionVector && _,int loopDepth) 
	{
															#line 895 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ValidateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ValidateActorState(); static_cast<ValidateActor*>(this)->destroy(); return 0; }
															#line 10171 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ValidateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ValidateActorState();
		static_cast<ValidateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(BlobGranuleRestoreVersionVector const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(BlobGranuleRestoreVersionVector && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ValidateActor*>(this)->actor_wait_state > 0) static_cast<ValidateActor*>(this)->actor_wait_state = 0;
		static_cast<ValidateActor*>(this)->ActorCallback< ValidateActor, 1, BlobGranuleRestoreVersionVector >::remove();

	}
	void a_callback_fire(ActorCallback< ValidateActor, 1, BlobGranuleRestoreVersionVector >*,BlobGranuleRestoreVersionVector const& value) 
	{
		fdb_probe_actor_enter("validate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ValidateActor, 1, BlobGranuleRestoreVersionVector >*,BlobGranuleRestoreVersionVector && value) 
	{
		fdb_probe_actor_enter("validate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ValidateActor, 1, BlobGranuleRestoreVersionVector >*,Error err) 
	{
		fdb_probe_actor_enter("validate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("validate", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 888 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestLoader> self;
															#line 10256 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via validate()
															#line 888 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ValidateActor final : public Actor<Void>, public ActorCallback< ValidateActor, 0, Version >, public ActorCallback< ValidateActor, 1, BlobGranuleRestoreVersionVector >, public FastAllocated<ValidateActor>, public ValidateActorState<ValidateActor> {
															#line 10261 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<ValidateActor>::operator new;
	using FastAllocated<ValidateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13482697066090028032UL, 15709700398855925248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ValidateActor, 0, Version >;
friend struct ActorCallback< ValidateActor, 1, BlobGranuleRestoreVersionVector >;
															#line 888 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ValidateActor(Reference<BlobManifestLoader> const& self) 
															#line 10279 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   ValidateActorState<ValidateActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("validate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17980783697279217408UL, 11074725319971040256UL);
		ActorExecutionContextHelper __helper(static_cast<ValidateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("validate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("validate", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ValidateActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ValidateActor, 1, BlobGranuleRestoreVersionVector >*)0, actor_cancelled()); break;
		}

	}
};
															#line 888 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> validate( Reference<BlobManifestLoader> const& self ) {
															#line 888 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new ValidateActor(self));
															#line 10312 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 897 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Find the newest granule for a key range. The newest granule has the max version and relevant files
																#line 10318 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via getGranule()
															#line 899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class GetGranuleActor>
															#line 899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class GetGranuleActorState {
															#line 10324 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	GetGranuleActorState(Transaction* const& tr,KeyRangeRef const& range) 
															#line 899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : tr(tr),
															#line 899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   range(range),
															#line 900 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   granuleVersion(),
															#line 901 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   historyKeyRange(blobGranuleHistoryKeyRangeFor(range))
															#line 10337 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("getGranule", reinterpret_cast<unsigned long>(this));

	}
	~GetGranuleActorState() 
	{
		fdb_probe_actor_destroy("getGranule", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 902 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			;
															#line 10352 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetGranuleActorState();
		static_cast<GetGranuleActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 905 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(historyKeyRange, GetRangeLimits::BYTE_LIMIT_UNLIMITED, Snapshot::True, Reverse::True);
															#line 905 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<GetGranuleActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 10385 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetGranuleActor*>(this)->actor_wait_state = 1;
															#line 905 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetGranuleActor, 0, RangeResult >*>(static_cast<GetGranuleActor*>(this)));
															#line 10390 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 935 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr->onError(e);
															#line 935 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<GetGranuleActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10414 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<GetGranuleActor*>(this)->actor_wait_state = 3;
															#line 935 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< GetGranuleActor, 2, Void >*>(static_cast<GetGranuleActor*>(this)));
															#line 10419 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 907 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		RangeForbody1loopBody1cont2Iterator0 = std::begin(results);
															#line 10434 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& __results,int loopDepth) 
	{
															#line 905 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		results = __results;
															#line 10443 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && __results,int loopDepth) 
	{
		results = std::move(__results);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetGranuleActor*>(this)->actor_wait_state > 0) static_cast<GetGranuleActor*>(this)->actor_wait_state = 0;
		static_cast<GetGranuleActor*>(this)->ActorCallback< GetGranuleActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetGranuleActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getGranule", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGranuleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGranule", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetGranuleActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getGranule", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGranuleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGranule", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetGranuleActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getGranule", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetGranuleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGranule", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 933 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		return a_body1loopBody1Catch1(restore_missing_data(), loopDepth);
															#line 10522 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 907 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!(RangeForbody1loopBody1cont2Iterator0 != std::end(results)))
															#line 10537 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 907 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		KeyValueRef row = *RangeForbody1loopBody1cont2Iterator0;
															#line 10543 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 908 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			keyRange = KeyRange();
															#line 909 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			version = Version();
															#line 910 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			std::tie(keyRange, version) = decodeBlobGranuleHistoryKey(row.key);
															#line 911 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			Standalone<BlobGranuleHistoryValue> historyValue = decodeBlobGranuleHistoryValue(row.value);
															#line 912 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			granuleID = historyValue.granuleID;
															#line 914 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<std::vector<GranuleFileVersion>> __when_expr_1 = listGranuleFiles(tr, granuleID);
															#line 914 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<GetGranuleActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10559 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetGranuleActor*>(this)->actor_wait_state = 2;
															#line 914 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetGranuleActor, 1, std::vector<GranuleFileVersion> >*>(static_cast<GetGranuleActor*>(this)));
															#line 10564 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(std::vector<GranuleFileVersion> const& files,int loopDepth) 
	{
															#line 916 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		granuleVersion.keyRange = KeyRangeRef(granuleVersion.arena(), keyRange);
															#line 917 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		granuleVersion.granuleID = granuleID;
															#line 918 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (files.empty())
															#line 10591 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 919 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			dprint("Granule {} doesn't have files for version {}\n", granuleID.toString(), version);
															#line 920 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			granuleVersion.version = version;
															#line 921 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			granuleVersion.sizeInBytes = 1;
															#line 10599 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
		else
		{
															#line 923 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			granuleVersion.version = files.back().version;
															#line 924 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			granuleVersion.sizeInBytes = granuleSizeInBytes(files);
															#line 10607 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
															#line 926 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("Granule {}: \n", granuleVersion.granuleID.toString());
															#line 927 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("  {} {} {}\n", keyRange.toString(), granuleVersion.version, granuleVersion.sizeInBytes);
															#line 928 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		for( auto& file : files ) {
															#line 929 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			dprint("  File {}: {} bytes\n", file.filename, file.sizeInBytes);
															#line 10617 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
															#line 931 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<GetGranuleActor*>(this)->SAV<Standalone<BlobGranuleRestoreVersion>>::futures) { (void)(granuleVersion); this->~GetGranuleActorState(); static_cast<GetGranuleActor*>(this)->destroy(); return 0; }
															#line 10621 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<GetGranuleActor*>(this)->SAV< Standalone<BlobGranuleRestoreVersion> >::value()) Standalone<BlobGranuleRestoreVersion>(std::move(granuleVersion)); // state_var_RVO
		this->~GetGranuleActorState();
		static_cast<GetGranuleActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(std::vector<GranuleFileVersion> && files,int loopDepth) 
	{
															#line 916 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		granuleVersion.keyRange = KeyRangeRef(granuleVersion.arena(), keyRange);
															#line 917 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		granuleVersion.granuleID = granuleID;
															#line 918 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (files.empty())
															#line 10637 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 919 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			dprint("Granule {} doesn't have files for version {}\n", granuleID.toString(), version);
															#line 920 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			granuleVersion.version = version;
															#line 921 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			granuleVersion.sizeInBytes = 1;
															#line 10645 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
		else
		{
															#line 923 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			granuleVersion.version = files.back().version;
															#line 924 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			granuleVersion.sizeInBytes = granuleSizeInBytes(files);
															#line 10653 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
															#line 926 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("Granule {}: \n", granuleVersion.granuleID.toString());
															#line 927 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("  {} {} {}\n", keyRange.toString(), granuleVersion.version, granuleVersion.sizeInBytes);
															#line 928 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		for( auto& file : files ) {
															#line 929 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			dprint("  File {}: {} bytes\n", file.filename, file.sizeInBytes);
															#line 10663 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
															#line 931 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<GetGranuleActor*>(this)->SAV<Standalone<BlobGranuleRestoreVersion>>::futures) { (void)(granuleVersion); this->~GetGranuleActorState(); static_cast<GetGranuleActor*>(this)->destroy(); return 0; }
															#line 10667 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<GetGranuleActor*>(this)->SAV< Standalone<BlobGranuleRestoreVersion> >::value()) Standalone<BlobGranuleRestoreVersion>(std::move(granuleVersion)); // state_var_RVO
		this->~GetGranuleActorState();
		static_cast<GetGranuleActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(std::vector<GranuleFileVersion> const& files,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(files, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(std::vector<GranuleFileVersion> && files,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(std::move(files), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetGranuleActor*>(this)->actor_wait_state > 0) static_cast<GetGranuleActor*>(this)->actor_wait_state = 0;
		static_cast<GetGranuleActor*>(this)->ActorCallback< GetGranuleActor, 1, std::vector<GranuleFileVersion> >::remove();

	}
	void a_callback_fire(ActorCallback< GetGranuleActor, 1, std::vector<GranuleFileVersion> >*,std::vector<GranuleFileVersion> const& value) 
	{
		fdb_probe_actor_enter("getGranule", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGranuleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGranule", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetGranuleActor, 1, std::vector<GranuleFileVersion> >*,std::vector<GranuleFileVersion> && value) 
	{
		fdb_probe_actor_enter("getGranule", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGranuleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGranule", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetGranuleActor, 1, std::vector<GranuleFileVersion> >*,Error err) 
	{
		fdb_probe_actor_enter("getGranule", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetGranuleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGranule", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<GetGranuleActor*>(this)->actor_wait_state > 0) static_cast<GetGranuleActor*>(this)->actor_wait_state = 0;
		static_cast<GetGranuleActor*>(this)->ActorCallback< GetGranuleActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetGranuleActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getGranule", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGranuleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGranule", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< GetGranuleActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getGranule", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetGranuleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGranule", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< GetGranuleActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getGranule", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetGranuleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getGranule", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Transaction* tr;
															#line 899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeyRangeRef range;
															#line 900 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Standalone<BlobGranuleRestoreVersion> granuleVersion;
															#line 901 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeyRange historyKeyRange;
															#line 905 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	RangeResult results;
															#line 907 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	decltype(std::begin(std::declval<RangeResult>())) RangeForbody1loopBody1cont2Iterator0;
															#line 908 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeyRange keyRange;
															#line 909 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Version version;
															#line 912 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	UID granuleID;
															#line 10855 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via getGranule()
															#line 899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class GetGranuleActor final : public Actor<Standalone<BlobGranuleRestoreVersion>>, public ActorCallback< GetGranuleActor, 0, RangeResult >, public ActorCallback< GetGranuleActor, 1, std::vector<GranuleFileVersion> >, public ActorCallback< GetGranuleActor, 2, Void >, public FastAllocated<GetGranuleActor>, public GetGranuleActorState<GetGranuleActor> {
															#line 10860 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<GetGranuleActor>::operator new;
	using FastAllocated<GetGranuleActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4839604986118387968UL, 7295040999622631680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<BlobGranuleRestoreVersion>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetGranuleActor, 0, RangeResult >;
friend struct ActorCallback< GetGranuleActor, 1, std::vector<GranuleFileVersion> >;
friend struct ActorCallback< GetGranuleActor, 2, Void >;
															#line 899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	GetGranuleActor(Transaction* const& tr,KeyRangeRef const& range) 
															#line 10879 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Standalone<BlobGranuleRestoreVersion>>(),
		   GetGranuleActorState<GetGranuleActor>(tr, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getGranule", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4501217528628130048UL, 18411170019894760192UL);
		ActorExecutionContextHelper __helper(static_cast<GetGranuleActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getGranule");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getGranule", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetGranuleActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetGranuleActor, 1, std::vector<GranuleFileVersion> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< GetGranuleActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Standalone<BlobGranuleRestoreVersion>> getGranule( Transaction* const& tr, KeyRangeRef const& range ) {
															#line 899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Standalone<BlobGranuleRestoreVersion>>(new GetGranuleActor(tr, range));
															#line 10913 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 939 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Return sum of last snapshot file size and delta files afterwards
	static int64_t granuleSizeInBytes(std::vector<GranuleFileVersion> files) {
		int64_t totalSize = 0;
		for (auto it = files.rbegin(); it < files.rend(); ++it) {
			totalSize += it->sizeInBytes;
			if (it->fileType == BG_FILE_TYPE_SNAPSHOT)
				break;
		}
		return totalSize;
	}

	// List all files for given granule
																#line 10930 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via listGranuleFiles()
															#line 952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class ListGranuleFilesActor>
															#line 952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ListGranuleFilesActorState {
															#line 10936 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ListGranuleFilesActorState(Transaction* const& tr,UID const& granuleID) 
															#line 952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : tr(tr),
															#line 952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   granuleID(granuleID),
															#line 953 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   files(),
															#line 955 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   fileKeyRange(blobGranuleFileKeyRangeFor(granuleID)),
															#line 956 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   limits(SERVER_KNOBS->BLOB_MANIFEST_RW_ROWS)
															#line 10951 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("listGranuleFiles", reinterpret_cast<unsigned long>(this));

	}
	~ListGranuleFilesActorState() 
	{
		fdb_probe_actor_destroy("listGranuleFiles", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 957 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			limits.minRows = 0;
															#line 958 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			begin = firstGreaterOrEqual(fileKeyRange.begin);
															#line 959 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			end = firstGreaterOrEqual(fileKeyRange.end);
															#line 960 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			;
															#line 10972 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListGranuleFilesActorState();
		static_cast<ListGranuleFilesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 984 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ListGranuleFilesActor*>(this)->SAV<std::vector<GranuleFileVersion>>::futures) { (void)(files); this->~ListGranuleFilesActorState(); static_cast<ListGranuleFilesActor*>(this)->destroy(); return 0; }
															#line 10995 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ListGranuleFilesActor*>(this)->SAV< std::vector<GranuleFileVersion> >::value()) std::vector<GranuleFileVersion>(std::move(files)); // state_var_RVO
		this->~ListGranuleFilesActorState();
		static_cast<ListGranuleFilesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 961 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = tr->getRange(begin, end, limits, Snapshot::True);
															#line 961 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (static_cast<ListGranuleFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11016 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ListGranuleFilesActor*>(this)->actor_wait_state = 1;
															#line 961 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListGranuleFilesActor, 0, RangeResult >*>(static_cast<ListGranuleFilesActor*>(this)));
															#line 11021 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult const& results,int loopDepth) 
	{
															#line 962 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		for( auto& row : results ) {
															#line 963 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			UID gid;
															#line 964 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			Version version;
															#line 965 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			uint8_t fileType;
															#line 966 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			Standalone<StringRef> filename;
															#line 967 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			int64_t offset;
															#line 968 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			int64_t length;
															#line 969 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			int64_t fullFileLength;
															#line 970 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			int64_t logicalSize;
															#line 971 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			Optional<BlobGranuleCipherKeysMeta> cipherKeysMeta;
															#line 973 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			std::tie(gid, version, fileType) = decodeBlobGranuleFileKey(row.key);
															#line 974 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			std::tie(filename, offset, length, fullFileLength, logicalSize, cipherKeysMeta) = decodeBlobGranuleFileValue(row.value);
															#line 976 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			GranuleFileVersion vs = { version, fileType, filename.toString(), length };
															#line 977 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			files.push_back(vs);
															#line 11069 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
															#line 979 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!results.more)
															#line 11073 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 982 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		begin = results.nextBeginKeySelector();
															#line 11079 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(RangeResult && results,int loopDepth) 
	{
															#line 962 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		for( auto& row : results ) {
															#line 963 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			UID gid;
															#line 964 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			Version version;
															#line 965 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			uint8_t fileType;
															#line 966 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			Standalone<StringRef> filename;
															#line 967 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			int64_t offset;
															#line 968 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			int64_t length;
															#line 969 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			int64_t fullFileLength;
															#line 970 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			int64_t logicalSize;
															#line 971 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			Optional<BlobGranuleCipherKeysMeta> cipherKeysMeta;
															#line 973 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			std::tie(gid, version, fileType) = decodeBlobGranuleFileKey(row.key);
															#line 974 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			std::tie(filename, offset, length, fullFileLength, logicalSize, cipherKeysMeta) = decodeBlobGranuleFileValue(row.value);
															#line 976 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			GranuleFileVersion vs = { version, fileType, filename.toString(), length };
															#line 977 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			files.push_back(vs);
															#line 11114 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		}
															#line 979 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!results.more)
															#line 11118 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 982 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		begin = results.nextBeginKeySelector();
															#line 11124 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(results, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && results,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListGranuleFilesActor*>(this)->actor_wait_state > 0) static_cast<ListGranuleFilesActor*>(this)->actor_wait_state = 0;
		static_cast<ListGranuleFilesActor*>(this)->ActorCallback< ListGranuleFilesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ListGranuleFilesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("listGranuleFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listGranuleFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListGranuleFilesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("listGranuleFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listGranuleFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListGranuleFilesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("listGranuleFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listGranuleFiles", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Transaction* tr;
															#line 952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	UID granuleID;
															#line 953 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	std::vector<GranuleFileVersion> files;
															#line 955 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeyRange fileKeyRange;
															#line 956 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	GetRangeLimits limits;
															#line 958 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeySelectorRef begin;
															#line 959 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeySelectorRef end;
															#line 11218 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via listGranuleFiles()
															#line 952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ListGranuleFilesActor final : public Actor<std::vector<GranuleFileVersion>>, public ActorCallback< ListGranuleFilesActor, 0, RangeResult >, public FastAllocated<ListGranuleFilesActor>, public ListGranuleFilesActorState<ListGranuleFilesActor> {
															#line 11223 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<ListGranuleFilesActor>::operator new;
	using FastAllocated<ListGranuleFilesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(649962950691835136UL, 1323993670524279808UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<GranuleFileVersion>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListGranuleFilesActor, 0, RangeResult >;
															#line 952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ListGranuleFilesActor(Transaction* const& tr,UID const& granuleID) 
															#line 11240 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<std::vector<GranuleFileVersion>>(),
		   ListGranuleFilesActorState<ListGranuleFilesActor>(tr, granuleID),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listGranuleFiles", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17833362232833831424UL, 7573664222454312192UL);
		ActorExecutionContextHelper __helper(static_cast<ListGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listGranuleFiles");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listGranuleFiles", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListGranuleFilesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		}

	}
};
															#line 952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<std::vector<GranuleFileVersion>> listGranuleFiles( Transaction* const& tr, UID const& granuleID ) {
															#line 952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<std::vector<GranuleFileVersion>>(new ListGranuleFilesActor(tr, granuleID));
															#line 11272 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 986 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	// Read data from granules and print out summary
																#line 11278 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
// This generated class is to be used only via checkGranuleFiles()
															#line 988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class CheckGranuleFilesActor>
															#line 988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class CheckGranuleFilesActorState {
															#line 11284 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	CheckGranuleFilesActorState(Reference<BlobManifestLoader> const& self,BlobGranuleRestoreVersion const& granule) 
															#line 988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : self(self),
															#line 988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   granule(granule),
															#line 989 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   range(granule.keyRange),
															#line 990 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   readVersion(granule.version),
															#line 991 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   tr(self->db_)
															#line 11299 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("checkGranuleFiles", reinterpret_cast<unsigned long>(this));

	}
	~CheckGranuleFilesActorState() 
	{
		fdb_probe_actor_destroy("checkGranuleFiles", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 992 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			;
															#line 11314 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckGranuleFilesActorState();
		static_cast<CheckGranuleFilesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 993 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 994 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 995 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 11348 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		try {
															#line 997 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Standalone<VectorRef<BlobGranuleChunkRef>>> __when_expr_0 = tr.readBlobGranules(range, 0, readVersion);
															#line 997 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<CheckGranuleFilesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 11354 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckGranuleFilesActor*>(this)->actor_wait_state = 1;
															#line 997 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleFilesActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >*>(static_cast<CheckGranuleFilesActor*>(this)));
															#line 11359 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1011 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 1011 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<CheckGranuleFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11383 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CheckGranuleFilesActor*>(this)->actor_wait_state = 3;
															#line 1011 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleFilesActor, 2, Void >*>(static_cast<CheckGranuleFilesActor*>(this)));
															#line 11388 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 999 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		count = 0;
															#line 1000 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		RangeForbody1loopBody1cont2Iterator0 = std::begin(chunks);
															#line 11405 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<BlobGranuleChunkRef>> const& __chunks,int loopDepth) 
	{
															#line 997 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		chunks = __chunks;
															#line 11414 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Standalone<VectorRef<BlobGranuleChunkRef>> && __chunks,int loopDepth) 
	{
		chunks = std::move(__chunks);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckGranuleFilesActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleFilesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleFilesActor*>(this)->ActorCallback< CheckGranuleFilesActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleFilesActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Standalone<VectorRef<BlobGranuleChunkRef>> const& value) 
	{
		fdb_probe_actor_enter("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckGranuleFilesActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Standalone<VectorRef<BlobGranuleChunkRef>> && value) 
	{
		fdb_probe_actor_enter("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckGranuleFilesActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 1005 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("Restorable blob granule {} @ {}\n", granule.granuleID.toString(), readVersion);
															#line 1006 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("  Range: {}\n", range.toString());
															#line 1007 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("  Keys : {}\n", count);
															#line 1008 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		dprint("  Size : {} bytes\n", granule.sizeInBytes);
															#line 1009 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<CheckGranuleFilesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckGranuleFilesActorState(); static_cast<CheckGranuleFilesActor*>(this)->destroy(); return 0; }
															#line 11501 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<CheckGranuleFilesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckGranuleFilesActorState();
		static_cast<CheckGranuleFilesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 1000 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!(RangeForbody1loopBody1cont2Iterator0 != std::end(chunks)))
															#line 11520 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
			return a_body1loopBody1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1000 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		const BlobGranuleChunkRef& chunk = *RangeForbody1loopBody1cont2Iterator0;
															#line 11526 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 1001 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<RangeResult> __when_expr_1 = readBlobGranule(chunk, range, 0, readVersion, self->blobConn_);
															#line 1001 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<CheckGranuleFilesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 11532 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckGranuleFilesActor*>(this)->actor_wait_state = 2;
															#line 1001 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckGranuleFilesActor, 1, RangeResult >*>(static_cast<CheckGranuleFilesActor*>(this)));
															#line 11537 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(int loopDepth) 
	{
															#line 1000 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		++RangeForbody1loopBody1cont2Iterator0;
															#line 11560 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(RangeResult const& rows,int loopDepth) 
	{
															#line 1002 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		count += rows.size();
															#line 11569 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont3(RangeResult && rows,int loopDepth) 
	{
															#line 1002 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		count += rows.size();
															#line 11578 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(RangeResult const& rows,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(rows, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(RangeResult && rows,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont3(std::move(rows), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckGranuleFilesActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleFilesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleFilesActor*>(this)->ActorCallback< CheckGranuleFilesActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleFilesActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckGranuleFilesActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckGranuleFilesActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckGranuleFilesActor*>(this)->actor_wait_state > 0) static_cast<CheckGranuleFilesActor*>(this)->actor_wait_state = 0;
		static_cast<CheckGranuleFilesActor*>(this)->ActorCallback< CheckGranuleFilesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckGranuleFilesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckGranuleFilesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckGranuleFilesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkGranuleFiles", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobManifestLoader> self;
															#line 988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	BlobGranuleRestoreVersion granule;
															#line 989 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	KeyRangeRef range;
															#line 990 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Version readVersion;
															#line 991 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Transaction tr;
															#line 997 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Standalone<VectorRef<BlobGranuleChunkRef>> chunks;
															#line 999 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int count;
															#line 1000 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	decltype(std::begin(std::declval<Standalone<VectorRef<BlobGranuleChunkRef>>>())) RangeForbody1loopBody1cont2Iterator0;
															#line 11761 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via checkGranuleFiles()
															#line 988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class CheckGranuleFilesActor final : public Actor<Void>, public ActorCallback< CheckGranuleFilesActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >, public ActorCallback< CheckGranuleFilesActor, 1, RangeResult >, public ActorCallback< CheckGranuleFilesActor, 2, Void >, public FastAllocated<CheckGranuleFilesActor>, public CheckGranuleFilesActorState<CheckGranuleFilesActor> {
															#line 11766 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<CheckGranuleFilesActor>::operator new;
	using FastAllocated<CheckGranuleFilesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15740668851473441024UL, 928159588289932544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckGranuleFilesActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >;
friend struct ActorCallback< CheckGranuleFilesActor, 1, RangeResult >;
friend struct ActorCallback< CheckGranuleFilesActor, 2, Void >;
															#line 988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	CheckGranuleFilesActor(Reference<BlobManifestLoader> const& self,BlobGranuleRestoreVersion const& granule) 
															#line 11785 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   CheckGranuleFilesActorState<CheckGranuleFilesActor>(self, granule),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkGranuleFiles", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(21471833030469120UL, 18103778488504487936UL);
		ActorExecutionContextHelper __helper(static_cast<CheckGranuleFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkGranuleFiles");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkGranuleFiles", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckGranuleFilesActor, 0, Standalone<VectorRef<BlobGranuleChunkRef>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckGranuleFilesActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckGranuleFilesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] static Future<Void> checkGranuleFiles( Reference<BlobManifestLoader> const& self, BlobGranuleRestoreVersion const& granule ) {
															#line 988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new CheckGranuleFilesActor(self, granule));
															#line 11819 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 1015 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

	Database db_;
	Reference<BlobConnectionProvider> blobConn_;
	RangeResult delayedRows_; // special rows that we would write at the end of restore
	Reference<AsyncVar<ServerDBInfo> const> dbInfo_;
	Optional<BlobGranuleCipherKeysCtx> cipherKeysCtx_;
};

// API to dump a manifest copy to external storage
															#line 11832 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
namespace {
// This generated class is to be used only via dumpManifest()
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class DumpManifestActor>
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class DumpManifestActorState {
															#line 11839 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	DumpManifestActorState(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<BlobConnectionProvider> const& blobConn,int64_t const& epoch,int64_t const& seqNo,bool const& encryptionEnabled) 
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : db(db),
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   dbInfo(dbInfo),
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   blobConn(blobConn),
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   epoch(epoch),
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   seqNo(seqNo),
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   encryptionEnabled(encryptionEnabled)
															#line 11856 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("dumpManifest", reinterpret_cast<unsigned long>(this));

	}
	~DumpManifestActorState() 
	{
		fdb_probe_actor_destroy("dumpManifest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1030 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			Reference<BlobManifestDumper> dumper = makeReference<BlobManifestDumper>(db, dbInfo, blobConn, epoch, seqNo, encryptionEnabled);
															#line 1032 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = BlobManifestDumper::execute(dumper);
															#line 1032 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<DumpManifestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 11875 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DumpManifestActor*>(this)->actor_wait_state = 1;
															#line 1032 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DumpManifestActor, 0, int64_t >*>(static_cast<DumpManifestActor*>(this)));
															#line 11880 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DumpManifestActorState();
		static_cast<DumpManifestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int64_t const& bytes,int loopDepth) 
	{
															#line 1033 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<DumpManifestActor*>(this)->SAV<int64_t>::futures) { (void)(bytes); this->~DumpManifestActorState(); static_cast<DumpManifestActor*>(this)->destroy(); return 0; }
															#line 11903 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<DumpManifestActor*>(this)->SAV< int64_t >::value()) int64_t(bytes);
		this->~DumpManifestActorState();
		static_cast<DumpManifestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int64_t && bytes,int loopDepth) 
	{
															#line 1033 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<DumpManifestActor*>(this)->SAV<int64_t>::futures) { (void)(bytes); this->~DumpManifestActorState(); static_cast<DumpManifestActor*>(this)->destroy(); return 0; }
															#line 11915 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<DumpManifestActor*>(this)->SAV< int64_t >::value()) int64_t(bytes);
		this->~DumpManifestActorState();
		static_cast<DumpManifestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int64_t const& bytes,int loopDepth) 
	{
		loopDepth = a_body1cont1(bytes, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && bytes,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(bytes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DumpManifestActor*>(this)->actor_wait_state > 0) static_cast<DumpManifestActor*>(this)->actor_wait_state = 0;
		static_cast<DumpManifestActor*>(this)->ActorCallback< DumpManifestActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< DumpManifestActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("dumpManifest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpManifestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpManifest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DumpManifestActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("dumpManifest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DumpManifestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpManifest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DumpManifestActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("dumpManifest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpManifestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dumpManifest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Database db;
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobConnectionProvider> blobConn;
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int64_t epoch;
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	int64_t seqNo;
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	bool encryptionEnabled;
															#line 12010 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via dumpManifest()
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class DumpManifestActor final : public Actor<int64_t>, public ActorCallback< DumpManifestActor, 0, int64_t >, public FastAllocated<DumpManifestActor>, public DumpManifestActorState<DumpManifestActor> {
															#line 12015 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<DumpManifestActor>::operator new;
	using FastAllocated<DumpManifestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12281150792548698112UL, 16548121123442420992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DumpManifestActor, 0, int64_t >;
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	DumpManifestActor(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<BlobConnectionProvider> const& blobConn,int64_t const& epoch,int64_t const& seqNo,bool const& encryptionEnabled) 
															#line 12032 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<int64_t>(),
		   DumpManifestActorState<DumpManifestActor>(db, dbInfo, blobConn, epoch, seqNo, encryptionEnabled),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dumpManifest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6272330158356439296UL, 13559082950820313088UL);
		ActorExecutionContextHelper __helper(static_cast<DumpManifestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dumpManifest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dumpManifest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DumpManifestActor, 0, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] Future<int64_t> dumpManifest( Database const& db, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Reference<BlobConnectionProvider> const& blobConn, int64_t const& epoch, int64_t const& seqNo, bool const& encryptionEnabled ) {
															#line 1024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<int64_t>(new DumpManifestActor(db, dbInfo, blobConn, epoch, seqNo, encryptionEnabled));
															#line 12065 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 1035 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

// API to load manifest from external blob storage
															#line 12071 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
namespace {
// This generated class is to be used only via loadManifest()
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class LoadManifestActor>
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class LoadManifestActorState {
															#line 12078 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	LoadManifestActorState(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<BlobConnectionProvider> const& blobConn) 
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : db(db),
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   dbInfo(dbInfo),
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   blobConn(blobConn)
															#line 12089 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("loadManifest", reinterpret_cast<unsigned long>(this));

	}
	~LoadManifestActorState() 
	{
		fdb_probe_actor_destroy("loadManifest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1040 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			Reference<BlobManifestLoader> loader = makeReference<BlobManifestLoader>(db, dbInfo, blobConn);
															#line 1041 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = BlobManifestLoader::execute(loader);
															#line 1041 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<LoadManifestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12108 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadManifestActor*>(this)->actor_wait_state = 1;
															#line 1041 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadManifestActor, 0, Void >*>(static_cast<LoadManifestActor*>(this)));
															#line 12113 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadManifestActorState();
		static_cast<LoadManifestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1042 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<LoadManifestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadManifestActorState(); static_cast<LoadManifestActor*>(this)->destroy(); return 0; }
															#line 12136 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<LoadManifestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadManifestActorState();
		static_cast<LoadManifestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1042 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<LoadManifestActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadManifestActorState(); static_cast<LoadManifestActor*>(this)->destroy(); return 0; }
															#line 12148 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<LoadManifestActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadManifestActorState();
		static_cast<LoadManifestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadManifestActor*>(this)->actor_wait_state > 0) static_cast<LoadManifestActor*>(this)->actor_wait_state = 0;
		static_cast<LoadManifestActor*>(this)->ActorCallback< LoadManifestActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadManifestActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadManifest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadManifestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadManifest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadManifestActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadManifest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadManifestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadManifest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadManifestActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadManifest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadManifestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadManifest", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Database db;
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobConnectionProvider> blobConn;
															#line 12237 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via loadManifest()
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class LoadManifestActor final : public Actor<Void>, public ActorCallback< LoadManifestActor, 0, Void >, public FastAllocated<LoadManifestActor>, public LoadManifestActorState<LoadManifestActor> {
															#line 12242 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<LoadManifestActor>::operator new;
	using FastAllocated<LoadManifestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12144979825841484032UL, 14795785095795130624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadManifestActor, 0, Void >;
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	LoadManifestActor(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<BlobConnectionProvider> const& blobConn) 
															#line 12259 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   LoadManifestActorState<LoadManifestActor>(db, dbInfo, blobConn),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadManifest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8639824778544196352UL, 3221912948796100864UL);
		ActorExecutionContextHelper __helper(static_cast<LoadManifestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadManifest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadManifest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadManifestActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] Future<Void> loadManifest( Database const& db, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Reference<BlobConnectionProvider> const& blobConn ) {
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new LoadManifestActor(db, dbInfo, blobConn));
															#line 12292 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 1044 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

// API to print summary for restorable granules
															#line 12298 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
namespace {
// This generated class is to be used only via printRestoreSummary()
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class PrintRestoreSummaryActor>
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class PrintRestoreSummaryActorState {
															#line 12305 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	PrintRestoreSummaryActorState(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<BlobConnectionProvider> const& blobConn) 
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : db(db),
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   dbInfo(dbInfo),
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   blobConn(blobConn)
															#line 12316 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("printRestoreSummary", reinterpret_cast<unsigned long>(this));

	}
	~PrintRestoreSummaryActorState() 
	{
		fdb_probe_actor_destroy("printRestoreSummary", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1049 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			Reference<BlobManifestLoader> loader = makeReference<BlobManifestLoader>(db, dbInfo, blobConn);
															#line 1050 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_0 = BlobManifestLoader::print(loader);
															#line 1050 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<PrintRestoreSummaryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12335 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PrintRestoreSummaryActor*>(this)->actor_wait_state = 1;
															#line 1050 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PrintRestoreSummaryActor, 0, Void >*>(static_cast<PrintRestoreSummaryActor*>(this)));
															#line 12340 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PrintRestoreSummaryActorState();
		static_cast<PrintRestoreSummaryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1051 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<PrintRestoreSummaryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintRestoreSummaryActorState(); static_cast<PrintRestoreSummaryActor*>(this)->destroy(); return 0; }
															#line 12363 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<PrintRestoreSummaryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintRestoreSummaryActorState();
		static_cast<PrintRestoreSummaryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1051 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<PrintRestoreSummaryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PrintRestoreSummaryActorState(); static_cast<PrintRestoreSummaryActor*>(this)->destroy(); return 0; }
															#line 12375 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<PrintRestoreSummaryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PrintRestoreSummaryActorState();
		static_cast<PrintRestoreSummaryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PrintRestoreSummaryActor*>(this)->actor_wait_state > 0) static_cast<PrintRestoreSummaryActor*>(this)->actor_wait_state = 0;
		static_cast<PrintRestoreSummaryActor*>(this)->ActorCallback< PrintRestoreSummaryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PrintRestoreSummaryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("printRestoreSummary", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRestoreSummaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRestoreSummary", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PrintRestoreSummaryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("printRestoreSummary", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRestoreSummaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRestoreSummary", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PrintRestoreSummaryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("printRestoreSummary", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRestoreSummaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("printRestoreSummary", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Database db;
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobConnectionProvider> blobConn;
															#line 12464 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via printRestoreSummary()
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class PrintRestoreSummaryActor final : public Actor<Void>, public ActorCallback< PrintRestoreSummaryActor, 0, Void >, public FastAllocated<PrintRestoreSummaryActor>, public PrintRestoreSummaryActorState<PrintRestoreSummaryActor> {
															#line 12469 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<PrintRestoreSummaryActor>::operator new;
	using FastAllocated<PrintRestoreSummaryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14398493482504424704UL, 6088859681145998848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PrintRestoreSummaryActor, 0, Void >;
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	PrintRestoreSummaryActor(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<BlobConnectionProvider> const& blobConn) 
															#line 12486 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Void>(),
		   PrintRestoreSummaryActorState<PrintRestoreSummaryActor>(db, dbInfo, blobConn),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("printRestoreSummary", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12057342525675650560UL, 11099040850403498496UL);
		ActorExecutionContextHelper __helper(static_cast<PrintRestoreSummaryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("printRestoreSummary");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("printRestoreSummary", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PrintRestoreSummaryActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] Future<Void> printRestoreSummary( Database const& db, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Reference<BlobConnectionProvider> const& blobConn ) {
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Void>(new PrintRestoreSummaryActor(db, dbInfo, blobConn));
															#line 12519 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 1053 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

// API to list blob granules
															#line 12525 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
namespace {
// This generated class is to be used only via listBlobGranules()
															#line 1055 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class ListBlobGranulesActor>
															#line 1055 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ListBlobGranulesActorState {
															#line 12532 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 1055 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ListBlobGranulesActorState(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<BlobConnectionProvider> const& blobConn) 
															#line 1055 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 1055 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : db(db),
															#line 1055 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   dbInfo(dbInfo),
															#line 1055 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   blobConn(blobConn)
															#line 12543 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("listBlobGranules", reinterpret_cast<unsigned long>(this));

	}
	~ListBlobGranulesActorState() 
	{
		fdb_probe_actor_destroy("listBlobGranules", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1058 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			Reference<BlobManifestLoader> loader = makeReference<BlobManifestLoader>(db, dbInfo, blobConn);
															#line 1059 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<BlobGranuleRestoreVersionVector> __when_expr_0 = BlobManifestLoader::listGranules(loader);
															#line 1059 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<ListBlobGranulesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12562 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListBlobGranulesActor*>(this)->actor_wait_state = 1;
															#line 1059 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListBlobGranulesActor, 0, BlobGranuleRestoreVersionVector >*>(static_cast<ListBlobGranulesActor*>(this)));
															#line 12567 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListBlobGranulesActorState();
		static_cast<ListBlobGranulesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(BlobGranuleRestoreVersionVector const& result,int loopDepth) 
	{
															#line 1060 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ListBlobGranulesActor*>(this)->SAV<BlobGranuleRestoreVersionVector>::futures) { (void)(result); this->~ListBlobGranulesActorState(); static_cast<ListBlobGranulesActor*>(this)->destroy(); return 0; }
															#line 12590 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ListBlobGranulesActor*>(this)->SAV< BlobGranuleRestoreVersionVector >::value()) BlobGranuleRestoreVersionVector(result);
		this->~ListBlobGranulesActorState();
		static_cast<ListBlobGranulesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(BlobGranuleRestoreVersionVector && result,int loopDepth) 
	{
															#line 1060 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<ListBlobGranulesActor*>(this)->SAV<BlobGranuleRestoreVersionVector>::futures) { (void)(result); this->~ListBlobGranulesActorState(); static_cast<ListBlobGranulesActor*>(this)->destroy(); return 0; }
															#line 12602 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<ListBlobGranulesActor*>(this)->SAV< BlobGranuleRestoreVersionVector >::value()) BlobGranuleRestoreVersionVector(result);
		this->~ListBlobGranulesActorState();
		static_cast<ListBlobGranulesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(BlobGranuleRestoreVersionVector const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(BlobGranuleRestoreVersionVector && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListBlobGranulesActor*>(this)->actor_wait_state > 0) static_cast<ListBlobGranulesActor*>(this)->actor_wait_state = 0;
		static_cast<ListBlobGranulesActor*>(this)->ActorCallback< ListBlobGranulesActor, 0, BlobGranuleRestoreVersionVector >::remove();

	}
	void a_callback_fire(ActorCallback< ListBlobGranulesActor, 0, BlobGranuleRestoreVersionVector >*,BlobGranuleRestoreVersionVector const& value) 
	{
		fdb_probe_actor_enter("listBlobGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListBlobGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listBlobGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListBlobGranulesActor, 0, BlobGranuleRestoreVersionVector >*,BlobGranuleRestoreVersionVector && value) 
	{
		fdb_probe_actor_enter("listBlobGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListBlobGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listBlobGranules", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListBlobGranulesActor, 0, BlobGranuleRestoreVersionVector >*,Error err) 
	{
		fdb_probe_actor_enter("listBlobGranules", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListBlobGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listBlobGranules", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1055 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Database db;
															#line 1055 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1055 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobConnectionProvider> blobConn;
															#line 12691 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via listBlobGranules()
															#line 1055 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class ListBlobGranulesActor final : public Actor<BlobGranuleRestoreVersionVector>, public ActorCallback< ListBlobGranulesActor, 0, BlobGranuleRestoreVersionVector >, public FastAllocated<ListBlobGranulesActor>, public ListBlobGranulesActorState<ListBlobGranulesActor> {
															#line 12696 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<ListBlobGranulesActor>::operator new;
	using FastAllocated<ListBlobGranulesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16440232709941338624UL, 4718647026040980992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<BlobGranuleRestoreVersionVector>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListBlobGranulesActor, 0, BlobGranuleRestoreVersionVector >;
															#line 1055 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	ListBlobGranulesActor(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<BlobConnectionProvider> const& blobConn) 
															#line 12713 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<BlobGranuleRestoreVersionVector>(),
		   ListBlobGranulesActorState<ListBlobGranulesActor>(db, dbInfo, blobConn),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listBlobGranules", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14257117557631760128UL, 9770685911664535552UL);
		ActorExecutionContextHelper __helper(static_cast<ListBlobGranulesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listBlobGranules");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listBlobGranules", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListBlobGranulesActor, 0, BlobGranuleRestoreVersionVector >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1055 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] Future<BlobGranuleRestoreVersionVector> listBlobGranules( Database const& db, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Reference<BlobConnectionProvider> const& blobConn ) {
															#line 1055 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<BlobGranuleRestoreVersionVector>(new ListBlobGranulesActor(db, dbInfo, blobConn));
															#line 12746 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 1062 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

// API to get max blob manager epoc from manifest files
															#line 12752 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
namespace {
// This generated class is to be used only via lastBlobEpoc()
															#line 1064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class LastBlobEpocActor1>
															#line 1064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class LastBlobEpocActor1State {
															#line 12759 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 1064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	LastBlobEpocActor1State(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<BlobConnectionProvider> const& blobConn) 
															#line 1064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 1064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : db(db),
															#line 1064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   dbInfo(dbInfo),
															#line 1064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   blobConn(blobConn)
															#line 12770 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("lastBlobEpoc", reinterpret_cast<unsigned long>(this));

	}
	~LastBlobEpocActor1State() 
	{
		fdb_probe_actor_destroy("lastBlobEpoc", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1067 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			Reference<BlobManifestLoader> loader = makeReference<BlobManifestLoader>(db, dbInfo, blobConn);
															#line 1068 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = BlobManifestLoader::lastBlobEpoc(loader);
															#line 1068 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<LastBlobEpocActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 12789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LastBlobEpocActor1*>(this)->actor_wait_state = 1;
															#line 1068 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LastBlobEpocActor1, 0, int64_t >*>(static_cast<LastBlobEpocActor1*>(this)));
															#line 12794 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LastBlobEpocActor1State();
		static_cast<LastBlobEpocActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int64_t const& epoc,int loopDepth) 
	{
															#line 1069 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<LastBlobEpocActor1*>(this)->SAV<int64_t>::futures) { (void)(epoc); this->~LastBlobEpocActor1State(); static_cast<LastBlobEpocActor1*>(this)->destroy(); return 0; }
															#line 12817 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<LastBlobEpocActor1*>(this)->SAV< int64_t >::value()) int64_t(epoc);
		this->~LastBlobEpocActor1State();
		static_cast<LastBlobEpocActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int64_t && epoc,int loopDepth) 
	{
															#line 1069 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (!static_cast<LastBlobEpocActor1*>(this)->SAV<int64_t>::futures) { (void)(epoc); this->~LastBlobEpocActor1State(); static_cast<LastBlobEpocActor1*>(this)->destroy(); return 0; }
															#line 12829 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		new (&static_cast<LastBlobEpocActor1*>(this)->SAV< int64_t >::value()) int64_t(epoc);
		this->~LastBlobEpocActor1State();
		static_cast<LastBlobEpocActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int64_t const& epoc,int loopDepth) 
	{
		loopDepth = a_body1cont1(epoc, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && epoc,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(epoc), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LastBlobEpocActor1*>(this)->actor_wait_state > 0) static_cast<LastBlobEpocActor1*>(this)->actor_wait_state = 0;
		static_cast<LastBlobEpocActor1*>(this)->ActorCallback< LastBlobEpocActor1, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< LastBlobEpocActor1, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("lastBlobEpoc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LastBlobEpocActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastBlobEpoc", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LastBlobEpocActor1, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("lastBlobEpoc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LastBlobEpocActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastBlobEpoc", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LastBlobEpocActor1, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("lastBlobEpoc", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LastBlobEpocActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("lastBlobEpoc", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Database db;
															#line 1064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<AsyncVar<ServerDBInfo> const> dbInfo;
															#line 1064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Reference<BlobConnectionProvider> blobConn;
															#line 12918 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via lastBlobEpoc()
															#line 1064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class LastBlobEpocActor1 final : public Actor<int64_t>, public ActorCallback< LastBlobEpocActor1, 0, int64_t >, public FastAllocated<LastBlobEpocActor1>, public LastBlobEpocActor1State<LastBlobEpocActor1> {
															#line 12923 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<LastBlobEpocActor1>::operator new;
	using FastAllocated<LastBlobEpocActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10787755995999559424UL, 5194339525538723840UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<int64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LastBlobEpocActor1, 0, int64_t >;
															#line 1064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	LastBlobEpocActor1(Database const& db,Reference<AsyncVar<ServerDBInfo> const> const& dbInfo,Reference<BlobConnectionProvider> const& blobConn) 
															#line 12940 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<int64_t>(),
		   LastBlobEpocActor1State<LastBlobEpocActor1>(db, dbInfo, blobConn),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("lastBlobEpoc", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18407539260726092544UL, 18206463566195214592UL);
		ActorExecutionContextHelper __helper(static_cast<LastBlobEpocActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("lastBlobEpoc");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("lastBlobEpoc", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LastBlobEpocActor1, 0, int64_t >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] Future<int64_t> lastBlobEpoc( Database const& db, Reference<AsyncVar<ServerDBInfo> const> const& dbInfo, Reference<BlobConnectionProvider> const& blobConn ) {
															#line 1064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<int64_t>(new LastBlobEpocActor1(db, dbInfo, blobConn));
															#line 12973 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 1071 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"

// API to get manifest backup version
															#line 12979 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
namespace {
// This generated class is to be used only via getManifestVersion()
															#line 1073 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
template <class GetManifestVersionActor>
															#line 1073 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class GetManifestVersionActorState {
															#line 12986 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
															#line 1073 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	GetManifestVersionActorState(Database const& db) 
															#line 1073 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
															#line 1073 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		 : db(db),
															#line 1074 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		   tr(db)
															#line 12995 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
	{
		fdb_probe_actor_create("getManifestVersion", reinterpret_cast<unsigned long>(this));

	}
	~GetManifestVersionActorState() 
	{
		fdb_probe_actor_destroy("getManifestVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1075 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			;
															#line 13010 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetManifestVersionActorState();
		static_cast<GetManifestVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 1077 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 1078 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1079 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1080 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(blobManifestVersionKey);
															#line 1080 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<GetManifestVersionActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 13049 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetManifestVersionActor*>(this)->actor_wait_state = 1;
															#line 1080 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetManifestVersionActor, 0, Optional<Value> >*>(static_cast<GetManifestVersionActor*>(this)));
															#line 13054 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1090 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 1090 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (static_cast<GetManifestVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 13078 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetManifestVersionActor*>(this)->actor_wait_state = 2;
															#line 1090 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetManifestVersionActor, 1, Void >*>(static_cast<GetManifestVersionActor*>(this)));
															#line 13083 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& value,int loopDepth) 
	{
															#line 1081 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (value.present())
															#line 13098 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 1082 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			Version version;
															#line 1083 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			BinaryReader reader(value.get(), Unversioned());
															#line 1084 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			reader >> version;
															#line 1085 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (!static_cast<GetManifestVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~GetManifestVersionActorState(); static_cast<GetManifestVersionActor*>(this)->destroy(); return 0; }
															#line 13108 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			new (&static_cast<GetManifestVersionActor*>(this)->SAV< Version >::value()) Version(version);
			this->~GetManifestVersionActorState();
			static_cast<GetManifestVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1087 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		TraceEvent("MissingBlobManifestVersion").log();
															#line 1088 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		return a_body1loopBody1Catch1(blob_restore_corrupted_manifest(), loopDepth);
															#line 13118 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && value,int loopDepth) 
	{
															#line 1081 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		if (value.present())
															#line 13126 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		{
															#line 1082 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			Version version;
															#line 1083 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			BinaryReader reader(value.get(), Unversioned());
															#line 1084 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			reader >> version;
															#line 1085 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
			if (!static_cast<GetManifestVersionActor*>(this)->SAV<Version>::futures) { (void)(version); this->~GetManifestVersionActorState(); static_cast<GetManifestVersionActor*>(this)->destroy(); return 0; }
															#line 13136 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
			new (&static_cast<GetManifestVersionActor*>(this)->SAV< Version >::value()) Version(version);
			this->~GetManifestVersionActorState();
			static_cast<GetManifestVersionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1087 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		TraceEvent("MissingBlobManifestVersion").log();
															#line 1088 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
		return a_body1loopBody1Catch1(blob_restore_corrupted_manifest(), loopDepth);
															#line 13146 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(value, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && value,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(value), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetManifestVersionActor*>(this)->actor_wait_state > 0) static_cast<GetManifestVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetManifestVersionActor*>(this)->ActorCallback< GetManifestVersionActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetManifestVersionActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getManifestVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetManifestVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getManifestVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetManifestVersionActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getManifestVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetManifestVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getManifestVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetManifestVersionActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getManifestVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetManifestVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getManifestVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetManifestVersionActor*>(this)->actor_wait_state > 0) static_cast<GetManifestVersionActor*>(this)->actor_wait_state = 0;
		static_cast<GetManifestVersionActor*>(this)->ActorCallback< GetManifestVersionActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetManifestVersionActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getManifestVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetManifestVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getManifestVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetManifestVersionActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getManifestVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetManifestVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getManifestVersion", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetManifestVersionActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getManifestVersion", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetManifestVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getManifestVersion", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1073 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Database db;
															#line 1074 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	Transaction tr;
															#line 13316 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
};
// This generated class is to be used only via getManifestVersion()
															#line 1073 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
class GetManifestVersionActor final : public Actor<Version>, public ActorCallback< GetManifestVersionActor, 0, Optional<Value> >, public ActorCallback< GetManifestVersionActor, 1, Void >, public FastAllocated<GetManifestVersionActor>, public GetManifestVersionActorState<GetManifestVersionActor> {
															#line 13321 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
public:
	using FastAllocated<GetManifestVersionActor>::operator new;
	using FastAllocated<GetManifestVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(302092811598079488UL, 6840959397288844800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetManifestVersionActor, 0, Optional<Value> >;
friend struct ActorCallback< GetManifestVersionActor, 1, Void >;
															#line 1073 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	GetManifestVersionActor(Database const& db) 
															#line 13339 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
		 : Actor<Version>(),
		   GetManifestVersionActorState<GetManifestVersionActor>(db),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getManifestVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16374259362208444416UL, 8448212224592731904UL);
		ActorExecutionContextHelper __helper(static_cast<GetManifestVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getManifestVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getManifestVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetManifestVersionActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetManifestVersionActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1073 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
[[nodiscard]] Future<Version> getManifestVersion( Database const& db ) {
															#line 1073 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
	return Future<Version>(new GetManifestVersionActor(db));
															#line 13373 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbserver/BlobManifest.actor.g.cpp"
}

#line 1094 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbserver/BlobManifest.actor.cpp"
