#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
/*
 * ManagementAPI.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(FDBCLIENT_MANAGEMENT_API_ACTOR_G_H)
#define FDBCLIENT_MANAGEMENT_API_ACTOR_G_H
#include "fdbclient/ManagementAPI.actor.g.h"
#elif !defined(FDBCLIENT_MANAGEMENT_API_ACTOR_H)
#define FDBCLIENT_MANAGEMENT_API_ACTOR_H

/* This file defines "management" interfaces for configuration, coordination changes, and
the inclusion and exclusion of servers. It is used to implement fdbcli management commands
and by test workloads that simulate such. It isn't exposed to C clients or anywhere outside
our code base and doesn't need to be versioned. It doesn't do anything you can't do with the
standard API and some knowledge of the contents of the system key space.
*/

#include <string>
#include <map>
#include "fdbclient/GenericManagementAPI.actor.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/RangeLock.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/MonitorLeader.h"
#include "flow/actorcompiler.h" // has to be last include

															#line 47 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<DatabaseConfiguration> getDatabaseConfiguration( Transaction* const& tr, bool const& useSystemPriority = false );

#line 46 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 51 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<DatabaseConfiguration> getDatabaseConfiguration( Database const& cx, bool const& useSystemPriority = false );

#line 47 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 55 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> waitForFullReplication( Database const& cx );

#line 48 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

struct IQuorumChange : ReferenceCounted<IQuorumChange> {
	virtual ~IQuorumChange() {}
	virtual Future<std::vector<NetworkAddress>> getDesiredCoordinators(Transaction* tr,
	                                                                   std::vector<NetworkAddress> oldCoordinators,
	                                                                   Reference<IClusterConnectionRecord>,
	                                                                   CoordinatorsResult&) = 0;
	virtual std::string getDesiredClusterKeyName() const { return std::string(); }
};

// Change to use the given set of coordination servers
															#line 70 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Optional<CoordinatorsResult>> changeQuorumChecker( Transaction* const& tr, ClusterConnectionString* const& conn, std::string const& newName, bool const& disableConfigDB );

#line 63 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 74 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<CoordinatorsResult> changeQuorum( Database const& cx, Reference<IQuorumChange> const& change );

#line 64 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
Reference<IQuorumChange> autoQuorumChange(int desired = -1);
Reference<IQuorumChange> nameQuorumChange(std::string const& name, Reference<IQuorumChange> const& other);

// Exclude the given set of servers from use as state servers.  Returns as soon as the change is durable, without
// necessarily waiting for the servers to be evacuated.  A NetworkAddress with a port of 0 means all servers on the
// given IP.
															#line 84 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> excludeServers( Database const& cx, std::vector<AddressExclusion> const& servers, bool const& failed = false );

#line 71 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 88 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> excludeServers( Transaction* const& tr, std::vector<AddressExclusion> const& servers, bool const& failed = false );

#line 72 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Exclude the servers matching the given set of localities from use as state servers.  Returns as soon as the change
// is durable, without necessarily waiting for the servers to be evacuated.
															#line 95 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> excludeLocalities( Database const& cx, std::unordered_set<std::string> const& localities, bool const& failed = false );

#line 76 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 99 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> excludeLocalities( Transaction* const& tr, std::unordered_set<std::string> const& localities, bool const& failed = false );

#line 77 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Remove the given servers from the exclusion list.  A NetworkAddress with a port of 0 means all servers on the given
// IP.  A NetworkAddress() means all servers (don't exclude anything)
															#line 106 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> includeServers( Database const& cx, std::vector<AddressExclusion> const& servers, bool const& failed = false );

#line 81 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Remove the given localities from the exclusion list.
															#line 112 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> includeLocalities( Database const& cx, std::vector<std::string> const& localities, bool const& failed = false, bool const& includeAll = false );

#line 87 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Set the process class of processes with the given address.  A NetworkAddress with a port of 0 means all servers on
// the given IP.
															#line 119 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> setClass( Database const& cx, AddressExclusion const& server, ProcessClass const& processClass );

#line 91 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get the current list of excluded servers including both "exclude" and "failed".
															#line 125 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<AddressExclusion>> getAllExcludedServers( Database const& cx );

#line 94 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 129 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<AddressExclusion>> getAllExcludedServers( Transaction* const& tr );

#line 95 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get the current list of excluded servers.
															#line 135 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<AddressExclusion>> getExcludedServerList( Transaction* const& tr );

#line 98 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get the current list of failed servers.
															#line 141 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<AddressExclusion>> getExcludedFailedServerList( Transaction* const& tr );

#line 101 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get the current list of excluded localities
															#line 147 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<std::string>> getAllExcludedLocalities( Database const& cx );

#line 104 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 151 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<std::string>> getAllExcludedLocalities( Transaction* const& tr );

#line 105 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get the current list of excluded localities.
															#line 157 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<std::string>> getExcludedLocalityList( Transaction* const& tr );

#line 108 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get the current list of failed localities.
															#line 163 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<std::string>> getExcludedFailedLocalityList( Transaction* const& tr );

#line 111 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Decodes the locality string to a pair of locality prefix and its value.
// The prefix could be dcid, processid, machineid, processid.
std::pair<std::string, std::string> decodeLocality(const std::string& locality);
std::set<AddressExclusion> getServerAddressesByLocality(
    const std::map<std::string, StorageServerInterface> server_interfaces,
    const std::string& locality);
std::set<AddressExclusion> getAddressesByLocality(const std::vector<ProcessData>& workers, const std::string& locality);

// Check for the given, previously excluded servers to be evacuated (no longer used for state).  If waitForExclusion
// is true, this actor returns once it is safe to shut down all such machines without impacting fault tolerance,
// until and unless any of them are explicitly included with includeServers()
															#line 179 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::set<NetworkAddress>> checkForExcludingServers( Database const& cx, std::vector<AddressExclusion> const& servers, bool const& waitForAllExcluded );

#line 126 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 183 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<bool> checkForExcludingServersTxActor( ReadYourWritesTransaction* const& tr, std::set<AddressExclusion>* const& exclusions, std::set<NetworkAddress>* const& inProgressExclusion );

#line 129 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Gets a list of all workers in the cluster (excluding testers)
															#line 189 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<ProcessData>> getWorkers( Database const& cx );

#line 132 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 193 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<ProcessData>> getWorkers( Transaction* const& tr );

#line 133 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 198 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> timeKeeperSetDisable( Database const& cx );

#line 135 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 203 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> lockDatabase( Transaction* const& tr, UID const& id );

#line 137 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 207 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> lockDatabase( Reference<ReadYourWritesTransaction> const& tr, UID const& id );

#line 138 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 211 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> lockDatabase( Database const& cx, UID const& id );

#line 139 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 216 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> unlockDatabase( Transaction* const& tr, UID const& id );

#line 141 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 220 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> unlockDatabase( Reference<ReadYourWritesTransaction> const& tr, UID const& id );

#line 142 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 224 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> unlockDatabase( Database const& cx, UID const& id );

#line 143 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 229 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> checkDatabaseLock( Transaction* const& tr, UID const& id );

#line 145 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 233 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> checkDatabaseLock( Reference<ReadYourWritesTransaction> const& tr, UID const& id );

#line 146 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 238 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> updateChangeFeed( Transaction* const& tr, Key const& rangeID, ChangeFeedStatus const& status, KeyRange const& range = KeyRange() );

#line 148 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 242 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> updateChangeFeed( Reference<ReadYourWritesTransaction> const& tr, Key const& rangeID, ChangeFeedStatus const& status, KeyRange const& range = KeyRange() );

#line 152 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 246 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> updateChangeFeed( Database const& cx, Key const& rangeID, ChangeFeedStatus const& status, KeyRange const& range = KeyRange() );

#line 153 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 251 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> advanceVersion( Database const& cx, Version const& v );

#line 155 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 256 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<int> setDDMode( Database const& cx, int const& mode );

#line 157 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 261 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> forceRecovery( Reference<IClusterConnectionRecord> const& clusterFile, Standalone<StringRef> const& dcId );

#line 159 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Start an audit on range of the specific type.
															#line 267 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<UID> auditStorage( Reference<IClusterConnectionRecord> const& clusterFile, KeyRange const& range, AuditType const& type, KeyValueStoreType const& engineType, double const& timeoutSeconds );

#line 166 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
// Cancel an audit given type and id
															#line 272 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<UID> cancelAuditStorage( Reference<IClusterConnectionRecord> const& clusterFile, AuditType const& type, UID const& auditId, double const& timeoutSeconds );

#line 171 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Set bulk load mode
// When the mode is on, DD will periodically check if there is any bulkload task to do by scaning the metadata.
															#line 279 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<int> setBulkLoadMode( Database const& cx, int const& mode );

#line 175 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Create a bulkload task submission transaction without commit
// Used by ManagementAPI and bulkdumpRestore at DD
															#line 286 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> setBulkLoadSubmissionTransaction( Transaction* const& tr, BulkLoadTaskState const& bulkLoadTask );

#line 179 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Create an bulkload task acknowledge transaction without commit
// Used by ManagementAPI and bulkdumpRestore at DD
															#line 293 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> setBulkLoadFinalizeTransaction( Transaction* const& tr, KeyRange const& range, UID const& taskId );

#line 183 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get bulk load task for the input range and taskId
															#line 299 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<BulkLoadTaskState> getBulkLoadTask( Transaction* const& tr, KeyRange const& range, UID const& taskId, std::vector<BulkLoadPhase> const& phases );

#line 189 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Add bulkLoad job to history map
															#line 305 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> addBulkLoadJobToHistory( Transaction* const& tr, BulkLoadJobState const& jobState );

#line 192 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get all past bulkLoad jobs from history map
															#line 311 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<BulkLoadJobState>> getBulkLoadJobFromHistory( Database const& cx );

#line 195 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Erase all bulkLoad job history metadata if jobId is not provided. Otherwise, erase the job with the given jobId.
															#line 317 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> clearBulkLoadJobHistory( Database const& cx, Optional<UID> const& jobId = Optional<UID>() );

#line 198 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get the current running bulk load job
															#line 323 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Optional<BulkLoadJobState>> getRunningBulkLoadJob( Database const& cx );

#line 201 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Cancel bulkLoad job for the given jobId
															#line 329 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> cancelBulkLoadJob( Database const& cx, UID const& jobId );

#line 204 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Acknowledge all bulk load tasks that are in the Error phase.
// After acknowledge, the write traffic to the task's range is turned on and the task's metadata is cleared by the bulk
// load engine.
															#line 337 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> acknowledgeAllErrorBulkLoadTasks( Database const& cx, UID const& jobId, KeyRange const& jobRange );

#line 209 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Submit a BulkLoad job: loading data from a remote folder using bulkloading mechanism.
// There is at most one BulkLoad or one BulkDump job at a time.
// If there is any existing BulkLoad or BulkDump job, reject the new job.
															#line 345 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> submitBulkLoadJob( Database const& cx, BulkLoadJobState const& jobState );

#line 214 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Set bulk dump mode. When the mode is on, DD will periodically check if there is any bulkdump task to do by scaning
// the metadata.
															#line 352 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<int> setBulkDumpMode( Database const& cx, int const& mode );

#line 218 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get bulk dump mode value.
															#line 358 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<int> getBulkDumpMode( Database const& cx );

#line 221 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// TODO(BulkDump): Cancel or clear the BulkDump job
															#line 364 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> cancelBulkDumpJob( Database const& cx, UID const& jobId );

#line 224 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Submit a bulkdump job: dumping data to a remote folder by storage servers.
// There is at most one BulkLoad or one BulkDump job at a time.
// If there is any existing BulkLoad or BulkDump job, reject the new job.
															#line 372 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> submitBulkDumpJob( Database const& cx, BulkDumpState const& bulkDumpJob );

#line 229 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Return the existing job metadata
															#line 378 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Optional<BulkDumpState>> getSubmittedBulkDumpJob( Transaction* const& tr );

#line 232 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get total number of completed tasks within the input range
															#line 384 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<size_t> getBulkDumpCompleteTaskCount( Database const& cx, KeyRange const& rangeToRead );

#line 235 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Persist a rangeLock owner to database metadata
// A range can only be locked by a registered owner
															#line 391 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> registerRangeLockOwner( Database const& cx, RangeLockOwnerName const& ownerUniqueID, std::string const& description );

#line 239 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Remove an owner form the database metadata
															#line 397 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> removeRangeLockOwner( Database const& cx, RangeLockOwnerName const& ownerUniqueID );

#line 242 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get all registered rangeLock owner
															#line 403 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<RangeLockOwner>> getAllRangeLockOwners( Database const& cx );

#line 245 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get a rangeLock owner by ownerUniqueID
															#line 409 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Optional<RangeLockOwner>> getRangeLockOwner( Database const& cx, RangeLockOwnerName const& ownerUniqueID );

#line 248 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Block write traffic to a user range (the input range must be within normalKeys).
// One transaction can call releaseExclusiveReadLockOnRange at most for one time.
															#line 416 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> takeExclusiveReadLockOnRange( Transaction* const& tr, KeyRange const& range, RangeLockOwnerName const& ownerUniqueID );

#line 252 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 421 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> takeExclusiveReadLockOnRange( Database const& cx, KeyRange const& range, RangeLockOwnerName const& ownerUniqueID );

#line 254 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Unblock a user range (the input range must be within normalKeys).
// One transaction can call releaseExclusiveReadLockOnRange at most for one time.
															#line 428 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> releaseExclusiveReadLockOnRange( Transaction* const& tr, KeyRange const& range, RangeLockOwnerName const& ownerUniqueID );

#line 258 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 433 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> releaseExclusiveReadLockOnRange( Database const& cx, KeyRange const& range, RangeLockOwnerName const& ownerUniqueID );

#line 260 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Get locked ranges within the input range (the input range must be within normalKeys)
															#line 439 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<std::vector<std::pair<KeyRange, RangeLockState>>> findExclusiveReadLockOnRange( Database const& cx, KeyRange const& range, Optional<RangeLockOwnerName> const& ownerName = Optional<RangeLockOwnerName>() );

#line 266 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Clear all exclusive read lock by the input user. Not transactional.
															#line 445 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> releaseExclusiveReadLockByUser( Database const& cx, RangeLockOwnerName const& ownerUniqueID );

#line 269 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 450 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> printHealthyZone( Database const& cx );

#line 271 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 454 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<bool> clearHealthyZone( Database const& cx, bool const& printWarning = false, bool const& clearSSFailureZoneString = false );

#line 272 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 458 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<bool> setHealthyZone( Database const& cx, StringRef const& zoneId, double const& seconds, bool const& printWarning = false );

#line 273 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 463 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> waitForPrimaryDC( Database const& cx, StringRef const& dcId );

#line 275 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

// Gets the cluster connection string
															#line 469 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Optional<ClusterConnectionString>> getConnectionString( Database const& cx );

#line 278 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

void schemaCoverage(std::string const& spath, bool covered = true);
bool schemaMatch(json_spirit::mValue const& schema,
                 json_spirit::mValue const& result,
                 std::string& errorStr,
                 Severity sev = SevError,
                 bool checkCoverage = false,
                 std::string path = std::string(),
                 std::string schema_path = std::string());

// execute payload in 'snapCmd' on all the coordinators, TLogs and
// storage nodes
															#line 485 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> mgmtSnapCreate( Database const& cx, Standalone<StringRef> const& snapCmd, UID const& snapUID );

#line 291 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

															#line 490 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> disableBackupWorker( Database const& cx );

#line 293 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"
															#line 494 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/include/fdbclient/ManagementAPI.actor.g.h"
[[nodiscard]] Future<Void> enableBackupWorker( Database const& cx );

#line 294 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/include/fdbclient/ManagementAPI.actor.h"

#include "flow/unactorcompiler.h"
#endif
