#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
/*
 * S3Client.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <string>
#include <vector>
#include <unordered_set>
#include <algorithm>
#include <sstream>
#include <iomanip>

#ifdef _WIN32
#include <io.h>
#endif

#include "fdbclient/S3Client.actor.h"
#include "flow/IAsyncFile.h"
#include "flow/Trace.h"
#include "flow/Traceable.h"
#include "flow/flow.h"
#include "flow/xxhash.h"
#include "flow/Error.h"
#include "rapidxml/rapidxml.hpp"
#include <openssl/sha.h>
#include "libb64/encode.h"

#include "flow/actorcompiler.h" // has to be last include

// Configuration constants
#define S3_CHECKSUM_TAG_NAME "xxhash64"
#define S3_CHECKSUM_FILE_SUFFIX ".checksum"

typedef XXH64_state_t XXHashState;

using ::format; // Use FoundationDB's format, not std::format

// State for a part of a multipart upload.
struct PartState {
	int partNumber = 0;
	std::string etag;
	int64_t offset = 0;
	int64_t size = 0;
	std::string checksum; // MD5 or SHA256 depending on integrity check setting
	bool completed = false;

	PartState() = default; // Add explicit default constructor

	PartState(int pNum, int64_t off, int64_t sz, std::string checksum = "")
	  : partNumber(pNum), offset(off), size(sz), checksum(checksum) {}
};

// Config for S3 operations with configurable parameters
struct PartConfig {
	// Basic part configuration
	int64_t partSizeBytes = CLIENT_KNOBS->BLOBSTORE_MULTIPART_MIN_PART_SIZE;
	int baseRetryDelayMs = CLIENT_KNOBS->BLOBSTORE_MULTIPART_RETRY_DELAY_MS;

	// Retry configuration - now configurable instead of magic numbers
	// TODO: Add these to CLIENT_KNOBS for runtime configuration
	int maxPartRetries = 3; // Default: 3 retries per part
	int maxFileRetries = 3; // Default: 3 retries per file
	int maxRetryDelayMs = 30000; // Default: 30 second cap on retry delay

	// Checksum configuration
	// TODO: Add these to CLIENT_KNOBS for runtime configuration
	bool enableChecksumValidation = true; // Default: enable checksum validation
};

// Calculate hash of a file.
// Uses xxhash library because it's fast (supposedly) and used elsewhere in fdb.
// If size is -1, the function will determine the file size automatically.
// Returns a hex string representation of the xxhash64 checksum.
															#line 91 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via calculateFileChecksum()
															#line 89 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CalculateFileChecksumActor>
															#line 89 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CalculateFileChecksumActorState {
															#line 98 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 89 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CalculateFileChecksumActorState(Reference<IAsyncFile> const& file,int64_t const& size) 
															#line 89 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 89 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : file(file),
															#line 89 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   size(size),
															#line 90 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   pos(0),
															#line 91 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   hashState(XXH64_createState()),
															#line 92 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   buffer(65536),
															#line 93 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   readSize()
															#line 115 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("calculateFileChecksum", reinterpret_cast<unsigned long>(this));

	}
	~CalculateFileChecksumActorState() 
	{
		fdb_probe_actor_destroy("calculateFileChecksum", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 95 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_reset(hashState, 0);
															#line 130 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			try {
															#line 98 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (size == -1)
															#line 134 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 99 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					StrictFuture<int64_t> __when_expr_0 = file->size();
															#line 99 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 140 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 1;
															#line 99 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CalculateFileChecksumActor, 0, int64_t >*>(static_cast<CalculateFileChecksumActor*>(this)));
															#line 145 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CalculateFileChecksumActorState();
		static_cast<CalculateFileChecksumActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 122 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_freeState(hashState);
															#line 123 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 182 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 103 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 196 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int64_t const& s,int loopDepth) 
	{
															#line 100 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		size = s;
															#line 205 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int64_t && s,int loopDepth) 
	{
															#line 100 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		size = s;
															#line 214 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t const& s,int loopDepth) 
	{
		loopDepth = a_body1cont3(s, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && s,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state > 0) static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 0;
		static_cast<CalculateFileChecksumActor*>(this)->ActorCallback< CalculateFileChecksumActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CalculateFileChecksumActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 118 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uint64_t hash = XXH64_digest(hashState);
															#line 119 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_freeState(hashState);
															#line 120 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CalculateFileChecksumActor*>(this)->SAV<std::string>::futures) { (void)(format("%016llx", hash)); this->~CalculateFileChecksumActorState(); static_cast<CalculateFileChecksumActor*>(this)->destroy(); return 0; }
															#line 302 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CalculateFileChecksumActor*>(this)->SAV< std::string >::value()) std::string(format("%016llx", hash));
		this->~CalculateFileChecksumActorState();
		static_cast<CalculateFileChecksumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 103 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(pos < size))
															#line 321 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 104 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		readSize = std::min<int64_t>(buffer.size(), size - pos);
															#line 105 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<int> __when_expr_1 = file->read(buffer.data(), readSize, pos);
															#line 105 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 331 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 2;
															#line 105 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CalculateFileChecksumActor, 1, int >*>(static_cast<CalculateFileChecksumActor*>(this)));
															#line 336 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int const& bytesRead,int loopDepth) 
	{
															#line 106 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != readSize)
															#line 358 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 107 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_freeState(hashState);
															#line 108 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientCalculateChecksumReadError") .detail("Expected", readSize) .detail("Actual", bytesRead) .detail("Position", pos);
															#line 112 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(io_error(), std::max(0, loopDepth - 1));
															#line 366 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 114 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_update(hashState, buffer.data(), bytesRead);
															#line 115 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		pos += bytesRead;
															#line 372 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int && bytesRead,int loopDepth) 
	{
															#line 106 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != readSize)
															#line 381 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 107 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_freeState(hashState);
															#line 108 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientCalculateChecksumReadError") .detail("Expected", readSize) .detail("Actual", bytesRead) .detail("Position", pos);
															#line 112 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(io_error(), std::max(0, loopDepth - 1));
															#line 389 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 114 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_update(hashState, buffer.data(), bytesRead);
															#line 115 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		pos += bytesRead;
															#line 395 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state > 0) static_cast<CalculateFileChecksumActor*>(this)->actor_wait_state = 0;
		static_cast<CalculateFileChecksumActor*>(this)->ActorCallback< CalculateFileChecksumActor, 1, int >::remove();

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 1, int >*,int const& value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CalculateFileChecksumActor, 1, int >*,int && value) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CalculateFileChecksumActor, 1, int >*,Error err) 
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 89 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 89 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t size;
															#line 90 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t pos;
															#line 91 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	XXH64_state_t* hashState;
															#line 92 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<uint8_t> buffer;
															#line 93 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int readSize;
															#line 487 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via calculateFileChecksum()
															#line 89 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CalculateFileChecksumActor final : public Actor<std::string>, public ActorCallback< CalculateFileChecksumActor, 0, int64_t >, public ActorCallback< CalculateFileChecksumActor, 1, int >, public FastAllocated<CalculateFileChecksumActor>, public CalculateFileChecksumActorState<CalculateFileChecksumActor> {
															#line 492 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CalculateFileChecksumActor>::operator new;
	using FastAllocated<CalculateFileChecksumActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7979641284042931200UL, 1694495374786493184UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::string>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CalculateFileChecksumActor, 0, int64_t >;
friend struct ActorCallback< CalculateFileChecksumActor, 1, int >;
															#line 89 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CalculateFileChecksumActor(Reference<IAsyncFile> const& file,int64_t const& size) 
															#line 510 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<std::string>(),
		   CalculateFileChecksumActorState<CalculateFileChecksumActor>(file, size),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("calculateFileChecksum", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12128180428655768320UL, 2149007350426683136UL);
		ActorExecutionContextHelper __helper(static_cast<CalculateFileChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("calculateFileChecksum");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("calculateFileChecksum", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CalculateFileChecksumActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CalculateFileChecksumActor, 1, int >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 89 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<std::string> calculateFileChecksum( Reference<IAsyncFile> const& file, int64_t const& size ) {
															#line 89 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<std::string>(new CalculateFileChecksumActor(file, size));
															#line 544 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 126 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

// Get the endpoint for the given s3url.
// Populates parameters and resource with parse of s3url.
Reference<S3BlobStoreEndpoint> getEndpoint(const std::string& s3url,
                                           std::string& resource,
                                           S3BlobStoreEndpoint::ParametersT& parameters) {
	try {
		std::string error;
		Optional<std::string> proxy;
		auto res = g_network->global(INetwork::enProxy);
		if (res) {
			proxy = *static_cast<Optional<std::string>*>(res);
		}
		Reference<S3BlobStoreEndpoint> endpoint =
		    S3BlobStoreEndpoint::fromString(s3url, proxy, &resource, &error, &parameters);

		if (!endpoint) {
			TraceEvent(SevError, "S3ClientGetEndpointNullEndpoint").detail("URL", s3url).detail("Error", error);
			throw backup_invalid_url();
		}

		// Let empty resource path be valid - it means list root of bucket

		// Validate bucket parameter exists
		if (parameters.find("bucket") == parameters.end()) {
			TraceEvent(SevError, "S3ClientGetEndpointMissingBucket").detail("URL", s3url).detail("Error", error);
			throw backup_invalid_url();
		}

		// Validate resource path characters
		for (char c : resource) {
			if (!isalnum(c) && c != '_' && c != '-' && c != '.' && c != '/') {
				TraceEvent(SevError, "S3ClientGetEndpointIllegalCharacter")
				    .detail("URL", s3url)
				    .detail("Character", std::string(1, c))
				    .detail("Error", error);
				throw backup_invalid_url();
			}
		}

		if (!error.empty()) {
			TraceEvent(SevError, "S3ClientGetEndpointError").detail("URL", s3url).detail("Error", error);
			throw backup_invalid_url();
		}

		return endpoint;

	} catch (Error& e) {
		TraceEvent(SevError, "S3ClientGetEndpointFailed").detail("URL", StringRef(s3url)).detail("Error", e.what());
		throw;
	}
}

// Helper function to determine if an error is retryable
bool isRetryableError(int errorCode) {
	return errorCode == error_code_http_bad_response || errorCode == error_code_connection_failed ||
	       errorCode == error_code_lookup_failed || errorCode == error_code_http_request_failed ||
	       errorCode == error_code_io_error || errorCode == error_code_platform_error;
}

// Write checksum with configurable fallback strategy
															#line 609 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via writeChecksumWithFallback()
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class WriteChecksumWithFallbackActor>
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class WriteChecksumWithFallbackActorState {
															#line 616 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	WriteChecksumWithFallbackActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& checksum,PartConfig const& config) 
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   checksum(checksum),
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config)
															#line 631 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this));

	}
	~WriteChecksumWithFallbackActorState() 
	{
		fdb_probe_actor_destroy("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 192 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!config.enableChecksumValidation)
															#line 646 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 193 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientChecksumValidationDisabled") .suppressFor(60) .detail("Bucket", bucket) .detail("Object", objectName);
															#line 197 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 652 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~WriteChecksumWithFallbackActorState();
				static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 202 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				tags = std::map<std::string, std::string>();
															#line 203 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				tags[S3_CHECKSUM_TAG_NAME] = checksum;
															#line 204 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<Void> __when_expr_0 = endpoint->putObjectTags(bucket, objectName, tags);
															#line 204 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 667 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state = 1;
															#line 204 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*>(static_cast<WriteChecksumWithFallbackActor*>(this)));
															#line 672 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 221 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_1 = endpoint->writeEntireFile(bucket, objectName + S3_CHECKSUM_FILE_SUFFIX, checksum);
															#line 221 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 703 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state = 2;
															#line 221 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*>(static_cast<WriteChecksumWithFallbackActor*>(this)));
															#line 708 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 211 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() != error_code_http_bad_response && e.code() != error_code_file_not_found)
															#line 718 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 212 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 722 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 214 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientTaggingFallback") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Reason", "Tagging not supported, using companion file");
															#line 726 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 205 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumStoredAsTags") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Checksum", checksum);
															#line 209 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 743 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 205 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumStoredAsTags") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Checksum", checksum);
															#line 209 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 757 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state > 0) static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<WriteChecksumWithFallbackActor*>(this)->ActorCallback< WriteChecksumWithFallbackActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 222 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumStoredAsFile") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumFile", objectName + S3_CHECKSUM_FILE_SUFFIX) .detail("Checksum", checksum);
															#line 227 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 846 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 222 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumStoredAsFile") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumFile", objectName + S3_CHECKSUM_FILE_SUFFIX) .detail("Checksum", checksum);
															#line 227 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<WriteChecksumWithFallbackActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WriteChecksumWithFallbackActorState(); static_cast<WriteChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 860 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<WriteChecksumWithFallbackActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WriteChecksumWithFallbackActorState();
		static_cast<WriteChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state > 0) static_cast<WriteChecksumWithFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<WriteChecksumWithFallbackActor*>(this)->ActorCallback< WriteChecksumWithFallbackActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string checksum;
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 202 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::map<std::string, std::string> tags;
															#line 955 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via writeChecksumWithFallback()
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class WriteChecksumWithFallbackActor final : public Actor<Void>, public ActorCallback< WriteChecksumWithFallbackActor, 0, Void >, public ActorCallback< WriteChecksumWithFallbackActor, 1, Void >, public FastAllocated<WriteChecksumWithFallbackActor>, public WriteChecksumWithFallbackActorState<WriteChecksumWithFallbackActor> {
															#line 960 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<WriteChecksumWithFallbackActor>::operator new;
	using FastAllocated<WriteChecksumWithFallbackActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14979667321173602048UL, 5193764287059432192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteChecksumWithFallbackActor, 0, Void >;
friend struct ActorCallback< WriteChecksumWithFallbackActor, 1, Void >;
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	WriteChecksumWithFallbackActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& checksum,PartConfig const& config) 
															#line 978 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   WriteChecksumWithFallbackActorState<WriteChecksumWithFallbackActor>(endpoint, bucket, objectName, checksum, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18335821694256988416UL, 390065426227613696UL);
		ActorExecutionContextHelper __helper(static_cast<WriteChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeChecksumWithFallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeChecksumWithFallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteChecksumWithFallbackActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteChecksumWithFallbackActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Void> writeChecksumWithFallback( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& checksum, PartConfig const& config ) {
															#line 187 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new WriteChecksumWithFallbackActor(endpoint, bucket, objectName, checksum, config));
															#line 1012 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 229 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

// Read checksum with configurable fallback strategy
															#line 1018 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via readChecksumWithFallback()
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class ReadChecksumWithFallbackActor>
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ReadChecksumWithFallbackActorState {
															#line 1025 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ReadChecksumWithFallbackActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,PartConfig const& config) 
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config)
															#line 1038 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("readChecksumWithFallback", reinterpret_cast<unsigned long>(this));

	}
	~ReadChecksumWithFallbackActorState() 
	{
		fdb_probe_actor_destroy("readChecksumWithFallback", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 235 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!config.enableChecksumValidation)
															#line 1053 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 236 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevDebug, "S3ClientChecksumValidationDisabled") .detail("Bucket", bucket) .detail("Object", objectName);
															#line 239 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1059 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
				this->~ReadChecksumWithFallbackActorState();
				static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			try {
															#line 244 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<std::map<std::string, std::string>> __when_expr_0 = endpoint->getObjectTags(bucket, objectName);
															#line 244 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1070 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state = 1;
															#line 244 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*>(static_cast<ReadChecksumWithFallbackActor*>(this)));
															#line 1075 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadChecksumWithFallbackActorState();
		static_cast<ReadChecksumWithFallbackActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
		try {
															#line 265 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::string> __when_expr_1 = endpoint->readEntireFile(bucket, objectName + S3_CHECKSUM_FILE_SUFFIX);
															#line 265 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1107 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state = 2;
															#line 265 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*>(static_cast<ReadChecksumWithFallbackActor*>(this)));
															#line 1112 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 254 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() != error_code_http_bad_response && e.code() != error_code_file_not_found)
															#line 1128 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 255 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1132 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 257 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientTagsNotAvailable") .detail("Bucket", bucket) .detail("Object", objectName) .detail("FallingBackToFile", "true");
															#line 1136 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 245 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		auto it = tags.find(S3_CHECKSUM_TAG_NAME);
															#line 246 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (it != tags.end() && !it->second.empty())
															#line 1153 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 247 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientChecksumFoundInTags") .detail("Bucket", bucket) .detail("Object", objectName) .detail("Checksum", it->second);
															#line 251 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(it->second)); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1159 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(it->second));
			this->~ReadChecksumWithFallbackActorState();
			static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::map<std::string, std::string> const& __tags,int loopDepth) 
	{
															#line 244 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		tags = __tags;
															#line 1173 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::map<std::string, std::string> && __tags,int loopDepth) 
	{
		tags = std::move(__tags);
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state > 0) static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<ReadChecksumWithFallbackActor*>(this)->ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*,std::map<std::string, std::string> const& value) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*,std::map<std::string, std::string> && value) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 278 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientNoChecksumFound") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumValidationEnabled", config.enableChecksumValidation ? "true" : "false");
															#line 282 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>()); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1267 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>());
		this->~ReadChecksumWithFallbackActorState();
		static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 273 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() != error_code_file_not_found)
															#line 1280 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 274 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1284 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(std::string const& checksum,int loopDepth) 
	{
															#line 266 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumFoundInFile") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumFile", objectName + S3_CHECKSUM_FILE_SUFFIX) .detail("Checksum", checksum);
															#line 271 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(checksum)); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1302 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(checksum));
		this->~ReadChecksumWithFallbackActorState();
		static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(std::string && checksum,int loopDepth) 
	{
															#line 266 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientChecksumFoundInFile") .detail("Bucket", bucket) .detail("Object", objectName) .detail("ChecksumFile", objectName + S3_CHECKSUM_FILE_SUFFIX) .detail("Checksum", checksum);
															#line 271 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<ReadChecksumWithFallbackActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(Optional<std::string>(checksum)); this->~ReadChecksumWithFallbackActorState(); static_cast<ReadChecksumWithFallbackActor*>(this)->destroy(); return 0; }
															#line 1316 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<ReadChecksumWithFallbackActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(Optional<std::string>(checksum));
		this->~ReadChecksumWithFallbackActorState();
		static_cast<ReadChecksumWithFallbackActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::string const& checksum,int loopDepth) 
	{
		loopDepth = a_body1cont8(checksum, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::string && checksum,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(checksum), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state > 0) static_cast<ReadChecksumWithFallbackActor*>(this)->actor_wait_state = 0;
		static_cast<ReadChecksumWithFallbackActor*>(this)->ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 244 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::map<std::string, std::string> tags;
															#line 1409 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via readChecksumWithFallback()
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ReadChecksumWithFallbackActor final : public Actor<Optional<std::string>>, public ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >, public ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >, public FastAllocated<ReadChecksumWithFallbackActor>, public ReadChecksumWithFallbackActorState<ReadChecksumWithFallbackActor> {
															#line 1414 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<ReadChecksumWithFallbackActor>::operator new;
	using FastAllocated<ReadChecksumWithFallbackActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9277959258169497600UL, 2207068199658108416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >;
friend struct ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >;
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ReadChecksumWithFallbackActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,PartConfig const& config) 
															#line 1432 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Optional<std::string>>(),
		   ReadChecksumWithFallbackActorState<ReadChecksumWithFallbackActor>(endpoint, bucket, objectName, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5279133990643063552UL, 16030994525704471296UL);
		ActorExecutionContextHelper __helper(static_cast<ReadChecksumWithFallbackActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readChecksumWithFallback");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readChecksumWithFallback", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadChecksumWithFallbackActor, 0, std::map<std::string, std::string> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadChecksumWithFallbackActor, 1, std::string >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Optional<std::string>> readChecksumWithFallback( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, PartConfig const& config ) {
															#line 231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Optional<std::string>>(new ReadChecksumWithFallbackActor(endpoint, bucket, objectName, config));
															#line 1466 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 284 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

// Upload a part of a multipart upload with configurable retry logic.

															#line 1473 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via uploadPart()
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class UploadPartActor>
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class UploadPartActorState {
															#line 1480 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	UploadPartActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& uploadID,Reference<IAsyncFile> const& file,PartState const& part,XXH64_state_t* const& hashState,PartConfig const& config) 
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   uploadID(uploadID),
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(file),
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   part(part),
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   hashState(hashState),
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config),
															#line 295 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   startTime(now()),
															#line 296 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resultPart(part),
															#line 297 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   attempt(0),
															#line 298 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxRetries(config.maxPartRetries),
															#line 299 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   delayMs(config.baseRetryDelayMs),
															#line 300 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   packets()
															#line 1513 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("uploadPart", reinterpret_cast<unsigned long>(this));

	}
	~UploadPartActorState() 
	{
		fdb_probe_actor_destroy("uploadPart", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 302 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientUploadPartStart") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size) .detail("MaxRetries", maxRetries);
															#line 310 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 1530 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UploadPartActorState();
		static_cast<UploadPartActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 313 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partData = std::string();
															#line 314 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partData.resize(resultPart.size);
															#line 316 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<int> __when_expr_0 = file->read(&partData[0], resultPart.size, resultPart.offset);
															#line 316 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<UploadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1567 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<UploadPartActor*>(this)->actor_wait_state = 1;
															#line 316 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UploadPartActor, 0, int >*>(static_cast<UploadPartActor*>(this)));
															#line 1572 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 370 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			attempt++;
															#line 371 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (attempt >= maxRetries || !isRetryableError(e.code()))
															#line 1596 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 372 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientUploadPartFailed") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("ErrorCode", e.code()) .detail("Attempts", attempt) .detail("MaxRetries", maxRetries) .detail("FinalError", e.what());
															#line 380 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1602 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 383 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientUploadPartRetry") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("Attempt", attempt) .detail("Error", e.what()) .detail("DelayMs", delayMs);
															#line 391 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(delayMs / 1000.0);
															#line 391 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<UploadPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1610 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<UploadPartActor*>(this)->actor_wait_state = 3;
															#line 391 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< UploadPartActor, 2, Void >*>(static_cast<UploadPartActor*>(this)));
															#line 1615 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int const& bytesRead,int loopDepth) 
	{
															#line 317 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != resultPart.size)
															#line 1630 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 318 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientUploadPartReadError") .detail("Expected", resultPart.size) .detail("Actual", bytesRead) .detail("Offset", resultPart.offset);
															#line 322 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), loopDepth);
															#line 1636 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 326 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_update(hashState, partData.data(), bytesRead);
															#line 329 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string checksum;
															#line 330 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (CLIENT_KNOBS->BLOBSTORE_ENABLE_OBJECT_INTEGRITY_CHECK)
															#line 1644 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			unsigned char hash[SHA256_DIGEST_LENGTH];
															#line 333 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_CTX sha256;
															#line 334 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Init(&sha256);
															#line 335 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Update(&sha256, partData.data(), partData.size());
															#line 336 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Final(hash, &sha256);
															#line 337 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string hashAsStr = std::string((char*)hash, SHA256_DIGEST_LENGTH);
															#line 338 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string sig = base64::encoder::from_string(hashAsStr);
															#line 340 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			sig.resize(sig.size() - 1);
															#line 341 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			checksum = sig;
															#line 1664 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		else
		{
															#line 344 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			checksum = HTTP::computeMD5Sum(partData);
															#line 1670 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 348 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.checksum = checksum;
															#line 351 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		packets.discardAll();
															#line 352 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		PacketWriter pw(packets.getWriteBuffer(partData.size()), nullptr, Unversioned());
															#line 353 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		pw.serializeBytes(partData);
															#line 355 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = endpoint->uploadPart( bucket, objectName, uploadID, resultPart.partNumber, &packets, partData.size(), resultPart.checksum);
															#line 355 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<UploadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1684 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UploadPartActor*>(this)->actor_wait_state = 2;
															#line 355 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UploadPartActor, 1, std::string >*>(static_cast<UploadPartActor*>(this)));
															#line 1689 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(int && bytesRead,int loopDepth) 
	{
															#line 317 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead != resultPart.size)
															#line 1698 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 318 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientUploadPartReadError") .detail("Expected", resultPart.size) .detail("Actual", bytesRead) .detail("Offset", resultPart.offset);
															#line 322 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), loopDepth);
															#line 1704 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 326 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_update(hashState, partData.data(), bytesRead);
															#line 329 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string checksum;
															#line 330 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (CLIENT_KNOBS->BLOBSTORE_ENABLE_OBJECT_INTEGRITY_CHECK)
															#line 1712 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			unsigned char hash[SHA256_DIGEST_LENGTH];
															#line 333 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_CTX sha256;
															#line 334 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Init(&sha256);
															#line 335 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Update(&sha256, partData.data(), partData.size());
															#line 336 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			SHA256_Final(hash, &sha256);
															#line 337 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string hashAsStr = std::string((char*)hash, SHA256_DIGEST_LENGTH);
															#line 338 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string sig = base64::encoder::from_string(hashAsStr);
															#line 340 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			sig.resize(sig.size() - 1);
															#line 341 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			checksum = sig;
															#line 1732 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		else
		{
															#line 344 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			checksum = HTTP::computeMD5Sum(partData);
															#line 1738 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 348 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.checksum = checksum;
															#line 351 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		packets.discardAll();
															#line 352 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		PacketWriter pw(packets.getWriteBuffer(partData.size()), nullptr, Unversioned());
															#line 353 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		pw.serializeBytes(partData);
															#line 355 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_1 = endpoint->uploadPart( bucket, objectName, uploadID, resultPart.partNumber, &packets, partData.size(), resultPart.checksum);
															#line 355 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<UploadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1752 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UploadPartActor*>(this)->actor_wait_state = 2;
															#line 355 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UploadPartActor, 1, std::string >*>(static_cast<UploadPartActor*>(this)));
															#line 1757 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UploadPartActor*>(this)->actor_wait_state > 0) static_cast<UploadPartActor*>(this)->actor_wait_state = 0;
		static_cast<UploadPartActor*>(this)->ActorCallback< UploadPartActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UploadPartActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(std::string const& etag,int loopDepth) 
	{
															#line 358 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.etag = etag;
															#line 359 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 360 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientUploadPartEnd") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Duration", now() - startTime) .detail("Size", resultPart.size) .detail("Attempts", attempt + 1);
															#line 368 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<UploadPartActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~UploadPartActorState(); static_cast<UploadPartActor*>(this)->destroy(); return 0; }
															#line 1847 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<UploadPartActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~UploadPartActorState();
		static_cast<UploadPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(std::string && etag,int loopDepth) 
	{
															#line 358 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.etag = etag;
															#line 359 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 360 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientUploadPartEnd") .detail("Bucket", StringRef(bucket)) .detail("Object", StringRef(objectName)) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Duration", now() - startTime) .detail("Size", resultPart.size) .detail("Attempts", attempt + 1);
															#line 368 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<UploadPartActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~UploadPartActorState(); static_cast<UploadPartActor*>(this)->destroy(); return 0; }
															#line 1865 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<UploadPartActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~UploadPartActorState();
		static_cast<UploadPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string const& etag,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(etag, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(std::string && etag,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(etag), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UploadPartActor*>(this)->actor_wait_state > 0) static_cast<UploadPartActor*>(this)->actor_wait_state = 0;
		static_cast<UploadPartActor*>(this)->ActorCallback< UploadPartActor, 1, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 1, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 1, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UploadPartActor, 1, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 392 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		delayMs = std::min(delayMs * 2, config.maxRetryDelayMs);
															#line 1952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 392 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		delayMs = std::min(delayMs * 2, config.maxRetryDelayMs);
															#line 1961 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<UploadPartActor*>(this)->actor_wait_state > 0) static_cast<UploadPartActor*>(this)->actor_wait_state = 0;
		static_cast<UploadPartActor*>(this)->ActorCallback< UploadPartActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< UploadPartActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< UploadPartActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string uploadID;
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState part;
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	XXH64_state_t* hashState;
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 295 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	double startTime;
															#line 296 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState resultPart;
															#line 297 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int attempt;
															#line 298 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxRetries;
															#line 299 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int delayMs;
															#line 300 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	UnsentPacketQueue packets;
															#line 313 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string partData;
															#line 2071 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via uploadPart()
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class UploadPartActor final : public Actor<PartState>, public ActorCallback< UploadPartActor, 0, int >, public ActorCallback< UploadPartActor, 1, std::string >, public ActorCallback< UploadPartActor, 2, Void >, public FastAllocated<UploadPartActor>, public UploadPartActorState<UploadPartActor> {
															#line 2076 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<UploadPartActor>::operator new;
	using FastAllocated<UploadPartActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2544912404231942144UL, 7368145770494336256UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<PartState>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UploadPartActor, 0, int >;
friend struct ActorCallback< UploadPartActor, 1, std::string >;
friend struct ActorCallback< UploadPartActor, 2, Void >;
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	UploadPartActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& uploadID,Reference<IAsyncFile> const& file,PartState const& part,XXH64_state_t* const& hashState,PartConfig const& config) 
															#line 2095 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<PartState>(),
		   UploadPartActorState<UploadPartActor>(endpoint, bucket, objectName, uploadID, file, part, hashState, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("uploadPart", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8500122340480301312UL, 500718127134435072UL);
		ActorExecutionContextHelper __helper(static_cast<UploadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("uploadPart");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("uploadPart", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UploadPartActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UploadPartActor, 1, std::string >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< UploadPartActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<PartState> uploadPart( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& uploadID, Reference<IAsyncFile> const& file, PartState const& part, XXH64_state_t* const& hashState, PartConfig const& config ) {
															#line 287 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<PartState>(new UploadPartActor(endpoint, bucket, objectName, uploadID, file, part, hashState, config));
															#line 2130 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 396 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

// Copy filepath to bucket at resource in s3.
															#line 2136 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyUpFile()
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpFileActor>
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActorState {
															#line 2143 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   filepath(filepath),
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config),
															#line 403 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   startTime(now()),
															#line 404 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(),
															#line 405 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   uploadID(),
															#line 406 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   parts(),
															#line 407 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   size(),
															#line 408 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   hashState(XXH64_createState()),
															#line 409 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   retries(0),
															#line 410 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   offset(),
															#line 411 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   partNumber(),
															#line 412 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxConcurrentUploads(),
															#line 413 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   activeFutures(),
															#line 414 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   activePartIndices(),
															#line 415 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   partSize(),
															#line 416 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   numParts(),
															#line 417 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   checksum(),
															#line 418 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   part(),
															#line 419 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   tags()
															#line 2192 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpFileActorState() 
	{
		fdb_probe_actor_destroy("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 421 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 2207 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpFileActorState();
		static_cast<CopyUpFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 612 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpFileActorState(); static_cast<CopyUpFileActor*>(this)->destroy(); return 0; }
															#line 2230 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpFileActorState();
		static_cast<CopyUpFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 423 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpFileStart") .detail("Bucket", bucket) .detail("Object", objectName) .detail("FilePath", filepath) .detail("Attempt", retries);
															#line 430 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!hashState)
															#line 2252 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 431 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				hashState = XXH64_createState();
															#line 2256 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 433 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			XXH64_reset(hashState, 0);
															#line 435 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( filepath, IAsyncFile::OPEN_READONLY | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_NO_AIO, 0644);
															#line 435 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2264 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpFileActor*>(this)->actor_wait_state = 1;
															#line 435 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2269 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 535 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2304 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 536 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 2308 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 539 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if ((e.code() == error_code_file_not_found || e.code() == error_code_http_request_failed || e.code() == error_code_io_error) && retries < config.maxFileRetries)
															#line 2312 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 542 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				retryError = e;
															#line 543 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientCopyUpFileRetry") .errorUnsuppressed(retryError) .detail("Bucket", bucket) .detail("Object", objectName) .detail("FilePath", filepath) .detail("Retries", retries);
															#line 549 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				retries++;
															#line 552 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				XXH64_freeState(hashState);
															#line 553 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				hashState = nullptr;
															#line 554 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				parts.clear();
															#line 555 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				activeFutures.clear();
															#line 556 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				activePartIndices.clear();
															#line 558 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (file)
															#line 2332 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 559 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					file = Reference<IAsyncFile>();
															#line 2336 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
															#line 563 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!uploadID.empty())
															#line 2340 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
					try {
															#line 565 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						StrictFuture<Void> __when_expr_6 = endpoint->abortMultiPartUpload(bucket, objectName, uploadID);
															#line 565 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 2347 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_6.get(), loopDepth); };
						static_cast<CopyUpFileActor*>(this)->actor_wait_state = 7;
															#line 565 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 6, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2352 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						loopDepth = 0;
					}
					catch (Error& error) {
						loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont3(loopDepth);
				}
			}
			else
			{
															#line 583 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				err = e;
															#line 584 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				XXH64_freeState(hashState);
															#line 585 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				hashState = nullptr;
															#line 586 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientCopyUpFileError") .detail("Filepath", filepath) .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("Error", err.what()) .detail("Attempts", retries + 1);
															#line 594 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				file = Reference<IAsyncFile>();
															#line 597 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!uploadID.empty())
															#line 2380 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
					try {
															#line 599 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						StrictFuture<Void> __when_expr_9 = endpoint->abortMultiPartUpload(bucket, objectName, uploadID);
															#line 599 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch2(actor_cancelled(), loopDepth);
															#line 2387 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1loopBody1Catch1Catch2(__when_expr_9.getError(), loopDepth); else return a_body1loopBody1Catch1when2(__when_expr_9.get(), loopDepth); };
						static_cast<CopyUpFileActor*>(this)->actor_wait_state = 10;
															#line 599 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 9, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2392 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						loopDepth = 0;
					}
					catch (Error& error) {
						loopDepth = a_body1loopBody1Catch1Catch2(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1loopBody1Catch1Catch2(unknown_error(), loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont12(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Reference<IAsyncFile> const& f,int loopDepth) 
	{
															#line 437 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 439 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 439 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2423 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 2;
															#line 439 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 1, int64_t >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2428 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Reference<IAsyncFile> && f,int loopDepth) 
	{
															#line 437 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 439 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<int64_t> __when_expr_1 = file->size();
															#line 439 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2441 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 2;
															#line 439 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 1, int64_t >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2446 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<IAsyncFile> const& f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(f, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Reference<IAsyncFile> && f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int64_t const& fileSize,int loopDepth) 
	{
															#line 440 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		size = fileSize;
															#line 442 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = endpoint->beginMultiPartUpload(bucket, objectName);
															#line 442 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2534 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 3;
															#line 442 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 2, std::string >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2539 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(int64_t && fileSize,int loopDepth) 
	{
															#line 440 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		size = fileSize;
															#line 442 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<std::string> __when_expr_2 = endpoint->beginMultiPartUpload(bucket, objectName);
															#line 442 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2552 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 3;
															#line 442 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 2, std::string >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2557 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(int64_t const& fileSize,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(fileSize, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(int64_t && fileSize,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(fileSize), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 1, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 1, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 1, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 1, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(std::string const& id,int loopDepth) 
	{
															#line 443 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadID = id;
															#line 445 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		offset = 0;
															#line 446 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber = 1;
															#line 447 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		maxConcurrentUploads = CLIENT_KNOBS->BLOBSTORE_CONCURRENT_WRITES_PER_FILE;
															#line 448 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeFutures.clear();
															#line 449 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 452 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 2653 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(std::string && id,int loopDepth) 
	{
															#line 443 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadID = id;
															#line 445 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		offset = 0;
															#line 446 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber = 1;
															#line 447 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		maxConcurrentUploads = CLIENT_KNOBS->BLOBSTORE_CONCURRENT_WRITES_PER_FILE;
															#line 448 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeFutures.clear();
															#line 449 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 452 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 2674 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(std::string const& id,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(id, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(std::string && id,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(id), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 2, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 2, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 2, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 2, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
															#line 485 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::map<int, S3BlobStoreEndpoint::PartInfo> etagMap;
															#line 486 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& part : parts ) {
															#line 487 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!part.completed)
															#line 2762 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 488 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientCopyUpFilePartNotCompleted") .detail("PartNumber", part.partNumber) .detail("Offset", part.offset) .detail("Size", part.size);
															#line 492 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				XXH64_freeState(hashState);
															#line 493 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1loopBody1Catch1(http_bad_response(), loopDepth);
															#line 2770 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 495 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			etagMap[part.partNumber] = S3BlobStoreEndpoint::PartInfo(part.etag, part.checksum);
															#line 2774 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 498 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Optional<std::string>> __when_expr_4 = endpoint->finishMultiPartUpload(bucket, objectName, uploadID, etagMap);
															#line 498 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2780 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_4.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 5;
															#line 498 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2785 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont5loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1(int loopDepth) 
	{
															#line 452 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(offset < size))
															#line 2801 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1loopBody1cont5break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 454 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for(;activeFutures.size() < maxConcurrentUploads && offset < size;) {
															#line 455 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partSize = std::min(config.partSizeBytes, size - offset);
															#line 457 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			part = PartState();
															#line 458 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			part.partNumber = partNumber;
															#line 459 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			part.offset = offset;
															#line 460 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			part.size = partSize;
															#line 461 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			parts.push_back(part);
															#line 463 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			activeFutures.push_back( uploadPart(endpoint, bucket, objectName, uploadID, file, part, hashState, config));
															#line 465 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			activePartIndices.push_back(partNumber - 1);
															#line 467 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			offset += partSize;
															#line 468 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partNumber++;
															#line 2827 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 472 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!activeFutures.empty())
															#line 2831 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 473 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::vector<PartState>> __when_expr_3 = getAll(activeFutures);
															#line 473 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2837 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont5loopBody1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CopyUpFileActor*>(this)->actor_wait_state = 4;
															#line 473 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*>(static_cast<CopyUpFileActor*>(this)));
															#line 2842 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont5loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont6(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont5loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont4(std::vector<PartState> const& completedParts,int loopDepth) 
	{
															#line 475 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for(int i = 0;i < completedParts.size();i++) {
															#line 476 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			parts[activePartIndices[i]] = completedParts[i];
															#line 2877 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 479 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeFutures.clear();
															#line 480 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 2883 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1cont4(std::vector<PartState> && completedParts,int loopDepth) 
	{
															#line 475 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for(int i = 0;i < completedParts.size();i++) {
															#line 476 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			parts[activePartIndices[i]] = completedParts[i];
															#line 2894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 479 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeFutures.clear();
															#line 480 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 2900 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont5loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(std::vector<PartState> const& completedParts,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont4(completedParts, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5loopBody1when1(std::vector<PartState> && completedParts,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5loopBody1cont4(std::move(completedParts), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*,std::vector<PartState> const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*,std::vector<PartState> && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont5loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont7(Optional<std::string> const& s3Checksum,int loopDepth) 
	{
															#line 502 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (s3Checksum.present())
															#line 2984 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 503 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientMultipartUploadChecksum") .detail("Bucket", bucket) .detail("Object", objectName) .detail("S3ChecksumSHA256", s3Checksum.get());
															#line 2988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 510 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		numParts = parts.size();
															#line 511 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.clear();
															#line 514 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uint64_t hash = XXH64_digest(hashState);
															#line 515 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_freeState(hashState);
															#line 516 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		checksum = format("%016llx", hash);
															#line 519 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 522 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_5 = writeChecksumWithFallback(endpoint, bucket, objectName, checksum, config);
															#line 522 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3006 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 6;
															#line 522 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 5, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 3011 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Optional<std::string> && s3Checksum,int loopDepth) 
	{
															#line 502 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (s3Checksum.present())
															#line 3020 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 503 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientMultipartUploadChecksum") .detail("Bucket", bucket) .detail("Object", objectName) .detail("S3ChecksumSHA256", s3Checksum.get());
															#line 3024 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 510 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		numParts = parts.size();
															#line 511 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.clear();
															#line 514 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uint64_t hash = XXH64_digest(hashState);
															#line 515 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		XXH64_freeState(hashState);
															#line 516 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		checksum = format("%016llx", hash);
															#line 519 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 522 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_5 = writeChecksumWithFallback(endpoint, bucket, objectName, checksum, config);
															#line 522 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3042 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_5.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 6;
															#line 522 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 5, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 3047 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<std::string> const& s3Checksum,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(s3Checksum, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<std::string> && s3Checksum,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(s3Checksum), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 4, Optional<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*,Optional<std::string> const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*,Optional<std::string> && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont10(Void const& _,int loopDepth) 
	{
															#line 524 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpFileEnd") .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("FileSize", size) .detail("Parts", numParts) .detail("Checksum", checksum) .detail("Duration", now() - startTime) .detail("Attempts", retries + 1);
															#line 3131 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont10(Void && _,int loopDepth) 
	{
															#line 524 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpFileEnd") .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("FileSize", size) .detail("Parts", numParts) .detail("Checksum", checksum) .detail("Duration", now() - startTime) .detail("Attempts", retries + 1);
															#line 3140 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
															#line 577 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (g_network->isSimulated())
															#line 3230 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 578 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_7 = delay(0);
															#line 578 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3236 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1Catch1(__when_expr_7.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont3when1(__when_expr_7.get(), loopDepth); };
			static_cast<CopyUpFileActor*>(this)->actor_wait_state = 8;
															#line 578 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 7, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 3241 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1Catch1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
															#line 574 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		uploadID = "";
															#line 3255 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& abortError,int loopDepth=0) 
	{
		try {
															#line 567 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientCopyUpFileAbortError") .error(abortError) .detail("Bucket", bucket) .detail("Object", objectName) .detail("UploadID", uploadID) .detail("OriginalError", retryError.what());
															#line 3265 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopBody1Catch1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1Catch1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont9(int loopDepth) 
	{
															#line 581 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_8 = delay(1.0 * retries);
															#line 581 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3382 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont9when1(__when_expr_8.get(), loopDepth); };
		static_cast<CopyUpFileActor*>(this)->actor_wait_state = 9;
															#line 581 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor, 8, Void >*>(static_cast<CopyUpFileActor*>(this)));
															#line 3387 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont10(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont10(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1Catch1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1Catch1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont13(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch2(const Error& abortError,int loopDepth=0) 
	{
		try {
															#line 602 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyUpFileAbortError") .error(abortError) .detail("Bucket", bucket) .detail("Object", objectName) .detail("OriginalError", err.what());
															#line 3583 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopBody1Catch1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont14(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont14(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont14cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont14(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont14(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CopyUpFileActor*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor*>(this)->ActorCallback< CopyUpFileActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1Catch1cont14cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont13(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 403 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	double startTime;
															#line 404 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 405 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string uploadID;
															#line 406 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<PartState> parts;
															#line 407 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t size;
															#line 408 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	XXH64_state_t* hashState;
															#line 409 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int retries;
															#line 410 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t offset;
															#line 411 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int partNumber;
															#line 412 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxConcurrentUploads;
															#line 413 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<Future<PartState>> activeFutures;
															#line 414 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<int> activePartIndices;
															#line 415 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t partSize;
															#line 416 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int numParts;
															#line 417 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string checksum;
															#line 418 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState part;
															#line 419 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::map<std::string, std::string> tags;
															#line 542 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Error retryError;
															#line 583 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Error err;
															#line 3742 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyUpFile()
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActor final : public Actor<Void>, public ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >, public ActorCallback< CopyUpFileActor, 1, int64_t >, public ActorCallback< CopyUpFileActor, 2, std::string >, public ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >, public ActorCallback< CopyUpFileActor, 4, Optional<std::string> >, public ActorCallback< CopyUpFileActor, 5, Void >, public ActorCallback< CopyUpFileActor, 6, Void >, public ActorCallback< CopyUpFileActor, 7, Void >, public ActorCallback< CopyUpFileActor, 8, Void >, public ActorCallback< CopyUpFileActor, 9, Void >, public FastAllocated<CopyUpFileActor>, public CopyUpFileActorState<CopyUpFileActor> {
															#line 3747 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyUpFileActor>::operator new;
	using FastAllocated<CopyUpFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17406407368537217024UL, 2310987000306488576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< CopyUpFileActor, 1, int64_t >;
friend struct ActorCallback< CopyUpFileActor, 2, std::string >;
friend struct ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >;
friend struct ActorCallback< CopyUpFileActor, 4, Optional<std::string> >;
friend struct ActorCallback< CopyUpFileActor, 5, Void >;
friend struct ActorCallback< CopyUpFileActor, 6, Void >;
friend struct ActorCallback< CopyUpFileActor, 7, Void >;
friend struct ActorCallback< CopyUpFileActor, 8, Void >;
friend struct ActorCallback< CopyUpFileActor, 9, Void >;
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 3773 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyUpFileActorState<CopyUpFileActor>(endpoint, bucket, objectName, filepath, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5029125091406905600UL, 16817405566823635200UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpFileActor, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyUpFileActor, 1, int64_t >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CopyUpFileActor, 2, std::string >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CopyUpFileActor, 3, std::vector<PartState> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CopyUpFileActor, 4, Optional<std::string> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CopyUpFileActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CopyUpFileActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CopyUpFileActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CopyUpFileActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CopyUpFileActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Void> copyUpFile( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& filepath, PartConfig const& config = PartConfig() ) {
															#line 398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpFileActor(endpoint, bucket, objectName, filepath, config));
															#line 3815 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 614 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 3820 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyUpFile()
															#line 615 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpFileActor1>
															#line 615 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActor1State {
															#line 3827 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 615 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActor1State(std::string const& filepath,std::string const& s3url) 
															#line 615 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 615 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : filepath(filepath),
															#line 615 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   s3url(s3url)
															#line 3836 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpFileActor1State() 
	{
		fdb_probe_actor_destroy("copyUpFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 616 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string resource;
															#line 617 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 618 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			Reference<S3BlobStoreEndpoint> endpoint = getEndpoint(s3url, resource, parameters);
															#line 619 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyUpFile(endpoint, parameters["bucket"], resource, filepath);
															#line 619 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpFileActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3859 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpFileActor1*>(this)->actor_wait_state = 1;
															#line 619 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpFileActor1, 0, Void >*>(static_cast<CopyUpFileActor1*>(this)));
															#line 3864 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpFileActor1State();
		static_cast<CopyUpFileActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 620 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpFileActor1State(); static_cast<CopyUpFileActor1*>(this)->destroy(); return 0; }
															#line 3887 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpFileActor1State();
		static_cast<CopyUpFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 620 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpFileActor1State(); static_cast<CopyUpFileActor1*>(this)->destroy(); return 0; }
															#line 3899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpFileActor1State();
		static_cast<CopyUpFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpFileActor1*>(this)->actor_wait_state > 0) static_cast<CopyUpFileActor1*>(this)->actor_wait_state = 0;
		static_cast<CopyUpFileActor1*>(this)->ActorCallback< CopyUpFileActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpFileActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpFileActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 615 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 615 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 3986 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyUpFile()
															#line 615 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpFileActor1 final : public Actor<Void>, public ActorCallback< CopyUpFileActor1, 0, Void >, public FastAllocated<CopyUpFileActor1>, public CopyUpFileActor1State<CopyUpFileActor1> {
															#line 3991 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyUpFileActor1>::operator new;
	using FastAllocated<CopyUpFileActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17406407368537217024UL, 2310987000306488576UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpFileActor1, 0, Void >;
															#line 615 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpFileActor1(std::string const& filepath,std::string const& s3url) 
															#line 4008 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyUpFileActor1State<CopyUpFileActor1>(filepath, s3url),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(794650894807017472UL, 16661816041386160896UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpFileActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 615 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyUpFile( std::string const& filepath, std::string const& s3url ) {
															#line 615 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpFileActor1(filepath, s3url));
															#line 4041 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 622 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 4046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyUpDirectory()
															#line 623 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpDirectoryActor>
															#line 623 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpDirectoryActorState {
															#line 4053 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 623 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpDirectoryActorState(std::string const& dirpath,std::string const& s3url) 
															#line 623 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 623 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : dirpath(dirpath),
															#line 623 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   s3url(s3url),
															#line 624 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 4064 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyUpDirectory", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpDirectoryActorState() 
	{
		fdb_probe_actor_destroy("copyUpDirectory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 625 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 626 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			endpoint = getEndpoint(s3url, resource, parameters);
															#line 627 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 628 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			files = std::vector<std::string>();
															#line 629 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			platform::findFilesRecursively(dirpath, files);
															#line 630 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientUploadDirStart") .detail("Filecount", files.size()) .detail("Bucket", bucket) .detail("Resource", resource);
															#line 634 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			RangeForbody1Iterator0 = std::begin(files);
															#line 4091 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpDirectoryActorState();
		static_cast<CopyUpDirectoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 639 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientUploadDirEnd").detail("Bucket", bucket).detail("Resource", resource);
															#line 640 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpDirectoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpDirectoryActorState(); static_cast<CopyUpDirectoryActor*>(this)->destroy(); return 0; }
															#line 4116 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpDirectoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpDirectoryActorState();
		static_cast<CopyUpDirectoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 634 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(RangeForbody1Iterator0 != std::end(files)))
															#line 4135 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 634 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		const auto& file = *RangeForbody1Iterator0;
															#line 4141 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 635 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string filepath = file;
															#line 636 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string s3path = resource + "/" + file.substr(dirpath.size() + 1);
															#line 637 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyUpFile(endpoint, bucket, s3path, filepath);
															#line 637 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4151 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state = 1;
															#line 637 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpDirectoryActor, 0, Void >*>(static_cast<CopyUpDirectoryActor*>(this)));
															#line 4156 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 634 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		++RangeForbody1Iterator0;
															#line 4179 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state > 0) static_cast<CopyUpDirectoryActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpDirectoryActor*>(this)->ActorCallback< CopyUpDirectoryActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpDirectoryActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpDirectoryActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpDirectoryActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 623 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string dirpath;
															#line 623 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 624 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 626 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 627 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 628 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<std::string> files;
															#line 634 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	decltype(std::begin(std::declval<std::vector<std::string>>())) RangeForbody1Iterator0;
															#line 4285 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyUpDirectory()
															#line 623 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpDirectoryActor final : public Actor<Void>, public ActorCallback< CopyUpDirectoryActor, 0, Void >, public FastAllocated<CopyUpDirectoryActor>, public CopyUpDirectoryActorState<CopyUpDirectoryActor> {
															#line 4290 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyUpDirectoryActor>::operator new;
	using FastAllocated<CopyUpDirectoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15920827466251545600UL, 14296731720606345216UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpDirectoryActor, 0, Void >;
															#line 623 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpDirectoryActor(std::string const& dirpath,std::string const& s3url) 
															#line 4307 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyUpDirectoryActorState<CopyUpDirectoryActor>(dirpath, s3url),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpDirectory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11526468938747652608UL, 2529043041251822336UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpDirectory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpDirectory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpDirectoryActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 623 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyUpDirectory( std::string const& dirpath, std::string const& s3url ) {
															#line 623 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpDirectoryActor(dirpath, s3url));
															#line 4340 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 642 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 4345 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyUpBulkDumpFileSet()
															#line 643 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyUpBulkDumpFileSetActor>
															#line 643 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpBulkDumpFileSetActorState {
															#line 4352 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 643 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpBulkDumpFileSetActorState(std::string const& s3url,BulkLoadFileSet const& sourceFileSet,BulkLoadFileSet const& destinationFileSet) 
															#line 643 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 643 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 643 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   sourceFileSet(sourceFileSet),
															#line 643 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   destinationFileSet(destinationFileSet),
															#line 646 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 4365 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this));

	}
	~CopyUpBulkDumpFileSetActorState() 
	{
		fdb_probe_actor_destroy("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 647 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 648 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			endpoint = getEndpoint(s3url, resource, parameters);
															#line 649 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 651 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpBulkDumpFileSetStart") .detail("Bucket", bucket) .detail("SourceFileSet", sourceFileSet.toString()) .detail("DestinationFileSet", destinationFileSet.toString());
															#line 655 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			pNumDeleted = 0;
															#line 656 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			pBytesDeleted = 0;
															#line 657 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			batch_dir = joinPath(getPath(s3url), destinationFileSet.getRelativePath());
															#line 660 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<bool> __when_expr_0 = endpoint->bucketExists(bucket);
															#line 660 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4396 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 1;
															#line 660 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4401 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyUpBulkDumpFileSetActorState();
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& exists,int loopDepth) 
	{
															#line 661 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (exists)
															#line 4424 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 662 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_1 = endpoint->deleteRecursively(bucket, batch_dir, &pNumDeleted, &pBytesDeleted);
															#line 662 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4430 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 2;
															#line 662 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4435 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(bool && exists,int loopDepth) 
	{
															#line 661 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (exists)
															#line 4449 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 662 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_1 = endpoint->deleteRecursively(bucket, batch_dir, &pNumDeleted, &pBytesDeleted);
															#line 662 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4455 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 2;
															#line 662 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4460 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(bool const& exists,int loopDepth) 
	{
		loopDepth = a_body1cont1(exists, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && exists,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(exists), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 665 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		auto destinationManifestPath = joinPath(batch_dir, destinationFileSet.getManifestFileName());
															#line 666 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_2 = copyUpFile(endpoint, bucket, destinationManifestPath, sourceFileSet.getManifestFileFullPath());
															#line 666 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4553 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 3;
															#line 666 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4558 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 667 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (sourceFileSet.hasDataFile())
															#line 4654 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 668 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			auto destinationDataPath = joinPath(batch_dir, destinationFileSet.getDataFileName());
															#line 669 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_3 = copyUpFile(endpoint, bucket, destinationDataPath, sourceFileSet.getDataFileFullPath());
															#line 669 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4662 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 4;
															#line 669 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4667 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 667 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (sourceFileSet.hasDataFile())
															#line 4681 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 668 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			auto destinationDataPath = joinPath(batch_dir, destinationFileSet.getDataFileName());
															#line 669 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_3 = copyUpFile(endpoint, bucket, destinationDataPath, sourceFileSet.getDataFileFullPath());
															#line 669 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4689 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont4when1(__when_expr_3.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 4;
															#line 669 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4694 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 671 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (sourceFileSet.hasByteSampleFile())
															#line 4783 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 672 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			ASSERT(sourceFileSet.hasDataFile());
															#line 673 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			auto destinationByteSamplePath = joinPath(batch_dir, destinationFileSet.getByteSampleFileName());
															#line 674 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_4 = copyUpFile(endpoint, bucket, destinationByteSamplePath, sourceFileSet.getBytesSampleFileFullPath());
															#line 674 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4793 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont5when1(__when_expr_4.get(), loopDepth); };
			static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 5;
															#line 674 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*>(static_cast<CopyUpBulkDumpFileSetActor*>(this)));
															#line 4798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont7(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 676 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientCopyUpBulkDumpFileSetEnd") .detail("BatchDir", batch_dir) .detail("NumDeleted", pNumDeleted) .detail("BytesDeleted", pBytesDeleted);
															#line 680 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyUpBulkDumpFileSetActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyUpBulkDumpFileSetActorState(); static_cast<CopyUpBulkDumpFileSetActor*>(this)->destroy(); return 0; }
															#line 4901 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyUpBulkDumpFileSetActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyUpBulkDumpFileSetActorState();
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state > 0) static_cast<CopyUpBulkDumpFileSetActor*>(this)->actor_wait_state = 0;
		static_cast<CopyUpBulkDumpFileSetActor*>(this)->ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 643 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 643 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	BulkLoadFileSet sourceFileSet;
															#line 643 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	BulkLoadFileSet destinationFileSet;
															#line 646 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 648 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 649 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 655 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int pNumDeleted;
															#line 656 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t pBytesDeleted;
															#line 657 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string batch_dir;
															#line 5014 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyUpBulkDumpFileSet()
															#line 643 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyUpBulkDumpFileSetActor final : public Actor<Void>, public ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >, public ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >, public ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >, public ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >, public ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >, public FastAllocated<CopyUpBulkDumpFileSetActor>, public CopyUpBulkDumpFileSetActorState<CopyUpBulkDumpFileSetActor> {
															#line 5019 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyUpBulkDumpFileSetActor>::operator new;
	using FastAllocated<CopyUpBulkDumpFileSetActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13842993483129861632UL, 16463570341213534208UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >;
friend struct ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >;
															#line 643 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyUpBulkDumpFileSetActor(std::string const& s3url,BulkLoadFileSet const& sourceFileSet,BulkLoadFileSet const& destinationFileSet) 
															#line 5040 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyUpBulkDumpFileSetActorState<CopyUpBulkDumpFileSetActor>(s3url, sourceFileSet, destinationFileSet),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(469867549170568960UL, 8064918125250259712UL);
		ActorExecutionContextHelper __helper(static_cast<CopyUpBulkDumpFileSetActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyUpBulkDumpFileSet");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyUpBulkDumpFileSet", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CopyUpBulkDumpFileSetActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 643 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyUpBulkDumpFileSet( std::string const& s3url, BulkLoadFileSet const& sourceFileSet, BulkLoadFileSet const& destinationFileSet ) {
															#line 643 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyUpBulkDumpFileSetActor(s3url, sourceFileSet, destinationFileSet));
															#line 5077 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 682 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 5082 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via downloadPart()
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class DownloadPartActor>
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class DownloadPartActorState {
															#line 5089 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	DownloadPartActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,Reference<IAsyncFile> const& file,PartState const& part,PartConfig const& config) 
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(file),
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   part(part),
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config),
															#line 689 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resultPart(part),
															#line 690 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   attempt(0),
															#line 691 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxRetries(config.maxPartRetries),
															#line 692 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   delayMs(config.baseRetryDelayMs)
															#line 5114 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("downloadPart", reinterpret_cast<unsigned long>(this));

	}
	~DownloadPartActorState() 
	{
		fdb_probe_actor_destroy("downloadPart", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 694 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevDebug, "S3ClientDownloadPartStart") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size);
															#line 701 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 5131 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DownloadPartActorState();
		static_cast<DownloadPartActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 703 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			buffer = std::vector<uint8_t>();
															#line 704 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			totalBytesRead = 0;
															#line 705 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			buffer.resize(resultPart.size);
															#line 708 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (resultPart.offset < 0 || resultPart.size <= 0)
															#line 5168 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 709 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevError, "S3ClientDownloadPartInvalidRange") .detail("Offset", resultPart.offset) .detail("Size", resultPart.size);
															#line 712 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1loopBody1Catch1(http_bad_response(), loopDepth);
															#line 5174 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 715 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 5178 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 763 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			attempt++;
															#line 764 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (attempt >= maxRetries || !isRetryableError(e.code()))
															#line 5202 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 765 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientDownloadPartFailed") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("ErrorCode", e.code()) .detail("Attempts", attempt) .detail("FinalError", e.what());
															#line 772 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 5208 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 775 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevInfo, "S3ClientDownloadPartRetry") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Attempt", attempt) .detail("Error", e.what()) .detail("DelayMs", delayMs);
															#line 783 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(delayMs / 1000.0);
															#line 783 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<DownloadPartActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5216 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<DownloadPartActor*>(this)->actor_wait_state = 3;
															#line 783 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DownloadPartActor, 2, Void >*>(static_cast<DownloadPartActor*>(this)));
															#line 5221 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 731 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (totalBytesRead != resultPart.size)
															#line 5236 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 732 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientDownloadPartSizeMismatch") .detail("Expected", resultPart.size) .detail("Actual", totalBytesRead) .detail("Offset", resultPart.offset) .detail("FilePath", file->getFilename());
															#line 737 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), loopDepth);
															#line 5242 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 741 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!resultPart.checksum.empty())
															#line 5246 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 742 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string calculatedMD5 = HTTP::computeMD5Sum(std::string((char*)buffer.data(), totalBytesRead));
															#line 743 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (resultPart.checksum != calculatedMD5)
															#line 5252 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 744 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientDownloadPartChecksumMismatch") .detail("Expected", resultPart.checksum) .detail("Calculated", calculatedMD5);
															#line 747 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1loopBody1Catch1(checksum_failed(), loopDepth);
															#line 5258 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
		}
															#line 751 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_1 = file->write(buffer.data(), totalBytesRead, resultPart.offset);
															#line 751 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5265 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<DownloadPartActor*>(this)->actor_wait_state = 2;
															#line 751 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DownloadPartActor, 1, Void >*>(static_cast<DownloadPartActor*>(this)));
															#line 5270 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 715 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(totalBytesRead < resultPart.size))
															#line 5286 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 716 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<int> __when_expr_0 = endpoint->readObject(bucket, objectName, buffer.data() + totalBytesRead, resultPart.size - totalBytesRead, resultPart.offset + totalBytesRead);
															#line 716 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5294 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DownloadPartActor*>(this)->actor_wait_state = 1;
															#line 716 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DownloadPartActor, 0, int >*>(static_cast<DownloadPartActor*>(this)));
															#line 5299 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int const& bytesRead,int loopDepth) 
	{
															#line 721 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead == 0)
															#line 5321 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 723 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientDownloadPartUnexpectedEOF") .detail("Expected", resultPart.size) .detail("Actual", totalBytesRead);
															#line 726 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), std::max(0, loopDepth - 1));
															#line 5327 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 728 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		totalBytesRead += bytesRead;
															#line 5331 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int && bytesRead,int loopDepth) 
	{
															#line 721 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (bytesRead == 0)
															#line 5340 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 723 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientDownloadPartUnexpectedEOF") .detail("Expected", resultPart.size) .detail("Actual", totalBytesRead);
															#line 726 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(io_error(), std::max(0, loopDepth - 1));
															#line 5346 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 728 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		totalBytesRead += bytesRead;
															#line 5350 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state > 0) static_cast<DownloadPartActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadPartActor*>(this)->ActorCallback< DownloadPartActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DownloadPartActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 753 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 754 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientDownloadPartEnd") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size) .detail("Attempts", attempt + 1);
															#line 761 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DownloadPartActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~DownloadPartActorState(); static_cast<DownloadPartActor*>(this)->destroy(); return 0; }
															#line 5438 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<DownloadPartActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~DownloadPartActorState();
		static_cast<DownloadPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 753 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resultPart.completed = true;
															#line 754 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(SevDebug, "S3ClientDownloadPartEnd") .detail("Bucket", bucket) .detail("Object", objectName) .detail("PartNumber", part.partNumber) .detail("Offset", resultPart.offset) .detail("Size", resultPart.size) .detail("Attempts", attempt + 1);
															#line 761 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DownloadPartActor*>(this)->SAV<PartState>::futures) { (void)(resultPart); this->~DownloadPartActorState(); static_cast<DownloadPartActor*>(this)->destroy(); return 0; }
															#line 5454 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<DownloadPartActor*>(this)->SAV< PartState >::value()) PartState(std::move(resultPart)); // state_var_RVO
		this->~DownloadPartActorState();
		static_cast<DownloadPartActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state > 0) static_cast<DownloadPartActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadPartActor*>(this)->ActorCallback< DownloadPartActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DownloadPartActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 784 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		delayMs = std::min(delayMs * 2, config.maxRetryDelayMs);
															#line 5541 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 784 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		delayMs = std::min(delayMs * 2, config.maxRetryDelayMs);
															#line 5550 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DownloadPartActor*>(this)->actor_wait_state > 0) static_cast<DownloadPartActor*>(this)->actor_wait_state = 0;
		static_cast<DownloadPartActor*>(this)->ActorCallback< DownloadPartActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DownloadPartActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DownloadPartActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState part;
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 689 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartState resultPart;
															#line 690 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int attempt;
															#line 691 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxRetries;
															#line 692 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int delayMs;
															#line 703 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<uint8_t> buffer;
															#line 704 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t totalBytesRead;
															#line 5654 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via downloadPart()
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class DownloadPartActor final : public Actor<PartState>, public ActorCallback< DownloadPartActor, 0, int >, public ActorCallback< DownloadPartActor, 1, Void >, public ActorCallback< DownloadPartActor, 2, Void >, public FastAllocated<DownloadPartActor>, public DownloadPartActorState<DownloadPartActor> {
															#line 5659 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<DownloadPartActor>::operator new;
	using FastAllocated<DownloadPartActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9093234315727939072UL, 10557298075110574336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<PartState>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DownloadPartActor, 0, int >;
friend struct ActorCallback< DownloadPartActor, 1, Void >;
friend struct ActorCallback< DownloadPartActor, 2, Void >;
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	DownloadPartActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,Reference<IAsyncFile> const& file,PartState const& part,PartConfig const& config) 
															#line 5678 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<PartState>(),
		   DownloadPartActorState<DownloadPartActor>(endpoint, bucket, objectName, file, part, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("downloadPart", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7678294994590579968UL, 4572654359242003456UL);
		ActorExecutionContextHelper __helper(static_cast<DownloadPartActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("downloadPart");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("downloadPart", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DownloadPartActor, 0, int >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DownloadPartActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DownloadPartActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<PartState> downloadPart( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, Reference<IAsyncFile> const& file, PartState const& part, PartConfig const& config ) {
															#line 683 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<PartState>(new DownloadPartActor(endpoint, bucket, objectName, file, part, config));
															#line 5713 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 788 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 5718 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via getExpectedChecksum()
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class GetExpectedChecksumActor>
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class GetExpectedChecksumActorState {
															#line 5725 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	GetExpectedChecksumActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName) 
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName)
															#line 5736 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("getExpectedChecksum", reinterpret_cast<unsigned long>(this));

	}
	~GetExpectedChecksumActorState() 
	{
		fdb_probe_actor_destroy("getExpectedChecksum", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			PartConfig config;
															#line 793 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Optional<std::string>> __when_expr_0 = readChecksumWithFallback(endpoint, bucket, objectName, config);
															#line 793 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<GetExpectedChecksumActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5755 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetExpectedChecksumActor*>(this)->actor_wait_state = 1;
															#line 793 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*>(static_cast<GetExpectedChecksumActor*>(this)));
															#line 5760 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetExpectedChecksumActorState();
		static_cast<GetExpectedChecksumActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<std::string> const& result,int loopDepth) 
	{
															#line 794 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<GetExpectedChecksumActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~GetExpectedChecksumActorState(); static_cast<GetExpectedChecksumActor*>(this)->destroy(); return 0; }
															#line 5783 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<GetExpectedChecksumActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(result);
		this->~GetExpectedChecksumActorState();
		static_cast<GetExpectedChecksumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<std::string> && result,int loopDepth) 
	{
															#line 794 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<GetExpectedChecksumActor*>(this)->SAV<Optional<std::string>>::futures) { (void)(result); this->~GetExpectedChecksumActorState(); static_cast<GetExpectedChecksumActor*>(this)->destroy(); return 0; }
															#line 5795 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<GetExpectedChecksumActor*>(this)->SAV< Optional<std::string> >::value()) Optional<std::string>(result);
		this->~GetExpectedChecksumActorState();
		static_cast<GetExpectedChecksumActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<std::string> const& result,int loopDepth) 
	{
		loopDepth = a_body1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<std::string> && result,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetExpectedChecksumActor*>(this)->actor_wait_state > 0) static_cast<GetExpectedChecksumActor*>(this)->actor_wait_state = 0;
		static_cast<GetExpectedChecksumActor*>(this)->ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*,Optional<std::string> const& value) 
	{
		fdb_probe_actor_enter("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExpectedChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*,Optional<std::string> && value) 
	{
		fdb_probe_actor_enter("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetExpectedChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetExpectedChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getExpectedChecksum", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 5884 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via getExpectedChecksum()
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class GetExpectedChecksumActor final : public Actor<Optional<std::string>>, public ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >, public FastAllocated<GetExpectedChecksumActor>, public GetExpectedChecksumActorState<GetExpectedChecksumActor> {
															#line 5889 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<GetExpectedChecksumActor>::operator new;
	using FastAllocated<GetExpectedChecksumActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16395640558035967488UL, 652852050684202752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >;
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	GetExpectedChecksumActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName) 
															#line 5906 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Optional<std::string>>(),
		   GetExpectedChecksumActorState<GetExpectedChecksumActor>(endpoint, bucket, objectName),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getExpectedChecksum", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(871911475965399040UL, 1400255941565895168UL);
		ActorExecutionContextHelper __helper(static_cast<GetExpectedChecksumActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getExpectedChecksum");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getExpectedChecksum", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetExpectedChecksumActor, 0, Optional<std::string> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Optional<std::string>> getExpectedChecksum( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName ) {
															#line 789 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Optional<std::string>>(new GetExpectedChecksumActor(endpoint, bucket, objectName));
															#line 5939 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 796 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

// Copy down file from s3 to filepath.
															#line 5945 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyDownFile()
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyDownFileActor>
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActorState {
															#line 5952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActorState(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : endpoint(endpoint),
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   objectName(objectName),
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   filepath(filepath),
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   config(config),
															#line 803 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   startTime(now()),
															#line 804 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   file(),
															#line 805 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   parts(),
															#line 806 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   fileSize(0),
															#line 807 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   offset(0),
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   partNumber(1),
															#line 809 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   partSize(),
															#line 810 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   expectedChecksum(),
															#line 811 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   retries(0),
															#line 812 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxConcurrentDownloads(),
															#line 813 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   activeDownloadFutures(),
															#line 814 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   activePartIndices()
															#line 5991 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyDownFileActorState() 
	{
		fdb_probe_actor_destroy("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 816 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			;
															#line 6006 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyDownFileActorState();
		static_cast<CopyDownFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 974 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownFileActorState(); static_cast<CopyDownFileActor*>(this)->destroy(); return 0; }
															#line 6029 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyDownFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownFileActorState();
		static_cast<CopyDownFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 818 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(s3VerboseEventSev(), "S3ClientCopyDownFileStart") .detail("Bucket", bucket) .detail("Object", objectName) .detail("FilePath", filepath) .detail("Attempt", retries);
															#line 824 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = endpoint->objectSize(bucket, objectName);
															#line 824 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6053 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 1;
															#line 824 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 0, int64_t >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6058 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 919 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if ((e.code() == error_code_file_not_found || e.code() == error_code_http_request_failed || e.code() == error_code_io_error) && retries < config.maxFileRetries)
															#line 6093 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 922 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientCopyDownFileRetry") .errorUnsuppressed(e) .detail("Bucket", bucket) .detail("Object", objectName) .detail("FilePath", filepath) .detail("Retries", retries);
															#line 928 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				retries++;
															#line 931 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				parts.clear();
															#line 932 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				activeDownloadFutures.clear();
															#line 933 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				activePartIndices.clear();
															#line 935 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (file)
															#line 6107 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
					try {
															#line 937 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						file = Reference<IAsyncFile>();
															#line 938 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						IAsyncFileSystem::filesystem()->deleteFile(filepath, true);
															#line 6114 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						loopDepth = a_body1loopBody1Catch1cont5(loopDepth);
					}
					catch (Error& error) {
						loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont2(loopDepth);
				}
			}
			else
			{
															#line 951 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				err = e;
															#line 952 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarnAlways, "S3ClientCopyDownFileError") .detail("Bucket", bucket) .detail("ObjectName", objectName) .errorUnsuppressed(err) .detail("FilePath", filepath) .detail("FileSize", fileSize);
															#line 959 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (file)
															#line 6136 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
					try {
															#line 961 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						StrictFuture<Void> __when_expr_11 = file->sync();
															#line 961 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch2(actor_cancelled(), loopDepth);
															#line 6143 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1loopBody1Catch1Catch2(__when_expr_11.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_11.get(), loopDepth); };
						static_cast<CopyDownFileActor*>(this)->actor_wait_state = 12;
															#line 961 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 11, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6148 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						loopDepth = 0;
					}
					catch (Error& error) {
						loopDepth = a_body1loopBody1Catch1Catch2(error, loopDepth);
					} catch (...) {
						loopDepth = a_body1loopBody1Catch1Catch2(unknown_error(), loopDepth);
					}
				}
				else
				{
					loopDepth = a_body1loopBody1Catch1cont10(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int64_t const& s,int loopDepth) 
	{
															#line 825 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (s <= 0)
															#line 6175 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 826 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileEmptyFile") .detail("Bucket", bucket) .detail("Object", objectName);
															#line 829 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(file_not_found(), loopDepth);
															#line 6181 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 831 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		fileSize = s;
															#line 833 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string dirPath = filepath.substr(0, filepath.find_last_of("/"));
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!dirPath.empty())
															#line 6189 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 835 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			platform::createDirectory(dirPath);
															#line 6193 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 838 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		int numParts = (fileSize + config.partSizeBytes - 1) / config.partSizeBytes;
															#line 839 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.reserve(numParts);
															#line 840 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open( filepath, IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_NO_AIO, 0644);
															#line 840 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6203 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 2;
															#line 840 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6208 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(int64_t && s,int loopDepth) 
	{
															#line 825 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (s <= 0)
															#line 6217 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 826 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileEmptyFile") .detail("Bucket", bucket) .detail("Object", objectName);
															#line 829 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(file_not_found(), loopDepth);
															#line 6223 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 831 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		fileSize = s;
															#line 833 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::string dirPath = filepath.substr(0, filepath.find_last_of("/"));
															#line 834 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!dirPath.empty())
															#line 6231 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 835 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			platform::createDirectory(dirPath);
															#line 6235 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 838 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		int numParts = (fileSize + config.partSizeBytes - 1) / config.partSizeBytes;
															#line 839 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		parts.reserve(numParts);
															#line 840 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<IAsyncFile>> __when_expr_1 = IAsyncFileSystem::filesystem()->open( filepath, IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_NO_AIO, 0644);
															#line 840 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6245 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 2;
															#line 840 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6250 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t const& s,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(s, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t && s,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(s), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Reference<IAsyncFile> const& f,int loopDepth) 
	{
															#line 845 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 847 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->truncate(fileSize);
															#line 847 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6338 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 3;
															#line 847 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 2, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6343 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Reference<IAsyncFile> && f,int loopDepth) 
	{
															#line 845 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = f;
															#line 847 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->truncate(fileSize);
															#line 847 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6356 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 3;
															#line 847 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 2, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6361 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<IAsyncFile> const& f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(f, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Reference<IAsyncFile> && f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 848 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_3 = file->truncate(fileSize);
															#line 848 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6447 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 4;
															#line 848 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 3, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6452 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 848 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_3 = file->truncate(fileSize);
															#line 848 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6463 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_3.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 4;
															#line 848 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 3, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6468 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 850 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		offset = 0;
															#line 851 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber = 1;
															#line 852 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		maxConcurrentDownloads = CLIENT_KNOBS->BLOBSTORE_CONCURRENT_READS_PER_FILE;
															#line 853 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeDownloadFutures.clear();
															#line 854 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 857 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 6562 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 850 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		offset = 0;
															#line 851 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		partNumber = 1;
															#line 852 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		maxConcurrentDownloads = CLIENT_KNOBS->BLOBSTORE_CONCURRENT_READS_PER_FILE;
															#line 853 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeDownloadFutures.clear();
															#line 854 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 857 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		;
															#line 6581 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
															#line 883 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& part : parts ) {
															#line 884 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!part.completed)
															#line 6667 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 885 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevError, "S3ClientCopyDownFilePartNotCompleted").detail("PartNumber", part.partNumber);
															#line 886 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1loopBody1Catch1(http_bad_response(), loopDepth);
															#line 6673 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
		}
															#line 890 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_5 = file->truncate(fileSize);
															#line 890 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6680 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont8when1(__when_expr_5.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 6;
															#line 890 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 5, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6685 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont7loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1(int loopDepth) 
	{
															#line 857 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(offset < fileSize))
															#line 6701 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1loopBody1cont7break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 859 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for(;activeDownloadFutures.size() < maxConcurrentDownloads && offset < fileSize;) {
															#line 860 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partSize = std::min(config.partSizeBytes, fileSize - offset);
															#line 861 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			parts.emplace_back(partNumber, offset, partSize, "");
															#line 862 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			activeDownloadFutures.push_back( downloadPart(endpoint, bucket, objectName, file, parts.back(), config));
															#line 864 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			activePartIndices.push_back(partNumber - 1);
															#line 865 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			offset += partSize;
															#line 866 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			partNumber++;
															#line 6719 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 870 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!activeDownloadFutures.empty())
															#line 6723 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 871 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::vector<PartState>> __when_expr_4 = getAll(activeDownloadFutures);
															#line 871 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6729 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont7loopBody1when1(__when_expr_4.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 5;
															#line 871 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6734 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont7loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont7loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1cont4(std::vector<PartState> const& completedParts,int loopDepth) 
	{
															#line 873 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for(int i = 0;i < completedParts.size();i++) {
															#line 874 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			parts[activePartIndices[i]] = completedParts[i];
															#line 6769 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 877 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeDownloadFutures.clear();
															#line 878 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 6775 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1cont4(std::vector<PartState> && completedParts,int loopDepth) 
	{
															#line 873 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for(int i = 0;i < completedParts.size();i++) {
															#line 874 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			parts[activePartIndices[i]] = completedParts[i];
															#line 6786 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 877 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activeDownloadFutures.clear();
															#line 878 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		activePartIndices.clear();
															#line 6792 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont7loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1when1(std::vector<PartState> const& completedParts,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7loopBody1cont4(completedParts, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7loopBody1when1(std::vector<PartState> && completedParts,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7loopBody1cont4(std::move(completedParts), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*,std::vector<PartState> const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*,std::vector<PartState> && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont7loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
															#line 891 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_6 = file->sync();
															#line 891 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6878 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 7;
															#line 891 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 6, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6883 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
															#line 891 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_6 = file->sync();
															#line 891 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont9when1(__when_expr_6.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 7;
															#line 891 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 6, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont12(Void const& _,int loopDepth) 
	{
															#line 894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Optional<std::string>> __when_expr_7 = getExpectedChecksum(endpoint, bucket, objectName);
															#line 894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6985 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont12when1(__when_expr_7.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 8;
															#line 894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 6990 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void && _,int loopDepth) 
	{
															#line 894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Optional<std::string>> __when_expr_7 = getExpectedChecksum(endpoint, bucket, objectName);
															#line 894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7001 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont12when1(__when_expr_7.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 8;
															#line 894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7006 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont12cont1(Optional<std::string> const& cs,int loopDepth) 
	{
															#line 896 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (cs.present())
															#line 7090 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 897 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			expectedChecksum = cs.get();
															#line 898 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::string> __when_expr_8 = calculateFileChecksum(file, fileSize);
															#line 898 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7098 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont12cont1when1(__when_expr_8.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 9;
															#line 898 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 8, std::string >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7103 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont12cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont12cont1(Optional<std::string> && cs,int loopDepth) 
	{
															#line 896 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (cs.present())
															#line 7117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 897 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			expectedChecksum = cs.get();
															#line 898 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<std::string> __when_expr_8 = calculateFileChecksum(file, fileSize);
															#line 898 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7125 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1loopBody1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1loopBody1cont12cont1when1(__when_expr_8.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 9;
															#line 898 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 8, std::string >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7130 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont12cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont12when1(Optional<std::string> const& cs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12cont1(cs, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12when1(Optional<std::string> && cs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12cont1(std::move(cs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 7, Optional<std::string> >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*,Optional<std::string> const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*,Optional<std::string> && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1cont12cont2(int loopDepth) 
	{
															#line 907 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 909 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientCopyDownFileEnd") .detail("Bucket", bucket) .detail("ObjectName", objectName) .detail("FileSize", fileSize) .detail("Duration", now() - startTime) .detail("Checksum", expectedChecksum) .detail("Parts", parts.size());
															#line 7221 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont12cont3(int loopDepth) 
	{
															#line 899 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (actualChecksum != expectedChecksum)
															#line 7230 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 900 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileChecksumMismatch") .detail("Expected", expectedChecksum) .detail("Calculated", actualChecksum);
															#line 903 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1loopBody1Catch1(checksum_failed(), loopDepth);
															#line 7236 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12cont1when1(std::string const& __actualChecksum,int loopDepth) 
	{
															#line 898 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		actualChecksum = __actualChecksum;
															#line 7246 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12cont1when1(std::string && __actualChecksum,int loopDepth) 
	{
		actualChecksum = std::move(__actualChecksum);
		loopDepth = a_body1loopBody1cont12cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 8, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 8, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 8, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 8, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(int loopDepth) 
	{
															#line 945 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (g_network->isSimulated())
															#line 7331 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 946 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_9 = delay(0);
															#line 946 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7337 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont2when1(__when_expr_9.get(), loopDepth); };
			static_cast<CopyDownFileActor*>(this)->actor_wait_state = 10;
															#line 946 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 9, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7342 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1Catch1cont6(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont3(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& cleanupError,int loopDepth=0) 
	{
		try {
															#line 940 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileCleanupError") .detail("FilePath", filepath) .errorUnsuppressed(cleanupError);
															#line 7363 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopBody1Catch1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6(int loopDepth) 
	{
															#line 949 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Void> __when_expr_10 = delay(1.0 * retries);
															#line 949 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7393 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1cont6when1(__when_expr_10.get(), loopDepth); };
		static_cast<CopyDownFileActor*>(this)->actor_wait_state = 11;
															#line 949 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor, 10, Void >*>(static_cast<CopyDownFileActor*>(this)));
															#line 7398 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(Void const& _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont7(Void && _,int loopDepth) 
	{
		return a_body1loopHead1(loopDepth); // continue

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1loopBody1Catch1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1loopBody1Catch1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1loopBody1Catch1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1loopBody1Catch1cont10(int loopDepth) 
	{
															#line 970 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		return a_body1Catch1(err, std::max(0, loopDepth - 1));
															#line 7581 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont11(int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch2(const Error& e2,int loopDepth=0) 
	{
		try {
															#line 965 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarnAlways, "S3ClientCopyDownFileCleanupError") .detail("FilePath", filepath) .errorUnsuppressed(e2);
															#line 7596 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = a_body1loopBody1Catch1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont12(Void const& _,int loopDepth) 
	{
															#line 962 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 963 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		IAsyncFileSystem::filesystem()->deleteFile(filepath, false);
															#line 7613 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont12(Void && _,int loopDepth) 
	{
															#line 962 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		file = Reference<IAsyncFile>();
															#line 963 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		IAsyncFileSystem::filesystem()->deleteFile(filepath, false);
															#line 7624 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1loopBody1Catch1cont12cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<CopyDownFileActor*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor*>(this)->ActorCallback< CopyDownFileActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1loopBody1Catch1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1loopBody1Catch1cont12cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string objectName;
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	PartConfig config;
															#line 803 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	double startTime;
															#line 804 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<IAsyncFile> file;
															#line 805 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<PartState> parts;
															#line 806 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t fileSize;
															#line 807 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t offset;
															#line 808 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int partNumber;
															#line 809 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int64_t partSize;
															#line 810 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string expectedChecksum;
															#line 811 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int retries;
															#line 812 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxConcurrentDownloads;
															#line 813 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<Future<PartState>> activeDownloadFutures;
															#line 814 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<int> activePartIndices;
															#line 898 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string actualChecksum;
															#line 951 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Error err;
															#line 7755 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyDownFile()
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActor final : public Actor<Void>, public ActorCallback< CopyDownFileActor, 0, int64_t >, public ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >, public ActorCallback< CopyDownFileActor, 2, Void >, public ActorCallback< CopyDownFileActor, 3, Void >, public ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >, public ActorCallback< CopyDownFileActor, 5, Void >, public ActorCallback< CopyDownFileActor, 6, Void >, public ActorCallback< CopyDownFileActor, 7, Optional<std::string> >, public ActorCallback< CopyDownFileActor, 8, std::string >, public ActorCallback< CopyDownFileActor, 9, Void >, public ActorCallback< CopyDownFileActor, 10, Void >, public ActorCallback< CopyDownFileActor, 11, Void >, public FastAllocated<CopyDownFileActor>, public CopyDownFileActorState<CopyDownFileActor> {
															#line 7760 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyDownFileActor>::operator new;
	using FastAllocated<CopyDownFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17115150216919271168UL, 13065632040032972800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyDownFileActor, 0, int64_t >;
friend struct ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >;
friend struct ActorCallback< CopyDownFileActor, 2, Void >;
friend struct ActorCallback< CopyDownFileActor, 3, Void >;
friend struct ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >;
friend struct ActorCallback< CopyDownFileActor, 5, Void >;
friend struct ActorCallback< CopyDownFileActor, 6, Void >;
friend struct ActorCallback< CopyDownFileActor, 7, Optional<std::string> >;
friend struct ActorCallback< CopyDownFileActor, 8, std::string >;
friend struct ActorCallback< CopyDownFileActor, 9, Void >;
friend struct ActorCallback< CopyDownFileActor, 10, Void >;
friend struct ActorCallback< CopyDownFileActor, 11, Void >;
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActor(Reference<S3BlobStoreEndpoint> const& endpoint,std::string const& bucket,std::string const& objectName,std::string const& filepath,PartConfig const& config = PartConfig()) 
															#line 7788 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyDownFileActorState<CopyDownFileActor>(endpoint, bucket, objectName, filepath, config),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7359276511881238784UL, 3382961653916387328UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyDownFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyDownFileActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyDownFileActor, 1, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CopyDownFileActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CopyDownFileActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CopyDownFileActor, 4, std::vector<PartState> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CopyDownFileActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CopyDownFileActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CopyDownFileActor, 7, Optional<std::string> >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CopyDownFileActor, 8, std::string >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CopyDownFileActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< CopyDownFileActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< CopyDownFileActor, 11, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] static Future<Void> copyDownFile( Reference<S3BlobStoreEndpoint> const& endpoint, std::string const& bucket, std::string const& objectName, std::string const& filepath, PartConfig const& config = PartConfig() ) {
															#line 798 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyDownFileActor(endpoint, bucket, objectName, filepath, config));
															#line 7832 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 976 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 7837 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyDownFile()
															#line 977 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyDownFileActor1>
															#line 977 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActor1State {
															#line 7844 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 977 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActor1State(std::string const& s3url,std::string const& filepath) 
															#line 977 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 977 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 977 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   filepath(filepath)
															#line 7853 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	~CopyDownFileActor1State() 
	{
		fdb_probe_actor_destroy("copyDownFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 978 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string resource;
															#line 979 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 980 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			Reference<S3BlobStoreEndpoint> endpoint = getEndpoint(s3url, resource, parameters);
															#line 981 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = copyDownFile(endpoint, parameters["bucket"], resource, filepath);
															#line 981 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownFileActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7876 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyDownFileActor1*>(this)->actor_wait_state = 1;
															#line 981 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyDownFileActor1, 0, Void >*>(static_cast<CopyDownFileActor1*>(this)));
															#line 7881 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyDownFileActor1State();
		static_cast<CopyDownFileActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 982 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownFileActor1State(); static_cast<CopyDownFileActor1*>(this)->destroy(); return 0; }
															#line 7904 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyDownFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownFileActor1State();
		static_cast<CopyDownFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 982 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownFileActor1*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownFileActor1State(); static_cast<CopyDownFileActor1*>(this)->destroy(); return 0; }
															#line 7916 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyDownFileActor1*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownFileActor1State();
		static_cast<CopyDownFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyDownFileActor1*>(this)->actor_wait_state > 0) static_cast<CopyDownFileActor1*>(this)->actor_wait_state = 0;
		static_cast<CopyDownFileActor1*>(this)->ActorCallback< CopyDownFileActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyDownFileActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyDownFileActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 977 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 977 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string filepath;
															#line 8003 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyDownFile()
															#line 977 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownFileActor1 final : public Actor<Void>, public ActorCallback< CopyDownFileActor1, 0, Void >, public FastAllocated<CopyDownFileActor1>, public CopyDownFileActor1State<CopyDownFileActor1> {
															#line 8008 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyDownFileActor1>::operator new;
	using FastAllocated<CopyDownFileActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17115150216919271168UL, 13065632040032972800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyDownFileActor1, 0, Void >;
															#line 977 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownFileActor1(std::string const& s3url,std::string const& filepath) 
															#line 8025 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyDownFileActor1State<CopyDownFileActor1>(s3url, filepath),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyDownFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17010639406587595520UL, 2888716185831900672UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyDownFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyDownFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyDownFileActor1, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 977 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyDownFile( std::string const& s3url, std::string const& filepath ) {
															#line 977 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyDownFileActor1(s3url, filepath));
															#line 8058 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 984 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 8063 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via copyDownDirectory()
															#line 985 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class CopyDownDirectoryActor>
															#line 985 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownDirectoryActorState {
															#line 8070 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 985 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownDirectoryActorState(std::string const& s3url,std::string const& dirpath) 
															#line 985 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 985 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 985 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   dirpath(dirpath),
															#line 986 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 8081 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("copyDownDirectory", reinterpret_cast<unsigned long>(this));

	}
	~CopyDownDirectoryActorState() 
	{
		fdb_probe_actor_destroy("copyDownDirectory", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 987 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			endpoint = getEndpoint(s3url, resource, parameters);
															#line 989 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 990 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<S3BlobStoreEndpoint::ListResult> __when_expr_0 = endpoint->listObjects(bucket, resource);
															#line 990 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8104 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 1;
															#line 990 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*>(static_cast<CopyDownDirectoryActor*>(this)));
															#line 8109 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CopyDownDirectoryActorState();
		static_cast<CopyDownDirectoryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(S3BlobStoreEndpoint::ListResult const& items,int loopDepth) 
	{
															#line 991 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		objects = items.objects;
															#line 992 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientDownDirectoryStart") .detail("Filecount", objects.size()) .detail("Bucket", bucket) .detail("Resource", resource);
															#line 996 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(objects);
															#line 8136 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(S3BlobStoreEndpoint::ListResult && items,int loopDepth) 
	{
															#line 991 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		objects = items.objects;
															#line 992 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientDownDirectoryStart") .detail("Filecount", objects.size()) .detail("Bucket", bucket) .detail("Resource", resource);
															#line 996 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(objects);
															#line 8149 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(S3BlobStoreEndpoint::ListResult const& items,int loopDepth) 
	{
		loopDepth = a_body1cont1(items, loopDepth);

		return loopDepth;
	}
	int a_body1when1(S3BlobStoreEndpoint::ListResult && items,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(items), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state > 0) static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownDirectoryActor*>(this)->ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult const& value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult && value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1001 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		TraceEvent(s3VerboseEventSev(), "S3ClientDownDirectoryEnd").detail("Bucket", bucket).detail("Resource", resource);
															#line 1002 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<CopyDownDirectoryActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CopyDownDirectoryActorState(); static_cast<CopyDownDirectoryActor*>(this)->destroy(); return 0; }
															#line 8235 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<CopyDownDirectoryActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CopyDownDirectoryActorState();
		static_cast<CopyDownDirectoryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 996 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!(RangeForbody1cont1Iterator0 != std::end(objects)))
															#line 8254 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 996 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		const auto& object = *RangeForbody1cont1Iterator0;
															#line 8260 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 997 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string filepath = dirpath + "/" + object.name.substr(resource.size());
															#line 998 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string s3path = object.name;
															#line 999 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_1 = copyDownFile(endpoint, bucket, s3path, filepath);
															#line 999 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 8270 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 2;
															#line 999 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CopyDownDirectoryActor, 1, Void >*>(static_cast<CopyDownDirectoryActor*>(this)));
															#line 8275 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 996 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		++RangeForbody1cont1Iterator0;
															#line 8298 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state > 0) static_cast<CopyDownDirectoryActor*>(this)->actor_wait_state = 0;
		static_cast<CopyDownDirectoryActor*>(this)->ActorCallback< CopyDownDirectoryActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CopyDownDirectoryActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CopyDownDirectoryActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 985 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 985 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string dirpath;
															#line 986 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 988 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> endpoint;
															#line 989 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 991 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::vector<S3BlobStoreEndpoint::ObjectInfo> objects;
															#line 996 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	decltype(std::begin(std::declval<std::vector<S3BlobStoreEndpoint::ObjectInfo>>())) RangeForbody1cont1Iterator0;
															#line 8404 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via copyDownDirectory()
															#line 985 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class CopyDownDirectoryActor final : public Actor<Void>, public ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >, public ActorCallback< CopyDownDirectoryActor, 1, Void >, public FastAllocated<CopyDownDirectoryActor>, public CopyDownDirectoryActorState<CopyDownDirectoryActor> {
															#line 8409 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<CopyDownDirectoryActor>::operator new;
	using FastAllocated<CopyDownDirectoryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5717814400730171392UL, 326181438806639872UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >;
friend struct ActorCallback< CopyDownDirectoryActor, 1, Void >;
															#line 985 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	CopyDownDirectoryActor(std::string const& s3url,std::string const& dirpath) 
															#line 8427 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   CopyDownDirectoryActorState<CopyDownDirectoryActor>(s3url, dirpath),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("copyDownDirectory", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10236592472061799424UL, 16660351427764155904UL);
		ActorExecutionContextHelper __helper(static_cast<CopyDownDirectoryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("copyDownDirectory");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("copyDownDirectory", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CopyDownDirectoryActor, 0, S3BlobStoreEndpoint::ListResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CopyDownDirectoryActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 985 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> copyDownDirectory( std::string const& s3url, std::string const& dirpath ) {
															#line 985 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new CopyDownDirectoryActor(s3url, dirpath));
															#line 8461 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 1004 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 8466 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via deleteResource()
															#line 1005 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class DeleteResourceActor>
															#line 1005 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class DeleteResourceActorState {
															#line 8473 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 1005 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	DeleteResourceActorState(std::string const& s3url) 
															#line 1005 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 1005 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 1006 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   resource()
															#line 8482 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("deleteResource", reinterpret_cast<unsigned long>(this));

	}
	~DeleteResourceActorState() 
	{
		fdb_probe_actor_destroy("deleteResource", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1007 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			S3BlobStoreEndpoint::ParametersT parameters;
															#line 1008 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			Reference<S3BlobStoreEndpoint> endpoint = getEndpoint(s3url, resource, parameters);
															#line 1009 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bucket = parameters["bucket"];
															#line 1010 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = endpoint->deleteRecursively(bucket, resource);
															#line 1010 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<DeleteResourceActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8505 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DeleteResourceActor*>(this)->actor_wait_state = 1;
															#line 1010 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DeleteResourceActor, 0, Void >*>(static_cast<DeleteResourceActor*>(this)));
															#line 8510 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DeleteResourceActorState();
		static_cast<DeleteResourceActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1011 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DeleteResourceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteResourceActorState(); static_cast<DeleteResourceActor*>(this)->destroy(); return 0; }
															#line 8533 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<DeleteResourceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteResourceActorState();
		static_cast<DeleteResourceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1011 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<DeleteResourceActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DeleteResourceActorState(); static_cast<DeleteResourceActor*>(this)->destroy(); return 0; }
															#line 8545 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<DeleteResourceActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DeleteResourceActorState();
		static_cast<DeleteResourceActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DeleteResourceActor*>(this)->actor_wait_state > 0) static_cast<DeleteResourceActor*>(this)->actor_wait_state = 0;
		static_cast<DeleteResourceActor*>(this)->ActorCallback< DeleteResourceActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DeleteResourceActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DeleteResourceActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DeleteResourceActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1005 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 1006 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 1009 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 8634 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via deleteResource()
															#line 1005 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class DeleteResourceActor final : public Actor<Void>, public ActorCallback< DeleteResourceActor, 0, Void >, public FastAllocated<DeleteResourceActor>, public DeleteResourceActorState<DeleteResourceActor> {
															#line 8639 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<DeleteResourceActor>::operator new;
	using FastAllocated<DeleteResourceActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(809037821219987456UL, 15350238297113580032UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DeleteResourceActor, 0, Void >;
															#line 1005 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	DeleteResourceActor(std::string const& s3url) 
															#line 8656 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   DeleteResourceActorState<DeleteResourceActor>(s3url),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("deleteResource", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14827851668417892864UL, 17501710632754782464UL);
		ActorExecutionContextHelper __helper(static_cast<DeleteResourceActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("deleteResource");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("deleteResource", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DeleteResourceActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1005 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> deleteResource( std::string const& s3url ) {
															#line 1005 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new DeleteResourceActor(s3url));
															#line 8689 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 1013 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 8694 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via listFiles()
															#line 1014 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class ListFilesActor>
															#line 1014 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFilesActorState {
															#line 8701 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 1014 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFilesActorState(std::string const& s3url,int const& maxDepth) 
															#line 1014 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 1014 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : s3url(s3url),
															#line 1014 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   maxDepth(maxDepth)
															#line 8710 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("listFiles", reinterpret_cast<unsigned long>(this));

	}
	~ListFilesActorState() 
	{
		fdb_probe_actor_destroy("listFiles", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1016 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				resource = std::string();
															#line 1017 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				error = std::string();
															#line 1018 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				parameters = S3BlobStoreEndpoint::ParametersT();
															#line 1019 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				bstore = getEndpoint(s3url, resource, parameters);
															#line 1021 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (!bstore)
															#line 8734 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 1022 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					TraceEvent(SevError, "S3ClientListingFailed").detail("Error", error);
															#line 1023 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					return a_body1Catch2(backup_invalid_url(), loopDepth);
															#line 8740 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
															#line 1027 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				bucket = parameters["bucket"];
															#line 1030 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				StrictFuture<bool> __when_expr_0 = bstore->bucketExists(bucket);
															#line 1030 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (static_cast<ListFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8748 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ListFilesActor*>(this)->actor_wait_state = 1;
															#line 1030 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListFilesActor, 0, bool >*>(static_cast<ListFilesActor*>(this)));
															#line 8753 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListFilesActorState();
		static_cast<ListFilesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1114 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!static_cast<ListFilesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListFilesActorState(); static_cast<ListFilesActor*>(this)->destroy(); return 0; }
															#line 8782 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		new (&static_cast<ListFilesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListFilesActorState();
		static_cast<ListFilesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1092 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevError, "S3ClientListFilesError").detail("URL", s3url).detail("Error", e.what());
															#line 1093 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (e.code() == error_code_backup_invalid_url)
															#line 8797 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 1094 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				std::cerr << "ERROR: Invalid blobstore URL: " << s3url << std::endl;
															#line 8801 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
			else
			{
															#line 1095 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (e.code() == error_code_backup_auth_missing)
															#line 8807 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 1096 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					std::cerr << "ERROR: Authentication information missing from URL" << std::endl;
															#line 8811 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
				else
				{
															#line 1097 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (e.code() == error_code_backup_auth_unreadable)
															#line 8817 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 1098 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						std::cerr << "ERROR: Could not read authentication information" << std::endl;
															#line 8821 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
					else
					{
															#line 1099 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						if (e.code() == error_code_http_request_failed)
															#line 8827 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						{
															#line 1101 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
							if (e.what() && strstr(e.what(), "NoSuchBucket") != nullptr)
															#line 8831 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
							{
															#line 1102 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
								std::cerr << "ERROR: Bucket does not exist" << std::endl;
															#line 8835 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
							}
							else
							{
															#line 1103 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
								if (e.what() && strstr(e.what(), "NoSuchKey") != nullptr)
															#line 8841 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
								{
															#line 1104 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
									std::cerr << "ERROR: Resource does not exist in bucket" << std::endl;
															#line 1105 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
									return a_body1Catch1(resource_not_found(), loopDepth);
															#line 8847 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
								}
								else
								{
															#line 1107 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
									std::cerr << "ERROR: HTTP request to blobstore failed" << std::endl;
															#line 8853 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
								}
							}
						}
						else
						{
															#line 1110 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
							std::cerr << "ERROR: " << e.what() << std::endl;
															#line 8861 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
						}
					}
				}
			}
															#line 1112 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 8868 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(bool const& exists,int loopDepth) 
	{
															#line 1031 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!exists)
															#line 8882 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 1032 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::cerr << "ERROR: Bucket '" << bucket << "' does not exist" << std::endl;
															#line 1033 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(http_request_failed(), loopDepth);
															#line 8888 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		delimiter = Optional<char>();
															#line 1038 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (maxDepth <= 1)
															#line 8894 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 1039 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			delimiter = Optional<char>('/');
															#line 8898 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 1043 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<S3BlobStoreEndpoint::ListResult> __when_expr_1 = bstore->listObjects(bucket, resource, delimiter, maxDepth);
															#line 1043 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8904 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFilesActor*>(this)->actor_wait_state = 2;
															#line 1043 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*>(static_cast<ListFilesActor*>(this)));
															#line 8909 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(bool && exists,int loopDepth) 
	{
															#line 1031 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (!exists)
															#line 8918 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 1032 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::cerr << "ERROR: Bucket '" << bucket << "' does not exist" << std::endl;
															#line 1033 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch2(http_request_failed(), loopDepth);
															#line 8924 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		delimiter = Optional<char>();
															#line 1038 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (maxDepth <= 1)
															#line 8930 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 1039 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			delimiter = Optional<char>('/');
															#line 8934 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 1043 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<S3BlobStoreEndpoint::ListResult> __when_expr_1 = bstore->listObjects(bucket, resource, delimiter, maxDepth);
															#line 1043 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8940 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFilesActor*>(this)->actor_wait_state = 2;
															#line 1043 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*>(static_cast<ListFilesActor*>(this)));
															#line 8945 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(bool const& exists,int loopDepth) 
	{
		loopDepth = a_body1cont2(exists, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && exists,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(exists), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListFilesActor*>(this)->actor_wait_state > 0) static_cast<ListFilesActor*>(this)->actor_wait_state = 0;
		static_cast<ListFilesActor*>(this)->ActorCallback< ListFilesActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListFilesActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1046 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::cout << "Contents of " << s3url << ":" << std::endl;
															#line 1049 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		std::set<std::string> directories;
															#line 1052 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		auto formatSize = [](int64_t size) -> std::string { const char* units[] = { "B", "KB", "MB", "GB", "TB", "PB" }; int unit = 0; double value = static_cast<double>(size); while (value >= 1024.0 && unit < 5) { value /= 1024.0; unit++; } char buffer[32]; snprintf(buffer, sizeof(buffer), "%.2f %s", value, units[unit]); return std::string(buffer); };
															#line 1066 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& prefix : result.commonPrefixes ) {
															#line 1067 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string dirName = prefix;
															#line 1069 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!dirName.empty() && dirName.back() == '/')
															#line 9039 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 1070 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				dirName.pop_back();
															#line 9043 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 1072 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			directories.insert(dirName);
															#line 1073 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::cout << "  " << dirName << "/" << std::endl;
															#line 9049 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
															#line 1077 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		for( const auto& object : result.objects ) {
															#line 1078 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string objectName = object.name;
															#line 1080 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			bool skip = false;
															#line 1081 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			for( const auto& dir : directories ) {
															#line 1082 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (objectName.find(dir + "/") == 0)
															#line 9061 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 1083 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					skip = true;
															#line 9065 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					break;
				}
			}
															#line 1087 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!skip)
															#line 9071 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 1088 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				std::cout << " " << objectName << " " << formatSize(object.size) << std::endl;
															#line 9075 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(S3BlobStoreEndpoint::ListResult const& __result,int loopDepth) 
	{
															#line 1043 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		result = __result;
															#line 9086 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(S3BlobStoreEndpoint::ListResult && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListFilesActor*>(this)->actor_wait_state > 0) static_cast<ListFilesActor*>(this)->actor_wait_state = 0;
		static_cast<ListFilesActor*>(this)->ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >::remove();

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult const& value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*,S3BlobStoreEndpoint::ListResult && value) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont14(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1014 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string s3url;
															#line 1014 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	int maxDepth;
															#line 1016 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 1017 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string error;
															#line 1018 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	S3BlobStoreEndpoint::ParametersT parameters;
															#line 1019 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> bstore;
															#line 1027 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 1037 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Optional<char> delimiter;
															#line 1043 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	S3BlobStoreEndpoint::ListResult result;
															#line 9192 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via listFiles()
															#line 1014 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFilesActor final : public Actor<Void>, public ActorCallback< ListFilesActor, 0, bool >, public ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >, public FastAllocated<ListFilesActor>, public ListFilesActorState<ListFilesActor> {
															#line 9197 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<ListFilesActor>::operator new;
	using FastAllocated<ListFilesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2024065738060215808UL, 6208488292947777792UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListFilesActor, 0, bool >;
friend struct ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >;
															#line 1014 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFilesActor(std::string const& s3url,int const& maxDepth) 
															#line 9215 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<Void>(),
		   ListFilesActorState<ListFilesActor>(s3url, maxDepth),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listFiles", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7548829570599198464UL, 17955669203805414144UL);
		ActorExecutionContextHelper __helper(static_cast<ListFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listFiles");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listFiles", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListFilesActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListFilesActor, 1, S3BlobStoreEndpoint::ListResult >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1014 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<Void> listFiles( std::string const& s3url, int const& maxDepth ) {
															#line 1014 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<Void>(new ListFilesActor(s3url, maxDepth));
															#line 9249 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 1116 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"

															#line 9254 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
namespace {
// This generated class is to be used only via listFiles_impl()
															#line 1117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
template <class ListFiles_implActor>
															#line 1117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFiles_implActorState {
															#line 9261 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
															#line 1117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFiles_implActorState(Reference<S3BlobStoreEndpoint> const& bstore,std::string const& bucket,std::string const& path) 
															#line 1117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
															#line 1117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		 : bstore(bstore),
															#line 1117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   bucket(bucket),
															#line 1117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		   path(path)
															#line 9272 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
	{
		fdb_probe_actor_create("listFiles_impl", reinterpret_cast<unsigned long>(this));

	}
	~ListFiles_implActorState() 
	{
		fdb_probe_actor_destroy("listFiles_impl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1120 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			StrictFuture<Void> __when_expr_0 = bstore->requestRateRead->getAllowance(1);
															#line 1120 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (static_cast<ListFiles_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9289 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListFiles_implActor*>(this)->actor_wait_state = 1;
															#line 1120 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListFiles_implActor, 0, Void >*>(static_cast<ListFiles_implActor*>(this)));
															#line 9294 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListFiles_implActorState();
		static_cast<ListFiles_implActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1122 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resource = bstore->constructResourcePath(bucket, path);
															#line 1123 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		headers = HTTP::Headers();
															#line 1124 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		fullResource = resource + "?list-type=2&prefix=" + path;
															#line 1126 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_1 = bstore->doRequest("GET", fullResource, headers, nullptr, 0, { 200, 404 });
															#line 1126 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9325 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFiles_implActor*>(this)->actor_wait_state = 2;
															#line 1126 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*>(static_cast<ListFiles_implActor*>(this)));
															#line 9330 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1122 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		resource = bstore->constructResourcePath(bucket, path);
															#line 1123 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		headers = HTTP::Headers();
															#line 1124 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		fullResource = resource + "?list-type=2&prefix=" + path;
															#line 1126 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		StrictFuture<Reference<HTTP::IncomingResponse>> __when_expr_1 = bstore->doRequest("GET", fullResource, headers, nullptr, 0, { 200, 404 });
															#line 1126 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9347 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ListFiles_implActor*>(this)->actor_wait_state = 2;
															#line 1126 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*>(static_cast<ListFiles_implActor*>(this)));
															#line 9352 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state > 0) static_cast<ListFiles_implActor*>(this)->actor_wait_state = 0;
		static_cast<ListFiles_implActor*>(this)->ActorCallback< ListFiles_implActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListFiles_implActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Reference<HTTP::IncomingResponse> const& r,int loopDepth) 
	{
															#line 1129 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (r->code == 404)
															#line 9436 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 1130 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientListFilesNotFound").detail("Bucket", bucket).detail("Path", path);
															#line 1131 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(file_not_found(), loopDepth);
															#line 9442 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		try {
															#line 1135 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_document<> doc;
															#line 1136 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string content = r->data.content;
															#line 1137 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			doc.parse<0>((char*)content.c_str());
															#line 1139 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* result = doc.first_node();
															#line 1140 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (result == nullptr || strcmp(result->name(), "ListBucketResult") != 0)
															#line 9455 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 1141 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientListFilesInvalidResponse") .detail("NodeName", result ? result->name() : "null");
															#line 1143 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 9461 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 1146 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::vector<std::string> files;
															#line 1147 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* n = result->first_node();
															#line 1148 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			for(;n != nullptr;) {
															#line 1149 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				const char* name = n->name();
															#line 1150 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (strcmp(name, "Contents") == 0)
															#line 9473 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 1151 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					rapidxml::xml_node<>* key = n->first_node("Key");
															#line 1152 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (key == nullptr)
															#line 9479 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 1153 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						TraceEvent(SevWarn, "S3ClientListFilesMissingKey").detail("NodeName", name);
															#line 1154 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 9485 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
															#line 1156 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					std::string file = key->value();
															#line 1157 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (file.size() > path.size() && file.substr(0, path.size()) == path)
															#line 9491 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 1158 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						file = file.substr(path.size());
															#line 9495 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
															#line 1160 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					files.push_back(file);
															#line 9499 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
															#line 1162 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				n = n->next_sibling();
															#line 9503 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 1165 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!static_cast<ListFiles_implActor*>(this)->SAV<std::vector<std::string>>::futures) { (void)(files); this->~ListFiles_implActorState(); static_cast<ListFiles_implActor*>(this)->destroy(); return 0; }
															#line 9507 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			new (&static_cast<ListFiles_implActor*>(this)->SAV< std::vector<std::string> >::value()) std::vector<std::string>(files);
			this->~ListFiles_implActorState();
			static_cast<ListFiles_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Reference<HTTP::IncomingResponse> && r,int loopDepth) 
	{
															#line 1129 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
		if (r->code == 404)
															#line 9525 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		{
															#line 1130 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientListFilesNotFound").detail("Bucket", bucket).detail("Path", path);
															#line 1131 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(file_not_found(), loopDepth);
															#line 9531 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		try {
															#line 1135 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_document<> doc;
															#line 1136 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::string content = r->data.content;
															#line 1137 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			doc.parse<0>((char*)content.c_str());
															#line 1139 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* result = doc.first_node();
															#line 1140 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (result == nullptr || strcmp(result->name(), "ListBucketResult") != 0)
															#line 9544 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			{
															#line 1141 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				TraceEvent(SevWarn, "S3ClientListFilesInvalidResponse") .detail("NodeName", result ? result->name() : "null");
															#line 1143 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 9550 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 1146 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			std::vector<std::string> files;
															#line 1147 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			rapidxml::xml_node<>* n = result->first_node();
															#line 1148 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			for(;n != nullptr;) {
															#line 1149 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				const char* name = n->name();
															#line 1150 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				if (strcmp(name, "Contents") == 0)
															#line 9562 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				{
															#line 1151 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					rapidxml::xml_node<>* key = n->first_node("Key");
															#line 1152 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (key == nullptr)
															#line 9568 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 1153 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						TraceEvent(SevWarn, "S3ClientListFilesMissingKey").detail("NodeName", name);
															#line 1154 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						return a_body1cont2Catch1(http_bad_response(), loopDepth);
															#line 9574 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
															#line 1156 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					std::string file = key->value();
															#line 1157 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					if (file.size() > path.size() && file.substr(0, path.size()) == path)
															#line 9580 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					{
															#line 1158 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
						file = file.substr(path.size());
															#line 9584 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
					}
															#line 1160 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
					files.push_back(file);
															#line 9588 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
				}
															#line 1162 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
				n = n->next_sibling();
															#line 9592 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			}
															#line 1165 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			if (!static_cast<ListFiles_implActor*>(this)->SAV<std::vector<std::string>>::futures) { (void)(files); this->~ListFiles_implActorState(); static_cast<ListFiles_implActor*>(this)->destroy(); return 0; }
															#line 9596 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
			new (&static_cast<ListFiles_implActor*>(this)->SAV< std::vector<std::string> >::value()) std::vector<std::string>(files);
			this->~ListFiles_implActorState();
			static_cast<ListFiles_implActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Reference<HTTP::IncomingResponse> const& r,int loopDepth) 
	{
		loopDepth = a_body1cont2(r, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Reference<HTTP::IncomingResponse> && r,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListFiles_implActor*>(this)->actor_wait_state > 0) static_cast<ListFiles_implActor*>(this)->actor_wait_state = 0;
		static_cast<ListFiles_implActor*>(this)->ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >::remove();

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> const& value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*,Reference<HTTP::IncomingResponse> && value) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*,Error err) 
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1167 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			TraceEvent(SevWarn, "S3ClientListFilesError").error(e).detail("Bucket", bucket).detail("Path", path);
															#line 1168 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 9692 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	Reference<S3BlobStoreEndpoint> bstore;
															#line 1117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string bucket;
															#line 1117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string path;
															#line 1122 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string resource;
															#line 1123 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	HTTP::Headers headers;
															#line 1124 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	std::string fullResource;
															#line 9714 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
};
// This generated class is to be used only via listFiles_impl()
															#line 1117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
class ListFiles_implActor final : public Actor<std::vector<std::string>>, public ActorCallback< ListFiles_implActor, 0, Void >, public ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >, public FastAllocated<ListFiles_implActor>, public ListFiles_implActorState<ListFiles_implActor> {
															#line 9719 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
public:
	using FastAllocated<ListFiles_implActor>::operator new;
	using FastAllocated<ListFiles_implActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16250287709132691200UL, 10320402310456295680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::string>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListFiles_implActor, 0, Void >;
friend struct ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >;
															#line 1117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	ListFiles_implActor(Reference<S3BlobStoreEndpoint> const& bstore,std::string const& bucket,std::string const& path) 
															#line 9737 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
		 : Actor<std::vector<std::string>>(),
		   ListFiles_implActorState<ListFiles_implActor>(bstore, bucket, path),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listFiles_impl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14489544770152881408UL, 3479841887926592000UL);
		ActorExecutionContextHelper __helper(static_cast<ListFiles_implActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listFiles_impl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listFiles_impl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListFiles_implActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListFiles_implActor, 1, Reference<HTTP::IncomingResponse> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
[[nodiscard]] Future<std::vector<std::string>> listFiles_impl( Reference<S3BlobStoreEndpoint> const& bstore, std::string const& bucket, std::string const& path ) {
															#line 1117 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
	return Future<std::vector<std::string>>(new ListFiles_implActor(bstore, bucket, path));
															#line 9771 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/build_output/fdbclient/S3Client.actor.g.cpp"
}

#line 1171 "/codebuild/output/src4166514139/src/github.com/apple/foundationdb/fdbclient/S3Client.actor.cpp"
