/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.test;

import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import java.util.ArrayList;
import java.util.List;

public class TesterArgs {
    private String outputDirectory;
    private boolean multiversionApi;
    private boolean callbacksOnExternalThread;
    private boolean externalClient;
    private Subspace subspace;
    private List<String> testsToRun;

    private TesterArgs(String string, boolean bl, boolean bl2, boolean bl3, Subspace subspace, List<String> list) {
        this.outputDirectory = string;
        this.multiversionApi = bl;
        this.callbacksOnExternalThread = bl2;
        this.externalClient = bl3;
        this.subspace = subspace;
        this.testsToRun = list;
    }

    public static void printUsage() {
        String string = "Arguments:  [-o/--output-directory DIR] [--disable-multiversion-api] [--enable-callbacks-on-external-threads] [--use-external-client] [--tests-to-run TEST [TEST ...]] [-h/--help]\n\nArguments:\n   -o/--output-directory DIR                Directory to store JSON output. If not set, the current directory is used.\n   --disable-multiversion-api               Disables the multi-version client API\n   --enable-callbacks-on-external-threads   Allows callbacks to be called on threads created by the client library.\n   --use-external-client                    Connect to the server using an external client.\n   --tests-to-run TEST [TEST ...]           List of test names to run.\n   -h/--help                                Print this help message and then quit.\n";
        System.out.print(string);
    }

    public static TesterArgs parseArgs(String[] stringArray) {
        String string = "";
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        Subspace subspace = new Subspace();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.equals("-o") || string2.equals("--output-directory")) {
                if (i + 1 < stringArray.length) {
                    string = stringArray[++i];
                    continue;
                }
                System.out.println("No output directory specified for argument " + string2 + "\n");
                TesterArgs.printUsage();
                throw new IllegalArgumentException("No output directory specified for argument " + string2);
            }
            if (string2.equals("--subspace")) {
                if (i + 1 < stringArray.length) {
                    subspace = new Subspace(Tuple.from((Object[])new Object[]{stringArray[++i]}));
                    continue;
                }
                System.out.println("No subspace specified for argument " + string2 + "\n");
                TesterArgs.printUsage();
                throw new IllegalArgumentException("Not subspace specified for argument " + string2);
            }
            if (string2.equals("--disable-multiversion-api")) {
                bl = false;
                continue;
            }
            if (string2.equals("--enable-callbacks-on-external-threads")) {
                bl2 = true;
                continue;
            }
            if (string2.equals("--use-external-client")) {
                bl3 = true;
                continue;
            }
            if (string2.equals("--tests-to-run")) {
                if (i + 1 < stringArray.length && stringArray[i + 1].charAt(0) != '-') {
                    int n;
                    for (n = i + 1; n < stringArray.length && stringArray[n].charAt(0) != '-'; ++n) {
                        arrayList.add(stringArray[n]);
                    }
                    i = n - 1;
                    continue;
                }
                System.out.println("No tests specified with argument " + string2 + "\n");
                TesterArgs.printUsage();
                throw new IllegalArgumentException("No tests specified with argument " + string2);
            }
            if (string2.equals("-h") || string2.equals("--help")) {
                TesterArgs.printUsage();
                return null;
            }
            System.out.println("Unknown argument " + string2 + "\n");
            TesterArgs.printUsage();
            throw new IllegalArgumentException("Unknown argument " + string2);
        }
        return new TesterArgs(string, bl, bl2, bl3, subspace, arrayList);
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean useMultiversionApi() {
        return this.multiversionApi;
    }

    public boolean putCallbacksOnExternalThread() {
        return this.callbacksOnExternalThread;
    }

    public boolean useExternalClient() {
        return this.externalClient;
    }

    public Subspace getSubspace() {
        return this.subspace;
    }

    public List<String> getTestsToRun() {
        return this.testsToRun;
    }
}

