#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
/*
 * HealthMetricsApi.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// workload description
// This workload can be attached to other workload to collect health information about the FDB cluster.
struct HealthMetricsApiWorkload : TestWorkload {
	// Performance Metrics
	int64_t worstStorageQueue = 0;
	int64_t worstLimitingStorageQueue = 0;
	int64_t worstStorageDurabilityLag = 0;
	int64_t worstLimitingStorageDurabilityLag = 0;
	int64_t worstTLogQueue = 0;
	int64_t detailedWorstStorageQueue = 0;
	int64_t detailedWorstStorageDurabilityLag = 0;
	int64_t detailedWorstTLogQueue = 0;
	double detailedWorstCpuUsage = 0;
	double detailedWorstDiskUsage = 0;

	// Test configuration
	double testDuration;
	double healthMetricsCheckInterval;
	double maxAllowedStaleness;
	bool sendDetailedHealthMetrics;

	// internal states
	bool healthMetricsStoppedUpdating = false;
	static constexpr auto NAME = "HealthMetricsApi";

	HealthMetricsApiWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 120.0);
		healthMetricsCheckInterval = getOption(options, "healthMetricsCheckInterval"_sr, 1.0);
		sendDetailedHealthMetrics = getOption(options, "sendDetailedHealthMetrics"_sr, true);
		maxAllowedStaleness = getOption(options, "maxAllowedStaleness"_sr, 60.0);
	}

																#line 60 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 58 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
template <class _setupActor>
															#line 58 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
class _setupActorState {
															#line 66 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
public:
															#line 58 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	_setupActorState(Database const& cx,HealthMetricsApiWorkload* const& self) 
															#line 58 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
															#line 58 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		 : cx(cx),
															#line 58 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		   self(self)
															#line 75 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 59 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			if (!self->sendDetailedHealthMetrics)
															#line 90 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
			{
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(2 * CLIENT_KNOBS->DETAILED_HEALTH_METRICS_MAX_STALENESS);
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
				if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 96 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 101 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 65 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 129 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		cx->healthMetrics.storageStats.clear();
															#line 63 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		cx->healthMetrics.tLogQueue.clear();
															#line 143 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 62 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		cx->healthMetrics.storageStats.clear();
															#line 63 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		cx->healthMetrics.tLogQueue.clear();
															#line 154 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 58 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	Database cx;
															#line 58 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	HealthMetricsApiWorkload* self;
															#line 238 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 58 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 243 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14208746228788967168UL, 4924021626255269888UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 58 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	_setupActor(Database const& cx,HealthMetricsApiWorkload* const& self) 
															#line 260 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 58 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, HealthMetricsApiWorkload* const& self ) {
															#line 58 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 292 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
}

#line 67 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }
																#line 297 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 68 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
template <class _startActor>
															#line 68 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
class _startActorState {
															#line 303 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
public:
															#line 68 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	_startActorState(Database const& cx,HealthMetricsApiWorkload* const& self) 
															#line 68 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
															#line 68 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		 : cx(cx),
															#line 68 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		   self(self)
															#line 312 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 69 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(healthMetricsChecker(cx, self), self->testDuration, Void());
															#line 69 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 329 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 69 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 334 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 70 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 357 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 70 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 369 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 68 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	Database cx;
															#line 68 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	HealthMetricsApiWorkload* self;
															#line 456 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 68 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 461 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4854128698455892224UL, 9061586759410253056UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 68 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	_startActor(Database const& cx,HealthMetricsApiWorkload* const& self) 
															#line 478 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 68 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, HealthMetricsApiWorkload* const& self ) {
															#line 68 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 510 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
}

#line 72 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	Future<Void> start(Database const& cx) override { return _start(cx, this); }

	Future<bool> check(Database const& cx) override {
		if (healthMetricsStoppedUpdating) {
			TraceEvent(SevError, "HealthMetricsStoppedUpdating").log();
			return false;
		}
		bool correctHealthMetricsState = true;
		if (worstStorageQueue == 0 || worstStorageDurabilityLag == 0 || worstTLogQueue == 0)
			correctHealthMetricsState = false;
		if (sendDetailedHealthMetrics) {
			if (detailedWorstStorageQueue == 0 || detailedWorstStorageDurabilityLag == 0 ||
			    detailedWorstTLogQueue == 0 || detailedWorstCpuUsage == 0.0 || detailedWorstDiskUsage == 0.0)
				correctHealthMetricsState = false;
		} else {
			if (detailedWorstStorageQueue != 0 || detailedWorstStorageDurabilityLag != 0 ||
			    detailedWorstTLogQueue != 0 || detailedWorstCpuUsage != 0.0 || detailedWorstDiskUsage != 0.0)
				correctHealthMetricsState = false;
		}
		if (!correctHealthMetricsState) {
			TraceEvent(SevError, "IncorrectHealthMetricsState")
			    .detail("WorstStorageQueue", worstStorageQueue)
			    .detail("WorstLimitingStorageQueue", worstLimitingStorageQueue)
			    .detail("WorstStorageDurabilityLag", worstStorageDurabilityLag)
			    .detail("WorstLimitingStorageDurabilityLag", worstLimitingStorageDurabilityLag)
			    .detail("WorstTLogQueue", worstTLogQueue)
			    .detail("DetailedWorstStorageQueue", detailedWorstStorageQueue)
			    .detail("DetailedWorstStorageDurabilityLag", detailedWorstStorageDurabilityLag)
			    .detail("DetailedWorstTLogQueue", detailedWorstTLogQueue)
			    .detail("DetailedWorstCpuUsage", detailedWorstCpuUsage)
			    .detail("DetailedWorstDiskUsage", detailedWorstDiskUsage)
			    .detail("SendingDetailedHealthMetrics", sendDetailedHealthMetrics);
		}
		return correctHealthMetricsState;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.emplace_back("WorstStorageQueue", worstStorageQueue, Averaged::True);
		m.emplace_back("DetailedWorstStorageQueue", detailedWorstStorageQueue, Averaged::True);
		m.emplace_back("WorstStorageDurabilityLag", worstStorageDurabilityLag, Averaged::True);
		m.emplace_back("DetailedWorstStorageDurabilityLag", detailedWorstStorageDurabilityLag, Averaged::True);
		m.emplace_back("WorstTLogQueue", worstTLogQueue, Averaged::True);
		m.emplace_back("DetailedWorstTLogQueue", detailedWorstTLogQueue, Averaged::True);
		m.emplace_back("DetailedWorstCpuUsage", detailedWorstCpuUsage, Averaged::True);
		m.emplace_back("DetailedWorstDiskUsage", detailedWorstDiskUsage, Averaged::True);
	}

																#line 561 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
// This generated class is to be used only via healthMetricsChecker()
															#line 119 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
template <class HealthMetricsCheckerActor>
															#line 119 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
class HealthMetricsCheckerActorState {
															#line 567 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
public:
															#line 119 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	HealthMetricsCheckerActorState(Database const& cx,HealthMetricsApiWorkload* const& self) 
															#line 119 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
															#line 119 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		 : cx(cx),
															#line 119 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		   self(self),
															#line 120 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		   repeated(0),
															#line 121 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		   healthMetrics()
															#line 580 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
	{
		fdb_probe_actor_create("healthMetricsChecker", reinterpret_cast<unsigned long>(this));

	}
	~HealthMetricsCheckerActorState() 
	{
		fdb_probe_actor_destroy("healthMetricsChecker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 122 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			;
															#line 595 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~HealthMetricsCheckerActorState();
		static_cast<HealthMetricsCheckerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 123 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(self->healthMetricsCheckInterval);
															#line 123 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 627 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state = 1;
															#line 123 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< HealthMetricsCheckerActor, 0, Void >*>(static_cast<HealthMetricsCheckerActor*>(this)));
															#line 632 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 124 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		StrictFuture<HealthMetrics> __when_expr_1 = cx->getHealthMetrics(self->sendDetailedHealthMetrics);
															#line 124 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 643 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state = 2;
															#line 124 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >*>(static_cast<HealthMetricsCheckerActor*>(this)));
															#line 648 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 124 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		StrictFuture<HealthMetrics> __when_expr_1 = cx->getHealthMetrics(self->sendDetailedHealthMetrics);
															#line 124 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 659 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state = 2;
															#line 124 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >*>(static_cast<HealthMetricsCheckerActor*>(this)));
															#line 664 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state > 0) static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMetricsCheckerActor*>(this)->ActorCallback< HealthMetricsCheckerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< HealthMetricsCheckerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< HealthMetricsCheckerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< HealthMetricsCheckerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(HealthMetrics const& newHealthMetrics,int loopDepth) 
	{
															#line 125 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (healthMetrics == newHealthMetrics)
															#line 748 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		{
															#line 126 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			if (++repeated > self->maxAllowedStaleness / self->healthMetricsCheckInterval)
															#line 752 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
			{
															#line 127 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
				self->healthMetricsStoppedUpdating = true;
															#line 756 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
			}
		}
		else
		{
															#line 129 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			repeated = 0;
															#line 763 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		}
															#line 130 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		healthMetrics = newHealthMetrics;
															#line 132 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstStorageQueue = std::max(self->worstStorageQueue, healthMetrics.worstStorageQueue);
															#line 133 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstLimitingStorageQueue = std::max(self->worstLimitingStorageQueue, healthMetrics.limitingStorageQueue);
															#line 135 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstStorageDurabilityLag = std::max(self->worstStorageDurabilityLag, healthMetrics.worstStorageDurabilityLag);
															#line 137 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstLimitingStorageDurabilityLag = std::max(self->worstLimitingStorageDurabilityLag, healthMetrics.limitingStorageDurabilityLag);
															#line 139 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstTLogQueue = std::max(self->worstTLogQueue, healthMetrics.worstTLogQueue);
															#line 141 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent("HealthMetrics") .detail("WorstStorageQueue", healthMetrics.worstStorageQueue) .detail("LimitingStorageQueue", healthMetrics.limitingStorageQueue) .detail("WorstStorageDurabilityLag", healthMetrics.worstStorageDurabilityLag) .detail("LimitingStorageDurabilityLag", healthMetrics.limitingStorageDurabilityLag) .detail("WorstTLogQueue", healthMetrics.worstTLogQueue) .detail("TpsLimit", healthMetrics.tpsLimit);
															#line 149 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceStorageQueue("StorageQueue");
															#line 150 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceStorageDurabilityLag("StorageDurabilityLag");
															#line 151 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceCpuUsage("CpuUsage");
															#line 152 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceDiskUsage("DiskUsage");
															#line 155 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		for( const auto& ss : healthMetrics.storageStats ) {
															#line 156 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			auto storageStats = ss.second;
															#line 157 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstStorageQueue = std::max(self->detailedWorstStorageQueue, storageStats.storageQueue);
															#line 158 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceStorageQueue.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.storageQueue);
															#line 159 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstStorageDurabilityLag = std::max(self->detailedWorstStorageDurabilityLag, storageStats.storageDurabilityLag);
															#line 161 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceStorageDurabilityLag.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.storageDurabilityLag);
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstCpuUsage = std::max(self->detailedWorstCpuUsage, storageStats.cpuUsage);
															#line 164 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceCpuUsage.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.cpuUsage);
															#line 165 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstDiskUsage = std::max(self->detailedWorstDiskUsage, storageStats.diskUsage);
															#line 166 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceDiskUsage.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.diskUsage);
															#line 807 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		}
															#line 168 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceTLogQueue("TLogQueue");
															#line 169 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		traceTLogQueue.setMaxEventLength(10000);
															#line 170 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		for( const auto& ss : healthMetrics.tLogQueue ) {
															#line 171 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstTLogQueue = std::max(self->detailedWorstTLogQueue, ss.second);
															#line 172 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceTLogQueue.detail(format("TLog-%s", ss.first.toString().c_str()), ss.second);
															#line 819 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(HealthMetrics && newHealthMetrics,int loopDepth) 
	{
															#line 125 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		if (healthMetrics == newHealthMetrics)
															#line 829 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		{
															#line 126 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			if (++repeated > self->maxAllowedStaleness / self->healthMetricsCheckInterval)
															#line 833 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
			{
															#line 127 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
				self->healthMetricsStoppedUpdating = true;
															#line 837 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
			}
		}
		else
		{
															#line 129 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			repeated = 0;
															#line 844 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		}
															#line 130 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		healthMetrics = newHealthMetrics;
															#line 132 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstStorageQueue = std::max(self->worstStorageQueue, healthMetrics.worstStorageQueue);
															#line 133 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstLimitingStorageQueue = std::max(self->worstLimitingStorageQueue, healthMetrics.limitingStorageQueue);
															#line 135 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstStorageDurabilityLag = std::max(self->worstStorageDurabilityLag, healthMetrics.worstStorageDurabilityLag);
															#line 137 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstLimitingStorageDurabilityLag = std::max(self->worstLimitingStorageDurabilityLag, healthMetrics.limitingStorageDurabilityLag);
															#line 139 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		self->worstTLogQueue = std::max(self->worstTLogQueue, healthMetrics.worstTLogQueue);
															#line 141 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent("HealthMetrics") .detail("WorstStorageQueue", healthMetrics.worstStorageQueue) .detail("LimitingStorageQueue", healthMetrics.limitingStorageQueue) .detail("WorstStorageDurabilityLag", healthMetrics.worstStorageDurabilityLag) .detail("LimitingStorageDurabilityLag", healthMetrics.limitingStorageDurabilityLag) .detail("WorstTLogQueue", healthMetrics.worstTLogQueue) .detail("TpsLimit", healthMetrics.tpsLimit);
															#line 149 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceStorageQueue("StorageQueue");
															#line 150 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceStorageDurabilityLag("StorageDurabilityLag");
															#line 151 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceCpuUsage("CpuUsage");
															#line 152 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceDiskUsage("DiskUsage");
															#line 155 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		for( const auto& ss : healthMetrics.storageStats ) {
															#line 156 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			auto storageStats = ss.second;
															#line 157 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstStorageQueue = std::max(self->detailedWorstStorageQueue, storageStats.storageQueue);
															#line 158 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceStorageQueue.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.storageQueue);
															#line 159 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstStorageDurabilityLag = std::max(self->detailedWorstStorageDurabilityLag, storageStats.storageDurabilityLag);
															#line 161 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceStorageDurabilityLag.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.storageDurabilityLag);
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstCpuUsage = std::max(self->detailedWorstCpuUsage, storageStats.cpuUsage);
															#line 164 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceCpuUsage.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.cpuUsage);
															#line 165 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstDiskUsage = std::max(self->detailedWorstDiskUsage, storageStats.diskUsage);
															#line 166 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceDiskUsage.detail(format("Storage-%s", ss.first.toString().c_str()), storageStats.diskUsage);
															#line 888 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		}
															#line 168 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		TraceEvent traceTLogQueue("TLogQueue");
															#line 169 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		traceTLogQueue.setMaxEventLength(10000);
															#line 170 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
		for( const auto& ss : healthMetrics.tLogQueue ) {
															#line 171 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			self->detailedWorstTLogQueue = std::max(self->detailedWorstTLogQueue, ss.second);
															#line 172 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
			traceTLogQueue.detail(format("TLog-%s", ss.first.toString().c_str()), ss.second);
															#line 900 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(HealthMetrics const& newHealthMetrics,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(newHealthMetrics, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(HealthMetrics && newHealthMetrics,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(newHealthMetrics), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state > 0) static_cast<HealthMetricsCheckerActor*>(this)->actor_wait_state = 0;
		static_cast<HealthMetricsCheckerActor*>(this)->ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >::remove();

	}
	void a_callback_fire(ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >*,HealthMetrics const& value) 
	{
		fdb_probe_actor_enter("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >*,HealthMetrics && value) 
	{
		fdb_probe_actor_enter("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >*,Error err) 
	{
		fdb_probe_actor_enter("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("healthMetricsChecker", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 119 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	Database cx;
															#line 119 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	HealthMetricsApiWorkload* self;
															#line 120 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	int repeated;
															#line 121 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	HealthMetrics healthMetrics;
															#line 989 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
};
// This generated class is to be used only via healthMetricsChecker()
															#line 119 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
class HealthMetricsCheckerActor final : public Actor<Void>, public ActorCallback< HealthMetricsCheckerActor, 0, Void >, public ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >, public FastAllocated<HealthMetricsCheckerActor>, public HealthMetricsCheckerActorState<HealthMetricsCheckerActor> {
															#line 994 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
public:
	using FastAllocated<HealthMetricsCheckerActor>::operator new;
	using FastAllocated<HealthMetricsCheckerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7416756639176928512UL, 6819071424294057472UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< HealthMetricsCheckerActor, 0, Void >;
friend struct ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >;
															#line 119 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	HealthMetricsCheckerActor(Database const& cx,HealthMetricsApiWorkload* const& self) 
															#line 1012 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
		 : Actor<Void>(),
		   HealthMetricsCheckerActorState<HealthMetricsCheckerActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("healthMetricsChecker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1752804974711321856UL, 5960329134305098496UL);
		ActorExecutionContextHelper __helper(static_cast<HealthMetricsCheckerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("healthMetricsChecker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("healthMetricsChecker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< HealthMetricsCheckerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< HealthMetricsCheckerActor, 1, HealthMetrics >*)0, actor_cancelled()); break;
		}

	}
};
															#line 119 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
[[nodiscard]] static Future<Void> healthMetricsChecker( Database const& cx, HealthMetricsApiWorkload* const& self ) {
															#line 119 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
	return Future<Void>(new HealthMetricsCheckerActor(cx, self));
															#line 1045 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/HealthMetricsApi.actor.g.cpp"
}

#line 176 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/HealthMetricsApi.actor.cpp"
};
WorkloadFactory<HealthMetricsApiWorkload> HealthMetricsApiWorkloadFactory;
