#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
/*
 * BackupToDBCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/DatabaseConfiguration.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbrpc/simulator.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/ClusterConnectionMemoryRecord.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/ApiVersion.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// A workload which test the correctness of backup and restore process. The
// database must be idle after the restore completes, and this workload checks
// that the restore range does not change post restore.
struct BackupToDBCorrectnessWorkload : TestWorkload {
	static constexpr auto NAME = "BackupToDBCorrectness";
	double backupAfter, abortAndRestartAfter, restoreAfter;
	double backupStartAt, restoreStartAfterBackupFinished, stopDifferentialAfter;
	Key backupTag, restoreTag;
	Key backupPrefix, extraPrefix;
	int backupRangesCount, backupRangeLengthMax;
	bool differentialBackup, performRestore, agentRequest;
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
	static int drAgentRequests;
	Database extraDB;
	LockDB locked{ false };
	bool shareLogRange;
	bool defaultBackup;
	UID destUid;

	// This workload is not compatible with RandomRangeLock workload because they will race in locked range
	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		out.insert({ "RandomRangeLock" });
	}

	BackupToDBCorrectnessWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		locked.set(sharedRandomNumber % 2);
		backupAfter = getOption(options, "backupAfter"_sr, 10.0);
		double minBackupAfter = getOption(options, "minBackupAfter"_sr, backupAfter);
		if (backupAfter > minBackupAfter) {
			backupAfter = deterministicRandom()->random01() * (backupAfter - minBackupAfter) + minBackupAfter;
		}
		restoreAfter = getOption(options, "restoreAfter"_sr, 35.0);
		performRestore = getOption(options, "performRestore"_sr, true);
		backupTag = getOption(options, "backupTag"_sr, BackupAgentBase::getDefaultTag());
		restoreTag = getOption(options, "restoreTag"_sr, "restore"_sr);
		backupPrefix = getOption(options, "backupPrefix"_sr, StringRef());
		backupRangesCount = getOption(options,
		                              "backupRangesCount"_sr,
		                              5); // tests can hangs if set higher than 1 + BACKUP_MAP_KEY_LOWER_LIMIT
		backupRangeLengthMax = getOption(options, "backupRangeLengthMax"_sr, 1);
		abortAndRestartAfter =
		    getOption(options,
		              "abortAndRestartAfter"_sr,
		              (!locked && deterministicRandom()->random01() < 0.5)
		                  ? deterministicRandom()->random01() * (restoreAfter - backupAfter) + backupAfter
		                  : 0.0);
		differentialBackup =
		    getOption(options, "differentialBackup"_sr, deterministicRandom()->random01() < 0.5 ? true : false);
		stopDifferentialAfter =
		    getOption(options,
		              "stopDifferentialAfter"_sr,
		              differentialBackup ? deterministicRandom()->random01() *
		                                           (restoreAfter - std::max(abortAndRestartAfter, backupAfter)) +
		                                       std::max(abortAndRestartAfter, backupAfter)
		                                 : 0.0);
		agentRequest = getOption(options, "simDrAgents"_sr, true);
		shareLogRange = getOption(options, "shareLogRange"_sr, false);
		defaultBackup = getOption(options, "defaultBackup"_sr, false);

		// Use sharedRandomNumber if shareLogRange is true so that we can ensure backup and DR both backup the same
		// range
		bool beforePrefix = shareLogRange ? (sharedRandomNumber & 1) : (deterministicRandom()->random01() < 0.5);

		if (!defaultBackup) {
			if (beforePrefix) {
				extraPrefix = backupPrefix.withPrefix("\xfe\xff\xfe"_sr);
				backupPrefix = backupPrefix.withPrefix("\xfe\xff\xff"_sr);
			} else {
				extraPrefix = backupPrefix.withPrefix("\x00\x00\x01"_sr);
				backupPrefix = backupPrefix.withPrefix("\x00\x00\00"_sr);
			}

			ASSERT(backupPrefix != StringRef());
		}

		KeyRef beginRange;
		KeyRef endRange;
		UID randomID = nondeterministicRandom()->randomUniqueID();

		if (defaultBackup) {
			addDefaultBackupRanges(backupRanges);
		} else if (shareLogRange) {
			if (beforePrefix)
				backupRanges.push_back_deep(backupRanges.arena(), KeyRangeRef(normalKeys.begin, "\xfe\xff\xfe"_sr));
			else
				backupRanges.push_back_deep(backupRanges.arena(),
				                            KeyRangeRef(strinc("\x00\x00\x01"_sr), normalKeys.end));
		} else if (backupRangesCount <= 0) {
			if (beforePrefix)
				backupRanges.push_back_deep(backupRanges.arena(),
				                            KeyRangeRef(normalKeys.begin, std::min(backupPrefix, extraPrefix)));
			else
				backupRanges.push_back_deep(backupRanges.arena(),
				                            KeyRangeRef(strinc(std::max(backupPrefix, extraPrefix)), normalKeys.end));
		} else {
			// Add backup ranges
			for (int rangeLoop = 0; rangeLoop < backupRangesCount; rangeLoop++) {
				// Get a random range of a random sizes
				beginRange = KeyRef(backupRanges.arena(),
				                    deterministicRandom()->randomAlphaNumeric(
				                        deterministicRandom()->randomInt(1, backupRangeLengthMax + 1)));
				endRange = KeyRef(backupRanges.arena(),
				                  deterministicRandom()->randomAlphaNumeric(
				                      deterministicRandom()->randomInt(1, backupRangeLengthMax + 1)));

				// Add the range to the array
				backupRanges.push_back_deep(backupRanges.arena(),
				                            (beginRange < endRange) ? KeyRangeRef(beginRange, endRange)
				                                                    : KeyRangeRef(endRange, beginRange));

				// Track the added range
				TraceEvent("BackupCorrectness_Range", randomID)
				    .detail("RangeBegin", (beginRange < endRange) ? printable(beginRange) : printable(endRange))
				    .detail("RangeEnd", (beginRange < endRange) ? printable(endRange) : printable(beginRange));
			}
		}

		ASSERT(g_simulator->extraDatabases.size() == 1);
		extraDB = Database::createSimulatedExtraDatabase(g_simulator->extraDatabases[0], wcx.defaultTenant);

		TraceEvent("BARW_Start").detail("Locked", locked);
	}

	Future<Void> setup(Database const& cx) override {
		if (clientId != 0) {
			return Void();
		}
		return _setup(cx, this);
	}

																#line 165 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
template <class _setupActor>
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class _setupActorState {
															#line 171 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
public:
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	_setupActorState(Database const& cx,BackupToDBCorrectnessWorkload* const& self) 
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		 : cx(cx),
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   self(self)
															#line 180 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 164 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (!self->defaultBackup && (cx->defaultTenant.present() || BUGGIFY))
															#line 195 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 165 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (cx->defaultTenant.present())
															#line 199 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				{
															#line 166 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					StrictFuture<TenantMapEntry> __when_expr_0 = TenantAPI::getTenant(cx.getReference(), cx->defaultTenant.get());
															#line 166 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 205 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 166 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, TenantMapEntry >*>(static_cast<_setupActor*>(this)));
															#line 210 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 186 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 243 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 181 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for( auto r : getSystemBackupRanges() ) {
															#line 182 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			self->backupRanges.push_back_deep(self->backupRanges.arena(), r);
															#line 257 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(TenantMapEntry const& entry,int loopDepth) 
	{
															#line 170 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->backupRanges.size() != 1 || self->backupRanges[0] != normalKeys || deterministicRandom()->coinflip())
															#line 267 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 172 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			Standalone<VectorRef<KeyRangeRef>> modifiedBackupRanges;
															#line 173 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for(int i = 0;i < self->backupRanges.size();++i) {
															#line 174 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				modifiedBackupRanges.push_back_deep( modifiedBackupRanges.arena(), self->backupRanges[i].withPrefix(entry.prefix, self->backupRanges.arena()));
															#line 275 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
															#line 178 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			self->backupRanges = modifiedBackupRanges;
															#line 279 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(TenantMapEntry && entry,int loopDepth) 
	{
															#line 170 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->backupRanges.size() != 1 || self->backupRanges[0] != normalKeys || deterministicRandom()->coinflip())
															#line 289 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 172 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			Standalone<VectorRef<KeyRangeRef>> modifiedBackupRanges;
															#line 173 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for(int i = 0;i < self->backupRanges.size();++i) {
															#line 174 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				modifiedBackupRanges.push_back_deep( modifiedBackupRanges.arena(), self->backupRanges[i].withPrefix(entry.prefix, self->backupRanges.arena()));
															#line 297 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
															#line 178 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			self->backupRanges = modifiedBackupRanges;
															#line 301 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(TenantMapEntry const& entry,int loopDepth) 
	{
		loopDepth = a_body1cont3(entry, loopDepth);

		return loopDepth;
	}
	int a_body1when1(TenantMapEntry && entry,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(entry), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, TenantMapEntry >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, TenantMapEntry >*,TenantMapEntry const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, TenantMapEntry >*,TenantMapEntry && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, TenantMapEntry >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Database cx;
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	BackupToDBCorrectnessWorkload* self;
															#line 386 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, TenantMapEntry >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 391 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3550227828566865152UL, 17796891773499894016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, TenantMapEntry >;
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	_setupActor(Database const& cx,BackupToDBCorrectnessWorkload* const& self) 
															#line 408 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, TenantMapEntry >*)0, actor_cancelled()); break;
		}

	}
};
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, BackupToDBCorrectnessWorkload* const& self ) {
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 440 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
}

#line 188 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}

	// Reads a series of key ranges and returns each range.
																#line 456 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
// This generated class is to be used only via readRanges()
															#line 200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
template <class ReadRangesActor>
															#line 200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class ReadRangesActorState {
															#line 462 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
public:
															#line 200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	ReadRangesActorState(Database const& cx,Standalone<VectorRef<KeyRangeRef>> const& ranges,StringRef const& removePrefix) 
															#line 200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
															#line 200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		 : cx(cx),
															#line 200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   ranges(ranges),
															#line 200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   removePrefix(removePrefix)
															#line 473 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("readRanges", reinterpret_cast<unsigned long>(this));

	}
	~ReadRangesActorState() 
	{
		fdb_probe_actor_destroy("readRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 203 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			;
															#line 488 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadRangesActorState();
		static_cast<ReadRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		tr = Transaction(cx);
															#line 518 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		try {
															#line 206 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			results = std::vector<Future<RangeResult>>();
															#line 207 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for( auto& range : ranges ) {
															#line 208 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				results.push_back(tr.getRange(range.removePrefix(removePrefix), 1000));
															#line 526 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
															#line 210 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(results);
															#line 210 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<ReadRangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 532 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadRangesActor*>(this)->actor_wait_state = 1;
															#line 210 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadRangesActor, 0, Void >*>(static_cast<ReadRangesActor*>(this)));
															#line 537 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 218 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 218 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<ReadRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 561 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadRangesActor*>(this)->actor_wait_state = 2;
															#line 218 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadRangesActor, 1, Void >*>(static_cast<ReadRangesActor*>(this)));
															#line 566 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 212 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		std::vector<RangeResult> ret;
															#line 213 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for( auto result : results ) {
															#line 214 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			ret.push_back(result.get());
															#line 585 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
															#line 216 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<ReadRangesActor*>(this)->SAV<std::vector<RangeResult>>::futures) { (void)(ret); this->~ReadRangesActorState(); static_cast<ReadRangesActor*>(this)->destroy(); return 0; }
															#line 589 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		new (&static_cast<ReadRangesActor*>(this)->SAV< std::vector<RangeResult> >::value()) std::vector<RangeResult>(ret);
		this->~ReadRangesActorState();
		static_cast<ReadRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 212 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		std::vector<RangeResult> ret;
															#line 213 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for( auto result : results ) {
															#line 214 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			ret.push_back(result.get());
															#line 605 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
															#line 216 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<ReadRangesActor*>(this)->SAV<std::vector<RangeResult>>::futures) { (void)(ret); this->~ReadRangesActorState(); static_cast<ReadRangesActor*>(this)->destroy(); return 0; }
															#line 609 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		new (&static_cast<ReadRangesActor*>(this)->SAV< std::vector<RangeResult> >::value()) std::vector<RangeResult>(ret);
		this->~ReadRangesActorState();
		static_cast<ReadRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadRangesActor*>(this)->actor_wait_state > 0) static_cast<ReadRangesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRangesActor*>(this)->ActorCallback< ReadRangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadRangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadRangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadRangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadRangesActor*>(this)->actor_wait_state > 0) static_cast<ReadRangesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadRangesActor*>(this)->ActorCallback< ReadRangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadRangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadRangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadRangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readRanges", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Database cx;
															#line 200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	StringRef removePrefix;
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Transaction tr;
															#line 206 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	std::vector<Future<RangeResult>> results;
															#line 789 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
};
// This generated class is to be used only via readRanges()
															#line 200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class ReadRangesActor final : public Actor<std::vector<RangeResult>>, public ActorCallback< ReadRangesActor, 0, Void >, public ActorCallback< ReadRangesActor, 1, Void >, public FastAllocated<ReadRangesActor>, public ReadRangesActorState<ReadRangesActor> {
															#line 794 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
public:
	using FastAllocated<ReadRangesActor>::operator new;
	using FastAllocated<ReadRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3054613061259264768UL, 14907521957252982272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<RangeResult>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadRangesActor, 0, Void >;
friend struct ActorCallback< ReadRangesActor, 1, Void >;
															#line 200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	ReadRangesActor(Database const& cx,Standalone<VectorRef<KeyRangeRef>> const& ranges,StringRef const& removePrefix) 
															#line 812 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		 : Actor<std::vector<RangeResult>>(),
		   ReadRangesActorState<ReadRangesActor>(cx, ranges, removePrefix),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3579129534909043968UL, 2722703771075061248UL);
		ActorExecutionContextHelper __helper(static_cast<ReadRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadRangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadRangesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
[[nodiscard]] static Future<std::vector<RangeResult>> readRanges( Database const& cx, Standalone<VectorRef<KeyRangeRef>> const& ranges, StringRef const& removePrefix ) {
															#line 200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	return Future<std::vector<RangeResult>>(new ReadRangesActor(cx, ranges, removePrefix));
															#line 845 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
}

#line 222 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"

																#line 850 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
// This generated class is to be used only via diffRanges()
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
template <class DiffRangesActor>
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class DiffRangesActorState {
															#line 856 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
public:
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DiffRangesActorState(Standalone<VectorRef<KeyRangeRef>> const& ranges,StringRef const& backupPrefix,Database const& src,Database const& dest) 
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		 : ranges(ranges),
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupPrefix(backupPrefix),
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   src(src),
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   dest(dest),
															#line 227 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   rangeIndex()
															#line 871 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("diffRanges", reinterpret_cast<unsigned long>(this));

	}
	~DiffRangesActorState() 
	{
		fdb_probe_actor_destroy("diffRanges", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 228 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			rangeIndex = 0;
															#line 886 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DiffRangesActorState();
		static_cast<DiffRangesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 304 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<DiffRangesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DiffRangesActorState(); static_cast<DiffRangesActor*>(this)->destroy(); return 0; }
															#line 909 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		new (&static_cast<DiffRangesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DiffRangesActorState();
		static_cast<DiffRangesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 228 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!(rangeIndex < ranges.size()))
															#line 928 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 229 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		range = ranges[rangeIndex];
															#line 230 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		begin = range.begin;
															#line 231 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		;
															#line 938 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 228 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		++rangeIndex;
															#line 960 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 232 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		tr = Transaction(src);
															#line 233 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		tr2 = Transaction(dest);
															#line 978 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		try {
															#line 235 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			;
															#line 982 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = a_body1loopBody1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 299 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 299 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<DiffRangesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1019 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<DiffRangesActor*>(this)->actor_wait_state = 2;
															#line 299 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DiffRangesActor, 1, Void >*>(static_cast<DiffRangesActor*>(this)));
															#line 1024 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1(int loopDepth) 
	{
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		srcFuture = tr.getRange(KeyRangeRef(begin, range.end), 1000);
															#line 237 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		bkpFuture = tr2.getRange(KeyRangeRef(begin, range.end).withPrefix(backupPrefix), 1000);
															#line 239 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_0 = success(srcFuture) && success(bkpFuture);
															#line 239 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1058 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<DiffRangesActor*>(this)->actor_wait_state = 1;
															#line 239 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DiffRangesActor, 0, Void >*>(static_cast<DiffRangesActor*>(this)));
															#line 1063 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 241 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		auto src = srcFuture.get().begin();
															#line 242 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		auto bkp = bkpFuture.get().begin();
															#line 244 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for(;src != srcFuture.get().end() && bkp != bkpFuture.get().end();) {
															#line 245 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			KeyRef bkpKey = bkp->key.substr(backupPrefix.size());
															#line 246 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (src->key != bkpKey && src->value != bkp->value)
															#line 1093 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 247 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent(SevError, "MismatchKeyAndValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 1097 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
			else
			{
															#line 252 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (src->key != bkpKey)
															#line 1103 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				{
															#line 253 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					TraceEvent(SevError, "MismatchKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 1107 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				}
				else
				{
															#line 258 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (src->value != bkp->value)
															#line 1113 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					{
															#line 259 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
						TraceEvent(SevError, "MismatchValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 1117 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					}
				}
			}
															#line 265 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			begin = std::min(src->key, bkpKey);
															#line 266 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (src->key == bkpKey)
															#line 1125 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 267 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				++src;
															#line 268 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				++bkp;
															#line 1131 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
			else
			{
															#line 269 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (src->key < bkpKey)
															#line 1137 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				{
															#line 270 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					++src;
															#line 1141 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				}
				else
				{
															#line 272 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					++bkp;
															#line 1147 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				}
			}
		}
															#line 275 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for(;src != srcFuture.get().end() && !bkpFuture.get().more;) {
															#line 276 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "MissingBkpKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value));
															#line 279 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			begin = src->key;
															#line 280 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			++src;
															#line 1159 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
															#line 282 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for(;bkp != bkpFuture.get().end() && !srcFuture.get().more;) {
															#line 283 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "MissingSrcKey") .detail("BkpKey", printable(bkp->key.substr(backupPrefix.size()))) .detail("BkpVal", printable(bkp->value));
															#line 286 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			begin = bkp->key;
															#line 287 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			++bkp;
															#line 1169 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
															#line 290 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!srcFuture.get().more && !bkpFuture.get().more)
															#line 1173 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
			return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 294 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		begin = keyAfter(begin);
															#line 1179 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 241 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		auto src = srcFuture.get().begin();
															#line 242 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		auto bkp = bkpFuture.get().begin();
															#line 244 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for(;src != srcFuture.get().end() && bkp != bkpFuture.get().end();) {
															#line 245 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			KeyRef bkpKey = bkp->key.substr(backupPrefix.size());
															#line 246 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (src->key != bkpKey && src->value != bkp->value)
															#line 1196 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 247 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent(SevError, "MismatchKeyAndValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 1200 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
			else
			{
															#line 252 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (src->key != bkpKey)
															#line 1206 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				{
															#line 253 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					TraceEvent(SevError, "MismatchKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 1210 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				}
				else
				{
															#line 258 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (src->value != bkp->value)
															#line 1216 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					{
															#line 259 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
						TraceEvent(SevError, "MismatchValue") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value)) .detail("BkpKey", printable(bkpKey)) .detail("BkpVal", printable(bkp->value));
															#line 1220 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					}
				}
			}
															#line 265 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			begin = std::min(src->key, bkpKey);
															#line 266 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (src->key == bkpKey)
															#line 1228 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 267 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				++src;
															#line 268 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				++bkp;
															#line 1234 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
			else
			{
															#line 269 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (src->key < bkpKey)
															#line 1240 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				{
															#line 270 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					++src;
															#line 1244 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				}
				else
				{
															#line 272 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					++bkp;
															#line 1250 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				}
			}
		}
															#line 275 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for(;src != srcFuture.get().end() && !bkpFuture.get().more;) {
															#line 276 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "MissingBkpKey") .detail("SrcKey", printable(src->key)) .detail("SrcVal", printable(src->value));
															#line 279 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			begin = src->key;
															#line 280 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			++src;
															#line 1262 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
															#line 282 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for(;bkp != bkpFuture.get().end() && !srcFuture.get().more;) {
															#line 283 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "MissingSrcKey") .detail("BkpKey", printable(bkp->key.substr(backupPrefix.size()))) .detail("BkpVal", printable(bkp->value));
															#line 286 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			begin = bkp->key;
															#line 287 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			++bkp;
															#line 1272 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
															#line 290 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!srcFuture.get().more && !bkpFuture.get().more)
															#line 1276 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
			return a_body1loopBody1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 294 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		begin = keyAfter(begin);
															#line 1282 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopBody1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state > 0) static_cast<DiffRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DiffRangesActor*>(this)->ActorCallback< DiffRangesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DiffRangesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DiffRangesActor*>(this)->actor_wait_state > 0) static_cast<DiffRangesActor*>(this)->actor_wait_state = 0;
		static_cast<DiffRangesActor*>(this)->ActorCallback< DiffRangesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DiffRangesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DiffRangesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> ranges;
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	StringRef backupPrefix;
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Database src;
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Database dest;
															#line 227 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	int rangeIndex;
															#line 229 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	KeyRangeRef range;
															#line 230 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key begin;
															#line 232 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Transaction tr;
															#line 233 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Transaction tr2;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Future<RangeResult> srcFuture;
															#line 237 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Future<RangeResult> bkpFuture;
															#line 1471 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
};
// This generated class is to be used only via diffRanges()
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class DiffRangesActor final : public Actor<Void>, public ActorCallback< DiffRangesActor, 0, Void >, public ActorCallback< DiffRangesActor, 1, Void >, public FastAllocated<DiffRangesActor>, public DiffRangesActorState<DiffRangesActor> {
															#line 1476 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
public:
	using FastAllocated<DiffRangesActor>::operator new;
	using FastAllocated<DiffRangesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5130882064353338624UL, 11201742423790492416UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DiffRangesActor, 0, Void >;
friend struct ActorCallback< DiffRangesActor, 1, Void >;
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DiffRangesActor(Standalone<VectorRef<KeyRangeRef>> const& ranges,StringRef const& backupPrefix,Database const& src,Database const& dest) 
															#line 1494 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   DiffRangesActorState<DiffRangesActor>(ranges, backupPrefix, src, dest),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("diffRanges", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14464715535444249600UL, 3030925669057132800UL);
		ActorExecutionContextHelper __helper(static_cast<DiffRangesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("diffRanges");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("diffRanges", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DiffRangesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DiffRangesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> diffRanges( Standalone<VectorRef<KeyRangeRef>> const& ranges, StringRef const& backupPrefix, Database const& src, Database const& dest ) {
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	return Future<Void>(new DiffRangesActor(ranges, backupPrefix, src, dest));
															#line 1527 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
}

#line 306 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"

																#line 1532 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
// This generated class is to be used only via doBackup()
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
template <class DoBackupActor>
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class DoBackupActorState {
															#line 1538 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
public:
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DoBackupActorState(BackupToDBCorrectnessWorkload* const& self,double const& startDelay,DatabaseBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,double const& stopDifferentialDelay,Promise<Void> const& submitted) 
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		 : self(self),
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   startDelay(startDelay),
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupAgent(backupAgent),
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   cx(cx),
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   tag(tag),
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupRanges(backupRanges),
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   stopDifferentialDelay(stopDifferentialDelay),
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   submitted(submitted),
															#line 316 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   randomID(nondeterministicRandom()->randomUniqueID()),
															#line 318 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   stopDifferentialFuture(delay(stopDifferentialDelay))
															#line 1563 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("doBackup", reinterpret_cast<unsigned long>(this));

	}
	~DoBackupActorState() 
	{
		fdb_probe_actor_destroy("doBackup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 319 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(startDelay);
															#line 319 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1580 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 1;
															#line 319 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 0, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1585 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 321 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (startDelay || BUGGIFY)
															#line 1608 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 322 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup1", randomID) .detail("Tag", printable(tag)) .detail("StartDelay", startDelay);
															#line 1612 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			try {
															#line 327 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_1 = backupAgent->abortBackup(cx, tag);
															#line 327 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1618 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 327 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1623 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 321 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (startDelay || BUGGIFY)
															#line 1643 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 322 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup1", randomID) .detail("Tag", printable(tag)) .detail("StartDelay", startDelay);
															#line 1647 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			try {
															#line 327 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_1 = backupAgent->abortBackup(cx, tag);
															#line 327 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1653 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 2;
															#line 327 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 1, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1658 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 345 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupClearAndSubmitBackup", randomID) .detail("Tag", printable(tag)) .detail("StopWhenDone", stopDifferentialDelay ? "False" : "True");
															#line 1753 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		try {
			try {
															#line 351 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_3 = backupAgent->submitBackup(cx, tag, backupRanges, StopWhenDone{ !stopDifferentialDelay }, self->backupPrefix, StringRef(), LockDB{ self->locked }, DatabaseBackupAgent::PreBackupAction::CLEAR);
															#line 351 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont2Catch2(actor_cancelled(), loopDepth);
															#line 1760 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont2when1(__when_expr_3.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 4;
															#line 351 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 3, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1765 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont2Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont2Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
															#line 333 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = backupAgent->unlockBackup(cx, tag);
															#line 333 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1788 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 3;
															#line 333 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 2, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 1793 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 329 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 330 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded)
															#line 1805 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 331 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 1809 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
															#line 372 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		submitted.send(Void());
															#line 374 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<UID> __when_expr_4 = backupAgent->getLogUid(cx, tag);
															#line 374 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2016 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 5;
															#line 374 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 4, UID >*>(static_cast<DoBackupActor*>(this)));
															#line 2021 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 366 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupSubmitBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 367 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 2033 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 368 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2037 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(int loopDepth) 
	{
		loopDepth = a_body1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont2Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 360 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_SubmitBackup1Exception", randomID).error(e);
															#line 361 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 2062 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 362 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1cont2Catch1(e, loopDepth);
															#line 2066 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch2(error, 0);
		} catch (...) {
			a_body1cont2Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2Catch2(error, 0);
		} catch (...) {
			a_body1cont2Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1cont2Catch2(error, 0);
		} catch (...) {
			a_body1cont2Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(int loopDepth) 
	{
															#line 377 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (stopDifferentialDelay)
															#line 2195 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 378 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			CODE_PROBE(!stopDifferentialFuture.isReady(), "Restore starts at specified time - stopDifferential not ready");
															#line 380 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_5 = stopDifferentialFuture;
															#line 380 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2203 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont12when1(__when_expr_5.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 6;
															#line 380 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 5, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2208 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7when1(UID const& __logUid,int loopDepth) 
	{
															#line 374 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		logUid = __logUid;
															#line 2222 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(UID && __logUid,int loopDepth) 
	{
		logUid = std::move(__logUid);
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 4, UID >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 4, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 4, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 4, UID >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
															#line 431 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWaitBackup", randomID).detail("Tag", printable(tag));
															#line 433 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<UID> __when_expr_11 = backupAgent->getDestUid(cx, logUid);
															#line 433 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2305 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont12cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 12;
															#line 433 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 11, UID >*>(static_cast<DoBackupActor*>(this)));
															#line 2310 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont2(Void const& _,int loopDepth) 
	{
															#line 381 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWaitToDiscontinue", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 385 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		aborted = false;
															#line 2321 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		try {
															#line 387 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (BUGGIFY)
															#line 2325 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 388 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupWaitForRestorable", randomID).detail("Tag", printable(tag));
															#line 390 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<EBackupState> __when_expr_6 = backupAgent->waitBackup(cx, tag, StopWhenDone::False);
															#line 390 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 2333 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont12cont2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_6.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 7;
															#line 390 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 6, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 2338 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 414 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 417 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_9 = backupAgent->discontinueBackup(cx, tag);
															#line 417 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 2349 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont12cont2Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont12cont2when2(__when_expr_9.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 10;
															#line 417 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 9, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2354 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2(Void && _,int loopDepth) 
	{
															#line 381 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWaitToDiscontinue", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 385 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		aborted = false;
															#line 2372 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		try {
															#line 387 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (BUGGIFY)
															#line 2376 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 388 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupWaitForRestorable", randomID).detail("Tag", printable(tag));
															#line 390 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<EBackupState> __when_expr_6 = backupAgent->waitBackup(cx, tag, StopWhenDone::False);
															#line 390 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 2384 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont12cont2Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont12cont2when1(__when_expr_6.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 7;
															#line 390 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 6, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 2389 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 414 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 417 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_9 = backupAgent->discontinueBackup(cx, tag);
															#line 417 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 2400 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont12cont2Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont12cont2when2(__when_expr_9.get(), loopDepth); };
				static_cast<DoBackupActor*>(this)->actor_wait_state = 10;
															#line 417 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 9, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2405 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1cont12cont2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont12cont2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont3(int loopDepth) 
	{
															#line 425 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (aborted)
															#line 2496 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 426 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_10 = backupAgent->unlockBackup(cx, tag);
															#line 426 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2502 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont12cont3when1(__when_expr_10.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 11;
															#line 426 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 10, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2507 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 420 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupDiscontinueBackupException", randomID).error(e).detail("Tag", printable(tag));
															#line 421 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 2524 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 422 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2528 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont12cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont4(int loopDepth) 
	{
		loopDepth = a_body1cont12cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont5(int loopDepth) 
	{
															#line 392 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_LastBackupFolder", randomID) .detail("BackupTag", printable(tag)) .detail("LogUid", logUid) .detail("WaitStatus", resultWait);
															#line 399 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (startDelay)
															#line 2552 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 400 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupAbortBackup2", randomID) .detail("Tag", printable(tag)) .detail("WaitStatus", resultWait);
															#line 403 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			aborted = true;
															#line 404 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_7 = backupAgent->abortBackup(cx, tag);
															#line 404 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 2562 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont12cont2Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont12cont5when1(__when_expr_7.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 8;
															#line 404 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 7, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2567 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 406 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupDiscontinueBackup", randomID) .detail("Tag", printable(tag)) .detail("DifferentialAfter", stopDifferentialDelay);
															#line 409 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_8 = backupAgent->discontinueBackup(cx, tag);
															#line 409 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1cont12cont2Catch1(actor_cancelled(), loopDepth);
															#line 2578 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont12cont2Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont12cont5when2(__when_expr_8.get(), loopDepth); };
			static_cast<DoBackupActor*>(this)->actor_wait_state = 9;
															#line 409 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 8, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 2583 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont12cont2when1(EBackupState const& __resultWait,int loopDepth) 
	{
															#line 390 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		resultWait = __resultWait;
															#line 2593 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = a_body1cont12cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2when1(EBackupState && __resultWait,int loopDepth) 
	{
		resultWait = std::move(__resultWait);
		loopDepth = a_body1cont12cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 6, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 6, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 6, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 6, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont12cont6(int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont12cont8(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont8(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont6(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont5when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont5when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont5when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont5when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont12cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont12cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont12cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont12cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont12cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont12cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12cont11(int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont11(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont12cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont12cont13(UID const& _destUid,int loopDepth) 
	{
															#line 434 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		self->destUid = _destUid;
															#line 436 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<EBackupState> __when_expr_12 = backupAgent->waitBackup(cx, tag, StopWhenDone::True);
															#line 436 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3049 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont12cont13when1(__when_expr_12.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 13;
															#line 436 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 12, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 3054 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont13(UID && _destUid,int loopDepth) 
	{
															#line 434 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		self->destUid = _destUid;
															#line 436 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<EBackupState> __when_expr_12 = backupAgent->waitBackup(cx, tag, StopWhenDone::True);
															#line 436 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3067 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont12cont13when1(__when_expr_12.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 13;
															#line 436 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 12, EBackupState >*>(static_cast<DoBackupActor*>(this)));
															#line 3072 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont1when1(UID const& _destUid,int loopDepth) 
	{
		loopDepth = a_body1cont12cont13(_destUid, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont1when1(UID && _destUid,int loopDepth) 
	{
		loopDepth = a_body1cont12cont13(std::move(_destUid), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 11, UID >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 11, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 11, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 11, UID >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont12cont13cont1(int loopDepth) 
	{
															#line 437 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_13 = backupAgent->unlockBackup(cx, tag);
															#line 437 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3158 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont12cont13cont1when1(__when_expr_13.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 14;
															#line 437 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 13, Void >*>(static_cast<DoBackupActor*>(this)));
															#line 3163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont13when1(EBackupState const& __statusValue,int loopDepth) 
	{
															#line 436 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		statusValue = __statusValue;
															#line 3172 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = a_body1cont12cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont13when1(EBackupState && __statusValue,int loopDepth) 
	{
		statusValue = std::move(__statusValue);
		loopDepth = a_body1cont12cont13cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 12, EBackupState >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 12, EBackupState >*,EBackupState const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont12cont13when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 12, EBackupState >*,EBackupState && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont12cont13when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 12, EBackupState >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont12cont13cont2(Void const& _,int loopDepth) 
	{
															#line 439 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		statusText = std::string();
															#line 441 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<std::string> __when_expr_14 = backupAgent->getStatus(cx, 5, tag);
															#line 441 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3255 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont12cont13cont2when1(__when_expr_14.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 15;
															#line 441 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 14, std::string >*>(static_cast<DoBackupActor*>(this)));
															#line 3260 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont13cont2(Void && _,int loopDepth) 
	{
															#line 439 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		statusText = std::string();
															#line 441 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<std::string> __when_expr_14 = backupAgent->getStatus(cx, 5, tag);
															#line 441 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<DoBackupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3273 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont12cont13cont2when1(__when_expr_14.get(), loopDepth); };
		static_cast<DoBackupActor*>(this)->actor_wait_state = 15;
															#line 441 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< DoBackupActor, 14, std::string >*>(static_cast<DoBackupActor*>(this)));
															#line 3278 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont12cont13cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont13cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont13cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont13cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont12cont13cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont12cont13cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont12cont13cont3(std::string const& _statusText,int loopDepth) 
	{
															#line 442 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		statusText = _statusText;
															#line 445 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupComplete", randomID) .detail("Tag", printable(tag)) .detail("Status", statusText) .detail("StatusValue", statusValue);
															#line 450 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 3366 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont13cont3(std::string && _statusText,int loopDepth) 
	{
															#line 442 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		statusText = _statusText;
															#line 445 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupComplete", randomID) .detail("Tag", printable(tag)) .detail("Status", statusText) .detail("StatusValue", statusValue);
															#line 450 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<DoBackupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DoBackupActorState(); static_cast<DoBackupActor*>(this)->destroy(); return 0; }
															#line 3382 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		new (&static_cast<DoBackupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DoBackupActorState();
		static_cast<DoBackupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12cont13cont2when1(std::string const& _statusText,int loopDepth) 
	{
		loopDepth = a_body1cont12cont13cont3(_statusText, loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont13cont2when1(std::string && _statusText,int loopDepth) 
	{
		loopDepth = a_body1cont12cont13cont3(std::move(_statusText), loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<DoBackupActor*>(this)->actor_wait_state > 0) static_cast<DoBackupActor*>(this)->actor_wait_state = 0;
		static_cast<DoBackupActor*>(this)->ActorCallback< DoBackupActor, 14, std::string >::remove();

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 14, std::string >*,std::string const& value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont12cont13cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< DoBackupActor, 14, std::string >*,std::string && value) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont12cont13cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< DoBackupActor, 14, std::string >*,Error err) 
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), 14);

	}
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	BackupToDBCorrectnessWorkload* self;
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	double startDelay;
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DatabaseBackupAgent* backupAgent;
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Database cx;
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key tag;
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> backupRanges;
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	double stopDifferentialDelay;
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Promise<Void> submitted;
															#line 316 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID randomID;
															#line 318 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Future<Void> stopDifferentialFuture;
															#line 374 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID logUid;
															#line 385 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	bool aborted;
															#line 390 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	EBackupState resultWait;
															#line 436 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	EBackupState statusValue;
															#line 439 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	std::string statusText;
															#line 3495 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
};
// This generated class is to be used only via doBackup()
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class DoBackupActor final : public Actor<Void>, public ActorCallback< DoBackupActor, 0, Void >, public ActorCallback< DoBackupActor, 1, Void >, public ActorCallback< DoBackupActor, 2, Void >, public ActorCallback< DoBackupActor, 3, Void >, public ActorCallback< DoBackupActor, 4, UID >, public ActorCallback< DoBackupActor, 5, Void >, public ActorCallback< DoBackupActor, 6, EBackupState >, public ActorCallback< DoBackupActor, 7, Void >, public ActorCallback< DoBackupActor, 8, Void >, public ActorCallback< DoBackupActor, 9, Void >, public ActorCallback< DoBackupActor, 10, Void >, public ActorCallback< DoBackupActor, 11, UID >, public ActorCallback< DoBackupActor, 12, EBackupState >, public ActorCallback< DoBackupActor, 13, Void >, public ActorCallback< DoBackupActor, 14, std::string >, public FastAllocated<DoBackupActor>, public DoBackupActorState<DoBackupActor> {
															#line 3500 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
public:
	using FastAllocated<DoBackupActor>::operator new;
	using FastAllocated<DoBackupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14299072232423101184UL, 407098747266418176UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DoBackupActor, 0, Void >;
friend struct ActorCallback< DoBackupActor, 1, Void >;
friend struct ActorCallback< DoBackupActor, 2, Void >;
friend struct ActorCallback< DoBackupActor, 3, Void >;
friend struct ActorCallback< DoBackupActor, 4, UID >;
friend struct ActorCallback< DoBackupActor, 5, Void >;
friend struct ActorCallback< DoBackupActor, 6, EBackupState >;
friend struct ActorCallback< DoBackupActor, 7, Void >;
friend struct ActorCallback< DoBackupActor, 8, Void >;
friend struct ActorCallback< DoBackupActor, 9, Void >;
friend struct ActorCallback< DoBackupActor, 10, Void >;
friend struct ActorCallback< DoBackupActor, 11, UID >;
friend struct ActorCallback< DoBackupActor, 12, EBackupState >;
friend struct ActorCallback< DoBackupActor, 13, Void >;
friend struct ActorCallback< DoBackupActor, 14, std::string >;
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DoBackupActor(BackupToDBCorrectnessWorkload* const& self,double const& startDelay,DatabaseBackupAgent* const& backupAgent,Database const& cx,Key const& tag,Standalone<VectorRef<KeyRangeRef>> const& backupRanges,double const& stopDifferentialDelay,Promise<Void> const& submitted) 
															#line 3531 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   DoBackupActorState<DoBackupActor>(self, startDelay, backupAgent, cx, tag, backupRanges, stopDifferentialDelay, submitted),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("doBackup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15925328432552866816UL, 11115638302355080704UL);
		ActorExecutionContextHelper __helper(static_cast<DoBackupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("doBackup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("doBackup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DoBackupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DoBackupActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DoBackupActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DoBackupActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DoBackupActor, 4, UID >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DoBackupActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< DoBackupActor, 6, EBackupState >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< DoBackupActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< DoBackupActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< DoBackupActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< DoBackupActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< DoBackupActor, 11, UID >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< DoBackupActor, 12, EBackupState >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< DoBackupActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< DoBackupActor, 14, std::string >*)0, actor_cancelled()); break;
		}

	}
};
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> doBackup( BackupToDBCorrectnessWorkload* const& self, double const& startDelay, DatabaseBackupAgent* const& backupAgent, Database const& cx, Key const& tag, Standalone<VectorRef<KeyRangeRef>> const& backupRanges, double const& stopDifferentialDelay, Promise<Void> const& submitted ) {
															#line 307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	return Future<Void>(new DoBackupActor(self, startDelay, backupAgent, cx, tag, backupRanges, stopDifferentialDelay, submitted));
															#line 3577 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
}

#line 452 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"

																#line 3582 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
// This generated class is to be used only via checkData()
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
template <class CheckDataActor>
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class CheckDataActorState {
															#line 3588 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
public:
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	CheckDataActorState(Database const& cx,UID const& logUid,UID const& destUid,UID const& randomID,Key const& tag,DatabaseBackupAgent* const& backupAgent,bool const& shareLogRange) 
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		 : cx(cx),
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   logUid(logUid),
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   destUid(destUid),
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   randomID(randomID),
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   tag(tag),
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupAgent(backupAgent),
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   shareLogRange(shareLogRange),
															#line 460 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupAgentKey(uidPrefixKey(logRangesRange.begin, logUid)),
															#line 461 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupLogValuesKey(uidPrefixKey(backupLogKeys.begin, destUid)),
															#line 462 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupLatestVersionsPath(uidPrefixKey(backupLatestVersionsPrefix, destUid)),
															#line 463 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupLatestVersionsKey(uidPrefixKey(backupLatestVersionsPath, logUid)),
															#line 464 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   displaySystemKeys(0)
															#line 3617 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("checkData", reinterpret_cast<unsigned long>(this));

	}
	~CheckDataActorState() 
	{
		fdb_probe_actor_destroy("checkData", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 467 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			;
															#line 3632 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckDataActorState();
		static_cast<CheckDataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 579 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (displaySystemKeys)
															#line 3655 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 580 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_9 = TaskBucket::debugPrintRange(cx, "\xff"_sr, StringRef());
															#line 580 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3661 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont1when1(__when_expr_9.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 10;
															#line 580 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 9, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 3666 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 468 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		tr = Reference<ReadYourWritesTransaction>(new ReadYourWritesTransaction(cx));
															#line 470 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_CheckLeftoverKeys", randomID).detail("BackupTag", printable(tag));
															#line 3689 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		try {
															#line 476 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_CheckLeftoverTasks", randomID).detail("BackupTag", printable(tag));
															#line 477 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = backupAgent->getTaskCount(tr);
															#line 477 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3697 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 1;
															#line 477 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 0, int64_t >*>(static_cast<CheckDataActor*>(this)));
															#line 3702 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 574 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_CheckException", randomID).error(e);
															#line 575 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_8 = tr->onError(e);
															#line 575 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3741 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1Catch1(__when_expr_8.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_8.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 9;
															#line 575 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 8, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 3746 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 478 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		waitCycles = 0;
															#line 480 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if ((taskCount) && false)
															#line 3763 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 481 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_EndingNonzeroTaskCount", randomID) .detail("BackupTag", printable(tag)) .detail("TaskCount", taskCount) .detail("WaitCycles", waitCycles);
															#line 485 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("EndingNonZeroTasks: %ld\n", (long)taskCount);
															#line 486 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = TaskBucket::debugPrintRange(cx, "\xff"_sr, StringRef());
															#line 486 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3773 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 2;
															#line 486 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 1, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 3778 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t const& __taskCount,int loopDepth) 
	{
															#line 477 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		taskCount = __taskCount;
															#line 3792 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t && __taskCount,int loopDepth) 
	{
		taskCount = std::move(__taskCount);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 489 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		;
															#line 3871 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1cont3loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(int loopDepth) 
	{
															#line 507 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_4 = tr->getRange(KeyRange(KeyRangeRef(backupAgentKey, strinc(backupAgentKey))), 100);
															#line 507 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3969 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont5when1(__when_expr_4.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 5;
															#line 507 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 4, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 3974 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont3loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1(int loopDepth) 
	{
															#line 489 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!(taskCount > 0))
															#line 3990 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
			return a_body1loopBody1cont3break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 490 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		waitCycles++;
															#line 492 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_NonzeroTaskWait", randomID) .detail("BackupTag", printable(tag)) .detail("TaskCount", taskCount) .detail("WaitCycles", waitCycles);
															#line 496 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		printf("%.6f %-10s Wait #%4d for %lld tasks to end\n", now(), randomID.toString().c_str(), waitCycles, (long long)taskCount);
															#line 502 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(5.0);
															#line 502 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4004 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1when1(__when_expr_2.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 3;
															#line 502 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 2, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 4009 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 503 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 504 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(taskCount, backupAgent->getTaskCount(tr));
															#line 504 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4035 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 4;
															#line 504 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 3, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 4040 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 503 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		tr = makeReference<ReadYourWritesTransaction>(cx);
															#line 504 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = store(taskCount, backupAgent->getTaskCount(tr));
															#line 504 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4053 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 4;
															#line 504 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 3, Void >*>(static_cast<CheckDataActor*>(this)));
															#line 4058 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont3loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont3loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont6(RangeResult const& agentValues,int loopDepth) 
	{
															#line 511 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (agentValues.size() > 0)
															#line 4229 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 512 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 513 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftoverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 516 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverMutationKeys", randomID) .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 520 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for( auto& s : agentValues ) {
															#line 521 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_LeftoverKey", randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 524 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 4243 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
		}
		else
		{
															#line 529 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 4250 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
															#line 532 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr->get(backupLatestVersionsKey);
															#line 532 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4256 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 6;
															#line 532 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 5, Optional<Value> >*>(static_cast<CheckDataActor*>(this)));
															#line 4261 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(RangeResult && agentValues,int loopDepth) 
	{
															#line 511 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (agentValues.size() > 0)
															#line 4270 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 512 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 513 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftoverMutationKeys: (%d) %s\n", agentValues.size(), printable(backupAgentKey).c_str());
															#line 516 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverMutationKeys", randomID) .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", agentValues.size()) .detail("KeySpace", printable(backupAgentKey));
															#line 520 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for( auto& s : agentValues ) {
															#line 521 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_LeftoverKey", randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 524 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 4284 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
		}
		else
		{
															#line 529 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("No left over backup agent configuration keys\n");
															#line 4291 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
															#line 532 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_5 = tr->get(backupLatestVersionsKey);
															#line 532 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4297 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1loopBody1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1loopBody1cont6when1(__when_expr_5.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 6;
															#line 532 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 5, Optional<Value> >*>(static_cast<CheckDataActor*>(this)));
															#line 4302 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(RangeResult const& agentValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(agentValues, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5when1(RangeResult && agentValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(agentValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 4, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 4, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 4, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 4, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont7(Optional<Value> const& latestVersion,int loopDepth) 
	{
															#line 533 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (latestVersion.present())
															#line 4386 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 534 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverVersionKey", randomID) .detail("BackupTag", printable(tag)) .detail("Key", backupLatestVersionsKey.printable()) .detail("Value", BinaryReader::fromStringRef<Version>(latestVersion.get(), Unversioned()));
															#line 4390 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
		else
		{
															#line 539 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("No left over backup version key\n");
															#line 4396 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
															#line 542 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = tr->getRange(KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 542 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4402 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 7;
															#line 542 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 6, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 4407 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont7(Optional<Value> && latestVersion,int loopDepth) 
	{
															#line 533 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (latestVersion.present())
															#line 4416 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 534 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverVersionKey", randomID) .detail("BackupTag", printable(tag)) .detail("Key", backupLatestVersionsKey.printable()) .detail("Value", BinaryReader::fromStringRef<Version>(latestVersion.get(), Unversioned()));
															#line 4420 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
		else
		{
															#line 539 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("No left over backup version key\n");
															#line 4426 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
															#line 542 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<RangeResult> __when_expr_6 = tr->getRange(KeyRange(KeyRangeRef(backupLatestVersionsPath, strinc(backupLatestVersionsPath))), 1);
															#line 542 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4432 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1loopBody1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1loopBody1cont7when1(__when_expr_6.get(), loopDepth); };
		static_cast<CheckDataActor*>(this)->actor_wait_state = 7;
															#line 542 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 6, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 4437 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<Value> const& latestVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(latestVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont6when1(Optional<Value> && latestVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(latestVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 5, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 5, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 5, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 5, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1loopBody1cont11(RangeResult const& versions,int loopDepth) 
	{
															#line 544 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!shareLogRange || !versions.size())
															#line 4521 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 545 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_7 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 545 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4527 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont11when1(__when_expr_7.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 8;
															#line 545 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 7, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 4532 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont11(RangeResult && versions,int loopDepth) 
	{
															#line 544 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!shareLogRange || !versions.size())
															#line 4546 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 545 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<RangeResult> __when_expr_7 = tr->getRange(KeyRange(KeyRangeRef(backupLogValuesKey, strinc(backupLogValuesKey))), 100);
															#line 545 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<CheckDataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4552 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1loopBody1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1loopBody1cont11when1(__when_expr_7.get(), loopDepth); };
			static_cast<CheckDataActor*>(this)->actor_wait_state = 8;
															#line 545 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< CheckDataActor, 7, RangeResult >*>(static_cast<CheckDataActor*>(this)));
															#line 4557 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(RangeResult const& versions,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(versions, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7when1(RangeResult && versions,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(versions), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 6, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 6, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 6, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 6, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1loopBody1cont11cont1(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont11cont2(RangeResult const& logValues,int loopDepth) 
	{
															#line 549 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (logValues.size() > 0)
															#line 4652 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 550 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 551 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftoverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 554 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverLogKeys", randomID) .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey)) .detail("Version", decodeBKMutationLogKey(logValues[0].key).first);
															#line 559 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for( auto& s : logValues ) {
															#line 560 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_LeftoverKey", randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 563 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 4666 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
		}
		else
		{
															#line 568 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("No left over backup log keys\n");
															#line 4673 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11cont2(RangeResult && logValues,int loopDepth) 
	{
															#line 549 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (logValues.size() > 0)
															#line 4683 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 550 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			displaySystemKeys++;
															#line 551 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("BackupCorrectnessLeftoverLogKeys: (%d) %s\n", logValues.size(), printable(backupLogValuesKey).c_str());
															#line 554 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupCorrectnessLeftoverLogKeys", randomID) .detail("BackupTag", printable(tag)) .detail("LeftoverKeys", logValues.size()) .detail("KeySpace", printable(backupLogValuesKey)) .detail("Version", decodeBKMutationLogKey(logValues[0].key).first);
															#line 559 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for( auto& s : logValues ) {
															#line 560 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				TraceEvent("BARW_LeftoverKey", randomID) .detail("Key", printable(StringRef(s.key.toString()))) .detail("Value", printable(StringRef(s.value.toString())));
															#line 563 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				printf("   Key: %-50s  Value: %s\n", printable(StringRef(s.key.toString())).c_str(), printable(StringRef(s.value.toString())).c_str());
															#line 4697 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
		}
		else
		{
															#line 568 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			printf("No left over backup log keys\n");
															#line 4704 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont11cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(RangeResult const& logValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont2(logValues, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11when1(RangeResult && logValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11cont2(std::move(logValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 7, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 7, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 7, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 7, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 582 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<CheckDataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckDataActorState(); static_cast<CheckDataActor*>(this)->destroy(); return 0; }
															#line 4876 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		new (&static_cast<CheckDataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckDataActorState();
		static_cast<CheckDataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<CheckDataActor*>(this)->actor_wait_state > 0) static_cast<CheckDataActor*>(this)->actor_wait_state = 0;
		static_cast<CheckDataActor*>(this)->ActorCallback< CheckDataActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< CheckDataActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< CheckDataActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), 9);

	}
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Database cx;
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID logUid;
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID destUid;
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID randomID;
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key tag;
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DatabaseBackupAgent* backupAgent;
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	bool shareLogRange;
															#line 460 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key backupAgentKey;
															#line 461 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key backupLogValuesKey;
															#line 462 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key backupLatestVersionsPath;
															#line 463 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key backupLatestVersionsKey;
															#line 464 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	int displaySystemKeys;
															#line 468 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 477 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	int64_t taskCount;
															#line 478 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	int waitCycles;
															#line 5001 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
};
// This generated class is to be used only via checkData()
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class CheckDataActor final : public Actor<Void>, public ActorCallback< CheckDataActor, 0, int64_t >, public ActorCallback< CheckDataActor, 1, Void >, public ActorCallback< CheckDataActor, 2, Void >, public ActorCallback< CheckDataActor, 3, Void >, public ActorCallback< CheckDataActor, 4, RangeResult >, public ActorCallback< CheckDataActor, 5, Optional<Value> >, public ActorCallback< CheckDataActor, 6, RangeResult >, public ActorCallback< CheckDataActor, 7, RangeResult >, public ActorCallback< CheckDataActor, 8, Void >, public ActorCallback< CheckDataActor, 9, Void >, public FastAllocated<CheckDataActor>, public CheckDataActorState<CheckDataActor> {
															#line 5006 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
public:
	using FastAllocated<CheckDataActor>::operator new;
	using FastAllocated<CheckDataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12873919189143843840UL, 15580536047259998720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckDataActor, 0, int64_t >;
friend struct ActorCallback< CheckDataActor, 1, Void >;
friend struct ActorCallback< CheckDataActor, 2, Void >;
friend struct ActorCallback< CheckDataActor, 3, Void >;
friend struct ActorCallback< CheckDataActor, 4, RangeResult >;
friend struct ActorCallback< CheckDataActor, 5, Optional<Value> >;
friend struct ActorCallback< CheckDataActor, 6, RangeResult >;
friend struct ActorCallback< CheckDataActor, 7, RangeResult >;
friend struct ActorCallback< CheckDataActor, 8, Void >;
friend struct ActorCallback< CheckDataActor, 9, Void >;
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	CheckDataActor(Database const& cx,UID const& logUid,UID const& destUid,UID const& randomID,Key const& tag,DatabaseBackupAgent* const& backupAgent,bool const& shareLogRange) 
															#line 5032 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   CheckDataActorState<CheckDataActor>(cx, logUid, destUid, randomID, tag, backupAgent, shareLogRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkData", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12159733170968748032UL, 9261654583238461696UL);
		ActorExecutionContextHelper __helper(static_cast<CheckDataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkData");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkData", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckDataActor, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckDataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CheckDataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CheckDataActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< CheckDataActor, 4, RangeResult >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< CheckDataActor, 5, Optional<Value> >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< CheckDataActor, 6, RangeResult >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< CheckDataActor, 7, RangeResult >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< CheckDataActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< CheckDataActor, 9, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> checkData( Database const& cx, UID const& logUid, UID const& destUid, UID const& randomID, Key const& tag, DatabaseBackupAgent* const& backupAgent, bool const& shareLogRange ) {
															#line 453 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	return Future<Void>(new CheckDataActor(cx, logUid, destUid, randomID, tag, backupAgent, shareLogRange));
															#line 5073 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
}

#line 584 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"

																#line 5078 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 585 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
template <class _startActor>
															#line 585 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class _startActorState {
															#line 5084 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
public:
															#line 585 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	_startActorState(Database const& cx,BackupToDBCorrectnessWorkload* const& self) 
															#line 585 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
															#line 585 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		 : cx(cx),
															#line 585 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   self(self),
															#line 586 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   backupAgent(cx),
															#line 587 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   restoreTool(self->extraDB),
															#line 588 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		   extraBackup()
															#line 5099 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 589 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 589 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5116 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 589 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, DatabaseConfiguration >*>(static_cast<_startActor*>(this)));
															#line 5121 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 590 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_Arguments") .detail("BackupTag", printable(self->backupTag)) .detail("BackupAfter", self->backupAfter) .detail("AbortAndRestartAfter", self->abortAndRestartAfter) .detail("DifferentialAfter", self->stopDifferentialAfter);
															#line 596 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		randomID = nondeterministicRandom()->randomUniqueID();
															#line 599 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->agentRequest)
															#line 5148 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 600 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			BackupToDBCorrectnessWorkload::drAgentRequests++;
															#line 5152 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
		try {
															#line 604 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			startRestore = delay(self->restoreAfter);
															#line 607 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(self->backupAfter);
															#line 607 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5161 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 607 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 5166 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& __config,int loopDepth) 
	{
															#line 589 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		config = __config;
															#line 5181 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && __config,int loopDepth) 
	{
		config = std::move(__config);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 813 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 5260 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 809 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent(SevError, "BackupAndRestoreCorrectness").error(e);
															#line 810 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 5275 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 609 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackup1", randomID).detail("Tag", printable(self->backupTag));
															#line 610 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		submitted = Promise<Void>();
															#line 611 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		b = doBackup(self, 0, &backupAgent, self->extraDB, self->backupTag, self->backupRanges, self->stopDifferentialAfter, submitted);
															#line 620 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->abortAndRestartAfter)
															#line 5295 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 621 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackup2", randomID) .detail("Tag", printable(self->backupTag)) .detail("AbortWait", self->abortAndRestartAfter);
															#line 624 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = submitted.getFuture();
															#line 624 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5303 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 624 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 5308 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 609 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackup1", randomID).detail("Tag", printable(self->backupTag));
															#line 610 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		submitted = Promise<Void>();
															#line 611 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		b = doBackup(self, 0, &backupAgent, self->extraDB, self->backupTag, self->backupRanges, self->stopDifferentialAfter, submitted);
															#line 620 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->abortAndRestartAfter)
															#line 5328 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 621 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackup2", randomID) .detail("Tag", printable(self->backupTag)) .detail("AbortWait", self->abortAndRestartAfter);
															#line 624 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_2 = submitted.getFuture();
															#line 624 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5336 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 624 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 5341 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont5(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 636 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupWait", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 639 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_3 = b;
															#line 639 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5434 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 639 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 5439 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 626 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		b = b && doBackup(self, self->abortAndRestartAfter, &backupAgent, self->extraDB, self->backupTag, self->backupRanges, self->stopDifferentialAfter, Promise<Void>());
															#line 5448 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 626 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		b = b && doBackup(self, self->abortAndRestartAfter, &backupAgent, self->extraDB, self->backupTag, self->backupRanges, self->stopDifferentialAfter, Promise<Void>());
															#line 5457 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 640 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupDone", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 644 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<UID> __when_expr_4 = backupAgent.getLogUid(self->extraDB, self->backupTag);
															#line 644 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5545 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 644 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, UID >*>(static_cast<_startActor*>(this)));
															#line 5550 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 640 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_DoBackupDone", randomID) .detail("BackupTag", printable(self->backupTag)) .detail("AbortAndRestartAfter", self->abortAndRestartAfter);
															#line 644 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<UID> __when_expr_4 = backupAgent.getLogUid(self->extraDB, self->backupTag);
															#line 644 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5563 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont8when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 644 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, UID >*>(static_cast<_startActor*>(this)));
															#line 5568 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 647 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (!self->locked && self->extraPrefix != self->backupPrefix && BUGGIFY)
															#line 5652 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 648 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_SubmitBackup2", randomID).detail("Tag", printable(self->backupTag));
															#line 5656 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			try {
															#line 650 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				extraBackup = backupAgent.submitBackup(self->extraDB, self->backupTag, self->backupRanges, StopWhenDone::True, self->extraPrefix, StringRef(), self->locked, DatabaseBackupAgent::PreBackupAction::CLEAR);
															#line 5660 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				loopDepth = a_body1cont13(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1cont9Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont9Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont10(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8when1(UID const& __logUid,int loopDepth) 
	{
															#line 644 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		logUid = __logUid;
															#line 5680 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(UID && __logUid,int loopDepth) 
	{
		logUid = std::move(__logUid);
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, UID >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, UID >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont10(int loopDepth) 
	{
															#line 667 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		CODE_PROBE(!startRestore.isReady(), "Restore starts at specified time");
															#line 668 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_5 = startRestore;
															#line 668 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 5763 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont10when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 668 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 5768 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11(int loopDepth) 
	{
		loopDepth = a_body1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1cont9Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 659 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_SubmitBackup2Exception", randomID) .error(e) .detail("BackupTag", printable(self->backupTag));
															#line 662 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 5786 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 663 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1cont1Catch1(e, loopDepth);
															#line 5790 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1(Void const& _,int loopDepth) 
	{
															#line 670 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->performRestore)
															#line 5819 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 672 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_Restore", randomID) .detail("RestoreAfter", self->restoreAfter) .detail("BackupTag", printable(self->restoreTag));
															#line 677 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			restoreRange = Standalone<VectorRef<KeyRangeRef>>();
															#line 678 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			systemRestoreRange = Standalone<VectorRef<KeyRangeRef>>();
															#line 679 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for( auto r : self->backupRanges ) {
															#line 680 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (config.tenantMode != TenantMode::REQUIRED || !r.intersects(getSystemBackupRanges()))
															#line 5831 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				{
															#line 681 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					restoreRange.push_back_deep( restoreRange.arena(), KeyRangeRef(r.begin.withPrefix(self->backupPrefix), r.end.withPrefix(self->backupPrefix)));
															#line 5835 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				}
				else
				{
															#line 685 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					KeyRangeRef normalKeyRange = r & normalKeys;
															#line 686 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					KeyRangeRef systemKeyRange = r & systemKeys;
															#line 687 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (!normalKeyRange.empty())
															#line 5845 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					{
															#line 688 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
						restoreRange.push_back_deep(restoreRange.arena(), KeyRangeRef(normalKeyRange.begin.withPrefix(self->backupPrefix), normalKeyRange.end.withPrefix(self->backupPrefix)));
															#line 5849 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					}
															#line 692 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (!systemKeyRange.empty())
															#line 5853 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					{
															#line 693 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
						systemRestoreRange.push_back_deep(systemRestoreRange.arena(), systemKeyRange);
															#line 5857 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					}
				}
			}
															#line 699 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (!systemRestoreRange.empty())
															#line 5863 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 700 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				systemRestoreTag = "restore_system"_sr;
															#line 5867 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				try {
															#line 702 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					StrictFuture<Void> __when_expr_6 = restoreTool.submitBackup(cx, systemRestoreTag, systemRestoreRange, StopWhenDone::True, StringRef(), self->backupPrefix, self->locked, DatabaseBackupAgent::PreBackupAction::CLEAR);
															#line 702 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont10cont1Catch1(actor_cancelled(), loopDepth);
															#line 5873 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont10cont1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_6.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 702 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 5878 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1cont10cont1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont10cont1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont10cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont10cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont1(Void && _,int loopDepth) 
	{
															#line 670 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->performRestore)
															#line 5903 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 672 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_Restore", randomID) .detail("RestoreAfter", self->restoreAfter) .detail("BackupTag", printable(self->restoreTag));
															#line 677 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			restoreRange = Standalone<VectorRef<KeyRangeRef>>();
															#line 678 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			systemRestoreRange = Standalone<VectorRef<KeyRangeRef>>();
															#line 679 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for( auto r : self->backupRanges ) {
															#line 680 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (config.tenantMode != TenantMode::REQUIRED || !r.intersects(getSystemBackupRanges()))
															#line 5915 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				{
															#line 681 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					restoreRange.push_back_deep( restoreRange.arena(), KeyRangeRef(r.begin.withPrefix(self->backupPrefix), r.end.withPrefix(self->backupPrefix)));
															#line 5919 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				}
				else
				{
															#line 685 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					KeyRangeRef normalKeyRange = r & normalKeys;
															#line 686 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					KeyRangeRef systemKeyRange = r & systemKeys;
															#line 687 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (!normalKeyRange.empty())
															#line 5929 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					{
															#line 688 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
						restoreRange.push_back_deep(restoreRange.arena(), KeyRangeRef(normalKeyRange.begin.withPrefix(self->backupPrefix), normalKeyRange.end.withPrefix(self->backupPrefix)));
															#line 5933 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					}
															#line 692 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (!systemKeyRange.empty())
															#line 5937 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					{
															#line 693 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
						systemRestoreRange.push_back_deep(systemRestoreRange.arena(), systemKeyRange);
															#line 5941 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					}
				}
			}
															#line 699 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (!systemRestoreRange.empty())
															#line 5947 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 700 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				systemRestoreTag = "restore_system"_sr;
															#line 5951 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				try {
															#line 702 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					StrictFuture<Void> __when_expr_6 = restoreTool.submitBackup(cx, systemRestoreTag, systemRestoreRange, StopWhenDone::True, StringRef(), self->backupPrefix, self->locked, DatabaseBackupAgent::PreBackupAction::CLEAR);
															#line 702 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont10cont1Catch1(actor_cancelled(), loopDepth);
															#line 5957 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1cont10cont1Catch1(__when_expr_6.getError(), loopDepth); else return a_body1cont10cont1when1(__when_expr_6.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 7;
															#line 702 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
					__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< _startActor, 6, Void >*>(static_cast<_startActor*>(this)));
															#line 5962 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1cont10cont1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1cont10cont1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont10cont3(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont10cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont10when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont10cont2(int loopDepth) 
	{
															#line 758 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (extraBackup.isValid())
															#line 6062 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 759 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_WaitExtraBackup", randomID).detail("BackupTag", printable(self->backupTag));
															#line 6066 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			try {
															#line 761 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				StrictFuture<Void> __when_expr_15 = extraBackup;
															#line 761 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont10cont2Catch1(actor_cancelled(), loopDepth);
															#line 6072 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				if (__when_expr_15.isReady()) { if (__when_expr_15.isError()) return a_body1cont10cont2Catch1(__when_expr_15.getError(), loopDepth); else return a_body1cont10cont2when1(__when_expr_15.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 16;
															#line 761 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				__when_expr_15.addCallbackAndClear(static_cast<ActorCallback< _startActor, 15, Void >*>(static_cast<_startActor*>(this)));
															#line 6077 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont10cont2Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont10cont2Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont10cont14(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont3(int loopDepth) 
	{
		try {
															#line 722 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_9 = restoreTool.submitBackup(cx, self->restoreTag, restoreRange, StopWhenDone::True, StringRef(), self->backupPrefix, self->locked, DatabaseBackupAgent::PreBackupAction::CLEAR);
															#line 722 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont10cont3Catch1(actor_cancelled(), loopDepth);
															#line 6100 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_9.isReady()) { if (__when_expr_9.isError()) return a_body1cont10cont3Catch1(__when_expr_9.getError(), loopDepth); else return a_body1cont10cont3when1(__when_expr_9.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 10;
															#line 722 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_9.addCallbackAndClear(static_cast<ActorCallback< _startActor, 9, Void >*>(static_cast<_startActor*>(this)));
															#line 6105 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont10cont3Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10cont3Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont9(int loopDepth) 
	{
															#line 717 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_7 = success(restoreTool.waitBackup(cx, systemRestoreTag));
															#line 717 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6122 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_7.isReady()) { if (__when_expr_7.isError()) return a_body1cont1Catch1(__when_expr_7.getError(), loopDepth); else return a_body1cont10cont9when1(__when_expr_7.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 8;
															#line 717 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_7.addCallbackAndClear(static_cast<ActorCallback< _startActor, 7, Void >*>(static_cast<_startActor*>(this)));
															#line 6127 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 711 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupSubmitBackupException", randomID) .error(e) .detail("Tag", printable(systemRestoreTag));
															#line 714 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 6139 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 715 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1cont1Catch1(e, loopDepth);
															#line 6143 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont10cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 6, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< _startActor, 6, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< _startActor, 6, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont10cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 6);

	}
	int a_body1cont10cont10cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont9(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont11(Void const& _,int loopDepth) 
	{
															#line 718 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_8 = restoreTool.unlockBackup(cx, systemRestoreTag);
															#line 718 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6261 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10cont11when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 718 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 6266 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont11(Void && _,int loopDepth) 
	{
															#line 718 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_8 = restoreTool.unlockBackup(cx, systemRestoreTag);
															#line 718 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6277 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_8.isReady()) { if (__when_expr_8.isError()) return a_body1cont1Catch1(__when_expr_8.getError(), loopDepth); else return a_body1cont10cont11when1(__when_expr_8.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 9;
															#line 718 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_8.addCallbackAndClear(static_cast<ActorCallback< _startActor, 8, Void >*>(static_cast<_startActor*>(this)));
															#line 6282 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont9when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont9when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose8() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 7, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10cont9when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_fire(ActorCallback< _startActor, 7, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont10cont9when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	void a_callback_error(ActorCallback< _startActor, 7, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 7);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose8();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 7);

	}
	int a_body1cont10cont11cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont11cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose9() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 8, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_fire(ActorCallback< _startActor, 8, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont10cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	void a_callback_error(ActorCallback< _startActor, 8, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 8);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose9();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 8);

	}
	int a_body1cont10cont12(int loopDepth) 
	{
															#line 738 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_10 = success(restoreTool.waitBackup(cx, self->restoreTag));
															#line 738 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6455 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_10.isReady()) { if (__when_expr_10.isError()) return a_body1cont1Catch1(__when_expr_10.getError(), loopDepth); else return a_body1cont10cont12when1(__when_expr_10.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 11;
															#line 738 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_10.addCallbackAndClear(static_cast<ActorCallback< _startActor, 10, Void >*>(static_cast<_startActor*>(this)));
															#line 6460 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont3Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 731 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_DoBackupSubmitBackupException", randomID) .error(e) .detail("Tag", printable(self->restoreTag));
															#line 734 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 6472 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 735 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1cont1Catch1(e, loopDepth);
															#line 6476 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont10cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont13cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose10() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 9, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_fire(ActorCallback< _startActor, 9, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	void a_callback_error(ActorCallback< _startActor, 9, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 9);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose10();
		try {
			a_body1cont10cont3Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10cont3Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont3Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 9);

	}
	int a_body1cont10cont13cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont12(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont12cont1(Void const& _,int loopDepth) 
	{
															#line 739 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_11 = restoreTool.unlockBackup(cx, self->restoreTag);
															#line 739 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6594 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont12cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 739 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 6599 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont1(Void && _,int loopDepth) 
	{
															#line 739 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_11 = restoreTool.unlockBackup(cx, self->restoreTag);
															#line 739 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6610 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_11.isReady()) { if (__when_expr_11.isError()) return a_body1cont1Catch1(__when_expr_11.getError(), loopDepth); else return a_body1cont10cont12cont1when1(__when_expr_11.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 12;
															#line 739 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_11.addCallbackAndClear(static_cast<ActorCallback< _startActor, 11, Void >*>(static_cast<_startActor*>(this)));
															#line 6615 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose11() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 10, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_fire(ActorCallback< _startActor, 10, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont10cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	void a_callback_error(ActorCallback< _startActor, 10, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 10);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose11();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 10);

	}
	int a_body1cont10cont12cont2(Void const& _,int loopDepth) 
	{
															#line 743 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<std::vector<RangeResult>> __when_expr_12 = readRanges(cx, restoreRange, self->backupPrefix);
															#line 743 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6701 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont10cont12cont2when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 743 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, std::vector<RangeResult> >*>(static_cast<_startActor*>(this)));
															#line 6706 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont2(Void && _,int loopDepth) 
	{
															#line 743 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<std::vector<RangeResult>> __when_expr_12 = readRanges(cx, restoreRange, self->backupPrefix);
															#line 743 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6717 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_12.isReady()) { if (__when_expr_12.isError()) return a_body1cont1Catch1(__when_expr_12.getError(), loopDepth); else return a_body1cont10cont12cont2when1(__when_expr_12.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 13;
															#line 743 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_12.addCallbackAndClear(static_cast<ActorCallback< _startActor, 12, std::vector<RangeResult> >*>(static_cast<_startActor*>(this)));
															#line 6722 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose12() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 11, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont12cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_fire(ActorCallback< _startActor, 11, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont10cont12cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	void a_callback_error(ActorCallback< _startActor, 11, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 11);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose12();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 11);

	}
	int a_body1cont10cont12cont3(int loopDepth) 
	{
															#line 744 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_13 = delay(5);
															#line 744 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6808 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_13.isReady()) { if (__when_expr_13.isError()) return a_body1cont1Catch1(__when_expr_13.getError(), loopDepth); else return a_body1cont10cont12cont3when1(__when_expr_13.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 14;
															#line 744 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_13.addCallbackAndClear(static_cast<ActorCallback< _startActor, 13, Void >*>(static_cast<_startActor*>(this)));
															#line 6813 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont2when1(std::vector<RangeResult> const& __res1,int loopDepth) 
	{
															#line 743 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		res1 = __res1;
															#line 6822 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = a_body1cont10cont12cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont2when1(std::vector<RangeResult> && __res1,int loopDepth) 
	{
		res1 = std::move(__res1);
		loopDepth = a_body1cont10cont12cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose13() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 12, std::vector<RangeResult> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 12, std::vector<RangeResult> >*,std::vector<RangeResult> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont12cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_fire(ActorCallback< _startActor, 12, std::vector<RangeResult> >*,std::vector<RangeResult> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont10cont12cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	void a_callback_error(ActorCallback< _startActor, 12, std::vector<RangeResult> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 12);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose13();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 12);

	}
	int a_body1cont10cont12cont4(Void const& _,int loopDepth) 
	{
															#line 745 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<std::vector<RangeResult>> __when_expr_14 = readRanges(cx, restoreRange, self->backupPrefix);
															#line 745 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6903 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont12cont4when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 745 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, std::vector<RangeResult> >*>(static_cast<_startActor*>(this)));
															#line 6908 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont4(Void && _,int loopDepth) 
	{
															#line 745 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<std::vector<RangeResult>> __when_expr_14 = readRanges(cx, restoreRange, self->backupPrefix);
															#line 745 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 6919 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_14.isReady()) { if (__when_expr_14.isError()) return a_body1cont1Catch1(__when_expr_14.getError(), loopDepth); else return a_body1cont10cont12cont4when1(__when_expr_14.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 15;
															#line 745 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_14.addCallbackAndClear(static_cast<ActorCallback< _startActor, 14, std::vector<RangeResult> >*>(static_cast<_startActor*>(this)));
															#line 6924 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont12cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont12cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose14() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 13, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont12cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_fire(ActorCallback< _startActor, 13, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont10cont12cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	void a_callback_error(ActorCallback< _startActor, 13, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 13);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose14();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 13);

	}
	int a_body1cont10cont12cont5(int loopDepth) 
	{
															#line 746 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		ASSERT(res1.size() == res2.size());
															#line 747 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		for(int i = 0;i < res1.size();++i) {
															#line 748 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			auto range1 = res1.at(i);
															#line 749 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			auto range2 = res2.at(i);
															#line 750 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			ASSERT(range1.size() == range2.size());
															#line 752 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			for(int j = 0;j < range1.size();++j) {
															#line 753 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				ASSERT(range1[j].key == range2[j].key && range1[j].value == range2[j].value);
															#line 7020 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
		}
		loopDepth = a_body1cont10cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont4when1(std::vector<RangeResult> const& __res2,int loopDepth) 
	{
															#line 745 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		res2 = __res2;
															#line 7031 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = a_body1cont10cont12cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont12cont4when1(std::vector<RangeResult> && __res2,int loopDepth) 
	{
		res2 = std::move(__res2);
		loopDepth = a_body1cont10cont12cont5(loopDepth);

		return loopDepth;
	}
	void a_exitChoose15() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 14, std::vector<RangeResult> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 14, std::vector<RangeResult> >*,std::vector<RangeResult> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont12cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_fire(ActorCallback< _startActor, 14, std::vector<RangeResult> >*,std::vector<RangeResult> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont10cont12cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	void a_callback_error(ActorCallback< _startActor, 14, std::vector<RangeResult> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 14);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose15();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 14);

	}
	int a_body1cont10cont14(int loopDepth) 
	{
															#line 787 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_17 = checkData( self->extraDB, logUid, self->destUid, randomID, self->backupTag, &backupAgent, self->shareLogRange);
															#line 787 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 7112 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_17.isReady()) { if (__when_expr_17.isError()) return a_body1cont1Catch1(__when_expr_17.getError(), loopDepth); else return a_body1cont10cont14when1(__when_expr_17.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 18;
															#line 787 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_17.addCallbackAndClear(static_cast<ActorCallback< _startActor, 17, Void >*>(static_cast<_startActor*>(this)));
															#line 7117 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont15(int loopDepth) 
	{
															#line 770 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_AbortBackupExtra", randomID).detail("BackupTag", printable(self->backupTag));
															#line 7126 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		try {
															#line 774 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_16 = backupAgent.abortBackup(self->extraDB, self->backupTag, PartialBackup::False, AbortOldBackup::False, DstOnly::False, WaitForDestUID::True);
															#line 774 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont10cont15Catch1(actor_cancelled(), loopDepth);
															#line 7132 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_16.isReady()) { if (__when_expr_16.isError()) return a_body1cont10cont15Catch1(__when_expr_16.getError(), loopDepth); else return a_body1cont10cont15when1(__when_expr_16.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 17;
															#line 774 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_16.addCallbackAndClear(static_cast<ActorCallback< _startActor, 16, Void >*>(static_cast<_startActor*>(this)));
															#line 7137 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont10cont15Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont10cont15Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 763 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_ExtraBackupException", randomID) .error(e) .detail("BackupTag", printable(self->backupTag));
															#line 766 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded && e.code() != error_code_backup_duplicate)
															#line 7155 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 767 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1cont1Catch1(e, loopDepth);
															#line 7159 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont10cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont16(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont16(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont16(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose16() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 15, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_fire(ActorCallback< _startActor, 15, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	void a_callback_error(ActorCallback< _startActor, 15, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 15);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose16();
		try {
			a_body1cont10cont2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10cont2Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 15);

	}
	int a_body1cont10cont16cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont15cont1(int loopDepth) 
	{
		loopDepth = a_body1cont10cont14(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont15Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 781 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			TraceEvent("BARW_AbortBackupExtraException", randomID).error(e);
															#line 782 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (e.code() != error_code_backup_unneeded)
															#line 7284 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			{
															#line 783 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
				return a_body1cont1Catch1(e, loopDepth);
															#line 7288 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			}
			loopDepth = a_body1cont10cont15cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont15cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont15cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont15when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont15when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont15cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose17() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 16, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 16, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont15when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont10cont15Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont15Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_fire(ActorCallback< _startActor, 16, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont15when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont10cont15Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont15Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	void a_callback_error(ActorCallback< _startActor, 16, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 16);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose17();
		try {
			a_body1cont10cont15Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont10cont15Catch1(error, 0);
		} catch (...) {
			a_body1cont10cont15Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 16);

	}
	int a_body1cont10cont15cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont10cont15cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont14cont1(Void const& _,int loopDepth) 
	{
															#line 790 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->performRestore)
															#line 7404 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 791 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<UID> __when_expr_18 = backupAgent.getLogUid(self->extraDB, self->restoreTag);
															#line 791 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 7410 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont10cont14cont1when1(__when_expr_18.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 19;
															#line 791 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _startActor, 18, UID >*>(static_cast<_startActor*>(this)));
															#line 7415 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont14cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont14cont1(Void && _,int loopDepth) 
	{
															#line 790 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->performRestore)
															#line 7429 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 791 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			StrictFuture<UID> __when_expr_18 = backupAgent.getLogUid(self->extraDB, self->restoreTag);
															#line 791 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 7435 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			if (__when_expr_18.isReady()) { if (__when_expr_18.isError()) return a_body1cont1Catch1(__when_expr_18.getError(), loopDepth); else return a_body1cont10cont14cont1when1(__when_expr_18.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 19;
															#line 791 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			__when_expr_18.addCallbackAndClear(static_cast<ActorCallback< _startActor, 18, UID >*>(static_cast<_startActor*>(this)));
															#line 7440 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont10cont14cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont10cont14when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose18() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 17, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 17, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont10cont14when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_fire(ActorCallback< _startActor, 17, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont10cont14when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	void a_callback_error(ActorCallback< _startActor, 17, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 17);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose18();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 17);

	}
	int a_body1cont10cont14cont2(int loopDepth) 
	{
															#line 796 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		TraceEvent("BARW_Complete", randomID).detail("BackupTag", printable(self->backupTag));
															#line 799 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (self->agentRequest)
															#line 7531 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 800 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			BackupToDBCorrectnessWorkload::drAgentRequests--;
															#line 7535 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
															#line 804 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if ((g_simulator->drAgents == ISimulator::BackupAgentType::BackupToDB) && (!BackupToDBCorrectnessWorkload::drAgentRequests))
															#line 7539 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		{
															#line 806 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
			g_simulator->drAgents = ISimulator::BackupAgentType::NoBackupAgents;
															#line 7543 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		}
		loopDepth = a_body1cont10cont14cont8(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14cont3(int loopDepth) 
	{
															#line 792 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_19 = checkData( cx, restoreUid, restoreUid, randomID, self->restoreTag, &restoreTool, self->shareLogRange);
															#line 792 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), loopDepth);
															#line 7555 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		if (__when_expr_19.isReady()) { if (__when_expr_19.isError()) return a_body1cont1Catch1(__when_expr_19.getError(), loopDepth); else return a_body1cont10cont14cont3when1(__when_expr_19.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 20;
															#line 792 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		__when_expr_19.addCallbackAndClear(static_cast<ActorCallback< _startActor, 19, Void >*>(static_cast<_startActor*>(this)));
															#line 7560 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont10cont14cont1when1(UID const& __restoreUid,int loopDepth) 
	{
															#line 791 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
		restoreUid = __restoreUid;
															#line 7569 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		loopDepth = a_body1cont10cont14cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14cont1when1(UID && __restoreUid,int loopDepth) 
	{
		restoreUid = std::move(__restoreUid);
		loopDepth = a_body1cont10cont14cont3(loopDepth);

		return loopDepth;
	}
	void a_exitChoose19() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 18, UID >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 18, UID >*,UID const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont10cont14cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_fire(ActorCallback< _startActor, 18, UID >*,UID && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont10cont14cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	void a_callback_error(ActorCallback< _startActor, 18, UID >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 18);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose19();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 18);

	}
	int a_body1cont10cont14cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont10cont14cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10cont14cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose20() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 19, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 19, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont10cont14cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_fire(ActorCallback< _startActor, 19, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont10cont14cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	void a_callback_error(ActorCallback< _startActor, 19, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 19);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose20();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 19);

	}
	int a_body1cont10cont14cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 585 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Database cx;
															#line 585 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	BackupToDBCorrectnessWorkload* self;
															#line 586 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DatabaseBackupAgent backupAgent;
															#line 587 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DatabaseBackupAgent restoreTool;
															#line 588 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Future<Void> extraBackup;
															#line 589 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	DatabaseConfiguration config;
															#line 596 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID randomID;
															#line 604 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Future<Void> startRestore;
															#line 610 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Promise<Void> submitted;
															#line 611 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Future<Void> b;
															#line 644 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID logUid;
															#line 677 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> restoreRange;
															#line 678 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Standalone<VectorRef<KeyRangeRef>> systemRestoreRange;
															#line 700 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	Key systemRestoreTag;
															#line 743 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	std::vector<RangeResult> res1;
															#line 745 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	std::vector<RangeResult> res2;
															#line 791 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	UID restoreUid;
															#line 7778 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 585 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, DatabaseConfiguration >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, UID >, public ActorCallback< _startActor, 5, Void >, public ActorCallback< _startActor, 6, Void >, public ActorCallback< _startActor, 7, Void >, public ActorCallback< _startActor, 8, Void >, public ActorCallback< _startActor, 9, Void >, public ActorCallback< _startActor, 10, Void >, public ActorCallback< _startActor, 11, Void >, public ActorCallback< _startActor, 12, std::vector<RangeResult> >, public ActorCallback< _startActor, 13, Void >, public ActorCallback< _startActor, 14, std::vector<RangeResult> >, public ActorCallback< _startActor, 15, Void >, public ActorCallback< _startActor, 16, Void >, public ActorCallback< _startActor, 17, Void >, public ActorCallback< _startActor, 18, UID >, public ActorCallback< _startActor, 19, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 7783 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16284968767511393024UL, 3009314503842558976UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, DatabaseConfiguration >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, UID >;
friend struct ActorCallback< _startActor, 5, Void >;
friend struct ActorCallback< _startActor, 6, Void >;
friend struct ActorCallback< _startActor, 7, Void >;
friend struct ActorCallback< _startActor, 8, Void >;
friend struct ActorCallback< _startActor, 9, Void >;
friend struct ActorCallback< _startActor, 10, Void >;
friend struct ActorCallback< _startActor, 11, Void >;
friend struct ActorCallback< _startActor, 12, std::vector<RangeResult> >;
friend struct ActorCallback< _startActor, 13, Void >;
friend struct ActorCallback< _startActor, 14, std::vector<RangeResult> >;
friend struct ActorCallback< _startActor, 15, Void >;
friend struct ActorCallback< _startActor, 16, Void >;
friend struct ActorCallback< _startActor, 17, Void >;
friend struct ActorCallback< _startActor, 18, UID >;
friend struct ActorCallback< _startActor, 19, Void >;
															#line 585 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	_startActor(Database const& cx,BackupToDBCorrectnessWorkload* const& self) 
															#line 7819 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, UID >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		case 7: this->a_callback_error((ActorCallback< _startActor, 6, Void >*)0, actor_cancelled()); break;
		case 8: this->a_callback_error((ActorCallback< _startActor, 7, Void >*)0, actor_cancelled()); break;
		case 9: this->a_callback_error((ActorCallback< _startActor, 8, Void >*)0, actor_cancelled()); break;
		case 10: this->a_callback_error((ActorCallback< _startActor, 9, Void >*)0, actor_cancelled()); break;
		case 11: this->a_callback_error((ActorCallback< _startActor, 10, Void >*)0, actor_cancelled()); break;
		case 12: this->a_callback_error((ActorCallback< _startActor, 11, Void >*)0, actor_cancelled()); break;
		case 13: this->a_callback_error((ActorCallback< _startActor, 12, std::vector<RangeResult> >*)0, actor_cancelled()); break;
		case 14: this->a_callback_error((ActorCallback< _startActor, 13, Void >*)0, actor_cancelled()); break;
		case 15: this->a_callback_error((ActorCallback< _startActor, 14, std::vector<RangeResult> >*)0, actor_cancelled()); break;
		case 16: this->a_callback_error((ActorCallback< _startActor, 15, Void >*)0, actor_cancelled()); break;
		case 17: this->a_callback_error((ActorCallback< _startActor, 16, Void >*)0, actor_cancelled()); break;
		case 18: this->a_callback_error((ActorCallback< _startActor, 17, Void >*)0, actor_cancelled()); break;
		case 19: this->a_callback_error((ActorCallback< _startActor, 18, UID >*)0, actor_cancelled()); break;
		case 20: this->a_callback_error((ActorCallback< _startActor, 19, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 585 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, BackupToDBCorrectnessWorkload* const& self ) {
															#line 585 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 7870 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/BackupToDBCorrectness.actor.g.cpp"
}

#line 815 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/workloads/BackupToDBCorrectness.actor.cpp"
};

int BackupToDBCorrectnessWorkload::drAgentRequests = 0;

WorkloadFactory<BackupToDBCorrectnessWorkload> BackupToDBCorrectnessWorkloadFactory;
