#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
/*
 * BulkSetup.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

// When actually compiled (NO_INTELLISENSE), include the generated
// version of this file.  In intellisense use the source version.
#if defined(NO_INTELLISENSE) && !defined(FDBSERVER_BULK_SETUP_ACTOR_G_H)
#define FDBSERVER_BULK_SETUP_ACTOR_G_H
#include "fdbserver/workloads/BulkSetup.actor.g.h"
#elif !defined(FDBSERVER_BULK_SETUP_ACTOR_H)
#define FDBSERVER_BULK_SETUP_ACTOR_H

#include <string>
#include <utility>
#include <vector>

#include "fdbclient/ClientBooleanParams.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbrpc/simulator.h"
#include "flow/actorcompiler.h" // This must be the last #include.

template <class T>
struct sfinae_true : std::true_type {};

template <class T>
auto testAuthToken(int) -> sfinae_true<decltype(std::declval<T>().setAuthToken(std::declval<Transaction&>()))>;
template <class>
auto testAuthToken(long) -> std::false_type;

template <class T>
struct hasAuthToken : decltype(testAuthToken<T>(0)) {};

template <class T>
void setAuthToken(T const& self, Transaction& tr) {
	if constexpr (hasAuthToken<T>::value) {
		self.setAuthToken(tr);
	}
}

															#line 63 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
namespace {
// This generated class is to be used only via checkRangeSimpleValueSize()
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T, class CheckRangeSimpleValueSizeActor>
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
class CheckRangeSimpleValueSizeActorState {
															#line 70 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
public:
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	CheckRangeSimpleValueSizeActorState(Database const& cx,T* const& workload,uint64_t const& begin,uint64_t const& end,Optional<Reference<Tenant>> const& tenant) 
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		 : cx(cx),
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   workload(workload),
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   begin(begin),
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   end(end),
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   tenant(tenant)
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
	{
		fdb_probe_actor_create("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this));

	}
	~CheckRangeSimpleValueSizeActorState() 
	{
		fdb_probe_actor_destroy("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 67 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			;
															#line 100 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckRangeSimpleValueSizeActorState();
		static_cast<CheckRangeSimpleValueSizeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 68 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		tr = Transaction(cx, tenant);
															#line 69 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		setAuthToken(*workload, tr);
															#line 132 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		try {
															#line 71 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			firstKV = (*workload)(begin);
															#line 72 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			lastKV = (*workload)(end - 1);
															#line 73 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			first = tr.get(firstKV.key);
															#line 74 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			last = tr.get(lastKV.key);
															#line 75 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			StrictFuture<Void> __when_expr_0 = success(first) && success(last);
															#line 75 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (static_cast<CheckRangeSimpleValueSizeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 146 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckRangeSimpleValueSizeActor*>(this)->actor_wait_state = 1;
															#line 75 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckRangeSimpleValueSizeActor, 0, Void >*>(static_cast<CheckRangeSimpleValueSizeActor*>(this)));
															#line 151 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 78 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			TraceEvent("CheckRangeError").error(e).detail("Begin", begin).detail("End", end);
															#line 79 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 79 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (static_cast<CheckRangeSimpleValueSizeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 177 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckRangeSimpleValueSizeActor*>(this)->actor_wait_state = 2;
															#line 79 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckRangeSimpleValueSizeActor, 1, Void >*>(static_cast<CheckRangeSimpleValueSizeActor*>(this)));
															#line 182 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 76 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (!static_cast<CheckRangeSimpleValueSizeActor*>(this)->SAV<bool>::futures) { (void)(first.get().present() && last.get().present()); this->~CheckRangeSimpleValueSizeActorState(); static_cast<CheckRangeSimpleValueSizeActor*>(this)->destroy(); return 0; }
															#line 197 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		new (&static_cast<CheckRangeSimpleValueSizeActor*>(this)->SAV< bool >::value()) bool(first.get().present() && last.get().present());
		this->~CheckRangeSimpleValueSizeActorState();
		static_cast<CheckRangeSimpleValueSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 76 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (!static_cast<CheckRangeSimpleValueSizeActor*>(this)->SAV<bool>::futures) { (void)(first.get().present() && last.get().present()); this->~CheckRangeSimpleValueSizeActorState(); static_cast<CheckRangeSimpleValueSizeActor*>(this)->destroy(); return 0; }
															#line 209 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		new (&static_cast<CheckRangeSimpleValueSizeActor*>(this)->SAV< bool >::value()) bool(first.get().present() && last.get().present());
		this->~CheckRangeSimpleValueSizeActorState();
		static_cast<CheckRangeSimpleValueSizeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckRangeSimpleValueSizeActor*>(this)->actor_wait_state > 0) static_cast<CheckRangeSimpleValueSizeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRangeSimpleValueSizeActor*>(this)->ActorCallback< CheckRangeSimpleValueSizeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRangeSimpleValueSizeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeSimpleValueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckRangeSimpleValueSizeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeSimpleValueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckRangeSimpleValueSizeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeSimpleValueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckRangeSimpleValueSizeActor*>(this)->actor_wait_state > 0) static_cast<CheckRangeSimpleValueSizeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRangeSimpleValueSizeActor*>(this)->ActorCallback< CheckRangeSimpleValueSizeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRangeSimpleValueSizeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeSimpleValueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckRangeSimpleValueSizeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeSimpleValueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckRangeSimpleValueSizeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeSimpleValueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Database cx;
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	T* workload;
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	uint64_t begin;
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	uint64_t end;
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Optional<Reference<Tenant>> tenant;
															#line 68 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Transaction tr;
															#line 71 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Standalone<KeyValueRef> firstKV;
															#line 72 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Standalone<KeyValueRef> lastKV;
															#line 73 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Future<Optional<Value>> first;
															#line 74 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Future<Optional<Value>> last;
															#line 399 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
};
// This generated class is to be used only via checkRangeSimpleValueSize()
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T>
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
class CheckRangeSimpleValueSizeActor final : public Actor<bool>, public ActorCallback< CheckRangeSimpleValueSizeActor<T>, 0, Void >, public ActorCallback< CheckRangeSimpleValueSizeActor<T>, 1, Void >, public FastAllocated<CheckRangeSimpleValueSizeActor<T>>, public CheckRangeSimpleValueSizeActorState<T, CheckRangeSimpleValueSizeActor<T>> {
															#line 406 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
public:
	using FastAllocated<CheckRangeSimpleValueSizeActor<T>>::operator new;
	using FastAllocated<CheckRangeSimpleValueSizeActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16317371515024039168UL, 18020766498438436352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckRangeSimpleValueSizeActor<T>, 0, Void >;
friend struct ActorCallback< CheckRangeSimpleValueSizeActor<T>, 1, Void >;
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	CheckRangeSimpleValueSizeActor(Database const& cx,T* const& workload,uint64_t const& begin,uint64_t const& end,Optional<Reference<Tenant>> const& tenant) 
															#line 424 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		 : Actor<bool>(),
		   CheckRangeSimpleValueSizeActorState<T, CheckRangeSimpleValueSizeActor<T>>(cx, workload, begin, end, tenant),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2038183974166491136UL, 7074640470747455488UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRangeSimpleValueSizeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkRangeSimpleValueSize");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkRangeSimpleValueSize", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckRangeSimpleValueSizeActor<T>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckRangeSimpleValueSizeActor<T>, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T>
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
[[nodiscard]] Future<bool> checkRangeSimpleValueSize( Database const& cx, T* const& workload, uint64_t const& begin, uint64_t const& end, Optional<Reference<Tenant>> const& tenant ) {
															#line 61 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	return Future<bool>(new CheckRangeSimpleValueSizeActor<T>(cx, workload, begin, end, tenant));
															#line 460 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
}

#line 83 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"

// Returns true if the range was added
															#line 466 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
namespace {
// This generated class is to be used only via setupRange()
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T, class SetupRangeActor>
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
class SetupRangeActorState {
															#line 473 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
public:
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	SetupRangeActorState(Database const& cx,T* const& workload,uint64_t const& begin,uint64_t const& end,std::vector<Reference<Tenant>> const& tenants) 
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		 : cx(cx),
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   workload(workload),
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   begin(begin),
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   end(end),
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   tenants(tenants),
															#line 91 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   bytesInserted(0)
															#line 490 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
	{
		fdb_probe_actor_create("setupRange", reinterpret_cast<unsigned long>(this));

	}
	~SetupRangeActorState() 
	{
		fdb_probe_actor_destroy("setupRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 92 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			;
															#line 505 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupRangeActorState();
		static_cast<SetupRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 93 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		Optional<Reference<Tenant>> tenant;
															#line 94 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (tenants.size() > 0)
															#line 537 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 95 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			tenant = deterministicRandom()->randomChoice(tenants);
															#line 541 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
															#line 97 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		tr = Transaction(cx, tenant);
															#line 98 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		setAuthToken(*workload, tr);
															#line 547 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		try {
															#line 100 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (deterministicRandom()->random01() < 0.001)
															#line 551 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			{
															#line 101 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				tr.debugTransaction(deterministicRandom()->randomUniqueID());
															#line 555 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			}
															#line 103 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			sampleKV = (*workload)(begin);
															#line 104 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (!g_network->isSimulated() || !g_simulator->speedUpSimulation)
															#line 561 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			{
															#line 107 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				StrictFuture<Optional<Value>> __when_expr_0 = tr.get(sampleKV.key);
															#line 107 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				if (static_cast<SetupRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 567 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SetupRangeActor*>(this)->actor_wait_state = 1;
															#line 107 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupRangeActor, 0, Optional<Value> >*>(static_cast<SetupRangeActor*>(this)));
															#line 572 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1loopBody1cont3(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 137 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 137 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (static_cast<SetupRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 601 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SetupRangeActor*>(this)->actor_wait_state = 3;
															#line 137 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetupRangeActor, 2, Void >*>(static_cast<SetupRangeActor*>(this)));
															#line 606 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 127 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		tr.addWriteConflictRange(KeyRangeRef(workload->keyForIndex(begin), keyAfter(workload->keyForIndex(end))));
															#line 128 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		bytesInserted = 0;
															#line 129 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		for(uint64_t n = begin;n < end;n++) {
															#line 130 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			Standalone<KeyValueRef> kv = (*workload)(n);
															#line 131 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			tr.set(kv.key, kv.value, AddConflictRange::False);
															#line 132 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			bytesInserted += kv.key.size() + kv.value.size();
															#line 631 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
															#line 134 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 134 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (static_cast<SetupRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 637 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_1.get(), loopDepth); };
		static_cast<SetupRangeActor*>(this)->actor_wait_state = 2;
															#line 134 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetupRangeActor, 1, Void >*>(static_cast<SetupRangeActor*>(this)));
															#line 642 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Optional<Value> const& f,int loopDepth) 
	{
															#line 108 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (f.present())
															#line 651 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 116 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (!static_cast<SetupRangeActor*>(this)->SAV<uint64_t>::futures) { (void)(bytesInserted); this->~SetupRangeActorState(); static_cast<SetupRangeActor*>(this)->destroy(); return 0; }
															#line 655 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			new (&static_cast<SetupRangeActor*>(this)->SAV< uint64_t >::value()) uint64_t(std::move(bytesInserted)); // state_var_RVO
			this->~SetupRangeActorState();
			static_cast<SetupRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Optional<Value> && f,int loopDepth) 
	{
															#line 108 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (f.present())
															#line 669 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 116 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (!static_cast<SetupRangeActor*>(this)->SAV<uint64_t>::futures) { (void)(bytesInserted); this->~SetupRangeActorState(); static_cast<SetupRangeActor*>(this)->destroy(); return 0; }
															#line 673 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			new (&static_cast<SetupRangeActor*>(this)->SAV< uint64_t >::value()) uint64_t(std::move(bytesInserted)); // state_var_RVO
			this->~SetupRangeActorState();
			static_cast<SetupRangeActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(f, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && f,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(f), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupRangeActor*>(this)->actor_wait_state > 0) static_cast<SetupRangeActor*>(this)->actor_wait_state = 0;
		static_cast<SetupRangeActor*>(this)->ActorCallback< SetupRangeActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< SetupRangeActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupRangeActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupRangeActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 135 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (!static_cast<SetupRangeActor*>(this)->SAV<uint64_t>::futures) { (void)(bytesInserted); this->~SetupRangeActorState(); static_cast<SetupRangeActor*>(this)->destroy(); return 0; }
															#line 762 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		new (&static_cast<SetupRangeActor*>(this)->SAV< uint64_t >::value()) uint64_t(std::move(bytesInserted)); // state_var_RVO
		this->~SetupRangeActorState();
		static_cast<SetupRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 135 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (!static_cast<SetupRangeActor*>(this)->SAV<uint64_t>::futures) { (void)(bytesInserted); this->~SetupRangeActorState(); static_cast<SetupRangeActor*>(this)->destroy(); return 0; }
															#line 774 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		new (&static_cast<SetupRangeActor*>(this)->SAV< uint64_t >::value()) uint64_t(std::move(bytesInserted)); // state_var_RVO
		this->~SetupRangeActorState();
		static_cast<SetupRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetupRangeActor*>(this)->actor_wait_state > 0) static_cast<SetupRangeActor*>(this)->actor_wait_state = 0;
		static_cast<SetupRangeActor*>(this)->ActorCallback< SetupRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetupRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetupRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SetupRangeActor*>(this)->actor_wait_state > 0) static_cast<SetupRangeActor*>(this)->actor_wait_state = 0;
		static_cast<SetupRangeActor*>(this)->ActorCallback< SetupRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SetupRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SetupRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Database cx;
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	T* workload;
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	uint64_t begin;
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	uint64_t end;
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	std::vector<Reference<Tenant>> tenants;
															#line 91 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	uint64_t bytesInserted;
															#line 97 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Transaction tr;
															#line 103 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Standalone<KeyValueRef> sampleKV;
															#line 960 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
};
// This generated class is to be used only via setupRange()
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T>
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
class SetupRangeActor final : public Actor<uint64_t>, public ActorCallback< SetupRangeActor<T>, 0, Optional<Value> >, public ActorCallback< SetupRangeActor<T>, 1, Void >, public ActorCallback< SetupRangeActor<T>, 2, Void >, public FastAllocated<SetupRangeActor<T>>, public SetupRangeActorState<T, SetupRangeActor<T>> {
															#line 967 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
public:
	using FastAllocated<SetupRangeActor<T>>::operator new;
	using FastAllocated<SetupRangeActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8926133209281135360UL, 12132037496447030528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<uint64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupRangeActor<T>, 0, Optional<Value> >;
friend struct ActorCallback< SetupRangeActor<T>, 1, Void >;
friend struct ActorCallback< SetupRangeActor<T>, 2, Void >;
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	SetupRangeActor(Database const& cx,T* const& workload,uint64_t const& begin,uint64_t const& end,std::vector<Reference<Tenant>> const& tenants) 
															#line 986 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		 : Actor<uint64_t>(),
		   SetupRangeActorState<T, SetupRangeActor<T>>(cx, workload, begin, end, tenants),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setupRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(919425258501996032UL, 177333446925881344UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setupRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setupRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupRangeActor<T>, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetupRangeActor<T>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SetupRangeActor<T>, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T>
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
[[nodiscard]] Future<uint64_t> setupRange( Database const& cx, T* const& workload, uint64_t const& begin, uint64_t const& end, std::vector<Reference<Tenant>> const& tenants ) {
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	return Future<uint64_t>(new SetupRangeActor<T>(cx, workload, begin, end, tenants));
															#line 1023 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
}

#line 141 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"

															#line 1028 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
namespace {
// This generated class is to be used only via setupRangeWorker()
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T, class SetupRangeWorkerActor>
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
class SetupRangeWorkerActorState {
															#line 1035 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
public:
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	SetupRangeWorkerActorState(Database const& cx,T* const& workload,std::vector<std::pair<uint64_t, uint64_t>>* const& jobs,double const& maxKeyInsertRate,int const& keySaveIncrement,int const& actorId,std::vector<Reference<Tenant>> const& tenants) 
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		 : cx(cx),
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   workload(workload),
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   jobs(jobs),
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   maxKeyInsertRate(maxKeyInsertRate),
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   keySaveIncrement(keySaveIncrement),
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   actorId(actorId),
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   tenants(tenants),
															#line 150 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   nextStart(),
															#line 151 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   loadedRanges(0),
															#line 152 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   lastStoredKeysLoaded(0),
															#line 153 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   keysLoaded(0),
															#line 154 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   bytesStored(0)
															#line 1064 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
	{
		fdb_probe_actor_create("setupRangeWorker", reinterpret_cast<unsigned long>(this));

	}
	~SetupRangeWorkerActorState() 
	{
		fdb_probe_actor_destroy("setupRangeWorker", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 155 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			;
															#line 1079 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetupRangeWorkerActorState();
		static_cast<SetupRangeWorkerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 192 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (!static_cast<SetupRangeWorkerActor*>(this)->SAV<uint64_t>::futures) { (void)(loadedRanges); this->~SetupRangeWorkerActorState(); static_cast<SetupRangeWorkerActor*>(this)->destroy(); return 0; }
															#line 1102 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		new (&static_cast<SetupRangeWorkerActor*>(this)->SAV< uint64_t >::value()) uint64_t(std::move(loadedRanges)); // state_var_RVO
		this->~SetupRangeWorkerActorState();
		static_cast<SetupRangeWorkerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 155 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (!(jobs->size()))
															#line 1121 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 156 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		job = jobs->back();
															#line 157 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		jobs->pop_back();
															#line 158 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		nextStart = now() + (job.second - job.first) / maxKeyInsertRate;
															#line 159 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		StrictFuture<uint64_t> __when_expr_0 = setupRange(cx, workload, job.first, job.second, tenants);
															#line 159 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1135 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state = 1;
															#line 159 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetupRangeWorkerActor, 0, uint64_t >*>(static_cast<SetupRangeWorkerActor*>(this)));
															#line 1140 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(uint64_t const& numBytes,int loopDepth) 
	{
															#line 160 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (numBytes > 0)
															#line 1162 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 161 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			loadedRanges++;
															#line 1166 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		Optional<Reference<Tenant>> tenant;
															#line 164 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (tenants.size() > 0)
															#line 1172 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 165 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			tenant = deterministicRandom()->randomChoice(tenants);
															#line 1176 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
															#line 167 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (keySaveIncrement > 0)
															#line 1180 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 168 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			keysLoaded += job.second - job.first;
															#line 169 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			bytesStored += numBytes;
															#line 171 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (keysLoaded - lastStoredKeysLoaded >= keySaveIncrement || jobs->size() == 0)
															#line 1188 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			{
															#line 172 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				tr = Transaction(cx, tenant);
															#line 173 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				setAuthToken(*workload, tr);
															#line 1194 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				try {
															#line 175 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					std::string countKey = format("keycount|%d|%d", workload->clientId, actorId);
															#line 176 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					std::string bytesKey = format("bytesstored|%d|%d", workload->clientId, actorId);
															#line 178 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					tr.set(StringRef(countKey), StringRef((uint8_t*)&keysLoaded, sizeof(uint64_t)));
															#line 179 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					tr.set(StringRef(bytesKey), StringRef((uint8_t*)&bytesStored, sizeof(uint64_t)));
															#line 181 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 181 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					if (static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1208 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
					static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state = 2;
															#line 181 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetupRangeWorkerActor, 1, Void >*>(static_cast<SetupRangeWorkerActor*>(this)));
															#line 1213 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(uint64_t && numBytes,int loopDepth) 
	{
															#line 160 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (numBytes > 0)
															#line 1238 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 161 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			loadedRanges++;
															#line 1242 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
															#line 163 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		Optional<Reference<Tenant>> tenant;
															#line 164 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (tenants.size() > 0)
															#line 1248 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 165 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			tenant = deterministicRandom()->randomChoice(tenants);
															#line 1252 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
															#line 167 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (keySaveIncrement > 0)
															#line 1256 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 168 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			keysLoaded += job.second - job.first;
															#line 169 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			bytesStored += numBytes;
															#line 171 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (keysLoaded - lastStoredKeysLoaded >= keySaveIncrement || jobs->size() == 0)
															#line 1264 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			{
															#line 172 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				tr = Transaction(cx, tenant);
															#line 173 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				setAuthToken(*workload, tr);
															#line 1270 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				try {
															#line 175 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					std::string countKey = format("keycount|%d|%d", workload->clientId, actorId);
															#line 176 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					std::string bytesKey = format("bytesstored|%d|%d", workload->clientId, actorId);
															#line 178 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					tr.set(StringRef(countKey), StringRef((uint8_t*)&keysLoaded, sizeof(uint64_t)));
															#line 179 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					tr.set(StringRef(bytesKey), StringRef((uint8_t*)&bytesStored, sizeof(uint64_t)));
															#line 181 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 181 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					if (static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1Catch1(actor_cancelled(), loopDepth);
															#line 1284 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
					static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state = 2;
															#line 181 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetupRangeWorkerActor, 1, Void >*>(static_cast<SetupRangeWorkerActor*>(this)));
															#line 1289 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
					loopDepth = 0;
				}
				catch (Error& error) {
					loopDepth = a_body1loopBody1cont1Catch1(error, loopDepth);
				} catch (...) {
					loopDepth = a_body1loopBody1cont1Catch1(unknown_error(), loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1loopBody1cont6(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(uint64_t const& numBytes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(numBytes, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(uint64_t && numBytes,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(numBytes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state > 0) static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<SetupRangeWorkerActor*>(this)->ActorCallback< SetupRangeWorkerActor, 0, uint64_t >::remove();

	}
	void a_callback_fire(ActorCallback< SetupRangeWorkerActor, 0, uint64_t >*,uint64_t const& value) 
	{
		fdb_probe_actor_enter("setupRangeWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRangeWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetupRangeWorkerActor, 0, uint64_t >*,uint64_t && value) 
	{
		fdb_probe_actor_enter("setupRangeWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRangeWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetupRangeWorkerActor, 0, uint64_t >*,Error err) 
	{
		fdb_probe_actor_enter("setupRangeWorker", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRangeWorker", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 189 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (now() < nextStart)
															#line 1389 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 190 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			StrictFuture<Void> __when_expr_3 = delayUntil(nextStart);
															#line 190 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1395 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
			static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state = 4;
															#line 190 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SetupRangeWorkerActor, 3, Void >*>(static_cast<SetupRangeWorkerActor*>(this)));
															#line 1400 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont11(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 184 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 184 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1429 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state = 3;
															#line 184 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetupRangeWorkerActor, 2, Void >*>(static_cast<SetupRangeWorkerActor*>(this)));
															#line 1434 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
															#line 182 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		lastStoredKeysLoaded = keysLoaded;
															#line 1449 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
															#line 182 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		lastStoredKeysLoaded = keysLoaded;
															#line 1458 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state > 0) static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<SetupRangeWorkerActor*>(this)->ActorCallback< SetupRangeWorkerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupRangeWorkerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setupRangeWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRangeWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetupRangeWorkerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setupRangeWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRangeWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetupRangeWorkerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setupRangeWorker", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRangeWorker", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state > 0) static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<SetupRangeWorkerActor*>(this)->ActorCallback< SetupRangeWorkerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupRangeWorkerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setupRangeWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRangeWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SetupRangeWorkerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setupRangeWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRangeWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SetupRangeWorkerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setupRangeWorker", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRangeWorker", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont11(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state > 0) static_cast<SetupRangeWorkerActor*>(this)->actor_wait_state = 0;
		static_cast<SetupRangeWorkerActor*>(this)->ActorCallback< SetupRangeWorkerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetupRangeWorkerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setupRangeWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRangeWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SetupRangeWorkerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setupRangeWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRangeWorker", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SetupRangeWorkerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setupRangeWorker", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setupRangeWorker", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Database cx;
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	T* workload;
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	std::vector<std::pair<uint64_t, uint64_t>>* jobs;
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	double maxKeyInsertRate;
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	int keySaveIncrement;
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	int actorId;
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	std::vector<Reference<Tenant>> tenants;
															#line 150 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	double nextStart;
															#line 151 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	uint64_t loadedRanges;
															#line 152 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	int lastStoredKeysLoaded;
															#line 153 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	uint64_t keysLoaded;
															#line 154 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	uint64_t bytesStored;
															#line 156 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	std::pair<uint64_t, uint64_t> job;
															#line 172 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Transaction tr;
															#line 1759 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
};
// This generated class is to be used only via setupRangeWorker()
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T>
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
class SetupRangeWorkerActor final : public Actor<uint64_t>, public ActorCallback< SetupRangeWorkerActor<T>, 0, uint64_t >, public ActorCallback< SetupRangeWorkerActor<T>, 1, Void >, public ActorCallback< SetupRangeWorkerActor<T>, 2, Void >, public ActorCallback< SetupRangeWorkerActor<T>, 3, Void >, public FastAllocated<SetupRangeWorkerActor<T>>, public SetupRangeWorkerActorState<T, SetupRangeWorkerActor<T>> {
															#line 1766 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
public:
	using FastAllocated<SetupRangeWorkerActor<T>>::operator new;
	using FastAllocated<SetupRangeWorkerActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12709785487363865088UL, 13758545493955171072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<uint64_t>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetupRangeWorkerActor<T>, 0, uint64_t >;
friend struct ActorCallback< SetupRangeWorkerActor<T>, 1, Void >;
friend struct ActorCallback< SetupRangeWorkerActor<T>, 2, Void >;
friend struct ActorCallback< SetupRangeWorkerActor<T>, 3, Void >;
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	SetupRangeWorkerActor(Database const& cx,T* const& workload,std::vector<std::pair<uint64_t, uint64_t>>* const& jobs,double const& maxKeyInsertRate,int const& keySaveIncrement,int const& actorId,std::vector<Reference<Tenant>> const& tenants) 
															#line 1786 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		 : Actor<uint64_t>(),
		   SetupRangeWorkerActorState<T, SetupRangeWorkerActor<T>>(cx, workload, jobs, maxKeyInsertRate, keySaveIncrement, actorId, tenants),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setupRangeWorker", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17914248999843325952UL, 15982364558858387712UL);
		ActorExecutionContextHelper __helper(static_cast<SetupRangeWorkerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setupRangeWorker");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setupRangeWorker", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetupRangeWorkerActor<T>, 0, uint64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetupRangeWorkerActor<T>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SetupRangeWorkerActor<T>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SetupRangeWorkerActor<T>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T>
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
[[nodiscard]] Future<uint64_t> setupRangeWorker( Database const& cx, T* const& workload, std::vector<std::pair<uint64_t, uint64_t>>* const& jobs, double const& maxKeyInsertRate, int const& keySaveIncrement, int const& actorId, std::vector<Reference<Tenant>> const& tenants ) {
															#line 142 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	return Future<uint64_t>(new SetupRangeWorkerActor<T>(cx, workload, jobs, maxKeyInsertRate, keySaveIncrement, actorId, tenants));
															#line 1824 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
}

#line 194 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"

// Periodically determines how many keys have been inserted.  If the count has just exceeded a count of interest,
// computes the time taken to reach that mark.  Returns a vector of times (in seconds) corresponding to the counts in
// the countsOfInterest vector.

// Expects countsOfInterest to be sorted in ascending order
															#line 1834 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
[[nodiscard]] Future<std::vector<std::pair<uint64_t, double>>> trackInsertionCount( Database const& cx, std::vector<uint64_t> const& countsOfInterest, double const& checkInterval );

#line 203 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"

															#line 1839 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
namespace {
// This generated class is to be used only via waitForLowInFlight()
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T, class WaitForLowInFlightActor>
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
class WaitForLowInFlightActorState {
															#line 1846 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
public:
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	WaitForLowInFlightActorState(Database const& cx,T* const& workload) 
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		 : cx(cx),
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   workload(workload),
															#line 206 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   timeout(delay(600.0))
															#line 1857 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
	{
		fdb_probe_actor_create("waitForLowInFlight", reinterpret_cast<unsigned long>(this));

	}
	~WaitForLowInFlightActorState() 
	{
		fdb_probe_actor_destroy("waitForLowInFlight", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 207 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			;
															#line 1872 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitForLowInFlightActorState();
		static_cast<WaitForLowInFlightActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 233 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (!static_cast<WaitForLowInFlightActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitForLowInFlightActorState(); static_cast<WaitForLowInFlightActor*>(this)->destroy(); return 0; }
															#line 1895 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		new (&static_cast<WaitForLowInFlightActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitForLowInFlightActorState();
		static_cast<WaitForLowInFlightActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 209 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (timeout.isReady())
															#line 1915 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			{
															#line 210 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				return a_body1loopBody1Catch1(timed_out(), loopDepth);
															#line 1919 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			}
															#line 213 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			StrictFuture<int64_t> __when_expr_0 = getDataInFlight(cx, workload->dbInfo);
															#line 213 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1925 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state = 1;
															#line 213 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitForLowInFlightActor, 0, int64_t >*>(static_cast<WaitForLowInFlightActor*>(this)));
															#line 1930 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 223 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (e.code() == error_code_attribute_not_found || (e.code() == error_code_timed_out && !timeout.isReady()))
															#line 1965 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			{
															#line 226 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				StrictFuture<Void> __when_expr_3 = delay(1.0);
															#line 226 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				if (static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1971 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state = 4;
															#line 226 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< WaitForLowInFlightActor, 3, Void >*>(static_cast<WaitForLowInFlightActor*>(this)));
															#line 1976 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				loopDepth = 0;
			}
			else
			{
															#line 228 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				TraceEvent(SevWarn, "WaitForLowInFlightError").error(e);
															#line 229 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 1985 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int64_t const& inFlight,int loopDepth) 
	{
															#line 214 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		TraceEvent("DynamicWarming").detail("InFlight", inFlight);
															#line 215 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (inFlight > 1e6)
															#line 2002 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 216 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 216 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2008 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state = 2;
															#line 216 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForLowInFlightActor, 1, Void >*>(static_cast<WaitForLowInFlightActor*>(this)));
															#line 2013 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 218 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			StrictFuture<Void> __when_expr_2 = delay(1.0);
															#line 218 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2022 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state = 3;
															#line 218 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForLowInFlightActor, 2, Void >*>(static_cast<WaitForLowInFlightActor*>(this)));
															#line 2027 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int64_t && inFlight,int loopDepth) 
	{
															#line 214 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		TraceEvent("DynamicWarming").detail("InFlight", inFlight);
															#line 215 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (inFlight > 1e6)
															#line 2039 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 216 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 216 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2045 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state = 2;
															#line 216 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitForLowInFlightActor, 1, Void >*>(static_cast<WaitForLowInFlightActor*>(this)));
															#line 2050 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = 0;
		}
		else
		{
															#line 218 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			StrictFuture<Void> __when_expr_2 = delay(1.0);
															#line 218 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2059 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont2when2(__when_expr_2.get(), loopDepth); };
			static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state = 3;
															#line 218 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WaitForLowInFlightActor, 2, Void >*>(static_cast<WaitForLowInFlightActor*>(this)));
															#line 2064 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t const& inFlight,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(inFlight, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(int64_t && inFlight,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(inFlight), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state > 0) static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForLowInFlightActor*>(this)->ActorCallback< WaitForLowInFlightActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForLowInFlightActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForLowInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitForLowInFlightActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForLowInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitForLowInFlightActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForLowInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state > 0) static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForLowInFlightActor*>(this)->ActorCallback< WaitForLowInFlightActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForLowInFlightActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForLowInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitForLowInFlightActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForLowInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitForLowInFlightActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForLowInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 219 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		TraceEvent("DynamicWarmingDone").log();
															#line 2242 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 219 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		TraceEvent("DynamicWarmingDone").log();
															#line 2251 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state > 0) static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForLowInFlightActor*>(this)->ActorCallback< WaitForLowInFlightActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForLowInFlightActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForLowInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WaitForLowInFlightActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForLowInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont2when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WaitForLowInFlightActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForLowInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state > 0) static_cast<WaitForLowInFlightActor*>(this)->actor_wait_state = 0;
		static_cast<WaitForLowInFlightActor*>(this)->ActorCallback< WaitForLowInFlightActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitForLowInFlightActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForLowInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< WaitForLowInFlightActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForLowInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< WaitForLowInFlightActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForLowInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitForLowInFlight", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Database cx;
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	T* workload;
															#line 206 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Future<Void> timeout;
															#line 2443 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
};
// This generated class is to be used only via waitForLowInFlight()
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T>
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
class WaitForLowInFlightActor final : public Actor<Void>, public ActorCallback< WaitForLowInFlightActor<T>, 0, int64_t >, public ActorCallback< WaitForLowInFlightActor<T>, 1, Void >, public ActorCallback< WaitForLowInFlightActor<T>, 2, Void >, public ActorCallback< WaitForLowInFlightActor<T>, 3, Void >, public FastAllocated<WaitForLowInFlightActor<T>>, public WaitForLowInFlightActorState<T, WaitForLowInFlightActor<T>> {
															#line 2450 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
public:
	using FastAllocated<WaitForLowInFlightActor<T>>::operator new;
	using FastAllocated<WaitForLowInFlightActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14569653947052644608UL, 16435386585921793536UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitForLowInFlightActor<T>, 0, int64_t >;
friend struct ActorCallback< WaitForLowInFlightActor<T>, 1, Void >;
friend struct ActorCallback< WaitForLowInFlightActor<T>, 2, Void >;
friend struct ActorCallback< WaitForLowInFlightActor<T>, 3, Void >;
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	WaitForLowInFlightActor(Database const& cx,T* const& workload) 
															#line 2470 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		 : Actor<Void>(),
		   WaitForLowInFlightActorState<T, WaitForLowInFlightActor<T>>(cx, workload),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitForLowInFlight", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1101048758868715008UL, 11076377271810180608UL);
		ActorExecutionContextHelper __helper(static_cast<WaitForLowInFlightActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitForLowInFlight");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitForLowInFlight", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitForLowInFlightActor<T>, 0, int64_t >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitForLowInFlightActor<T>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WaitForLowInFlightActor<T>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< WaitForLowInFlightActor<T>, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T>
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
[[nodiscard]] Future<Void> waitForLowInFlight( Database const& cx, T* const& workload ) {
															#line 204 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	return Future<Void>(new WaitForLowInFlightActor<T>(cx, workload));
															#line 2508 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
}

#line 235 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"

															#line 2513 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
namespace {
// This generated class is to be used only via bulkSetup()
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T, class BulkSetupActor>
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
class BulkSetupActorState {
															#line 2520 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
public:
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	BulkSetupActorState(Database const& cx,T* const& workload,uint64_t const& nodeCount,Promise<double> const& setupTime,bool const& valuesInconsequential = false,double const& postSetupWarming = 0.0,double const& maxKeyInsertRate = 1e12,std::vector<uint64_t> const& insertionCountsToMeasure = std::vector<uint64_t>(),Promise<std::vector<std::pair<uint64_t, double>>> const& ratesAtKeyCounts = Promise<std::vector<std::pair<uint64_t, double>>>(),int const& keySaveIncrement = 0,double const& keyCheckInterval = 0.1,uint64_t const& startNodeIdx = 0,uint64_t const& endNodeIdx = 0,std::vector<Reference<Tenant>> const& tenants = std::vector<Reference<Tenant>>()) 
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		 : cx(cx),
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   workload(workload),
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   nodeCount(nodeCount),
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   setupTime(setupTime),
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   valuesInconsequential(valuesInconsequential),
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   postSetupWarming(postSetupWarming),
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   maxKeyInsertRate(maxKeyInsertRate),
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   insertionCountsToMeasure(insertionCountsToMeasure),
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   ratesAtKeyCounts(ratesAtKeyCounts),
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   keySaveIncrement(keySaveIncrement),
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   keyCheckInterval(keyCheckInterval),
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   startNodeIdx(startNodeIdx),
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   endNodeIdx(endNodeIdx),
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   tenants(tenants),
															#line 253 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   jobs(),
															#line 254 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   startNode(startNodeIdx ? startNodeIdx : (nodeCount * workload->clientId) / workload->clientCount),
															#line 255 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   endNode(endNodeIdx ? endNodeIdx : (nodeCount * (workload->clientId + 1)) / workload->clientCount),
															#line 257 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		   start(now())
															#line 2561 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
	{
		fdb_probe_actor_create("bulkSetup", reinterpret_cast<unsigned long>(this));

	}
	~BulkSetupActorState() 
	{
		fdb_probe_actor_destroy("bulkSetup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 259 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			TraceEvent("BulkSetupStart") .detail("NodeCount", nodeCount) .detail("ValuesInconsequential", valuesInconsequential) .detail("PostSetupWarming", postSetupWarming) .detail("MaxKeyInsertRate", maxKeyInsertRate) .detail("NumTenants", tenants.size());
															#line 268 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (valuesInconsequential)
															#line 2578 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			{
															#line 269 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				Optional<Reference<Tenant>> tenant;
															#line 270 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				if (tenants.size() > 0)
															#line 2584 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				{
															#line 271 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					tenant = deterministicRandom()->randomChoice(tenants);
															#line 2588 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				}
															#line 273 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				StrictFuture<bool> __when_expr_0 = checkRangeSimpleValueSize(cx, workload, startNode, endNode, tenant);
															#line 273 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				if (static_cast<BulkSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2594 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<BulkSetupActor*>(this)->actor_wait_state = 1;
															#line 273 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BulkSetupActor, 0, bool >*>(static_cast<BulkSetupActor*>(this)));
															#line 2599 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BulkSetupActorState();
		static_cast<BulkSetupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 290 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		StrictFuture<Void> __when_expr_1 = delay(deterministicRandom()->random01() / 4);
															#line 290 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (static_cast<BulkSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2629 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<BulkSetupActor*>(this)->actor_wait_state = 2;
															#line 290 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< BulkSetupActor, 1, Void >*>(static_cast<BulkSetupActor*>(this)));
															#line 2634 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(bool const& present,int loopDepth) 
	{
															#line 274 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (present)
															#line 2643 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 275 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			TraceEvent("BulkSetupRangeAlreadyPresent") .detail("Begin", startNode) .detail("End", endNode) .detail("CheckMethod", "SimpleValueSize");
															#line 279 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			setupTime.send(0.0);
															#line 280 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			ratesAtKeyCounts.send(std::vector<std::pair<uint64_t, double>>());
															#line 281 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (!static_cast<BulkSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BulkSetupActorState(); static_cast<BulkSetupActor*>(this)->destroy(); return 0; }
															#line 2653 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			new (&static_cast<BulkSetupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~BulkSetupActorState();
			static_cast<BulkSetupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 283 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			TraceEvent("BulkRangeNotFound") .detail("Begin", startNode) .detail("End", endNode) .detail("CheckMethod", "SimpleValueSize");
															#line 2663 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(bool && present,int loopDepth) 
	{
															#line 274 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (present)
															#line 2673 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 275 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			TraceEvent("BulkSetupRangeAlreadyPresent") .detail("Begin", startNode) .detail("End", endNode) .detail("CheckMethod", "SimpleValueSize");
															#line 279 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			setupTime.send(0.0);
															#line 280 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			ratesAtKeyCounts.send(std::vector<std::pair<uint64_t, double>>());
															#line 281 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (!static_cast<BulkSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BulkSetupActorState(); static_cast<BulkSetupActor*>(this)->destroy(); return 0; }
															#line 2683 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			new (&static_cast<BulkSetupActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~BulkSetupActorState();
			static_cast<BulkSetupActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 283 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			TraceEvent("BulkRangeNotFound") .detail("Begin", startNode) .detail("End", endNode) .detail("CheckMethod", "SimpleValueSize");
															#line 2693 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool const& present,int loopDepth) 
	{
		loopDepth = a_body1cont2(present, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && present,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(present), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BulkSetupActor*>(this)->actor_wait_state > 0) static_cast<BulkSetupActor*>(this)->actor_wait_state = 0;
		static_cast<BulkSetupActor*>(this)->ActorCallback< BulkSetupActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< BulkSetupActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BulkSetupActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BulkSetupActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 292 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		BULK_SETUP_WORKERS = 40;
															#line 294 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		int size_total = 0;
															#line 295 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		for(int i = 0;i < 100;i++) {
															#line 296 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			Standalone<KeyValueRef> sampleKV = (*workload)(startNode + (uint64_t)(deterministicRandom()->random01() * (endNode - startNode)));
															#line 298 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			size_total += sampleKV.key.size() + sampleKV.value.size();
															#line 2786 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
															#line 300 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		BULK_SETUP_RANGE_SIZE = size_total == 0 ? 50 : std::max(1, 10000 / (size_total / 100));
															#line 302 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		TraceEvent((workload->description() + "SetupStart").c_str()) .detail("ClientIdx", workload->clientId) .detail("ClientCount", workload->clientCount) .detail("StartingNode", startNode) .detail("NodesAssigned", endNode - startNode) .detail("NodesPerInsertion", BULK_SETUP_RANGE_SIZE) .detail("SetupActors", BULK_SETUP_WORKERS);
															#line 311 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		for(uint64_t n = startNode;n < endNode;n += BULK_SETUP_RANGE_SIZE) {
															#line 312 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			jobs.emplace_back(n, std::min(endNode, n + BULK_SETUP_RANGE_SIZE));
															#line 2796 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
															#line 313 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		deterministicRandom()->randomShuffle(jobs);
															#line 316 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		double maxWorkerInsertRate = maxKeyInsertRate / BULK_SETUP_WORKERS / workload->clientCount;
															#line 317 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		fs = std::vector<Future<uint64_t>>();
															#line 319 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		insertionTimes = std::vector<std::pair<uint64_t, double>>();
															#line 321 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (insertionCountsToMeasure.size() > 0)
															#line 2808 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 322 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			std::sort(insertionCountsToMeasure.begin(), insertionCountsToMeasure.end());
															#line 323 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			for(int i = 0;i < insertionCountsToMeasure.size();i++) {
															#line 324 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				if (insertionCountsToMeasure[i] > nodeCount)
															#line 2816 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				{
															#line 325 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					insertionCountsToMeasure.erase(insertionCountsToMeasure.begin() + i, insertionCountsToMeasure.end());
															#line 2820 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				}
			}
															#line 327 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (workload->clientId == 0)
															#line 2825 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			{
															#line 328 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				insertionTimes = trackInsertionCount(cx, insertionCountsToMeasure, keyCheckInterval);
															#line 2829 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			}
															#line 330 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (keySaveIncrement <= 0)
															#line 2833 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			{
															#line 331 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				keySaveIncrement = BULK_SETUP_RANGE_SIZE;
															#line 2837 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			}
		}
		else
		{
															#line 333 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			keySaveIncrement = 0;
															#line 2844 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
															#line 335 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		for(int j = 0;j < BULK_SETUP_WORKERS;j++) {
															#line 336 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			fs.push_back(setupRangeWorker(cx, workload, &jobs, maxWorkerInsertRate, keySaveIncrement, j, tenants));
															#line 2850 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
		try {
															#line 338 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			StrictFuture<Void> __when_expr_2 = success(insertionTimes) && waitForAll(fs);
															#line 338 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (static_cast<BulkSetupActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 2857 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont7Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont7when1(__when_expr_2.get(), loopDepth); };
			static_cast<BulkSetupActor*>(this)->actor_wait_state = 3;
															#line 338 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BulkSetupActor, 2, Void >*>(static_cast<BulkSetupActor*>(this)));
															#line 2862 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 292 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		BULK_SETUP_WORKERS = 40;
															#line 294 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		int size_total = 0;
															#line 295 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		for(int i = 0;i < 100;i++) {
															#line 296 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			Standalone<KeyValueRef> sampleKV = (*workload)(startNode + (uint64_t)(deterministicRandom()->random01() * (endNode - startNode)));
															#line 298 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			size_total += sampleKV.key.size() + sampleKV.value.size();
															#line 2885 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
															#line 300 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		BULK_SETUP_RANGE_SIZE = size_total == 0 ? 50 : std::max(1, 10000 / (size_total / 100));
															#line 302 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		TraceEvent((workload->description() + "SetupStart").c_str()) .detail("ClientIdx", workload->clientId) .detail("ClientCount", workload->clientCount) .detail("StartingNode", startNode) .detail("NodesAssigned", endNode - startNode) .detail("NodesPerInsertion", BULK_SETUP_RANGE_SIZE) .detail("SetupActors", BULK_SETUP_WORKERS);
															#line 311 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		for(uint64_t n = startNode;n < endNode;n += BULK_SETUP_RANGE_SIZE) {
															#line 312 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			jobs.emplace_back(n, std::min(endNode, n + BULK_SETUP_RANGE_SIZE));
															#line 2895 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
															#line 313 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		deterministicRandom()->randomShuffle(jobs);
															#line 316 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		double maxWorkerInsertRate = maxKeyInsertRate / BULK_SETUP_WORKERS / workload->clientCount;
															#line 317 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		fs = std::vector<Future<uint64_t>>();
															#line 319 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		insertionTimes = std::vector<std::pair<uint64_t, double>>();
															#line 321 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (insertionCountsToMeasure.size() > 0)
															#line 2907 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
															#line 322 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			std::sort(insertionCountsToMeasure.begin(), insertionCountsToMeasure.end());
															#line 323 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			for(int i = 0;i < insertionCountsToMeasure.size();i++) {
															#line 324 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				if (insertionCountsToMeasure[i] > nodeCount)
															#line 2915 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				{
															#line 325 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
					insertionCountsToMeasure.erase(insertionCountsToMeasure.begin() + i, insertionCountsToMeasure.end());
															#line 2919 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				}
			}
															#line 327 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (workload->clientId == 0)
															#line 2924 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			{
															#line 328 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				insertionTimes = trackInsertionCount(cx, insertionCountsToMeasure, keyCheckInterval);
															#line 2928 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			}
															#line 330 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (keySaveIncrement <= 0)
															#line 2932 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			{
															#line 331 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				keySaveIncrement = BULK_SETUP_RANGE_SIZE;
															#line 2936 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			}
		}
		else
		{
															#line 333 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			keySaveIncrement = 0;
															#line 2943 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
															#line 335 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		for(int j = 0;j < BULK_SETUP_WORKERS;j++) {
															#line 336 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			fs.push_back(setupRangeWorker(cx, workload, &jobs, maxWorkerInsertRate, keySaveIncrement, j, tenants));
															#line 2949 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
		try {
															#line 338 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			StrictFuture<Void> __when_expr_2 = success(insertionTimes) && waitForAll(fs);
															#line 338 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (static_cast<BulkSetupActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 2956 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont7Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont7when1(__when_expr_2.get(), loopDepth); };
			static_cast<BulkSetupActor*>(this)->actor_wait_state = 3;
															#line 338 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< BulkSetupActor, 2, Void >*>(static_cast<BulkSetupActor*>(this)));
															#line 2961 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<BulkSetupActor*>(this)->actor_wait_state > 0) static_cast<BulkSetupActor*>(this)->actor_wait_state = 0;
		static_cast<BulkSetupActor*>(this)->ActorCallback< BulkSetupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkSetupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< BulkSetupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< BulkSetupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont8(int loopDepth) 
	{
															#line 346 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		ratesAtKeyCounts.send(insertionTimes.get());
															#line 348 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		uint64_t rangesInserted = 0;
															#line 349 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		for(int i = 0;i < fs.size();i++) {
															#line 350 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			rangesInserted += fs[i].get();
															#line 3057 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
															#line 352 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		elapsed = now() - start;
															#line 353 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		setupTime.send(elapsed);
															#line 354 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		TraceEvent("SetupLoadComplete") .detail("LoadedRanges", rangesInserted) .detail("Duration", elapsed) .detail("Nodes", nodeCount);
															#line 360 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (postSetupWarming != 0)
															#line 3067 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		{
			try {
															#line 362 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				StrictFuture<Void> __when_expr_3 = delay(5.0);
															#line 362 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				if (static_cast<BulkSetupActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 3074 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont8Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont8when1(__when_expr_3.get(), loopDepth); };
				static_cast<BulkSetupActor*>(this)->actor_wait_state = 4;
															#line 362 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< BulkSetupActor, 3, Void >*>(static_cast<BulkSetupActor*>(this)));
															#line 3079 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1cont8Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1cont8Catch1(unknown_error(), loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont19(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 340 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (e.code() == error_code_operation_failed)
															#line 3100 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			{
															#line 341 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				TraceEvent(SevError, "BulkSetupFailed").error(e);
															#line 3104 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			}
															#line 343 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			return a_body1Catch1(e, loopDepth);
															#line 3108 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont18(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont18cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont18(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont18cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont18(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont18(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<BulkSetupActor*>(this)->actor_wait_state > 0) static_cast<BulkSetupActor*>(this)->actor_wait_state = 0;
		static_cast<BulkSetupActor*>(this)->ActorCallback< BulkSetupActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkSetupActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< BulkSetupActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< BulkSetupActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont7Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont18cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont19(int loopDepth) 
	{
															#line 373 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		TraceEvent((workload->description() + "SetupOK").c_str()) .detail("ClientIdx", workload->clientId) .detail("WarmingDelay", postSetupWarming) .detail("KeyLoadElapsedTime", elapsed);
															#line 377 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (!static_cast<BulkSetupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BulkSetupActorState(); static_cast<BulkSetupActor*>(this)->destroy(); return 0; }
															#line 3224 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		new (&static_cast<BulkSetupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BulkSetupActorState();
		static_cast<BulkSetupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont21(int loopDepth) 
	{
		loopDepth = a_body1cont19(loopDepth);

		return loopDepth;
	}
	int a_body1cont8Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 365 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (e.code() == error_code_actor_cancelled)
															#line 3243 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			{
															#line 366 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				return a_body1Catch1(e, loopDepth);
															#line 3247 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			}
															#line 367 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			TraceEvent("DynamicWarmingError").error(e);
															#line 368 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
			if (postSetupWarming > 0)
															#line 3253 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
			{
															#line 369 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				StrictFuture<Void> __when_expr_5 = timeout(databaseWarmer(cx), postSetupWarming, Void());
															#line 369 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				if (static_cast<BulkSetupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3259 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont8Catch1when1(__when_expr_5.get(), loopDepth); };
				static_cast<BulkSetupActor*>(this)->actor_wait_state = 6;
															#line 369 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
				__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< BulkSetupActor, 5, Void >*>(static_cast<BulkSetupActor*>(this)));
															#line 3264 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont8Catch1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont22(Void const& _,int loopDepth) 
	{
															#line 363 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		StrictFuture<Void> __when_expr_4 = waitForLowInFlight(cx, workload);
															#line 363 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (static_cast<BulkSetupActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 3286 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont8Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont22when1(__when_expr_4.get(), loopDepth); };
		static_cast<BulkSetupActor*>(this)->actor_wait_state = 5;
															#line 363 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BulkSetupActor, 4, Void >*>(static_cast<BulkSetupActor*>(this)));
															#line 3291 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont22(Void && _,int loopDepth) 
	{
															#line 363 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		StrictFuture<Void> __when_expr_4 = waitForLowInFlight(cx, workload);
															#line 363 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		if (static_cast<BulkSetupActor*>(this)->actor_wait_state < 0) return a_body1cont8Catch1(actor_cancelled(), loopDepth);
															#line 3302 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont8Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont22when1(__when_expr_4.get(), loopDepth); };
		static_cast<BulkSetupActor*>(this)->actor_wait_state = 5;
															#line 363 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< BulkSetupActor, 4, Void >*>(static_cast<BulkSetupActor*>(this)));
															#line 3307 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont22(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont22(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<BulkSetupActor*>(this)->actor_wait_state > 0) static_cast<BulkSetupActor*>(this)->actor_wait_state = 0;
		static_cast<BulkSetupActor*>(this)->ActorCallback< BulkSetupActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkSetupActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< BulkSetupActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< BulkSetupActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont22cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont22cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont22cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont22cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont22when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont22cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont22when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont22cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<BulkSetupActor*>(this)->actor_wait_state > 0) static_cast<BulkSetupActor*>(this)->actor_wait_state = 0;
		static_cast<BulkSetupActor*>(this)->ActorCallback< BulkSetupActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkSetupActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont22when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< BulkSetupActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont22when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< BulkSetupActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont8Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont8Catch1(error, 0);
		} catch (...) {
			a_body1cont8Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont22cont2(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont21(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1cont21(loopDepth);

		return loopDepth;
	}
	int a_body1cont8Catch1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8Catch1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8Catch1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont8Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8Catch1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8Catch1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<BulkSetupActor*>(this)->actor_wait_state > 0) static_cast<BulkSetupActor*>(this)->actor_wait_state = 0;
		static_cast<BulkSetupActor*>(this)->ActorCallback< BulkSetupActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BulkSetupActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< BulkSetupActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< BulkSetupActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Database cx;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	T* workload;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	uint64_t nodeCount;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Promise<double> setupTime;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	bool valuesInconsequential;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	double postSetupWarming;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	double maxKeyInsertRate;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	std::vector<uint64_t> insertionCountsToMeasure;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Promise<std::vector<std::pair<uint64_t, double>>> ratesAtKeyCounts;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	int keySaveIncrement;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	double keyCheckInterval;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	uint64_t startNodeIdx;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	uint64_t endNodeIdx;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	std::vector<Reference<Tenant>> tenants;
															#line 253 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	std::vector<std::pair<uint64_t, uint64_t>> jobs;
															#line 254 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	uint64_t startNode;
															#line 255 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	uint64_t endNode;
															#line 257 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	double start;
															#line 292 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	int BULK_SETUP_WORKERS;
															#line 300 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	int BULK_SETUP_RANGE_SIZE;
															#line 317 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	std::vector<Future<uint64_t>> fs;
															#line 319 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	Future<std::vector<std::pair<uint64_t, double>>> insertionTimes;
															#line 352 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	double elapsed;
															#line 3626 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
};
// This generated class is to be used only via bulkSetup()
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T>
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
class BulkSetupActor final : public Actor<Void>, public ActorCallback< BulkSetupActor<T>, 0, bool >, public ActorCallback< BulkSetupActor<T>, 1, Void >, public ActorCallback< BulkSetupActor<T>, 2, Void >, public ActorCallback< BulkSetupActor<T>, 3, Void >, public ActorCallback< BulkSetupActor<T>, 4, Void >, public ActorCallback< BulkSetupActor<T>, 5, Void >, public FastAllocated<BulkSetupActor<T>>, public BulkSetupActorState<T, BulkSetupActor<T>> {
															#line 3633 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
public:
	using FastAllocated<BulkSetupActor<T>>::operator new;
	using FastAllocated<BulkSetupActor<T>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3885013521422017280UL, 5487122077474217984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BulkSetupActor<T>, 0, bool >;
friend struct ActorCallback< BulkSetupActor<T>, 1, Void >;
friend struct ActorCallback< BulkSetupActor<T>, 2, Void >;
friend struct ActorCallback< BulkSetupActor<T>, 3, Void >;
friend struct ActorCallback< BulkSetupActor<T>, 4, Void >;
friend struct ActorCallback< BulkSetupActor<T>, 5, Void >;
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	BulkSetupActor(Database const& cx,T* const& workload,uint64_t const& nodeCount,Promise<double> const& setupTime,bool const& valuesInconsequential = false,double const& postSetupWarming = 0.0,double const& maxKeyInsertRate = 1e12,std::vector<uint64_t> const& insertionCountsToMeasure = std::vector<uint64_t>(),Promise<std::vector<std::pair<uint64_t, double>>> const& ratesAtKeyCounts = Promise<std::vector<std::pair<uint64_t, double>>>(),int const& keySaveIncrement = 0,double const& keyCheckInterval = 0.1,uint64_t const& startNodeIdx = 0,uint64_t const& endNodeIdx = 0,std::vector<Reference<Tenant>> const& tenants = std::vector<Reference<Tenant>>()) 
															#line 3655 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
		 : Actor<Void>(),
		   BulkSetupActorState<T, BulkSetupActor<T>>(cx, workload, nodeCount, setupTime, valuesInconsequential, postSetupWarming, maxKeyInsertRate, insertionCountsToMeasure, ratesAtKeyCounts, keySaveIncrement, keyCheckInterval, startNodeIdx, endNodeIdx, tenants),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("bulkSetup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14110425825640959232UL, 2900195219242885120UL);
		ActorExecutionContextHelper __helper(static_cast<BulkSetupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("bulkSetup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("bulkSetup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BulkSetupActor<T>, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< BulkSetupActor<T>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< BulkSetupActor<T>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< BulkSetupActor<T>, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< BulkSetupActor<T>, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< BulkSetupActor<T>, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
template <class T>
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
[[nodiscard]] Future<Void> bulkSetup( Database const& cx, T* const& workload, uint64_t const& nodeCount, Promise<double> const& setupTime, bool const& valuesInconsequential = false, double const& postSetupWarming = 0.0, double const& maxKeyInsertRate = 1e12, std::vector<uint64_t> const& insertionCountsToMeasure = std::vector<uint64_t>(), Promise<std::vector<std::pair<uint64_t, double>>> const& ratesAtKeyCounts = Promise<std::vector<std::pair<uint64_t, double>>>(), int const& keySaveIncrement = 0, double const& keyCheckInterval = 0.1, uint64_t const& startNodeIdx = 0, uint64_t const& endNodeIdx = 0, std::vector<Reference<Tenant>> const& tenants = std::vector<Reference<Tenant>>() ) {
															#line 236 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"
	return Future<Void>(new BulkSetupActor<T>(cx, workload, nodeCount, setupTime, valuesInconsequential, postSetupWarming, maxKeyInsertRate, insertionCountsToMeasure, ratesAtKeyCounts, keySaveIncrement, keyCheckInterval, startNodeIdx, endNodeIdx, tenants));
															#line 3695 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/include/fdbserver/workloads/BulkSetup.actor.g.h"
}

#line 379 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/include/fdbserver/workloads/BulkSetup.actor.h"

#include "flow/unactorcompiler.h"

#endif
