#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
/*
 * LatencyBandsMap.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/LatencyBandsMap.h"
#include "flow/UnitTest.h"
#include "flow/actorcompiler.h" // must be last include

class LatencyBandsMapImpl {
public:
																#line 29 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
// This generated class is to be used only via expireOldTagsActor()
															#line 27 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
template <class ExpireOldTagsActorActor>
															#line 27 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
class ExpireOldTagsActorActorState {
															#line 35 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
public:
															#line 27 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	ExpireOldTagsActorActorState(LatencyBandsMap* const& self) 
															#line 27 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
															#line 27 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		 : self(self)
															#line 42 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
	{
		fdb_probe_actor_create("expireOldTagsActor", reinterpret_cast<unsigned long>(this));

	}
	~ExpireOldTagsActorActorState() 
	{
		fdb_probe_actor_destroy("expireOldTagsActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 28 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			;
															#line 57 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ExpireOldTagsActorActorState();
		static_cast<ExpireOldTagsActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 29 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(5.0);
															#line 29 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		if (static_cast<ExpireOldTagsActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 89 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ExpireOldTagsActorActor*>(this)->actor_wait_state = 1;
															#line 29 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ExpireOldTagsActorActor, 0, Void >*>(static_cast<ExpireOldTagsActorActor*>(this)));
															#line 94 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 30 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		for(auto it = self->map.begin();it != self->map.end();) {
															#line 31 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			const auto& [tag, expirableBands] = *it;
															#line 32 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			if (now() - expirableBands.lastUpdated > SERVER_KNOBS->GLOBAL_TAG_THROTTLING_TAG_EXPIRE_AFTER)
															#line 107 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
			{
															#line 33 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
				CODE_PROBE(true, "LatencyBandsMap erasing expired tag");
															#line 34 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
				it = self->map.erase(it);
															#line 113 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
			}
			else
			{
															#line 36 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
				++it;
															#line 119 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 30 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		for(auto it = self->map.begin();it != self->map.end();) {
															#line 31 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			const auto& [tag, expirableBands] = *it;
															#line 32 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			if (now() - expirableBands.lastUpdated > SERVER_KNOBS->GLOBAL_TAG_THROTTLING_TAG_EXPIRE_AFTER)
															#line 134 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
			{
															#line 33 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
				CODE_PROBE(true, "LatencyBandsMap erasing expired tag");
															#line 34 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
				it = self->map.erase(it);
															#line 140 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
			}
			else
			{
															#line 36 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
				++it;
															#line 146 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ExpireOldTagsActorActor*>(this)->actor_wait_state > 0) static_cast<ExpireOldTagsActorActor*>(this)->actor_wait_state = 0;
		static_cast<ExpireOldTagsActorActor*>(this)->ActorCallback< ExpireOldTagsActorActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ExpireOldTagsActorActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("expireOldTagsActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireOldTagsActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireOldTagsActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ExpireOldTagsActorActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("expireOldTagsActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireOldTagsActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireOldTagsActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ExpireOldTagsActorActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("expireOldTagsActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireOldTagsActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("expireOldTagsActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 27 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	LatencyBandsMap* self;
															#line 230 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
};
// This generated class is to be used only via expireOldTagsActor()
															#line 27 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
class ExpireOldTagsActorActor final : public Actor<Void>, public ActorCallback< ExpireOldTagsActorActor, 0, Void >, public FastAllocated<ExpireOldTagsActorActor>, public ExpireOldTagsActorActorState<ExpireOldTagsActorActor> {
															#line 235 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
public:
	using FastAllocated<ExpireOldTagsActorActor>::operator new;
	using FastAllocated<ExpireOldTagsActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13450647034674019840UL, 7576137826369379328UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ExpireOldTagsActorActor, 0, Void >;
															#line 27 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	ExpireOldTagsActorActor(LatencyBandsMap* const& self) 
															#line 252 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		 : Actor<Void>(),
		   ExpireOldTagsActorActorState<ExpireOldTagsActorActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("expireOldTagsActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7550215270076477440UL, 2375923325840401408UL);
		ActorExecutionContextHelper __helper(static_cast<ExpireOldTagsActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("expireOldTagsActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("expireOldTagsActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ExpireOldTagsActorActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 27 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
[[nodiscard]] static Future<Void> expireOldTagsActor( LatencyBandsMap* const& self ) {
															#line 27 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	return Future<Void>(new ExpireOldTagsActorActor(self));
															#line 284 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
}

#line 41 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
};

LatencyBandsMap::ExpirableBands::ExpirableBands(LatencyBands&& bands)
  : latencyBands(std::move(bands)), lastUpdated(now()) {}

Optional<LatencyBands*> LatencyBandsMap::getLatencyBands(TransactionTag tag) {
	if (map.size() == maxSize && !map.contains(tag)) {
		CODE_PROBE(true, "LatencyBandsMap reached maxSize");
		return {};
	}
	auto const [it, inserted] = map.try_emplace(
	    tag, LatencyBands(name, id, loggingInterval, [tag](auto& te) { te.detail("Tag", printable(tag)); }));
	auto& expirableBands = it->second;
	if (inserted) {
		for (const auto& threshold : thresholds) {
			expirableBands.latencyBands.addThreshold(threshold);
		}
	}
	expirableBands.lastUpdated = now();
	return &expirableBands.latencyBands;
}

LatencyBandsMap::LatencyBandsMap(std::string const& name, UID id, double loggingInterval, int maxSize)
  : name(name), id(id), loggingInterval(loggingInterval), maxSize(maxSize) {
	expireOldTags = LatencyBandsMapImpl::expireOldTagsActor(this);
}

void LatencyBandsMap::addMeasurement(TransactionTag tag, double value, int count) {
	auto bands = getLatencyBands(tag);
	if (bands.present()) {
		bands.get()->addMeasurement(value, count);
	}
}

void LatencyBandsMap::addThreshold(double value) {
	thresholds.push_back(value);
	for (auto& [tag, expirableBands] : map) {
		expirableBands.latencyBands.addThreshold(value);
	}
}

															#line 329 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase82()
															#line 82 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
template <class FlowTestCase82Actor>
															#line 82 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
class FlowTestCase82ActorState {
															#line 336 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
public:
															#line 82 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	FlowTestCase82ActorState(UnitTestParameters const& params) 
															#line 82 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
															#line 82 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		 : params(params),
															#line 83 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		   latencyBandsMap("TestLatencyBandsMap", deterministicRandom()->randomUniqueID(), 10.0, 100),
															#line 84 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		   tags()
															#line 347 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase82", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase82ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase82", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 85 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			tags.push_back_deep(tags.arena(), "a"_sr);
															#line 86 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			tags.push_back_deep(tags.arena(), "b"_sr);
															#line 87 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			tags.push_back_deep(tags.arena(), "c"_sr);
															#line 88 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			latencyBandsMap.addThreshold(0.1);
															#line 89 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			latencyBandsMap.addThreshold(0.2);
															#line 90 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			latencyBandsMap.addThreshold(0.4);
															#line 91 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			measurements = 0;
															#line 92 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			;
															#line 376 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase82ActorState();
		static_cast<FlowTestCase82Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 93 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delayJittered(0.1);
															#line 93 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		if (static_cast<FlowTestCase82Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 408 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FlowTestCase82Actor*>(this)->actor_wait_state = 1;
															#line 93 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase82Actor, 0, Void >*>(static_cast<FlowTestCase82Actor*>(this)));
															#line 413 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		auto const tag = deterministicRandom()->randomChoice(tags);
															#line 95 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		latencyBandsMap.addMeasurement(tag, deterministicRandom()->random01());
															#line 96 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		if (++measurements == 1000)
															#line 426 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		{
															#line 97 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			if (!static_cast<FlowTestCase82Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase82ActorState(); static_cast<FlowTestCase82Actor*>(this)->destroy(); return 0; }
															#line 430 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
			new (&static_cast<FlowTestCase82Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase82ActorState();
			static_cast<FlowTestCase82Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		auto const tag = deterministicRandom()->randomChoice(tags);
															#line 95 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		latencyBandsMap.addMeasurement(tag, deterministicRandom()->random01());
															#line 96 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		if (++measurements == 1000)
															#line 448 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		{
															#line 97 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			if (!static_cast<FlowTestCase82Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase82ActorState(); static_cast<FlowTestCase82Actor*>(this)->destroy(); return 0; }
															#line 452 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
			new (&static_cast<FlowTestCase82Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase82ActorState();
			static_cast<FlowTestCase82Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase82Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase82Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase82Actor*>(this)->ActorCallback< FlowTestCase82Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase82Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase82", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase82Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase82", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase82Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase82", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase82Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase82", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase82Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase82", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase82Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase82", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 82 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	UnitTestParameters params;
															#line 83 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	LatencyBandsMap latencyBandsMap;
															#line 84 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	Standalone<VectorRef<TransactionTagRef>> tags;
															#line 91 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	int measurements;
															#line 545 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase82()
															#line 82 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
class FlowTestCase82Actor final : public Actor<Void>, public ActorCallback< FlowTestCase82Actor, 0, Void >, public FastAllocated<FlowTestCase82Actor>, public FlowTestCase82ActorState<FlowTestCase82Actor> {
															#line 550 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase82Actor>::operator new;
	using FastAllocated<FlowTestCase82Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13497979762256524800UL, 222656362714404352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase82Actor, 0, Void >;
															#line 82 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	FlowTestCase82Actor(UnitTestParameters const& params) 
															#line 567 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase82ActorState<FlowTestCase82Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase82", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10384903433464871424UL, 14266784369280557568UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase82Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase82");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase82", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase82Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 82 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
static Future<Void> flowTestCase82( UnitTestParameters const& params ) {
															#line 82 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	return Future<Void>(new FlowTestCase82Actor(params));
															#line 600 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase82, "/fdbserver/LatencyBandsMap/Simple")

#line 101 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"

															#line 606 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase102()
															#line 102 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
template <class FlowTestCase102Actor>
															#line 102 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
class FlowTestCase102ActorState {
															#line 613 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
public:
															#line 102 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	FlowTestCase102ActorState(UnitTestParameters const& params) 
															#line 102 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
															#line 102 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		 : params(params)
															#line 620 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase102", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase102ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase102", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 103 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			LatencyBandsMap latencyBandsMap("TestLatencyBandsMap", deterministicRandom()->randomUniqueID(), 10.0, 2);
															#line 104 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			latencyBandsMap.addMeasurement("a"_sr, deterministicRandom()->random01());
															#line 105 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			latencyBandsMap.addMeasurement("b"_sr, deterministicRandom()->random01());
															#line 106 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			latencyBandsMap.addMeasurement("c"_sr, deterministicRandom()->random01());
															#line 107 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			ASSERT_EQ(latencyBandsMap.size(), 2);
															#line 108 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			if (!static_cast<FlowTestCase102Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase102ActorState(); static_cast<FlowTestCase102Actor*>(this)->destroy(); return 0; }
															#line 645 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
			new (&static_cast<FlowTestCase102Actor*>(this)->SAV< Void >::value()) Void(Void());
			this->~FlowTestCase102ActorState();
			static_cast<FlowTestCase102Actor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase102ActorState();
		static_cast<FlowTestCase102Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
															#line 102 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	UnitTestParameters params;
															#line 669 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase102()
															#line 102 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
class FlowTestCase102Actor final : public Actor<Void>, public FastAllocated<FlowTestCase102Actor>, public FlowTestCase102ActorState<FlowTestCase102Actor> {
															#line 674 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase102Actor>::operator new;
	using FastAllocated<FlowTestCase102Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2315741340546453760UL, 2479409155302373632UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
															#line 102 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	FlowTestCase102Actor(UnitTestParameters const& params) 
															#line 690 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase102ActorState<FlowTestCase102Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase102", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6166052583406517760UL, 6458751585831993600UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase102Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase102");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase102", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		}

	}
};
} // namespace
															#line 102 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
static Future<Void> flowTestCase102( UnitTestParameters const& params ) {
															#line 102 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	return Future<Void>(new FlowTestCase102Actor(params));
															#line 722 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase102, "/fdbserver/LatencyBandsMap/MaxSize")

#line 110 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"

															#line 728 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase111()
															#line 111 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
template <class FlowTestCase111Actor>
															#line 111 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
class FlowTestCase111ActorState {
															#line 735 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
public:
															#line 111 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	FlowTestCase111ActorState(UnitTestParameters const& params) 
															#line 111 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
															#line 111 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		 : params(params),
															#line 112 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		   latencyBandsMap("TestLatencyBandsMap", deterministicRandom()->randomUniqueID(), 10.0, 100)
															#line 744 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase111", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase111ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase111", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			latencyBandsMap.addMeasurement("a"_sr, deterministicRandom()->random01());
															#line 114 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			latencyBandsMap.addMeasurement("b"_sr, deterministicRandom()->random01());
															#line 115 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			latencyBandsMap.addMeasurement("c"_sr, deterministicRandom()->random01());
															#line 116 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			latencyBandsMap.addThreshold(0.1);
															#line 117 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			latencyBandsMap.addThreshold(0.2);
															#line 118 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			latencyBandsMap.addThreshold(0.4);
															#line 119 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			ASSERT_EQ(latencyBandsMap.size(), 3);
															#line 120 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			waitIterations = 0;
															#line 121 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
			;
															#line 775 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase111ActorState();
		static_cast<FlowTestCase111Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 129 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		ASSERT_EQ(latencyBandsMap.size(), 2);
															#line 130 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		if (!static_cast<FlowTestCase111Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase111ActorState(); static_cast<FlowTestCase111Actor*>(this)->destroy(); return 0; }
															#line 800 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		new (&static_cast<FlowTestCase111Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase111ActorState();
		static_cast<FlowTestCase111Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 122 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(1.0);
															#line 122 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		if (static_cast<FlowTestCase111Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 821 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<FlowTestCase111Actor*>(this)->actor_wait_state = 1;
															#line 122 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase111Actor, 0, Void >*>(static_cast<FlowTestCase111Actor*>(this)));
															#line 826 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		latencyBandsMap.addMeasurement("a"_sr, deterministicRandom()->random01());
															#line 124 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		latencyBandsMap.addMeasurement("b"_sr, deterministicRandom()->random01());
															#line 125 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		if (++waitIterations == 2 * SERVER_KNOBS->GLOBAL_TAG_THROTTLING_TAG_EXPIRE_AFTER)
															#line 852 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 123 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		latencyBandsMap.addMeasurement("a"_sr, deterministicRandom()->random01());
															#line 124 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		latencyBandsMap.addMeasurement("b"_sr, deterministicRandom()->random01());
															#line 125 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
		if (++waitIterations == 2 * SERVER_KNOBS->GLOBAL_TAG_THROTTLING_TAG_EXPIRE_AFTER)
															#line 868 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase111Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase111Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase111Actor*>(this)->ActorCallback< FlowTestCase111Actor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase111Actor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase111", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase111Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase111", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase111Actor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase111", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase111Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase111", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase111Actor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase111", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase111Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase111", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 111 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	UnitTestParameters params;
															#line 112 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	LatencyBandsMap latencyBandsMap;
															#line 120 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	int waitIterations;
															#line 957 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase111()
															#line 111 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
class FlowTestCase111Actor final : public Actor<Void>, public ActorCallback< FlowTestCase111Actor, 0, Void >, public FastAllocated<FlowTestCase111Actor>, public FlowTestCase111ActorState<FlowTestCase111Actor> {
															#line 962 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase111Actor>::operator new;
	using FastAllocated<FlowTestCase111Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17277981363799860736UL, 18265871905500480512UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase111Actor, 0, Void >;
															#line 111 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	FlowTestCase111Actor(UnitTestParameters const& params) 
															#line 979 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase111ActorState<FlowTestCase111Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase111", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2288077941330982912UL, 18184305930580024576UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase111Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase111");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase111", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase111Actor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 111 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
static Future<Void> flowTestCase111( UnitTestParameters const& params ) {
															#line 111 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
	return Future<Void>(new FlowTestCase111Actor(params));
															#line 1012 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/build_output/fdbserver/LatencyBandsMap.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase111, "/fdbserver/LatencyBandsMap/Expire")

#line 132 "/codebuild/output/src1048538414/src/github.com/apple/foundationdb/fdbserver/LatencyBandsMap.actor.cpp"
