/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb;

import com.apple.foundationdb.Database;
import com.apple.foundationdb.FDB;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.NativeFuture;
import com.apple.foundationdb.RequiresDatabase;
import com.apple.foundationdb.Transaction;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={RequiresDatabase.class})
class WatchesIntegrationTest {
    private static final FDB fdb = FDB.selectAPIVersion((int)740);
    private static final int WATCH_TIMEOUT_SEC = 10;

    WatchesIntegrationTest() {
    }

    @Test
    @Tag(value="SupportsExternalClient")
    public void testWatchesWithinLimit() throws Exception {
        try (Database database = fdb.open();){
            database.options().setMaxWatches(10L);
            this.ensureConnected(database);
            this.setTestKeys(database, "eee", 10, "oldVal");
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < 10) {
                int n2 = n++;
                database.run(transaction -> {
                    arrayList.add(this.createTestWatch((Transaction)transaction, "eee", n2));
                    return null;
                });
            }
            this.setTestKeys(database, "eee", 10, "newVal");
            for (CompletableFuture completableFuture : arrayList) {
                completableFuture.orTimeout(10L, TimeUnit.SECONDS).join();
            }
        }
    }

    @Test
    @Tag(value="SupportsExternalClient")
    public void testWatchesWithinLimitInSingleTx() throws Exception {
        try (Database database = fdb.open();){
            database.options().setMaxWatches(10L);
            this.ensureConnected(database);
            this.setTestKeys(database, "aaa", 10, "oldVal");
            ArrayList arrayList = new ArrayList();
            database.run(transaction -> {
                for (int i = 0; i < 10; ++i) {
                    arrayList.add(this.createTestWatch((Transaction)transaction, "aaa", i));
                }
                return null;
            });
            this.setTestKeys(database, "aaa", 10, "newVal");
            for (CompletableFuture completableFuture : arrayList) {
                completableFuture.orTimeout(10L, TimeUnit.SECONDS).join();
            }
        }
    }

    @Test
    @Tag(value="SupportsExternalClient")
    public void testWatchesOverTheLimit() throws Exception {
        try (Database database = fdb.open();){
            database.options().setMaxWatches(10L);
            this.ensureConnected(database);
            this.setTestKeys(database, "bbb", 11, "oldVal");
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < 11) {
                int n2 = n++;
                database.run(transaction -> {
                    arrayList.add(this.createTestWatch((Transaction)transaction, "bbb", n2));
                    return null;
                });
            }
            this.setTestKeys(database, "bbb", 11, "newVal");
            try {
                for (CompletableFuture completableFuture : arrayList) {
                    completableFuture.orTimeout(1L, TimeUnit.SECONDS).join();
                }
                Assertions.fail((String)"Watch limit not imposed");
            }
            catch (CompletionException completionException) {
                Assertions.assertTrue((boolean)(completionException.getCause() instanceof FDBException));
                Assertions.assertEquals((int)1032, (int)((FDBException)completionException.getCause()).getCode());
            }
        }
    }

    @Test
    @Tag(value="SupportsExternalClient")
    public void testWatchesOverTheLimitInSingleTx() throws Exception {
        try (Database database = fdb.open();){
            database.options().setMaxWatches(10L);
            this.ensureConnected(database);
            ArrayList arrayList = new ArrayList();
            this.setTestKeys(database, "ccc", 11, "oldVal");
            database.run(transaction -> {
                for (int i = 0; i < 11; ++i) {
                    arrayList.add(this.createTestWatch((Transaction)transaction, "ccc", i));
                }
                return null;
            });
            this.setTestKeys(database, "ccc", 11, "newVal");
            try {
                for (CompletableFuture completableFuture : arrayList) {
                    completableFuture.orTimeout(1L, TimeUnit.SECONDS).join();
                }
                Assertions.fail((String)"Watch limit not imposed");
            }
            catch (CompletionException completionException) {
                Assertions.assertTrue((boolean)(completionException.getCause() instanceof FDBException));
                Assertions.assertEquals((int)1032, (int)((FDBException)completionException.getCause()).getCode());
            }
        }
    }

    @Test
    @Tag(value="SupportsExternalClient")
    public void testWatchCleanupOnCancel() throws Exception {
        try (Database database = fdb.open();){
            database.options().setMaxWatches(10L);
            this.ensureConnected(database);
            this.setTestKeys(database, "ddd", 100, "oldVal");
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < 100) {
                int n2 = n++;
                database.run(transaction -> {
                    CompletableFuture<Void> completableFuture = this.createTestWatch((Transaction)transaction, "ddd", n2);
                    arrayList.add(completableFuture);
                    if (n2 < 90) {
                        completableFuture.cancel(true);
                    }
                    return null;
                });
            }
            this.setTestKeys(database, "ddd", 100, "newVal");
            n = 0;
            for (CompletableFuture completableFuture : arrayList) {
                if (n < 90) {
                    try {
                        completableFuture.orTimeout(1L, TimeUnit.SECONDS).join();
                        Assertions.fail((String)"Expecting cancellation exception");
                    }
                    catch (CancellationException cancellationException) {}
                } else {
                    completableFuture.orTimeout(10L, TimeUnit.SECONDS).join();
                }
                ++n;
            }
        }
    }

    @Test
    @Tag(value="SupportsExternalClient")
    public void testWatchCleanupInSingleTxOnCancel() throws Exception {
        try (Database database = fdb.open();){
            database.options().setMaxWatches(10L);
            this.ensureConnected(database);
            this.setTestKeys(database, "ddd", 100, "oldVal");
            ArrayList arrayList = new ArrayList();
            database.run(transaction -> {
                for (int i = 0; i < 100; ++i) {
                    CompletableFuture<Void> completableFuture = this.createTestWatch((Transaction)transaction, "ddd", i);
                    arrayList.add(completableFuture);
                    if (i >= 90) continue;
                    completableFuture.cancel(true);
                }
                return null;
            });
            this.setTestKeys(database, "ddd", 100, "newVal");
            int n = 0;
            for (CompletableFuture completableFuture : arrayList) {
                if (n < 90) {
                    try {
                        completableFuture.orTimeout(1L, TimeUnit.SECONDS).join();
                        Assertions.fail((String)"Expecting cancellation exception");
                    }
                    catch (CancellationException cancellationException) {}
                } else {
                    completableFuture.orTimeout(10L, TimeUnit.SECONDS).join();
                }
                ++n;
            }
        }
    }

    @Test
    @Tag(value="SupportsExternalClient")
    public void testWatchCleanupOnClose() throws Exception {
        try (Database database = fdb.open();){
            database.options().setMaxWatches(10L);
            this.ensureConnected(database);
            this.setTestKeys(database, "ddd", 100, "oldVal");
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < 100) {
                int n2 = n++;
                database.run(transaction -> {
                    CompletableFuture<Void> completableFuture = this.createTestWatch((Transaction)transaction, "ddd", n2);
                    if (n2 >= 90) {
                        arrayList.add(completableFuture);
                    } else {
                        ((NativeFuture)completableFuture).close();
                    }
                    return null;
                });
            }
            System.gc();
            this.setTestKeys(database, "ddd", 100, "newVal");
            for (CompletableFuture completableFuture : arrayList) {
                completableFuture.orTimeout(10L, TimeUnit.SECONDS).join();
            }
        }
    }

    private void ensureConnected(Database database) throws Exception {
        database.run(transaction -> {
            transaction.getReadVersion().join();
            return null;
        });
    }

    private void setTestKeys(Database database, String string, int n, String string2) throws Exception {
        database.run(transaction -> {
            for (int i = 0; i < n; ++i) {
                transaction.set(String.format("%s%d", string, i).getBytes(), string2.getBytes());
            }
            return null;
        });
    }

    private CompletableFuture<Void> createTestWatch(Transaction transaction, String string, int n) {
        return transaction.watch(String.format("%s%d", string, n).getBytes());
    }

    static class DirectExecutor
    implements Executor {
        DirectExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    }
}

