#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
/*
 * ListTenants.actor.h
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once
#if defined(NO_INTELLISENSE) && !defined(METACLUSTER_LISTTENANTS_ACTOR_G_H)
#define METACLUSTER_LISTTENANTS_ACTOR_G_H
#include "metacluster/ListTenants.actor.g.h"
#elif !defined(METACLUSTER_LISTTENANTS_ACTOR_H)
#define METACLUSTER_LISTTENANTS_ACTOR_H

#include "fdbclient/Tenant.h"
#include "flow/flow.h"
#include "flow/genericactors.actor.h"

#include "metacluster/MetaclusterTypes.h"

#include "flow/actorcompiler.h" // has to be last include

namespace metacluster {

template <class Transaction>
Future<std::vector<std::pair<TenantName, int64_t>>> listTenantsTransaction(Transaction tr,
                                                                           TenantName begin,
                                                                           TenantName end,
                                                                           int limit,
                                                                           int offset = 0) {
	CODE_PROBE(true, "List tenants");
	tr->setOption(FDBTransactionOptions::RAW_ACCESS);
	auto future = metadata::management::tenantMetadata().tenantNameIndex.getRange(tr, begin, end, limit + offset);
	return fmap(
	    [offset](auto f) {
		    std::vector<std::pair<TenantName, int64_t>>& results = f.results;
		    results.erase(results.begin(), results.begin() + offset);
		    return results;
	    },
	    future);
}

															#line 58 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
// This generated class is to be used only via listTenantGroupTenantsTransaction()
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
template <class Transaction, class ListTenantGroupTenantsTransactionActor>
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
class ListTenantGroupTenantsTransactionActorState {
															#line 64 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
public:
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	ListTenantGroupTenantsTransactionActorState(Transaction const& tr,TenantGroupName const& tenantGroup,TenantName const& begin,TenantName const& end,int const& limit) 
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		 : tr(tr),
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   tenantGroup(tenantGroup),
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   begin(begin),
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   end(end),
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   limit(limit)
															#line 79 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
	{
		fdb_probe_actor_create("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this));

	}
	~ListTenantGroupTenantsTransactionActorState() 
	{
		fdb_probe_actor_destroy("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 62 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			CODE_PROBE(true, "List tenant group tenants");
															#line 63 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			tr->setOption(FDBTransactionOptions::RAW_ACCESS);
															#line 64 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			StrictFuture<KeyBackedSet<Tuple>::RangeResultType> __when_expr_0 = metadata::management::tenantMetadata().tenantGroupTenantIndex.getRange( tr, Tuple::makeTuple(tenantGroup, begin), Tuple::makeTuple(tenantGroup, end), limit);
															#line 64 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			if (static_cast<ListTenantGroupTenantsTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 100 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListTenantGroupTenantsTransactionActor*>(this)->actor_wait_state = 1;
															#line 64 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListTenantGroupTenantsTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >*>(static_cast<ListTenantGroupTenantsTransactionActor*>(this)));
															#line 105 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListTenantGroupTenantsTransactionActorState();
		static_cast<ListTenantGroupTenantsTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 67 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		std::vector<std::pair<TenantName, int64_t>> returnResult;
															#line 68 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		if (!result.results.size())
															#line 130 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		{
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			if (!static_cast<ListTenantGroupTenantsTransactionActor*>(this)->SAV<std::vector<std::pair<TenantName, int64_t>>>::futures) { (void)(returnResult); this->~ListTenantGroupTenantsTransactionActorState(); static_cast<ListTenantGroupTenantsTransactionActor*>(this)->destroy(); return 0; }
															#line 134 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			new (&static_cast<ListTenantGroupTenantsTransactionActor*>(this)->SAV< std::vector<std::pair<TenantName, int64_t>> >::value()) std::vector<std::pair<TenantName, int64_t>>(returnResult);
			this->~ListTenantGroupTenantsTransactionActorState();
			static_cast<ListTenantGroupTenantsTransactionActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 71 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		for( auto const& tupleEntry : result.results ) {
															#line 72 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			returnResult.push_back(std::make_pair(tupleEntry.getString(1), tupleEntry.getInt(2)));
															#line 144 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		}
															#line 74 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		if (!static_cast<ListTenantGroupTenantsTransactionActor*>(this)->SAV<std::vector<std::pair<TenantName, int64_t>>>::futures) { (void)(returnResult); this->~ListTenantGroupTenantsTransactionActorState(); static_cast<ListTenantGroupTenantsTransactionActor*>(this)->destroy(); return 0; }
															#line 148 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		new (&static_cast<ListTenantGroupTenantsTransactionActor*>(this)->SAV< std::vector<std::pair<TenantName, int64_t>> >::value()) std::vector<std::pair<TenantName, int64_t>>(returnResult);
		this->~ListTenantGroupTenantsTransactionActorState();
		static_cast<ListTenantGroupTenantsTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(KeyBackedSet<Tuple>::RangeResultType const& __result,int loopDepth) 
	{
															#line 64 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		result = __result;
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedSet<Tuple>::RangeResultType && __result,int loopDepth) 
	{
		result = std::move(__result);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListTenantGroupTenantsTransactionActor*>(this)->actor_wait_state > 0) static_cast<ListTenantGroupTenantsTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantGroupTenantsTransactionActor*>(this)->ActorCallback< ListTenantGroupTenantsTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantGroupTenantsTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,KeyBackedSet<Tuple>::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupTenantsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListTenantGroupTenantsTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,KeyBackedSet<Tuple>::RangeResultType && value) 
	{
		fdb_probe_actor_enter("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupTenantsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListTenantGroupTenantsTransactionActor, 0, KeyBackedSet<Tuple>::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupTenantsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	Transaction tr;
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	TenantGroupName tenantGroup;
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	TenantName begin;
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	TenantName end;
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	int limit;
															#line 64 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	KeyBackedSet<Tuple>::RangeResultType result;
															#line 247 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
};
// This generated class is to be used only via listTenantGroupTenantsTransaction()
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
template <class Transaction>
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
class ListTenantGroupTenantsTransactionActor final : public Actor<std::vector<std::pair<TenantName, int64_t>>>, public ActorCallback< ListTenantGroupTenantsTransactionActor<Transaction>, 0, KeyBackedSet<Tuple>::RangeResultType >, public FastAllocated<ListTenantGroupTenantsTransactionActor<Transaction>>, public ListTenantGroupTenantsTransactionActorState<Transaction, ListTenantGroupTenantsTransactionActor<Transaction>> {
															#line 254 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
public:
	using FastAllocated<ListTenantGroupTenantsTransactionActor<Transaction>>::operator new;
	using FastAllocated<ListTenantGroupTenantsTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4521424746391796736UL, 16497374998721836800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<TenantName, int64_t>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListTenantGroupTenantsTransactionActor<Transaction>, 0, KeyBackedSet<Tuple>::RangeResultType >;
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	ListTenantGroupTenantsTransactionActor(Transaction const& tr,TenantGroupName const& tenantGroup,TenantName const& begin,TenantName const& end,int const& limit) 
															#line 271 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		 : Actor<std::vector<std::pair<TenantName, int64_t>>>(),
		   ListTenantGroupTenantsTransactionActorState<Transaction, ListTenantGroupTenantsTransactionActor<Transaction>>(tr, tenantGroup, begin, end, limit),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15437714249961797888UL, 4104142458071764736UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantGroupTenantsTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listTenantGroupTenantsTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listTenantGroupTenantsTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListTenantGroupTenantsTransactionActor<Transaction>, 0, KeyBackedSet<Tuple>::RangeResultType >*)0, actor_cancelled()); break;
		}

	}
};
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
template <class Transaction>
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
[[nodiscard]] Future<std::vector<std::pair<TenantName, int64_t>>> listTenantGroupTenantsTransaction( Transaction const& tr, TenantGroupName const& tenantGroup, TenantName const& begin, TenantName const& end, int const& limit ) {
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	return Future<std::vector<std::pair<TenantName, int64_t>>>(new ListTenantGroupTenantsTransactionActor<Transaction>(tr, tenantGroup, begin, end, limit));
															#line 305 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
}

#line 76 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"

template <class DB>
Future<std::vector<std::pair<TenantName, int64_t>>> listTenants(Reference<DB> db,
                                                                TenantName begin,
                                                                TenantName end,
                                                                int limit,
                                                                int offset = 0) {
	return runTransaction(db, [=](Reference<typename DB::TransactionT> tr) {
		tr->setOption(FDBTransactionOptions::LOCK_AWARE);
		tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
		return listTenantsTransaction(tr, begin, end, limit, offset);
	});
}

// Scan the tenant index to get a list of tenant IDs, and then lookup the metadata for each ID individually
															#line 324 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
// This generated class is to be used only via listTenantMetadataTransaction()
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
template <class Transaction, class ListTenantMetadataTransactionActor>
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
class ListTenantMetadataTransactionActorState {
															#line 330 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
public:
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	ListTenantMetadataTransactionActorState(Transaction const& tr,std::vector<std::pair<TenantName, int64_t>> const& tenantIds) 
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		 : tr(tr),
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   tenantIds(tenantIds)
															#line 339 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
	{
		fdb_probe_actor_create("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this));

	}
	~ListTenantMetadataTransactionActorState() 
	{
		fdb_probe_actor_destroy("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 96 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			CODE_PROBE(true, "List tenant metadata");
															#line 97 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			idIdx = 0;
															#line 98 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			futures = std::vector<Future<Optional<MetaclusterTenantMapEntry>>>();
															#line 99 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			for(;idIdx < tenantIds.size();++idIdx) {
															#line 100 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				futures.push_back(tryGetTenantTransaction(tr, tenantIds[idIdx].second));
															#line 362 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			}
															#line 102 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			StrictFuture<Void> __when_expr_0 = waitForAll(futures);
															#line 102 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			if (static_cast<ListTenantMetadataTransactionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 368 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ListTenantMetadataTransactionActor*>(this)->actor_wait_state = 1;
															#line 102 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListTenantMetadataTransactionActor, 0, Void >*>(static_cast<ListTenantMetadataTransactionActor*>(this)));
															#line 373 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListTenantMetadataTransactionActorState();
		static_cast<ListTenantMetadataTransactionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> results;
															#line 105 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		results.reserve(futures.size());
															#line 106 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		for(int i = 0;i < futures.size();++i) {
															#line 107 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			const MetaclusterTenantMapEntry& entry = futures[i].get().get();
															#line 111 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			if (entry.tenantName == tenantIds[i].first)
															#line 404 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			{
															#line 112 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				results.emplace_back(entry.tenantName, entry);
															#line 408 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			}
		}
															#line 116 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		if (!static_cast<ListTenantMetadataTransactionActor*>(this)->SAV<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>::futures) { (void)(results); this->~ListTenantMetadataTransactionActorState(); static_cast<ListTenantMetadataTransactionActor*>(this)->destroy(); return 0; }
															#line 413 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		new (&static_cast<ListTenantMetadataTransactionActor*>(this)->SAV< std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >::value()) std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>(results);
		this->~ListTenantMetadataTransactionActorState();
		static_cast<ListTenantMetadataTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 104 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> results;
															#line 105 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		results.reserve(futures.size());
															#line 106 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		for(int i = 0;i < futures.size();++i) {
															#line 107 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			const MetaclusterTenantMapEntry& entry = futures[i].get().get();
															#line 111 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			if (entry.tenantName == tenantIds[i].first)
															#line 433 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			{
															#line 112 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				results.emplace_back(entry.tenantName, entry);
															#line 437 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			}
		}
															#line 116 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		if (!static_cast<ListTenantMetadataTransactionActor*>(this)->SAV<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>::futures) { (void)(results); this->~ListTenantMetadataTransactionActorState(); static_cast<ListTenantMetadataTransactionActor*>(this)->destroy(); return 0; }
															#line 442 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		new (&static_cast<ListTenantMetadataTransactionActor*>(this)->SAV< std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >::value()) std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>(results);
		this->~ListTenantMetadataTransactionActorState();
		static_cast<ListTenantMetadataTransactionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListTenantMetadataTransactionActor*>(this)->actor_wait_state > 0) static_cast<ListTenantMetadataTransactionActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantMetadataTransactionActor*>(this)->ActorCallback< ListTenantMetadataTransactionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataTransactionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataTransactionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListTenantMetadataTransactionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	Transaction tr;
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	std::vector<std::pair<TenantName, int64_t>> tenantIds;
															#line 97 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	int idIdx;
															#line 98 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	std::vector<Future<Optional<MetaclusterTenantMapEntry>>> futures;
															#line 533 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
};
// This generated class is to be used only via listTenantMetadataTransaction()
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
template <class Transaction>
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
class ListTenantMetadataTransactionActor final : public Actor<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>, public ActorCallback< ListTenantMetadataTransactionActor<Transaction>, 0, Void >, public FastAllocated<ListTenantMetadataTransactionActor<Transaction>>, public ListTenantMetadataTransactionActorState<Transaction, ListTenantMetadataTransactionActor<Transaction>> {
															#line 540 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
public:
	using FastAllocated<ListTenantMetadataTransactionActor<Transaction>>::operator new;
	using FastAllocated<ListTenantMetadataTransactionActor<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3061598996379106560UL, 11634554647770540800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListTenantMetadataTransactionActor<Transaction>, 0, Void >;
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	ListTenantMetadataTransactionActor(Transaction const& tr,std::vector<std::pair<TenantName, int64_t>> const& tenantIds) 
															#line 557 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		 : Actor<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>(),
		   ListTenantMetadataTransactionActorState<Transaction, ListTenantMetadataTransactionActor<Transaction>>(tr, tenantIds),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1675706873923236608UL, 11373340560176294656UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listTenantMetadataTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListTenantMetadataTransactionActor<Transaction>, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
template <class Transaction>
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
[[nodiscard]] Future<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>> listTenantMetadataTransaction( Transaction const& tr, std::vector<std::pair<TenantName, int64_t>> const& tenantIds ) {
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	return Future<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>(new ListTenantMetadataTransactionActor<Transaction>(tr, tenantIds));
															#line 591 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
}

#line 118 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"

															#line 596 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
// This generated class is to be used only via listTenantMetadataTransaction()
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
template <class Transaction, class ListTenantMetadataTransactionActor1>
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
class ListTenantMetadataTransactionActor1State {
															#line 602 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
public:
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	ListTenantMetadataTransactionActor1State(Transaction const& tr,TenantNameRef const& begin,TenantNameRef const& end,int const& limit,Optional<TenantGroupName> const& tenantGroup = Optional<TenantGroupName>()) 
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		 : tr(tr),
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   begin(begin),
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   end(end),
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   limit(limit),
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   tenantGroup(tenantGroup),
															#line 126 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   matchingTenants()
															#line 619 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
	{
		fdb_probe_actor_create("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this));

	}
	~ListTenantMetadataTransactionActor1State() 
	{
		fdb_probe_actor_destroy("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 127 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			if (!tenantGroup.present())
															#line 634 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			{
															#line 128 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				StrictFuture<Void> __when_expr_0 = store(matchingTenants, listTenantsTransaction(tr, begin, end, limit));
															#line 128 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				if (static_cast<ListTenantMetadataTransactionActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 640 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ListTenantMetadataTransactionActor1*>(this)->actor_wait_state = 1;
															#line 128 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListTenantMetadataTransactionActor1, 0, Void >*>(static_cast<ListTenantMetadataTransactionActor1*>(this)));
															#line 645 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
				loopDepth = 0;
			}
			else
			{
															#line 130 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				StrictFuture<Void> __when_expr_1 = store(matchingTenants, listTenantGroupTenantsTransaction(tr, tenantGroup.get(), begin, end, limit));
															#line 130 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				if (static_cast<ListTenantMetadataTransactionActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 654 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<ListTenantMetadataTransactionActor1*>(this)->actor_wait_state = 2;
															#line 130 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListTenantMetadataTransactionActor1, 1, Void >*>(static_cast<ListTenantMetadataTransactionActor1*>(this)));
															#line 659 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListTenantMetadataTransactionActor1State();
		static_cast<ListTenantMetadataTransactionActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 132 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		StrictFuture<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>> __when_expr_2 = listTenantMetadataTransaction(tr, matchingTenants);
															#line 132 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		if (static_cast<ListTenantMetadataTransactionActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 685 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<ListTenantMetadataTransactionActor1*>(this)->actor_wait_state = 3;
															#line 132 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ListTenantMetadataTransactionActor1, 2, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >*>(static_cast<ListTenantMetadataTransactionActor1*>(this)));
															#line 690 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListTenantMetadataTransactionActor1*>(this)->actor_wait_state > 0) static_cast<ListTenantMetadataTransactionActor1*>(this)->actor_wait_state = 0;
		static_cast<ListTenantMetadataTransactionActor1*>(this)->ActorCallback< ListTenantMetadataTransactionActor1, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataTransactionActor1, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataTransactionActor1, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListTenantMetadataTransactionActor1, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListTenantMetadataTransactionActor1*>(this)->actor_wait_state > 0) static_cast<ListTenantMetadataTransactionActor1*>(this)->actor_wait_state = 0;
		static_cast<ListTenantMetadataTransactionActor1*>(this)->ActorCallback< ListTenantMetadataTransactionActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataTransactionActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataTransactionActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListTenantMetadataTransactionActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> const& results,int loopDepth) 
	{
															#line 134 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		if (!static_cast<ListTenantMetadataTransactionActor1*>(this)->SAV<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>::futures) { (void)(results); this->~ListTenantMetadataTransactionActor1State(); static_cast<ListTenantMetadataTransactionActor1*>(this)->destroy(); return 0; }
															#line 873 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		new (&static_cast<ListTenantMetadataTransactionActor1*>(this)->SAV< std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >::value()) std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>(results);
		this->~ListTenantMetadataTransactionActor1State();
		static_cast<ListTenantMetadataTransactionActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> && results,int loopDepth) 
	{
															#line 134 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		if (!static_cast<ListTenantMetadataTransactionActor1*>(this)->SAV<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>::futures) { (void)(results); this->~ListTenantMetadataTransactionActor1State(); static_cast<ListTenantMetadataTransactionActor1*>(this)->destroy(); return 0; }
															#line 885 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		new (&static_cast<ListTenantMetadataTransactionActor1*>(this)->SAV< std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >::value()) std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>(results);
		this->~ListTenantMetadataTransactionActor1State();
		static_cast<ListTenantMetadataTransactionActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> const& results,int loopDepth) 
	{
		loopDepth = a_body1cont4(results, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> && results,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(results), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ListTenantMetadataTransactionActor1*>(this)->actor_wait_state > 0) static_cast<ListTenantMetadataTransactionActor1*>(this)->actor_wait_state = 0;
		static_cast<ListTenantMetadataTransactionActor1*>(this)->ActorCallback< ListTenantMetadataTransactionActor1, 2, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataTransactionActor1, 2, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >*,std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataTransactionActor1, 2, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >*,std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ListTenantMetadataTransactionActor1, 2, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	Transaction tr;
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	TenantNameRef begin;
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	TenantNameRef end;
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	int limit;
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	Optional<TenantGroupName> tenantGroup;
															#line 126 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	std::vector<std::pair<TenantName, int64_t>> matchingTenants;
															#line 980 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
};
// This generated class is to be used only via listTenantMetadataTransaction()
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
template <class Transaction>
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
class ListTenantMetadataTransactionActor1 final : public Actor<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>, public ActorCallback< ListTenantMetadataTransactionActor1<Transaction>, 0, Void >, public ActorCallback< ListTenantMetadataTransactionActor1<Transaction>, 1, Void >, public ActorCallback< ListTenantMetadataTransactionActor1<Transaction>, 2, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >, public FastAllocated<ListTenantMetadataTransactionActor1<Transaction>>, public ListTenantMetadataTransactionActor1State<Transaction, ListTenantMetadataTransactionActor1<Transaction>> {
															#line 987 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
public:
	using FastAllocated<ListTenantMetadataTransactionActor1<Transaction>>::operator new;
	using FastAllocated<ListTenantMetadataTransactionActor1<Transaction>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3061598996379106560UL, 11634554647770540800UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListTenantMetadataTransactionActor1<Transaction>, 0, Void >;
friend struct ActorCallback< ListTenantMetadataTransactionActor1<Transaction>, 1, Void >;
friend struct ActorCallback< ListTenantMetadataTransactionActor1<Transaction>, 2, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >;
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	ListTenantMetadataTransactionActor1(Transaction const& tr,TenantNameRef const& begin,TenantNameRef const& end,int const& limit,Optional<TenantGroupName> const& tenantGroup = Optional<TenantGroupName>()) 
															#line 1006 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		 : Actor<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>(),
		   ListTenantMetadataTransactionActor1State<Transaction, ListTenantMetadataTransactionActor1<Transaction>>(tr, begin, end, limit, tenantGroup),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3366547139155613440UL, 6203339001634722560UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataTransactionActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listTenantMetadataTransaction");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listTenantMetadataTransaction", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListTenantMetadataTransactionActor1<Transaction>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListTenantMetadataTransactionActor1<Transaction>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ListTenantMetadataTransactionActor1<Transaction>, 2, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
template <class Transaction>
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
[[nodiscard]] Future<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>> listTenantMetadataTransaction( Transaction const& tr, TenantNameRef const& begin, TenantNameRef const& end, int const& limit, Optional<TenantGroupName> const& tenantGroup = Optional<TenantGroupName>() ) {
															#line 119 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	return Future<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>(new ListTenantMetadataTransactionActor1<Transaction>(tr, begin, end, limit, tenantGroup));
															#line 1042 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
}

#line 136 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"

															#line 1047 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
// This generated class is to be used only via listTenantMetadata()
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
template <class DB, class ListTenantMetadataActor>
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
class ListTenantMetadataActorState {
															#line 1053 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
public:
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	ListTenantMetadataActorState(Reference<DB> const& db,TenantName const& begin,TenantName const& end,int const& limit,int const& offset = 0,std::vector<TenantState> const& filters = std::vector<TenantState>(),Optional<TenantGroupName> const& tenantGroup = Optional<TenantGroupName>()) 
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		 : db(db),
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   begin(begin),
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   end(end),
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   limit(limit),
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   offset(offset),
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   filters(filters),
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   tenantGroup(tenantGroup),
															#line 146 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   tr(db->createTransaction()),
															#line 147 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		   results()
															#line 1076 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
	{
		fdb_probe_actor_create("listTenantMetadata", reinterpret_cast<unsigned long>(this));

	}
	~ListTenantMetadataActorState() 
	{
		fdb_probe_actor_destroy("listTenantMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 149 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			;
															#line 1091 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListTenantMetadataActorState();
		static_cast<ListTenantMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 151 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			tr->setOption(FDBTransactionOptions::READ_LOCK_AWARE);
															#line 153 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			if (filters.empty())
															#line 1126 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			{
															#line 154 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				ids = std::vector<std::pair<TenantName, int64_t>>();
															#line 155 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				if (!tenantGroup.present())
															#line 1132 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
				{
															#line 156 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
					StrictFuture<Void> __when_expr_0 = store(ids, listTenantsTransaction(tr, begin, end, limit));
															#line 156 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
					if (static_cast<ListTenantMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1138 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
					static_cast<ListTenantMetadataActor*>(this)->actor_wait_state = 1;
															#line 156 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListTenantMetadataActor, 0, Void >*>(static_cast<ListTenantMetadataActor*>(this)));
															#line 1143 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
					loopDepth = 0;
				}
				else
				{
															#line 158 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
					StrictFuture<Void> __when_expr_1 = store(ids, listTenantGroupTenantsTransaction(tr, tenantGroup.get(), begin, end, limit));
															#line 158 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
					if (static_cast<ListTenantMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
					if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
					static_cast<ListTenantMetadataActor*>(this)->actor_wait_state = 2;
															#line 158 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
					__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ListTenantMetadataActor, 1, Void >*>(static_cast<ListTenantMetadataActor*>(this)));
															#line 1157 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
					loopDepth = 0;
				}
			}
			else
			{
				loopDepth = a_body1loopBody1cont2(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 191 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			StrictFuture<Void> __when_expr_4 = safeThreadFutureToFuture(tr->onError(e));
															#line 191 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			if (static_cast<ListTenantMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1187 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<ListTenantMetadataActor*>(this)->actor_wait_state = 5;
															#line 191 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ListTenantMetadataActor, 4, Void >*>(static_cast<ListTenantMetadataActor*>(this)));
															#line 1192 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 165 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		count = 0;
															#line 166 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		;
															#line 1209 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		loopDepth = a_body1loopBody1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		StrictFuture<Void> __when_expr_2 = store(results, listTenantMetadataTransaction(tr, ids));
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		if (static_cast<ListTenantMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1220 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<ListTenantMetadataActor*>(this)->actor_wait_state = 3;
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ListTenantMetadataActor, 2, Void >*>(static_cast<ListTenantMetadataActor*>(this)));
															#line 1225 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListTenantMetadataActor*>(this)->actor_wait_state > 0) static_cast<ListTenantMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantMetadataActor*>(this)->ActorCallback< ListTenantMetadataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListTenantMetadataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ListTenantMetadataActor*>(this)->actor_wait_state > 0) static_cast<ListTenantMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantMetadataActor*>(this)->ActorCallback< ListTenantMetadataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ListTenantMetadataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 161 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		if (!static_cast<ListTenantMetadataActor*>(this)->SAV<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>::futures) { (void)(results); this->~ListTenantMetadataActorState(); static_cast<ListTenantMetadataActor*>(this)->destroy(); return 0; }
															#line 1408 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		new (&static_cast<ListTenantMetadataActor*>(this)->SAV< std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >::value()) std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>(std::move(results)); // state_var_RVO
		this->~ListTenantMetadataActorState();
		static_cast<ListTenantMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 161 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		if (!static_cast<ListTenantMetadataActor*>(this)->SAV<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>::futures) { (void)(results); this->~ListTenantMetadataActorState(); static_cast<ListTenantMetadataActor*>(this)->destroy(); return 0; }
															#line 1420 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		new (&static_cast<ListTenantMetadataActor*>(this)->SAV< std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >::value()) std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>(std::move(results)); // state_var_RVO
		this->~ListTenantMetadataActorState();
		static_cast<ListTenantMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ListTenantMetadataActor*>(this)->actor_wait_state > 0) static_cast<ListTenantMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantMetadataActor*>(this)->ActorCallback< ListTenantMetadataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ListTenantMetadataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1(int loopDepth) 
	{
															#line 167 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		StrictFuture<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>> __when_expr_3 = listTenantMetadataTransaction(tr, begin, end, std::max(limit + offset, 1000), tenantGroup);
															#line 167 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		if (static_cast<ListTenantMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1516 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont2loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<ListTenantMetadataActor*>(this)->actor_wait_state = 4;
															#line 167 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ListTenantMetadataActor, 3, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >*>(static_cast<ListTenantMetadataActor*>(this)));
															#line 1521 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> const& tenantBatch,int loopDepth) 
	{
															#line 170 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		if (tenantBatch.empty())
															#line 1530 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		{
															#line 171 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			if (!static_cast<ListTenantMetadataActor*>(this)->SAV<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>::futures) { (void)(results); this->~ListTenantMetadataActorState(); static_cast<ListTenantMetadataActor*>(this)->destroy(); return 0; }
															#line 1534 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			new (&static_cast<ListTenantMetadataActor*>(this)->SAV< std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >::value()) std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>(std::move(results)); // state_var_RVO
			this->~ListTenantMetadataActorState();
			static_cast<ListTenantMetadataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 174 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		for( auto const& [name, entry] : tenantBatch ) {
															#line 175 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			if (std::count(filters.begin(), filters.end(), entry.tenantState))
															#line 1544 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			{
															#line 176 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				++count;
															#line 177 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				if (count > offset)
															#line 1550 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
				{
															#line 178 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
					results.emplace_back(name, entry);
															#line 179 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
					if (count - offset == limit)
															#line 1556 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
					{
															#line 180 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
						ASSERT(count - offset == results.size());
															#line 181 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
						if (!static_cast<ListTenantMetadataActor*>(this)->SAV<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>::futures) { (void)(results); this->~ListTenantMetadataActorState(); static_cast<ListTenantMetadataActor*>(this)->destroy(); return 0; }
															#line 1562 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
						new (&static_cast<ListTenantMetadataActor*>(this)->SAV< std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >::value()) std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>(std::move(results)); // state_var_RVO
						this->~ListTenantMetadataActorState();
						static_cast<ListTenantMetadataActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
															#line 187 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		CODE_PROBE(true, "List tenant multiple batches");
															#line 188 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		begin = keyAfter(tenantBatch.back().first);
															#line 1575 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1cont1(std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> && tenantBatch,int loopDepth) 
	{
															#line 170 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		if (tenantBatch.empty())
															#line 1584 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		{
															#line 171 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			if (!static_cast<ListTenantMetadataActor*>(this)->SAV<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>::futures) { (void)(results); this->~ListTenantMetadataActorState(); static_cast<ListTenantMetadataActor*>(this)->destroy(); return 0; }
															#line 1588 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			new (&static_cast<ListTenantMetadataActor*>(this)->SAV< std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >::value()) std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>(std::move(results)); // state_var_RVO
			this->~ListTenantMetadataActorState();
			static_cast<ListTenantMetadataActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 174 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		for( auto const& [name, entry] : tenantBatch ) {
															#line 175 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
			if (std::count(filters.begin(), filters.end(), entry.tenantState))
															#line 1598 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
			{
															#line 176 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				++count;
															#line 177 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
				if (count > offset)
															#line 1604 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
				{
															#line 178 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
					results.emplace_back(name, entry);
															#line 179 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
					if (count - offset == limit)
															#line 1610 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
					{
															#line 180 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
						ASSERT(count - offset == results.size());
															#line 181 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
						if (!static_cast<ListTenantMetadataActor*>(this)->SAV<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>::futures) { (void)(results); this->~ListTenantMetadataActorState(); static_cast<ListTenantMetadataActor*>(this)->destroy(); return 0; }
															#line 1616 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
						new (&static_cast<ListTenantMetadataActor*>(this)->SAV< std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >::value()) std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>(std::move(results)); // state_var_RVO
						this->~ListTenantMetadataActorState();
						static_cast<ListTenantMetadataActor*>(this)->finishSendAndDelPromiseRef();
						return 0;
					}
				}
			}
		}
															#line 187 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		CODE_PROBE(true, "List tenant multiple batches");
															#line 188 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
		begin = keyAfter(tenantBatch.back().first);
															#line 1629 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		if (loopDepth == 0) return a_body1loopBody1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> const& tenantBatch,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(tenantBatch, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2loopBody1when1(std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> && tenantBatch,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2loopBody1cont1(std::move(tenantBatch), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ListTenantMetadataActor*>(this)->actor_wait_state > 0) static_cast<ListTenantMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantMetadataActor*>(this)->ActorCallback< ListTenantMetadataActor, 3, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataActor, 3, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >*,std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> const& value) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataActor, 3, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >*,std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> && value) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ListTenantMetadataActor, 3, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ListTenantMetadataActor*>(this)->actor_wait_state > 0) static_cast<ListTenantMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<ListTenantMetadataActor*>(this)->ActorCallback< ListTenantMetadataActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ListTenantMetadataActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ListTenantMetadataActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	Reference<DB> db;
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	TenantName begin;
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	TenantName end;
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	int limit;
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	int offset;
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	std::vector<TenantState> filters;
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	Optional<TenantGroupName> tenantGroup;
															#line 146 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	Reference<typename DB::TransactionT> tr;
															#line 147 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> results;
															#line 154 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	std::vector<std::pair<TenantName, int64_t>> ids;
															#line 165 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	int count;
															#line 1818 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
};
// This generated class is to be used only via listTenantMetadata()
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
template <class DB>
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
class ListTenantMetadataActor final : public Actor<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>, public ActorCallback< ListTenantMetadataActor<DB>, 0, Void >, public ActorCallback< ListTenantMetadataActor<DB>, 1, Void >, public ActorCallback< ListTenantMetadataActor<DB>, 2, Void >, public ActorCallback< ListTenantMetadataActor<DB>, 3, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >, public ActorCallback< ListTenantMetadataActor<DB>, 4, Void >, public FastAllocated<ListTenantMetadataActor<DB>>, public ListTenantMetadataActorState<DB, ListTenantMetadataActor<DB>> {
															#line 1825 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
public:
	using FastAllocated<ListTenantMetadataActor<DB>>::operator new;
	using FastAllocated<ListTenantMetadataActor<DB>>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1529620492580085760UL, 13323197210563347968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListTenantMetadataActor<DB>, 0, Void >;
friend struct ActorCallback< ListTenantMetadataActor<DB>, 1, Void >;
friend struct ActorCallback< ListTenantMetadataActor<DB>, 2, Void >;
friend struct ActorCallback< ListTenantMetadataActor<DB>, 3, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >;
friend struct ActorCallback< ListTenantMetadataActor<DB>, 4, Void >;
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	ListTenantMetadataActor(Reference<DB> const& db,TenantName const& begin,TenantName const& end,int const& limit,int const& offset = 0,std::vector<TenantState> const& filters = std::vector<TenantState>(),Optional<TenantGroupName> const& tenantGroup = Optional<TenantGroupName>()) 
															#line 1846 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
		 : Actor<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>(),
		   ListTenantMetadataActorState<DB, ListTenantMetadataActor<DB>>(db, begin, end, limit, offset, filters, tenantGroup),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listTenantMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3242650202773022976UL, 1444534915101634048UL);
		ActorExecutionContextHelper __helper(static_cast<ListTenantMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listTenantMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listTenantMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListTenantMetadataActor<DB>, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ListTenantMetadataActor<DB>, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ListTenantMetadataActor<DB>, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ListTenantMetadataActor<DB>, 3, std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>> >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ListTenantMetadataActor<DB>, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
template <class DB>
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
[[nodiscard]] Future<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>> listTenantMetadata( Reference<DB> const& db, TenantName const& begin, TenantName const& end, int const& limit, int const& offset = 0, std::vector<TenantState> const& filters = std::vector<TenantState>(), Optional<TenantGroupName> const& tenantGroup = Optional<TenantGroupName>() ) {
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"
	return Future<std::vector<std::pair<TenantName, MetaclusterTenantMapEntry>>>(new ListTenantMetadataActor<DB>(db, begin, end, limit, offset, filters, tenantGroup));
															#line 1884 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/metacluster/include/metacluster/ListTenants.actor.g.h"
}

#line 195 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/metacluster/include/metacluster/ListTenants.actor.h"

} // namespace metacluster

#include "flow/unactorcompiler.h"
#endif