#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
/*
 * TimeKeeperCorrectness.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/workloads/workloads.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbserver/Knobs.h"
#include "flow/actorcompiler.h" // has to be last include

struct TimeKeeperCorrectnessWorkload : TestWorkload {
	static constexpr auto NAME = "TimeKeeperCorrectness";

	double testDuration;
	std::map<int64_t, Version> inMemTimeKeeper;

	TimeKeeperCorrectnessWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 20.0);
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	void getMetrics(std::vector<PerfMetric>& m) override {}

																#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 41 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
template <class _startActor>
															#line 41 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
class _startActorState {
															#line 49 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
public:
															#line 41 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	_startActorState(Database const& cx,TimeKeeperCorrectnessWorkload* const& self) 
															#line 41 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
															#line 41 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		 : cx(cx),
															#line 41 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		   self(self)
															#line 58 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			TraceEvent(SevInfo, "TKCorrectness_Start").log();
															#line 44 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			start = now();
															#line 45 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			;
															#line 77 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 63 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		TraceEvent(SevInfo, "TKCorrectness_Completed").log();
															#line 64 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 102 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 45 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		if (!(now() - start > self->testDuration))
															#line 121 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 46 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		tr = Transaction(cx);
															#line 48 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		;
															#line 129 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 60 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		StrictFuture<Void> __when_expr_2 = delay(std::min(SERVER_KNOBS->TIME_KEEPER_DELAY / 10, (int64_t)1L));
															#line 60 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 153 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 60 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 158 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 50 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			curTime = now();
															#line 51 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 51 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 179 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 51 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Version >*>(static_cast<_startActor*>(this)));
															#line 184 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 55 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 55 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 221 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 55 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 226 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Version const& v,int loopDepth) 
	{
															#line 52 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		self->inMemTimeKeeper[curTime] = v;
															#line 241 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Version && v,int loopDepth) 
	{
															#line 52 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		self->inMemTimeKeeper[curTime] = v;
															#line 250 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Version const& v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(v, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Version && v,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 41 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	Database cx;
															#line 41 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	TimeKeeperCorrectnessWorkload* self;
															#line 44 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	double start;
															#line 46 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	Transaction tr;
															#line 50 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	int64_t curTime;
															#line 514 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 41 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Version >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 519 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4723659572635378688UL, 7565773666370716928UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Version >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
															#line 41 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	_startActor(Database const& cx,TimeKeeperCorrectnessWorkload* const& self) 
															#line 538 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 41 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, TimeKeeperCorrectnessWorkload* const& self ) {
															#line 41 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 572 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
}

#line 66 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"

	Future<Void> start(Database const& cx) override { return _start(cx, this); }

																#line 579 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
template <class _checkActor>
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
class _checkActorState {
															#line 585 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
public:
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	_checkActorState(Database const& cx,TimeKeeperCorrectnessWorkload* const& self) 
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		 : cx(cx),
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		   self(self),
															#line 70 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		   dbTimeKeeper(KeyBackedMap<int64_t, Version>(timeKeeperPrefixRange.begin)),
															#line 71 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(cx))
															#line 598 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 73 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			TraceEvent(SevInfo, "TKCorrectness_CheckStart") .detail("TimeKeeperMaxEntries", SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES) .detail("TimeKeeperDelay", SERVER_KNOBS->TIME_KEEPER_DELAY);
															#line 77 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			;
															#line 615 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 79 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 80 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 82 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			StrictFuture<KeyBackedRangeResult<std::pair<int64_t, Version>>> __when_expr_0 = dbTimeKeeper.getRange(tr, 0, Optional<int64_t>(), self->inMemTimeKeeper.size() + 2);
															#line 82 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 652 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 82 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, KeyBackedRangeResult<std::pair<int64_t, Version>> >*>(static_cast<_checkActor*>(this)));
															#line 657 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 117 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 117 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 681 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 2;
															#line 117 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 1, Void >*>(static_cast<_checkActor*>(this)));
															#line 686 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(KeyBackedRangeResult<std::pair<int64_t, Version>> const& allItems,int loopDepth) 
	{
															#line 85 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		if (allItems.results.size() > SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES + 1)
															#line 701 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		{
															#line 86 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			TraceEvent(SevError, "TKCorrectness_TooManyEntries") .detail("Expected", SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES + 1) .detail("Found", allItems.results.size());
															#line 89 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 707 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_checkActorState();
			static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 92 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		if (allItems.results.size() < self->testDuration / SERVER_KNOBS->TIME_KEEPER_DELAY)
															#line 715 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		{
															#line 93 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			TraceEvent(SevWarnAlways, "TKCorrectness_TooFewEntries") .detail("Expected", self->testDuration / SERVER_KNOBS->TIME_KEEPER_DELAY) .detail("Found", allItems.results.size());
															#line 719 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		}
															#line 98 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		for( auto item : allItems.results ) {
															#line 99 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			auto it = self->inMemTimeKeeper.lower_bound(item.first);
															#line 100 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			if (it == self->inMemTimeKeeper.end())
															#line 727 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			{
				continue;
			}
															#line 104 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			if (item.second >= it->second)
															#line 733 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			{
															#line 105 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
				TraceEvent(SevError, "TKCorrectness_VersionIncorrectBounds") .detail("ClusterTime", item.first) .detail("ClusterVersion", item.second) .detail("LocalTime", it->first) .detail("LocalVersion", it->second);
															#line 110 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
				if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 739 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
				new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
				this->~_checkActorState();
				static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 114 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		TraceEvent(SevInfo, "TKCorrectness_Passed").log();
															#line 115 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 750 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(KeyBackedRangeResult<std::pair<int64_t, Version>> && allItems,int loopDepth) 
	{
															#line 85 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		if (allItems.results.size() > SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES + 1)
															#line 762 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		{
															#line 86 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			TraceEvent(SevError, "TKCorrectness_TooManyEntries") .detail("Expected", SERVER_KNOBS->TIME_KEEPER_MAX_ENTRIES + 1) .detail("Found", allItems.results.size());
															#line 89 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 768 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
			this->~_checkActorState();
			static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 92 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		if (allItems.results.size() < self->testDuration / SERVER_KNOBS->TIME_KEEPER_DELAY)
															#line 776 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		{
															#line 93 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			TraceEvent(SevWarnAlways, "TKCorrectness_TooFewEntries") .detail("Expected", self->testDuration / SERVER_KNOBS->TIME_KEEPER_DELAY) .detail("Found", allItems.results.size());
															#line 780 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		}
															#line 98 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		for( auto item : allItems.results ) {
															#line 99 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			auto it = self->inMemTimeKeeper.lower_bound(item.first);
															#line 100 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			if (it == self->inMemTimeKeeper.end())
															#line 788 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			{
				continue;
			}
															#line 104 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
			if (item.second >= it->second)
															#line 794 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
			{
															#line 105 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
				TraceEvent(SevError, "TKCorrectness_VersionIncorrectBounds") .detail("ClusterTime", item.first) .detail("ClusterVersion", item.second) .detail("LocalTime", it->first) .detail("LocalVersion", it->second);
															#line 110 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
				if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(false); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 800 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
				new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(false);
				this->~_checkActorState();
				static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 114 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		TraceEvent(SevInfo, "TKCorrectness_Passed").log();
															#line 115 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 811 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedRangeResult<std::pair<int64_t, Version>> const& allItems,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(allItems, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(KeyBackedRangeResult<std::pair<int64_t, Version>> && allItems,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(allItems), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, KeyBackedRangeResult<std::pair<int64_t, Version>> >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, KeyBackedRangeResult<std::pair<int64_t, Version>> >*,KeyBackedRangeResult<std::pair<int64_t, Version>> const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, KeyBackedRangeResult<std::pair<int64_t, Version>> >*,KeyBackedRangeResult<std::pair<int64_t, Version>> && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, KeyBackedRangeResult<std::pair<int64_t, Version>> >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _checkActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _checkActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	Database cx;
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	TimeKeeperCorrectnessWorkload* self;
															#line 70 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	KeyBackedMap<int64_t, Version> dbTimeKeeper;
															#line 71 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 989 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, KeyBackedRangeResult<std::pair<int64_t, Version>> >, public ActorCallback< _checkActor, 1, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 994 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(673612147144707840UL, 3783984659787567616UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, KeyBackedRangeResult<std::pair<int64_t, Version>> >;
friend struct ActorCallback< _checkActor, 1, Void >;
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	_checkActor(Database const& cx,TimeKeeperCorrectnessWorkload* const& self) 
															#line 1012 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, KeyBackedRangeResult<std::pair<int64_t, Version>> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _checkActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
[[nodiscard]] static Future<bool> _check( Database const& cx, TimeKeeperCorrectnessWorkload* const& self ) {
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 1045 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TimeKeeperCorrectness.actor.g.cpp"
}

#line 121 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/TimeKeeperCorrectness.actor.cpp"

	Future<bool> check(Database const& cx) override { return _check(cx, this); }
};

WorkloadFactory<TimeKeeperCorrectnessWorkload> TimeKeeperCorrectnessWorkloadFactory;
