#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
/*
 * MetaclusterManagementConcurrencyWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cstdint>
#include <limits>
#include "fdbclient/DatabaseContext.h"
#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/GenericManagementAPI.actor.h"
#include "fdbclient/MultiVersionTransaction.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/RunTransaction.actor.h"
#include "fdbclient/TenantManagement.actor.h"
#include "fdbclient/ThreadSafeTransaction.h"
#include "fdbrpc/simulator.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/Knobs.h"
#include "flow/Error.h"
#include "flow/IRandom.h"
#include "flow/ProtocolVersion.h"
#include "flow/flow.h"

#include "metacluster/Metacluster.h"
#include "metacluster/MetaclusterConsistency.actor.h"
#include "metacluster/TenantConsistency.actor.h"

#include "flow/actorcompiler.h" // This must be the last #include.

struct MetaclusterManagementConcurrencyWorkload : TestWorkload {
	static constexpr auto NAME = "MetaclusterManagementConcurrency";

	metacluster::util::SimulatedMetacluster simMetacluster;
	std::vector<ClusterName> dataDbIndex;

	double testDuration;
	bool createMetacluster;

	MetaclusterManagementConcurrencyWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		testDuration = getOption(options, "testDuration"_sr, 90.0);
		createMetacluster = getOption(options, "createMetacluster"_sr, true);
	}

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }

																#line 64 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 62 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class _setupActor>
															#line 62 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class _setupActorState {
															#line 70 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 62 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	_setupActorState(Database const& cx,MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 62 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 62 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : cx(cx),
															#line 62 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   self(self)
															#line 79 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 63 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = store(self->simMetacluster, metacluster::util::createSimulatedMetacluster( cx, deterministicRandom()->randomInt(TenantAPI::TENANT_ID_PREFIX_MIN_VALUE, TenantAPI::TENANT_ID_PREFIX_MAX_VALUE + 1), {}, metacluster::util::SkipMetaclusterCreation(self->clientId != 0 || !self->createMetacluster)));
															#line 63 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 96 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 63 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 101 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT_GT(self->simMetacluster.dataDbs.size(), 0);
															#line 72 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		for( auto const& [name, db] : self->simMetacluster.dataDbs ) {
															#line 73 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			self->dataDbIndex.push_back(name);
															#line 128 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		}
															#line 76 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 132 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 71 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT_GT(self->simMetacluster.dataDbs.size(), 0);
															#line 72 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		for( auto const& [name, db] : self->simMetacluster.dataDbs ) {
															#line 73 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			self->dataDbIndex.push_back(name);
															#line 148 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		}
															#line 76 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 62 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database cx;
															#line 62 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 239 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 62 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 244 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1753503435016858624UL, 11225196628733101312UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 62 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	_setupActor(Database const& cx,MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 261 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 62 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _setup( Database const& cx, MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 62 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 293 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 78 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

	ClusterName chooseClusterName() { return dataDbIndex[deterministicRandom()->randomInt(0, dataDbIndex.size())]; }

																#line 300 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via registerCluster()
															#line 81 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class RegisterClusterActor>
															#line 81 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class RegisterClusterActorState {
															#line 306 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 81 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	RegisterClusterActorState(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 81 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 81 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 82 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 83 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   dataDb(self->simMetacluster.dataDbs[clusterName]),
															#line 85 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   debugId(deterministicRandom()->randomUniqueID())
															#line 319 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("registerCluster", reinterpret_cast<unsigned long>(this));

	}
	~RegisterClusterActorState() 
	{
		fdb_probe_actor_destroy("registerCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 88 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				entry = metacluster::DataClusterEntry();
															#line 89 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				entry.capacity.numTenantGroups = deterministicRandom()->randomInt(0, 4);
															#line 90 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (deterministicRandom()->random01() < 0.2)
															#line 339 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 91 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					entry.autoTenantAssignment = metacluster::AutoTenantAssignment::DISABLED;
															#line 343 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				}
															#line 93 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				;
															#line 347 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 134 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 376 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 114 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRegisterClusterError", debugId) .error(e) .detail("ClusterName", clusterName);
															#line 117 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (e.code() != error_code_cluster_already_exists && e.code() != error_code_cluster_not_empty && e.code() != error_code_cluster_already_registered && e.code() != error_code_cluster_removed && e.code() != error_code_cluster_restoring)
															#line 391 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 120 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				TraceEvent(SevError, "MetaclusterManagementConcurrencyRegisterClusterFailure", debugId) .error(e) .detail("ClusterName", clusterName);
															#line 123 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				ASSERT(false);
															#line 397 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 126 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = success(errorOr(metacluster::removeCluster(self->simMetacluster.managementDb, clusterName, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove::True)));
															#line 126 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<RegisterClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 403 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_1.get(), loopDepth); };
			static_cast<RegisterClusterActor*>(this)->actor_wait_state = 2;
															#line 126 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RegisterClusterActor, 1, Void >*>(static_cast<RegisterClusterActor*>(this)));
															#line 408 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 94 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRegisteringCluster", debugId) .detail("ClusterName", clusterName) .detail("NumTenantGroups", entry.capacity.numTenantGroups);
															#line 97 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		Future<Void> registerFuture = metacluster::registerCluster(self->simMetacluster.managementDb, clusterName, dataDb.getReference()->getConnectionRecord()->getConnectionString(), entry);
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Optional<Void>> __when_expr_0 = timeout(registerFuture, deterministicRandom()->randomInt(1, 30));
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 442 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RegisterClusterActor*>(this)->actor_wait_state = 1;
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RegisterClusterActor, 0, Optional<Void> >*>(static_cast<RegisterClusterActor*>(this)));
															#line 447 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Void> const& result,int loopDepth) 
	{
															#line 104 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 469 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 105 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRegisteredCluster", debugId) .detail("ClusterName", clusterName) .detail("NumTenantGroups", entry.capacity.numTenantGroups);
															#line 473 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 111 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Register cluster timed out");
															#line 478 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Void> && result,int loopDepth) 
	{
															#line 104 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 487 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 105 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRegisteredCluster", debugId) .detail("ClusterName", clusterName) .detail("NumTenantGroups", entry.capacity.numTenantGroups);
															#line 491 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 111 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Register cluster timed out");
															#line 496 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state > 0) static_cast<RegisterClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterClusterActor*>(this)->ActorCallback< RegisterClusterActor, 0, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 0, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 0, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RegisterClusterActor, 0, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 593 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
															#line 131 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<RegisterClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RegisterClusterActorState(); static_cast<RegisterClusterActor*>(this)->destroy(); return 0; }
															#line 605 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<RegisterClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RegisterClusterActorState();
		static_cast<RegisterClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RegisterClusterActor*>(this)->actor_wait_state > 0) static_cast<RegisterClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RegisterClusterActor*>(this)->ActorCallback< RegisterClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RegisterClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RegisterClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 81 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 82 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName;
															#line 83 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database dataDb;
															#line 85 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	UID debugId;
															#line 88 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	metacluster::DataClusterEntry entry;
															#line 698 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via registerCluster()
															#line 81 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class RegisterClusterActor final : public Actor<Void>, public ActorCallback< RegisterClusterActor, 0, Optional<Void> >, public ActorCallback< RegisterClusterActor, 1, Void >, public FastAllocated<RegisterClusterActor>, public RegisterClusterActorState<RegisterClusterActor> {
															#line 703 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<RegisterClusterActor>::operator new;
	using FastAllocated<RegisterClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(18216880612323518464UL, 712935976848985344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RegisterClusterActor, 0, Optional<Void> >;
friend struct ActorCallback< RegisterClusterActor, 1, Void >;
															#line 81 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	RegisterClusterActor(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 721 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RegisterClusterActorState<RegisterClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("registerCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5031830753118412800UL, 13167156597116580864UL);
		ActorExecutionContextHelper __helper(static_cast<RegisterClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("registerCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("registerCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RegisterClusterActor, 0, Optional<Void> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RegisterClusterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 81 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> registerCluster( MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 81 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new RegisterClusterActor(self));
															#line 754 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 136 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

																#line 759 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via removeCluster()
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class RemoveClusterActor>
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class RemoveClusterActorState {
															#line 765 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	RemoveClusterActorState(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 138 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 139 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   dataDb(self->simMetacluster.dataDbs[clusterName]),
															#line 140 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   forceRemove(deterministicRandom()->coinflip()),
															#line 142 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   debugId(deterministicRandom()->randomUniqueID())
															#line 780 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("removeCluster", reinterpret_cast<unsigned long>(this));

	}
	~RemoveClusterActorState() 
	{
		fdb_probe_actor_destroy("removeCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 145 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				;
															#line 796 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RemoveClusterActorState();
		static_cast<RemoveClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 175 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<RemoveClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveClusterActorState(); static_cast<RemoveClusterActor*>(this)->destroy(); return 0; }
															#line 825 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<RemoveClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveClusterActorState();
		static_cast<RemoveClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 163 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRemoveClusterError", debugId) .error(e) .detail("ClusterName", clusterName);
															#line 166 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (e.code() != error_code_cluster_not_found && e.code() != error_code_cluster_not_empty)
															#line 840 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 167 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				TraceEvent(SevError, "MetaclusterManagementConcurrencyRemoveClusterFailure", debugId) .error(e) .detail("ClusterName", clusterName);
															#line 170 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				ASSERT(false);
															#line 846 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 172 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (!static_cast<RemoveClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveClusterActorState(); static_cast<RemoveClusterActor*>(this)->destroy(); return 0; }
															#line 850 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			new (&static_cast<RemoveClusterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~RemoveClusterActorState();
			static_cast<RemoveClusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 146 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRemovingCluster", debugId) .detail("ClusterName", clusterName);
															#line 148 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		Future<bool> removeFuture = metacluster::removeCluster(self->simMetacluster.managementDb, clusterName, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove::False);
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Optional<bool>> __when_expr_0 = timeout(removeFuture, deterministicRandom()->randomInt(1, 30));
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<RemoveClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 887 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<RemoveClusterActor*>(this)->actor_wait_state = 1;
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RemoveClusterActor, 0, Optional<bool> >*>(static_cast<RemoveClusterActor*>(this)));
															#line 892 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<bool> const& result,int loopDepth) 
	{
															#line 153 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 914 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 154 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			ASSERT(result.get());
															#line 155 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRemovedCluster", debugId) .detail("ClusterName", clusterName);
															#line 920 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Remove cluster timed out");
															#line 925 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<bool> && result,int loopDepth) 
	{
															#line 153 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 934 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 154 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			ASSERT(result.get());
															#line 155 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRemovedCluster", debugId) .detail("ClusterName", clusterName);
															#line 940 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Remove cluster timed out");
															#line 945 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<bool> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<bool> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RemoveClusterActor*>(this)->actor_wait_state > 0) static_cast<RemoveClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveClusterActor*>(this)->ActorCallback< RemoveClusterActor, 0, Optional<bool> >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveClusterActor, 0, Optional<bool> >*,Optional<bool> const& value) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoveClusterActor, 0, Optional<bool> >*,Optional<bool> && value) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RemoveClusterActor, 0, Optional<bool> >*,Error err) 
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 138 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName;
															#line 139 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database dataDb;
															#line 140 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	metacluster::ForceRemove forceRemove;
															#line 142 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	UID debugId;
															#line 1048 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via removeCluster()
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class RemoveClusterActor final : public Actor<Void>, public ActorCallback< RemoveClusterActor, 0, Optional<bool> >, public FastAllocated<RemoveClusterActor>, public RemoveClusterActorState<RemoveClusterActor> {
															#line 1053 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<RemoveClusterActor>::operator new;
	using FastAllocated<RemoveClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16179266410390217984UL, 5514483093006935552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RemoveClusterActor, 0, Optional<bool> >;
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	RemoveClusterActor(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 1070 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RemoveClusterActorState<RemoveClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("removeCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(812508501301004544UL, 4934221500031631872UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("removeCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("removeCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RemoveClusterActor, 0, Optional<bool> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> removeCluster( MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 137 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new RemoveClusterActor(self));
															#line 1102 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 177 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

																#line 1107 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via listClusters()
															#line 178 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class ListClustersActor>
															#line 178 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class ListClustersActorState {
															#line 1113 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 178 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ListClustersActorState(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 178 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 178 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 179 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName1(self->chooseClusterName()),
															#line 180 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName2(self->chooseClusterName()),
															#line 181 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   limit(deterministicRandom()->randomInt(1, self->simMetacluster.dataDbs.size() + 1))
															#line 1126 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("listClusters", reinterpret_cast<unsigned long>(this));

	}
	~ListClustersActorState() 
	{
		fdb_probe_actor_destroy("listClusters", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 183 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				TraceEvent(SevDebug, "MetaclusterManagementConcurrencyListClusters") .detail("StartClusterName", clusterName1) .detail("EndClusterName", clusterName2) .detail("Limit", limit);
															#line 188 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				StrictFuture<std::map<ClusterName, metacluster::DataClusterMetadata>> __when_expr_0 = metacluster::listClusters(self->simMetacluster.managementDb, clusterName1, clusterName2, limit);
															#line 188 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (static_cast<ListClustersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1146 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ListClustersActor*>(this)->actor_wait_state = 1;
															#line 188 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*>(static_cast<ListClustersActor*>(this)));
															#line 1151 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ListClustersActorState();
		static_cast<ListClustersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 214 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<ListClustersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListClustersActorState(); static_cast<ListClustersActor*>(this)->destroy(); return 0; }
															#line 1180 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<ListClustersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ListClustersActorState();
		static_cast<ListClustersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 199 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyListClustersError") .error(e) .detail("StartClusterName", clusterName1) .detail("EndClusterName", clusterName2) .detail("Limit", limit);
															#line 205 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (e.code() != error_code_inverted_range)
															#line 1195 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 206 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				TraceEvent(SevError, "MetaclusterManagementConcurrencyListClusterFailure") .error(e) .detail("ClusterName1", clusterName1) .detail("ClusterName2", clusterName2);
															#line 210 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				ASSERT(false);
															#line 1201 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 212 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (!static_cast<ListClustersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ListClustersActorState(); static_cast<ListClustersActor*>(this)->destroy(); return 0; }
															#line 1205 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			new (&static_cast<ListClustersActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~ListClustersActorState();
			static_cast<ListClustersActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(std::map<ClusterName, metacluster::DataClusterMetadata> const& clusterList,int loopDepth) 
	{
															#line 191 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyListedClusters") .detail("StartClusterName", clusterName1) .detail("EndClusterName", clusterName2) .detail("Limit", limit);
															#line 196 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT(clusterName1 <= clusterName2);
															#line 197 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT(clusterList.size() <= limit);
															#line 1227 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(std::map<ClusterName, metacluster::DataClusterMetadata> && clusterList,int loopDepth) 
	{
															#line 191 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyListedClusters") .detail("StartClusterName", clusterName1) .detail("EndClusterName", clusterName2) .detail("Limit", limit);
															#line 196 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT(clusterName1 <= clusterName2);
															#line 197 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT(clusterList.size() <= limit);
															#line 1240 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::map<ClusterName, metacluster::DataClusterMetadata> const& clusterList,int loopDepth) 
	{
		loopDepth = a_body1cont2(clusterList, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::map<ClusterName, metacluster::DataClusterMetadata> && clusterList,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(clusterList), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ListClustersActor*>(this)->actor_wait_state > 0) static_cast<ListClustersActor*>(this)->actor_wait_state = 0;
		static_cast<ListClustersActor*>(this)->ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*,std::map<ClusterName, metacluster::DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*,std::map<ClusterName, metacluster::DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 178 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 179 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName1;
															#line 180 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName2;
															#line 181 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	int limit;
															#line 1341 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via listClusters()
															#line 178 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class ListClustersActor final : public Actor<Void>, public ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >, public FastAllocated<ListClustersActor>, public ListClustersActorState<ListClustersActor> {
															#line 1346 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<ListClustersActor>::operator new;
	using FastAllocated<ListClustersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16022058237259770880UL, 14579734523059505920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >;
															#line 178 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ListClustersActor(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 1363 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ListClustersActorState<ListClustersActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("listClusters", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2037707045627374080UL, 7691457401409661952UL);
		ActorExecutionContextHelper __helper(static_cast<ListClustersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("listClusters");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("listClusters", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ListClustersActor, 0, std::map<ClusterName, metacluster::DataClusterMetadata> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 178 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> listClusters( MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 178 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new ListClustersActor(self));
															#line 1395 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 216 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

																#line 1400 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via getCluster()
															#line 217 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class GetClusterActor>
															#line 217 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class GetClusterActorState {
															#line 1406 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 217 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	GetClusterActorState(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 217 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 217 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 218 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 219 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   dataDb(self->simMetacluster.dataDbs[clusterName])
															#line 1417 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("getCluster", reinterpret_cast<unsigned long>(this));

	}
	~GetClusterActorState() 
	{
		fdb_probe_actor_destroy("getCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 222 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				TraceEvent(SevDebug, "MetaclusterManagementConcurrencyGetCluster").detail("ClusterName", clusterName);
															#line 223 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				StrictFuture<metacluster::DataClusterMetadata> __when_expr_0 = metacluster::getCluster(self->simMetacluster.managementDb, clusterName);
															#line 223 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (static_cast<GetClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 1437 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetClusterActor*>(this)->actor_wait_state = 1;
															#line 223 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*>(static_cast<GetClusterActor*>(this)));
															#line 1442 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetClusterActorState();
		static_cast<GetClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 242 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<GetClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetClusterActorState(); static_cast<GetClusterActor*>(this)->destroy(); return 0; }
															#line 1471 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<GetClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~GetClusterActorState();
		static_cast<GetClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 230 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyGetClusterError") .error(e) .detail("ClusterName", clusterName);
															#line 233 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (e.code() != error_code_cluster_not_found)
															#line 1486 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 234 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				TraceEvent(SevError, "MetaclusterManagementConcurrencyGetClusterFailure") .error(e) .detail("ClusterName", clusterName);
															#line 237 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				ASSERT(false);
															#line 1492 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 239 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (!static_cast<GetClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~GetClusterActorState(); static_cast<GetClusterActor*>(this)->destroy(); return 0; }
															#line 1496 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			new (&static_cast<GetClusterActor*>(this)->SAV< Void >::value()) Void(Void());
			this->~GetClusterActorState();
			static_cast<GetClusterActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(metacluster::DataClusterMetadata const& clusterMetadata,int loopDepth) 
	{
															#line 225 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyGotCluster").detail("ClusterName", clusterName);
															#line 227 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT(dataDb.getReference()->getConnectionRecord()->getConnectionString() == clusterMetadata.connectionString);
															#line 1516 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(metacluster::DataClusterMetadata && clusterMetadata,int loopDepth) 
	{
															#line 225 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyGotCluster").detail("ClusterName", clusterName);
															#line 227 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		ASSERT(dataDb.getReference()->getConnectionRecord()->getConnectionString() == clusterMetadata.connectionString);
															#line 1527 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::DataClusterMetadata const& clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont2(clusterMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1when1(metacluster::DataClusterMetadata && clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(clusterMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetClusterActor*>(this)->actor_wait_state > 0) static_cast<GetClusterActor*>(this)->actor_wait_state = 0;
		static_cast<GetClusterActor*>(this)->ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >::remove();

	}
	void a_callback_fire(ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*,metacluster::DataClusterMetadata const& value) 
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*,metacluster::DataClusterMetadata && value) 
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*,Error err) 
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 217 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 218 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName;
															#line 219 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database dataDb;
															#line 1626 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via getCluster()
															#line 217 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class GetClusterActor final : public Actor<Void>, public ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >, public FastAllocated<GetClusterActor>, public GetClusterActorState<GetClusterActor> {
															#line 1631 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<GetClusterActor>::operator new;
	using FastAllocated<GetClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3821907633342619648UL, 2860762671397013248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >;
															#line 217 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	GetClusterActor(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 1648 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   GetClusterActorState<GetClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3838274093655030272UL, 16128179049859696384UL);
		ActorExecutionContextHelper __helper(static_cast<GetClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetClusterActor, 0, metacluster::DataClusterMetadata >*)0, actor_cancelled()); break;
		}

	}
};
															#line 217 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> getCluster( MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 217 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new GetClusterActor(self));
															#line 1680 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 244 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

																#line 1685 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via configureImpl()
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class ConfigureImplActor>
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class ConfigureImplActorState {
															#line 1691 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ConfigureImplActorState(MetaclusterManagementConcurrencyWorkload* const& self,ClusterName const& clusterName,Optional<int64_t> const& numTenantGroups,Optional<ClusterConnectionString> const& connectionString,Optional<metacluster::AutoTenantAssignment> const& autoTenantAssignment) 
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName(clusterName),
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   numTenantGroups(numTenantGroups),
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   connectionString(connectionString),
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   autoTenantAssignment(autoTenantAssignment),
															#line 251 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   tr(self->simMetacluster.managementDb->createTransaction())
															#line 1708 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("configureImpl", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureImplActorState() 
	{
		fdb_probe_actor_destroy("configureImpl", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 252 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			;
															#line 1723 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureImplActorState();
		static_cast<ConfigureImplActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 254 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 255 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Optional<metacluster::DataClusterMetadata>> __when_expr_0 = metacluster::tryGetClusterTransaction(tr, clusterName);
															#line 255 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1758 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ConfigureImplActor*>(this)->actor_wait_state = 1;
															#line 255 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*>(static_cast<ConfigureImplActor*>(this)));
															#line 1763 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 279 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_2 = safeThreadFutureToFuture(tr->onError(e));
															#line 279 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1787 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ConfigureImplActor*>(this)->actor_wait_state = 3;
															#line 279 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 2, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 1792 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<metacluster::DataClusterMetadata> const& clusterMetadata,int loopDepth) 
	{
															#line 257 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		entry = Optional<metacluster::DataClusterEntry>();
															#line 259 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (clusterMetadata.present())
															#line 1809 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 260 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (numTenantGroups.present())
															#line 1813 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 261 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (!entry.present())
															#line 1817 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 262 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					entry = clusterMetadata.get().entry;
															#line 1821 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				}
															#line 264 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				entry.get().capacity.numTenantGroups = numTenantGroups.get();
															#line 1825 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 266 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (autoTenantAssignment.present())
															#line 1829 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 267 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (!entry.present())
															#line 1833 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 268 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					entry = clusterMetadata.get().entry;
															#line 1837 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				}
															#line 270 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				entry.get().autoTenantAssignment = autoTenantAssignment.get();
															#line 1841 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 272 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			metacluster::updateClusterMetadata(tr, clusterName, clusterMetadata.get(), connectionString, entry);
															#line 274 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 274 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1849 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConfigureImplActor*>(this)->actor_wait_state = 2;
															#line 274 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 1, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 1854 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<metacluster::DataClusterMetadata> && clusterMetadata,int loopDepth) 
	{
															#line 257 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		entry = Optional<metacluster::DataClusterEntry>();
															#line 259 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (clusterMetadata.present())
															#line 1870 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 260 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (numTenantGroups.present())
															#line 1874 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 261 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (!entry.present())
															#line 1878 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 262 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					entry = clusterMetadata.get().entry;
															#line 1882 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				}
															#line 264 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				entry.get().capacity.numTenantGroups = numTenantGroups.get();
															#line 1886 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 266 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (autoTenantAssignment.present())
															#line 1890 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 267 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (!entry.present())
															#line 1894 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 268 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					entry = clusterMetadata.get().entry;
															#line 1898 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				}
															#line 270 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				entry.get().autoTenantAssignment = autoTenantAssignment.get();
															#line 1902 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 272 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			metacluster::updateClusterMetadata(tr, clusterName, clusterMetadata.get(), connectionString, entry);
															#line 274 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = buggifiedCommit(tr, BUGGIFY_WITH_PROB(0.1));
															#line 274 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<ConfigureImplActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1910 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
			static_cast<ConfigureImplActor*>(this)->actor_wait_state = 2;
															#line 274 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ConfigureImplActor, 1, Void >*>(static_cast<ConfigureImplActor*>(this)));
															#line 1915 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont3(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<metacluster::DataClusterMetadata> const& clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(clusterMetadata, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<metacluster::DataClusterMetadata> && clusterMetadata,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(clusterMetadata), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureImplActor*>(this)->ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*,Optional<metacluster::DataClusterMetadata> const& value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*,Optional<metacluster::DataClusterMetadata> && value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*,Error err) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 277 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<ConfigureImplActor*>(this)->SAV<Optional<metacluster::DataClusterEntry>>::futures) { (void)(entry); this->~ConfigureImplActorState(); static_cast<ConfigureImplActor*>(this)->destroy(); return 0; }
															#line 2004 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<ConfigureImplActor*>(this)->SAV< Optional<metacluster::DataClusterEntry> >::value()) Optional<metacluster::DataClusterEntry>(std::move(entry)); // state_var_RVO
		this->~ConfigureImplActorState();
		static_cast<ConfigureImplActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureImplActor*>(this)->ActorCallback< ConfigureImplActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ConfigureImplActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ConfigureImplActor*>(this)->actor_wait_state > 0) static_cast<ConfigureImplActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureImplActor*>(this)->ActorCallback< ConfigureImplActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ConfigureImplActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ConfigureImplActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName;
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Optional<int64_t> numTenantGroups;
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Optional<ClusterConnectionString> connectionString;
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Optional<metacluster::AutoTenantAssignment> autoTenantAssignment;
															#line 251 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Reference<ITransaction> tr;
															#line 257 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Optional<metacluster::DataClusterEntry> entry;
															#line 2200 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via configureImpl()
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class ConfigureImplActor final : public Actor<Optional<metacluster::DataClusterEntry>>, public ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >, public ActorCallback< ConfigureImplActor, 1, Void >, public ActorCallback< ConfigureImplActor, 2, Void >, public FastAllocated<ConfigureImplActor>, public ConfigureImplActorState<ConfigureImplActor> {
															#line 2205 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<ConfigureImplActor>::operator new;
	using FastAllocated<ConfigureImplActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2426814824343099904UL, 12350578585161383680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Optional<metacluster::DataClusterEntry>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >;
friend struct ActorCallback< ConfigureImplActor, 1, Void >;
friend struct ActorCallback< ConfigureImplActor, 2, Void >;
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ConfigureImplActor(MetaclusterManagementConcurrencyWorkload* const& self,ClusterName const& clusterName,Optional<int64_t> const& numTenantGroups,Optional<ClusterConnectionString> const& connectionString,Optional<metacluster::AutoTenantAssignment> const& autoTenantAssignment) 
															#line 2224 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Optional<metacluster::DataClusterEntry>>(),
		   ConfigureImplActorState<ConfigureImplActor>(self, clusterName, numTenantGroups, connectionString, autoTenantAssignment),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureImpl", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(766673556958241024UL, 14520056664626172928UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureImplActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureImpl");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureImpl", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureImplActor, 0, Optional<metacluster::DataClusterMetadata> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ConfigureImplActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ConfigureImplActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Optional<metacluster::DataClusterEntry>> configureImpl( MetaclusterManagementConcurrencyWorkload* const& self, ClusterName const& clusterName, Optional<int64_t> const& numTenantGroups, Optional<ClusterConnectionString> const& connectionString, Optional<metacluster::AutoTenantAssignment> const& autoTenantAssignment ) {
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Optional<metacluster::DataClusterEntry>>(new ConfigureImplActor(self, clusterName, numTenantGroups, connectionString, autoTenantAssignment));
															#line 2258 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 283 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

																#line 2263 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via configureCluster()
															#line 284 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class ConfigureClusterActor>
															#line 284 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class ConfigureClusterActorState {
															#line 2269 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 284 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ConfigureClusterActorState(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 284 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 284 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 285 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 286 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   dataDb(self->simMetacluster.dataDbs[clusterName]),
															#line 288 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   debugId(deterministicRandom()->randomUniqueID()),
															#line 290 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   newNumTenantGroups(),
															#line 291 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   connectionString(),
															#line 292 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   autoTenantAssignment()
															#line 2288 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("configureCluster", reinterpret_cast<unsigned long>(this));

	}
	~ConfigureClusterActorState() 
	{
		fdb_probe_actor_destroy("configureCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 293 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 2303 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 294 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				newNumTenantGroups = deterministicRandom()->randomInt(0, 4);
															#line 2307 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 296 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 2311 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 297 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				connectionString = dataDb.getReference()->getConnectionRecord()->getConnectionString();
															#line 2315 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
															#line 299 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (deterministicRandom()->coinflip())
															#line 2319 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 300 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				autoTenantAssignment = deterministicRandom()->coinflip() ? metacluster::AutoTenantAssignment::DISABLED : metacluster::AutoTenantAssignment::ENABLED;
															#line 2323 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
			try {
															#line 305 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				;
															#line 2328 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ConfigureClusterActorState();
		static_cast<ConfigureClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 342 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<ConfigureClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ConfigureClusterActorState(); static_cast<ConfigureClusterActor*>(this)->destroy(); return 0; }
															#line 2357 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<ConfigureClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ConfigureClusterActorState();
		static_cast<ConfigureClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 328 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyConfigureClusterError", debugId) .error(e) .detail("ClusterName", clusterName) .detail("NewNumTenantGroups", newNumTenantGroups.orDefault(-1)) .detail("NewConnectionString", connectionString.map(&ClusterConnectionString::toString).orDefault(""));
															#line 333 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (e.code() != error_code_cluster_not_found && e.code() != error_code_cluster_removed && e.code() != error_code_invalid_metacluster_operation && e.code() != error_code_cluster_restoring)
															#line 2372 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 335 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				TraceEvent(SevError, "MetaclusterManagementConcurrencyConfigureClusterFailure") .error(e) .detail("ClusterName", clusterName);
															#line 338 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				ASSERT(false);
															#line 2378 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 306 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyConfigureCluster", debugId) .detail("ClusterName", clusterName) .detail("NewNumTenantGroups", newNumTenantGroups.orDefault(-1)) .detail("NewConnectionString", connectionString.map(&ClusterConnectionString::toString).orDefault(""));
															#line 312 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Optional<Optional<metacluster::DataClusterEntry>>> __when_expr_0 = timeout( configureImpl(self, clusterName, newNumTenantGroups, connectionString, autoTenantAssignment), deterministicRandom()->randomInt(1, 30));
															#line 312 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<ConfigureClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2411 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ConfigureClusterActor*>(this)->actor_wait_state = 1;
															#line 312 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*>(static_cast<ConfigureClusterActor*>(this)));
															#line 2416 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Optional<metacluster::DataClusterEntry>> const& result,int loopDepth) 
	{
															#line 316 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 2438 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 317 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyConfiguredCluster", debugId) .detail("ClusterName", clusterName) .detail("NewNumTenantGroups", newNumTenantGroups.orDefault(-1)) .detail("NewConnectionString", connectionString.map(&ClusterConnectionString::toString).orDefault(""));
															#line 2442 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 325 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Configure cluster timed out");
															#line 2447 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Optional<Optional<metacluster::DataClusterEntry>> && result,int loopDepth) 
	{
															#line 316 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 2456 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 317 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyConfiguredCluster", debugId) .detail("ClusterName", clusterName) .detail("NewNumTenantGroups", newNumTenantGroups.orDefault(-1)) .detail("NewConnectionString", connectionString.map(&ClusterConnectionString::toString).orDefault(""));
															#line 2460 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 325 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Configure cluster timed out");
															#line 2465 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Optional<metacluster::DataClusterEntry>> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Optional<metacluster::DataClusterEntry>> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ConfigureClusterActor*>(this)->actor_wait_state > 0) static_cast<ConfigureClusterActor*>(this)->actor_wait_state = 0;
		static_cast<ConfigureClusterActor*>(this)->ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >::remove();

	}
	void a_callback_fire(ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*,Optional<Optional<metacluster::DataClusterEntry>> const& value) 
	{
		fdb_probe_actor_enter("configureCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*,Optional<Optional<metacluster::DataClusterEntry>> && value) 
	{
		fdb_probe_actor_enter("configureCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*,Error err) 
	{
		fdb_probe_actor_enter("configureCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("configureCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 284 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 285 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName;
															#line 286 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database dataDb;
															#line 288 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	UID debugId;
															#line 290 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Optional<int64_t> newNumTenantGroups;
															#line 291 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Optional<ClusterConnectionString> connectionString;
															#line 292 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Optional<metacluster::AutoTenantAssignment> autoTenantAssignment;
															#line 2572 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via configureCluster()
															#line 284 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class ConfigureClusterActor final : public Actor<Void>, public ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >, public FastAllocated<ConfigureClusterActor>, public ConfigureClusterActorState<ConfigureClusterActor> {
															#line 2577 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<ConfigureClusterActor>::operator new;
	using FastAllocated<ConfigureClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5121722979538603264UL, 8683297438447022336UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >;
															#line 284 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ConfigureClusterActor(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 2594 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   ConfigureClusterActorState<ConfigureClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("configureCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6960254137143238656UL, 15722660461201014016UL);
		ActorExecutionContextHelper __helper(static_cast<ConfigureClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("configureCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("configureCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ConfigureClusterActor, 0, Optional<Optional<metacluster::DataClusterEntry>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 284 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> configureCluster( MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 284 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new ConfigureClusterActor(self));
															#line 2626 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 344 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

																#line 2631 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via restoreCluster()
															#line 345 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class RestoreClusterActor>
															#line 345 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class RestoreClusterActorState {
															#line 2637 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 345 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	RestoreClusterActorState(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 345 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 345 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : self(self),
															#line 346 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   clusterName(self->chooseClusterName()),
															#line 347 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   db(self->simMetacluster.dataDbs[clusterName]),
															#line 348 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   applyManagementClusterUpdates(deterministicRandom()->coinflip()),
															#line 350 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   forceJoin(deterministicRandom()->coinflip()),
															#line 351 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   removeFirst(!applyManagementClusterUpdates && deterministicRandom()->coinflip()),
															#line 353 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   debugId(deterministicRandom()->randomUniqueID())
															#line 2656 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("restoreCluster", reinterpret_cast<unsigned long>(this));

	}
	~RestoreClusterActorState() 
	{
		fdb_probe_actor_destroy("restoreCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 356 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				;
															#line 2672 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RestoreClusterActorState();
		static_cast<RestoreClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 448 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<RestoreClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RestoreClusterActorState(); static_cast<RestoreClusterActor*>(this)->destroy(); return 0; }
															#line 2701 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<RestoreClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RestoreClusterActorState();
		static_cast<RestoreClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 419 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreError", debugId) .error(e) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 424 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (e.code() == error_code_cluster_already_registered)
															#line 2716 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 425 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				ASSERT(!forceJoin || !applyManagementClusterUpdates);
															#line 2720 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			}
			else
			{
															#line 426 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (applyManagementClusterUpdates && e.code() == error_code_invalid_data_cluster)
															#line 2726 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				{
				}
				else
				{
															#line 429 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					if (!applyManagementClusterUpdates && (e.code() == error_code_cluster_already_exists || e.code() == error_code_tenant_already_exists || e.code() == error_code_invalid_tenant_configuration))
															#line 2733 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
					{
					}
					else
					{
															#line 433 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
						if (e.code() != error_code_cluster_not_found && e.code() != error_code_cluster_removed && e.code() != error_code_conflicting_restore)
															#line 2740 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
						{
															#line 435 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
							TraceEvent(SevError, "MetaclusterManagementConcurrencyRestoreFailure", debugId) .error(e) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 439 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
							ASSERT(false);
															#line 2746 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
						}
					}
				}
			}
															#line 442 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_3 = success(errorOr(metacluster::removeCluster(self->simMetacluster.managementDb, clusterName, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove::True)));
															#line 442 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2755 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1Catch2when1(__when_expr_3.get(), loopDepth); };
			static_cast<RestoreClusterActor*>(this)->actor_wait_state = 4;
															#line 442 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 3, Void >*>(static_cast<RestoreClusterActor*>(this)));
															#line 2760 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 357 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestore", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 361 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (removeFirst)
															#line 2790 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 362 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreRemoveDataCluster", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 366 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(errorOr(metacluster::removeCluster(self->simMetacluster.managementDb, clusterName, ClusterType::METACLUSTER_MANAGEMENT, metacluster::ForceRemove::True)));
															#line 366 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2798 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RestoreClusterActor*>(this)->actor_wait_state = 1;
															#line 366 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 0, Void >*>(static_cast<RestoreClusterActor*>(this)));
															#line 2803 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 376 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		messages = std::vector<std::string>();
															#line 377 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (deterministicRandom()->coinflip())
															#line 2832 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 378 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreDryRun", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 382 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_1 = metacluster::restoreCluster(self->simMetacluster.managementDb, clusterName, db->getConnectionRecord()->getConnectionString(), applyManagementClusterUpdates, metacluster::RestoreDryRun::True, forceJoin, metacluster::ForceReuseTenantIdPrefix::True, &messages);
															#line 382 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2840 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RestoreClusterActor*>(this)->actor_wait_state = 2;
															#line 382 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 1, Void >*>(static_cast<RestoreClusterActor*>(this)));
															#line 2845 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 371 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreRemovedDataCluster", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 2859 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 371 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreRemovedDataCluster", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 2868 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
															#line 398 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		StrictFuture<Optional<Void>> __when_expr_2 = timeout(metacluster::restoreCluster(self->simMetacluster.managementDb, clusterName, db->getConnectionRecord()->getConnectionString(), applyManagementClusterUpdates, metacluster::RestoreDryRun::False, forceJoin, metacluster::ForceReuseTenantIdPrefix::True, &messages), 30.0);
															#line 398 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2954 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont4when1(__when_expr_2.get(), loopDepth); };
		static_cast<RestoreClusterActor*>(this)->actor_wait_state = 3;
															#line 398 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< RestoreClusterActor, 2, Optional<Void> >*>(static_cast<RestoreClusterActor*>(this)));
															#line 2959 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 391 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreDryRunDone", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 395 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		messages.clear();
															#line 2970 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 391 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreDryRunDone", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 395 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		messages.clear();
															#line 2981 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont7(Optional<Void> const& result,int loopDepth) 
	{
															#line 409 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 3065 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 410 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreComplete", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 3069 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 416 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Restore cluster timed out");
															#line 3074 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Optional<Void> && result,int loopDepth) 
	{
															#line 409 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (result.present())
															#line 3083 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 410 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			TraceEvent(SevDebug, "MetaclusterManagementConcurrencyRestoreComplete", debugId) .detail("ClusterName", clusterName) .detail("ApplyManagementClusterUpdates", applyManagementClusterUpdates);
															#line 3087 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 416 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		CODE_PROBE(true, "Restore cluster timed out");
															#line 3092 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Optional<Void> const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont4when1(Optional<Void> && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 2, Optional<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 2, Optional<Void> >*,Optional<Void> const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 2, Optional<Void> >*,Optional<Void> && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 2, Optional<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch2cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1Catch2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1Catch2cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<RestoreClusterActor*>(this)->actor_wait_state > 0) static_cast<RestoreClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RestoreClusterActor*>(this)->ActorCallback< RestoreClusterActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< RestoreClusterActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< RestoreClusterActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 345 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 346 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	ClusterName clusterName;
															#line 347 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database db;
															#line 348 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	metacluster::ApplyManagementClusterUpdates applyManagementClusterUpdates;
															#line 350 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	metacluster::ForceJoin forceJoin;
															#line 351 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	bool removeFirst;
															#line 353 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	UID debugId;
															#line 376 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	std::vector<std::string> messages;
															#line 3288 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via restoreCluster()
															#line 345 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class RestoreClusterActor final : public Actor<Void>, public ActorCallback< RestoreClusterActor, 0, Void >, public ActorCallback< RestoreClusterActor, 1, Void >, public ActorCallback< RestoreClusterActor, 2, Optional<Void> >, public ActorCallback< RestoreClusterActor, 3, Void >, public FastAllocated<RestoreClusterActor>, public RestoreClusterActorState<RestoreClusterActor> {
															#line 3293 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<RestoreClusterActor>::operator new;
	using FastAllocated<RestoreClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12871660931611274496UL, 16330185937938286848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RestoreClusterActor, 0, Void >;
friend struct ActorCallback< RestoreClusterActor, 1, Void >;
friend struct ActorCallback< RestoreClusterActor, 2, Optional<Void> >;
friend struct ActorCallback< RestoreClusterActor, 3, Void >;
															#line 345 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	RestoreClusterActor(MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 3313 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   RestoreClusterActorState<RestoreClusterActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("restoreCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12143823830767418880UL, 265345168070311680UL);
		ActorExecutionContextHelper __helper(static_cast<RestoreClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("restoreCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("restoreCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RestoreClusterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RestoreClusterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< RestoreClusterActor, 2, Optional<Void> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< RestoreClusterActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 345 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> restoreCluster( MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 345 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new RestoreClusterActor(self));
															#line 3348 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 450 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

	Future<Void> start(Database const& cx) override { return _start(cx, this); }
																#line 3354 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 452 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class _startActor>
															#line 452 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class _startActorState {
															#line 3360 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 452 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	_startActorState(Database const& cx,MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 452 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 452 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : cx(cx),
															#line 452 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   self(self),
															#line 453 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   start(now())
															#line 3371 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 456 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			;
															#line 3386 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 473 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 3409 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 456 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!(now() < start + self->testDuration))
															#line 3428 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 457 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		operation = deterministicRandom()->randomInt(0, 6);
															#line 458 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (operation == 0)
															#line 3436 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		{
															#line 459 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = registerCluster(self);
															#line 459 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3442 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 459 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 3447 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 460 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (operation == 1)
															#line 3454 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			{
															#line 461 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_1 = removeCluster(self);
															#line 461 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3460 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when2(__when_expr_1.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 461 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 3465 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 462 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
				if (operation == 2)
															#line 3472 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
				{
															#line 463 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					StrictFuture<Void> __when_expr_2 = listClusters(self);
															#line 463 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3478 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when3(__when_expr_2.get(), loopDepth); };
					static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 463 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 3483 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
															#line 464 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
					if (operation == 3)
															#line 3490 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
					{
															#line 465 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
						StrictFuture<Void> __when_expr_3 = getCluster(self);
															#line 465 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
						if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3496 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
						if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when4(__when_expr_3.get(), loopDepth); };
						static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 465 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
						__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 3501 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
						loopDepth = 0;
					}
					else
					{
															#line 466 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
						if (operation == 4)
															#line 3508 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
						{
															#line 467 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
							StrictFuture<Void> __when_expr_4 = configureCluster(self);
															#line 467 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
							if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3514 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
							if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when5(__when_expr_4.get(), loopDepth); };
							static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 467 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
							__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 3519 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 468 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
							if (operation == 5)
															#line 3526 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
							{
															#line 469 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
								StrictFuture<Void> __when_expr_5 = restoreCluster(self);
															#line 469 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
								if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3532 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
								if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when6(__when_expr_5.get(), loopDepth); };
								static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 469 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
								__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 3537 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
								loopDepth = 0;
							}
							else
							{
								loopDepth = a_body1loopBody1cont12(loopDepth);
							}
						}
					}
				}
			}
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1when3(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont9(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1when4(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont10(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont11(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1when5(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont12(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont10(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when6(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1when6(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 452 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database cx;
															#line 452 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 453 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	double start;
															#line 457 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	int operation;
															#line 4131 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 452 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 4136 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6007148677722675968UL, 17989496564944383488UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
															#line 452 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	_startActor(Database const& cx,MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 4158 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 452 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 452 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 4195 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 475 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

	Future<bool> check(Database const& cx) override {
		if (clientId == 0) {
			return _check(cx, this);
		} else {
			return true;
		}
	}
																#line 4207 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
// This generated class is to be used only via _check()
															#line 483 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
template <class _checkActor>
															#line 483 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class _checkActorState {
															#line 4213 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
															#line 483 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	_checkActorState(Database const& cx,MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 483 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
															#line 483 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		 : cx(cx),
															#line 483 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   self(self),
															#line 485 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		   metaclusterConsistencyCheck(self->simMetacluster.managementDb, metacluster::util::AllowPartialMetaclusterOperations::True)
															#line 4224 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 487 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			StrictFuture<Void> __when_expr_0 = metaclusterConsistencyCheck.run();
															#line 487 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4241 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 487 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 4246 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 489 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 4269 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 489 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(true); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 4281 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(true);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 483 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	Database cx;
															#line 483 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	MetaclusterManagementConcurrencyWorkload* self;
															#line 485 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	metacluster::util::MetaclusterConsistencyCheck<IDatabase> metaclusterConsistencyCheck;
															#line 4370 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
};
// This generated class is to be used only via _check()
															#line 483 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 4375 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11302793516520553728UL, 16331246506367257344UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
															#line 483 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	_checkActor(Database const& cx,MetaclusterManagementConcurrencyWorkload* const& self) 
															#line 4392 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 483 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
[[nodiscard]] static Future<bool> _check( Database const& cx, MetaclusterManagementConcurrencyWorkload* const& self ) {
															#line 483 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 4424 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.g.cpp"
}

#line 491 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/MetaclusterManagementConcurrencyWorkload.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<MetaclusterManagementConcurrencyWorkload> MetaclusterManagementConcurrencyWorkloadFactory;
