#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
/*
 * Inventory.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// SOMEDAY: Make this actually run on multiple clients

struct InventoryTestWorkload : TestWorkload {
	static constexpr auto NAME = "InventoryTest";
	std::map<Key, int> minExpectedResults,
	    maxExpectedResults; // Destroyed last, since it's used in actor cancellation of InventoryTestClient(Actor)

	int actorCount, productsPerWrite, nProducts;
	double testDuration, transactionsPerSecond, fractionWriteTransactions;
	std::vector<Future<Void>> clients;

	PerfIntCounter transactions, retries;
	PerfDoubleCounter totalLatency;

	InventoryTestWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), transactions("Transactions"), retries("Retries"), totalLatency("Latency") {
		actorCount = getOption(options, "actorCount"_sr, 500);
		nProducts = getOption(options, "nProducts"_sr, 100000);
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		transactionsPerSecond = getOption(options, "transactionsPerSecond"_sr, 10000);
		fractionWriteTransactions = getOption(options, "fractionWriteTransactions"_sr, 0.01);
		productsPerWrite = getOption(options, "productsPerWrite"_sr, 2);
	}

	Future<Void> start(Database const& cx) override {
		if (clientId)
			return Void();
		for (int c = 0; c < actorCount; c++)
			clients.push_back(timeout(
			    inventoryTestClient(
			        cx->clone(), this, actorCount / transactionsPerSecond, fractionWriteTransactions, productsPerWrite),
			    testDuration,
			    Void()));
		return waitForAll(clients);
	}

	int failures() const {
		int failures = 0;
		for (int c = 0; c < clients.size(); c++)
			if (clients[c].isReady() && clients[c].isError()) {
				++failures;
			}
		return failures;
	}

	Future<bool> check(Database const& cx) override {
		if (clientId)
			return true;
		return inventoryTestCheck(cx->clone(), this);
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		m.emplace_back("Client Failures", failures(), Averaged::False);
		m.push_back(transactions.getMetric());
		m.push_back(retries.getMetric());
		m.emplace_back("Avg Latency (ms)", 1000 * totalLatency.getValue() / transactions.getValue(), Averaged::True);
		m.emplace_back("Read rows/simsec (approx)",
		               transactions.getValue() *
		                   (2 * fractionWriteTransactions + 1 * (1.0 - fractionWriteTransactions)) / testDuration,
		               Averaged::True);
		m.emplace_back("Write rows/simsec (approx)",
		               transactions.getValue() * 2 * fractionWriteTransactions / testDuration,
		               Averaged::True);
	}

	Key chooseProduct() const {
		int p = deterministicRandom()->randomInt(0, nProducts);
		return doubleToTestKey((double)p / nProducts);
		// std::string s = std::string(1,'a' + (p%26)) + format("%d",p/26);
		/*int c = deterministicRandom()->randomInt(0,10);
		s += ',';
		for(int i=0; i<c; i++)
		    s += format("%d", c);
		s += '.';*/
		// return s;
	}

																#line 105 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
// This generated class is to be used only via inventoryTestCheck()
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
template <class InventoryTestCheckActor>
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
class InventoryTestCheckActorState {
															#line 111 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
public:
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	InventoryTestCheckActorState(Database const& cx,InventoryTestWorkload* const& self) 
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		 : cx(cx),
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		   self(self)
															#line 120 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
	{
		fdb_probe_actor_create("inventoryTestCheck", reinterpret_cast<unsigned long>(this));

	}
	~InventoryTestCheckActorState() 
	{
		fdb_probe_actor_destroy("inventoryTestCheck", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 104 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			if (self->failures())
															#line 135 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			{
															#line 105 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				TraceEvent(SevError, "TestFailure").detail("Reason", "There were client failures.");
															#line 106 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				if (!static_cast<InventoryTestCheckActor*>(this)->SAV<bool>::futures) { (void)(false); this->~InventoryTestCheckActorState(); static_cast<InventoryTestCheckActor*>(this)->destroy(); return 0; }
															#line 141 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
				new (&static_cast<InventoryTestCheckActor*>(this)->SAV< bool >::value()) bool(false);
				this->~InventoryTestCheckActorState();
				static_cast<InventoryTestCheckActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 112 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			self->clients.clear();
															#line 114 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			tr = Transaction(cx);
															#line 115 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			;
															#line 153 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InventoryTestCheckActorState();
		static_cast<InventoryTestCheckActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 117 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange( firstGreaterOrEqual(doubleToTestKey(0)), firstGreaterOrEqual(doubleToTestKey(1)), self->nProducts);
															#line 117 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			if (static_cast<InventoryTestCheckActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 186 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InventoryTestCheckActor*>(this)->actor_wait_state = 1;
															#line 117 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InventoryTestCheckActor, 0, RangeResult >*>(static_cast<InventoryTestCheckActor*>(this)));
															#line 191 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 147 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 147 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			if (static_cast<InventoryTestCheckActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 215 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<InventoryTestCheckActor*>(this)->actor_wait_state = 2;
															#line 147 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InventoryTestCheckActor, 1, Void >*>(static_cast<InventoryTestCheckActor*>(this)));
															#line 220 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& data,int loopDepth) 
	{
															#line 120 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		std::map<Key, int> actualResults;
															#line 121 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		for(int i = 0;i < data.size();i++) {
															#line 122 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			actualResults[data[i].key] = atoi(data[i].value.toString().c_str());
															#line 239 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		}
															#line 123 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		for(auto i = self->minExpectedResults.begin();i != self->minExpectedResults.end();++i) {
															#line 124 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			actualResults[i->first];
															#line 245 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		}
															#line 125 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		bool error = false;
															#line 126 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		for(auto i = actualResults.begin();i != actualResults.end();++i) {
															#line 127 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			if (i->second < self->minExpectedResults[i->first] || i->second > self->maxExpectedResults[i->first])
															#line 253 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			{
															#line 129 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				if (!error)
															#line 257 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
				{
															#line 130 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
					TraceEvent(SevError, "TestFailure").detail("Reason", "Incorrect results.");
															#line 261 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
				}
															#line 131 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				error = true;
															#line 132 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				std::string str;
															#line 133 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				for(int d = 0;d < data.size();d++) {
															#line 134 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
					if (data[d].key == i->first)
															#line 271 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
					{
															#line 135 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
						str = data[d].value.toString();
															#line 275 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
					}
				}
															#line 136 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				TraceEvent(SevError, "IncorrectTestResult") .detail("Key", printable(i->first)) .detail("ActualValue", i->second) .detail("ActualValueString", str) .detail("MinExpected", self->minExpectedResults[i->first]) .detail("MaxExpected", self->maxExpectedResults[i->first]);
															#line 280 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			}
		}
															#line 143 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		if (error)
															#line 285 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		{
															#line 144 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			if (!static_cast<InventoryTestCheckActor*>(this)->SAV<bool>::futures) { (void)(false); this->~InventoryTestCheckActorState(); static_cast<InventoryTestCheckActor*>(this)->destroy(); return 0; }
															#line 289 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			new (&static_cast<InventoryTestCheckActor*>(this)->SAV< bool >::value()) bool(false);
			this->~InventoryTestCheckActorState();
			static_cast<InventoryTestCheckActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 145 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		if (!static_cast<InventoryTestCheckActor*>(this)->SAV<bool>::futures) { (void)(true); this->~InventoryTestCheckActorState(); static_cast<InventoryTestCheckActor*>(this)->destroy(); return 0; }
															#line 297 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		new (&static_cast<InventoryTestCheckActor*>(this)->SAV< bool >::value()) bool(true);
		this->~InventoryTestCheckActorState();
		static_cast<InventoryTestCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && data,int loopDepth) 
	{
															#line 120 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		std::map<Key, int> actualResults;
															#line 121 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		for(int i = 0;i < data.size();i++) {
															#line 122 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			actualResults[data[i].key] = atoi(data[i].value.toString().c_str());
															#line 313 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		}
															#line 123 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		for(auto i = self->minExpectedResults.begin();i != self->minExpectedResults.end();++i) {
															#line 124 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			actualResults[i->first];
															#line 319 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		}
															#line 125 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		bool error = false;
															#line 126 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		for(auto i = actualResults.begin();i != actualResults.end();++i) {
															#line 127 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			if (i->second < self->minExpectedResults[i->first] || i->second > self->maxExpectedResults[i->first])
															#line 327 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			{
															#line 129 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				if (!error)
															#line 331 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
				{
															#line 130 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
					TraceEvent(SevError, "TestFailure").detail("Reason", "Incorrect results.");
															#line 335 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
				}
															#line 131 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				error = true;
															#line 132 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				std::string str;
															#line 133 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				for(int d = 0;d < data.size();d++) {
															#line 134 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
					if (data[d].key == i->first)
															#line 345 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
					{
															#line 135 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
						str = data[d].value.toString();
															#line 349 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
					}
				}
															#line 136 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				TraceEvent(SevError, "IncorrectTestResult") .detail("Key", printable(i->first)) .detail("ActualValue", i->second) .detail("ActualValueString", str) .detail("MinExpected", self->minExpectedResults[i->first]) .detail("MaxExpected", self->maxExpectedResults[i->first]);
															#line 354 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			}
		}
															#line 143 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		if (error)
															#line 359 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		{
															#line 144 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			if (!static_cast<InventoryTestCheckActor*>(this)->SAV<bool>::futures) { (void)(false); this->~InventoryTestCheckActorState(); static_cast<InventoryTestCheckActor*>(this)->destroy(); return 0; }
															#line 363 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			new (&static_cast<InventoryTestCheckActor*>(this)->SAV< bool >::value()) bool(false);
			this->~InventoryTestCheckActorState();
			static_cast<InventoryTestCheckActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 145 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		if (!static_cast<InventoryTestCheckActor*>(this)->SAV<bool>::futures) { (void)(true); this->~InventoryTestCheckActorState(); static_cast<InventoryTestCheckActor*>(this)->destroy(); return 0; }
															#line 371 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		new (&static_cast<InventoryTestCheckActor*>(this)->SAV< bool >::value()) bool(true);
		this->~InventoryTestCheckActorState();
		static_cast<InventoryTestCheckActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& data,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(data, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && data,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(data), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InventoryTestCheckActor*>(this)->actor_wait_state > 0) static_cast<InventoryTestCheckActor*>(this)->actor_wait_state = 0;
		static_cast<InventoryTestCheckActor*>(this)->ActorCallback< InventoryTestCheckActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< InventoryTestCheckActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("inventoryTestCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InventoryTestCheckActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("inventoryTestCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InventoryTestCheckActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("inventoryTestCheck", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestCheck", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<InventoryTestCheckActor*>(this)->actor_wait_state > 0) static_cast<InventoryTestCheckActor*>(this)->actor_wait_state = 0;
		static_cast<InventoryTestCheckActor*>(this)->ActorCallback< InventoryTestCheckActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InventoryTestCheckActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("inventoryTestCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< InventoryTestCheckActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("inventoryTestCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestCheck", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< InventoryTestCheckActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("inventoryTestCheck", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestCheck", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	Database cx;
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	InventoryTestWorkload* self;
															#line 114 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	Transaction tr;
															#line 547 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
};
// This generated class is to be used only via inventoryTestCheck()
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
class InventoryTestCheckActor final : public Actor<bool>, public ActorCallback< InventoryTestCheckActor, 0, RangeResult >, public ActorCallback< InventoryTestCheckActor, 1, Void >, public FastAllocated<InventoryTestCheckActor>, public InventoryTestCheckActorState<InventoryTestCheckActor> {
															#line 552 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
public:
	using FastAllocated<InventoryTestCheckActor>::operator new;
	using FastAllocated<InventoryTestCheckActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13870274509627984384UL, 10277276487739470848UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InventoryTestCheckActor, 0, RangeResult >;
friend struct ActorCallback< InventoryTestCheckActor, 1, Void >;
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	InventoryTestCheckActor(Database const& cx,InventoryTestWorkload* const& self) 
															#line 570 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		 : Actor<bool>(),
		   InventoryTestCheckActorState<InventoryTestCheckActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("inventoryTestCheck", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12037495107732696320UL, 11694776749013380608UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestCheckActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("inventoryTestCheck");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("inventoryTestCheck", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InventoryTestCheckActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< InventoryTestCheckActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
[[nodiscard]] Future<bool> inventoryTestCheck( Database const& cx, InventoryTestWorkload* const& self ) {
															#line 103 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	return Future<bool>(new InventoryTestCheckActor(cx, self));
															#line 603 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
}

#line 151 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"

																#line 608 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
// This generated class is to be used only via inventoryTestWrite()
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
template <class InventoryTestWriteActor>
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
class InventoryTestWriteActorState {
															#line 614 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
public:
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	InventoryTestWriteActorState(Transaction* const& tr,Key const& key) 
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		 : tr(tr),
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		   key(key)
															#line 623 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
	{
		fdb_probe_actor_create("inventoryTestWrite", reinterpret_cast<unsigned long>(this));

	}
	~InventoryTestWriteActorState() 
	{
		fdb_probe_actor_destroy("inventoryTestWrite", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 153 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(key);
															#line 153 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			if (static_cast<InventoryTestWriteActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 640 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InventoryTestWriteActor*>(this)->actor_wait_state = 1;
															#line 153 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InventoryTestWriteActor, 0, Optional<Value> >*>(static_cast<InventoryTestWriteActor*>(this)));
															#line 645 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InventoryTestWriteActorState();
		static_cast<InventoryTestWriteActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& val,int loopDepth) 
	{
															#line 154 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		int count = !val.present() ? 0 : atoi(val.get().toString().c_str());
															#line 155 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		ASSERT(count >= 0 && count < 1000000);
															#line 156 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		tr->set(key, format("%d", count + 1));
															#line 157 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		if (!static_cast<InventoryTestWriteActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InventoryTestWriteActorState(); static_cast<InventoryTestWriteActor*>(this)->destroy(); return 0; }
															#line 674 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		new (&static_cast<InventoryTestWriteActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InventoryTestWriteActorState();
		static_cast<InventoryTestWriteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && val,int loopDepth) 
	{
															#line 154 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		int count = !val.present() ? 0 : atoi(val.get().toString().c_str());
															#line 155 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		ASSERT(count >= 0 && count < 1000000);
															#line 156 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		tr->set(key, format("%d", count + 1));
															#line 157 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		if (!static_cast<InventoryTestWriteActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InventoryTestWriteActorState(); static_cast<InventoryTestWriteActor*>(this)->destroy(); return 0; }
															#line 692 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		new (&static_cast<InventoryTestWriteActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InventoryTestWriteActorState();
		static_cast<InventoryTestWriteActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1cont1(val, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InventoryTestWriteActor*>(this)->actor_wait_state > 0) static_cast<InventoryTestWriteActor*>(this)->actor_wait_state = 0;
		static_cast<InventoryTestWriteActor*>(this)->ActorCallback< InventoryTestWriteActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< InventoryTestWriteActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("inventoryTestWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InventoryTestWriteActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("inventoryTestWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestWrite", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InventoryTestWriteActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("inventoryTestWrite", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestWrite", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	Transaction* tr;
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	Key key;
															#line 779 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
};
// This generated class is to be used only via inventoryTestWrite()
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
class InventoryTestWriteActor final : public Actor<Void>, public ActorCallback< InventoryTestWriteActor, 0, Optional<Value> >, public FastAllocated<InventoryTestWriteActor>, public InventoryTestWriteActorState<InventoryTestWriteActor> {
															#line 784 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
public:
	using FastAllocated<InventoryTestWriteActor>::operator new;
	using FastAllocated<InventoryTestWriteActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16279581021661436160UL, 6557461639568373248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InventoryTestWriteActor, 0, Optional<Value> >;
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	InventoryTestWriteActor(Transaction* const& tr,Key const& key) 
															#line 801 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		 : Actor<Void>(),
		   InventoryTestWriteActorState<InventoryTestWriteActor>(tr, key),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("inventoryTestWrite", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14460522225282840576UL, 4511122973514995200UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestWriteActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("inventoryTestWrite");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("inventoryTestWrite", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InventoryTestWriteActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
[[nodiscard]] Future<Void> inventoryTestWrite( Transaction* const& tr, Key const& key ) {
															#line 152 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	return Future<Void>(new InventoryTestWriteActor(tr, key));
															#line 833 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
}

#line 159 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"

																#line 838 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
// This generated class is to be used only via inventoryTestClient()
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
template <class InventoryTestClientActor>
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
class InventoryTestClientActorState {
															#line 844 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
public:
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	InventoryTestClientActorState(Database const& cx,InventoryTestWorkload* const& self,double const& transactionDelay,double const& fractionWriteTransactions,int const& productsPerWrite) 
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		 : cx(cx),
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		   self(self),
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		   transactionDelay(transactionDelay),
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		   fractionWriteTransactions(fractionWriteTransactions),
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		   productsPerWrite(productsPerWrite),
															#line 165 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		   lastTime(now())
															#line 861 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
	{
		fdb_probe_actor_create("inventoryTestClient", reinterpret_cast<unsigned long>(this));

	}
	~InventoryTestClientActorState() 
	{
		fdb_probe_actor_destroy("inventoryTestClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 166 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			;
															#line 876 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InventoryTestClientActorState();
		static_cast<InventoryTestClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 167 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		StrictFuture<Void> __when_expr_0 = poisson(&lastTime, transactionDelay);
															#line 167 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		if (static_cast<InventoryTestClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 908 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<InventoryTestClientActor*>(this)->actor_wait_state = 1;
															#line 167 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InventoryTestClientActor, 0, Void >*>(static_cast<InventoryTestClientActor*>(this)));
															#line 913 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 168 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		st = now();
															#line 169 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		tr = Transaction(cx);
															#line 170 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		if (deterministicRandom()->random01() < fractionWriteTransactions)
															#line 926 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		{
															#line 171 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			products = std::set<Key>();
															#line 172 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			for(int i = 0;i < productsPerWrite;i++) {
															#line 173 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				products.insert(self->chooseProduct());
															#line 934 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			}
															#line 174 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			for(auto p = products.begin();p != products.end();++p) {
															#line 175 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				self->maxExpectedResults[*p]++;
															#line 940 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			}
															#line 176 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			;
															#line 944 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
															#line 201 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			;
															#line 951 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1loopHead2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 168 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		st = now();
															#line 169 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		tr = Transaction(cx);
															#line 170 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		if (deterministicRandom()->random01() < fractionWriteTransactions)
															#line 965 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		{
															#line 171 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			products = std::set<Key>();
															#line 172 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			for(int i = 0;i < productsPerWrite;i++) {
															#line 173 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				products.insert(self->chooseProduct());
															#line 973 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			}
															#line 174 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			for(auto p = products.begin();p != products.end();++p) {
															#line 175 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				self->maxExpectedResults[*p]++;
															#line 979 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			}
															#line 176 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			;
															#line 983 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);
		}
		else
		{
															#line 201 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			;
															#line 990 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			loopDepth = a_body1loopBody1cont1loopHead2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InventoryTestClientActor*>(this)->actor_wait_state > 0) static_cast<InventoryTestClientActor*>(this)->actor_wait_state = 0;
		static_cast<InventoryTestClientActor*>(this)->ActorCallback< InventoryTestClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InventoryTestClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InventoryTestClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InventoryTestClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 210 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		self->totalLatency += now() - st;
															#line 211 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		++self->transactions;
															#line 1077 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 198 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		for(auto p = products.begin();p != products.end();++p) {
															#line 199 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			self->minExpectedResults[*p]++;
															#line 1088 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		}
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 177 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		std::vector<Future<Void>> todo;
															#line 178 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		for(auto p = products.begin();p != products.end();++p) {
															#line 179 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			todo.push_back(self->inventoryTestWrite(&tr, *p));
															#line 1109 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		}
		try {
			try {
															#line 182 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				StrictFuture<Void> __when_expr_1 = waitForAll(todo);
															#line 182 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				if (static_cast<InventoryTestClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch2(actor_cancelled(), loopDepth);
															#line 1117 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
				static_cast<InventoryTestClientActor*>(this)->actor_wait_state = 2;
															#line 182 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InventoryTestClientActor, 1, Void >*>(static_cast<InventoryTestClientActor*>(this)));
															#line 1122 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1cont1loopBody1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1cont1loopBody1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
															#line 194 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		++self->retries;
															#line 195 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		for(auto p = products.begin();p != products.end();++p) {
															#line 196 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			self->maxExpectedResults[*p]++;
															#line 1160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 192 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 192 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			if (static_cast<InventoryTestClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1173 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<InventoryTestClientActor*>(this)->actor_wait_state = 4;
															#line 192 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< InventoryTestClientActor, 3, Void >*>(static_cast<InventoryTestClientActor*>(this)));
															#line 1178 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(int loopDepth) 
	{
															#line 189 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 189 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		if (static_cast<InventoryTestClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1195 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<InventoryTestClientActor*>(this)->actor_wait_state = 3;
															#line 189 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< InventoryTestClientActor, 2, Void >*>(static_cast<InventoryTestClientActor*>(this)));
															#line 1200 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 184 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 1210 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			{
															#line 185 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
				for(auto p = products.begin();p != products.end();++p) {
															#line 186 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
					self->maxExpectedResults[*p]--;
															#line 1216 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
				}
			}
															#line 187 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			return a_body1loopBody1cont1loopBody1Catch1(e, loopDepth);
															#line 1221 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<InventoryTestClientActor*>(this)->actor_wait_state > 0) static_cast<InventoryTestClientActor*>(this)->actor_wait_state = 0;
		static_cast<InventoryTestClientActor*>(this)->ActorCallback< InventoryTestClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InventoryTestClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< InventoryTestClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< InventoryTestClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch2(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<InventoryTestClientActor*>(this)->actor_wait_state > 0) static_cast<InventoryTestClientActor*>(this)->actor_wait_state = 0;
		static_cast<InventoryTestClientActor*>(this)->ActorCallback< InventoryTestClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InventoryTestClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< InventoryTestClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< InventoryTestClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<InventoryTestClientActor*>(this)->actor_wait_state > 0) static_cast<InventoryTestClientActor*>(this)->actor_wait_state = 0;
		static_cast<InventoryTestClientActor*>(this)->ActorCallback< InventoryTestClientActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InventoryTestClientActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< InventoryTestClientActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< InventoryTestClientActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead2(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody2(int loopDepth) 
	{
		try {
															#line 203 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_4 = tr.get(self->chooseProduct());
															#line 203 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			if (static_cast<InventoryTestClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody2Catch1(actor_cancelled(), loopDepth);
															#line 1525 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1loopBody1cont1loopBody2Catch1(__when_expr_4.getError(), loopDepth); else return a_body1loopBody1cont1loopBody2when1(__when_expr_4.get(), loopDepth); };
			static_cast<InventoryTestClientActor*>(this)->actor_wait_state = 5;
															#line 203 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< InventoryTestClientActor, 4, Optional<Value> >*>(static_cast<InventoryTestClientActor*>(this)));
															#line 1530 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody2Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody2Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break2(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont8(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody2cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead2(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody2Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 206 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			StrictFuture<Void> __when_expr_5 = tr.onError(e);
															#line 206 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			if (static_cast<InventoryTestClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1567 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody2Catch1when1(__when_expr_5.get(), loopDepth); };
			static_cast<InventoryTestClientActor*>(this)->actor_wait_state = 6;
															#line 206 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< InventoryTestClientActor, 5, Void >*>(static_cast<InventoryTestClientActor*>(this)));
															#line 1572 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody2cont2(Optional<Value> const& val,int loopDepth) 
	{
		return a_body1loopBody1cont1break2(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody2cont2(Optional<Value> && val,int loopDepth) 
	{
		return a_body1loopBody1cont1break2(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody2when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody2cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody2when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody2cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<InventoryTestClientActor*>(this)->actor_wait_state > 0) static_cast<InventoryTestClientActor*>(this)->actor_wait_state = 0;
		static_cast<InventoryTestClientActor*>(this)->ActorCallback< InventoryTestClientActor, 4, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< InventoryTestClientActor, 4, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< InventoryTestClientActor, 4, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< InventoryTestClientActor, 4, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody2Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody2Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody2Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont1loopBody2Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody2Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody2cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody2Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody2Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody2Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody2Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<InventoryTestClientActor*>(this)->actor_wait_state > 0) static_cast<InventoryTestClientActor*>(this)->actor_wait_state = 0;
		static_cast<InventoryTestClientActor*>(this)->ActorCallback< InventoryTestClientActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InventoryTestClientActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody2Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< InventoryTestClientActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont1loopBody2Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< InventoryTestClientActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	Database cx;
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	InventoryTestWorkload* self;
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	double transactionDelay;
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	double fractionWriteTransactions;
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	int productsPerWrite;
															#line 165 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	double lastTime;
															#line 168 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	double st;
															#line 169 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	Transaction tr;
															#line 171 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	std::set<Key> products;
															#line 1775 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
};
// This generated class is to be used only via inventoryTestClient()
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
class InventoryTestClientActor final : public Actor<Void>, public ActorCallback< InventoryTestClientActor, 0, Void >, public ActorCallback< InventoryTestClientActor, 1, Void >, public ActorCallback< InventoryTestClientActor, 2, Void >, public ActorCallback< InventoryTestClientActor, 3, Void >, public ActorCallback< InventoryTestClientActor, 4, Optional<Value> >, public ActorCallback< InventoryTestClientActor, 5, Void >, public FastAllocated<InventoryTestClientActor>, public InventoryTestClientActorState<InventoryTestClientActor> {
															#line 1780 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
public:
	using FastAllocated<InventoryTestClientActor>::operator new;
	using FastAllocated<InventoryTestClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(483768670526168576UL, 15982229618812834560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InventoryTestClientActor, 0, Void >;
friend struct ActorCallback< InventoryTestClientActor, 1, Void >;
friend struct ActorCallback< InventoryTestClientActor, 2, Void >;
friend struct ActorCallback< InventoryTestClientActor, 3, Void >;
friend struct ActorCallback< InventoryTestClientActor, 4, Optional<Value> >;
friend struct ActorCallback< InventoryTestClientActor, 5, Void >;
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	InventoryTestClientActor(Database const& cx,InventoryTestWorkload* const& self,double const& transactionDelay,double const& fractionWriteTransactions,int const& productsPerWrite) 
															#line 1802 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
		 : Actor<Void>(),
		   InventoryTestClientActorState<InventoryTestClientActor>(cx, self, transactionDelay, fractionWriteTransactions, productsPerWrite),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("inventoryTestClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12733973992382359552UL, 15565095983859191040UL);
		ActorExecutionContextHelper __helper(static_cast<InventoryTestClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("inventoryTestClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("inventoryTestClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InventoryTestClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< InventoryTestClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< InventoryTestClientActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< InventoryTestClientActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< InventoryTestClientActor, 4, Optional<Value> >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< InventoryTestClientActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
[[nodiscard]] Future<Void> inventoryTestClient( Database const& cx, InventoryTestWorkload* const& self, double const& transactionDelay, double const& fractionWriteTransactions, int const& productsPerWrite ) {
															#line 160 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
	return Future<Void>(new InventoryTestClientActor(cx, self, transactionDelay, fractionWriteTransactions, productsPerWrite));
															#line 1839 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/Inventory.actor.g.cpp"
}

#line 214 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/Inventory.actor.cpp"
};

WorkloadFactory<InventoryTestWorkload> InventoryTestWorkloadFactory;
