#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
/*
 * DummyWorkload.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// The workload that do nothing. It can be used for waiting for quiescence
struct DummyWorkload : TestWorkload {
	static constexpr auto NAME = "DummyWorkload";
	bool displayWorkers;
	double displayDelay;

	DummyWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		displayWorkers = getOption(options, "displayWorkers"_sr, true);
		displayDelay = getOption(options, "displayDelay"_sr, 0.0);
	}

	Future<Void> start(Database const& cx) override {
		if ((clientId == 0) && (displayWorkers)) {
			return _start(this, cx);
		}
		return Void();
	}

																#line 44 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DummyWorkload.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
template <class _startActor>
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
class _startActorState {
															#line 50 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DummyWorkload.actor.g.cpp"
public:
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
	_startActorState(DummyWorkload* const& self,Database const& cx) 
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
		 : self(self),
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
		   cx(cx)
															#line 59 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DummyWorkload.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
			if (self->displayDelay > 0.0)
															#line 74 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DummyWorkload.actor.g.cpp"
			{
															#line 44 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
				StrictFuture<Void> __when_expr_0 = delay(self->displayDelay);
															#line 44 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
				if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 80 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DummyWorkload.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 44 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 85 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DummyWorkload.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 45 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
		g_simulator->displayWorkers();
															#line 46 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 115 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DummyWorkload.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
	DummyWorkload* self;
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
	Database cx;
															#line 214 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DummyWorkload.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 219 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DummyWorkload.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9514384665411318016UL, 12671734744922870784UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
	_startActor(DummyWorkload* const& self,Database const& cx) 
															#line 236 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DummyWorkload.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
[[nodiscard]] static Future<Void> _start( DummyWorkload* const& self, Database const& cx ) {
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"
	return Future<Void>(new _startActor(self, cx));
															#line 268 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/DummyWorkload.actor.g.cpp"
}

#line 48 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/workloads/DummyWorkload.actor.cpp"

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<DummyWorkload> DummyWorkloadFactory;
