#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
/*
 * TSSMappingUtil.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/SystemData.h"
#include "fdbclient/KeyBackedTypes.actor.h"
#include "fdbserver/TSSMappingUtil.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

															#line 28 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via readTSSMappingRYW()
															#line 26 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
template <class ReadTSSMappingRYWActor>
															#line 26 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
class ReadTSSMappingRYWActorState {
															#line 35 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
public:
															#line 26 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	ReadTSSMappingRYWActorState(Reference<ReadYourWritesTransaction> const& tr,std::map<UID, StorageServerInterface>* const& tssMapping) 
															#line 26 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
															#line 26 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		 : tr(tr),
															#line 26 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		   tssMapping(tssMapping)
															#line 44 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("readTSSMappingRYW", reinterpret_cast<unsigned long>(this));

	}
	~ReadTSSMappingRYWActorState() 
	{
		fdb_probe_actor_destroy("readTSSMappingRYW", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 28 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			KeyBackedMap<UID, UID> tssMapDB = KeyBackedMap<UID, UID>(tssMappingKeys.begin);
															#line 29 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			StrictFuture<KeyBackedMap<UID, UID>::RangeResultType> __when_expr_0 = tssMapDB.getRange(tr, UID(), Optional<UID>(), CLIENT_KNOBS->TOO_MANY);
															#line 29 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			if (static_cast<ReadTSSMappingRYWActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 63 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadTSSMappingRYWActor*>(this)->actor_wait_state = 1;
															#line 29 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadTSSMappingRYWActor, 0, KeyBackedMap<UID, UID>::RangeResultType >*>(static_cast<ReadTSSMappingRYWActor*>(this)));
															#line 68 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadTSSMappingRYWActorState();
		static_cast<ReadTSSMappingRYWActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 31 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		ASSERT(uidMapping.results.size() < CLIENT_KNOBS->TOO_MANY);
															#line 33 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		mapping = std::map<UID, StorageServerInterface>();
															#line 34 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		mapItr = std::vector<std::pair<UID, UID>>::iterator();
															#line 35 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		mapItr = uidMapping.results.begin();
															#line 97 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedMap<UID, UID>::RangeResultType const& __uidMapping,int loopDepth) 
	{
															#line 29 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		uidMapping = __uidMapping;
															#line 106 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyBackedMap<UID, UID>::RangeResultType && __uidMapping,int loopDepth) 
	{
		uidMapping = std::move(__uidMapping);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadTSSMappingRYWActor*>(this)->actor_wait_state > 0) static_cast<ReadTSSMappingRYWActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTSSMappingRYWActor*>(this)->ActorCallback< ReadTSSMappingRYWActor, 0, KeyBackedMap<UID, UID>::RangeResultType >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTSSMappingRYWActor, 0, KeyBackedMap<UID, UID>::RangeResultType >*,KeyBackedMap<UID, UID>::RangeResultType const& value) 
	{
		fdb_probe_actor_enter("readTSSMappingRYW", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTSSMappingRYWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTSSMappingRYW", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadTSSMappingRYWActor, 0, KeyBackedMap<UID, UID>::RangeResultType >*,KeyBackedMap<UID, UID>::RangeResultType && value) 
	{
		fdb_probe_actor_enter("readTSSMappingRYW", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTSSMappingRYWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTSSMappingRYW", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadTSSMappingRYWActor, 0, KeyBackedMap<UID, UID>::RangeResultType >*,Error err) 
	{
		fdb_probe_actor_enter("readTSSMappingRYW", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTSSMappingRYWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTSSMappingRYW", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 40 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		if (!static_cast<ReadTSSMappingRYWActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadTSSMappingRYWActorState(); static_cast<ReadTSSMappingRYWActor*>(this)->destroy(); return 0; }
															#line 185 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		new (&static_cast<ReadTSSMappingRYWActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadTSSMappingRYWActorState();
		static_cast<ReadTSSMappingRYWActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 35 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		if (!(mapItr != uidMapping.results.end()))
															#line 204 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 36 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		ssId = mapItr->first;
															#line 37 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr->get(serverListKeyFor(mapItr->second));
															#line 37 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		if (static_cast<ReadTSSMappingRYWActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 214 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadTSSMappingRYWActor*>(this)->actor_wait_state = 2;
															#line 37 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadTSSMappingRYWActor, 1, Optional<Value> >*>(static_cast<ReadTSSMappingRYWActor*>(this)));
															#line 219 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Optional<Value> const& v,int loopDepth) 
	{
															#line 38 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		(*tssMapping)[ssId] = decodeServerListValue(v.get());
															#line 35 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		++mapItr;
															#line 243 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Optional<Value> && v,int loopDepth) 
	{
															#line 38 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		(*tssMapping)[ssId] = decodeServerListValue(v.get());
															#line 35 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		++mapItr;
															#line 254 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(v, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadTSSMappingRYWActor*>(this)->actor_wait_state > 0) static_cast<ReadTSSMappingRYWActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTSSMappingRYWActor*>(this)->ActorCallback< ReadTSSMappingRYWActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTSSMappingRYWActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("readTSSMappingRYW", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTSSMappingRYWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTSSMappingRYW", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadTSSMappingRYWActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("readTSSMappingRYW", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTSSMappingRYWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTSSMappingRYW", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadTSSMappingRYWActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("readTSSMappingRYW", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTSSMappingRYWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTSSMappingRYW", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 26 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 26 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	std::map<UID, StorageServerInterface>* tssMapping;
															#line 29 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	KeyBackedMap<UID, UID>::RangeResultType uidMapping;
															#line 33 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	std::map<UID, StorageServerInterface> mapping;
															#line 34 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	std::vector<std::pair<UID, UID>>::iterator mapItr;
															#line 36 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	UID ssId;
															#line 346 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
};
// This generated class is to be used only via readTSSMappingRYW()
															#line 26 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
class ReadTSSMappingRYWActor final : public Actor<Void>, public ActorCallback< ReadTSSMappingRYWActor, 0, KeyBackedMap<UID, UID>::RangeResultType >, public ActorCallback< ReadTSSMappingRYWActor, 1, Optional<Value> >, public FastAllocated<ReadTSSMappingRYWActor>, public ReadTSSMappingRYWActorState<ReadTSSMappingRYWActor> {
															#line 351 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
public:
	using FastAllocated<ReadTSSMappingRYWActor>::operator new;
	using FastAllocated<ReadTSSMappingRYWActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3291496835796735744UL, 2059590066227422720UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadTSSMappingRYWActor, 0, KeyBackedMap<UID, UID>::RangeResultType >;
friend struct ActorCallback< ReadTSSMappingRYWActor, 1, Optional<Value> >;
															#line 26 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	ReadTSSMappingRYWActor(Reference<ReadYourWritesTransaction> const& tr,std::map<UID, StorageServerInterface>* const& tssMapping) 
															#line 369 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		 : Actor<Void>(),
		   ReadTSSMappingRYWActorState<ReadTSSMappingRYWActor>(tr, tssMapping),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readTSSMappingRYW", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8885762407101084416UL, 17998911128795282176UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTSSMappingRYWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readTSSMappingRYW");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readTSSMappingRYW", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadTSSMappingRYWActor, 0, KeyBackedMap<UID, UID>::RangeResultType >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadTSSMappingRYWActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 26 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
[[nodiscard]] Future<Void> readTSSMappingRYW( Reference<ReadYourWritesTransaction> const& tr, std::map<UID, StorageServerInterface>* const& tssMapping ) {
															#line 26 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	return Future<Void>(new ReadTSSMappingRYWActor(tr, tssMapping));
															#line 403 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
}

#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"

															#line 408 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via readTSSMapping()
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
template <class ReadTSSMappingActor>
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
class ReadTSSMappingActorState {
															#line 415 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
public:
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	ReadTSSMappingActorState(Transaction* const& tr,std::map<UID, StorageServerInterface>* const& tssMapping) 
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		 : tr(tr),
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		   tssMapping(tssMapping)
															#line 424 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("readTSSMapping", reinterpret_cast<unsigned long>(this));

	}
	~ReadTSSMappingActorState() 
	{
		fdb_probe_actor_destroy("readTSSMapping", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 44 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr->getRange(tssMappingKeys, CLIENT_KNOBS->TOO_MANY);
															#line 44 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			if (static_cast<ReadTSSMappingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 441 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadTSSMappingActor*>(this)->actor_wait_state = 1;
															#line 44 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadTSSMappingActor, 0, RangeResult >*>(static_cast<ReadTSSMappingActor*>(this)));
															#line 446 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadTSSMappingActorState();
		static_cast<ReadTSSMappingActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 45 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		ASSERT(!mappingList.more && mappingList.size() < CLIENT_KNOBS->TOO_MANY);
															#line 47 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		RangeForbody1cont1Iterator0 = std::begin(mappingList);
															#line 471 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult const& __mappingList,int loopDepth) 
	{
															#line 44 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		mappingList = __mappingList;
															#line 480 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(RangeResult && __mappingList,int loopDepth) 
	{
		mappingList = std::move(__mappingList);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadTSSMappingActor*>(this)->actor_wait_state > 0) static_cast<ReadTSSMappingActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTSSMappingActor*>(this)->ActorCallback< ReadTSSMappingActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTSSMappingActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("readTSSMapping", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTSSMappingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTSSMapping", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadTSSMappingActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("readTSSMapping", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTSSMappingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTSSMapping", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadTSSMappingActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("readTSSMapping", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTSSMappingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTSSMapping", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 53 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		if (!static_cast<ReadTSSMappingActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReadTSSMappingActorState(); static_cast<ReadTSSMappingActor*>(this)->destroy(); return 0; }
															#line 559 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		new (&static_cast<ReadTSSMappingActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReadTSSMappingActorState();
		static_cast<ReadTSSMappingActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 47 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		if (!(RangeForbody1cont1Iterator0 != std::end(mappingList)))
															#line 578 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 47 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		auto& it = *RangeForbody1cont1Iterator0;
															#line 584 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		{
															#line 48 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			ssId = TupleCodec<UID>::unpack(it.key.removePrefix(tssMappingKeys.begin));
															#line 49 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			UID tssId = TupleCodec<UID>::unpack(it.value);
															#line 50 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(serverListKeyFor(tssId));
															#line 50 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			if (static_cast<ReadTSSMappingActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 594 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ReadTSSMappingActor*>(this)->actor_wait_state = 2;
															#line 50 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadTSSMappingActor, 1, Optional<Value> >*>(static_cast<ReadTSSMappingActor*>(this)));
															#line 599 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 47 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		++RangeForbody1cont1Iterator0;
															#line 622 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Optional<Value> const& v,int loopDepth) 
	{
															#line 51 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		(*tssMapping)[ssId] = decodeServerListValue(v.get());
															#line 631 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Optional<Value> && v,int loopDepth) 
	{
															#line 51 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		(*tssMapping)[ssId] = decodeServerListValue(v.get());
															#line 640 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> const& v,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(v, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Optional<Value> && v,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(v), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadTSSMappingActor*>(this)->actor_wait_state > 0) static_cast<ReadTSSMappingActor*>(this)->actor_wait_state = 0;
		static_cast<ReadTSSMappingActor*>(this)->ActorCallback< ReadTSSMappingActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadTSSMappingActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("readTSSMapping", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTSSMappingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTSSMapping", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadTSSMappingActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("readTSSMapping", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTSSMappingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTSSMapping", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadTSSMappingActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("readTSSMapping", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTSSMappingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readTSSMapping", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	Transaction* tr;
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	std::map<UID, StorageServerInterface>* tssMapping;
															#line 44 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	RangeResult mappingList;
															#line 47 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	decltype(std::begin(std::declval<RangeResult>())) RangeForbody1cont1Iterator0;
															#line 48 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	UID ssId;
															#line 730 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
};
// This generated class is to be used only via readTSSMapping()
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
class ReadTSSMappingActor final : public Actor<Void>, public ActorCallback< ReadTSSMappingActor, 0, RangeResult >, public ActorCallback< ReadTSSMappingActor, 1, Optional<Value> >, public FastAllocated<ReadTSSMappingActor>, public ReadTSSMappingActorState<ReadTSSMappingActor> {
															#line 735 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
public:
	using FastAllocated<ReadTSSMappingActor>::operator new;
	using FastAllocated<ReadTSSMappingActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5792252565860582656UL, 1059682533199908352UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadTSSMappingActor, 0, RangeResult >;
friend struct ActorCallback< ReadTSSMappingActor, 1, Optional<Value> >;
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	ReadTSSMappingActor(Transaction* const& tr,std::map<UID, StorageServerInterface>* const& tssMapping) 
															#line 753 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		 : Actor<Void>(),
		   ReadTSSMappingActorState<ReadTSSMappingActor>(tr, tssMapping),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readTSSMapping", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2241672198424992256UL, 14139293400169091840UL);
		ActorExecutionContextHelper __helper(static_cast<ReadTSSMappingActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readTSSMapping");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readTSSMapping", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadTSSMappingActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadTSSMappingActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
[[nodiscard]] Future<Void> readTSSMapping( Transaction* const& tr, std::map<UID, StorageServerInterface>* const& tssMapping ) {
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	return Future<Void>(new ReadTSSMappingActor(tr, tssMapping));
															#line 787 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
}

#line 55 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"

															#line 792 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
namespace {
// This generated class is to be used only via removeTSSPairsFromCluster()
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
template <class RemoveTSSPairsFromClusterActor>
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
class RemoveTSSPairsFromClusterActorState {
															#line 799 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
public:
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	RemoveTSSPairsFromClusterActorState(Database const& cx,std::vector<std::pair<UID, UID>> const& pairsToRemove) 
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		 : cx(cx),
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		   pairsToRemove(pairsToRemove),
															#line 57 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		   tr(makeReference<ReadYourWritesTransaction>(cx)),
															#line 58 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		   tssMapDB(KeyBackedMap<UID, UID>(tssMappingKeys.begin))
															#line 812 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
	{
		fdb_probe_actor_create("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this));

	}
	~RemoveTSSPairsFromClusterActorState() 
	{
		fdb_probe_actor_destroy("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 59 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			;
															#line 827 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RemoveTSSPairsFromClusterActorState();
		static_cast<RemoveTSSPairsFromClusterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 75 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
		if (!static_cast<RemoveTSSPairsFromClusterActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RemoveTSSPairsFromClusterActorState(); static_cast<RemoveTSSPairsFromClusterActor*>(this)->destroy(); return 0; }
															#line 850 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		new (&static_cast<RemoveTSSPairsFromClusterActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RemoveTSSPairsFromClusterActorState();
		static_cast<RemoveTSSPairsFromClusterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 61 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			tr->setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 62 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 63 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			for( auto& tssPair : pairsToRemove ) {
															#line 66 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
				tr->clear(serverTagKeyFor(tssPair.second));
															#line 67 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
				tssMapDB.erase(tr, tssPair.first);
															#line 878 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
			}
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr->commit();
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			if (static_cast<RemoveTSSPairsFromClusterActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 884 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RemoveTSSPairsFromClusterActor*>(this)->actor_wait_state = 1;
															#line 69 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RemoveTSSPairsFromClusterActor, 0, Void >*>(static_cast<RemoveTSSPairsFromClusterActor*>(this)));
															#line 889 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 72 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr->onError(e);
															#line 72 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			if (static_cast<RemoveTSSPairsFromClusterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 926 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<RemoveTSSPairsFromClusterActor*>(this)->actor_wait_state = 2;
															#line 72 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< RemoveTSSPairsFromClusterActor, 1, Void >*>(static_cast<RemoveTSSPairsFromClusterActor*>(this)));
															#line 931 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RemoveTSSPairsFromClusterActor*>(this)->actor_wait_state > 0) static_cast<RemoveTSSPairsFromClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveTSSPairsFromClusterActor*>(this)->ActorCallback< RemoveTSSPairsFromClusterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveTSSPairsFromClusterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveTSSPairsFromClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RemoveTSSPairsFromClusterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveTSSPairsFromClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RemoveTSSPairsFromClusterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveTSSPairsFromClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<RemoveTSSPairsFromClusterActor*>(this)->actor_wait_state > 0) static_cast<RemoveTSSPairsFromClusterActor*>(this)->actor_wait_state = 0;
		static_cast<RemoveTSSPairsFromClusterActor*>(this)->ActorCallback< RemoveTSSPairsFromClusterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RemoveTSSPairsFromClusterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveTSSPairsFromClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< RemoveTSSPairsFromClusterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveTSSPairsFromClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< RemoveTSSPairsFromClusterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveTSSPairsFromClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	Database cx;
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	std::vector<std::pair<UID, UID>> pairsToRemove;
															#line 57 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 58 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	KeyBackedMap<UID, UID> tssMapDB;
															#line 1124 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
};
// This generated class is to be used only via removeTSSPairsFromCluster()
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
class RemoveTSSPairsFromClusterActor final : public Actor<Void>, public ActorCallback< RemoveTSSPairsFromClusterActor, 0, Void >, public ActorCallback< RemoveTSSPairsFromClusterActor, 1, Void >, public FastAllocated<RemoveTSSPairsFromClusterActor>, public RemoveTSSPairsFromClusterActorState<RemoveTSSPairsFromClusterActor> {
															#line 1129 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
public:
	using FastAllocated<RemoveTSSPairsFromClusterActor>::operator new;
	using FastAllocated<RemoveTSSPairsFromClusterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15355958450139244544UL, 14206479829040022528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RemoveTSSPairsFromClusterActor, 0, Void >;
friend struct ActorCallback< RemoveTSSPairsFromClusterActor, 1, Void >;
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	RemoveTSSPairsFromClusterActor(Database const& cx,std::vector<std::pair<UID, UID>> const& pairsToRemove) 
															#line 1147 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
		 : Actor<Void>(),
		   RemoveTSSPairsFromClusterActorState<RemoveTSSPairsFromClusterActor>(cx, pairsToRemove),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1312248610919352320UL, 16241755392619639808UL);
		ActorExecutionContextHelper __helper(static_cast<RemoveTSSPairsFromClusterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("removeTSSPairsFromCluster");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("removeTSSPairsFromCluster", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RemoveTSSPairsFromClusterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< RemoveTSSPairsFromClusterActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
[[nodiscard]] Future<Void> removeTSSPairsFromCluster( Database const& cx, std::vector<std::pair<UID, UID>> const& pairsToRemove ) {
															#line 56 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
	return Future<Void>(new RemoveTSSPairsFromClusterActor(cx, pairsToRemove));
															#line 1181 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/fdbserver/TSSMappingUtil.actor.g.cpp"
}

#line 77 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/fdbserver/TSSMappingUtil.actor.cpp"
