#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
/*
 * Node.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "DirectoryLayer.h"

namespace FDB {
DirectoryLayer::Node::Node(Reference<DirectoryLayer> const& directoryLayer,
                           Optional<Subspace> const& subspace,
                           IDirectory::Path const& path,
                           IDirectory::Path const& targetPath)
  : directoryLayer(directoryLayer), subspace(subspace), path(path), targetPath(targetPath), loadedMetadata(false) {}

bool DirectoryLayer::Node::exists() const {
	return subspace.present();
}

															#line 36 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/bindings/flow/Node.actor.g.cpp"
// This generated class is to be used only via loadMetadata()
															#line 34 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
template <class LoadMetadataActor>
															#line 34 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
class LoadMetadataActorState {
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/bindings/flow/Node.actor.g.cpp"
public:
															#line 34 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
	LoadMetadataActorState(DirectoryLayer::Node* const& n,Reference<Transaction> const& tr) 
															#line 34 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
															#line 34 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
		 : n(n),
															#line 34 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
		   tr(tr)
															#line 51 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/bindings/flow/Node.actor.g.cpp"
	{
		fdb_probe_actor_create("loadMetadata", reinterpret_cast<unsigned long>(this));

	}
	~LoadMetadataActorState() 
	{
		fdb_probe_actor_destroy("loadMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 35 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
			if (!n->exists())
															#line 66 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/bindings/flow/Node.actor.g.cpp"
			{
															#line 36 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
				n->loadedMetadata = true;
															#line 37 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
				if (!static_cast<LoadMetadataActor*>(this)->SAV<DirectoryLayer::Node>::futures) { (void)(*n); this->~LoadMetadataActorState(); static_cast<LoadMetadataActor*>(this)->destroy(); return 0; }
															#line 72 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/bindings/flow/Node.actor.g.cpp"
				new (&static_cast<LoadMetadataActor*>(this)->SAV< DirectoryLayer::Node >::value()) DirectoryLayer::Node(*n);
				this->~LoadMetadataActorState();
				static_cast<LoadMetadataActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 40 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
			StrictFuture<Optional<FDBStandalone<ValueRef>>> __when_expr_0 = tr->get(n->subspace.get().pack(DirectoryLayer::LAYER_KEY));
															#line 40 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
			if (static_cast<LoadMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 82 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/bindings/flow/Node.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadMetadataActor*>(this)->actor_wait_state = 1;
															#line 40 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadMetadataActor, 0, Optional<FDBStandalone<ValueRef>> >*>(static_cast<LoadMetadataActor*>(this)));
															#line 87 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/bindings/flow/Node.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadMetadataActorState();
		static_cast<LoadMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<FDBStandalone<ValueRef>> const& layer,int loopDepth) 
	{
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
		n->layer = layer.present() ? layer.get() : Standalone<StringRef>();
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
		n->loadedMetadata = true;
															#line 45 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
		if (!static_cast<LoadMetadataActor*>(this)->SAV<DirectoryLayer::Node>::futures) { (void)(*n); this->~LoadMetadataActorState(); static_cast<LoadMetadataActor*>(this)->destroy(); return 0; }
															#line 114 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/bindings/flow/Node.actor.g.cpp"
		new (&static_cast<LoadMetadataActor*>(this)->SAV< DirectoryLayer::Node >::value()) DirectoryLayer::Node(*n);
		this->~LoadMetadataActorState();
		static_cast<LoadMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<FDBStandalone<ValueRef>> && layer,int loopDepth) 
	{
															#line 42 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
		n->layer = layer.present() ? layer.get() : Standalone<StringRef>();
															#line 43 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
		n->loadedMetadata = true;
															#line 45 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
		if (!static_cast<LoadMetadataActor*>(this)->SAV<DirectoryLayer::Node>::futures) { (void)(*n); this->~LoadMetadataActorState(); static_cast<LoadMetadataActor*>(this)->destroy(); return 0; }
															#line 130 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/bindings/flow/Node.actor.g.cpp"
		new (&static_cast<LoadMetadataActor*>(this)->SAV< DirectoryLayer::Node >::value()) DirectoryLayer::Node(*n);
		this->~LoadMetadataActorState();
		static_cast<LoadMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Optional<FDBStandalone<ValueRef>> const& layer,int loopDepth) 
	{
		loopDepth = a_body1cont1(layer, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<FDBStandalone<ValueRef>> && layer,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(layer), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadMetadataActor*>(this)->actor_wait_state > 0) static_cast<LoadMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<LoadMetadataActor*>(this)->ActorCallback< LoadMetadataActor, 0, Optional<FDBStandalone<ValueRef>> >::remove();

	}
	void a_callback_fire(ActorCallback< LoadMetadataActor, 0, Optional<FDBStandalone<ValueRef>> >*,Optional<FDBStandalone<ValueRef>> const& value) 
	{
		fdb_probe_actor_enter("loadMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadMetadataActor, 0, Optional<FDBStandalone<ValueRef>> >*,Optional<FDBStandalone<ValueRef>> && value) 
	{
		fdb_probe_actor_enter("loadMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadMetadataActor, 0, Optional<FDBStandalone<ValueRef>> >*,Error err) 
	{
		fdb_probe_actor_enter("loadMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 34 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
	DirectoryLayer::Node* n;
															#line 34 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
	Reference<Transaction> tr;
															#line 217 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/bindings/flow/Node.actor.g.cpp"
};
// This generated class is to be used only via loadMetadata()
															#line 34 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
class LoadMetadataActor final : public Actor<DirectoryLayer::Node>, public ActorCallback< LoadMetadataActor, 0, Optional<FDBStandalone<ValueRef>> >, public FastAllocated<LoadMetadataActor>, public LoadMetadataActorState<LoadMetadataActor> {
															#line 222 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/bindings/flow/Node.actor.g.cpp"
public:
	using FastAllocated<LoadMetadataActor>::operator new;
	using FastAllocated<LoadMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12300700542721018624UL, 214358812329767424UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<DirectoryLayer::Node>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadMetadataActor, 0, Optional<FDBStandalone<ValueRef>> >;
															#line 34 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
	LoadMetadataActor(DirectoryLayer::Node* const& n,Reference<Transaction> const& tr) 
															#line 239 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/bindings/flow/Node.actor.g.cpp"
		 : Actor<DirectoryLayer::Node>(),
		   LoadMetadataActorState<LoadMetadataActor>(n, tr),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6834767203553285120UL, 15272469307470001152UL);
		ActorExecutionContextHelper __helper(static_cast<LoadMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadMetadataActor, 0, Optional<FDBStandalone<ValueRef>> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 34 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
[[nodiscard]] Future<DirectoryLayer::Node> loadMetadata( DirectoryLayer::Node* const& n, Reference<Transaction> const& tr ) {
															#line 34 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"
	return Future<DirectoryLayer::Node>(new LoadMetadataActor(n, tr));
															#line 271 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/build_output/bindings/flow/Node.actor.g.cpp"
}

#line 47 "/codebuild/output/src3134128731/src/github.com/apple/foundationdb/bindings/flow/Node.actor.cpp"

// Calls to loadMetadata must keep the Node alive while the future is outstanding
Future<DirectoryLayer::Node> DirectoryLayer::Node::loadMetadata(Reference<Transaction> tr) {
	return FDB::loadMetadata(this, tr);
}

bool DirectoryLayer::Node::isInPartition(bool includeEmptySubpath) const {
	ASSERT(loadedMetadata);
	return exists() && layer == DirectoryLayer::PARTITION_LAYER &&
	       (includeEmptySubpath || targetPath.size() > path.size());
}

IDirectory::Path DirectoryLayer::Node::getPartitionSubpath() const {
	return Path(targetPath.begin() + path.size(), targetPath.end());
}

Reference<DirectorySubspace> DirectoryLayer::Node::getContents() const {
	ASSERT(exists());
	ASSERT(loadedMetadata);

	return directoryLayer->contentsOfNode(subspace.get(), path, layer);
}
} // namespace FDB
