#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
/*
 * FastTriggeredWatches.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbserver/Knobs.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct FastTriggeredWatchesWorkload : TestWorkload {
	static constexpr auto NAME = "FastTriggeredWatches";
	// Tests the time it takes for a watch to be fired after the value has changed in the storage server
	int nodes, keyBytes;
	double testDuration;
	std::vector<Future<Void>> clients;
	PerfIntCounter operations, retries;
	Value defaultValue;

	FastTriggeredWatchesWorkload(WorkloadContext const& wcx)
	  : TestWorkload(wcx), operations("Operations"), retries("Retries") {
		testDuration = getOption(options, "testDuration"_sr, 600.0);
		nodes = getOption(options, "nodes"_sr, 100);
		defaultValue = StringRef(format("%010d", deterministicRandom()->randomInt(0, 1000)));
		keyBytes = std::max(getOption(options, "keyBytes"_sr, 16), 16);
	}

	void disableFailureInjectionWorkloads(std::set<std::string>& out) const override {
		// This test asserts that watches fire within a certain version range. Attrition will make this assertion fail
		// since it can cause recoveries which will bump the cluster version significantly
		out.emplace("Attrition");
	}

	Future<Void> setup(Database const& cx) override {
		if (clientId == 0)
			return _setup(cx, this);
		return Void();
	}

																#line 59 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 57 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
template <class _setupActor>
															#line 57 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
class _setupActorState {
															#line 65 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
public:
															#line 57 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	_setupActorState(Database const& cx,FastTriggeredWatchesWorkload* const& self) 
															#line 57 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
															#line 57 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		 : cx(cx),
															#line 57 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		   self(self),
															#line 58 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		   tr(cx)
															#line 76 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 60 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			;
															#line 91 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 72 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 114 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 62 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			for(int i = 0;i < self->nodes;i += 2) {
															#line 63 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
				tr.set(self->keyForIndex(i), self->defaultValue);
															#line 136 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			}
															#line 65 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			StrictFuture<Void> __when_expr_0 = tr.commit();
															#line 65 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 142 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 65 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 147 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 184 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 2;
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 1, Void >*>(static_cast<_setupActor*>(this)));
															#line 189 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _setupActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _setupActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 57 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	Database cx;
															#line 57 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	FastTriggeredWatchesWorkload* self;
															#line 58 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	Transaction tr;
															#line 380 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 57 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public ActorCallback< _setupActor, 1, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 385 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15915275534386988032UL, 10305001072537075456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
friend struct ActorCallback< _setupActor, 1, Void >;
															#line 57 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	_setupActor(Database const& cx,FastTriggeredWatchesWorkload* const& self) 
															#line 403 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _setupActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 57 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, FastTriggeredWatchesWorkload* const& self ) {
															#line 57 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 436 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
}

#line 74 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId == 0)
			return _start(cx, this);
		return Void();
	}

																#line 447 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
// This generated class is to be used only via setter()
															#line 81 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
template <class SetterActor>
															#line 81 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
class SetterActorState {
															#line 453 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
public:
															#line 81 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	SetterActorState(Database const& cx,Key const& key,Optional<Value> const& value) 
															#line 81 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
															#line 81 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		 : cx(cx),
															#line 81 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		   key(key),
															#line 81 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		   value(value),
															#line 82 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		   tr(cx)
															#line 466 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
	{
		fdb_probe_actor_create("setter", reinterpret_cast<unsigned long>(this));

	}
	~SetterActorState() 
	{
		fdb_probe_actor_destroy("setter", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 84 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(deterministicRandom()->random01());
															#line 84 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			if (static_cast<SetterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 483 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetterActor*>(this)->actor_wait_state = 1;
															#line 84 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetterActor, 0, Void >*>(static_cast<SetterActor*>(this)));
															#line 488 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetterActorState();
		static_cast<SetterActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		;
															#line 511 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 85 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		;
															#line 520 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetterActor*>(this)->actor_wait_state > 0) static_cast<SetterActor*>(this)->actor_wait_state = 0;
		static_cast<SetterActor*>(this)->ActorCallback< SetterActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetterActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetterActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setter", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetterActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setter", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setter", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
		try {
															#line 87 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			if (value.present())
															#line 612 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			{
															#line 88 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
				tr.set(key, value.get());
															#line 616 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			}
			else
			{
															#line 90 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
				tr.clear(key);
															#line 622 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			}
															#line 92 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 92 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			if (static_cast<SetterActor*>(this)->actor_wait_state < 0) return a_body1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 628 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<SetterActor*>(this)->actor_wait_state = 2;
															#line 92 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SetterActor, 1, Void >*>(static_cast<SetterActor*>(this)));
															#line 633 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 97 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 97 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			if (static_cast<SetterActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 657 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SetterActor*>(this)->actor_wait_state = 3;
															#line 97 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SetterActor, 2, Void >*>(static_cast<SetterActor*>(this)));
															#line 662 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (!static_cast<SetterActor*>(this)->SAV<Version>::futures) { (void)(tr.getCommittedVersion()); this->~SetterActorState(); static_cast<SetterActor*>(this)->destroy(); return 0; }
															#line 677 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		new (&static_cast<SetterActor*>(this)->SAV< Version >::value()) Version(tr.getCommittedVersion());
		this->~SetterActorState();
		static_cast<SetterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 94 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (!static_cast<SetterActor*>(this)->SAV<Version>::futures) { (void)(tr.getCommittedVersion()); this->~SetterActorState(); static_cast<SetterActor*>(this)->destroy(); return 0; }
															#line 689 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		new (&static_cast<SetterActor*>(this)->SAV< Version >::value()) Version(tr.getCommittedVersion());
		this->~SetterActorState();
		static_cast<SetterActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SetterActor*>(this)->actor_wait_state > 0) static_cast<SetterActor*>(this)->actor_wait_state = 0;
		static_cast<SetterActor*>(this)->ActorCallback< SetterActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetterActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SetterActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setter", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SetterActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setter", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setter", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SetterActor*>(this)->actor_wait_state > 0) static_cast<SetterActor*>(this)->actor_wait_state = 0;
		static_cast<SetterActor*>(this)->ActorCallback< SetterActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetterActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setter", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SetterActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setter", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SetterActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setter", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setter", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 81 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	Database cx;
															#line 81 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	Key key;
															#line 81 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	Optional<Value> value;
															#line 82 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 867 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
};
// This generated class is to be used only via setter()
															#line 81 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
class SetterActor final : public Actor<Version>, public ActorCallback< SetterActor, 0, Void >, public ActorCallback< SetterActor, 1, Void >, public ActorCallback< SetterActor, 2, Void >, public FastAllocated<SetterActor>, public SetterActorState<SetterActor> {
															#line 872 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
public:
	using FastAllocated<SetterActor>::operator new;
	using FastAllocated<SetterActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11979944993842252544UL, 13496454738664997120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetterActor, 0, Void >;
friend struct ActorCallback< SetterActor, 1, Void >;
friend struct ActorCallback< SetterActor, 2, Void >;
															#line 81 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	SetterActor(Database const& cx,Key const& key,Optional<Value> const& value) 
															#line 891 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		 : Actor<Version>(),
		   SetterActorState<SetterActor>(cx, key, value),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setter", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2265709294996421120UL, 11269667129351686912UL);
		ActorExecutionContextHelper __helper(static_cast<SetterActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setter");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setter", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetterActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SetterActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SetterActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 81 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
[[nodiscard]] Future<Version> setter( Database const& cx, Key const& key, Optional<Value> const& value ) {
															#line 81 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	return Future<Version>(new SetterActor(cx, key, value));
															#line 925 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
}

#line 101 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"

																#line 930 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
template <class _startActor>
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
class _startActorState {
															#line 936 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
public:
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	_startActorState(Database const& cx,FastTriggeredWatchesWorkload* const& self) 
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		 : cx(cx),
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		   self(self),
															#line 103 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		   testStart(now()),
															#line 104 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		   lastReadVersion(0)
															#line 949 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 106 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
				;
															#line 965 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 160 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			TraceEvent(SevError, "FastWatchError").errorUnsuppressed(e);
															#line 161 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 997 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 158 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 1011 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 107 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		getDuration = 0;
															#line 108 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		watchEnd = 0;
															#line 109 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		watchCommitted = false;
															#line 110 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		setKey = self->keyForIndex(deterministicRandom()->randomInt(0, self->nodes));
															#line 111 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		setValue = Optional<Value>();
															#line 112 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (deterministicRandom()->random01() > 0.5)
															#line 1040 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		{
															#line 113 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			setValue = StringRef(format("%010d", deterministicRandom()->randomInt(0, 1000)));
															#line 1044 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		}
															#line 115 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		setFuture = self->setter(cx, setKey, setValue);
															#line 116 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(deterministicRandom()->random01());
															#line 116 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1052 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 116 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1057 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 117 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		watchCommitVersion = 0;
															#line 118 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		;
															#line 1081 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 117 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		watchCommitVersion = 0;
															#line 118 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		;
															#line 1092 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(int loopDepth) 
	{
															#line 148 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		StrictFuture<Version> __when_expr_5 = setFuture;
															#line 148 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1178 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont3when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 148 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Version >*>(static_cast<_startActor*>(this)));
															#line 1183 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1(int loopDepth) 
	{
															#line 119 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 1199 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		try {
															#line 122 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr.get(setKey);
															#line 122 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1205 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 122 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Optional<Value> >*>(static_cast<_startActor*>(this)));
															#line 1210 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1cont1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 145 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr.onError(e);
															#line 145 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 1247 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1cont1loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 145 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 1252 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Value> const& val,int loopDepth) 
	{
															#line 123 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (watchCommitted)
															#line 1267 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		{
															#line 124 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			getDuration = now() - watchEnd;
															#line 1271 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		}
															#line 126 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		lastReadVersion = tr.getReadVersion().get();
															#line 130 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (val == setValue)
															#line 1277 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 132 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		ASSERT(!watchCommitted);
															#line 133 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		tr.addWriteConflictRange(singleKeyRange(""_sr));
															#line 135 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		watchFuture = tr.watch(setKey);
															#line 136 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 136 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1291 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 136 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1296 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2(Optional<Value> && val,int loopDepth) 
	{
															#line 123 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (watchCommitted)
															#line 1305 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		{
															#line 124 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
			getDuration = now() - watchEnd;
															#line 1309 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		}
															#line 126 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		lastReadVersion = tr.getReadVersion().get();
															#line 130 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (val == setValue)
															#line 1315 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		{
			return a_body1loopBody1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 132 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		ASSERT(!watchCommitted);
															#line 133 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		tr.addWriteConflictRange(singleKeyRange(""_sr));
															#line 135 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		watchFuture = tr.watch(setKey);
															#line 136 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 136 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1329 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 136 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1334 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> const& val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(val, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1when1(Optional<Value> && val,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont2(std::move(val), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 137 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		watchCommitVersion = tr.getCommittedVersion();
															#line 140 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 140 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1422 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 140 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1427 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 137 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		watchCommitVersion = tr.getCommittedVersion();
															#line 140 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		StrictFuture<Void> __when_expr_3 = watchFuture;
															#line 140 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1loopBody1cont1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1440 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1cont1loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 140 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1445 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
															#line 141 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		watchEnd = now();
															#line 142 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		watchCommitted = true;
															#line 1531 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
															#line 141 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		watchEnd = now();
															#line 142 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		watchCommitted = true;
															#line 1542 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		loopDepth = a_body1loopBody1cont1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1cont1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1cont1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1cont1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1cont1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1loopBody1cont1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1loopBody1cont4(Version const& keySetVersion,int loopDepth) 
	{
															#line 149 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		int64_t versionDelta = lastReadVersion - std::max(keySetVersion, watchCommitVersion);
															#line 152 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		ASSERT(!watchCommitted || versionDelta >= SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT || versionDelta < SERVER_KNOBS->VERSIONS_PER_SECOND * (25 + getDuration));
															#line 155 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (now() - testStart > self->testDuration)
															#line 1730 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont4(Version && keySetVersion,int loopDepth) 
	{
															#line 149 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		int64_t versionDelta = lastReadVersion - std::max(keySetVersion, watchCommitVersion);
															#line 152 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		ASSERT(!watchCommitted || versionDelta >= SERVER_KNOBS->MAX_VERSIONS_IN_FLIGHT || versionDelta < SERVER_KNOBS->VERSIONS_PER_SECOND * (25 + getDuration));
															#line 155 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
		if (now() - testStart > self->testDuration)
															#line 1746 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Version const& keySetVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(keySetVersion, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Version && keySetVersion,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(keySetVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Version >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Version >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	Database cx;
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	FastTriggeredWatchesWorkload* self;
															#line 103 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	double testStart;
															#line 104 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	Version lastReadVersion;
															#line 107 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	double getDuration;
															#line 108 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	double watchEnd;
															#line 109 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	bool watchCommitted;
															#line 110 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	Key setKey;
															#line 111 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	Optional<Value> setValue;
															#line 115 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	Future<Version> setFuture;
															#line 117 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	Version watchCommitVersion;
															#line 119 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 135 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	Future<Void> watchFuture;
															#line 1855 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Optional<Value> >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Version >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1860 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7993042245057638144UL, 12407472711042694400UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Optional<Value> >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Version >;
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	_startActor(Database const& cx,FastTriggeredWatchesWorkload* const& self) 
															#line 1882 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Version >*)0, actor_cancelled()); break;
		}

	}
};
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
[[nodiscard]] static Future<Void> _start( Database const& cx, FastTriggeredWatchesWorkload* const& self ) {
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1919 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/FastTriggeredWatches.actor.g.cpp"
}

#line 164 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbserver/workloads/FastTriggeredWatches.actor.cpp"

	Future<bool> check(Database const& cx) override {
		bool ok = true;
		for (int i = 0; i < clients.size(); i++)
			if (clients[i].isError())
				ok = false;
		clients.clear();
		return ok;
	}

	void getMetrics(std::vector<PerfMetric>& m) override {
		double duration = testDuration;
		m.emplace_back("Operations/sec", operations.getValue() / duration, Averaged::False);
		m.push_back(operations.getMetric());
		m.push_back(retries.getMetric());
	}

	Key keyForIndex(uint64_t index) const {
		Key result = makeString(keyBytes);
		uint8_t* data = mutateString(result);
		memset(data, '.', keyBytes);

		double d = double(index) / nodes;
		emplaceIndex(data, 0, *(int64_t*)&d);

		return result;
	}
};

WorkloadFactory<FastTriggeredWatchesWorkload> FastTriggeredWatchesWorkloadFactory;
