#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
/*
 * IncludeCommand.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbcli/fdbcli.actor.h"

#include "fdbclient/FDBOptions.g.h"
#include "fdbclient/IClientApi.h"
#include "fdbclient/Knobs.h"

#include "flow/Arena.h"
#include "flow/FastRef.h"
#include "flow/ThreadHelper.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

namespace {

// Remove the given localities from the exclusion list.
// include localities by clearing the keys.
															#line 38 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
// This generated class is to be used only via includeLocalities()
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
template <class IncludeLocalitiesActor>
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
class IncludeLocalitiesActorState {
															#line 44 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
public:
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	IncludeLocalitiesActorState(Reference<IDatabase> const& db,std::vector<std::string> const& localities,bool const& failed,bool const& includeAll) 
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		 : db(db),
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   localities(localities),
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   failed(failed),
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   includeAll(includeAll),
															#line 40 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   versionKey(deterministicRandom()->randomUniqueID().toString()),
															#line 41 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 61 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("includeLocalities", reinterpret_cast<unsigned long>(this));

	}
	~IncludeLocalitiesActorState() 
	{
		fdb_probe_actor_destroy("includeLocalities", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 42 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			;
															#line 76 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncludeLocalitiesActorState();
		static_cast<IncludeLocalitiesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 43 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 106 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		try {
															#line 46 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			if (includeAll)
															#line 110 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			{
															#line 47 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				if (failed)
															#line 114 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
				{
															#line 48 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
					tr->clear(fdb_cli::failedLocalitySpecialKeyRange);
															#line 118 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
				}
				else
				{
															#line 50 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
					tr->clear(fdb_cli::excludedLocalitySpecialKeyRange);
															#line 124 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
				}
			}
			else
			{
															#line 53 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				for( const auto& l : localities ) {
															#line 54 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
					Key locality = failed ? fdb_cli::failedLocalitySpecialKeyRange.begin.withSuffix(l) : fdb_cli::excludedLocalitySpecialKeyRange.begin.withSuffix(l);
															#line 56 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
					tr->clear(locality);
															#line 135 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
				}
			}
															#line 59 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			StrictFuture<Void> __when_expr_0 = safeThreadFutureToFuture(tr->commit());
															#line 59 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			if (static_cast<IncludeLocalitiesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 142 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IncludeLocalitiesActor*>(this)->actor_wait_state = 1;
															#line 59 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncludeLocalitiesActor, 0, Void >*>(static_cast<IncludeLocalitiesActor*>(this)));
															#line 147 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 62 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			TraceEvent("IncludeLocalitiesError").errorUnsuppressed(e);
															#line 63 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 63 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			if (static_cast<IncludeLocalitiesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 173 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<IncludeLocalitiesActor*>(this)->actor_wait_state = 2;
															#line 63 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncludeLocalitiesActor, 1, Void >*>(static_cast<IncludeLocalitiesActor*>(this)));
															#line 178 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 60 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		if (!static_cast<IncludeLocalitiesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncludeLocalitiesActorState(); static_cast<IncludeLocalitiesActor*>(this)->destroy(); return 0; }
															#line 193 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		new (&static_cast<IncludeLocalitiesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncludeLocalitiesActorState();
		static_cast<IncludeLocalitiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 60 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		if (!static_cast<IncludeLocalitiesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncludeLocalitiesActorState(); static_cast<IncludeLocalitiesActor*>(this)->destroy(); return 0; }
															#line 205 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		new (&static_cast<IncludeLocalitiesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncludeLocalitiesActorState();
		static_cast<IncludeLocalitiesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncludeLocalitiesActor*>(this)->actor_wait_state > 0) static_cast<IncludeLocalitiesActor*>(this)->actor_wait_state = 0;
		static_cast<IncludeLocalitiesActor*>(this)->ActorCallback< IncludeLocalitiesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncludeLocalitiesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("includeLocalities", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeLocalities", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncludeLocalitiesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("includeLocalities", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeLocalities", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncludeLocalitiesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("includeLocalities", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeLocalities", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IncludeLocalitiesActor*>(this)->actor_wait_state > 0) static_cast<IncludeLocalitiesActor*>(this)->actor_wait_state = 0;
		static_cast<IncludeLocalitiesActor*>(this)->ActorCallback< IncludeLocalitiesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncludeLocalitiesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("includeLocalities", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeLocalities", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IncludeLocalitiesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("includeLocalities", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeLocalities", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IncludeLocalitiesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("includeLocalities", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeLocalities", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	std::vector<std::string> localities;
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	bool failed;
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	bool includeAll;
															#line 40 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	std::string versionKey;
															#line 41 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 387 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
};
// This generated class is to be used only via includeLocalities()
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
class IncludeLocalitiesActor final : public Actor<Void>, public ActorCallback< IncludeLocalitiesActor, 0, Void >, public ActorCallback< IncludeLocalitiesActor, 1, Void >, public FastAllocated<IncludeLocalitiesActor>, public IncludeLocalitiesActorState<IncludeLocalitiesActor> {
															#line 392 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
public:
	using FastAllocated<IncludeLocalitiesActor>::operator new;
	using FastAllocated<IncludeLocalitiesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3242820556999980800UL, 7022365675481922560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncludeLocalitiesActor, 0, Void >;
friend struct ActorCallback< IncludeLocalitiesActor, 1, Void >;
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	IncludeLocalitiesActor(Reference<IDatabase> const& db,std::vector<std::string> const& localities,bool const& failed,bool const& includeAll) 
															#line 410 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		 : Actor<Void>(),
		   IncludeLocalitiesActorState<IncludeLocalitiesActor>(db, localities, failed, includeAll),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("includeLocalities", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3203046928570983680UL, 8290273524939964416UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeLocalitiesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("includeLocalities");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("includeLocalities", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncludeLocalitiesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IncludeLocalitiesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
[[nodiscard]] Future<Void> includeLocalities( Reference<IDatabase> const& db, std::vector<std::string> const& localities, bool const& failed, bool const& includeAll ) {
															#line 36 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	return Future<Void>(new IncludeLocalitiesActor(db, localities, failed, includeAll));
															#line 443 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
}

#line 67 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"

															#line 448 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
// This generated class is to be used only via includeServers()
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
template <class IncludeServersActor>
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
class IncludeServersActorState {
															#line 454 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
public:
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	IncludeServersActorState(Reference<IDatabase> const& db,std::vector<AddressExclusion> const& servers,bool const& failed) 
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		 : db(db),
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   servers(servers),
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   failed(failed),
															#line 69 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   versionKey(deterministicRandom()->randomUniqueID().toString()),
															#line 70 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   tr(db->createTransaction())
															#line 469 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("includeServers", reinterpret_cast<unsigned long>(this));

	}
	~IncludeServersActorState() 
	{
		fdb_probe_actor_destroy("includeServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 71 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			;
															#line 484 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncludeServersActorState();
		static_cast<IncludeServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 72 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		tr->setOption(FDBTransactionOptions::SPECIAL_KEY_SPACE_ENABLE_WRITES);
															#line 514 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		try {
															#line 74 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			for( auto& s : servers ) {
															#line 76 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				if (!s.isValid())
															#line 520 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
				{
															#line 77 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
					if (failed)
															#line 524 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
					{
															#line 78 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
						tr->clear(fdb_cli::failedServersSpecialKeyRange);
															#line 528 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
					}
					else
					{
															#line 80 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
						tr->clear(fdb_cli::excludedServersSpecialKeyRange);
															#line 534 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
					}
				}
				else
				{
															#line 83 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
					Key addr = failed ? fdb_cli::failedServersSpecialKeyRange.begin.withSuffix(s.toString()) : fdb_cli::excludedServersSpecialKeyRange.begin.withSuffix(s.toString());
															#line 85 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
					tr->clear(addr);
															#line 94 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
					if (s.isWholeMachine())
															#line 545 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
					{
															#line 95 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
						tr->clear(KeyRangeRef(addr.withSuffix(":"_sr), addr.withSuffix(";"_sr)));
															#line 549 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
					}
				}
			}
															#line 98 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			StrictFuture<Void> __when_expr_0 = safeThreadFutureToFuture(tr->commit());
															#line 98 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			if (static_cast<IncludeServersActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 557 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<IncludeServersActor*>(this)->actor_wait_state = 1;
															#line 98 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncludeServersActor, 0, Void >*>(static_cast<IncludeServersActor*>(this)));
															#line 562 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 101 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			TraceEvent("IncludeServersError").errorUnsuppressed(e);
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			StrictFuture<Void> __when_expr_1 = safeThreadFutureToFuture(tr->onError(e));
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			if (static_cast<IncludeServersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 588 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<IncludeServersActor*>(this)->actor_wait_state = 2;
															#line 102 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncludeServersActor, 1, Void >*>(static_cast<IncludeServersActor*>(this)));
															#line 593 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		if (!static_cast<IncludeServersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncludeServersActorState(); static_cast<IncludeServersActor*>(this)->destroy(); return 0; }
															#line 608 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		new (&static_cast<IncludeServersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncludeServersActorState();
		static_cast<IncludeServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 99 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		if (!static_cast<IncludeServersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~IncludeServersActorState(); static_cast<IncludeServersActor*>(this)->destroy(); return 0; }
															#line 620 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		new (&static_cast<IncludeServersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~IncludeServersActorState();
		static_cast<IncludeServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncludeServersActor*>(this)->actor_wait_state > 0) static_cast<IncludeServersActor*>(this)->actor_wait_state = 0;
		static_cast<IncludeServersActor*>(this)->ActorCallback< IncludeServersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncludeServersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("includeServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncludeServersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("includeServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncludeServersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("includeServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IncludeServersActor*>(this)->actor_wait_state > 0) static_cast<IncludeServersActor*>(this)->actor_wait_state = 0;
		static_cast<IncludeServersActor*>(this)->ActorCallback< IncludeServersActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncludeServersActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("includeServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IncludeServersActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("includeServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeServers", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IncludeServersActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("includeServers", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeServers", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	std::vector<AddressExclusion> servers;
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	bool failed;
															#line 69 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	std::string versionKey;
															#line 70 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	Reference<ITransaction> tr;
															#line 800 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
};
// This generated class is to be used only via includeServers()
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
class IncludeServersActor final : public Actor<Void>, public ActorCallback< IncludeServersActor, 0, Void >, public ActorCallback< IncludeServersActor, 1, Void >, public FastAllocated<IncludeServersActor>, public IncludeServersActorState<IncludeServersActor> {
															#line 805 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
public:
	using FastAllocated<IncludeServersActor>::operator new;
	using FastAllocated<IncludeServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5971717886479703040UL, 10447151038980551168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncludeServersActor, 0, Void >;
friend struct ActorCallback< IncludeServersActor, 1, Void >;
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	IncludeServersActor(Reference<IDatabase> const& db,std::vector<AddressExclusion> const& servers,bool const& failed) 
															#line 823 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		 : Actor<Void>(),
		   IncludeServersActorState<IncludeServersActor>(db, servers, failed),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("includeServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7035060310568136960UL, 2930223583431837696UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("includeServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("includeServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncludeServersActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IncludeServersActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
[[nodiscard]] Future<Void> includeServers( Reference<IDatabase> const& db, std::vector<AddressExclusion> const& servers, bool const& failed ) {
															#line 68 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	return Future<Void>(new IncludeServersActor(db, servers, failed));
															#line 856 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
}

#line 106 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"

// Includes the servers that could be IP addresses or localities back to the cluster.
															#line 862 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
// This generated class is to be used only via include()
															#line 108 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
template <class IncludeActor>
															#line 108 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
class IncludeActorState {
															#line 868 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
public:
															#line 108 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	IncludeActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 108 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
															#line 108 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		 : db(db),
															#line 108 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   tokens(tokens),
															#line 109 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   addresses(),
															#line 110 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   localities(),
															#line 111 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   failed(false),
															#line 112 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   all(false)
															#line 885 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("include", reinterpret_cast<unsigned long>(this));

	}
	~IncludeActorState() 
	{
		fdb_probe_actor_destroy("include", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			for(auto t = tokens.begin() + 1;t != tokens.end();++t) {
															#line 114 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				if (*t == "all"_sr)
															#line 902 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
				{
															#line 115 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
					all = true;
															#line 906 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
				}
				else
				{
															#line 116 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
					if (*t == "failed"_sr)
															#line 912 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
					{
															#line 117 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
						failed = true;
															#line 916 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
					}
					else
					{
															#line 118 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
						if (t->startsWith(LocalityData::ExcludeLocalityPrefix) && t->toString().find(':') != std::string::npos)
															#line 922 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
						{
															#line 120 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
							localities.push_back(t->toString());
															#line 926 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
						}
						else
						{
															#line 122 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
							auto a = AddressExclusion::parse(*t);
															#line 123 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
							if (!a.isValid())
															#line 934 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
							{
															#line 124 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
								fprintf(stderr, "ERROR: '%s' is neither a valid network endpoint address nor a locality\n", t->toString().c_str());
															#line 127 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
								if (t->toString().find(":tls") != std::string::npos)
															#line 940 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
								{
															#line 128 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
									printf("        Do not include the `:tls' suffix when naming a process\n");
															#line 944 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
								}
															#line 129 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
								if (!static_cast<IncludeActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IncludeActorState(); static_cast<IncludeActor*>(this)->destroy(); return 0; }
															#line 948 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
								new (&static_cast<IncludeActor*>(this)->SAV< bool >::value()) bool(false);
								this->~IncludeActorState();
								static_cast<IncludeActor*>(this)->finishSendAndDelPromiseRef();
								return 0;
							}
															#line 131 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
							addresses.push_back(a);
															#line 956 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
						}
					}
				}
			}
															#line 134 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			if (all)
															#line 963 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			{
															#line 135 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				std::vector<AddressExclusion> includeAll;
															#line 136 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				includeAll.push_back(AddressExclusion());
															#line 137 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				StrictFuture<Void> __when_expr_0 = includeServers(db, includeAll, failed);
															#line 137 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				if (static_cast<IncludeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 973 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<IncludeActor*>(this)->actor_wait_state = 1;
															#line 137 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncludeActor, 0, Void >*>(static_cast<IncludeActor*>(this)));
															#line 978 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 140 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				if (!addresses.empty())
															#line 985 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
				{
															#line 141 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
					StrictFuture<Void> __when_expr_2 = includeServers(db, addresses, failed);
															#line 141 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
					if (static_cast<IncludeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 991 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
					if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1when2(__when_expr_2.get(), loopDepth); };
					static_cast<IncludeActor*>(this)->actor_wait_state = 3;
															#line 141 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
					__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IncludeActor, 2, Void >*>(static_cast<IncludeActor*>(this)));
															#line 996 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont12(loopDepth);
				}
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncludeActorState();
		static_cast<IncludeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 148 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		if (!static_cast<IncludeActor*>(this)->SAV<bool>::futures) { (void)(true); this->~IncludeActorState(); static_cast<IncludeActor*>(this)->destroy(); return 0; }
															#line 1025 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		new (&static_cast<IncludeActor*>(this)->SAV< bool >::value()) bool(true);
		this->~IncludeActorState();
		static_cast<IncludeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont11(Void const& _,int loopDepth) 
	{
															#line 138 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = includeLocalities(db, localities, failed, all);
															#line 138 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		if (static_cast<IncludeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1039 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont11when1(__when_expr_1.get(), loopDepth); };
		static_cast<IncludeActor*>(this)->actor_wait_state = 2;
															#line 138 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncludeActor, 1, Void >*>(static_cast<IncludeActor*>(this)));
															#line 1044 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont11(Void && _,int loopDepth) 
	{
															#line 138 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		StrictFuture<Void> __when_expr_1 = includeLocalities(db, localities, failed, all);
															#line 138 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		if (static_cast<IncludeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1055 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont11when1(__when_expr_1.get(), loopDepth); };
		static_cast<IncludeActor*>(this)->actor_wait_state = 2;
															#line 138 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncludeActor, 1, Void >*>(static_cast<IncludeActor*>(this)));
															#line 1060 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncludeActor*>(this)->actor_wait_state > 0) static_cast<IncludeActor*>(this)->actor_wait_state = 0;
		static_cast<IncludeActor*>(this)->ActorCallback< IncludeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncludeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("include", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("include", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncludeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("include", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("include", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncludeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("include", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("include", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont11cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont11when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont11cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IncludeActor*>(this)->actor_wait_state > 0) static_cast<IncludeActor*>(this)->actor_wait_state = 0;
		static_cast<IncludeActor*>(this)->ActorCallback< IncludeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncludeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("include", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("include", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IncludeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("include", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont11when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("include", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IncludeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("include", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("include", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont12(int loopDepth) 
	{
															#line 143 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		if (!localities.empty())
															#line 1231 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		{
															#line 145 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			StrictFuture<Void> __when_expr_3 = includeLocalities(db, localities, failed, all);
															#line 145 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			if (static_cast<IncludeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1237 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont12when1(__when_expr_3.get(), loopDepth); };
			static_cast<IncludeActor*>(this)->actor_wait_state = 4;
															#line 145 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< IncludeActor, 3, Void >*>(static_cast<IncludeActor*>(this)));
															#line 1242 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont12cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont13(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont13(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont13(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont13(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<IncludeActor*>(this)->actor_wait_state > 0) static_cast<IncludeActor*>(this)->actor_wait_state = 0;
		static_cast<IncludeActor*>(this)->ActorCallback< IncludeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncludeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("include", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("include", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< IncludeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("include", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("include", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< IncludeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("include", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("include", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont12when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<IncludeActor*>(this)->actor_wait_state > 0) static_cast<IncludeActor*>(this)->actor_wait_state = 0;
		static_cast<IncludeActor*>(this)->ActorCallback< IncludeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncludeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("include", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont12when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("include", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< IncludeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("include", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont12when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("include", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< IncludeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("include", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("include", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 108 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 108 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 109 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	std::vector<AddressExclusion> addresses;
															#line 110 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	std::vector<std::string> localities;
															#line 111 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	bool failed;
															#line 112 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	bool all;
															#line 1444 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
};
// This generated class is to be used only via include()
															#line 108 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
class IncludeActor final : public Actor<bool>, public ActorCallback< IncludeActor, 0, Void >, public ActorCallback< IncludeActor, 1, Void >, public ActorCallback< IncludeActor, 2, Void >, public ActorCallback< IncludeActor, 3, Void >, public FastAllocated<IncludeActor>, public IncludeActorState<IncludeActor> {
															#line 1449 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
public:
	using FastAllocated<IncludeActor>::operator new;
	using FastAllocated<IncludeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3196709304303926784UL, 15055308972041640448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncludeActor, 0, Void >;
friend struct ActorCallback< IncludeActor, 1, Void >;
friend struct ActorCallback< IncludeActor, 2, Void >;
friend struct ActorCallback< IncludeActor, 3, Void >;
															#line 108 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	IncludeActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 1469 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		 : Actor<bool>(),
		   IncludeActorState<IncludeActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("include", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3288515436143372032UL, 11648955311431933952UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("include");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("include", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncludeActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< IncludeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< IncludeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< IncludeActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 108 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
[[nodiscard]] Future<bool> include( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 108 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	return Future<bool>(new IncludeActor(db, tokens));
															#line 1504 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
}

#line 149 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"


} // namespace

namespace fdb_cli {

															#line 1514 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
// This generated class is to be used only via includeCommandActor()
															#line 155 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
template <class IncludeCommandActorActor>
															#line 155 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
class IncludeCommandActorActorState {
															#line 1520 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
public:
															#line 155 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	IncludeCommandActorActorState(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 155 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
															#line 155 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		 : db(db),
															#line 155 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		   tokens(tokens)
															#line 1529 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
	{
		fdb_probe_actor_create("includeCommandActor", reinterpret_cast<unsigned long>(this));

	}
	~IncludeCommandActorActorState() 
	{
		fdb_probe_actor_destroy("includeCommandActor", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 156 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
			if (tokens.size() < 2)
															#line 1544 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
			{
															#line 157 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				printUsage(tokens[0]);
															#line 158 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				if (!static_cast<IncludeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(false); this->~IncludeCommandActorActorState(); static_cast<IncludeCommandActorActor*>(this)->destroy(); return 0; }
															#line 1550 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
				new (&static_cast<IncludeCommandActorActor*>(this)->SAV< bool >::value()) bool(false);
				this->~IncludeCommandActorActorState();
				static_cast<IncludeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 160 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				StrictFuture<bool> __when_expr_0 = include(db, tokens);
															#line 160 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				if (static_cast<IncludeCommandActorActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1562 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<IncludeCommandActorActor*>(this)->actor_wait_state = 1;
															#line 160 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncludeCommandActorActor, 0, bool >*>(static_cast<IncludeCommandActorActor*>(this)));
															#line 1567 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~IncludeCommandActorActorState();
		static_cast<IncludeCommandActorActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(bool const& result,int loopDepth) 
	{
															#line 161 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		if (!static_cast<IncludeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~IncludeCommandActorActorState(); static_cast<IncludeCommandActorActor*>(this)->destroy(); return 0; }
															#line 1591 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		new (&static_cast<IncludeCommandActorActor*>(this)->SAV< bool >::value()) bool(result);
		this->~IncludeCommandActorActorState();
		static_cast<IncludeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(bool && result,int loopDepth) 
	{
															#line 161 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
		if (!static_cast<IncludeCommandActorActor*>(this)->SAV<bool>::futures) { (void)(result); this->~IncludeCommandActorActorState(); static_cast<IncludeCommandActorActor*>(this)->destroy(); return 0; }
															#line 1603 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		new (&static_cast<IncludeCommandActorActor*>(this)->SAV< bool >::value()) bool(result);
		this->~IncludeCommandActorActorState();
		static_cast<IncludeCommandActorActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(bool const& result,int loopDepth) 
	{
		loopDepth = a_body1cont3(result, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && result,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncludeCommandActorActor*>(this)->actor_wait_state > 0) static_cast<IncludeCommandActorActor*>(this)->actor_wait_state = 0;
		static_cast<IncludeCommandActorActor*>(this)->ActorCallback< IncludeCommandActorActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< IncludeCommandActorActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("includeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncludeCommandActorActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("includeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncludeCommandActorActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("includeCommandActor", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("includeCommandActor", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 155 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	Reference<IDatabase> db;
															#line 155 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	std::vector<StringRef> tokens;
															#line 1690 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
};
// This generated class is to be used only via includeCommandActor()
															#line 155 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
class IncludeCommandActorActor final : public Actor<bool>, public ActorCallback< IncludeCommandActorActor, 0, bool >, public FastAllocated<IncludeCommandActorActor>, public IncludeCommandActorActorState<IncludeCommandActorActor> {
															#line 1695 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
public:
	using FastAllocated<IncludeCommandActorActor>::operator new;
	using FastAllocated<IncludeCommandActorActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2438208785791096832UL, 3975259010479062528UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< IncludeCommandActorActor, 0, bool >;
															#line 155 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	IncludeCommandActorActor(Reference<IDatabase> const& db,std::vector<StringRef> const& tokens) 
															#line 1712 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
		 : Actor<bool>(),
		   IncludeCommandActorActorState<IncludeCommandActorActor>(db, tokens),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("includeCommandActor", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12203827490374514688UL, 5585399274928477184UL);
		ActorExecutionContextHelper __helper(static_cast<IncludeCommandActorActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("includeCommandActor");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("includeCommandActor", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< IncludeCommandActorActor, 0, bool >*)0, actor_cancelled()); break;
		}

	}
};
															#line 155 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
[[nodiscard]] Future<bool> includeCommandActor( Reference<IDatabase> const& db, std::vector<StringRef> const& tokens ) {
															#line 155 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"
	return Future<bool>(new IncludeCommandActorActor(db, tokens));
															#line 1744 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/build_output/fdbcli/IncludeCommand.actor.g.cpp"
}

#line 164 "/codebuild/output/src3288893276/src/github.com/apple/foundationdb/fdbcli/IncludeCommand.actor.cpp"

CommandFactory includeFactory(
    "include",
    CommandHelp(
        "include all|[<ADDRESS...>] [locality_dcid:<excludedcid>] [locality_zoneid:<excludezoneid>] "
        "[locality_machineid:<excludemachineid>] [locality_processid:<excludeprocessid>] or any locality data",
        "permit previously-excluded servers and localities to rejoin the database",
        "If `all' is specified, the excluded servers and localities list is cleared.\n\nFor each IP address or IP:port "
        "pair in <ADDRESS...> or any LocalityData (like dcid, zoneid, machineid, processid), removes any "
        "matching exclusions from the excluded servers and localities list. "
        "(A specified IP will match all IP:* exclusion entries)"));
} // namespace fdb_cli
