#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
/*
 * CpuProfiler.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/QuietDatabase.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// A workload which starts the CPU profiler at a given time and duration on all workers in a cluster
struct CpuProfilerWorkload : TestWorkload {
	static constexpr auto NAME = "CpuProfiler";
	bool success;

	// How long to run the workload before starting the profiler
	double initialDelay;

	// How long the profiler should be run; if <= 0 then it will run until the workload's check function is called
	double duration;

	// What process classes should be profiled as part of this run?
	// See Locality.h for the list of valid strings to provide.
	std::vector<std::string> roles;

	// A list of worker interfaces which have had profiling turned on
	std::vector<WorkerInterface> profilingWorkers;

	CpuProfilerWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		initialDelay = getOption(options, "initialDelay"_sr, 0.0);
		duration = getOption(options, "duration"_sr, -1.0);
		roles = getOption(options, "roles"_sr, std::vector<std::string>());
		success = true;
	}

	Future<Void> setup(Database const& cx) override { return Void(); }

	// Turns the profiler on or off
																#line 57 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
// This generated class is to be used only via updateProfiler()
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
template <class UpdateProfilerActor>
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
class UpdateProfilerActorState {
															#line 63 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
public:
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	UpdateProfilerActorState(bool const& enabled,Database const& cx,CpuProfilerWorkload* const& self) 
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		 : enabled(enabled),
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		   cx(cx),
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		   self(self)
															#line 74 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateProfiler", reinterpret_cast<unsigned long>(this));

	}
	~UpdateProfilerActorState() 
	{
		fdb_probe_actor_destroy("updateProfiler", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 56 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			if (self->clientId == 0)
															#line 89 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
			{
															#line 58 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
				if (enabled)
															#line 93 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
				{
															#line 59 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
					StrictFuture<std::vector<WorkerDetails>> __when_expr_0 = getWorkers(self->dbInfo);
															#line 59 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
					if (static_cast<UpdateProfilerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 99 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
					static_cast<UpdateProfilerActor*>(this)->actor_wait_state = 1;
															#line 59 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateProfilerActor, 0, std::vector<WorkerDetails> >*>(static_cast<UpdateProfilerActor*>(this)));
															#line 104 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateProfilerActorState();
		static_cast<UpdateProfilerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 98 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (!static_cast<UpdateProfilerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~UpdateProfilerActorState(); static_cast<UpdateProfilerActor*>(this)->destroy(); return 0; }
															#line 137 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		new (&static_cast<UpdateProfilerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~UpdateProfilerActorState();
		static_cast<UpdateProfilerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 71 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		replies = std::vector<Future<ErrorOr<Void>>>();
															#line 72 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		i = int();
															#line 74 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		for(i = 0;i < self->profilingWorkers.size();i++) {
															#line 75 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			ProfilerRequest req;
															#line 76 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			req.type = ProfilerRequest::Type::FLOW;
															#line 77 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			req.action = enabled ? ProfilerRequest::Action::ENABLE : ProfilerRequest::Action::DISABLE;
															#line 78 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			req.duration = 0;
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			req.outputFile = StringRef(self->profilingWorkers[i].address().ip.toString() + "." + format("%d", self->profilingWorkers[i].address().port) + ".profile.bin");
															#line 84 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			replies.push_back(self->profilingWorkers[i].clientInterface.profiler.tryGetReply(req));
															#line 165 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		}
															#line 87 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		StrictFuture<Void> __when_expr_1 = waitForAll(replies);
															#line 87 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (static_cast<UpdateProfilerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 171 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateProfilerActor*>(this)->actor_wait_state = 2;
															#line 87 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateProfilerActor, 1, Void >*>(static_cast<UpdateProfilerActor*>(this)));
															#line 176 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(std::vector<WorkerDetails> const& _workers,int loopDepth) 
	{
															#line 60 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		std::vector<WorkerInterface> workers;
															#line 61 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		for(int i = 0;i < _workers.size();i++) {
															#line 62 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			if (self->roles.empty() || std::find(self->roles.cbegin(), self->roles.cend(), _workers[i].processClass.toString()) != self->roles.cend())
															#line 189 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
			{
															#line 65 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
				workers.push_back(_workers[i].interf);
															#line 193 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
			}
		}
															#line 68 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		self->profilingWorkers = workers;
															#line 198 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(std::vector<WorkerDetails> && _workers,int loopDepth) 
	{
															#line 60 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		std::vector<WorkerInterface> workers;
															#line 61 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		for(int i = 0;i < _workers.size();i++) {
															#line 62 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			if (self->roles.empty() || std::find(self->roles.cbegin(), self->roles.cend(), _workers[i].processClass.toString()) != self->roles.cend())
															#line 211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
			{
															#line 65 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
				workers.push_back(_workers[i].interf);
															#line 215 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
			}
		}
															#line 68 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		self->profilingWorkers = workers;
															#line 220 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> const& _workers,int loopDepth) 
	{
		loopDepth = a_body1cont3(_workers, loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<WorkerDetails> && _workers,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_workers), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateProfilerActor*>(this)->actor_wait_state > 0) static_cast<UpdateProfilerActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateProfilerActor*>(this)->ActorCallback< UpdateProfilerActor, 0, std::vector<WorkerDetails> >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateProfilerActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> const& value) 
	{
		fdb_probe_actor_enter("updateProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateProfilerActor, 0, std::vector<WorkerDetails> >*,std::vector<WorkerDetails> && value) 
	{
		fdb_probe_actor_enter("updateProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateProfilerActor, 0, std::vector<WorkerDetails> >*,Error err) 
	{
		fdb_probe_actor_enter("updateProfiler", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateProfiler", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (enabled)
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		{
															#line 91 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			for(i = 0;i < replies.size();i++) {
															#line 92 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
				if (!replies[i].get().present())
															#line 310 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
				{
															#line 93 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
					self->success = false;
															#line 314 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
				}
			}
		}
															#line 95 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		TraceEvent("DoneSignalingProfiler").log();
															#line 320 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (enabled)
															#line 329 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		{
															#line 91 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			for(i = 0;i < replies.size();i++) {
															#line 92 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
				if (!replies[i].get().present())
															#line 335 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
				{
															#line 93 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
					self->success = false;
															#line 339 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
				}
			}
		}
															#line 95 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		TraceEvent("DoneSignalingProfiler").log();
															#line 345 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateProfilerActor*>(this)->actor_wait_state > 0) static_cast<UpdateProfilerActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateProfilerActor*>(this)->ActorCallback< UpdateProfilerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateProfilerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateProfiler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateProfiler", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateProfilerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateProfiler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateProfiler", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateProfilerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateProfiler", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateProfiler", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	bool enabled;
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	Database cx;
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	CpuProfilerWorkload* self;
															#line 71 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	std::vector<Future<ErrorOr<Void>>> replies;
															#line 72 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	int i;
															#line 435 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateProfiler()
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
class UpdateProfilerActor final : public Actor<Void>, public ActorCallback< UpdateProfilerActor, 0, std::vector<WorkerDetails> >, public ActorCallback< UpdateProfilerActor, 1, Void >, public FastAllocated<UpdateProfilerActor>, public UpdateProfilerActorState<UpdateProfilerActor> {
															#line 440 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateProfilerActor>::operator new;
	using FastAllocated<UpdateProfilerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6532360219166534400UL, 17925171878166408192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateProfilerActor, 0, std::vector<WorkerDetails> >;
friend struct ActorCallback< UpdateProfilerActor, 1, Void >;
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	UpdateProfilerActor(bool const& enabled,Database const& cx,CpuProfilerWorkload* const& self) 
															#line 458 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateProfilerActorState<UpdateProfilerActor>(enabled, cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateProfiler", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13526999877125458688UL, 9673212807152107264UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateProfilerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateProfiler");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateProfiler", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateProfilerActor, 0, std::vector<WorkerDetails> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateProfilerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
[[nodiscard]] Future<Void> updateProfiler( bool const& enabled, Database const& cx, CpuProfilerWorkload* const& self ) {
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	return Future<Void>(new UpdateProfilerActor(enabled, cx, self));
															#line 491 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
}

#line 100 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"

	Future<Void> start(Database const& cx) override { return _start(cx, this); }

																#line 498 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
// This generated class is to be used only via _start()
															#line 103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
template <class _startActor>
															#line 103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
class _startActorState {
															#line 504 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
public:
															#line 103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	_startActorState(Database const& cx,CpuProfilerWorkload* const& self) 
															#line 103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
															#line 103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		 : cx(cx),
															#line 103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		   self(self)
															#line 513 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 104 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->initialDelay);
															#line 104 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 530 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 104 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 535 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 105 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (self->clientId == 0)
															#line 558 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		{
															#line 106 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			TraceEvent("SignalProfilerOn").log();
															#line 562 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		}
															#line 107 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		StrictFuture<Void> __when_expr_1 = timeoutError(self->updateProfiler(true, cx, self), 60.0);
															#line 107 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 568 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 107 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 573 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 105 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (self->clientId == 0)
															#line 582 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		{
															#line 106 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			TraceEvent("SignalProfilerOn").log();
															#line 586 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		}
															#line 107 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		StrictFuture<Void> __when_expr_1 = timeoutError(self->updateProfiler(true, cx, self), 60.0);
															#line 107 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 592 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 107 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 597 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 110 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (self->duration > 0)
															#line 681 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		{
															#line 111 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(self->duration);
															#line 111 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 687 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 111 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 692 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 110 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (self->duration > 0)
															#line 706 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		{
															#line 111 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(self->duration);
															#line 111 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 712 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 111 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 717 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 117 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 806 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 112 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (self->clientId == 0)
															#line 818 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		{
															#line 113 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			TraceEvent("SignalProfilerOff").log();
															#line 822 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		}
															#line 114 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		StrictFuture<Void> __when_expr_3 = timeoutError(self->updateProfiler(false, cx, self), 60.0);
															#line 114 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 828 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 114 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 833 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 112 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (self->clientId == 0)
															#line 842 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		{
															#line 113 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			TraceEvent("SignalProfilerOff").log();
															#line 846 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		}
															#line 114 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		StrictFuture<Void> __when_expr_3 = timeoutError(self->updateProfiler(false, cx, self), 60.0);
															#line 114 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 852 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 114 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 857 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	Database cx;
															#line 103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	CpuProfilerWorkload* self;
															#line 1028 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _start()
															#line 103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 1033 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17491758462667189504UL, 873132442764622080UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
															#line 103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	_startActor(Database const& cx,CpuProfilerWorkload* const& self) 
															#line 1053 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, CpuProfilerWorkload* const& self ) {
															#line 103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 1088 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
}

#line 119 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"

	Future<bool> check(Database const& cx) override { return _check(cx, this); }

																#line 1095 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
// This generated class is to be used only via _check()
															#line 122 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
template <class _checkActor>
															#line 122 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
class _checkActorState {
															#line 1101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
public:
															#line 122 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	_checkActorState(Database const& cx,CpuProfilerWorkload* const& self) 
															#line 122 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
															#line 122 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		 : cx(cx),
															#line 122 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		   self(self)
															#line 1110 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("_check", reinterpret_cast<unsigned long>(this));

	}
	~_checkActorState() 
	{
		fdb_probe_actor_destroy("_check", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 124 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
			if (self->duration <= 0)
															#line 1125 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
			{
															#line 125 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
				if (self->clientId == 0)
															#line 1129 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
				{
															#line 126 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
					TraceEvent("SignalProfilerOff").log();
															#line 1133 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
				}
															#line 127 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
				StrictFuture<Void> __when_expr_0 = timeoutError(self->updateProfiler(false, cx, self), 60.0);
															#line 127 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
				if (static_cast<_checkActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1139 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<_checkActor*>(this)->actor_wait_state = 1;
															#line 127 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _checkActor, 0, Void >*>(static_cast<_checkActor*>(this)));
															#line 1144 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 130 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
		if (!static_cast<_checkActor*>(this)->SAV<bool>::futures) { (void)(self->success); this->~_checkActorState(); static_cast<_checkActor*>(this)->destroy(); return 0; }
															#line 1172 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		new (&static_cast<_checkActor*>(this)->SAV< bool >::value()) bool(self->success);
		this->~_checkActorState();
		static_cast<_checkActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_checkActor*>(this)->actor_wait_state > 0) static_cast<_checkActor*>(this)->actor_wait_state = 0;
		static_cast<_checkActor*>(this)->ActorCallback< _checkActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _checkActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _checkActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 122 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	Database cx;
															#line 122 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	CpuProfilerWorkload* self;
															#line 1271 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
};
// This generated class is to be used only via _check()
															#line 122 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
class _checkActor final : public Actor<bool>, public ActorCallback< _checkActor, 0, Void >, public FastAllocated<_checkActor>, public _checkActorState<_checkActor> {
															#line 1276 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
public:
	using FastAllocated<_checkActor>::operator new;
	using FastAllocated<_checkActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14512218794962135552UL, 15899979464742444288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _checkActor, 0, Void >;
															#line 122 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	_checkActor(Database const& cx,CpuProfilerWorkload* const& self) 
															#line 1293 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   _checkActorState<_checkActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_check", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(18414574916690025728UL, 14115196402046968064UL);
		ActorExecutionContextHelper __helper(static_cast<_checkActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_check");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_check", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _checkActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 122 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
[[nodiscard]] Future<bool> _check( Database const& cx, CpuProfilerWorkload* const& self ) {
															#line 122 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"
	return Future<bool>(new _checkActor(cx, self));
															#line 1325 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/CpuProfiler.actor.g.cpp.py_gen"
}

#line 132 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/workloads/CpuProfiler.actor.cpp"

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<CpuProfilerWorkload> CpuProfilerWorkloadFactory;
