#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
/*
 * RestoreController.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This file implements the functions for RestoreController role

#include "fdbrpc/RangeMap.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/SystemData.h"
#include "fdbclient/BackupAgent.actor.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/MutationList.h"
#include "fdbclient/BackupContainer.h"
#include "fdbserver/RestoreUtil.h"
#include "fdbserver/RestoreCommon.actor.h"
#include "fdbserver/RestoreRoleCommon.actor.h"
#include "fdbserver/RestoreController.actor.h"
#include "fdbserver/RestoreApplier.actor.h"
#include "fdbserver/RestoreLoader.actor.h"

#include "flow/Platform.h"
#include "flow/actorcompiler.h" // This must be the last #include.

// TODO: Support [[maybe_unused]] attribute for actors
// ACTOR static Future<Void> clearDB(Database cx);
															#line 44 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Version> collectBackupFiles( Reference<IBackupContainer> const& bc, std::vector<RestoreFileFR>* const& rangeFiles, std::vector<RestoreFileFR>* const& logFiles, Version* const& minRangeVersion, Database const& cx, RestoreRequest const& request );

#line 48 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 48 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> buildRangeVersions( KeyRangeMap<Version>* const& pRangeVersions, std::vector<RestoreFileFR>* const& pRangeFiles, Key const& url, Optional<std::string> const& proxy, Database const& cx );

#line 53 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

															#line 53 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Version> processRestoreRequest( Reference<RestoreControllerData> const& self, Database const& cx, RestoreRequest const& request );

#line 57 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 57 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> startProcessRestoreRequests( Reference<RestoreControllerData> const& self, Database const& cx );

#line 58 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 61 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> distributeWorkloadPerVersionBatch( Reference<RestoreControllerData> const& self, int const& batchIndex, Database const& cx, RestoreRequest const& request, VersionBatch const& versionBatch );

#line 63 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

															#line 66 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> recruitRestoreRoles( Reference<RestoreWorkerData> const& controllerWorker, Reference<RestoreControllerData> const& controllerData );

#line 66 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 70 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> distributeRestoreSysInfo( Reference<RestoreControllerData> const& controllerData, KeyRangeMap<Version>* const& pRangeVersions );

#line 68 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

															#line 75 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
[[nodiscard]] static Future<std::vector<RestoreRequest>> collectRestoreRequests( Database const& cx );

#line 70 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 79 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> initializeVersionBatch( std::map<UID, RestoreApplierInterface> const& appliersInterf, std::map<UID, RestoreLoaderInterface> const& loadersInterf, int const& batchIndex );

#line 73 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 83 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> notifyApplierToApplyMutations( Reference<ControllerBatchData> const& batchData, Reference<ControllerBatchStatus> const& batchStatus, std::map<UID, RestoreApplierInterface> const& appliersInterf, int const& batchIndex, NotifiedVersion* const& finishedBatch );

#line 78 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 87 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> notifyLoadersVersionBatchFinished( std::map<UID, RestoreLoaderInterface> const& loadersInterf, int const& batchIndex );

#line 80 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 91 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> notifyRestoreCompleted( Reference<RestoreControllerData> const& self, bool const& terminate );

#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 95 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> signalRestoreCompleted( Reference<RestoreControllerData> const& self, Database const& cx );

#line 82 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
// TODO: Support [[maybe_unused]] attribute for actors
// ACTOR static Future<Void> updateHeartbeatTime(Reference<RestoreControllerData> self);
															#line 101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
[[nodiscard]] static Future<Void> checkRolesLiveness( Reference<RestoreControllerData> const& self );

#line 85 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

void splitKeyRangeForAppliers(Reference<ControllerBatchData> batchData,
                              std::map<UID, RestoreApplierInterface> appliersInterf,
                              int batchIndex);

															#line 110 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via sampleBackups()
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class SampleBackupsActor>
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class SampleBackupsActorState {
															#line 117 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	SampleBackupsActorState(Reference<RestoreControllerData> const& self,RestoreControllerInterface const& ci) 
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : self(self),
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   ci(ci)
															#line 126 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("sampleBackups", reinterpret_cast<unsigned long>(this));

	}
	~SampleBackupsActorState() 
	{
		fdb_probe_actor_destroy("sampleBackups", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 91 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			;
															#line 141 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SampleBackupsActorState();
		static_cast<SampleBackupsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<SampleBackupsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SampleBackupsActorState(); static_cast<SampleBackupsActor*>(this)->destroy(); return 0; }
															#line 164 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<SampleBackupsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SampleBackupsActorState();
		static_cast<SampleBackupsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 93 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			auto __when_expr_0 = ci.samples.getFuture();
															#line 184 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			static_assert(std::is_same<decltype(__when_expr_0), FutureStream<RestoreSamplesRequest>>::value || std::is_same<decltype(__when_expr_0), ThreadFutureStream<RestoreSamplesRequest>>::value, "invalid type");
															#line 93 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<SampleBackupsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 188 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.pop(), loopDepth); };
			static_cast<SampleBackupsActor*>(this)->actor_wait_state = 1;
															#line 93 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorSingleCallback< SampleBackupsActor, 0, RestoreSamplesRequest >*>(static_cast<SampleBackupsActor*>(this)));
															#line 193 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 113 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent(SevWarn, "FastRestoreControllerSampleBackupsError", self->id()).error(e);
															#line 228 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RestoreSamplesRequest const& req,int loopDepth) 
	{
															#line 94 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent(SevDebug, "FastRestoreControllerSampleBackups") .detail("SampleID", req.id) .detail("BatchIndex", req.batchIndex) .detail("Samples", req.samples.size());
															#line 98 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(req.batchIndex <= self->batch.size());
															#line 100 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		Reference<ControllerBatchData> batch = self->batch[req.batchIndex];
															#line 101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(batch.isValid());
															#line 102 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (batch->sampleMsgs.find(req.id) != batch->sampleMsgs.end())
															#line 251 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			req.reply.send(RestoreCommonReply(req.id));
															#line 255 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 106 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		batch->sampleMsgs.insert(req.id);
															#line 107 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& m : req.samples ) {
															#line 108 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			batch->samples.addMetric(m.key, m.size);
															#line 109 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			batch->samplesSize += m.size;
															#line 266 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 111 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		req.reply.send(RestoreCommonReply(req.id));
															#line 270 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2(RestoreSamplesRequest && req,int loopDepth) 
	{
															#line 94 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent(SevDebug, "FastRestoreControllerSampleBackups") .detail("SampleID", req.id) .detail("BatchIndex", req.batchIndex) .detail("Samples", req.samples.size());
															#line 98 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(req.batchIndex <= self->batch.size());
															#line 100 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		Reference<ControllerBatchData> batch = self->batch[req.batchIndex];
															#line 101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(batch.isValid());
															#line 102 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (batch->sampleMsgs.find(req.id) != batch->sampleMsgs.end())
															#line 287 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			req.reply.send(RestoreCommonReply(req.id));
															#line 291 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			return a_body1loopHead1(loopDepth); // continue
		}
															#line 106 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		batch->sampleMsgs.insert(req.id);
															#line 107 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& m : req.samples ) {
															#line 108 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			batch->samples.addMetric(m.key, m.size);
															#line 109 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			batch->samplesSize += m.size;
															#line 302 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 111 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		req.reply.send(RestoreCommonReply(req.id));
															#line 306 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont6(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RestoreSamplesRequest const& req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(req, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RestoreSamplesRequest && req,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(req), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SampleBackupsActor*>(this)->actor_wait_state > 0) static_cast<SampleBackupsActor*>(this)->actor_wait_state = 0;
		static_cast<SampleBackupsActor*>(this)->ActorSingleCallback< SampleBackupsActor, 0, RestoreSamplesRequest >::remove();

	}
	void a_callback_fire(ActorSingleCallback< SampleBackupsActor, 0, RestoreSamplesRequest >*,RestoreSamplesRequest const& value) 
	{
		fdb_probe_actor_enter("sampleBackups", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SampleBackupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sampleBackups", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorSingleCallback< SampleBackupsActor, 0, RestoreSamplesRequest >*,RestoreSamplesRequest && value) 
	{
		fdb_probe_actor_enter("sampleBackups", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SampleBackupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sampleBackups", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorSingleCallback< SampleBackupsActor, 0, RestoreSamplesRequest >*,Error err) 
	{
		fdb_probe_actor_enter("sampleBackups", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SampleBackupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sampleBackups", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont6(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<RestoreControllerData> self;
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	RestoreControllerInterface ci;
															#line 403 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via sampleBackups()
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class SampleBackupsActor final : public Actor<Void>, public ActorSingleCallback< SampleBackupsActor, 0, RestoreSamplesRequest >, public FastAllocated<SampleBackupsActor>, public SampleBackupsActorState<SampleBackupsActor> {
															#line 408 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<SampleBackupsActor>::operator new;
	using FastAllocated<SampleBackupsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10544393171881402624UL, 4794003576437598464UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorSingleCallback< SampleBackupsActor, 0, RestoreSamplesRequest >;
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	SampleBackupsActor(Reference<RestoreControllerData> const& self,RestoreControllerInterface const& ci) 
															#line 425 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SampleBackupsActorState<SampleBackupsActor>(self, ci),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sampleBackups", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(148526607085550336UL, 5122416263057473536UL);
		ActorExecutionContextHelper __helper(static_cast<SampleBackupsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sampleBackups");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sampleBackups", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorSingleCallback< SampleBackupsActor, 0, RestoreSamplesRequest >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] Future<Void> sampleBackups( Reference<RestoreControllerData> const& self, RestoreControllerInterface const& ci ) {
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new SampleBackupsActor(self, ci));
															#line 458 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 120 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

															#line 463 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via startRestoreController()
															#line 121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class StartRestoreControllerActor>
															#line 121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class StartRestoreControllerActorState {
															#line 470 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	StartRestoreControllerActorState(Reference<RestoreWorkerData> const& controllerWorker,Database const& cx) 
															#line 121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : controllerWorker(controllerWorker),
															#line 121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   cx(cx)
															#line 479 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("startRestoreController", reinterpret_cast<unsigned long>(this));

	}
	~StartRestoreControllerActorState() 
	{
		fdb_probe_actor_destroy("startRestoreController", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 122 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ASSERT(controllerWorker.isValid());
															#line 123 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ASSERT(controllerWorker->controllerInterf.present());
															#line 124 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			self = makeReference<RestoreControllerData>(controllerWorker->controllerInterf.get().id());
															#line 126 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			error = actorCollection(self->addActor.getFuture());
															#line 500 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			try {
															#line 130 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = recruitRestoreRoles(controllerWorker, self);
															#line 130 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (static_cast<StartRestoreControllerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 506 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<StartRestoreControllerActor*>(this)->actor_wait_state = 1;
															#line 130 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartRestoreControllerActor, 0, Void >*>(static_cast<StartRestoreControllerActor*>(this)));
															#line 511 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartRestoreControllerActorState();
		static_cast<StartRestoreControllerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 145 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<StartRestoreControllerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartRestoreControllerActorState(); static_cast<StartRestoreControllerActor*>(this)->destroy(); return 0; }
															#line 540 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<StartRestoreControllerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartRestoreControllerActorState();
		static_cast<StartRestoreControllerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 140 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (e.code() != error_code_operation_cancelled)
															#line 553 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 141 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevError, "FastRestoreControllerStart").error(e).detail("Reason", "Unexpected unhandled error");
															#line 557 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 133 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->addActor.send(checkRolesLiveness(self));
															#line 134 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->addActor.send(updateProcessMetrics(self));
															#line 135 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->addActor.send(traceProcessMetrics(self, "RestoreController"));
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->addActor.send(sampleBackups(self, controllerWorker->controllerInterf.get()));
															#line 138 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = startProcessRestoreRequests(self, cx) || error;
															#line 138 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<StartRestoreControllerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 583 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartRestoreControllerActor*>(this)->actor_wait_state = 2;
															#line 138 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartRestoreControllerActor, 1, Void >*>(static_cast<StartRestoreControllerActor*>(this)));
															#line 588 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 133 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->addActor.send(checkRolesLiveness(self));
															#line 134 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->addActor.send(updateProcessMetrics(self));
															#line 135 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->addActor.send(traceProcessMetrics(self, "RestoreController"));
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->addActor.send(sampleBackups(self, controllerWorker->controllerInterf.get()));
															#line 138 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = startProcessRestoreRequests(self, cx) || error;
															#line 138 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<StartRestoreControllerActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 607 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartRestoreControllerActor*>(this)->actor_wait_state = 2;
															#line 138 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartRestoreControllerActor, 1, Void >*>(static_cast<StartRestoreControllerActor*>(this)));
															#line 612 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartRestoreControllerActor*>(this)->actor_wait_state > 0) static_cast<StartRestoreControllerActor*>(this)->actor_wait_state = 0;
		static_cast<StartRestoreControllerActor*>(this)->ActorCallback< StartRestoreControllerActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRestoreControllerActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRestoreController", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreController", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartRestoreControllerActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRestoreController", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreController", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartRestoreControllerActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreController", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreController", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartRestoreControllerActor*>(this)->actor_wait_state > 0) static_cast<StartRestoreControllerActor*>(this)->actor_wait_state = 0;
		static_cast<StartRestoreControllerActor*>(this)->ActorCallback< StartRestoreControllerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartRestoreControllerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startRestoreController", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreController", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartRestoreControllerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startRestoreController", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreController", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartRestoreControllerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startRestoreController", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startRestoreController", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<RestoreWorkerData> controllerWorker;
															#line 121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Database cx;
															#line 124 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<RestoreControllerData> self;
															#line 126 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Future<Void> error;
															#line 800 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via startRestoreController()
															#line 121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class StartRestoreControllerActor final : public Actor<Void>, public ActorCallback< StartRestoreControllerActor, 0, Void >, public ActorCallback< StartRestoreControllerActor, 1, Void >, public FastAllocated<StartRestoreControllerActor>, public StartRestoreControllerActorState<StartRestoreControllerActor> {
															#line 805 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<StartRestoreControllerActor>::operator new;
	using FastAllocated<StartRestoreControllerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11298573500890971392UL, 16993234006016370432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartRestoreControllerActor, 0, Void >;
friend struct ActorCallback< StartRestoreControllerActor, 1, Void >;
															#line 121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	StartRestoreControllerActor(Reference<RestoreWorkerData> const& controllerWorker,Database const& cx) 
															#line 823 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StartRestoreControllerActorState<StartRestoreControllerActor>(controllerWorker, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startRestoreController", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8998312990648762112UL, 7490788563203841024UL);
		ActorExecutionContextHelper __helper(static_cast<StartRestoreControllerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startRestoreController");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startRestoreController", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartRestoreControllerActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartRestoreControllerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] Future<Void> startRestoreController( Reference<RestoreWorkerData> const& controllerWorker, Database const& cx ) {
															#line 121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new StartRestoreControllerActor(controllerWorker, cx));
															#line 857 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 147 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

// RestoreWorker that has restore controller role: Recruite a role for each worker
															#line 863 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via recruitRestoreRoles()
															#line 149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class RecruitRestoreRolesActor>
															#line 149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class RecruitRestoreRolesActorState {
															#line 870 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	RecruitRestoreRolesActorState(Reference<RestoreWorkerData> const& controllerWorker,Reference<RestoreControllerData> const& controllerData) 
															#line 149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : controllerWorker(controllerWorker),
															#line 149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   controllerData(controllerData),
															#line 151 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   nodeIndex(0),
															#line 152 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   role(RestoreRole::Invalid)
															#line 883 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("recruitRestoreRoles", reinterpret_cast<unsigned long>(this));

	}
	~RecruitRestoreRolesActorState() 
	{
		fdb_probe_actor_destroy("recruitRestoreRoles", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 154 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent("FastRestoreController", controllerData->id()) .detail("RecruitRestoreRoles", controllerWorker->workerInterfaces.size()) .detail("NumLoaders", SERVER_KNOBS->FASTRESTORE_NUM_LOADERS) .detail("NumAppliers", SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS);
															#line 158 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ASSERT(controllerData->loadersInterf.empty() && controllerData->appliersInterf.empty());
															#line 159 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ASSERT(controllerWorker->controllerInterf.present());
															#line 161 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ASSERT(controllerData.isValid());
															#line 162 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ASSERT(SERVER_KNOBS->FASTRESTORE_NUM_LOADERS > 0 && SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS > 0);
															#line 164 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ASSERT(SERVER_KNOBS->FASTRESTORE_NUM_LOADERS + SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS <= controllerWorker->workerInterfaces.size());
															#line 168 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			std::vector<std::pair<UID, RestoreRecruitRoleRequest>> requests;
															#line 169 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( auto& workerInterf : controllerWorker->workerInterfaces ) {
															#line 170 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (nodeIndex >= 0 && nodeIndex < SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS)
															#line 914 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				{
															#line 172 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					role = RestoreRole::Applier;
															#line 918 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 173 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					if (nodeIndex >= SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS && nodeIndex < SERVER_KNOBS->FASTRESTORE_NUM_LOADERS + SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS)
															#line 924 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
					{
															#line 176 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
						role = RestoreRole::Loader;
															#line 928 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
					}
					else
					{
						break;
					}
				}
															#line 181 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent("FastRestoreController", controllerData->id()) .detail("WorkerNode", workerInterf.first) .detail("NodeRole", role) .detail("NodeIndex", nodeIndex);
															#line 185 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				requests.emplace_back(workerInterf.first, RestoreRecruitRoleRequest(controllerWorker->controllerInterf.get(), role, nodeIndex));
															#line 187 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				nodeIndex++;
															#line 941 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 190 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			replies = std::vector<RestoreRecruitRoleReply>();
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = getBatchReplies(&RestoreWorkerInterface::recruitRole, controllerWorker->workerInterfaces, requests, &replies);
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<RecruitRestoreRolesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 949 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<RecruitRestoreRolesActor*>(this)->actor_wait_state = 1;
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< RecruitRestoreRolesActor, 0, Void >*>(static_cast<RecruitRestoreRolesActor*>(this)));
															#line 954 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~RecruitRestoreRolesActorState();
		static_cast<RecruitRestoreRolesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 192 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& reply : replies ) {
															#line 193 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (reply.role == RestoreRole::Applier)
															#line 979 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 194 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				ASSERT_WE_THINK(reply.applier.present());
															#line 195 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				controllerData->appliersInterf[reply.applier.get().id()] = reply.applier.get();
															#line 985 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 196 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (reply.role == RestoreRole::Loader)
															#line 991 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				{
															#line 197 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					ASSERT_WE_THINK(reply.loader.present());
															#line 198 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					controllerData->loadersInterf[reply.loader.get().id()] = reply.loader.get();
															#line 997 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 200 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					TraceEvent(SevError, "FastRestoreController").detail("RecruitRestoreRolesInvalidRole", reply.role);
															#line 1003 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				}
			}
		}
															#line 203 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		controllerData->recruitedRoles.send(Void());
															#line 204 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreRecruitRestoreRolesDone", controllerData->id()) .detail("Workers", controllerWorker->workerInterfaces.size()) .detail("RecruitedRoles", replies.size());
															#line 208 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<RecruitRestoreRolesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitRestoreRolesActorState(); static_cast<RecruitRestoreRolesActor*>(this)->destroy(); return 0; }
															#line 1013 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<RecruitRestoreRolesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecruitRestoreRolesActorState();
		static_cast<RecruitRestoreRolesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 192 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& reply : replies ) {
															#line 193 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (reply.role == RestoreRole::Applier)
															#line 1027 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 194 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				ASSERT_WE_THINK(reply.applier.present());
															#line 195 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				controllerData->appliersInterf[reply.applier.get().id()] = reply.applier.get();
															#line 1033 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 196 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (reply.role == RestoreRole::Loader)
															#line 1039 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				{
															#line 197 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					ASSERT_WE_THINK(reply.loader.present());
															#line 198 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					controllerData->loadersInterf[reply.loader.get().id()] = reply.loader.get();
															#line 1045 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 200 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					TraceEvent(SevError, "FastRestoreController").detail("RecruitRestoreRolesInvalidRole", reply.role);
															#line 1051 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				}
			}
		}
															#line 203 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		controllerData->recruitedRoles.send(Void());
															#line 204 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreRecruitRestoreRolesDone", controllerData->id()) .detail("Workers", controllerWorker->workerInterfaces.size()) .detail("RecruitedRoles", replies.size());
															#line 208 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<RecruitRestoreRolesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~RecruitRestoreRolesActorState(); static_cast<RecruitRestoreRolesActor*>(this)->destroy(); return 0; }
															#line 1061 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<RecruitRestoreRolesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~RecruitRestoreRolesActorState();
		static_cast<RecruitRestoreRolesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<RecruitRestoreRolesActor*>(this)->actor_wait_state > 0) static_cast<RecruitRestoreRolesActor*>(this)->actor_wait_state = 0;
		static_cast<RecruitRestoreRolesActor*>(this)->ActorCallback< RecruitRestoreRolesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< RecruitRestoreRolesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("recruitRestoreRoles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitRestoreRolesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitRestoreRoles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< RecruitRestoreRolesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("recruitRestoreRoles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitRestoreRolesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitRestoreRoles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< RecruitRestoreRolesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("recruitRestoreRoles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitRestoreRolesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("recruitRestoreRoles", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<RestoreWorkerData> controllerWorker;
															#line 149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<RestoreControllerData> controllerData;
															#line 151 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	int nodeIndex;
															#line 152 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	RestoreRole role;
															#line 190 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<RestoreRecruitRoleReply> replies;
															#line 1154 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via recruitRestoreRoles()
															#line 149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class RecruitRestoreRolesActor final : public Actor<Void>, public ActorCallback< RecruitRestoreRolesActor, 0, Void >, public FastAllocated<RecruitRestoreRolesActor>, public RecruitRestoreRolesActorState<RecruitRestoreRolesActor> {
															#line 1159 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<RecruitRestoreRolesActor>::operator new;
	using FastAllocated<RecruitRestoreRolesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(15911675678680076544UL, 10137347408458395648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< RecruitRestoreRolesActor, 0, Void >;
															#line 149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	RecruitRestoreRolesActor(Reference<RestoreWorkerData> const& controllerWorker,Reference<RestoreControllerData> const& controllerData) 
															#line 1176 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   RecruitRestoreRolesActorState<RecruitRestoreRolesActor>(controllerWorker, controllerData),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("recruitRestoreRoles", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13976194847769832192UL, 4054108294052434432UL);
		ActorExecutionContextHelper __helper(static_cast<RecruitRestoreRolesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("recruitRestoreRoles");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("recruitRestoreRoles", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< RecruitRestoreRolesActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] Future<Void> recruitRestoreRoles( Reference<RestoreWorkerData> const& controllerWorker, Reference<RestoreControllerData> const& controllerData ) {
															#line 149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new RecruitRestoreRolesActor(controllerWorker, controllerData));
															#line 1209 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 210 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

															#line 1214 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via distributeRestoreSysInfo()
															#line 211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class DistributeRestoreSysInfoActor>
															#line 211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class DistributeRestoreSysInfoActorState {
															#line 1221 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	DistributeRestoreSysInfoActorState(Reference<RestoreControllerData> const& controllerData,KeyRangeMap<Version>* const& pRangeVersions) 
															#line 211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : controllerData(controllerData),
															#line 211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   pRangeVersions(pRangeVersions)
															#line 1230 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("distributeRestoreSysInfo", reinterpret_cast<unsigned long>(this));

	}
	~DistributeRestoreSysInfoActorState() 
	{
		fdb_probe_actor_destroy("distributeRestoreSysInfo", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 213 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ASSERT(controllerData.isValid());
															#line 214 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ASSERT(!controllerData->loadersInterf.empty());
															#line 215 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			RestoreSysInfo sysInfo(controllerData->appliersInterf);
															#line 217 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			Standalone<VectorRef<std::pair<KeyRangeRef, Version>>> rangeVersionsVec;
															#line 218 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			auto ranges = pRangeVersions->ranges();
															#line 219 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			int i = 0;
															#line 220 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for(auto r = ranges.begin();r != ranges.end();++r) {
															#line 221 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				rangeVersionsVec.push_back(rangeVersionsVec.arena(), std::make_pair(KeyRangeRef(r->begin(), r->end()), r->value()));
															#line 223 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent("DistributeRangeVersions") .detail("RangeIndex", i++) .detail("RangeBegin", r->begin()) .detail("RangeEnd", r->end()) .detail("RangeVersion", r->value());
															#line 1261 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 229 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			std::vector<std::pair<UID, RestoreSysInfoRequest>> requests;
															#line 230 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( auto& loader : controllerData->loadersInterf ) {
															#line 231 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				requests.emplace_back(loader.first, RestoreSysInfoRequest(sysInfo, rangeVersionsVec));
															#line 1269 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 234 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent("FastRestoreDistributeRestoreSysInfoToLoaders", controllerData->id()) .detail("Loaders", controllerData->loadersInterf.size());
															#line 236 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = sendBatchRequests(&RestoreLoaderInterface::updateRestoreSysInfo, controllerData->loadersInterf, requests);
															#line 236 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<DistributeRestoreSysInfoActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1277 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DistributeRestoreSysInfoActor*>(this)->actor_wait_state = 1;
															#line 236 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DistributeRestoreSysInfoActor, 0, Void >*>(static_cast<DistributeRestoreSysInfoActor*>(this)));
															#line 1282 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DistributeRestoreSysInfoActorState();
		static_cast<DistributeRestoreSysInfoActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 237 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreDistributeRestoreSysInfoToLoadersDone", controllerData->id()) .detail("Loaders", controllerData->loadersInterf.size());
															#line 240 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<DistributeRestoreSysInfoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DistributeRestoreSysInfoActorState(); static_cast<DistributeRestoreSysInfoActor*>(this)->destroy(); return 0; }
															#line 1307 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<DistributeRestoreSysInfoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DistributeRestoreSysInfoActorState();
		static_cast<DistributeRestoreSysInfoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 237 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreDistributeRestoreSysInfoToLoadersDone", controllerData->id()) .detail("Loaders", controllerData->loadersInterf.size());
															#line 240 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<DistributeRestoreSysInfoActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DistributeRestoreSysInfoActorState(); static_cast<DistributeRestoreSysInfoActor*>(this)->destroy(); return 0; }
															#line 1321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<DistributeRestoreSysInfoActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DistributeRestoreSysInfoActorState();
		static_cast<DistributeRestoreSysInfoActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DistributeRestoreSysInfoActor*>(this)->actor_wait_state > 0) static_cast<DistributeRestoreSysInfoActor*>(this)->actor_wait_state = 0;
		static_cast<DistributeRestoreSysInfoActor*>(this)->ActorCallback< DistributeRestoreSysInfoActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DistributeRestoreSysInfoActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("distributeRestoreSysInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeRestoreSysInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeRestoreSysInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DistributeRestoreSysInfoActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("distributeRestoreSysInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeRestoreSysInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeRestoreSysInfo", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DistributeRestoreSysInfoActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("distributeRestoreSysInfo", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeRestoreSysInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeRestoreSysInfo", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<RestoreControllerData> controllerData;
															#line 211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	KeyRangeMap<Version>* pRangeVersions;
															#line 1408 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via distributeRestoreSysInfo()
															#line 211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class DistributeRestoreSysInfoActor final : public Actor<Void>, public ActorCallback< DistributeRestoreSysInfoActor, 0, Void >, public FastAllocated<DistributeRestoreSysInfoActor>, public DistributeRestoreSysInfoActorState<DistributeRestoreSysInfoActor> {
															#line 1413 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<DistributeRestoreSysInfoActor>::operator new;
	using FastAllocated<DistributeRestoreSysInfoActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14698977565656912640UL, 3304526490373018368UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DistributeRestoreSysInfoActor, 0, Void >;
															#line 211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	DistributeRestoreSysInfoActor(Reference<RestoreControllerData> const& controllerData,KeyRangeMap<Version>* const& pRangeVersions) 
															#line 1430 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DistributeRestoreSysInfoActorState<DistributeRestoreSysInfoActor>(controllerData, pRangeVersions),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("distributeRestoreSysInfo", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11643194572954517248UL, 12080161115094183680UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeRestoreSysInfoActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("distributeRestoreSysInfo");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("distributeRestoreSysInfo", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DistributeRestoreSysInfoActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] Future<Void> distributeRestoreSysInfo( Reference<RestoreControllerData> const& controllerData, KeyRangeMap<Version>* const& pRangeVersions ) {
															#line 211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new DistributeRestoreSysInfoActor(controllerData, pRangeVersions));
															#line 1463 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 242 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

// The server of the restore controller. It drives the restore progress with the following steps:
// 1) Lock database and clear the normal keyspace
// 2) Wait on each RestoreRequest, which is sent by RestoreTool operated by DBA
// 3) Process each restore request in actor processRestoreRequest;
// 3.1) Sample workload to decide the key range for each applier, which is implemented as a dummy sampling;
// 3.2) Send each loader the map of key-range to applier interface;
// 3.3) Construct requests of which file should be loaded by which loader, and send requests to loaders;
// 4) After process all restore requests, finish restore by cleaning up the restore related system key
//    and ask all restore roles to quit.
															#line 1477 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via startProcessRestoreRequests()
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class StartProcessRestoreRequestsActor>
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class StartProcessRestoreRequestsActorState {
															#line 1484 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	StartProcessRestoreRequestsActorState(Reference<RestoreControllerData> const& self,Database const& cx) 
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : self(self),
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   cx(cx)
															#line 1493 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this));

	}
	~StartProcessRestoreRequestsActorState() 
	{
		fdb_probe_actor_destroy("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 253 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<std::vector<RestoreRequest>> __when_expr_0 = collectRestoreRequests(cx);
															#line 253 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1510 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state = 1;
															#line 253 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< StartProcessRestoreRequestsActor, 0, std::vector<RestoreRequest> >*>(static_cast<StartProcessRestoreRequestsActor*>(this)));
															#line 1515 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~StartProcessRestoreRequestsActorState();
		static_cast<StartProcessRestoreRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 254 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		restoreIndex = 0;
															#line 256 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerWaitOnRestoreRequests", self->id()) .detail("RestoreRequests", restoreRequests.size());
															#line 1540 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		try {
															#line 263 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			restoreIndex = 0;
															#line 1544 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(std::vector<RestoreRequest> const& __restoreRequests,int loopDepth) 
	{
															#line 253 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		restoreRequests = __restoreRequests;
															#line 1559 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(std::vector<RestoreRequest> && __restoreRequests,int loopDepth) 
	{
		restoreRequests = std::move(__restoreRequests);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<StartProcessRestoreRequestsActor*>(this)->ActorCallback< StartProcessRestoreRequestsActor, 0, std::vector<RestoreRequest> >::remove();

	}
	void a_callback_fire(ActorCallback< StartProcessRestoreRequestsActor, 0, std::vector<RestoreRequest> >*,std::vector<RestoreRequest> const& value) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< StartProcessRestoreRequestsActor, 0, std::vector<RestoreRequest> >*,std::vector<RestoreRequest> && value) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< StartProcessRestoreRequestsActor, 0, std::vector<RestoreRequest> >*,Error err) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 297 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_4 = signalRestoreCompleted(self, cx);
															#line 297 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1640 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont2when1(__when_expr_4.get(), loopDepth); };
		static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state = 5;
															#line 297 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< StartProcessRestoreRequestsActor, 4, Void >*>(static_cast<StartProcessRestoreRequestsActor*>(this)));
															#line 1645 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 284 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (restoreIndex < restoreRequests.size())
															#line 1655 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 285 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevError, "FastRestoreControllerProcessRestoreRequestsFailed", self->id()) .error(e) .detail("RestoreRequest", restoreRequests[restoreIndex].toString());
															#line 1659 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 289 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevError, "FastRestoreControllerProcessRestoreRequestsFailed", self->id()) .error(e) .detail("RestoreRequests", restoreRequests.size()) .detail("RestoreIndex", restoreIndex);
															#line 1665 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 263 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!(restoreIndex < restoreRequests.size()))
															#line 1694 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 264 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		request = restoreRequests[restoreIndex];
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		range = request.range.removePrefix(request.removePrefix).withPrefix(request.addPrefix);
															#line 266 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerProcessRestoreRequests", self->id()) .detail("RestoreRequestInfo", request.toString()) .detail("TransformedKeyRange", range);
															#line 270 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->resetPerRestoreRequest();
															#line 273 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = runRYWTransaction(cx, [=](Reference<ReadYourWritesTransaction> tr) -> Future<Void> { tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS); tr->setOption(FDBTransactionOptions::LOCK_AWARE); tr->clear(range); return Void(); });
															#line 273 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1710 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state = 2;
															#line 273 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< StartProcessRestoreRequestsActor, 1, Void >*>(static_cast<StartProcessRestoreRequestsActor*>(this)));
															#line 1715 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 280 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = success(processRestoreRequest(self, cx, request));
															#line 280 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1739 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state = 3;
															#line 280 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartProcessRestoreRequestsActor, 2, Void >*>(static_cast<StartProcessRestoreRequestsActor*>(this)));
															#line 1744 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 280 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = success(processRestoreRequest(self, cx, request));
															#line 280 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1755 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
		static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state = 3;
															#line 280 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< StartProcessRestoreRequestsActor, 2, Void >*>(static_cast<StartProcessRestoreRequestsActor*>(this)));
															#line 1760 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<StartProcessRestoreRequestsActor*>(this)->ActorCallback< StartProcessRestoreRequestsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartProcessRestoreRequestsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< StartProcessRestoreRequestsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< StartProcessRestoreRequestsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 281 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = notifyRestoreCompleted(self, false);
															#line 281 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1846 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state = 4;
															#line 281 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartProcessRestoreRequestsActor, 3, Void >*>(static_cast<StartProcessRestoreRequestsActor*>(this)));
															#line 1851 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 281 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = notifyRestoreCompleted(self, false);
															#line 281 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1862 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state = 4;
															#line 281 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< StartProcessRestoreRequestsActor, 3, Void >*>(static_cast<StartProcessRestoreRequestsActor*>(this)));
															#line 1867 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<StartProcessRestoreRequestsActor*>(this)->ActorCallback< StartProcessRestoreRequestsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartProcessRestoreRequestsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< StartProcessRestoreRequestsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< StartProcessRestoreRequestsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 263 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		restoreIndex++;
															#line 1951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 263 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		restoreIndex++;
															#line 1960 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<StartProcessRestoreRequestsActor*>(this)->ActorCallback< StartProcessRestoreRequestsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartProcessRestoreRequestsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< StartProcessRestoreRequestsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< StartProcessRestoreRequestsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 299 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerRestoreCompleted", self->id());
															#line 301 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<StartProcessRestoreRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartProcessRestoreRequestsActorState(); static_cast<StartProcessRestoreRequestsActor*>(this)->destroy(); return 0; }
															#line 2059 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<StartProcessRestoreRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartProcessRestoreRequestsActorState();
		static_cast<StartProcessRestoreRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 299 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerRestoreCompleted", self->id());
															#line 301 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<StartProcessRestoreRequestsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~StartProcessRestoreRequestsActorState(); static_cast<StartProcessRestoreRequestsActor*>(this)->destroy(); return 0; }
															#line 2073 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<StartProcessRestoreRequestsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~StartProcessRestoreRequestsActorState();
		static_cast<StartProcessRestoreRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<StartProcessRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<StartProcessRestoreRequestsActor*>(this)->ActorCallback< StartProcessRestoreRequestsActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< StartProcessRestoreRequestsActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< StartProcessRestoreRequestsActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< StartProcessRestoreRequestsActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<RestoreControllerData> self;
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Database cx;
															#line 253 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<RestoreRequest> restoreRequests;
															#line 254 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	int restoreIndex;
															#line 264 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	RestoreRequest request;
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	KeyRange range;
															#line 2168 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via startProcessRestoreRequests()
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class StartProcessRestoreRequestsActor final : public Actor<Void>, public ActorCallback< StartProcessRestoreRequestsActor, 0, std::vector<RestoreRequest> >, public ActorCallback< StartProcessRestoreRequestsActor, 1, Void >, public ActorCallback< StartProcessRestoreRequestsActor, 2, Void >, public ActorCallback< StartProcessRestoreRequestsActor, 3, Void >, public ActorCallback< StartProcessRestoreRequestsActor, 4, Void >, public FastAllocated<StartProcessRestoreRequestsActor>, public StartProcessRestoreRequestsActorState<StartProcessRestoreRequestsActor> {
															#line 2173 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<StartProcessRestoreRequestsActor>::operator new;
	using FastAllocated<StartProcessRestoreRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8242414011737075712UL, 3617325513454440192UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< StartProcessRestoreRequestsActor, 0, std::vector<RestoreRequest> >;
friend struct ActorCallback< StartProcessRestoreRequestsActor, 1, Void >;
friend struct ActorCallback< StartProcessRestoreRequestsActor, 2, Void >;
friend struct ActorCallback< StartProcessRestoreRequestsActor, 3, Void >;
friend struct ActorCallback< StartProcessRestoreRequestsActor, 4, Void >;
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	StartProcessRestoreRequestsActor(Reference<RestoreControllerData> const& self,Database const& cx) 
															#line 2194 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   StartProcessRestoreRequestsActorState<StartProcessRestoreRequestsActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9788967725029342976UL, 851628508547609856UL);
		ActorExecutionContextHelper __helper(static_cast<StartProcessRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("startProcessRestoreRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("startProcessRestoreRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< StartProcessRestoreRequestsActor, 0, std::vector<RestoreRequest> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< StartProcessRestoreRequestsActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< StartProcessRestoreRequestsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< StartProcessRestoreRequestsActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< StartProcessRestoreRequestsActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] Future<Void> startProcessRestoreRequests( Reference<RestoreControllerData> const& self, Database const& cx ) {
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new StartProcessRestoreRequestsActor(self, cx));
															#line 2231 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 303 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

															#line 2236 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via monitorFinishedVersion()
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class MonitorFinishedVersionActor>
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class MonitorFinishedVersionActorState {
															#line 2243 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	MonitorFinishedVersionActorState(Reference<RestoreControllerData> const& self,RestoreRequest const& request) 
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : self(self),
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   request(request)
															#line 2252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("monitorFinishedVersion", reinterpret_cast<unsigned long>(this));

	}
	~MonitorFinishedVersionActorState() 
	{
		fdb_probe_actor_destroy("monitorFinishedVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 305 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			;
															#line 2267 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~MonitorFinishedVersionActorState();
		static_cast<MonitorFinishedVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 306 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreMonitorFinishedVersion", self->id()) .detail("RestoreRequest", request.toString()) .detail("BatchIndex", self->finishedBatch.get());
															#line 309 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->FASTRESTORE_VB_MONITOR_DELAY);
															#line 309 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<MonitorFinishedVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2301 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<MonitorFinishedVersionActor*>(this)->actor_wait_state = 1;
															#line 309 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< MonitorFinishedVersionActor, 0, Void >*>(static_cast<MonitorFinishedVersionActor*>(this)));
															#line 2306 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<MonitorFinishedVersionActor*>(this)->actor_wait_state > 0) static_cast<MonitorFinishedVersionActor*>(this)->actor_wait_state = 0;
		static_cast<MonitorFinishedVersionActor*>(this)->ActorCallback< MonitorFinishedVersionActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< MonitorFinishedVersionActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("monitorFinishedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorFinishedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorFinishedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< MonitorFinishedVersionActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("monitorFinishedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorFinishedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorFinishedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< MonitorFinishedVersionActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("monitorFinishedVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorFinishedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("monitorFinishedVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<RestoreControllerData> self;
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	RestoreRequest request;
															#line 2402 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via monitorFinishedVersion()
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class MonitorFinishedVersionActor final : public Actor<Void>, public ActorCallback< MonitorFinishedVersionActor, 0, Void >, public FastAllocated<MonitorFinishedVersionActor>, public MonitorFinishedVersionActorState<MonitorFinishedVersionActor> {
															#line 2407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<MonitorFinishedVersionActor>::operator new;
	using FastAllocated<MonitorFinishedVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2595002870862865152UL, 2119078018235208704UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< MonitorFinishedVersionActor, 0, Void >;
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	MonitorFinishedVersionActor(Reference<RestoreControllerData> const& self,RestoreRequest const& request) 
															#line 2424 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   MonitorFinishedVersionActorState<MonitorFinishedVersionActor>(self, request),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("monitorFinishedVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3433461659947425024UL, 17308802768782099968UL);
		ActorExecutionContextHelper __helper(static_cast<MonitorFinishedVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("monitorFinishedVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("monitorFinishedVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< MonitorFinishedVersionActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Void> monitorFinishedVersion( Reference<RestoreControllerData> const& self, RestoreRequest const& request ) {
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new MonitorFinishedVersionActor(self, request));
															#line 2457 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 312 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

															#line 2462 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via processRestoreRequest()
															#line 313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class ProcessRestoreRequestActor>
															#line 313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class ProcessRestoreRequestActorState {
															#line 2469 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	ProcessRestoreRequestActorState(Reference<RestoreControllerData> const& self,Database const& cx,RestoreRequest const& request) 
															#line 313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : self(self),
															#line 313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   cx(cx),
															#line 313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   request(request),
															#line 316 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   rangeFiles(),
															#line 317 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   logFiles(),
															#line 318 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   allFiles(),
															#line 319 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   minRangeVersion(MAX_VERSION)
															#line 2488 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("processRestoreRequest", reinterpret_cast<unsigned long>(this));

	}
	~ProcessRestoreRequestActorState() 
	{
		fdb_probe_actor_destroy("processRestoreRequest", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			self->initBackupContainer(request.url, request.proxy);
															#line 324 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Version> __when_expr_0 = collectBackupFiles(self->bc, &rangeFiles, &logFiles, &minRangeVersion, cx, request);
															#line 324 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2507 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state = 1;
															#line 324 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ProcessRestoreRequestActor, 0, Version >*>(static_cast<ProcessRestoreRequestActor*>(this)));
															#line 2512 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ProcessRestoreRequestActorState();
		static_cast<ProcessRestoreRequestActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 326 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(targetVersion > 0);
															#line 327 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(minRangeVersion != MAX_VERSION);
															#line 329 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		std::sort(rangeFiles.begin(), rangeFiles.end());
															#line 330 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		std::sort(logFiles.begin(), logFiles.end(), [](RestoreFileFR const& f1, RestoreFileFR const& f2) -> bool { return std::tie(f1.endVersion, f1.beginVersion, f1.fileIndex, f1.fileName) < std::tie(f2.endVersion, f2.beginVersion, f2.fileIndex, f2.fileName); });
															#line 336 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		rangeVersions = KeyRangeMap<Version>(minRangeVersion, allKeys.end);
															#line 337 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (SERVER_KNOBS->FASTRESTORE_GET_RANGE_VERSIONS_EXPENSIVE)
															#line 2545 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 338 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = buildRangeVersions(&rangeVersions, &rangeFiles, request.url, request.proxy, cx);
															#line 338 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2551 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state = 2;
															#line 338 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ProcessRestoreRequestActor, 1, Void >*>(static_cast<ProcessRestoreRequestActor*>(this)));
															#line 2556 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 341 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			auto ranges = rangeVersions.ranges();
															#line 342 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			int i = 0;
															#line 343 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for(auto r = ranges.begin();r != ranges.end();++r) {
															#line 344 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevDebug, "SingleRangeVersion") .detail("RangeIndex", i++) .detail("RangeBegin", r->begin()) .detail("RangeEnd", r->end()) .detail("RangeVersion", r->value());
															#line 2569 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Version const& __targetVersion,int loopDepth) 
	{
															#line 324 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		targetVersion = __targetVersion;
															#line 2580 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Version && __targetVersion,int loopDepth) 
	{
		targetVersion = std::move(__targetVersion);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state > 0) static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessRestoreRequestActor*>(this)->ActorCallback< ProcessRestoreRequestActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessRestoreRequestActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ProcessRestoreRequestActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ProcessRestoreRequestActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 352 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = distributeRestoreSysInfo(self, &rangeVersions);
															#line 352 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2661 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state = 3;
															#line 352 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ProcessRestoreRequestActor, 2, Void >*>(static_cast<ProcessRestoreRequestActor*>(this)));
															#line 2666 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state > 0) static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessRestoreRequestActor*>(this)->ActorCallback< ProcessRestoreRequestActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessRestoreRequestActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ProcessRestoreRequestActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ProcessRestoreRequestActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 355 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->buildVersionBatches(rangeFiles, logFiles, &self->versionBatches, targetVersion);
															#line 356 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->dumpVersionBatches(self->versionBatches);
															#line 358 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		fBatches = std::vector<Future<Void>>();
															#line 359 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		versionBatches = std::vector<VersionBatch>();
															#line 360 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& vb : self->versionBatches ) {
															#line 361 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			versionBatches.push_back(vb.second);
															#line 2772 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 365 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		releaseVBOutOfOrder = g_network->isSimulated() ? deterministicRandom()->random01() < 0.5 : false;
															#line 366 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(g_network->isSimulated() || !releaseVBOutOfOrder);
															#line 367 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (releaseVBOutOfOrder)
															#line 2780 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 369 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			int permTimes = deterministicRandom()->randomInt(0, 100);
															#line 370 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for(;permTimes-- > 0;) {
															#line 371 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				std::next_permutation(versionBatches.begin(), versionBatches.end());
															#line 2788 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
		}
															#line 375 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->addActor.send(monitorFinishedVersion(self, request));
															#line 376 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		versionBatch = versionBatches.begin();
															#line 377 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		;
															#line 2797 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 355 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->buildVersionBatches(rangeFiles, logFiles, &self->versionBatches, targetVersion);
															#line 356 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->dumpVersionBatches(self->versionBatches);
															#line 358 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		fBatches = std::vector<Future<Void>>();
															#line 359 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		versionBatches = std::vector<VersionBatch>();
															#line 360 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& vb : self->versionBatches ) {
															#line 361 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			versionBatches.push_back(vb.second);
															#line 2816 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 365 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		releaseVBOutOfOrder = g_network->isSimulated() ? deterministicRandom()->random01() < 0.5 : false;
															#line 366 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(g_network->isSimulated() || !releaseVBOutOfOrder);
															#line 367 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (releaseVBOutOfOrder)
															#line 2824 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 369 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			int permTimes = deterministicRandom()->randomInt(0, 100);
															#line 370 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for(;permTimes-- > 0;) {
															#line 371 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				std::next_permutation(versionBatches.begin(), versionBatches.end());
															#line 2832 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
		}
															#line 375 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->addActor.send(monitorFinishedVersion(self, request));
															#line 376 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		versionBatch = versionBatches.begin();
															#line 377 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		;
															#line 2841 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state > 0) static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessRestoreRequestActor*>(this)->ActorCallback< ProcessRestoreRequestActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessRestoreRequestActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ProcessRestoreRequestActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ProcessRestoreRequestActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
															#line 398 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_5 = waitForAll(fBatches);
															#line 398 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state < 0) return a_body1cont7Catch1(actor_cancelled(), loopDepth);
															#line 2928 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1cont7Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont7when1(__when_expr_5.get(), loopDepth); };
			static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state = 6;
															#line 398 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ProcessRestoreRequestActor, 5, Void >*>(static_cast<ProcessRestoreRequestActor*>(this)));
															#line 2933 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont7Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont7Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1(int loopDepth) 
	{
															#line 377 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!(versionBatch != versionBatches.end()))
															#line 2955 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
			return a_body1cont6break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 378 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		;
															#line 2961 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont6loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6break1(int loopDepth) 
	{
		try {
			return a_body1cont7(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1(int loopDepth) 
	{
															#line 384 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		int batchIndex = versionBatch->batchIndex;
															#line 385 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerDispatchVersionBatches") .detail("BatchIndex", batchIndex) .detail("BatchSize", versionBatch->size) .detail("RunningVersionBatches", self->runningVersionBatches.get()) .detail("VersionBatches", versionBatches.size());
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->batch[batchIndex] = makeReference<ControllerBatchData>();
															#line 391 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->batchStatus[batchIndex] = makeReference<ControllerBatchStatus>();
															#line 392 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		fBatches.push_back(distributeWorkloadPerVersionBatch(self, batchIndex, cx, request, *versionBatch));
															#line 394 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_4 = delay(SERVER_KNOBS->FASTRESTORE_VB_LAUNCH_DELAY);
															#line 394 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2995 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont6loopBody1cont1when1(__when_expr_4.get(), loopDepth); };
		static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state = 5;
															#line 394 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ProcessRestoreRequestActor, 4, Void >*>(static_cast<ProcessRestoreRequestActor*>(this)));
															#line 3000 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont6loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1(int loopDepth) 
	{
															#line 378 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!(self->runningVersionBatches.get() >= SERVER_KNOBS->FASTRESTORE_VB_PARALLELISM && !releaseVBOutOfOrder))
															#line 3016 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
			return a_body1cont6loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 380 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerDispatchVersionBatches") .detail("WaitOnRunningVersionBatches", self->runningVersionBatches.get());
															#line 382 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->runningVersionBatches.onChange();
															#line 382 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 3026 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 2)); else return a_body1cont6loopBody1loopBody1when1(__when_expr_3.get(), loopDepth); };
		static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state = 4;
															#line 382 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ProcessRestoreRequestActor, 3, Void >*>(static_cast<ProcessRestoreRequestActor*>(this)));
															#line 3031 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1cont6loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont1(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1cont1(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont6loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state > 0) static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessRestoreRequestActor*>(this)->ActorCallback< ProcessRestoreRequestActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessRestoreRequestActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ProcessRestoreRequestActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ProcessRestoreRequestActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont6loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 377 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		versionBatch++;
															#line 3140 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 377 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		versionBatch++;
															#line 3149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1cont6loopHead1(0);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state > 0) static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessRestoreRequestActor*>(this)->ActorCallback< ProcessRestoreRequestActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessRestoreRequestActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ProcessRestoreRequestActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ProcessRestoreRequestActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont11(int loopDepth) 
	{
															#line 403 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreController").detail("RestoreToVersion", request.targetVersion);
															#line 404 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<ProcessRestoreRequestActor*>(this)->SAV<Version>::futures) { (void)(request.targetVersion); this->~ProcessRestoreRequestActorState(); static_cast<ProcessRestoreRequestActor*>(this)->destroy(); return 0; }
															#line 3235 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<ProcessRestoreRequestActor*>(this)->SAV< Version >::value()) Version(request.targetVersion);
		this->~ProcessRestoreRequestActorState();
		static_cast<ProcessRestoreRequestActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont7Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 400 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent(SevError, "FastRestoreControllerDispatchVersionBatchesUnexpectedError").error(e);
															#line 3248 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state > 0) static_cast<ProcessRestoreRequestActor*>(this)->actor_wait_state = 0;
		static_cast<ProcessRestoreRequestActor*>(this)->ActorCallback< ProcessRestoreRequestActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ProcessRestoreRequestActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ProcessRestoreRequestActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ProcessRestoreRequestActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont7Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont7Catch1(error, 0);
		} catch (...) {
			a_body1cont7Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12cont1(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont11(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<RestoreControllerData> self;
															#line 313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Database cx;
															#line 313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	RestoreRequest request;
															#line 316 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<RestoreFileFR> rangeFiles;
															#line 317 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<RestoreFileFR> logFiles;
															#line 318 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<RestoreFileFR> allFiles;
															#line 319 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Version minRangeVersion;
															#line 324 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Version targetVersion;
															#line 336 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	KeyRangeMap<Version> rangeVersions;
															#line 358 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<Future<Void>> fBatches;
															#line 359 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<VersionBatch> versionBatches;
															#line 365 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	bool releaseVBOutOfOrder;
															#line 376 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<VersionBatch>::iterator versionBatch;
															#line 3385 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via processRestoreRequest()
															#line 313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class ProcessRestoreRequestActor final : public Actor<Version>, public ActorCallback< ProcessRestoreRequestActor, 0, Version >, public ActorCallback< ProcessRestoreRequestActor, 1, Void >, public ActorCallback< ProcessRestoreRequestActor, 2, Void >, public ActorCallback< ProcessRestoreRequestActor, 3, Void >, public ActorCallback< ProcessRestoreRequestActor, 4, Void >, public ActorCallback< ProcessRestoreRequestActor, 5, Void >, public FastAllocated<ProcessRestoreRequestActor>, public ProcessRestoreRequestActorState<ProcessRestoreRequestActor> {
															#line 3390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<ProcessRestoreRequestActor>::operator new;
	using FastAllocated<ProcessRestoreRequestActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13424018452098373376UL, 5436007345991033088UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ProcessRestoreRequestActor, 0, Version >;
friend struct ActorCallback< ProcessRestoreRequestActor, 1, Void >;
friend struct ActorCallback< ProcessRestoreRequestActor, 2, Void >;
friend struct ActorCallback< ProcessRestoreRequestActor, 3, Void >;
friend struct ActorCallback< ProcessRestoreRequestActor, 4, Void >;
friend struct ActorCallback< ProcessRestoreRequestActor, 5, Void >;
															#line 313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	ProcessRestoreRequestActor(Reference<RestoreControllerData> const& self,Database const& cx,RestoreRequest const& request) 
															#line 3412 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   ProcessRestoreRequestActorState<ProcessRestoreRequestActor>(self, cx, request),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("processRestoreRequest", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6238867455145832192UL, 5282382489246358016UL);
		ActorExecutionContextHelper __helper(static_cast<ProcessRestoreRequestActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("processRestoreRequest");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("processRestoreRequest", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ProcessRestoreRequestActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ProcessRestoreRequestActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ProcessRestoreRequestActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ProcessRestoreRequestActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< ProcessRestoreRequestActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< ProcessRestoreRequestActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Version> processRestoreRequest( Reference<RestoreControllerData> const& self, Database const& cx, RestoreRequest const& request ) {
															#line 313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Version>(new ProcessRestoreRequestActor(self, cx, request));
															#line 3450 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 406 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

															#line 3455 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via loadFilesOnLoaders()
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class LoadFilesOnLoadersActor>
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class LoadFilesOnLoadersActorState {
															#line 3462 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	LoadFilesOnLoadersActorState(Reference<ControllerBatchData> const& batchData,Reference<ControllerBatchStatus> const& batchStatus,std::map<UID, RestoreLoaderInterface> const& loadersInterf,int const& batchIndex,Database const& cx,RestoreRequest const& request,VersionBatch const& versionBatch,bool const& isRangeFile) 
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : batchData(batchData),
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   batchStatus(batchStatus),
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   loadersInterf(loadersInterf),
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   batchIndex(batchIndex),
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   cx(cx),
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   request(request),
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   versionBatch(versionBatch),
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   isRangeFile(isRangeFile)
															#line 3483 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("loadFilesOnLoaders", reinterpret_cast<unsigned long>(this));

	}
	~LoadFilesOnLoadersActorState() 
	{
		fdb_probe_actor_destroy("loadFilesOnLoaders", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 416 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			std::set<RestoreFileFR>* files = isRangeFile ? &versionBatch.rangeFiles : &versionBatch.logFiles;
															#line 418 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent("FastRestoreControllerPhaseLoadFilesStart") .detail("RestoreRequestID", request.randomUid) .detail("BatchIndex", batchIndex) .detail("FileTypeLoadedInVersionBatch", isRangeFile) .detail("BeginVersion", versionBatch.beginVersion) .detail("EndVersion", versionBatch.endVersion) .detail("Files", (files != nullptr ? files->size() : -1));
															#line 426 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			std::vector<std::pair<UID, RestoreLoadFileRequest>> requests;
															#line 427 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			std::map<UID, RestoreLoaderInterface>::iterator loader = loadersInterf.begin();
															#line 428 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			assets = std::vector<RestoreAsset>();
															#line 431 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			int random = deterministicRandom()->randomInt(0, loadersInterf.size());
															#line 432 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for(;random-- > 0;) {
															#line 433 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				loader++;
															#line 3512 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 436 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			int paramIdx = 0;
															#line 437 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( auto& file : *files ) {
															#line 439 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (loader == loadersInterf.end())
															#line 3520 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				{
															#line 440 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					loader = loadersInterf.begin();
															#line 3524 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				}
															#line 443 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				LoadingParam param;
															#line 444 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.url = request.url;
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.isRangeFile = file.isRange;
															#line 446 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.rangeVersion = file.isRange ? file.version : -1;
															#line 447 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.blockSize = file.blockSize;
															#line 449 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.asset.uid = deterministicRandom()->randomUniqueID();
															#line 450 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.asset.filename = file.fileName;
															#line 451 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.asset.fileIndex = file.fileIndex;
															#line 452 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.asset.partitionId = file.partitionId;
															#line 453 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.asset.offset = 0;
															#line 454 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.asset.len = file.fileSize;
															#line 455 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.asset.range = request.range;
															#line 456 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.asset.beginVersion = versionBatch.beginVersion;
															#line 457 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.asset.endVersion = (isRangeFile || request.targetVersion == -1) ? versionBatch.endVersion : std::min(versionBatch.endVersion, request.targetVersion + 1);
															#line 460 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.asset.addPrefix = request.addPrefix;
															#line 461 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.asset.removePrefix = request.removePrefix;
															#line 462 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				param.asset.batchIndex = batchIndex;
															#line 464 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent("FastRestoreControllerPhaseLoadFiles") .detail("BatchIndex", batchIndex) .detail("LoadParamIndex", paramIdx) .detail("LoaderID", loader->first.toString()) .detail("LoadParam", param.toString());
															#line 469 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				ASSERT_WE_THINK(param.asset.len > 0);
															#line 470 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				ASSERT_WE_THINK(param.asset.offset >= 0);
															#line 471 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				ASSERT_WE_THINK(param.asset.offset <= file.fileSize);
															#line 472 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				ASSERT_WE_THINK(param.asset.beginVersion <= param.asset.endVersion);
															#line 474 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				requests.emplace_back(loader->first, RestoreLoadFileRequest(batchIndex, param));
															#line 476 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (batchStatus->raStatus.find(param.asset) != batchStatus->raStatus.end())
															#line 3574 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				{
															#line 477 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					TraceEvent(SevError, "FastRestoreControllerPhaseLoadFiles") .detail("LoadingParam", param.toString()) .detail("RestoreAssetAlreadyProcessed", batchStatus->raStatus[param.asset]);
															#line 3578 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				}
															#line 481 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				batchStatus->raStatus[param.asset] = RestoreAssetStatus::Loading;
															#line 482 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				assets.push_back(param.asset);
															#line 483 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				++loader;
															#line 484 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				++paramIdx;
															#line 3588 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 486 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent(files->size() != paramIdx ? SevError : SevInfo, "FastRestoreControllerPhaseLoadFiles") .detail("BatchIndex", batchIndex) .detail("Files", files->size()) .detail("LoadParams", paramIdx);
															#line 491 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			replies = std::vector<RestoreLoadFileReply>();
															#line 493 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = getBatchReplies( &RestoreLoaderInterface::loadFile, loadersInterf, requests, &replies, TaskPriority::RestoreLoaderLoadFiles);
															#line 493 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<LoadFilesOnLoadersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3598 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<LoadFilesOnLoadersActor*>(this)->actor_wait_state = 1;
															#line 493 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< LoadFilesOnLoadersActor, 0, Void >*>(static_cast<LoadFilesOnLoadersActor*>(this)));
															#line 3603 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~LoadFilesOnLoadersActorState();
		static_cast<LoadFilesOnLoadersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 496 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseLoadFilesReply") .detail("BatchIndex", batchIndex) .detail("SamplingReplies", replies.size());
															#line 499 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& reply : replies ) {
															#line 501 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			RestoreAssetStatus status = batchStatus->raStatus[reply.param.asset];
															#line 502 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (status == RestoreAssetStatus::Loading && !reply.isDuplicated)
															#line 3632 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 503 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				batchStatus->raStatus[reply.param.asset] = RestoreAssetStatus::Loaded;
															#line 3636 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 504 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (status == RestoreAssetStatus::Loading && reply.isDuplicated)
															#line 3642 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				{
															#line 506 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					batchStatus->raStatus[reply.param.asset] = RestoreAssetStatus::Loaded;
															#line 507 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					TraceEvent(SevWarn, "FastRestoreControllerPhaseLoadFilesReply") .detail("RestoreAsset", reply.param.asset.toString()) .detail("DuplicateRequestArriveEarly", "RestoreAsset should have been processed");
															#line 3648 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 510 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					if (status == RestoreAssetStatus::Loaded && reply.isDuplicated)
															#line 3654 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
					{
															#line 511 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
						TraceEvent(SevDebug, "FastRestoreControllerPhaseLoadFilesReply") .detail("RestoreAsset", reply.param.asset.toString()) .detail("RequestIgnored", "Loading request was sent more than once");
															#line 3658 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
					}
					else
					{
															#line 515 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
						TraceEvent(SevError, "FastRestoreControllerPhaseLoadFilesReply") .detail("RestoreAsset", reply.param.asset.toString()) .detail("UnexpectedReply", reply.toString());
															#line 3664 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 522 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& asset : assets ) {
															#line 523 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (batchStatus->raStatus[asset] != RestoreAssetStatus::Loaded)
															#line 3673 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 524 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevError, "FastRestoreControllerPhaseLoadFilesReply") .detail("RestoreAsset", asset.toString()) .detail("UnexpectedStatus", batchStatus->raStatus[asset]);
															#line 3677 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
		}
															#line 530 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseLoadFilesDone") .detail("BatchIndex", batchIndex) .detail("FileTypeLoadedInVersionBatch", isRangeFile) .detail("BeginVersion", versionBatch.beginVersion) .detail("EndVersion", versionBatch.endVersion);
															#line 535 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<LoadFilesOnLoadersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadFilesOnLoadersActorState(); static_cast<LoadFilesOnLoadersActor*>(this)->destroy(); return 0; }
															#line 3684 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<LoadFilesOnLoadersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadFilesOnLoadersActorState();
		static_cast<LoadFilesOnLoadersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 496 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseLoadFilesReply") .detail("BatchIndex", batchIndex) .detail("SamplingReplies", replies.size());
															#line 499 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& reply : replies ) {
															#line 501 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			RestoreAssetStatus status = batchStatus->raStatus[reply.param.asset];
															#line 502 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (status == RestoreAssetStatus::Loading && !reply.isDuplicated)
															#line 3702 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 503 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				batchStatus->raStatus[reply.param.asset] = RestoreAssetStatus::Loaded;
															#line 3706 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 504 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (status == RestoreAssetStatus::Loading && reply.isDuplicated)
															#line 3712 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				{
															#line 506 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					batchStatus->raStatus[reply.param.asset] = RestoreAssetStatus::Loaded;
															#line 507 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					TraceEvent(SevWarn, "FastRestoreControllerPhaseLoadFilesReply") .detail("RestoreAsset", reply.param.asset.toString()) .detail("DuplicateRequestArriveEarly", "RestoreAsset should have been processed");
															#line 3718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				}
				else
				{
															#line 510 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					if (status == RestoreAssetStatus::Loaded && reply.isDuplicated)
															#line 3724 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
					{
															#line 511 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
						TraceEvent(SevDebug, "FastRestoreControllerPhaseLoadFilesReply") .detail("RestoreAsset", reply.param.asset.toString()) .detail("RequestIgnored", "Loading request was sent more than once");
															#line 3728 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
					}
					else
					{
															#line 515 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
						TraceEvent(SevError, "FastRestoreControllerPhaseLoadFilesReply") .detail("RestoreAsset", reply.param.asset.toString()) .detail("UnexpectedReply", reply.toString());
															#line 3734 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
					}
				}
			}
		}
															#line 522 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& asset : assets ) {
															#line 523 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (batchStatus->raStatus[asset] != RestoreAssetStatus::Loaded)
															#line 3743 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 524 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevError, "FastRestoreControllerPhaseLoadFilesReply") .detail("RestoreAsset", asset.toString()) .detail("UnexpectedStatus", batchStatus->raStatus[asset]);
															#line 3747 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
		}
															#line 530 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseLoadFilesDone") .detail("BatchIndex", batchIndex) .detail("FileTypeLoadedInVersionBatch", isRangeFile) .detail("BeginVersion", versionBatch.beginVersion) .detail("EndVersion", versionBatch.endVersion);
															#line 535 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<LoadFilesOnLoadersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~LoadFilesOnLoadersActorState(); static_cast<LoadFilesOnLoadersActor*>(this)->destroy(); return 0; }
															#line 3754 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<LoadFilesOnLoadersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~LoadFilesOnLoadersActorState();
		static_cast<LoadFilesOnLoadersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<LoadFilesOnLoadersActor*>(this)->actor_wait_state > 0) static_cast<LoadFilesOnLoadersActor*>(this)->actor_wait_state = 0;
		static_cast<LoadFilesOnLoadersActor*>(this)->ActorCallback< LoadFilesOnLoadersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< LoadFilesOnLoadersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("loadFilesOnLoaders", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadFilesOnLoadersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadFilesOnLoaders", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< LoadFilesOnLoadersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("loadFilesOnLoaders", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<LoadFilesOnLoadersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadFilesOnLoaders", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< LoadFilesOnLoadersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("loadFilesOnLoaders", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<LoadFilesOnLoadersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("loadFilesOnLoaders", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<ControllerBatchData> batchData;
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<ControllerBatchStatus> batchStatus;
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::map<UID, RestoreLoaderInterface> loadersInterf;
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	int batchIndex;
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Database cx;
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	RestoreRequest request;
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	VersionBatch versionBatch;
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	bool isRangeFile;
															#line 428 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<RestoreAsset> assets;
															#line 491 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<RestoreLoadFileReply> replies;
															#line 3857 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via loadFilesOnLoaders()
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class LoadFilesOnLoadersActor final : public Actor<Void>, public ActorCallback< LoadFilesOnLoadersActor, 0, Void >, public FastAllocated<LoadFilesOnLoadersActor>, public LoadFilesOnLoadersActorState<LoadFilesOnLoadersActor> {
															#line 3862 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<LoadFilesOnLoadersActor>::operator new;
	using FastAllocated<LoadFilesOnLoadersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5177144133423535104UL, 17883872413484560896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< LoadFilesOnLoadersActor, 0, Void >;
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	LoadFilesOnLoadersActor(Reference<ControllerBatchData> const& batchData,Reference<ControllerBatchStatus> const& batchStatus,std::map<UID, RestoreLoaderInterface> const& loadersInterf,int const& batchIndex,Database const& cx,RestoreRequest const& request,VersionBatch const& versionBatch,bool const& isRangeFile) 
															#line 3879 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   LoadFilesOnLoadersActorState<LoadFilesOnLoadersActor>(batchData, batchStatus, loadersInterf, batchIndex, cx, request, versionBatch, isRangeFile),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("loadFilesOnLoaders", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16269871804417156352UL, 12371216340561633280UL);
		ActorExecutionContextHelper __helper(static_cast<LoadFilesOnLoadersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("loadFilesOnLoaders");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("loadFilesOnLoaders", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< LoadFilesOnLoadersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Void> loadFilesOnLoaders( Reference<ControllerBatchData> const& batchData, Reference<ControllerBatchStatus> const& batchStatus, std::map<UID, RestoreLoaderInterface> const& loadersInterf, int const& batchIndex, Database const& cx, RestoreRequest const& request, VersionBatch const& versionBatch, bool const& isRangeFile ) {
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new LoadFilesOnLoadersActor(batchData, batchStatus, loadersInterf, batchIndex, cx, request, versionBatch, isRangeFile));
															#line 3912 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 537 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

// Ask loaders to send its buffered mutations to appliers
															#line 3918 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via sendMutationsFromLoaders()
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class SendMutationsFromLoadersActor>
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class SendMutationsFromLoadersActorState {
															#line 3925 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	SendMutationsFromLoadersActorState(Reference<ControllerBatchData> const& batchData,Reference<ControllerBatchStatus> const& batchStatus,std::map<UID, RestoreLoaderInterface> const& loadersInterf,int const& batchIndex,bool const& useRangeFile) 
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : batchData(batchData),
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   batchStatus(batchStatus),
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   loadersInterf(loadersInterf),
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   batchIndex(batchIndex),
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   useRangeFile(useRangeFile)
															#line 3940 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("sendMutationsFromLoaders", reinterpret_cast<unsigned long>(this));

	}
	~SendMutationsFromLoadersActorState() 
	{
		fdb_probe_actor_destroy("sendMutationsFromLoaders", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 544 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent("FastRestoreControllerPhaseSendMutationsFromLoadersStart") .detail("BatchIndex", batchIndex) .detail("UseRangeFiles", useRangeFile) .detail("Loaders", loadersInterf.size());
															#line 549 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			std::vector<std::pair<UID, RestoreSendMutationsToAppliersRequest>> requests;
															#line 550 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( auto& loader : loadersInterf ) {
															#line 551 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				requests.emplace_back( loader.first, RestoreSendMutationsToAppliersRequest(batchIndex, batchData->rangeToApplier, useRangeFile));
															#line 553 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				batchStatus->loadStatus[loader.first] = useRangeFile ? RestoreSendStatus::SendingRanges : RestoreSendStatus::SendingLogs;
															#line 3963 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 556 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			replies = std::vector<RestoreCommonReply>();
															#line 557 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = getBatchReplies(&RestoreLoaderInterface::sendMutations, loadersInterf, requests, &replies, TaskPriority::RestoreLoaderSendMutations);
															#line 557 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<SendMutationsFromLoadersActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3971 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SendMutationsFromLoadersActor*>(this)->actor_wait_state = 1;
															#line 557 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SendMutationsFromLoadersActor, 0, Void >*>(static_cast<SendMutationsFromLoadersActor*>(this)));
															#line 3976 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SendMutationsFromLoadersActorState();
		static_cast<SendMutationsFromLoadersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 563 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseSendMutationsFromLoadersDone") .detail("BatchIndex", batchIndex) .detail("UseRangeFiles", useRangeFile) .detail("Loaders", loadersInterf.size());
															#line 568 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<SendMutationsFromLoadersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendMutationsFromLoadersActorState(); static_cast<SendMutationsFromLoadersActor*>(this)->destroy(); return 0; }
															#line 4001 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<SendMutationsFromLoadersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendMutationsFromLoadersActorState();
		static_cast<SendMutationsFromLoadersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 563 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseSendMutationsFromLoadersDone") .detail("BatchIndex", batchIndex) .detail("UseRangeFiles", useRangeFile) .detail("Loaders", loadersInterf.size());
															#line 568 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<SendMutationsFromLoadersActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SendMutationsFromLoadersActorState(); static_cast<SendMutationsFromLoadersActor*>(this)->destroy(); return 0; }
															#line 4015 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<SendMutationsFromLoadersActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SendMutationsFromLoadersActorState();
		static_cast<SendMutationsFromLoadersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SendMutationsFromLoadersActor*>(this)->actor_wait_state > 0) static_cast<SendMutationsFromLoadersActor*>(this)->actor_wait_state = 0;
		static_cast<SendMutationsFromLoadersActor*>(this)->ActorCallback< SendMutationsFromLoadersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SendMutationsFromLoadersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("sendMutationsFromLoaders", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendMutationsFromLoadersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendMutationsFromLoaders", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SendMutationsFromLoadersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("sendMutationsFromLoaders", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SendMutationsFromLoadersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendMutationsFromLoaders", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SendMutationsFromLoadersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("sendMutationsFromLoaders", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SendMutationsFromLoadersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("sendMutationsFromLoaders", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<ControllerBatchData> batchData;
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<ControllerBatchStatus> batchStatus;
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::map<UID, RestoreLoaderInterface> loadersInterf;
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	int batchIndex;
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	bool useRangeFile;
															#line 556 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<RestoreCommonReply> replies;
															#line 4110 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via sendMutationsFromLoaders()
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class SendMutationsFromLoadersActor final : public Actor<Void>, public ActorCallback< SendMutationsFromLoadersActor, 0, Void >, public FastAllocated<SendMutationsFromLoadersActor>, public SendMutationsFromLoadersActorState<SendMutationsFromLoadersActor> {
															#line 4115 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<SendMutationsFromLoadersActor>::operator new;
	using FastAllocated<SendMutationsFromLoadersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17730150985331230976UL, 5836091850865730560UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SendMutationsFromLoadersActor, 0, Void >;
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	SendMutationsFromLoadersActor(Reference<ControllerBatchData> const& batchData,Reference<ControllerBatchStatus> const& batchStatus,std::map<UID, RestoreLoaderInterface> const& loadersInterf,int const& batchIndex,bool const& useRangeFile) 
															#line 4132 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SendMutationsFromLoadersActorState<SendMutationsFromLoadersActor>(batchData, batchStatus, loadersInterf, batchIndex, useRangeFile),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("sendMutationsFromLoaders", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6550632508046924288UL, 14705310329549593600UL);
		ActorExecutionContextHelper __helper(static_cast<SendMutationsFromLoadersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("sendMutationsFromLoaders");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("sendMutationsFromLoaders", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SendMutationsFromLoadersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Void> sendMutationsFromLoaders( Reference<ControllerBatchData> const& batchData, Reference<ControllerBatchStatus> const& batchStatus, std::map<UID, RestoreLoaderInterface> const& loadersInterf, int const& batchIndex, bool const& useRangeFile ) {
															#line 539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new SendMutationsFromLoadersActor(batchData, batchStatus, loadersInterf, batchIndex, useRangeFile));
															#line 4165 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 570 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

// Process a version batch. Phases (loading files, send mutations) should execute in order
															#line 4171 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via distributeWorkloadPerVersionBatch()
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class DistributeWorkloadPerVersionBatchActor>
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class DistributeWorkloadPerVersionBatchActorState {
															#line 4178 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	DistributeWorkloadPerVersionBatchActorState(Reference<RestoreControllerData> const& self,int const& batchIndex,Database const& cx,RestoreRequest const& request,VersionBatch const& versionBatch) 
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : self(self),
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   batchIndex(batchIndex),
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   cx(cx),
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   request(request),
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   versionBatch(versionBatch),
															#line 577 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   batchData(self->batch[batchIndex]),
															#line 578 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   batchStatus(self->batchStatus[batchIndex]),
															#line 579 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   startTime(now())
															#line 4199 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this));

	}
	~DistributeWorkloadPerVersionBatchActorState() 
	{
		fdb_probe_actor_destroy("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 581 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent("FastRestoreControllerDispatchVersionBatchesStart", self->id()) .detail("BatchIndex", batchIndex) .detail("BatchSize", versionBatch.size) .detail("RunningVersionBatches", self->runningVersionBatches.get());
															#line 586 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			self->runningVersionBatches.set(self->runningVersionBatches.get() + 1);
															#line 589 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = isSchedulable(self, batchIndex, __FUNCTION__);
															#line 589 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4220 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 1;
															#line 589 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DistributeWorkloadPerVersionBatchActor, 0, Void >*>(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)));
															#line 4225 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~DistributeWorkloadPerVersionBatchActorState();
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 591 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = initializeVersionBatch(self->appliersInterf, self->loadersInterf, batchIndex);
															#line 591 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4250 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 2;
															#line 591 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DistributeWorkloadPerVersionBatchActor, 1, Void >*>(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)));
															#line 4255 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 591 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = initializeVersionBatch(self->appliersInterf, self->loadersInterf, batchIndex);
															#line 591 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4266 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 2;
															#line 591 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< DistributeWorkloadPerVersionBatchActor, 1, Void >*>(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)));
															#line 4271 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state > 0) static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 0;
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->ActorCallback< DistributeWorkloadPerVersionBatchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DistributeWorkloadPerVersionBatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DistributeWorkloadPerVersionBatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DistributeWorkloadPerVersionBatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 593 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(!versionBatch.isEmpty());
															#line 594 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(self->loadersInterf.size() > 0);
															#line 595 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(self->appliersInterf.size() > 0);
															#line 599 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(batchData->samples.empty());
															#line 600 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(batchData->samplesSize < 1 && batchData->samplesSize > -1);
															#line 601 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(batchStatus->raStatus.empty());
															#line 602 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(batchStatus->loadStatus.empty());
															#line 603 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(batchStatus->applyStatus.empty());
															#line 608 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = loadFilesOnLoaders(batchData, batchStatus, self->loadersInterf, batchIndex, cx, request, versionBatch, false) && loadFilesOnLoaders(batchData, batchStatus, self->loadersInterf, batchIndex, cx, request, versionBatch, true);
															#line 608 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4373 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 3;
															#line 608 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DistributeWorkloadPerVersionBatchActor, 2, Void >*>(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)));
															#line 4378 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 593 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(!versionBatch.isEmpty());
															#line 594 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(self->loadersInterf.size() > 0);
															#line 595 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(self->appliersInterf.size() > 0);
															#line 599 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(batchData->samples.empty());
															#line 600 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(batchData->samplesSize < 1 && batchData->samplesSize > -1);
															#line 601 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(batchStatus->raStatus.empty());
															#line 602 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(batchStatus->loadStatus.empty());
															#line 603 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(batchStatus->applyStatus.empty());
															#line 608 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_2 = loadFilesOnLoaders(batchData, batchStatus, self->loadersInterf, batchIndex, cx, request, versionBatch, false) && loadFilesOnLoaders(batchData, batchStatus, self->loadersInterf, batchIndex, cx, request, versionBatch, true);
															#line 608 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4405 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 3;
															#line 608 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< DistributeWorkloadPerVersionBatchActor, 2, Void >*>(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)));
															#line 4410 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state > 0) static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 0;
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->ActorCallback< DistributeWorkloadPerVersionBatchActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DistributeWorkloadPerVersionBatchActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< DistributeWorkloadPerVersionBatchActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< DistributeWorkloadPerVersionBatchActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 612 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(batchData->rangeToApplier.empty());
															#line 613 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		splitKeyRangeForAppliers(batchData, self->appliersInterf, batchIndex);
															#line 617 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = sendMutationsFromLoaders(batchData, batchStatus, self->loadersInterf, batchIndex, false) && sendMutationsFromLoaders(batchData, batchStatus, self->loadersInterf, batchIndex, true);
															#line 617 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4500 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 4;
															#line 617 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DistributeWorkloadPerVersionBatchActor, 3, Void >*>(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)));
															#line 4505 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 612 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(batchData->rangeToApplier.empty());
															#line 613 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		splitKeyRangeForAppliers(batchData, self->appliersInterf, batchIndex);
															#line 617 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = sendMutationsFromLoaders(batchData, batchStatus, self->loadersInterf, batchIndex, false) && sendMutationsFromLoaders(batchData, batchStatus, self->loadersInterf, batchIndex, true);
															#line 617 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4520 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont3when1(__when_expr_3.get(), loopDepth); };
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 4;
															#line 617 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< DistributeWorkloadPerVersionBatchActor, 3, Void >*>(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)));
															#line 4525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state > 0) static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 0;
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->ActorCallback< DistributeWorkloadPerVersionBatchActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DistributeWorkloadPerVersionBatchActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< DistributeWorkloadPerVersionBatchActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< DistributeWorkloadPerVersionBatchActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
															#line 622 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_4 = notifyApplierToApplyMutations(batchData, batchStatus, self->appliersInterf, batchIndex, &self->finishedBatch);
															#line 622 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4611 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 5;
															#line 622 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DistributeWorkloadPerVersionBatchActor, 4, Void >*>(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)));
															#line 4616 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
															#line 622 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_4 = notifyApplierToApplyMutations(batchData, batchStatus, self->appliersInterf, batchIndex, &self->finishedBatch);
															#line 622 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4627 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), loopDepth); else return a_body1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 5;
															#line 622 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< DistributeWorkloadPerVersionBatchActor, 4, Void >*>(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)));
															#line 4632 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state > 0) static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 0;
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->ActorCallback< DistributeWorkloadPerVersionBatchActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DistributeWorkloadPerVersionBatchActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< DistributeWorkloadPerVersionBatchActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< DistributeWorkloadPerVersionBatchActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 624 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = notifyLoadersVersionBatchFinished(self->loadersInterf, batchIndex);
															#line 624 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 6;
															#line 624 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DistributeWorkloadPerVersionBatchActor, 5, Void >*>(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)));
															#line 4723 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 624 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_5 = notifyLoadersVersionBatchFinished(self->loadersInterf, batchIndex);
															#line 624 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 4734 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont5when1(__when_expr_5.get(), loopDepth); };
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 6;
															#line 624 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< DistributeWorkloadPerVersionBatchActor, 5, Void >*>(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)));
															#line 4739 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state > 0) static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 0;
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->ActorCallback< DistributeWorkloadPerVersionBatchActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DistributeWorkloadPerVersionBatchActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< DistributeWorkloadPerVersionBatchActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< DistributeWorkloadPerVersionBatchActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 626 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->runningVersionBatches.set(self->runningVersionBatches.get() - 1);
															#line 628 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (self->delayedActors > 0)
															#line 4825 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 629 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			self->checkMemory.trigger();
															#line 4829 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 632 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerDispatchVersionBatchesDone", self->id()) .detail("BatchIndex", batchIndex) .detail("BatchSize", versionBatch.size) .detail("RunningVersionBatches", self->runningVersionBatches.get()) .detail("Latency", now() - startTime);
															#line 638 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DistributeWorkloadPerVersionBatchActorState(); static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->destroy(); return 0; }
															#line 4835 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DistributeWorkloadPerVersionBatchActorState();
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 626 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		self->runningVersionBatches.set(self->runningVersionBatches.get() - 1);
															#line 628 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (self->delayedActors > 0)
															#line 4849 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 629 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			self->checkMemory.trigger();
															#line 4853 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 632 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerDispatchVersionBatchesDone", self->id()) .detail("BatchIndex", batchIndex) .detail("BatchSize", versionBatch.size) .detail("RunningVersionBatches", self->runningVersionBatches.get()) .detail("Latency", now() - startTime);
															#line 638 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~DistributeWorkloadPerVersionBatchActorState(); static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->destroy(); return 0; }
															#line 4859 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~DistributeWorkloadPerVersionBatchActorState();
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state > 0) static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->actor_wait_state = 0;
		static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->ActorCallback< DistributeWorkloadPerVersionBatchActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DistributeWorkloadPerVersionBatchActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< DistributeWorkloadPerVersionBatchActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< DistributeWorkloadPerVersionBatchActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<RestoreControllerData> self;
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	int batchIndex;
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Database cx;
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	RestoreRequest request;
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	VersionBatch versionBatch;
															#line 577 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<ControllerBatchData> batchData;
															#line 578 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<ControllerBatchStatus> batchStatus;
															#line 579 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	double startTime;
															#line 4958 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via distributeWorkloadPerVersionBatch()
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class DistributeWorkloadPerVersionBatchActor final : public Actor<Void>, public ActorCallback< DistributeWorkloadPerVersionBatchActor, 0, Void >, public ActorCallback< DistributeWorkloadPerVersionBatchActor, 1, Void >, public ActorCallback< DistributeWorkloadPerVersionBatchActor, 2, Void >, public ActorCallback< DistributeWorkloadPerVersionBatchActor, 3, Void >, public ActorCallback< DistributeWorkloadPerVersionBatchActor, 4, Void >, public ActorCallback< DistributeWorkloadPerVersionBatchActor, 5, Void >, public FastAllocated<DistributeWorkloadPerVersionBatchActor>, public DistributeWorkloadPerVersionBatchActorState<DistributeWorkloadPerVersionBatchActor> {
															#line 4963 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<DistributeWorkloadPerVersionBatchActor>::operator new;
	using FastAllocated<DistributeWorkloadPerVersionBatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4336166828911353344UL, 82830926669495552UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< DistributeWorkloadPerVersionBatchActor, 0, Void >;
friend struct ActorCallback< DistributeWorkloadPerVersionBatchActor, 1, Void >;
friend struct ActorCallback< DistributeWorkloadPerVersionBatchActor, 2, Void >;
friend struct ActorCallback< DistributeWorkloadPerVersionBatchActor, 3, Void >;
friend struct ActorCallback< DistributeWorkloadPerVersionBatchActor, 4, Void >;
friend struct ActorCallback< DistributeWorkloadPerVersionBatchActor, 5, Void >;
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	DistributeWorkloadPerVersionBatchActor(Reference<RestoreControllerData> const& self,int const& batchIndex,Database const& cx,RestoreRequest const& request,VersionBatch const& versionBatch) 
															#line 4985 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   DistributeWorkloadPerVersionBatchActorState<DistributeWorkloadPerVersionBatchActor>(self, batchIndex, cx, request, versionBatch),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16438959176122984960UL, 2011357118043292416UL);
		ActorExecutionContextHelper __helper(static_cast<DistributeWorkloadPerVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("distributeWorkloadPerVersionBatch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("distributeWorkloadPerVersionBatch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< DistributeWorkloadPerVersionBatchActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< DistributeWorkloadPerVersionBatchActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< DistributeWorkloadPerVersionBatchActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< DistributeWorkloadPerVersionBatchActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< DistributeWorkloadPerVersionBatchActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< DistributeWorkloadPerVersionBatchActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Void> distributeWorkloadPerVersionBatch( Reference<RestoreControllerData> const& self, int const& batchIndex, Database const& cx, RestoreRequest const& request, VersionBatch const& versionBatch ) {
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new DistributeWorkloadPerVersionBatchActor(self, batchIndex, cx, request, versionBatch));
															#line 5023 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 640 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

// Decide which key range should be taken by which applier
// Input: samples in batchData
// Output: rangeToApplier in batchData
void splitKeyRangeForAppliers(Reference<ControllerBatchData> batchData,
                              std::map<UID, RestoreApplierInterface> appliersInterf,
                              int batchIndex) {
	ASSERT(batchData->samplesSize >= 0);
	// Sanity check: samples should not be used after freed
	ASSERT((batchData->samplesSize > 0 && !batchData->samples.empty()) ||
	       (batchData->samplesSize == 0 && batchData->samples.empty()));
	int numAppliers = appliersInterf.size();
	double slotSize = std::max(batchData->samplesSize / numAppliers, 1.0);
	double cumulativeSize = slotSize;
	TraceEvent("FastRestoreControllerPhaseCalculateApplierKeyRangesStart")
	    .detail("BatchIndex", batchIndex)
	    .detail("SamplingSize", batchData->samplesSize)
	    .detail("SlotSize", slotSize);

	std::set<Key> keyrangeSplitter; // unique key to split key range for appliers
	keyrangeSplitter.insert(allKeys.begin); // First slot
	TraceEvent("FastRestoreControllerPhaseCalculateApplierKeyRanges")
	    .detail("BatchIndex", batchIndex)
	    .detail("CumulativeSize", cumulativeSize)
	    .detail("Slot", 0)
	    .detail("LowerBoundKey", allKeys.begin);
	int slotIdx = 1;
	while (cumulativeSize < batchData->samplesSize) {
		IndexedSet<Key, int64_t>::iterator lowerBound = batchData->samples.index(cumulativeSize);
		if (lowerBound == batchData->samples.end()) {
			break;
		}
		keyrangeSplitter.insert(*lowerBound);
		TraceEvent("FastRestoreControllerPhaseCalculateApplierKeyRanges")
		    .detail("BatchIndex", batchIndex)
		    .detail("CumulativeSize", cumulativeSize)
		    .detail("Slot", slotIdx++)
		    .detail("LowerBoundKey", lowerBound->toString());
		cumulativeSize += slotSize;
	}
	if (keyrangeSplitter.size() < numAppliers) {
		TraceEvent(SevWarnAlways, "FastRestoreControllerPhaseCalculateApplierKeyRanges")
		    .detail("NotAllAppliersAreUsed", keyrangeSplitter.size())
		    .detail("NumAppliers", numAppliers);
	} else if (keyrangeSplitter.size() > numAppliers) {
		bool expected = (keyrangeSplitter.size() == numAppliers + 1);
		TraceEvent(expected ? SevWarn : SevError, "FastRestoreControllerPhaseCalculateApplierKeyRanges")
		    .detail("TooManySlotsThanAppliers", keyrangeSplitter.size())
		    .detail("NumAppliers", numAppliers)
		    .detail("SamplingSize", batchData->samplesSize)
		    .detail("PerformanceMayDegrade", "Last applier handles more data than others");
	}

	std::set<Key>::iterator splitter = keyrangeSplitter.begin();
	batchData->rangeToApplier.clear();
	for (auto& applier : appliersInterf) {
		if (splitter == keyrangeSplitter.end()) {
			break; // Not all appliers will be used
		}
		batchData->rangeToApplier[*splitter] = applier.first;
		splitter++;
	}
	ASSERT(batchData->rangeToApplier.size() > 0);
	ASSERT(batchData->sanityCheckApplierKeyRange());
	batchData->logApplierKeyRange(batchIndex);
	TraceEvent("FastRestoreControllerPhaseCalculateApplierKeyRangesDone")
	    .detail("BatchIndex", batchIndex)
	    .detail("SamplingSize", batchData->samplesSize)
	    .detail("SlotSize", slotSize);
	batchData->samples.clear();
}

															#line 5099 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via collectRestoreRequests()
															#line 712 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class CollectRestoreRequestsActor>
															#line 712 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class CollectRestoreRequestsActorState {
															#line 5106 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 712 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	CollectRestoreRequestsActorState(Database const& cx) 
															#line 712 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 712 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : cx(cx),
															#line 713 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   restoreRequests(),
															#line 714 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   watch4RestoreRequest(),
															#line 715 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   tr(cx)
															#line 5119 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("collectRestoreRequests", reinterpret_cast<unsigned long>(this));

	}
	~CollectRestoreRequestsActorState() 
	{
		fdb_probe_actor_destroy("collectRestoreRequests", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			;
															#line 5134 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CollectRestoreRequestsActorState();
		static_cast<CollectRestoreRequestsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 746 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<CollectRestoreRequestsActor*>(this)->SAV<std::vector<RestoreRequest>>::futures) { (void)(restoreRequests); this->~CollectRestoreRequestsActorState(); static_cast<CollectRestoreRequestsActor*>(this)->destroy(); return 0; }
															#line 5157 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<CollectRestoreRequestsActor*>(this)->SAV< std::vector<RestoreRequest> >::value()) std::vector<RestoreRequest>(std::move(restoreRequests)); // state_var_RVO
		this->~CollectRestoreRequestsActorState();
		static_cast<CollectRestoreRequestsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 720 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent("FastRestoreControllerPhaseCollectRestoreRequestsWait").log();
															#line 721 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 722 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 725 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(restoreRequestTriggerKey);
															#line 725 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5185 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state = 1;
															#line 725 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CollectRestoreRequestsActor, 0, Optional<Value> >*>(static_cast<CollectRestoreRequestsActor*>(this)));
															#line 5190 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 742 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 742 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5227 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state = 4;
															#line 742 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< CollectRestoreRequestsActor, 3, Void >*>(static_cast<CollectRestoreRequestsActor*>(this)));
															#line 5232 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& numRequests,int loopDepth) 
	{
															#line 726 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(numRequests.present());
															#line 728 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(restoreRequestKeys, CLIENT_KNOBS->TOO_MANY);
															#line 728 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5251 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state = 2;
															#line 728 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CollectRestoreRequestsActor, 1, RangeResult >*>(static_cast<CollectRestoreRequestsActor*>(this)));
															#line 5256 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && numRequests,int loopDepth) 
	{
															#line 726 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(numRequests.present());
															#line 728 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(restoreRequestKeys, CLIENT_KNOBS->TOO_MANY);
															#line 728 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5269 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state = 2;
															#line 728 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CollectRestoreRequestsActor, 1, RangeResult >*>(static_cast<CollectRestoreRequestsActor*>(this)));
															#line 5274 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& numRequests,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(numRequests, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && numRequests,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(numRequests), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<CollectRestoreRequestsActor*>(this)->ActorCallback< CollectRestoreRequestsActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CollectRestoreRequestsActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CollectRestoreRequestsActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CollectRestoreRequestsActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& restoreRequestValues,int loopDepth) 
	{
															#line 729 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(!restoreRequestValues.more);
															#line 730 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (restoreRequestValues.size())
															#line 5360 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 731 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( auto& it : restoreRequestValues ) {
															#line 732 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				restoreRequests.push_back(decodeRestoreRequestValue(it.value));
															#line 733 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent("FastRestoreControllerPhaseCollectRestoreRequests") .detail("RestoreRequest", restoreRequests.back().toString());
															#line 5368 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 738 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent(SevError, "FastRestoreControllerPhaseCollectRestoreRequestsEmptyRequests").log();
															#line 739 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(5.0);
															#line 739 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5380 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state = 3;
															#line 739 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CollectRestoreRequestsActor, 2, Void >*>(static_cast<CollectRestoreRequestsActor*>(this)));
															#line 5385 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && restoreRequestValues,int loopDepth) 
	{
															#line 729 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(!restoreRequestValues.more);
															#line 730 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (restoreRequestValues.size())
															#line 5397 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 731 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( auto& it : restoreRequestValues ) {
															#line 732 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				restoreRequests.push_back(decodeRestoreRequestValue(it.value));
															#line 733 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent("FastRestoreControllerPhaseCollectRestoreRequests") .detail("RestoreRequest", restoreRequests.back().toString());
															#line 5405 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
		else
		{
															#line 738 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent(SevError, "FastRestoreControllerPhaseCollectRestoreRequestsEmptyRequests").log();
															#line 739 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_2 = delay(5.0);
															#line 739 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5417 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
			static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state = 3;
															#line 739 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CollectRestoreRequestsActor, 2, Void >*>(static_cast<CollectRestoreRequestsActor*>(this)));
															#line 5422 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& restoreRequestValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(restoreRequestValues, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && restoreRequestValues,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(restoreRequestValues), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<CollectRestoreRequestsActor*>(this)->ActorCallback< CollectRestoreRequestsActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< CollectRestoreRequestsActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CollectRestoreRequestsActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CollectRestoreRequestsActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<CollectRestoreRequestsActor*>(this)->ActorCallback< CollectRestoreRequestsActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CollectRestoreRequestsActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CollectRestoreRequestsActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CollectRestoreRequestsActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1cont8(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state > 0) static_cast<CollectRestoreRequestsActor*>(this)->actor_wait_state = 0;
		static_cast<CollectRestoreRequestsActor*>(this)->ActorCallback< CollectRestoreRequestsActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CollectRestoreRequestsActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< CollectRestoreRequestsActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< CollectRestoreRequestsActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectRestoreRequests", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 712 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Database cx;
															#line 713 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<RestoreRequest> restoreRequests;
															#line 714 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Future<Void> watch4RestoreRequest;
															#line 715 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 5704 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via collectRestoreRequests()
															#line 712 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class CollectRestoreRequestsActor final : public Actor<std::vector<RestoreRequest>>, public ActorCallback< CollectRestoreRequestsActor, 0, Optional<Value> >, public ActorCallback< CollectRestoreRequestsActor, 1, RangeResult >, public ActorCallback< CollectRestoreRequestsActor, 2, Void >, public ActorCallback< CollectRestoreRequestsActor, 3, Void >, public FastAllocated<CollectRestoreRequestsActor>, public CollectRestoreRequestsActorState<CollectRestoreRequestsActor> {
															#line 5709 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<CollectRestoreRequestsActor>::operator new;
	using FastAllocated<CollectRestoreRequestsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4067566216299839744UL, 7116688026159631104UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<RestoreRequest>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CollectRestoreRequestsActor, 0, Optional<Value> >;
friend struct ActorCallback< CollectRestoreRequestsActor, 1, RangeResult >;
friend struct ActorCallback< CollectRestoreRequestsActor, 2, Void >;
friend struct ActorCallback< CollectRestoreRequestsActor, 3, Void >;
															#line 712 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	CollectRestoreRequestsActor(Database const& cx) 
															#line 5729 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<std::vector<RestoreRequest>>(),
		   CollectRestoreRequestsActorState<CollectRestoreRequestsActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("collectRestoreRequests", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6180299361668164352UL, 8770844308289193728UL);
		ActorExecutionContextHelper __helper(static_cast<CollectRestoreRequestsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("collectRestoreRequests");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("collectRestoreRequests", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CollectRestoreRequestsActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CollectRestoreRequestsActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CollectRestoreRequestsActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< CollectRestoreRequestsActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 712 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<std::vector<RestoreRequest>> collectRestoreRequests( Database const& cx ) {
															#line 712 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<std::vector<RestoreRequest>>(new CollectRestoreRequestsActor(cx));
															#line 5765 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 748 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

// Collect the backup files' description into output_files by reading the backupContainer bc.
// Returns the restore target version.
															#line 5772 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via collectBackupFiles()
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class CollectBackupFilesActor>
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class CollectBackupFilesActorState {
															#line 5779 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	CollectBackupFilesActorState(Reference<IBackupContainer> const& bc,std::vector<RestoreFileFR>* const& rangeFiles,std::vector<RestoreFileFR>* const& logFiles,Version* const& minRangeVersion,Database const& cx,RestoreRequest const& request) 
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : bc(bc),
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   rangeFiles(rangeFiles),
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   logFiles(logFiles),
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   minRangeVersion(minRangeVersion),
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   cx(cx),
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   request(request)
															#line 5796 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("collectBackupFiles", reinterpret_cast<unsigned long>(this));

	}
	~CollectBackupFilesActorState() 
	{
		fdb_probe_actor_destroy("collectBackupFiles", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 757 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<BackupDescription> __when_expr_0 = bc->describeBackup();
															#line 757 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<CollectBackupFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5813 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CollectBackupFilesActor*>(this)->actor_wait_state = 1;
															#line 757 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CollectBackupFilesActor, 0, BackupDescription >*>(static_cast<CollectBackupFilesActor*>(this)));
															#line 5818 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CollectBackupFilesActorState();
		static_cast<CollectBackupFilesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 760 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = desc.resolveVersionTimes(cx);
															#line 760 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<CollectBackupFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5843 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<CollectBackupFilesActor*>(this)->actor_wait_state = 2;
															#line 760 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CollectBackupFilesActor, 1, Void >*>(static_cast<CollectBackupFilesActor*>(this)));
															#line 5848 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(BackupDescription const& __desc,int loopDepth) 
	{
															#line 757 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		desc = __desc;
															#line 5857 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(BackupDescription && __desc,int loopDepth) 
	{
		desc = std::move(__desc);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CollectBackupFilesActor*>(this)->actor_wait_state > 0) static_cast<CollectBackupFilesActor*>(this)->actor_wait_state = 0;
		static_cast<CollectBackupFilesActor*>(this)->ActorCallback< CollectBackupFilesActor, 0, BackupDescription >::remove();

	}
	void a_callback_fire(ActorCallback< CollectBackupFilesActor, 0, BackupDescription >*,BackupDescription const& value) 
	{
		fdb_probe_actor_enter("collectBackupFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectBackupFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectBackupFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CollectBackupFilesActor, 0, BackupDescription >*,BackupDescription && value) 
	{
		fdb_probe_actor_enter("collectBackupFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectBackupFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectBackupFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CollectBackupFilesActor, 0, BackupDescription >*,Error err) 
	{
		fdb_probe_actor_enter("collectBackupFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CollectBackupFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectBackupFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 762 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (request.targetVersion == invalidVersion && desc.maxRestorableVersion.present())
															#line 5936 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 763 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			request.targetVersion = desc.maxRestorableVersion.get();
															#line 5940 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 766 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseCollectBackupFilesStart") .detail("TargetVersion", request.targetVersion) .detail("BackupDesc", desc.toString()) .detail("UseRangeFile", SERVER_KNOBS->FASTRESTORE_USE_RANGE_FILE) .detail("UseLogFile", SERVER_KNOBS->FASTRESTORE_USE_LOG_FILE);
															#line 771 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (g_network->isSimulated())
															#line 5946 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 772 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			std::cout << "Restore to version: " << request.targetVersion << "\nBackupDesc: \n" << desc.toString() << "\n\n";
															#line 5950 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 775 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		restoreRanges = VectorRef<KeyRangeRef>();
															#line 776 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		restoreRanges.add(request.range);
															#line 777 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Optional<RestorableFileSet>> __when_expr_2 = bc->getRestoreSet(request.targetVersion, restoreRanges);
															#line 777 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<CollectBackupFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5960 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CollectBackupFilesActor*>(this)->actor_wait_state = 3;
															#line 777 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CollectBackupFilesActor, 2, Optional<RestorableFileSet> >*>(static_cast<CollectBackupFilesActor*>(this)));
															#line 5965 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 762 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (request.targetVersion == invalidVersion && desc.maxRestorableVersion.present())
															#line 5974 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 763 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			request.targetVersion = desc.maxRestorableVersion.get();
															#line 5978 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 766 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseCollectBackupFilesStart") .detail("TargetVersion", request.targetVersion) .detail("BackupDesc", desc.toString()) .detail("UseRangeFile", SERVER_KNOBS->FASTRESTORE_USE_RANGE_FILE) .detail("UseLogFile", SERVER_KNOBS->FASTRESTORE_USE_LOG_FILE);
															#line 771 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (g_network->isSimulated())
															#line 5984 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 772 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			std::cout << "Restore to version: " << request.targetVersion << "\nBackupDesc: \n" << desc.toString() << "\n\n";
															#line 5988 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 775 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		restoreRanges = VectorRef<KeyRangeRef>();
															#line 776 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		restoreRanges.add(request.range);
															#line 777 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Optional<RestorableFileSet>> __when_expr_2 = bc->getRestoreSet(request.targetVersion, restoreRanges);
															#line 777 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<CollectBackupFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 5998 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2when1(__when_expr_2.get(), loopDepth); };
		static_cast<CollectBackupFilesActor*>(this)->actor_wait_state = 3;
															#line 777 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CollectBackupFilesActor, 2, Optional<RestorableFileSet> >*>(static_cast<CollectBackupFilesActor*>(this)));
															#line 6003 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CollectBackupFilesActor*>(this)->actor_wait_state > 0) static_cast<CollectBackupFilesActor*>(this)->actor_wait_state = 0;
		static_cast<CollectBackupFilesActor*>(this)->ActorCallback< CollectBackupFilesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CollectBackupFilesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("collectBackupFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectBackupFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectBackupFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CollectBackupFilesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("collectBackupFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectBackupFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectBackupFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CollectBackupFilesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("collectBackupFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CollectBackupFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectBackupFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(Optional<RestorableFileSet> const& restorable,int loopDepth) 
	{
															#line 779 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!restorable.present())
															#line 6087 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 780 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent(SevWarn, "FastRestoreControllerPhaseCollectBackupFiles") .detail("NotRestorable", request.targetVersion);
															#line 782 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			return a_body1Catch1(restore_missing_data(), loopDepth);
															#line 6093 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 785 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(rangeFiles->empty());
															#line 786 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(logFiles->empty());
															#line 788 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		std::set<RestoreFileFR> uniqueRangeFiles;
															#line 789 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		std::set<RestoreFileFR> uniqueLogFiles;
															#line 790 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		double rangeSize = 0;
															#line 791 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		double logSize = 0;
															#line 792 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		*minRangeVersion = MAX_VERSION;
															#line 793 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (SERVER_KNOBS->FASTRESTORE_USE_RANGE_FILE)
															#line 6111 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 794 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( const RangeFile& f : restorable.get().ranges ) {
															#line 795 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevFRDebugInfo, "FastRestoreControllerPhaseCollectBackupFiles") .detail("RangeFile", f.toString());
															#line 797 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (f.fileSize <= 0)
															#line 6119 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 800 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				RestoreFileFR file(f);
															#line 801 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevFRDebugInfo, "FastRestoreControllerPhaseCollectBackupFiles") .detail("RangeFileFR", file.toString());
															#line 803 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				uniqueRangeFiles.insert(file);
															#line 804 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				rangeSize += file.fileSize;
															#line 805 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				*minRangeVersion = std::min(*minRangeVersion, file.version);
															#line 6133 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
		}
															#line 808 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (MAX_VERSION == *minRangeVersion)
															#line 6138 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 809 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			*minRangeVersion = 0;
															#line 6142 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 812 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (SERVER_KNOBS->FASTRESTORE_USE_LOG_FILE)
															#line 6146 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 813 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( const LogFile& f : restorable.get().logs ) {
															#line 814 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevFRDebugInfo, "FastRestoreControllerPhaseCollectBackupFiles").detail("LogFile", f.toString());
															#line 815 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (f.fileSize <= 0)
															#line 6154 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 818 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				RestoreFileFR file(f);
															#line 819 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevFRDebugInfo, "FastRestoreControllerPhaseCollectBackupFiles") .detail("LogFileFR", file.toString());
															#line 821 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				logFiles->push_back(file);
															#line 822 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				uniqueLogFiles.insert(file);
															#line 823 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				logSize += file.fileSize;
															#line 6168 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
		}
															#line 828 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		rangeFiles->assign(uniqueRangeFiles.begin(), uniqueRangeFiles.end());
															#line 829 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		logFiles->assign(uniqueLogFiles.begin(), uniqueLogFiles.end());
															#line 831 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseCollectBackupFilesDone") .detail("BackupDesc", desc.toString()) .detail("RangeFiles", rangeFiles->size()) .detail("LogFiles", logFiles->size()) .detail("RangeFileBytes", rangeSize) .detail("LogFileBytes", logSize) .detail("UseRangeFile", SERVER_KNOBS->FASTRESTORE_USE_RANGE_FILE) .detail("UseLogFile", SERVER_KNOBS->FASTRESTORE_USE_LOG_FILE);
															#line 839 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<CollectBackupFilesActor*>(this)->SAV<Version>::futures) { (void)(request.targetVersion); this->~CollectBackupFilesActorState(); static_cast<CollectBackupFilesActor*>(this)->destroy(); return 0; }
															#line 6179 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<CollectBackupFilesActor*>(this)->SAV< Version >::value()) Version(request.targetVersion);
		this->~CollectBackupFilesActorState();
		static_cast<CollectBackupFilesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Optional<RestorableFileSet> && restorable,int loopDepth) 
	{
															#line 779 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!restorable.present())
															#line 6191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 780 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent(SevWarn, "FastRestoreControllerPhaseCollectBackupFiles") .detail("NotRestorable", request.targetVersion);
															#line 782 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			return a_body1Catch1(restore_missing_data(), loopDepth);
															#line 6197 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 785 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(rangeFiles->empty());
															#line 786 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(logFiles->empty());
															#line 788 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		std::set<RestoreFileFR> uniqueRangeFiles;
															#line 789 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		std::set<RestoreFileFR> uniqueLogFiles;
															#line 790 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		double rangeSize = 0;
															#line 791 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		double logSize = 0;
															#line 792 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		*minRangeVersion = MAX_VERSION;
															#line 793 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (SERVER_KNOBS->FASTRESTORE_USE_RANGE_FILE)
															#line 6215 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 794 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( const RangeFile& f : restorable.get().ranges ) {
															#line 795 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevFRDebugInfo, "FastRestoreControllerPhaseCollectBackupFiles") .detail("RangeFile", f.toString());
															#line 797 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (f.fileSize <= 0)
															#line 6223 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 800 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				RestoreFileFR file(f);
															#line 801 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevFRDebugInfo, "FastRestoreControllerPhaseCollectBackupFiles") .detail("RangeFileFR", file.toString());
															#line 803 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				uniqueRangeFiles.insert(file);
															#line 804 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				rangeSize += file.fileSize;
															#line 805 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				*minRangeVersion = std::min(*minRangeVersion, file.version);
															#line 6237 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
		}
															#line 808 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (MAX_VERSION == *minRangeVersion)
															#line 6242 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 809 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			*minRangeVersion = 0;
															#line 6246 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 812 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (SERVER_KNOBS->FASTRESTORE_USE_LOG_FILE)
															#line 6250 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 813 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( const LogFile& f : restorable.get().logs ) {
															#line 814 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevFRDebugInfo, "FastRestoreControllerPhaseCollectBackupFiles").detail("LogFile", f.toString());
															#line 815 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (f.fileSize <= 0)
															#line 6258 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				{
					continue;
				}
															#line 818 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				RestoreFileFR file(f);
															#line 819 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevFRDebugInfo, "FastRestoreControllerPhaseCollectBackupFiles") .detail("LogFileFR", file.toString());
															#line 821 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				logFiles->push_back(file);
															#line 822 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				uniqueLogFiles.insert(file);
															#line 823 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				logSize += file.fileSize;
															#line 6272 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
		}
															#line 828 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		rangeFiles->assign(uniqueRangeFiles.begin(), uniqueRangeFiles.end());
															#line 829 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		logFiles->assign(uniqueLogFiles.begin(), uniqueLogFiles.end());
															#line 831 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseCollectBackupFilesDone") .detail("BackupDesc", desc.toString()) .detail("RangeFiles", rangeFiles->size()) .detail("LogFiles", logFiles->size()) .detail("RangeFileBytes", rangeSize) .detail("LogFileBytes", logSize) .detail("UseRangeFile", SERVER_KNOBS->FASTRESTORE_USE_RANGE_FILE) .detail("UseLogFile", SERVER_KNOBS->FASTRESTORE_USE_LOG_FILE);
															#line 839 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<CollectBackupFilesActor*>(this)->SAV<Version>::futures) { (void)(request.targetVersion); this->~CollectBackupFilesActorState(); static_cast<CollectBackupFilesActor*>(this)->destroy(); return 0; }
															#line 6283 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<CollectBackupFilesActor*>(this)->SAV< Version >::value()) Version(request.targetVersion);
		this->~CollectBackupFilesActorState();
		static_cast<CollectBackupFilesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Optional<RestorableFileSet> const& restorable,int loopDepth) 
	{
		loopDepth = a_body1cont3(restorable, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Optional<RestorableFileSet> && restorable,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(restorable), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CollectBackupFilesActor*>(this)->actor_wait_state > 0) static_cast<CollectBackupFilesActor*>(this)->actor_wait_state = 0;
		static_cast<CollectBackupFilesActor*>(this)->ActorCallback< CollectBackupFilesActor, 2, Optional<RestorableFileSet> >::remove();

	}
	void a_callback_fire(ActorCallback< CollectBackupFilesActor, 2, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> const& value) 
	{
		fdb_probe_actor_enter("collectBackupFiles", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectBackupFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectBackupFiles", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CollectBackupFilesActor, 2, Optional<RestorableFileSet> >*,Optional<RestorableFileSet> && value) 
	{
		fdb_probe_actor_enter("collectBackupFiles", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CollectBackupFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectBackupFiles", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CollectBackupFilesActor, 2, Optional<RestorableFileSet> >*,Error err) 
	{
		fdb_probe_actor_enter("collectBackupFiles", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CollectBackupFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("collectBackupFiles", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<RestoreFileFR>* rangeFiles;
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<RestoreFileFR>* logFiles;
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Version* minRangeVersion;
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Database cx;
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	RestoreRequest request;
															#line 757 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	BackupDescription desc;
															#line 775 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	VectorRef<KeyRangeRef> restoreRanges;
															#line 6382 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via collectBackupFiles()
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class CollectBackupFilesActor final : public Actor<Version>, public ActorCallback< CollectBackupFilesActor, 0, BackupDescription >, public ActorCallback< CollectBackupFilesActor, 1, Void >, public ActorCallback< CollectBackupFilesActor, 2, Optional<RestorableFileSet> >, public FastAllocated<CollectBackupFilesActor>, public CollectBackupFilesActorState<CollectBackupFilesActor> {
															#line 6387 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<CollectBackupFilesActor>::operator new;
	using FastAllocated<CollectBackupFilesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3894182538072774400UL, 14233710407407617024UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Version>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CollectBackupFilesActor, 0, BackupDescription >;
friend struct ActorCallback< CollectBackupFilesActor, 1, Void >;
friend struct ActorCallback< CollectBackupFilesActor, 2, Optional<RestorableFileSet> >;
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	CollectBackupFilesActor(Reference<IBackupContainer> const& bc,std::vector<RestoreFileFR>* const& rangeFiles,std::vector<RestoreFileFR>* const& logFiles,Version* const& minRangeVersion,Database const& cx,RestoreRequest const& request) 
															#line 6406 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Version>(),
		   CollectBackupFilesActorState<CollectBackupFilesActor>(bc, rangeFiles, logFiles, minRangeVersion, cx, request),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("collectBackupFiles", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(787573320604149504UL, 3710720400712921600UL);
		ActorExecutionContextHelper __helper(static_cast<CollectBackupFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("collectBackupFiles");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("collectBackupFiles", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CollectBackupFilesActor, 0, BackupDescription >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CollectBackupFilesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CollectBackupFilesActor, 2, Optional<RestorableFileSet> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Version> collectBackupFiles( Reference<IBackupContainer> const& bc, std::vector<RestoreFileFR>* const& rangeFiles, std::vector<RestoreFileFR>* const& logFiles, Version* const& minRangeVersion, Database const& cx, RestoreRequest const& request ) {
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Version>(new CollectBackupFilesActor(bc, rangeFiles, logFiles, minRangeVersion, cx, request));
															#line 6441 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 841 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

// By the first and last block of *file to get (beginKey, endKey);
// set (beginKey, endKey) and file->version to pRangeVersions
															#line 6448 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via insertRangeVersion()
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class InsertRangeVersionActor>
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class InsertRangeVersionActorState {
															#line 6455 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	InsertRangeVersionActorState(KeyRangeMap<Version>* const& pRangeVersions,RestoreFileFR* const& file,Reference<IBackupContainer> const& bc,Database const& cx) 
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : pRangeVersions(pRangeVersions),
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   file(file),
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   bc(bc),
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   cx(cx)
															#line 6468 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("insertRangeVersion", reinterpret_cast<unsigned long>(this));

	}
	~InsertRangeVersionActorState() 
	{
		fdb_probe_actor_destroy("insertRangeVersion", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 848 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent("FastRestoreControllerDecodeRangeVersion").detail("File", file->toString());
															#line 849 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			RangeFile rangeFile = { file->version, (uint32_t)file->blockSize, file->fileName, file->fileSize };
															#line 852 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<KeyRange> __when_expr_0 = bc->getSnapshotFileKeyRange(rangeFile, cx);
															#line 852 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<InsertRangeVersionActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6489 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InsertRangeVersionActor*>(this)->actor_wait_state = 1;
															#line 852 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InsertRangeVersionActor, 0, KeyRange >*>(static_cast<InsertRangeVersionActor*>(this)));
															#line 6494 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InsertRangeVersionActorState();
		static_cast<InsertRangeVersionActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(KeyRange const& fileRange,int loopDepth) 
	{
															#line 853 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerInsertRangeVersion") .detail("DecodedRangeFile", file->fileName) .detail("KeyRange", fileRange) .detail("Version", file->version);
															#line 858 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		auto ranges = pRangeVersions->modify(fileRange);
															#line 859 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for(auto r = ranges.begin();r != ranges.end();++r) {
															#line 860 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			r->value() = std::max(r->value(), file->version);
															#line 6523 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 863 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (SERVER_KNOBS->FASTRESTORE_DUMP_INSERT_RANGE_VERSION)
															#line 6527 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 865 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ranges = pRangeVersions->ranges();
															#line 866 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			int i = 0;
															#line 867 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for(auto r = ranges.begin();r != ranges.end();++r) {
															#line 868 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevDebug, "RangeVersionsAfterUpdate") .detail("File", file->toString()) .detail("FileRange", fileRange.toString()) .detail("FileVersion", file->version) .detail("RangeIndex", i++) .detail("RangeBegin", r->begin()) .detail("RangeEnd", r->end()) .detail("RangeVersion", r->value());
															#line 6537 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
		}
															#line 879 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<InsertRangeVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InsertRangeVersionActorState(); static_cast<InsertRangeVersionActor*>(this)->destroy(); return 0; }
															#line 6542 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<InsertRangeVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InsertRangeVersionActorState();
		static_cast<InsertRangeVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(KeyRange && fileRange,int loopDepth) 
	{
															#line 853 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerInsertRangeVersion") .detail("DecodedRangeFile", file->fileName) .detail("KeyRange", fileRange) .detail("Version", file->version);
															#line 858 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		auto ranges = pRangeVersions->modify(fileRange);
															#line 859 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for(auto r = ranges.begin();r != ranges.end();++r) {
															#line 860 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			r->value() = std::max(r->value(), file->version);
															#line 6560 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 863 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (SERVER_KNOBS->FASTRESTORE_DUMP_INSERT_RANGE_VERSION)
															#line 6564 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 865 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ranges = pRangeVersions->ranges();
															#line 866 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			int i = 0;
															#line 867 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for(auto r = ranges.begin();r != ranges.end();++r) {
															#line 868 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevDebug, "RangeVersionsAfterUpdate") .detail("File", file->toString()) .detail("FileRange", fileRange.toString()) .detail("FileVersion", file->version) .detail("RangeIndex", i++) .detail("RangeBegin", r->begin()) .detail("RangeEnd", r->end()) .detail("RangeVersion", r->value());
															#line 6574 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
		}
															#line 879 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<InsertRangeVersionActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InsertRangeVersionActorState(); static_cast<InsertRangeVersionActor*>(this)->destroy(); return 0; }
															#line 6579 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<InsertRangeVersionActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InsertRangeVersionActorState();
		static_cast<InsertRangeVersionActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(KeyRange const& fileRange,int loopDepth) 
	{
		loopDepth = a_body1cont1(fileRange, loopDepth);

		return loopDepth;
	}
	int a_body1when1(KeyRange && fileRange,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(fileRange), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InsertRangeVersionActor*>(this)->actor_wait_state > 0) static_cast<InsertRangeVersionActor*>(this)->actor_wait_state = 0;
		static_cast<InsertRangeVersionActor*>(this)->ActorCallback< InsertRangeVersionActor, 0, KeyRange >::remove();

	}
	void a_callback_fire(ActorCallback< InsertRangeVersionActor, 0, KeyRange >*,KeyRange const& value) 
	{
		fdb_probe_actor_enter("insertRangeVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InsertRangeVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("insertRangeVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InsertRangeVersionActor, 0, KeyRange >*,KeyRange && value) 
	{
		fdb_probe_actor_enter("insertRangeVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InsertRangeVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("insertRangeVersion", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InsertRangeVersionActor, 0, KeyRange >*,Error err) 
	{
		fdb_probe_actor_enter("insertRangeVersion", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InsertRangeVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("insertRangeVersion", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	KeyRangeMap<Version>* pRangeVersions;
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	RestoreFileFR* file;
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<IBackupContainer> bc;
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Database cx;
															#line 6670 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via insertRangeVersion()
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class InsertRangeVersionActor final : public Actor<Void>, public ActorCallback< InsertRangeVersionActor, 0, KeyRange >, public FastAllocated<InsertRangeVersionActor>, public InsertRangeVersionActorState<InsertRangeVersionActor> {
															#line 6675 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<InsertRangeVersionActor>::operator new;
	using FastAllocated<InsertRangeVersionActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17807063372816897792UL, 7160258568944754688UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InsertRangeVersionActor, 0, KeyRange >;
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	InsertRangeVersionActor(KeyRangeMap<Version>* const& pRangeVersions,RestoreFileFR* const& file,Reference<IBackupContainer> const& bc,Database const& cx) 
															#line 6692 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   InsertRangeVersionActorState<InsertRangeVersionActor>(pRangeVersions, file, bc, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("insertRangeVersion", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4339928517800382464UL, 12592096180063873792UL);
		ActorExecutionContextHelper __helper(static_cast<InsertRangeVersionActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("insertRangeVersion");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("insertRangeVersion", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InsertRangeVersionActor, 0, KeyRange >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Void> insertRangeVersion( KeyRangeMap<Version>* const& pRangeVersions, RestoreFileFR* const& file, Reference<IBackupContainer> const& bc, Database const& cx ) {
															#line 844 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new InsertRangeVersionActor(pRangeVersions, file, bc, cx));
															#line 6725 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 881 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

// Build the version skyline of snapshot ranges by parsing range files;
// Expensive and slow operation that should not run in real prod.
															#line 6732 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via buildRangeVersions()
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class BuildRangeVersionsActor>
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class BuildRangeVersionsActorState {
															#line 6739 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	BuildRangeVersionsActorState(KeyRangeMap<Version>* const& pRangeVersions,std::vector<RestoreFileFR>* const& pRangeFiles,Key const& url,Optional<std::string> const& proxy,Database const& cx) 
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : pRangeVersions(pRangeVersions),
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   pRangeFiles(pRangeFiles),
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   url(url),
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   proxy(proxy),
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   cx(cx)
															#line 6754 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("buildRangeVersions", reinterpret_cast<unsigned long>(this));

	}
	~BuildRangeVersionsActorState() 
	{
		fdb_probe_actor_destroy("buildRangeVersions", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 889 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (!g_network->isSimulated())
															#line 6769 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 890 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevError, "ExpensiveBuildRangeVersions") .detail("Reason", "Parsing all range files is slow and memory intensive");
															#line 892 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (!static_cast<BuildRangeVersionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BuildRangeVersionsActorState(); static_cast<BuildRangeVersionsActor*>(this)->destroy(); return 0; }
															#line 6775 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				new (&static_cast<BuildRangeVersionsActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~BuildRangeVersionsActorState();
				static_cast<BuildRangeVersionsActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 894 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			Reference<IBackupContainer> bc = IBackupContainer::openContainer(url.toString(), proxy, {});
															#line 898 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			fileIndex = 0;
															#line 899 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			fInsertRangeVersions = std::vector<Future<Void>>();
															#line 900 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for(;fileIndex < pRangeFiles->size();++fileIndex) {
															#line 901 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				fInsertRangeVersions.push_back(insertRangeVersion(pRangeVersions, &pRangeFiles->at(fileIndex), bc, cx));
															#line 6791 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 904 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAll(fInsertRangeVersions);
															#line 904 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<BuildRangeVersionsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 6797 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<BuildRangeVersionsActor*>(this)->actor_wait_state = 1;
															#line 904 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< BuildRangeVersionsActor, 0, Void >*>(static_cast<BuildRangeVersionsActor*>(this)));
															#line 6802 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~BuildRangeVersionsActorState();
		static_cast<BuildRangeVersionsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 906 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<BuildRangeVersionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BuildRangeVersionsActorState(); static_cast<BuildRangeVersionsActor*>(this)->destroy(); return 0; }
															#line 6825 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<BuildRangeVersionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BuildRangeVersionsActorState();
		static_cast<BuildRangeVersionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 906 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<BuildRangeVersionsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~BuildRangeVersionsActorState(); static_cast<BuildRangeVersionsActor*>(this)->destroy(); return 0; }
															#line 6837 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<BuildRangeVersionsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~BuildRangeVersionsActorState();
		static_cast<BuildRangeVersionsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<BuildRangeVersionsActor*>(this)->actor_wait_state > 0) static_cast<BuildRangeVersionsActor*>(this)->actor_wait_state = 0;
		static_cast<BuildRangeVersionsActor*>(this)->ActorCallback< BuildRangeVersionsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< BuildRangeVersionsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("buildRangeVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildRangeVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildRangeVersions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< BuildRangeVersionsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("buildRangeVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<BuildRangeVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildRangeVersions", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< BuildRangeVersionsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("buildRangeVersions", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<BuildRangeVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("buildRangeVersions", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	KeyRangeMap<Version>* pRangeVersions;
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<RestoreFileFR>* pRangeFiles;
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Key url;
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Optional<std::string> proxy;
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Database cx;
															#line 898 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	int fileIndex;
															#line 899 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<Future<Void>> fInsertRangeVersions;
															#line 6934 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via buildRangeVersions()
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class BuildRangeVersionsActor final : public Actor<Void>, public ActorCallback< BuildRangeVersionsActor, 0, Void >, public FastAllocated<BuildRangeVersionsActor>, public BuildRangeVersionsActorState<BuildRangeVersionsActor> {
															#line 6939 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<BuildRangeVersionsActor>::operator new;
	using FastAllocated<BuildRangeVersionsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8773700295048194304UL, 3752396208979850240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< BuildRangeVersionsActor, 0, Void >;
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	BuildRangeVersionsActor(KeyRangeMap<Version>* const& pRangeVersions,std::vector<RestoreFileFR>* const& pRangeFiles,Key const& url,Optional<std::string> const& proxy,Database const& cx) 
															#line 6956 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   BuildRangeVersionsActorState<BuildRangeVersionsActor>(pRangeVersions, pRangeFiles, url, proxy, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("buildRangeVersions", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13965785796847574016UL, 2432683052982404352UL);
		ActorExecutionContextHelper __helper(static_cast<BuildRangeVersionsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("buildRangeVersions");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("buildRangeVersions", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< BuildRangeVersionsActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Void> buildRangeVersions( KeyRangeMap<Version>* const& pRangeVersions, std::vector<RestoreFileFR>* const& pRangeFiles, Key const& url, Optional<std::string> const& proxy, Database const& cx ) {
															#line 884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new BuildRangeVersionsActor(pRangeVersions, pRangeFiles, url, proxy, cx));
															#line 6989 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 908 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

/*
ACTOR static Future<Void> clearDB(Database cx) {
    wait(runRYWTransaction(cx, [](Reference<ReadYourWritesTransaction> tr) -> Future<Void> {
        tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
        tr->setOption(FDBTransactionOptions::LOCK_AWARE);
        tr->clear(normalKeys);
        return Void();
    }));

    return Void();
}
*/

															#line 7007 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via initializeVersionBatch()
															#line 922 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class InitializeVersionBatchActor>
															#line 922 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class InitializeVersionBatchActorState {
															#line 7014 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 922 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	InitializeVersionBatchActorState(std::map<UID, RestoreApplierInterface> const& appliersInterf,std::map<UID, RestoreLoaderInterface> const& loadersInterf,int const& batchIndex) 
															#line 922 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 922 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : appliersInterf(appliersInterf),
															#line 922 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   loadersInterf(loadersInterf),
															#line 922 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   batchIndex(batchIndex)
															#line 7025 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("initializeVersionBatch", reinterpret_cast<unsigned long>(this));

	}
	~InitializeVersionBatchActorState() 
	{
		fdb_probe_actor_destroy("initializeVersionBatch", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 925 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent("FastRestoreControllerPhaseInitVersionBatchForAppliersStart") .detail("BatchIndex", batchIndex) .detail("Appliers", appliersInterf.size());
															#line 928 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			std::vector<std::pair<UID, RestoreVersionBatchRequest>> requestsToAppliers;
															#line 929 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			requestsToAppliers.reserve(appliersInterf.size());
															#line 930 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( auto& applier : appliersInterf ) {
															#line 931 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				requestsToAppliers.emplace_back(applier.first, RestoreVersionBatchRequest(batchIndex));
															#line 7048 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 933 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = sendBatchRequests(&RestoreApplierInterface::initVersionBatch, appliersInterf, requestsToAppliers);
															#line 933 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<InitializeVersionBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7054 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InitializeVersionBatchActor*>(this)->actor_wait_state = 1;
															#line 933 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InitializeVersionBatchActor, 0, Void >*>(static_cast<InitializeVersionBatchActor*>(this)));
															#line 7059 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InitializeVersionBatchActorState();
		static_cast<InitializeVersionBatchActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 935 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseInitVersionBatchForLoaders") .detail("BatchIndex", batchIndex) .detail("Loaders", loadersInterf.size());
															#line 938 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		std::vector<std::pair<UID, RestoreVersionBatchRequest>> requestsToLoaders;
															#line 939 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		requestsToLoaders.reserve(loadersInterf.size());
															#line 940 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& loader : loadersInterf ) {
															#line 941 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			requestsToLoaders.emplace_back(loader.first, RestoreVersionBatchRequest(batchIndex));
															#line 7090 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 943 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = sendBatchRequests(&RestoreLoaderInterface::initVersionBatch, loadersInterf, requestsToLoaders);
															#line 943 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<InitializeVersionBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7096 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<InitializeVersionBatchActor*>(this)->actor_wait_state = 2;
															#line 943 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitializeVersionBatchActor, 1, Void >*>(static_cast<InitializeVersionBatchActor*>(this)));
															#line 7101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 935 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseInitVersionBatchForLoaders") .detail("BatchIndex", batchIndex) .detail("Loaders", loadersInterf.size());
															#line 938 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		std::vector<std::pair<UID, RestoreVersionBatchRequest>> requestsToLoaders;
															#line 939 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		requestsToLoaders.reserve(loadersInterf.size());
															#line 940 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& loader : loadersInterf ) {
															#line 941 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			requestsToLoaders.emplace_back(loader.first, RestoreVersionBatchRequest(batchIndex));
															#line 7118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 943 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = sendBatchRequests(&RestoreLoaderInterface::initVersionBatch, loadersInterf, requestsToLoaders);
															#line 943 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<InitializeVersionBatchActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7124 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<InitializeVersionBatchActor*>(this)->actor_wait_state = 2;
															#line 943 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitializeVersionBatchActor, 1, Void >*>(static_cast<InitializeVersionBatchActor*>(this)));
															#line 7129 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InitializeVersionBatchActor*>(this)->actor_wait_state > 0) static_cast<InitializeVersionBatchActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeVersionBatchActor*>(this)->ActorCallback< InitializeVersionBatchActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeVersionBatchActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initializeVersionBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeVersionBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InitializeVersionBatchActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initializeVersionBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeVersionBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InitializeVersionBatchActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initializeVersionBatch", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeVersionBatch", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 945 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseInitVersionBatchForAppliersDone").detail("BatchIndex", batchIndex);
															#line 946 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<InitializeVersionBatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeVersionBatchActorState(); static_cast<InitializeVersionBatchActor*>(this)->destroy(); return 0; }
															#line 7215 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<InitializeVersionBatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeVersionBatchActorState();
		static_cast<InitializeVersionBatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 945 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseInitVersionBatchForAppliersDone").detail("BatchIndex", batchIndex);
															#line 946 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<InitializeVersionBatchActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~InitializeVersionBatchActorState(); static_cast<InitializeVersionBatchActor*>(this)->destroy(); return 0; }
															#line 7229 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<InitializeVersionBatchActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~InitializeVersionBatchActorState();
		static_cast<InitializeVersionBatchActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<InitializeVersionBatchActor*>(this)->actor_wait_state > 0) static_cast<InitializeVersionBatchActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeVersionBatchActor*>(this)->ActorCallback< InitializeVersionBatchActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeVersionBatchActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initializeVersionBatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeVersionBatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< InitializeVersionBatchActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initializeVersionBatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeVersionBatch", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< InitializeVersionBatchActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initializeVersionBatch", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeVersionBatch", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 922 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::map<UID, RestoreApplierInterface> appliersInterf;
															#line 922 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::map<UID, RestoreLoaderInterface> loadersInterf;
															#line 922 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	int batchIndex;
															#line 7318 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via initializeVersionBatch()
															#line 922 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class InitializeVersionBatchActor final : public Actor<Void>, public ActorCallback< InitializeVersionBatchActor, 0, Void >, public ActorCallback< InitializeVersionBatchActor, 1, Void >, public FastAllocated<InitializeVersionBatchActor>, public InitializeVersionBatchActorState<InitializeVersionBatchActor> {
															#line 7323 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<InitializeVersionBatchActor>::operator new;
	using FastAllocated<InitializeVersionBatchActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10233776420570651136UL, 10840552098077387264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InitializeVersionBatchActor, 0, Void >;
friend struct ActorCallback< InitializeVersionBatchActor, 1, Void >;
															#line 922 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	InitializeVersionBatchActor(std::map<UID, RestoreApplierInterface> const& appliersInterf,std::map<UID, RestoreLoaderInterface> const& loadersInterf,int const& batchIndex) 
															#line 7341 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   InitializeVersionBatchActorState<InitializeVersionBatchActor>(appliersInterf, loadersInterf, batchIndex),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("initializeVersionBatch", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12681903638159905536UL, 13559761476380750848UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeVersionBatchActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("initializeVersionBatch");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("initializeVersionBatch", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InitializeVersionBatchActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< InitializeVersionBatchActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 922 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Void> initializeVersionBatch( std::map<UID, RestoreApplierInterface> const& appliersInterf, std::map<UID, RestoreLoaderInterface> const& loadersInterf, int const& batchIndex ) {
															#line 922 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new InitializeVersionBatchActor(appliersInterf, loadersInterf, batchIndex));
															#line 7375 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 948 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

// Calculate the amount of data each applier should keep outstanding to DB;
// This is the amount of data that are in in-progress transactions.
															#line 7382 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via updateApplierWriteBW()
															#line 951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class UpdateApplierWriteBWActor>
															#line 951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class UpdateApplierWriteBWActorState {
															#line 7389 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	UpdateApplierWriteBWActorState(Reference<ControllerBatchData> const& batchData,std::map<UID, RestoreApplierInterface> const& appliersInterf,int const& batchIndex) 
															#line 951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : batchData(batchData),
															#line 951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   appliersInterf(appliersInterf),
															#line 951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   batchIndex(batchIndex),
															#line 954 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   applierRemainMB(),
															#line 955 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   totalRemainMB(SERVER_KNOBS->FASTRESTORE_WRITE_BW_MB),
															#line 956 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   standardAvgBW(SERVER_KNOBS->FASTRESTORE_WRITE_BW_MB / SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS),
															#line 957 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   loopCount(0),
															#line 958 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   replies(),
															#line 959 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   requests()
															#line 7412 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("updateApplierWriteBW", reinterpret_cast<unsigned long>(this));

	}
	~UpdateApplierWriteBWActorState() 
	{
		fdb_probe_actor_destroy("updateApplierWriteBW", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 960 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( auto& applier : appliersInterf ) {
															#line 961 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				applierRemainMB[applier.first] = SERVER_KNOBS->FASTRESTORE_WRITE_BW_MB / SERVER_KNOBS->FASTRESTORE_NUM_APPLIERS;
															#line 7429 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 964 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			;
															#line 7433 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~UpdateApplierWriteBWActorState();
		static_cast<UpdateApplierWriteBWActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 965 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		requests.clear();
															#line 966 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& applier : appliersInterf ) {
															#line 967 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			double writeRate = totalRemainMB > 1 ? (applierRemainMB[applier.first] / totalRemainMB) * SERVER_KNOBS->FASTRESTORE_WRITE_BW_MB : standardAvgBW;
															#line 970 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			requests.emplace_back(applier.first, RestoreUpdateRateRequest(batchIndex, writeRate));
															#line 7469 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 972 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		replies.clear();
															#line 973 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = getBatchReplies( &RestoreApplierInterface::updateRate, appliersInterf, requests, &replies, TaskPriority::DefaultEndpoint);
															#line 973 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<UpdateApplierWriteBWActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7477 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<UpdateApplierWriteBWActor*>(this)->actor_wait_state = 1;
															#line 973 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< UpdateApplierWriteBWActor, 0, Void >*>(static_cast<UpdateApplierWriteBWActor*>(this)));
															#line 7482 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 979 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(replies.size() == requests.size());
															#line 980 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		totalRemainMB = 0;
															#line 981 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for(int i = 0;i < replies.size();i++) {
															#line 982 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			UID& applierID = requests[i].first;
															#line 983 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			applierRemainMB[applierID] = replies[i].remainMB;
															#line 984 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			totalRemainMB += replies[i].remainMB;
															#line 7501 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 986 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(totalRemainMB >= 0);
															#line 987 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		double delayTime = SERVER_KNOBS->FASTRESTORE_RATE_UPDATE_SECONDS;
															#line 988 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (loopCount == 0)
															#line 7509 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 989 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			delayTime = 0.2;
															#line 7513 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 991 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		loopCount++;
															#line 992 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(delayTime);
															#line 992 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<UpdateApplierWriteBWActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7521 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateApplierWriteBWActor*>(this)->actor_wait_state = 2;
															#line 992 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateApplierWriteBWActor, 1, Void >*>(static_cast<UpdateApplierWriteBWActor*>(this)));
															#line 7526 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 979 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(replies.size() == requests.size());
															#line 980 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		totalRemainMB = 0;
															#line 981 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for(int i = 0;i < replies.size();i++) {
															#line 982 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			UID& applierID = requests[i].first;
															#line 983 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			applierRemainMB[applierID] = replies[i].remainMB;
															#line 984 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			totalRemainMB += replies[i].remainMB;
															#line 7545 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 986 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		ASSERT(totalRemainMB >= 0);
															#line 987 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		double delayTime = SERVER_KNOBS->FASTRESTORE_RATE_UPDATE_SECONDS;
															#line 988 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (loopCount == 0)
															#line 7553 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 989 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			delayTime = 0.2;
															#line 7557 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		}
															#line 991 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		loopCount++;
															#line 992 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(delayTime);
															#line 992 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<UpdateApplierWriteBWActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 7565 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<UpdateApplierWriteBWActor*>(this)->actor_wait_state = 2;
															#line 992 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< UpdateApplierWriteBWActor, 1, Void >*>(static_cast<UpdateApplierWriteBWActor*>(this)));
															#line 7570 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<UpdateApplierWriteBWActor*>(this)->actor_wait_state > 0) static_cast<UpdateApplierWriteBWActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateApplierWriteBWActor*>(this)->ActorCallback< UpdateApplierWriteBWActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateApplierWriteBWActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateApplierWriteBW", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateApplierWriteBWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateApplierWriteBW", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< UpdateApplierWriteBWActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateApplierWriteBW", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateApplierWriteBWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateApplierWriteBW", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< UpdateApplierWriteBWActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateApplierWriteBW", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateApplierWriteBWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateApplierWriteBW", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<UpdateApplierWriteBWActor*>(this)->actor_wait_state > 0) static_cast<UpdateApplierWriteBWActor*>(this)->actor_wait_state = 0;
		static_cast<UpdateApplierWriteBWActor*>(this)->ActorCallback< UpdateApplierWriteBWActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< UpdateApplierWriteBWActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("updateApplierWriteBW", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateApplierWriteBWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateApplierWriteBW", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< UpdateApplierWriteBWActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("updateApplierWriteBW", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateApplierWriteBWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateApplierWriteBW", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< UpdateApplierWriteBWActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("updateApplierWriteBW", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateApplierWriteBWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("updateApplierWriteBW", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<ControllerBatchData> batchData;
															#line 951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::map<UID, RestoreApplierInterface> appliersInterf;
															#line 951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	int batchIndex;
															#line 954 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::unordered_map<UID, double> applierRemainMB;
															#line 955 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	double totalRemainMB;
															#line 956 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	double standardAvgBW;
															#line 957 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	int loopCount;
															#line 958 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<RestoreUpdateRateReply> replies;
															#line 959 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<std::pair<UID, RestoreUpdateRateRequest>> requests;
															#line 7755 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via updateApplierWriteBW()
															#line 951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class UpdateApplierWriteBWActor final : public Actor<Void>, public ActorCallback< UpdateApplierWriteBWActor, 0, Void >, public ActorCallback< UpdateApplierWriteBWActor, 1, Void >, public FastAllocated<UpdateApplierWriteBWActor>, public UpdateApplierWriteBWActorState<UpdateApplierWriteBWActor> {
															#line 7760 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<UpdateApplierWriteBWActor>::operator new;
	using FastAllocated<UpdateApplierWriteBWActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10305886639812171008UL, 466917005449996288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< UpdateApplierWriteBWActor, 0, Void >;
friend struct ActorCallback< UpdateApplierWriteBWActor, 1, Void >;
															#line 951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	UpdateApplierWriteBWActor(Reference<ControllerBatchData> const& batchData,std::map<UID, RestoreApplierInterface> const& appliersInterf,int const& batchIndex) 
															#line 7778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   UpdateApplierWriteBWActorState<UpdateApplierWriteBWActor>(batchData, appliersInterf, batchIndex),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("updateApplierWriteBW", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6654149193452061952UL, 9068918385964945152UL);
		ActorExecutionContextHelper __helper(static_cast<UpdateApplierWriteBWActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("updateApplierWriteBW");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("updateApplierWriteBW", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< UpdateApplierWriteBWActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< UpdateApplierWriteBWActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Void> updateApplierWriteBW( Reference<ControllerBatchData> const& batchData, std::map<UID, RestoreApplierInterface> const& appliersInterf, int const& batchIndex ) {
															#line 951 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new UpdateApplierWriteBWActor(batchData, appliersInterf, batchIndex));
															#line 7812 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 995 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

// Ask each applier to apply its received mutations to DB
// NOTE: Controller cannot start applying mutations at batchIndex until all appliers have applied for (batchIndex - 1)
//       because appliers at different batchIndex may have overlapped key ranges.
															#line 7820 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via notifyApplierToApplyMutations()
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class NotifyApplierToApplyMutationsActor>
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class NotifyApplierToApplyMutationsActorState {
															#line 7827 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	NotifyApplierToApplyMutationsActorState(Reference<ControllerBatchData> const& batchData,Reference<ControllerBatchStatus> const& batchStatus,std::map<UID, RestoreApplierInterface> const& appliersInterf,int const& batchIndex,NotifiedVersion* const& finishedBatch) 
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : batchData(batchData),
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   batchStatus(batchStatus),
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   appliersInterf(appliersInterf),
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   batchIndex(batchIndex),
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   finishedBatch(finishedBatch)
															#line 7842 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this));

	}
	~NotifyApplierToApplyMutationsActorState() 
	{
		fdb_probe_actor_destroy("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1004 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent("FastRestoreControllerPhaseApplyToDBStart") .detail("BatchIndex", batchIndex) .detail("FinishedBatch", finishedBatch->get());
															#line 1008 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = finishedBatch->whenAtLeast(batchIndex - 1);
															#line 1008 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<NotifyApplierToApplyMutationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7861 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<NotifyApplierToApplyMutationsActor*>(this)->actor_wait_state = 1;
															#line 1008 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NotifyApplierToApplyMutationsActor, 0, Void >*>(static_cast<NotifyApplierToApplyMutationsActor*>(this)));
															#line 7866 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NotifyApplierToApplyMutationsActorState();
		static_cast<NotifyApplierToApplyMutationsActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1010 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		updateRate = Future<Void>();
															#line 1012 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (finishedBatch->get() == batchIndex - 1)
															#line 7891 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 1014 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			std::vector<std::pair<UID, RestoreVersionBatchRequest>> requests;
															#line 1016 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent("FastRestoreControllerPhaseApplyToDBRunning") .detail("BatchIndex", batchIndex) .detail("Appliers", appliersInterf.size());
															#line 1019 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( auto& applier : appliersInterf ) {
															#line 1020 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				ASSERT(batchStatus->applyStatus.find(applier.first) == batchStatus->applyStatus.end());
															#line 1021 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				requests.emplace_back(applier.first, RestoreVersionBatchRequest(batchIndex));
															#line 1022 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				batchStatus->applyStatus[applier.first] = RestoreApplyStatus::Applying;
															#line 7905 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 1024 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			replies = std::vector<RestoreCommonReply>();
															#line 1027 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (!batchData->applyToDB.present())
															#line 7911 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 1028 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				batchData->applyToDB = Never();
															#line 1029 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				batchData->applyToDB = getBatchReplies(&RestoreApplierInterface::applyToDB, appliersInterf, requests, &replies, TaskPriority::RestoreApplierWriteDB);
															#line 1034 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				updateRate = updateApplierWriteBW(batchData, appliersInterf, batchIndex);
															#line 7919 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1036 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevError, "FastRestoreControllerPhaseApplyToDB") .detail("BatchIndex", batchIndex) .detail("Attention", "Actor should not be invoked twice for the same batch index");
															#line 7925 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 1041 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ASSERT(batchData->applyToDB.present());
															#line 1042 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ASSERT(!batchData->applyToDB.get().isError());
															#line 1043 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = batchData->applyToDB.get();
															#line 1043 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<NotifyApplierToApplyMutationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 7935 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<NotifyApplierToApplyMutationsActor*>(this)->actor_wait_state = 2;
															#line 1043 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NotifyApplierToApplyMutationsActor, 1, Void >*>(static_cast<NotifyApplierToApplyMutationsActor*>(this)));
															#line 7940 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1010 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		updateRate = Future<Void>();
															#line 1012 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (finishedBatch->get() == batchIndex - 1)
															#line 7956 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		{
															#line 1014 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			std::vector<std::pair<UID, RestoreVersionBatchRequest>> requests;
															#line 1016 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent("FastRestoreControllerPhaseApplyToDBRunning") .detail("BatchIndex", batchIndex) .detail("Appliers", appliersInterf.size());
															#line 1019 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( auto& applier : appliersInterf ) {
															#line 1020 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				ASSERT(batchStatus->applyStatus.find(applier.first) == batchStatus->applyStatus.end());
															#line 1021 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				requests.emplace_back(applier.first, RestoreVersionBatchRequest(batchIndex));
															#line 1022 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				batchStatus->applyStatus[applier.first] = RestoreApplyStatus::Applying;
															#line 7970 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 1024 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			replies = std::vector<RestoreCommonReply>();
															#line 1027 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (!batchData->applyToDB.present())
															#line 7976 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 1028 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				batchData->applyToDB = Never();
															#line 1029 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				batchData->applyToDB = getBatchReplies(&RestoreApplierInterface::applyToDB, appliersInterf, requests, &replies, TaskPriority::RestoreApplierWriteDB);
															#line 1034 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				updateRate = updateApplierWriteBW(batchData, appliersInterf, batchIndex);
															#line 7984 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
			else
			{
															#line 1036 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevError, "FastRestoreControllerPhaseApplyToDB") .detail("BatchIndex", batchIndex) .detail("Attention", "Actor should not be invoked twice for the same batch index");
															#line 7990 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 1041 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ASSERT(batchData->applyToDB.present());
															#line 1042 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			ASSERT(!batchData->applyToDB.get().isError());
															#line 1043 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_1 = batchData->applyToDB.get();
															#line 1043 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<NotifyApplierToApplyMutationsActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8000 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<NotifyApplierToApplyMutationsActor*>(this)->actor_wait_state = 2;
															#line 1043 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< NotifyApplierToApplyMutationsActor, 1, Void >*>(static_cast<NotifyApplierToApplyMutationsActor*>(this)));
															#line 8005 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NotifyApplierToApplyMutationsActor*>(this)->actor_wait_state > 0) static_cast<NotifyApplierToApplyMutationsActor*>(this)->actor_wait_state = 0;
		static_cast<NotifyApplierToApplyMutationsActor*>(this)->ActorCallback< NotifyApplierToApplyMutationsActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NotifyApplierToApplyMutationsActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyApplierToApplyMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NotifyApplierToApplyMutationsActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyApplierToApplyMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NotifyApplierToApplyMutationsActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyApplierToApplyMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1066 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseApplyToDBDone") .detail("BatchIndex", batchIndex) .detail("FinishedBatch", finishedBatch->get());
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<NotifyApplierToApplyMutationsActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NotifyApplierToApplyMutationsActorState(); static_cast<NotifyApplierToApplyMutationsActor*>(this)->destroy(); return 0; }
															#line 8096 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<NotifyApplierToApplyMutationsActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NotifyApplierToApplyMutationsActorState();
		static_cast<NotifyApplierToApplyMutationsActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 1046 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& reply : replies ) {
															#line 1047 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (batchStatus->applyStatus[reply.id] == RestoreApplyStatus::Applying)
															#line 8110 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 1048 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				batchStatus->applyStatus[reply.id] = RestoreApplyStatus::Applied;
															#line 1049 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (reply.isDuplicated)
															#line 8116 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				{
															#line 1050 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					TraceEvent(SevWarn, "FastRestoreControllerPhaseApplyToDB") .detail("Applier", reply.id) .detail("DuplicateRequestReturnEarlier", "Apply db request should have been processed");
															#line 8120 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1056 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& applier : appliersInterf ) {
															#line 1057 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (batchStatus->applyStatus[applier.first] != RestoreApplyStatus::Applied)
															#line 8128 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 1058 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevError, "FastRestoreControllerPhaseApplyToDB") .detail("Applier", applier.first) .detail("ApplyStatus", batchStatus->applyStatus[applier.first]);
															#line 8132 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
		}
															#line 1063 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		finishedBatch->set(batchIndex);
															#line 8137 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 1046 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& reply : replies ) {
															#line 1047 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (batchStatus->applyStatus[reply.id] == RestoreApplyStatus::Applying)
															#line 8148 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 1048 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				batchStatus->applyStatus[reply.id] = RestoreApplyStatus::Applied;
															#line 1049 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (reply.isDuplicated)
															#line 8154 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				{
															#line 1050 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
					TraceEvent(SevWarn, "FastRestoreControllerPhaseApplyToDB") .detail("Applier", reply.id) .detail("DuplicateRequestReturnEarlier", "Apply db request should have been processed");
															#line 8158 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				}
			}
		}
															#line 1056 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& applier : appliersInterf ) {
															#line 1057 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (batchStatus->applyStatus[applier.first] != RestoreApplyStatus::Applied)
															#line 8166 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 1058 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevError, "FastRestoreControllerPhaseApplyToDB") .detail("Applier", applier.first) .detail("ApplyStatus", batchStatus->applyStatus[applier.first]);
															#line 8170 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
		}
															#line 1063 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		finishedBatch->set(batchIndex);
															#line 8175 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<NotifyApplierToApplyMutationsActor*>(this)->actor_wait_state > 0) static_cast<NotifyApplierToApplyMutationsActor*>(this)->actor_wait_state = 0;
		static_cast<NotifyApplierToApplyMutationsActor*>(this)->ActorCallback< NotifyApplierToApplyMutationsActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NotifyApplierToApplyMutationsActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyApplierToApplyMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< NotifyApplierToApplyMutationsActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyApplierToApplyMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< NotifyApplierToApplyMutationsActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyApplierToApplyMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<ControllerBatchData> batchData;
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<ControllerBatchStatus> batchStatus;
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::map<UID, RestoreApplierInterface> appliersInterf;
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	int batchIndex;
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	NotifiedVersion* finishedBatch;
															#line 1010 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Future<Void> updateRate;
															#line 1024 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::vector<RestoreCommonReply> replies;
															#line 8269 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via notifyApplierToApplyMutations()
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class NotifyApplierToApplyMutationsActor final : public Actor<Void>, public ActorCallback< NotifyApplierToApplyMutationsActor, 0, Void >, public ActorCallback< NotifyApplierToApplyMutationsActor, 1, Void >, public FastAllocated<NotifyApplierToApplyMutationsActor>, public NotifyApplierToApplyMutationsActorState<NotifyApplierToApplyMutationsActor> {
															#line 8274 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<NotifyApplierToApplyMutationsActor>::operator new;
	using FastAllocated<NotifyApplierToApplyMutationsActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8798901335889967104UL, 6948146147590119680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NotifyApplierToApplyMutationsActor, 0, Void >;
friend struct ActorCallback< NotifyApplierToApplyMutationsActor, 1, Void >;
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	NotifyApplierToApplyMutationsActor(Reference<ControllerBatchData> const& batchData,Reference<ControllerBatchStatus> const& batchStatus,std::map<UID, RestoreApplierInterface> const& appliersInterf,int const& batchIndex,NotifiedVersion* const& finishedBatch) 
															#line 8292 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   NotifyApplierToApplyMutationsActorState<NotifyApplierToApplyMutationsActor>(batchData, batchStatus, appliersInterf, batchIndex, finishedBatch),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(6663421218567091456UL, 18294541136230672128UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyApplierToApplyMutationsActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("notifyApplierToApplyMutations");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("notifyApplierToApplyMutations", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NotifyApplierToApplyMutationsActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< NotifyApplierToApplyMutationsActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Void> notifyApplierToApplyMutations( Reference<ControllerBatchData> const& batchData, Reference<ControllerBatchStatus> const& batchStatus, std::map<UID, RestoreApplierInterface> const& appliersInterf, int const& batchIndex, NotifiedVersion* const& finishedBatch ) {
															#line 999 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new NotifyApplierToApplyMutationsActor(batchData, batchStatus, appliersInterf, batchIndex, finishedBatch));
															#line 8326 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 1072 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

// Notify loaders that all data in the version batch has been applied to DB.
															#line 8332 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via notifyLoadersVersionBatchFinished()
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class NotifyLoadersVersionBatchFinishedActor>
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class NotifyLoadersVersionBatchFinishedActorState {
															#line 8339 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	NotifyLoadersVersionBatchFinishedActorState(std::map<UID, RestoreLoaderInterface> const& loadersInterf,int const& batchIndex) 
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : loadersInterf(loadersInterf),
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   batchIndex(batchIndex)
															#line 8348 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("notifyLoadersVersionBatchFinished", reinterpret_cast<unsigned long>(this));

	}
	~NotifyLoadersVersionBatchFinishedActorState() 
	{
		fdb_probe_actor_destroy("notifyLoadersVersionBatchFinished", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1076 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent("FastRestoreControllerPhaseNotifyLoadersVersionBatchFinishedStart").detail("BatchIndex", batchIndex);
															#line 1077 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			std::vector<std::pair<UID, RestoreVersionBatchRequest>> requestsToLoaders;
															#line 1078 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			requestsToLoaders.reserve(loadersInterf.size());
															#line 1079 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( auto& loader : loadersInterf ) {
															#line 1080 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				requestsToLoaders.emplace_back(loader.first, RestoreVersionBatchRequest(batchIndex));
															#line 8371 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 1082 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = sendBatchRequests(&RestoreLoaderInterface::finishVersionBatch, loadersInterf, requestsToLoaders);
															#line 1082 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8377 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->actor_wait_state = 1;
															#line 1082 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NotifyLoadersVersionBatchFinishedActor, 0, Void >*>(static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)));
															#line 8382 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NotifyLoadersVersionBatchFinishedActorState();
		static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1083 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseNotifyLoadersVersionBatchFinishedDone").detail("BatchIndex", batchIndex);
															#line 1085 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NotifyLoadersVersionBatchFinishedActorState(); static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->destroy(); return 0; }
															#line 8407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NotifyLoadersVersionBatchFinishedActorState();
		static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1083 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseNotifyLoadersVersionBatchFinishedDone").detail("BatchIndex", batchIndex);
															#line 1085 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NotifyLoadersVersionBatchFinishedActorState(); static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->destroy(); return 0; }
															#line 8421 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NotifyLoadersVersionBatchFinishedActorState();
		static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->actor_wait_state > 0) static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->actor_wait_state = 0;
		static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->ActorCallback< NotifyLoadersVersionBatchFinishedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NotifyLoadersVersionBatchFinishedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("notifyLoadersVersionBatchFinished", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("notifyLoadersVersionBatchFinished", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NotifyLoadersVersionBatchFinishedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("notifyLoadersVersionBatchFinished", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("notifyLoadersVersionBatchFinished", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NotifyLoadersVersionBatchFinishedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("notifyLoadersVersionBatchFinished", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("notifyLoadersVersionBatchFinished", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	std::map<UID, RestoreLoaderInterface> loadersInterf;
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	int batchIndex;
															#line 8508 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via notifyLoadersVersionBatchFinished()
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class NotifyLoadersVersionBatchFinishedActor final : public Actor<Void>, public ActorCallback< NotifyLoadersVersionBatchFinishedActor, 0, Void >, public FastAllocated<NotifyLoadersVersionBatchFinishedActor>, public NotifyLoadersVersionBatchFinishedActorState<NotifyLoadersVersionBatchFinishedActor> {
															#line 8513 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<NotifyLoadersVersionBatchFinishedActor>::operator new;
	using FastAllocated<NotifyLoadersVersionBatchFinishedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10608310726535081216UL, 5763832926487436288UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NotifyLoadersVersionBatchFinishedActor, 0, Void >;
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	NotifyLoadersVersionBatchFinishedActor(std::map<UID, RestoreLoaderInterface> const& loadersInterf,int const& batchIndex) 
															#line 8530 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   NotifyLoadersVersionBatchFinishedActorState<NotifyLoadersVersionBatchFinishedActor>(loadersInterf, batchIndex),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("notifyLoadersVersionBatchFinished", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7086600246610977792UL, 16233894767893461760UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyLoadersVersionBatchFinishedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("notifyLoadersVersionBatchFinished");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("notifyLoadersVersionBatchFinished", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NotifyLoadersVersionBatchFinishedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Void> notifyLoadersVersionBatchFinished( std::map<UID, RestoreLoaderInterface> const& loadersInterf, int const& batchIndex ) {
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new NotifyLoadersVersionBatchFinishedActor(loadersInterf, batchIndex));
															#line 8563 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 1087 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

// Ask all loaders and appliers to perform housecleaning at the end of a restore request
// Terminate those roles if terminate = true
															#line 8570 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via notifyRestoreCompleted()
															#line 1090 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class NotifyRestoreCompletedActor>
															#line 1090 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class NotifyRestoreCompletedActorState {
															#line 8577 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 1090 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	NotifyRestoreCompletedActorState(Reference<RestoreControllerData> const& self,bool const& terminate = false) 
															#line 1090 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 1090 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : self(self),
															#line 1090 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   terminate(terminate)
															#line 8586 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("notifyRestoreCompleted", reinterpret_cast<unsigned long>(this));

	}
	~NotifyRestoreCompletedActorState() 
	{
		fdb_probe_actor_destroy("notifyRestoreCompleted", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1091 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			std::vector<std::pair<UID, RestoreFinishRequest>> requests;
															#line 1092 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			TraceEvent("FastRestoreControllerPhaseNotifyRestoreCompletedStart").log();
															#line 1093 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( auto& loader : self->loadersInterf ) {
															#line 1094 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				requests.emplace_back(loader.first, RestoreFinishRequest(terminate));
															#line 8607 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 1097 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			Future<Void> endLoaders = sendBatchRequests(&RestoreLoaderInterface::finishRestore, self->loadersInterf, requests);
															#line 1099 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			requests.clear();
															#line 1100 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			for( auto& applier : self->appliersInterf ) {
															#line 1101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				requests.emplace_back(applier.first, RestoreFinishRequest(terminate));
															#line 8617 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
															#line 1103 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			Future<Void> endAppliers = sendBatchRequests(&RestoreApplierInterface::finishRestore, self->appliersInterf, requests);
															#line 1108 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (!terminate)
															#line 8623 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 1109 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				StrictFuture<Void> __when_expr_0 = endLoaders && endAppliers;
															#line 1109 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				if (static_cast<NotifyRestoreCompletedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8629 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<NotifyRestoreCompletedActor*>(this)->actor_wait_state = 1;
															#line 1109 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< NotifyRestoreCompletedActor, 0, Void >*>(static_cast<NotifyRestoreCompletedActor*>(this)));
															#line 8634 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~NotifyRestoreCompletedActorState();
		static_cast<NotifyRestoreCompletedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1112 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerPhaseNotifyRestoreCompletedDone").log();
															#line 1114 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<NotifyRestoreCompletedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~NotifyRestoreCompletedActorState(); static_cast<NotifyRestoreCompletedActor*>(this)->destroy(); return 0; }
															#line 8664 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<NotifyRestoreCompletedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~NotifyRestoreCompletedActorState();
		static_cast<NotifyRestoreCompletedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<NotifyRestoreCompletedActor*>(this)->actor_wait_state > 0) static_cast<NotifyRestoreCompletedActor*>(this)->actor_wait_state = 0;
		static_cast<NotifyRestoreCompletedActor*>(this)->ActorCallback< NotifyRestoreCompletedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< NotifyRestoreCompletedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("notifyRestoreCompleted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("notifyRestoreCompleted", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< NotifyRestoreCompletedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("notifyRestoreCompleted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("notifyRestoreCompleted", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< NotifyRestoreCompletedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("notifyRestoreCompleted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("notifyRestoreCompleted", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1090 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<RestoreControllerData> self;
															#line 1090 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	bool terminate;
															#line 8763 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via notifyRestoreCompleted()
															#line 1090 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class NotifyRestoreCompletedActor final : public Actor<Void>, public ActorCallback< NotifyRestoreCompletedActor, 0, Void >, public FastAllocated<NotifyRestoreCompletedActor>, public NotifyRestoreCompletedActorState<NotifyRestoreCompletedActor> {
															#line 8768 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<NotifyRestoreCompletedActor>::operator new;
	using FastAllocated<NotifyRestoreCompletedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11030044538680458240UL, 14166880893739448064UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< NotifyRestoreCompletedActor, 0, Void >;
															#line 1090 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	NotifyRestoreCompletedActor(Reference<RestoreControllerData> const& self,bool const& terminate = false) 
															#line 8785 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   NotifyRestoreCompletedActorState<NotifyRestoreCompletedActor>(self, terminate),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("notifyRestoreCompleted", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14233574727824499200UL, 11843383366868026624UL);
		ActorExecutionContextHelper __helper(static_cast<NotifyRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("notifyRestoreCompleted");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("notifyRestoreCompleted", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< NotifyRestoreCompletedActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1090 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Void> notifyRestoreCompleted( Reference<RestoreControllerData> const& self, bool const& terminate = false ) {
															#line 1090 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new NotifyRestoreCompletedActor(self, terminate));
															#line 8818 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 1116 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

// Register the restoreRequestDoneKey to signal the end of restore
															#line 8824 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via signalRestoreCompleted()
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class SignalRestoreCompletedActor>
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class SignalRestoreCompletedActorState {
															#line 8831 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	SignalRestoreCompletedActorState(Reference<RestoreControllerData> const& self,Database const& cx) 
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : self(self),
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   cx(cx),
															#line 1119 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		   tr(new ReadYourWritesTransaction(cx))
															#line 8842 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("signalRestoreCompleted", reinterpret_cast<unsigned long>(this));

	}
	~SignalRestoreCompletedActorState() 
	{
		fdb_probe_actor_destroy("signalRestoreCompleted", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_0 = notifyRestoreCompleted(self, true);
															#line 1121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8859 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state = 1;
															#line 1121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SignalRestoreCompletedActor, 0, Void >*>(static_cast<SignalRestoreCompletedActor*>(this)));
															#line 8864 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SignalRestoreCompletedActorState();
		static_cast<SignalRestoreCompletedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1123 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 1123 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8889 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state = 2;
															#line 1123 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SignalRestoreCompletedActor, 1, Void >*>(static_cast<SignalRestoreCompletedActor*>(this)));
															#line 8894 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1123 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(5.0);
															#line 1123 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8905 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state = 2;
															#line 1123 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< SignalRestoreCompletedActor, 1, Void >*>(static_cast<SignalRestoreCompletedActor*>(this)));
															#line 8910 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state > 0) static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state = 0;
		static_cast<SignalRestoreCompletedActor*>(this)->ActorCallback< SignalRestoreCompletedActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SignalRestoreCompletedActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SignalRestoreCompletedActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SignalRestoreCompletedActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1126 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		;
															#line 8994 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1126 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		;
															#line 9003 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state > 0) static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state = 0;
		static_cast<SignalRestoreCompletedActor*>(this)->ActorCallback< SignalRestoreCompletedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SignalRestoreCompletedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< SignalRestoreCompletedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< SignalRestoreCompletedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1141 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		TraceEvent("FastRestoreControllerAllRestoreCompleted").log();
															#line 1143 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (!static_cast<SignalRestoreCompletedActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SignalRestoreCompletedActorState(); static_cast<SignalRestoreCompletedActor*>(this)->destroy(); return 0; }
															#line 9089 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		new (&static_cast<SignalRestoreCompletedActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SignalRestoreCompletedActorState();
		static_cast<SignalRestoreCompletedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
		try {
															#line 1128 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			tr->setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 1129 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			tr->setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 1130 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			tr->clear(restoreRequestTriggerKey);
															#line 1131 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			tr->clear(restoreRequestKeys);
															#line 1132 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Version> __when_expr_2 = tr->getReadVersion();
															#line 1132 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9119 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont2loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
			static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state = 3;
															#line 1132 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< SignalRestoreCompletedActor, 2, Version >*>(static_cast<SignalRestoreCompletedActor*>(this)));
															#line 9124 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1cont2loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont2loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1137 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			StrictFuture<Void> __when_expr_4 = tr->onError(e);
															#line 1137 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9161 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1Catch1when1(__when_expr_4.get(), loopDepth); };
			static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state = 5;
															#line 1137 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< SignalRestoreCompletedActor, 4, Void >*>(static_cast<SignalRestoreCompletedActor*>(this)));
															#line 9166 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Version const& readVersion,int loopDepth) 
	{
															#line 1133 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		tr->set(restoreRequestDoneKey, restoreRequestDoneVersionValue(readVersion));
															#line 1134 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 1134 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9185 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state = 4;
															#line 1134 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SignalRestoreCompletedActor, 3, Void >*>(static_cast<SignalRestoreCompletedActor*>(this)));
															#line 9190 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2(Version && readVersion,int loopDepth) 
	{
															#line 1133 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		tr->set(restoreRequestDoneKey, restoreRequestDoneVersionValue(readVersion));
															#line 1134 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_3 = tr->commit();
															#line 1134 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state < 0) return a_body1cont2loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 9203 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont2loopBody1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont2loopBody1cont2when1(__when_expr_3.get(), loopDepth); };
		static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state = 4;
															#line 1134 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< SignalRestoreCompletedActor, 3, Void >*>(static_cast<SignalRestoreCompletedActor*>(this)));
															#line 9208 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Version const& readVersion,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(readVersion, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Version && readVersion,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont2(std::move(readVersion), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state > 0) static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state = 0;
		static_cast<SignalRestoreCompletedActor*>(this)->ActorCallback< SignalRestoreCompletedActor, 2, Version >::remove();

	}
	void a_callback_fire(ActorCallback< SignalRestoreCompletedActor, 2, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< SignalRestoreCompletedActor, 2, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< SignalRestoreCompletedActor, 2, Version >*,Error err) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont3(Void const& _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont3(Void && _,int loopDepth) 
	{
		return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state > 0) static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state = 0;
		static_cast<SignalRestoreCompletedActor*>(this)->ActorCallback< SignalRestoreCompletedActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SignalRestoreCompletedActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< SignalRestoreCompletedActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< SignalRestoreCompletedActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont2loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1cont2loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state > 0) static_cast<SignalRestoreCompletedActor*>(this)->actor_wait_state = 0;
		static_cast<SignalRestoreCompletedActor*>(this)->ActorCallback< SignalRestoreCompletedActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SignalRestoreCompletedActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< SignalRestoreCompletedActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< SignalRestoreCompletedActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), 4);

	}
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<RestoreControllerData> self;
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Database cx;
															#line 1119 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<ReadYourWritesTransaction> tr;
															#line 9468 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via signalRestoreCompleted()
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class SignalRestoreCompletedActor final : public Actor<Void>, public ActorCallback< SignalRestoreCompletedActor, 0, Void >, public ActorCallback< SignalRestoreCompletedActor, 1, Void >, public ActorCallback< SignalRestoreCompletedActor, 2, Version >, public ActorCallback< SignalRestoreCompletedActor, 3, Void >, public ActorCallback< SignalRestoreCompletedActor, 4, Void >, public FastAllocated<SignalRestoreCompletedActor>, public SignalRestoreCompletedActorState<SignalRestoreCompletedActor> {
															#line 9473 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<SignalRestoreCompletedActor>::operator new;
	using FastAllocated<SignalRestoreCompletedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12973932687173989888UL, 15548470317996937984UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SignalRestoreCompletedActor, 0, Void >;
friend struct ActorCallback< SignalRestoreCompletedActor, 1, Void >;
friend struct ActorCallback< SignalRestoreCompletedActor, 2, Version >;
friend struct ActorCallback< SignalRestoreCompletedActor, 3, Void >;
friend struct ActorCallback< SignalRestoreCompletedActor, 4, Void >;
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	SignalRestoreCompletedActor(Reference<RestoreControllerData> const& self,Database const& cx) 
															#line 9494 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   SignalRestoreCompletedActorState<SignalRestoreCompletedActor>(self, cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1017404258021883136UL, 4461465405657219584UL);
		ActorExecutionContextHelper __helper(static_cast<SignalRestoreCompletedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("signalRestoreCompleted");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("signalRestoreCompleted", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SignalRestoreCompletedActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< SignalRestoreCompletedActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< SignalRestoreCompletedActor, 2, Version >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< SignalRestoreCompletedActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< SignalRestoreCompletedActor, 4, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Void> signalRestoreCompleted( Reference<RestoreControllerData> const& self, Database const& cx ) {
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new SignalRestoreCompletedActor(self, cx));
															#line 9531 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 1145 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"

/*
// Update the most recent time when controller receives heartbeat from each loader and applier
// TODO: Replace the heartbeat mechanism with FDB failure monitoring mechanism
ACTOR static Future<Void> updateHeartbeatTime(Reference<RestoreControllerData> self) {
    wait(self->recruitedRoles.getFuture());

    int numRoles = self->loadersInterf.size() + self->appliersInterf.size();
    state std::map<UID, RestoreLoaderInterface>::iterator loader = self->loadersInterf.begin();
    state std::map<UID, RestoreApplierInterface>::iterator applier = self->appliersInterf.begin();
    state std::vector<Future<RestoreCommonReply>> fReplies(numRoles, Never()); // TODO: Reserve memory for this vector
    state std::vector<UID> nodes;
    state int index = 0;
    state Future<Void> fTimeout = Void();

    // Initialize nodes only once
    std::transform(self->loadersInterf.begin(),
                   self->loadersInterf.end(),
                   std::back_inserter(nodes),
                   [](const std::pair<UID, RestoreLoaderInterface>& in) { return in.first; });
    std::transform(self->appliersInterf.begin(),
                   self->appliersInterf.end(),
                   std::back_inserter(nodes),
                   [](const std::pair<UID, RestoreApplierInterface>& in) { return in.first; });

    loop {
        loader = self->loadersInterf.begin();
        applier = self->appliersInterf.begin();
        index = 0;
        std::fill(fReplies.begin(), fReplies.end(), Never());
        // ping loaders and appliers
        while (loader != self->loadersInterf.end()) {
            fReplies[index] = loader->second.heartbeat.getReply(RestoreSimpleRequest());
            loader++;
            index++;
        }
        while (applier != self->appliersInterf.end()) {
            fReplies[index] = applier->second.heartbeat.getReply(RestoreSimpleRequest());
            applier++;
            index++;
        }

        fTimeout = delay(SERVER_KNOBS->FASTRESTORE_HEARTBEAT_DELAY);

        // Here we have to handle error, otherwise controller worker will fail and exit.
        try {
            wait(waitForAll(fReplies) || fTimeout);
        } catch (Error& e) {
            // This should be an ignorable error.
            TraceEvent(g_network->isSimulated() ? SevWarnAlways : SevError, "FastRestoreUpdateHeartbeatError").error(e);
        }

        // Update the most recent heart beat time for each role
        for (int i = 0; i < fReplies.size(); ++i) {
            if (!fReplies[i].isError() && fReplies[i].isReady()) {
                double currentTime = now();
                auto item = self->rolesHeartBeatTime.emplace(nodes[i], currentTime);
                item.first->second = currentTime;
            }
        }
        wait(fTimeout); // Ensure not updating heartbeat too quickly
    }
}
*/

// Check if a restore role dies or disconnected
															#line 9601 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkRolesLiveness()
															#line 1211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
template <class CheckRolesLivenessActor>
															#line 1211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class CheckRolesLivenessActorState {
															#line 9608 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
															#line 1211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	CheckRolesLivenessActorState(Reference<RestoreControllerData> const& self) 
															#line 1211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
															#line 1211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		 : self(self)
															#line 9615 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkRolesLiveness", reinterpret_cast<unsigned long>(this));

	}
	~CheckRolesLivenessActorState() 
	{
		fdb_probe_actor_destroy("checkRolesLiveness", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1212 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			;
															#line 9630 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckRolesLivenessActorState();
		static_cast<CheckRolesLivenessActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 1213 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		StrictFuture<Void> __when_expr_0 = delay(SERVER_KNOBS->FASTRESTORE_HEARTBEAT_MAX_DELAY);
															#line 1213 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		if (static_cast<CheckRolesLivenessActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9662 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<CheckRolesLivenessActor*>(this)->actor_wait_state = 1;
															#line 1213 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckRolesLivenessActor, 0, Void >*>(static_cast<CheckRolesLivenessActor*>(this)));
															#line 9667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 1214 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& role : self->rolesHeartBeatTime ) {
															#line 1215 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (now() - role.second > SERVER_KNOBS->FASTRESTORE_HEARTBEAT_MAX_DELAY)
															#line 9678 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 1216 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevWarnAlways, "FastRestoreUnavailableRole", role.first) .detail("Delta", now() - role.second) .detail("LastAliveTime", role.second);
															#line 9682 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 1214 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
		for( auto& role : self->rolesHeartBeatTime ) {
															#line 1215 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
			if (now() - role.second > SERVER_KNOBS->FASTRESTORE_HEARTBEAT_MAX_DELAY)
															#line 9695 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			{
															#line 1216 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
				TraceEvent(SevWarnAlways, "FastRestoreUnavailableRole", role.first) .detail("Delta", now() - role.second) .detail("LastAliveTime", role.second);
															#line 9699 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
			}
		}
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckRolesLivenessActor*>(this)->actor_wait_state > 0) static_cast<CheckRolesLivenessActor*>(this)->actor_wait_state = 0;
		static_cast<CheckRolesLivenessActor*>(this)->ActorCallback< CheckRolesLivenessActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckRolesLivenessActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkRolesLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRolesLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRolesLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckRolesLivenessActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkRolesLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRolesLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRolesLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckRolesLivenessActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkRolesLiveness", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRolesLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkRolesLiveness", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	Reference<RestoreControllerData> self;
															#line 9783 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkRolesLiveness()
															#line 1211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
class CheckRolesLivenessActor final : public Actor<Void>, public ActorCallback< CheckRolesLivenessActor, 0, Void >, public FastAllocated<CheckRolesLivenessActor>, public CheckRolesLivenessActorState<CheckRolesLivenessActor> {
															#line 9788 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckRolesLivenessActor>::operator new;
	using FastAllocated<CheckRolesLivenessActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16125250977414845440UL, 16131729845485973248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckRolesLivenessActor, 0, Void >;
															#line 1211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	CheckRolesLivenessActor(Reference<RestoreControllerData> const& self) 
															#line 9805 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckRolesLivenessActorState<CheckRolesLivenessActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkRolesLiveness", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10295753672202107392UL, 4434029829286333440UL);
		ActorExecutionContextHelper __helper(static_cast<CheckRolesLivenessActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkRolesLiveness");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkRolesLiveness", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckRolesLivenessActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
[[nodiscard]] static Future<Void> checkRolesLiveness( Reference<RestoreControllerData> const& self ) {
															#line 1211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
	return Future<Void>(new CheckRolesLivenessActor(self));
															#line 9838 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbserver/RestoreController.actor.g.cpp.py_gen"
}

#line 1223 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbserver/RestoreController.actor.cpp"
