#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
/*
 * AuditUtils.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbclient/AuditUtils.actor.h"

#include "fdbclient/Audit.h"
#include "fdbclient/FDBTypes.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbclient/ReadYourWrites.h"
#include "fdbclient/ClientKnobs.h"
#include <fmt/format.h>

#include "flow/actorcompiler.h" // has to be last include

void clearAuditProgressMetadata(Transaction* tr, AuditType auditType, UID auditId) {
	// There are two possible places to store AuditProgressMetadata:
	// (1) auditServerBasedProgressRangeFor or (2) auditRangeBasedProgressRangeFor
	// Which place stores the progress metadata is decided by DDAudit design
	// This function enforces the DDAudit design when clear the progress metadata
	// Design: for replica/ha/locationMetadata, the audit always writes to RangeBased space
	// for SSShard, the audit always writes to ServerBased space
	// This function clears the progress metadata accordingly
	if (auditType == AuditType::ValidateStorageServerShard) {
		tr->clear(auditServerBasedProgressRangeFor(auditType, auditId));
	} else if (auditType == AuditType::ValidateHA) {
		tr->clear(auditRangeBasedProgressRangeFor(auditType, auditId));
	} else if (auditType == AuditType::ValidateReplica) {
		tr->clear(auditRangeBasedProgressRangeFor(auditType, auditId));
	} else if (auditType == AuditType::ValidateLocationMetadata) {
		tr->clear(auditRangeBasedProgressRangeFor(auditType, auditId));
	} else {
		UNREACHABLE();
	}
	return;
}

															#line 56 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkStorageServerRemoved()
															#line 54 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class CheckStorageServerRemovedActor>
															#line 54 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckStorageServerRemovedActorState {
															#line 63 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 54 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckStorageServerRemovedActorState(Database const& cx,UID const& ssid) 
															#line 54 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 54 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 54 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   ssid(ssid),
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   res(false),
															#line 56 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx)
															#line 76 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this));

	}
	~CheckStorageServerRemovedActorState() 
	{
		fdb_probe_actor_destroy("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 57 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilStorageServerRemovedStart").detail("StorageServer", ssid);
															#line 59 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 93 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckStorageServerRemovedActorState();
		static_cast<CheckStorageServerRemovedActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 77 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevDebug, "AuditUtilStorageServerRemovedEnd").detail("StorageServer", ssid).detail("Removed", res);
															#line 78 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<CheckStorageServerRemovedActor*>(this)->SAV<bool>::futures) { (void)(res); this->~CheckStorageServerRemovedActorState(); static_cast<CheckStorageServerRemovedActor*>(this)->destroy(); return 0; }
															#line 118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<CheckStorageServerRemovedActor*>(this)->SAV< bool >::value()) bool(std::move(res)); // state_var_RVO
		this->~CheckStorageServerRemovedActorState();
		static_cast<CheckStorageServerRemovedActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 61 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 62 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 63 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 64 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(serverListKeyFor(ssid));
															#line 64 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 146 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state = 1;
															#line 64 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >*>(static_cast<CheckStorageServerRemovedActor*>(this)));
															#line 151 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 70 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilStorageServerRemovedError") .errorUnsuppressed(e) .detail("StorageServer", ssid);
															#line 73 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 73 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 190 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state = 2;
															#line 73 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckStorageServerRemovedActor, 1, Void >*>(static_cast<CheckStorageServerRemovedActor*>(this)));
															#line 195 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& serverListValue,int loopDepth) 
	{
															#line 65 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!serverListValue.present())
															#line 210 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 66 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			res = true;
															#line 214 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && serverListValue,int loopDepth) 
	{
															#line 65 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!serverListValue.present())
															#line 224 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 66 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			res = true;
															#line 228 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& serverListValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(serverListValue, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && serverListValue,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(serverListValue), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state > 0) static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckStorageServerRemovedActor*>(this)->ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageServerRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageServerRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageServerRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state > 0) static_cast<CheckStorageServerRemovedActor*>(this)->actor_wait_state = 0;
		static_cast<CheckStorageServerRemovedActor*>(this)->ActorCallback< CheckStorageServerRemovedActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckStorageServerRemovedActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageServerRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckStorageServerRemovedActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageServerRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckStorageServerRemovedActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageServerRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 54 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 54 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID ssid;
															#line 55 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	bool res;
															#line 56 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 404 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkStorageServerRemoved()
															#line 54 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckStorageServerRemovedActor final : public Actor<bool>, public ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >, public ActorCallback< CheckStorageServerRemovedActor, 1, Void >, public FastAllocated<CheckStorageServerRemovedActor>, public CheckStorageServerRemovedActorState<CheckStorageServerRemovedActor> {
															#line 409 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckStorageServerRemovedActor>::operator new;
	using FastAllocated<CheckStorageServerRemovedActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16604514526257080320UL, 2745708698571462656UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckStorageServerRemovedActor, 1, Void >;
															#line 54 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckStorageServerRemovedActor(Database const& cx,UID const& ssid) 
															#line 427 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   CheckStorageServerRemovedActorState<CheckStorageServerRemovedActor>(cx, ssid),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12273032095068269824UL, 16824334513600268800UL);
		ActorExecutionContextHelper __helper(static_cast<CheckStorageServerRemovedActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkStorageServerRemoved");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkStorageServerRemoved", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckStorageServerRemovedActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckStorageServerRemovedActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 54 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<bool> checkStorageServerRemoved( Database const& cx, UID const& ssid ) {
															#line 54 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<bool>(new CheckStorageServerRemovedActor(cx, ssid));
															#line 461 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 80 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 466 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via cancelAuditMetadata()
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class CancelAuditMetadataActor>
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CancelAuditMetadataActorState {
															#line 473 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CancelAuditMetadataActorState(Database const& cx,AuditType const& auditType,UID const& auditId) 
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditType(auditType),
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditId(auditId)
															#line 484 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("cancelAuditMetadata", reinterpret_cast<unsigned long>(this));

	}
	~CancelAuditMetadataActorState() 
	{
		fdb_probe_actor_destroy("cancelAuditMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 83 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				tr = Transaction(cx);
															#line 84 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevInfo, "AuditUtilCancelAuditMetadataStart", auditId) .detail("AuditKey", auditKey(auditType, auditId));
															#line 86 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				;
															#line 504 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CancelAuditMetadataActorState();
		static_cast<CancelAuditMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 114 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<CancelAuditMetadataActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CancelAuditMetadataActorState(); static_cast<CancelAuditMetadataActor*>(this)->destroy(); return 0; }
															#line 533 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<CancelAuditMetadataActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CancelAuditMetadataActorState();
		static_cast<CancelAuditMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 112 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch1(cancel_audit_storage_failed(), loopDepth);
															#line 546 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 88 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 89 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 90 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 91 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(auditKey(auditType, auditId));
															#line 91 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 582 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state = 1;
															#line 91 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >*>(static_cast<CancelAuditMetadataActor*>(this)));
															#line 587 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 106 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevWarn, "AuditUtilCancelAuditMetadataError", auditId) .detail("AuditKey", auditKey(auditType, auditId));
															#line 108 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 108 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 626 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state = 3;
															#line 108 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< CancelAuditMetadataActor, 2, Void >*>(static_cast<CancelAuditMetadataActor*>(this)));
															#line 631 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& res_,int loopDepth) 
	{
															#line 92 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res_.present())
															#line 646 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 95 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		toCancelState = decodeAuditStorageState(res_.get());
															#line 97 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(toCancelState.id == auditId && toCancelState.getType() == auditType);
															#line 98 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		toCancelState.setPhase(AuditPhase::Failed);
															#line 99 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.set(auditKey(toCancelState.getType(), toCancelState.id), auditStorageStateValue(toCancelState));
															#line 100 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		clearAuditProgressMetadata(&tr, toCancelState.getType(), toCancelState.id);
															#line 101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 664 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state = 2;
															#line 101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CancelAuditMetadataActor, 1, Void >*>(static_cast<CancelAuditMetadataActor*>(this)));
															#line 669 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && res_,int loopDepth) 
	{
															#line 92 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res_.present())
															#line 678 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 95 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		toCancelState = decodeAuditStorageState(res_.get());
															#line 97 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(toCancelState.id == auditId && toCancelState.getType() == auditType);
															#line 98 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		toCancelState.setPhase(AuditPhase::Failed);
															#line 99 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.set(auditKey(toCancelState.getType(), toCancelState.id), auditStorageStateValue(toCancelState));
															#line 100 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		clearAuditProgressMetadata(&tr, toCancelState.getType(), toCancelState.id);
															#line 101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 696 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state = 2;
															#line 101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CancelAuditMetadataActor, 1, Void >*>(static_cast<CancelAuditMetadataActor*>(this)));
															#line 701 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state > 0) static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CancelAuditMetadataActor*>(this)->ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilCancelAuditMetadataEnd", auditId) .detail("AuditKey", auditKey(auditType, auditId));
															#line 785 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 102 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilCancelAuditMetadataEnd", auditId) .detail("AuditKey", auditKey(auditType, auditId));
															#line 794 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state > 0) static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CancelAuditMetadataActor*>(this)->ActorCallback< CancelAuditMetadataActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CancelAuditMetadataActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CancelAuditMetadataActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CancelAuditMetadataActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state > 0) static_cast<CancelAuditMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<CancelAuditMetadataActor*>(this)->ActorCallback< CancelAuditMetadataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CancelAuditMetadataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< CancelAuditMetadataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< CancelAuditMetadataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType auditType;
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditId;
															#line 83 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 95 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditStorageState toCancelState;
															#line 984 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via cancelAuditMetadata()
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CancelAuditMetadataActor final : public Actor<Void>, public ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >, public ActorCallback< CancelAuditMetadataActor, 1, Void >, public ActorCallback< CancelAuditMetadataActor, 2, Void >, public FastAllocated<CancelAuditMetadataActor>, public CancelAuditMetadataActorState<CancelAuditMetadataActor> {
															#line 989 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<CancelAuditMetadataActor>::operator new;
	using FastAllocated<CancelAuditMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3927575311856518912UL, 2055353106932221696UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >;
friend struct ActorCallback< CancelAuditMetadataActor, 1, Void >;
friend struct ActorCallback< CancelAuditMetadataActor, 2, Void >;
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CancelAuditMetadataActor(Database const& cx,AuditType const& auditType,UID const& auditId) 
															#line 1008 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CancelAuditMetadataActorState<CancelAuditMetadataActor>(cx, auditType, auditId),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12148951812118840320UL, 11785627702551069952UL);
		ActorExecutionContextHelper __helper(static_cast<CancelAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("cancelAuditMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("cancelAuditMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CancelAuditMetadataActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CancelAuditMetadataActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< CancelAuditMetadataActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<Void> cancelAuditMetadata( Database const& cx, AuditType const& auditType, UID const& auditId ) {
															#line 81 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<Void>(new CancelAuditMetadataActor(cx, auditType, auditId));
															#line 1043 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 116 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

AuditPhase stringToAuditPhase(std::string auditPhaseStr) {
	// Convert chars of auditPhaseStr to lower case
	std::transform(auditPhaseStr.begin(), auditPhaseStr.end(), auditPhaseStr.begin(), [](unsigned char c) {
		return std::tolower(c);
	});
	if (auditPhaseStr == "running") {
		return AuditPhase::Running;
	} else if (auditPhaseStr == "complete") {
		return AuditPhase::Complete;
	} else if (auditPhaseStr == "failed") {
		return AuditPhase::Failed;
	} else if (auditPhaseStr == "error") {
		return AuditPhase::Error;
	} else {
		return AuditPhase::Invalid;
	}
}

// This is not transactional
															#line 1067 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getAuditStates()
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class GetAuditStatesActor>
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStatesActorState {
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStatesActorState(Database const& cx,AuditType const& auditType,bool const& newFirst,Optional<int> const& num,Optional<AuditPhase> const& phase) 
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditType(auditType),
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   newFirst(newFirst),
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   num(num),
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   phase(phase),
															#line 141 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx),
															#line 142 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditStates(),
															#line 143 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   readBegin(),
															#line 144 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   readEnd(),
															#line 145 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   reverse(newFirst ? Reverse::True : Reverse::False)
															#line 1099 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditStates", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditStatesActorState() 
	{
		fdb_probe_actor_destroy("getAuditStates", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 146 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (num.present() && num.get() == 0)
															#line 1114 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 147 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (!static_cast<GetAuditStatesActor*>(this)->SAV<std::vector<AuditStorageState>>::futures) { (void)(auditStates); this->~GetAuditStatesActorState(); static_cast<GetAuditStatesActor*>(this)->destroy(); return 0; }
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				new (&static_cast<GetAuditStatesActor*>(this)->SAV< std::vector<AuditStorageState> >::value()) std::vector<AuditStorageState>(std::move(auditStates)); // state_var_RVO
				this->~GetAuditStatesActorState();
				static_cast<GetAuditStatesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 1126 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditStatesActorState();
		static_cast<GetAuditStatesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 188 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<GetAuditStatesActor*>(this)->SAV<std::vector<AuditStorageState>>::futures) { (void)(auditStates); this->~GetAuditStatesActorState(); static_cast<GetAuditStatesActor*>(this)->destroy(); return 0; }
															#line 1149 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditStatesActor*>(this)->SAV< std::vector<AuditStorageState> >::value()) std::vector<AuditStorageState>(std::move(auditStates)); // state_var_RVO
		this->~GetAuditStatesActorState();
		static_cast<GetAuditStatesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 151 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			readBegin = auditKeyRange(auditType).begin;
															#line 152 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			readEnd = auditKeyRange(auditType).end;
															#line 153 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auditStates.clear();
															#line 154 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 1175 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 185 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 185 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<GetAuditStatesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1212 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAuditStatesActor*>(this)->actor_wait_state = 2;
															#line 185 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditStatesActor, 1, Void >*>(static_cast<GetAuditStatesActor*>(this)));
															#line 1217 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
															#line 155 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 156 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 157 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 158 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		KeyRangeRef rangeToRead(readBegin, readEnd);
															#line 159 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<RangeResult> __when_expr_0 = tr.getRange(rangeToRead, num.present() ? GetRangeLimits(num.get()) : GetRangeLimits(), Snapshot::False, reverse);
															#line 159 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<GetAuditStatesActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1255 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<GetAuditStatesActor*>(this)->actor_wait_state = 1;
															#line 159 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditStatesActor, 0, RangeResult >*>(static_cast<GetAuditStatesActor*>(this)));
															#line 1260 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
															#line 163 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < res.size();++i) {
															#line 164 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			const AuditStorageState auditState = decodeAuditStorageState(res[i].value);
															#line 165 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (phase.present() && auditState.getPhase() != phase.get())
															#line 1286 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 168 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auditStates.push_back(auditState);
															#line 169 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (num.present() && auditStates.size() == num.get())
															#line 1294 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 170 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (!static_cast<GetAuditStatesActor*>(this)->SAV<std::vector<AuditStorageState>>::futures) { (void)(auditStates); this->~GetAuditStatesActorState(); static_cast<GetAuditStatesActor*>(this)->destroy(); return 0; }
															#line 1298 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				new (&static_cast<GetAuditStatesActor*>(this)->SAV< std::vector<AuditStorageState> >::value()) std::vector<AuditStorageState>(std::move(auditStates)); // state_var_RVO
				this->~GetAuditStatesActorState();
				static_cast<GetAuditStatesActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 173 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res.more)
															#line 1307 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 176 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (newFirst)
															#line 1313 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 177 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			readEnd = res.front().key;
															#line 1317 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		else
		{
															#line 179 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			readBegin = keyAfter(res.back().key);
															#line 1323 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 181 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.reset();
															#line 1327 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult const& __res,int loopDepth) 
	{
															#line 159 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		res = __res;
															#line 1336 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(RangeResult && __res,int loopDepth) 
	{
		res = std::move(__res);
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditStatesActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStatesActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStatesActor*>(this)->ActorCallback< GetAuditStatesActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStatesActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getAuditStates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStates", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditStatesActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getAuditStates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStates", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditStatesActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStates", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStates", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditStatesActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStatesActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStatesActor*>(this)->ActorCallback< GetAuditStatesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStatesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditStates", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStates", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditStatesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditStates", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStates", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditStatesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStates", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStates", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType auditType;
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	bool newFirst;
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Optional<int> num;
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Optional<AuditPhase> phase;
															#line 141 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 142 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::vector<AuditStorageState> auditStates;
															#line 143 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Key readBegin;
															#line 144 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Key readEnd;
															#line 145 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Reverse reverse;
															#line 159 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	RangeResult res;
															#line 1520 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditStates()
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStatesActor final : public Actor<std::vector<AuditStorageState>>, public ActorCallback< GetAuditStatesActor, 0, RangeResult >, public ActorCallback< GetAuditStatesActor, 1, Void >, public FastAllocated<GetAuditStatesActor>, public GetAuditStatesActorState<GetAuditStatesActor> {
															#line 1525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditStatesActor>::operator new;
	using FastAllocated<GetAuditStatesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2205710573798415872UL, 6126379772064793600UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<AuditStorageState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditStatesActor, 0, RangeResult >;
friend struct ActorCallback< GetAuditStatesActor, 1, Void >;
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStatesActor(Database const& cx,AuditType const& auditType,bool const& newFirst,Optional<int> const& num,Optional<AuditPhase> const& phase) 
															#line 1543 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<std::vector<AuditStorageState>>(),
		   GetAuditStatesActorState<GetAuditStatesActor>(cx, auditType, newFirst, num, phase),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditStates", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3167609632865366528UL, 13809905943605247488UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStatesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditStates");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditStates", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditStatesActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditStatesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<std::vector<AuditStorageState>> getAuditStates( Database const& cx, AuditType const& auditType, bool const& newFirst, Optional<int> const& num, Optional<AuditPhase> const& phase ) {
															#line 136 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<std::vector<AuditStorageState>>(new GetAuditStatesActor(cx, auditType, newFirst, num, phase));
															#line 1577 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 190 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 1582 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via clearAuditMetadataForType()
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class ClearAuditMetadataForTypeActor>
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class ClearAuditMetadataForTypeActorState {
															#line 1589 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	ClearAuditMetadataForTypeActorState(Database const& cx,AuditType const& auditType,UID const& maxAuditIdToClear,int const& numFinishAuditToKeep) 
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditType(auditType),
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   maxAuditIdToClear(maxAuditIdToClear),
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   numFinishAuditToKeep(numFinishAuditToKeep),
															#line 195 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx),
															#line 196 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   numFinishAuditCleaned(0)
															#line 1606 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this));

	}
	~ClearAuditMetadataForTypeActorState() 
	{
		fdb_probe_actor_destroy("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 197 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilClearAuditMetadataForTypeStart") .detail("AuditType", auditType) .detail("MaxAuditIdToClear", maxAuditIdToClear);
															#line 1621 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			try {
															#line 202 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				;
															#line 1625 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ClearAuditMetadataForTypeActorState();
		static_cast<ClearAuditMetadataForTypeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 262 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<ClearAuditMetadataForTypeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ClearAuditMetadataForTypeActorState(); static_cast<ClearAuditMetadataForTypeActor*>(this)->destroy(); return 0; }
															#line 1654 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<ClearAuditMetadataForTypeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ClearAuditMetadataForTypeActorState();
		static_cast<ClearAuditMetadataForTypeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 256 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevInfo, "AuditUtilClearAuditMetadataForTypeError") .detail("AuditType", auditType) .errorUnsuppressed(e);
															#line 1667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 204 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<std::vector<AuditStorageState>> __when_expr_0 = getAuditStates(cx, auditType, false);
															#line 204 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1698 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state = 1;
															#line 204 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >*>(static_cast<ClearAuditMetadataForTypeActor*>(this)));
															#line 1703 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1740 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state = 3;
															#line 252 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >*>(static_cast<ClearAuditMetadataForTypeActor*>(this)));
															#line 1745 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 209 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		int numFinishAudit = 0;
															#line 210 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for( const auto& auditState : auditStates ) {
															#line 211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditState.id.first() > maxAuditIdToClear.first())
															#line 1764 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 214 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditState.getPhase() == AuditPhase::Complete || auditState.getPhase() == AuditPhase::Failed)
															#line 1770 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 215 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				numFinishAudit++;
															#line 1774 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
															#line 218 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		const int numFinishAuditToClean = numFinishAudit - numFinishAuditToKeep;
															#line 219 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		numFinishAuditCleaned = 0;
															#line 220 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 221 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 222 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 223 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for( const auto& auditState : auditStates ) {
															#line 224 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditState.id.first() > maxAuditIdToClear.first())
															#line 1791 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
				continue;
			}
															#line 227 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT(auditState.getType() == auditType);
															#line 228 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditState.getPhase() == AuditPhase::Complete && numFinishAuditCleaned < numFinishAuditToClean)
															#line 1799 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 231 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				tr.clear(auditKey(auditType, auditState.id));
															#line 234 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				numFinishAuditCleaned++;
															#line 1805 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
			else
			{
															#line 235 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Failed && numFinishAuditCleaned < numFinishAuditToClean)
															#line 1811 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 238 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					tr.clear(auditKey(auditType, auditState.id));
															#line 240 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					clearAuditProgressMetadata(&tr, auditType, auditState.id);
															#line 241 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					numFinishAuditCleaned++;
															#line 1819 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				}
			}
		}
															#line 245 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 245 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1827 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state = 2;
															#line 245 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >*>(static_cast<ClearAuditMetadataForTypeActor*>(this)));
															#line 1832 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<AuditStorageState> const& __auditStates,int loopDepth) 
	{
															#line 204 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditStates = __auditStates;
															#line 1841 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(std::vector<AuditStorageState> && __auditStates,int loopDepth) 
	{
		auditStates = std::move(__auditStates);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state > 0) static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAuditMetadataForTypeActor*>(this)->ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 246 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevDebug, "AuditUtilClearAuditMetadataForTypeEnd") .detail("AuditType", auditType) .detail("NumCleanedFinishAudits", numFinishAuditCleaned);
															#line 1920 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 246 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevDebug, "AuditUtilClearAuditMetadataForTypeEnd") .detail("AuditType", auditType) .detail("NumCleanedFinishAudits", numFinishAuditCleaned);
															#line 1929 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state > 0) static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAuditMetadataForTypeActor*>(this)->ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state > 0) static_cast<ClearAuditMetadataForTypeActor*>(this)->actor_wait_state = 0;
		static_cast<ClearAuditMetadataForTypeActor*>(this)->ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType auditType;
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID maxAuditIdToClear;
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int numFinishAuditToKeep;
															#line 195 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 196 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int numFinishAuditCleaned;
															#line 204 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::vector<AuditStorageState> auditStates;
															#line 2123 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via clearAuditMetadataForType()
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class ClearAuditMetadataForTypeActor final : public Actor<Void>, public ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >, public ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >, public ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >, public FastAllocated<ClearAuditMetadataForTypeActor>, public ClearAuditMetadataForTypeActorState<ClearAuditMetadataForTypeActor> {
															#line 2128 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<ClearAuditMetadataForTypeActor>::operator new;
	using FastAllocated<ClearAuditMetadataForTypeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16539712178786590464UL, 11720201749891649280UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >;
friend struct ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >;
friend struct ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >;
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	ClearAuditMetadataForTypeActor(Database const& cx,AuditType const& auditType,UID const& maxAuditIdToClear,int const& numFinishAuditToKeep) 
															#line 2147 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   ClearAuditMetadataForTypeActorState<ClearAuditMetadataForTypeActor>(cx, auditType, maxAuditIdToClear, numFinishAuditToKeep),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2691779984664438272UL, 7749499684062243584UL);
		ActorExecutionContextHelper __helper(static_cast<ClearAuditMetadataForTypeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("clearAuditMetadataForType");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("clearAuditMetadataForType", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ClearAuditMetadataForTypeActor, 0, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ClearAuditMetadataForTypeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ClearAuditMetadataForTypeActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<Void> clearAuditMetadataForType( Database const& cx, AuditType const& auditType, UID const& maxAuditIdToClear, int const& numFinishAuditToKeep ) {
															#line 191 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<Void>(new ClearAuditMetadataForTypeActor(cx, auditType, maxAuditIdToClear, numFinishAuditToKeep));
															#line 2182 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 264 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 2187 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkMoveKeysLockForAudit()
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class CheckMoveKeysLockForAuditActor>
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckMoveKeysLockForAuditActorState {
															#line 2194 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckMoveKeysLockForAuditActorState(Transaction* const& tr,MoveKeyLockInfo const& lock,bool const& isDDEnabled,bool const& isWrite = true) 
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : tr(tr),
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   lock(lock),
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   isDDEnabled(isDDEnabled),
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   isWrite(isWrite)
															#line 2207 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this));

	}
	~CheckMoveKeysLockForAuditActorState() 
	{
		fdb_probe_actor_destroy("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 269 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr->setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 270 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (!isDDEnabled)
															#line 2224 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 271 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevDebug, "AuditUtilDisabledByInMemoryCheck").log();
															#line 272 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2230 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 274 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr->get(moveKeysLockOwnerKey);
															#line 274 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2236 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state = 1;
															#line 274 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >*>(static_cast<CheckMoveKeysLockForAuditActor*>(this)));
															#line 2241 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckMoveKeysLockForAuditActorState();
		static_cast<CheckMoveKeysLockForAuditActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> const& readVal,int loopDepth) 
	{
															#line 275 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		UID currentOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 277 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (currentOwner == lock.prevOwner)
															#line 2266 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 279 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(moveKeysLockWriteKey);
															#line 279 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2272 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state = 2;
															#line 279 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >*>(static_cast<CheckMoveKeysLockForAuditActor*>(this)));
															#line 2277 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 301 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (currentOwner == lock.myOwner)
															#line 2284 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 302 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (isWrite)
															#line 2288 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					BinaryWriter wrLastWrite(Unversioned());
															#line 305 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					wrLastWrite << deterministicRandom()->randomUniqueID();
															#line 306 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 308 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					tr->makeSelfConflicting();
															#line 2298 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				}
															#line 310 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (!static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckMoveKeysLockForAuditActorState(); static_cast<CheckMoveKeysLockForAuditActor*>(this)->destroy(); return 0; }
															#line 2302 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				new (&static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckMoveKeysLockForAuditActorState();
				static_cast<CheckMoveKeysLockForAuditActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 312 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevDebug, "AuditUtilConflictWithNewOwner") .detail("CurrentOwner", currentOwner.toString()) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString());
															#line 317 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2314 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}

		return loopDepth;
	}
	int a_body1cont1(Optional<Value> && readVal,int loopDepth) 
	{
															#line 275 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		UID currentOwner = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 277 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (currentOwner == lock.prevOwner)
															#line 2326 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 279 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_1 = tr->get(moveKeysLockWriteKey);
															#line 279 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 2332 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state = 2;
															#line 279 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >*>(static_cast<CheckMoveKeysLockForAuditActor*>(this)));
															#line 2337 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		else
		{
															#line 301 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (currentOwner == lock.myOwner)
															#line 2344 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 302 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (isWrite)
															#line 2348 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 304 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					BinaryWriter wrLastWrite(Unversioned());
															#line 305 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					wrLastWrite << deterministicRandom()->randomUniqueID();
															#line 306 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 308 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					tr->makeSelfConflicting();
															#line 2358 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				}
															#line 310 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (!static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckMoveKeysLockForAuditActorState(); static_cast<CheckMoveKeysLockForAuditActor*>(this)->destroy(); return 0; }
															#line 2362 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				new (&static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV< Void >::value()) Void(Void());
				this->~CheckMoveKeysLockForAuditActorState();
				static_cast<CheckMoveKeysLockForAuditActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
			else
			{
															#line 312 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevDebug, "AuditUtilConflictWithNewOwner") .detail("CurrentOwner", currentOwner.toString()) .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString());
															#line 317 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2374 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}

		return loopDepth;
	}
	int a_body1when1(Optional<Value> const& readVal,int loopDepth) 
	{
		loopDepth = a_body1cont1(readVal, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Optional<Value> && readVal,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(readVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state > 0) static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state = 0;
		static_cast<CheckMoveKeysLockForAuditActor*>(this)->ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckMoveKeysLockForAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckMoveKeysLockForAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckMoveKeysLockForAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Optional<Value> const& readVal,int loopDepth) 
	{
															#line 280 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		UID lastWrite = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 281 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (lastWrite != lock.prevWrite)
															#line 2461 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 282 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "ConflictWithPreviousOwner");
															#line 283 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2467 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 286 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (isWrite)
															#line 2471 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 287 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			BinaryWriter wrMyOwner(Unversioned());
															#line 288 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			wrMyOwner << lock.myOwner;
															#line 289 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr->set(moveKeysLockOwnerKey, wrMyOwner.toValue());
															#line 290 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			BinaryWriter wrLastWrite(Unversioned());
															#line 291 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			UID lastWriter = deterministicRandom()->randomUniqueID();
															#line 292 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			wrLastWrite << lastWriter;
															#line 293 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 294 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent("AuditUtilCheckMoveKeysLock") .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("Writer", lastWriter.toString());
															#line 2489 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 300 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckMoveKeysLockForAuditActorState(); static_cast<CheckMoveKeysLockForAuditActor*>(this)->destroy(); return 0; }
															#line 2493 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckMoveKeysLockForAuditActorState();
		static_cast<CheckMoveKeysLockForAuditActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Optional<Value> && readVal,int loopDepth) 
	{
															#line 280 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		UID lastWrite = readVal.present() ? BinaryReader::fromStringRef<UID>(readVal.get(), Unversioned()) : UID();
															#line 281 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (lastWrite != lock.prevWrite)
															#line 2507 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 282 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "ConflictWithPreviousOwner");
															#line 283 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch1(movekeys_conflict(), loopDepth);
															#line 2513 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 286 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (isWrite)
															#line 2517 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 287 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			BinaryWriter wrMyOwner(Unversioned());
															#line 288 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			wrMyOwner << lock.myOwner;
															#line 289 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr->set(moveKeysLockOwnerKey, wrMyOwner.toValue());
															#line 290 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			BinaryWriter wrLastWrite(Unversioned());
															#line 291 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			UID lastWriter = deterministicRandom()->randomUniqueID();
															#line 292 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			wrLastWrite << lastWriter;
															#line 293 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr->set(moveKeysLockWriteKey, wrLastWrite.toValue());
															#line 294 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent("AuditUtilCheckMoveKeysLock") .detail("PrevOwner", lock.prevOwner.toString()) .detail("PrevWrite", lock.prevWrite.toString()) .detail("MyOwner", lock.myOwner.toString()) .detail("Writer", lastWriter.toString());
															#line 2535 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 300 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~CheckMoveKeysLockForAuditActorState(); static_cast<CheckMoveKeysLockForAuditActor*>(this)->destroy(); return 0; }
															#line 2539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<CheckMoveKeysLockForAuditActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~CheckMoveKeysLockForAuditActorState();
		static_cast<CheckMoveKeysLockForAuditActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> const& readVal,int loopDepth) 
	{
		loopDepth = a_body1cont4(readVal, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Optional<Value> && readVal,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(readVal), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state > 0) static_cast<CheckMoveKeysLockForAuditActor*>(this)->actor_wait_state = 0;
		static_cast<CheckMoveKeysLockForAuditActor*>(this)->ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckMoveKeysLockForAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckMoveKeysLockForAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckMoveKeysLockForAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction* tr;
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	MoveKeyLockInfo lock;
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	bool isDDEnabled;
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	bool isWrite;
															#line 2630 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkMoveKeysLockForAudit()
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckMoveKeysLockForAuditActor final : public Actor<Void>, public ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >, public ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >, public FastAllocated<CheckMoveKeysLockForAuditActor>, public CheckMoveKeysLockForAuditActorState<CheckMoveKeysLockForAuditActor> {
															#line 2635 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckMoveKeysLockForAuditActor>::operator new;
	using FastAllocated<CheckMoveKeysLockForAuditActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7726288482251059712UL, 675811272010867456UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >;
friend struct ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >;
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckMoveKeysLockForAuditActor(Transaction* const& tr,MoveKeyLockInfo const& lock,bool const& isDDEnabled,bool const& isWrite = true) 
															#line 2653 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   CheckMoveKeysLockForAuditActorState<CheckMoveKeysLockForAuditActor>(tr, lock, isDDEnabled, isWrite),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17967583375086042368UL, 8101399529876800512UL);
		ActorExecutionContextHelper __helper(static_cast<CheckMoveKeysLockForAuditActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkMoveKeysLockForAudit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkMoveKeysLockForAudit", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckMoveKeysLockForAuditActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckMoveKeysLockForAuditActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] static Future<Void> checkMoveKeysLockForAudit( Transaction* const& tr, MoveKeyLockInfo const& lock, bool const& isDDEnabled, bool const& isWrite = true ) {
															#line 265 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<Void>(new CheckMoveKeysLockForAuditActor(tr, lock, isDDEnabled, isWrite));
															#line 2687 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 320 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 2692 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via persistNewAuditState()
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class PersistNewAuditStateActor>
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistNewAuditStateActorState {
															#line 2699 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistNewAuditStateActorState(Database const& cx,AuditStorageState const& auditState,MoveKeyLockInfo const& lock,bool const& ddEnabled) 
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditState(auditState),
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   lock(lock),
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   ddEnabled(ddEnabled)
															#line 2712 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("persistNewAuditState", reinterpret_cast<unsigned long>(this));

	}
	~PersistNewAuditStateActorState() 
	{
		fdb_probe_actor_destroy("persistNewAuditState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 325 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT(!auditState.id.isValid());
															#line 326 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr = Transaction(cx);
															#line 327 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auditId = UID();
															#line 328 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			latestExistingAuditState = AuditStorageState();
															#line 329 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilPersistedNewAuditStateStart", auditId);
															#line 2735 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			try {
															#line 331 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				;
															#line 2739 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				loopDepth = a_body1loopHead1(loopDepth);
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PersistNewAuditStateActorState();
		static_cast<PersistNewAuditStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 387 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<PersistNewAuditStateActor*>(this)->SAV<UID>::futures) { (void)(auditId); this->~PersistNewAuditStateActorState(); static_cast<PersistNewAuditStateActor*>(this)->destroy(); return 0; }
															#line 2768 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<PersistNewAuditStateActor*>(this)->SAV< UID >::value()) UID(std::move(auditId)); // state_var_RVO
		this->~PersistNewAuditStateActorState();
		static_cast<PersistNewAuditStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 376 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevWarn, "AuditUtilPersistedNewAuditStateUnretriableError", auditId) .errorUnsuppressed(e) .detail("AuditKey", auditKey(auditState.getType(), auditId));
															#line 379 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT_WE_THINK(e.code() == error_code_actor_cancelled || e.code() == error_code_movekeys_conflict);
															#line 380 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 2785 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 381 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 2789 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
			else
			{
															#line 383 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(persist_new_audit_metadata_error(), loopDepth);
															#line 2795 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 333 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 334 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 335 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 336 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkMoveKeysLockForAudit(&tr, lock, ddEnabled, true);
															#line 336 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2832 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 1;
															#line 336 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PersistNewAuditStateActor, 0, Void >*>(static_cast<PersistNewAuditStateActor*>(this)));
															#line 2837 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 369 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilPersistedNewAuditStateError", auditId) .errorUnsuppressed(e) .detail("AuditKey", auditKey(auditState.getType(), auditId));
															#line 372 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 372 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2876 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 4;
															#line 372 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PersistNewAuditStateActor, 3, Void >*>(static_cast<PersistNewAuditStateActor*>(this)));
															#line 2881 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 337 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(auditKeyRange(auditState.getType()), 1, Snapshot::False, Reverse::True);
															#line 337 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2898 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 2;
															#line 337 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistNewAuditStateActor, 1, RangeResult >*>(static_cast<PersistNewAuditStateActor*>(this)));
															#line 2903 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 337 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(auditKeyRange(auditState.getType()), 1, Snapshot::False, Reverse::True);
															#line 337 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 2914 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 2;
															#line 337 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistNewAuditStateActor, 1, RangeResult >*>(static_cast<PersistNewAuditStateActor*>(this)));
															#line 2919 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistNewAuditStateActor*>(this)->ActorCallback< PersistNewAuditStateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PersistNewAuditStateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& res,int loopDepth) 
	{
															#line 339 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(res.size() == 0 || res.size() == 1);
															#line 340 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		uint64_t nextId = 1;
															#line 341 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res.empty())
															#line 3007 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 342 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			latestExistingAuditState = decodeAuditStorageState(res[0].value);
															#line 343 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditId.isValid())
															#line 3013 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 345 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				ASSERT(latestExistingAuditState.id.first() <= auditId.first());
															#line 346 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (latestExistingAuditState.id.first() == auditId.first())
															#line 3019 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 349 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					if (!static_cast<PersistNewAuditStateActor*>(this)->SAV<UID>::futures) { (void)(auditId); this->~PersistNewAuditStateActorState(); static_cast<PersistNewAuditStateActor*>(this)->destroy(); return 0; }
															#line 3023 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					new (&static_cast<PersistNewAuditStateActor*>(this)->SAV< UID >::value()) UID(std::move(auditId)); // state_var_RVO
					this->~PersistNewAuditStateActorState();
					static_cast<PersistNewAuditStateActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 354 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					ASSERT(auditId.first() == latestExistingAuditState.id.first() + 1);
															#line 3033 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				}
			}
															#line 357 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			nextId = latestExistingAuditState.id.first() + 1;
															#line 3038 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 359 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditId = UID(nextId, 0LL);
															#line 360 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditState.id = auditId;
															#line 361 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilPersistedNewAuditStateIdSelected", auditId) .detail("AuditKey", auditKey(auditState.getType(), auditId));
															#line 363 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.set(auditKey(auditState.getType(), auditId), auditStorageStateValue(auditState));
															#line 364 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 364 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3052 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 3;
															#line 364 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistNewAuditStateActor, 2, Void >*>(static_cast<PersistNewAuditStateActor*>(this)));
															#line 3057 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && res,int loopDepth) 
	{
															#line 339 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(res.size() == 0 || res.size() == 1);
															#line 340 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		uint64_t nextId = 1;
															#line 341 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res.empty())
															#line 3070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 342 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			latestExistingAuditState = decodeAuditStorageState(res[0].value);
															#line 343 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditId.isValid())
															#line 3076 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 345 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				ASSERT(latestExistingAuditState.id.first() <= auditId.first());
															#line 346 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (latestExistingAuditState.id.first() == auditId.first())
															#line 3082 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 349 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					if (!static_cast<PersistNewAuditStateActor*>(this)->SAV<UID>::futures) { (void)(auditId); this->~PersistNewAuditStateActorState(); static_cast<PersistNewAuditStateActor*>(this)->destroy(); return 0; }
															#line 3086 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					new (&static_cast<PersistNewAuditStateActor*>(this)->SAV< UID >::value()) UID(std::move(auditId)); // state_var_RVO
					this->~PersistNewAuditStateActorState();
					static_cast<PersistNewAuditStateActor*>(this)->finishSendAndDelPromiseRef();
					return 0;
				}
				else
				{
															#line 354 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					ASSERT(auditId.first() == latestExistingAuditState.id.first() + 1);
															#line 3096 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				}
			}
															#line 357 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			nextId = latestExistingAuditState.id.first() + 1;
															#line 3101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 359 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditId = UID(nextId, 0LL);
															#line 360 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditState.id = auditId;
															#line 361 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilPersistedNewAuditStateIdSelected", auditId) .detail("AuditKey", auditKey(auditState.getType(), auditId));
															#line 363 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.set(auditKey(auditState.getType(), auditId), auditStorageStateValue(auditState));
															#line 364 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 364 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3115 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 3;
															#line 364 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistNewAuditStateActor, 2, Void >*>(static_cast<PersistNewAuditStateActor*>(this)));
															#line 3120 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(res, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && res,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(res), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistNewAuditStateActor*>(this)->ActorCallback< PersistNewAuditStateActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PersistNewAuditStateActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 365 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevDebug, "AuditUtilPersistedNewAuditState", auditId) .detail("AuditKey", auditKey(auditState.getType(), auditId));
															#line 3204 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 365 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevDebug, "AuditUtilPersistedNewAuditState", auditId) .detail("AuditKey", auditKey(auditState.getType(), auditId));
															#line 3213 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistNewAuditStateActor*>(this)->ActorCallback< PersistNewAuditStateActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PersistNewAuditStateActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistNewAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistNewAuditStateActor*>(this)->ActorCallback< PersistNewAuditStateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PersistNewAuditStateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PersistNewAuditStateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont3(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditStorageState auditState;
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	MoveKeyLockInfo lock;
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	bool ddEnabled;
															#line 326 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 327 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditId;
															#line 328 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditStorageState latestExistingAuditState;
															#line 3407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via persistNewAuditState()
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistNewAuditStateActor final : public Actor<UID>, public ActorCallback< PersistNewAuditStateActor, 0, Void >, public ActorCallback< PersistNewAuditStateActor, 1, RangeResult >, public ActorCallback< PersistNewAuditStateActor, 2, Void >, public ActorCallback< PersistNewAuditStateActor, 3, Void >, public FastAllocated<PersistNewAuditStateActor>, public PersistNewAuditStateActorState<PersistNewAuditStateActor> {
															#line 3412 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<PersistNewAuditStateActor>::operator new;
	using FastAllocated<PersistNewAuditStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16907449208107312896UL, 11902430058175895296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<UID>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PersistNewAuditStateActor, 0, Void >;
friend struct ActorCallback< PersistNewAuditStateActor, 1, RangeResult >;
friend struct ActorCallback< PersistNewAuditStateActor, 2, Void >;
friend struct ActorCallback< PersistNewAuditStateActor, 3, Void >;
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistNewAuditStateActor(Database const& cx,AuditStorageState const& auditState,MoveKeyLockInfo const& lock,bool const& ddEnabled) 
															#line 3432 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<UID>(),
		   PersistNewAuditStateActorState<PersistNewAuditStateActor>(cx, auditState, lock, ddEnabled),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("persistNewAuditState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10305488094696748544UL, 8284581294054826496UL);
		ActorExecutionContextHelper __helper(static_cast<PersistNewAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("persistNewAuditState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("persistNewAuditState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PersistNewAuditStateActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PersistNewAuditStateActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PersistNewAuditStateActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PersistNewAuditStateActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<UID> persistNewAuditState( Database const& cx, AuditStorageState const& auditState, MoveKeyLockInfo const& lock, bool const& ddEnabled ) {
															#line 321 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<UID>(new PersistNewAuditStateActor(cx, auditState, lock, ddEnabled));
															#line 3468 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 389 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 3473 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via persistAuditState()
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class PersistAuditStateActor>
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistAuditStateActorState {
															#line 3480 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistAuditStateActorState(Database const& cx,AuditStorageState const& auditState,std::string const& context,MoveKeyLockInfo const& lock,bool const& ddEnabled) 
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditState(auditState),
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   context(context),
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   lock(lock),
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   ddEnabled(ddEnabled),
															#line 395 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx),
															#line 396 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditPhase(auditState.getPhase())
															#line 3499 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("persistAuditState", reinterpret_cast<unsigned long>(this));

	}
	~PersistAuditStateActorState() 
	{
		fdb_probe_actor_destroy("persistAuditState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 397 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT(auditPhase == AuditPhase::Complete || auditPhase == AuditPhase::Failed || auditPhase == AuditPhase::Error);
															#line 399 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 3516 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PersistAuditStateActorState();
		static_cast<PersistAuditStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 442 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<PersistAuditStateActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PersistAuditStateActorState(); static_cast<PersistAuditStateActor*>(this)->destroy(); return 0; }
															#line 3539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<PersistAuditStateActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PersistAuditStateActorState();
		static_cast<PersistAuditStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 401 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 402 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 403 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 404 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkMoveKeysLockForAudit(&tr, lock, ddEnabled, true);
															#line 404 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3567 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 1;
															#line 404 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateActor, 0, Void >*>(static_cast<PersistAuditStateActor*>(this)));
															#line 3572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 431 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevWarn, "AuditUtilPersistAuditStateError", auditState.id) .errorUnsuppressed(e) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditPhase", auditPhase) .detail("AuditKey", auditKey(auditState.getType(), auditState.id)) .detail("Context", context);
															#line 438 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 438 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 3611 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 4;
															#line 438 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateActor, 3, Void >*>(static_cast<PersistAuditStateActor*>(this)));
															#line 3616 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 406 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (auditPhase == AuditPhase::Complete)
															#line 3631 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			clearAuditProgressMetadata(&tr, auditState.getType(), auditState.id);
															#line 3635 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 410 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(auditKey(auditState.getType(), auditState.id));
															#line 410 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3641 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 2;
															#line 410 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateActor, 1, Optional<Value> >*>(static_cast<PersistAuditStateActor*>(this)));
															#line 3646 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 406 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (auditPhase == AuditPhase::Complete)
															#line 3655 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 407 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			clearAuditProgressMetadata(&tr, auditState.getType(), auditState.id);
															#line 3659 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 410 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Optional<Value>> __when_expr_1 = tr.get(auditKey(auditState.getType(), auditState.id));
															#line 410 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3665 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 2;
															#line 410 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateActor, 1, Optional<Value> >*>(static_cast<PersistAuditStateActor*>(this)));
															#line 3670 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateActor*>(this)->ActorCallback< PersistAuditStateActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PersistAuditStateActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Optional<Value> const& res_,int loopDepth) 
	{
															#line 411 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res_.present())
															#line 3754 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 412 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 3758 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		else
		{
															#line 414 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			const AuditStorageState currentState = decodeAuditStorageState(res_.get());
															#line 415 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT(currentState.id == auditState.id && currentState.getType() == auditState.getType());
															#line 416 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (currentState.getPhase() == AuditPhase::Failed)
															#line 3768 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 417 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 3772 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
															#line 421 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.set(auditKey(auditState.getType(), auditState.id), auditStorageStateValue(auditState));
															#line 422 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 422 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3781 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 3;
															#line 422 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateActor, 2, Void >*>(static_cast<PersistAuditStateActor*>(this)));
															#line 3786 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Optional<Value> && res_,int loopDepth) 
	{
															#line 411 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res_.present())
															#line 3795 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 412 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 3799 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		else
		{
															#line 414 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			const AuditStorageState currentState = decodeAuditStorageState(res_.get());
															#line 415 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT(currentState.id == auditState.id && currentState.getType() == auditState.getType());
															#line 416 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (currentState.getPhase() == AuditPhase::Failed)
															#line 3809 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 417 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 3813 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
															#line 421 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		tr.set(auditKey(auditState.getType(), auditState.id), auditStorageStateValue(auditState));
															#line 422 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 422 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 3822 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 3;
															#line 422 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateActor, 2, Void >*>(static_cast<PersistAuditStateActor*>(this)));
															#line 3827 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> const& res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(res_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Optional<Value> && res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(res_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateActor*>(this)->ActorCallback< PersistAuditStateActor, 1, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 1, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 1, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PersistAuditStateActor, 1, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont5(Void const& _,int loopDepth) 
	{
															#line 423 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilPersistAuditState", auditState.id) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditPhase", auditPhase) .detail("AuditKey", auditKey(auditState.getType(), auditState.id)) .detail("Context", context);
															#line 3911 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont5(Void && _,int loopDepth) 
	{
															#line 423 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilPersistAuditState", auditState.id) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditPhase", auditPhase) .detail("AuditKey", auditKey(auditState.getType(), auditState.id)) .detail("Context", context);
															#line 3920 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateActor*>(this)->ActorCallback< PersistAuditStateActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PersistAuditStateActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PersistAuditStateActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateActor*>(this)->ActorCallback< PersistAuditStateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PersistAuditStateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditStorageState auditState;
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::string context;
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	MoveKeyLockInfo lock;
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	bool ddEnabled;
															#line 395 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 396 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditPhase auditPhase;
															#line 4101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via persistAuditState()
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistAuditStateActor final : public Actor<Void>, public ActorCallback< PersistAuditStateActor, 0, Void >, public ActorCallback< PersistAuditStateActor, 1, Optional<Value> >, public ActorCallback< PersistAuditStateActor, 2, Void >, public ActorCallback< PersistAuditStateActor, 3, Void >, public FastAllocated<PersistAuditStateActor>, public PersistAuditStateActorState<PersistAuditStateActor> {
															#line 4106 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<PersistAuditStateActor>::operator new;
	using FastAllocated<PersistAuditStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17707563174281300992UL, 5755898014018640896UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PersistAuditStateActor, 0, Void >;
friend struct ActorCallback< PersistAuditStateActor, 1, Optional<Value> >;
friend struct ActorCallback< PersistAuditStateActor, 2, Void >;
friend struct ActorCallback< PersistAuditStateActor, 3, Void >;
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistAuditStateActor(Database const& cx,AuditStorageState const& auditState,std::string const& context,MoveKeyLockInfo const& lock,bool const& ddEnabled) 
															#line 4126 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PersistAuditStateActorState<PersistAuditStateActor>(cx, auditState, context, lock, ddEnabled),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("persistAuditState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(1344343807573194240UL, 3027519602546182400UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("persistAuditState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("persistAuditState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PersistAuditStateActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PersistAuditStateActor, 1, Optional<Value> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PersistAuditStateActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PersistAuditStateActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<Void> persistAuditState( Database const& cx, AuditStorageState const& auditState, std::string const& context, MoveKeyLockInfo const& lock, bool const& ddEnabled ) {
															#line 390 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<Void>(new PersistAuditStateActor(cx, auditState, context, lock, ddEnabled));
															#line 4162 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 444 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 4167 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getAuditState()
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class GetAuditStateActor>
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStateActorState {
															#line 4174 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStateActorState(Database const& cx,AuditType const& type,UID const& id) 
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   type(type),
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   id(id),
															#line 446 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx),
															#line 447 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   res()
															#line 4189 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditState", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditStateActorState() 
	{
		fdb_probe_actor_destroy("getAuditState", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 449 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 4204 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditStateActorState();
		static_cast<GetAuditStateActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 471 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!res.present())
															#line 4227 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 472 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch1(key_not_found(), loopDepth);
															#line 4231 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 475 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<GetAuditStateActor*>(this)->SAV<AuditStorageState>::futures) { (void)(decodeAuditStorageState(res.get())); this->~GetAuditStateActorState(); static_cast<GetAuditStateActor*>(this)->destroy(); return 0; }
															#line 4235 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditStateActor*>(this)->SAV< AuditStorageState >::value()) AuditStorageState(decodeAuditStorageState(res.get()));
		this->~GetAuditStateActorState();
		static_cast<GetAuditStateActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 451 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 452 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 453 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 454 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(auditKey(type, id));
															#line 454 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<GetAuditStateActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4263 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAuditStateActor*>(this)->actor_wait_state = 1;
															#line 454 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditStateActor, 0, Optional<Value> >*>(static_cast<GetAuditStateActor*>(this)));
															#line 4268 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 462 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilReadAuditStateError", id) .errorUnsuppressed(e) .detail("AuditID", id) .detail("AuditType", type) .detail("AuditKey", auditKey(type, id));
															#line 467 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 467 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<GetAuditStateActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4307 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAuditStateActor*>(this)->actor_wait_state = 2;
															#line 467 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditStateActor, 1, Void >*>(static_cast<GetAuditStateActor*>(this)));
															#line 4312 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& res_,int loopDepth) 
	{
															#line 455 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		res = res_;
															#line 456 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevDebug, "AuditUtilReadAuditState", id) .detail("AuditID", id) .detail("AuditType", type) .detail("AuditKey", auditKey(type, id));
															#line 4329 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && res_,int loopDepth) 
	{
															#line 455 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		res = res_;
															#line 456 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevDebug, "AuditUtilReadAuditState", id) .detail("AuditID", id) .detail("AuditType", type) .detail("AuditKey", auditKey(type, id));
															#line 4340 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditStateActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStateActor*>(this)->ActorCallback< GetAuditStateActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStateActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("getAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditStateActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("getAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditStateActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditState", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditState", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditStateActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStateActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStateActor*>(this)->ActorCallback< GetAuditStateActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditStateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditStateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditState", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditState", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType type;
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID id;
															#line 446 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 447 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Optional<Value> res;
															#line 4517 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditState()
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStateActor final : public Actor<AuditStorageState>, public ActorCallback< GetAuditStateActor, 0, Optional<Value> >, public ActorCallback< GetAuditStateActor, 1, Void >, public FastAllocated<GetAuditStateActor>, public GetAuditStateActorState<GetAuditStateActor> {
															#line 4522 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditStateActor>::operator new;
	using FastAllocated<GetAuditStateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7951650409061175296UL, 10803942205874759680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<AuditStorageState>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditStateActor, 0, Optional<Value> >;
friend struct ActorCallback< GetAuditStateActor, 1, Void >;
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStateActor(Database const& cx,AuditType const& type,UID const& id) 
															#line 4540 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<AuditStorageState>(),
		   GetAuditStateActorState<GetAuditStateActor>(cx, type, id),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditState", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14929657578609179648UL, 1747181064157270016UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditState");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditState", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditStateActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditStateActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<AuditStorageState> getAuditState( Database const& cx, AuditType const& type, UID const& id ) {
															#line 445 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<AuditStorageState>(new GetAuditStateActor(cx, type, id));
															#line 4574 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 477 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 4579 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via persistAuditStateByRange()
															#line 478 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class PersistAuditStateByRangeActor>
															#line 478 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistAuditStateByRangeActorState {
															#line 4586 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 478 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistAuditStateByRangeActorState(Database const& cx,AuditStorageState const& auditState) 
															#line 478 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 478 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 478 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditState(auditState),
															#line 479 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx)
															#line 4597 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("persistAuditStateByRange", reinterpret_cast<unsigned long>(this));

	}
	~PersistAuditStateByRangeActorState() 
	{
		fdb_probe_actor_destroy("persistAuditStateByRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 481 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 4612 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PersistAuditStateByRangeActorState();
		static_cast<PersistAuditStateByRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 522 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<PersistAuditStateByRangeActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PersistAuditStateByRangeActorState(); static_cast<PersistAuditStateByRangeActor*>(this)->destroy(); return 0; }
															#line 4635 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<PersistAuditStateByRangeActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PersistAuditStateByRangeActorState();
		static_cast<PersistAuditStateByRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 483 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 484 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 485 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 486 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(auditKey(auditState.getType(), auditState.id));
															#line 486 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4663 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 1;
															#line 486 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 4668 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 513 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilPersistAuditStateByRangeError") .errorUnsuppressed(e) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditPhase", auditState.getPhase());
															#line 518 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 518 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 4707 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 4;
															#line 518 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 3, Void >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 4712 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& ddAuditState_,int loopDepth) 
	{
															#line 487 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!ddAuditState_.present())
															#line 4727 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 488 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 4731 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 490 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		AuditStorageState ddAuditState = decodeAuditStorageState(ddAuditState_.get());
															#line 491 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.ddId.isValid());
															#line 492 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.ddId != auditState.ddId)
															#line 4739 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 493 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_task_outdated(), loopDepth);
															#line 4743 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 498 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Complete)
															#line 4747 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 502 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.getPhase() == AuditPhase::Running || ddAuditState.getPhase() == AuditPhase::Failed);
															#line 503 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Failed)
															#line 4755 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 504 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 4759 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 506 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = krmSetRange(&tr, auditRangeBasedProgressPrefixFor(auditState.getType(), auditState.id), auditState.range, auditStorageStateValue(auditState));
															#line 506 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4765 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 2;
															#line 506 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 1, Void >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 4770 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && ddAuditState_,int loopDepth) 
	{
															#line 487 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!ddAuditState_.present())
															#line 4779 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 488 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 4783 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 490 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		AuditStorageState ddAuditState = decodeAuditStorageState(ddAuditState_.get());
															#line 491 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.ddId.isValid());
															#line 492 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.ddId != auditState.ddId)
															#line 4791 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 493 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_task_outdated(), loopDepth);
															#line 4795 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 498 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Complete)
															#line 4799 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 502 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.getPhase() == AuditPhase::Running || ddAuditState.getPhase() == AuditPhase::Failed);
															#line 503 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Failed)
															#line 4807 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 504 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 4811 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 506 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = krmSetRange(&tr, auditRangeBasedProgressPrefixFor(auditState.getType(), auditState.id), auditState.range, auditStorageStateValue(auditState));
															#line 506 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4817 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 2;
															#line 506 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 1, Void >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 4822 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& ddAuditState_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ddAuditState_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && ddAuditState_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ddAuditState_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByRangeActor*>(this)->ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 510 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 510 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4908 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 3;
															#line 510 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 2, Void >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 4913 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 510 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 510 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 4924 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 3;
															#line 510 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByRangeActor, 2, Void >*>(static_cast<PersistAuditStateByRangeActor*>(this)));
															#line 4929 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByRangeActor*>(this)->ActorCallback< PersistAuditStateByRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByRangeActor*>(this)->ActorCallback< PersistAuditStateByRangeActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByRangeActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByRangeActor*>(this)->ActorCallback< PersistAuditStateByRangeActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByRangeActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByRangeActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 478 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 478 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditStorageState auditState;
															#line 479 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 5189 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via persistAuditStateByRange()
															#line 478 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistAuditStateByRangeActor final : public Actor<Void>, public ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >, public ActorCallback< PersistAuditStateByRangeActor, 1, Void >, public ActorCallback< PersistAuditStateByRangeActor, 2, Void >, public ActorCallback< PersistAuditStateByRangeActor, 3, Void >, public FastAllocated<PersistAuditStateByRangeActor>, public PersistAuditStateByRangeActorState<PersistAuditStateByRangeActor> {
															#line 5194 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<PersistAuditStateByRangeActor>::operator new;
	using FastAllocated<PersistAuditStateByRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17640683768539788032UL, 8543460748879724544UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >;
friend struct ActorCallback< PersistAuditStateByRangeActor, 1, Void >;
friend struct ActorCallback< PersistAuditStateByRangeActor, 2, Void >;
friend struct ActorCallback< PersistAuditStateByRangeActor, 3, Void >;
															#line 478 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistAuditStateByRangeActor(Database const& cx,AuditStorageState const& auditState) 
															#line 5214 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PersistAuditStateByRangeActorState<PersistAuditStateByRangeActor>(cx, auditState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(12978781156159195648UL, 11031502681131358976UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("persistAuditStateByRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("persistAuditStateByRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PersistAuditStateByRangeActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PersistAuditStateByRangeActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PersistAuditStateByRangeActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PersistAuditStateByRangeActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 478 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<Void> persistAuditStateByRange( Database const& cx, AuditStorageState const& auditState ) {
															#line 478 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<Void>(new PersistAuditStateByRangeActor(cx, auditState));
															#line 5250 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 524 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 5255 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getAuditStateByRange()
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class GetAuditStateByRangeActor>
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStateByRangeActorState {
															#line 5262 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStateByRangeActorState(Database const& cx,AuditType const& type,UID const& auditId,KeyRange const& range) 
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   type(type),
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditId(auditId),
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   range(range),
															#line 529 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditStates(),
															#line 530 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx)
															#line 5279 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditStateByRange", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditStateByRangeActorState() 
	{
		fdb_probe_actor_destroy("getAuditStateByRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 532 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 5294 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditStateByRangeActorState();
		static_cast<GetAuditStateByRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 554 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		std::vector<AuditStorageState> res;
															#line 555 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < auditStates.size() - 1;++i) {
															#line 556 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			KeyRange currentRange = KeyRangeRef(auditStates[i].key, auditStates[i + 1].key);
															#line 557 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			AuditStorageState auditState(auditId, currentRange, type);
															#line 558 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (!auditStates[i].value.empty())
															#line 5325 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 559 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				AuditStorageState auditState_ = decodeAuditStorageState(auditStates[i].value);
															#line 560 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				auditState.setPhase(auditState_.getPhase());
															#line 561 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				auditState.error = auditState_.error;
															#line 5333 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 563 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			res.push_back(auditState);
															#line 5337 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 566 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<GetAuditStateByRangeActor*>(this)->SAV<std::vector<AuditStorageState>>::futures) { (void)(res); this->~GetAuditStateByRangeActorState(); static_cast<GetAuditStateByRangeActor*>(this)->destroy(); return 0; }
															#line 5341 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditStateByRangeActor*>(this)->SAV< std::vector<AuditStorageState> >::value()) std::vector<AuditStorageState>(res);
		this->~GetAuditStateByRangeActorState();
		static_cast<GetAuditStateByRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 534 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 535 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 536 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 537 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, auditRangeBasedProgressPrefixFor(type, auditId), range, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT_BYTES);
															#line 537 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5369 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state = 1;
															#line 537 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >*>(static_cast<GetAuditStateByRangeActor*>(this)));
															#line 5374 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 545 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilGetAuditStateForRangeError").errorUnsuppressed(e).detail("AuditID", auditId);
															#line 546 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 546 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5413 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state = 2;
															#line 546 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditStateByRangeActor, 1, Void >*>(static_cast<GetAuditStateByRangeActor*>(this)));
															#line 5418 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& res_,int loopDepth) 
	{
															#line 542 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditStates = res_;
															#line 5433 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && res_,int loopDepth) 
	{
															#line 542 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditStates = res_;
															#line 5442 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStateByRangeActor*>(this)->ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStateByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStateByRangeActor*>(this)->ActorCallback< GetAuditStateByRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStateByRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditStateByRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditStateByRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType type;
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditId;
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange range;
															#line 529 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	RangeResult auditStates;
															#line 530 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 5621 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditStateByRange()
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStateByRangeActor final : public Actor<std::vector<AuditStorageState>>, public ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >, public ActorCallback< GetAuditStateByRangeActor, 1, Void >, public FastAllocated<GetAuditStateByRangeActor>, public GetAuditStateByRangeActorState<GetAuditStateByRangeActor> {
															#line 5626 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditStateByRangeActor>::operator new;
	using FastAllocated<GetAuditStateByRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6726754286305206016UL, 13088628110580688384UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<AuditStorageState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >;
friend struct ActorCallback< GetAuditStateByRangeActor, 1, Void >;
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStateByRangeActor(Database const& cx,AuditType const& type,UID const& auditId,KeyRange const& range) 
															#line 5644 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<std::vector<AuditStorageState>>(),
		   GetAuditStateByRangeActorState<GetAuditStateByRangeActor>(cx, type, auditId, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditStateByRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9019552324261391360UL, 16492306215431648768UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditStateByRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditStateByRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditStateByRangeActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditStateByRangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<std::vector<AuditStorageState>> getAuditStateByRange( Database const& cx, AuditType const& type, UID const& auditId, KeyRange const& range ) {
															#line 525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<std::vector<AuditStorageState>>(new GetAuditStateByRangeActor(cx, type, auditId, range));
															#line 5678 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 568 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 5683 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via persistAuditStateByServer()
															#line 569 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class PersistAuditStateByServerActor>
															#line 569 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistAuditStateByServerActorState {
															#line 5690 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 569 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistAuditStateByServerActorState(Database const& cx,AuditStorageState const& auditState) 
															#line 569 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 569 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 569 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditState(auditState),
															#line 570 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx)
															#line 5701 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("persistAuditStateByServer", reinterpret_cast<unsigned long>(this));

	}
	~PersistAuditStateByServerActorState() 
	{
		fdb_probe_actor_destroy("persistAuditStateByServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 572 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 5716 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PersistAuditStateByServerActorState();
		static_cast<PersistAuditStateByServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 615 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<PersistAuditStateByServerActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PersistAuditStateByServerActorState(); static_cast<PersistAuditStateByServerActor*>(this)->destroy(); return 0; }
															#line 5739 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<PersistAuditStateByServerActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PersistAuditStateByServerActorState();
		static_cast<PersistAuditStateByServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 574 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 575 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 576 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 577 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Optional<Value>> __when_expr_0 = tr.get(auditKey(auditState.getType(), auditState.id));
															#line 577 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5767 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 1;
															#line 577 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >*>(static_cast<PersistAuditStateByServerActor*>(this)));
															#line 5772 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 605 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilPersistAuditStateByRangeError") .errorUnsuppressed(e) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditPhase", auditState.getPhase()) .detail("AuditServerID", auditState.auditServerId);
															#line 611 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 611 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 5811 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
			static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 4;
															#line 611 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByServerActor, 3, Void >*>(static_cast<PersistAuditStateByServerActor*>(this)));
															#line 5816 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> const& ddAuditState_,int loopDepth) 
	{
															#line 578 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!ddAuditState_.present())
															#line 5831 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 579 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 5835 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 581 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		AuditStorageState ddAuditState = decodeAuditStorageState(ddAuditState_.get());
															#line 582 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.ddId.isValid());
															#line 583 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.ddId != auditState.ddId)
															#line 5843 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 584 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_task_outdated(), loopDepth);
															#line 5847 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 589 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Complete)
															#line 5851 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 593 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.getPhase() == AuditPhase::Running || ddAuditState.getPhase() == AuditPhase::Failed);
															#line 594 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Failed)
															#line 5859 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 595 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 5863 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 597 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = krmSetRange( &tr, auditServerBasedProgressPrefixFor(auditState.getType(), auditState.id, auditState.auditServerId), auditState.range, auditStorageStateValue(auditState));
															#line 597 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5869 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 2;
															#line 597 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByServerActor, 1, Void >*>(static_cast<PersistAuditStateByServerActor*>(this)));
															#line 5874 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Optional<Value> && ddAuditState_,int loopDepth) 
	{
															#line 578 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!ddAuditState_.present())
															#line 5883 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 579 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 5887 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 581 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		AuditStorageState ddAuditState = decodeAuditStorageState(ddAuditState_.get());
															#line 582 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.ddId.isValid());
															#line 583 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.ddId != auditState.ddId)
															#line 5895 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 584 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_task_outdated(), loopDepth);
															#line 5899 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 589 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Complete)
															#line 5903 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 593 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		ASSERT(ddAuditState.getPhase() == AuditPhase::Running || ddAuditState.getPhase() == AuditPhase::Failed);
															#line 594 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (ddAuditState.getPhase() == AuditPhase::Failed)
															#line 5911 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 595 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1loopBody1Catch1(audit_storage_cancelled(), loopDepth);
															#line 5915 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 597 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_1 = krmSetRange( &tr, auditServerBasedProgressPrefixFor(auditState.getType(), auditState.id, auditState.auditServerId), auditState.range, auditStorageStateValue(auditState));
															#line 597 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 5921 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 2;
															#line 597 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByServerActor, 1, Void >*>(static_cast<PersistAuditStateByServerActor*>(this)));
															#line 5926 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> const& ddAuditState_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(ddAuditState_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Optional<Value> && ddAuditState_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(ddAuditState_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByServerActor*>(this)->ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >*,Optional<Value> const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >*,Optional<Value> && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 602 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 602 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6012 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 3;
															#line 602 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByServerActor, 2, Void >*>(static_cast<PersistAuditStateByServerActor*>(this)));
															#line 6017 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 602 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 602 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6028 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 3;
															#line 602 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PersistAuditStateByServerActor, 2, Void >*>(static_cast<PersistAuditStateByServerActor*>(this)));
															#line 6033 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByServerActor*>(this)->ActorCallback< PersistAuditStateByServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont8(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont8(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByServerActor*>(this)->ActorCallback< PersistAuditStateByServerActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByServerActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state > 0) static_cast<PersistAuditStateByServerActor*>(this)->actor_wait_state = 0;
		static_cast<PersistAuditStateByServerActor*>(this)->ActorCallback< PersistAuditStateByServerActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PersistAuditStateByServerActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PersistAuditStateByServerActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 569 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 569 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditStorageState auditState;
															#line 570 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 6293 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via persistAuditStateByServer()
															#line 569 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class PersistAuditStateByServerActor final : public Actor<Void>, public ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >, public ActorCallback< PersistAuditStateByServerActor, 1, Void >, public ActorCallback< PersistAuditStateByServerActor, 2, Void >, public ActorCallback< PersistAuditStateByServerActor, 3, Void >, public FastAllocated<PersistAuditStateByServerActor>, public PersistAuditStateByServerActorState<PersistAuditStateByServerActor> {
															#line 6298 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<PersistAuditStateByServerActor>::operator new;
	using FastAllocated<PersistAuditStateByServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13331749385300695296UL, 83778243419946752UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >;
friend struct ActorCallback< PersistAuditStateByServerActor, 1, Void >;
friend struct ActorCallback< PersistAuditStateByServerActor, 2, Void >;
friend struct ActorCallback< PersistAuditStateByServerActor, 3, Void >;
															#line 569 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	PersistAuditStateByServerActor(Database const& cx,AuditStorageState const& auditState) 
															#line 6318 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<Void>(),
		   PersistAuditStateByServerActorState<PersistAuditStateByServerActor>(cx, auditState),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16835651359936887296UL, 15337111470123838976UL);
		ActorExecutionContextHelper __helper(static_cast<PersistAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("persistAuditStateByServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("persistAuditStateByServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< PersistAuditStateByServerActor, 0, Optional<Value> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< PersistAuditStateByServerActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< PersistAuditStateByServerActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< PersistAuditStateByServerActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 569 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<Void> persistAuditStateByServer( Database const& cx, AuditStorageState const& auditState ) {
															#line 569 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<Void>(new PersistAuditStateByServerActor(cx, auditState));
															#line 6354 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 617 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 6359 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getAuditStateByServer()
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class GetAuditStateByServerActor>
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStateByServerActorState {
															#line 6366 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStateByServerActorState(Database const& cx,AuditType const& type,UID const& auditId,UID const& auditServerId,KeyRange const& range) 
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   type(type),
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditId(auditId),
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditServerId(auditServerId),
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   range(range),
															#line 623 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditStates(),
															#line 624 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx)
															#line 6385 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getAuditStateByServer", reinterpret_cast<unsigned long>(this));

	}
	~GetAuditStateByServerActorState() 
	{
		fdb_probe_actor_destroy("getAuditStateByServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 626 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 6400 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetAuditStateByServerActorState();
		static_cast<GetAuditStateByServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 652 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		std::vector<AuditStorageState> res;
															#line 653 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < auditStates.size() - 1;++i) {
															#line 654 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			KeyRange currentRange = KeyRangeRef(auditStates[i].key, auditStates[i + 1].key);
															#line 655 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			AuditStorageState auditState(auditId, currentRange, type);
															#line 656 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (!auditStates[i].value.empty())
															#line 6431 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 657 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				AuditStorageState auditState_ = decodeAuditStorageState(auditStates[i].value);
															#line 658 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				auditState.setPhase(auditState_.getPhase());
															#line 659 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				auditState.error = auditState_.error;
															#line 6439 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 661 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			res.push_back(auditState);
															#line 6443 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 664 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<GetAuditStateByServerActor*>(this)->SAV<std::vector<AuditStorageState>>::futures) { (void)(res); this->~GetAuditStateByServerActorState(); static_cast<GetAuditStateByServerActor*>(this)->destroy(); return 0; }
															#line 6447 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<GetAuditStateByServerActor*>(this)->SAV< std::vector<AuditStorageState> >::value()) std::vector<AuditStorageState>(res);
		this->~GetAuditStateByServerActorState();
		static_cast<GetAuditStateByServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 628 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 629 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::READ_SYSTEM_KEYS);
															#line 630 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 631 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = krmGetRanges(&tr, auditServerBasedProgressPrefixFor(type, auditId, auditServerId), range, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT_BYTES);
															#line 631 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6475 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state = 1;
															#line 631 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetAuditStateByServerActor, 0, RangeResult >*>(static_cast<GetAuditStateByServerActor*>(this)));
															#line 6480 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 639 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilGetAuditStateForRangeError") .errorUnsuppressed(e) .detail("AuditID", auditId) .detail("AuditType", type) .detail("AuditServerID", auditServerId);
															#line 644 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 644 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 6519 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state = 2;
															#line 644 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< GetAuditStateByServerActor, 1, Void >*>(static_cast<GetAuditStateByServerActor*>(this)));
															#line 6524 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& res_,int loopDepth) 
	{
															#line 636 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditStates = res_;
															#line 6539 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && res_,int loopDepth) 
	{
															#line 636 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditStates = res_;
															#line 6548 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(res_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && res_,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(res_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStateByServerActor*>(this)->ActorCallback< GetAuditStateByServerActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStateByServerActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetAuditStateByServerActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetAuditStateByServerActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state > 0) static_cast<GetAuditStateByServerActor*>(this)->actor_wait_state = 0;
		static_cast<GetAuditStateByServerActor*>(this)->ActorCallback< GetAuditStateByServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetAuditStateByServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< GetAuditStateByServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< GetAuditStateByServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getAuditStateByServer", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType type;
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditId;
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditServerId;
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange range;
															#line 623 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	RangeResult auditStates;
															#line 624 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 6729 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getAuditStateByServer()
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetAuditStateByServerActor final : public Actor<std::vector<AuditStorageState>>, public ActorCallback< GetAuditStateByServerActor, 0, RangeResult >, public ActorCallback< GetAuditStateByServerActor, 1, Void >, public FastAllocated<GetAuditStateByServerActor>, public GetAuditStateByServerActorState<GetAuditStateByServerActor> {
															#line 6734 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetAuditStateByServerActor>::operator new;
	using FastAllocated<GetAuditStateByServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3067854385215611136UL, 14866837512195382016UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<AuditStorageState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetAuditStateByServerActor, 0, RangeResult >;
friend struct ActorCallback< GetAuditStateByServerActor, 1, Void >;
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetAuditStateByServerActor(Database const& cx,AuditType const& type,UID const& auditId,UID const& auditServerId,KeyRange const& range) 
															#line 6752 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<std::vector<AuditStorageState>>(),
		   GetAuditStateByServerActorState<GetAuditStateByServerActor>(cx, type, auditId, auditServerId, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getAuditStateByServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8717234915021857024UL, 13842049359504508416UL);
		ActorExecutionContextHelper __helper(static_cast<GetAuditStateByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getAuditStateByServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getAuditStateByServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetAuditStateByServerActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< GetAuditStateByServerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<std::vector<AuditStorageState>> getAuditStateByServer( Database const& cx, AuditType const& type, UID const& auditId, UID const& auditServerId, KeyRange const& range ) {
															#line 618 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<std::vector<AuditStorageState>>(new GetAuditStateByServerActor(cx, type, auditId, auditServerId, range));
															#line 6786 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 666 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 6791 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkAuditProgressCompleteByRange()
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class CheckAuditProgressCompleteByRangeActor>
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckAuditProgressCompleteByRangeActorState {
															#line 6798 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckAuditProgressCompleteByRangeActorState(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange) 
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditType(auditType),
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditId(auditId),
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditRange(auditRange)
															#line 6811 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this));

	}
	~CheckAuditProgressCompleteByRangeActorState() 
	{
		fdb_probe_actor_destroy("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 671 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT(auditType == AuditType::ValidateHA || auditType == AuditType::ValidateReplica || auditType == AuditType::ValidateLocationMetadata);
															#line 673 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			rangeToRead = auditRange;
															#line 674 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			rangeToReadBegin = auditRange.begin;
															#line 675 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			retryCount = 0;
															#line 676 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 6834 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckAuditProgressCompleteByRangeActorState();
		static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 711 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilCheckAuditProgressFinish") .detail("AuditID", auditId) .detail("AuditRange", auditRange) .detail("AuditType", auditType);
															#line 715 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckAuditProgressCompleteByRangeActorState(); static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->destroy(); return 0; }
															#line 6859 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckAuditProgressCompleteByRangeActorState();
		static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 676 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!(rangeToReadBegin < auditRange.end))
															#line 6878 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 677 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		;
															#line 6884 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 679 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			rangeToRead = KeyRangeRef(rangeToReadBegin, auditRange.end);
															#line 680 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<std::vector<AuditStorageState>> __when_expr_0 = getAuditStateByRange(cx, auditType, auditId, rangeToRead);
															#line 680 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 6924 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state = 1;
															#line 680 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >*>(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)));
															#line 6929 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 696 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 6964 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 697 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 6968 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 699 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (retryCount > 30)
															#line 6972 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 700 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevWarn, "AuditUtilCheckAuditProgressFailed") .detail("AuditID", auditId) .detail("AuditRange", auditRange) .detail("AuditType", auditType);
															#line 704 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(audit_storage_failed(), std::max(0, loopDepth - 2));
															#line 6978 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 706 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0.5);
															#line 706 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 6984 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state = 2;
															#line 706 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >*>(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)));
															#line 6989 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 682 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < auditStates.size();i++) {
															#line 683 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			AuditPhase phase = auditStates[i].getPhase();
															#line 684 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (phase == AuditPhase::Invalid)
															#line 7008 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 685 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevWarn, "AuditUtilCheckAuditProgressNotFinished") .detail("AuditID", auditId) .detail("AuditRange", auditRange) .detail("AuditType", auditType) .detail("UnfinishedRange", auditStates[i].range);
															#line 690 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (!static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckAuditProgressCompleteByRangeActorState(); static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->destroy(); return 0; }
															#line 7014 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				new (&static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckAuditProgressCompleteByRangeActorState();
				static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 693 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		rangeToReadBegin = auditStates.back().range.end;
															#line 7023 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> const& __auditStates,int loopDepth) 
	{
															#line 680 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditStates = __auditStates;
															#line 7032 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> && __auditStates,int loopDepth) 
	{
		auditStates = std::move(__auditStates);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state > 0) static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 707 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		retryCount++;
															#line 7111 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 707 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		retryCount++;
															#line 7120 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state > 0) static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType auditType;
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditId;
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange auditRange;
															#line 673 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange rangeToRead;
															#line 674 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Key rangeToReadBegin;
															#line 675 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int retryCount;
															#line 680 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::vector<AuditStorageState> auditStates;
															#line 7216 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkAuditProgressCompleteByRange()
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckAuditProgressCompleteByRangeActor final : public Actor<bool>, public ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >, public ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >, public FastAllocated<CheckAuditProgressCompleteByRangeActor>, public CheckAuditProgressCompleteByRangeActorState<CheckAuditProgressCompleteByRangeActor> {
															#line 7221 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckAuditProgressCompleteByRangeActor>::operator new;
	using FastAllocated<CheckAuditProgressCompleteByRangeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16004141969122530048UL, 8142516545126088448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >;
friend struct ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >;
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckAuditProgressCompleteByRangeActor(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange) 
															#line 7239 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   CheckAuditProgressCompleteByRangeActorState<CheckAuditProgressCompleteByRangeActor>(cx, auditType, auditId, auditRange),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3026521694061770240UL, 13785155459301910272UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByRangeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkAuditProgressCompleteByRange");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkAuditProgressCompleteByRange", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckAuditProgressCompleteByRangeActor, 0, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckAuditProgressCompleteByRangeActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<bool> checkAuditProgressCompleteByRange( Database const& cx, AuditType const& auditType, UID const& auditId, KeyRange const& auditRange ) {
															#line 667 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<bool>(new CheckAuditProgressCompleteByRangeActor(cx, auditType, auditId, auditRange));
															#line 7273 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 717 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

															#line 7278 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via checkAuditProgressCompleteByServer()
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class CheckAuditProgressCompleteByServerActor>
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckAuditProgressCompleteByServerActorState {
															#line 7285 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckAuditProgressCompleteByServerActorState(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange,UID const& serverId,std::shared_ptr<AsyncVar<int>> const& checkProgressBudget) 
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditType(auditType),
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditId(auditId),
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditRange(auditRange),
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   serverId(serverId),
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   checkProgressBudget(checkProgressBudget)
															#line 7302 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this));

	}
	~CheckAuditProgressCompleteByServerActorState() 
	{
		fdb_probe_actor_destroy("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 724 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			ASSERT(auditType == AuditType::ValidateStorageServerShard);
															#line 725 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			rangeToRead = auditRange;
															#line 726 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			rangeToReadBegin = auditRange.begin;
															#line 727 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			retryCount = 0;
															#line 728 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 7325 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~CheckAuditProgressCompleteByServerActorState();
		static_cast<CheckAuditProgressCompleteByServerActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 767 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		checkProgressBudget->set(checkProgressBudget->get() + 1);
															#line 768 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilCheckAuditProgressFinish") .detail("ServerID", serverId) .detail("AuditID", auditId) .detail("AuditRange", auditRange) .detail("AuditType", auditType);
															#line 773 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<CheckAuditProgressCompleteByServerActor*>(this)->SAV<bool>::futures) { (void)(true); this->~CheckAuditProgressCompleteByServerActorState(); static_cast<CheckAuditProgressCompleteByServerActor*>(this)->destroy(); return 0; }
															#line 7352 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<CheckAuditProgressCompleteByServerActor*>(this)->SAV< bool >::value()) bool(true);
		this->~CheckAuditProgressCompleteByServerActorState();
		static_cast<CheckAuditProgressCompleteByServerActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 728 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!(rangeToReadBegin < auditRange.end))
															#line 7371 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 729 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		;
															#line 7377 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 731 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			rangeToRead = KeyRangeRef(rangeToReadBegin, auditRange.end);
															#line 732 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<std::vector<AuditStorageState>> __when_expr_0 = getAuditStateByServer(cx, auditType, auditId, serverId, rangeToRead);
															#line 732 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7417 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state = 1;
															#line 732 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >*>(static_cast<CheckAuditProgressCompleteByServerActor*>(this)));
															#line 7422 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 750 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (e.code() == error_code_actor_cancelled)
															#line 7457 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 751 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 2));
															#line 7461 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 753 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (retryCount > 30)
															#line 7465 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 754 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevWarn, "AuditUtilCheckAuditProgressFailed") .detail("ServerID", serverId) .detail("AuditID", auditId) .detail("AuditRange", auditRange) .detail("AuditType", auditType);
															#line 759 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				checkProgressBudget->set(checkProgressBudget->get() + 1);
															#line 760 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(audit_storage_failed(), std::max(0, loopDepth - 2));
															#line 7473 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 762 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_1 = delay(0.5);
															#line 762 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 7479 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state = 2;
															#line 762 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >*>(static_cast<CheckAuditProgressCompleteByServerActor*>(this)));
															#line 7484 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(int loopDepth) 
	{
															#line 734 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < auditStates.size();i++) {
															#line 735 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			AuditPhase phase = auditStates[i].getPhase();
															#line 736 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (phase == AuditPhase::Invalid)
															#line 7503 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 737 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevWarn, "AuditUtilCheckAuditProgressNotFinished") .detail("ServerID", serverId) .detail("AuditID", auditId) .detail("AuditRange", auditRange) .detail("AuditType", auditType) .detail("UnfinishedRange", auditStates[i].range);
															#line 743 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				checkProgressBudget->set(checkProgressBudget->get() + 1);
															#line 744 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (!static_cast<CheckAuditProgressCompleteByServerActor*>(this)->SAV<bool>::futures) { (void)(false); this->~CheckAuditProgressCompleteByServerActorState(); static_cast<CheckAuditProgressCompleteByServerActor*>(this)->destroy(); return 0; }
															#line 7511 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				new (&static_cast<CheckAuditProgressCompleteByServerActor*>(this)->SAV< bool >::value()) bool(false);
				this->~CheckAuditProgressCompleteByServerActorState();
				static_cast<CheckAuditProgressCompleteByServerActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
		}
															#line 747 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		rangeToReadBegin = auditStates.back().range.end;
															#line 7520 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> const& __auditStates,int loopDepth) 
	{
															#line 732 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		auditStates = __auditStates;
															#line 7529 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(std::vector<AuditStorageState> && __auditStates,int loopDepth) 
	{
		auditStates = std::move(__auditStates);
		loopDepth = a_body1loopBody1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state > 0) static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAuditProgressCompleteByServerActor*>(this)->ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> const& value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >*,std::vector<AuditStorageState> && value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >*,Error err) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 763 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		retryCount++;
															#line 7608 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 763 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		retryCount++;
															#line 7617 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state > 0) static_cast<CheckAuditProgressCompleteByServerActor*>(this)->actor_wait_state = 0;
		static_cast<CheckAuditProgressCompleteByServerActor*>(this)->ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditType auditType;
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditId;
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange auditRange;
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID serverId;
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::shared_ptr<AsyncVar<int>> checkProgressBudget;
															#line 725 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange rangeToRead;
															#line 726 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Key rangeToReadBegin;
															#line 727 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int retryCount;
															#line 732 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::vector<AuditStorageState> auditStates;
															#line 7717 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via checkAuditProgressCompleteByServer()
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class CheckAuditProgressCompleteByServerActor final : public Actor<bool>, public ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >, public ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >, public FastAllocated<CheckAuditProgressCompleteByServerActor>, public CheckAuditProgressCompleteByServerActorState<CheckAuditProgressCompleteByServerActor> {
															#line 7722 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<CheckAuditProgressCompleteByServerActor>::operator new;
	using FastAllocated<CheckAuditProgressCompleteByServerActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3016349524485326336UL, 11326784910327689728UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >;
friend struct ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >;
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	CheckAuditProgressCompleteByServerActor(Database const& cx,AuditType const& auditType,UID const& auditId,KeyRange const& auditRange,UID const& serverId,std::shared_ptr<AsyncVar<int>> const& checkProgressBudget) 
															#line 7740 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<bool>(),
		   CheckAuditProgressCompleteByServerActorState<CheckAuditProgressCompleteByServerActor>(cx, auditType, auditId, auditRange, serverId, checkProgressBudget),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(14129580192873401344UL, 6628265393131345664UL);
		ActorExecutionContextHelper __helper(static_cast<CheckAuditProgressCompleteByServerActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("checkAuditProgressCompleteByServer");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("checkAuditProgressCompleteByServer", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< CheckAuditProgressCompleteByServerActor, 0, std::vector<AuditStorageState> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< CheckAuditProgressCompleteByServerActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<bool> checkAuditProgressCompleteByServer( Database const& cx, AuditType const& auditType, UID const& auditId, KeyRange const& auditRange, UID const& serverId, std::shared_ptr<AsyncVar<int>> const& checkProgressBudget ) {
															#line 718 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<bool>(new CheckAuditProgressCompleteByServerActor(cx, auditType, auditId, auditRange, serverId, checkProgressBudget));
															#line 7774 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 775 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

// Load RUNNING audit states to resume, clean up COMPLETE and FAILED audit states
// Update ddId for RUNNING audit states
															#line 7781 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via initAuditMetadata()
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class InitAuditMetadataActor>
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class InitAuditMetadataActorState {
															#line 7788 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	InitAuditMetadataActorState(Database const& cx,MoveKeyLockInfo const& lock,bool const& ddEnabled,UID const& dataDistributorId,int const& persistFinishAuditCount) 
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : cx(cx),
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   lock(lock),
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   ddEnabled(ddEnabled),
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   dataDistributorId(dataDistributorId),
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   persistFinishAuditCount(persistFinishAuditCount),
															#line 783 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   existingAuditStates(),
															#line 784 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   auditStatesToResume(),
															#line 785 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(cx),
															#line 786 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   retryCount(0)
															#line 7811 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("initAuditMetadata", reinterpret_cast<unsigned long>(this));

	}
	~InitAuditMetadataActorState() 
	{
		fdb_probe_actor_destroy("initAuditMetadata", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 787 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			;
															#line 7826 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InitAuditMetadataActorState();
		static_cast<InitAuditMetadataActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 886 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<InitAuditMetadataActor*>(this)->SAV<std::vector<AuditStorageState>>::futures) { (void)(auditStatesToResume); this->~InitAuditMetadataActorState(); static_cast<InitAuditMetadataActor*>(this)->destroy(); return 0; }
															#line 7849 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<InitAuditMetadataActor*>(this)->SAV< std::vector<AuditStorageState> >::value()) std::vector<AuditStorageState>(std::move(auditStatesToResume)); // state_var_RVO
		this->~InitAuditMetadataActorState();
		static_cast<InitAuditMetadataActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 790 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			existingAuditStates.clear();
															#line 791 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auditStatesToResume.clear();
															#line 792 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 793 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 794 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 795 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			StrictFuture<Void> __when_expr_0 = checkMoveKeysLockForAudit(&tr, lock, ddEnabled, true);
															#line 795 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7881 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 1;
															#line 795 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InitAuditMetadataActor, 0, Void >*>(static_cast<InitAuditMetadataActor*>(this)));
															#line 7886 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 870 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (e.code() == error_code_actor_cancelled || e.code() == error_code_movekeys_conflict)
															#line 7921 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 871 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				return a_body1Catch1(e, std::max(0, loopDepth - 1));
															#line 7925 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 873 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (retryCount > 50)
															#line 7929 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 874 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				TraceEvent(SevWarnAlways, "AuditUtilInitAuditMetadataExceedRetryMax", dataDistributorId) .errorUnsuppressed(e);
															#line 7933 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				return a_body1break1(loopDepth==0?0:loopDepth-1); // break
			}
			try {
															#line 879 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				StrictFuture<Void> __when_expr_3 = tr.onError(e);
															#line 879 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1Catch1(actor_cancelled(), loopDepth);
															#line 7941 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1loopBody1Catch1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1loopBody1Catch1when1(__when_expr_3.get(), loopDepth); };
				static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 4;
															#line 879 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< InitAuditMetadataActor, 3, Void >*>(static_cast<InitAuditMetadataActor*>(this)));
															#line 7946 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1loopBody1Catch1Catch1(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1loopBody1Catch1Catch1(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 796 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(auditKeys, CLIENT_KNOBS->TOO_MANY);
															#line 796 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7969 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 2;
															#line 796 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitAuditMetadataActor, 1, RangeResult >*>(static_cast<InitAuditMetadataActor*>(this)));
															#line 7974 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 796 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<RangeResult> __when_expr_1 = tr.getRange(auditKeys, CLIENT_KNOBS->TOO_MANY);
															#line 796 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 7985 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 2;
															#line 796 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< InitAuditMetadataActor, 1, RangeResult >*>(static_cast<InitAuditMetadataActor*>(this)));
															#line 7990 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state > 0) static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<InitAuditMetadataActor*>(this)->ActorCallback< InitAuditMetadataActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InitAuditMetadataActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(RangeResult const& result,int loopDepth) 
	{
															#line 797 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (result.more || result.size() >= CLIENT_KNOBS->TOO_MANY)
															#line 8074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 798 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "AuditUtilLoadMetadataIncomplete", dataDistributorId) .detail("ResMore", result.more) .detail("ResSize", result.size());
															#line 8078 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 804 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < result.size();++i) {
															#line 805 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auto auditState = decodeAuditStorageState(result[i].value);
															#line 806 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevVerbose, "AuditUtilLoadMetadataEach", dataDistributorId) .detail("CurrentDDID", dataDistributorId) .detail("AuditDDID", auditState.ddId) .detail("AuditType", auditState.getType()) .detail("AuditID", auditState.id) .detail("AuditPhase", auditState.getPhase());
															#line 812 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditState.getPhase() == AuditPhase::Running)
															#line 8088 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 813 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				AuditStorageState toUpdate = auditState;
															#line 814 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				toUpdate.ddId = dataDistributorId;
															#line 815 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				tr.set(auditKey(toUpdate.getType(), toUpdate.id), auditStorageStateValue(toUpdate));
															#line 8096 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 817 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			existingAuditStates[auditState.getType()].push_back(auditState);
															#line 8100 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 820 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for( const auto& [auditType, _] : existingAuditStates ) {
															#line 821 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			int numFinishAudit = 0;
															#line 822 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			for( const auto& auditState : existingAuditStates[auditType] ) {
															#line 823 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Complete || auditState.getPhase() == AuditPhase::Failed)
															#line 8110 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 824 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					numFinishAudit++;
															#line 8114 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				}
			}
															#line 827 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			const int numFinishAuditsToClear = numFinishAudit - persistFinishAuditCount;
															#line 828 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			int numFinishAuditsCleared = 0;
															#line 829 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::sort(existingAuditStates[auditType].begin(), existingAuditStates[auditType].end(), [](AuditStorageState a, AuditStorageState b) { return a.id < b.id; });
															#line 834 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			for( const auto& auditState : existingAuditStates[auditType] ) {
															#line 835 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Failed)
															#line 8127 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 836 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					if (numFinishAuditsCleared < numFinishAuditsToClear)
															#line 8131 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					{
															#line 838 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						tr.clear(auditKey(auditState.getType(), auditState.id));
															#line 839 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						clearAuditProgressMetadata(&tr, auditState.getType(), auditState.id);
															#line 840 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						numFinishAuditsCleared++;
															#line 841 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						TraceEvent(SevInfo, "AuditUtilMetadataCleared", dataDistributorId) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditRange", auditState.range);
															#line 8141 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 846 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					if (auditState.getPhase() == AuditPhase::Complete)
															#line 8148 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					{
															#line 847 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						if (numFinishAuditsCleared < numFinishAuditsToClear)
															#line 8152 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						{
															#line 851 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							tr.clear(auditKey(auditState.getType(), auditState.id));
															#line 852 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							numFinishAuditsCleared++;
															#line 853 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							TraceEvent(SevInfo, "AuditUtilMetadataCleared", dataDistributorId) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditRange", auditState.range);
															#line 8160 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						}
					}
					else
					{
															#line 858 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						if (auditState.getPhase() == AuditPhase::Running)
															#line 8167 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						{
															#line 859 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							auditStatesToResume.push_back(auditState);
															#line 860 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							TraceEvent(SevInfo, "AuditUtilMetadataAddedToResume", dataDistributorId) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditRange", auditState.range);
															#line 8173 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						}
					}
				}
			}
		}
															#line 867 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 867 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8183 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 3;
															#line 867 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< InitAuditMetadataActor, 2, Void >*>(static_cast<InitAuditMetadataActor*>(this)));
															#line 8188 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont3(RangeResult && result,int loopDepth) 
	{
															#line 797 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (result.more || result.size() >= CLIENT_KNOBS->TOO_MANY)
															#line 8197 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 798 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "AuditUtilLoadMetadataIncomplete", dataDistributorId) .detail("ResMore", result.more) .detail("ResSize", result.size());
															#line 8201 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 804 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < result.size();++i) {
															#line 805 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			auto auditState = decodeAuditStorageState(result[i].value);
															#line 806 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevVerbose, "AuditUtilLoadMetadataEach", dataDistributorId) .detail("CurrentDDID", dataDistributorId) .detail("AuditDDID", auditState.ddId) .detail("AuditType", auditState.getType()) .detail("AuditID", auditState.id) .detail("AuditPhase", auditState.getPhase());
															#line 812 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (auditState.getPhase() == AuditPhase::Running)
															#line 8211 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 813 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				AuditStorageState toUpdate = auditState;
															#line 814 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				toUpdate.ddId = dataDistributorId;
															#line 815 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				tr.set(auditKey(toUpdate.getType(), toUpdate.id), auditStorageStateValue(toUpdate));
															#line 8219 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 817 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			existingAuditStates[auditState.getType()].push_back(auditState);
															#line 8223 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 820 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for( const auto& [auditType, _] : existingAuditStates ) {
															#line 821 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			int numFinishAudit = 0;
															#line 822 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			for( const auto& auditState : existingAuditStates[auditType] ) {
															#line 823 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Complete || auditState.getPhase() == AuditPhase::Failed)
															#line 8233 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 824 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					numFinishAudit++;
															#line 8237 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				}
			}
															#line 827 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			const int numFinishAuditsToClear = numFinishAudit - persistFinishAuditCount;
															#line 828 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			int numFinishAuditsCleared = 0;
															#line 829 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::sort(existingAuditStates[auditType].begin(), existingAuditStates[auditType].end(), [](AuditStorageState a, AuditStorageState b) { return a.id < b.id; });
															#line 834 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			for( const auto& auditState : existingAuditStates[auditType] ) {
															#line 835 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (auditState.getPhase() == AuditPhase::Failed)
															#line 8250 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				{
															#line 836 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					if (numFinishAuditsCleared < numFinishAuditsToClear)
															#line 8254 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					{
															#line 838 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						tr.clear(auditKey(auditState.getType(), auditState.id));
															#line 839 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						clearAuditProgressMetadata(&tr, auditState.getType(), auditState.id);
															#line 840 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						numFinishAuditsCleared++;
															#line 841 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						TraceEvent(SevInfo, "AuditUtilMetadataCleared", dataDistributorId) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditRange", auditState.range);
															#line 8264 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					}
				}
				else
				{
															#line 846 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
					if (auditState.getPhase() == AuditPhase::Complete)
															#line 8271 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
					{
															#line 847 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						if (numFinishAuditsCleared < numFinishAuditsToClear)
															#line 8275 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						{
															#line 851 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							tr.clear(auditKey(auditState.getType(), auditState.id));
															#line 852 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							numFinishAuditsCleared++;
															#line 853 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							TraceEvent(SevInfo, "AuditUtilMetadataCleared", dataDistributorId) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditRange", auditState.range);
															#line 8283 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						}
					}
					else
					{
															#line 858 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
						if (auditState.getPhase() == AuditPhase::Running)
															#line 8290 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						{
															#line 859 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							auditStatesToResume.push_back(auditState);
															#line 860 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
							TraceEvent(SevInfo, "AuditUtilMetadataAddedToResume", dataDistributorId) .detail("AuditID", auditState.id) .detail("AuditType", auditState.getType()) .detail("AuditRange", auditState.range);
															#line 8296 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
						}
					}
				}
			}
		}
															#line 867 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		StrictFuture<Void> __when_expr_2 = tr.commit();
															#line 867 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 8306 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1loopBody1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1loopBody1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 3;
															#line 867 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< InitAuditMetadataActor, 2, Void >*>(static_cast<InitAuditMetadataActor*>(this)));
															#line 8311 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult const& result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(result, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(RangeResult && result,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(result), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state > 0) static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<InitAuditMetadataActor*>(this)->ActorCallback< InitAuditMetadataActor, 1, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 1, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 1, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< InitAuditMetadataActor, 1, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1cont4(Void const& _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont4(Void && _,int loopDepth) 
	{
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state > 0) static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<InitAuditMetadataActor*>(this)->ActorCallback< InitAuditMetadataActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< InitAuditMetadataActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1loopBody1Catch1cont1(int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 881 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			retryCount++;
															#line 882 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			tr.reset();
															#line 8491 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<InitAuditMetadataActor*>(this)->actor_wait_state > 0) static_cast<InitAuditMetadataActor*>(this)->actor_wait_state = 0;
		static_cast<InitAuditMetadataActor*>(this)->ActorCallback< InitAuditMetadataActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< InitAuditMetadataActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< InitAuditMetadataActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1loopBody1Catch1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1loopBody1Catch1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1loopBody1Catch1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Database cx;
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	MoveKeyLockInfo lock;
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	bool ddEnabled;
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID dataDistributorId;
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int persistFinishAuditCount;
															#line 783 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::unordered_map<AuditType, std::vector<AuditStorageState>> existingAuditStates;
															#line 784 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::vector<AuditStorageState> auditStatesToResume;
															#line 785 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction tr;
															#line 786 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int retryCount;
															#line 8620 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via initAuditMetadata()
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class InitAuditMetadataActor final : public Actor<std::vector<AuditStorageState>>, public ActorCallback< InitAuditMetadataActor, 0, Void >, public ActorCallback< InitAuditMetadataActor, 1, RangeResult >, public ActorCallback< InitAuditMetadataActor, 2, Void >, public ActorCallback< InitAuditMetadataActor, 3, Void >, public FastAllocated<InitAuditMetadataActor>, public InitAuditMetadataActorState<InitAuditMetadataActor> {
															#line 8625 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<InitAuditMetadataActor>::operator new;
	using FastAllocated<InitAuditMetadataActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(17270968180146843136UL, 16770297123581546496UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<std::vector<AuditStorageState>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InitAuditMetadataActor, 0, Void >;
friend struct ActorCallback< InitAuditMetadataActor, 1, RangeResult >;
friend struct ActorCallback< InitAuditMetadataActor, 2, Void >;
friend struct ActorCallback< InitAuditMetadataActor, 3, Void >;
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	InitAuditMetadataActor(Database const& cx,MoveKeyLockInfo const& lock,bool const& ddEnabled,UID const& dataDistributorId,int const& persistFinishAuditCount) 
															#line 8645 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<std::vector<AuditStorageState>>(),
		   InitAuditMetadataActorState<InitAuditMetadataActor>(cx, lock, ddEnabled, dataDistributorId, persistFinishAuditCount),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("initAuditMetadata", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5137575058642904320UL, 475804656007697920UL);
		ActorExecutionContextHelper __helper(static_cast<InitAuditMetadataActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("initAuditMetadata");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("initAuditMetadata", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InitAuditMetadataActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< InitAuditMetadataActor, 1, RangeResult >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< InitAuditMetadataActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< InitAuditMetadataActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<std::vector<AuditStorageState>> initAuditMetadata( Database const& cx, MoveKeyLockInfo const& lock, bool const& ddEnabled, UID const& dataDistributorId, int const& persistFinishAuditCount ) {
															#line 778 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<std::vector<AuditStorageState>>(new InitAuditMetadataActor(cx, lock, ddEnabled, dataDistributorId, persistFinishAuditCount));
															#line 8681 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 888 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

// Check if any pair of ranges are exclusive with each other
// This is not a part in consistency check of audit metadata
// This is used for checking the validity of inputs to rangesSame()
bool elementsAreExclusiveWithEachOther(std::vector<KeyRange> ranges) {
	ASSERT(std::is_sorted(ranges.begin(), ranges.end(), KeyRangeRef::ArbitraryOrder()));
	for (int i = 0; i < ranges.size() - 1; ++i) {
		if (ranges[i].end > ranges[i + 1].begin) {
			TraceEvent(SevError, "AuditUtilElementsAreNotExclusiveWithEachOther").detail("Ranges", describe(ranges));
			return false;
		}
	}
	return true;
}

// Check if any range is empty in the given list of ranges
// This is not a part in consistency check of audit metadata
// This is used for checking the validity of inputs to rangesSame()
bool noEmptyRangeInRanges(std::vector<KeyRange> ranges) {
	for (const auto& range : ranges) {
		if (range.empty()) {
			return false;
		}
	}
	return true;
}

// Given a list of ranges, where ranges can overlap with each other
// Return a list of exclusive ranges which covers the ranges exactly
// the same as the input list of ranges
std::vector<KeyRange> coalesceRangeList(std::vector<KeyRange> ranges) {
	std::sort(ranges.begin(), ranges.end(), [](KeyRange a, KeyRange b) { return a.begin < b.begin; });
	std::vector<KeyRange> res;
	for (const auto& range : ranges) {
		if (res.empty()) {
			res.push_back(range);
			continue;
		}
		if (range.begin <= res.back().end) {
			if (range.end > res.back().end) { // update res.back if current range extends the back range
				KeyRange newBack = Standalone(KeyRangeRef(res.back().begin, range.end));
				res.pop_back();
				res.push_back(newBack);
			}
		} else {
			res.push_back(range);
		}
	}
	return res;
}

// Given two lists of ranges --- rangesA and rangesB, check if two lists are identical
// If not, return the mismatched two ranges of rangeA and rangeB respectively
Optional<std::pair<KeyRange, KeyRange>> rangesSame(std::vector<KeyRange> rangesA, std::vector<KeyRange> rangesB) {
	if (g_network->isSimulated()) {
		ASSERT(noEmptyRangeInRanges(rangesA));
		ASSERT(noEmptyRangeInRanges(rangesB));
	}
	KeyRange emptyRange;
	if (rangesA.empty() && rangesB.empty()) { // no mismatch
		return Optional<std::pair<KeyRange, KeyRange>>();
	} else if (rangesA.empty() && !rangesB.empty()) { // rangesA is empty while rangesB has a range
		return std::make_pair(emptyRange, rangesB.front());
	} else if (!rangesA.empty() && rangesB.empty()) { // rangesB is empty while rangesA has a range
		return std::make_pair(rangesA.front(), emptyRange);
	}
	TraceEvent(SevVerbose, "AuditUtilRangesSameBeforeSort").detail("RangesA", rangesA).detail("Rangesb", rangesB);
	// sort in ascending order
	std::sort(rangesA.begin(), rangesA.end(), [](KeyRange a, KeyRange b) { return a.begin < b.begin; });
	std::sort(rangesB.begin(), rangesB.end(), [](KeyRange a, KeyRange b) { return a.begin < b.begin; });
	TraceEvent(SevVerbose, "AuditUtilRangesSameAfterSort").detail("RangesA", rangesA).detail("Rangesb", rangesB);
	if (g_network->isSimulated()) {
		ASSERT(elementsAreExclusiveWithEachOther(rangesA));
		ASSERT(elementsAreExclusiveWithEachOther(rangesB));
	}
	if (rangesA.front().begin != rangesB.front().begin) { // rangeList heads mismatch
		return std::make_pair(rangesA.front(), rangesB.front());
	} else if (rangesA.back().end != rangesB.back().end) { // rangeList backs mismatch
		return std::make_pair(rangesA.back(), rangesB.back());
	}
	int ia = 0;
	int ib = 0;
	KeyRangeRef rangeA = rangesA[0];
	KeyRangeRef rangeB = rangesB[0];
	KeyRange lastRangeA = Standalone(rangeA);
	KeyRange lastRangeB = Standalone(rangeB);
	while (true) {
		if (rangeA.begin == rangeB.begin) {
			if (rangeA.end == rangeB.end) {
				if (rangeA.end == rangesA.back().end) {
					break;
				}
				++ia;
				++ib;
				rangeA = rangesA[ia];
				rangeB = rangesB[ib];
				lastRangeA = Standalone(rangeA);
				lastRangeB = Standalone(rangeB);
			} else if (rangeA.end > rangeB.end) {
				rangeA = KeyRangeRef(rangeB.end, rangeA.end);
				++ib;
				rangeB = rangesB[ib];
				lastRangeB = Standalone(rangeB);
			} else {
				rangeB = KeyRangeRef(rangeA.end, rangeB.end);
				++ia;
				rangeA = rangesA[ia];
				lastRangeA = Standalone(rangeA);
			}
		} else {
			return std::make_pair(lastRangeA, lastRangeB);
		}
	}
	return Optional<std::pair<KeyRange, KeyRange>>();
}

// Given an input server, get ranges within the input range via the input transaction
// from the perspective of ServerKeys system key space
// Input: (1) SS id; (2) transaction tr; (3) within range
// Return AuditGetServerKeysRes, including: (1) complete range by a single read range;
// (2) version of the read; (3) ranges of the input SS
															#line 8806 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getThisServerKeysFromServerKeys()
															#line 1009 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class GetThisServerKeysFromServerKeysActor>
															#line 1009 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetThisServerKeysFromServerKeysActorState {
															#line 8813 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 1009 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetThisServerKeysFromServerKeysActorState(UID const& serverID,Transaction* const& tr,KeyRange const& range) 
															#line 1009 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 1009 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : serverID(serverID),
															#line 1009 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(tr),
															#line 1009 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   range(range),
															#line 1010 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   readResult(),
															#line 1011 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   res()
															#line 8828 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this));

	}
	~GetThisServerKeysFromServerKeysActorState() 
	{
		fdb_probe_actor_destroy("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1014 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				StrictFuture<Void> __when_expr_0 = store(readResult, krmGetRanges(tr, serverKeysPrefixFor(serverID), range, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT_BYTES));
															#line 1014 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (static_cast<GetThisServerKeysFromServerKeysActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 8846 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetThisServerKeysFromServerKeysActor*>(this)->actor_wait_state = 1;
															#line 1014 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >*>(static_cast<GetThisServerKeysFromServerKeysActor*>(this)));
															#line 8851 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetThisServerKeysFromServerKeysActorState();
		static_cast<GetThisServerKeysFromServerKeysActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1062 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<GetThisServerKeysFromServerKeysActor*>(this)->SAV<AuditGetServerKeysRes>::futures) { (void)(res); this->~GetThisServerKeysFromServerKeysActorState(); static_cast<GetThisServerKeysFromServerKeysActor*>(this)->destroy(); return 0; }
															#line 8880 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<GetThisServerKeysFromServerKeysActor*>(this)->SAV< AuditGetServerKeysRes >::value()) AuditGetServerKeysRes(std::move(res)); // state_var_RVO
		this->~GetThisServerKeysFromServerKeysActorState();
		static_cast<GetThisServerKeysFromServerKeysActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1056 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilGetThisServerKeysError", serverID) .errorUnsuppressed(e) .detail("AuditServerID", serverID);
															#line 1059 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 8895 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1020 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Future<Version> grvF = tr->getReadVersion();
															#line 1021 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!grvF.isReady())
															#line 8911 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 1022 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevWarnAlways, "AuditUtilReadServerKeysGRVError", serverID);
															#line 1023 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch2(audit_storage_cancelled(), loopDepth);
															#line 8917 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 1025 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Version readAtVersion = grvF.get();
															#line 1027 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromServerKeysReadDone", serverID) .detail("Range", range) .detail("Prefix", serverKeysPrefixFor(serverID)) .detail("ResultSize", readResult.size()) .detail("AuditServerID", serverID);
															#line 1033 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		std::vector<KeyRange> ownRanges;
															#line 1034 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;++i) {
															#line 1035 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromServerKeysAddToResult", serverID) .detail("ValueIsServerKeysFalse", readResult[i].value == serverKeysFalse) .detail("ServerHasKey", serverHasKey(readResult[i].value)) .detail("Range", KeyRangeRef(readResult[i].key, readResult[i + 1].key)) .detail("AuditServerID", serverID);
															#line 1040 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (serverHasKey(readResult[i].value))
															#line 8931 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 1041 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				KeyRange shardRange;
															#line 1042 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				ownRanges.push_back(Standalone(KeyRangeRef(readResult[i].key, readResult[i + 1].key)));
															#line 8937 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
															#line 1045 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		const KeyRange completeRange = Standalone(KeyRangeRef(range.begin, readResult.back().key));
															#line 1046 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromServerKeysEnd", serverID) .detail("AuditServerID", serverID) .detail("Range", range) .detail("Prefix", serverKeysPrefixFor(serverID)) .detail("ReadAtVersion", readAtVersion) .detail("CompleteRange", completeRange) .detail("ResultSize", ownRanges.size());
															#line 1053 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		res = AuditGetServerKeysRes(completeRange, readAtVersion, serverID, ownRanges, readResult.logicalSize());
															#line 8946 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1020 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Future<Version> grvF = tr->getReadVersion();
															#line 1021 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!grvF.isReady())
															#line 8957 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 1022 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevWarnAlways, "AuditUtilReadServerKeysGRVError", serverID);
															#line 1023 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch2(audit_storage_cancelled(), loopDepth);
															#line 8963 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 1025 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Version readAtVersion = grvF.get();
															#line 1027 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromServerKeysReadDone", serverID) .detail("Range", range) .detail("Prefix", serverKeysPrefixFor(serverID)) .detail("ResultSize", readResult.size()) .detail("AuditServerID", serverID);
															#line 1033 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		std::vector<KeyRange> ownRanges;
															#line 1034 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;++i) {
															#line 1035 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromServerKeysAddToResult", serverID) .detail("ValueIsServerKeysFalse", readResult[i].value == serverKeysFalse) .detail("ServerHasKey", serverHasKey(readResult[i].value)) .detail("Range", KeyRangeRef(readResult[i].key, readResult[i + 1].key)) .detail("AuditServerID", serverID);
															#line 1040 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (serverHasKey(readResult[i].value))
															#line 8977 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 1041 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				KeyRange shardRange;
															#line 1042 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				ownRanges.push_back(Standalone(KeyRangeRef(readResult[i].key, readResult[i + 1].key)));
															#line 8983 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
															#line 1045 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		const KeyRange completeRange = Standalone(KeyRangeRef(range.begin, readResult.back().key));
															#line 1046 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromServerKeysEnd", serverID) .detail("AuditServerID", serverID) .detail("Range", range) .detail("Prefix", serverKeysPrefixFor(serverID)) .detail("ReadAtVersion", readAtVersion) .detail("CompleteRange", completeRange) .detail("ResultSize", ownRanges.size());
															#line 1053 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		res = AuditGetServerKeysRes(completeRange, readAtVersion, serverID, ownRanges, readResult.logicalSize());
															#line 8992 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetThisServerKeysFromServerKeysActor*>(this)->actor_wait_state > 0) static_cast<GetThisServerKeysFromServerKeysActor*>(this)->actor_wait_state = 0;
		static_cast<GetThisServerKeysFromServerKeysActor*>(this)->ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetThisServerKeysFromServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetThisServerKeysFromServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetThisServerKeysFromServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont7(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1009 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID serverID;
															#line 1009 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction* tr;
															#line 1009 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange range;
															#line 1010 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	RangeResult readResult;
															#line 1011 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditGetServerKeysRes res;
															#line 9095 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getThisServerKeysFromServerKeys()
															#line 1009 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetThisServerKeysFromServerKeysActor final : public Actor<AuditGetServerKeysRes>, public ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >, public FastAllocated<GetThisServerKeysFromServerKeysActor>, public GetThisServerKeysFromServerKeysActorState<GetThisServerKeysFromServerKeysActor> {
															#line 9100 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetThisServerKeysFromServerKeysActor>::operator new;
	using FastAllocated<GetThisServerKeysFromServerKeysActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16506312436252175360UL, 5587933648484999680UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<AuditGetServerKeysRes>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >;
															#line 1009 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetThisServerKeysFromServerKeysActor(UID const& serverID,Transaction* const& tr,KeyRange const& range) 
															#line 9117 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<AuditGetServerKeysRes>(),
		   GetThisServerKeysFromServerKeysActorState<GetThisServerKeysFromServerKeysActor>(serverID, tr, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8956952993459453952UL, 3712613669581083392UL);
		ActorExecutionContextHelper __helper(static_cast<GetThisServerKeysFromServerKeysActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getThisServerKeysFromServerKeys");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getThisServerKeysFromServerKeys", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetThisServerKeysFromServerKeysActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1009 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<AuditGetServerKeysRes> getThisServerKeysFromServerKeys( UID const& serverID, Transaction* const& tr, KeyRange const& range ) {
															#line 1009 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<AuditGetServerKeysRes>(new GetThisServerKeysFromServerKeysActor(serverID, tr, range));
															#line 9150 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 1064 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"

// Given an input server, get ranges within the input range via the input transaction
// from the perspective of KeyServers system key space
// Input: (1) Audit Server ID (for logging); (2) transaction tr; (3) within range
// Return AuditGetKeyServersRes, including : (1) complete range by a single read range; (2) version of the read;
// (3) map between SSes and their ranges --- in KeyServers space, a range corresponds to multiple SSes
															#line 9160 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
namespace {
// This generated class is to be used only via getShardMapFromKeyServers()
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
template <class GetShardMapFromKeyServersActor>
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetShardMapFromKeyServersActorState {
															#line 9167 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetShardMapFromKeyServersActorState(UID const& auditServerId,Transaction* const& tr,KeyRange const& range) 
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		 : auditServerId(auditServerId),
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   tr(tr),
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   range(range),
															#line 1071 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   res(),
															#line 1072 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   actors(),
															#line 1073 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   readResult(),
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   UIDtoTagMap(),
															#line 1075 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   totalShardsCount(0),
															#line 1076 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		   shardsInAnonymousPhysicalShardCount(0)
															#line 9190 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
	{
		fdb_probe_actor_create("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this));

	}
	~GetShardMapFromKeyServersActorState() 
	{
		fdb_probe_actor_destroy("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1080 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				actors.push_back(store(readResult, krmGetRanges(tr, keyServersPrefix, range, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT, CLIENT_KNOBS->KRM_GET_RANGE_LIMIT_BYTES)));
															#line 1086 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				actors.push_back(store(UIDtoTagMap, tr->getRange(serverTagKeys, CLIENT_KNOBS->TOO_MANY)));
															#line 1087 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(actors);
															#line 1087 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				if (static_cast<GetShardMapFromKeyServersActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 9212 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<GetShardMapFromKeyServersActor*>(this)->actor_wait_state = 1;
															#line 1087 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< GetShardMapFromKeyServersActor, 0, Void >*>(static_cast<GetShardMapFromKeyServersActor*>(this)));
															#line 9217 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~GetShardMapFromKeyServersActorState();
		static_cast<GetShardMapFromKeyServersActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1140 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!static_cast<GetShardMapFromKeyServersActor*>(this)->SAV<AuditGetKeyServersRes>::futures) { (void)(res); this->~GetShardMapFromKeyServersActorState(); static_cast<GetShardMapFromKeyServersActor*>(this)->destroy(); return 0; }
															#line 9246 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		new (&static_cast<GetShardMapFromKeyServersActor*>(this)->SAV< AuditGetKeyServersRes >::value()) AuditGetKeyServersRes(std::move(res)); // state_var_RVO
		this->~GetShardMapFromKeyServersActorState();
		static_cast<GetShardMapFromKeyServersActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1134 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevDebug, "AuditUtilGetThisServerKeysFromKeyServersError", auditServerId) .errorUnsuppressed(e) .detail("AuditServerId", auditServerId);
															#line 1137 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 9261 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1088 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (UIDtoTagMap.more || UIDtoTagMap.size() >= CLIENT_KNOBS->TOO_MANY)
															#line 9275 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 1089 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "AuditUtilReadKeyServersReadTagError", auditServerId);
															#line 1092 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch2(audit_storage_cancelled(), loopDepth);
															#line 9281 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 1094 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Future<Version> grvF = tr->getReadVersion();
															#line 1095 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!grvF.isReady())
															#line 9287 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 1096 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevWarnAlways, "AuditUtilReadKeyServersGRVError", auditServerId);
															#line 1097 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch2(audit_storage_cancelled(), loopDepth);
															#line 9293 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 1099 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Version readAtVersion = grvF.get();
															#line 1101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromKeyServersReadDone", auditServerId) .detail("Range", range) .detail("ResultSize", readResult.size()) .detail("AuditServerID", auditServerId);
															#line 1107 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		std::unordered_map<UID, std::vector<KeyRange>> serverOwnRanges;
															#line 1108 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;++i) {
															#line 1109 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::vector<UID> src;
															#line 1110 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::vector<UID> dest;
															#line 1111 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			UID srcID;
															#line 1112 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			UID destID;
															#line 1113 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, readResult[i].value, src, dest, srcID, destID);
															#line 1114 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (srcID == anonymousShardId)
															#line 9315 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 1115 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				shardsInAnonymousPhysicalShardCount++;
															#line 9319 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 1117 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			totalShardsCount++;
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::vector<UID> servers(src.size() + dest.size());
															#line 1119 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), servers.begin());
															#line 1120 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			for( auto& ssid : servers ) {
															#line 1121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				serverOwnRanges[ssid].push_back(Standalone(KeyRangeRef(readResult[i].key, readResult[i + 1].key)));
															#line 9331 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
															#line 1124 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		const KeyRange completeRange = Standalone(KeyRangeRef(range.begin, readResult.back().key));
															#line 1125 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilGetThisServerKeysFromKeyServersEnd", auditServerId) .detail("Range", range) .detail("CompleteRange", completeRange) .detail("AtVersion", readAtVersion) .detail("ShardsInAnonymousPhysicalShardCount", shardsInAnonymousPhysicalShardCount) .detail("TotalShardsCount", totalShardsCount);
															#line 1131 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		res = AuditGetKeyServersRes(completeRange, readAtVersion, serverOwnRanges, readResult.logicalSize());
															#line 9340 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1088 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (UIDtoTagMap.more || UIDtoTagMap.size() >= CLIENT_KNOBS->TOO_MANY)
															#line 9349 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 1089 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(g_network->isSimulated() ? SevError : SevWarnAlways, "AuditUtilReadKeyServersReadTagError", auditServerId);
															#line 1092 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch2(audit_storage_cancelled(), loopDepth);
															#line 9355 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 1094 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Future<Version> grvF = tr->getReadVersion();
															#line 1095 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		if (!grvF.isReady())
															#line 9361 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		{
															#line 1096 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			TraceEvent(SevWarnAlways, "AuditUtilReadKeyServersGRVError", auditServerId);
															#line 1097 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			return a_body1Catch2(audit_storage_cancelled(), loopDepth);
															#line 9367 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		}
															#line 1099 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		Version readAtVersion = grvF.get();
															#line 1101 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevVerbose, "AuditUtilGetThisServerKeysFromKeyServersReadDone", auditServerId) .detail("Range", range) .detail("ResultSize", readResult.size()) .detail("AuditServerID", auditServerId);
															#line 1107 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		std::unordered_map<UID, std::vector<KeyRange>> serverOwnRanges;
															#line 1108 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		for(int i = 0;i < readResult.size() - 1;++i) {
															#line 1109 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::vector<UID> src;
															#line 1110 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::vector<UID> dest;
															#line 1111 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			UID srcID;
															#line 1112 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			UID destID;
															#line 1113 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			decodeKeyServersValue(UIDtoTagMap, readResult[i].value, src, dest, srcID, destID);
															#line 1114 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			if (srcID == anonymousShardId)
															#line 9389 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			{
															#line 1115 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				shardsInAnonymousPhysicalShardCount++;
															#line 9393 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
															#line 1117 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			totalShardsCount++;
															#line 1118 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::vector<UID> servers(src.size() + dest.size());
															#line 1119 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			std::merge(src.begin(), src.end(), dest.begin(), dest.end(), servers.begin());
															#line 1120 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
			for( auto& ssid : servers ) {
															#line 1121 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
				serverOwnRanges[ssid].push_back(Standalone(KeyRangeRef(readResult[i].key, readResult[i + 1].key)));
															#line 9405 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
			}
		}
															#line 1124 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		const KeyRange completeRange = Standalone(KeyRangeRef(range.begin, readResult.back().key));
															#line 1125 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		TraceEvent(SevInfo, "AuditUtilGetThisServerKeysFromKeyServersEnd", auditServerId) .detail("Range", range) .detail("CompleteRange", completeRange) .detail("AtVersion", readAtVersion) .detail("ShardsInAnonymousPhysicalShardCount", shardsInAnonymousPhysicalShardCount) .detail("TotalShardsCount", totalShardsCount);
															#line 1131 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
		res = AuditGetKeyServersRes(completeRange, readAtVersion, serverOwnRanges, readResult.logicalSize());
															#line 9414 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<GetShardMapFromKeyServersActor*>(this)->actor_wait_state > 0) static_cast<GetShardMapFromKeyServersActor*>(this)->actor_wait_state = 0;
		static_cast<GetShardMapFromKeyServersActor*>(this)->ActorCallback< GetShardMapFromKeyServersActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< GetShardMapFromKeyServersActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardMapFromKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< GetShardMapFromKeyServersActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardMapFromKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< GetShardMapFromKeyServersActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardMapFromKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	UID auditServerId;
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	Transaction* tr;
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	KeyRange range;
															#line 1071 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	AuditGetKeyServersRes res;
															#line 1072 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	std::vector<Future<Void>> actors;
															#line 1073 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	RangeResult readResult;
															#line 1074 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	RangeResult UIDtoTagMap;
															#line 1075 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int64_t totalShardsCount;
															#line 1076 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	int64_t shardsInAnonymousPhysicalShardCount;
															#line 9525 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
};
// This generated class is to be used only via getShardMapFromKeyServers()
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
class GetShardMapFromKeyServersActor final : public Actor<AuditGetKeyServersRes>, public ActorCallback< GetShardMapFromKeyServersActor, 0, Void >, public FastAllocated<GetShardMapFromKeyServersActor>, public GetShardMapFromKeyServersActorState<GetShardMapFromKeyServersActor> {
															#line 9530 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
public:
	using FastAllocated<GetShardMapFromKeyServersActor>::operator new;
	using FastAllocated<GetShardMapFromKeyServersActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(8560282404513894144UL, 11508822121384776448UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<AuditGetKeyServersRes>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< GetShardMapFromKeyServersActor, 0, Void >;
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	GetShardMapFromKeyServersActor(UID const& auditServerId,Transaction* const& tr,KeyRange const& range) 
															#line 9547 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
		 : Actor<AuditGetKeyServersRes>(),
		   GetShardMapFromKeyServersActorState<GetShardMapFromKeyServersActor>(auditServerId, tr, range),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3833684394082341632UL, 14546150940928992768UL);
		ActorExecutionContextHelper __helper(static_cast<GetShardMapFromKeyServersActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("getShardMapFromKeyServers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("getShardMapFromKeyServers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< GetShardMapFromKeyServersActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
[[nodiscard]] Future<AuditGetKeyServersRes> getShardMapFromKeyServers( UID const& auditServerId, Transaction* const& tr, KeyRange const& range ) {
															#line 1070 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
	return Future<AuditGetKeyServersRes>(new GetShardMapFromKeyServersActor(auditServerId, tr, range));
															#line 9580 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/build_output/fdbclient/AuditUtils.actor.g.cpp.py_gen"
}

#line 1142 "/codebuild/output/src4227438799/src/github.com/apple/foundationdb/fdbclient/AuditUtils.actor.cpp"
