#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
/*
 * WriteBandwidth.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <boost/lexical_cast.hpp>

#include "fdbrpc/DDSketch.h"
#include "fdbclient/NativeAPI.actor.h"
#include "fdbserver/TesterInterface.actor.h"
#include "fdbserver/WorkerInterface.actor.h"
#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/workloads/BulkSetup.actor.h"
#include "flow/actorcompiler.h" // This must be the last #include.

struct WriteBandwidthWorkload : KVWorkload {
	static constexpr auto NAME = "WriteBandwidth";

	int keysPerTransaction;
	double testDuration, warmingDelay, loadTime, maxInsertRate;
	std::vector<Future<Void>> clients;
	PerfIntCounter transactions, retries;
	DDSketch<double> commitLatencies, GRVLatencies;

	WriteBandwidthWorkload(WorkloadContext const& wcx)
	  : KVWorkload(wcx), loadTime(0.0), transactions("Transactions"), retries("Retries"), commitLatencies(),
	    GRVLatencies() {
		testDuration = getOption(options, "testDuration"_sr, 10.0);
		keysPerTransaction = getOption(options, "keysPerTransaction"_sr, 100);
		warmingDelay = getOption(options, "warmingDelay"_sr, 0.0);
		maxInsertRate = getOption(options, "maxInsertRate"_sr, 1e12);
	}

	Future<Void> setup(Database const& cx) override { return _setup(cx, this); }
	Future<Void> start(Database const& cx) override { return _start(cx, this); }

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {
		double duration = testDuration;
		int writes = transactions.getValue() * keysPerTransaction;
		m.emplace_back("Measured Duration", duration, Averaged::True);
		m.emplace_back("Transactions/sec", transactions.getValue() / duration, Averaged::False);
		m.emplace_back("Operations/sec", writes / duration, Averaged::False);
		m.push_back(transactions.getMetric());
		m.push_back(retries.getMetric());
		m.emplace_back("Mean load time (seconds)", loadTime, Averaged::True);
		m.emplace_back("Write rows", writes, Averaged::False);

		m.emplace_back("Mean GRV Latency (ms)", 1000 * GRVLatencies.mean(), Averaged::True);
		m.emplace_back("Median GRV Latency (ms, averaged)", 1000 * GRVLatencies.median(), Averaged::True);
		m.emplace_back("90% GRV Latency (ms, averaged)", 1000 * GRVLatencies.percentile(0.90), Averaged::True);
		m.emplace_back("98% GRV Latency (ms, averaged)", 1000 * GRVLatencies.percentile(0.98), Averaged::True);

		m.emplace_back("Mean Commit Latency (ms)", 1000 * commitLatencies.mean(), Averaged::True);
		m.emplace_back("Median Commit Latency (ms, averaged)", 1000 * commitLatencies.median(), Averaged::True);
		m.emplace_back("90% Commit Latency (ms, averaged)", 1000 * commitLatencies.percentile(0.90), Averaged::True);
		m.emplace_back("98% Commit Latency (ms, averaged)", 1000 * commitLatencies.percentile(0.98), Averaged::True);

		m.emplace_back("Write rows/sec", writes / duration, Averaged::False);
		m.emplace_back("Bytes written/sec",
		               (writes * (keyBytes + (minValueBytes + maxValueBytes) * 0.5)) / duration,
		               Averaged::False);
	}

	Standalone<KeyValueRef> operator()(uint64_t n) { return KeyValueRef(keyForIndex(n, false), randomValue()); }

																#line 85 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
// This generated class is to be used only via _setup()
															#line 83 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
template <class _setupActor>
															#line 83 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
class _setupActorState {
															#line 91 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
public:
															#line 83 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	_setupActorState(Database const& cx,WriteBandwidthWorkload* const& self) 
															#line 83 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
															#line 83 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		 : cx(cx),
															#line 83 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		   self(self),
															#line 84 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		   loadTime(),
															#line 85 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		   ratesAtKeyCounts()
															#line 104 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
	{
		fdb_probe_actor_create("_setup", reinterpret_cast<unsigned long>(this));

	}
	~_setupActorState() 
	{
		fdb_probe_actor_destroy("_setup", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 87 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			StrictFuture<Void> __when_expr_0 = bulkSetup(cx, self, self->nodeCount, loadTime, true, self->warmingDelay, self->maxInsertRate);
															#line 87 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			if (static_cast<_setupActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 121 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_setupActor*>(this)->actor_wait_state = 1;
															#line 87 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _setupActor, 0, Void >*>(static_cast<_setupActor*>(this)));
															#line 126 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		self->loadTime = loadTime.getFuture().get();
															#line 89 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 151 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 88 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		self->loadTime = loadTime.getFuture().get();
															#line 89 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		if (!static_cast<_setupActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_setupActorState(); static_cast<_setupActor*>(this)->destroy(); return 0; }
															#line 165 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		new (&static_cast<_setupActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_setupActorState();
		static_cast<_setupActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_setupActor*>(this)->actor_wait_state > 0) static_cast<_setupActor*>(this)->actor_wait_state = 0;
		static_cast<_setupActor*>(this)->ActorCallback< _setupActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _setupActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _setupActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 83 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	Database cx;
															#line 83 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	WriteBandwidthWorkload* self;
															#line 84 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	Promise<double> loadTime;
															#line 85 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	Promise<std::vector<std::pair<uint64_t, double>>> ratesAtKeyCounts;
															#line 256 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
};
// This generated class is to be used only via _setup()
															#line 83 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
class _setupActor final : public Actor<Void>, public ActorCallback< _setupActor, 0, Void >, public FastAllocated<_setupActor>, public _setupActorState<_setupActor> {
															#line 261 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
public:
	using FastAllocated<_setupActor>::operator new;
	using FastAllocated<_setupActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(12073026208230778368UL, 936099165794944000UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _setupActor, 0, Void >;
															#line 83 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	_setupActor(Database const& cx,WriteBandwidthWorkload* const& self) 
															#line 278 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		 : Actor<Void>(),
		   _setupActorState<_setupActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_setup", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3044502327521131520UL, 13387266639422932480UL);
		ActorExecutionContextHelper __helper(static_cast<_setupActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_setup");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_setup", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _setupActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 83 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
[[nodiscard]] Future<Void> _setup( Database const& cx, WriteBandwidthWorkload* const& self ) {
															#line 83 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	return Future<Void>(new _setupActor(cx, self));
															#line 310 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
}

#line 91 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"

																#line 315 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 92 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
template <class _startActor>
															#line 92 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
class _startActorState {
															#line 321 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
public:
															#line 92 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	_startActorState(Database const& cx,WriteBandwidthWorkload* const& self) 
															#line 92 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
															#line 92 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		 : cx(cx),
															#line 92 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		   self(self)
															#line 330 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 93 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			for(int i = 0;i < self->actorCount;i++) {
															#line 94 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
				self->clients.push_back(self->writeClient(cx, self));
															#line 347 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
			}
															#line 97 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			StrictFuture<Void> __when_expr_0 = timeout(waitForAll(self->clients), self->testDuration, Void());
															#line 97 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 353 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 97 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 358 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 98 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		self->clients.clear();
															#line 99 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 383 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 98 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		self->clients.clear();
															#line 99 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 397 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 92 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	Database cx;
															#line 92 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	WriteBandwidthWorkload* self;
															#line 484 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 92 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 489 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3825227779322804224UL, 5656335695219795200UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
															#line 92 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	_startActor(Database const& cx,WriteBandwidthWorkload* const& self) 
															#line 506 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 92 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, WriteBandwidthWorkload* const& self ) {
															#line 92 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 538 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
}

#line 101 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"

																#line 543 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
// This generated class is to be used only via writeClient()
															#line 102 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
template <class WriteClientActor>
															#line 102 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
class WriteClientActorState {
															#line 549 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
public:
															#line 102 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	WriteClientActorState(Database const& cx,WriteBandwidthWorkload* const& self) 
															#line 102 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
															#line 102 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		 : cx(cx),
															#line 102 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		   self(self)
															#line 558 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
	{
		fdb_probe_actor_create("writeClient", reinterpret_cast<unsigned long>(this));

	}
	~WriteClientActorState() 
	{
		fdb_probe_actor_destroy("writeClient", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 103 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			;
															#line 573 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WriteClientActorState();
		static_cast<WriteClientActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 104 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		tr = Transaction(cx);
															#line 105 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		startIdx = deterministicRandom()->random01() * (self->nodeCount - self->keysPerTransaction);
															#line 106 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		;
															#line 607 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		loopDepth = a_body1loopBody1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
															#line 129 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		++self->transactions;
															#line 616 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1(int loopDepth) 
	{
		try {
															#line 108 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			start = now();
															#line 109 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			StrictFuture<Void> __when_expr_0 = success(tr.getReadVersion());
															#line 109 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 637 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WriteClientActor*>(this)->actor_wait_state = 1;
															#line 109 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 0, Void >*>(static_cast<WriteClientActor*>(this)));
															#line 642 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1break1(int loopDepth) 
	{
		try {
			return a_body1loopBody1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopBody1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 125 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 125 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 2));
															#line 679 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 2)); else return a_body1loopBody1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<WriteClientActor*>(this)->actor_wait_state = 3;
															#line 125 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 2, Void >*>(static_cast<WriteClientActor*>(this)));
															#line 684 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 2));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 2));
		}

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void const& _,int loopDepth) 
	{
															#line 110 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		self->GRVLatencies.addSample(now() - start);
															#line 113 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		tr.addWriteConflictRange( KeyRangeRef(self->keyForIndex(startIdx, false), keyAfter(self->keyForIndex(startIdx + self->keysPerTransaction - 1, false))));
															#line 117 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		for(int i = 0;i < self->keysPerTransaction;i++) {
															#line 118 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			tr.set(self->keyForIndex(startIdx + i, false), self->randomValue(), AddConflictRange::False);
															#line 705 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		}
															#line 120 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		start = now();
															#line 121 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 121 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 713 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteClientActor*>(this)->actor_wait_state = 2;
															#line 121 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 1, Void >*>(static_cast<WriteClientActor*>(this)));
															#line 718 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2(Void && _,int loopDepth) 
	{
															#line 110 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		self->GRVLatencies.addSample(now() - start);
															#line 113 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		tr.addWriteConflictRange( KeyRangeRef(self->keyForIndex(startIdx, false), keyAfter(self->keyForIndex(startIdx + self->keysPerTransaction - 1, false))));
															#line 117 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		for(int i = 0;i < self->keysPerTransaction;i++) {
															#line 118 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
			tr.set(self->keyForIndex(startIdx + i, false), self->randomValue(), AddConflictRange::False);
															#line 733 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		}
															#line 120 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		start = now();
															#line 121 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 121 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		if (static_cast<WriteClientActor*>(this)->actor_wait_state < 0) return a_body1loopBody1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 741 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<WriteClientActor*>(this)->actor_wait_state = 2;
															#line 121 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WriteClientActor, 1, Void >*>(static_cast<WriteClientActor*>(this)));
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WriteClientActor*>(this)->actor_wait_state > 0) static_cast<WriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriteClientActor*>(this)->ActorCallback< WriteClientActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WriteClientActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 122 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		self->commitLatencies.addSample(now() - start);
															#line 830 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 122 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		self->commitLatencies.addSample(now() - start);
															#line 839 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		return a_body1loopBody1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WriteClientActor*>(this)->actor_wait_state > 0) static_cast<WriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriteClientActor*>(this)->ActorCallback< WriteClientActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WriteClientActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		++self->retries;
															#line 923 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
		++self->retries;
															#line 932 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		loopDepth = a_body1loopBody1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<WriteClientActor*>(this)->actor_wait_state > 0) static_cast<WriteClientActor*>(this)->actor_wait_state = 0;
		static_cast<WriteClientActor*>(this)->ActorCallback< WriteClientActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< WriteClientActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< WriteClientActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 102 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	Database cx;
															#line 102 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	WriteBandwidthWorkload* self;
															#line 104 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	Transaction tr;
															#line 105 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	uint64_t startIdx;
															#line 108 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	double start;
															#line 1022 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
};
// This generated class is to be used only via writeClient()
															#line 102 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
class WriteClientActor final : public Actor<Void>, public ActorCallback< WriteClientActor, 0, Void >, public ActorCallback< WriteClientActor, 1, Void >, public ActorCallback< WriteClientActor, 2, Void >, public FastAllocated<WriteClientActor>, public WriteClientActorState<WriteClientActor> {
															#line 1027 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
public:
	using FastAllocated<WriteClientActor>::operator new;
	using FastAllocated<WriteClientActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16149716075584379136UL, 832259986727691008UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WriteClientActor, 0, Void >;
friend struct ActorCallback< WriteClientActor, 1, Void >;
friend struct ActorCallback< WriteClientActor, 2, Void >;
															#line 102 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	WriteClientActor(Database const& cx,WriteBandwidthWorkload* const& self) 
															#line 1046 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
		 : Actor<Void>(),
		   WriteClientActorState<WriteClientActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("writeClient", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4567739696819474176UL, 14335318888042807040UL);
		ActorExecutionContextHelper __helper(static_cast<WriteClientActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("writeClient");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("writeClient", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WriteClientActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WriteClientActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< WriteClientActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 102 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
[[nodiscard]] Future<Void> writeClient( Database const& cx, WriteBandwidthWorkload* const& self ) {
															#line 102 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
	return Future<Void>(new WriteClientActor(cx, self));
															#line 1080 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/WriteBandwidth.actor.g.cpp"
}

#line 132 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/WriteBandwidth.actor.cpp"
};

WorkloadFactory<WriteBandwidthWorkload> WriteBandwidthWorkloadFactory;
