#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
/*
 * TriggerRecovery.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/workloads/workloads.actor.h"
#include "fdbserver/ServerDBInfo.h"
#include "fdbclient/Status.h"
#include "fdbclient/StatusClient.h"
#include "fdbclient/ManagementAPI.actor.h"
#include "fdbclient/RunRYWTransaction.actor.h"
#include "flow/actorcompiler.h" // has to be last include

struct TriggerRecoveryLoopWorkload : TestWorkload {
	static constexpr auto NAME = "TriggerRecoveryLoop";

	double startTime;
	int numRecoveries;
	double delayBetweenRecoveries;
	double killAllProportion;
	Optional<int32_t> originalNumOfResolvers;
	Optional<int32_t> currentNumOfResolvers;

	TriggerRecoveryLoopWorkload(WorkloadContext const& wcx) : TestWorkload(wcx) {
		startTime = getOption(options, "startTime"_sr, 0.0);
		numRecoveries = getOption(options, "numRecoveries"_sr, deterministicRandom()->randomInt(1, 10));
		delayBetweenRecoveries = getOption(options, "delayBetweenRecoveries"_sr, 0.0);
		killAllProportion = getOption(options, "killAllProportion"_sr, 0.1);
		ASSERT((numRecoveries > 0) && (startTime >= 0) && (delayBetweenRecoveries >= 0));
		TraceEvent(SevInfo, "TriggerRecoveryLoopSetup")
		    .detail("StartTime", startTime)
		    .detail("NumRecoveries", numRecoveries)
		    .detail("DelayBetweenRecoveries", delayBetweenRecoveries);
	}

																#line 53 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
// This generated class is to be used only via setOriginalNumOfResolvers()
															#line 51 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
template <class SetOriginalNumOfResolversActor>
															#line 51 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
class SetOriginalNumOfResolversActorState {
															#line 59 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
public:
															#line 51 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	SetOriginalNumOfResolversActorState(Database const& cx,TriggerRecoveryLoopWorkload* const& self) 
															#line 51 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
															#line 51 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		 : cx(cx),
															#line 51 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		   self(self)
															#line 68 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("setOriginalNumOfResolvers", reinterpret_cast<unsigned long>(this));

	}
	~SetOriginalNumOfResolversActorState() 
	{
		fdb_probe_actor_destroy("setOriginalNumOfResolvers", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 52 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			StrictFuture<DatabaseConfiguration> __when_expr_0 = getDatabaseConfiguration(cx);
															#line 52 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			if (static_cast<SetOriginalNumOfResolversActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 85 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<SetOriginalNumOfResolversActor*>(this)->actor_wait_state = 1;
															#line 52 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetOriginalNumOfResolversActor, 0, DatabaseConfiguration >*>(static_cast<SetOriginalNumOfResolversActor*>(this)));
															#line 90 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetOriginalNumOfResolversActorState();
		static_cast<SetOriginalNumOfResolversActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(DatabaseConfiguration const& config,int loopDepth) 
	{
															#line 53 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		self->originalNumOfResolvers = self->currentNumOfResolvers = config.getDesiredResolvers();
															#line 54 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (!static_cast<SetOriginalNumOfResolversActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetOriginalNumOfResolversActorState(); static_cast<SetOriginalNumOfResolversActor*>(this)->destroy(); return 0; }
															#line 115 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		new (&static_cast<SetOriginalNumOfResolversActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetOriginalNumOfResolversActorState();
		static_cast<SetOriginalNumOfResolversActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(DatabaseConfiguration && config,int loopDepth) 
	{
															#line 53 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		self->originalNumOfResolvers = self->currentNumOfResolvers = config.getDesiredResolvers();
															#line 54 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (!static_cast<SetOriginalNumOfResolversActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetOriginalNumOfResolversActorState(); static_cast<SetOriginalNumOfResolversActor*>(this)->destroy(); return 0; }
															#line 129 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		new (&static_cast<SetOriginalNumOfResolversActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetOriginalNumOfResolversActorState();
		static_cast<SetOriginalNumOfResolversActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration const& config,int loopDepth) 
	{
		loopDepth = a_body1cont1(config, loopDepth);

		return loopDepth;
	}
	int a_body1when1(DatabaseConfiguration && config,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(config), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetOriginalNumOfResolversActor*>(this)->actor_wait_state > 0) static_cast<SetOriginalNumOfResolversActor*>(this)->actor_wait_state = 0;
		static_cast<SetOriginalNumOfResolversActor*>(this)->ActorCallback< SetOriginalNumOfResolversActor, 0, DatabaseConfiguration >::remove();

	}
	void a_callback_fire(ActorCallback< SetOriginalNumOfResolversActor, 0, DatabaseConfiguration >*,DatabaseConfiguration const& value) 
	{
		fdb_probe_actor_enter("setOriginalNumOfResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetOriginalNumOfResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setOriginalNumOfResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetOriginalNumOfResolversActor, 0, DatabaseConfiguration >*,DatabaseConfiguration && value) 
	{
		fdb_probe_actor_enter("setOriginalNumOfResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetOriginalNumOfResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setOriginalNumOfResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetOriginalNumOfResolversActor, 0, DatabaseConfiguration >*,Error err) 
	{
		fdb_probe_actor_enter("setOriginalNumOfResolvers", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetOriginalNumOfResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setOriginalNumOfResolvers", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 51 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	Database cx;
															#line 51 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	TriggerRecoveryLoopWorkload* self;
															#line 216 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
};
// This generated class is to be used only via setOriginalNumOfResolvers()
															#line 51 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
class SetOriginalNumOfResolversActor final : public Actor<Void>, public ActorCallback< SetOriginalNumOfResolversActor, 0, DatabaseConfiguration >, public FastAllocated<SetOriginalNumOfResolversActor>, public SetOriginalNumOfResolversActorState<SetOriginalNumOfResolversActor> {
															#line 221 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
public:
	using FastAllocated<SetOriginalNumOfResolversActor>::operator new;
	using FastAllocated<SetOriginalNumOfResolversActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(13699050953228120576UL, 8118948138005261568UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetOriginalNumOfResolversActor, 0, DatabaseConfiguration >;
															#line 51 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	SetOriginalNumOfResolversActor(Database const& cx,TriggerRecoveryLoopWorkload* const& self) 
															#line 238 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   SetOriginalNumOfResolversActorState<SetOriginalNumOfResolversActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setOriginalNumOfResolvers", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10755735097171916288UL, 4786807930222457088UL);
		ActorExecutionContextHelper __helper(static_cast<SetOriginalNumOfResolversActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setOriginalNumOfResolvers");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setOriginalNumOfResolvers", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetOriginalNumOfResolversActor, 0, DatabaseConfiguration >*)0, actor_cancelled()); break;
		}

	}
};
															#line 51 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
[[nodiscard]] Future<Void> setOriginalNumOfResolvers( Database const& cx, TriggerRecoveryLoopWorkload* const& self ) {
															#line 51 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	return Future<Void>(new SetOriginalNumOfResolversActor(cx, self));
															#line 270 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
}

#line 56 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"

	Future<Void> setup(Database const& cx) override {
		if (clientId == 0) {
			return setOriginalNumOfResolvers(cx, this);
		}
		return Void();
	}

																#line 282 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
// This generated class is to be used only via returnIfClusterRecovered()
															#line 64 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
template <class ReturnIfClusterRecoveredActor>
															#line 64 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
class ReturnIfClusterRecoveredActorState {
															#line 288 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
public:
															#line 64 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	ReturnIfClusterRecoveredActorState(Database const& cx) 
															#line 64 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
															#line 64 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		 : cx(cx)
															#line 295 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this));

	}
	~ReturnIfClusterRecoveredActorState() 
	{
		fdb_probe_actor_destroy("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 65 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			;
															#line 310 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReturnIfClusterRecoveredActorState();
		static_cast<ReturnIfClusterRecoveredActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 79 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (!static_cast<ReturnIfClusterRecoveredActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ReturnIfClusterRecoveredActorState(); static_cast<ReturnIfClusterRecoveredActor*>(this)->destroy(); return 0; }
															#line 333 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		new (&static_cast<ReturnIfClusterRecoveredActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ReturnIfClusterRecoveredActorState();
		static_cast<ReturnIfClusterRecoveredActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 66 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		tr = ReadYourWritesTransaction(cx);
															#line 352 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		try {
															#line 68 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 69 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			tr.setOption(FDBTransactionOptions::PRIORITY_SYSTEM_IMMEDIATE);
															#line 70 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			StrictFuture<Version> __when_expr_0 = tr.getReadVersion();
															#line 70 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			if (static_cast<ReturnIfClusterRecoveredActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 362 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReturnIfClusterRecoveredActor*>(this)->actor_wait_state = 1;
															#line 70 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReturnIfClusterRecoveredActor, 0, Version >*>(static_cast<ReturnIfClusterRecoveredActor*>(this)));
															#line 367 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 76 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_2 = tr.onError(e);
															#line 76 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			if (static_cast<ReturnIfClusterRecoveredActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 404 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ReturnIfClusterRecoveredActor*>(this)->actor_wait_state = 3;
															#line 76 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReturnIfClusterRecoveredActor, 2, Void >*>(static_cast<ReturnIfClusterRecoveredActor*>(this)));
															#line 409 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(int loopDepth) 
	{
															#line 71 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		tr.makeSelfConflicting();
															#line 72 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = tr.commit();
															#line 72 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (static_cast<ReturnIfClusterRecoveredActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 428 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1loopBody1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1loopBody1cont2when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReturnIfClusterRecoveredActor*>(this)->actor_wait_state = 2;
															#line 72 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReturnIfClusterRecoveredActor, 1, Void >*>(static_cast<ReturnIfClusterRecoveredActor*>(this)));
															#line 433 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(Version const& __v,int loopDepth) 
	{
															#line 70 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		v = __v;
															#line 442 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(Version && __v,int loopDepth) 
	{
		v = std::move(__v);
		loopDepth = a_body1loopBody1cont2(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReturnIfClusterRecoveredActor*>(this)->actor_wait_state > 0) static_cast<ReturnIfClusterRecoveredActor*>(this)->actor_wait_state = 0;
		static_cast<ReturnIfClusterRecoveredActor*>(this)->ActorCallback< ReturnIfClusterRecoveredActor, 0, Version >::remove();

	}
	void a_callback_fire(ActorCallback< ReturnIfClusterRecoveredActor, 0, Version >*,Version const& value) 
	{
		fdb_probe_actor_enter("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfClusterRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReturnIfClusterRecoveredActor, 0, Version >*,Version && value) 
	{
		fdb_probe_actor_enter("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfClusterRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReturnIfClusterRecoveredActor, 0, Version >*,Error err) 
	{
		fdb_probe_actor_enter("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfClusterRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 73 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		TraceEvent(SevInfo, "TriggerRecoveryLoop_ClusterVersion").detail("Version", v);
															#line 521 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 73 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		TraceEvent(SevInfo, "TriggerRecoveryLoop_ClusterVersion").detail("Version", v);
															#line 530 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		return a_body1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReturnIfClusterRecoveredActor*>(this)->actor_wait_state > 0) static_cast<ReturnIfClusterRecoveredActor*>(this)->actor_wait_state = 0;
		static_cast<ReturnIfClusterRecoveredActor*>(this)->ActorCallback< ReturnIfClusterRecoveredActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReturnIfClusterRecoveredActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfClusterRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReturnIfClusterRecoveredActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfClusterRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReturnIfClusterRecoveredActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfClusterRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReturnIfClusterRecoveredActor*>(this)->actor_wait_state > 0) static_cast<ReturnIfClusterRecoveredActor*>(this)->actor_wait_state = 0;
		static_cast<ReturnIfClusterRecoveredActor*>(this)->ActorCallback< ReturnIfClusterRecoveredActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReturnIfClusterRecoveredActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfClusterRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReturnIfClusterRecoveredActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfClusterRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReturnIfClusterRecoveredActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfClusterRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 64 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	Database cx;
															#line 66 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 70 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	Version v;
															#line 703 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
};
// This generated class is to be used only via returnIfClusterRecovered()
															#line 64 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
class ReturnIfClusterRecoveredActor final : public Actor<Void>, public ActorCallback< ReturnIfClusterRecoveredActor, 0, Version >, public ActorCallback< ReturnIfClusterRecoveredActor, 1, Void >, public ActorCallback< ReturnIfClusterRecoveredActor, 2, Void >, public FastAllocated<ReturnIfClusterRecoveredActor>, public ReturnIfClusterRecoveredActorState<ReturnIfClusterRecoveredActor> {
															#line 708 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
public:
	using FastAllocated<ReturnIfClusterRecoveredActor>::operator new;
	using FastAllocated<ReturnIfClusterRecoveredActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7386621513595055872UL, 14857724399455445248UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReturnIfClusterRecoveredActor, 0, Version >;
friend struct ActorCallback< ReturnIfClusterRecoveredActor, 1, Void >;
friend struct ActorCallback< ReturnIfClusterRecoveredActor, 2, Void >;
															#line 64 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	ReturnIfClusterRecoveredActor(Database const& cx) 
															#line 727 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   ReturnIfClusterRecoveredActorState<ReturnIfClusterRecoveredActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(17337203920119327744UL, 17168092274796932864UL);
		ActorExecutionContextHelper __helper(static_cast<ReturnIfClusterRecoveredActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("returnIfClusterRecovered");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("returnIfClusterRecovered", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReturnIfClusterRecoveredActor, 0, Version >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReturnIfClusterRecoveredActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReturnIfClusterRecoveredActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 64 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
[[nodiscard]] Future<Void> returnIfClusterRecovered( Database const& cx ) {
															#line 64 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	return Future<Void>(new ReturnIfClusterRecoveredActor(cx));
															#line 761 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
}

#line 81 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"

																#line 766 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
// This generated class is to be used only via changeResolverConfig()
															#line 82 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
template <class ChangeResolverConfigActor>
															#line 82 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
class ChangeResolverConfigActorState {
															#line 772 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
public:
															#line 82 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	ChangeResolverConfigActorState(Database const& cx,TriggerRecoveryLoopWorkload* const& self,bool const& setToOriginal = false) 
															#line 82 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
															#line 82 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		 : cx(cx),
															#line 82 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		   self(self),
															#line 82 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		   setToOriginal(setToOriginal),
															#line 85 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		   numResolversToSet()
															#line 785 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("changeResolverConfig", reinterpret_cast<unsigned long>(this));

	}
	~ChangeResolverConfigActorState() 
	{
		fdb_probe_actor_destroy("changeResolverConfig", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 86 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			if (setToOriginal)
															#line 800 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			{
															#line 87 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
				numResolversToSet = self->originalNumOfResolvers.get();
															#line 804 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			}
			else
			{
															#line 89 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
				numResolversToSet = self->currentNumOfResolvers.get() == self->originalNumOfResolvers.get() ? self->originalNumOfResolvers.get() + 1 : self->originalNumOfResolvers.get();
															#line 810 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			}
															#line 93 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			configStr = StringRef(format("resolvers=%d", numResolversToSet));
															#line 94 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			;
															#line 816 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ChangeResolverConfigActorState();
		static_cast<ChangeResolverConfigActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 106 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (!static_cast<ChangeResolverConfigActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~ChangeResolverConfigActorState(); static_cast<ChangeResolverConfigActor*>(this)->destroy(); return 0; }
															#line 839 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		new (&static_cast<ChangeResolverConfigActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~ChangeResolverConfigActorState();
		static_cast<ChangeResolverConfigActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
															#line 95 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		Optional<ConfigureAutoResult> conf;
															#line 96 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		StrictFuture<ConfigurationResult> __when_expr_0 = ManagementAPI::changeConfig(cx.getReference(), { configStr }, conf, true);
															#line 96 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (static_cast<ChangeResolverConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 862 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
		static_cast<ChangeResolverConfigActor*>(this)->actor_wait_state = 1;
															#line 96 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ChangeResolverConfigActor, 0, ConfigurationResult >*>(static_cast<ChangeResolverConfigActor*>(this)));
															#line 867 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1break1(int loopDepth) 
	{
		try {
			return a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(ConfigurationResult const& r,int loopDepth) 
	{
															#line 97 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (r == ConfigurationResult::SUCCESS)
															#line 889 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		{
															#line 98 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			self->currentNumOfResolvers = numResolversToSet;
															#line 99 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			TraceEvent(SevInfo, "TriggerRecoveryLoop_ChangeResolverConfigSuccess") .detail("NumOfResolvers", self->currentNumOfResolvers.get());
															#line 895 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 103 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		TraceEvent(SevWarn, "TriggerRecoveryLoop_ChangeResolverConfigFailed").detail("Result", r);
															#line 104 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 104 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (static_cast<ChangeResolverConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 904 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeResolverConfigActor*>(this)->actor_wait_state = 2;
															#line 104 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeResolverConfigActor, 1, Void >*>(static_cast<ChangeResolverConfigActor*>(this)));
															#line 909 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1cont1(ConfigurationResult && r,int loopDepth) 
	{
															#line 97 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (r == ConfigurationResult::SUCCESS)
															#line 918 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		{
															#line 98 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			self->currentNumOfResolvers = numResolversToSet;
															#line 99 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			TraceEvent(SevInfo, "TriggerRecoveryLoop_ChangeResolverConfigSuccess") .detail("NumOfResolvers", self->currentNumOfResolvers.get());
															#line 924 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			return a_body1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 103 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		TraceEvent(SevWarn, "TriggerRecoveryLoop_ChangeResolverConfigFailed").detail("Result", r);
															#line 104 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_1 = delay(1.0);
															#line 104 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (static_cast<ChangeResolverConfigActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 933 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ChangeResolverConfigActor*>(this)->actor_wait_state = 2;
															#line 104 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ChangeResolverConfigActor, 1, Void >*>(static_cast<ChangeResolverConfigActor*>(this)));
															#line 938 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(ConfigurationResult const& r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(r, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(ConfigurationResult && r,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ChangeResolverConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeResolverConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeResolverConfigActor*>(this)->ActorCallback< ChangeResolverConfigActor, 0, ConfigurationResult >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeResolverConfigActor, 0, ConfigurationResult >*,ConfigurationResult const& value) 
	{
		fdb_probe_actor_enter("changeResolverConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeResolverConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeResolverConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ChangeResolverConfigActor, 0, ConfigurationResult >*,ConfigurationResult && value) 
	{
		fdb_probe_actor_enter("changeResolverConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeResolverConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeResolverConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ChangeResolverConfigActor, 0, ConfigurationResult >*,Error err) 
	{
		fdb_probe_actor_enter("changeResolverConfig", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeResolverConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeResolverConfig", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1cont2(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont2(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ChangeResolverConfigActor*>(this)->actor_wait_state > 0) static_cast<ChangeResolverConfigActor*>(this)->actor_wait_state = 0;
		static_cast<ChangeResolverConfigActor*>(this)->ActorCallback< ChangeResolverConfigActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ChangeResolverConfigActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("changeResolverConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeResolverConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeResolverConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ChangeResolverConfigActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("changeResolverConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeResolverConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeResolverConfig", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ChangeResolverConfigActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("changeResolverConfig", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeResolverConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("changeResolverConfig", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 82 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	Database cx;
															#line 82 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	TriggerRecoveryLoopWorkload* self;
															#line 82 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	bool setToOriginal;
															#line 85 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	int32_t numResolversToSet;
															#line 93 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	StringRef configStr;
															#line 1115 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
};
// This generated class is to be used only via changeResolverConfig()
															#line 82 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
class ChangeResolverConfigActor final : public Actor<Void>, public ActorCallback< ChangeResolverConfigActor, 0, ConfigurationResult >, public ActorCallback< ChangeResolverConfigActor, 1, Void >, public FastAllocated<ChangeResolverConfigActor>, public ChangeResolverConfigActorState<ChangeResolverConfigActor> {
															#line 1120 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
public:
	using FastAllocated<ChangeResolverConfigActor>::operator new;
	using FastAllocated<ChangeResolverConfigActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14517518232031032320UL, 11223936550171636992UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ChangeResolverConfigActor, 0, ConfigurationResult >;
friend struct ActorCallback< ChangeResolverConfigActor, 1, Void >;
															#line 82 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	ChangeResolverConfigActor(Database const& cx,TriggerRecoveryLoopWorkload* const& self,bool const& setToOriginal = false) 
															#line 1138 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   ChangeResolverConfigActorState<ChangeResolverConfigActor>(cx, self, setToOriginal),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("changeResolverConfig", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3507863441917862144UL, 2010419940587447040UL);
		ActorExecutionContextHelper __helper(static_cast<ChangeResolverConfigActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("changeResolverConfig");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("changeResolverConfig", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ChangeResolverConfigActor, 0, ConfigurationResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ChangeResolverConfigActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 82 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
[[nodiscard]] Future<Void> changeResolverConfig( Database const& cx, TriggerRecoveryLoopWorkload* const& self, bool const& setToOriginal = false ) {
															#line 82 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	return Future<Void>(new ChangeResolverConfigActor(cx, self, setToOriginal));
															#line 1171 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
}

#line 108 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"

																#line 1176 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
// This generated class is to be used only via killAll()
															#line 109 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
template <class KillAllActor>
															#line 109 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
class KillAllActorState {
															#line 1182 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
public:
															#line 109 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	KillAllActorState(Database const& cx) 
															#line 109 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
															#line 109 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		 : cx(cx),
															#line 110 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		   tr(cx)
															#line 1191 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("killAll", reinterpret_cast<unsigned long>(this));

	}
	~KillAllActorState() 
	{
		fdb_probe_actor_destroy("killAll", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 111 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			;
															#line 1206 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			loopDepth = a_body1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~KillAllActorState();
		static_cast<KillAllActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1(int loopDepth) 
	{
		try {
															#line 113 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			tr.setOption(FDBTransactionOptions::ACCESS_SYSTEM_KEYS);
															#line 114 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			tr.setOption(FDBTransactionOptions::LOCK_AWARE);
															#line 115 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			StrictFuture<RangeResult> __when_expr_0 = tr.getRange(KeyRangeRef("\xff\xff/worker_interfaces/"_sr, "\xff\xff/worker_interfaces0"_sr), CLIENT_KNOBS->TOO_MANY);
															#line 115 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			if (static_cast<KillAllActor*>(this)->actor_wait_state < 0) return a_body1loopBody1Catch1(actor_cancelled(), loopDepth);
															#line 1243 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1loopBody1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1loopBody1when1(__when_expr_0.get(), loopDepth); };
			static_cast<KillAllActor*>(this)->actor_wait_state = 1;
															#line 115 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< KillAllActor, 0, RangeResult >*>(static_cast<KillAllActor*>(this)));
															#line 1248 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1loopBody1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1loopBody1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1loopBody1cont1(int loopDepth) 
	{
		if (loopDepth == 0) return a_body1loopHead1(0);

		return loopDepth;
	}
	int a_body1loopBody1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
															#line 135 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_1 = tr.onError(e);
															#line 135 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			if (static_cast<KillAllActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1272 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1loopBody1Catch1when1(__when_expr_1.get(), loopDepth); };
			static_cast<KillAllActor*>(this)->actor_wait_state = 2;
															#line 135 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< KillAllActor, 1, Void >*>(static_cast<KillAllActor*>(this)));
															#line 1277 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, std::max(0, loopDepth - 1));
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), std::max(0, loopDepth - 1));
		}

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult const& kvs,int loopDepth) 
	{
															#line 118 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		ASSERT(!kvs.more);
															#line 119 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		std::map<Key, Value> address_interface;
															#line 120 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		for( auto it : kvs ) {
															#line 121 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			auto ip_port = (it.key.endsWith(":tls"_sr) ? it.key.removeSuffix(":tls"_sr) : it.key) .removePrefix("\xff\xff/worker_interfaces/"_sr);
															#line 123 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			address_interface[ip_port] = it.value;
															#line 1300 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		}
															#line 125 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		for( auto it : address_interface ) {
															#line 126 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			if (cx->apiVersionAtLeast(700))
															#line 1306 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			{
															#line 127 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
				BinaryReader::fromStringRef<ClientWorkerInterface>(it.second, IncludeVersion()) .reboot.send(RebootRequest());
															#line 1310 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			}
			else
			{
															#line 130 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
				tr.set("\xff\xff/reboot_worker"_sr, it.second);
															#line 1316 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			}
		}
															#line 132 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		TraceEvent(SevInfo, "TriggerRecoveryLoop_AttempedKillAll").log();
															#line 133 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (!static_cast<KillAllActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KillAllActorState(); static_cast<KillAllActor*>(this)->destroy(); return 0; }
															#line 1323 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		new (&static_cast<KillAllActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~KillAllActorState();
		static_cast<KillAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1cont2(RangeResult && kvs,int loopDepth) 
	{
															#line 118 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		ASSERT(!kvs.more);
															#line 119 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		std::map<Key, Value> address_interface;
															#line 120 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		for( auto it : kvs ) {
															#line 121 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			auto ip_port = (it.key.endsWith(":tls"_sr) ? it.key.removeSuffix(":tls"_sr) : it.key) .removePrefix("\xff\xff/worker_interfaces/"_sr);
															#line 123 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			address_interface[ip_port] = it.value;
															#line 1343 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		}
															#line 125 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		for( auto it : address_interface ) {
															#line 126 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			if (cx->apiVersionAtLeast(700))
															#line 1349 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			{
															#line 127 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
				BinaryReader::fromStringRef<ClientWorkerInterface>(it.second, IncludeVersion()) .reboot.send(RebootRequest());
															#line 1353 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			}
			else
			{
															#line 130 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
				tr.set("\xff\xff/reboot_worker"_sr, it.second);
															#line 1359 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			}
		}
															#line 132 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		TraceEvent(SevInfo, "TriggerRecoveryLoop_AttempedKillAll").log();
															#line 133 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (!static_cast<KillAllActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~KillAllActorState(); static_cast<KillAllActor*>(this)->destroy(); return 0; }
															#line 1366 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		new (&static_cast<KillAllActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~KillAllActorState();
		static_cast<KillAllActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult const& kvs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(kvs, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1when1(RangeResult && kvs,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont2(std::move(kvs), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<KillAllActor*>(this)->actor_wait_state > 0) static_cast<KillAllActor*>(this)->actor_wait_state = 0;
		static_cast<KillAllActor*>(this)->ActorCallback< KillAllActor, 0, RangeResult >::remove();

	}
	void a_callback_fire(ActorCallback< KillAllActor, 0, RangeResult >*,RangeResult const& value) 
	{
		fdb_probe_actor_enter("killAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< KillAllActor, 0, RangeResult >*,RangeResult && value) 
	{
		fdb_probe_actor_enter("killAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killAll", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< KillAllActor, 0, RangeResult >*,Error err) 
	{
		fdb_probe_actor_enter("killAll", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1loopBody1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1loopBody1Catch1(error, 0);
		} catch (...) {
			a_body1loopBody1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killAll", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1loopBody1Catch1cont1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1cont1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1loopBody1Catch1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1loopBody1Catch1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<KillAllActor*>(this)->actor_wait_state > 0) static_cast<KillAllActor*>(this)->actor_wait_state = 0;
		static_cast<KillAllActor*>(this)->ActorCallback< KillAllActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< KillAllActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("killAll", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killAll", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< KillAllActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("killAll", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<KillAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1loopBody1Catch1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killAll", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< KillAllActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("killAll", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<KillAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("killAll", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 109 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	Database cx;
															#line 110 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	ReadYourWritesTransaction tr;
															#line 1540 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
};
// This generated class is to be used only via killAll()
															#line 109 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
class KillAllActor final : public Actor<Void>, public ActorCallback< KillAllActor, 0, RangeResult >, public ActorCallback< KillAllActor, 1, Void >, public FastAllocated<KillAllActor>, public KillAllActorState<KillAllActor> {
															#line 1545 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
public:
	using FastAllocated<KillAllActor>::operator new;
	using FastAllocated<KillAllActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(4606739932320242176UL, 7604963227000241920UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< KillAllActor, 0, RangeResult >;
friend struct ActorCallback< KillAllActor, 1, Void >;
															#line 109 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	KillAllActor(Database const& cx) 
															#line 1563 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   KillAllActorState<KillAllActor>(cx),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("killAll", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8131236958631472896UL, 14746510822375315200UL);
		ActorExecutionContextHelper __helper(static_cast<KillAllActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("killAll");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("killAll", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< KillAllActor, 0, RangeResult >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< KillAllActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 109 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
[[nodiscard]] Future<Void> killAll( Database const& cx ) {
															#line 109 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	return Future<Void>(new KillAllActor(cx));
															#line 1596 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
}

#line 139 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"

																#line 1601 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
// This generated class is to be used only via _start()
															#line 140 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
template <class _startActor>
															#line 140 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
class _startActorState {
															#line 1607 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
public:
															#line 140 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	_startActorState(Database const& cx,TriggerRecoveryLoopWorkload* const& self) 
															#line 140 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
															#line 140 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		 : cx(cx),
															#line 140 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		   self(self)
															#line 1616 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
	{
		fdb_probe_actor_create("_start", reinterpret_cast<unsigned long>(this));

	}
	~_startActorState() 
	{
		fdb_probe_actor_destroy("_start", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 141 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_0 = delay(self->startTime);
															#line 141 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1633 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 1;
															#line 141 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< _startActor, 0, Void >*>(static_cast<_startActor*>(this)));
															#line 1638 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~_startActorState();
		static_cast<_startActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 142 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		numRecoveriesDone = 0;
															#line 1661 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		try {
															#line 144 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			;
															#line 1665 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 142 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		numRecoveriesDone = 0;
															#line 1680 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		try {
															#line 144 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			;
															#line 1684 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< _startActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< _startActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 161 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_5 = self->changeResolverConfig(cx, self, true);
															#line 161 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1776 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont2when1(__when_expr_5.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 6;
															#line 161 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< _startActor, 5, Void >*>(static_cast<_startActor*>(this)));
															#line 1781 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1Catch1(const Error& e,int loopDepth=0) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 145 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (deterministicRandom()->random01() < self->killAllProportion)
															#line 1816 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		{
															#line 146 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_1 = self->killAll(cx);
															#line 146 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1cont1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 2;
															#line 146 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< _startActor, 1, Void >*>(static_cast<_startActor*>(this)));
															#line 1827 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
															#line 148 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->changeResolverConfig(cx, self);
															#line 148 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1836 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1cont1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when2(__when_expr_2.get(), loopDepth); };
			static_cast<_startActor*>(this)->actor_wait_state = 3;
															#line 148 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< _startActor, 2, Void >*>(static_cast<_startActor*>(this)));
															#line 1841 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
			loopDepth = 0;
		}

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1cont1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1cont1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(int loopDepth) 
	{
															#line 150 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		numRecoveriesDone++;
															#line 151 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		TraceEvent(SevInfo, "TriggerRecoveryLoop_AttempedRecovery").detail("RecoveryNum", numRecoveriesDone);
															#line 152 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (numRecoveriesDone == self->numRecoveries)
															#line 1868 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 155 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(self->delayBetweenRecoveries);
															#line 155 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 1876 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1cont1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 4;
															#line 155 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< _startActor, 3, Void >*>(static_cast<_startActor*>(this)));
															#line 1881 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< _startActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< _startActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when2(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< _startActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< _startActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->returnIfClusterRecovered(cx);
															#line 156 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2066 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 156 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 2071 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 156 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		StrictFuture<Void> __when_expr_4 = self->returnIfClusterRecovered(cx);
															#line 156 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (static_cast<_startActor*>(this)->actor_wait_state < 0) return a_body1cont1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 2082 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1cont1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont4when1(__when_expr_4.get(), loopDepth); };
		static_cast<_startActor*>(this)->actor_wait_state = 5;
															#line 156 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< _startActor, 4, Void >*>(static_cast<_startActor*>(this)));
															#line 2087 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< _startActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< _startActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< _startActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1loopBody1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< _startActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1cont1Catch1(error, 0);
		} catch (...) {
			a_body1cont1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont4(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 162 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 2271 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 162 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
		if (!static_cast<_startActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~_startActorState(); static_cast<_startActor*>(this)->destroy(); return 0; }
															#line 2283 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		new (&static_cast<_startActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~_startActorState();
		static_cast<_startActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<_startActor*>(this)->actor_wait_state > 0) static_cast<_startActor*>(this)->actor_wait_state = 0;
		static_cast<_startActor*>(this)->ActorCallback< _startActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< _startActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< _startActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 140 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	Database cx;
															#line 140 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	TriggerRecoveryLoopWorkload* self;
															#line 142 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	int numRecoveriesDone;
															#line 2372 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
};
// This generated class is to be used only via _start()
															#line 140 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
class _startActor final : public Actor<Void>, public ActorCallback< _startActor, 0, Void >, public ActorCallback< _startActor, 1, Void >, public ActorCallback< _startActor, 2, Void >, public ActorCallback< _startActor, 3, Void >, public ActorCallback< _startActor, 4, Void >, public ActorCallback< _startActor, 5, Void >, public FastAllocated<_startActor>, public _startActorState<_startActor> {
															#line 2377 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
public:
	using FastAllocated<_startActor>::operator new;
	using FastAllocated<_startActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7951875997472645888UL, 12715775798148226048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< _startActor, 0, Void >;
friend struct ActorCallback< _startActor, 1, Void >;
friend struct ActorCallback< _startActor, 2, Void >;
friend struct ActorCallback< _startActor, 3, Void >;
friend struct ActorCallback< _startActor, 4, Void >;
friend struct ActorCallback< _startActor, 5, Void >;
															#line 140 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	_startActor(Database const& cx,TriggerRecoveryLoopWorkload* const& self) 
															#line 2399 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
		 : Actor<Void>(),
		   _startActorState<_startActor>(cx, self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("_start", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16516870674810565632UL, 12235738791954228224UL);
		ActorExecutionContextHelper __helper(static_cast<_startActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("_start");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("_start", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< _startActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< _startActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< _startActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< _startActor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< _startActor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< _startActor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 140 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
[[nodiscard]] Future<Void> _start( Database const& cx, TriggerRecoveryLoopWorkload* const& self ) {
															#line 140 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"
	return Future<Void>(new _startActor(cx, self));
															#line 2436 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/workloads/TriggerRecovery.actor.g.cpp"
}

#line 164 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/workloads/TriggerRecovery.actor.cpp"

	Future<Void> start(Database const& cx) override {
		if (clientId != 0)
			return Void();
		return _start(cx, this);
	}

	Future<bool> check(Database const& cx) override { return true; }

	void getMetrics(std::vector<PerfMetric>& m) override {}
};

WorkloadFactory<TriggerRecoveryLoopWorkload> TriggerRecoveryLoopWorkloadFactory;
