#define POST_ACTOR_COMPILER 1
#line 1 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
/*
 * DiskQueue.actor.cpp
 *
 * This source file is part of the FoundationDB open source project
 *
 * Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fdbserver/IDiskQueue.h"
#include "flow/IAsyncFile.h"
#include "fdbserver/Knobs.h"
#include "fdbrpc/simulator.h"
#include "crc32/crc32c.h"
#include "flow/genericactors.actor.h"
#include "flow/xxhash.h"

#include "flow/actorcompiler.h" // This must be the last #include.

typedef bool (*compare_pages)(void*, void*);
typedef int64_t loc_t;

// 0 -> 0
// 1 -> 4k
// 4k -> 4k
int64_t pageCeiling(int64_t loc) {
	return (loc + _PAGE_SIZE - 1) / _PAGE_SIZE * _PAGE_SIZE;
}

// 0 -> 0
// 1 -> 0
// 4k -> 4k
int64_t pageFloor(int64_t loc) {
	return loc / _PAGE_SIZE * _PAGE_SIZE;
}

struct StringBuffer {
	Standalone<StringRef> str;
	int reserved;
	UID id;

	StringBuffer(UID fromFileID) : reserved(0), id(fromFileID) {}

	int size() const { return str.size(); }
	Standalone<StringRef> get() { return str; }
	void clear() {
		str = Standalone<StringRef>();
		reserved = 0;
	}
	void clearReserve(int size) {
		str = Standalone<StringRef>();
		reserved = size;
		str.contents() = StringRef(new (str.arena()) uint8_t[size], 0);
	}
	void append(StringRef x) { memcpy(append(x.size()), x.begin(), x.size()); }
	void* append(int bytes) {
		ASSERT(str.size() + bytes <= reserved);
		void* p = const_cast<uint8_t*>(str.end());
		str.contents() = StringRef(str.begin(), str.size() + bytes);
		return p;
	}
	StringRef pop_front(int bytes) {
		ASSERT(bytes <= str.size());
		StringRef result = str.substr(0, bytes);
		str.contents() = str.substr(bytes);
		return result;
	}
	void alignReserve(int alignment, int size) {
		ASSERT(alignment && (alignment & (alignment - 1)) == 0); // alignment is a power of two

		if (size >= reserved) {
			// SOMEDAY: Use a new arena and discard the old one after copying?
			reserved = std::max(size, reserved * 2);
			if (reserved > 1e9) {
				printf("WOAH! Huge allocation\n");
				TraceEvent(SevError, "StringBufferHugeAllocation", id)
				    .detail("Alignment", alignment)
				    .detail("Reserved", reserved)
				    .backtrace();
			}
			uint8_t* b = new (str.arena()) uint8_t[reserved + alignment - 1];
			uint8_t* e = b + (reserved + alignment - 1);

			uint8_t* p = (uint8_t*)(int64_t(b + alignment - 1) &
			                        ~(alignment - 1)); // first multiple of alignment greater than or equal to b
			ASSERT(p >= b && p + reserved <= e && int64_t(p) % alignment == 0);

			if (str.size() > 0) {
				memcpy(p, str.begin(), str.size());
			}
			str.contents() = StringRef(p, str.size());
		}
	}
};

struct SyncQueue : ReferenceCounted<SyncQueue> {
	SyncQueue(int outstandingLimit, Reference<IAsyncFile> file) : outstandingLimit(outstandingLimit), file(file) {
		for (int i = 0; i < outstandingLimit; i++)
			outstanding.push_back(Void());
	}

	Future<Void> onSync() { // Future is set when all writes completed before the call to onSync are complete
		if (outstanding.size() <= outstandingLimit)
			outstanding.push_back(waitAndSync(this));
		return outstanding.back();
	}

private:
	int outstandingLimit;
	Deque<Future<Void>> outstanding;
	Reference<IAsyncFile> file;

																#line 126 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via waitAndSync()
															#line 124 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class WaitAndSyncActor>
															#line 124 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class WaitAndSyncActorState {
															#line 132 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 124 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	WaitAndSyncActorState(SyncQueue* const& self) 
															#line 124 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 124 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self)
															#line 139 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("waitAndSync", reinterpret_cast<unsigned long>(this));

	}
	~WaitAndSyncActorState() 
	{
		fdb_probe_actor_destroy("waitAndSync", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 125 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->outstanding.front();
															#line 125 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (static_cast<WaitAndSyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 156 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<WaitAndSyncActor*>(this)->actor_wait_state = 1;
															#line 125 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< WaitAndSyncActor, 0, Void >*>(static_cast<WaitAndSyncActor*>(this)));
															#line 161 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~WaitAndSyncActorState();
		static_cast<WaitAndSyncActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->outstanding.pop_front();
															#line 127 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->sync();
															#line 127 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (static_cast<WaitAndSyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 188 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitAndSyncActor*>(this)->actor_wait_state = 2;
															#line 127 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitAndSyncActor, 1, Void >*>(static_cast<WaitAndSyncActor*>(this)));
															#line 193 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 126 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->outstanding.pop_front();
															#line 127 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->file->sync();
															#line 127 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (static_cast<WaitAndSyncActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 206 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<WaitAndSyncActor*>(this)->actor_wait_state = 2;
															#line 127 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< WaitAndSyncActor, 1, Void >*>(static_cast<WaitAndSyncActor*>(this)));
															#line 211 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<WaitAndSyncActor*>(this)->actor_wait_state > 0) static_cast<WaitAndSyncActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAndSyncActor*>(this)->ActorCallback< WaitAndSyncActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAndSyncActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAndSync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< WaitAndSyncActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAndSync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSync", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< WaitAndSyncActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAndSync", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSync", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<WaitAndSyncActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitAndSyncActorState(); static_cast<WaitAndSyncActor*>(this)->destroy(); return 0; }
															#line 295 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<WaitAndSyncActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitAndSyncActorState();
		static_cast<WaitAndSyncActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 128 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<WaitAndSyncActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~WaitAndSyncActorState(); static_cast<WaitAndSyncActor*>(this)->destroy(); return 0; }
															#line 307 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<WaitAndSyncActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~WaitAndSyncActorState();
		static_cast<WaitAndSyncActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<WaitAndSyncActor*>(this)->actor_wait_state > 0) static_cast<WaitAndSyncActor*>(this)->actor_wait_state = 0;
		static_cast<WaitAndSyncActor*>(this)->ActorCallback< WaitAndSyncActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< WaitAndSyncActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("waitAndSync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< WaitAndSyncActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("waitAndSync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSync", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< WaitAndSyncActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("waitAndSync", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("waitAndSync", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 124 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	SyncQueue* self;
															#line 392 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via waitAndSync()
															#line 124 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class WaitAndSyncActor final : public Actor<Void>, public ActorCallback< WaitAndSyncActor, 0, Void >, public ActorCallback< WaitAndSyncActor, 1, Void >, public FastAllocated<WaitAndSyncActor>, public WaitAndSyncActorState<WaitAndSyncActor> {
															#line 397 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<WaitAndSyncActor>::operator new;
	using FastAllocated<WaitAndSyncActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6772445579860515328UL, 4604676445825178624UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< WaitAndSyncActor, 0, Void >;
friend struct ActorCallback< WaitAndSyncActor, 1, Void >;
															#line 124 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	WaitAndSyncActor(SyncQueue* const& self) 
															#line 415 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Void>(),
		   WaitAndSyncActorState<WaitAndSyncActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("waitAndSync", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8071881172979647488UL, 7496258388089928960UL);
		ActorExecutionContextHelper __helper(static_cast<WaitAndSyncActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("waitAndSync");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("waitAndSync", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< WaitAndSyncActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< WaitAndSyncActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 124 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
[[nodiscard]] static Future<Void> waitAndSync( SyncQueue* const& self ) {
															#line 124 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Void>(new WaitAndSyncActor(self));
															#line 448 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 130 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
};

// We use a Tracked instead of a Reference when the shutdown/destructor code would need to wait() on pending file
// operations (e.g., read).
template <typename T>
class Tracked {
protected:
	struct TrackMe : NonCopyable {
		T* self;
		explicit TrackMe(T* self) : self(self) {
			self->actorCount++;
			if (self->actorCount == 1)
				self->actorCountIsZero.set(false);
		}
		~TrackMe() {
			self->actorCount--;
			if (self->actorCount == 0)
				self->actorCountIsZero.set(true);
		}
	};

	Future<Void> onSafeToDestruct() {
		if (actorCountIsZero.get()) {
			return Void();
		} else {
			return actorCountIsZero.onChange();
		}
	}

private:
	int actorCount = 0;
	AsyncVar<bool> actorCountIsZero = true;
};

// DiskQueue uses two files to implement a dynamically resizable ring buffer, where files only allow append and read
// operations.
//    To increase the ring buffer size, it creates a ring buffer in the other file.
//    After finish reading the current file, it switch to use the other file as the ring buffer.
class RawDiskQueue_TwoFiles : public Tracked<RawDiskQueue_TwoFiles> {
public:
	RawDiskQueue_TwoFiles(std::string basename, std::string fileExtension, UID dbgid, int64_t fileSizeWarningLimit)
	  : basename(basename), fileExtension(fileExtension), dbgid(dbgid), dbg_file0BeginSeq(0),
	    fileSizeWarningLimit(fileSizeWarningLimit), onError(delayed(error.getFuture())), onStopped(stopped.getFuture()),
	    readyToPush(Void()), lastCommit(Void()), isFirstCommit(true), readingBuffer(dbgid), readingFile(-1),
	    readingPage(-1), writingPos(-1), fileExtensionBytes(SERVER_KNOBS->DISK_QUEUE_FILE_EXTENSION_BYTES),
	    fileShrinkBytes(SERVER_KNOBS->DISK_QUEUE_FILE_SHRINK_BYTES) {
		if (BUGGIFY)
			fileExtensionBytes = _PAGE_SIZE * deterministicRandom()->randomSkewedUInt32(1, 10 << 10);
		if (BUGGIFY)
			fileShrinkBytes = _PAGE_SIZE * deterministicRandom()->randomSkewedUInt32(1, 10 << 10);
		files[0].dbgFilename = filename(0);
		files[1].dbgFilename = filename(1);
		// We issue reads into firstPages, so it needs to be 4k aligned.
		firstPages.reserve(firstPages.arena(), 2);
		void* pageMemory = operator new(sizeof(Page) * 3, firstPages.arena());
		// firstPages is assumed to always be a valid page, and our initialization here is the only
		// time that it would not contain a valid page.  Whenever DiskQueue reaches in to look at
		// these bytes, it only cares about `seq`, and having that be all 0xFF's means uninitialized
		// pages will look like the ultimate end of the disk queue, rather than the beginning of it.
		// This makes code fail in more immediate and obvious ways.
		firstPages[0] = (Page*)((((uintptr_t)pageMemory + 4095) / 4096) * 4096);
		memset(firstPages[0], 0xFF, sizeof(Page));
		firstPages[1] = (Page*)((uintptr_t)firstPages[0] + 4096);
		memset(firstPages[1], 0xFF, sizeof(Page));
		stallCount.init("RawDiskQueue.StallCount"_sr);
	}

	Future<Void> pushAndCommit(Standalone<StringRef> pageData, StringBuffer* pageMem, uint64_t poppedPages) {
		return pushAndCommit(this, pageData, pageMem, poppedPages);
	}

	void stall() {
		stallCount++;
		readyToPush = lastCommit;
	}

	Future<Standalone<StringRef>> readFirstAndLastPages(compare_pages compare) {
		return readFirstAndLastPages(this, compare);
	}

	void setStartPage(int file, int64_t page) {
		TraceEvent("RDQSetStart", dbgid)
		    .detail("FileNum", file)
		    .detail("PageNum", page)
		    .detail("File0Name", files[0].dbgFilename);
		readingFile = file;
		readingPage = page;
	}

	Future<Void> setPoppedPage(int file, int64_t page, int64_t debugSeq) {
		return setPoppedPage(this, file, page, debugSeq);
	}

	// FIXME: let the caller pass in where to write the data.
	Future<Standalone<StringRef>> read(int file, int page, int nPages) { return read(this, file, page, nPages); }
	Future<Standalone<StringRef>> readNextPage() { return readNextPage(this); }
	Future<Void> truncateBeforeLastReadPage() { return truncateBeforeLastReadPage(this); }

	Future<Void> getError() { return onError; }
	Future<Void> onClosed() { return onStopped; }
	void dispose() { shutdown(this, true); }
	void close() { shutdown(this, false); }

	StorageBytes getStorageBytes() const {
		int64_t free;
		int64_t total;

		g_network->getDiskBytes(parentDirectory(basename), free, total);

		return StorageBytes(free,
		                    total,
		                    files[0].size + files[1].size,
		                    free); // TODO: we could potentially do better in the available field by accounting for the
		                           // unused pages at the end of the file
	}

	// private:
	struct Page {
		uint8_t data[_PAGE_SIZE];
	};

	struct File {
		Reference<IAsyncFile> f;
		int64_t size; // always a multiple of _PAGE_SIZE, even if the physical file isn't for some reason
		int64_t popped;
		std::string dbgFilename;
		Reference<SyncQueue> syncQueue;

		File() : size(-1), popped(-1) {}

		void setFile(Reference<IAsyncFile> f) {
			this->f = f;
			this->syncQueue = makeReference<SyncQueue>(1, f);
		}
	};
	File files[2]; // After readFirstAndLastPages(), files[0] is logically before files[1] (pushes are always into
	               // files[1])
	Standalone<VectorRef<Page*>> firstPages;

	std::string basename;
	std::string fileExtension;
	std::string filename(int i) const { return basename + format("%d.%s", i, fileExtension.c_str()); }

	UID dbgid;
	int64_t dbg_file0BeginSeq;
	int64_t fileSizeWarningLimit;

	Promise<Void> error, stopped;
	Future<Void> onError, onStopped;

	Future<Void> readyToPush;
	Future<Void> lastCommit;
	bool isFirstCommit;

	StringBuffer readingBuffer; // Pages that have been read and not yet returned
	int readingFile; // File index where the next page (after readingBuffer) should be read from, i.e.,
	                 // files[readingFile]. readingFile = 2 if recovery is complete (all files have been read).
	int64_t readingPage; // Page within readingFile that is the next page after readingBuffer

	int64_t writingPos; // Position within files[1] that will be next written

	int64_t fileExtensionBytes;
	int64_t fileShrinkBytes;

	Int64MetricHandle stallCount;

	Future<Void> truncateFile(int file, int64_t pos) { return truncateFile(this, file, pos); }

	// FIXME: Merge this function with IAsyncFileSystem::incrementalDeleteFile().
																#line 621 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via incrementalTruncate()
															#line 299 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class IncrementalTruncateActor>
															#line 299 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class IncrementalTruncateActorState {
															#line 627 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 299 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	IncrementalTruncateActorState(Reference<IAsyncFile> const& file) 
															#line 299 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 299 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : file(file)
															#line 634 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("incrementalTruncate", reinterpret_cast<unsigned long>(this));

	}
	~IncrementalTruncateActorState() 
	{
		fdb_probe_actor_destroy("incrementalTruncate", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 300 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<int64_t> __when_expr_0 = file->size();
															#line 300 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 651 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			static_cast<IncrementalTruncateActor*>(this)->actor_wait_state = 1;
															#line 300 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< IncrementalTruncateActor, 0, int64_t >*>(static_cast<IncrementalTruncateActor*>(this)));
															#line 655 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<IncrementalTruncateActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 302 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		;
															#line 677 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t const& __remainingFileSize,int loopDepth) 
	{
															#line 300 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		remainingFileSize = __remainingFileSize;
															#line 686 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(int64_t && __remainingFileSize,int loopDepth) 
	{
		remainingFileSize = std::move(__remainingFileSize);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<IncrementalTruncateActor*>(this)->actor_wait_state > 0) static_cast<IncrementalTruncateActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalTruncateActor*>(this)->ActorCallback< IncrementalTruncateActor, 0, int64_t >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalTruncateActor, 0, int64_t >*,int64_t const& value) 
	{
		fdb_probe_actor_enter("incrementalTruncate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalTruncateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalTruncate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< IncrementalTruncateActor, 0, int64_t >*,int64_t && value) 
	{
		fdb_probe_actor_enter("incrementalTruncate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalTruncateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalTruncate", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< IncrementalTruncateActor, 0, int64_t >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalTruncate", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalTruncateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalTruncate", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 308 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		TraceEvent("DiskQueueReplaceTruncateEnded").detail("Filename", file->getFilename());
															#line 765 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 302 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!(remainingFileSize > 0))
															#line 781 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 303 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_1 = file->truncate(remainingFileSize);
															#line 303 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
															#line 789 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<IncrementalTruncateActor*>(this)->actor_wait_state = 2;
															#line 303 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< IncrementalTruncateActor, 1, Void >*>(static_cast<IncrementalTruncateActor*>(this)));
															#line 793 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont2(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void const& _,int loopDepth) 
	{
															#line 304 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->sync();
															#line 304 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
															#line 817 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<IncrementalTruncateActor*>(this)->actor_wait_state = 3;
															#line 304 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IncrementalTruncateActor, 2, Void >*>(static_cast<IncrementalTruncateActor*>(this)));
															#line 821 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Void && _,int loopDepth) 
	{
															#line 304 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_2 = file->sync();
															#line 304 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
															#line 832 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<IncrementalTruncateActor*>(this)->actor_wait_state = 3;
															#line 304 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< IncrementalTruncateActor, 2, Void >*>(static_cast<IncrementalTruncateActor*>(this)));
															#line 836 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<IncrementalTruncateActor*>(this)->actor_wait_state > 0) static_cast<IncrementalTruncateActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalTruncateActor*>(this)->ActorCallback< IncrementalTruncateActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalTruncateActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalTruncate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalTruncateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalTruncate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< IncrementalTruncateActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalTruncate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalTruncateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalTruncate", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< IncrementalTruncateActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalTruncate", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalTruncateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalTruncate", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont3(Void const& _,int loopDepth) 
	{
															#line 305 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(FLOW_KNOBS->INCREMENTAL_DELETE_INTERVAL);
															#line 305 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
															#line 922 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<IncrementalTruncateActor*>(this)->actor_wait_state = 4;
															#line 305 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< IncrementalTruncateActor, 3, Void >*>(static_cast<IncrementalTruncateActor*>(this)));
															#line 926 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3(Void && _,int loopDepth) 
	{
															#line 305 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(FLOW_KNOBS->INCREMENTAL_DELETE_INTERVAL);
															#line 305 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont3when1(__when_expr_3.get(), loopDepth); };
															#line 937 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<IncrementalTruncateActor*>(this)->actor_wait_state = 4;
															#line 305 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< IncrementalTruncateActor, 3, Void >*>(static_cast<IncrementalTruncateActor*>(this)));
															#line 941 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<IncrementalTruncateActor*>(this)->actor_wait_state > 0) static_cast<IncrementalTruncateActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalTruncateActor*>(this)->ActorCallback< IncrementalTruncateActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalTruncateActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalTruncate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalTruncateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalTruncate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< IncrementalTruncateActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalTruncate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalTruncateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalTruncate", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< IncrementalTruncateActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalTruncate", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalTruncateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalTruncate", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont1loopBody1cont4(Void const& _,int loopDepth) 
	{
															#line 302 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		remainingFileSize -= FLOW_KNOBS->INCREMENTAL_DELETE_TRUNCATE_AMOUNT;
															#line 1025 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont4(Void && _,int loopDepth) 
	{
															#line 302 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		remainingFileSize -= FLOW_KNOBS->INCREMENTAL_DELETE_TRUNCATE_AMOUNT;
															#line 1034 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<IncrementalTruncateActor*>(this)->actor_wait_state > 0) static_cast<IncrementalTruncateActor*>(this)->actor_wait_state = 0;
		static_cast<IncrementalTruncateActor*>(this)->ActorCallback< IncrementalTruncateActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< IncrementalTruncateActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("incrementalTruncate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalTruncateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalTruncate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< IncrementalTruncateActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("incrementalTruncate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalTruncateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont1loopBody1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalTruncate", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< IncrementalTruncateActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("incrementalTruncate", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalTruncateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("incrementalTruncate", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 299 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		delete static_cast<IncrementalTruncateActor*>(this);
															#line 1118 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 299 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Reference<IAsyncFile> file;
															#line 300 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int64_t remainingFileSize;
															#line 1127 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via incrementalTruncate()
															#line 299 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class IncrementalTruncateActor final : public Actor<void>, public ActorCallback< IncrementalTruncateActor, 0, int64_t >, public ActorCallback< IncrementalTruncateActor, 1, Void >, public ActorCallback< IncrementalTruncateActor, 2, Void >, public ActorCallback< IncrementalTruncateActor, 3, Void >, public FastAllocated<IncrementalTruncateActor>, public IncrementalTruncateActorState<IncrementalTruncateActor> {
															#line 1132 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<IncrementalTruncateActor>::operator new;
	using FastAllocated<IncrementalTruncateActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14771023396194298368UL, 13452335402367655168UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< IncrementalTruncateActor, 0, int64_t >;
friend struct ActorCallback< IncrementalTruncateActor, 1, Void >;
friend struct ActorCallback< IncrementalTruncateActor, 2, Void >;
friend struct ActorCallback< IncrementalTruncateActor, 3, Void >;
															#line 299 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	IncrementalTruncateActor(Reference<IAsyncFile> const& file) 
															#line 1152 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<void>(),
		   IncrementalTruncateActorState<IncrementalTruncateActor>(file),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("incrementalTruncate", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16934395315238103296UL, 2024796163238840576UL);
		ActorExecutionContextHelper __helper(static_cast<IncrementalTruncateActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("incrementalTruncate");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("incrementalTruncate", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 299 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
static void incrementalTruncate( Reference<IAsyncFile> const& file ) {
															#line 299 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	new IncrementalTruncateActor(file);
															#line 1175 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 310 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

#if defined(_WIN32)
																#line 1181 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via replaceFile()
															#line 312 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class ReplaceFileActor>
															#line 312 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReplaceFileActorState {
															#line 1187 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 312 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReplaceFileActorState(Reference<IAsyncFile> const& toReplace) 
															#line 312 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 312 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : toReplace(toReplace)
															#line 1194 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("replaceFile", reinterpret_cast<unsigned long>(this));

	}
	~ReplaceFileActorState() 
	{
		fdb_probe_actor_destroy("replaceFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 314 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Void> __when_expr_0 = toReplace->truncate(4 << 10);
															#line 314 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (static_cast<ReplaceFileActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1211 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReplaceFileActor*>(this)->actor_wait_state = 1;
															#line 314 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReplaceFileActor, 0, Void >*>(static_cast<ReplaceFileActor*>(this)));
															#line 1216 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReplaceFileActorState();
		static_cast<ReplaceFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 315 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReplaceFileActor*>(this)->SAV<Reference<IAsyncFile>>::futures) { (void)(toReplace); this->~ReplaceFileActorState(); static_cast<ReplaceFileActor*>(this)->destroy(); return 0; }
															#line 1239 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReplaceFileActor*>(this)->SAV< Reference<IAsyncFile> >::value()) Reference<IAsyncFile>(std::move(toReplace)); // state_var_RVO
		this->~ReplaceFileActorState();
		static_cast<ReplaceFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 315 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReplaceFileActor*>(this)->SAV<Reference<IAsyncFile>>::futures) { (void)(toReplace); this->~ReplaceFileActorState(); static_cast<ReplaceFileActor*>(this)->destroy(); return 0; }
															#line 1251 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReplaceFileActor*>(this)->SAV< Reference<IAsyncFile> >::value()) Reference<IAsyncFile>(std::move(toReplace)); // state_var_RVO
		this->~ReplaceFileActorState();
		static_cast<ReplaceFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReplaceFileActor*>(this)->actor_wait_state > 0) static_cast<ReplaceFileActor*>(this)->actor_wait_state = 0;
		static_cast<ReplaceFileActor*>(this)->ActorCallback< ReplaceFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplaceFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("replaceFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replaceFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReplaceFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("replaceFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replaceFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReplaceFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("replaceFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replaceFile", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 312 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Reference<IAsyncFile> toReplace;
															#line 1336 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via replaceFile()
															#line 312 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReplaceFileActor final : public Actor<Reference<IAsyncFile>>, public ActorCallback< ReplaceFileActor, 0, Void >, public FastAllocated<ReplaceFileActor>, public ReplaceFileActorState<ReplaceFileActor> {
															#line 1341 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<ReplaceFileActor>::operator new;
	using FastAllocated<ReplaceFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10767193694357712384UL, 3309270823474932480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<IAsyncFile>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReplaceFileActor, 0, Void >;
															#line 312 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReplaceFileActor(Reference<IAsyncFile> const& toReplace) 
															#line 1358 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Reference<IAsyncFile>>(),
		   ReplaceFileActorState<ReplaceFileActor>(toReplace),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("replaceFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(2403045773695531008UL, 6611563022924325376UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("replaceFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("replaceFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReplaceFileActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 312 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
[[nodiscard]] static Future<Reference<IAsyncFile>> replaceFile( Reference<IAsyncFile> const& toReplace ) {
															#line 312 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Reference<IAsyncFile>>(new ReplaceFileActor(toReplace));
															#line 1390 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 317 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
#else
																#line 1395 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via replaceFile()
															#line 318 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class ReplaceFileActor1>
															#line 318 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReplaceFileActor1State {
															#line 1401 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 318 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReplaceFileActor1State(Reference<IAsyncFile> const& toReplace) 
															#line 318 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 318 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : toReplace(toReplace)
															#line 1408 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("replaceFile", reinterpret_cast<unsigned long>(this));

	}
	~ReplaceFileActor1State() 
	{
		fdb_probe_actor_destroy("replaceFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 319 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			incrementalTruncate(toReplace);
															#line 321 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Reference<IAsyncFile>> __when_expr_0 = IAsyncFileSystem::filesystem()->open( toReplace->getFilename(), IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_UNBUFFERED | IAsyncFile::OPEN_LOCK, 0600);
															#line 321 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (static_cast<ReplaceFileActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1427 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReplaceFileActor1*>(this)->actor_wait_state = 1;
															#line 321 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReplaceFileActor1, 0, Reference<IAsyncFile> >*>(static_cast<ReplaceFileActor1*>(this)));
															#line 1432 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReplaceFileActor1State();
		static_cast<ReplaceFileActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> const& _replacement,int loopDepth) 
	{
															#line 326 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		replacement = _replacement;
															#line 327 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_1 = replacement->sync();
															#line 327 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (static_cast<ReplaceFileActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1459 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReplaceFileActor1*>(this)->actor_wait_state = 2;
															#line 327 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReplaceFileActor1, 1, Void >*>(static_cast<ReplaceFileActor1*>(this)));
															#line 1464 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Reference<IAsyncFile> && _replacement,int loopDepth) 
	{
															#line 326 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		replacement = _replacement;
															#line 327 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_1 = replacement->sync();
															#line 327 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (static_cast<ReplaceFileActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 1477 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReplaceFileActor1*>(this)->actor_wait_state = 2;
															#line 327 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReplaceFileActor1, 1, Void >*>(static_cast<ReplaceFileActor1*>(this)));
															#line 1482 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& _replacement,int loopDepth) 
	{
		loopDepth = a_body1cont1(_replacement, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && _replacement,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_replacement), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReplaceFileActor1*>(this)->actor_wait_state > 0) static_cast<ReplaceFileActor1*>(this)->actor_wait_state = 0;
		static_cast<ReplaceFileActor1*>(this)->ActorCallback< ReplaceFileActor1, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< ReplaceFileActor1, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("replaceFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replaceFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReplaceFileActor1, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("replaceFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replaceFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReplaceFileActor1, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("replaceFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replaceFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 329 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReplaceFileActor1*>(this)->SAV<Reference<IAsyncFile>>::futures) { (void)(replacement); this->~ReplaceFileActor1State(); static_cast<ReplaceFileActor1*>(this)->destroy(); return 0; }
															#line 1566 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReplaceFileActor1*>(this)->SAV< Reference<IAsyncFile> >::value()) Reference<IAsyncFile>(std::move(replacement)); // state_var_RVO
		this->~ReplaceFileActor1State();
		static_cast<ReplaceFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 329 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReplaceFileActor1*>(this)->SAV<Reference<IAsyncFile>>::futures) { (void)(replacement); this->~ReplaceFileActor1State(); static_cast<ReplaceFileActor1*>(this)->destroy(); return 0; }
															#line 1578 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReplaceFileActor1*>(this)->SAV< Reference<IAsyncFile> >::value()) Reference<IAsyncFile>(std::move(replacement)); // state_var_RVO
		this->~ReplaceFileActor1State();
		static_cast<ReplaceFileActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReplaceFileActor1*>(this)->actor_wait_state > 0) static_cast<ReplaceFileActor1*>(this)->actor_wait_state = 0;
		static_cast<ReplaceFileActor1*>(this)->ActorCallback< ReplaceFileActor1, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReplaceFileActor1, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("replaceFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replaceFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReplaceFileActor1, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("replaceFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replaceFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReplaceFileActor1, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("replaceFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("replaceFile", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 318 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Reference<IAsyncFile> toReplace;
															#line 326 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Reference<IAsyncFile> replacement;
															#line 1665 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via replaceFile()
															#line 318 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReplaceFileActor1 final : public Actor<Reference<IAsyncFile>>, public ActorCallback< ReplaceFileActor1, 0, Reference<IAsyncFile> >, public ActorCallback< ReplaceFileActor1, 1, Void >, public FastAllocated<ReplaceFileActor1>, public ReplaceFileActor1State<ReplaceFileActor1> {
															#line 1670 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<ReplaceFileActor1>::operator new;
	using FastAllocated<ReplaceFileActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(10767193694357712384UL, 3309270823474932480UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Reference<IAsyncFile>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReplaceFileActor1, 0, Reference<IAsyncFile> >;
friend struct ActorCallback< ReplaceFileActor1, 1, Void >;
															#line 318 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReplaceFileActor1(Reference<IAsyncFile> const& toReplace) 
															#line 1688 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Reference<IAsyncFile>>(),
		   ReplaceFileActor1State<ReplaceFileActor1>(toReplace),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("replaceFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11405398894919752960UL, 15305368755244453120UL);
		ActorExecutionContextHelper __helper(static_cast<ReplaceFileActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("replaceFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("replaceFile", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReplaceFileActor1, 0, Reference<IAsyncFile> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReplaceFileActor1, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 318 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
[[nodiscard]] static Future<Reference<IAsyncFile>> replaceFile( Reference<IAsyncFile> const& toReplace ) {
															#line 318 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Reference<IAsyncFile>>(new ReplaceFileActor1(toReplace));
															#line 1721 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 331 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
#endif

	Future<Future<Void>> push(Standalone<StringRef> pageData, std::vector<Reference<SyncQueue>>* toSync) {
		return push(this, pageData, toSync);
	}

																#line 1731 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via push()
															#line 337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class PushActor>
															#line 337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class PushActorState {
															#line 1737 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	PushActorState(RawDiskQueue_TwoFiles* const& self,Standalone<StringRef> const& pageData,std::vector<Reference<SyncQueue>>* const& toSync) 
															#line 337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   pageData(pageData),
															#line 337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   toSync(toSync)
															#line 1748 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("push", reinterpret_cast<unsigned long>(this));

	}
	~PushActorState() 
	{
		fdb_probe_actor_destroy("push", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 342 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(self->readingFile == 2);
															#line 343 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(pageData.size() % _PAGE_SIZE == 0);
															#line 344 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(int64_t(pageData.begin()) % _PAGE_SIZE == 0);
															#line 345 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(self->writingPos % _PAGE_SIZE == 0);
															#line 346 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(self->files[0].size % _PAGE_SIZE == 0 && self->files[1].size % _PAGE_SIZE == 0);
															#line 348 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			waitfor = std::vector<Future<Void>>();
															#line 350 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (pageData.size() + self->writingPos > self->files[1].size)
															#line 1775 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 351 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (self->files[0].popped == self->files[0].size)
															#line 1779 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				{
															#line 353 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					int p = self->files[1].size - self->writingPos;
															#line 354 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					if (p > 0)
															#line 1785 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
					{
															#line 355 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
						toSync->push_back(self->files[1].syncQueue);
															#line 358 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
						waitfor.push_back(uncancellable( holdWhile(pageData, self->files[1].f->write(pageData.begin(), p, self->writingPos))));
															#line 360 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
						pageData.contents() = pageData.substr(p);
															#line 1793 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
					}
															#line 363 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					self->dbg_file0BeginSeq += self->files[0].size;
															#line 364 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					std::swap(self->files[0], self->files[1]);
															#line 365 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					std::swap(self->firstPages[0], self->firstPages[1]);
															#line 366 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					self->files[1].popped = 0;
															#line 367 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					self->writingPos = 0;
															#line 368 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					*self->firstPages[1] = *(const Page*)pageData.begin();
															#line 370 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					const int64_t activeDataVolume = pageCeiling(self->files[0].size - self->files[0].popped + self->fileExtensionBytes + self->fileShrinkBytes);
															#line 372 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					const int64_t desiredMaxFileSize = pageCeiling(std::max(activeDataVolume, SERVER_KNOBS->TLOG_HARD_LIMIT_BYTES * 2));
															#line 374 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					const bool frivolouslyTruncate = BUGGIFY_WITH_PROB(0.1);
															#line 375 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					if (self->files[1].size > desiredMaxFileSize || frivolouslyTruncate)
															#line 1815 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
					{
															#line 377 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
						int64_t maxShrink = pageFloor(std::max(self->files[1].size - desiredMaxFileSize, self->fileShrinkBytes));
															#line 379 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
						if ((maxShrink > SERVER_KNOBS->DISK_QUEUE_MAX_TRUNCATE_BYTES) || (frivolouslyTruncate && deterministicRandom()->random01() < 0.3))
															#line 1821 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
						{
															#line 381 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
							CODE_PROBE(true, "Replacing DiskQueue file");
															#line 382 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
							TraceEvent("DiskQueueReplaceFile", self->dbgid) .detail("Filename", self->files[1].f->getFilename()) .detail("OldFileSize", self->files[1].size) .detail("ElidedTruncateSize", maxShrink);
															#line 386 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
							StrictFuture<Reference<IAsyncFile>> __when_expr_0 = replaceFile(self->files[1].f);
															#line 386 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
							if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 1831 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
							static_cast<PushActor*>(this)->actor_wait_state = 1;
															#line 386 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
							__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PushActor, 0, Reference<IAsyncFile> >*>(static_cast<PushActor*>(this)));
															#line 1835 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
							loopDepth = 0;
						}
						else
						{
															#line 391 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
							CODE_PROBE(true, "Truncating DiskQueue file");
															#line 392 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
							const int64_t startingSize = self->files[1].size;
															#line 393 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
							self->files[1].size -= std::min(maxShrink, self->files[1].size);
															#line 394 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
							self->files[1].size = std::max(self->files[1].size, self->fileExtensionBytes);
															#line 395 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
							TraceEvent("DiskQueueTruncate", self->dbgid) .detail("Filename", self->files[1].f->getFilename()) .detail("OldFileSize", startingSize) .detail("NewFileSize", self->files[1].size);
															#line 399 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
							waitfor.push_back(self->files[1].f->truncate(self->files[1].size));
															#line 1852 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
							loopDepth = a_body1cont5(loopDepth);
						}
					}
					else
					{
						loopDepth = a_body1cont3(loopDepth);
					}
				}
				else
				{
															#line 407 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					int64_t minExtension = pageData.size() + self->writingPos - self->files[1].size;
															#line 408 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					self->files[1].size += std::min(std::max(self->fileExtensionBytes, minExtension), self->files[0].size + self->files[1].size + minExtension);
															#line 410 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					waitfor.push_back(self->files[1].f->truncate(self->files[1].size));
															#line 412 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					if (self->fileSizeWarningLimit > 0 && self->files[1].size > self->fileSizeWarningLimit)
															#line 1871 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
					{
															#line 413 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
						TraceEvent(SevWarnAlways, "DiskQueueFileTooLarge", self->dbgid) .suppressFor(1.0) .detail("Filename", self->filename(1)) .detail("Size", self->files[1].size);
															#line 1875 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
					}
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			else
			{
															#line 419 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (self->writingPos == 0)
															#line 1884 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				{
															#line 421 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					*self->firstPages[1] = *(const Page*)pageData.begin();
															#line 1888 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				}
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PushActorState();
		static_cast<PushActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 426 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->files[1].size = std::max(self->files[1].size, self->writingPos + pageData.size());
															#line 427 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		toSync->push_back(self->files[1].syncQueue);
															#line 428 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		waitfor.push_back(uncancellable( holdWhile(pageData, self->files[1].f->write(pageData.begin(), pageData.size(), self->writingPos))));
															#line 430 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->writingPos += pageData.size();
															#line 432 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<PushActor*>(this)->SAV<Future<Void>>::futures) { (void)(waitForAllReadyThenThrow(waitfor)); this->~PushActorState(); static_cast<PushActor*>(this)->destroy(); return 0; }
															#line 1921 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<PushActor*>(this)->SAV< Future<Void> >::value()) Future<Void>(waitForAllReadyThenThrow(waitfor));
		this->~PushActorState();
		static_cast<PushActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Reference<IAsyncFile> const& newFile,int loopDepth) 
	{
															#line 387 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->files[1].setFile(newFile);
															#line 388 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		waitfor.push_back(self->files[1].f->truncate(self->fileExtensionBytes));
															#line 389 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->files[1].size = self->fileExtensionBytes;
															#line 1955 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Reference<IAsyncFile> && newFile,int loopDepth) 
	{
															#line 387 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->files[1].setFile(newFile);
															#line 388 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		waitfor.push_back(self->files[1].f->truncate(self->fileExtensionBytes));
															#line 389 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->files[1].size = self->fileExtensionBytes;
															#line 1968 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> const& newFile,int loopDepth) 
	{
		loopDepth = a_body1cont6(newFile, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Reference<IAsyncFile> && newFile,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(newFile), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PushActor*>(this)->actor_wait_state > 0) static_cast<PushActor*>(this)->actor_wait_state = 0;
		static_cast<PushActor*>(this)->ActorCallback< PushActor, 0, Reference<IAsyncFile> >::remove();

	}
	void a_callback_fire(ActorCallback< PushActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> const& value) 
	{
		fdb_probe_actor_enter("push", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PushActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("push", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PushActor, 0, Reference<IAsyncFile> >*,Reference<IAsyncFile> && value) 
	{
		fdb_probe_actor_enter("push", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PushActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("push", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PushActor, 0, Reference<IAsyncFile> >*,Error err) 
	{
		fdb_probe_actor_enter("push", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PushActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("push", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	RawDiskQueue_TwoFiles* self;
															#line 337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Standalone<StringRef> pageData;
															#line 337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	std::vector<Reference<SyncQueue>>* toSync;
															#line 348 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	std::vector<Future<Void>> waitfor;
															#line 2056 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via push()
															#line 337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class PushActor final : public Actor<Future<Void>>, public ActorCallback< PushActor, 0, Reference<IAsyncFile> >, public FastAllocated<PushActor>, public PushActorState<PushActor> {
															#line 2061 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<PushActor>::operator new;
	using FastAllocated<PushActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16071491573932497664UL, 18107322076497445120UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Future<Void>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PushActor, 0, Reference<IAsyncFile> >;
															#line 337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	PushActor(RawDiskQueue_TwoFiles* const& self,Standalone<StringRef> const& pageData,std::vector<Reference<SyncQueue>>* const& toSync) 
															#line 2078 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Future<Void>>(),
		   PushActorState<PushActor>(self, pageData, toSync),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("push", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13629107650161882624UL, 4038763567833321984UL);
		ActorExecutionContextHelper __helper(static_cast<PushActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("push");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("push", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
static Future<Future<Void>> push( RawDiskQueue_TwoFiles* const& self, Standalone<StringRef> const& pageData, std::vector<Reference<SyncQueue>>* const& toSync ) {
															#line 337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Future<Void>>(new PushActor(self, pageData, toSync));
															#line 2101 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 434 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

	// Write the given data (pageData) to the queue files of self, sync data to disk, and delete the memory (pageMem)
	// that hold the pageData
																#line 2108 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via pushAndCommit()
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class PushAndCommitActor>
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class PushAndCommitActorState {
															#line 2114 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	PushAndCommitActorState(RawDiskQueue_TwoFiles* const& self,Standalone<StringRef> const& pageData,StringBuffer* const& pageMem,uint64_t const& poppedPages) 
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   pageData(pageData),
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   pageMem(pageMem),
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   poppedPages(poppedPages),
															#line 441 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   committed(),
															#line 442 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   errorPromise(self->error),
															#line 443 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   filename(self->files[0].dbgFilename),
															#line 444 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   dbgid(self->dbgid),
															#line 445 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   syncFiles(),
															#line 446 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   lastCommit(self->lastCommit)
															#line 2139 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("pushAndCommit", reinterpret_cast<unsigned long>(this));

	}
	~PushAndCommitActorState() 
	{
		fdb_probe_actor_destroy("pushAndCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 450 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				Future<Void> ready = self->readyToPush;
															#line 451 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				self->readyToPush = pushing.getFuture();
															#line 452 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				self->lastCommit = committed.getFuture();
															#line 456 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (self->isFirstCommit)
															#line 2161 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				{
															#line 457 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					self->isFirstCommit = false;
															#line 458 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					self->readyToPush = self->lastCommit;
															#line 2167 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				}
															#line 461 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				StrictFuture<Void> __when_expr_0 = ready;
															#line 461 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 2173 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				static_cast<PushAndCommitActor*>(this)->actor_wait_state = 1;
															#line 461 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< PushAndCommitActor, 0, Void >*>(static_cast<PushAndCommitActor*>(this)));
															#line 2177 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~PushAndCommitActorState();
		static_cast<PushAndCommitActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 509 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<PushAndCommitActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~PushAndCommitActorState(); static_cast<PushAndCommitActor*>(this)->destroy(); return 0; }
															#line 2206 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<PushAndCommitActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~PushAndCommitActorState();
		static_cast<PushAndCommitActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 493 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			delete pageMem;
															#line 494 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			CODE_PROBE(true, "push error");
															#line 495 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			CODE_PROBE(2 == syncFiles.size(), "push spanning both files error");
															#line 496 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			TraceEvent(SevError, "RDQPushAndCommitError", dbgid) .errorUnsuppressed(e) .detail("InitialFilename0", filename);
															#line 500 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (errorPromise.canBeSet())
															#line 2227 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 501 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				errorPromise.sendError(e);
															#line 2231 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 502 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (pushing.canBeSet())
															#line 2235 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 503 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				pushing.sendError(e);
															#line 2239 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 504 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (committed.canBeSet())
															#line 2243 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 505 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				committed.sendError(e);
															#line 2247 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 507 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 2251 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 463 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		CODE_PROBE(pageData.size() > sizeof(Page), "push more than one page of data");
															#line 465 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Future<Void>> __when_expr_1 = self->push(pageData, &syncFiles);
															#line 465 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 2269 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<PushAndCommitActor*>(this)->actor_wait_state = 2;
															#line 465 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PushAndCommitActor, 1, Future<Void> >*>(static_cast<PushAndCommitActor*>(this)));
															#line 2273 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 463 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		CODE_PROBE(pageData.size() > sizeof(Page), "push more than one page of data");
															#line 465 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Future<Void>> __when_expr_1 = self->push(pageData, &syncFiles);
															#line 465 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 2286 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<PushAndCommitActor*>(this)->actor_wait_state = 2;
															#line 465 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< PushAndCommitActor, 1, Future<Void> >*>(static_cast<PushAndCommitActor*>(this)));
															#line 2290 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<PushAndCommitActor*>(this)->actor_wait_state > 0) static_cast<PushAndCommitActor*>(this)->actor_wait_state = 0;
		static_cast<PushAndCommitActor*>(this)->ActorCallback< PushAndCommitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PushAndCommitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< PushAndCommitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< PushAndCommitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Future<Void> const& pushed,int loopDepth) 
	{
															#line 466 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		pushing.send(Void());
															#line 467 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(syncFiles.size() >= 1 && syncFiles.size() <= 2);
															#line 468 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		CODE_PROBE(2 == syncFiles.size(), "push spans both files");
															#line 469 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_2 = pushed;
															#line 469 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
															#line 2382 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<PushAndCommitActor*>(this)->actor_wait_state = 3;
															#line 469 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PushAndCommitActor, 2, Void >*>(static_cast<PushAndCommitActor*>(this)));
															#line 2386 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(Future<Void> && pushed,int loopDepth) 
	{
															#line 466 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		pushing.send(Void());
															#line 467 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(syncFiles.size() >= 1 && syncFiles.size() <= 2);
															#line 468 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		CODE_PROBE(2 == syncFiles.size(), "push spans both files");
															#line 469 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_2 = pushed;
															#line 469 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont4when1(__when_expr_2.get(), loopDepth); };
															#line 2403 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<PushAndCommitActor*>(this)->actor_wait_state = 3;
															#line 469 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< PushAndCommitActor, 2, Void >*>(static_cast<PushAndCommitActor*>(this)));
															#line 2407 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(Future<Void> const& pushed,int loopDepth) 
	{
		loopDepth = a_body1cont4(pushed, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Future<Void> && pushed,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(pushed), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<PushAndCommitActor*>(this)->actor_wait_state > 0) static_cast<PushAndCommitActor*>(this)->actor_wait_state = 0;
		static_cast<PushAndCommitActor*>(this)->ActorCallback< PushAndCommitActor, 1, Future<Void> >::remove();

	}
	void a_callback_fire(ActorCallback< PushAndCommitActor, 1, Future<Void> >*,Future<Void> const& value) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< PushAndCommitActor, 1, Future<Void> >*,Future<Void> && value) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< PushAndCommitActor, 1, Future<Void> >*,Error err) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 471 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		delete pageMem;
															#line 472 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		pageMem = 0;
															#line 474 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		Future<Void> sync = syncFiles[0]->onSync();
															#line 475 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		for(int i = 1;i < syncFiles.size();i++) {
															#line 476 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			sync = sync && syncFiles[i]->onSync();
															#line 2499 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 477 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_3 = sync;
															#line 477 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
															#line 2505 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<PushAndCommitActor*>(this)->actor_wait_state = 4;
															#line 477 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PushAndCommitActor, 3, Void >*>(static_cast<PushAndCommitActor*>(this)));
															#line 2509 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 471 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		delete pageMem;
															#line 472 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		pageMem = 0;
															#line 474 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		Future<Void> sync = syncFiles[0]->onSync();
															#line 475 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		for(int i = 1;i < syncFiles.size();i++) {
															#line 476 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			sync = sync && syncFiles[i]->onSync();
															#line 2526 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 477 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_3 = sync;
															#line 477 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
															#line 2532 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<PushAndCommitActor*>(this)->actor_wait_state = 4;
															#line 477 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< PushAndCommitActor, 3, Void >*>(static_cast<PushAndCommitActor*>(this)));
															#line 2536 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<PushAndCommitActor*>(this)->actor_wait_state > 0) static_cast<PushAndCommitActor*>(this)->actor_wait_state = 0;
		static_cast<PushAndCommitActor*>(this)->ActorCallback< PushAndCommitActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PushAndCommitActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< PushAndCommitActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< PushAndCommitActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 478 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_4 = lastCommit;
															#line 478 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
															#line 2622 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<PushAndCommitActor*>(this)->actor_wait_state = 5;
															#line 478 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PushAndCommitActor, 4, Void >*>(static_cast<PushAndCommitActor*>(this)));
															#line 2626 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 478 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_4 = lastCommit;
															#line 478 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), loopDepth); else return a_body1cont6when1(__when_expr_4.get(), loopDepth); };
															#line 2637 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<PushAndCommitActor*>(this)->actor_wait_state = 5;
															#line 478 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< PushAndCommitActor, 4, Void >*>(static_cast<PushAndCommitActor*>(this)));
															#line 2641 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<PushAndCommitActor*>(this)->actor_wait_state > 0) static_cast<PushAndCommitActor*>(this)->actor_wait_state = 0;
		static_cast<PushAndCommitActor*>(this)->ActorCallback< PushAndCommitActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PushAndCommitActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< PushAndCommitActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< PushAndCommitActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont8(Void const& _,int loopDepth) 
	{
															#line 481 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (g_network->check_yield(g_network->getCurrentTask()))
															#line 2725 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 482 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Void> __when_expr_5 = delay(0, g_network->getCurrentTask());
															#line 482 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
															#line 2731 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			static_cast<PushAndCommitActor*>(this)->actor_wait_state = 6;
															#line 482 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< PushAndCommitActor, 5, Void >*>(static_cast<PushAndCommitActor*>(this)));
															#line 2735 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont8(Void && _,int loopDepth) 
	{
															#line 481 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (g_network->check_yield(g_network->getCurrentTask()))
															#line 2749 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 482 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Void> __when_expr_5 = delay(0, g_network->getCurrentTask());
															#line 482 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont8when1(__when_expr_5.get(), loopDepth); };
															#line 2755 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			static_cast<PushAndCommitActor*>(this)->actor_wait_state = 6;
															#line 482 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< PushAndCommitActor, 5, Void >*>(static_cast<PushAndCommitActor*>(this)));
															#line 2759 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<PushAndCommitActor*>(this)->actor_wait_state > 0) static_cast<PushAndCommitActor*>(this)->actor_wait_state = 0;
		static_cast<PushAndCommitActor*>(this)->ActorCallback< PushAndCommitActor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PushAndCommitActor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< PushAndCommitActor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< PushAndCommitActor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 485 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->updatePopped(poppedPages * sizeof(Page));
															#line 491 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		committed.send(Void());
															#line 2850 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont12(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont8when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<PushAndCommitActor*>(this)->actor_wait_state > 0) static_cast<PushAndCommitActor*>(this)->actor_wait_state = 0;
		static_cast<PushAndCommitActor*>(this)->ActorCallback< PushAndCommitActor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< PushAndCommitActor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< PushAndCommitActor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont8when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< PushAndCommitActor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont12(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	RawDiskQueue_TwoFiles* self;
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Standalone<StringRef> pageData;
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	StringBuffer* pageMem;
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	uint64_t poppedPages;
															#line 441 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Promise<Void> pushing, committed;
															#line 442 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Promise<Void> errorPromise;
															#line 443 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	std::string filename;
															#line 444 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	UID dbgid;
															#line 445 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	std::vector<Reference<SyncQueue>> syncFiles;
															#line 446 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Future<Void> lastCommit;
															#line 2975 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via pushAndCommit()
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class PushAndCommitActor final : public Actor<Void>, public ActorCallback< PushAndCommitActor, 0, Void >, public ActorCallback< PushAndCommitActor, 1, Future<Void> >, public ActorCallback< PushAndCommitActor, 2, Void >, public ActorCallback< PushAndCommitActor, 3, Void >, public ActorCallback< PushAndCommitActor, 4, Void >, public ActorCallback< PushAndCommitActor, 5, Void >, public FastAllocated<PushAndCommitActor>, public PushAndCommitActorState<PushAndCommitActor> {
															#line 2980 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<PushAndCommitActor>::operator new;
	using FastAllocated<PushAndCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2904667785399445760UL, 4401810060824131072UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< PushAndCommitActor, 0, Void >;
friend struct ActorCallback< PushAndCommitActor, 1, Future<Void> >;
friend struct ActorCallback< PushAndCommitActor, 2, Void >;
friend struct ActorCallback< PushAndCommitActor, 3, Void >;
friend struct ActorCallback< PushAndCommitActor, 4, Void >;
friend struct ActorCallback< PushAndCommitActor, 5, Void >;
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	PushAndCommitActor(RawDiskQueue_TwoFiles* const& self,Standalone<StringRef> const& pageData,StringBuffer* const& pageMem,uint64_t const& poppedPages) 
															#line 3002 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Void>(),
		   PushAndCommitActorState<PushAndCommitActor>(self, pageData, pageMem, poppedPages),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("pushAndCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3287611057907801856UL, 17276513268045268480UL);
		ActorExecutionContextHelper __helper(static_cast<PushAndCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("pushAndCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("pushAndCommit", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
static Future<Void> pushAndCommit( RawDiskQueue_TwoFiles* const& self, Standalone<StringRef> const& pageData, StringBuffer* const& pageMem, uint64_t const& poppedPages ) {
															#line 437 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Void>(new PushAndCommitActor(self, pageData, pageMem, poppedPages));
															#line 3025 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 511 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

	void updatePopped(int64_t popped) {
		int64_t pop0 = std::min(popped, files[0].size - files[0].popped);
		files[0].popped += pop0;
		files[1].popped += popped - pop0;
	}

	// Set the starting point of the ring buffer, i.e., the first useful page to be read (and poped)
																#line 3037 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via setPoppedPage()
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class SetPoppedPageActor>
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class SetPoppedPageActorState {
															#line 3043 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	SetPoppedPageActorState(RawDiskQueue_TwoFiles* const& self,int const& file,int64_t const& page,int64_t const& debugSeq) 
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   file(file),
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   page(page),
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   debugSeq(debugSeq)
															#line 3056 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("setPoppedPage", reinterpret_cast<unsigned long>(this));

	}
	~SetPoppedPageActorState() 
	{
		fdb_probe_actor_destroy("setPoppedPage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 520 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->files[file].popped = page * sizeof(Page);
															#line 521 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (file)
															#line 3073 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 522 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				self->files[0].popped = self->files[0].size;
															#line 3077 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
			else
			{
															#line 524 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				self->files[1].popped = 0;
															#line 3083 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 525 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->dbg_file0BeginSeq = debugSeq - self->files[1].popped - self->files[0].popped;
															#line 531 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (file == 1)
															#line 3089 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 532 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				StrictFuture<Void> __when_expr_0 = self->truncateFile(self, 0, 0);
															#line 532 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (static_cast<SetPoppedPageActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3095 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<SetPoppedPageActor*>(this)->actor_wait_state = 1;
															#line 532 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< SetPoppedPageActor, 0, Void >*>(static_cast<SetPoppedPageActor*>(this)));
															#line 3100 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~SetPoppedPageActorState();
		static_cast<SetPoppedPageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 534 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<SetPoppedPageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~SetPoppedPageActorState(); static_cast<SetPoppedPageActor*>(this)->destroy(); return 0; }
															#line 3128 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<SetPoppedPageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~SetPoppedPageActorState();
		static_cast<SetPoppedPageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<SetPoppedPageActor*>(this)->actor_wait_state > 0) static_cast<SetPoppedPageActor*>(this)->actor_wait_state = 0;
		static_cast<SetPoppedPageActor*>(this)->ActorCallback< SetPoppedPageActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< SetPoppedPageActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("setPoppedPage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetPoppedPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPoppedPage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< SetPoppedPageActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("setPoppedPage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<SetPoppedPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPoppedPage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< SetPoppedPageActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("setPoppedPage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<SetPoppedPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("setPoppedPage", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	RawDiskQueue_TwoFiles* self;
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int file;
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int64_t page;
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int64_t debugSeq;
															#line 3231 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via setPoppedPage()
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class SetPoppedPageActor final : public Actor<Void>, public ActorCallback< SetPoppedPageActor, 0, Void >, public FastAllocated<SetPoppedPageActor>, public SetPoppedPageActorState<SetPoppedPageActor> {
															#line 3236 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<SetPoppedPageActor>::operator new;
	using FastAllocated<SetPoppedPageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(9973013603805990656UL, 11400839531636927232UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< SetPoppedPageActor, 0, Void >;
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	SetPoppedPageActor(RawDiskQueue_TwoFiles* const& self,int const& file,int64_t const& page,int64_t const& debugSeq) 
															#line 3253 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Void>(),
		   SetPoppedPageActorState<SetPoppedPageActor>(self, file, page, debugSeq),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("setPoppedPage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13260590622798659328UL, 12877355854868673280UL);
		ActorExecutionContextHelper __helper(static_cast<SetPoppedPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("setPoppedPage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("setPoppedPage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< SetPoppedPageActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
[[nodiscard]] static Future<Void> setPoppedPage( RawDiskQueue_TwoFiles* const& self, int const& file, int64_t const& page, int64_t const& debugSeq ) {
															#line 519 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Void>(new SetPoppedPageActor(self, file, page, debugSeq));
															#line 3285 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 536 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

																#line 3290 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via openFiles()
															#line 537 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class OpenFilesActor>
															#line 537 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class OpenFilesActorState {
															#line 3296 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 537 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	OpenFilesActorState(RawDiskQueue_TwoFiles* const& self) 
															#line 537 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 537 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 538 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   fs()
															#line 3305 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("openFiles", reinterpret_cast<unsigned long>(this));

	}
	~OpenFilesActorState() 
	{
		fdb_probe_actor_destroy("openFiles", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 539 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			fs.reserve(2);
															#line 540 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			for(int i = 0;i < 2;i++) {
															#line 541 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				fs.push_back(IAsyncFileSystem::filesystem()->open(self->filename(i), IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_UNBUFFERED | IAsyncFile::OPEN_LOCK, 0));
															#line 3324 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 545 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Void> __when_expr_0 = waitForAllReady(fs);
															#line 545 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (static_cast<OpenFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3330 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<OpenFilesActor*>(this)->actor_wait_state = 1;
															#line 545 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< OpenFilesActor, 0, Void >*>(static_cast<OpenFilesActor*>(this)));
															#line 3335 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~OpenFilesActorState();
		static_cast<OpenFilesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 551 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!fs[0].isError() && !fs[1].isError())
															#line 3358 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
			loopDepth = a_body1cont3(loopDepth);
		}
		else
		{
															#line 553 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (fs[0].isError() && fs[0].getError().code() == error_code_file_not_found && fs[1].isError() && fs[1].getError().code() == error_code_file_not_found)
															#line 3366 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 557 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				TraceEvent("DiskQueueCreate").detail("File0", self->filename(0));
															#line 558 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				for(int i = 0;i < 2;i++) {
															#line 559 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					fs[i] = IAsyncFileSystem::filesystem()->open( self->filename(i), IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_UNBUFFERED | IAsyncFile::OPEN_LOCK, 0600);
															#line 3374 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				}
															#line 566 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				StrictFuture<Void> __when_expr_1 = waitForAll(fs);
															#line 566 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (static_cast<OpenFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3380 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<OpenFilesActor*>(this)->actor_wait_state = 2;
															#line 566 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OpenFilesActor, 1, Void >*>(static_cast<OpenFilesActor*>(this)));
															#line 3385 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 571 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (!fs[0].isError() || (fs[1].isError() && fs[1].getError().code() != error_code_file_not_found))
															#line 3392 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				{
															#line 572 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					return a_body1Catch1(fs[1].getError(), loopDepth);
															#line 3396 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				}
				else
				{
															#line 574 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					return a_body1Catch1(fs[0].getError(), loopDepth);
															#line 3402 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				}
			}
		}

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 551 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!fs[0].isError() && !fs[1].isError())
															#line 3413 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
			loopDepth = a_body1cont3(loopDepth);
		}
		else
		{
															#line 553 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (fs[0].isError() && fs[0].getError().code() == error_code_file_not_found && fs[1].isError() && fs[1].getError().code() == error_code_file_not_found)
															#line 3421 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 557 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				TraceEvent("DiskQueueCreate").detail("File0", self->filename(0));
															#line 558 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				for(int i = 0;i < 2;i++) {
															#line 559 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					fs[i] = IAsyncFileSystem::filesystem()->open( self->filename(i), IAsyncFile::OPEN_ATOMIC_WRITE_AND_CREATE | IAsyncFile::OPEN_CREATE | IAsyncFile::OPEN_READWRITE | IAsyncFile::OPEN_UNCACHED | IAsyncFile::OPEN_UNBUFFERED | IAsyncFile::OPEN_LOCK, 0600);
															#line 3429 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				}
															#line 566 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				StrictFuture<Void> __when_expr_1 = waitForAll(fs);
															#line 566 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (static_cast<OpenFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3435 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
				static_cast<OpenFilesActor*>(this)->actor_wait_state = 2;
															#line 566 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< OpenFilesActor, 1, Void >*>(static_cast<OpenFilesActor*>(this)));
															#line 3440 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 571 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (!fs[0].isError() || (fs[1].isError() && fs[1].getError().code() != error_code_file_not_found))
															#line 3447 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				{
															#line 572 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					return a_body1Catch1(fs[1].getError(), loopDepth);
															#line 3451 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				}
				else
				{
															#line 574 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					return a_body1Catch1(fs[0].getError(), loopDepth);
															#line 3457 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				}
			}
		}

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<OpenFilesActor*>(this)->actor_wait_state > 0) static_cast<OpenFilesActor*>(this)->actor_wait_state = 0;
		static_cast<OpenFilesActor*>(this)->ActorCallback< OpenFilesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OpenFilesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("openFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< OpenFilesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("openFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< OpenFilesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("openFiles", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFiles", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 581 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		std::vector<Future<Void>> syncs;
															#line 582 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		syncs.reserve(fs.size());
															#line 583 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		for(int i = 0;i < fs.size();i++) {
															#line 584 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			syncs.push_back(fs[i].get()->sync());
															#line 3549 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 585 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAll(syncs);
															#line 585 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (static_cast<OpenFilesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 3555 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
		static_cast<OpenFilesActor*>(this)->actor_wait_state = 3;
															#line 585 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< OpenFilesActor, 2, Void >*>(static_cast<OpenFilesActor*>(this)));
															#line 3560 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont4(int loopDepth) 
	{
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<OpenFilesActor*>(this)->actor_wait_state > 0) static_cast<OpenFilesActor*>(this)->actor_wait_state = 0;
		static_cast<OpenFilesActor*>(this)->ActorCallback< OpenFilesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OpenFilesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("openFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< OpenFilesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("openFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< OpenFilesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("openFiles", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFiles", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont10(Void const& _,int loopDepth) 
	{
															#line 588 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		for(int i = 0;i < 2;i++) {
															#line 589 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->files[i].setFile(fs[i].get());
															#line 3664 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 591 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<OpenFilesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OpenFilesActorState(); static_cast<OpenFilesActor*>(this)->destroy(); return 0; }
															#line 3668 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<OpenFilesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OpenFilesActorState();
		static_cast<OpenFilesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont10(Void && _,int loopDepth) 
	{
															#line 588 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		for(int i = 0;i < 2;i++) {
															#line 589 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->files[i].setFile(fs[i].get());
															#line 3682 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 591 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<OpenFilesActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~OpenFilesActorState(); static_cast<OpenFilesActor*>(this)->destroy(); return 0; }
															#line 3686 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<OpenFilesActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~OpenFilesActorState();
		static_cast<OpenFilesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont10(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont10(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<OpenFilesActor*>(this)->actor_wait_state > 0) static_cast<OpenFilesActor*>(this)->actor_wait_state = 0;
		static_cast<OpenFilesActor*>(this)->ActorCallback< OpenFilesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< OpenFilesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("openFiles", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFiles", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< OpenFilesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("openFiles", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFiles", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< OpenFilesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("openFiles", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("openFiles", reinterpret_cast<unsigned long>(this), 2);

	}
															#line 537 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	RawDiskQueue_TwoFiles* self;
															#line 538 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	std::vector<Future<Reference<IAsyncFile>>> fs;
															#line 3773 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via openFiles()
															#line 537 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class OpenFilesActor final : public Actor<Void>, public ActorCallback< OpenFilesActor, 0, Void >, public ActorCallback< OpenFilesActor, 1, Void >, public ActorCallback< OpenFilesActor, 2, Void >, public FastAllocated<OpenFilesActor>, public OpenFilesActorState<OpenFilesActor> {
															#line 3778 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<OpenFilesActor>::operator new;
	using FastAllocated<OpenFilesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(3596345961443774720UL, 3679748040946690048UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< OpenFilesActor, 0, Void >;
friend struct ActorCallback< OpenFilesActor, 1, Void >;
friend struct ActorCallback< OpenFilesActor, 2, Void >;
															#line 537 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	OpenFilesActor(RawDiskQueue_TwoFiles* const& self) 
															#line 3797 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Void>(),
		   OpenFilesActorState<OpenFilesActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("openFiles", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(11754153581846317824UL, 12385251554521197568UL);
		ActorExecutionContextHelper __helper(static_cast<OpenFilesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("openFiles");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("openFiles", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< OpenFilesActor, 0, Void >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< OpenFilesActor, 1, Void >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< OpenFilesActor, 2, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 537 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
[[nodiscard]] static Future<Void> openFiles( RawDiskQueue_TwoFiles* const& self ) {
															#line 537 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Void>(new OpenFilesActor(self));
															#line 3831 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 593 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

																#line 3836 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via shutdown()
															#line 594 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class ShutdownActor>
															#line 594 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ShutdownActorState {
															#line 3842 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 594 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ShutdownActorState(RawDiskQueue_TwoFiles* const& self,bool const& deleteFiles) 
															#line 594 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 594 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 594 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   deleteFiles(deleteFiles),
															#line 596 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   error(success())
															#line 3853 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("shutdown", reinterpret_cast<unsigned long>(this));

	}
	~ShutdownActorState() 
	{
		fdb_probe_actor_destroy("shutdown", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 598 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				StrictFuture<Void> __when_expr_0 = success(errorOr(self->lastCommit));
															#line 598 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 3871 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				static_cast<ShutdownActor*>(this)->actor_wait_state = 1;
															#line 598 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ShutdownActor, 0, Void >*>(static_cast<ShutdownActor*>(this)));
															#line 3875 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<ShutdownActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 623 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (error.code() != error_code_actor_cancelled)
															#line 3903 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 624 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (self->stopped.canBeSet())
															#line 3907 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 625 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				self->stopped.send(Void());
															#line 3911 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 626 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (self->error.canBeSet())
															#line 3915 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 627 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				self->error.send(Never());
															#line 3919 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 628 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			delete self;
															#line 3923 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
		loopDepth = a_body1cont14(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 617 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			TraceEvent(SevError, "DiskQueueShutdownError", self->dbgid) .errorUnsuppressed(e) .detail("Reason", e.code() == error_code_platform_error ? "could not delete database" : "unknown");
															#line 620 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			error = e;
															#line 3936 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 601 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->onSafeToDestruct();
															#line 601 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 3953 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<ShutdownActor*>(this)->actor_wait_state = 2;
															#line 601 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShutdownActor, 1, Void >*>(static_cast<ShutdownActor*>(this)));
															#line 3957 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 601 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->onSafeToDestruct();
															#line 601 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 3968 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<ShutdownActor*>(this)->actor_wait_state = 2;
															#line 601 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ShutdownActor, 1, Void >*>(static_cast<ShutdownActor*>(this)));
															#line 3972 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ShutdownActor*>(this)->actor_wait_state > 0) static_cast<ShutdownActor*>(this)->actor_wait_state = 0;
		static_cast<ShutdownActor*>(this)->ActorCallback< ShutdownActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShutdownActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shutdown", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShutdownActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shutdown", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ShutdownActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shutdown", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShutdownActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shutdown", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ShutdownActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shutdown", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShutdownActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shutdown", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 603 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		for(int i = 0;i < 2;i++) {
															#line 604 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->files[i].f.clear();
															#line 4058 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 606 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (deleteFiles)
															#line 4062 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 607 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			TraceEvent("DiskQueueShutdownDeleting", self->dbgid) .detail("File0", self->filename(0)) .detail("File1", self->filename(1));
															#line 610 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Void> __when_expr_2 = IAsyncFileSystem::filesystem()->incrementalDeleteFile(self->filename(0), false);
															#line 610 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
															#line 4070 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			static_cast<ShutdownActor*>(this)->actor_wait_state = 3;
															#line 610 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ShutdownActor, 2, Void >*>(static_cast<ShutdownActor*>(this)));
															#line 4074 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 603 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		for(int i = 0;i < 2;i++) {
															#line 604 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->files[i].f.clear();
															#line 4090 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 606 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (deleteFiles)
															#line 4094 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 607 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			TraceEvent("DiskQueueShutdownDeleting", self->dbgid) .detail("File0", self->filename(0)) .detail("File1", self->filename(1));
															#line 610 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Void> __when_expr_2 = IAsyncFileSystem::filesystem()->incrementalDeleteFile(self->filename(0), false);
															#line 610 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
															#line 4102 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			static_cast<ShutdownActor*>(this)->actor_wait_state = 3;
															#line 610 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ShutdownActor, 2, Void >*>(static_cast<ShutdownActor*>(this)));
															#line 4106 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ShutdownActor*>(this)->actor_wait_state > 0) static_cast<ShutdownActor*>(this)->actor_wait_state = 0;
		static_cast<ShutdownActor*>(this)->ActorCallback< ShutdownActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShutdownActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shutdown", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShutdownActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shutdown", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ShutdownActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shutdown", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShutdownActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shutdown", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ShutdownActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shutdown", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShutdownActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shutdown", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 613 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		TraceEvent("DiskQueueShutdownComplete", self->dbgid) .detail("DeleteFiles", deleteFiles) .detail("File0", self->filename(0));
															#line 4195 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont9(loopDepth);

		return loopDepth;
	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 611 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_3 = IAsyncFileSystem::filesystem()->incrementalDeleteFile(self->filename(1), true);
															#line 611 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
															#line 4206 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<ShutdownActor*>(this)->actor_wait_state = 4;
															#line 611 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ShutdownActor, 3, Void >*>(static_cast<ShutdownActor*>(this)));
															#line 4210 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 611 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_3 = IAsyncFileSystem::filesystem()->incrementalDeleteFile(self->filename(1), true);
															#line 611 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont6when1(__when_expr_3.get(), loopDepth); };
															#line 4221 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<ShutdownActor*>(this)->actor_wait_state = 4;
															#line 611 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ShutdownActor, 3, Void >*>(static_cast<ShutdownActor*>(this)));
															#line 4225 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ShutdownActor*>(this)->actor_wait_state > 0) static_cast<ShutdownActor*>(this)->actor_wait_state = 0;
		static_cast<ShutdownActor*>(this)->ActorCallback< ShutdownActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShutdownActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shutdown", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShutdownActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shutdown", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ShutdownActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shutdown", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShutdownActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shutdown", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ShutdownActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shutdown", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShutdownActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shutdown", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont7(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont7(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont6when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ShutdownActor*>(this)->actor_wait_state > 0) static_cast<ShutdownActor*>(this)->actor_wait_state = 0;
		static_cast<ShutdownActor*>(this)->ActorCallback< ShutdownActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ShutdownActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("shutdown", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShutdownActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shutdown", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ShutdownActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("shutdown", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ShutdownActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont6when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shutdown", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ShutdownActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("shutdown", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ShutdownActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("shutdown", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont9(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont14(int loopDepth) 
	{
															#line 594 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		delete static_cast<ShutdownActor*>(this);
															#line 4409 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 594 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	RawDiskQueue_TwoFiles* self;
															#line 594 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	bool deleteFiles;
															#line 596 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Error error;
															#line 4420 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via shutdown()
															#line 594 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ShutdownActor final : public Actor<void>, public ActorCallback< ShutdownActor, 0, Void >, public ActorCallback< ShutdownActor, 1, Void >, public ActorCallback< ShutdownActor, 2, Void >, public ActorCallback< ShutdownActor, 3, Void >, public FastAllocated<ShutdownActor>, public ShutdownActorState<ShutdownActor> {
															#line 4425 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<ShutdownActor>::operator new;
	using FastAllocated<ShutdownActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(5164931864318084096UL, 7541216684517391360UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< ShutdownActor, 0, Void >;
friend struct ActorCallback< ShutdownActor, 1, Void >;
friend struct ActorCallback< ShutdownActor, 2, Void >;
friend struct ActorCallback< ShutdownActor, 3, Void >;
															#line 594 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ShutdownActor(RawDiskQueue_TwoFiles* const& self,bool const& deleteFiles) 
															#line 4445 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<void>(),
		   ShutdownActorState<ShutdownActor>(self, deleteFiles),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("shutdown", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3873605778738212608UL, 11672863135119866112UL);
		ActorExecutionContextHelper __helper(static_cast<ShutdownActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("shutdown");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("shutdown", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 594 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
static void shutdown( RawDiskQueue_TwoFiles* const& self, bool const& deleteFiles ) {
															#line 594 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	new ShutdownActor(self, deleteFiles);
															#line 4468 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 631 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

	// Return the most recently written page, the page with largest seq number
																#line 4474 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via readFirstAndLastPages()
															#line 633 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class ReadFirstAndLastPagesActor>
															#line 633 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReadFirstAndLastPagesActorState {
															#line 4480 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 633 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReadFirstAndLastPagesActorState(RawDiskQueue_TwoFiles* const& self,compare_pages const& compare) 
															#line 633 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 633 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 633 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   compare(compare),
															#line 635 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   trackMe(self)
															#line 4491 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("readFirstAndLastPages", reinterpret_cast<unsigned long>(this));

	}
	~ReadFirstAndLastPagesActorState() 
	{
		fdb_probe_actor_destroy("readFirstAndLastPages", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 639 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				StrictFuture<Void> __when_expr_0 = openFiles(self);
															#line 639 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 4509 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 1;
															#line 639 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadFirstAndLastPagesActor, 0, Void >*>(static_cast<ReadFirstAndLastPagesActor*>(this)));
															#line 4513 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadFirstAndLastPagesActorState();
		static_cast<ReadFirstAndLastPagesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 735 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			bool ok = e.code() == error_code_file_not_found;
															#line 736 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			TraceEvent(ok ? SevInfo : SevError, "RDQReadFirstAndLastPagesError", self->dbgid) .errorUnsuppressed(e) .detail("File0Name", self->files[0].dbgFilename);
															#line 739 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!self->error.isSet())
															#line 4547 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 740 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				self->error.sendError(e);
															#line 4551 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 741 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 4555 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 642 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		std::vector<Future<int64_t>> fsize;
															#line 643 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		fsize.reserve(2);
															#line 644 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		for(int i = 0;i < 2;i++) {
															#line 645 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			fsize.push_back(self->files[i].f->size());
															#line 4575 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 646 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<std::vector<int64_t>> __when_expr_1 = getAll(fsize);
															#line 646 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 4581 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 2;
															#line 646 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadFirstAndLastPagesActor, 1, std::vector<int64_t> >*>(static_cast<ReadFirstAndLastPagesActor*>(this)));
															#line 4585 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 642 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		std::vector<Future<int64_t>> fsize;
															#line 643 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		fsize.reserve(2);
															#line 644 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		for(int i = 0;i < 2;i++) {
															#line 645 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			fsize.push_back(self->files[i].f->size());
															#line 4600 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 646 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<std::vector<int64_t>> __when_expr_1 = getAll(fsize);
															#line 646 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 4606 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 2;
															#line 646 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadFirstAndLastPagesActor, 1, std::vector<int64_t> >*>(static_cast<ReadFirstAndLastPagesActor*>(this)));
															#line 4610 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state > 0) static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFirstAndLastPagesActor*>(this)->ActorCallback< ReadFirstAndLastPagesActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFirstAndLastPagesActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadFirstAndLastPagesActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadFirstAndLastPagesActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(std::vector<int64_t> const& file_sizes,int loopDepth) 
	{
															#line 647 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		for(int i = 0;i < 2;i++) {
															#line 649 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->files[i].size = file_sizes[i] - file_sizes[i] % sizeof(Page);
															#line 650 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(self->files[i].size % sizeof(Page) == 0);
															#line 4698 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 654 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		std::vector<Future<int>> reads;
															#line 655 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		for(int i = 0;i < 2;i++) {
															#line 656 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (self->files[i].size > 0)
															#line 4706 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 657 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				reads.push_back(self->files[i].f->read(self->firstPages[i], sizeof(Page), 0));
															#line 4710 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
		}
															#line 658 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAllReadyThenThrow(reads);
															#line 658 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
															#line 4717 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 3;
															#line 658 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadFirstAndLastPagesActor, 2, Void >*>(static_cast<ReadFirstAndLastPagesActor*>(this)));
															#line 4721 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(std::vector<int64_t> && file_sizes,int loopDepth) 
	{
															#line 647 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		for(int i = 0;i < 2;i++) {
															#line 649 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->files[i].size = file_sizes[i] - file_sizes[i] % sizeof(Page);
															#line 650 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(self->files[i].size % sizeof(Page) == 0);
															#line 4734 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 654 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		std::vector<Future<int>> reads;
															#line 655 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		for(int i = 0;i < 2;i++) {
															#line 656 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (self->files[i].size > 0)
															#line 4742 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 657 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				reads.push_back(self->files[i].f->read(self->firstPages[i], sizeof(Page), 0));
															#line 4746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
		}
															#line 658 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_2 = waitForAllReadyThenThrow(reads);
															#line 658 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch2(__when_expr_2.getError(), loopDepth); else return a_body1cont3when1(__when_expr_2.get(), loopDepth); };
															#line 4753 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 3;
															#line 658 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadFirstAndLastPagesActor, 2, Void >*>(static_cast<ReadFirstAndLastPagesActor*>(this)));
															#line 4757 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<int64_t> const& file_sizes,int loopDepth) 
	{
		loopDepth = a_body1cont3(file_sizes, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(std::vector<int64_t> && file_sizes,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(file_sizes), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state > 0) static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFirstAndLastPagesActor*>(this)->ActorCallback< ReadFirstAndLastPagesActor, 1, std::vector<int64_t> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFirstAndLastPagesActor, 1, std::vector<int64_t> >*,std::vector<int64_t> const& value) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadFirstAndLastPagesActor, 1, std::vector<int64_t> >*,std::vector<int64_t> && value) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadFirstAndLastPagesActor, 1, std::vector<int64_t> >*,Error err) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 661 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (compare(self->firstPages[1], self->firstPages[0]))
															#line 4841 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 662 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			std::swap(self->firstPages[0], self->firstPages[1]);
															#line 663 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			std::swap(self->files[0], self->files[1]);
															#line 4847 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 666 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!compare(self->firstPages[0], self->firstPages[0]))
															#line 4851 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 667 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			memset(self->firstPages[0], 0xFF, sizeof(Page));
															#line 4855 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 670 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!compare(self->firstPages[1], self->firstPages[1]))
															#line 4859 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 676 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			std::vector<Future<Void>> truncates;
															#line 677 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			for(int i = 0;i < 2;++i) {
															#line 678 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (self->files[i].size > 0)
															#line 4867 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				{
															#line 679 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					truncates.push_back(self->truncateFile(self, i, 0));
															#line 4871 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				}
			}
															#line 681 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Void> __when_expr_3 = waitForAll(truncates);
															#line 681 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
															#line 4878 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 4;
															#line 681 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReadFirstAndLastPagesActor, 3, Void >*>(static_cast<ReadFirstAndLastPagesActor*>(this)));
															#line 4882 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 661 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (compare(self->firstPages[1], self->firstPages[0]))
															#line 4896 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 662 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			std::swap(self->firstPages[0], self->firstPages[1]);
															#line 663 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			std::swap(self->files[0], self->files[1]);
															#line 4902 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 666 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!compare(self->firstPages[0], self->firstPages[0]))
															#line 4906 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 667 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			memset(self->firstPages[0], 0xFF, sizeof(Page));
															#line 4910 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 670 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!compare(self->firstPages[1], self->firstPages[1]))
															#line 4914 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 676 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			std::vector<Future<Void>> truncates;
															#line 677 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			for(int i = 0;i < 2;++i) {
															#line 678 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (self->files[i].size > 0)
															#line 4922 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				{
															#line 679 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					truncates.push_back(self->truncateFile(self, i, 0));
															#line 4926 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				}
			}
															#line 681 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Void> __when_expr_3 = waitForAll(truncates);
															#line 681 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch2(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
															#line 4933 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 4;
															#line 681 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReadFirstAndLastPagesActor, 3, Void >*>(static_cast<ReadFirstAndLastPagesActor*>(this)));
															#line 4937 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont9(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state > 0) static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFirstAndLastPagesActor*>(this)->ActorCallback< ReadFirstAndLastPagesActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFirstAndLastPagesActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadFirstAndLastPagesActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadFirstAndLastPagesActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont9(int loopDepth) 
	{
															#line 694 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		begin = 0;
															#line 695 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		end = self->files[1].size / sizeof(Page);
															#line 696 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		middlePageAllocation = makeAlignedString(sizeof(Page), sizeof(Page));
															#line 697 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		middlePage = (Page*)middlePageAllocation.begin();
															#line 698 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		;
															#line 5034 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont9loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont12(Void const& _,int loopDepth) 
	{
															#line 683 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->files[0].popped = self->files[0].size;
															#line 684 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->files[1].popped = 0;
															#line 685 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		memset(self->firstPages[1], 0xFF, sizeof(Page));
															#line 686 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->writingPos = 0;
															#line 687 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->readingFile = 2;
															#line 688 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadFirstAndLastPagesActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(Standalone<StringRef>()); this->~ReadFirstAndLastPagesActorState(); static_cast<ReadFirstAndLastPagesActor*>(this)->destroy(); return 0; }
															#line 5053 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadFirstAndLastPagesActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(Standalone<StringRef>());
		this->~ReadFirstAndLastPagesActorState();
		static_cast<ReadFirstAndLastPagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont12(Void && _,int loopDepth) 
	{
															#line 683 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->files[0].popped = self->files[0].size;
															#line 684 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->files[1].popped = 0;
															#line 685 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		memset(self->firstPages[1], 0xFF, sizeof(Page));
															#line 686 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->writingPos = 0;
															#line 687 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->readingFile = 2;
															#line 688 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadFirstAndLastPagesActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(Standalone<StringRef>()); this->~ReadFirstAndLastPagesActorState(); static_cast<ReadFirstAndLastPagesActor*>(this)->destroy(); return 0; }
															#line 5075 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadFirstAndLastPagesActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(Standalone<StringRef>());
		this->~ReadFirstAndLastPagesActorState();
		static_cast<ReadFirstAndLastPagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont12(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont12(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state > 0) static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFirstAndLastPagesActor*>(this)->ActorCallback< ReadFirstAndLastPagesActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFirstAndLastPagesActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ReadFirstAndLastPagesActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ReadFirstAndLastPagesActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont15(int loopDepth) 
	{
															#line 721 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<int> __when_expr_5 = self->files[1].f->read(middlePage, sizeof(Page), (begin + 1) * sizeof(Page));
															#line 721 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch2(__when_expr_5.getError(), loopDepth); else return a_body1cont15when1(__when_expr_5.get(), loopDepth); };
															#line 5164 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 6;
															#line 721 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< ReadFirstAndLastPagesActor, 5, int >*>(static_cast<ReadFirstAndLastPagesActor*>(this)));
															#line 5168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont9loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1(int loopDepth) 
	{
															#line 698 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!(begin + 1 != end))
															#line 5184 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
			return a_body1cont9break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 699 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		middle = (begin + end) / 2;
															#line 700 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(middle > begin && middle < end);
															#line 702 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<int> __when_expr_4 = self->files[1].f->read(middlePage, sizeof(Page), middle * sizeof(Page));
															#line 702 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch2(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont9loopBody1when1(__when_expr_4.get(), loopDepth); };
															#line 5196 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 5;
															#line 702 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< ReadFirstAndLastPagesActor, 4, int >*>(static_cast<ReadFirstAndLastPagesActor*>(this)));
															#line 5200 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont9break1(int loopDepth) 
	{
		try {
			return a_body1cont15(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch2(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch2(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont9loopBody1cont1(int const& len,int loopDepth) 
	{
															#line 703 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(len == sizeof(Page));
															#line 705 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		bool middleValid = compare(self->firstPages[1], middlePage);
															#line 707 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		TraceEvent("RDQBS", self->dbgid) .detail("Begin", begin) .detail("End", end) .detail("Middle", middle) .detail("Valid", middleValid) .detail("File0Name", self->files[0].dbgFilename);
															#line 714 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (middleValid)
															#line 5228 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 715 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			begin = middle;
															#line 5232 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
		else
		{
															#line 717 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			end = middle;
															#line 5238 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont9loopHead1(0);

		return loopDepth;
	}
	int a_body1cont9loopBody1cont1(int && len,int loopDepth) 
	{
															#line 703 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(len == sizeof(Page));
															#line 705 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		bool middleValid = compare(self->firstPages[1], middlePage);
															#line 707 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		TraceEvent("RDQBS", self->dbgid) .detail("Begin", begin) .detail("End", end) .detail("Middle", middle) .detail("Valid", middleValid) .detail("File0Name", self->files[0].dbgFilename);
															#line 714 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (middleValid)
															#line 5254 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 715 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			begin = middle;
															#line 5258 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
		else
		{
															#line 717 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			end = middle;
															#line 5264 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
		if (loopDepth == 0) return a_body1cont9loopHead1(0);

		return loopDepth;
	}
	int a_body1cont9loopBody1when1(int const& len,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont1(len, loopDepth);

		return loopDepth;
	}
	int a_body1cont9loopBody1when1(int && len,int loopDepth) 
	{
		loopDepth = a_body1cont9loopBody1cont1(std::move(len), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state > 0) static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFirstAndLastPagesActor*>(this)->ActorCallback< ReadFirstAndLastPagesActor, 4, int >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFirstAndLastPagesActor, 4, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont9loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< ReadFirstAndLastPagesActor, 4, int >*,int && value) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont9loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< ReadFirstAndLastPagesActor, 4, int >*,Error err) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont15cont1(int const& len1,int loopDepth) 
	{
															#line 722 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(!(len1 == sizeof(Page) && compare(self->firstPages[1], middlePage)));
															#line 725 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<int> __when_expr_6 = self->files[1].f->read(middlePage, sizeof(Page), begin * sizeof(Page));
															#line 725 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont15cont1when1(__when_expr_6.get(), loopDepth); };
															#line 5353 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 7;
															#line 725 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ReadFirstAndLastPagesActor, 6, int >*>(static_cast<ReadFirstAndLastPagesActor*>(this)));
															#line 5357 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont15cont1(int && len1,int loopDepth) 
	{
															#line 722 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(!(len1 == sizeof(Page) && compare(self->firstPages[1], middlePage)));
															#line 725 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<int> __when_expr_6 = self->files[1].f->read(middlePage, sizeof(Page), begin * sizeof(Page));
															#line 725 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_6.isReady()) { if (__when_expr_6.isError()) return a_body1Catch2(__when_expr_6.getError(), loopDepth); else return a_body1cont15cont1when1(__when_expr_6.get(), loopDepth); };
															#line 5370 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 7;
															#line 725 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_6.addCallbackAndClear(static_cast<ActorCallback< ReadFirstAndLastPagesActor, 6, int >*>(static_cast<ReadFirstAndLastPagesActor*>(this)));
															#line 5374 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont15when1(int const& len1,int loopDepth) 
	{
		loopDepth = a_body1cont15cont1(len1, loopDepth);

		return loopDepth;
	}
	int a_body1cont15when1(int && len1,int loopDepth) 
	{
		loopDepth = a_body1cont15cont1(std::move(len1), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state > 0) static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFirstAndLastPagesActor*>(this)->ActorCallback< ReadFirstAndLastPagesActor, 5, int >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFirstAndLastPagesActor, 5, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont15when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< ReadFirstAndLastPagesActor, 5, int >*,int && value) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont15when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< ReadFirstAndLastPagesActor, 5, int >*,Error err) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 5);

	}
	int a_body1cont15cont2(int const& len2,int loopDepth) 
	{
															#line 726 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(len2 == sizeof(Page) && compare(self->firstPages[1], middlePage));
															#line 728 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		TraceEvent("RDQEndFound", self->dbgid) .detail("File0Name", self->files[0].dbgFilename) .detail("Pos", begin) .detail("FileSize", self->files[1].size);
															#line 733 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadFirstAndLastPagesActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(middlePageAllocation); this->~ReadFirstAndLastPagesActorState(); static_cast<ReadFirstAndLastPagesActor*>(this)->destroy(); return 0; }
															#line 5462 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadFirstAndLastPagesActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(std::move(middlePageAllocation)); // state_var_RVO
		this->~ReadFirstAndLastPagesActorState();
		static_cast<ReadFirstAndLastPagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont15cont2(int && len2,int loopDepth) 
	{
															#line 726 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(len2 == sizeof(Page) && compare(self->firstPages[1], middlePage));
															#line 728 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		TraceEvent("RDQEndFound", self->dbgid) .detail("File0Name", self->files[0].dbgFilename) .detail("Pos", begin) .detail("FileSize", self->files[1].size);
															#line 733 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadFirstAndLastPagesActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(middlePageAllocation); this->~ReadFirstAndLastPagesActorState(); static_cast<ReadFirstAndLastPagesActor*>(this)->destroy(); return 0; }
															#line 5478 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadFirstAndLastPagesActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(std::move(middlePageAllocation)); // state_var_RVO
		this->~ReadFirstAndLastPagesActorState();
		static_cast<ReadFirstAndLastPagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont15cont1when1(int const& len2,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(len2, loopDepth);

		return loopDepth;
	}
	int a_body1cont15cont1when1(int && len2,int loopDepth) 
	{
		loopDepth = a_body1cont15cont2(std::move(len2), loopDepth);

		return loopDepth;
	}
	void a_exitChoose7() 
	{
		if (static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state > 0) static_cast<ReadFirstAndLastPagesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadFirstAndLastPagesActor*>(this)->ActorCallback< ReadFirstAndLastPagesActor, 6, int >::remove();

	}
	void a_callback_fire(ActorCallback< ReadFirstAndLastPagesActor, 6, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont15cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_fire(ActorCallback< ReadFirstAndLastPagesActor, 6, int >*,int && value) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1cont15cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 6);

	}
	void a_callback_error(ActorCallback< ReadFirstAndLastPagesActor, 6, int >*,Error err) 
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 6);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose7();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), 6);

	}
															#line 633 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	RawDiskQueue_TwoFiles* self;
															#line 633 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	compare_pages compare;
															#line 635 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	TrackMe trackMe;
															#line 694 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int64_t begin;
															#line 695 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int64_t end;
															#line 696 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Standalone<StringRef> middlePageAllocation;
															#line 697 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Page* middlePage;
															#line 699 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int64_t middle;
															#line 5577 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via readFirstAndLastPages()
															#line 633 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReadFirstAndLastPagesActor final : public Actor<Standalone<StringRef>>, public ActorCallback< ReadFirstAndLastPagesActor, 0, Void >, public ActorCallback< ReadFirstAndLastPagesActor, 1, std::vector<int64_t> >, public ActorCallback< ReadFirstAndLastPagesActor, 2, Void >, public ActorCallback< ReadFirstAndLastPagesActor, 3, Void >, public ActorCallback< ReadFirstAndLastPagesActor, 4, int >, public ActorCallback< ReadFirstAndLastPagesActor, 5, int >, public ActorCallback< ReadFirstAndLastPagesActor, 6, int >, public FastAllocated<ReadFirstAndLastPagesActor>, public ReadFirstAndLastPagesActorState<ReadFirstAndLastPagesActor> {
															#line 5582 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<ReadFirstAndLastPagesActor>::operator new;
	using FastAllocated<ReadFirstAndLastPagesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1307962942216824064UL, 500287575818006272UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadFirstAndLastPagesActor, 0, Void >;
friend struct ActorCallback< ReadFirstAndLastPagesActor, 1, std::vector<int64_t> >;
friend struct ActorCallback< ReadFirstAndLastPagesActor, 2, Void >;
friend struct ActorCallback< ReadFirstAndLastPagesActor, 3, Void >;
friend struct ActorCallback< ReadFirstAndLastPagesActor, 4, int >;
friend struct ActorCallback< ReadFirstAndLastPagesActor, 5, int >;
friend struct ActorCallback< ReadFirstAndLastPagesActor, 6, int >;
															#line 633 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReadFirstAndLastPagesActor(RawDiskQueue_TwoFiles* const& self,compare_pages const& compare) 
															#line 5605 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   ReadFirstAndLastPagesActorState<ReadFirstAndLastPagesActor>(self, compare),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10266453685164386304UL, 7768601412247819264UL);
		ActorExecutionContextHelper __helper(static_cast<ReadFirstAndLastPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readFirstAndLastPages");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readFirstAndLastPages", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 633 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
static Future<Standalone<StringRef>> readFirstAndLastPages( RawDiskQueue_TwoFiles* const& self, compare_pages const& compare ) {
															#line 633 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Standalone<StringRef>>(new ReadFirstAndLastPagesActor(self, compare));
															#line 5628 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 744 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

	// Read nPages from pageOffset*sizeof(Page) offset in file self->files[file]
																#line 5634 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via read()
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class ReadActor>
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReadActorState {
															#line 5640 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReadActorState(RawDiskQueue_TwoFiles* const& self,int const& file,int const& pageOffset,int const& nPages) 
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   file(file),
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   pageOffset(pageOffset),
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   nPages(nPages),
															#line 750 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   trackMe(self),
															#line 751 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   bytesRequested(nPages * sizeof(Page)),
															#line 752 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   result(makeAlignedString(sizeof(Page), bytesRequested))
															#line 5659 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("read", reinterpret_cast<unsigned long>(this));

	}
	~ReadActorState() 
	{
		fdb_probe_actor_destroy("read", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 753 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (file == 1)
															#line 5674 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 754 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				ASSERT_WE_THINK(pageOffset * sizeof(Page) + bytesRequested <= self->writingPos);
															#line 5678 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 755 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<int> __when_expr_0 = self->files[file].f->read(mutateString(result), bytesRequested, pageOffset * sizeof(Page));
															#line 755 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 5684 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			static_cast<ReadActor*>(this)->actor_wait_state = 1;
															#line 755 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadActor, 0, int >*>(static_cast<ReadActor*>(this)));
															#line 5688 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadActorState();
		static_cast<ReadActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int const& bytesRead,int loopDepth) 
	{
															#line 757 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT_WE_THINK(bytesRead == bytesRequested);
															#line 758 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(result); this->~ReadActorState(); static_cast<ReadActor*>(this)->destroy(); return 0; }
															#line 5713 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(std::move(result)); // state_var_RVO
		this->~ReadActorState();
		static_cast<ReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(int && bytesRead,int loopDepth) 
	{
															#line 757 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT_WE_THINK(bytesRead == bytesRequested);
															#line 758 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(result); this->~ReadActorState(); static_cast<ReadActor*>(this)->destroy(); return 0; }
															#line 5727 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(std::move(result)); // state_var_RVO
		this->~ReadActorState();
		static_cast<ReadActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(int const& bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont1(bytesRead, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && bytesRead,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(bytesRead), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadActor*>(this)->actor_wait_state > 0) static_cast<ReadActor*>(this)->actor_wait_state = 0;
		static_cast<ReadActor*>(this)->ActorCallback< ReadActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< ReadActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	RawDiskQueue_TwoFiles* self;
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int file;
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int pageOffset;
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int nPages;
															#line 750 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	TrackMe trackMe;
															#line 751 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	const size_t bytesRequested;
															#line 752 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Standalone<StringRef> result;
															#line 5824 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via read()
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReadActor final : public Actor<Standalone<StringRef>>, public ActorCallback< ReadActor, 0, int >, public FastAllocated<ReadActor>, public ReadActorState<ReadActor> {
															#line 5829 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<ReadActor>::operator new;
	using FastAllocated<ReadActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1039949855147058176UL, 5269655990752170240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadActor, 0, int >;
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReadActor(RawDiskQueue_TwoFiles* const& self,int const& file,int const& pageOffset,int const& nPages) 
															#line 5846 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   ReadActorState<ReadActor>(self, file, pageOffset, nPages),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3377648328873480704UL, 6210503387287458048UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("read");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
static Future<Standalone<StringRef>> read( RawDiskQueue_TwoFiles* const& self, int const& file, int const& pageOffset, int const& nPages ) {
															#line 746 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Standalone<StringRef>>(new ReadActor(self, file, pageOffset, nPages));
															#line 5869 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 760 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

	Future<int> fillReadingBuffer() {
		// If we're right at the end of a file...
		if (readingPage * sizeof(Page) >= (size_t)files[readingFile].size) {
			readingFile++;
			readingPage = 0;
			if (readingFile >= 2) {
				// Recovery complete
				readingBuffer.clear();
				writingPos = files[1].size;
				return 0;
			}
		}

		// Read up to 1MB into readingBuffer
		int len = std::min<int64_t>((files[readingFile].size / sizeof(Page) - readingPage) * sizeof(Page),
		                            BUGGIFY_WITH_PROB(1.0) ? sizeof(Page) * deterministicRandom()->randomInt(1, 4)
		                                                   : (1 << 20));
		readingBuffer.clear();
		readingBuffer.alignReserve(sizeof(Page), len);
		void* p = readingBuffer.append(len);

		auto pos = readingPage * sizeof(Page);
		readingPage += len / sizeof(Page);
		ASSERT(int64_t(p) % sizeof(Page) == 0);
		return files[readingFile].f->read(p, len, pos);
	}

																#line 5901 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via readNextPage()
															#line 788 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class ReadNextPageActor>
															#line 788 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReadNextPageActorState {
															#line 5907 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 788 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReadNextPageActorState(RawDiskQueue_TwoFiles* const& self) 
															#line 788 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 788 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 789 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   trackMe(self)
															#line 5916 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("readNextPage", reinterpret_cast<unsigned long>(this));

	}
	~ReadNextPageActorState() 
	{
		fdb_probe_actor_destroy("readNextPage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 792 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				ASSERT(self->readingFile < 2);
															#line 793 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				ASSERT(self->files[0].f && self->files[1].f);
															#line 795 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (!self->readingBuffer.size())
															#line 5936 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				{
															#line 796 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					f = Void();
															#line 799 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					StrictFuture<int> __when_expr_0 = self->fillReadingBuffer();
															#line 799 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 5944 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
					static_cast<ReadNextPageActor*>(this)->actor_wait_state = 1;
															#line 799 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadNextPageActor, 0, int >*>(static_cast<ReadNextPageActor*>(this)));
															#line 5948 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
					loopDepth = 0;
				}
				else
				{
					loopDepth = a_body1cont2(loopDepth);
				}
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadNextPageActorState();
		static_cast<ReadNextPageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 811 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			CODE_PROBE(true, "Read next page error");
															#line 812 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			TraceEvent(SevError, "RDQReadNextPageError", self->dbgid) .errorUnsuppressed(e) .detail("File0Name", self->files[0].dbgFilename);
															#line 815 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!self->error.isSet())
															#line 5987 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 816 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				self->error.sendError(e);
															#line 5991 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 817 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 5995 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(int loopDepth) 
	{
															#line 804 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!self->readingBuffer.size())
															#line 6009 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 805 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!static_cast<ReadNextPageActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(Standalone<StringRef>()); this->~ReadNextPageActorState(); static_cast<ReadNextPageActor*>(this)->destroy(); return 0; }
															#line 6013 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			new (&static_cast<ReadNextPageActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(Standalone<StringRef>());
			this->~ReadNextPageActorState();
			static_cast<ReadNextPageActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 807 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(self->readingBuffer.size() >= sizeof(Page));
															#line 808 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		Standalone<StringRef> result = self->readingBuffer.pop_front(sizeof(Page));
															#line 809 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadNextPageActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(result); this->~ReadNextPageActorState(); static_cast<ReadNextPageActor*>(this)->destroy(); return 0; }
															#line 6025 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadNextPageActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(result);
		this->~ReadNextPageActorState();
		static_cast<ReadNextPageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(int const& read,int loopDepth) 
	{
															#line 800 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(read == self->readingBuffer.size());
															#line 802 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f;
															#line 802 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
															#line 6041 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<ReadNextPageActor*>(this)->actor_wait_state = 2;
															#line 802 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadNextPageActor, 1, Void >*>(static_cast<ReadNextPageActor*>(this)));
															#line 6045 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont3(int && read,int loopDepth) 
	{
															#line 800 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(read == self->readingBuffer.size());
															#line 802 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_1 = f;
															#line 802 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont3when1(__when_expr_1.get(), loopDepth); };
															#line 6058 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<ReadNextPageActor*>(this)->actor_wait_state = 2;
															#line 802 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadNextPageActor, 1, Void >*>(static_cast<ReadNextPageActor*>(this)));
															#line 6062 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(int const& read,int loopDepth) 
	{
		loopDepth = a_body1cont3(read, loopDepth);

		return loopDepth;
	}
	int a_body1when1(int && read,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(read), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadNextPageActor*>(this)->actor_wait_state > 0) static_cast<ReadNextPageActor*>(this)->actor_wait_state = 0;
		static_cast<ReadNextPageActor*>(this)->ActorCallback< ReadNextPageActor, 0, int >::remove();

	}
	void a_callback_fire(ActorCallback< ReadNextPageActor, 0, int >*,int const& value) 
	{
		fdb_probe_actor_enter("readNextPage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextPage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadNextPageActor, 0, int >*,int && value) 
	{
		fdb_probe_actor_enter("readNextPage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextPage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadNextPageActor, 0, int >*,Error err) 
	{
		fdb_probe_actor_enter("readNextPage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextPage", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont4(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont4(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont4(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont3when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont4(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadNextPageActor*>(this)->actor_wait_state > 0) static_cast<ReadNextPageActor*>(this)->actor_wait_state = 0;
		static_cast<ReadNextPageActor*>(this)->ActorCallback< ReadNextPageActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadNextPageActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readNextPage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextPage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadNextPageActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readNextPage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont3when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextPage", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadNextPageActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readNextPage", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNextPage", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 788 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	RawDiskQueue_TwoFiles* self;
															#line 789 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	TrackMe trackMe;
															#line 796 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Future<Void> f;
															#line 6235 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via readNextPage()
															#line 788 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReadNextPageActor final : public Actor<Standalone<StringRef>>, public ActorCallback< ReadNextPageActor, 0, int >, public ActorCallback< ReadNextPageActor, 1, Void >, public FastAllocated<ReadNextPageActor>, public ReadNextPageActorState<ReadNextPageActor> {
															#line 6240 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<ReadNextPageActor>::operator new;
	using FastAllocated<ReadNextPageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(2480330625661733632UL, 6366373050455211520UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadNextPageActor, 0, int >;
friend struct ActorCallback< ReadNextPageActor, 1, Void >;
															#line 788 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReadNextPageActor(RawDiskQueue_TwoFiles* const& self) 
															#line 6258 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   ReadNextPageActorState<ReadNextPageActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readNextPage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(16019210228624203264UL, 4820023028417954304UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readNextPage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readNextPage", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 788 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
static Future<Standalone<StringRef>> readNextPage( RawDiskQueue_TwoFiles* const& self ) {
															#line 788 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Standalone<StringRef>>(new ReadNextPageActor(self));
															#line 6281 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 820 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

	// Set zero and free the memory from pos to the end of file self->files[file].
																#line 6287 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via truncateFile()
															#line 822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class TruncateFileActor>
															#line 822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class TruncateFileActorState {
															#line 6293 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	TruncateFileActorState(RawDiskQueue_TwoFiles* const& self,int const& file,int64_t const& pos) 
															#line 822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   file(file),
															#line 822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   pos(pos),
															#line 823 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   trackMe(self)
															#line 6306 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("truncateFile", reinterpret_cast<unsigned long>(this));

	}
	~TruncateFileActorState() 
	{
		fdb_probe_actor_destroy("truncateFile", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 824 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			TraceEvent("DQTruncateFile", self->dbgid) .detail("File", file) .detail("Pos", pos) .detail("File0Name", self->files[0].dbgFilename);
															#line 828 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			f = self->files[file].f;
															#line 830 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (pos == 0)
															#line 6325 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 831 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				memset(self->firstPages[file], 0xFF, _PAGE_SIZE);
															#line 6329 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 833 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Void> __when_expr_0 = f->zeroRange(pos, self->files[file].size - pos);
															#line 833 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 6335 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			static_cast<TruncateFileActor*>(this)->actor_wait_state = 1;
															#line 833 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TruncateFileActor, 0, Void >*>(static_cast<TruncateFileActor*>(this)));
															#line 6339 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TruncateFileActorState();
		static_cast<TruncateFileActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 834 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->files[file].syncQueue->onSync();
															#line 834 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 6364 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<TruncateFileActor*>(this)->actor_wait_state = 2;
															#line 834 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TruncateFileActor, 1, Void >*>(static_cast<TruncateFileActor*>(this)));
															#line 6368 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 834 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_1 = self->files[file].syncQueue->onSync();
															#line 834 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1cont1when1(__when_expr_1.get(), loopDepth); };
															#line 6379 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<TruncateFileActor*>(this)->actor_wait_state = 2;
															#line 834 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< TruncateFileActor, 1, Void >*>(static_cast<TruncateFileActor*>(this)));
															#line 6383 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TruncateFileActor*>(this)->actor_wait_state > 0) static_cast<TruncateFileActor*>(this)->actor_wait_state = 0;
		static_cast<TruncateFileActor*>(this)->ActorCallback< TruncateFileActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TruncateFileActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("truncateFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TruncateFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("truncateFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TruncateFileActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("truncateFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TruncateFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("truncateFile", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TruncateFileActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("truncateFile", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TruncateFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("truncateFile", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Void const& _,int loopDepth) 
	{
															#line 836 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<TruncateFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TruncateFileActorState(); static_cast<TruncateFileActor*>(this)->destroy(); return 0; }
															#line 6467 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<TruncateFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TruncateFileActorState();
		static_cast<TruncateFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont3(Void && _,int loopDepth) 
	{
															#line 836 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<TruncateFileActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TruncateFileActorState(); static_cast<TruncateFileActor*>(this)->destroy(); return 0; }
															#line 6479 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<TruncateFileActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TruncateFileActorState();
		static_cast<TruncateFileActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont3(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<TruncateFileActor*>(this)->actor_wait_state > 0) static_cast<TruncateFileActor*>(this)->actor_wait_state = 0;
		static_cast<TruncateFileActor*>(this)->ActorCallback< TruncateFileActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TruncateFileActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("truncateFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TruncateFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("truncateFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< TruncateFileActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("truncateFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TruncateFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("truncateFile", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< TruncateFileActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("truncateFile", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TruncateFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("truncateFile", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	RawDiskQueue_TwoFiles* self;
															#line 822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int file;
															#line 822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int64_t pos;
															#line 823 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	TrackMe trackMe;
															#line 828 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Reference<IAsyncFile> f;
															#line 6572 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via truncateFile()
															#line 822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class TruncateFileActor final : public Actor<Void>, public ActorCallback< TruncateFileActor, 0, Void >, public ActorCallback< TruncateFileActor, 1, Void >, public FastAllocated<TruncateFileActor>, public TruncateFileActorState<TruncateFileActor> {
															#line 6577 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<TruncateFileActor>::operator new;
	using FastAllocated<TruncateFileActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7003865004995508224UL, 3993139473381636608UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TruncateFileActor, 0, Void >;
friend struct ActorCallback< TruncateFileActor, 1, Void >;
															#line 822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	TruncateFileActor(RawDiskQueue_TwoFiles* const& self,int const& file,int64_t const& pos) 
															#line 6595 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Void>(),
		   TruncateFileActorState<TruncateFileActor>(self, file, pos),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("truncateFile", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7442459812600750080UL, 10199943093046937088UL);
		ActorExecutionContextHelper __helper(static_cast<TruncateFileActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("truncateFile");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("truncateFile", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
static Future<Void> truncateFile( RawDiskQueue_TwoFiles* const& self, int const& file, int64_t const& pos ) {
															#line 822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Void>(new TruncateFileActor(self, file, pos));
															#line 6618 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 838 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

																#line 6623 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via truncateBeforeLastReadPage()
															#line 839 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class TruncateBeforeLastReadPageActor>
															#line 839 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class TruncateBeforeLastReadPageActorState {
															#line 6629 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 839 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	TruncateBeforeLastReadPageActorState(RawDiskQueue_TwoFiles* const& self) 
															#line 839 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 839 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self)
															#line 6636 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("truncateBeforeLastReadPage", reinterpret_cast<unsigned long>(this));

	}
	~TruncateBeforeLastReadPageActorState() 
	{
		fdb_probe_actor_destroy("truncateBeforeLastReadPage", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 841 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				file = self->readingFile;
															#line 842 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				pos = (self->readingPage - self->readingBuffer.size() / sizeof(Page) - 1) * sizeof(Page);
															#line 843 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				commits = std::vector<Future<Void>>();
															#line 844 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				swap = file == 0;
															#line 846 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				CODE_PROBE(file == 0, "truncate before last read page on file 0");
															#line 847 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				CODE_PROBE(file == 1 && pos != self->files[1].size, "truncate before last read page on file 1");
															#line 849 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				self->readingFile = 2;
															#line 850 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				self->readingBuffer.clear();
															#line 851 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				self->writingPos = pos;
															#line 853 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				for(;file < 2;) {
															#line 854 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					commits.push_back(self->truncateFile(self, file, pos));
															#line 855 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					file++;
															#line 856 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					pos = 0;
															#line 6676 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				}
															#line 859 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				StrictFuture<Void> __when_expr_0 = waitForAll(commits);
															#line 859 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (static_cast<TruncateBeforeLastReadPageActor*>(this)->actor_wait_state < 0) return a_body1Catch2(actor_cancelled(), loopDepth);
															#line 6682 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<TruncateBeforeLastReadPageActor*>(this)->actor_wait_state = 1;
															#line 859 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< TruncateBeforeLastReadPageActor, 0, Void >*>(static_cast<TruncateBeforeLastReadPageActor*>(this)));
															#line 6687 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~TruncateBeforeLastReadPageActorState();
		static_cast<TruncateBeforeLastReadPageActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 869 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			TraceEvent(SevError, "RDQTruncateBeforeLastReadPageError", self->dbgid) .error(e) .detail("File0Name", self->files[0].dbgFilename);
															#line 872 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!self->error.isSet())
															#line 6719 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 873 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				self->error.sendError(e);
															#line 6723 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 874 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			return a_body1Catch1(e, loopDepth);
															#line 6727 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 861 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (swap)
															#line 6741 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 862 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			std::swap(self->files[0], self->files[1]);
															#line 863 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			std::swap(self->firstPages[0], self->firstPages[1]);
															#line 864 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->files[0].popped = self->files[0].size;
															#line 6749 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 867 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<TruncateBeforeLastReadPageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TruncateBeforeLastReadPageActorState(); static_cast<TruncateBeforeLastReadPageActor*>(this)->destroy(); return 0; }
															#line 6753 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<TruncateBeforeLastReadPageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TruncateBeforeLastReadPageActorState();
		static_cast<TruncateBeforeLastReadPageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 861 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (swap)
															#line 6765 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 862 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			std::swap(self->files[0], self->files[1]);
															#line 863 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			std::swap(self->firstPages[0], self->firstPages[1]);
															#line 864 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->files[0].popped = self->files[0].size;
															#line 6773 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 867 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<TruncateBeforeLastReadPageActor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~TruncateBeforeLastReadPageActorState(); static_cast<TruncateBeforeLastReadPageActor*>(this)->destroy(); return 0; }
															#line 6777 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<TruncateBeforeLastReadPageActor*>(this)->SAV< Void >::value()) Void(Void());
		this->~TruncateBeforeLastReadPageActorState();
		static_cast<TruncateBeforeLastReadPageActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<TruncateBeforeLastReadPageActor*>(this)->actor_wait_state > 0) static_cast<TruncateBeforeLastReadPageActor*>(this)->actor_wait_state = 0;
		static_cast<TruncateBeforeLastReadPageActor*>(this)->ActorCallback< TruncateBeforeLastReadPageActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< TruncateBeforeLastReadPageActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("truncateBeforeLastReadPage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TruncateBeforeLastReadPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("truncateBeforeLastReadPage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< TruncateBeforeLastReadPageActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("truncateBeforeLastReadPage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<TruncateBeforeLastReadPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("truncateBeforeLastReadPage", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< TruncateBeforeLastReadPageActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("truncateBeforeLastReadPage", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<TruncateBeforeLastReadPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("truncateBeforeLastReadPage", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 839 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	RawDiskQueue_TwoFiles* self;
															#line 841 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int file;
															#line 842 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int64_t pos;
															#line 843 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	std::vector<Future<Void>> commits;
															#line 844 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	bool swap;
															#line 6870 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via truncateBeforeLastReadPage()
															#line 839 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class TruncateBeforeLastReadPageActor final : public Actor<Void>, public ActorCallback< TruncateBeforeLastReadPageActor, 0, Void >, public FastAllocated<TruncateBeforeLastReadPageActor>, public TruncateBeforeLastReadPageActorState<TruncateBeforeLastReadPageActor> {
															#line 6875 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<TruncateBeforeLastReadPageActor>::operator new;
	using FastAllocated<TruncateBeforeLastReadPageActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16595651523981052416UL, 1663257563445240832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< TruncateBeforeLastReadPageActor, 0, Void >;
															#line 839 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	TruncateBeforeLastReadPageActor(RawDiskQueue_TwoFiles* const& self) 
															#line 6892 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Void>(),
		   TruncateBeforeLastReadPageActorState<TruncateBeforeLastReadPageActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("truncateBeforeLastReadPage", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(3018624130537680384UL, 16722161850737007360UL);
		ActorExecutionContextHelper __helper(static_cast<TruncateBeforeLastReadPageActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("truncateBeforeLastReadPage");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("truncateBeforeLastReadPage", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< TruncateBeforeLastReadPageActor, 0, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 839 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
[[nodiscard]] static Future<Void> truncateBeforeLastReadPage( RawDiskQueue_TwoFiles* const& self ) {
															#line 839 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Void>(new TruncateBeforeLastReadPageActor(self));
															#line 6924 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 877 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
};

class DiskQueue final : public IDiskQueue, public Tracked<DiskQueue> {
public:
	DiskQueue(std::string basename,
	          std::string fileExtension,
	          UID dbgid,
	          DiskQueueVersion diskQueueVersion,
	          int64_t fileSizeWarningLimit)
	  : rawQueue(new RawDiskQueue_TwoFiles(basename, fileExtension, dbgid, fileSizeWarningLimit)), dbgid(dbgid),
	    diskQueueVersion(diskQueueVersion), anyPopped(false), warnAlwaysForMemory(true), nextPageSeq(0), poppedSeq(0),
	    lastPoppedSeq(0), lastCommittedSeq(0), pushed_page_buffer(nullptr), recovered(false), initialized(false),
	    nextReadLocation(-1), readBufPage(nullptr), readBufPos(0) {}

	location push(StringRef contents) override {
		ASSERT(recovered);
		uint8_t const* begin = contents.begin();
		uint8_t const* end = contents.end();
		CODE_PROBE(contents.size() && pushedPageCount(), "More than one push between commits");

		bool pushAtEndOfPage = contents.size() >= 4 && pushedPageCount() && backPage().remainingCapacity() < 4;
		CODE_PROBE(pushAtEndOfPage, "Push right at the end of a page, possibly splitting size");
		while (begin != end) {
			if (!pushedPageCount() || !backPage().remainingCapacity())
				addEmptyPage();

			auto& p = backPage();
			int s = std::min<int>(p.remainingCapacity(), end - begin);
			memcpy(p.payload + p.payloadSize, begin, s);
			p.payloadSize += s;
			begin += s;
		}
		return endLocation();
	}

	void pop(location upTo) override {
		ASSERT(!upTo.hi);
		ASSERT(!recovered || upTo.lo <= endLocation());

		// SS can pop pages that have not been sync.ed to disk because of concurrency:
		//   SS can read (i.e., pop) data at the same time or before tLog syncs the page to disk.
		//   This is rare in real situation but common in simulation.
		// The following ASSERT is NOT part of the intended contract of IDiskQueue, but alerts the user to a known bug
		// where popping
		//  into uncommitted pages can cause a durability failure.
		// FIXME: Remove this ASSERT when popping into uncommitted pages is fixed
		if (upTo.lo > lastCommittedSeq) {
			TraceEvent(SevError, "DQPopUncommittedData", dbgid)
			    .detail("UpTo", upTo)
			    .detail("LastCommittedSeq", lastCommittedSeq)
			    .detail("File0Name", rawQueue->files[0].dbgFilename);
		}
		if (upTo.lo > poppedSeq) {
			poppedSeq = upTo.lo;
			anyPopped = true;
		}
	}

	Future<Standalone<StringRef>> read(location from, location to, CheckHashes ch) override {
		return read(this, from, to, ch);
	}

	int getMaxPayload() const { return Page::maxPayload; }

	// Always commit an entire page. Commit overhead is the unused space in a to-be-committed page
	int getCommitOverhead() const override {
		if (!pushedPageCount()) {
			if (!anyPopped)
				return 0;

			// To mark pages are poped, we push an empty page to specify that following pages were poped.
			// maxPayLoad is the max. payload size, i.e., (page_size - page_header_size).
			return Page::maxPayload;
		} else
			return backPage().remainingCapacity();
	}

	Future<Void> commit() override {
		ASSERT(recovered);
		if (!pushedPageCount()) {
			if (!anyPopped)
				return Void();
			addEmptyPage(); // To remove poped pages, we push an empty page to specify that pages behind it were poped.
		}
		anyPopped = false;
		backPage().popped = poppedSeq;
		backPage().zeroPad();
		backPage().updateHash();

		// Warn users that we pushed too many pages. 8000 is an arbitrary value.
		if (pushedPageCount() >= 8000) {
			TraceEvent(warnAlwaysForMemory ? SevWarnAlways : SevWarn, "DiskQueueMemoryWarning", dbgid)
			    .suppressFor(1.0)
			    .detail("PushedPages", pushedPageCount())
			    .detail("NextPageSeq", nextPageSeq)
			    .detail("Details", format("%d pages", pushedPageCount()))
			    .detail("File0Name", rawQueue->files[0].dbgFilename);
			if (g_network->isSimulated())
				warnAlwaysForMemory = false;
		}

		/*TraceEvent("DQCommit", dbgid).detail("Pages", pushedPageCount()).detail("LastPoppedSeq", lastPoppedSeq).detail("PoppedSeq", poppedSeq).detail("NextPageSeq", nextPageSeq)
		    .detail("RawFile0Size", rawQueue->files[0].size).detail("RawFile1Size",
		   rawQueue->files[1].size).detail("WritingPos", rawQueue->writingPos) .detail("RawFile0Name",
		   rawQueue->files[0].dbgFilename);*/

		// Since we only commit entire pages, round the last
		// committed location up to the next page.
		lastCommittedSeq = pageCeiling(backPage().endSeq());
		auto f = rawQueue->pushAndCommit(
		    pushed_page_buffer->get(), pushed_page_buffer, poppedSeq / sizeof(Page) - lastPoppedSeq / sizeof(Page));
		lastPoppedSeq = poppedSeq;
		pushed_page_buffer = 0;
		return f;
	}

	void stall() { rawQueue->stall(); }

	Future<bool> initializeRecovery(location recoverAt) override { return initializeRecovery(this, recoverAt); }
	Future<Standalone<StringRef>> readNext(int bytes) override { return readNext(this, bytes); }

	// FIXME: getNextReadLocation should ASSERT( initialized ), but the memory storage engine needs
	// to be changed to understand the new intiailizeRecovery protocol.
	location getNextReadLocation() const override { return nextReadLocation; }
	location getNextPushLocation() const override {
		ASSERT(initialized);
		return endLocation();
	}

	Future<Void> getError() const override { return rawQueue->getError(); }
	Future<Void> onClosed() const override { return rawQueue->onClosed(); }

	void dispose() override {
		TraceEvent("DQDestroy", dbgid)
		    .detail("LastPoppedSeq", lastPoppedSeq)
		    .detail("PoppedSeq", poppedSeq)
		    .detail("NextPageSeq", nextPageSeq)
		    .detail("File0Name", rawQueue->files[0].dbgFilename);
		dispose(this);
	}

	void close() override {
		TraceEvent("DQClose", dbgid)
		    .detail("LastPoppedSeq", lastPoppedSeq)
		    .detail("PoppedSeq", poppedSeq)
		    .detail("NextPageSeq", nextPageSeq)
		    .detail("PoppedCommitted",
		            rawQueue->dbg_file0BeginSeq + rawQueue->files[0].popped + rawQueue->files[1].popped)
		    .detail("File0Name", rawQueue->files[0].dbgFilename);
		close(this);
	}

	StorageBytes getStorageBytes() const override { return rawQueue->getStorageBytes(); }

private:
																#line 7083 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via dispose()
															#line 1032 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class DisposeActor>
															#line 1032 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class DisposeActorState {
															#line 7089 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 1032 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	DisposeActorState(DiskQueue* const& self) 
															#line 1032 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 1032 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self)
															#line 7096 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("dispose", reinterpret_cast<unsigned long>(this));

	}
	~DisposeActorState() 
	{
		fdb_probe_actor_destroy("dispose", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1033 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->onSafeToDestruct();
															#line 1033 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 7113 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			static_cast<DisposeActor*>(this)->actor_wait_state = 1;
															#line 1033 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< DisposeActor, 0, Void >*>(static_cast<DisposeActor*>(this)));
															#line 7117 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<DisposeActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1034 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		TraceEvent("DQDestroyDone", self->dbgid).detail("File0Name", self->rawQueue->files[0].dbgFilename);
															#line 1035 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->rawQueue->dispose();
															#line 1036 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		delete self;
															#line 7143 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1034 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		TraceEvent("DQDestroyDone", self->dbgid).detail("File0Name", self->rawQueue->files[0].dbgFilename);
															#line 1035 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->rawQueue->dispose();
															#line 1036 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		delete self;
															#line 7156 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<DisposeActor*>(this)->actor_wait_state > 0) static_cast<DisposeActor*>(this)->actor_wait_state = 0;
		static_cast<DisposeActor*>(this)->ActorCallback< DisposeActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< DisposeActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("dispose", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisposeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispose", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< DisposeActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("dispose", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<DisposeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispose", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< DisposeActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("dispose", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<DisposeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("dispose", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1032 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		delete static_cast<DisposeActor*>(this);
															#line 7240 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 1032 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	DiskQueue* self;
															#line 7247 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via dispose()
															#line 1032 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class DisposeActor final : public Actor<void>, public ActorCallback< DisposeActor, 0, Void >, public FastAllocated<DisposeActor>, public DisposeActorState<DisposeActor> {
															#line 7252 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<DisposeActor>::operator new;
	using FastAllocated<DisposeActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(7414532567830770432UL, 13724959646612824832UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< DisposeActor, 0, Void >;
															#line 1032 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	DisposeActor(DiskQueue* const& self) 
															#line 7269 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<void>(),
		   DisposeActorState<DisposeActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("dispose", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7168122389187786496UL, 15266394968279035136UL);
		ActorExecutionContextHelper __helper(static_cast<DisposeActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("dispose");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("dispose", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 1032 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
static void dispose( DiskQueue* const& self ) {
															#line 1032 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	new DisposeActor(self);
															#line 7292 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 1038 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

																#line 7297 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via close()
															#line 1039 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class CloseActor>
															#line 1039 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class CloseActorState {
															#line 7303 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 1039 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	CloseActorState(DiskQueue* const& self) 
															#line 1039 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 1039 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self)
															#line 7310 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("close", reinterpret_cast<unsigned long>(this));

	}
	~CloseActorState() 
	{
		fdb_probe_actor_destroy("close", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1040 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Void> __when_expr_0 = self->onSafeToDestruct();
															#line 1040 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 7327 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			static_cast<CloseActor*>(this)->actor_wait_state = 1;
															#line 1040 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< CloseActor, 0, Void >*>(static_cast<CloseActor*>(this)));
															#line 7331 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<CloseActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Void const& _,int loopDepth) 
	{
															#line 1041 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		TraceEvent("DQCloseDone", self->dbgid).detail("File0Name", self->rawQueue->files[0].dbgFilename);
															#line 1042 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->rawQueue->close();
															#line 1043 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		delete self;
															#line 7357 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1cont1(Void && _,int loopDepth) 
	{
															#line 1041 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		TraceEvent("DQCloseDone", self->dbgid).detail("File0Name", self->rawQueue->files[0].dbgFilename);
															#line 1042 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->rawQueue->close();
															#line 1043 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		delete self;
															#line 7370 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont3(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<CloseActor*>(this)->actor_wait_state > 0) static_cast<CloseActor*>(this)->actor_wait_state = 0;
		static_cast<CloseActor*>(this)->ActorCallback< CloseActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< CloseActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("close", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("close", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< CloseActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("close", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<CloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("close", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< CloseActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("close", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<CloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("close", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(int loopDepth) 
	{
															#line 1039 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		delete static_cast<CloseActor*>(this);
															#line 7454 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 1039 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	DiskQueue* self;
															#line 7461 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via close()
															#line 1039 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class CloseActor final : public Actor<void>, public ActorCallback< CloseActor, 0, Void >, public FastAllocated<CloseActor>, public CloseActorState<CloseActor> {
															#line 7466 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<CloseActor>::operator new;
	using FastAllocated<CloseActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(6462181422340392192UL, 60461667346227968UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< CloseActor, 0, Void >;
															#line 1039 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	CloseActor(DiskQueue* const& self) 
															#line 7483 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<void>(),
		   CloseActorState<CloseActor>(self),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("close", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9419912505739474944UL, 5603856312376563968UL);
		ActorExecutionContextHelper __helper(static_cast<CloseActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("close");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("close", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 1039 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
static void close( DiskQueue* const& self ) {
															#line 1039 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	new CloseActor(self);
															#line 7506 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 1045 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

#pragma pack(push, 1)
	struct PageHeader {
		union {
			UID hash;
			struct {
				union {
					uint64_t hash64;
					struct {
						uint32_t hash32;
						uint32_t _unused;
					};
				};
				uint16_t magic;
				uint16_t implementationVersion;
			};
		};
		uint64_t seq; // seq is the index of the virtually infinite disk queue file. Its unit is bytes.
		uint64_t popped;
		int32_t payloadSize;
	};
	// The on disk format depends on the size of PageHeader.
	static_assert(sizeof(PageHeader) == 36, "PageHeader must be 36 bytes");

	struct Page : PageHeader {
		static const int maxPayload = _PAGE_SIZE - sizeof(PageHeader);
		uint8_t payload[maxPayload];

		DiskQueueVersion diskQueueVersion() const { return static_cast<DiskQueueVersion>(implementationVersion); }
		int remainingCapacity() const { return maxPayload - payloadSize; }
		uint64_t endSeq() const { return seq + sizeof(PageHeader) + payloadSize; }
		UID checksum_hashlittle2() const {
			// SOMEDAY: Better hash?
			uint32_t part[2] = { 0x12345678, 0xbeefabcd };
			hashlittle2(&seq, sizeof(Page) - sizeof(UID), &part[0], &part[1]);
			return UID(int64_t(part[0]) << 32 | part[1], 0xFDB);
		}
		uint32_t checksum_crc32c() const {
			return crc32c_append(0xfdbeefdb, (uint8_t*)&_unused, sizeof(Page) - sizeof(uint32_t));
		}
		uint64_t checksum_xxhash3() const {
			return XXH3_64bits(static_cast<const void*>(&magic), sizeof(Page) - sizeof(uint64_t));
		}
		void updateHash() {
			switch (diskQueueVersion()) {
			case DiskQueueVersion::V0: {
				hash = checksum_hashlittle2();
				return;
			}
			case DiskQueueVersion::V1: {
				hash32 = checksum_crc32c();
				return;
			}
			case DiskQueueVersion::V2:
			default: {
				hash64 = checksum_xxhash3();
				return;
			}
			}
		}
		bool checkHash() {
			switch (diskQueueVersion()) {
			case DiskQueueVersion::V0: {
				return hash == checksum_hashlittle2();
			}
			case DiskQueueVersion::V1: {
				return hash32 == checksum_crc32c();
			}
			case DiskQueueVersion::V2: {
				return hash64 == checksum_xxhash3();
			}
			default:
				return false;
			}
		}
		void zeroPad() { memset(payload + payloadSize, 0, maxPayload - payloadSize); }
	};
	static_assert(sizeof(Page) == _PAGE_SIZE, "Page must be 4k");
#pragma pack(pop)

	loc_t endLocation() const { return pushedPageCount() ? backPage().endSeq() : nextPageSeq; }

	void addEmptyPage() {
		if (pushedPageCount()) {
			backPage().updateHash();
			ASSERT(backPage().payloadSize == Page::maxPayload);
		}

		// pushed_pages.resize( pushed_pages.arena(), pushed_pages.size()+1 );
		if (!pushed_page_buffer)
			pushed_page_buffer = new StringBuffer(dbgid);
		pushed_page_buffer->alignReserve(sizeof(Page), pushed_page_buffer->size() + sizeof(Page));
		pushed_page_buffer->append(sizeof(Page));

		ASSERT(nextPageSeq % sizeof(Page) == 0);

		auto& p = backPage();
		memset(static_cast<void*>(&p), 0, sizeof(Page)); // FIXME: unnecessary?
		p.magic = 0xFDB;
		switch (diskQueueVersion) {
		case DiskQueueVersion::V0:
			p.implementationVersion = 0;
			break;
		case DiskQueueVersion::V1:
			p.implementationVersion = 1;
			break;
		case DiskQueueVersion::V2:
			p.implementationVersion = 2;
			break;
		}
		p.payloadSize = 0;
		p.seq = nextPageSeq;
		nextPageSeq += sizeof(Page);
		p.popped = poppedSeq;

		if (pushedPageCount() == 8000) {
			TraceEvent("DiskQueueHighPageCount", dbgid)
			    .detail("PushedPages", pushedPageCount())
			    .detail("NextPageSeq", nextPageSeq)
			    .detail("File0Name", rawQueue->files[0].dbgFilename);
		}
	}

																#line 7633 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via verifyCommit()
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class VerifyCommitActor>
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class VerifyCommitActorState {
															#line 7639 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	VerifyCommitActorState(DiskQueue* const& self,Future<Void> const& commitSynced,StringBuffer* const& buffer,loc_t const& start,loc_t const& end) 
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   commitSynced(commitSynced),
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   buffer(buffer),
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   start(start),
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   end(end),
															#line 1173 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   trackme(self)
															#line 7656 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("verifyCommit", reinterpret_cast<unsigned long>(this));

	}
	~VerifyCommitActorState() 
	{
		fdb_probe_actor_destroy("verifyCommit", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
			try {
															#line 1175 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				StrictFuture<Void> __when_expr_0 = commitSynced;
															#line 1175 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch2(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
															#line 7674 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				static_cast<VerifyCommitActor*>(this)->actor_wait_state = 1;
															#line 1175 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< VerifyCommitActor, 0, Void >*>(static_cast<VerifyCommitActor*>(this)));
															#line 7678 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				loopDepth = 0;
			}
			catch (Error& error) {
				loopDepth = a_body1Catch2(error, loopDepth);
			} catch (...) {
				loopDepth = a_body1Catch2(unknown_error(), loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		delete static_cast<VerifyCommitActor*>(this);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1186 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		delete buffer;
															#line 7706 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont7(loopDepth);

		return loopDepth;
	}
	int a_body1Catch2(const Error& e,int loopDepth=0) 
	{
		try {
															#line 1181 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (e.code() != error_code_io_error)
															#line 7716 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1182 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				delete buffer;
															#line 1183 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				return a_body1Catch1(e, loopDepth);
															#line 7722 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2(Void const& _,int loopDepth) 
	{
															#line 1176 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = readPages(self, start, end);
															#line 1176 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 7740 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<VerifyCommitActor*>(this)->actor_wait_state = 2;
															#line 1176 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyCommitActor, 1, Standalone<StringRef> >*>(static_cast<VerifyCommitActor*>(this)));
															#line 7744 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2(Void && _,int loopDepth) 
	{
															#line 1176 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = readPages(self, start, end);
															#line 1176 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch2(__when_expr_1.getError(), loopDepth); else return a_body1cont2when1(__when_expr_1.get(), loopDepth); };
															#line 7755 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		static_cast<VerifyCommitActor*>(this)->actor_wait_state = 2;
															#line 1176 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< VerifyCommitActor, 1, Standalone<StringRef> >*>(static_cast<VerifyCommitActor*>(this)));
															#line 7759 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2(_, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<VerifyCommitActor*>(this)->actor_wait_state > 0) static_cast<VerifyCommitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyCommitActor*>(this)->ActorCallback< VerifyCommitActor, 0, Void >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyCommitActor, 0, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("verifyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< VerifyCommitActor, 0, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("verifyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< VerifyCommitActor, 0, Void >*,Error err) 
	{
		fdb_probe_actor_enter("verifyCommit", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyCommit", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont3(Standalone<StringRef> const& pagedData,int loopDepth) 
	{
															#line 1177 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		const int startOffset = start % _PAGE_SIZE;
															#line 1178 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		const int dataLen = end - start;
															#line 1179 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(pagedData.substr(startOffset, dataLen).compare(buffer->get().substr(0, dataLen)) == 0);
															#line 7847 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(Standalone<StringRef> && pagedData,int loopDepth) 
	{
															#line 1177 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		const int startOffset = start % _PAGE_SIZE;
															#line 1178 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		const int dataLen = end - start;
															#line 1179 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(pagedData.substr(startOffset, dataLen).compare(buffer->get().substr(0, dataLen)) == 0);
															#line 7860 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont5(loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Standalone<StringRef> const& pagedData,int loopDepth) 
	{
		loopDepth = a_body1cont3(pagedData, loopDepth);

		return loopDepth;
	}
	int a_body1cont2when1(Standalone<StringRef> && pagedData,int loopDepth) 
	{
		loopDepth = a_body1cont3(std::move(pagedData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<VerifyCommitActor*>(this)->actor_wait_state > 0) static_cast<VerifyCommitActor*>(this)->actor_wait_state = 0;
		static_cast<VerifyCommitActor*>(this)->ActorCallback< VerifyCommitActor, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< VerifyCommitActor, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("verifyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< VerifyCommitActor, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("verifyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont2when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< VerifyCommitActor, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("verifyCommit", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch2(err, 0);
		}
		catch (Error& error) {
			a_body1Catch2(error, 0);
		} catch (...) {
			a_body1Catch2(unknown_error(), 0);
		}
		fdb_probe_actor_exit("verifyCommit", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont5(int loopDepth) 
	{
		try {
			loopDepth = a_body1cont1(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont7(int loopDepth) 
	{
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		delete static_cast<VerifyCommitActor*>(this);
															#line 7957 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		return 0;

		return loopDepth;
	}
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	DiskQueue* self;
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Future<Void> commitSynced;
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	StringBuffer* buffer;
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	loc_t start;
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	loc_t end;
															#line 1173 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	TrackMe trackme;
															#line 7974 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via verifyCommit()
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class VerifyCommitActor final : public Actor<void>, public ActorCallback< VerifyCommitActor, 0, Void >, public ActorCallback< VerifyCommitActor, 1, Standalone<StringRef> >, public FastAllocated<VerifyCommitActor>, public VerifyCommitActorState<VerifyCommitActor> {
															#line 7979 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<VerifyCommitActor>::operator new;
	using FastAllocated<VerifyCommitActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14763877875474670592UL, 4706466552796267264UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() {{
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<void>*>(this)->~Actor();
        operator delete(this);
    }}
#pragma clang diagnostic pop
friend struct ActorCallback< VerifyCommitActor, 0, Void >;
friend struct ActorCallback< VerifyCommitActor, 1, Standalone<StringRef> >;
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	VerifyCommitActor(DiskQueue* const& self,Future<Void> const& commitSynced,StringBuffer* const& buffer,loc_t const& start,loc_t const& end) 
															#line 7997 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<void>(),
		   VerifyCommitActorState<VerifyCommitActor>(self, commitSynced, buffer, start, end),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("verifyCommit", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(10177084602302882048UL, 9574497880036689920UL);
		ActorExecutionContextHelper __helper(static_cast<VerifyCommitActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("verifyCommit");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("verifyCommit", reinterpret_cast<unsigned long>(this), -1);

	}
};
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
static void verifyCommit( DiskQueue* const& self, Future<Void> const& commitSynced, StringBuffer* const& buffer, loc_t const& start, loc_t const& end ) {
															#line 1168 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	new VerifyCommitActor(self, commitSynced, buffer, start, end);
															#line 8020 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 1188 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

	// Read pages from [start, end) bytes
																#line 8026 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via readPages()
															#line 1190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class ReadPagesActor>
															#line 1190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReadPagesActorState {
															#line 8032 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 1190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReadPagesActorState(DiskQueue* const& self,location const& start,location const& end) 
															#line 1190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 1190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 1190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   start(start),
															#line 1190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   end(end),
															#line 1191 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   trackme(self),
															#line 1192 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   fromFile(),
															#line 1193 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   toFile(),
															#line 1194 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   fromPage(),
															#line 1195 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   toPage(),
															#line 1196 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   file0size(self->rawQueue->files[0].size ? self->firstPages(1).seq - self->firstPages(0).seq : self->firstPages(1).seq)
															#line 8055 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("readPages", reinterpret_cast<unsigned long>(this));

	}
	~ReadPagesActorState() 
	{
		fdb_probe_actor_destroy("readPages", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1198 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(end > start);
															#line 1199 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(start.lo >= self->firstPages(0).seq || start.lo >= self->firstPages(1).seq);
															#line 1200 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->findPhysicalLocation(start.lo, &fromFile, &fromPage, nullptr);
															#line 1201 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->findPhysicalLocation(end.lo - 1, &toFile, &toPage, nullptr);
															#line 1202 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (fromFile == 0)
															#line 8078 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1203 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				ASSERT(fromPage < file0size / _PAGE_SIZE);
															#line 8082 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 1205 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (toFile == 0)
															#line 8086 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1206 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				ASSERT(toPage < file0size / _PAGE_SIZE);
															#line 8090 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 1209 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (fromFile == 1 && self->recovered)
															#line 8094 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1210 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				ASSERT(fromPage < self->rawQueue->writingPos / _PAGE_SIZE);
															#line 8098 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 1212 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (toFile == 1 && self->recovered)
															#line 8102 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1213 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				ASSERT(toPage < self->rawQueue->writingPos / _PAGE_SIZE);
															#line 8106 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 1215 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (fromFile == toFile)
															#line 8110 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1216 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				ASSERT(toPage >= fromPage);
															#line 1217 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				StrictFuture<Standalone<StringRef>> __when_expr_0 = self->rawQueue->read(fromFile, fromPage, toPage - fromPage + 1);
															#line 1217 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (static_cast<ReadPagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8118 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadPagesActor*>(this)->actor_wait_state = 1;
															#line 1217 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadPagesActor, 0, Standalone<StringRef> >*>(static_cast<ReadPagesActor*>(this)));
															#line 8123 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
															#line 1232 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				ASSERT(fromFile == 0);
															#line 1233 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				firstChunk = Standalone<StringRef>();
															#line 1234 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				secondChunk = Standalone<StringRef>();
															#line 1235 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				StrictFuture<Void> __when_expr_1 = store(firstChunk, self->rawQueue->read(fromFile, fromPage, (file0size / sizeof(Page)) - fromPage)) && store(secondChunk, self->rawQueue->read(toFile, 0, toPage + 1));
															#line 1235 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (static_cast<ReadPagesActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8138 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), loopDepth); else return a_body1when2(__when_expr_1.get(), loopDepth); };
				static_cast<ReadPagesActor*>(this)->actor_wait_state = 2;
															#line 1235 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadPagesActor, 1, Void >*>(static_cast<ReadPagesActor*>(this)));
															#line 8143 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				loopDepth = 0;
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadPagesActorState();
		static_cast<ReadPagesActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont6(Standalone<StringRef> const& pagedData,int loopDepth) 
	{
															#line 1218 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (std::min(self->firstPages(0).seq, self->firstPages(1).seq) > start.lo)
															#line 8167 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1224 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			return a_body1Catch1(io_error(), loopDepth);
															#line 8171 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1226 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(((Page*)pagedData.begin())->seq == pageFloor(start.lo));
															#line 1227 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(pagedData.size() == (toPage - fromPage + 1) * _PAGE_SIZE);
															#line 1229 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(((Page*)pagedData.end() - 1)->seq == pageFloor(end.lo - 1));
															#line 1230 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadPagesActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(pagedData); this->~ReadPagesActorState(); static_cast<ReadPagesActor*>(this)->destroy(); return 0; }
															#line 8181 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadPagesActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(pagedData);
		this->~ReadPagesActorState();
		static_cast<ReadPagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Standalone<StringRef> && pagedData,int loopDepth) 
	{
															#line 1218 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (std::min(self->firstPages(0).seq, self->firstPages(1).seq) > start.lo)
															#line 8193 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1224 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			return a_body1Catch1(io_error(), loopDepth);
															#line 8197 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1226 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(((Page*)pagedData.begin())->seq == pageFloor(start.lo));
															#line 1227 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(pagedData.size() == (toPage - fromPage + 1) * _PAGE_SIZE);
															#line 1229 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(((Page*)pagedData.end() - 1)->seq == pageFloor(end.lo - 1));
															#line 1230 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadPagesActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(pagedData); this->~ReadPagesActorState(); static_cast<ReadPagesActor*>(this)->destroy(); return 0; }
															#line 8207 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadPagesActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(pagedData);
		this->~ReadPagesActorState();
		static_cast<ReadPagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& pagedData,int loopDepth) 
	{
		loopDepth = a_body1cont6(pagedData, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && pagedData,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(pagedData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadPagesActor*>(this)->actor_wait_state > 0) static_cast<ReadPagesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadPagesActor*>(this)->ActorCallback< ReadPagesActor, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadPagesActor, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("readPages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readPages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadPagesActor, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("readPages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readPages", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadPagesActor, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("readPages", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readPages", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont9(Void const& _,int loopDepth) 
	{
															#line 1237 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (std::min(self->firstPages(0).seq, self->firstPages(1).seq) > start.lo)
															#line 8294 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1239 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			return a_body1Catch1(io_error(), loopDepth);
															#line 8298 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1241 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(firstChunk.size() == ((file0size / sizeof(Page)) - fromPage) * _PAGE_SIZE);
															#line 1242 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(((Page*)firstChunk.begin())->seq == pageFloor(start.lo));
															#line 1243 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(secondChunk.size() == (toPage + 1) * _PAGE_SIZE);
															#line 1244 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(((Page*)secondChunk.end() - 1)->seq == pageFloor(end.lo - 1));
															#line 1245 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadPagesActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(firstChunk.withSuffix(secondChunk)); this->~ReadPagesActorState(); static_cast<ReadPagesActor*>(this)->destroy(); return 0; }
															#line 8310 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadPagesActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(firstChunk.withSuffix(secondChunk));
		this->~ReadPagesActorState();
		static_cast<ReadPagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont9(Void && _,int loopDepth) 
	{
															#line 1237 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (std::min(self->firstPages(0).seq, self->firstPages(1).seq) > start.lo)
															#line 8322 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1239 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			return a_body1Catch1(io_error(), loopDepth);
															#line 8326 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1241 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(firstChunk.size() == ((file0size / sizeof(Page)) - fromPage) * _PAGE_SIZE);
															#line 1242 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(((Page*)firstChunk.begin())->seq == pageFloor(start.lo));
															#line 1243 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(secondChunk.size() == (toPage + 1) * _PAGE_SIZE);
															#line 1244 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(((Page*)secondChunk.end() - 1)->seq == pageFloor(end.lo - 1));
															#line 1245 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadPagesActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(firstChunk.withSuffix(secondChunk)); this->~ReadPagesActorState(); static_cast<ReadPagesActor*>(this)->destroy(); return 0; }
															#line 8338 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadPagesActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(firstChunk.withSuffix(secondChunk));
		this->~ReadPagesActorState();
		static_cast<ReadPagesActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when2(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont9(_, loopDepth);

		return loopDepth;
	}
	int a_body1when2(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont9(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadPagesActor*>(this)->actor_wait_state > 0) static_cast<ReadPagesActor*>(this)->actor_wait_state = 0;
		static_cast<ReadPagesActor*>(this)->ActorCallback< ReadPagesActor, 1, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadPagesActor, 1, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readPages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readPages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadPagesActor, 1, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readPages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1when2(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readPages", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadPagesActor, 1, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readPages", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readPages", reinterpret_cast<unsigned long>(this), 1);

	}
															#line 1190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	DiskQueue* self;
															#line 1190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	location start;
															#line 1190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	location end;
															#line 1191 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	TrackMe trackme;
															#line 1192 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int fromFile;
															#line 1193 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int toFile;
															#line 1194 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int64_t fromPage;
															#line 1195 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int64_t toPage;
															#line 1196 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	uint64_t file0size;
															#line 1233 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Standalone<StringRef> firstChunk;
															#line 1234 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Standalone<StringRef> secondChunk;
															#line 8443 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via readPages()
															#line 1190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReadPagesActor final : public Actor<Standalone<StringRef>>, public ActorCallback< ReadPagesActor, 0, Standalone<StringRef> >, public ActorCallback< ReadPagesActor, 1, Void >, public FastAllocated<ReadPagesActor>, public ReadPagesActorState<ReadPagesActor> {
															#line 8448 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<ReadPagesActor>::operator new;
	using FastAllocated<ReadPagesActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(14115471722232052736UL, 4884207533127602432UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadPagesActor, 0, Standalone<StringRef> >;
friend struct ActorCallback< ReadPagesActor, 1, Void >;
															#line 1190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReadPagesActor(DiskQueue* const& self,location const& start,location const& end) 
															#line 8466 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   ReadPagesActorState<ReadPagesActor>(self, start, end),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readPages", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5856265570725428992UL, 10420774988100980736UL);
		ActorExecutionContextHelper __helper(static_cast<ReadPagesActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readPages");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readPages", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadPagesActor, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadPagesActor, 1, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
[[nodiscard]] static Future<Standalone<StringRef>> readPages( DiskQueue* const& self, location const& start, location const& end ) {
															#line 1190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Standalone<StringRef>>(new ReadPagesActor(self, start, end));
															#line 8499 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 1248 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

																#line 8504 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via read()
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class ReadActor1>
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReadActor1State {
															#line 8510 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReadActor1State(DiskQueue* const& self,location const& start,location const& end,CheckHashes const& ch) 
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   start(start),
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   end(end),
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   ch(ch)
															#line 8523 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("read", reinterpret_cast<unsigned long>(this));

	}
	~ReadActor1State() 
	{
		fdb_probe_actor_destroy("read", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1252 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = readPages(self, start, end);
															#line 1252 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (static_cast<ReadActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8540 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadActor1*>(this)->actor_wait_state = 1;
															#line 1252 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadActor1, 0, Standalone<StringRef> >*>(static_cast<ReadActor1*>(this)));
															#line 8545 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadActor1State();
		static_cast<ReadActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1253 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(start.lo % sizeof(Page) == 0 || start.lo % sizeof(Page) >= sizeof(PageHeader));
															#line 1254 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		int startingOffset = start.lo % sizeof(Page);
															#line 1255 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (startingOffset > 0)
															#line 8572 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1256 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			startingOffset -= sizeof(PageHeader);
															#line 8576 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1257 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(end.lo % sizeof(Page) == 0 || end.lo % sizeof(Page) > sizeof(PageHeader));
															#line 1258 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		int endingOffset = end.lo % sizeof(Page);
															#line 1259 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (endingOffset == 0)
															#line 8584 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1260 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			endingOffset = sizeof(Page);
															#line 8588 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1261 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (endingOffset > 0)
															#line 8592 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1262 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			endingOffset -= sizeof(PageHeader);
															#line 8596 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1264 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (pageFloor(end.lo - 1) == pageFloor(start.lo))
															#line 8600 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1266 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(pagedData.size() == sizeof(Page));
															#line 1267 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			Page* data = reinterpret_cast<Page*>(const_cast<uint8_t*>(pagedData.begin()));
															#line 1268 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (ch && !data->checkHash())
															#line 8608 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1269 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				return a_body1Catch1(io_error(), loopDepth);
															#line 8612 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 1270 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!ch && data->payloadSize > Page::maxPayload)
															#line 8616 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1271 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				return a_body1Catch1(io_error(), loopDepth);
															#line 8620 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 1272 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			pagedData.contents() = pagedData.substr(sizeof(PageHeader) + startingOffset, endingOffset - startingOffset);
															#line 1273 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!static_cast<ReadActor1*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(pagedData); this->~ReadActor1State(); static_cast<ReadActor1*>(this)->destroy(); return 0; }
															#line 8626 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			new (&static_cast<ReadActor1*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(std::move(pagedData)); // state_var_RVO
			this->~ReadActor1State();
			static_cast<ReadActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		else
		{
															#line 1277 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			uint8_t* buf = mutateString(pagedData);
															#line 1278 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			Page* data = reinterpret_cast<Page*>(const_cast<uint8_t*>(pagedData.begin()));
															#line 1279 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (ch && !data->checkHash())
															#line 8640 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1280 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				return a_body1Catch1(io_error(), loopDepth);
															#line 8644 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 1281 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!ch && data->payloadSize > Page::maxPayload)
															#line 8648 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1282 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				return a_body1Catch1(io_error(), loopDepth);
															#line 8652 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 1285 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (data->payloadSize > startingOffset)
															#line 8656 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1286 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				const int length = data->payloadSize - startingOffset;
															#line 1287 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				memmove(buf, data->payload + startingOffset, length);
															#line 1288 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				buf += length;
															#line 8664 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 1290 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			data++;
															#line 1291 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (ch && !data->checkHash())
															#line 8670 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1292 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				return a_body1Catch1(io_error(), loopDepth);
															#line 8674 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 1293 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!ch && data->payloadSize > Page::maxPayload)
															#line 8678 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1294 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				return a_body1Catch1(io_error(), loopDepth);
															#line 8682 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			}
															#line 1297 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			for(;data->seq != pageFloor(end.lo - 1);) {
															#line 1300 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				const int length = data->payloadSize;
															#line 1301 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				memmove(buf, data->payload, length);
															#line 1302 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				buf += length;
															#line 1303 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				data++;
															#line 1304 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (ch && !data->checkHash())
															#line 8696 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				{
															#line 1305 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					return a_body1Catch1(io_error(), loopDepth);
															#line 8700 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				}
															#line 1306 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (!ch && data->payloadSize > Page::maxPayload)
															#line 8704 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				{
															#line 1307 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
					return a_body1Catch1(io_error(), loopDepth);
															#line 8708 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				}
			}
															#line 1311 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			const int length = data->payloadSize;
															#line 1312 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			memmove(buf, data->payload, std::min(endingOffset, length));
															#line 1313 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			buf += std::min(endingOffset, length);
															#line 1315 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			memset(buf, 0, pagedData.size() - (buf - pagedData.begin()));
															#line 1316 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			Standalone<StringRef> unpagedData = pagedData.substr(0, buf - pagedData.begin());
															#line 1317 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!static_cast<ReadActor1*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(unpagedData); this->~ReadActor1State(); static_cast<ReadActor1*>(this)->destroy(); return 0; }
															#line 8723 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			new (&static_cast<ReadActor1*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(unpagedData);
			this->~ReadActor1State();
			static_cast<ReadActor1*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& __pagedData,int loopDepth) 
	{
															#line 1252 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		pagedData = __pagedData;
															#line 8736 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && __pagedData,int loopDepth) 
	{
		pagedData = std::move(__pagedData);
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadActor1*>(this)->actor_wait_state > 0) static_cast<ReadActor1*>(this)->actor_wait_state = 0;
		static_cast<ReadActor1*>(this)->ActorCallback< ReadActor1, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadActor1, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadActor1, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadActor1, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	DiskQueue* self;
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	location start;
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	location end;
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	CheckHashes ch;
															#line 1252 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Standalone<StringRef> pagedData;
															#line 8821 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via read()
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReadActor1 final : public Actor<Standalone<StringRef>>, public ActorCallback< ReadActor1, 0, Standalone<StringRef> >, public FastAllocated<ReadActor1>, public ReadActor1State<ReadActor1> {
															#line 8826 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<ReadActor1>::operator new;
	using FastAllocated<ReadActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1039949855147058176UL, 5269655990752170240UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadActor1, 0, Standalone<StringRef> >;
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReadActor1(DiskQueue* const& self,location const& start,location const& end,CheckHashes const& ch) 
															#line 8843 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   ReadActor1State<ReadActor1>(self, start, end, ch),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("read", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(13045688915661361920UL, 7552795543224692992UL);
		ActorExecutionContextHelper __helper(static_cast<ReadActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("read");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("read", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadActor1, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
[[nodiscard]] static Future<Standalone<StringRef>> read( DiskQueue* const& self, location const& start, location const& end, CheckHashes const& ch ) {
															#line 1249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Standalone<StringRef>>(new ReadActor1(self, start, end, ch));
															#line 8875 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 1320 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

	void readFromBuffer(StringBuffer* result, int* bytes) {
		// extract up to bytes from readBufPage into result
		int len = std::min(readBufPage->payloadSize - readBufPos, *bytes);
		if (len <= 0)
			return;

		result->append(StringRef(readBufPage->payload + readBufPos, len));

		readBufPos += len;
		*bytes -= len;
		nextReadLocation += len;
	}

																#line 8893 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via readNext()
															#line 1334 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class ReadNextActor>
															#line 1334 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReadNextActorState {
															#line 8899 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 1334 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReadNextActorState(DiskQueue* const& self,int const& bytes) 
															#line 1334 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 1334 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 1334 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   bytes(bytes),
															#line 1335 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   result(self->dbgid)
															#line 8910 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("readNext", reinterpret_cast<unsigned long>(this));

	}
	~ReadNextActorState() 
	{
		fdb_probe_actor_destroy("readNext", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1336 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(bytes >= 0);
															#line 1337 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			result.clearReserve(bytes);
															#line 1339 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(!self->recovered);
															#line 1341 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!self->initialized)
															#line 8931 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1342 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				StrictFuture<bool> __when_expr_0 = initializeRecovery(self, 0);
															#line 1342 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (static_cast<ReadNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 8937 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
				static_cast<ReadNextActor*>(this)->actor_wait_state = 1;
															#line 1342 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadNextActor, 0, bool >*>(static_cast<ReadNextActor*>(this)));
															#line 8942 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont1(loopDepth);
			}
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadNextActorState();
		static_cast<ReadNextActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(int loopDepth) 
	{
															#line 1351 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		;
															#line 8970 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont1loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(bool const& recoveryComplete,int loopDepth) 
	{
															#line 1344 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (recoveryComplete)
															#line 8979 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1345 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(self->poppedSeq <= self->endLocation());
															#line 1347 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!static_cast<ReadNextActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(Standalone<StringRef>()); this->~ReadNextActorState(); static_cast<ReadNextActor*>(this)->destroy(); return 0; }
															#line 8985 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			new (&static_cast<ReadNextActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(Standalone<StringRef>());
			this->~ReadNextActorState();
			static_cast<ReadNextActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2(bool && recoveryComplete,int loopDepth) 
	{
															#line 1344 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (recoveryComplete)
															#line 8999 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1345 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(self->poppedSeq <= self->endLocation());
															#line 1347 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!static_cast<ReadNextActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(Standalone<StringRef>()); this->~ReadNextActorState(); static_cast<ReadNextActor*>(this)->destroy(); return 0; }
															#line 9005 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			new (&static_cast<ReadNextActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(Standalone<StringRef>());
			this->~ReadNextActorState();
			static_cast<ReadNextActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
		loopDepth = a_body1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool const& recoveryComplete,int loopDepth) 
	{
		loopDepth = a_body1cont2(recoveryComplete, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && recoveryComplete,int loopDepth) 
	{
		loopDepth = a_body1cont2(std::move(recoveryComplete), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadNextActor*>(this)->actor_wait_state > 0) static_cast<ReadNextActor*>(this)->actor_wait_state = 0;
		static_cast<ReadNextActor*>(this)->ActorCallback< ReadNextActor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadNextActor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont5(int loopDepth) 
	{
															#line 1391 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		int f;
															#line 1392 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		int64_t p;
															#line 1393 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		bool poppedNotDurable = self->lastPoppedSeq / sizeof(Page) != self->poppedSeq / sizeof(Page);
															#line 1394 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		CODE_PROBE(poppedNotDurable, "DiskQueue: Recovery popped position not fully durable");
															#line 1395 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->findPhysicalLocation(self->lastPoppedSeq, &f, &p, "lastPoppedSeq");
															#line 1396 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_3 = self->rawQueue->setPoppedPage(f, p, pageFloor(self->lastPoppedSeq));
															#line 1396 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (static_cast<ReadNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9106 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), loopDepth); else return a_body1cont5when1(__when_expr_3.get(), loopDepth); };
		static_cast<ReadNextActor*>(this)->actor_wait_state = 4;
															#line 1396 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< ReadNextActor, 3, Void >*>(static_cast<ReadNextActor*>(this)));
															#line 9111 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1352 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (self->readBufPage)
															#line 9127 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1353 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->readFromBuffer(&result, &bytes);
															#line 1355 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!bytes)
															#line 9133 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1356 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (!static_cast<ReadNextActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(result.str); this->~ReadNextActorState(); static_cast<ReadNextActor*>(this)->destroy(); return 0; }
															#line 9137 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				new (&static_cast<ReadNextActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(result.str);
				this->~ReadNextActorState();
				static_cast<ReadNextActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1357 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			ASSERT(self->readBufPos == self->readBufPage->payloadSize);
															#line 1358 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->readBufPage = 0;
															#line 1359 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->nextReadLocation += sizeof(Page) - self->readBufPos;
															#line 1360 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->readBufPos = 0;
															#line 9151 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1363 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = self->rawQueue->readNextPage();
															#line 1363 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (static_cast<ReadNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9157 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<ReadNextActor*>(this)->actor_wait_state = 2;
															#line 1363 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< ReadNextActor, 1, Standalone<StringRef> >*>(static_cast<ReadNextActor*>(this)));
															#line 9162 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont5(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Standalone<StringRef> const& page,int loopDepth) 
	{
															#line 1364 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!page.size())
															#line 9184 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1365 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			TraceEvent("DQRecEOF", self->dbgid) .detail("NextReadLocation", self->nextReadLocation) .detail("File0Name", self->rawQueue->files[0].dbgFilename);
															#line 9188 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1370 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(page.size() == sizeof(Page));
															#line 1372 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->readBufArena = page.arena();
															#line 1373 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->readBufPage = (Page*)page.begin();
															#line 1374 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!self->readBufPage->checkHash() || self->readBufPage->seq < pageFloor(self->nextReadLocation))
															#line 9199 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1375 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			TraceEvent("DQRecInvalidPage", self->dbgid) .detail("NextReadLocation", self->nextReadLocation) .detail("HashCheck", self->readBufPage->checkHash()) .detail("Seq", self->readBufPage->seq) .detail("Expect", pageFloor(self->nextReadLocation)) .detail("File0Name", self->rawQueue->files[0].dbgFilename);
															#line 1381 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->rawQueue->truncateBeforeLastReadPage();
															#line 1381 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (static_cast<ReadNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9207 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ReadNextActor*>(this)->actor_wait_state = 3;
															#line 1381 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadNextActor, 2, Void >*>(static_cast<ReadNextActor*>(this)));
															#line 9212 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Standalone<StringRef> && page,int loopDepth) 
	{
															#line 1364 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!page.size())
															#line 9226 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1365 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			TraceEvent("DQRecEOF", self->dbgid) .detail("NextReadLocation", self->nextReadLocation) .detail("File0Name", self->rawQueue->files[0].dbgFilename);
															#line 9230 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1370 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(page.size() == sizeof(Page));
															#line 1372 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->readBufArena = page.arena();
															#line 1373 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->readBufPage = (Page*)page.begin();
															#line 1374 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!self->readBufPage->checkHash() || self->readBufPage->seq < pageFloor(self->nextReadLocation))
															#line 9241 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1375 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			TraceEvent("DQRecInvalidPage", self->dbgid) .detail("NextReadLocation", self->nextReadLocation) .detail("HashCheck", self->readBufPage->checkHash()) .detail("Seq", self->readBufPage->seq) .detail("Expect", pageFloor(self->nextReadLocation)) .detail("File0Name", self->rawQueue->files[0].dbgFilename);
															#line 1381 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Void> __when_expr_2 = self->rawQueue->truncateBeforeLastReadPage();
															#line 1381 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (static_cast<ReadNextActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 9249 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1cont1when1(__when_expr_2.get(), loopDepth); };
			static_cast<ReadNextActor*>(this)->actor_wait_state = 3;
															#line 1381 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< ReadNextActor, 2, Void >*>(static_cast<ReadNextActor*>(this)));
															#line 9254 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		else
		{
			loopDepth = a_body1cont1loopBody1cont4(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Standalone<StringRef> const& page,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(page, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Standalone<StringRef> && page,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(page), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<ReadNextActor*>(this)->actor_wait_state > 0) static_cast<ReadNextActor*>(this)->actor_wait_state = 0;
		static_cast<ReadNextActor*>(this)->ActorCallback< ReadNextActor, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< ReadNextActor, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont1loopBody1cont4(int loopDepth) 
	{
															#line 1385 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(self->readBufPage->seq == pageFloor(self->nextReadLocation));
															#line 1386 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->lastPoppedSeq = self->readBufPage->popped;
															#line 9345 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void const& _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont6(Void && _,int loopDepth) 
	{
		return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<ReadNextActor*>(this)->actor_wait_state > 0) static_cast<ReadNextActor*>(this)->actor_wait_state = 0;
		static_cast<ReadNextActor*>(this)->ActorCallback< ReadNextActor, 2, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 2, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 2, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont1loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< ReadNextActor, 2, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont6(Void const& _,int loopDepth) 
	{
															#line 1399 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->nextPageSeq = pageFloor(self->nextReadLocation);
															#line 1400 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (self->nextReadLocation % sizeof(Page) > sizeof(PageHeader))
															#line 9443 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1401 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->nextPageSeq += sizeof(Page);
															#line 9447 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1403 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		TraceEvent("DQRecovered", self->dbgid) .detail("LastPoppedSeq", self->lastPoppedSeq) .detail("PoppedSeq", self->poppedSeq) .detail("NextPageSeq", self->nextPageSeq) .detail("File0Name", self->rawQueue->files[0].dbgFilename);
															#line 1408 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->recovered = true;
															#line 1409 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(self->poppedSeq <= self->endLocation());
															#line 1411 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		CODE_PROBE(result.size() == 0, "End of queue at border between reads");
															#line 1412 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		CODE_PROBE(result.size() != 0, "Partial read at end of queue");
															#line 1416 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->lastCommittedSeq = self->nextReadLocation;
															#line 1418 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadNextActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(result.str); this->~ReadNextActorState(); static_cast<ReadNextActor*>(this)->destroy(); return 0; }
															#line 9463 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadNextActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(result.str);
		this->~ReadNextActorState();
		static_cast<ReadNextActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont6(Void && _,int loopDepth) 
	{
															#line 1399 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->nextPageSeq = pageFloor(self->nextReadLocation);
															#line 1400 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (self->nextReadLocation % sizeof(Page) > sizeof(PageHeader))
															#line 9477 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1401 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->nextPageSeq += sizeof(Page);
															#line 9481 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1403 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		TraceEvent("DQRecovered", self->dbgid) .detail("LastPoppedSeq", self->lastPoppedSeq) .detail("PoppedSeq", self->poppedSeq) .detail("NextPageSeq", self->nextPageSeq) .detail("File0Name", self->rawQueue->files[0].dbgFilename);
															#line 1408 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->recovered = true;
															#line 1409 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		ASSERT(self->poppedSeq <= self->endLocation());
															#line 1411 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		CODE_PROBE(result.size() == 0, "End of queue at border between reads");
															#line 1412 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		CODE_PROBE(result.size() != 0, "Partial read at end of queue");
															#line 1416 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->lastCommittedSeq = self->nextReadLocation;
															#line 1418 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadNextActor*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(result.str); this->~ReadNextActorState(); static_cast<ReadNextActor*>(this)->destroy(); return 0; }
															#line 9497 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadNextActor*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(result.str);
		this->~ReadNextActorState();
		static_cast<ReadNextActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont6(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont5when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont6(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<ReadNextActor*>(this)->actor_wait_state > 0) static_cast<ReadNextActor*>(this)->actor_wait_state = 0;
		static_cast<ReadNextActor*>(this)->ActorCallback< ReadNextActor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< ReadNextActor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont5when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< ReadNextActor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 3);

	}
															#line 1334 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	DiskQueue* self;
															#line 1334 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int bytes;
															#line 1335 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	StringBuffer result;
															#line 9586 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via readNext()
															#line 1334 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReadNextActor final : public Actor<Standalone<StringRef>>, public ActorCallback< ReadNextActor, 0, bool >, public ActorCallback< ReadNextActor, 1, Standalone<StringRef> >, public ActorCallback< ReadNextActor, 2, Void >, public ActorCallback< ReadNextActor, 3, Void >, public FastAllocated<ReadNextActor>, public ReadNextActorState<ReadNextActor> {
															#line 9591 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<ReadNextActor>::operator new;
	using FastAllocated<ReadNextActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1242609304041452544UL, 4486717928770103296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadNextActor, 0, bool >;
friend struct ActorCallback< ReadNextActor, 1, Standalone<StringRef> >;
friend struct ActorCallback< ReadNextActor, 2, Void >;
friend struct ActorCallback< ReadNextActor, 3, Void >;
															#line 1334 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReadNextActor(DiskQueue* const& self,int const& bytes) 
															#line 9611 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   ReadNextActorState<ReadNextActor>(self, bytes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(8157539301062630144UL, 4791951039325370368UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readNext");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadNextActor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< ReadNextActor, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< ReadNextActor, 2, Void >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< ReadNextActor, 3, Void >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1334 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
[[nodiscard]] static Future<Standalone<StringRef>> readNext( DiskQueue* const& self, int const& bytes ) {
															#line 1334 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Standalone<StringRef>>(new ReadNextActor(self, bytes));
															#line 9646 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 1420 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

	// recoverAt is the minimum position in the disk queue file that needs to be read to restore log's states.
	// This allows log to read only a small portion of the most recent data from a large (e.g., 10GB) disk file.
	// This is particularly useful for logSpilling feature.
																#line 9654 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via initializeRecovery()
															#line 1424 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class InitializeRecoveryActor>
															#line 1424 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class InitializeRecoveryActorState {
															#line 9660 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 1424 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	InitializeRecoveryActorState(DiskQueue* const& self,location const& recoverAt) 
															#line 1424 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 1424 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 1424 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   recoverAt(recoverAt)
															#line 9669 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("initializeRecovery", reinterpret_cast<unsigned long>(this));

	}
	~InitializeRecoveryActorState() 
	{
		fdb_probe_actor_destroy("initializeRecovery", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1425 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (self->initialized)
															#line 9684 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1426 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (!static_cast<InitializeRecoveryActor*>(this)->SAV<bool>::futures) { (void)(self->recovered); this->~InitializeRecoveryActorState(); static_cast<InitializeRecoveryActor*>(this)->destroy(); return 0; }
															#line 9688 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				new (&static_cast<InitializeRecoveryActor*>(this)->SAV< bool >::value()) bool(self->recovered);
				this->~InitializeRecoveryActorState();
				static_cast<InitializeRecoveryActor*>(this)->finishSendAndDelPromiseRef();
				return 0;
			}
															#line 1428 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = self->rawQueue->readFirstAndLastPages(&comparePages);
															#line 1428 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (static_cast<InitializeRecoveryActor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 9698 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<InitializeRecoveryActor*>(this)->actor_wait_state = 1;
															#line 1428 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< InitializeRecoveryActor, 0, Standalone<StringRef> >*>(static_cast<InitializeRecoveryActor*>(this)));
															#line 9703 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~InitializeRecoveryActorState();
		static_cast<InitializeRecoveryActor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& lastPageData,int loopDepth) 
	{
															#line 1429 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->initialized = true;
															#line 1431 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!lastPageData.size())
															#line 9728 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1433 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->nextReadLocation = 0;
															#line 1434 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->lastCommittedSeq = 0;
															#line 1435 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->recovered = true;
															#line 1436 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!static_cast<InitializeRecoveryActor*>(this)->SAV<bool>::futures) { (void)(true); this->~InitializeRecoveryActorState(); static_cast<InitializeRecoveryActor*>(this)->destroy(); return 0; }
															#line 9738 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			new (&static_cast<InitializeRecoveryActor*>(this)->SAV< bool >::value()) bool(true);
			this->~InitializeRecoveryActorState();
			static_cast<InitializeRecoveryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1439 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		Page* lastPage = (Page*)lastPageData.begin();
															#line 1440 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->poppedSeq = lastPage->popped;
															#line 1441 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->nextReadLocation = std::max(recoverAt.lo, self->poppedSeq);
															#line 1455 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		int file;
															#line 1456 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		int64_t page;
															#line 1457 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->findPhysicalLocation(self->nextReadLocation, &file, &page, "FirstReadLocation");
															#line 1458 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->rawQueue->setStartPage(file, page);
															#line 1460 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->readBufPos = self->nextReadLocation % sizeof(Page) - sizeof(PageHeader);
															#line 1461 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (self->readBufPos < 0)
															#line 9762 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1462 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->nextReadLocation -= self->readBufPos;
															#line 1463 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->readBufPos = 0;
															#line 9768 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1465 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		TraceEvent("DQRecStart", self->dbgid) .detail("ReadBufPos", self->readBufPos) .detail("NextReadLoc", self->nextReadLocation) .detail("Popped", self->poppedSeq) .detail("MinRecoverAt", recoverAt) .detail("File0Name", self->rawQueue->files[0].dbgFilename);
															#line 1472 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<InitializeRecoveryActor*>(this)->SAV<bool>::futures) { (void)(false); this->~InitializeRecoveryActorState(); static_cast<InitializeRecoveryActor*>(this)->destroy(); return 0; }
															#line 9774 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<InitializeRecoveryActor*>(this)->SAV< bool >::value()) bool(false);
		this->~InitializeRecoveryActorState();
		static_cast<InitializeRecoveryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && lastPageData,int loopDepth) 
	{
															#line 1429 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->initialized = true;
															#line 1431 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!lastPageData.size())
															#line 9788 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1433 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->nextReadLocation = 0;
															#line 1434 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->lastCommittedSeq = 0;
															#line 1435 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->recovered = true;
															#line 1436 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (!static_cast<InitializeRecoveryActor*>(this)->SAV<bool>::futures) { (void)(true); this->~InitializeRecoveryActorState(); static_cast<InitializeRecoveryActor*>(this)->destroy(); return 0; }
															#line 9798 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			new (&static_cast<InitializeRecoveryActor*>(this)->SAV< bool >::value()) bool(true);
			this->~InitializeRecoveryActorState();
			static_cast<InitializeRecoveryActor*>(this)->finishSendAndDelPromiseRef();
			return 0;
		}
															#line 1439 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		Page* lastPage = (Page*)lastPageData.begin();
															#line 1440 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->poppedSeq = lastPage->popped;
															#line 1441 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->nextReadLocation = std::max(recoverAt.lo, self->poppedSeq);
															#line 1455 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		int file;
															#line 1456 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		int64_t page;
															#line 1457 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->findPhysicalLocation(self->nextReadLocation, &file, &page, "FirstReadLocation");
															#line 1458 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->rawQueue->setStartPage(file, page);
															#line 1460 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		self->readBufPos = self->nextReadLocation % sizeof(Page) - sizeof(PageHeader);
															#line 1461 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (self->readBufPos < 0)
															#line 9822 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1462 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->nextReadLocation -= self->readBufPos;
															#line 1463 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->readBufPos = 0;
															#line 9828 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1465 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		TraceEvent("DQRecStart", self->dbgid) .detail("ReadBufPos", self->readBufPos) .detail("NextReadLoc", self->nextReadLocation) .detail("Popped", self->poppedSeq) .detail("MinRecoverAt", recoverAt) .detail("File0Name", self->rawQueue->files[0].dbgFilename);
															#line 1472 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<InitializeRecoveryActor*>(this)->SAV<bool>::futures) { (void)(false); this->~InitializeRecoveryActorState(); static_cast<InitializeRecoveryActor*>(this)->destroy(); return 0; }
															#line 9834 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<InitializeRecoveryActor*>(this)->SAV< bool >::value()) bool(false);
		this->~InitializeRecoveryActorState();
		static_cast<InitializeRecoveryActor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& lastPageData,int loopDepth) 
	{
		loopDepth = a_body1cont1(lastPageData, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && lastPageData,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(lastPageData), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<InitializeRecoveryActor*>(this)->actor_wait_state > 0) static_cast<InitializeRecoveryActor*>(this)->actor_wait_state = 0;
		static_cast<InitializeRecoveryActor*>(this)->ActorCallback< InitializeRecoveryActor, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< InitializeRecoveryActor, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("initializeRecovery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeRecovery", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< InitializeRecoveryActor, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("initializeRecovery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeRecovery", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< InitializeRecoveryActor, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("initializeRecovery", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("initializeRecovery", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1424 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	DiskQueue* self;
															#line 1424 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	location recoverAt;
															#line 9921 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via initializeRecovery()
															#line 1424 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class InitializeRecoveryActor final : public Actor<bool>, public ActorCallback< InitializeRecoveryActor, 0, Standalone<StringRef> >, public FastAllocated<InitializeRecoveryActor>, public InitializeRecoveryActorState<InitializeRecoveryActor> {
															#line 9926 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<InitializeRecoveryActor>::operator new;
	using FastAllocated<InitializeRecoveryActor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(11270919693922618624UL, 18310489325565749760UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<bool>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< InitializeRecoveryActor, 0, Standalone<StringRef> >;
															#line 1424 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	InitializeRecoveryActor(DiskQueue* const& self,location const& recoverAt) 
															#line 9943 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<bool>(),
		   InitializeRecoveryActorState<InitializeRecoveryActor>(self, recoverAt),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("initializeRecovery", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(7891479301351043072UL, 5889597138482105088UL);
		ActorExecutionContextHelper __helper(static_cast<InitializeRecoveryActor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("initializeRecovery");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("initializeRecovery", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< InitializeRecoveryActor, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1424 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
[[nodiscard]] static Future<bool> initializeRecovery( DiskQueue* const& self, location const& recoverAt ) {
															#line 1424 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<bool>(new InitializeRecoveryActor(self, recoverAt));
															#line 9975 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 1474 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"

	Page& firstPages(int i) {
		ASSERT(initialized);
		return *(Page*)rawQueue->firstPages[i];
	}

	void findPhysicalLocation(loc_t loc, int* file, int64_t* page, const char* context) {
		bool ok = false;

		if (context)
			TraceEvent(SevInfo, "FindPhysicalLocation", dbgid)
			    .detail("Page0Valid", firstPages(0).checkHash())
			    .detail("Page0Seq", firstPages(0).seq)
			    .detail("Page1Valid", firstPages(1).checkHash())
			    .detail("Page1Seq", firstPages(1).seq)
			    .detail("Location", loc)
			    .detail("Context", context)
			    .detail("File0Name", rawQueue->files[0].dbgFilename);

		for (int i = 1; i >= 0; i--) {
			ASSERT_WE_THINK(firstPages(i).checkHash());
			if (firstPages(i).seq <= (size_t)loc) {
				*file = i;
				*page = (loc - firstPages(i).seq) / sizeof(Page);
				if (context)
					TraceEvent("FoundPhysicalLocation", dbgid)
					    .detail("PageIndex", i)
					    .detail("PageLocation", *page)
					    .detail("SizeofPage", sizeof(Page))
					    .detail("PageSequence", firstPages(i).seq)
					    .detail("Location", loc)
					    .detail("Context", context)
					    .detail("File0Name", rawQueue->files[0].dbgFilename);
				ok = true;
				break;
			}
		}
		if (!ok)
			TraceEvent(SevError, "DiskQueueLocationError", dbgid)
			    .detail("Page0Valid", firstPages(0).checkHash())
			    .detail("Page0Seq", firstPages(0).seq)
			    .detail("Page1Valid", firstPages(1).checkHash())
			    .detail("Page1Seq", firstPages(1).seq)
			    .detail("Location", loc)
			    .detail("Context", context ? context : "")
			    .detail("File0Name", rawQueue->files[0].dbgFilename);
		ASSERT(ok);
	}

	// isValid(firstPage) == compare(firstPage, firstPage)
	// isValid(otherPage) == compare(firstPage, otherPage)
	// Swap file1, file2 if comparePages( file2.firstPage, file1.firstPage )
	static bool comparePages(void* v1, void* v2) {
		Page* p1 = (Page*)v1;
		Page* p2 = (Page*)v2;
		return p2->checkHash() && (p2->seq >= p1->seq || !p1->checkHash());
	}

	RawDiskQueue_TwoFiles* rawQueue;
	UID dbgid;
	DiskQueueVersion diskQueueVersion;

	bool anyPopped; // pop() has been called since the most recent call to commit()
	bool warnAlwaysForMemory;
	loc_t nextPageSeq, poppedSeq;
	loc_t lastPoppedSeq; // poppedSeq the last time commit was called.
	loc_t lastCommittedSeq; // The seq location where the last commit finishes at.

	// Buffer of pushed pages that haven't been committed.  The last one (backPage()) is still mutable.
	StringBuffer* pushed_page_buffer;
	Page& backPage() {
		ASSERT(pushedPageCount());
		return ((Page*)pushed_page_buffer->get().end())[-1];
	}
	Page const& backPage() const { return ((Page*)pushed_page_buffer->get().end())[-1]; }
	int pushedPageCount() const { return pushed_page_buffer ? pushed_page_buffer->size() / sizeof(Page) : 0; }

	// Recovery state
	bool recovered;
	bool initialized;
	loc_t nextReadLocation;
	Arena readBufArena;
	Page* readBufPage;
	int readBufPos;
};

// A class wrapping DiskQueue which prevents uncommitted data from being popped.
//
// Once upon a time, it was intended to allow popping uncommitted data
// by performing two commits when uncommitted data is popped:
//	Commit 1 - pop only previously committed data and push new data (i.e., commit uncommitted data)
//      Commit 2 - finish pop into uncommitted data
//
// Now, instead, we only use this to catch errors in tlog logic where
// we attempt to pop too much.
class DiskQueue_PopUncommitted final : public IDiskQueue {

public:
	DiskQueue_PopUncommitted(std::string basename,
	                         std::string fileExtension,
	                         UID dbgid,
	                         DiskQueueVersion diskQueueVersion,
	                         int64_t fileSizeWarningLimit)
	  : queue(new DiskQueue(basename, fileExtension, dbgid, diskQueueVersion, fileSizeWarningLimit)), pushed(0),
	    popped(0), committed(0) {};

	// IClosable
	Future<Void> getError() const override { return queue->getError(); }
	Future<Void> onClosed() const override { return queue->onClosed(); }
	void dispose() override {
		queue->dispose();
		delete this;
	}
	void close() override {
		queue->close();
		delete this;
	}

	// IDiskQueue
	Future<bool> initializeRecovery(location recoverAt) override { return queue->initializeRecovery(recoverAt); }
	Future<Standalone<StringRef>> readNext(int bytes) override { return readNext(this, bytes); }

	location getNextReadLocation() const override { return queue->getNextReadLocation(); }

	Future<Standalone<StringRef>> read(location start, location end, CheckHashes ch) override {
		return queue->read(start, end, ch);
	}
	location getNextPushLocation() const override { return queue->getNextPushLocation(); }

	location push(StringRef contents) override {
		pushed = queue->push(contents);
		return pushed;
	}

	void pop(location upTo) override {
		popped = std::max(popped, upTo);
		ASSERT_WE_THINK(committed >= popped);
		queue->pop(std::min(committed, popped));
	}

	int getCommitOverhead() const override {
		return queue->getCommitOverhead() + (popped > committed ? queue->getMaxPayload() : 0);
	}

	Future<Void> commit() override {
		location pushLocation = pushed;
		location popLocation = popped;

		Future<Void> commitFuture = queue->commit();

		bool updatePop = popLocation > committed;

		// Since we only commit entire pages, round the last
		// committed location up to the next page.
		committed = location(pushLocation.hi, pageCeiling(pushLocation.lo));

		if (updatePop) {
			ASSERT_WE_THINK(false);
			ASSERT(popLocation <= committed);

			queue->stall(); // Don't permit this pipelined commit to write anything to disk until the previous commit is
			                // totally finished
			pop(popLocation);
			commitFuture = commitFuture && queue->commit();
		} else {
			CODE_PROBE(true, "No uncommitted data was popped");
		}

		return commitFuture;
	}

	StorageBytes getStorageBytes() const override { return queue->getStorageBytes(); }

private:
	DiskQueue* queue;
	location pushed;
	location popped;
	location committed;

																#line 10158 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
// This generated class is to be used only via readNext()
															#line 1653 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class ReadNextActor1>
															#line 1653 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReadNextActor1State {
															#line 10164 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 1653 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReadNextActor1State(DiskQueue_PopUncommitted* const& self,int const& bytes) 
															#line 1653 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 1653 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : self(self),
															#line 1653 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   bytes(bytes)
															#line 10173 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("readNext", reinterpret_cast<unsigned long>(this));

	}
	~ReadNextActor1State() 
	{
		fdb_probe_actor_destroy("readNext", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1654 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<Standalone<StringRef>> __when_expr_0 = self->queue->readNext(bytes);
															#line 1654 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (static_cast<ReadNextActor1*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10190 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<ReadNextActor1*>(this)->actor_wait_state = 1;
															#line 1654 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< ReadNextActor1, 0, Standalone<StringRef> >*>(static_cast<ReadNextActor1*>(this)));
															#line 10195 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~ReadNextActor1State();
		static_cast<ReadNextActor1*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> const& str,int loopDepth) 
	{
															#line 1655 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (str.size() < bytes)
															#line 10218 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1656 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->pushed = self->getNextReadLocation();
															#line 10222 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1658 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadNextActor1*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(str); this->~ReadNextActor1State(); static_cast<ReadNextActor1*>(this)->destroy(); return 0; }
															#line 10226 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadNextActor1*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(str);
		this->~ReadNextActor1State();
		static_cast<ReadNextActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont1(Standalone<StringRef> && str,int loopDepth) 
	{
															#line 1655 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (str.size() < bytes)
															#line 10238 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1656 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			self->pushed = self->getNextReadLocation();
															#line 10242 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1658 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<ReadNextActor1*>(this)->SAV<Standalone<StringRef>>::futures) { (void)(str); this->~ReadNextActor1State(); static_cast<ReadNextActor1*>(this)->destroy(); return 0; }
															#line 10246 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<ReadNextActor1*>(this)->SAV< Standalone<StringRef> >::value()) Standalone<StringRef>(str);
		this->~ReadNextActor1State();
		static_cast<ReadNextActor1*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> const& str,int loopDepth) 
	{
		loopDepth = a_body1cont1(str, loopDepth);

		return loopDepth;
	}
	int a_body1when1(Standalone<StringRef> && str,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(str), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<ReadNextActor1*>(this)->actor_wait_state > 0) static_cast<ReadNextActor1*>(this)->actor_wait_state = 0;
		static_cast<ReadNextActor1*>(this)->ActorCallback< ReadNextActor1, 0, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< ReadNextActor1, 0, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< ReadNextActor1, 0, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< ReadNextActor1, 0, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), 0);

	}
															#line 1653 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	DiskQueue_PopUncommitted* self;
															#line 1653 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int bytes;
															#line 10333 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via readNext()
															#line 1653 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class ReadNextActor1 final : public Actor<Standalone<StringRef>>, public ActorCallback< ReadNextActor1, 0, Standalone<StringRef> >, public FastAllocated<ReadNextActor1>, public ReadNextActor1State<ReadNextActor1> {
															#line 10338 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<ReadNextActor1>::operator new;
	using FastAllocated<ReadNextActor1>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(1242609304041452544UL, 4486717928770103296UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Standalone<StringRef>>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< ReadNextActor1, 0, Standalone<StringRef> >;
															#line 1653 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	ReadNextActor1(DiskQueue_PopUncommitted* const& self,int const& bytes) 
															#line 10355 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Standalone<StringRef>>(),
		   ReadNextActor1State<ReadNextActor1>(self, bytes),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("readNext", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(4875483019034025472UL, 9459347930214458624UL);
		ActorExecutionContextHelper __helper(static_cast<ReadNextActor1*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("readNext");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("readNext", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< ReadNextActor1, 0, Standalone<StringRef> >*)0, actor_cancelled()); break;
		}

	}
};
															#line 1653 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
[[nodiscard]] static Future<Standalone<StringRef>> readNext( DiskQueue_PopUncommitted* const& self, int const& bytes ) {
															#line 1653 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Standalone<StringRef>>(new ReadNextActor1(self, bytes));
															#line 10387 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}

#line 1660 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
};

IDiskQueue* openDiskQueue(std::string basename,
                          std::string ext,
                          UID dbgid,
                          DiskQueueVersion dqv,
                          int64_t fileSizeWarningLimit) {
	return new DiskQueue_PopUncommitted(basename, ext, dbgid, dqv, fileSizeWarningLimit);
}

															#line 10401 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
namespace {
// This generated class is to be used only via flowTestCase1670()
															#line 1670 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
template <class FlowTestCase1670Actor>
															#line 1670 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class FlowTestCase1670ActorState {
															#line 10408 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
															#line 1670 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	FlowTestCase1670ActorState(UnitTestParameters const& params) 
															#line 1670 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
															#line 1670 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		 : params(params),
															#line 1671 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   queue(openDiskQueue("test-", "fdq", deterministicRandom()->randomUniqueID(), DiskQueueVersion::V2)),
															#line 1673 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   valueString(std::string(10e6, '.')),
															#line 1674 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   valueStr((uint8_t*)valueString.c_str(), 10e6),
															#line 1675 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   locations(),
															#line 1676 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   loopCount(0),
															#line 1677 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		   lastCommit(Void())
															#line 10427 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
	{
		fdb_probe_actor_create("flowTestCase1670", reinterpret_cast<unsigned long>(this));

	}
	~FlowTestCase1670ActorState() 
	{
		fdb_probe_actor_destroy("flowTestCase1670", reinterpret_cast<unsigned long>(this));

	}
	int a_body1(int loopDepth=0) 
	{
		try {
															#line 1678 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			StrictFuture<bool> __when_expr_0 = queue->initializeRecovery(0);
															#line 1678 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10444 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			if (__when_expr_0.isReady()) { if (__when_expr_0.isError()) return a_body1Catch1(__when_expr_0.getError(), loopDepth); else return a_body1when1(__when_expr_0.get(), loopDepth); };
			static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state = 1;
															#line 1678 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			__when_expr_0.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1670Actor, 0, bool >*>(static_cast<FlowTestCase1670Actor*>(this)));
															#line 10449 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = 0;
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1Catch1(Error error,int loopDepth=0) 
	{
		this->~FlowTestCase1670ActorState();
		static_cast<FlowTestCase1670Actor*>(this)->sendErrorAndDelPromiseRef(error);
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1(bool const& fullyRecovered,int loopDepth) 
	{
															#line 1679 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!fullyRecovered)
															#line 10472 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1680 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			;
															#line 10476 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1(bool && fullyRecovered,int loopDepth) 
	{
															#line 1679 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!fullyRecovered)
															#line 10490 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1680 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			;
															#line 10494 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			loopDepth = a_body1cont1loopHead1(loopDepth);
		}
		else
		{
			loopDepth = a_body1cont2(loopDepth);
		}

		return loopDepth;
	}
	int a_body1when1(bool const& fullyRecovered,int loopDepth) 
	{
		loopDepth = a_body1cont1(fullyRecovered, loopDepth);

		return loopDepth;
	}
	int a_body1when1(bool && fullyRecovered,int loopDepth) 
	{
		loopDepth = a_body1cont1(std::move(fullyRecovered), loopDepth);

		return loopDepth;
	}
	void a_exitChoose1() 
	{
		if (static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1670Actor*>(this)->ActorCallback< FlowTestCase1670Actor, 0, bool >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1670Actor, 0, bool >*,bool const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1670Actor, 0, bool >*,bool && value) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 0);

	}
	void a_callback_error(ActorCallback< FlowTestCase1670Actor, 0, bool >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 0);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose1();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 0);

	}
	int a_body1cont2(int loopDepth) 
	{
															#line 1687 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		;
															#line 10583 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont2loopHead1(loopDepth);

		return loopDepth;
	}
	int a_body1cont3(int loopDepth) 
	{
		loopDepth = a_body1cont2(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont1loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1(int loopDepth) 
	{
															#line 1681 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Standalone<StringRef>> __when_expr_1 = queue->readNext(1e6);
															#line 1681 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10607 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (__when_expr_1.isReady()) { if (__when_expr_1.isError()) return a_body1Catch1(__when_expr_1.getError(), std::max(0, loopDepth - 1)); else return a_body1cont1loopBody1when1(__when_expr_1.get(), loopDepth); };
		static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state = 2;
															#line 1681 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_1.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1670Actor, 1, Standalone<StringRef> >*>(static_cast<FlowTestCase1670Actor*>(this)));
															#line 10612 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont1break1(int loopDepth) 
	{
		try {
			return a_body1cont3(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Standalone<StringRef> const& h,int loopDepth) 
	{
															#line 1682 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (h.size() < 1e6)
															#line 10634 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1cont1(Standalone<StringRef> && h,int loopDepth) 
	{
															#line 1682 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (h.size() < 1e6)
															#line 10646 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
			return a_body1cont1break1(loopDepth==0?0:loopDepth-1); // break
		}
		if (loopDepth == 0) return a_body1cont1loopHead1(0);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Standalone<StringRef> const& h,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(h, loopDepth);

		return loopDepth;
	}
	int a_body1cont1loopBody1when1(Standalone<StringRef> && h,int loopDepth) 
	{
		loopDepth = a_body1cont1loopBody1cont1(std::move(h), loopDepth);

		return loopDepth;
	}
	void a_exitChoose2() 
	{
		if (static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1670Actor*>(this)->ActorCallback< FlowTestCase1670Actor, 1, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1670Actor, 1, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1670Actor, 1, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1cont1loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 1);

	}
	void a_callback_error(ActorCallback< FlowTestCase1670Actor, 1, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose2();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 1);

	}
	int a_body1cont4(int loopDepth) 
	{
															#line 1705 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		queue->dispose();
															#line 1706 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_5 = queue->onClosed();
															#line 1706 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), loopDepth);
															#line 10737 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (__when_expr_5.isReady()) { if (__when_expr_5.isError()) return a_body1Catch1(__when_expr_5.getError(), loopDepth); else return a_body1cont4when1(__when_expr_5.get(), loopDepth); };
		static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state = 6;
															#line 1706 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_5.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1670Actor, 5, Void >*>(static_cast<FlowTestCase1670Actor*>(this)));
															#line 10742 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopHead1(int loopDepth) 
	{
		int oldLoopDepth = ++loopDepth;
		while (loopDepth == oldLoopDepth) loopDepth = a_body1cont2loopBody1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1(int loopDepth) 
	{
															#line 1687 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!(loopCount < 4000))
															#line 10758 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
			return a_body1cont2break1(loopDepth==0?0:loopDepth-1); // break
		}
															#line 1688 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (loopCount % 100 == 0)
															#line 10764 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1689 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			printf("loop count: %d\n", loopCount);
															#line 10768 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		}
															#line 1691 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (++loopCount % 2 == 0)
															#line 10772 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		{
															#line 1692 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			frontLocation = locations.front();
															#line 1693 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			locations.pop_front();
															#line 1694 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
			if (locations.size() > 10)
															#line 10780 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
			{
															#line 1695 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				StrictFuture<Standalone<StringRef>> __when_expr_2 = queue->read(frontLocation, locations.front(), CheckHashes::True);
															#line 1695 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				if (static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10786 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				if (__when_expr_2.isReady()) { if (__when_expr_2.isError()) return a_body1Catch1(__when_expr_2.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1when1(__when_expr_2.get(), loopDepth); };
				static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state = 3;
															#line 1695 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
				__when_expr_2.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1670Actor, 2, Standalone<StringRef> >*>(static_cast<FlowTestCase1670Actor*>(this)));
															#line 10791 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
				loopDepth = 0;
			}
			else
			{
				loopDepth = a_body1cont2loopBody1cont4(loopDepth);
			}
		}
		else
		{
			loopDepth = a_body1cont2loopBody1cont1(loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2break1(int loopDepth) 
	{
		try {
			return a_body1cont4(loopDepth);
		}
		catch (Error& error) {
			loopDepth = a_body1Catch1(error, loopDepth);
		} catch (...) {
			loopDepth = a_body1Catch1(unknown_error(), loopDepth);
		}

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1(int loopDepth) 
	{
															#line 1699 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_3 = delay(0.001);
															#line 1699 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10825 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (__when_expr_3.isReady()) { if (__when_expr_3.isError()) return a_body1Catch1(__when_expr_3.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont1when1(__when_expr_3.get(), loopDepth); };
		static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state = 4;
															#line 1699 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_3.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1670Actor, 3, Void >*>(static_cast<FlowTestCase1670Actor*>(this)));
															#line 10830 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont4(int loopDepth) 
	{
															#line 1697 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		queue->pop(frontLocation);
															#line 10839 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = a_body1cont2loopBody1cont1(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Standalone<StringRef> const& r,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont5(Standalone<StringRef> && r,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont4(loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Standalone<StringRef> const& r,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(r, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1when1(Standalone<StringRef> && r,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont5(std::move(r), loopDepth);

		return loopDepth;
	}
	void a_exitChoose3() 
	{
		if (static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1670Actor*>(this)->ActorCallback< FlowTestCase1670Actor, 2, Standalone<StringRef> >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1670Actor, 2, Standalone<StringRef> >*,Standalone<StringRef> const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1670Actor, 2, Standalone<StringRef> >*,Standalone<StringRef> && value) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1cont2loopBody1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 2);

	}
	void a_callback_error(ActorCallback< FlowTestCase1670Actor, 2, Standalone<StringRef> >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 2);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose3();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 2);

	}
	int a_body1cont2loopBody1cont7(Void const& _,int loopDepth) 
	{
															#line 1700 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		locations.push_back(queue->push(valueStr));
															#line 1701 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		Future<Void> prevCommit = lastCommit;
															#line 1702 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		lastCommit = queue->commit();
															#line 1703 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_4 = prevCommit;
															#line 1703 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10943 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state = 5;
															#line 1703 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1670Actor, 4, Void >*>(static_cast<FlowTestCase1670Actor*>(this)));
															#line 10948 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont7(Void && _,int loopDepth) 
	{
															#line 1700 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		locations.push_back(queue->push(valueStr));
															#line 1701 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		Future<Void> prevCommit = lastCommit;
															#line 1702 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		lastCommit = queue->commit();
															#line 1703 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		StrictFuture<Void> __when_expr_4 = prevCommit;
															#line 1703 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state < 0) return a_body1Catch1(actor_cancelled(), std::max(0, loopDepth - 1));
															#line 10965 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		if (__when_expr_4.isReady()) { if (__when_expr_4.isError()) return a_body1Catch1(__when_expr_4.getError(), std::max(0, loopDepth - 1)); else return a_body1cont2loopBody1cont7when1(__when_expr_4.get(), loopDepth); };
		static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state = 5;
															#line 1703 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		__when_expr_4.addCallbackAndClear(static_cast<ActorCallback< FlowTestCase1670Actor, 4, Void >*>(static_cast<FlowTestCase1670Actor*>(this)));
															#line 10970 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		loopDepth = 0;

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont7(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont1when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont7(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose4() 
	{
		if (static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1670Actor*>(this)->ActorCallback< FlowTestCase1670Actor, 3, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1670Actor, 3, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont1when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1670Actor, 3, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1cont2loopBody1cont1when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 3);

	}
	void a_callback_error(ActorCallback< FlowTestCase1670Actor, 3, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 3);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose4();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 3);

	}
	int a_body1cont2loopBody1cont8(Void const& _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont8(Void && _,int loopDepth) 
	{
		if (loopDepth == 0) return a_body1cont2loopHead1(0);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont7when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont8(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont2loopBody1cont7when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont2loopBody1cont8(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose5() 
	{
		if (static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1670Actor*>(this)->ActorCallback< FlowTestCase1670Actor, 4, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1670Actor, 4, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont7when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1670Actor, 4, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1cont2loopBody1cont7when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 4);

	}
	void a_callback_error(ActorCallback< FlowTestCase1670Actor, 4, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 4);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose5();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 4);

	}
	int a_body1cont5(Void const& _,int loopDepth) 
	{
															#line 1707 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<FlowTestCase1670Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1670ActorState(); static_cast<FlowTestCase1670Actor*>(this)->destroy(); return 0; }
															#line 11141 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<FlowTestCase1670Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1670ActorState();
		static_cast<FlowTestCase1670Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont5(Void && _,int loopDepth) 
	{
															#line 1707 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
		if (!static_cast<FlowTestCase1670Actor*>(this)->SAV<Void>::futures) { (void)(Void()); this->~FlowTestCase1670ActorState(); static_cast<FlowTestCase1670Actor*>(this)->destroy(); return 0; }
															#line 11153 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		new (&static_cast<FlowTestCase1670Actor*>(this)->SAV< Void >::value()) Void(Void());
		this->~FlowTestCase1670ActorState();
		static_cast<FlowTestCase1670Actor*>(this)->finishSendAndDelPromiseRef();
		return 0;

		return loopDepth;
	}
	int a_body1cont4when1(Void const& _,int loopDepth) 
	{
		loopDepth = a_body1cont5(_, loopDepth);

		return loopDepth;
	}
	int a_body1cont4when1(Void && _,int loopDepth) 
	{
		loopDepth = a_body1cont5(std::move(_), loopDepth);

		return loopDepth;
	}
	void a_exitChoose6() 
	{
		if (static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state > 0) static_cast<FlowTestCase1670Actor*>(this)->actor_wait_state = 0;
		static_cast<FlowTestCase1670Actor*>(this)->ActorCallback< FlowTestCase1670Actor, 5, Void >::remove();

	}
	void a_callback_fire(ActorCallback< FlowTestCase1670Actor, 5, Void >*,Void const& value) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4when1(value, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_fire(ActorCallback< FlowTestCase1670Actor, 5, Void >*,Void && value) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(9578512156108914944UL, 107643746863906816UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1cont4when1(std::move(value), 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 5);

	}
	void a_callback_error(ActorCallback< FlowTestCase1670Actor, 5, Void >*,Error err) 
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), 5);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(5187328219730237440UL, 3113259079076601088UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		a_exitChoose6();
		try {
			a_body1Catch1(err, 0);
		}
		catch (Error& error) {
			a_body1Catch1(error, 0);
		} catch (...) {
			a_body1Catch1(unknown_error(), 0);
		}
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), 5);

	}
															#line 1670 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	UnitTestParameters params;
															#line 1671 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	IDiskQueue* queue;
															#line 1673 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	std::string valueString;
															#line 1674 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	StringRef valueStr;
															#line 1675 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	std::deque<IDiskQueue::location> locations;
															#line 1676 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	int loopCount;
															#line 1677 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	Future<Void> lastCommit;
															#line 1692 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	IDiskQueue::location frontLocation;
															#line 11252 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
};
// This generated class is to be used only via flowTestCase1670()
															#line 1670 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
class FlowTestCase1670Actor final : public Actor<Void>, public ActorCallback< FlowTestCase1670Actor, 0, bool >, public ActorCallback< FlowTestCase1670Actor, 1, Standalone<StringRef> >, public ActorCallback< FlowTestCase1670Actor, 2, Standalone<StringRef> >, public ActorCallback< FlowTestCase1670Actor, 3, Void >, public ActorCallback< FlowTestCase1670Actor, 4, Void >, public ActorCallback< FlowTestCase1670Actor, 5, Void >, public FastAllocated<FlowTestCase1670Actor>, public FlowTestCase1670ActorState<FlowTestCase1670Actor> {
															#line 11257 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
public:
	using FastAllocated<FlowTestCase1670Actor>::operator new;
	using FastAllocated<FlowTestCase1670Actor>::operator delete;
	static constexpr ActorIdentifier __actorIdentifier = UID(16152320527575917824UL, 5760504646842715648UL);
	ActiveActorHelper activeActorHelper;
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wdelete-non-virtual-dtor"
    void destroy() override {
        activeActorHelper.~ActiveActorHelper();
        static_cast<Actor<Void>*>(this)->~Actor();
        operator delete(this);
    }
#pragma clang diagnostic pop
friend struct ActorCallback< FlowTestCase1670Actor, 0, bool >;
friend struct ActorCallback< FlowTestCase1670Actor, 1, Standalone<StringRef> >;
friend struct ActorCallback< FlowTestCase1670Actor, 2, Standalone<StringRef> >;
friend struct ActorCallback< FlowTestCase1670Actor, 3, Void >;
friend struct ActorCallback< FlowTestCase1670Actor, 4, Void >;
friend struct ActorCallback< FlowTestCase1670Actor, 5, Void >;
															#line 1670 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	FlowTestCase1670Actor(UnitTestParameters const& params) 
															#line 11279 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
		 : Actor<Void>(),
		   FlowTestCase1670ActorState<FlowTestCase1670Actor>(params),
		   activeActorHelper(__actorIdentifier)
	{
		fdb_probe_actor_enter("flowTestCase1670", reinterpret_cast<unsigned long>(this), -1);
		#ifdef WITH_ACAC
		static constexpr ActorBlockIdentifier __identifier = UID(15162947324972481280UL, 14940753676187731456UL);
		ActorExecutionContextHelper __helper(static_cast<FlowTestCase1670Actor*>(this)->activeActorHelper.actorID, __identifier);
		#endif // WITH_ACAC
		#ifdef ENABLE_SAMPLING
		this->lineage.setActorName("flowTestCase1670");
		LineageScope _(&this->lineage);
		#endif
		this->a_body1();
		fdb_probe_actor_exit("flowTestCase1670", reinterpret_cast<unsigned long>(this), -1);

	}
	void cancel() override
	{
		auto wait_state = this->actor_wait_state;
		this->actor_wait_state = -1;
		switch (wait_state) {
		case 1: this->a_callback_error((ActorCallback< FlowTestCase1670Actor, 0, bool >*)0, actor_cancelled()); break;
		case 2: this->a_callback_error((ActorCallback< FlowTestCase1670Actor, 1, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 3: this->a_callback_error((ActorCallback< FlowTestCase1670Actor, 2, Standalone<StringRef> >*)0, actor_cancelled()); break;
		case 4: this->a_callback_error((ActorCallback< FlowTestCase1670Actor, 3, Void >*)0, actor_cancelled()); break;
		case 5: this->a_callback_error((ActorCallback< FlowTestCase1670Actor, 4, Void >*)0, actor_cancelled()); break;
		case 6: this->a_callback_error((ActorCallback< FlowTestCase1670Actor, 5, Void >*)0, actor_cancelled()); break;
		}

	}
};
} // namespace
															#line 1670 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
static Future<Void> flowTestCase1670( UnitTestParameters const& params ) {
															#line 1670 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
	return Future<Void>(new FlowTestCase1670Actor(params));
															#line 11317 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/build_output/fdbserver/DiskQueue.actor.g.cpp"
}
ACTOR_TEST_CASE(flowTestCase1670, "performance/fdbserver/DiskQueue")

#line 1709 "/codebuild/output/src1143352350/src/github.com/apple/foundationdb/fdbserver/DiskQueue.actor.cpp"
