#
# brokenrole.py
#
# This source file is part of the FoundationDB open source project
#
# Copyright 2013-2024 Apple Inc. and the FoundationDB project authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#


def setup(app):
    app.add_role("broken", broken_role)


def broken_role(name, rawtext, text, lineno, inliner, options=None, content=None):
    options = options or {}
    content = content or []
    msg = inliner.reporter.error("Broken role invoked", line=lineno)
    prb = inliner.problematic(rawtext, rawtext, msg)
    return [prb], [msg]
